/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-01-14 23:04:01 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `z8ei5_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=10249 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4244 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=30754 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_aiowps_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `network_id` bigint(20) NOT NULL DEFAULT '0',
  `site_id` bigint(20) NOT NULL DEFAULT '0',
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `event_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `details` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `stacktrace` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_aiowps_debug_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT '1',
  `backtrace_log` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_aiowps_message_store` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_key` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_dipi_instagram_media` (
  `media_id` bigint(20) NOT NULL,
  `account_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `timestamp` datetime NOT NULL,
  `caption` text COLLATE utf8mb4_unicode_ci,
  `media_type` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `permalink` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `media_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `children_count` int(11) DEFAULT '0',
  PRIMARY KEY (`media_id`,`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `z8ei5_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=27258 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=50242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_wpfm_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_name` text COLLATE utf8mb4_unicode_520_ci,
  `backup_date` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=352 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `css` longtext COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `error_code` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error_message` longtext COLLATE utf8mb4_unicode_ci,
  `unprocessedcss` longtext COLLATE utf8mb4_unicode_ci,
  `retries` tinyint(1) NOT NULL DEFAULT '1',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `job_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `queue_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `hash` (`hash`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_wps_cleaner` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blog_id` bigint(20) NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `media_id` bigint(20) NOT NULL,
  `object_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14692 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_wps_cleaner_queue` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blog_id` bigint(20) DEFAULT NULL,
  `post_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `z8ei5_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `z8ei5_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `z8ei5_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=11639 DEFAULT CHARSET=utf8;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: z8ei5_actionscheduler_actions */
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10212", "rocket_preload_job_preload_url", "complete", "2023-09-06 07:14:47", "2023-09-06 07:14:47", "[\"http:\\/\\/ts-formation.fr\\/project\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:26:39", "2023-09-06 14:26:39", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10213", "rocket_preload_job_preload_url", "complete", "2023-09-06 07:14:47", "2023-09-06 07:14:47", "[\"http:\\/\\/ts-formation.fr\\/category\\/non-classe\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:26:42", "2023-09-06 14:26:42", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10214", "rocket_preload_job_preload_url", "complete", "2023-09-06 07:14:47", "2023-09-06 07:14:47", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/elisabeth-cousin\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:26:45", "2023-09-06 14:26:45", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10215", "rocket_preload_job_preload_url", "complete", "2023-09-06 07:14:47", "2023-09-06 07:14:47", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/mackendy-dossous\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:26:48", "2023-09-06 14:26:48", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10216", "rocket_preload_job_preload_url", "complete", "2023-09-06 07:14:47", "2023-09-06 07:14:47", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/claire-lanoe\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:26:51", "2023-09-06 14:26:51", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10217", "rocket_preload_job_preload_url", "complete", "2023-09-06 07:14:47", "2023-09-06 07:14:47", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/allard-nathalie\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:26:54", "2023-09-06 14:26:54", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10218", "rocket_preload_job_preload_url", "complete", "2023-09-06 07:14:47", "2023-09-06 07:14:47", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/mathieu-basinski\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:26:57", "2023-09-06 14:26:57", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10219", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:27:46", "2023-09-06 12:27:46", "[\"http:\\/\\/ts-formation.fr\\/bonjour-tout-le-monde\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:27:50", "2023-09-06 14:27:50", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10220", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:27:46", "2023-09-06 12:27:46", "[\"http:\\/\\/ts-formation.fr\\/a-propos\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:27:53", "2023-09-06 14:27:53", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10221", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:27:46", "2023-09-06 12:27:46", "[\"http:\\/\\/ts-formation.fr\\/contact\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:27:56", "2023-09-06 14:27:56", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10222", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:27:46", "2023-09-06 12:27:46", "[\"http:\\/\\/ts-formation.fr\\/mentions-legales\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:27:59", "2023-09-06 14:27:59", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10223", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:27:46", "2023-09-06 12:27:46", "[\"http:\\/\\/ts-formation.fr\\/conditions-generales-de-vente\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:28:02", "2023-09-06 14:28:02", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10224", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:27:46", "2023-09-06 12:27:46", "[\"http:\\/\\/ts-formation.fr\\/reglement-interieur\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:28:05", "2023-09-06 14:28:05", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10225", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:27:46", "2023-09-06 12:27:46", "[\"http:\\/\\/ts-formation.fr\\/politique-de-confidentialite\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:28:06", "2023-09-06 14:28:06", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10226", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:27:46", "2023-09-06 12:27:46", "[\"http:\\/\\/ts-formation.fr\\/evenements\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:28:09", "2023-09-06 14:28:09", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10227", "rocket_preload_job_check_finished", "complete", "2023-09-06 12:31:51", "2023-09-06 14:31:51", "[1694003451]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694003511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694003511;}", "2", "1", "2023-09-06 12:32:55", "2023-09-06 14:32:55", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10228", "rocket_preload_job_check_finished", "complete", "2023-09-06 12:33:55", "2023-09-06 14:33:55", "[1694003575]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694003635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694003635;}", "2", "1", "2023-09-06 12:34:07", "2023-09-06 14:34:07", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10229", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/bonjour-tout-le-monde\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:32:58", "2023-09-06 14:32:58", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10230", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/a-propos\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:02", "2023-09-06 14:33:02", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10231", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/nos-formations\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:05", "2023-09-06 14:33:05", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10232", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/contact\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:08", "2023-09-06 14:33:08", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10233", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/mentions-legales\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:11", "2023-09-06 14:33:11", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10234", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/conditions-generales-de-vente\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:14", "2023-09-06 14:33:14", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10235", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/reglement-interieur\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:17", "2023-09-06 14:33:17", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10236", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/project\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:26", "2023-09-06 14:33:26", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10237", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/category\\/non-classe\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:29", "2023-09-06 14:33:29", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10238", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/formation-excel\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:32", "2023-09-06 14:33:32", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10239", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/formation-word-angers\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:35", "2023-09-06 14:33:35", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10240", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:38", "2023-09-06 14:33:38", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10241", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/elisabeth-cousin\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:41", "2023-09-06 14:33:41", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10242", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/mackendy-dossous\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:44", "2023-09-06 14:33:44", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10243", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/claire-lanoe\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:52", "2023-09-06 14:33:52", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10244", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/allard-nathalie\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:55", "2023-09-06 14:33:55", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10245", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/dipi_testimonial\\/mathieu-basinski\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:33:58", "2023-09-06 14:33:58", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10246", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/politique-de-confidentialite\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:34:01", "2023-09-06 14:34:01", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10247", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/evenements\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:34:04", "2023-09-06 14:34:04", "0", NULL);
INSERT INTO `z8ei5_actionscheduler_actions` VALUES("10248", "rocket_preload_job_preload_url", "complete", "2023-09-06 12:32:55", "2023-09-06 12:32:55", "[\"http:\\/\\/ts-formation.fr\\/services\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 12:34:07", "2023-09-06 14:34:07", "0", NULL);

/* INSERT TABLE DATA: z8ei5_actionscheduler_claims */
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("366", "2022-09-25 21:02:53");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("751", "2022-10-10 22:02:53");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("1355", "2022-10-17 04:02:45");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("1536", "2022-10-17 11:02:44");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("1604", "2022-10-20 14:02:50");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("1934", "2022-11-23 07:02:50");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("2100", "2022-12-12 19:02:59");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("3142", "2023-04-05 19:02:45");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("3256", "2023-04-20 12:05:58");
INSERT INTO `z8ei5_actionscheduler_claims` VALUES("4243", "2023-06-08 14:02:53");

/* INSERT TABLE DATA: z8ei5_actionscheduler_groups */
INSERT INTO `z8ei5_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `z8ei5_actionscheduler_groups` VALUES("2", "rocket-preload");

/* INSERT TABLE DATA: z8ei5_actionscheduler_logs */
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30643", "10212", "action created", "2023-09-06 07:14:47", "2023-09-06 09:14:47");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30644", "10213", "action created", "2023-09-06 07:14:47", "2023-09-06 09:14:47");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30645", "10214", "action created", "2023-09-06 07:14:47", "2023-09-06 09:14:47");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30646", "10215", "action created", "2023-09-06 07:14:47", "2023-09-06 09:14:47");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30647", "10216", "action created", "2023-09-06 07:14:47", "2023-09-06 09:14:47");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30648", "10217", "action created", "2023-09-06 07:14:47", "2023-09-06 09:14:47");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30649", "10218", "action created", "2023-09-06 07:14:47", "2023-09-06 09:14:47");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30650", "10212", "action started via WP Cron", "2023-09-06 12:26:36", "2023-09-06 14:26:36");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30651", "10212", "action complete via WP Cron", "2023-09-06 12:26:39", "2023-09-06 14:26:39");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30652", "10213", "action started via WP Cron", "2023-09-06 12:26:39", "2023-09-06 14:26:39");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30653", "10213", "action complete via WP Cron", "2023-09-06 12:26:42", "2023-09-06 14:26:42");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30654", "10214", "action started via WP Cron", "2023-09-06 12:26:42", "2023-09-06 14:26:42");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30655", "10214", "action complete via WP Cron", "2023-09-06 12:26:45", "2023-09-06 14:26:45");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30656", "10215", "action started via WP Cron", "2023-09-06 12:26:45", "2023-09-06 14:26:45");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30657", "10215", "action complete via WP Cron", "2023-09-06 12:26:48", "2023-09-06 14:26:48");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30658", "10216", "action started via WP Cron", "2023-09-06 12:26:48", "2023-09-06 14:26:48");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30659", "10216", "action complete via WP Cron", "2023-09-06 12:26:51", "2023-09-06 14:26:51");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30660", "10217", "action started via WP Cron", "2023-09-06 12:26:51", "2023-09-06 14:26:51");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30661", "10217", "action complete via WP Cron", "2023-09-06 12:26:54", "2023-09-06 14:26:54");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30662", "10218", "action started via WP Cron", "2023-09-06 12:26:54", "2023-09-06 14:26:54");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30663", "10218", "action complete via WP Cron", "2023-09-06 12:26:57", "2023-09-06 14:26:57");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30664", "10219", "action created", "2023-09-06 12:27:46", "2023-09-06 14:27:46");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30665", "10220", "action created", "2023-09-06 12:27:46", "2023-09-06 14:27:46");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30666", "10221", "action created", "2023-09-06 12:27:46", "2023-09-06 14:27:46");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30667", "10222", "action created", "2023-09-06 12:27:46", "2023-09-06 14:27:46");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30668", "10223", "action created", "2023-09-06 12:27:46", "2023-09-06 14:27:46");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30669", "10224", "action created", "2023-09-06 12:27:46", "2023-09-06 14:27:46");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30670", "10225", "action created", "2023-09-06 12:27:46", "2023-09-06 14:27:46");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30671", "10226", "action created", "2023-09-06 12:27:46", "2023-09-06 14:27:46");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30672", "10219", "action started via Async Request", "2023-09-06 12:27:47", "2023-09-06 14:27:47");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30673", "10219", "action complete via Async Request", "2023-09-06 12:27:50", "2023-09-06 14:27:50");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30674", "10220", "action started via Async Request", "2023-09-06 12:27:50", "2023-09-06 14:27:50");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30675", "10220", "action complete via Async Request", "2023-09-06 12:27:53", "2023-09-06 14:27:53");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30676", "10221", "action started via Async Request", "2023-09-06 12:27:53", "2023-09-06 14:27:53");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30677", "10221", "action complete via Async Request", "2023-09-06 12:27:56", "2023-09-06 14:27:56");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30678", "10222", "action started via Async Request", "2023-09-06 12:27:56", "2023-09-06 14:27:56");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30679", "10222", "action complete via Async Request", "2023-09-06 12:27:59", "2023-09-06 14:27:59");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30680", "10223", "action started via Async Request", "2023-09-06 12:27:59", "2023-09-06 14:27:59");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30681", "10223", "action complete via Async Request", "2023-09-06 12:28:02", "2023-09-06 14:28:02");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30682", "10224", "action started via Async Request", "2023-09-06 12:28:02", "2023-09-06 14:28:02");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30683", "10224", "action complete via Async Request", "2023-09-06 12:28:05", "2023-09-06 14:28:05");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30684", "10225", "action started via Async Request", "2023-09-06 12:28:05", "2023-09-06 14:28:05");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30685", "10225", "action complete via Async Request", "2023-09-06 12:28:06", "2023-09-06 14:28:06");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30686", "10226", "action started via Async Request", "2023-09-06 12:28:06", "2023-09-06 14:28:06");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30687", "10226", "action complete via Async Request", "2023-09-06 12:28:09", "2023-09-06 14:28:09");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30688", "10227", "action created", "2023-09-06 12:30:51", "2023-09-06 14:30:51");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30689", "10227", "action started via WP Cron", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30690", "10228", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30691", "10227", "action complete via WP Cron", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30692", "10229", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30693", "10230", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30694", "10231", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30695", "10232", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30696", "10233", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30697", "10234", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30698", "10235", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30699", "10236", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30700", "10237", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30701", "10238", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30702", "10239", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30703", "10240", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30704", "10241", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30705", "10242", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30706", "10243", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30707", "10244", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30708", "10245", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30709", "10246", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30710", "10247", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30711", "10248", "action created", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30712", "10229", "action started via Async Request", "2023-09-06 12:32:55", "2023-09-06 14:32:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30713", "10229", "action complete via Async Request", "2023-09-06 12:32:58", "2023-09-06 14:32:58");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30714", "10230", "action started via Async Request", "2023-09-06 12:32:59", "2023-09-06 14:32:59");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30715", "10230", "action complete via Async Request", "2023-09-06 12:33:02", "2023-09-06 14:33:02");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30716", "10231", "action started via Async Request", "2023-09-06 12:33:02", "2023-09-06 14:33:02");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30717", "10231", "action complete via Async Request", "2023-09-06 12:33:05", "2023-09-06 14:33:05");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30718", "10232", "action started via Async Request", "2023-09-06 12:33:05", "2023-09-06 14:33:05");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30719", "10232", "action complete via Async Request", "2023-09-06 12:33:08", "2023-09-06 14:33:08");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30720", "10233", "action started via Async Request", "2023-09-06 12:33:08", "2023-09-06 14:33:08");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30721", "10233", "action complete via Async Request", "2023-09-06 12:33:11", "2023-09-06 14:33:11");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30722", "10234", "action started via Async Request", "2023-09-06 12:33:11", "2023-09-06 14:33:11");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30723", "10234", "action complete via Async Request", "2023-09-06 12:33:14", "2023-09-06 14:33:14");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30724", "10235", "action started via Async Request", "2023-09-06 12:33:14", "2023-09-06 14:33:14");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30725", "10235", "action complete via Async Request", "2023-09-06 12:33:17", "2023-09-06 14:33:17");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30726", "10236", "action started via Async Request", "2023-09-06 12:33:23", "2023-09-06 14:33:23");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30727", "10236", "action complete via Async Request", "2023-09-06 12:33:26", "2023-09-06 14:33:26");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30728", "10237", "action started via Async Request", "2023-09-06 12:33:26", "2023-09-06 14:33:26");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30729", "10237", "action complete via Async Request", "2023-09-06 12:33:29", "2023-09-06 14:33:29");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30730", "10238", "action started via Async Request", "2023-09-06 12:33:29", "2023-09-06 14:33:29");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30731", "10238", "action complete via Async Request", "2023-09-06 12:33:32", "2023-09-06 14:33:32");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30732", "10239", "action started via Async Request", "2023-09-06 12:33:32", "2023-09-06 14:33:32");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30733", "10239", "action complete via Async Request", "2023-09-06 12:33:35", "2023-09-06 14:33:35");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30734", "10240", "action started via Async Request", "2023-09-06 12:33:35", "2023-09-06 14:33:35");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30735", "10240", "action complete via Async Request", "2023-09-06 12:33:38", "2023-09-06 14:33:38");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30736", "10241", "action started via Async Request", "2023-09-06 12:33:38", "2023-09-06 14:33:38");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30737", "10241", "action complete via Async Request", "2023-09-06 12:33:41", "2023-09-06 14:33:41");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30738", "10242", "action started via Async Request", "2023-09-06 12:33:41", "2023-09-06 14:33:41");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30739", "10242", "action complete via Async Request", "2023-09-06 12:33:44", "2023-09-06 14:33:44");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30740", "10243", "action started via Async Request", "2023-09-06 12:33:49", "2023-09-06 14:33:49");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30741", "10243", "action complete via Async Request", "2023-09-06 12:33:52", "2023-09-06 14:33:52");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30742", "10244", "action started via Async Request", "2023-09-06 12:33:52", "2023-09-06 14:33:52");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30743", "10244", "action complete via Async Request", "2023-09-06 12:33:55", "2023-09-06 14:33:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30744", "10245", "action started via Async Request", "2023-09-06 12:33:55", "2023-09-06 14:33:55");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30745", "10245", "action complete via Async Request", "2023-09-06 12:33:58", "2023-09-06 14:33:58");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30746", "10246", "action started via Async Request", "2023-09-06 12:33:58", "2023-09-06 14:33:58");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30747", "10246", "action complete via Async Request", "2023-09-06 12:34:01", "2023-09-06 14:34:01");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30748", "10247", "action started via Async Request", "2023-09-06 12:34:01", "2023-09-06 14:34:01");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30749", "10247", "action complete via Async Request", "2023-09-06 12:34:04", "2023-09-06 14:34:04");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30750", "10248", "action started via Async Request", "2023-09-06 12:34:04", "2023-09-06 14:34:04");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30751", "10248", "action complete via Async Request", "2023-09-06 12:34:07", "2023-09-06 14:34:07");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30752", "10228", "action started via Async Request", "2023-09-06 12:34:07", "2023-09-06 14:34:07");
INSERT INTO `z8ei5_actionscheduler_logs` VALUES("30753", "10228", "action complete via Async Request", "2023-09-06 12:34:07", "2023-09-06 14:34:07");

/* INSERT TABLE DATA: z8ei5_aiowps_audit_log */
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("40", "1", "1", "vincent", "130.93.170.48", "info", "successful_login", "{\"successful_login\":{\"username\":\"vincent\"}}", "", "1688134823");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("41", "1", "1", "Vincent", "130.93.170.48", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Divi Pixel\",\"version\":\"2.24.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:10:\"Divi Pixel\";s:7:\"version\";s:6:\"2.24.0\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:10:\"Divi Pixel\";s:7:\"version\";s:6:\"2.24.0\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:2;s:4:\"info\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:235;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:10:\"Divi Pixel\";s:7:\"version\";s:6:\"2.24.0\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:161;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:25:\"divi-pixel/divi-pixel.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:15:\"Plugin_Upgrader\";}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:371;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;O:15:\"Plugin_Upgrader\":7:{s:6:\"result\";a:7:{s:6:\"source\";s:62:\"/home/tsformb/www/wp-content/upgrade/wp-rocket_3.14/wp-rocket/\";s:12:\"source_files\";a:13:{i:0;s:9:\"languages\";i:1;s:16:\"contributors.txt\";i:2;s:18:\"dynamic-lists.json\";i:3;s:6:\"assets\";i:4;s:13:\"uninstall.php\";i:5;s:26:\"dynamic-lists-delayjs.json\";i:6;s:13:\"composer.lock\";i:7;s:13:\"composer.json\";i:8;s:13:\"wp-rocket.php\";i:9;s:16:\"licence-data.php\";i:10;s:3:\"inc\";i:11;s:5:\"views\";i:12;s:6:\"vendor\";}s:11:\"destination\";s:47:\"/home/tsformb/www/wp-content/plugins/wp-rocket/\";s:16:\"destination_name\";s:9:\"wp-rocket\";s:17:\"local_destination\";s:36:\"/home/tsformb/www/wp-content/plugins\";s:18:\"remote_destination\";s:47:\"/home/tsformb/www/wp-content/plugins/wp-rocket/\";s:17:\"clear_destination\";b:1;}s:4:\"bulk\";b:1;s:15:\"new_plugin_data\";a:0:{}s:7:\"strings\";a:32:{s:18:\"skin_upgrade_start\";s:125:\"Le processus de mise à jour se lance. Il peut prendre un certain temps chez certains hébergeurs, merci pour votre patience.\";s:24:\"skin_update_failed_error\";s:63:\"Une erreur est survenue lors de la mise à jour de %1$s : %2$s\";s:18:\"skin_update_failed\";s:33:\"La mise à jour de %s a échoué.\";s:22:\"skin_update_successful\";s:28:\"%s a bien été mis à jour.\";s:16:\"skin_upgrade_end\";s:41:\"Toutes les mises à jour sont terminées.\";s:25:\"skin_before_update_header\";s:46:\"Mise à jour de l’extension %1$s (%2$d/%3$d)\";s:11:\"bad_request\";s:42:\"Les données fournies ne sont pas valides.\";s:14:\"fs_unavailable\";s:47:\"Impossible d’accéder au système de fichier.\";s:8:\"fs_error\";s:30:\"Erreur du système de fichier.\";s:14:\"fs_no_root_dir\";s:59:\"Impossible de localiser le répertoire racine de WordPress.\";s:17:\"fs_no_content_dir\";s:76:\"Impossible de localiser le répertoire de contenu de WordPress (wp-content).\";s:17:\"fs_no_plugins_dir\";s:66:\"Impossible de localiser le répertoire d’extension de WordPress.\";s:16:\"fs_no_themes_dir\";s:60:\"Impossible de localiser le dossier des thèmes de WordPress.\";s:12:\"fs_no_folder\";s:52:\"Impossible de localiser le dossier nécessaire (%s).\";s:15:\"download_failed\";s:31:\"Le téléchargement a échoué.\";s:18:\"installing_package\";s:43:\"Installation de la dernière version&#8230;\";s:8:\"no_files\";s:36:\"Ce paquet ne contient aucun fichier.\";s:13:\"folder_exists\";s:40:\"Le dossier de destination existe déjà.\";s:12:\"mkdir_failed\";s:32:\"Impossible de créer le dossier.\";s:20:\"incompatible_archive\";s:42:\"L’archive n’a pas pu être installée.\";s:18:\"files_not_writable\";s:175:\"La mise à jour ne peut pas être installée car certains fichiers n’ont pas pu être copiés. Ceci est généralement dû à des incohérences dans les droits des fichiers.\";s:17:\"maintenance_start\";s:37:\"Activation du mode maintenance&#8230;\";s:15:\"maintenance_end\";s:41:\"Désactivation du mode maintenance&#8230;\";s:10:\"up_to_date\";s:50:\"Vous avez la dernière version de cette extension.\";s:10:\"no_package\";s:42:\"Aucune archive de mise à jour disponible.\";s:19:\"downloading_package\";s:74:\"Téléchargement de la mise à jour depuis <span class=\"code\">%s</span>…\";s:14:\"unpack_package\";s:40:\"Décompression de la mise à jour&#8230;\";s:10:\"remove_old\";s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";s:17:\"remove_old_failed\";s:47:\"Impossible de supprimer l’ancienne extension.\";s:14:\"process_failed\";s:44:\"La mise à jour de l’extension a échoué.\";s:15:\"process_success\";s:40:\"L’extension a bien été mise à jour.\";s:20:\"process_bulk_success\";s:44:\"Les extensions ont bien été mises à jour.\";}s:4:\"skin\";O:25:\"Bulk_Plugin_Upgrader_Skin\":9:{s:11:\"plugin_info\";a:14:{s:4:\"Name\";s:9:\"WP Rocket\";s:9:\"PluginURI\";s:20:\"https://wp-rocket.me\";s:7:\"Version\";s:6:\"3.13.1\";s:11:\"Description\";s:38:\"The best WordPress performance plugin.\";s:6:\"Author\";s:8:\"WP Media\";s:9:\"AuthorURI\";s:19:\"https://wp-media.me\";s:10:\"TextDomain\";s:6:\"rocket\";s:10:\"DomainPath\";s:9:\"languages\";s:7:\"Network\";b:0;s:10:\"RequiresWP\";s:3:\"5.7\";s:11:\"RequiresPHP\";s:3:\"7.2\";s:9:\"UpdateURI\";s:0:\"\";s:5:\"Title\";s:9:\"WP Rocket\";s:10:\"AuthorName\";s:8:\"WP Media\";}s:7:\"in_loop\";b:0;s:5:\"error\";b:0;s:8:\"upgrader\";r:96;s:11:\"done_header\";b:0;s:11:\"done_footer\";b:0;s:6:\"result\";a:7:{s:6:\"source\";s:62:\"/home/tsformb/www/wp-content/upgrade/wp-rocket_3.14/wp-rocket/\";s:12:\"source_files\";a:13:{i:0;s:9:\"languages\";i:1;s:16:\"contributors.txt\";i:2;s:18:\"dynamic-lists.json\";i:3;s:6:\"assets\";i:4;s:13:\"uninstall.php\";i:5;s:26:\"dynamic-lists-delayjs.json\";i:6;s:13:\"composer.lock\";i:7;s:13:\"composer.json\";i:8;s:13:\"wp-rocket.php\";i:9;s:16:\"licence-data.php\";i:10;s:3:\"inc\";i:11;s:5:\"views\";i:12;s:6:\"vendor\";}s:11:\"destination\";s:47:\"/home/tsformb/www/wp-content/plugins/wp-rocket/\";s:16:\"destination_name\";s:9:\"wp-rocket\";s:17:\"local_destination\";s:36:\"/home/tsformb/www/wp-content/plugins\";s:18:\"remote_destination\";s:47:\"/home/tsformb/www/wp-content/plugins/wp-rocket/\";s:17:\"clear_destination\";b:1;}s:7:\"options\";a:4:{s:3:\"url\";s:139:\"update.php?action=update-selected&amp;plugins=divi-pixel%2Fdivi-pixel.php%2Cinstant-images%2Finstant-images.php%2Cwp-rocket%2Fwp-rocket.php\";s:5:\"nonce\";s:19:\"bulk-update-plugins\";s:5:\"title\";s:0:\"\";s:7:\"context\";b:0;}s:13:\"plugin_active\";b:1;}s:12:\"update_count\";i:3;s:14:\"update_current\";i:3;}i:2;a:4:{s:6:\"action\";s:6:\"update\";s:4:\"type\";s:6:\"plugin\";s:4:\"bulk\";b:1;s:7:\"plugins\";a:3:{i:0;s:25:\"divi-pixel/divi-pixel.php\";i:1;s:33:\"instant-images/instant-images.php\";i:2;s:23:\"wp-rocket/wp-rocket.php\";}}}}i:9;a:6:{s:4:\"file\";s:37:\"/home/tsformb/www/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1688135326");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("42", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"All In One WP Security\",\"version\":\"5.2.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:22:\"All In One WP Security\";s:7:\"version\";s:5:\"5.2.0\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:22:\"All In One WP Security\";s:7:\"version\";s:5:\"5.2.0\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:2;s:4:\"info\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:235;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:22:\"All In One WP Security\";s:7:\"version\";s:5:\"5.2.0\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:161;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:15:\"Plugin_Upgrader\";}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;O:15:\"Plugin_Upgrader\":7:{s:6:\"result\";a:7:{s:6:\"source\";s:115:\"/home/tsformb/www/wp-content/upgrade/all-in-one-wp-security-and-firewall.5.2.0/all-in-one-wp-security-and-firewall/\";s:12:\"source_files\";a:18:{i:0;s:10:\"index.html\";i:1;s:9:\"languages\";i:2;s:10:\"readme.txt\";i:3;s:9:\"templates\";i:4;s:7:\"backups\";i:5;s:8:\"includes\";i:6;s:15:\"wp-security.php\";i:7;s:14:\"other-includes\";i:8;s:3:\"css\";i:9;s:20:\"wp-security-core.php\";i:10;s:4:\"logs\";i:11;s:6:\"images\";i:12;s:11:\"license.txt\";i:13;s:5:\"admin\";i:14;s:2:\"js\";i:15;s:6:\"vendor\";i:16;s:3:\"lib\";i:17;s:7:\"classes\";}s:11:\"destination\";s:73:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/\";s:16:\"destination_name\";s:35:\"all-in-one-wp-security-and-firewall\";s:17:\"local_destination\";s:36:\"/home/tsformb/www/wp-content/plugins\";s:18:\"remote_destination\";s:73:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/\";s:17:\"clear_destination\";b:1;}s:4:\"bulk\";b:0;s:15:\"new_plugin_data\";a:0:{}s:7:\"strings\";a:26:{s:11:\"bad_request\";s:42:\"Les données fournies ne sont pas valides.\";s:14:\"fs_unavailable\";s:47:\"Impossible d’accéder au système de fichier.\";s:8:\"fs_error\";s:30:\"Erreur du système de fichier.\";s:14:\"fs_no_root_dir\";s:59:\"Impossible de localiser le répertoire racine de WordPress.\";s:17:\"fs_no_content_dir\";s:76:\"Impossible de localiser le répertoire de contenu de WordPress (wp-content).\";s:17:\"fs_no_plugins_dir\";s:66:\"Impossible de localiser le répertoire d’extension de WordPress.\";s:16:\"fs_no_themes_dir\";s:60:\"Impossible de localiser le dossier des thèmes de WordPress.\";s:12:\"fs_no_folder\";s:52:\"Impossible de localiser le dossier nécessaire (%s).\";s:15:\"download_failed\";s:31:\"Le téléchargement a échoué.\";s:18:\"installing_package\";s:43:\"Installation de la dernière version&#8230;\";s:8:\"no_files\";s:36:\"Ce paquet ne contient aucun fichier.\";s:13:\"folder_exists\";s:40:\"Le dossier de destination existe déjà.\";s:12:\"mkdir_failed\";s:32:\"Impossible de créer le dossier.\";s:20:\"incompatible_archive\";s:42:\"L’archive n’a pas pu être installée.\";s:18:\"files_not_writable\";s:175:\"La mise à jour ne peut pas être installée car certains fichiers n’ont pas pu être copiés. Ceci est généralement dû à des incohérences dans les droits des fichiers.\";s:17:\"maintenance_start\";s:37:\"Activation du mode maintenance&#8230;\";s:15:\"maintenance_end\";s:41:\"Désactivation du mode maintenance&#8230;\";s:10:\"up_to_date\";s:50:\"Vous avez la dernière version de cette extension.\";s:10:\"no_package\";s:42:\"Aucune archive de mise à jour disponible.\";s:19:\"downloading_package\";s:74:\"Téléchargement de la mise à jour depuis <span class=\"code\">%s</span>…\";s:14:\"unpack_package\";s:40:\"Décompression de la mise à jour&#8230;\";s:10:\"remove_old\";s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";s:17:\"remove_old_failed\";s:47:\"Impossible de supprimer l’ancienne extension.\";s:14:\"process_failed\";s:44:\"La mise à jour de l’extension a échoué.\";s:15:\"process_success\";s:40:\"L’extension a bien été mise à jour.\";s:20:\"process_bulk_success\";s:44:\"Les extensions ont bien été mises à jour.\";}s:4:\"skin\";O:23:\"Automatic_Upgrader_Skin\":6:{s:11:\"\0*\0messages\";a:8:{i:0;s:55:\"Mise à jour de l’extension : All In One WP Security\";i:1;s:130:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.5.2.0.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:37:\"Activation du mode maintenance&#8230;\";i:5;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:6;s:41:\"Désactivation du mode maintenance&#8230;\";i:7;s:40:\"L’extension a bien été mise à jour.\";}s:8:\"upgrader\";r:96;s:11:\"done_header\";b:0;s:11:\"done_footer\";b:0;s:6:\"result\";a:7:{s:6:\"source\";s:115:\"/home/tsformb/www/wp-content/upgrade/all-in-one-wp-security-and-firewall.5.2.0/all-in-one-wp-security-and-firewall/\";s:12:\"source_files\";a:18:{i:0;s:10:\"index.html\";i:1;s:9:\"languages\";i:2;s:10:\"readme.txt\";i:3;s:9:\"templates\";i:4;s:7:\"backups\";i:5;s:8:\"includes\";i:6;s:15:\"wp-security.php\";i:7;s:14:\"other-includes\";i:8;s:3:\"css\";i:9;s:20:\"wp-security-core.php\";i:10;s:4:\"logs\";i:11;s:6:\"images\";i:12;s:11:\"license.txt\";i:13;s:5:\"admin\";i:14;s:2:\"js\";i:15;s:6:\"vendor\";i:16;s:3:\"lib\";i:17;s:7:\"classes\";}s:11:\"destination\";s:73:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/\";s:16:\"destination_name\";s:35:\"all-in-one-wp-security-and-firewall\";s:17:\"local_destination\";s:36:\"/home/tsformb/www/wp-content/plugins\";s:18:\"remote_destination\";s:73:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/\";s:17:\"clear_destination\";b:1;}s:7:\"options\";a:4:{s:3:\"url\";s:0:\"\";s:5:\"nonce\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"context\";s:28:\"/home/tsformb/www/wp-content\";}}s:12:\"update_count\";i:0;s:14:\"update_current\";i:0;}i:2;a:3:{s:6:\"plugin\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:6:\"update\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1;a:4:{s:18:\"clear_update_cache\";b:0;s:13:\"pre_check_md5\";b:0;s:16:\"attempt_rollback\";b:1;s:28:\"allow_relaxed_file_ownership\";b:0;}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;O:8:\"stdClass\":13:{s:2:\"id\";s:49:\"w.org/plugins/all-in-one-wp-security-and-firewall\";s:4:\"slug\";s:35:\"all-in-one-wp-security-and-firewall\";s:6:\"plugin\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:11:\"new_version\";s:5:\"5.2.0\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.5.2.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-256x256.png?rev=2798307\";s:2:\"1x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-128x128.png?rev=2798307\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:91:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-1544x500.png?rev=2798307\";s:2:\"1x\";s:90:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-772x250.png?rev=2798307\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.2.2\";s:12:\"requires_php\";s:3:\"5.6\";s:15:\"current_version\";s:5:\"5.1.9\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:0:{}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:0:{}}}}", "1689086952");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("43", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"20.11\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:9:\"Yoast SEO\";s:7:\"version\";s:5:\"20.11\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:9:\"Yoast SEO\";s:7:\"version\";s:5:\"20.11\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:2;s:4:\"info\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:235;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{s:6:\"plugin\";a:4:{s:4:\"name\";s:9:\"Yoast SEO\";s:7:\"version\";s:5:\"20.11\";s:6:\"action\";s:7:\"updated\";s:7:\"network\";s:0:\"\";}}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:161;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:24:\"wordpress-seo/wp-seo.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:15:\"Plugin_Upgrader\";}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;O:15:\"Plugin_Upgrader\":7:{s:6:\"result\";a:7:{s:6:\"source\";s:71:\"/home/tsformb/www/wp-content/upgrade/wordpress-seo.20.11/wordpress-seo/\";s:12:\"source_files\";a:16:{i:0;s:10:\"readme.txt\";i:1;s:3:\"src\";i:2;s:15:\"vendor_prefixed\";i:3;s:9:\"index.php\";i:4;s:8:\"packages\";i:5;s:15:\"wp-seo-main.php\";i:6;s:3:\"css\";i:7;s:10:\"wp-seo.php\";i:8;s:6:\"images\";i:9;s:11:\"license.txt\";i:10;s:5:\"admin\";i:11;s:3:\"inc\";i:12;s:15:\"wpml-config.xml\";i:13;s:2:\"js\";i:14;s:6:\"vendor\";i:15;s:3:\"lib\";}s:11:\"destination\";s:51:\"/home/tsformb/www/wp-content/plugins/wordpress-seo/\";s:16:\"destination_name\";s:13:\"wordpress-seo\";s:17:\"local_destination\";s:36:\"/home/tsformb/www/wp-content/plugins\";s:18:\"remote_destination\";s:51:\"/home/tsformb/www/wp-content/plugins/wordpress-seo/\";s:17:\"clear_destination\";b:1;}s:4:\"bulk\";b:0;s:15:\"new_plugin_data\";a:0:{}s:7:\"strings\";a:26:{s:11:\"bad_request\";s:42:\"Les données fournies ne sont pas valides.\";s:14:\"fs_unavailable\";s:47:\"Impossible d’accéder au système de fichier.\";s:8:\"fs_error\";s:30:\"Erreur du système de fichier.\";s:14:\"fs_no_root_dir\";s:59:\"Impossible de localiser le répertoire racine de WordPress.\";s:17:\"fs_no_content_dir\";s:76:\"Impossible de localiser le répertoire de contenu de WordPress (wp-content).\";s:17:\"fs_no_plugins_dir\";s:66:\"Impossible de localiser le répertoire d’extension de WordPress.\";s:16:\"fs_no_themes_dir\";s:60:\"Impossible de localiser le dossier des thèmes de WordPress.\";s:12:\"fs_no_folder\";s:52:\"Impossible de localiser le dossier nécessaire (%s).\";s:15:\"download_failed\";s:31:\"Le téléchargement a échoué.\";s:18:\"installing_package\";s:43:\"Installation de la dernière version&#8230;\";s:8:\"no_files\";s:36:\"Ce paquet ne contient aucun fichier.\";s:13:\"folder_exists\";s:40:\"Le dossier de destination existe déjà.\";s:12:\"mkdir_failed\";s:32:\"Impossible de créer le dossier.\";s:20:\"incompatible_archive\";s:42:\"L’archive n’a pas pu être installée.\";s:18:\"files_not_writable\";s:175:\"La mise à jour ne peut pas être installée car certains fichiers n’ont pas pu être copiés. Ceci est généralement dû à des incohérences dans les droits des fichiers.\";s:17:\"maintenance_start\";s:37:\"Activation du mode maintenance&#8230;\";s:15:\"maintenance_end\";s:41:\"Désactivation du mode maintenance&#8230;\";s:10:\"up_to_date\";s:50:\"Vous avez la dernière version de cette extension.\";s:10:\"no_package\";s:42:\"Aucune archive de mise à jour disponible.\";s:19:\"downloading_package\";s:74:\"Téléchargement de la mise à jour depuis <span class=\"code\">%s</span>…\";s:14:\"unpack_package\";s:40:\"Décompression de la mise à jour&#8230;\";s:10:\"remove_old\";s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";s:17:\"remove_old_failed\";s:47:\"Impossible de supprimer l’ancienne extension.\";s:14:\"process_failed\";s:44:\"La mise à jour de l’extension a échoué.\";s:15:\"process_success\";s:40:\"L’extension a bien été mise à jour.\";s:20:\"process_bulk_success\";s:44:\"Les extensions ont bien été mises à jour.\";}s:4:\"skin\";O:23:\"Automatic_Upgrader_Skin\":6:{s:11:\"\0*\0messages\";a:8:{i:0;s:42:\"Mise à jour de l’extension : Yoast SEO\";i:1;s:108:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/wordpress-seo.20.11.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:37:\"Activation du mode maintenance&#8230;\";i:5;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:6;s:41:\"Désactivation du mode maintenance&#8230;\";i:7;s:40:\"L’extension a bien été mise à jour.\";}s:8:\"upgrader\";r:96;s:11:\"done_header\";b:0;s:11:\"done_footer\";b:0;s:6:\"result\";a:7:{s:6:\"source\";s:71:\"/home/tsformb/www/wp-content/upgrade/wordpress-seo.20.11/wordpress-seo/\";s:12:\"source_files\";a:16:{i:0;s:10:\"readme.txt\";i:1;s:3:\"src\";i:2;s:15:\"vendor_prefixed\";i:3;s:9:\"index.php\";i:4;s:8:\"packages\";i:5;s:15:\"wp-seo-main.php\";i:6;s:3:\"css\";i:7;s:10:\"wp-seo.php\";i:8;s:6:\"images\";i:9;s:11:\"license.txt\";i:10;s:5:\"admin\";i:11;s:3:\"inc\";i:12;s:15:\"wpml-config.xml\";i:13;s:2:\"js\";i:14;s:6:\"vendor\";i:15;s:3:\"lib\";}s:11:\"destination\";s:51:\"/home/tsformb/www/wp-content/plugins/wordpress-seo/\";s:16:\"destination_name\";s:13:\"wordpress-seo\";s:17:\"local_destination\";s:36:\"/home/tsformb/www/wp-content/plugins\";s:18:\"remote_destination\";s:51:\"/home/tsformb/www/wp-content/plugins/wordpress-seo/\";s:17:\"clear_destination\";b:1;}s:7:\"options\";a:4:{s:3:\"url\";s:0:\"\";s:5:\"nonce\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"context\";s:28:\"/home/tsformb/www/wp-content\";}}s:12:\"update_count\";i:0;s:14:\"update_current\";i:0;}i:2;a:3:{s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:6:\"update\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:24:\"wordpress-seo/wp-seo.php\";i:1;a:4:{s:18:\"clear_update_cache\";b:0;s:13:\"pre_check_md5\";b:0;s:16:\"attempt_rollback\";b:1;s:28:\"allow_relaxed_file_ownership\";b:0;}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;O:8:\"stdClass\":13:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"20.11\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.11.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=2643727\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=2643727\";}s:8:\"requires\";s:3:\"6.1\";s:6:\"tested\";s:5:\"6.2.2\";s:12:\"requires_php\";s:5:\"7.2.5\";s:15:\"current_version\";s:5:\"20.10\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:0:{}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:0:{}}}}", "1689086957");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("44", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"All In One WP Security\",\"version\":\"5.2.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:235;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:161;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1689166166");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("45", "1", "1", "", "185.100.5.252", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"20.11\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:373;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:570;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:11:\"translation\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:11;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:16;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1689492753");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("46", "1", "1", "", "185.100.5.252", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"20.11\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:373;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:570;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:11:\"translation\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:11;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:16;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1689512237");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("47", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"BBQ Firewall\",\"version\":\"20230718\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:235;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:161;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:39:\"block-bad-queries/block-bad-queries.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1689759625");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("48", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"20.12\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:235;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:161;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:24:\"wordpress-seo/wp-seo.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1690313467");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("49", "1", "1", "", "185.100.5.252", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"20.12\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:373;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:570;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:11:\"translation\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:11;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:16;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1690313471");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("50", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"All In One WP Security\",\"version\":\"5.2.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:235;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:161;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1691166163");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("51", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"20.13\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:237;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:158;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:24:\"wordpress-seo/wp-seo.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:24:\"wordpress-seo/wp-seo.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1691520907");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("52", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"All In One WP Security\",\"version\":\"5.2.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:237;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:158;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1692060674");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("53", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"All In One WP Security\",\"version\":\"5.2.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:185;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1692212378");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("54", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"21.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:185;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:24:\"wordpress-seo/wp-seo.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:24:\"wordpress-seo/wp-seo.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1692729077");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("55", "1", "1", "", "185.100.5.252", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"21.0\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:19:\"translation_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:408;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:19:\"translation_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:22:\"Language_Pack_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:7;a:4:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:22:\"Language_Pack_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:570;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:11:\"translation\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:11;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:14;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:15;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:16;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:18;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:19;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1692729081");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("56", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WPS Bidouille\",\"version\":\"1.29\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:185;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:31:\"wps-bidouille/wps-bidouille.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:31:\"wps-bidouille/wps-bidouille.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1692889402");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("57", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WPS Cleaner\",\"version\":\"1.6.9\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:185;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:27:\"wps-cleaner/wps-cleaner.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:27:\"wps-cleaner/wps-cleaner.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1692889405");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("58", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WPS Hide Login\",\"version\":\"1.9.9\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:185;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:33:\"wps-hide-login/wps-hide-login.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:33:\"wps-hide-login/wps-hide-login.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1692889406");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("59", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WPS Limit Login\",\"version\":\"1.5.7\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:185;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:35:\"wps-limit-login/wps-limit-login.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:35:\"wps-limit-login/wps-limit-login.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1692889409");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("60", "1", "1", "", "185.100.5.252", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"21.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:185;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:24:\"wordpress-seo/wp-seo.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:875;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:231;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:24:\"wordpress-seo/wp-seo.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:523;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:6:\"plugin\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:12;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:15;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:16;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:17;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:19;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:20;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1693921730");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("61", "1", "1", "", "185.100.5.252", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"21.1\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:19:\"translation_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:408;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:19:\"translation_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:22:\"Language_Pack_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:7;a:4:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:22:\"Language_Pack_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:456;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:66:\"/home/tsformb/www/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:570;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:11:\"translation\";i:1;a:1:{i:0;s:8:\"stdClass\";}}}i:11;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:850;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:14;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:15;a:4:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/update.php\";s:4:\"line\";i:290;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:20:\"wp_maybe_auto_update\";}}i:16;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:18;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:19;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-cron.php\";s:4:\"line\";i:188;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:2:{i:0;s:16:\"wp_version_check\";i:1;a:1:{i:0;s:0:\"\";}}}}", "1693921734");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("62", "1", "1", "SiConsultingAdmin", "37.65.52.232", "info", "successful_login", "{\"successful_login\":{\"username\":\"SiConsultingAdmin\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:4:{i:0;s:16:\"successful_login\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";i:3;s:17:\"SiConsultingAdmin\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:545;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:5:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"successful_login\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";i:4;s:17:\"SiConsultingAdmin\";}}i:4;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:554;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:17:\"SiConsultingAdmin\";}}i:5;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:591;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:17:\"SiConsultingAdmin\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:17:\"SiConsultingAdmin\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:7;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:8:\"wp_login\";i:1;s:17:\"SiConsultingAdmin\";i:2;a:1:{i:0;s:7:\"WP_User\";}}}i:10;a:4:{s:4:\"file\";s:30:\"/home/tsformb/www/wp-login.php\";s:4:\"line\";i:1241;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}i:11;a:4:{s:4:\"file\";s:70:\"/home/tsformb/www/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:603;s:4:\"args\";a:1:{i:0;s:30:\"/home/tsformb/www/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:15;a:4:{s:4:\"file\";s:33:\"/home/tsformb/www/wp-settings.php\";s:4:\"line\";i:645;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:9:\"wp_loaded\";}}i:16;a:4:{s:4:\"file\";s:31:\"/home/tsformb/www/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:33:\"/home/tsformb/www/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:29:\"/home/tsformb/www/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:31:\"/home/tsformb/www/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:36:\"/home/tsformb/www/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:29:\"/home/tsformb/www/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:27:\"/home/tsformb/www/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:36:\"/home/tsformb/www/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1694003194");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("63", "1", "1", "SiConsultingAdmin", "37.65.52.232", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Divi Pixel\",\"version\":\"2.26.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:188;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:25:\"divi-pixel/divi-pixel.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:371;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:37:\"/home/tsformb/www/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}}", "1694003225");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("64", "1", "1", "SiConsultingAdmin", "37.65.52.232", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WP Rocket\",\"version\":\"3.14.4.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:14:\"plugin_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:14:\"plugin_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:188;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:7:\"updated\";i:1;s:23:\"wp-rocket/wp-rocket.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:371;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:37:\"/home/tsformb/www/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}}", "1694003225");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("65", "1", "1", "SiConsultingAdmin", "37.65.52.232", "info", "core_updated", "{\"core_updated\":{\"old_version\":\"6.2.2\",\"new_version\":\"6.3.1\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:12:\"core_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:136;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:12:\"core_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:308;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:5:\"6.3.1\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:332;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:7;a:4:{s:4:\"file\";s:51:\"/home/tsformb/www/wp-admin/includes/update-core.php\";s:4:\"line\";i:1606;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:2:{i:0;s:26:\"_core_updated_successfully\";i:1;s:5:\"6.3.1\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/tsformb/www/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:172;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:2:{i:0;s:58:\"/home/tsformb/www/wp-content/upgrade/wordpress-6.3.1-fr_fr\";i:1;s:18:\"/home/tsformb/www/\";}}i:9;a:6:{s:4:\"file\";s:42:\"/home/tsformb/www/wp-admin/update-core.php\";s:4:\"line\";i:887;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:8:\"stdClass\";}i:1;a:1:{i:0;s:0:\"\";}}}i:10;a:4:{s:4:\"file\";s:42:\"/home/tsformb/www/wp-admin/update-core.php\";s:4:\"line\";i:1116;s:8:\"function\";s:15:\"do_core_upgrade\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}}", "1694003326");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("66", "1", "1", "SiConsultingAdmin", "37.65.52.232", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Duplicator\",\"version\":\"1.5.5.1\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:16:\"plugin_installed\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"plugin_installed\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:155;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:9:\"installed\";i:1;s:0:\"\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:960;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:52:\"/home/tsformb/www/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4505;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:61:\"https://downloads.wordpress.org/plugin/duplicator.1.5.5.1.zip\";}}i:11;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:13;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:14;a:4:{s:4:\"file\";s:41:\"/home/tsformb/www/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:22:\"wp_ajax_install-plugin\";}}}", "1694003431");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("67", "1", "1", "SiConsultingAdmin", "37.65.52.232", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"duplicator\",\"version\":\"1.5.5.1\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:19:\"translation_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:408;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:19:\"translation_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:22:\"Language_Pack_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:7;a:4:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:22:\"Language_Pack_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:312;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}}}i:10;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:12;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:960;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:13;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:14;a:6:{s:4:\"file\";s:52:\"/home/tsformb/www/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4505;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:61:\"https://downloads.wordpress.org/plugin/duplicator.1.5.5.1.zip\";}}i:15;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:17;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:18;a:4:{s:4:\"file\";s:41:\"/home/tsformb/www/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:22:\"wp_ajax_install-plugin\";}}}", "1694003436");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("68", "1", "1", "SiConsultingAdmin", "37.65.52.232", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Duplicator\",\"version\":\"1.5.5.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:16:\"plugin_activated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"plugin_activated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:168;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:9:\"activated\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:25:\"duplicator/duplicator.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:46:\"/home/tsformb/www/wp-admin/includes/plugin.php\";s:4:\"line\";i:720;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:16:\"activated_plugin\";i:1;s:25:\"duplicator/duplicator.php\";i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-admin/plugins.php\";s:4:\"line\";i:58;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:3:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:89:\"http://ts-formation.fr/wp-admin/plugins.php?error=true&plugin=duplicator%2Fduplicator.php\";i:2;a:1:{i:0;s:0:\"\";}}}}", "1694003451");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("69", "1", "1", "SiConsultingAdmin", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "info", "successful_login", "{\"successful_login\":{\"username\":\"SiConsultingAdmin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:4:{i:0;s:16:\"successful_login\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";i:3;s:17:\"SiConsultingAdmin\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:545;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:5:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"successful_login\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";i:4;s:17:\"SiConsultingAdmin\";}}i:4;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:554;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:17:\"SiConsultingAdmin\";}}i:5;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:591;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:17:\"SiConsultingAdmin\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:17:\"SiConsultingAdmin\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:7;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:8:\"wp_login\";i:1;s:17:\"SiConsultingAdmin\";i:2;a:1:{i:0;s:7:\"WP_User\";}}}i:10;a:4:{s:4:\"file\";s:30:\"/home/tsformb/www/wp-login.php\";s:4:\"line\";i:1241;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}}", "1695653641");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("70", "1", "1", "SiConsultingAdmin", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Really Simple SSL\",\"version\":\"7.0.9\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:16:\"plugin_installed\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"plugin_installed\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:155;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:9:\"installed\";i:1;s:0:\"\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:960;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:6:{s:4:\"file\";s:52:\"/home/tsformb/www/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4505;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.7.0.9.zip\";}}i:11;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:13;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:14;a:4:{s:4:\"file\";s:41:\"/home/tsformb/www/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:22:\"wp_ajax_install-plugin\";}}}", "1695653836");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("71", "1", "1", "SiConsultingAdmin", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"really-simple-ssl\",\"version\":\"7.0.9\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:19:\"translation_updated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:408;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:19:\"translation_updated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:22:\"Language_Pack_Upgrader\";}i:1;a:1:{i:0;s:0:\"\";}}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:7;a:4:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:22:\"Language_Pack_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:68:\"/home/tsformb/www/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:9;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:312;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:15:\"Plugin_Upgrader\";}}}i:10;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:12;a:4:{s:4:\"file\";s:57:\"/home/tsformb/www/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:960;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:25:\"upgrader_process_complete\";i:1;a:1:{i:0;s:15:\"Plugin_Upgrader\";}i:2;a:1:{i:0;s:0:\"\";}}}i:13;a:6:{s:4:\"file\";s:61:\"/home/tsformb/www/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:14;a:6:{s:4:\"file\";s:52:\"/home/tsformb/www/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4505;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.7.0.9.zip\";}}i:15;a:4:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:17;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:18;a:4:{s:4:\"file\";s:41:\"/home/tsformb/www/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:22:\"wp_ajax_install-plugin\";}}}", "1695653839");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("72", "1", "1", "SiConsultingAdmin", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Really Simple SSL\",\"version\":\"7.0.9\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:16:\"plugin_activated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"plugin_activated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:168;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:3:{i:0;s:9:\"activated\";i:1;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:2;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:46:\"/home/tsformb/www/wp-admin/includes/plugin.php\";s:4:\"line\";i:720;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:16:\"activated_plugin\";i:1;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-admin/plugins.php\";s:4:\"line\";i:58;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:3:{i:0;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:1;s:112:\"https://ts-formation.fr/wp-admin/plugins.php?error=true&plugin=really-simple-ssl%2Frlrsssl-really-simple-ssl.php\";i:2;a:1:{i:0;s:0:\"\";}}}}", "1695653844");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("73", "1", "1", "JboostAdmin", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"JboostAdmin\",\"known\":false}}", "a:10:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:4:{i:0;s:12:\"failed_login\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:7:\"warning\";i:3;s:11:\"JboostAdmin\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:497;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:5:{i:0;s:19:\"aiowps_record_event\";i:1;s:12:\"failed_login\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:7:\"warning\";i:4;s:11:\"JboostAdmin\";}}i:4;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:196;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:11:\"JboostAdmin\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:8:\"WP_Error\";}i:1;a:1:{i:0;s:0:\"\";}}}i:7;a:4:{s:4:\"file\";s:43:\"/home/tsformb/www/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:12:\"authenticate\";}}i:8;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-includes/user.php\";s:4:\"line\";i:106;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:30:\"/home/tsformb/www/wp-login.php\";s:4:\"line\";i:1241;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}}", "1695654057");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("74", "1", "1", "SiConsultingAdmin", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "info", "successful_login", "{\"successful_login\":{\"username\":\"SiConsultingAdmin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:4:{i:0;s:16:\"successful_login\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";i:3;s:17:\"SiConsultingAdmin\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:545;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:5:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"successful_login\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";i:4;s:17:\"SiConsultingAdmin\";}}i:4;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:554;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:17:\"SiConsultingAdmin\";}}i:5;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:591;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:17:\"SiConsultingAdmin\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:17:\"SiConsultingAdmin\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:7;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:8:\"wp_login\";i:1;s:17:\"SiConsultingAdmin\";i:2;a:1:{i:0;s:7:\"WP_User\";}}}i:10;a:4:{s:4:\"file\";s:30:\"/home/tsformb/www/wp-login.php\";s:4:\"line\";i:1241;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}}", "1695654063");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("75", "1", "1", "SiConsultingAdmin", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "info", "user_registration", "{\"user_registration\":{\"registered_username\":\"Jboost\",\"type\":\"admin\",\"admin_username\":\"SiConsultingAdmin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:17:\"user_registration\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:524;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:17:\"user_registration\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";}}i:4;a:6:{s:4:\"file\";s:114:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-registration.php\";s:4:\"line\";i:49;s:8:\"function\";s:23:\"event_user_registration\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;s:5:\"admin\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:312;s:8:\"function\";s:39:\"aiowps_user_registration_action_handler\";s:5:\"class\";s:31:\"AIOWPSecurity_User_Registration\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-includes/user.php\";s:4:\"line\";i:2497;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:13:\"user_register\";i:1;a:1:{i:0;s:0:\"\";}i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:44:\"/home/tsformb/www/wp-admin/includes/user.php\";s:4:\"line\";i:235;s:8:\"function\";s:14:\"wp_insert_user\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:10;a:4:{s:4:\"file\";s:39:\"/home/tsformb/www/wp-admin/user-new.php\";s:4:\"line\";i:195;s:8:\"function\";s:9:\"edit_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1695655147");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("76", "1", "1", "Jboost", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "info", "successful_login", "{\"successful_login\":{\"username\":\"Jboost\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:4:{i:0;s:16:\"successful_login\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";i:3;s:6:\"Jboost\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:545;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:5:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"successful_login\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";i:4;s:6:\"Jboost\";}}i:4;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:554;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:6:\"Jboost\";}}i:5;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:591;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:6:\"Jboost\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:6:\"Jboost\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:7;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:8:\"wp_login\";i:1;s:6:\"Jboost\";i:2;a:1:{i:0;s:7:\"WP_User\";}}}i:10;a:4:{s:4:\"file\";s:30:\"/home/tsformb/www/wp-login.php\";s:4:\"line\";i:1241;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}}", "1695656057");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("77", "1", "1", "Jboost", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "info", "successful_login", "{\"successful_login\":{\"username\":\"Jboost\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:4:{i:0;s:16:\"successful_login\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:4:\"info\";i:3;s:6:\"Jboost\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:545;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:5:{i:0;s:19:\"aiowps_record_event\";i:1;s:16:\"successful_login\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:4:\"info\";i:4;s:6:\"Jboost\";}}i:4;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:554;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:6:\"Jboost\";}}i:5;a:6:{s:4:\"file\";s:107:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:591;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:6:\"Jboost\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:6:\"Jboost\";i:1;a:1:{i:0;s:7:\"WP_User\";}}}i:7;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:8;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:8:\"wp_login\";i:1;s:6:\"Jboost\";i:2;a:1:{i:0;s:7:\"WP_User\";}}}i:10;a:4:{s:4:\"file\";s:30:\"/home/tsformb/www/wp-login.php\";s:4:\"line\";i:1241;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:2:{i:0;a:1:{i:0;s:0:\"\";}i:1;a:1:{i:0;s:0:\"\";}}}}", "1695657749");
INSERT INTO `z8ei5_aiowps_audit_log` VALUES("78", "1", "1", "Jboost", "2a02:8429:93f0:ef01:b916:d530:7cb8:ba30", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"All In One WP Security\",\"version\":\"5.2.4\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:3:{i:0;s:18:\"plugin_deactivated\";i:1;a:1:{i:0;s:0:\"\";}i:2;s:7:\"warning\";}}i:1;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:2;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:3;a:4:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:264;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:4:{i:0;s:19:\"aiowps_record_event\";i:1;s:18:\"plugin_deactivated\";i:2;a:1:{i:0;s:0:\"\";}i:3;s:7:\"warning\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/tsformb/www/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:203;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:4:{i:0;s:11:\"deactivated\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:0:\"\";i:3;s:7:\"warning\";}}i:5;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:310;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:2:{i:0;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1;a:1:{i:0;s:0:\"\";}}}i:6;a:6:{s:4:\"file\";s:47:\"/home/tsformb/www/wp-includes/class-wp-hook.php\";s:4:\"line\";i:334;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:2:{i:0;s:0:\"\";i:1;a:1:{i:0;s:0:\"\";}}}i:7;a:6:{s:4:\"file\";s:40:\"/home/tsformb/www/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;a:1:{i:0;s:0:\"\";}}}i:8;a:4:{s:4:\"file\";s:46:\"/home/tsformb/www/wp-admin/includes/plugin.php\";s:4:\"line\";i:830;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:3:{i:0;s:18:\"deactivated_plugin\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;a:1:{i:0;s:0:\"\";}}}i:9;a:4:{s:4:\"file\";s:38:\"/home/tsformb/www/wp-admin/plugins.php\";s:4:\"line\";i:209;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:3:{i:0;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1;a:1:{i:0;s:0:\"\";}i:2;a:1:{i:0;s:0:\"\";}}}}", "1695657807");

/* INSERT TABLE DATA: z8ei5_comments */
INSERT INTO `z8ei5_comments` VALUES("1", "1", "Un commentateur ou commentatrice WordPress", "wapuu@wordpress.example", "https://fr.wordpress.org/", "", "2022-06-16 02:40:39", "2022-06-16 00:40:39", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://fr.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: z8ei5_duplicator_packages */
INSERT INTO `z8ei5_duplicator_packages` VALUES("1", "20240114_turneyskillformation", "4e03ade158db0cf32787_20240114230347", "24", "2024-01-14 23:04:01", "Jboost", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-01-14 23:03:47\";s:7:\"Version\";s:5:\"1.5.8\";s:9:\"VersionWP\";s:5:\"6.4.2\";s:9:\"VersionDB\";s:6:\"5.7.42\";s:10:\"VersionPHP\";s:6:\"8.1.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:29:\"20240114_turneyskillformation\";s:4:\"Hash\";s:35:\"4e03ade158db0cf32787_20240114230347\";s:8:\"NameHash\";s:65:\"20240114_turneyskillformation_4e03ade158db0cf32787_20240114230347\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:75:\"20240114_turneyskillformation_4e03ade158db0cf32787_20240114230347_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"24.0\";s:6:\"WPUser\";s:6:\"Jboost\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:77:\"20240114_turneyskillformation_4e03ade158db0cf32787_20240114230347_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/tsformb/www\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1218;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:9494;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-01-14 23:03:47\";s:7:\"Version\";s:5:\"1.5.8\";s:9:\"VersionWP\";s:5:\"6.4.2\";s:9:\"VersionDB\";s:6:\"5.7.42\";s:10:\"VersionPHP\";s:6:\"8.1.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:29:\"20240114_turneyskillformation\";s:4:\"Hash\";s:35:\"4e03ade158db0cf32787_20240114230347\";s:8:\"NameHash\";s:65:\"20240114_turneyskillformation_4e03ade158db0cf32787_20240114230347\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:83:\"20240114_turneyskillformation_4e03ade158db0cf32787_20240114230347_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/tsformb/www/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:78:\"20240114_turneyskillformation_4e03ade158db0cf32787_20240114230347_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:128:\"/home/tsformb/www/wp-content/backups-dup-lite/tmp/20240114_turneyskillformation_4e03ade158db0cf32787_20240114230347_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/tsformb/www/wp-admin\";i:1;s:29:\"/home/tsformb/www/wp-includes\";i:2;s:38:\"/home/tsformb/www/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/tsformb/www\";i:1;s:17:\"/home/tsformb/www\";i:2;s:28:\"/home/tsformb/www/wp-content\";i:3;s:36:\"/home/tsformb/www/wp-content/uploads\";i:4;s:36:\"/home/tsformb/www/wp-content/plugins\";i:5;s:39:\"/home/tsformb/www/wp-content/mu-plugins\";i:6;s:35:\"/home/tsformb/www/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:49:\"/home/tsformb/www/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: z8ei5_options */
INSERT INTO `z8ei5_options` VALUES("1", "siteurl", "https://ts-formation.fr", "yes");
INSERT INTO `z8ei5_options` VALUES("2", "home", "https://ts-formation.fr", "yes");
INSERT INTO `z8ei5_options` VALUES("3", "blogname", "TurneySkillFormation", "yes");
INSERT INTO `z8ei5_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `z8ei5_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("6", "admin_email", "jamila@j-boost.fr", "yes");
INSERT INTO `z8ei5_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `z8ei5_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `z8ei5_options` VALUES("15", "mailserver_login", "", "yes");
INSERT INTO `z8ei5_options` VALUES("16", "mailserver_pass", "", "yes");
INSERT INTO `z8ei5_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `z8ei5_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `z8ei5_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `z8ei5_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `z8ei5_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `z8ei5_options` VALUES("24", "time_format", "G\\hi", "yes");
INSERT INTO `z8ei5_options` VALUES("25", "links_updated_date_format", "d F Y G\\hi", "yes");
INSERT INTO `z8ei5_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `z8ei5_options` VALUES("29", "rewrite_rules", "a:396:{s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:58:\"dipi_cpt_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?dipi_cpt_category=$matches[1]&feed=$matches[2]\";s:53:\"dipi_cpt_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?dipi_cpt_category=$matches[1]&feed=$matches[2]\";s:34:\"dipi_cpt_category/([^/]+)/embed/?$\";s:50:\"index.php?dipi_cpt_category=$matches[1]&embed=true\";s:46:\"dipi_cpt_category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?dipi_cpt_category=$matches[1]&paged=$matches[2]\";s:28:\"dipi_cpt_category/([^/]+)/?$\";s:39:\"index.php?dipi_cpt_category=$matches[1]\";s:60:\"dipi_media_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dipi_media_category=$matches[1]&feed=$matches[2]\";s:55:\"dipi_media_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dipi_media_category=$matches[1]&feed=$matches[2]\";s:36:\"dipi_media_category/([^/]+)/embed/?$\";s:52:\"index.php?dipi_media_category=$matches[1]&embed=true\";s:48:\"dipi_media_category/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?dipi_media_category=$matches[1]&paged=$matches[2]\";s:30:\"dipi_media_category/([^/]+)/?$\";s:41:\"index.php?dipi_media_category=$matches[1]\";s:56:\"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:51:\"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:32:\"layout_category/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=layout_category&term=$matches[1]&embed=true\";s:44:\"layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=layout_category&term=$matches[1]&paged=$matches[2]\";s:26:\"layout_category/([^/]+)/?$\";s:51:\"index.php?taxonomy=layout_category&term=$matches[1]\";s:51:\"layout_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=layout_tag&term=$matches[1]&feed=$matches[2]\";s:46:\"layout_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=layout_tag&term=$matches[1]&feed=$matches[2]\";s:27:\"layout_tag/([^/]+)/embed/?$\";s:57:\"index.php?taxonomy=layout_tag&term=$matches[1]&embed=true\";s:39:\"layout_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?taxonomy=layout_tag&term=$matches[1]&paged=$matches[2]\";s:21:\"layout_tag/([^/]+)/?$\";s:46:\"index.php?taxonomy=layout_tag&term=$matches[1]\";s:52:\"layout_pack/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_pack/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_pack/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_pack&term=$matches[1]&embed=true\";s:40:\"layout_pack/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_pack&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_pack/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_pack&term=$matches[1]\";s:52:\"layout_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_type/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_type&term=$matches[1]&embed=true\";s:40:\"layout_type/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_type&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_type/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_type&term=$matches[1]\";s:53:\"module_width/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:48:\"module_width/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:29:\"module_width/([^/]+)/embed/?$\";s:59:\"index.php?taxonomy=module_width&term=$matches[1]&embed=true\";s:41:\"module_width/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?taxonomy=module_width&term=$matches[1]&paged=$matches[2]\";s:23:\"module_width/([^/]+)/?$\";s:48:\"index.php?taxonomy=module_width&term=$matches[1]\";s:46:\"scope/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:41:\"scope/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:22:\"scope/([^/]+)/embed/?$\";s:52:\"index.php?taxonomy=scope&term=$matches[1]&embed=true\";s:34:\"scope/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?taxonomy=scope&term=$matches[1]&paged=$matches[2]\";s:16:\"scope/([^/]+)/?$\";s:41:\"index.php?taxonomy=scope&term=$matches[1]\";s:40:\"et_pb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"et_pb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"et_pb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"et_pb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"et_pb_layout/([^/]+)/embed/?$\";s:60:\"index.php?post_type=et_pb_layout&name=$matches[1]&embed=true\";s:33:\"et_pb_layout/([^/]+)/trackback/?$\";s:54:\"index.php?post_type=et_pb_layout&name=$matches[1]&tb=1\";s:41:\"et_pb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&paged=$matches[2]\";s:48:\"et_pb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&cpage=$matches[2]\";s:37:\"et_pb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:66:\"index.php?post_type=et_pb_layout&name=$matches[1]&page=$matches[2]\";s:29:\"et_pb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"et_pb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"et_pb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"et_pb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"et_tb_item_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&feed=$matches[2]\";s:51:\"et_tb_item_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&feed=$matches[2]\";s:32:\"et_tb_item_type/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&embed=true\";s:44:\"et_tb_item_type/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&paged=$matches[2]\";s:26:\"et_tb_item_type/([^/]+)/?$\";s:51:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]\";s:38:\"et_tb_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"et_tb_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"et_tb_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"et_tb_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"et_tb_item/([^/]+)/embed/?$\";s:58:\"index.php?post_type=et_tb_item&name=$matches[1]&embed=true\";s:31:\"et_tb_item/([^/]+)/trackback/?$\";s:52:\"index.php?post_type=et_tb_item&name=$matches[1]&tb=1\";s:39:\"et_tb_item/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&paged=$matches[2]\";s:46:\"et_tb_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&cpage=$matches[2]\";s:35:\"et_tb_item/([^/]+)(?:/([0-9]+))?/?$\";s:64:\"index.php?post_type=et_tb_item&name=$matches[1]&page=$matches[2]\";s:27:\"et_tb_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"et_tb_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"et_tb_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"et_tb_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:58:\"dipi_faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?dipi_faq_category=$matches[1]&feed=$matches[2]\";s:53:\"dipi_faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?dipi_faq_category=$matches[1]&feed=$matches[2]\";s:34:\"dipi_faq_category/([^/]+)/embed/?$\";s:50:\"index.php?dipi_faq_category=$matches[1]&embed=true\";s:46:\"dipi_faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?dipi_faq_category=$matches[1]&paged=$matches[2]\";s:28:\"dipi_faq_category/([^/]+)/?$\";s:39:\"index.php?dipi_faq_category=$matches[1]\";s:44:\"dipi_testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"dipi_testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"dipi_testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"dipi_testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"dipi_testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"dipi_testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"dipi_testimonial/([^/]+)/embed/?$\";s:49:\"index.php?dipi_testimonial=$matches[1]&embed=true\";s:37:\"dipi_testimonial/([^/]+)/trackback/?$\";s:43:\"index.php?dipi_testimonial=$matches[1]&tb=1\";s:45:\"dipi_testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?dipi_testimonial=$matches[1]&paged=$matches[2]\";s:52:\"dipi_testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?dipi_testimonial=$matches[1]&cpage=$matches[2]\";s:41:\"dipi_testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?dipi_testimonial=$matches[1]&page=$matches[2]\";s:33:\"dipi_testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"dipi_testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"dipi_testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"dipi_testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"dipi_testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"dipi_testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"testimonial_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?testimonial_cat=$matches[1]&feed=$matches[2]\";s:51:\"testimonial_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?testimonial_cat=$matches[1]&feed=$matches[2]\";s:32:\"testimonial_cat/([^/]+)/embed/?$\";s:48:\"index.php?testimonial_cat=$matches[1]&embed=true\";s:44:\"testimonial_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?testimonial_cat=$matches[1]&paged=$matches[2]\";s:26:\"testimonial_cat/([^/]+)/?$\";s:37:\"index.php?testimonial_cat=$matches[1]\";s:56:\"testimonial_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?testimonial_tag=$matches[1]&feed=$matches[2]\";s:51:\"testimonial_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?testimonial_tag=$matches[1]&feed=$matches[2]\";s:32:\"testimonial_tag/([^/]+)/embed/?$\";s:48:\"index.php?testimonial_tag=$matches[1]&embed=true\";s:44:\"testimonial_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?testimonial_tag=$matches[1]&paged=$matches[2]\";s:26:\"testimonial_tag/([^/]+)/?$\";s:37:\"index.php?testimonial_tag=$matches[1]\";s:44:\"dipi_popup_maker/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"dipi_popup_maker/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"dipi_popup_maker/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"dipi_popup_maker/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"dipi_popup_maker/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"dipi_popup_maker/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"dipi_popup_maker/([^/]+)/embed/?$\";s:49:\"index.php?dipi_popup_maker=$matches[1]&embed=true\";s:37:\"dipi_popup_maker/([^/]+)/trackback/?$\";s:43:\"index.php?dipi_popup_maker=$matches[1]&tb=1\";s:45:\"dipi_popup_maker/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?dipi_popup_maker=$matches[1]&paged=$matches[2]\";s:52:\"dipi_popup_maker/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?dipi_popup_maker=$matches[1]&cpage=$matches[2]\";s:41:\"dipi_popup_maker/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?dipi_popup_maker=$matches[1]&page=$matches[2]\";s:33:\"dipi_popup_maker/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"dipi_popup_maker/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"dipi_popup_maker/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"dipi_popup_maker/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"dipi_popup_maker/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"dipi_popup_maker/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_options/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_options/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_options/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_options/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_options/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_options/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_options/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_options&name=$matches[1]&embed=true\";s:37:\"et_theme_options/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_options&name=$matches[1]&tb=1\";s:45:\"et_theme_options/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_options&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_options/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_options&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_options/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_options&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_options/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_options/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_options/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_options/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_options/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_options/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"et_code_snippet_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:56:\"et_code_snippet_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:37:\"et_code_snippet_type/([^/]+)/embed/?$\";s:53:\"index.php?et_code_snippet_type=$matches[1]&embed=true\";s:49:\"et_code_snippet_type/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?et_code_snippet_type=$matches[1]&paged=$matches[2]\";s:31:\"et_code_snippet_type/([^/]+)/?$\";s:42:\"index.php?et_code_snippet_type=$matches[1]\";s:43:\"et_code_snippet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"et_code_snippet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"et_code_snippet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"et_code_snippet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"et_code_snippet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"et_code_snippet/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"et_code_snippet/([^/]+)/embed/?$\";s:63:\"index.php?post_type=et_code_snippet&name=$matches[1]&embed=true\";s:36:\"et_code_snippet/([^/]+)/trackback/?$\";s:57:\"index.php?post_type=et_code_snippet&name=$matches[1]&tb=1\";s:44:\"et_code_snippet/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&paged=$matches[2]\";s:51:\"et_code_snippet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&cpage=$matches[2]\";s:40:\"et_code_snippet/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?post_type=et_code_snippet&name=$matches[1]&page=$matches[2]\";s:32:\"et_code_snippet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"et_code_snippet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"et_code_snippet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"et_code_snippet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"et_code_snippet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"et_code_snippet/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:37:\"et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:45:\"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:32:\"et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:40:\"et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:47:\"et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:36:\"et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:28:\"et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:37:\"et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:45:\"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:35:\"et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:43:\"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:50:\"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:39:\"et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:31:\"et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:37:\"et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:45:\"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"dipi_faq/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"dipi_faq/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"dipi_faq/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"dipi_faq/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"dipi_faq/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"dipi_faq/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"dipi_faq/([^/]+)/embed/?$\";s:41:\"index.php?dipi_faq=$matches[1]&embed=true\";s:29:\"dipi_faq/([^/]+)/trackback/?$\";s:35:\"index.php?dipi_faq=$matches[1]&tb=1\";s:37:\"dipi_faq/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?dipi_faq=$matches[1]&paged=$matches[2]\";s:44:\"dipi_faq/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?dipi_faq=$matches[1]&cpage=$matches[2]\";s:33:\"dipi_faq/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?dipi_faq=$matches[1]&page=$matches[2]\";s:25:\"dipi_faq/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"dipi_faq/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"dipi_faq/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"dipi_faq/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"dipi_faq/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"dipi_faq/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=6&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `z8ei5_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `z8ei5_options` VALUES("33", "active_plugins", "a:14:{i:0;s:39:\"block-bad-queries/block-bad-queries.php\";i:1;s:25:\"divi-flyin/divi-flyin.php\";i:2;s:25:\"divi-pixel/divi-pixel.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:50:\"hjqs-mentions-legales-fr/hjqs-mentions-legales.php\";i:6;s:33:\"instant-images/instant-images.php\";i:7;s:19:\"optimus/optimus.php\";i:8;s:26:\"popups-for-divi/plugin.php\";i:9;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:10;s:31:\"wps-bidouille/wps-bidouille.php\";i:11;s:27:\"wps-cleaner/wps-cleaner.php\";i:12;s:33:\"wps-hide-login/wps-hide-login.php\";i:13;s:35:\"wps-limit-login/wps-limit-login.php\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `z8ei5_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `z8ei5_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `z8ei5_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `z8ei5_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `z8ei5_options` VALUES("40", "template", "Divi", "yes");
INSERT INTO `z8ei5_options` VALUES("41", "stylesheet", "Divi", "yes");
INSERT INTO `z8ei5_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `z8ei5_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `z8ei5_options` VALUES("46", "db_version", "56657", "yes");
INSERT INTO `z8ei5_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `z8ei5_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("50", "default_link_category", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `z8ei5_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `z8ei5_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `z8ei5_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `z8ei5_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `z8ei5_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `z8ei5_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `z8ei5_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `z8ei5_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `z8ei5_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `z8ei5_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `z8ei5_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `z8ei5_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `z8ei5_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `z8ei5_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `z8ei5_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `z8ei5_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `z8ei5_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `z8ei5_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("79", "uninstall_plugins", "a:3:{s:19:\"optimus/optimus.php\";a:2:{i:0;s:7:\"Optimus\";i:1;s:21:\"handle_uninstall_hook\";}s:27:\"wps-cleaner/wps-cleaner.php\";a:2:{i:0;s:23:\"\\WPS\\WPS_Cleaner\\Plugin\";i:1;s:9:\"uninstall\";}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}}", "no");
INSERT INTO `z8ei5_options` VALUES("80", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `z8ei5_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("82", "page_on_front", "6", "yes");
INSERT INTO `z8ei5_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("86", "site_icon", "49884", "yes");
INSERT INTO `z8ei5_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `z8ei5_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `z8ei5_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("91", "admin_email_lifespan", "1711260022", "yes");
INSERT INTO `z8ei5_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `z8ei5_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `z8ei5_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `z8ei5_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `z8ei5_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `z8ei5_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `z8ei5_options` VALUES("100", "z8ei5_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:80:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:10:\"copy_posts\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:15:\"manage_security\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `z8ei5_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("102", "user_count", "3", "no");
INSERT INTO `z8ei5_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:71:\"<!-- wp:group -->\n<div class=\"wp-block-group\"></div>\n<!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:71:\"<!-- wp:group -->\n<div class=\"wp-block-group\"></div>\n<!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("104", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `z8ei5_options` VALUES("105", "cron", "a:25:{i:1705273649;a:1:{s:29:\"rsssl_every_five_minutes_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"rsssl_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1705275640;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1705276153;a:1:{s:25:\"dipi_check_license_status\";a:1:{s:32:\"5d374855e6118a4d918ea76e17e537fc\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:1:{i:0;b:1;}s:8:\"interval\";i:3600;}}}i:1705276582;a:1:{s:29:\"wps_cleaner_indexation_medias\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1705276649;a:1:{s:28:\"rsssl_every_three_hours_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:23:\"rsssl_every_three_hours\";s:4:\"args\";a:0:{}s:8:\"interval\";i:10800;}}}i:1705279240;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1705279356;a:4:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1705279473;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705279753;a:2:{s:29:\"dipi_save_google_reviews_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:31:\"dipi_save_facebook_reviews_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1705280056;a:3:{s:36:\"dipi_refresh_instagram_access_tokens\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:39:\"dipi_testimonial_google_review_callback\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:41:\"dipi_testimonial_facebook_review_callback\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1705280621;a:1:{s:33:\"puc_cron_check_updates-divi-flyin\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1705323600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705330649;a:2:{s:21:\"rsssl_every_week_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"rsssl_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:20:\"rsssl_every_day_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"rsssl_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705331899;a:1:{s:23:\"aiowps_clean_old_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705334370;a:1:{s:26:\"dm_admin_cron_notice_check\";a:1:{s:32:\"dd4d6eb78a154fb59dc300ada4733b5a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:2:{i:0;s:3:\"pfd\";i:1;s:2:\"dm\";}s:8:\"interval\";i:86400;}}}i:1705334642;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705335120;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705494628;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705538658;a:1:{s:27:\"update_plugins_notification\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705624840;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705762156;a:1:{s:24:\"aiowps_weekly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705763226;a:1:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705763826;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1707180063;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `z8ei5_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("131", "whl_page", "jconnect", "yes");
INSERT INTO `z8ei5_options` VALUES("134", "wps_display", "a:5:{i:0;s:25:\"wps-dashboard-server-info\";i:1;s:19:\"wps-dashboard-tools\";i:2;s:24:\"wps-dashboard-user-infos\";i:3;s:27:\"wps-dashboard-report-system\";i:4;s:19:\"wps-dashboard-mysql\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("135", "wps_white_list", "false", "yes");
INSERT INTO `z8ei5_options` VALUES("136", "wps_save_settings", "true", "yes");
INSERT INTO `z8ei5_options` VALUES("141", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"21.1\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("142", "wpseo", "a:106:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:0;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:23:\"home_url_option_changed\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"21.1\";s:16:\"previous_version\";s:4:\"21.0\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1655340060;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:23:\"https://ts-formation.fr\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:15:{s:17:\"dipi_cpt_category\";s:17:\"dipi_cpt_category\";s:19:\"dipi_media_category\";s:19:\"dipi_media_category\";s:15:\"layout_category\";s:15:\"layout_category\";s:10:\"layout_tag\";s:10:\"layout_tag\";s:11:\"layout_pack\";s:11:\"layout_pack\";s:11:\"layout_type\";s:11:\"layout_type\";s:12:\"module_width\";s:12:\"module_width\";s:5:\"scope\";s:5:\"scope\";s:15:\"et_tb_item_type\";s:15:\"et_tb_item_type\";s:16:\"project_category\";s:16:\"project_category\";s:11:\"project_tag\";s:11:\"project_tag\";s:17:\"dipi_faq_category\";s:17:\"dipi_faq_category\";s:15:\"testimonial_cat\";s:15:\"testimonial_cat\";s:15:\"testimonial_tag\";s:15:\"testimonial_tag\";s:20:\"et_code_snippet_type\";s:20:\"et_code_snippet_type\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:3:{i:0;s:18:\"siteRepresentation\";i:1;s:14:\"socialProfiles\";i:2;s:19:\"personalPreferences\";}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1655340060;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:6:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"project\";i:3;s:16:\"dipi_testimonial\";i:4;s:16:\"dipi_popup_maker\";i:5;s:8:\"dipi_faq\";}s:28:\"last_known_public_taxonomies\";a:13:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:17:\"dipi_cpt_category\";i:3;s:19:\"dipi_media_category\";i:4;s:15:\"layout_category\";i:5;s:10:\"layout_tag\";i:6;s:15:\"et_tb_item_type\";i:7;s:16:\"project_category\";i:8;s:11:\"project_tag\";i:9;s:17:\"dipi_faq_category\";i:10;s:15:\"testimonial_cat\";i:11;s:15:\"testimonial_tag\";i:12;s:20:\"et_code_snippet_type\";}s:23:\"last_known_no_unindexed\";a:4:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1695657258;s:35:\"wpseo_total_unindexed_general_items\";i:1695653643;s:31:\"wpseo_unindexed_post_link_count\";i:1695653643;s:31:\"wpseo_unindexed_term_link_count\";i:1695653643;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;}", "no");
INSERT INTO `z8ei5_options` VALUES("143", "wpseo_titles", "a:304:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:1;s:12:\"disable-date\";b:1;s:19:\"disable-post_format\";b:1;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:65:\"http://ts-formation.fr/wp-content/uploads/2022/09/education-2.png\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";i:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:1;s:23:\"display-metabox-pt-post\";b:0;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:13:\"title-project\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-project\";s:0:\"\";s:15:\"noindex-project\";b:1;s:26:\"display-metabox-pt-project\";b:0;s:26:\"post_types-project-maintax\";i:0;s:24:\"schema-page-type-project\";s:7:\"WebPage\";s:27:\"schema-article-type-project\";s:4:\"None\";s:20:\"social-title-project\";s:9:\"%%title%%\";s:26:\"social-description-project\";s:0:\"\";s:24:\"social-image-url-project\";s:0:\"\";s:23:\"social-image-id-project\";i:0;s:23:\"title-ptarchive-project\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-project\";s:0:\"\";s:25:\"bctitle-ptarchive-project\";s:0:\"\";s:25:\"noindex-ptarchive-project\";b:0;s:30:\"social-title-ptarchive-project\";s:21:\"%%pt_plural%% Archive\";s:36:\"social-description-ptarchive-project\";s:0:\"\";s:34:\"social-image-url-ptarchive-project\";s:0:\"\";s:33:\"social-image-id-ptarchive-project\";i:0;s:22:\"title-dipi_testimonial\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-dipi_testimonial\";s:0:\"\";s:24:\"noindex-dipi_testimonial\";b:0;s:35:\"display-metabox-pt-dipi_testimonial\";b:1;s:35:\"post_types-dipi_testimonial-maintax\";i:0;s:33:\"schema-page-type-dipi_testimonial\";s:7:\"WebPage\";s:36:\"schema-article-type-dipi_testimonial\";s:4:\"None\";s:29:\"social-title-dipi_testimonial\";s:9:\"%%title%%\";s:35:\"social-description-dipi_testimonial\";s:0:\"\";s:33:\"social-image-url-dipi_testimonial\";s:0:\"\";s:32:\"social-image-id-dipi_testimonial\";i:0;s:22:\"title-dipi_popup_maker\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-dipi_popup_maker\";s:0:\"\";s:24:\"noindex-dipi_popup_maker\";b:1;s:35:\"display-metabox-pt-dipi_popup_maker\";b:0;s:35:\"post_types-dipi_popup_maker-maintax\";i:0;s:33:\"schema-page-type-dipi_popup_maker\";s:7:\"WebPage\";s:36:\"schema-article-type-dipi_popup_maker\";s:4:\"None\";s:29:\"social-title-dipi_popup_maker\";s:9:\"%%title%%\";s:35:\"social-description-dipi_popup_maker\";s:0:\"\";s:33:\"social-image-url-dipi_popup_maker\";s:0:\"\";s:32:\"social-image-id-dipi_popup_maker\";i:0;s:14:\"title-dipi_faq\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-dipi_faq\";s:0:\"\";s:16:\"noindex-dipi_faq\";b:1;s:27:\"display-metabox-pt-dipi_faq\";b:0;s:27:\"post_types-dipi_faq-maintax\";i:0;s:25:\"schema-page-type-dipi_faq\";s:7:\"WebPage\";s:28:\"schema-article-type-dipi_faq\";s:4:\"None\";s:21:\"social-title-dipi_faq\";s:9:\"%%title%%\";s:27:\"social-description-dipi_faq\";s:0:\"\";s:25:\"social-image-url-dipi_faq\";s:0:\"\";s:24:\"social-image-id-dipi_faq\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:1;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:1;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:27:\"title-tax-dipi_cpt_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:30:\"metadesc-tax-dipi_cpt_category\";s:0:\"\";s:37:\"display-metabox-tax-dipi_cpt_category\";b:1;s:29:\"noindex-tax-dipi_cpt_category\";b:0;s:34:\"social-title-tax-dipi_cpt_category\";s:27:\"Archives des %%term_title%%\";s:40:\"social-description-tax-dipi_cpt_category\";s:0:\"\";s:38:\"social-image-url-tax-dipi_cpt_category\";s:0:\"\";s:37:\"social-image-id-tax-dipi_cpt_category\";i:0;s:35:\"taxonomy-dipi_cpt_category-ptparent\";i:0;s:29:\"title-tax-dipi_media_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-tax-dipi_media_category\";s:0:\"\";s:39:\"display-metabox-tax-dipi_media_category\";b:1;s:31:\"noindex-tax-dipi_media_category\";b:0;s:36:\"social-title-tax-dipi_media_category\";s:27:\"Archives des %%term_title%%\";s:42:\"social-description-tax-dipi_media_category\";s:0:\"\";s:40:\"social-image-url-tax-dipi_media_category\";s:0:\"\";s:39:\"social-image-id-tax-dipi_media_category\";i:0;s:37:\"taxonomy-dipi_media_category-ptparent\";i:0;s:25:\"title-tax-layout_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-layout_category\";s:0:\"\";s:35:\"display-metabox-tax-layout_category\";b:0;s:27:\"noindex-tax-layout_category\";b:1;s:32:\"social-title-tax-layout_category\";s:27:\"Archives des %%term_title%%\";s:38:\"social-description-tax-layout_category\";s:0:\"\";s:36:\"social-image-url-tax-layout_category\";s:0:\"\";s:35:\"social-image-id-tax-layout_category\";i:0;s:33:\"taxonomy-layout_category-ptparent\";i:0;s:20:\"title-tax-layout_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-layout_tag\";s:0:\"\";s:30:\"display-metabox-tax-layout_tag\";b:0;s:22:\"noindex-tax-layout_tag\";b:1;s:27:\"social-title-tax-layout_tag\";s:27:\"Archives des %%term_title%%\";s:33:\"social-description-tax-layout_tag\";s:0:\"\";s:31:\"social-image-url-tax-layout_tag\";s:0:\"\";s:30:\"social-image-id-tax-layout_tag\";i:0;s:28:\"taxonomy-layout_tag-ptparent\";i:0;s:21:\"title-tax-layout_pack\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-layout_pack\";s:0:\"\";s:31:\"display-metabox-tax-layout_pack\";b:1;s:23:\"noindex-tax-layout_pack\";b:0;s:28:\"social-title-tax-layout_pack\";s:27:\"Archives des %%term_title%%\";s:34:\"social-description-tax-layout_pack\";s:0:\"\";s:32:\"social-image-url-tax-layout_pack\";s:0:\"\";s:31:\"social-image-id-tax-layout_pack\";i:0;s:29:\"taxonomy-layout_pack-ptparent\";i:0;s:21:\"title-tax-layout_type\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-layout_type\";s:0:\"\";s:31:\"display-metabox-tax-layout_type\";b:1;s:23:\"noindex-tax-layout_type\";b:0;s:28:\"social-title-tax-layout_type\";s:27:\"Archives des %%term_title%%\";s:34:\"social-description-tax-layout_type\";s:0:\"\";s:32:\"social-image-url-tax-layout_type\";s:0:\"\";s:31:\"social-image-id-tax-layout_type\";i:0;s:29:\"taxonomy-layout_type-ptparent\";i:0;s:22:\"title-tax-module_width\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-module_width\";s:0:\"\";s:32:\"display-metabox-tax-module_width\";b:1;s:24:\"noindex-tax-module_width\";b:0;s:29:\"social-title-tax-module_width\";s:27:\"Archives des %%term_title%%\";s:35:\"social-description-tax-module_width\";s:0:\"\";s:33:\"social-image-url-tax-module_width\";s:0:\"\";s:32:\"social-image-id-tax-module_width\";i:0;s:30:\"taxonomy-module_width-ptparent\";i:0;s:15:\"title-tax-scope\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-scope\";s:0:\"\";s:25:\"display-metabox-tax-scope\";b:1;s:17:\"noindex-tax-scope\";b:0;s:22:\"social-title-tax-scope\";s:27:\"Archives des %%term_title%%\";s:28:\"social-description-tax-scope\";s:0:\"\";s:26:\"social-image-url-tax-scope\";s:0:\"\";s:25:\"social-image-id-tax-scope\";i:0;s:23:\"taxonomy-scope-ptparent\";i:0;s:25:\"title-tax-et_tb_item_type\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-et_tb_item_type\";s:0:\"\";s:35:\"display-metabox-tax-et_tb_item_type\";b:0;s:27:\"noindex-tax-et_tb_item_type\";b:1;s:32:\"social-title-tax-et_tb_item_type\";s:27:\"Archives des %%term_title%%\";s:38:\"social-description-tax-et_tb_item_type\";s:0:\"\";s:36:\"social-image-url-tax-et_tb_item_type\";s:0:\"\";s:35:\"social-image-id-tax-et_tb_item_type\";i:0;s:33:\"taxonomy-et_tb_item_type-ptparent\";i:0;s:26:\"title-tax-project_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-project_category\";s:0:\"\";s:36:\"display-metabox-tax-project_category\";b:0;s:28:\"noindex-tax-project_category\";b:1;s:33:\"social-title-tax-project_category\";s:27:\"Archives des %%term_title%%\";s:39:\"social-description-tax-project_category\";s:0:\"\";s:37:\"social-image-url-tax-project_category\";s:0:\"\";s:36:\"social-image-id-tax-project_category\";i:0;s:34:\"taxonomy-project_category-ptparent\";i:0;s:21:\"title-tax-project_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-project_tag\";s:0:\"\";s:31:\"display-metabox-tax-project_tag\";b:0;s:23:\"noindex-tax-project_tag\";b:1;s:28:\"social-title-tax-project_tag\";s:27:\"Archives des %%term_title%%\";s:34:\"social-description-tax-project_tag\";s:0:\"\";s:32:\"social-image-url-tax-project_tag\";s:0:\"\";s:31:\"social-image-id-tax-project_tag\";i:0;s:29:\"taxonomy-project_tag-ptparent\";i:0;s:27:\"title-tax-dipi_faq_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:30:\"metadesc-tax-dipi_faq_category\";s:0:\"\";s:37:\"display-metabox-tax-dipi_faq_category\";b:0;s:29:\"noindex-tax-dipi_faq_category\";b:1;s:34:\"social-title-tax-dipi_faq_category\";s:27:\"Archives des %%term_title%%\";s:40:\"social-description-tax-dipi_faq_category\";s:0:\"\";s:38:\"social-image-url-tax-dipi_faq_category\";s:0:\"\";s:37:\"social-image-id-tax-dipi_faq_category\";i:0;s:35:\"taxonomy-dipi_faq_category-ptparent\";i:0;s:25:\"title-tax-testimonial_cat\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-testimonial_cat\";s:0:\"\";s:35:\"display-metabox-tax-testimonial_cat\";b:0;s:27:\"noindex-tax-testimonial_cat\";b:1;s:32:\"social-title-tax-testimonial_cat\";s:27:\"Archives des %%term_title%%\";s:38:\"social-description-tax-testimonial_cat\";s:0:\"\";s:36:\"social-image-url-tax-testimonial_cat\";s:0:\"\";s:35:\"social-image-id-tax-testimonial_cat\";i:0;s:33:\"taxonomy-testimonial_cat-ptparent\";i:0;s:25:\"title-tax-testimonial_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-testimonial_tag\";s:0:\"\";s:35:\"display-metabox-tax-testimonial_tag\";b:0;s:27:\"noindex-tax-testimonial_tag\";b:1;s:32:\"social-title-tax-testimonial_tag\";s:27:\"Archives des %%term_title%%\";s:38:\"social-description-tax-testimonial_tag\";s:0:\"\";s:36:\"social-image-url-tax-testimonial_tag\";s:0:\"\";s:35:\"social-image-id-tax-testimonial_tag\";i:0;s:33:\"taxonomy-testimonial_tag-ptparent\";i:0;s:30:\"title-tax-et_code_snippet_type\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:33:\"metadesc-tax-et_code_snippet_type\";s:0:\"\";s:40:\"display-metabox-tax-et_code_snippet_type\";b:1;s:32:\"noindex-tax-et_code_snippet_type\";b:0;s:37:\"social-title-tax-et_code_snippet_type\";s:27:\"Archives des %%term_title%%\";s:43:\"social-description-tax-et_code_snippet_type\";s:0:\"\";s:41:\"social-image-url-tax-et_code_snippet_type\";s:0:\"\";s:40:\"social-image-id-tax-et_code_snippet_type\";i:0;s:38:\"taxonomy-et_code_snippet_type-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:98;s:17:\"company_logo_meta\";a:10:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:8:\"filesize\";i:8151;s:3:\"url\";s:66:\"https://ts-formation.fr/wp-content/uploads/2022/09/education-2.png\";s:4:\"path\";s:60:\"/home/tsformb/www/wp-content/uploads/2022/09/education-2.png\";s:4:\"size\";s:4:\"full\";s:2:\"id\";i:98;s:3:\"alt\";s:0:\"\";s:6:\"pixels\";i:16384;s:4:\"type\";s:9:\"image/png\";}s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "yes");
INSERT INTO `z8ei5_options` VALUES("144", "wpseo_social", "a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:74:\"http://ts-formation.fr/wp-content/uploads/2022/10/TurneySkillFormation.png\";s:19:\"og_default_image_id\";i:49874;s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}}", "yes");
INSERT INTO `z8ei5_options` VALUES("147", "theme_mods_twentytwentytwo", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1655340063;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `z8ei5_options` VALUES("148", "current_theme", "Divi", "yes");
INSERT INTO `z8ei5_options` VALUES("149", "theme_switched", "", "yes");
INSERT INTO `z8ei5_options` VALUES("154", "et_core_version", "4.23.4", "yes");
INSERT INTO `z8ei5_options` VALUES("156", "et_divi", "a:164:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:30:\"et_flush_rewrite_rules_library\";s:6:\"4.23.4\";s:31:\"divi_previous_installed_version\";s:6:\"4.21.0\";s:29:\"divi_latest_installed_version\";s:6:\"4.23.4\";s:27:\"divi_skip_font_subset_force\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:15:\"divi_1_3_images\";s:7:\"checked\";s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:23:\"builder_custom_defaults\";O:8:\"stdClass\":0:{}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:29:\"custom_defaults_migrated_flag\";b:1;s:9:\"divi_logo\";s:0:\"\";s:14:\"divi_fixed_nav\";s:2:\"on\";s:26:\"divi_gallery_layout_enable\";s:5:\"false\";s:18:\"divi_color_palette\";s:63:\"#000000|#ffffff|#f34600|#03a397|#02898d|#01568d|#00335a|#8300e9\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:5:\"false\";s:12:\"divi_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:33:\"divi_gf_enable_all_character_sets\";s:5:\"false\";s:23:\"divi_show_facebook_icon\";s:2:\"on\";s:22:\"divi_show_twitter_icon\";s:2:\"on\";s:24:\"divi_show_instagram_icon\";s:2:\"on\";s:18:\"divi_show_rss_icon\";s:2:\"on\";s:17:\"divi_facebook_url\";s:1:\"#\";s:16:\"divi_twitter_url\";s:1:\"#\";s:18:\"divi_instagram_url\";s:1:\"#\";s:12:\"divi_rss_url\";s:0:\"\";s:34:\"divi_woocommerce_archive_num_posts\";i:9;s:17:\"divi_catnum_posts\";i:6;s:21:\"divi_archivenum_posts\";i:5;s:20:\"divi_searchnum_posts\";i:5;s:17:\"divi_tagnum_posts\";i:5;s:16:\"divi_date_format\";s:6:\"M j, Y\";s:16:\"divi_use_excerpt\";s:5:\"false\";s:16:\"divi_back_to_top\";s:5:\"false\";s:18:\"divi_smooth_scroll\";s:5:\"false\";s:25:\"divi_disable_translations\";s:5:\"false\";s:29:\"divi_enable_responsive_images\";s:2:\"on\";s:15:\"divi_custom_css\";s:855:\"@media screen and ( max-width: 980px ) {\r\n    .inverse {\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n    }\r\n}\r\n\r\n.ds-vertical-align {\r\n        display: flex;\r\n        flex-direction: column;\r\n        justify-content: center;\r\n    }\r\n\r\n/*******************************************************/\r\n    /* tarteaucitron */\r\n    /*******************************************************/\r\n    #tarteaucitronAlertBig #tarteaucitronPersonalize,\r\n    #tarteaucitronRoot #tarteaucitronPercentage,\r\n    #tarteaucitronAlertSmall #tarteaucitronManager #tarteaucitronDot #tarteaucitronDotGreen {\r\n	Background :#02898d!important\r\n}\r\n.tarteaucitronAllow {\r\n	background: #02898d!important\r\n}\r\n.tarteaucitronDeny{\r\n	background: #f34600!important\r\n}\r\n#tarteaucitronRoot #tarteaucitronAlertBig {\r\n	background:#333333!important;\r\n	color:white!important\r\n}\";s:29:\"divi_dynamic_module_framework\";s:2:\"on\";s:16:\"divi_dynamic_css\";s:2:\"on\";s:18:\"divi_dynamic_icons\";s:5:\"false\";s:22:\"divi_inline_stylesheet\";s:2:\"on\";s:17:\"divi_critical_css\";s:2:\"on\";s:30:\"divi_critical_threshold_height\";s:3:\"Bas\";s:25:\"divi_dynamic_js_libraries\";s:2:\"on\";s:19:\"divi_disable_emojis\";s:2:\"on\";s:20:\"divi_defer_block_css\";s:2:\"on\";s:24:\"divi_google_fonts_inline\";s:5:\"false\";s:51:\"divi_limit_google_fonts_support_for_legacy_browsers\";s:2:\"on\";s:23:\"divi_enable_jquery_body\";s:2:\"on\";s:32:\"divi_enable_jquery_compatibility\";s:2:\"on\";s:29:\"divi_enable_jquery_body_super\";s:5:\"false\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:2:\"on\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:27:\"et_pb_post_type_integration\";a:5:{s:4:\"post\";s:2:\"on\";s:4:\"page\";s:2:\"on\";s:7:\"project\";s:2:\"on\";s:16:\"dipi_testimonial\";s:3:\"off\";s:16:\"dipi_popup_maker\";s:3:\"off\";}s:21:\"et_pb_static_css_file\";s:2:\"on\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:24:\"et_enable_classic_editor\";s:3:\"off\";s:14:\"divi_postinfo2\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";}s:22:\"divi_show_postcomments\";s:2:\"on\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:3:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:1362:\"<script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/gh/AmauriC/tarteaucitron.js@1.9.4/tarteaucitron.min.js\"></script>\r\n		<script type=\"text/javascript\">\r\n      tarteaucitron.init({\r\n        \"privacyUrl\": \"http://ts-formation.fr/politique-de-confidentialite/\", /* Privacy policy url */\r\n        \"hashtag\": \"#tarteaucitron\", /* Open the panel with this hashtag */\r\n        \"cookieName\": \"tartaucitron\", /* Cookie name */\r\n        \"orientation\": \"bottom\", /* Banner position (top - bottom) */\r\n        \"showAlertSmall\": false, /* Show the small banner on bottom right */\r\n        \"cookieslist\": true, /* Show the cookie list */\r\n        \"adblocker\": false, /* Show a Warning if an adblocker is detected */\r\n        \"AcceptAllCta\" : true, /* Show the accept all button when highPrivacy on */\r\n        \"highPrivacy\": false, /* Disable auto consent */\r\n        \"handleBrowserDNTRequest\": false, /* If Do Not Track == 1, accept all */\r\n        \"removeCredit\": false, /* Remove credit link */\r\n        \"moreInfoLink\": true, /* Show more info link */\r\n        //\"cookieDomain\": \".my-multisite-domaine.fr\" /* Shared cookie for subdomain */\r\n      });\r\n    </script>\r\n\r\n<meta name=\"google-site-verification\" content=\"a1dfr3q1FTUqkkl7O7VWGPHkWuRqRVJ9a5EuZog9s1o\" />\r\n\r\n<meta name=\"google-site-verification\" content=\"DoWZ5TqgxsDXkNBDOqj6WVVZKgwdvYDaqfJdJfI0nuc\" />\r\n\";s:21:\"divi_integration_body\";s:239:\"<script type=\"text/javascript\"> \r\ntarteaucitron.user.gtagUa = \'G-ZTJG0GNW63\'; \r\ntarteaucitron.user.gtagMore = function () { /* add here your optionnal gtag() */ }; \r\n(tarteaucitron.job = tarteaucitron.job || []).push(\'gtag\'); \r\n</script>\r\n\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:19:\"product_tour_status\";a:3:{i:2;s:3:\"off\";i:4;s:3:\"off\";i:6;s:3:\"off\";}s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:46:\"et_fb_pref_builder_enable_visual_theme_builder\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:0:\"\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:0:\"\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:484;s:33:\"et_fb_pref_modal_dimension_height\";i:541;s:27:\"et_fb_pref_modal_position_x\";i:448;s:27:\"et_fb_pref_modal_position_y\";i:124;s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:0;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:0;s:30:\"et_fb_pref_lv_modal_position_x\";i:0;s:30:\"et_fb_pref_lv_modal_position_y\";i:0;s:34:\"et_fb_pref_responsive_tablet_width\";i:768;s:35:\"et_fb_pref_responsive_tablet_height\";i:0;s:33:\"et_fb_pref_responsive_phone_width\";i:400;s:34:\"et_fb_pref_responsive_phone_height\";i:0;s:35:\"et_fb_pref_responsive_minimum_width\";i:320;s:35:\"et_fb_pref_responsive_maximum_width\";i:980;s:12:\"accent_color\";s:7:\"#03a397\";s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";s:10:\"link_color\";s:7:\"#f34600\";s:12:\"divi_favicon\";s:0:\"\";s:29:\"presets_storage_migrated_flag\";b:1;s:39:\"builder_global_presets_history_migrated\";b:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("157", "theme_mods_Divi", "a:4:{s:18:\"custom_css_post_id\";i:21;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:3;}s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("158", "widget_aboutmewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("159", "widget_adsensewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("160", "widget_advwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("161", "et_safe_mode_plugins_allowlist", "a:8:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:27:\"ari-adminer/ari-adminer.php\";i:5;s:31:\"query-monitor/query-monitor.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("162", "et_support_center_installed", "true", "yes");
INSERT INTO `z8ei5_options` VALUES("163", "et_images_temp_folder", "/home/clients/siconsulting/prod/base_wordpress/wp-content/uploads/et_temp", "yes");
INSERT INTO `z8ei5_options` VALUES("164", "et_schedule_clean_images_last_time", "1704816571", "yes");
INSERT INTO `z8ei5_options` VALUES("165", "et_bfb_settings", "a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("172", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("173", "et_account_status", "active", "no");
INSERT INTO `z8ei5_options` VALUES("177", "et_pb_builder_options", "a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("186", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("189", "wps-security-scanner", "a:2:{s:18:\"email_notification\";s:1:\"1\";s:12:\"ignore_nofix\";s:1:\"0\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("190", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("191", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `z8ei5_options` VALUES("192", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("210", "et_support_site_id", "O1AvHemNBbxqT(MJCoYI", "yes");
INSERT INTO `z8ei5_options` VALUES("211", "et_support_center_setup_done", "processed", "yes");
INSERT INTO `z8ei5_options` VALUES("216", "optimus_purchase_time", "1684051193", "no");
INSERT INTO `z8ei5_options` VALUES("221", "wpseo_sitemap_1_cache_validator", "pXYx", "no");
INSERT INTO `z8ei5_options` VALUES("222", "wpseo_sitemap_post_cache_validator", "3NS95", "no");
INSERT INTO `z8ei5_options` VALUES("253", "finished_updating_comment_type", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("254", "wpseo_sitemap_page_cache_validator", "3O4d", "no");
INSERT INTO `z8ei5_options` VALUES("273", "list_post_without_cache", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("278", "recently_activated", "a:3:{s:24:\"wordpress-seo/wp-seo.php\";i:1695657830;s:33:\"duplicate-post/duplicate-post.php\";i:1695657822;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1695657807;}", "yes");
INSERT INTO `z8ei5_options` VALUES("296", "wpseo_sitemap_attachment_cache_validator", "5r2HW", "no");
INSERT INTO `z8ei5_options` VALUES("308", "dipi_license", "ead2378fa38c30e20a7db545ccdcc632", "yes");
INSERT INTO `z8ei5_options` VALUES("309", "dipi_license_status", "valid", "yes");
INSERT INTO `z8ei5_options` VALUES("310", "dipi_license_limit", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("311", "dipi_license_site_count", "259", "yes");
INSERT INTO `z8ei5_options` VALUES("312", "edd_sl_9481ed44b0b7ba0701d45beb14f3f72f", "a:2:{s:7:\"timeout\";i:1655351406;s:5:\"value\";s:94816:\"{\"new_version\":\"2.13\",\"stable_version\":\"2.13\",\"name\":\"Divi Pixel\",\"slug\":\"divi-pixel\",\"url\":\"https:\\/\\/www.divi-pixel.com\\/product\\/divi-pixel\\/?changelog=1\",\"last_updated\":\"2022-06-08 13:29:23\",\"homepage\":\"https:\\/\\/www.divi-pixel.com\\/product\\/divi-pixel\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p>[et_pb_section fb_built=\\\"1\\\" admin_label=\\\"section\\\" _builder_version=\\\"4.16\\\" global_colors_info=\\\"{}\\\"][et_pb_row admin_label=\\\"row\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"][et_pb_column type=\\\"4_4\\\" _builder_version=\\\"4.16\\\" custom_padding=\\\"|||\\\" global_colors_info=\\\"{}\\\" custom_padding__hover=\\\"|||\\\"][et_pb_text admin_label=\\\"Text\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"]<br \\/>\\nDivi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals. Create amazing websites using powerful Divi Pixels modules and settings.<br \\/>\\n[\\/et_pb_text][\\/et_pb_column][\\/et_pb_row][\\/et_pb_section]<\\/p>\\n\",\"changelog\":\"<p><strong>2.13.0 - June 8th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added Text Highlighter module<\\/li>\\n<li>Added option to select the active tab on load in Advanced Tabs module<\\/li>\\n<li>Added ordering settings to Masonry Gallery module<\\/li>\\n<li>Fixed particles background issue when parallax option is enabled<\\/li>\\n<li>Fixed Theme Customizer toggles not displaying the correct value<\\/li>\\n<li>Fixed button icons not working when the Dynamic CSS is enabled<\\/li>\\n<li>Fixed Carousel button link dynamic option<\\/li>\\n<li>Fixed collapsed submenu not working when Theme Builder Menu module used<\\/li>\\n<li>Fixed Timeline animations not working in Firefox and Safari browsers<\\/li>\\n<li>Fixed not loading Divi Pixel font when the user is logged in<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.12.0 - May 26th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Particles Background effect<\\/li>\\n<li>Fixed Hotspot Image unwanted square element displayed below module when Lazy Load is used<\\/li>\\n<li>Added animation settings to child modules in the Timeline module<\\/li>\\n<li>Added Image Slider heading customization settings for H tags placed in description<\\/li>\\n<li>Updated PHP 8 depreciated functions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.11.0 - May 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Expanding CTA module<\\/li>\\n<li>Fixed Advanced Tabs button target issue<\\/li>\\n<li>Fixed Image Gallery navigation issue when used in Advanced Tabs module<\\/li>\\n<li>Fixed Carousel description HTML markup displayed when not used<\\/li>\\n<li>Fixed Carousel image box-shadow issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.10 - May 9th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Maintenance Mode feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Allow TTF, OTF and WOFF file uploads<\\/li>\\n<li>Fixed Image Slider issue when used in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.9 - May 5th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Horizontal Timeline module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added option to add overlay image for Scroll Image module and set reveal effect<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added Animate in Viewport and Delay options to the Lottie Icon module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added reverse direction animation for autorotate option in Info Circle module<\\/li>\\n<li>Improved JavaScript for Balloon module to address issues when used in Theme Builder<\\/li>\\n<li>Added Telegram social media icon<\\/li>\\n<li>Added link customization settings to FAQ module<\\/li>\\n<li>Added Carousel image\\/icon hover option<\\/li>\\n<li>Fixed Floating Images animations not working in Safari and iOS 15.4.1<\\/li>\\n<li>Fixed Fancy Text prefix goes out of the screen issue<\\/li>\\n<li>Fixed Dual Heading background text displayed in Divi Builder when not used<\\/li>\\n<li>Fixed Advanced Tabs Divi Library item width issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.8 - April 25th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Advanced Tabs module<\\/li>\\n<li>Fixed Image Slider custom thumbnails not displayed on front-end<\\/li>\\n<li>Fixed Image Slider title formatting and HTML tag displayed on front-end<\\/li>\\n<li>Fixed Image Hotspot mobile issue<\\/li>\\n<li>Fixed Image Hotspot box shadow and border-radius issue<\\/li>\\n<li>Fixed Hover Box and Flip Box gradient migration issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.2 - April 13th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Author Box and Menu CTA Button font issue<\\/li>\\n<li>Fixed Panorama video controls not working in Safari browser<\\/li>\\n<li>Fixed Panorama default height value not working<\\/li>\\n<li>Fixed Image Slider custom navigation not displayed on the frontend<\\/li>\\n<li>Fixed Divi Pixel settings import issue<\\/li>\\n<li>Fixed Masonry Gallery icon border not working<\\/li>\\n<li>Fixed Dual Heading background animation issue<\\/li>\\n<li>Fixed module link not working in Balloon module<\\/li>\\n<li>Fixed dropdown link background color not working with Theme Builder header<\\/li>\\n<li>Added multi-select field for CTA menu button<\\/li>\\n<li>Added gradient migration for new gradient builder to retain old values<\\/li>\\n<li>Added dynamic images and content to Before &amp; After Slider module<\\/li>\\n<li>Added dynamic content fields to the Grid Button module<\\/li>\\n<li>Added dynamic labels to the Content Toggle module<\\/li>\\n<li>Added dynamic prefix and suffix fields to the Counter module<\\/li>\\n<li>Added dynamic heading content to the Dual Heading module<\\/li>\\n<li>Added dynamic fields for prefix and suffix in Fancy Text module<\\/li>\\n<li>Added dynamic image and image link fields to the Floating Images module<\\/li>\\n<li>Added dynamic image and content fields to Accordion Image module<\\/li>\\n<li>Added dynamic images and content fields to the Image Hotspot module<\\/li>\\n<li>Added dynamic images and content fields to the Balloon module<\\/li>\\n<li>Added dynamic images and content fields to the Carousel module<\\/li>\\n<li>Added dynamic images and content fields to the Flip Box module<\\/li>\\n<li>Added dynamic images and content fields to the Hover Box module<\\/li>\\n<li>Added dynamic images fields to the Image Magnifier module<\\/li>\\n<li>Added dynamic images fields to the Image Mask module<\\/li>\\n<li>Added dynamic images fields to the Image Showcase module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.1 - April 6th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Added Projects category and tag slug options<\\/li>\\n<li>Added CSS ID &amp; Classes fields to Image Accordion child items<\\/li>\\n<li>Added Half Circle option to the Counter module<\\/li>\\n<li>Added new gradient support to Divi Pixel modules<\\/li>\\n<li>Added image placeholder to Tilt Image module<\\/li>\\n<li>Fixed Circle Info Button margin not working<\\/li>\\n<li>Fixed Circle Info icon height issue<\\/li>\\n<li>Fixed Circle Info content switch on mobiles not working<\\/li>\\n<li>Fixed Circle Info icons not displayed in Firefox\\/Safari when icon animation is enabled<\\/li>\\n<li>Fixed Facebook and Google API code causing an error on cron<\\/li>\\n<li>Fixed Panorama responsive height issue<\\/li>\\n<li>Fixed Carousel, Content Toggle &amp; Balloon fatal errors sent to the email after WP autosave is triggered<\\/li>\\n<li>Fixed Carousel pagination responsive settings issue<\\/li>\\n<li>Fixed Carousel arrow navigation not working on mobile devices<\\/li>\\n<li>Fixed Masonry Gallery circle icon issue in builder<\\/li>\\n<li>Fixed Image Hotspot spacing issue in Firefox\\/Safari browsers<\\/li>\\n<li>Updated cron timing frequency for license check (twice daily)<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7 February 23rd 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Info Circle module added<\\/li>\\n<li>Updated Google social media icon<\\/li>\\n<li>Updated Snapchat and TikTok SVG images creating an error<\\/li>\\n<li>Updated Image Hotspot position value step to 0.1<\\/li>\\n<li>Updated hotspot icon line height causing hotspot icon to be not perfectly centred<\\/li>\\n<li>Improved Scroll Image horizontal mouse scroll performance<\\/li>\\n<li>Improved preloader performance<\\/li>\\n<li>Fixed Tilt Image glare effect<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Panorama rendering issues in Divi Builder when the video is used<\\/li>\\n<li>Fixed Panorama height not working when the video is used<\\/li>\\n<li>Fixed Flip Box back button padding not working<\\/li>\\n<li>Fixed Dual Heading module bottom margin and padding not working<\\/li>\\n<li>Fixed Dual Heading text background clipping for the 2nd text not working<\\/li>\\n<li>Fixed Carousel image border radius when box-shadow added not applying properly<\\/li>\\n<li>Fixed custom blog layout style not applying when Theme Builder template is used<\\/li>\\n<li>Fixed Image Slider Divi Library shortcodes not rendering<\\/li>\\n<li>Fixed dropdown arrow displayed on child submenus<\\/li>\\n<li>Fixed Search icon position when CTA Button not used<\\/li>\\n<li>Added support for PHP 8<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6.1 January 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added language settings for Google testimonials<\\/li>\\n<li><strong>NEW:<\\/strong> Added options to Exclude\\/Include Testimonials by Post ID<\\/li>\\n<li><strong>NEW:<\\/strong> Added 9 new animations to the Floating Images module<\\/li>\\n<li>Updated Floating Images position max and min values<\\/li>\\n<li>Fixed Floating Images transition CSS not working<\\/li>\\n<li>Fixed issue with Menu Hover Effect applies to the centred header logo<\\/li>\\n<li>Fixed Blog Slider random order not working<\\/li>\\n<li>Fixed not working link in Carousel child module<\\/li>\\n<li>Removed Carousel button wrapper HTML markup when the button is not used<\\/li>\\n<li>Added Soundcloud and TikTok icons to Social Media settings<\\/li>\\n<li>Added CSS ID &amp; Classes field to the Image Hotspot child module<\\/li>\\n<li>Added dynamic image support for Image Slider module (front-end only)<\\/li>\\n<li>Fixed JS error after searching when post meta section is empty<\\/li>\\n<li>Fixed Image Slider text displayed on sides when 3D Cube mode is used<\\/li>\\n<li>Fixed SVG Animator default width and height not working in Safari browser<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Tilt Image flickering issue in Chrome browser<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6 December 8th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> SVG Animator module added<\\/li>\\n<li>Image Slider thumbnails height various units support added<\\/li>\\n<li>Blog Slider backward PHP (&lt;7.2) compatibility issue fixed<\\/li>\\n<li>custom styles did not apply on paginated blog pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.3 November 26th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\" data-border-radius-top-cap=\\\"false\\\" data-border-radius-bottom-cap=\\\"false\\\">\\n<li><strong>NEW:<\\/strong> Image Accordion Always Visible new settings for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Showcase individual images links feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider featured image animation effects added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel image animation settings added<\\/li>\\n<li><strong>NEW:<\\/strong> All Divi Pixel modules support new Divi icons<\\/li>\\n<li>Carousel new custom CSS for active slide added<\\/li>\\n<li>Blog Slider navigation responsive settings added<\\/li>\\n<li>Blog Slider featured image border and box-shadow customization settings added<\\/li>\\n<li>Blog Slider new Custom CSS fields for navigation and active slide added<\\/li>\\n<li>Blog Slider pagination not working in builder when multiple instances used issue fixed<\\/li>\\n<li>Content Toggle new Custom CSS fields for toggle button added<\\/li>\\n<li>Image Mask shape 7 not displayed properly on front end issue fixed<\\/li>\\n<li>Masonry Gallery Grid Items border not working issue fixed<\\/li>\\n<li>Accordion module not triggered in Carousel module issue fixed<\\/li>\\n<li>Dropdown menu text color not working on fixed header issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.2 October 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 28 new masks added to the Image Mask module<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask selector field improved<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask: option to rotate, scale and flip the mask<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask image Alt Text field added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask upload custom shape option added<\\/li>\\n<li>Image Mask placeholder image added<\\/li>\\n<li>Image Showcase module URL issue fixed<\\/li>\\n<li>Carousel Autoplay stops working when the Pause on Hover option is disabled issue fixed<\\/li>\\n<li>Carousel item doesn\\u2019t take full width when short content is added issue fixed<\\/li>\\n<li>Countdown Timer doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Counter module doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Image Magnifier module doesn\\u2019t work in builder issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1 September 30th 2021<\\/strong><\\/p>\\n<ul>\\n<li>FAQ module categories missed issue fixed<\\/li>\\n<li>Custom preloader not working issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5 September 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Dual Heading module added<\\/li>\\n<li>Mobile Menu on WooCommerce pages issues fixed<\\/li>\\n<li>Blog archive custom style not applying for pagination pages issue fixed<\\/li>\\n<li>Image Hotspot tooltip displaying when border radius on the image is used issue fixed<\\/li>\\n<li>Image Hotspot tooltip image default width not applying in the builder issue fixed<\\/li>\\n<li>Image Hotspot new Ripple Effect style added<\\/li>\\n<li>Image Hotspot default image placeholder added<\\/li>\\n<li>Image Hotspot tooltip spacing in builder issue fixed<\\/li>\\n<li>Improved backwards compatibility with outdated PHP versions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4.2 - September 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider thumbnails margin controls added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider responsive settings for Image Overlay added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider custom thumbnail option added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider custom CSS field for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Slide Image responsive position control added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay hover settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay responsive settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Price List - Price Prefix and Suffix fields added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery image animation options added<\\/li>\\n<li>Custom Map Marker being cropped issue fixed<\\/li>\\n<li>Hover Box double arrow icon issue fixed<\\/li>\\n<li>Testimonial Slider Random order issue fixed<\\/li>\\n<li>Image Showcase in hidden section causing JS error issue fixed<\\/li>\\n<li>Blog Slider active pagination color issue fixed<\\/li>\\n<li>Blog Slider Content custom CSS field added<\\/li>\\n<li>dipi-anim-preload class not removed from the body after the page is loaded issue fixed<\\/li>\\n<li>Image Showcase causing JS error when the module is hidden issue fixed<\\/li>\\n<li>CTA Menu Button text color when Menu module is used issue fixed<\\/li>\\n<li style=\\\"list-style-type: none;\\\"><\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.4.1 August 23rd 2021<\\/strong><\\/p>\\n<p>Divi 4.10+ compatibility<\\/p>\\n<ul>\\n<li>Carousel lightbox functionality issue fixed<\\/li>\\n<li>Masonry Gallery layout grid and lightbox issue fixed<\\/li>\\n<li>Preloader, when Defer jQuery and jQuery Migrate option is enabled issue fixed<\\/li>\\n<li>Image Slider when Defer jQuery and jQuery migrate option is enabled issue fixed<\\/li>\\n<li>Counter module when Dynamic JS Libraries option enabled issue fixed<\\/li>\\n<li>Price List module when Dynamic JS Libraries enabled lightbox issue fixed<\\/li>\\n<li>Testimonial Slider popup when Dynamic JS Libraries enabled issue fixed<\\/li>\\n<li>Conditional Display when Dynamic Module Framework enabled issue fixed<\\/li>\\n<\\/ul>\\n<p>Improvements\\/Fixes<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\"><strong>NEW:<\\/strong> Image Slider Autoplay settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Archive page Style 2 - broken layout on category pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4 August 18th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Hotspot responsive positioning settings added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Open Carousel image in lightbox option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Reverse Carousel slide direction when Autoplay option is enabled<\\/li>\\n<li><strong>NEW:<\\/strong> Price List image lightbox gallery option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Masonry Gallery image link option added<\\/li>\\n<li>Carousel item Box Shadow on hover issue fixed<\\/li>\\n<li>Sidebar customization issues fixed<\\/li>\\n<li>Testimonial Slider heading customization settings added<\\/li>\\n<li>Carousel reloading in builder issue fixed<\\/li>\\n<li>Price List responsive settings for the layout and image added<\\/li>\\n<li>Price List module Box Shadow option to the parent module added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.3.2 July 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li>Related Article hover activation issue fixed<\\/li>\\n<li>Footer social icons when credits are disabled issue fixed<\\/li>\\n<li>Menu CTA button - menu selection issue fixed<\\/li>\\n<li>Image Hotspot - tooltip button when Trigger on Click is enabled issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.3.1 July 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Menu CTA Button - option for selecting menu added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Showcase - 11 new mockups added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box text line-height default values fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs alignment responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Divi Builder plugin &amp; Extra theme compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Exclude Posts option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive Featured Image border-radius option added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p>2.3 July 7th 2021<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> FAQ module with Google Structured Data added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider - category class added for single post box<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.5 June 30th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added new Section, Row and Module settings to conditionally display content based on users role or a login status<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Suppress Filters option is added to use the attempted filter by other 3rd party plugins (like WPML)<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mobile Menu Hamburger icon browser compatibility improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline card width when the icon is used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module PHP 7.2 compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Rename Projects tab category slug issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.4 June 18th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">duplicated logo when multiple Theme Builder headers are used issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.3 June 16th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> apply blog archive style to the native Divi Blog module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> select image size for the Blog Slider module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Divi Library Shortcodes to use in any module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Option to hide \\u201cEdit in Visual Builder\\u201d link on pages\\/posts overview dashboard pages<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial Read More popup font customization settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider \\u201cOrder By\\u201d settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - hide tooltip option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - link field to the hotspot child added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot isn\\u2019t interactive anymore issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider HTML markup displayed for disabled elements issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Accordion TinyMCE editor support added for the description field<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image responsive scroll speed settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Panorama 2D Image mode scroll issue on tablets and mobiles fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider responsive settings for navigation size and padding added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider - testimonials order settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More link disabled when a full testimonial is displayed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mega Menu width issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Read More Button Text\\u201d doesn\\u2019t apply to the native Divi Blog module issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d doesn\\u2019t apply to the Theme Builder custom header issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Collapsed mobile top menu not clickable issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module visibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module displaying on archive pages issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs separator alignment issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Lottie Icon width not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Content Toggle\\/Masonry Gallery compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Full-width post does not display full-width sections in frontend Divi Builder issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.2 April 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: open tooltip on click<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: tooltip animations added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Carousel - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module margin in Divi Builder modules list issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Ballon button link target issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">plugin settings modules list updated<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider HTML support for review text added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image content animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon button shadow not applying in builder properly issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider not working with Blog module when testimonial CPT is selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module fetches taxonomy from pages where taxonomy is not added issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline line border styles issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial custom CSS for Profile Image selector fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.1 April 2nd, 2021<\\/strong><\\/p>\\n<ul>\\n<li>plugin updater issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.0 April 1st, 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Ballon module added<\\/li>\\n<li>Blog Slider item not clickable in Firefox browser issue fixed<\\/li>\\n<li>Content Toggle et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li>Content Toggle and Image Showcase compatibility improved<\\/li>\\n<li>Testimonial Slider popup\\/Divi Machine conflict issue fixed<\\/li>\\n<li>API licensing UI and functionality improved<\\/li>\\n<li>Documentation pages UI improved<\\/li>\\n<\\/ul>\\n<p><strong>2.1.2 March 8th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">Content Toggle issue with dipi_label function issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module dipi_label function replaced with esc_html__ function<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.1 March 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Disable LazyLoad in Content Toggle module settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Enable Lightbox responsive settings issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Plugin Settings\\/Modules options updated<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.0 - February 25th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Content Toggle module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Archive section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Post Navigation section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Author Box section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Related Articles section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Disable Lightbox responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d in Firefox displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d ON\\/OFF builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box circle icon issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box WPML support improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image\\/Icon alignment in Timeline not working in Divi Builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel Autoplay option doesn\\u2019t work in Safari issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel items displayed vertically in Safari 8 issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel child item hover icon not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Button Grid on mobiles improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Floating Images Transform settings not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box height controls improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box solid border issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase rendering with WP Rocket Lazy Loading in different browsers issues fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image mouse scrolling improved<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.0.1 - February 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW: <\\/strong>Masonry Gallery Coverflow Animations<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Masonry Gallery - disable image lightbox option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box jQuery variable naming issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">CSS error preventing Divi scripts from compile issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text child module link issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion image responsive settings improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image Active On Load and Open On Click issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">fonts in Theme Customizer did not enqueue issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.0.0 - January 26th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Timeline module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added CSS ID &amp; Classes to Button Grid child modules<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> WhatsApp, Snapchat and Xing social media icons added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Active Image size responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Opened on Load responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Performance improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Mask SVG markup issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase - image positioning tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Primary Header Social Icons positioning when CTA Button is not used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery image width causing the problem with the proper displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Button displaying multiple icons when icon not selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default content-length value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default spacing value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Error messages when Google reviews are fetched corrected<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image arrow color rendering in builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box name improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text alignment settings revised<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup displaying mixed testimonials issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup image styling issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.3 - December 16th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>collapsed mobile menu close animation fixed<\\/li>\\n<li>dropdown menu width max value increased<\\/li>\\n<li>Hamburger Mobile Menu not displayed after WP 5.6 issue fixed<\\/li>\\n<li>minor code improvements in Panorama and Lottie modules<\\/li>\\n<li>Carousel Coverflow mode - disabled slide shadow issue fixed<\\/li>\\n<li>Duplicated Social Icons in Primary Header issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.2 - December 7th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Breadcrumbs active item styles missed on front-end issue fixed<\\/li>\\n<li>Dropdown menu item width control added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.1 - December 5th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Carousel spacing issue fixed<\\/li>\\n<li>plugin package\\/2 new modules Divi Builder rendering issues fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.0 - December 4th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Showcase module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask module added<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS Class field added to the header CTA button<\\/li>\\n<li><strong>NEW:<\\/strong> Divi Builder support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Extra theme support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Post Type\\/Taxonomy settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Alignment settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Dynamic button URL to Grid Button module added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel module CSS ID &amp; Classes added to child items<\\/li>\\n<li>Vertical Navigation style issues fixed<\\/li>\\n<li>Testimonial Slider overflow issue fixed<\\/li>\\n<li>Mobile Menu animation out when Theme Builder header used issue fixed<\\/li>\\n<li>Blog Archive responsive breakpoint updated<\\/li>\\n<li>Hotspot tooltip height on mobiles issue fixed<\\/li>\\n<li>Blog Slider body text and button box-shadow issues fixed<\\/li>\\n<li>Admin Label field added to the Carousel child modules<\\/li>\\n<li>Tooltip image wrapper if image not selected - HTML markup not displayed<\\/li>\\n<li>Post meta alignment on archive page issue fixed<\\/li>\\n<li>Tilt Image mobile height issue fixed<\\/li>\\n<li>Footer Reveal Effect visibility in the front-end builder issue fixed<\\/li>\\n<li>Hide Admin Bar setting issue fixed<\\/li>\\n<li>Hide Admin Bar\\/Hide Top Header\\/Reading Progress Bar issues fixed<\\/li>\\n<li>Breadcrumbs Schema Markup issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.9 - 14 October 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Mobile Submenu customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Collapsed Mobile menu icon customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Circle animation for Mobile Menu background overlay added<\\/li>\\n<li>Menu Dropdown visibility with Theme Builder Header and Footer Reveal Effect enabled issue fixed<\\/li>\\n<li>default Mobile Menu animation performance issue fixed<\\/li>\\n<li>Centered Inline Logo header alignment fixed<\\/li>\\n<li>Centered header hamburger icon position fixed<\\/li>\\n<li>Stand and Spring style Hamburger icon animation issues fixed<\\/li>\\n<li>Fixed Mobile Menu container gap issue on mobiles fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.2 - 28th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>NEW: Add Arrow to Dropdown Menus<\\/li>\\n<li>NEW: Dropdown Menu width and position controls added<\\/li>\\n<li>NEW: Open Menu Button Link in a New Window option added<\\/li>\\n<li>Header Height\\/Spacing issues fixed<\\/li>\\n<li>Hide Top Bar feature improved<\\/li>\\n<li>Do Not Shrink Header on Scroll feature improved<\\/li>\\n<li>Social Icons in Secondary Menu Firefox issue fixed<\\/li>\\n<li>CTA Menu Button Position First\\/Last issue fixed<\\/li>\\n<li>Centered\\/Centered Inline header style issues fixed<\\/li>\\n<li>Top Bar performance on mobiles improved<\\/li>\\n<li>Mobile Menu paddings issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.1 - 15th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Fixed duplicated hamburger icons when more than one menu was used on a page<\\/li>\\n<li>Do Not Shrink Header functionality improved<\\/li>\\n<\\/ul>\\n<p><strong>1.8 - 13th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Magnifier module<\\/li>\\n<li><strong>NEW:<\\/strong> Lottie Icon module<\\/li>\\n<li>Plugin Settings page responsive issues fixed<\\/li>\\n<li>Plugin Settings Page Toolbar added<\\/li>\\n<li>Hide Admin Bar when user not logged in issue fixed<\\/li>\\n<li>Archive Page Header Injector issue fixed<\\/li>\\n<li>Bottom Bar customization issues fixed<\\/li>\\n<li>Back To Top custom link issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.7.1 - 28th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Panorama module PHP error for older PHP versions<\\/li>\\n<\\/ul>\\n<p><strong>1.7 - 27th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Panorama module<\\/li>\\n<li><strong>NEW:<\\/strong> Reading Progress Bar module<\\/li>\\n<li><strong>NEW:<\\/strong> Google icon to Social Icons added<\\/li>\\n<li>SVG image upload feature improved<\\/li>\\n<li>Force Footer to Bottom when Theme Builder used issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.6.2 - 20th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed an issue with social icons individual locations<\\/li>\\n<li>Fixed an issue with the revealing footer effect<\\/li>\\n<\\/ul>\\n<p><strong>1.6.1 - 15th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue in Divi Pixel options panel (WordPress 5.5 compatibility)<\\/li>\\n<li>Fixed an issue where individual social icon locations would break the menus<\\/li>\\n<\\/ul>\\n<p><strong>1.6.0 - 12th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Scrollable Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt text field added for Hover Box images<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Accordion Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS fields added to Accordion Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Tilt Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Hotspot Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List configurable HTML title tag option added<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Label field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Fixed responsive flex settings for Button Grid and added options for alignment and justification<\\/li>\\n<li><strong>NEW:<\\/strong> Login Page custom logo URL option added<\\/li>\\n<li><strong>NEW:<\\/strong> option to add links to images in Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> SVG image preview in Media Library added<\\/li>\\n<li>Tilt Image title customization issue fixed<\\/li>\\n<li>fixed issue with Theme Customizer scripts not loading on FlyWheel hosted sites<\\/li>\\n<li>Hover Box displaying empty heading tags issue fixed<\\/li>\\n<li>duplicated Prefix and Suffix spans in Typing Text module issue fixed<\\/li>\\n<li>Login Page logo size default values fixed<\\/li>\\n<li>Added option to Masonry Gallery to enable lazy loading images compatibility<\\/li>\\n<li>Automatically scroll to the top of the Divi Pixel options page after switching tabs<\\/li>\\n<li>Fixed Masonry Gallery not opening images in a lightbox<\\/li>\\n<li>Accordion Image responsive spacing issue fixed<\\/li>\\n<li>Carousel box-shadow and border child module issue fixed<\\/li>\\n<li>Carousel module left navigation positioning issue in builder fixed<\\/li>\\n<li>Flip Box content displaying issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.5.0 - 8th May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Accordion Module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box: added option to force the module to be a square<\\/li>\\n<li>Fixed \\\"open in new window\\\" option in various modules<\\/li>\\n<li>Improved SVG upload functionality to allow different mime types<\\/li>\\n<li>Fixed Related Articles and Author Box when Theme Builder is used<\\/li>\\n<li>Fixed Blog Slider default columns on tablet and mobiles<\\/li>\\n<li>Fixed \\\"Related Articles\\\" heading, which was sometimes displayed on custom post types<\\/li>\\n<li>Fixed Flex Direction responsive options in Typing Text module<\\/li>\\n<li>Fixed Image Hotspot heading level option in Visual Builder<\\/li>\\n<li>Fixed various typos<\\/li>\\n<li>Added some semicolons here and there to spice up the code (and fix some issues)<\\/li>\\n<\\/ul>\\n<p><strong>1.4.4 - 31st May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Flip Box Dynamic Height option added<\\/li>\\n<li><strong>NEW:<\\/strong> Flip Box: force module to be a square option added<\\/li>\\n<li>Flip Box Image Overlay builder issue fixed<\\/li>\\n<li>Flip Box icon not displayed on front-end issue fixed<\\/li>\\n<li>Primary Menu customization when Menu Hover Animation disabled issue fixed<\\/li>\\n<li>Masonry Gallery: IE browser issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.3 - 27th May 2020<\\/strong><\\/p>\\n<ul>\\n<li>Flip Box: height issue fixed<\\/li>\\n<li>Flip Box: Back Button not displayed on front-end issue fixed<\\/li>\\n<li>Flip Box: 3D Content Effect issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.2 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Flip Box module: Dynamic Height option removed<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.1 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Plugin Settings\\/Modules section updated<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.0 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Fancy Text module added<\\/li>\\n<li>Breadcrumbs Module: responsive padding options added<\\/li>\\n<li>Breadcrumbs: separator icon issue fixed<\\/li>\\n<li>Back To Top Button: box-shadow issue on hover fixed<\\/li>\\n<li>Back To Top Button: custom link issue fixed<\\/li>\\n<li>Menu CTA Button: hover text\\/background issue fixed<\\/li>\\n<li>Secondary Header menu\\/social icons positioning issue fixed<\\/li>\\n<li>Button Grid: icon size and positioning fixed<\\/li>\\n<li>Blog Archive: meta text icons positioning fixed<\\/li>\\n<li>Blog Slider image clickable option added<\\/li>\\n<li>Blog Slider: responsive image height option added<\\/li>\\n<li>Mobile Menu: Theme Builder header issues fixed<\\/li>\\n<li>Custom Mobile Breakpoint: all menu customization settings revised and improved<\\/li>\\n<li>Login Page: form field text size option added<\\/li>\\n<li>Login Page: logo size issue fixed, logo height option added<\\/li>\\n<li>Related Articles: section title font size issue fixed<\\/li>\\n<li>Testimonial Slider: read more popup size on mobiles issue fixed<\\/li>\\n<li>Header Menu: customization setting improved<\\/li>\\n<li>Hover Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Hover Box: module not displayed in Builder\\/Firefox issue fixed<\\/li>\\n<li>Hover Box: responsive height fixed<\\/li>\\n<li>Flip Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Image Hotspot, Hover Box, Flip Box, Carousel, Tilt Image: configurable HTML title tag option added<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.3.1 - 26th April 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed a bunch of smaller bugs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.0 - 20th April 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Blog Slider module<\\/li>\\n<li><strong>NEW<\\/strong>: Animation Delay option in Counter module<\\/li>\\n<li><strong>NEW:<\\/strong> Option to enable beta downloads<\\/li>\\n<li>Mobile Menu issue fixed<\\/li>\\n<li>Header\\/Menu Animation issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0 - 26th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Countdown module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box module<\\/li>\\n<li>Force Footer to Bottom Firefox issue fixed<\\/li>\\n<li>Filled Background menu animation style Firefox issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0 - 16th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Hotspot module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Export\\/Import functionality added to the Divi Pixel options panel<\\/li>\\n<li>Back to top button functionality improved<\\/li>\\n<li>Testimonial Slider mobile issues fixed<\\/li>\\n<li>Testimonial Slider Website URL field added<\\/li>\\n<li>The improved license activation process<\\/li>\\n<li>Licensing API Library updated<\\/li>\\n<\\/ul>\\n<p><strong>1.0.0 - 4th March 2020<\\/strong><\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/www.divi-pixel.com\\/wp-content\\/uploads\\/2020\\/03\\/dp-affiliate-banner-02-128x128.png\",\"2x\":\"https:\\/\\/www.divi-pixel.com\\/wp-content\\/uploads\\/2020\\/03\\/dp-affiliate-banner-02-256x256.png\"},\"msg\":\"No license key has been provided.\",\"description\":[\"<p>[et_pb_section fb_built=\\\"1\\\" admin_label=\\\"section\\\" _builder_version=\\\"4.16\\\" global_colors_info=\\\"{}\\\"][et_pb_row admin_label=\\\"row\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"][et_pb_column type=\\\"4_4\\\" _builder_version=\\\"4.16\\\" custom_padding=\\\"|||\\\" global_colors_info=\\\"{}\\\" custom_padding__hover=\\\"|||\\\"][et_pb_text admin_label=\\\"Text\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"]<br \\/>\\nDivi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals. Create amazing websites using powerful Divi Pixels modules and settings.<br \\/>\\n[\\/et_pb_text][\\/et_pb_column][\\/et_pb_row][\\/et_pb_section]<\\/p>\\n\"],\"changelog\":[\"<p><strong>2.13.0 - June 8th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added Text Highlighter module<\\/li>\\n<li>Added option to select the active tab on load in Advanced Tabs module<\\/li>\\n<li>Added ordering settings to Masonry Gallery module<\\/li>\\n<li>Fixed particles background issue when parallax option is enabled<\\/li>\\n<li>Fixed Theme Customizer toggles not displaying the correct value<\\/li>\\n<li>Fixed button icons not working when the Dynamic CSS is enabled<\\/li>\\n<li>Fixed Carousel button link dynamic option<\\/li>\\n<li>Fixed collapsed submenu not working when Theme Builder Menu module used<\\/li>\\n<li>Fixed Timeline animations not working in Firefox and Safari browsers<\\/li>\\n<li>Fixed not loading Divi Pixel font when the user is logged in<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.12.0 - May 26th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Particles Background effect<\\/li>\\n<li>Fixed Hotspot Image unwanted square element displayed below module when Lazy Load is used<\\/li>\\n<li>Added animation settings to child modules in the Timeline module<\\/li>\\n<li>Added Image Slider heading customization settings for H tags placed in description<\\/li>\\n<li>Updated PHP 8 depreciated functions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.11.0 - May 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Expanding CTA module<\\/li>\\n<li>Fixed Advanced Tabs button target issue<\\/li>\\n<li>Fixed Image Gallery navigation issue when used in Advanced Tabs module<\\/li>\\n<li>Fixed Carousel description HTML markup displayed when not used<\\/li>\\n<li>Fixed Carousel image box-shadow issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.10 - May 9th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Maintenance Mode feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Allow TTF, OTF and WOFF file uploads<\\/li>\\n<li>Fixed Image Slider issue when used in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.9 - May 5th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Horizontal Timeline module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added option to add overlay image for Scroll Image module and set reveal effect<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added Animate in Viewport and Delay options to the Lottie Icon module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added reverse direction animation for autorotate option in Info Circle module<\\/li>\\n<li>Improved JavaScript for Balloon module to address issues when used in Theme Builder<\\/li>\\n<li>Added Telegram social media icon<\\/li>\\n<li>Added link customization settings to FAQ module<\\/li>\\n<li>Added Carousel image\\/icon hover option<\\/li>\\n<li>Fixed Floating Images animations not working in Safari and iOS 15.4.1<\\/li>\\n<li>Fixed Fancy Text prefix goes out of the screen issue<\\/li>\\n<li>Fixed Dual Heading background text displayed in Divi Builder when not used<\\/li>\\n<li>Fixed Advanced Tabs Divi Library item width issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.8 - April 25th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Advanced Tabs module<\\/li>\\n<li>Fixed Image Slider custom thumbnails not displayed on front-end<\\/li>\\n<li>Fixed Image Slider title formatting and HTML tag displayed on front-end<\\/li>\\n<li>Fixed Image Hotspot mobile issue<\\/li>\\n<li>Fixed Image Hotspot box shadow and border-radius issue<\\/li>\\n<li>Fixed Hover Box and Flip Box gradient migration issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.2 - April 13th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Author Box and Menu CTA Button font issue<\\/li>\\n<li>Fixed Panorama video controls not working in Safari browser<\\/li>\\n<li>Fixed Panorama default height value not working<\\/li>\\n<li>Fixed Image Slider custom navigation not displayed on the frontend<\\/li>\\n<li>Fixed Divi Pixel settings import issue<\\/li>\\n<li>Fixed Masonry Gallery icon border not working<\\/li>\\n<li>Fixed Dual Heading background animation issue<\\/li>\\n<li>Fixed module link not working in Balloon module<\\/li>\\n<li>Fixed dropdown link background color not working with Theme Builder header<\\/li>\\n<li>Added multi-select field for CTA menu button<\\/li>\\n<li>Added gradient migration for new gradient builder to retain old values<\\/li>\\n<li>Added dynamic images and content to Before &amp; After Slider module<\\/li>\\n<li>Added dynamic content fields to the Grid Button module<\\/li>\\n<li>Added dynamic labels to the Content Toggle module<\\/li>\\n<li>Added dynamic prefix and suffix fields to the Counter module<\\/li>\\n<li>Added dynamic heading content to the Dual Heading module<\\/li>\\n<li>Added dynamic fields for prefix and suffix in Fancy Text module<\\/li>\\n<li>Added dynamic image and image link fields to the Floating Images module<\\/li>\\n<li>Added dynamic image and content fields to Accordion Image module<\\/li>\\n<li>Added dynamic images and content fields to the Image Hotspot module<\\/li>\\n<li>Added dynamic images and content fields to the Balloon module<\\/li>\\n<li>Added dynamic images and content fields to the Carousel module<\\/li>\\n<li>Added dynamic images and content fields to the Flip Box module<\\/li>\\n<li>Added dynamic images and content fields to the Hover Box module<\\/li>\\n<li>Added dynamic images fields to the Image Magnifier module<\\/li>\\n<li>Added dynamic images fields to the Image Mask module<\\/li>\\n<li>Added dynamic images fields to the Image Showcase module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.1 - April 6th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Added Projects category and tag slug options<\\/li>\\n<li>Added CSS ID &amp; Classes fields to Image Accordion child items<\\/li>\\n<li>Added Half Circle option to the Counter module<\\/li>\\n<li>Added new gradient support to Divi Pixel modules<\\/li>\\n<li>Added image placeholder to Tilt Image module<\\/li>\\n<li>Fixed Circle Info Button margin not working<\\/li>\\n<li>Fixed Circle Info icon height issue<\\/li>\\n<li>Fixed Circle Info content switch on mobiles not working<\\/li>\\n<li>Fixed Circle Info icons not displayed in Firefox\\/Safari when icon animation is enabled<\\/li>\\n<li>Fixed Facebook and Google API code causing an error on cron<\\/li>\\n<li>Fixed Panorama responsive height issue<\\/li>\\n<li>Fixed Carousel, Content Toggle &amp; Balloon fatal errors sent to the email after WP autosave is triggered<\\/li>\\n<li>Fixed Carousel pagination responsive settings issue<\\/li>\\n<li>Fixed Carousel arrow navigation not working on mobile devices<\\/li>\\n<li>Fixed Masonry Gallery circle icon issue in builder<\\/li>\\n<li>Fixed Image Hotspot spacing issue in Firefox\\/Safari browsers<\\/li>\\n<li>Updated cron timing frequency for license check (twice daily)<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7 February 23rd 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Info Circle module added<\\/li>\\n<li>Updated Google social media icon<\\/li>\\n<li>Updated Snapchat and TikTok SVG images creating an error<\\/li>\\n<li>Updated Image Hotspot position value step to 0.1<\\/li>\\n<li>Updated hotspot icon line height causing hotspot icon to be not perfectly centred<\\/li>\\n<li>Improved Scroll Image horizontal mouse scroll performance<\\/li>\\n<li>Improved preloader performance<\\/li>\\n<li>Fixed Tilt Image glare effect<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Panorama rendering issues in Divi Builder when the video is used<\\/li>\\n<li>Fixed Panorama height not working when the video is used<\\/li>\\n<li>Fixed Flip Box back button padding not working<\\/li>\\n<li>Fixed Dual Heading module bottom margin and padding not working<\\/li>\\n<li>Fixed Dual Heading text background clipping for the 2nd text not working<\\/li>\\n<li>Fixed Carousel image border radius when box-shadow added not applying properly<\\/li>\\n<li>Fixed custom blog layout style not applying when Theme Builder template is used<\\/li>\\n<li>Fixed Image Slider Divi Library shortcodes not rendering<\\/li>\\n<li>Fixed dropdown arrow displayed on child submenus<\\/li>\\n<li>Fixed Search icon position when CTA Button not used<\\/li>\\n<li>Added support for PHP 8<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6.1 January 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added language settings for Google testimonials<\\/li>\\n<li><strong>NEW:<\\/strong> Added options to Exclude\\/Include Testimonials by Post ID<\\/li>\\n<li><strong>NEW:<\\/strong> Added 9 new animations to the Floating Images module<\\/li>\\n<li>Updated Floating Images position max and min values<\\/li>\\n<li>Fixed Floating Images transition CSS not working<\\/li>\\n<li>Fixed issue with Menu Hover Effect applies to the centred header logo<\\/li>\\n<li>Fixed Blog Slider random order not working<\\/li>\\n<li>Fixed not working link in Carousel child module<\\/li>\\n<li>Removed Carousel button wrapper HTML markup when the button is not used<\\/li>\\n<li>Added Soundcloud and TikTok icons to Social Media settings<\\/li>\\n<li>Added CSS ID &amp; Classes field to the Image Hotspot child module<\\/li>\\n<li>Added dynamic image support for Image Slider module (front-end only)<\\/li>\\n<li>Fixed JS error after searching when post meta section is empty<\\/li>\\n<li>Fixed Image Slider text displayed on sides when 3D Cube mode is used<\\/li>\\n<li>Fixed SVG Animator default width and height not working in Safari browser<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Tilt Image flickering issue in Chrome browser<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6 December 8th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> SVG Animator module added<\\/li>\\n<li>Image Slider thumbnails height various units support added<\\/li>\\n<li>Blog Slider backward PHP (&lt;7.2) compatibility issue fixed<\\/li>\\n<li>custom styles did not apply on paginated blog pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.3 November 26th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\" data-border-radius-top-cap=\\\"false\\\" data-border-radius-bottom-cap=\\\"false\\\">\\n<li><strong>NEW:<\\/strong> Image Accordion Always Visible new settings for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Showcase individual images links feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider featured image animation effects added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel image animation settings added<\\/li>\\n<li><strong>NEW:<\\/strong> All Divi Pixel modules support new Divi icons<\\/li>\\n<li>Carousel new custom CSS for active slide added<\\/li>\\n<li>Blog Slider navigation responsive settings added<\\/li>\\n<li>Blog Slider featured image border and box-shadow customization settings added<\\/li>\\n<li>Blog Slider new Custom CSS fields for navigation and active slide added<\\/li>\\n<li>Blog Slider pagination not working in builder when multiple instances used issue fixed<\\/li>\\n<li>Content Toggle new Custom CSS fields for toggle button added<\\/li>\\n<li>Image Mask shape 7 not displayed properly on front end issue fixed<\\/li>\\n<li>Masonry Gallery Grid Items border not working issue fixed<\\/li>\\n<li>Accordion module not triggered in Carousel module issue fixed<\\/li>\\n<li>Dropdown menu text color not working on fixed header issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.2 October 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 28 new masks added to the Image Mask module<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask selector field improved<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask: option to rotate, scale and flip the mask<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask image Alt Text field added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask upload custom shape option added<\\/li>\\n<li>Image Mask placeholder image added<\\/li>\\n<li>Image Showcase module URL issue fixed<\\/li>\\n<li>Carousel Autoplay stops working when the Pause on Hover option is disabled issue fixed<\\/li>\\n<li>Carousel item doesn\\u2019t take full width when short content is added issue fixed<\\/li>\\n<li>Countdown Timer doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Counter module doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Image Magnifier module doesn\\u2019t work in builder issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1 September 30th 2021<\\/strong><\\/p>\\n<ul>\\n<li>FAQ module categories missed issue fixed<\\/li>\\n<li>Custom preloader not working issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5 September 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Dual Heading module added<\\/li>\\n<li>Mobile Menu on WooCommerce pages issues fixed<\\/li>\\n<li>Blog archive custom style not applying for pagination pages issue fixed<\\/li>\\n<li>Image Hotspot tooltip displaying when border radius on the image is used issue fixed<\\/li>\\n<li>Image Hotspot tooltip image default width not applying in the builder issue fixed<\\/li>\\n<li>Image Hotspot new Ripple Effect style added<\\/li>\\n<li>Image Hotspot default image placeholder added<\\/li>\\n<li>Image Hotspot tooltip spacing in builder issue fixed<\\/li>\\n<li>Improved backwards compatibility with outdated PHP versions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4.2 - September 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider thumbnails margin controls added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider responsive settings for Image Overlay added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider custom thumbnail option added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider custom CSS field for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Slide Image responsive position control added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay hover settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay responsive settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Price List - Price Prefix and Suffix fields added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery image animation options added<\\/li>\\n<li>Custom Map Marker being cropped issue fixed<\\/li>\\n<li>Hover Box double arrow icon issue fixed<\\/li>\\n<li>Testimonial Slider Random order issue fixed<\\/li>\\n<li>Image Showcase in hidden section causing JS error issue fixed<\\/li>\\n<li>Blog Slider active pagination color issue fixed<\\/li>\\n<li>Blog Slider Content custom CSS field added<\\/li>\\n<li>dipi-anim-preload class not removed from the body after the page is loaded issue fixed<\\/li>\\n<li>Image Showcase causing JS error when the module is hidden issue fixed<\\/li>\\n<li>CTA Menu Button text color when Menu module is used issue fixed<\\/li>\\n<li style=\\\"list-style-type: none;\\\"><\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.4.1 August 23rd 2021<\\/strong><\\/p>\\n<p>Divi 4.10+ compatibility<\\/p>\\n<ul>\\n<li>Carousel lightbox functionality issue fixed<\\/li>\\n<li>Masonry Gallery layout grid and lightbox issue fixed<\\/li>\\n<li>Preloader, when Defer jQuery and jQuery Migrate option is enabled issue fixed<\\/li>\\n<li>Image Slider when Defer jQuery and jQuery migrate option is enabled issue fixed<\\/li>\\n<li>Counter module when Dynamic JS Libraries option enabled issue fixed<\\/li>\\n<li>Price List module when Dynamic JS Libraries enabled lightbox issue fixed<\\/li>\\n<li>Testimonial Slider popup when Dynamic JS Libraries enabled issue fixed<\\/li>\\n<li>Conditional Display when Dynamic Module Framework enabled issue fixed<\\/li>\\n<\\/ul>\\n<p>Improvements\\/Fixes<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\"><strong>NEW:<\\/strong> Image Slider Autoplay settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Archive page Style 2 - broken layout on category pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4 August 18th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Hotspot responsive positioning settings added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Open Carousel image in lightbox option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Reverse Carousel slide direction when Autoplay option is enabled<\\/li>\\n<li><strong>NEW:<\\/strong> Price List image lightbox gallery option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Masonry Gallery image link option added<\\/li>\\n<li>Carousel item Box Shadow on hover issue fixed<\\/li>\\n<li>Sidebar customization issues fixed<\\/li>\\n<li>Testimonial Slider heading customization settings added<\\/li>\\n<li>Carousel reloading in builder issue fixed<\\/li>\\n<li>Price List responsive settings for the layout and image added<\\/li>\\n<li>Price List module Box Shadow option to the parent module added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.3.2 July 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li>Related Article hover activation issue fixed<\\/li>\\n<li>Footer social icons when credits are disabled issue fixed<\\/li>\\n<li>Menu CTA button - menu selection issue fixed<\\/li>\\n<li>Image Hotspot - tooltip button when Trigger on Click is enabled issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.3.1 July 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Menu CTA Button - option for selecting menu added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Showcase - 11 new mockups added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box text line-height default values fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs alignment responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Divi Builder plugin &amp; Extra theme compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Exclude Posts option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive Featured Image border-radius option added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p>2.3 July 7th 2021<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> FAQ module with Google Structured Data added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider - category class added for single post box<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.5 June 30th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added new Section, Row and Module settings to conditionally display content based on users role or a login status<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Suppress Filters option is added to use the attempted filter by other 3rd party plugins (like WPML)<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mobile Menu Hamburger icon browser compatibility improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline card width when the icon is used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module PHP 7.2 compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Rename Projects tab category slug issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.4 June 18th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">duplicated logo when multiple Theme Builder headers are used issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.3 June 16th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> apply blog archive style to the native Divi Blog module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> select image size for the Blog Slider module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Divi Library Shortcodes to use in any module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Option to hide \\u201cEdit in Visual Builder\\u201d link on pages\\/posts overview dashboard pages<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial Read More popup font customization settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider \\u201cOrder By\\u201d settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - hide tooltip option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - link field to the hotspot child added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot isn\\u2019t interactive anymore issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider HTML markup displayed for disabled elements issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Accordion TinyMCE editor support added for the description field<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image responsive scroll speed settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Panorama 2D Image mode scroll issue on tablets and mobiles fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider responsive settings for navigation size and padding added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider - testimonials order settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More link disabled when a full testimonial is displayed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mega Menu width issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Read More Button Text\\u201d doesn\\u2019t apply to the native Divi Blog module issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d doesn\\u2019t apply to the Theme Builder custom header issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Collapsed mobile top menu not clickable issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module visibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module displaying on archive pages issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs separator alignment issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Lottie Icon width not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Content Toggle\\/Masonry Gallery compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Full-width post does not display full-width sections in frontend Divi Builder issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.2 April 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: open tooltip on click<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: tooltip animations added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Carousel - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module margin in Divi Builder modules list issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Ballon button link target issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">plugin settings modules list updated<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider HTML support for review text added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image content animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon button shadow not applying in builder properly issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider not working with Blog module when testimonial CPT is selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module fetches taxonomy from pages where taxonomy is not added issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline line border styles issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial custom CSS for Profile Image selector fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.1 April 2nd, 2021<\\/strong><\\/p>\\n<ul>\\n<li>plugin updater issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.0 April 1st, 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Ballon module added<\\/li>\\n<li>Blog Slider item not clickable in Firefox browser issue fixed<\\/li>\\n<li>Content Toggle et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li>Content Toggle and Image Showcase compatibility improved<\\/li>\\n<li>Testimonial Slider popup\\/Divi Machine conflict issue fixed<\\/li>\\n<li>API licensing UI and functionality improved<\\/li>\\n<li>Documentation pages UI improved<\\/li>\\n<\\/ul>\\n<p><strong>2.1.2 March 8th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">Content Toggle issue with dipi_label function issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module dipi_label function replaced with esc_html__ function<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.1 March 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Disable LazyLoad in Content Toggle module settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Enable Lightbox responsive settings issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Plugin Settings\\/Modules options updated<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.0 - February 25th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Content Toggle module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Archive section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Post Navigation section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Author Box section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Related Articles section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Disable Lightbox responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d in Firefox displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d ON\\/OFF builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box circle icon issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box WPML support improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image\\/Icon alignment in Timeline not working in Divi Builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel Autoplay option doesn\\u2019t work in Safari issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel items displayed vertically in Safari 8 issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel child item hover icon not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Button Grid on mobiles improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Floating Images Transform settings not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box height controls improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box solid border issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase rendering with WP Rocket Lazy Loading in different browsers issues fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image mouse scrolling improved<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.0.1 - February 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW: <\\/strong>Masonry Gallery Coverflow Animations<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Masonry Gallery - disable image lightbox option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box jQuery variable naming issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">CSS error preventing Divi scripts from compile issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text child module link issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion image responsive settings improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image Active On Load and Open On Click issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">fonts in Theme Customizer did not enqueue issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.0.0 - January 26th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Timeline module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added CSS ID &amp; Classes to Button Grid child modules<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> WhatsApp, Snapchat and Xing social media icons added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Active Image size responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Opened on Load responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Performance improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Mask SVG markup issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase - image positioning tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Primary Header Social Icons positioning when CTA Button is not used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery image width causing the problem with the proper displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Button displaying multiple icons when icon not selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default content-length value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default spacing value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Error messages when Google reviews are fetched corrected<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image arrow color rendering in builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box name improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text alignment settings revised<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup displaying mixed testimonials issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup image styling issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.3 - December 16th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>collapsed mobile menu close animation fixed<\\/li>\\n<li>dropdown menu width max value increased<\\/li>\\n<li>Hamburger Mobile Menu not displayed after WP 5.6 issue fixed<\\/li>\\n<li>minor code improvements in Panorama and Lottie modules<\\/li>\\n<li>Carousel Coverflow mode - disabled slide shadow issue fixed<\\/li>\\n<li>Duplicated Social Icons in Primary Header issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.2 - December 7th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Breadcrumbs active item styles missed on front-end issue fixed<\\/li>\\n<li>Dropdown menu item width control added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.1 - December 5th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Carousel spacing issue fixed<\\/li>\\n<li>plugin package\\/2 new modules Divi Builder rendering issues fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.0 - December 4th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Showcase module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask module added<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS Class field added to the header CTA button<\\/li>\\n<li><strong>NEW:<\\/strong> Divi Builder support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Extra theme support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Post Type\\/Taxonomy settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Alignment settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Dynamic button URL to Grid Button module added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel module CSS ID &amp; Classes added to child items<\\/li>\\n<li>Vertical Navigation style issues fixed<\\/li>\\n<li>Testimonial Slider overflow issue fixed<\\/li>\\n<li>Mobile Menu animation out when Theme Builder header used issue fixed<\\/li>\\n<li>Blog Archive responsive breakpoint updated<\\/li>\\n<li>Hotspot tooltip height on mobiles issue fixed<\\/li>\\n<li>Blog Slider body text and button box-shadow issues fixed<\\/li>\\n<li>Admin Label field added to the Carousel child modules<\\/li>\\n<li>Tooltip image wrapper if image not selected - HTML markup not displayed<\\/li>\\n<li>Post meta alignment on archive page issue fixed<\\/li>\\n<li>Tilt Image mobile height issue fixed<\\/li>\\n<li>Footer Reveal Effect visibility in the front-end builder issue fixed<\\/li>\\n<li>Hide Admin Bar setting issue fixed<\\/li>\\n<li>Hide Admin Bar\\/Hide Top Header\\/Reading Progress Bar issues fixed<\\/li>\\n<li>Breadcrumbs Schema Markup issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.9 - 14 October 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Mobile Submenu customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Collapsed Mobile menu icon customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Circle animation for Mobile Menu background overlay added<\\/li>\\n<li>Menu Dropdown visibility with Theme Builder Header and Footer Reveal Effect enabled issue fixed<\\/li>\\n<li>default Mobile Menu animation performance issue fixed<\\/li>\\n<li>Centered Inline Logo header alignment fixed<\\/li>\\n<li>Centered header hamburger icon position fixed<\\/li>\\n<li>Stand and Spring style Hamburger icon animation issues fixed<\\/li>\\n<li>Fixed Mobile Menu container gap issue on mobiles fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.2 - 28th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>NEW: Add Arrow to Dropdown Menus<\\/li>\\n<li>NEW: Dropdown Menu width and position controls added<\\/li>\\n<li>NEW: Open Menu Button Link in a New Window option added<\\/li>\\n<li>Header Height\\/Spacing issues fixed<\\/li>\\n<li>Hide Top Bar feature improved<\\/li>\\n<li>Do Not Shrink Header on Scroll feature improved<\\/li>\\n<li>Social Icons in Secondary Menu Firefox issue fixed<\\/li>\\n<li>CTA Menu Button Position First\\/Last issue fixed<\\/li>\\n<li>Centered\\/Centered Inline header style issues fixed<\\/li>\\n<li>Top Bar performance on mobiles improved<\\/li>\\n<li>Mobile Menu paddings issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.1 - 15th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Fixed duplicated hamburger icons when more than one menu was used on a page<\\/li>\\n<li>Do Not Shrink Header functionality improved<\\/li>\\n<\\/ul>\\n<p><strong>1.8 - 13th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Magnifier module<\\/li>\\n<li><strong>NEW:<\\/strong> Lottie Icon module<\\/li>\\n<li>Plugin Settings page responsive issues fixed<\\/li>\\n<li>Plugin Settings Page Toolbar added<\\/li>\\n<li>Hide Admin Bar when user not logged in issue fixed<\\/li>\\n<li>Archive Page Header Injector issue fixed<\\/li>\\n<li>Bottom Bar customization issues fixed<\\/li>\\n<li>Back To Top custom link issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.7.1 - 28th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Panorama module PHP error for older PHP versions<\\/li>\\n<\\/ul>\\n<p><strong>1.7 - 27th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Panorama module<\\/li>\\n<li><strong>NEW:<\\/strong> Reading Progress Bar module<\\/li>\\n<li><strong>NEW:<\\/strong> Google icon to Social Icons added<\\/li>\\n<li>SVG image upload feature improved<\\/li>\\n<li>Force Footer to Bottom when Theme Builder used issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.6.2 - 20th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed an issue with social icons individual locations<\\/li>\\n<li>Fixed an issue with the revealing footer effect<\\/li>\\n<\\/ul>\\n<p><strong>1.6.1 - 15th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue in Divi Pixel options panel (WordPress 5.5 compatibility)<\\/li>\\n<li>Fixed an issue where individual social icon locations would break the menus<\\/li>\\n<\\/ul>\\n<p><strong>1.6.0 - 12th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Scrollable Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt text field added for Hover Box images<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Accordion Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS fields added to Accordion Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Tilt Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Hotspot Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List configurable HTML title tag option added<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Label field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Fixed responsive flex settings for Button Grid and added options for alignment and justification<\\/li>\\n<li><strong>NEW:<\\/strong> Login Page custom logo URL option added<\\/li>\\n<li><strong>NEW:<\\/strong> option to add links to images in Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> SVG image preview in Media Library added<\\/li>\\n<li>Tilt Image title customization issue fixed<\\/li>\\n<li>fixed issue with Theme Customizer scripts not loading on FlyWheel hosted sites<\\/li>\\n<li>Hover Box displaying empty heading tags issue fixed<\\/li>\\n<li>duplicated Prefix and Suffix spans in Typing Text module issue fixed<\\/li>\\n<li>Login Page logo size default values fixed<\\/li>\\n<li>Added option to Masonry Gallery to enable lazy loading images compatibility<\\/li>\\n<li>Automatically scroll to the top of the Divi Pixel options page after switching tabs<\\/li>\\n<li>Fixed Masonry Gallery not opening images in a lightbox<\\/li>\\n<li>Accordion Image responsive spacing issue fixed<\\/li>\\n<li>Carousel box-shadow and border child module issue fixed<\\/li>\\n<li>Carousel module left navigation positioning issue in builder fixed<\\/li>\\n<li>Flip Box content displaying issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.5.0 - 8th May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Accordion Module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box: added option to force the module to be a square<\\/li>\\n<li>Fixed \\\"open in new window\\\" option in various modules<\\/li>\\n<li>Improved SVG upload functionality to allow different mime types<\\/li>\\n<li>Fixed Related Articles and Author Box when Theme Builder is used<\\/li>\\n<li>Fixed Blog Slider default columns on tablet and mobiles<\\/li>\\n<li>Fixed \\\"Related Articles\\\" heading, which was sometimes displayed on custom post types<\\/li>\\n<li>Fixed Flex Direction responsive options in Typing Text module<\\/li>\\n<li>Fixed Image Hotspot heading level option in Visual Builder<\\/li>\\n<li>Fixed various typos<\\/li>\\n<li>Added some semicolons here and there to spice up the code (and fix some issues)<\\/li>\\n<\\/ul>\\n<p><strong>1.4.4 - 31st May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Flip Box Dynamic Height option added<\\/li>\\n<li><strong>NEW:<\\/strong> Flip Box: force module to be a square option added<\\/li>\\n<li>Flip Box Image Overlay builder issue fixed<\\/li>\\n<li>Flip Box icon not displayed on front-end issue fixed<\\/li>\\n<li>Primary Menu customization when Menu Hover Animation disabled issue fixed<\\/li>\\n<li>Masonry Gallery: IE browser issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.3 - 27th May 2020<\\/strong><\\/p>\\n<ul>\\n<li>Flip Box: height issue fixed<\\/li>\\n<li>Flip Box: Back Button not displayed on front-end issue fixed<\\/li>\\n<li>Flip Box: 3D Content Effect issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.2 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Flip Box module: Dynamic Height option removed<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.1 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Plugin Settings\\/Modules section updated<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.0 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Fancy Text module added<\\/li>\\n<li>Breadcrumbs Module: responsive padding options added<\\/li>\\n<li>Breadcrumbs: separator icon issue fixed<\\/li>\\n<li>Back To Top Button: box-shadow issue on hover fixed<\\/li>\\n<li>Back To Top Button: custom link issue fixed<\\/li>\\n<li>Menu CTA Button: hover text\\/background issue fixed<\\/li>\\n<li>Secondary Header menu\\/social icons positioning issue fixed<\\/li>\\n<li>Button Grid: icon size and positioning fixed<\\/li>\\n<li>Blog Archive: meta text icons positioning fixed<\\/li>\\n<li>Blog Slider image clickable option added<\\/li>\\n<li>Blog Slider: responsive image height option added<\\/li>\\n<li>Mobile Menu: Theme Builder header issues fixed<\\/li>\\n<li>Custom Mobile Breakpoint: all menu customization settings revised and improved<\\/li>\\n<li>Login Page: form field text size option added<\\/li>\\n<li>Login Page: logo size issue fixed, logo height option added<\\/li>\\n<li>Related Articles: section title font size issue fixed<\\/li>\\n<li>Testimonial Slider: read more popup size on mobiles issue fixed<\\/li>\\n<li>Header Menu: customization setting improved<\\/li>\\n<li>Hover Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Hover Box: module not displayed in Builder\\/Firefox issue fixed<\\/li>\\n<li>Hover Box: responsive height fixed<\\/li>\\n<li>Flip Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Image Hotspot, Hover Box, Flip Box, Carousel, Tilt Image: configurable HTML title tag option added<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.3.1 - 26th April 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed a bunch of smaller bugs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.0 - 20th April 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Blog Slider module<\\/li>\\n<li><strong>NEW<\\/strong>: Animation Delay option in Counter module<\\/li>\\n<li><strong>NEW:<\\/strong> Option to enable beta downloads<\\/li>\\n<li>Mobile Menu issue fixed<\\/li>\\n<li>Header\\/Menu Animation issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0 - 26th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Countdown module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box module<\\/li>\\n<li>Force Footer to Bottom Firefox issue fixed<\\/li>\\n<li>Filled Background menu animation style Firefox issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0 - 16th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Hotspot module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Export\\/Import functionality added to the Divi Pixel options panel<\\/li>\\n<li>Back to top button functionality improved<\\/li>\\n<li>Testimonial Slider mobile issues fixed<\\/li>\\n<li>Testimonial Slider Website URL field added<\\/li>\\n<li>The improved license activation process<\\/li>\\n<li>Licensing API Library updated<\\/li>\\n<\\/ul>\\n<p><strong>1.0.0 - 4th March 2020<\\/strong><\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"]}\";}", "no");
INSERT INTO `z8ei5_options` VALUES("334", "wp_rocket_settings", "a:77:{s:12:\"cache_mobile\";i:1;s:23:\"do_caching_mobile_files\";i:1;s:19:\"purge_cron_interval\";i:10;s:15:\"purge_cron_unit\";s:15:\"HOUR_IN_SECONDS\";s:10:\"minify_css\";i:1;s:22:\"minify_concatenate_css\";i:1;s:11:\"exclude_css\";a:1:{i:0;s:71:\"cdn.jsdelivr.net/gh/AmauriC/tarteaucitron.js@1.9.4/tarteaucitron.min.js\";}s:26:\"remove_unused_css_safelist\";a:0:{}s:12:\"critical_css\";s:0:\"\";s:9:\"minify_js\";i:1;s:17:\"exclude_inline_js\";a:0:{}s:10:\"exclude_js\";a:1:{i:0;s:20:\"tarteaucitron.min.js\";}s:12:\"defer_all_js\";i:1;s:16:\"exclude_defer_js\";a:1:{i:0;s:20:\"tarteaucitron.min.js\";}s:8:\"delay_js\";i:1;s:19:\"delay_js_exclusions\";a:1:{i:0;s:13:\"tarteaucitron\";}s:16:\"exclude_lazyload\";a:0:{}s:14:\"manual_preload\";i:1;s:13:\"preload_links\";s:1:\"1\";s:12:\"dns_prefetch\";a:0:{}s:13:\"preload_fonts\";a:0:{}s:16:\"cache_reject_uri\";a:0:{}s:20:\"cache_reject_cookies\";a:0:{}s:15:\"cache_reject_ua\";a:0:{}s:17:\"cache_purge_pages\";a:0:{}s:19:\"cache_query_strings\";a:0:{}s:27:\"automatic_cleanup_frequency\";s:0:\"\";s:10:\"cdn_cnames\";a:0:{}s:8:\"cdn_zone\";a:0:{}s:16:\"cdn_reject_files\";a:0:{}s:17:\"control_heartbeat\";i:1;s:24:\"heartbeat_admin_behavior\";s:18:\"reduce_periodicity\";s:25:\"heartbeat_editor_behavior\";s:18:\"reduce_periodicity\";s:23:\"heartbeat_site_behavior\";s:18:\"reduce_periodicity\";s:18:\"cloudflare_api_key\";s:0:\"\";s:16:\"cloudflare_email\";s:0:\"\";s:18:\"cloudflare_zone_id\";s:0:\"\";s:18:\"sucury_waf_api_key\";s:0:\"\";s:12:\"consumer_key\";s:8:\"65497d9a\";s:14:\"consumer_email\";s:25:\"jamila.retter54@gmail.com\";s:10:\"secret_key\";s:8:\"9c5b793c\";s:7:\"license\";s:10:\"1655340620\";s:16:\"secret_cache_key\";s:22:\"62aa7e49064f9926601208\";s:14:\"minify_css_key\";s:22:\"644e8aef69e17954920046\";s:13:\"minify_js_key\";s:22:\"644e8aef69e1c309797925\";s:7:\"version\";s:8:\"3.14.4.2\";s:23:\"cloudflare_old_settings\";s:0:\"\";s:9:\"cache_ssl\";i:1;s:19:\"minify_google_fonts\";i:1;s:5:\"emoji\";i:1;s:17:\"remove_unused_css\";i:0;s:9:\"async_css\";i:0;s:16:\"async_css_mobile\";s:1:\"1\";s:17:\"cache_logged_user\";i:0;s:21:\"minify_concatenate_js\";i:0;s:8:\"lazyload\";i:0;s:16:\"lazyload_iframes\";i:0;s:16:\"lazyload_youtube\";i:0;s:18:\"database_revisions\";i:0;s:20:\"database_auto_drafts\";i:0;s:22:\"database_trashed_posts\";i:0;s:22:\"database_spam_comments\";i:0;s:25:\"database_trashed_comments\";i:0;s:23:\"database_all_transients\";i:0;s:24:\"database_optimize_tables\";i:0;s:26:\"schedule_automatic_cleanup\";i:0;s:13:\"do_cloudflare\";i:0;s:18:\"cloudflare_devmode\";i:0;s:24:\"cloudflare_auto_settings\";i:0;s:27:\"cloudflare_protocol_rewrite\";i:0;s:21:\"sucury_waf_cache_sync\";i:0;s:3:\"cdn\";i:0;s:18:\"varnish_auto_purge\";i:0;s:16:\"image_dimensions\";i:0;s:20:\"preload_excluded_uri\";a:0:{}s:28:\"delay_js_exclusions_selected\";a:0:{}s:39:\"delay_js_exclusions_selected_exclusions\";a:0:{}}", "yes");
INSERT INTO `z8ei5_options` VALUES("345", "edd_api_request_9481ed44b0b7ba0701d45beb14f3f72f", "a:2:{s:7:\"timeout\";i:1655351423;s:5:\"value\";s:94816:\"{\"new_version\":\"2.13\",\"stable_version\":\"2.13\",\"name\":\"Divi Pixel\",\"slug\":\"divi-pixel\",\"url\":\"https:\\/\\/www.divi-pixel.com\\/product\\/divi-pixel\\/?changelog=1\",\"last_updated\":\"2022-06-08 13:29:23\",\"homepage\":\"https:\\/\\/www.divi-pixel.com\\/product\\/divi-pixel\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p>[et_pb_section fb_built=\\\"1\\\" admin_label=\\\"section\\\" _builder_version=\\\"4.16\\\" global_colors_info=\\\"{}\\\"][et_pb_row admin_label=\\\"row\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"][et_pb_column type=\\\"4_4\\\" _builder_version=\\\"4.16\\\" custom_padding=\\\"|||\\\" global_colors_info=\\\"{}\\\" custom_padding__hover=\\\"|||\\\"][et_pb_text admin_label=\\\"Text\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"]<br \\/>\\nDivi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals. Create amazing websites using powerful Divi Pixels modules and settings.<br \\/>\\n[\\/et_pb_text][\\/et_pb_column][\\/et_pb_row][\\/et_pb_section]<\\/p>\\n\",\"changelog\":\"<p><strong>2.13.0 - June 8th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added Text Highlighter module<\\/li>\\n<li>Added option to select the active tab on load in Advanced Tabs module<\\/li>\\n<li>Added ordering settings to Masonry Gallery module<\\/li>\\n<li>Fixed particles background issue when parallax option is enabled<\\/li>\\n<li>Fixed Theme Customizer toggles not displaying the correct value<\\/li>\\n<li>Fixed button icons not working when the Dynamic CSS is enabled<\\/li>\\n<li>Fixed Carousel button link dynamic option<\\/li>\\n<li>Fixed collapsed submenu not working when Theme Builder Menu module used<\\/li>\\n<li>Fixed Timeline animations not working in Firefox and Safari browsers<\\/li>\\n<li>Fixed not loading Divi Pixel font when the user is logged in<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.12.0 - May 26th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Particles Background effect<\\/li>\\n<li>Fixed Hotspot Image unwanted square element displayed below module when Lazy Load is used<\\/li>\\n<li>Added animation settings to child modules in the Timeline module<\\/li>\\n<li>Added Image Slider heading customization settings for H tags placed in description<\\/li>\\n<li>Updated PHP 8 depreciated functions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.11.0 - May 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Expanding CTA module<\\/li>\\n<li>Fixed Advanced Tabs button target issue<\\/li>\\n<li>Fixed Image Gallery navigation issue when used in Advanced Tabs module<\\/li>\\n<li>Fixed Carousel description HTML markup displayed when not used<\\/li>\\n<li>Fixed Carousel image box-shadow issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.10 - May 9th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Maintenance Mode feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Allow TTF, OTF and WOFF file uploads<\\/li>\\n<li>Fixed Image Slider issue when used in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.9 - May 5th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Horizontal Timeline module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added option to add overlay image for Scroll Image module and set reveal effect<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added Animate in Viewport and Delay options to the Lottie Icon module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added reverse direction animation for autorotate option in Info Circle module<\\/li>\\n<li>Improved JavaScript for Balloon module to address issues when used in Theme Builder<\\/li>\\n<li>Added Telegram social media icon<\\/li>\\n<li>Added link customization settings to FAQ module<\\/li>\\n<li>Added Carousel image\\/icon hover option<\\/li>\\n<li>Fixed Floating Images animations not working in Safari and iOS 15.4.1<\\/li>\\n<li>Fixed Fancy Text prefix goes out of the screen issue<\\/li>\\n<li>Fixed Dual Heading background text displayed in Divi Builder when not used<\\/li>\\n<li>Fixed Advanced Tabs Divi Library item width issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.8 - April 25th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Advanced Tabs module<\\/li>\\n<li>Fixed Image Slider custom thumbnails not displayed on front-end<\\/li>\\n<li>Fixed Image Slider title formatting and HTML tag displayed on front-end<\\/li>\\n<li>Fixed Image Hotspot mobile issue<\\/li>\\n<li>Fixed Image Hotspot box shadow and border-radius issue<\\/li>\\n<li>Fixed Hover Box and Flip Box gradient migration issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.2 - April 13th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Author Box and Menu CTA Button font issue<\\/li>\\n<li>Fixed Panorama video controls not working in Safari browser<\\/li>\\n<li>Fixed Panorama default height value not working<\\/li>\\n<li>Fixed Image Slider custom navigation not displayed on the frontend<\\/li>\\n<li>Fixed Divi Pixel settings import issue<\\/li>\\n<li>Fixed Masonry Gallery icon border not working<\\/li>\\n<li>Fixed Dual Heading background animation issue<\\/li>\\n<li>Fixed module link not working in Balloon module<\\/li>\\n<li>Fixed dropdown link background color not working with Theme Builder header<\\/li>\\n<li>Added multi-select field for CTA menu button<\\/li>\\n<li>Added gradient migration for new gradient builder to retain old values<\\/li>\\n<li>Added dynamic images and content to Before &amp; After Slider module<\\/li>\\n<li>Added dynamic content fields to the Grid Button module<\\/li>\\n<li>Added dynamic labels to the Content Toggle module<\\/li>\\n<li>Added dynamic prefix and suffix fields to the Counter module<\\/li>\\n<li>Added dynamic heading content to the Dual Heading module<\\/li>\\n<li>Added dynamic fields for prefix and suffix in Fancy Text module<\\/li>\\n<li>Added dynamic image and image link fields to the Floating Images module<\\/li>\\n<li>Added dynamic image and content fields to Accordion Image module<\\/li>\\n<li>Added dynamic images and content fields to the Image Hotspot module<\\/li>\\n<li>Added dynamic images and content fields to the Balloon module<\\/li>\\n<li>Added dynamic images and content fields to the Carousel module<\\/li>\\n<li>Added dynamic images and content fields to the Flip Box module<\\/li>\\n<li>Added dynamic images and content fields to the Hover Box module<\\/li>\\n<li>Added dynamic images fields to the Image Magnifier module<\\/li>\\n<li>Added dynamic images fields to the Image Mask module<\\/li>\\n<li>Added dynamic images fields to the Image Showcase module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.1 - April 6th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Added Projects category and tag slug options<\\/li>\\n<li>Added CSS ID &amp; Classes fields to Image Accordion child items<\\/li>\\n<li>Added Half Circle option to the Counter module<\\/li>\\n<li>Added new gradient support to Divi Pixel modules<\\/li>\\n<li>Added image placeholder to Tilt Image module<\\/li>\\n<li>Fixed Circle Info Button margin not working<\\/li>\\n<li>Fixed Circle Info icon height issue<\\/li>\\n<li>Fixed Circle Info content switch on mobiles not working<\\/li>\\n<li>Fixed Circle Info icons not displayed in Firefox\\/Safari when icon animation is enabled<\\/li>\\n<li>Fixed Facebook and Google API code causing an error on cron<\\/li>\\n<li>Fixed Panorama responsive height issue<\\/li>\\n<li>Fixed Carousel, Content Toggle &amp; Balloon fatal errors sent to the email after WP autosave is triggered<\\/li>\\n<li>Fixed Carousel pagination responsive settings issue<\\/li>\\n<li>Fixed Carousel arrow navigation not working on mobile devices<\\/li>\\n<li>Fixed Masonry Gallery circle icon issue in builder<\\/li>\\n<li>Fixed Image Hotspot spacing issue in Firefox\\/Safari browsers<\\/li>\\n<li>Updated cron timing frequency for license check (twice daily)<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7 February 23rd 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Info Circle module added<\\/li>\\n<li>Updated Google social media icon<\\/li>\\n<li>Updated Snapchat and TikTok SVG images creating an error<\\/li>\\n<li>Updated Image Hotspot position value step to 0.1<\\/li>\\n<li>Updated hotspot icon line height causing hotspot icon to be not perfectly centred<\\/li>\\n<li>Improved Scroll Image horizontal mouse scroll performance<\\/li>\\n<li>Improved preloader performance<\\/li>\\n<li>Fixed Tilt Image glare effect<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Panorama rendering issues in Divi Builder when the video is used<\\/li>\\n<li>Fixed Panorama height not working when the video is used<\\/li>\\n<li>Fixed Flip Box back button padding not working<\\/li>\\n<li>Fixed Dual Heading module bottom margin and padding not working<\\/li>\\n<li>Fixed Dual Heading text background clipping for the 2nd text not working<\\/li>\\n<li>Fixed Carousel image border radius when box-shadow added not applying properly<\\/li>\\n<li>Fixed custom blog layout style not applying when Theme Builder template is used<\\/li>\\n<li>Fixed Image Slider Divi Library shortcodes not rendering<\\/li>\\n<li>Fixed dropdown arrow displayed on child submenus<\\/li>\\n<li>Fixed Search icon position when CTA Button not used<\\/li>\\n<li>Added support for PHP 8<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6.1 January 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added language settings for Google testimonials<\\/li>\\n<li><strong>NEW:<\\/strong> Added options to Exclude\\/Include Testimonials by Post ID<\\/li>\\n<li><strong>NEW:<\\/strong> Added 9 new animations to the Floating Images module<\\/li>\\n<li>Updated Floating Images position max and min values<\\/li>\\n<li>Fixed Floating Images transition CSS not working<\\/li>\\n<li>Fixed issue with Menu Hover Effect applies to the centred header logo<\\/li>\\n<li>Fixed Blog Slider random order not working<\\/li>\\n<li>Fixed not working link in Carousel child module<\\/li>\\n<li>Removed Carousel button wrapper HTML markup when the button is not used<\\/li>\\n<li>Added Soundcloud and TikTok icons to Social Media settings<\\/li>\\n<li>Added CSS ID &amp; Classes field to the Image Hotspot child module<\\/li>\\n<li>Added dynamic image support for Image Slider module (front-end only)<\\/li>\\n<li>Fixed JS error after searching when post meta section is empty<\\/li>\\n<li>Fixed Image Slider text displayed on sides when 3D Cube mode is used<\\/li>\\n<li>Fixed SVG Animator default width and height not working in Safari browser<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Tilt Image flickering issue in Chrome browser<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6 December 8th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> SVG Animator module added<\\/li>\\n<li>Image Slider thumbnails height various units support added<\\/li>\\n<li>Blog Slider backward PHP (&lt;7.2) compatibility issue fixed<\\/li>\\n<li>custom styles did not apply on paginated blog pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.3 November 26th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\" data-border-radius-top-cap=\\\"false\\\" data-border-radius-bottom-cap=\\\"false\\\">\\n<li><strong>NEW:<\\/strong> Image Accordion Always Visible new settings for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Showcase individual images links feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider featured image animation effects added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel image animation settings added<\\/li>\\n<li><strong>NEW:<\\/strong> All Divi Pixel modules support new Divi icons<\\/li>\\n<li>Carousel new custom CSS for active slide added<\\/li>\\n<li>Blog Slider navigation responsive settings added<\\/li>\\n<li>Blog Slider featured image border and box-shadow customization settings added<\\/li>\\n<li>Blog Slider new Custom CSS fields for navigation and active slide added<\\/li>\\n<li>Blog Slider pagination not working in builder when multiple instances used issue fixed<\\/li>\\n<li>Content Toggle new Custom CSS fields for toggle button added<\\/li>\\n<li>Image Mask shape 7 not displayed properly on front end issue fixed<\\/li>\\n<li>Masonry Gallery Grid Items border not working issue fixed<\\/li>\\n<li>Accordion module not triggered in Carousel module issue fixed<\\/li>\\n<li>Dropdown menu text color not working on fixed header issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.2 October 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 28 new masks added to the Image Mask module<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask selector field improved<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask: option to rotate, scale and flip the mask<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask image Alt Text field added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask upload custom shape option added<\\/li>\\n<li>Image Mask placeholder image added<\\/li>\\n<li>Image Showcase module URL issue fixed<\\/li>\\n<li>Carousel Autoplay stops working when the Pause on Hover option is disabled issue fixed<\\/li>\\n<li>Carousel item doesn\\u2019t take full width when short content is added issue fixed<\\/li>\\n<li>Countdown Timer doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Counter module doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Image Magnifier module doesn\\u2019t work in builder issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1 September 30th 2021<\\/strong><\\/p>\\n<ul>\\n<li>FAQ module categories missed issue fixed<\\/li>\\n<li>Custom preloader not working issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5 September 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Dual Heading module added<\\/li>\\n<li>Mobile Menu on WooCommerce pages issues fixed<\\/li>\\n<li>Blog archive custom style not applying for pagination pages issue fixed<\\/li>\\n<li>Image Hotspot tooltip displaying when border radius on the image is used issue fixed<\\/li>\\n<li>Image Hotspot tooltip image default width not applying in the builder issue fixed<\\/li>\\n<li>Image Hotspot new Ripple Effect style added<\\/li>\\n<li>Image Hotspot default image placeholder added<\\/li>\\n<li>Image Hotspot tooltip spacing in builder issue fixed<\\/li>\\n<li>Improved backwards compatibility with outdated PHP versions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4.2 - September 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider thumbnails margin controls added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider responsive settings for Image Overlay added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider custom thumbnail option added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider custom CSS field for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Slide Image responsive position control added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay hover settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay responsive settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Price List - Price Prefix and Suffix fields added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery image animation options added<\\/li>\\n<li>Custom Map Marker being cropped issue fixed<\\/li>\\n<li>Hover Box double arrow icon issue fixed<\\/li>\\n<li>Testimonial Slider Random order issue fixed<\\/li>\\n<li>Image Showcase in hidden section causing JS error issue fixed<\\/li>\\n<li>Blog Slider active pagination color issue fixed<\\/li>\\n<li>Blog Slider Content custom CSS field added<\\/li>\\n<li>dipi-anim-preload class not removed from the body after the page is loaded issue fixed<\\/li>\\n<li>Image Showcase causing JS error when the module is hidden issue fixed<\\/li>\\n<li>CTA Menu Button text color when Menu module is used issue fixed<\\/li>\\n<li style=\\\"list-style-type: none;\\\"><\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.4.1 August 23rd 2021<\\/strong><\\/p>\\n<p>Divi 4.10+ compatibility<\\/p>\\n<ul>\\n<li>Carousel lightbox functionality issue fixed<\\/li>\\n<li>Masonry Gallery layout grid and lightbox issue fixed<\\/li>\\n<li>Preloader, when Defer jQuery and jQuery Migrate option is enabled issue fixed<\\/li>\\n<li>Image Slider when Defer jQuery and jQuery migrate option is enabled issue fixed<\\/li>\\n<li>Counter module when Dynamic JS Libraries option enabled issue fixed<\\/li>\\n<li>Price List module when Dynamic JS Libraries enabled lightbox issue fixed<\\/li>\\n<li>Testimonial Slider popup when Dynamic JS Libraries enabled issue fixed<\\/li>\\n<li>Conditional Display when Dynamic Module Framework enabled issue fixed<\\/li>\\n<\\/ul>\\n<p>Improvements\\/Fixes<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\"><strong>NEW:<\\/strong> Image Slider Autoplay settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Archive page Style 2 - broken layout on category pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4 August 18th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Hotspot responsive positioning settings added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Open Carousel image in lightbox option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Reverse Carousel slide direction when Autoplay option is enabled<\\/li>\\n<li><strong>NEW:<\\/strong> Price List image lightbox gallery option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Masonry Gallery image link option added<\\/li>\\n<li>Carousel item Box Shadow on hover issue fixed<\\/li>\\n<li>Sidebar customization issues fixed<\\/li>\\n<li>Testimonial Slider heading customization settings added<\\/li>\\n<li>Carousel reloading in builder issue fixed<\\/li>\\n<li>Price List responsive settings for the layout and image added<\\/li>\\n<li>Price List module Box Shadow option to the parent module added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.3.2 July 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li>Related Article hover activation issue fixed<\\/li>\\n<li>Footer social icons when credits are disabled issue fixed<\\/li>\\n<li>Menu CTA button - menu selection issue fixed<\\/li>\\n<li>Image Hotspot - tooltip button when Trigger on Click is enabled issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.3.1 July 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Menu CTA Button - option for selecting menu added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Showcase - 11 new mockups added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box text line-height default values fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs alignment responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Divi Builder plugin &amp; Extra theme compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Exclude Posts option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive Featured Image border-radius option added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p>2.3 July 7th 2021<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> FAQ module with Google Structured Data added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider - category class added for single post box<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.5 June 30th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added new Section, Row and Module settings to conditionally display content based on users role or a login status<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Suppress Filters option is added to use the attempted filter by other 3rd party plugins (like WPML)<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mobile Menu Hamburger icon browser compatibility improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline card width when the icon is used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module PHP 7.2 compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Rename Projects tab category slug issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.4 June 18th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">duplicated logo when multiple Theme Builder headers are used issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.3 June 16th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> apply blog archive style to the native Divi Blog module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> select image size for the Blog Slider module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Divi Library Shortcodes to use in any module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Option to hide \\u201cEdit in Visual Builder\\u201d link on pages\\/posts overview dashboard pages<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial Read More popup font customization settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider \\u201cOrder By\\u201d settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - hide tooltip option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - link field to the hotspot child added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot isn\\u2019t interactive anymore issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider HTML markup displayed for disabled elements issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Accordion TinyMCE editor support added for the description field<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image responsive scroll speed settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Panorama 2D Image mode scroll issue on tablets and mobiles fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider responsive settings for navigation size and padding added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider - testimonials order settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More link disabled when a full testimonial is displayed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mega Menu width issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Read More Button Text\\u201d doesn\\u2019t apply to the native Divi Blog module issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d doesn\\u2019t apply to the Theme Builder custom header issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Collapsed mobile top menu not clickable issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module visibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module displaying on archive pages issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs separator alignment issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Lottie Icon width not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Content Toggle\\/Masonry Gallery compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Full-width post does not display full-width sections in frontend Divi Builder issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.2 April 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: open tooltip on click<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: tooltip animations added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Carousel - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module margin in Divi Builder modules list issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Ballon button link target issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">plugin settings modules list updated<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider HTML support for review text added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image content animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon button shadow not applying in builder properly issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider not working with Blog module when testimonial CPT is selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module fetches taxonomy from pages where taxonomy is not added issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline line border styles issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial custom CSS for Profile Image selector fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.1 April 2nd, 2021<\\/strong><\\/p>\\n<ul>\\n<li>plugin updater issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.0 April 1st, 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Ballon module added<\\/li>\\n<li>Blog Slider item not clickable in Firefox browser issue fixed<\\/li>\\n<li>Content Toggle et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li>Content Toggle and Image Showcase compatibility improved<\\/li>\\n<li>Testimonial Slider popup\\/Divi Machine conflict issue fixed<\\/li>\\n<li>API licensing UI and functionality improved<\\/li>\\n<li>Documentation pages UI improved<\\/li>\\n<\\/ul>\\n<p><strong>2.1.2 March 8th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">Content Toggle issue with dipi_label function issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module dipi_label function replaced with esc_html__ function<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.1 March 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Disable LazyLoad in Content Toggle module settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Enable Lightbox responsive settings issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Plugin Settings\\/Modules options updated<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.0 - February 25th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Content Toggle module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Archive section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Post Navigation section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Author Box section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Related Articles section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Disable Lightbox responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d in Firefox displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d ON\\/OFF builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box circle icon issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box WPML support improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image\\/Icon alignment in Timeline not working in Divi Builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel Autoplay option doesn\\u2019t work in Safari issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel items displayed vertically in Safari 8 issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel child item hover icon not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Button Grid on mobiles improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Floating Images Transform settings not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box height controls improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box solid border issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase rendering with WP Rocket Lazy Loading in different browsers issues fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image mouse scrolling improved<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.0.1 - February 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW: <\\/strong>Masonry Gallery Coverflow Animations<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Masonry Gallery - disable image lightbox option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box jQuery variable naming issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">CSS error preventing Divi scripts from compile issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text child module link issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion image responsive settings improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image Active On Load and Open On Click issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">fonts in Theme Customizer did not enqueue issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.0.0 - January 26th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Timeline module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added CSS ID &amp; Classes to Button Grid child modules<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> WhatsApp, Snapchat and Xing social media icons added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Active Image size responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Opened on Load responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Performance improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Mask SVG markup issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase - image positioning tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Primary Header Social Icons positioning when CTA Button is not used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery image width causing the problem with the proper displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Button displaying multiple icons when icon not selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default content-length value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default spacing value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Error messages when Google reviews are fetched corrected<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image arrow color rendering in builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box name improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text alignment settings revised<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup displaying mixed testimonials issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup image styling issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.3 - December 16th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>collapsed mobile menu close animation fixed<\\/li>\\n<li>dropdown menu width max value increased<\\/li>\\n<li>Hamburger Mobile Menu not displayed after WP 5.6 issue fixed<\\/li>\\n<li>minor code improvements in Panorama and Lottie modules<\\/li>\\n<li>Carousel Coverflow mode - disabled slide shadow issue fixed<\\/li>\\n<li>Duplicated Social Icons in Primary Header issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.2 - December 7th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Breadcrumbs active item styles missed on front-end issue fixed<\\/li>\\n<li>Dropdown menu item width control added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.1 - December 5th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Carousel spacing issue fixed<\\/li>\\n<li>plugin package\\/2 new modules Divi Builder rendering issues fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.0 - December 4th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Showcase module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask module added<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS Class field added to the header CTA button<\\/li>\\n<li><strong>NEW:<\\/strong> Divi Builder support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Extra theme support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Post Type\\/Taxonomy settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Alignment settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Dynamic button URL to Grid Button module added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel module CSS ID &amp; Classes added to child items<\\/li>\\n<li>Vertical Navigation style issues fixed<\\/li>\\n<li>Testimonial Slider overflow issue fixed<\\/li>\\n<li>Mobile Menu animation out when Theme Builder header used issue fixed<\\/li>\\n<li>Blog Archive responsive breakpoint updated<\\/li>\\n<li>Hotspot tooltip height on mobiles issue fixed<\\/li>\\n<li>Blog Slider body text and button box-shadow issues fixed<\\/li>\\n<li>Admin Label field added to the Carousel child modules<\\/li>\\n<li>Tooltip image wrapper if image not selected - HTML markup not displayed<\\/li>\\n<li>Post meta alignment on archive page issue fixed<\\/li>\\n<li>Tilt Image mobile height issue fixed<\\/li>\\n<li>Footer Reveal Effect visibility in the front-end builder issue fixed<\\/li>\\n<li>Hide Admin Bar setting issue fixed<\\/li>\\n<li>Hide Admin Bar\\/Hide Top Header\\/Reading Progress Bar issues fixed<\\/li>\\n<li>Breadcrumbs Schema Markup issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.9 - 14 October 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Mobile Submenu customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Collapsed Mobile menu icon customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Circle animation for Mobile Menu background overlay added<\\/li>\\n<li>Menu Dropdown visibility with Theme Builder Header and Footer Reveal Effect enabled issue fixed<\\/li>\\n<li>default Mobile Menu animation performance issue fixed<\\/li>\\n<li>Centered Inline Logo header alignment fixed<\\/li>\\n<li>Centered header hamburger icon position fixed<\\/li>\\n<li>Stand and Spring style Hamburger icon animation issues fixed<\\/li>\\n<li>Fixed Mobile Menu container gap issue on mobiles fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.2 - 28th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>NEW: Add Arrow to Dropdown Menus<\\/li>\\n<li>NEW: Dropdown Menu width and position controls added<\\/li>\\n<li>NEW: Open Menu Button Link in a New Window option added<\\/li>\\n<li>Header Height\\/Spacing issues fixed<\\/li>\\n<li>Hide Top Bar feature improved<\\/li>\\n<li>Do Not Shrink Header on Scroll feature improved<\\/li>\\n<li>Social Icons in Secondary Menu Firefox issue fixed<\\/li>\\n<li>CTA Menu Button Position First\\/Last issue fixed<\\/li>\\n<li>Centered\\/Centered Inline header style issues fixed<\\/li>\\n<li>Top Bar performance on mobiles improved<\\/li>\\n<li>Mobile Menu paddings issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.1 - 15th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Fixed duplicated hamburger icons when more than one menu was used on a page<\\/li>\\n<li>Do Not Shrink Header functionality improved<\\/li>\\n<\\/ul>\\n<p><strong>1.8 - 13th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Magnifier module<\\/li>\\n<li><strong>NEW:<\\/strong> Lottie Icon module<\\/li>\\n<li>Plugin Settings page responsive issues fixed<\\/li>\\n<li>Plugin Settings Page Toolbar added<\\/li>\\n<li>Hide Admin Bar when user not logged in issue fixed<\\/li>\\n<li>Archive Page Header Injector issue fixed<\\/li>\\n<li>Bottom Bar customization issues fixed<\\/li>\\n<li>Back To Top custom link issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.7.1 - 28th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Panorama module PHP error for older PHP versions<\\/li>\\n<\\/ul>\\n<p><strong>1.7 - 27th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Panorama module<\\/li>\\n<li><strong>NEW:<\\/strong> Reading Progress Bar module<\\/li>\\n<li><strong>NEW:<\\/strong> Google icon to Social Icons added<\\/li>\\n<li>SVG image upload feature improved<\\/li>\\n<li>Force Footer to Bottom when Theme Builder used issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.6.2 - 20th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed an issue with social icons individual locations<\\/li>\\n<li>Fixed an issue with the revealing footer effect<\\/li>\\n<\\/ul>\\n<p><strong>1.6.1 - 15th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue in Divi Pixel options panel (WordPress 5.5 compatibility)<\\/li>\\n<li>Fixed an issue where individual social icon locations would break the menus<\\/li>\\n<\\/ul>\\n<p><strong>1.6.0 - 12th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Scrollable Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt text field added for Hover Box images<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Accordion Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS fields added to Accordion Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Tilt Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Hotspot Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List configurable HTML title tag option added<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Label field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Fixed responsive flex settings for Button Grid and added options for alignment and justification<\\/li>\\n<li><strong>NEW:<\\/strong> Login Page custom logo URL option added<\\/li>\\n<li><strong>NEW:<\\/strong> option to add links to images in Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> SVG image preview in Media Library added<\\/li>\\n<li>Tilt Image title customization issue fixed<\\/li>\\n<li>fixed issue with Theme Customizer scripts not loading on FlyWheel hosted sites<\\/li>\\n<li>Hover Box displaying empty heading tags issue fixed<\\/li>\\n<li>duplicated Prefix and Suffix spans in Typing Text module issue fixed<\\/li>\\n<li>Login Page logo size default values fixed<\\/li>\\n<li>Added option to Masonry Gallery to enable lazy loading images compatibility<\\/li>\\n<li>Automatically scroll to the top of the Divi Pixel options page after switching tabs<\\/li>\\n<li>Fixed Masonry Gallery not opening images in a lightbox<\\/li>\\n<li>Accordion Image responsive spacing issue fixed<\\/li>\\n<li>Carousel box-shadow and border child module issue fixed<\\/li>\\n<li>Carousel module left navigation positioning issue in builder fixed<\\/li>\\n<li>Flip Box content displaying issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.5.0 - 8th May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Accordion Module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box: added option to force the module to be a square<\\/li>\\n<li>Fixed \\\"open in new window\\\" option in various modules<\\/li>\\n<li>Improved SVG upload functionality to allow different mime types<\\/li>\\n<li>Fixed Related Articles and Author Box when Theme Builder is used<\\/li>\\n<li>Fixed Blog Slider default columns on tablet and mobiles<\\/li>\\n<li>Fixed \\\"Related Articles\\\" heading, which was sometimes displayed on custom post types<\\/li>\\n<li>Fixed Flex Direction responsive options in Typing Text module<\\/li>\\n<li>Fixed Image Hotspot heading level option in Visual Builder<\\/li>\\n<li>Fixed various typos<\\/li>\\n<li>Added some semicolons here and there to spice up the code (and fix some issues)<\\/li>\\n<\\/ul>\\n<p><strong>1.4.4 - 31st May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Flip Box Dynamic Height option added<\\/li>\\n<li><strong>NEW:<\\/strong> Flip Box: force module to be a square option added<\\/li>\\n<li>Flip Box Image Overlay builder issue fixed<\\/li>\\n<li>Flip Box icon not displayed on front-end issue fixed<\\/li>\\n<li>Primary Menu customization when Menu Hover Animation disabled issue fixed<\\/li>\\n<li>Masonry Gallery: IE browser issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.3 - 27th May 2020<\\/strong><\\/p>\\n<ul>\\n<li>Flip Box: height issue fixed<\\/li>\\n<li>Flip Box: Back Button not displayed on front-end issue fixed<\\/li>\\n<li>Flip Box: 3D Content Effect issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.2 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Flip Box module: Dynamic Height option removed<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.1 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Plugin Settings\\/Modules section updated<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.0 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Fancy Text module added<\\/li>\\n<li>Breadcrumbs Module: responsive padding options added<\\/li>\\n<li>Breadcrumbs: separator icon issue fixed<\\/li>\\n<li>Back To Top Button: box-shadow issue on hover fixed<\\/li>\\n<li>Back To Top Button: custom link issue fixed<\\/li>\\n<li>Menu CTA Button: hover text\\/background issue fixed<\\/li>\\n<li>Secondary Header menu\\/social icons positioning issue fixed<\\/li>\\n<li>Button Grid: icon size and positioning fixed<\\/li>\\n<li>Blog Archive: meta text icons positioning fixed<\\/li>\\n<li>Blog Slider image clickable option added<\\/li>\\n<li>Blog Slider: responsive image height option added<\\/li>\\n<li>Mobile Menu: Theme Builder header issues fixed<\\/li>\\n<li>Custom Mobile Breakpoint: all menu customization settings revised and improved<\\/li>\\n<li>Login Page: form field text size option added<\\/li>\\n<li>Login Page: logo size issue fixed, logo height option added<\\/li>\\n<li>Related Articles: section title font size issue fixed<\\/li>\\n<li>Testimonial Slider: read more popup size on mobiles issue fixed<\\/li>\\n<li>Header Menu: customization setting improved<\\/li>\\n<li>Hover Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Hover Box: module not displayed in Builder\\/Firefox issue fixed<\\/li>\\n<li>Hover Box: responsive height fixed<\\/li>\\n<li>Flip Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Image Hotspot, Hover Box, Flip Box, Carousel, Tilt Image: configurable HTML title tag option added<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.3.1 - 26th April 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed a bunch of smaller bugs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.0 - 20th April 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Blog Slider module<\\/li>\\n<li><strong>NEW<\\/strong>: Animation Delay option in Counter module<\\/li>\\n<li><strong>NEW:<\\/strong> Option to enable beta downloads<\\/li>\\n<li>Mobile Menu issue fixed<\\/li>\\n<li>Header\\/Menu Animation issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0 - 26th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Countdown module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box module<\\/li>\\n<li>Force Footer to Bottom Firefox issue fixed<\\/li>\\n<li>Filled Background menu animation style Firefox issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0 - 16th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Hotspot module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Export\\/Import functionality added to the Divi Pixel options panel<\\/li>\\n<li>Back to top button functionality improved<\\/li>\\n<li>Testimonial Slider mobile issues fixed<\\/li>\\n<li>Testimonial Slider Website URL field added<\\/li>\\n<li>The improved license activation process<\\/li>\\n<li>Licensing API Library updated<\\/li>\\n<\\/ul>\\n<p><strong>1.0.0 - 4th March 2020<\\/strong><\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/www.divi-pixel.com\\/wp-content\\/uploads\\/2020\\/03\\/dp-affiliate-banner-02-128x128.png\",\"2x\":\"https:\\/\\/www.divi-pixel.com\\/wp-content\\/uploads\\/2020\\/03\\/dp-affiliate-banner-02-256x256.png\"},\"msg\":\"No license key has been provided.\",\"description\":[\"<p>[et_pb_section fb_built=\\\"1\\\" admin_label=\\\"section\\\" _builder_version=\\\"4.16\\\" global_colors_info=\\\"{}\\\"][et_pb_row admin_label=\\\"row\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"][et_pb_column type=\\\"4_4\\\" _builder_version=\\\"4.16\\\" custom_padding=\\\"|||\\\" global_colors_info=\\\"{}\\\" custom_padding__hover=\\\"|||\\\"][et_pb_text admin_label=\\\"Text\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"]<br \\/>\\nDivi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals. Create amazing websites using powerful Divi Pixels modules and settings.<br \\/>\\n[\\/et_pb_text][\\/et_pb_column][\\/et_pb_row][\\/et_pb_section]<\\/p>\\n\"],\"changelog\":[\"<p><strong>2.13.0 - June 8th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added Text Highlighter module<\\/li>\\n<li>Added option to select the active tab on load in Advanced Tabs module<\\/li>\\n<li>Added ordering settings to Masonry Gallery module<\\/li>\\n<li>Fixed particles background issue when parallax option is enabled<\\/li>\\n<li>Fixed Theme Customizer toggles not displaying the correct value<\\/li>\\n<li>Fixed button icons not working when the Dynamic CSS is enabled<\\/li>\\n<li>Fixed Carousel button link dynamic option<\\/li>\\n<li>Fixed collapsed submenu not working when Theme Builder Menu module used<\\/li>\\n<li>Fixed Timeline animations not working in Firefox and Safari browsers<\\/li>\\n<li>Fixed not loading Divi Pixel font when the user is logged in<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.12.0 - May 26th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Particles Background effect<\\/li>\\n<li>Fixed Hotspot Image unwanted square element displayed below module when Lazy Load is used<\\/li>\\n<li>Added animation settings to child modules in the Timeline module<\\/li>\\n<li>Added Image Slider heading customization settings for H tags placed in description<\\/li>\\n<li>Updated PHP 8 depreciated functions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.11.0 - May 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Expanding CTA module<\\/li>\\n<li>Fixed Advanced Tabs button target issue<\\/li>\\n<li>Fixed Image Gallery navigation issue when used in Advanced Tabs module<\\/li>\\n<li>Fixed Carousel description HTML markup displayed when not used<\\/li>\\n<li>Fixed Carousel image box-shadow issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.10 - May 9th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Maintenance Mode feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Allow TTF, OTF and WOFF file uploads<\\/li>\\n<li>Fixed Image Slider issue when used in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.9 - May 5th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Horizontal Timeline module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added option to add overlay image for Scroll Image module and set reveal effect<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added Animate in Viewport and Delay options to the Lottie Icon module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added reverse direction animation for autorotate option in Info Circle module<\\/li>\\n<li>Improved JavaScript for Balloon module to address issues when used in Theme Builder<\\/li>\\n<li>Added Telegram social media icon<\\/li>\\n<li>Added link customization settings to FAQ module<\\/li>\\n<li>Added Carousel image\\/icon hover option<\\/li>\\n<li>Fixed Floating Images animations not working in Safari and iOS 15.4.1<\\/li>\\n<li>Fixed Fancy Text prefix goes out of the screen issue<\\/li>\\n<li>Fixed Dual Heading background text displayed in Divi Builder when not used<\\/li>\\n<li>Fixed Advanced Tabs Divi Library item width issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.8 - April 25th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Advanced Tabs module<\\/li>\\n<li>Fixed Image Slider custom thumbnails not displayed on front-end<\\/li>\\n<li>Fixed Image Slider title formatting and HTML tag displayed on front-end<\\/li>\\n<li>Fixed Image Hotspot mobile issue<\\/li>\\n<li>Fixed Image Hotspot box shadow and border-radius issue<\\/li>\\n<li>Fixed Hover Box and Flip Box gradient migration issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.2 - April 13th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Author Box and Menu CTA Button font issue<\\/li>\\n<li>Fixed Panorama video controls not working in Safari browser<\\/li>\\n<li>Fixed Panorama default height value not working<\\/li>\\n<li>Fixed Image Slider custom navigation not displayed on the frontend<\\/li>\\n<li>Fixed Divi Pixel settings import issue<\\/li>\\n<li>Fixed Masonry Gallery icon border not working<\\/li>\\n<li>Fixed Dual Heading background animation issue<\\/li>\\n<li>Fixed module link not working in Balloon module<\\/li>\\n<li>Fixed dropdown link background color not working with Theme Builder header<\\/li>\\n<li>Added multi-select field for CTA menu button<\\/li>\\n<li>Added gradient migration for new gradient builder to retain old values<\\/li>\\n<li>Added dynamic images and content to Before &amp; After Slider module<\\/li>\\n<li>Added dynamic content fields to the Grid Button module<\\/li>\\n<li>Added dynamic labels to the Content Toggle module<\\/li>\\n<li>Added dynamic prefix and suffix fields to the Counter module<\\/li>\\n<li>Added dynamic heading content to the Dual Heading module<\\/li>\\n<li>Added dynamic fields for prefix and suffix in Fancy Text module<\\/li>\\n<li>Added dynamic image and image link fields to the Floating Images module<\\/li>\\n<li>Added dynamic image and content fields to Accordion Image module<\\/li>\\n<li>Added dynamic images and content fields to the Image Hotspot module<\\/li>\\n<li>Added dynamic images and content fields to the Balloon module<\\/li>\\n<li>Added dynamic images and content fields to the Carousel module<\\/li>\\n<li>Added dynamic images and content fields to the Flip Box module<\\/li>\\n<li>Added dynamic images and content fields to the Hover Box module<\\/li>\\n<li>Added dynamic images fields to the Image Magnifier module<\\/li>\\n<li>Added dynamic images fields to the Image Mask module<\\/li>\\n<li>Added dynamic images fields to the Image Showcase module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.1 - April 6th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Added Projects category and tag slug options<\\/li>\\n<li>Added CSS ID &amp; Classes fields to Image Accordion child items<\\/li>\\n<li>Added Half Circle option to the Counter module<\\/li>\\n<li>Added new gradient support to Divi Pixel modules<\\/li>\\n<li>Added image placeholder to Tilt Image module<\\/li>\\n<li>Fixed Circle Info Button margin not working<\\/li>\\n<li>Fixed Circle Info icon height issue<\\/li>\\n<li>Fixed Circle Info content switch on mobiles not working<\\/li>\\n<li>Fixed Circle Info icons not displayed in Firefox\\/Safari when icon animation is enabled<\\/li>\\n<li>Fixed Facebook and Google API code causing an error on cron<\\/li>\\n<li>Fixed Panorama responsive height issue<\\/li>\\n<li>Fixed Carousel, Content Toggle &amp; Balloon fatal errors sent to the email after WP autosave is triggered<\\/li>\\n<li>Fixed Carousel pagination responsive settings issue<\\/li>\\n<li>Fixed Carousel arrow navigation not working on mobile devices<\\/li>\\n<li>Fixed Masonry Gallery circle icon issue in builder<\\/li>\\n<li>Fixed Image Hotspot spacing issue in Firefox\\/Safari browsers<\\/li>\\n<li>Updated cron timing frequency for license check (twice daily)<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7 February 23rd 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Info Circle module added<\\/li>\\n<li>Updated Google social media icon<\\/li>\\n<li>Updated Snapchat and TikTok SVG images creating an error<\\/li>\\n<li>Updated Image Hotspot position value step to 0.1<\\/li>\\n<li>Updated hotspot icon line height causing hotspot icon to be not perfectly centred<\\/li>\\n<li>Improved Scroll Image horizontal mouse scroll performance<\\/li>\\n<li>Improved preloader performance<\\/li>\\n<li>Fixed Tilt Image glare effect<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Panorama rendering issues in Divi Builder when the video is used<\\/li>\\n<li>Fixed Panorama height not working when the video is used<\\/li>\\n<li>Fixed Flip Box back button padding not working<\\/li>\\n<li>Fixed Dual Heading module bottom margin and padding not working<\\/li>\\n<li>Fixed Dual Heading text background clipping for the 2nd text not working<\\/li>\\n<li>Fixed Carousel image border radius when box-shadow added not applying properly<\\/li>\\n<li>Fixed custom blog layout style not applying when Theme Builder template is used<\\/li>\\n<li>Fixed Image Slider Divi Library shortcodes not rendering<\\/li>\\n<li>Fixed dropdown arrow displayed on child submenus<\\/li>\\n<li>Fixed Search icon position when CTA Button not used<\\/li>\\n<li>Added support for PHP 8<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6.1 January 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added language settings for Google testimonials<\\/li>\\n<li><strong>NEW:<\\/strong> Added options to Exclude\\/Include Testimonials by Post ID<\\/li>\\n<li><strong>NEW:<\\/strong> Added 9 new animations to the Floating Images module<\\/li>\\n<li>Updated Floating Images position max and min values<\\/li>\\n<li>Fixed Floating Images transition CSS not working<\\/li>\\n<li>Fixed issue with Menu Hover Effect applies to the centred header logo<\\/li>\\n<li>Fixed Blog Slider random order not working<\\/li>\\n<li>Fixed not working link in Carousel child module<\\/li>\\n<li>Removed Carousel button wrapper HTML markup when the button is not used<\\/li>\\n<li>Added Soundcloud and TikTok icons to Social Media settings<\\/li>\\n<li>Added CSS ID &amp; Classes field to the Image Hotspot child module<\\/li>\\n<li>Added dynamic image support for Image Slider module (front-end only)<\\/li>\\n<li>Fixed JS error after searching when post meta section is empty<\\/li>\\n<li>Fixed Image Slider text displayed on sides when 3D Cube mode is used<\\/li>\\n<li>Fixed SVG Animator default width and height not working in Safari browser<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Tilt Image flickering issue in Chrome browser<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6 December 8th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> SVG Animator module added<\\/li>\\n<li>Image Slider thumbnails height various units support added<\\/li>\\n<li>Blog Slider backward PHP (&lt;7.2) compatibility issue fixed<\\/li>\\n<li>custom styles did not apply on paginated blog pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.3 November 26th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\" data-border-radius-top-cap=\\\"false\\\" data-border-radius-bottom-cap=\\\"false\\\">\\n<li><strong>NEW:<\\/strong> Image Accordion Always Visible new settings for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Showcase individual images links feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider featured image animation effects added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel image animation settings added<\\/li>\\n<li><strong>NEW:<\\/strong> All Divi Pixel modules support new Divi icons<\\/li>\\n<li>Carousel new custom CSS for active slide added<\\/li>\\n<li>Blog Slider navigation responsive settings added<\\/li>\\n<li>Blog Slider featured image border and box-shadow customization settings added<\\/li>\\n<li>Blog Slider new Custom CSS fields for navigation and active slide added<\\/li>\\n<li>Blog Slider pagination not working in builder when multiple instances used issue fixed<\\/li>\\n<li>Content Toggle new Custom CSS fields for toggle button added<\\/li>\\n<li>Image Mask shape 7 not displayed properly on front end issue fixed<\\/li>\\n<li>Masonry Gallery Grid Items border not working issue fixed<\\/li>\\n<li>Accordion module not triggered in Carousel module issue fixed<\\/li>\\n<li>Dropdown menu text color not working on fixed header issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.2 October 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 28 new masks added to the Image Mask module<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask selector field improved<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask: option to rotate, scale and flip the mask<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask image Alt Text field added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask upload custom shape option added<\\/li>\\n<li>Image Mask placeholder image added<\\/li>\\n<li>Image Showcase module URL issue fixed<\\/li>\\n<li>Carousel Autoplay stops working when the Pause on Hover option is disabled issue fixed<\\/li>\\n<li>Carousel item doesn\\u2019t take full width when short content is added issue fixed<\\/li>\\n<li>Countdown Timer doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Counter module doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Image Magnifier module doesn\\u2019t work in builder issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1 September 30th 2021<\\/strong><\\/p>\\n<ul>\\n<li>FAQ module categories missed issue fixed<\\/li>\\n<li>Custom preloader not working issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5 September 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Dual Heading module added<\\/li>\\n<li>Mobile Menu on WooCommerce pages issues fixed<\\/li>\\n<li>Blog archive custom style not applying for pagination pages issue fixed<\\/li>\\n<li>Image Hotspot tooltip displaying when border radius on the image is used issue fixed<\\/li>\\n<li>Image Hotspot tooltip image default width not applying in the builder issue fixed<\\/li>\\n<li>Image Hotspot new Ripple Effect style added<\\/li>\\n<li>Image Hotspot default image placeholder added<\\/li>\\n<li>Image Hotspot tooltip spacing in builder issue fixed<\\/li>\\n<li>Improved backwards compatibility with outdated PHP versions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4.2 - September 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider thumbnails margin controls added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider responsive settings for Image Overlay added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider custom thumbnail option added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider custom CSS field for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Slide Image responsive position control added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay hover settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay responsive settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Price List - Price Prefix and Suffix fields added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery image animation options added<\\/li>\\n<li>Custom Map Marker being cropped issue fixed<\\/li>\\n<li>Hover Box double arrow icon issue fixed<\\/li>\\n<li>Testimonial Slider Random order issue fixed<\\/li>\\n<li>Image Showcase in hidden section causing JS error issue fixed<\\/li>\\n<li>Blog Slider active pagination color issue fixed<\\/li>\\n<li>Blog Slider Content custom CSS field added<\\/li>\\n<li>dipi-anim-preload class not removed from the body after the page is loaded issue fixed<\\/li>\\n<li>Image Showcase causing JS error when the module is hidden issue fixed<\\/li>\\n<li>CTA Menu Button text color when Menu module is used issue fixed<\\/li>\\n<li style=\\\"list-style-type: none;\\\"><\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.4.1 August 23rd 2021<\\/strong><\\/p>\\n<p>Divi 4.10+ compatibility<\\/p>\\n<ul>\\n<li>Carousel lightbox functionality issue fixed<\\/li>\\n<li>Masonry Gallery layout grid and lightbox issue fixed<\\/li>\\n<li>Preloader, when Defer jQuery and jQuery Migrate option is enabled issue fixed<\\/li>\\n<li>Image Slider when Defer jQuery and jQuery migrate option is enabled issue fixed<\\/li>\\n<li>Counter module when Dynamic JS Libraries option enabled issue fixed<\\/li>\\n<li>Price List module when Dynamic JS Libraries enabled lightbox issue fixed<\\/li>\\n<li>Testimonial Slider popup when Dynamic JS Libraries enabled issue fixed<\\/li>\\n<li>Conditional Display when Dynamic Module Framework enabled issue fixed<\\/li>\\n<\\/ul>\\n<p>Improvements\\/Fixes<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\"><strong>NEW:<\\/strong> Image Slider Autoplay settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Archive page Style 2 - broken layout on category pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4 August 18th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Hotspot responsive positioning settings added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Open Carousel image in lightbox option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Reverse Carousel slide direction when Autoplay option is enabled<\\/li>\\n<li><strong>NEW:<\\/strong> Price List image lightbox gallery option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Masonry Gallery image link option added<\\/li>\\n<li>Carousel item Box Shadow on hover issue fixed<\\/li>\\n<li>Sidebar customization issues fixed<\\/li>\\n<li>Testimonial Slider heading customization settings added<\\/li>\\n<li>Carousel reloading in builder issue fixed<\\/li>\\n<li>Price List responsive settings for the layout and image added<\\/li>\\n<li>Price List module Box Shadow option to the parent module added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.3.2 July 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li>Related Article hover activation issue fixed<\\/li>\\n<li>Footer social icons when credits are disabled issue fixed<\\/li>\\n<li>Menu CTA button - menu selection issue fixed<\\/li>\\n<li>Image Hotspot - tooltip button when Trigger on Click is enabled issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.3.1 July 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Menu CTA Button - option for selecting menu added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Showcase - 11 new mockups added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box text line-height default values fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs alignment responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Divi Builder plugin &amp; Extra theme compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Exclude Posts option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive Featured Image border-radius option added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p>2.3 July 7th 2021<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> FAQ module with Google Structured Data added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider - category class added for single post box<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.5 June 30th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added new Section, Row and Module settings to conditionally display content based on users role or a login status<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Suppress Filters option is added to use the attempted filter by other 3rd party plugins (like WPML)<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mobile Menu Hamburger icon browser compatibility improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline card width when the icon is used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module PHP 7.2 compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Rename Projects tab category slug issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.4 June 18th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">duplicated logo when multiple Theme Builder headers are used issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.3 June 16th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> apply blog archive style to the native Divi Blog module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> select image size for the Blog Slider module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Divi Library Shortcodes to use in any module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Option to hide \\u201cEdit in Visual Builder\\u201d link on pages\\/posts overview dashboard pages<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial Read More popup font customization settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider \\u201cOrder By\\u201d settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - hide tooltip option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - link field to the hotspot child added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot isn\\u2019t interactive anymore issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider HTML markup displayed for disabled elements issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Accordion TinyMCE editor support added for the description field<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image responsive scroll speed settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Panorama 2D Image mode scroll issue on tablets and mobiles fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider responsive settings for navigation size and padding added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider - testimonials order settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More link disabled when a full testimonial is displayed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mega Menu width issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Read More Button Text\\u201d doesn\\u2019t apply to the native Divi Blog module issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d doesn\\u2019t apply to the Theme Builder custom header issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Collapsed mobile top menu not clickable issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module visibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module displaying on archive pages issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs separator alignment issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Lottie Icon width not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Content Toggle\\/Masonry Gallery compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Full-width post does not display full-width sections in frontend Divi Builder issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.2 April 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: open tooltip on click<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: tooltip animations added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Carousel - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module margin in Divi Builder modules list issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Ballon button link target issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">plugin settings modules list updated<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider HTML support for review text added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image content animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon button shadow not applying in builder properly issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider not working with Blog module when testimonial CPT is selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module fetches taxonomy from pages where taxonomy is not added issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline line border styles issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial custom CSS for Profile Image selector fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.1 April 2nd, 2021<\\/strong><\\/p>\\n<ul>\\n<li>plugin updater issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.0 April 1st, 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Ballon module added<\\/li>\\n<li>Blog Slider item not clickable in Firefox browser issue fixed<\\/li>\\n<li>Content Toggle et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li>Content Toggle and Image Showcase compatibility improved<\\/li>\\n<li>Testimonial Slider popup\\/Divi Machine conflict issue fixed<\\/li>\\n<li>API licensing UI and functionality improved<\\/li>\\n<li>Documentation pages UI improved<\\/li>\\n<\\/ul>\\n<p><strong>2.1.2 March 8th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">Content Toggle issue with dipi_label function issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module dipi_label function replaced with esc_html__ function<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.1 March 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Disable LazyLoad in Content Toggle module settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Enable Lightbox responsive settings issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Plugin Settings\\/Modules options updated<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.0 - February 25th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Content Toggle module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Archive section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Post Navigation section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Author Box section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Related Articles section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Disable Lightbox responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d in Firefox displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d ON\\/OFF builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box circle icon issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box WPML support improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image\\/Icon alignment in Timeline not working in Divi Builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel Autoplay option doesn\\u2019t work in Safari issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel items displayed vertically in Safari 8 issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel child item hover icon not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Button Grid on mobiles improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Floating Images Transform settings not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box height controls improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box solid border issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase rendering with WP Rocket Lazy Loading in different browsers issues fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image mouse scrolling improved<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.0.1 - February 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW: <\\/strong>Masonry Gallery Coverflow Animations<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Masonry Gallery - disable image lightbox option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box jQuery variable naming issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">CSS error preventing Divi scripts from compile issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text child module link issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion image responsive settings improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image Active On Load and Open On Click issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">fonts in Theme Customizer did not enqueue issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.0.0 - January 26th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Timeline module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added CSS ID &amp; Classes to Button Grid child modules<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> WhatsApp, Snapchat and Xing social media icons added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Active Image size responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Opened on Load responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Performance improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Mask SVG markup issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase - image positioning tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Primary Header Social Icons positioning when CTA Button is not used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery image width causing the problem with the proper displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Button displaying multiple icons when icon not selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default content-length value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default spacing value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Error messages when Google reviews are fetched corrected<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image arrow color rendering in builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box name improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text alignment settings revised<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup displaying mixed testimonials issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup image styling issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.3 - December 16th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>collapsed mobile menu close animation fixed<\\/li>\\n<li>dropdown menu width max value increased<\\/li>\\n<li>Hamburger Mobile Menu not displayed after WP 5.6 issue fixed<\\/li>\\n<li>minor code improvements in Panorama and Lottie modules<\\/li>\\n<li>Carousel Coverflow mode - disabled slide shadow issue fixed<\\/li>\\n<li>Duplicated Social Icons in Primary Header issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.2 - December 7th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Breadcrumbs active item styles missed on front-end issue fixed<\\/li>\\n<li>Dropdown menu item width control added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.1 - December 5th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Carousel spacing issue fixed<\\/li>\\n<li>plugin package\\/2 new modules Divi Builder rendering issues fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.0 - December 4th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Showcase module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask module added<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS Class field added to the header CTA button<\\/li>\\n<li><strong>NEW:<\\/strong> Divi Builder support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Extra theme support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Post Type\\/Taxonomy settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Alignment settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Dynamic button URL to Grid Button module added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel module CSS ID &amp; Classes added to child items<\\/li>\\n<li>Vertical Navigation style issues fixed<\\/li>\\n<li>Testimonial Slider overflow issue fixed<\\/li>\\n<li>Mobile Menu animation out when Theme Builder header used issue fixed<\\/li>\\n<li>Blog Archive responsive breakpoint updated<\\/li>\\n<li>Hotspot tooltip height on mobiles issue fixed<\\/li>\\n<li>Blog Slider body text and button box-shadow issues fixed<\\/li>\\n<li>Admin Label field added to the Carousel child modules<\\/li>\\n<li>Tooltip image wrapper if image not selected - HTML markup not displayed<\\/li>\\n<li>Post meta alignment on archive page issue fixed<\\/li>\\n<li>Tilt Image mobile height issue fixed<\\/li>\\n<li>Footer Reveal Effect visibility in the front-end builder issue fixed<\\/li>\\n<li>Hide Admin Bar setting issue fixed<\\/li>\\n<li>Hide Admin Bar\\/Hide Top Header\\/Reading Progress Bar issues fixed<\\/li>\\n<li>Breadcrumbs Schema Markup issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.9 - 14 October 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Mobile Submenu customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Collapsed Mobile menu icon customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Circle animation for Mobile Menu background overlay added<\\/li>\\n<li>Menu Dropdown visibility with Theme Builder Header and Footer Reveal Effect enabled issue fixed<\\/li>\\n<li>default Mobile Menu animation performance issue fixed<\\/li>\\n<li>Centered Inline Logo header alignment fixed<\\/li>\\n<li>Centered header hamburger icon position fixed<\\/li>\\n<li>Stand and Spring style Hamburger icon animation issues fixed<\\/li>\\n<li>Fixed Mobile Menu container gap issue on mobiles fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.2 - 28th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>NEW: Add Arrow to Dropdown Menus<\\/li>\\n<li>NEW: Dropdown Menu width and position controls added<\\/li>\\n<li>NEW: Open Menu Button Link in a New Window option added<\\/li>\\n<li>Header Height\\/Spacing issues fixed<\\/li>\\n<li>Hide Top Bar feature improved<\\/li>\\n<li>Do Not Shrink Header on Scroll feature improved<\\/li>\\n<li>Social Icons in Secondary Menu Firefox issue fixed<\\/li>\\n<li>CTA Menu Button Position First\\/Last issue fixed<\\/li>\\n<li>Centered\\/Centered Inline header style issues fixed<\\/li>\\n<li>Top Bar performance on mobiles improved<\\/li>\\n<li>Mobile Menu paddings issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.1 - 15th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Fixed duplicated hamburger icons when more than one menu was used on a page<\\/li>\\n<li>Do Not Shrink Header functionality improved<\\/li>\\n<\\/ul>\\n<p><strong>1.8 - 13th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Magnifier module<\\/li>\\n<li><strong>NEW:<\\/strong> Lottie Icon module<\\/li>\\n<li>Plugin Settings page responsive issues fixed<\\/li>\\n<li>Plugin Settings Page Toolbar added<\\/li>\\n<li>Hide Admin Bar when user not logged in issue fixed<\\/li>\\n<li>Archive Page Header Injector issue fixed<\\/li>\\n<li>Bottom Bar customization issues fixed<\\/li>\\n<li>Back To Top custom link issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.7.1 - 28th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Panorama module PHP error for older PHP versions<\\/li>\\n<\\/ul>\\n<p><strong>1.7 - 27th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Panorama module<\\/li>\\n<li><strong>NEW:<\\/strong> Reading Progress Bar module<\\/li>\\n<li><strong>NEW:<\\/strong> Google icon to Social Icons added<\\/li>\\n<li>SVG image upload feature improved<\\/li>\\n<li>Force Footer to Bottom when Theme Builder used issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.6.2 - 20th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed an issue with social icons individual locations<\\/li>\\n<li>Fixed an issue with the revealing footer effect<\\/li>\\n<\\/ul>\\n<p><strong>1.6.1 - 15th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue in Divi Pixel options panel (WordPress 5.5 compatibility)<\\/li>\\n<li>Fixed an issue where individual social icon locations would break the menus<\\/li>\\n<\\/ul>\\n<p><strong>1.6.0 - 12th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Scrollable Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt text field added for Hover Box images<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Accordion Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS fields added to Accordion Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Tilt Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Hotspot Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List configurable HTML title tag option added<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Label field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Fixed responsive flex settings for Button Grid and added options for alignment and justification<\\/li>\\n<li><strong>NEW:<\\/strong> Login Page custom logo URL option added<\\/li>\\n<li><strong>NEW:<\\/strong> option to add links to images in Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> SVG image preview in Media Library added<\\/li>\\n<li>Tilt Image title customization issue fixed<\\/li>\\n<li>fixed issue with Theme Customizer scripts not loading on FlyWheel hosted sites<\\/li>\\n<li>Hover Box displaying empty heading tags issue fixed<\\/li>\\n<li>duplicated Prefix and Suffix spans in Typing Text module issue fixed<\\/li>\\n<li>Login Page logo size default values fixed<\\/li>\\n<li>Added option to Masonry Gallery to enable lazy loading images compatibility<\\/li>\\n<li>Automatically scroll to the top of the Divi Pixel options page after switching tabs<\\/li>\\n<li>Fixed Masonry Gallery not opening images in a lightbox<\\/li>\\n<li>Accordion Image responsive spacing issue fixed<\\/li>\\n<li>Carousel box-shadow and border child module issue fixed<\\/li>\\n<li>Carousel module left navigation positioning issue in builder fixed<\\/li>\\n<li>Flip Box content displaying issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.5.0 - 8th May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Accordion Module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box: added option to force the module to be a square<\\/li>\\n<li>Fixed \\\"open in new window\\\" option in various modules<\\/li>\\n<li>Improved SVG upload functionality to allow different mime types<\\/li>\\n<li>Fixed Related Articles and Author Box when Theme Builder is used<\\/li>\\n<li>Fixed Blog Slider default columns on tablet and mobiles<\\/li>\\n<li>Fixed \\\"Related Articles\\\" heading, which was sometimes displayed on custom post types<\\/li>\\n<li>Fixed Flex Direction responsive options in Typing Text module<\\/li>\\n<li>Fixed Image Hotspot heading level option in Visual Builder<\\/li>\\n<li>Fixed various typos<\\/li>\\n<li>Added some semicolons here and there to spice up the code (and fix some issues)<\\/li>\\n<\\/ul>\\n<p><strong>1.4.4 - 31st May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Flip Box Dynamic Height option added<\\/li>\\n<li><strong>NEW:<\\/strong> Flip Box: force module to be a square option added<\\/li>\\n<li>Flip Box Image Overlay builder issue fixed<\\/li>\\n<li>Flip Box icon not displayed on front-end issue fixed<\\/li>\\n<li>Primary Menu customization when Menu Hover Animation disabled issue fixed<\\/li>\\n<li>Masonry Gallery: IE browser issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.3 - 27th May 2020<\\/strong><\\/p>\\n<ul>\\n<li>Flip Box: height issue fixed<\\/li>\\n<li>Flip Box: Back Button not displayed on front-end issue fixed<\\/li>\\n<li>Flip Box: 3D Content Effect issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.2 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Flip Box module: Dynamic Height option removed<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.1 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Plugin Settings\\/Modules section updated<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.0 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Fancy Text module added<\\/li>\\n<li>Breadcrumbs Module: responsive padding options added<\\/li>\\n<li>Breadcrumbs: separator icon issue fixed<\\/li>\\n<li>Back To Top Button: box-shadow issue on hover fixed<\\/li>\\n<li>Back To Top Button: custom link issue fixed<\\/li>\\n<li>Menu CTA Button: hover text\\/background issue fixed<\\/li>\\n<li>Secondary Header menu\\/social icons positioning issue fixed<\\/li>\\n<li>Button Grid: icon size and positioning fixed<\\/li>\\n<li>Blog Archive: meta text icons positioning fixed<\\/li>\\n<li>Blog Slider image clickable option added<\\/li>\\n<li>Blog Slider: responsive image height option added<\\/li>\\n<li>Mobile Menu: Theme Builder header issues fixed<\\/li>\\n<li>Custom Mobile Breakpoint: all menu customization settings revised and improved<\\/li>\\n<li>Login Page: form field text size option added<\\/li>\\n<li>Login Page: logo size issue fixed, logo height option added<\\/li>\\n<li>Related Articles: section title font size issue fixed<\\/li>\\n<li>Testimonial Slider: read more popup size on mobiles issue fixed<\\/li>\\n<li>Header Menu: customization setting improved<\\/li>\\n<li>Hover Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Hover Box: module not displayed in Builder\\/Firefox issue fixed<\\/li>\\n<li>Hover Box: responsive height fixed<\\/li>\\n<li>Flip Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Image Hotspot, Hover Box, Flip Box, Carousel, Tilt Image: configurable HTML title tag option added<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.3.1 - 26th April 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed a bunch of smaller bugs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.0 - 20th April 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Blog Slider module<\\/li>\\n<li><strong>NEW<\\/strong>: Animation Delay option in Counter module<\\/li>\\n<li><strong>NEW:<\\/strong> Option to enable beta downloads<\\/li>\\n<li>Mobile Menu issue fixed<\\/li>\\n<li>Header\\/Menu Animation issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0 - 26th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Countdown module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box module<\\/li>\\n<li>Force Footer to Bottom Firefox issue fixed<\\/li>\\n<li>Filled Background menu animation style Firefox issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0 - 16th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Hotspot module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Export\\/Import functionality added to the Divi Pixel options panel<\\/li>\\n<li>Back to top button functionality improved<\\/li>\\n<li>Testimonial Slider mobile issues fixed<\\/li>\\n<li>Testimonial Slider Website URL field added<\\/li>\\n<li>The improved license activation process<\\/li>\\n<li>Licensing API Library updated<\\/li>\\n<\\/ul>\\n<p><strong>1.0.0 - 4th March 2020<\\/strong><\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"]}\";}", "no");
INSERT INTO `z8ei5_options` VALUES("348", "category_children", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("387", "aiowpsec_db_version", "2.0.4", "yes");
INSERT INTO `z8ei5_options` VALUES("388", "aio_wp_security_configs", "a:107:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:0:\"\";s:28:\"aiowps_allow_unlock_requests\";s:1:\"1\";s:25:\"aiowps_max_login_attempts\";s:1:\"3\";s:24:\"aiowps_retry_time_period\";s:1:\"5\";s:26:\"aiowps_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:35:\"n.ait@siconsulting-certification.fr\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"kbzckoom29rum87rl1dk\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"uhirkipysle617sitg8w\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:0:\"\";s:26:\"aiowps_db_backup_frequency\";s:1:\"4\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:26:\"aiowps_backup_files_stored\";s:1:\"2\";s:32:\"aiowps_send_backup_email_address\";s:0:\"\";s:27:\"aiowps_backup_email_address\";s:35:\"n.ait@siconsulting-certification.fr\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:0:\"\";s:27:\"aiowps_max_file_upload_size\";s:2:\"10\";s:31:\"aiowps_enable_pingback_firewall\";s:1:\"0\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:1:\"0\";s:29:\"aiowps_deny_bad_query_strings\";s:1:\"0\";s:34:\"aiowps_advanced_char_string_filter\";s:1:\"0\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:35:\"n.ait@siconsulting-certification.fr\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:36:\"aiowps_enable_php_backtrace_in_email\";s:0:\"\";s:30:\"aiowps_max_lockout_time_length\";s:2:\"60\";s:35:\"aiowps_disable_application_password\";s:1:\"1\";s:33:\"aiowps_enable_trash_spam_comments\";s:0:\"\";s:37:\"aiowps_trash_spam_comments_after_days\";s:2:\"14\";s:36:\"aiowps_on_uninstall_delete_db_tables\";s:1:\"1\";s:34:\"aiowps_on_uninstall_delete_configs\";s:1:\"1\";s:12:\"installed-at\";i:1665068452;s:25:\"aiowps_ip_retrieve_method\";i:0;s:22:\"aiowps_default_captcha\";s:0:\"\";s:33:\"aiowps_disable_rss_and_atom_feeds\";s:0:\"\";s:25:\"aiowps_turnstile_site_key\";s:0:\"\";s:27:\"aiowps_turnstile_secret_key\";s:0:\"\";s:31:\"aiowps_enable_spambot_detecting\";s:0:\"\";s:27:\"aiowps_spam_comments_should\";s:0:\"\";s:21:\"aios_firewall_dismiss\";b:0;}", "yes");
INSERT INTO `z8ei5_options` VALUES("400", "wps_cleaner_alert", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("401", "wps_cleaner_version", "20180601", "no");
INSERT INTO `z8ei5_options` VALUES("415", "action_scheduler_hybrid_store_demarkation", "15", "yes");
INSERT INTO `z8ei5_options` VALUES("416", "schema-ActionScheduler_StoreSchema", "6.0.1655340810", "yes");
INSERT INTO `z8ei5_options` VALUES("417", "schema-ActionScheduler_LoggerSchema", "3.0.1655340810", "yes");
INSERT INTO `z8ei5_options` VALUES("422", "wpr_rucss_used_css_version", "20221104", "yes");
INSERT INTO `z8ei5_options` VALUES("442", "action_scheduler_lock_async-request-runner", "1694003699", "yes");
INSERT INTO `z8ei5_options` VALUES("445", "edd_sl_40296a3e9440833e559c5421d677fd29", "a:2:{s:7:\"timeout\";i:1669027917;s:5:\"value\";s:108946:\"{\"new_version\":\"2.18\",\"stable_version\":\"2.18\",\"name\":\"Divi Pixel\",\"slug\":\"divi-pixel\",\"url\":\"https:\\/\\/www.divi-pixel.com\\/product\\/divi-pixel\\/?changelog=1\",\"last_updated\":\"2022-11-17 16:16:57\",\"homepage\":\"https:\\/\\/www.divi-pixel.com\\/product\\/divi-pixel\\/\",\"package\":\"https:\\/\\/www.divi-pixel.com\\/edd-sl\\/package_download\\/MTY2OTYyNTUxNzplYWQyMzc4ZmEzOGMzMGUyMGE3ZGI1NDVjY2RjYzYzMjozMjcxODo0MzYyYWM1NTE2ZjMxYTBkMTNiOWQ1YWQ4NWU4MGU2YjpodHRwc0AvL3d3dy50dXJuZXlza2lsbGZvcm1hdGlvbi5mcjow\",\"download_link\":\"https:\\/\\/www.divi-pixel.com\\/edd-sl\\/package_download\\/MTY2OTYyNTUxNzplYWQyMzc4ZmEzOGMzMGUyMGE3ZGI1NDVjY2RjYzYzMjozMjcxODo0MzYyYWM1NTE2ZjMxYTBkMTNiOWQ1YWQ4NWU4MGU2YjpodHRwc0AvL3d3dy50dXJuZXlza2lsbGZvcm1hdGlvbi5mcjow\",\"sections\":{\"description\":\"<p>[et_pb_section fb_built=\\\"1\\\" admin_label=\\\"section\\\" _builder_version=\\\"4.16\\\" global_colors_info=\\\"{}\\\"][et_pb_row admin_label=\\\"row\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"][et_pb_column type=\\\"4_4\\\" _builder_version=\\\"4.16\\\" custom_padding=\\\"|||\\\" global_colors_info=\\\"{}\\\" custom_padding__hover=\\\"|||\\\"][et_pb_text admin_label=\\\"Text\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"]<br \\/>\\nDivi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals. Create amazing websites using powerful Divi Pixels modules and settings.<br \\/>\\n[\\/et_pb_text][\\/et_pb_column][\\/et_pb_row][\\/et_pb_section]<\\/p>\\n\",\"changelog\":\"<p><strong>2.18 November 17th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Layout Importer<\\/li>\\n<li><strong>NEW:<\\/strong> Reveal Before &amp; After Slider image after the label is clicked<\\/li>\\n<li><strong>NEW:<\\/strong> Added CPT support and Post Status to Blog Slider module<\\/li>\\n<li><strong>NEW:<\\/strong> Added dynamic field to Scroll Image module<\\/li>\\n<li><strong>NEW:<\\/strong> \\u201cHide All Modules\\u201d option added<\\/li>\\n<li>Fixed Advanced Tabs issue where content is not displayed in the builder<\\/li>\\n<li>Fixed Popup position issue on category pages<\\/li>\\n<li>Fixed popup periodicity function not working<\\/li>\\n<li>Fixed Contact Form success message not displayed in the Popup Maker<\\/li>\\n<li>Fixed the Carousel issue when used in the Balloon module<\\/li>\\n<li>Fixed header white gap when resizing the browser<\\/li>\\n<li>Fixed Hover Box PHP notice<\\/li>\\n<li>Fixed Image Showcase displaying link cursor when the link is not added<\\/li>\\n<li>Improved spacing settings for the Fancy Text animated text<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.17 October 26th, 2022<\\/strong><\\/p>\\n<ul>\\n<li>NEW: Filterable Gallery for Divi<\\/li>\\n<li>Fixed Menu CTA Button placement issue in the Safari browser<\\/li>\\n<li>Added Carousel navigation responsive settings<\\/li>\\n<li>Fixed Floating Images animation in Safari browser<\\/li>\\n<li>Fixed Blurb icon placement issue caused by the Advanced Tabs responsive icon settings<\\/li>\\n<li>Fixed duplicated content showing on hover in the Advanced Tabs module<\\/li>\\n<li>Fixed Advanced Tabs not showing inside the Balloon module<\\/li>\\n<li>Fixed hamburger mobile menu animation when multiple menus are used<\\/li>\\n<li>Fixed duplicated mobile menu displayed on CPT pages<\\/li>\\n<li>Fixed the Panorama module not working with the LatePoint plugin<\\/li>\\n<li>Fixed Popup Maker page search functionality<\\/li>\\n<li>Added Line social network<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.16.1 September 14th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added continuous slide animation to the Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Added option to make website elements clickable when the popup is opened<\\/li>\\n<li><strong>NEW:<\\/strong> Added Horizontal Timeline active line position setting<\\/li>\\n<li><strong>NEW:<\\/strong> Added responsive tab icon\\/image placement settings to the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Added list customization settings to the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Added Typing Text start animation in viewport<\\/li>\\n<li><strong>NEW:<\\/strong> Added responsive image count option to the Masonry Gallery module<\\/li>\\n<li><strong>NEW:<\\/strong> Added option to use custom images for Timeline line<\\/li>\\n<li>Fixed Expanding CTA button dynamic link issue<\\/li>\\n<li>Fixed Popup Maker Guest user role not saving<\\/li>\\n<li>Fixed Popup video still playing when the popup is closed<\\/li>\\n<li>Fixed Pricing Table module still available in the Divi Builder when the module is hidden<\\/li>\\n<li>Fixed Masonry Gallery rendering issue when used in the Advanced Tabs module<\\/li>\\n<li>Fixed testimonial length not working with the Chinese language<\\/li>\\n<li>Fixed Image Showcase rendering issues in Safari and Firefox browsers<\\/li>\\n<li>Fixed Horizontal Timeline SVG image not showing<\\/li>\\n<li>Fixed Advanced Tabs default tab issue<\\/li>\\n<li>Fixed Advanced Tabs duplicated tab icons when Theme Builder for product template is used<\\/li>\\n<li>Fixed Carousel equal height issue<\\/li>\\n<li>Fixed Carousel Module duplicated box-shadow, borders, padding, and margins in the builder<\\/li>\\n<li>Fixed Carousel Image hover effect transition<\\/li>\\n<li>Fixed FAQ module title alignment not working<\\/li>\\n<li>Fixed Expanding CTA responsive font size settings not working<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.16 July 27th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Pricing Table module<\\/li>\\n<li><strong>NEW:<\\/strong> Advanced Tabs activate on hover option added<\\/li>\\n<li>Improved Divi Builder plugin and Extra Theme support<\\/li>\\n<li>Improved hamburger script and placed it in external JS file so it can be excluded from Delayed JavaScript Execution<\\/li>\\n<li>Fixed Advanced Tabs content width issue on tablets and mobiles<\\/li>\\n<li>Fixed Popup Maker On Load issue in front-end builder<\\/li>\\n<li>Fixed Popup Maker saving issue<\\/li>\\n<li>Fixed customization functionality when the Divi Builder plugin is used<\\/li>\\n<li>Fixed a bug that caused Divi Pixel to not add the Theme Customizer settings<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.15.1 July 9th, 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Image Slider Loop option not working<\\/li>\\n<li>Fixed not working Custom Map Marker<\\/li>\\n<li>Fixed nonce_check in Popup Maker<\\/li>\\n<li>Fixed et_pb_get_specific_default_font function error<\\/li>\\n<li>Improved Breadcrumbs schema markup<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.15.0 - July 6th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Tile Scroll module<\\/li>\\n<li>Added option to activate\\/deactivate popups from the Popup Maker CPT dashboard<\\/li>\\n<li>Added option to close popup when browser back button is clicked<\\/li>\\n<li>Added Triggering column to the Popup Maker CPT screen<\\/li>\\n<li>Added z-index control for the Popup Maker overlay<\\/li>\\n<li>Added quick preview option to Popup Maker<\\/li>\\n<li>Added support for Divi Ghoster plugin<\\/li>\\n<li>Added Horizontal Order Direction to Masonry Gallery module<\\/li>\\n<li>Added responsive mockup images to the Image Showcase module<\\/li>\\n<li>Fixed FAQ module collapsed icon alignment issue<\\/li>\\n<li>Fixed Info Circle dynamic button link issue<\\/li>\\n<li>Fixed Image Hotspot responsive tooltip displaying issue<\\/li>\\n<li>Fixed dynamic button link in Advanced Tabs and Info Circle modules<\\/li>\\n<li>Fixed SVG Animator triggers animation during customizing other modules<\\/li>\\n<li>Fixed not working responsive Fullwidth Tabs option in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.14.0 - June 22nd, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Popup Maker for Divi<\\/li>\\n<li>Added title H tag control to FAQ module<\\/li>\\n<li>Fixed Horizontal Timeline image\\/icon position responsive settings<\\/li>\\n<li>Fixed Horizontal Timeline navigation not working on mobiles<\\/li>\\n<li>Fixed Collapsed Mobile Menu icon issue for closed menu<\\/li>\\n<li>Fixed duplicated Google testimonials added during fetching<\\/li>\\n<li>Fixed Back To Top Button icon issue when circle double arrow icon is selected<\\/li>\\n<li>Fixed Masonry Gallery manual order issue<\\/li>\\n<li>Fixed not working Advanced Tabs tab image alignment<\\/li>\\n<li>Fixed Advanced Tabs content area margin issue<\\/li>\\n<li>Fixed Expanding CTA overlay height issue on Android mobiles<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.13.0 - June 8th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added Text Highlighter module<\\/li>\\n<li>Added option to select the active tab on load in Advanced Tabs module<\\/li>\\n<li>Added ordering settings to Masonry Gallery module<\\/li>\\n<li>Fixed particles background issue when parallax option is enabled<\\/li>\\n<li>Fixed Theme Customizer toggles not displaying the correct value<\\/li>\\n<li>Fixed button icons not working when the Dynamic CSS is enabled<\\/li>\\n<li>Fixed Carousel button link dynamic option<\\/li>\\n<li>Fixed collapsed submenu not working when Theme Builder Menu module used<\\/li>\\n<li>Fixed Timeline animations not working in Firefox and Safari browsers<\\/li>\\n<li>Fixed not loading Divi Pixel font when the user is logged in<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.12.0 - May 26th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Particles Background effect<\\/li>\\n<li>Fixed Hotspot Image unwanted square element displayed below module when Lazy Load is used<\\/li>\\n<li>Added animation settings to child modules in the Timeline module<\\/li>\\n<li>Added Image Slider heading customization settings for H tags placed in the description<\\/li>\\n<li>Updated PHP 8 depreciated functions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.11.0 - May 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Expanding CTA module<\\/li>\\n<li>Fixed Advanced Tabs button target issue<\\/li>\\n<li>Fixed Image Gallery navigation issue when used in Advanced Tabs module<\\/li>\\n<li>Fixed Carousel description HTML markup displayed when not used<\\/li>\\n<li>Fixed Carousel image box-shadow issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.10 - May 9th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Maintenance Mode feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Allow TTF, OTF and WOFF file uploads<\\/li>\\n<li>Fixed Image Slider issue when used in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.9 - May 5th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Horizontal Timeline module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added option to add overlay image for Scroll Image module and set reveal effect<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added Animate in Viewport and Delay options to the Lottie Icon module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added reverse direction animation for autorotate option in Info Circle module<\\/li>\\n<li>Improved JavaScript for Balloon module to address issues when used in Theme Builder<\\/li>\\n<li>Added Telegram social media icon<\\/li>\\n<li>Added link customization settings to FAQ module<\\/li>\\n<li>Added Carousel image\\/icon hover option<\\/li>\\n<li>Fixed Floating Images animations not working in Safari and iOS 15.4.1<\\/li>\\n<li>Fixed Fancy Text prefix goes out of the screen issue<\\/li>\\n<li>Fixed Dual Heading background text displayed in Divi Builder when not used<\\/li>\\n<li>Fixed Advanced Tabs Divi Library item width issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.8 - April 25th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Advanced Tabs module<\\/li>\\n<li>Fixed Image Slider custom thumbnails not displayed on front-end<\\/li>\\n<li>Fixed Image Slider title formatting and HTML tag displayed on front-end<\\/li>\\n<li>Fixed Image Hotspot mobile issue<\\/li>\\n<li>Fixed Image Hotspot box shadow and border-radius issue<\\/li>\\n<li>Fixed Hover Box and Flip Box gradient migration issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.2 - April 13th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Author Box and Menu CTA Button font issue<\\/li>\\n<li>Fixed Panorama video controls not working in Safari browser<\\/li>\\n<li>Fixed Panorama default height value not working<\\/li>\\n<li>Fixed Image Slider custom navigation not displayed on the frontend<\\/li>\\n<li>Fixed Divi Pixel settings import issue<\\/li>\\n<li>Fixed Masonry Gallery icon border not working<\\/li>\\n<li>Fixed Dual Heading background animation issue<\\/li>\\n<li>Fixed module link not working in Balloon module<\\/li>\\n<li>Fixed dropdown link background color not working with Theme Builder header<\\/li>\\n<li>Added multi-select field for CTA menu button<\\/li>\\n<li>Added gradient migration for new gradient builder to retain old values<\\/li>\\n<li>Added dynamic images and content to Before &amp; After Slider module<\\/li>\\n<li>Added dynamic content fields to the Grid Button module<\\/li>\\n<li>Added dynamic labels to the Content Toggle module<\\/li>\\n<li>Added dynamic prefix and suffix fields to the Counter module<\\/li>\\n<li>Added dynamic heading content to the Dual Heading module<\\/li>\\n<li>Added dynamic fields for prefix and suffix in Fancy Text module<\\/li>\\n<li>Added dynamic image and image link fields to the Floating Images module<\\/li>\\n<li>Added dynamic image and content fields to Accordion Image module<\\/li>\\n<li>Added dynamic images and content fields to the Image Hotspot module<\\/li>\\n<li>Added dynamic images and content fields to the Balloon module<\\/li>\\n<li>Added dynamic images and content fields to the Carousel module<\\/li>\\n<li>Added dynamic images and content fields to the Flip Box module<\\/li>\\n<li>Added dynamic images and content fields to the Hover Box module<\\/li>\\n<li>Added dynamic images fields to the Image Magnifier module<\\/li>\\n<li>Added dynamic images fields to the Image Mask module<\\/li>\\n<li>Added dynamic images fields to the Image Showcase module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.1 - April 6th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Added Projects category and tag slug options<\\/li>\\n<li>Added CSS ID &amp; Classes fields to Image Accordion child items<\\/li>\\n<li>Added Half Circle option to the Counter module<\\/li>\\n<li>Added new gradient support to Divi Pixel modules<\\/li>\\n<li>Added image placeholder to Tilt Image module<\\/li>\\n<li>Fixed Circle Info Button margin not working<\\/li>\\n<li>Fixed Circle Info icon height issue<\\/li>\\n<li>Fixed Circle Info content switch on mobiles not working<\\/li>\\n<li>Fixed Circle Info icons not displayed in Firefox\\/Safari when icon animation is enabled<\\/li>\\n<li>Fixed Facebook and Google API code causing an error on cron<\\/li>\\n<li>Fixed Panorama responsive height issue<\\/li>\\n<li>Fixed Carousel, Content Toggle &amp; Balloon fatal errors sent to the email after WP autosave is triggered<\\/li>\\n<li>Fixed Carousel pagination responsive settings issue<\\/li>\\n<li>Fixed Carousel arrow navigation not working on mobile devices<\\/li>\\n<li>Fixed Masonry Gallery circle icon issue in builder<\\/li>\\n<li>Fixed Image Hotspot spacing issue in Firefox\\/Safari browsers<\\/li>\\n<li>Updated cron timing frequency for license check (twice daily)<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7 February 23rd 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Info Circle module added<\\/li>\\n<li>Updated Google social media icon<\\/li>\\n<li>Updated Snapchat and TikTok SVG images creating an error<\\/li>\\n<li>Updated Image Hotspot position value step to 0.1<\\/li>\\n<li>Updated hotspot icon line height causing hotspot icon to be not perfectly centred<\\/li>\\n<li>Improved Scroll Image horizontal mouse scroll performance<\\/li>\\n<li>Improved preloader performance<\\/li>\\n<li>Fixed Tilt Image glare effect<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Panorama rendering issues in Divi Builder when the video is used<\\/li>\\n<li>Fixed Panorama height not working when the video is used<\\/li>\\n<li>Fixed Flip Box back button padding not working<\\/li>\\n<li>Fixed Dual Heading module bottom margin and padding not working<\\/li>\\n<li>Fixed Dual Heading text background clipping for the 2nd text not working<\\/li>\\n<li>Fixed Carousel image border radius when box-shadow added not applying properly<\\/li>\\n<li>Fixed custom blog layout style not applying when Theme Builder template is used<\\/li>\\n<li>Fixed Image Slider Divi Library shortcodes not rendering<\\/li>\\n<li>Fixed dropdown arrow displayed on child submenus<\\/li>\\n<li>Fixed Search icon position when CTA Button not used<\\/li>\\n<li>Added support for PHP 8<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6.1 January 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added language settings for Google testimonials<\\/li>\\n<li><strong>NEW:<\\/strong> Added options to Exclude\\/Include Testimonials by Post ID<\\/li>\\n<li><strong>NEW:<\\/strong> Added 9 new animations to the Floating Images module<\\/li>\\n<li>Updated Floating Images position max and min values<\\/li>\\n<li>Fixed Floating Images transition CSS not working<\\/li>\\n<li>Fixed issue with Menu Hover Effect applies to the centred header logo<\\/li>\\n<li>Fixed Blog Slider random order not working<\\/li>\\n<li>Fixed not working link in Carousel child module<\\/li>\\n<li>Removed Carousel button wrapper HTML markup when the button is not used<\\/li>\\n<li>Added Soundcloud and TikTok icons to Social Media settings<\\/li>\\n<li>Added CSS ID &amp; Classes field to the Image Hotspot child module<\\/li>\\n<li>Added dynamic image support for Image Slider module (front-end only)<\\/li>\\n<li>Fixed JS error after searching when post meta section is empty<\\/li>\\n<li>Fixed Image Slider text displayed on sides when 3D Cube mode is used<\\/li>\\n<li>Fixed SVG Animator default width and height not working in Safari browser<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Tilt Image flickering issue in Chrome browser<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6 December 8th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> SVG Animator module added<\\/li>\\n<li>Image Slider thumbnails height various units support added<\\/li>\\n<li>Blog Slider backward PHP (&lt;7.2) compatibility issue fixed<\\/li>\\n<li>custom styles did not apply on paginated blog pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.3 November 26th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\" data-border-radius-top-cap=\\\"false\\\" data-border-radius-bottom-cap=\\\"false\\\">\\n<li><strong>NEW:<\\/strong> Image Accordion Always Visible new settings for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Showcase individual images links feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider featured image animation effects added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel image animation settings added<\\/li>\\n<li><strong>NEW:<\\/strong> All Divi Pixel modules support new Divi icons<\\/li>\\n<li>Carousel new custom CSS for active slide added<\\/li>\\n<li>Blog Slider navigation responsive settings added<\\/li>\\n<li>Blog Slider featured image border and box-shadow customization settings added<\\/li>\\n<li>Blog Slider new Custom CSS fields for navigation and active slide added<\\/li>\\n<li>Blog Slider pagination not working in builder when multiple instances used issue fixed<\\/li>\\n<li>Content Toggle new Custom CSS fields for toggle button added<\\/li>\\n<li>Image Mask shape 7 not displayed properly on front end issue fixed<\\/li>\\n<li>Masonry Gallery Grid Items border not working issue fixed<\\/li>\\n<li>Accordion module not triggered in Carousel module issue fixed<\\/li>\\n<li>Dropdown menu text color not working on fixed header issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.2 October 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 28 new masks added to the Image Mask module<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask selector field improved<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask: option to rotate, scale and flip the mask<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask image Alt Text field added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask upload custom shape option added<\\/li>\\n<li>Image Mask placeholder image added<\\/li>\\n<li>Image Showcase module URL issue fixed<\\/li>\\n<li>Carousel Autoplay stops working when the Pause on Hover option is disabled issue fixed<\\/li>\\n<li>Carousel item doesn\\u2019t take full width when short content is added issue fixed<\\/li>\\n<li>Countdown Timer doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Counter module doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Image Magnifier module doesn\\u2019t work in builder issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1 September 30th 2021<\\/strong><\\/p>\\n<ul>\\n<li>FAQ module categories missed issue fixed<\\/li>\\n<li>Custom preloader not working issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5 September 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Dual Heading module added<\\/li>\\n<li>Mobile Menu on WooCommerce pages issues fixed<\\/li>\\n<li>Blog archive custom style not applying for pagination pages issue fixed<\\/li>\\n<li>Image Hotspot tooltip displaying when border radius on the image is used issue fixed<\\/li>\\n<li>Image Hotspot tooltip image default width not applying in the builder issue fixed<\\/li>\\n<li>Image Hotspot new Ripple Effect style added<\\/li>\\n<li>Image Hotspot default image placeholder added<\\/li>\\n<li>Image Hotspot tooltip spacing in builder issue fixed<\\/li>\\n<li>Improved backwards compatibility with outdated PHP versions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4.2 - September 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider thumbnails margin controls added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider responsive settings for Image Overlay added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider custom thumbnail option added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider custom CSS field for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Slide Image responsive position control added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay hover settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay responsive settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Price List - Price Prefix and Suffix fields added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery image animation options added<\\/li>\\n<li>Custom Map Marker being cropped issue fixed<\\/li>\\n<li>Hover Box double arrow icon issue fixed<\\/li>\\n<li>Testimonial Slider Random order issue fixed<\\/li>\\n<li>Image Showcase in hidden section causing JS error issue fixed<\\/li>\\n<li>Blog Slider active pagination color issue fixed<\\/li>\\n<li>Blog Slider Content custom CSS field added<\\/li>\\n<li>dipi-anim-preload class not removed from the body after the page is loaded issue fixed<\\/li>\\n<li>Image Showcase causing JS error when the module is hidden issue fixed<\\/li>\\n<li>CTA Menu Button text color when Menu module is used issue fixed<\\/li>\\n<li style=\\\"list-style-type: none;\\\"><\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.4.1 August 23rd 2021<\\/strong><\\/p>\\n<p>Divi 4.10+ compatibility<\\/p>\\n<ul>\\n<li>Carousel lightbox functionality issue fixed<\\/li>\\n<li>Masonry Gallery layout grid and lightbox issue fixed<\\/li>\\n<li>Preloader, when Defer jQuery and jQuery Migrate option is enabled issue fixed<\\/li>\\n<li>Image Slider when Defer jQuery and jQuery migrate option is enabled issue fixed<\\/li>\\n<li>Counter module when Dynamic JS Libraries option enabled issue fixed<\\/li>\\n<li>Price List module when Dynamic JS Libraries enabled lightbox issue fixed<\\/li>\\n<li>Testimonial Slider popup when Dynamic JS Libraries enabled issue fixed<\\/li>\\n<li>Conditional Display when Dynamic Module Framework enabled issue fixed<\\/li>\\n<\\/ul>\\n<p>Improvements\\/Fixes<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\"><strong>NEW:<\\/strong> Image Slider Autoplay settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Archive page Style 2 - broken layout on category pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4 August 18th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Hotspot responsive positioning settings added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Open Carousel image in lightbox option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Reverse Carousel slide direction when Autoplay option is enabled<\\/li>\\n<li><strong>NEW:<\\/strong> Price List image lightbox gallery option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Masonry Gallery image link option added<\\/li>\\n<li>Carousel item Box Shadow on hover issue fixed<\\/li>\\n<li>Sidebar customization issues fixed<\\/li>\\n<li>Testimonial Slider heading customization settings added<\\/li>\\n<li>Carousel reloading in builder issue fixed<\\/li>\\n<li>Price List responsive settings for the layout and image added<\\/li>\\n<li>Price List module Box Shadow option to the parent module added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.3.2 July 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li>Related Article hover activation issue fixed<\\/li>\\n<li>Footer social icons when credits are disabled issue fixed<\\/li>\\n<li>Menu CTA button - menu selection issue fixed<\\/li>\\n<li>Image Hotspot - tooltip button when Trigger on Click is enabled issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.3.1 July 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Menu CTA Button - option for selecting menu added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Showcase - 11 new mockups added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box text line-height default values fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs alignment responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Divi Builder plugin &amp; Extra theme compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Exclude Posts option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive Featured Image border-radius option added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p>2.3 July 7th 2021<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> FAQ module with Google Structured Data added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider - category class added for single post box<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.5 June 30th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added new Section, Row and Module settings to conditionally display content based on users role or a login status<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Suppress Filters option is added to use the attempted filter by other 3rd party plugins (like WPML)<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mobile Menu Hamburger icon browser compatibility improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline card width when the icon is used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module PHP 7.2 compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Rename Projects tab category slug issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.4 June 18th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">duplicated logo when multiple Theme Builder headers are used issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.3 June 16th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> apply blog archive style to the native Divi Blog module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> select image size for the Blog Slider module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Divi Library Shortcodes to use in any module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Option to hide \\u201cEdit in Visual Builder\\u201d link on pages\\/posts overview dashboard pages<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial Read More popup font customization settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider \\u201cOrder By\\u201d settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - hide tooltip option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - link field to the hotspot child added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot isn\\u2019t interactive anymore issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider HTML markup displayed for disabled elements issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Accordion TinyMCE editor support added for the description field<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image responsive scroll speed settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Panorama 2D Image mode scroll issue on tablets and mobiles fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider responsive settings for navigation size and padding added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider - testimonials order settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More link disabled when a full testimonial is displayed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mega Menu width issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Read More Button Text\\u201d doesn\\u2019t apply to the native Divi Blog module issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d doesn\\u2019t apply to the Theme Builder custom header issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Collapsed mobile top menu not clickable issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module visibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module displaying on archive pages issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs separator alignment issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Lottie Icon width not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Content Toggle\\/Masonry Gallery compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Full-width post does not display full-width sections in frontend Divi Builder issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.2 April 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: open tooltip on click<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: tooltip animations added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Carousel - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module margin in Divi Builder modules list issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Ballon button link target issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">plugin settings modules list updated<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider HTML support for review text added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image content animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon button shadow not applying in builder properly issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider not working with Blog module when testimonial CPT is selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module fetches taxonomy from pages where taxonomy is not added issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline line border styles issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial custom CSS for Profile Image selector fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.1 April 2nd, 2021<\\/strong><\\/p>\\n<ul>\\n<li>plugin updater issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.0 April 1st, 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Ballon module added<\\/li>\\n<li>Blog Slider item not clickable in Firefox browser issue fixed<\\/li>\\n<li>Content Toggle et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li>Content Toggle and Image Showcase compatibility improved<\\/li>\\n<li>Testimonial Slider popup\\/Divi Machine conflict issue fixed<\\/li>\\n<li>API licensing UI and functionality improved<\\/li>\\n<li>Documentation pages UI improved<\\/li>\\n<\\/ul>\\n<p><strong>2.1.2 March 8th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">Content Toggle issue with dipi_label function issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module dipi_label function replaced with esc_html__ function<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.1 March 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Disable LazyLoad in Content Toggle module settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Enable Lightbox responsive settings issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Plugin Settings\\/Modules options updated<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.0 - February 25th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Content Toggle module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Archive section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Post Navigation section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Author Box section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Related Articles section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Disable Lightbox responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d in Firefox displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d ON\\/OFF builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box circle icon issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box WPML support improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image\\/Icon alignment in Timeline not working in Divi Builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel Autoplay option doesn\\u2019t work in Safari issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel items displayed vertically in Safari 8 issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel child item hover icon not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Button Grid on mobiles improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Floating Images Transform settings not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box height controls improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box solid border issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase rendering with WP Rocket Lazy Loading in different browsers issues fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image mouse scrolling improved<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.0.1 - February 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW: <\\/strong>Masonry Gallery Coverflow Animations<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Masonry Gallery - disable image lightbox option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box jQuery variable naming issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">CSS error preventing Divi scripts from compile issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text child module link issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion image responsive settings improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image Active On Load and Open On Click issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">fonts in Theme Customizer did not enqueue issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.0.0 - January 26th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Timeline module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added CSS ID &amp; Classes to Button Grid child modules<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> WhatsApp, Snapchat and Xing social media icons added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Active Image size responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Opened on Load responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Performance improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Mask SVG markup issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase - image positioning tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Primary Header Social Icons positioning when CTA Button is not used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery image width causing the problem with the proper displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Button displaying multiple icons when icon not selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default content-length value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default spacing value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Error messages when Google reviews are fetched corrected<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image arrow color rendering in builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box name improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text alignment settings revised<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup displaying mixed testimonials issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup image styling issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.3 - December 16th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>collapsed mobile menu close animation fixed<\\/li>\\n<li>dropdown menu width max value increased<\\/li>\\n<li>Hamburger Mobile Menu not displayed after WP 5.6 issue fixed<\\/li>\\n<li>minor code improvements in Panorama and Lottie modules<\\/li>\\n<li>Carousel Coverflow mode - disabled slide shadow issue fixed<\\/li>\\n<li>Duplicated Social Icons in Primary Header issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.2 - December 7th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Breadcrumbs active item styles missed on front-end issue fixed<\\/li>\\n<li>Dropdown menu item width control added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.1 - December 5th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Carousel spacing issue fixed<\\/li>\\n<li>plugin package\\/2 new modules Divi Builder rendering issues fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.0 - December 4th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Showcase module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask module added<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS Class field added to the header CTA button<\\/li>\\n<li><strong>NEW:<\\/strong> Divi Builder support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Extra theme support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Post Type\\/Taxonomy settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Alignment settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Dynamic button URL to Grid Button module added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel module CSS ID &amp; Classes added to child items<\\/li>\\n<li>Vertical Navigation style issues fixed<\\/li>\\n<li>Testimonial Slider overflow issue fixed<\\/li>\\n<li>Mobile Menu animation out when Theme Builder header used issue fixed<\\/li>\\n<li>Blog Archive responsive breakpoint updated<\\/li>\\n<li>Hotspot tooltip height on mobiles issue fixed<\\/li>\\n<li>Blog Slider body text and button box-shadow issues fixed<\\/li>\\n<li>Admin Label field added to the Carousel child modules<\\/li>\\n<li>Tooltip image wrapper if image not selected - HTML markup not displayed<\\/li>\\n<li>Post meta alignment on archive page issue fixed<\\/li>\\n<li>Tilt Image mobile height issue fixed<\\/li>\\n<li>Footer Reveal Effect visibility in the front-end builder issue fixed<\\/li>\\n<li>Hide Admin Bar setting issue fixed<\\/li>\\n<li>Hide Admin Bar\\/Hide Top Header\\/Reading Progress Bar issues fixed<\\/li>\\n<li>Breadcrumbs Schema Markup issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.9 - 14 October 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Mobile Submenu customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Collapsed Mobile menu icon customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Circle animation for Mobile Menu background overlay added<\\/li>\\n<li>Menu Dropdown visibility with Theme Builder Header and Footer Reveal Effect enabled issue fixed<\\/li>\\n<li>default Mobile Menu animation performance issue fixed<\\/li>\\n<li>Centered Inline Logo header alignment fixed<\\/li>\\n<li>Centered header hamburger icon position fixed<\\/li>\\n<li>Stand and Spring style Hamburger icon animation issues fixed<\\/li>\\n<li>Fixed Mobile Menu container gap issue on mobiles fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.2 - 28th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>NEW: Add Arrow to Dropdown Menus<\\/li>\\n<li>NEW: Dropdown Menu width and position controls added<\\/li>\\n<li>NEW: Open Menu Button Link in a New Window option added<\\/li>\\n<li>Header Height\\/Spacing issues fixed<\\/li>\\n<li>Hide Top Bar feature improved<\\/li>\\n<li>Do Not Shrink Header on Scroll feature improved<\\/li>\\n<li>Social Icons in Secondary Menu Firefox issue fixed<\\/li>\\n<li>CTA Menu Button Position First\\/Last issue fixed<\\/li>\\n<li>Centered\\/Centered Inline header style issues fixed<\\/li>\\n<li>Top Bar performance on mobiles improved<\\/li>\\n<li>Mobile Menu paddings issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.1 - 15th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Fixed duplicated hamburger icons when more than one menu was used on a page<\\/li>\\n<li>Do Not Shrink Header functionality improved<\\/li>\\n<\\/ul>\\n<p><strong>1.8 - 13th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Magnifier module<\\/li>\\n<li><strong>NEW:<\\/strong> Lottie Icon module<\\/li>\\n<li>Plugin Settings page responsive issues fixed<\\/li>\\n<li>Plugin Settings Page Toolbar added<\\/li>\\n<li>Hide Admin Bar when user not logged in issue fixed<\\/li>\\n<li>Archive Page Header Injector issue fixed<\\/li>\\n<li>Bottom Bar customization issues fixed<\\/li>\\n<li>Back To Top custom link issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.7.1 - 28th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Panorama module PHP error for older PHP versions<\\/li>\\n<\\/ul>\\n<p><strong>1.7 - 27th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Panorama module<\\/li>\\n<li><strong>NEW:<\\/strong> Reading Progress Bar module<\\/li>\\n<li><strong>NEW:<\\/strong> Google icon to Social Icons added<\\/li>\\n<li>SVG image upload feature improved<\\/li>\\n<li>Force Footer to Bottom when Theme Builder used issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.6.2 - 20th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed an issue with social icons individual locations<\\/li>\\n<li>Fixed an issue with the revealing footer effect<\\/li>\\n<\\/ul>\\n<p><strong>1.6.1 - 15th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue in Divi Pixel options panel (WordPress 5.5 compatibility)<\\/li>\\n<li>Fixed an issue where individual social icon locations would break the menus<\\/li>\\n<\\/ul>\\n<p><strong>1.6.0 - 12th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Scrollable Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt text field added for Hover Box images<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Accordion Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS fields added to Accordion Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Tilt Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Hotspot Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List configurable HTML title tag option added<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Label field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Fixed responsive flex settings for Button Grid and added options for alignment and justification<\\/li>\\n<li><strong>NEW:<\\/strong> Login Page custom logo URL option added<\\/li>\\n<li><strong>NEW:<\\/strong> option to add links to images in Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> SVG image preview in Media Library added<\\/li>\\n<li>Tilt Image title customization issue fixed<\\/li>\\n<li>fixed issue with Theme Customizer scripts not loading on FlyWheel hosted sites<\\/li>\\n<li>Hover Box displaying empty heading tags issue fixed<\\/li>\\n<li>duplicated Prefix and Suffix spans in Typing Text module issue fixed<\\/li>\\n<li>Login Page logo size default values fixed<\\/li>\\n<li>Added option to Masonry Gallery to enable lazy loading images compatibility<\\/li>\\n<li>Automatically scroll to the top of the Divi Pixel options page after switching tabs<\\/li>\\n<li>Fixed Masonry Gallery not opening images in a lightbox<\\/li>\\n<li>Accordion Image responsive spacing issue fixed<\\/li>\\n<li>Carousel box-shadow and border child module issue fixed<\\/li>\\n<li>Carousel module left navigation positioning issue in builder fixed<\\/li>\\n<li>Flip Box content displaying issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.5.0 - 8th May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Accordion Module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box: added option to force the module to be a square<\\/li>\\n<li>Fixed \\\"open in new window\\\" option in various modules<\\/li>\\n<li>Improved SVG upload functionality to allow different mime types<\\/li>\\n<li>Fixed Related Articles and Author Box when Theme Builder is used<\\/li>\\n<li>Fixed Blog Slider default columns on tablet and mobiles<\\/li>\\n<li>Fixed \\\"Related Articles\\\" heading, which was sometimes displayed on custom post types<\\/li>\\n<li>Fixed Flex Direction responsive options in Typing Text module<\\/li>\\n<li>Fixed Image Hotspot heading level option in Visual Builder<\\/li>\\n<li>Fixed various typos<\\/li>\\n<li>Added some semicolons here and there to spice up the code (and fix some issues)<\\/li>\\n<\\/ul>\\n<p><strong>1.4.4 - 31st May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Flip Box Dynamic Height option added<\\/li>\\n<li><strong>NEW:<\\/strong> Flip Box: force module to be a square option added<\\/li>\\n<li>Flip Box Image Overlay builder issue fixed<\\/li>\\n<li>Flip Box icon not displayed on front-end issue fixed<\\/li>\\n<li>Primary Menu customization when Menu Hover Animation disabled issue fixed<\\/li>\\n<li>Masonry Gallery: IE browser issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.3 - 27th May 2020<\\/strong><\\/p>\\n<ul>\\n<li>Flip Box: height issue fixed<\\/li>\\n<li>Flip Box: Back Button not displayed on front-end issue fixed<\\/li>\\n<li>Flip Box: 3D Content Effect issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.2 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Flip Box module: Dynamic Height option removed<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.1 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Plugin Settings\\/Modules section updated<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.0 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Fancy Text module added<\\/li>\\n<li>Breadcrumbs Module: responsive padding options added<\\/li>\\n<li>Breadcrumbs: separator icon issue fixed<\\/li>\\n<li>Back To Top Button: box-shadow issue on hover fixed<\\/li>\\n<li>Back To Top Button: custom link issue fixed<\\/li>\\n<li>Menu CTA Button: hover text\\/background issue fixed<\\/li>\\n<li>Secondary Header menu\\/social icons positioning issue fixed<\\/li>\\n<li>Button Grid: icon size and positioning fixed<\\/li>\\n<li>Blog Archive: meta text icons positioning fixed<\\/li>\\n<li>Blog Slider image clickable option added<\\/li>\\n<li>Blog Slider: responsive image height option added<\\/li>\\n<li>Mobile Menu: Theme Builder header issues fixed<\\/li>\\n<li>Custom Mobile Breakpoint: all menu customization settings revised and improved<\\/li>\\n<li>Login Page: form field text size option added<\\/li>\\n<li>Login Page: logo size issue fixed, logo height option added<\\/li>\\n<li>Related Articles: section title font size issue fixed<\\/li>\\n<li>Testimonial Slider: read more popup size on mobiles issue fixed<\\/li>\\n<li>Header Menu: customization setting improved<\\/li>\\n<li>Hover Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Hover Box: module not displayed in Builder\\/Firefox issue fixed<\\/li>\\n<li>Hover Box: responsive height fixed<\\/li>\\n<li>Flip Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Image Hotspot, Hover Box, Flip Box, Carousel, Tilt Image: configurable HTML title tag option added<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.3.1 - 26th April 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed a bunch of smaller bugs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.0 - 20th April 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Blog Slider module<\\/li>\\n<li><strong>NEW<\\/strong>: Animation Delay option in Counter module<\\/li>\\n<li><strong>NEW:<\\/strong> Option to enable beta downloads<\\/li>\\n<li>Mobile Menu issue fixed<\\/li>\\n<li>Header\\/Menu Animation issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0 - 26th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Countdown module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box module<\\/li>\\n<li>Force Footer to Bottom Firefox issue fixed<\\/li>\\n<li>Filled Background menu animation style Firefox issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0 - 16th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Hotspot module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Export\\/Import functionality added to the Divi Pixel options panel<\\/li>\\n<li>Back to top button functionality improved<\\/li>\\n<li>Testimonial Slider mobile issues fixed<\\/li>\\n<li>Testimonial Slider Website URL field added<\\/li>\\n<li>The improved license activation process<\\/li>\\n<li>Licensing API Library updated<\\/li>\\n<\\/ul>\\n<p><strong>1.0.0 - 4th March 2020<\\/strong><\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/www.divi-pixel.com\\/wp-content\\/uploads\\/2020\\/03\\/dp-affiliate-banner-02-128x128.png\",\"2x\":\"https:\\/\\/www.divi-pixel.com\\/wp-content\\/uploads\\/2020\\/03\\/dp-affiliate-banner-02-256x256.png\"},\"description\":[\"<p>[et_pb_section fb_built=\\\"1\\\" admin_label=\\\"section\\\" _builder_version=\\\"4.16\\\" global_colors_info=\\\"{}\\\"][et_pb_row admin_label=\\\"row\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"][et_pb_column type=\\\"4_4\\\" _builder_version=\\\"4.16\\\" custom_padding=\\\"|||\\\" global_colors_info=\\\"{}\\\" custom_padding__hover=\\\"|||\\\"][et_pb_text admin_label=\\\"Text\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"]<br \\/>\\nDivi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals. Create amazing websites using powerful Divi Pixels modules and settings.<br \\/>\\n[\\/et_pb_text][\\/et_pb_column][\\/et_pb_row][\\/et_pb_section]<\\/p>\\n\"],\"changelog\":[\"<p><strong>2.18 November 17th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Layout Importer<\\/li>\\n<li><strong>NEW:<\\/strong> Reveal Before &amp; After Slider image after the label is clicked<\\/li>\\n<li><strong>NEW:<\\/strong> Added CPT support and Post Status to Blog Slider module<\\/li>\\n<li><strong>NEW:<\\/strong> Added dynamic field to Scroll Image module<\\/li>\\n<li><strong>NEW:<\\/strong> \\u201cHide All Modules\\u201d option added<\\/li>\\n<li>Fixed Advanced Tabs issue where content is not displayed in the builder<\\/li>\\n<li>Fixed Popup position issue on category pages<\\/li>\\n<li>Fixed popup periodicity function not working<\\/li>\\n<li>Fixed Contact Form success message not displayed in the Popup Maker<\\/li>\\n<li>Fixed the Carousel issue when used in the Balloon module<\\/li>\\n<li>Fixed header white gap when resizing the browser<\\/li>\\n<li>Fixed Hover Box PHP notice<\\/li>\\n<li>Fixed Image Showcase displaying link cursor when the link is not added<\\/li>\\n<li>Improved spacing settings for the Fancy Text animated text<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.17 October 26th, 2022<\\/strong><\\/p>\\n<ul>\\n<li>NEW: Filterable Gallery for Divi<\\/li>\\n<li>Fixed Menu CTA Button placement issue in the Safari browser<\\/li>\\n<li>Added Carousel navigation responsive settings<\\/li>\\n<li>Fixed Floating Images animation in Safari browser<\\/li>\\n<li>Fixed Blurb icon placement issue caused by the Advanced Tabs responsive icon settings<\\/li>\\n<li>Fixed duplicated content showing on hover in the Advanced Tabs module<\\/li>\\n<li>Fixed Advanced Tabs not showing inside the Balloon module<\\/li>\\n<li>Fixed hamburger mobile menu animation when multiple menus are used<\\/li>\\n<li>Fixed duplicated mobile menu displayed on CPT pages<\\/li>\\n<li>Fixed the Panorama module not working with the LatePoint plugin<\\/li>\\n<li>Fixed Popup Maker page search functionality<\\/li>\\n<li>Added Line social network<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.16.1 September 14th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added continuous slide animation to the Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Added option to make website elements clickable when the popup is opened<\\/li>\\n<li><strong>NEW:<\\/strong> Added Horizontal Timeline active line position setting<\\/li>\\n<li><strong>NEW:<\\/strong> Added responsive tab icon\\/image placement settings to the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Added list customization settings to the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Added Typing Text start animation in viewport<\\/li>\\n<li><strong>NEW:<\\/strong> Added responsive image count option to the Masonry Gallery module<\\/li>\\n<li><strong>NEW:<\\/strong> Added option to use custom images for Timeline line<\\/li>\\n<li>Fixed Expanding CTA button dynamic link issue<\\/li>\\n<li>Fixed Popup Maker Guest user role not saving<\\/li>\\n<li>Fixed Popup video still playing when the popup is closed<\\/li>\\n<li>Fixed Pricing Table module still available in the Divi Builder when the module is hidden<\\/li>\\n<li>Fixed Masonry Gallery rendering issue when used in the Advanced Tabs module<\\/li>\\n<li>Fixed testimonial length not working with the Chinese language<\\/li>\\n<li>Fixed Image Showcase rendering issues in Safari and Firefox browsers<\\/li>\\n<li>Fixed Horizontal Timeline SVG image not showing<\\/li>\\n<li>Fixed Advanced Tabs default tab issue<\\/li>\\n<li>Fixed Advanced Tabs duplicated tab icons when Theme Builder for product template is used<\\/li>\\n<li>Fixed Carousel equal height issue<\\/li>\\n<li>Fixed Carousel Module duplicated box-shadow, borders, padding, and margins in the builder<\\/li>\\n<li>Fixed Carousel Image hover effect transition<\\/li>\\n<li>Fixed FAQ module title alignment not working<\\/li>\\n<li>Fixed Expanding CTA responsive font size settings not working<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.16 July 27th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Pricing Table module<\\/li>\\n<li><strong>NEW:<\\/strong> Advanced Tabs activate on hover option added<\\/li>\\n<li>Improved Divi Builder plugin and Extra Theme support<\\/li>\\n<li>Improved hamburger script and placed it in external JS file so it can be excluded from Delayed JavaScript Execution<\\/li>\\n<li>Fixed Advanced Tabs content width issue on tablets and mobiles<\\/li>\\n<li>Fixed Popup Maker On Load issue in front-end builder<\\/li>\\n<li>Fixed Popup Maker saving issue<\\/li>\\n<li>Fixed customization functionality when the Divi Builder plugin is used<\\/li>\\n<li>Fixed a bug that caused Divi Pixel to not add the Theme Customizer settings<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.15.1 July 9th, 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Image Slider Loop option not working<\\/li>\\n<li>Fixed not working Custom Map Marker<\\/li>\\n<li>Fixed nonce_check in Popup Maker<\\/li>\\n<li>Fixed et_pb_get_specific_default_font function error<\\/li>\\n<li>Improved Breadcrumbs schema markup<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.15.0 - July 6th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Tile Scroll module<\\/li>\\n<li>Added option to activate\\/deactivate popups from the Popup Maker CPT dashboard<\\/li>\\n<li>Added option to close popup when browser back button is clicked<\\/li>\\n<li>Added Triggering column to the Popup Maker CPT screen<\\/li>\\n<li>Added z-index control for the Popup Maker overlay<\\/li>\\n<li>Added quick preview option to Popup Maker<\\/li>\\n<li>Added support for Divi Ghoster plugin<\\/li>\\n<li>Added Horizontal Order Direction to Masonry Gallery module<\\/li>\\n<li>Added responsive mockup images to the Image Showcase module<\\/li>\\n<li>Fixed FAQ module collapsed icon alignment issue<\\/li>\\n<li>Fixed Info Circle dynamic button link issue<\\/li>\\n<li>Fixed Image Hotspot responsive tooltip displaying issue<\\/li>\\n<li>Fixed dynamic button link in Advanced Tabs and Info Circle modules<\\/li>\\n<li>Fixed SVG Animator triggers animation during customizing other modules<\\/li>\\n<li>Fixed not working responsive Fullwidth Tabs option in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.14.0 - June 22nd, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Popup Maker for Divi<\\/li>\\n<li>Added title H tag control to FAQ module<\\/li>\\n<li>Fixed Horizontal Timeline image\\/icon position responsive settings<\\/li>\\n<li>Fixed Horizontal Timeline navigation not working on mobiles<\\/li>\\n<li>Fixed Collapsed Mobile Menu icon issue for closed menu<\\/li>\\n<li>Fixed duplicated Google testimonials added during fetching<\\/li>\\n<li>Fixed Back To Top Button icon issue when circle double arrow icon is selected<\\/li>\\n<li>Fixed Masonry Gallery manual order issue<\\/li>\\n<li>Fixed not working Advanced Tabs tab image alignment<\\/li>\\n<li>Fixed Advanced Tabs content area margin issue<\\/li>\\n<li>Fixed Expanding CTA overlay height issue on Android mobiles<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.13.0 - June 8th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added Text Highlighter module<\\/li>\\n<li>Added option to select the active tab on load in Advanced Tabs module<\\/li>\\n<li>Added ordering settings to Masonry Gallery module<\\/li>\\n<li>Fixed particles background issue when parallax option is enabled<\\/li>\\n<li>Fixed Theme Customizer toggles not displaying the correct value<\\/li>\\n<li>Fixed button icons not working when the Dynamic CSS is enabled<\\/li>\\n<li>Fixed Carousel button link dynamic option<\\/li>\\n<li>Fixed collapsed submenu not working when Theme Builder Menu module used<\\/li>\\n<li>Fixed Timeline animations not working in Firefox and Safari browsers<\\/li>\\n<li>Fixed not loading Divi Pixel font when the user is logged in<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.12.0 - May 26th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Particles Background effect<\\/li>\\n<li>Fixed Hotspot Image unwanted square element displayed below module when Lazy Load is used<\\/li>\\n<li>Added animation settings to child modules in the Timeline module<\\/li>\\n<li>Added Image Slider heading customization settings for H tags placed in the description<\\/li>\\n<li>Updated PHP 8 depreciated functions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.11.0 - May 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Expanding CTA module<\\/li>\\n<li>Fixed Advanced Tabs button target issue<\\/li>\\n<li>Fixed Image Gallery navigation issue when used in Advanced Tabs module<\\/li>\\n<li>Fixed Carousel description HTML markup displayed when not used<\\/li>\\n<li>Fixed Carousel image box-shadow issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.10 - May 9th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Maintenance Mode feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Allow TTF, OTF and WOFF file uploads<\\/li>\\n<li>Fixed Image Slider issue when used in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.9 - May 5th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Horizontal Timeline module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added option to add overlay image for Scroll Image module and set reveal effect<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added Animate in Viewport and Delay options to the Lottie Icon module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added reverse direction animation for autorotate option in Info Circle module<\\/li>\\n<li>Improved JavaScript for Balloon module to address issues when used in Theme Builder<\\/li>\\n<li>Added Telegram social media icon<\\/li>\\n<li>Added link customization settings to FAQ module<\\/li>\\n<li>Added Carousel image\\/icon hover option<\\/li>\\n<li>Fixed Floating Images animations not working in Safari and iOS 15.4.1<\\/li>\\n<li>Fixed Fancy Text prefix goes out of the screen issue<\\/li>\\n<li>Fixed Dual Heading background text displayed in Divi Builder when not used<\\/li>\\n<li>Fixed Advanced Tabs Divi Library item width issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.8 - April 25th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Advanced Tabs module<\\/li>\\n<li>Fixed Image Slider custom thumbnails not displayed on front-end<\\/li>\\n<li>Fixed Image Slider title formatting and HTML tag displayed on front-end<\\/li>\\n<li>Fixed Image Hotspot mobile issue<\\/li>\\n<li>Fixed Image Hotspot box shadow and border-radius issue<\\/li>\\n<li>Fixed Hover Box and Flip Box gradient migration issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.2 - April 13th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Author Box and Menu CTA Button font issue<\\/li>\\n<li>Fixed Panorama video controls not working in Safari browser<\\/li>\\n<li>Fixed Panorama default height value not working<\\/li>\\n<li>Fixed Image Slider custom navigation not displayed on the frontend<\\/li>\\n<li>Fixed Divi Pixel settings import issue<\\/li>\\n<li>Fixed Masonry Gallery icon border not working<\\/li>\\n<li>Fixed Dual Heading background animation issue<\\/li>\\n<li>Fixed module link not working in Balloon module<\\/li>\\n<li>Fixed dropdown link background color not working with Theme Builder header<\\/li>\\n<li>Added multi-select field for CTA menu button<\\/li>\\n<li>Added gradient migration for new gradient builder to retain old values<\\/li>\\n<li>Added dynamic images and content to Before &amp; After Slider module<\\/li>\\n<li>Added dynamic content fields to the Grid Button module<\\/li>\\n<li>Added dynamic labels to the Content Toggle module<\\/li>\\n<li>Added dynamic prefix and suffix fields to the Counter module<\\/li>\\n<li>Added dynamic heading content to the Dual Heading module<\\/li>\\n<li>Added dynamic fields for prefix and suffix in Fancy Text module<\\/li>\\n<li>Added dynamic image and image link fields to the Floating Images module<\\/li>\\n<li>Added dynamic image and content fields to Accordion Image module<\\/li>\\n<li>Added dynamic images and content fields to the Image Hotspot module<\\/li>\\n<li>Added dynamic images and content fields to the Balloon module<\\/li>\\n<li>Added dynamic images and content fields to the Carousel module<\\/li>\\n<li>Added dynamic images and content fields to the Flip Box module<\\/li>\\n<li>Added dynamic images and content fields to the Hover Box module<\\/li>\\n<li>Added dynamic images fields to the Image Magnifier module<\\/li>\\n<li>Added dynamic images fields to the Image Mask module<\\/li>\\n<li>Added dynamic images fields to the Image Showcase module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.1 - April 6th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Added Projects category and tag slug options<\\/li>\\n<li>Added CSS ID &amp; Classes fields to Image Accordion child items<\\/li>\\n<li>Added Half Circle option to the Counter module<\\/li>\\n<li>Added new gradient support to Divi Pixel modules<\\/li>\\n<li>Added image placeholder to Tilt Image module<\\/li>\\n<li>Fixed Circle Info Button margin not working<\\/li>\\n<li>Fixed Circle Info icon height issue<\\/li>\\n<li>Fixed Circle Info content switch on mobiles not working<\\/li>\\n<li>Fixed Circle Info icons not displayed in Firefox\\/Safari when icon animation is enabled<\\/li>\\n<li>Fixed Facebook and Google API code causing an error on cron<\\/li>\\n<li>Fixed Panorama responsive height issue<\\/li>\\n<li>Fixed Carousel, Content Toggle &amp; Balloon fatal errors sent to the email after WP autosave is triggered<\\/li>\\n<li>Fixed Carousel pagination responsive settings issue<\\/li>\\n<li>Fixed Carousel arrow navigation not working on mobile devices<\\/li>\\n<li>Fixed Masonry Gallery circle icon issue in builder<\\/li>\\n<li>Fixed Image Hotspot spacing issue in Firefox\\/Safari browsers<\\/li>\\n<li>Updated cron timing frequency for license check (twice daily)<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7 February 23rd 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Info Circle module added<\\/li>\\n<li>Updated Google social media icon<\\/li>\\n<li>Updated Snapchat and TikTok SVG images creating an error<\\/li>\\n<li>Updated Image Hotspot position value step to 0.1<\\/li>\\n<li>Updated hotspot icon line height causing hotspot icon to be not perfectly centred<\\/li>\\n<li>Improved Scroll Image horizontal mouse scroll performance<\\/li>\\n<li>Improved preloader performance<\\/li>\\n<li>Fixed Tilt Image glare effect<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Panorama rendering issues in Divi Builder when the video is used<\\/li>\\n<li>Fixed Panorama height not working when the video is used<\\/li>\\n<li>Fixed Flip Box back button padding not working<\\/li>\\n<li>Fixed Dual Heading module bottom margin and padding not working<\\/li>\\n<li>Fixed Dual Heading text background clipping for the 2nd text not working<\\/li>\\n<li>Fixed Carousel image border radius when box-shadow added not applying properly<\\/li>\\n<li>Fixed custom blog layout style not applying when Theme Builder template is used<\\/li>\\n<li>Fixed Image Slider Divi Library shortcodes not rendering<\\/li>\\n<li>Fixed dropdown arrow displayed on child submenus<\\/li>\\n<li>Fixed Search icon position when CTA Button not used<\\/li>\\n<li>Added support for PHP 8<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6.1 January 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added language settings for Google testimonials<\\/li>\\n<li><strong>NEW:<\\/strong> Added options to Exclude\\/Include Testimonials by Post ID<\\/li>\\n<li><strong>NEW:<\\/strong> Added 9 new animations to the Floating Images module<\\/li>\\n<li>Updated Floating Images position max and min values<\\/li>\\n<li>Fixed Floating Images transition CSS not working<\\/li>\\n<li>Fixed issue with Menu Hover Effect applies to the centred header logo<\\/li>\\n<li>Fixed Blog Slider random order not working<\\/li>\\n<li>Fixed not working link in Carousel child module<\\/li>\\n<li>Removed Carousel button wrapper HTML markup when the button is not used<\\/li>\\n<li>Added Soundcloud and TikTok icons to Social Media settings<\\/li>\\n<li>Added CSS ID &amp; Classes field to the Image Hotspot child module<\\/li>\\n<li>Added dynamic image support for Image Slider module (front-end only)<\\/li>\\n<li>Fixed JS error after searching when post meta section is empty<\\/li>\\n<li>Fixed Image Slider text displayed on sides when 3D Cube mode is used<\\/li>\\n<li>Fixed SVG Animator default width and height not working in Safari browser<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Tilt Image flickering issue in Chrome browser<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6 December 8th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> SVG Animator module added<\\/li>\\n<li>Image Slider thumbnails height various units support added<\\/li>\\n<li>Blog Slider backward PHP (&lt;7.2) compatibility issue fixed<\\/li>\\n<li>custom styles did not apply on paginated blog pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.3 November 26th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\" data-border-radius-top-cap=\\\"false\\\" data-border-radius-bottom-cap=\\\"false\\\">\\n<li><strong>NEW:<\\/strong> Image Accordion Always Visible new settings for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Showcase individual images links feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider featured image animation effects added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel image animation settings added<\\/li>\\n<li><strong>NEW:<\\/strong> All Divi Pixel modules support new Divi icons<\\/li>\\n<li>Carousel new custom CSS for active slide added<\\/li>\\n<li>Blog Slider navigation responsive settings added<\\/li>\\n<li>Blog Slider featured image border and box-shadow customization settings added<\\/li>\\n<li>Blog Slider new Custom CSS fields for navigation and active slide added<\\/li>\\n<li>Blog Slider pagination not working in builder when multiple instances used issue fixed<\\/li>\\n<li>Content Toggle new Custom CSS fields for toggle button added<\\/li>\\n<li>Image Mask shape 7 not displayed properly on front end issue fixed<\\/li>\\n<li>Masonry Gallery Grid Items border not working issue fixed<\\/li>\\n<li>Accordion module not triggered in Carousel module issue fixed<\\/li>\\n<li>Dropdown menu text color not working on fixed header issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.2 October 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 28 new masks added to the Image Mask module<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask selector field improved<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask: option to rotate, scale and flip the mask<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask image Alt Text field added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask upload custom shape option added<\\/li>\\n<li>Image Mask placeholder image added<\\/li>\\n<li>Image Showcase module URL issue fixed<\\/li>\\n<li>Carousel Autoplay stops working when the Pause on Hover option is disabled issue fixed<\\/li>\\n<li>Carousel item doesn\\u2019t take full width when short content is added issue fixed<\\/li>\\n<li>Countdown Timer doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Counter module doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Image Magnifier module doesn\\u2019t work in builder issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1 September 30th 2021<\\/strong><\\/p>\\n<ul>\\n<li>FAQ module categories missed issue fixed<\\/li>\\n<li>Custom preloader not working issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5 September 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Dual Heading module added<\\/li>\\n<li>Mobile Menu on WooCommerce pages issues fixed<\\/li>\\n<li>Blog archive custom style not applying for pagination pages issue fixed<\\/li>\\n<li>Image Hotspot tooltip displaying when border radius on the image is used issue fixed<\\/li>\\n<li>Image Hotspot tooltip image default width not applying in the builder issue fixed<\\/li>\\n<li>Image Hotspot new Ripple Effect style added<\\/li>\\n<li>Image Hotspot default image placeholder added<\\/li>\\n<li>Image Hotspot tooltip spacing in builder issue fixed<\\/li>\\n<li>Improved backwards compatibility with outdated PHP versions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4.2 - September 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider thumbnails margin controls added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider responsive settings for Image Overlay added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider custom thumbnail option added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider custom CSS field for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Slide Image responsive position control added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay hover settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay responsive settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Price List - Price Prefix and Suffix fields added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery image animation options added<\\/li>\\n<li>Custom Map Marker being cropped issue fixed<\\/li>\\n<li>Hover Box double arrow icon issue fixed<\\/li>\\n<li>Testimonial Slider Random order issue fixed<\\/li>\\n<li>Image Showcase in hidden section causing JS error issue fixed<\\/li>\\n<li>Blog Slider active pagination color issue fixed<\\/li>\\n<li>Blog Slider Content custom CSS field added<\\/li>\\n<li>dipi-anim-preload class not removed from the body after the page is loaded issue fixed<\\/li>\\n<li>Image Showcase causing JS error when the module is hidden issue fixed<\\/li>\\n<li>CTA Menu Button text color when Menu module is used issue fixed<\\/li>\\n<li style=\\\"list-style-type: none;\\\"><\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.4.1 August 23rd 2021<\\/strong><\\/p>\\n<p>Divi 4.10+ compatibility<\\/p>\\n<ul>\\n<li>Carousel lightbox functionality issue fixed<\\/li>\\n<li>Masonry Gallery layout grid and lightbox issue fixed<\\/li>\\n<li>Preloader, when Defer jQuery and jQuery Migrate option is enabled issue fixed<\\/li>\\n<li>Image Slider when Defer jQuery and jQuery migrate option is enabled issue fixed<\\/li>\\n<li>Counter module when Dynamic JS Libraries option enabled issue fixed<\\/li>\\n<li>Price List module when Dynamic JS Libraries enabled lightbox issue fixed<\\/li>\\n<li>Testimonial Slider popup when Dynamic JS Libraries enabled issue fixed<\\/li>\\n<li>Conditional Display when Dynamic Module Framework enabled issue fixed<\\/li>\\n<\\/ul>\\n<p>Improvements\\/Fixes<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\"><strong>NEW:<\\/strong> Image Slider Autoplay settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Archive page Style 2 - broken layout on category pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4 August 18th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Hotspot responsive positioning settings added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Open Carousel image in lightbox option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Reverse Carousel slide direction when Autoplay option is enabled<\\/li>\\n<li><strong>NEW:<\\/strong> Price List image lightbox gallery option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Masonry Gallery image link option added<\\/li>\\n<li>Carousel item Box Shadow on hover issue fixed<\\/li>\\n<li>Sidebar customization issues fixed<\\/li>\\n<li>Testimonial Slider heading customization settings added<\\/li>\\n<li>Carousel reloading in builder issue fixed<\\/li>\\n<li>Price List responsive settings for the layout and image added<\\/li>\\n<li>Price List module Box Shadow option to the parent module added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.3.2 July 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li>Related Article hover activation issue fixed<\\/li>\\n<li>Footer social icons when credits are disabled issue fixed<\\/li>\\n<li>Menu CTA button - menu selection issue fixed<\\/li>\\n<li>Image Hotspot - tooltip button when Trigger on Click is enabled issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.3.1 July 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Menu CTA Button - option for selecting menu added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Showcase - 11 new mockups added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box text line-height default values fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs alignment responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Divi Builder plugin &amp; Extra theme compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Exclude Posts option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive Featured Image border-radius option added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p>2.3 July 7th 2021<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> FAQ module with Google Structured Data added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider - category class added for single post box<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.5 June 30th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added new Section, Row and Module settings to conditionally display content based on users role or a login status<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Suppress Filters option is added to use the attempted filter by other 3rd party plugins (like WPML)<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mobile Menu Hamburger icon browser compatibility improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline card width when the icon is used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module PHP 7.2 compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Rename Projects tab category slug issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.4 June 18th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">duplicated logo when multiple Theme Builder headers are used issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.3 June 16th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> apply blog archive style to the native Divi Blog module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> select image size for the Blog Slider module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Divi Library Shortcodes to use in any module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Option to hide \\u201cEdit in Visual Builder\\u201d link on pages\\/posts overview dashboard pages<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial Read More popup font customization settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider \\u201cOrder By\\u201d settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - hide tooltip option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - link field to the hotspot child added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot isn\\u2019t interactive anymore issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider HTML markup displayed for disabled elements issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Accordion TinyMCE editor support added for the description field<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image responsive scroll speed settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Panorama 2D Image mode scroll issue on tablets and mobiles fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider responsive settings for navigation size and padding added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider - testimonials order settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More link disabled when a full testimonial is displayed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mega Menu width issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Read More Button Text\\u201d doesn\\u2019t apply to the native Divi Blog module issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d doesn\\u2019t apply to the Theme Builder custom header issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Collapsed mobile top menu not clickable issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module visibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module displaying on archive pages issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs separator alignment issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Lottie Icon width not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Content Toggle\\/Masonry Gallery compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Full-width post does not display full-width sections in frontend Divi Builder issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.2 April 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: open tooltip on click<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: tooltip animations added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Carousel - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module margin in Divi Builder modules list issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Ballon button link target issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">plugin settings modules list updated<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider HTML support for review text added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image content animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon button shadow not applying in builder properly issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider not working with Blog module when testimonial CPT is selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module fetches taxonomy from pages where taxonomy is not added issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline line border styles issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial custom CSS for Profile Image selector fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.1 April 2nd, 2021<\\/strong><\\/p>\\n<ul>\\n<li>plugin updater issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.0 April 1st, 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Ballon module added<\\/li>\\n<li>Blog Slider item not clickable in Firefox browser issue fixed<\\/li>\\n<li>Content Toggle et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li>Content Toggle and Image Showcase compatibility improved<\\/li>\\n<li>Testimonial Slider popup\\/Divi Machine conflict issue fixed<\\/li>\\n<li>API licensing UI and functionality improved<\\/li>\\n<li>Documentation pages UI improved<\\/li>\\n<\\/ul>\\n<p><strong>2.1.2 March 8th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">Content Toggle issue with dipi_label function issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module dipi_label function replaced with esc_html__ function<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.1 March 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Disable LazyLoad in Content Toggle module settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Enable Lightbox responsive settings issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Plugin Settings\\/Modules options updated<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.0 - February 25th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Content Toggle module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Archive section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Post Navigation section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Author Box section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Related Articles section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Disable Lightbox responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d in Firefox displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d ON\\/OFF builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box circle icon issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box WPML support improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image\\/Icon alignment in Timeline not working in Divi Builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel Autoplay option doesn\\u2019t work in Safari issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel items displayed vertically in Safari 8 issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel child item hover icon not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Button Grid on mobiles improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Floating Images Transform settings not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box height controls improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box solid border issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase rendering with WP Rocket Lazy Loading in different browsers issues fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image mouse scrolling improved<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.0.1 - February 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW: <\\/strong>Masonry Gallery Coverflow Animations<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Masonry Gallery - disable image lightbox option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box jQuery variable naming issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">CSS error preventing Divi scripts from compile issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text child module link issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion image responsive settings improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image Active On Load and Open On Click issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">fonts in Theme Customizer did not enqueue issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.0.0 - January 26th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Timeline module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added CSS ID &amp; Classes to Button Grid child modules<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> WhatsApp, Snapchat and Xing social media icons added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Active Image size responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Opened on Load responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Performance improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Mask SVG markup issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase - image positioning tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Primary Header Social Icons positioning when CTA Button is not used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery image width causing the problem with the proper displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Button displaying multiple icons when icon not selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default content-length value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default spacing value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Error messages when Google reviews are fetched corrected<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image arrow color rendering in builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box name improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text alignment settings revised<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup displaying mixed testimonials issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup image styling issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.3 - December 16th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>collapsed mobile menu close animation fixed<\\/li>\\n<li>dropdown menu width max value increased<\\/li>\\n<li>Hamburger Mobile Menu not displayed after WP 5.6 issue fixed<\\/li>\\n<li>minor code improvements in Panorama and Lottie modules<\\/li>\\n<li>Carousel Coverflow mode - disabled slide shadow issue fixed<\\/li>\\n<li>Duplicated Social Icons in Primary Header issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.2 - December 7th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Breadcrumbs active item styles missed on front-end issue fixed<\\/li>\\n<li>Dropdown menu item width control added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.1 - December 5th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Carousel spacing issue fixed<\\/li>\\n<li>plugin package\\/2 new modules Divi Builder rendering issues fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.0 - December 4th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Showcase module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask module added<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS Class field added to the header CTA button<\\/li>\\n<li><strong>NEW:<\\/strong> Divi Builder support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Extra theme support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Post Type\\/Taxonomy settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Alignment settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Dynamic button URL to Grid Button module added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel module CSS ID &amp; Classes added to child items<\\/li>\\n<li>Vertical Navigation style issues fixed<\\/li>\\n<li>Testimonial Slider overflow issue fixed<\\/li>\\n<li>Mobile Menu animation out when Theme Builder header used issue fixed<\\/li>\\n<li>Blog Archive responsive breakpoint updated<\\/li>\\n<li>Hotspot tooltip height on mobiles issue fixed<\\/li>\\n<li>Blog Slider body text and button box-shadow issues fixed<\\/li>\\n<li>Admin Label field added to the Carousel child modules<\\/li>\\n<li>Tooltip image wrapper if image not selected - HTML markup not displayed<\\/li>\\n<li>Post meta alignment on archive page issue fixed<\\/li>\\n<li>Tilt Image mobile height issue fixed<\\/li>\\n<li>Footer Reveal Effect visibility in the front-end builder issue fixed<\\/li>\\n<li>Hide Admin Bar setting issue fixed<\\/li>\\n<li>Hide Admin Bar\\/Hide Top Header\\/Reading Progress Bar issues fixed<\\/li>\\n<li>Breadcrumbs Schema Markup issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.9 - 14 October 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Mobile Submenu customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Collapsed Mobile menu icon customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Circle animation for Mobile Menu background overlay added<\\/li>\\n<li>Menu Dropdown visibility with Theme Builder Header and Footer Reveal Effect enabled issue fixed<\\/li>\\n<li>default Mobile Menu animation performance issue fixed<\\/li>\\n<li>Centered Inline Logo header alignment fixed<\\/li>\\n<li>Centered header hamburger icon position fixed<\\/li>\\n<li>Stand and Spring style Hamburger icon animation issues fixed<\\/li>\\n<li>Fixed Mobile Menu container gap issue on mobiles fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.2 - 28th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>NEW: Add Arrow to Dropdown Menus<\\/li>\\n<li>NEW: Dropdown Menu width and position controls added<\\/li>\\n<li>NEW: Open Menu Button Link in a New Window option added<\\/li>\\n<li>Header Height\\/Spacing issues fixed<\\/li>\\n<li>Hide Top Bar feature improved<\\/li>\\n<li>Do Not Shrink Header on Scroll feature improved<\\/li>\\n<li>Social Icons in Secondary Menu Firefox issue fixed<\\/li>\\n<li>CTA Menu Button Position First\\/Last issue fixed<\\/li>\\n<li>Centered\\/Centered Inline header style issues fixed<\\/li>\\n<li>Top Bar performance on mobiles improved<\\/li>\\n<li>Mobile Menu paddings issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.1 - 15th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Fixed duplicated hamburger icons when more than one menu was used on a page<\\/li>\\n<li>Do Not Shrink Header functionality improved<\\/li>\\n<\\/ul>\\n<p><strong>1.8 - 13th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Magnifier module<\\/li>\\n<li><strong>NEW:<\\/strong> Lottie Icon module<\\/li>\\n<li>Plugin Settings page responsive issues fixed<\\/li>\\n<li>Plugin Settings Page Toolbar added<\\/li>\\n<li>Hide Admin Bar when user not logged in issue fixed<\\/li>\\n<li>Archive Page Header Injector issue fixed<\\/li>\\n<li>Bottom Bar customization issues fixed<\\/li>\\n<li>Back To Top custom link issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.7.1 - 28th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Panorama module PHP error for older PHP versions<\\/li>\\n<\\/ul>\\n<p><strong>1.7 - 27th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Panorama module<\\/li>\\n<li><strong>NEW:<\\/strong> Reading Progress Bar module<\\/li>\\n<li><strong>NEW:<\\/strong> Google icon to Social Icons added<\\/li>\\n<li>SVG image upload feature improved<\\/li>\\n<li>Force Footer to Bottom when Theme Builder used issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.6.2 - 20th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed an issue with social icons individual locations<\\/li>\\n<li>Fixed an issue with the revealing footer effect<\\/li>\\n<\\/ul>\\n<p><strong>1.6.1 - 15th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue in Divi Pixel options panel (WordPress 5.5 compatibility)<\\/li>\\n<li>Fixed an issue where individual social icon locations would break the menus<\\/li>\\n<\\/ul>\\n<p><strong>1.6.0 - 12th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Scrollable Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt text field added for Hover Box images<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Accordion Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS fields added to Accordion Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Tilt Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Hotspot Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List configurable HTML title tag option added<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Label field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Fixed responsive flex settings for Button Grid and added options for alignment and justification<\\/li>\\n<li><strong>NEW:<\\/strong> Login Page custom logo URL option added<\\/li>\\n<li><strong>NEW:<\\/strong> option to add links to images in Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> SVG image preview in Media Library added<\\/li>\\n<li>Tilt Image title customization issue fixed<\\/li>\\n<li>fixed issue with Theme Customizer scripts not loading on FlyWheel hosted sites<\\/li>\\n<li>Hover Box displaying empty heading tags issue fixed<\\/li>\\n<li>duplicated Prefix and Suffix spans in Typing Text module issue fixed<\\/li>\\n<li>Login Page logo size default values fixed<\\/li>\\n<li>Added option to Masonry Gallery to enable lazy loading images compatibility<\\/li>\\n<li>Automatically scroll to the top of the Divi Pixel options page after switching tabs<\\/li>\\n<li>Fixed Masonry Gallery not opening images in a lightbox<\\/li>\\n<li>Accordion Image responsive spacing issue fixed<\\/li>\\n<li>Carousel box-shadow and border child module issue fixed<\\/li>\\n<li>Carousel module left navigation positioning issue in builder fixed<\\/li>\\n<li>Flip Box content displaying issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.5.0 - 8th May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Accordion Module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box: added option to force the module to be a square<\\/li>\\n<li>Fixed \\\"open in new window\\\" option in various modules<\\/li>\\n<li>Improved SVG upload functionality to allow different mime types<\\/li>\\n<li>Fixed Related Articles and Author Box when Theme Builder is used<\\/li>\\n<li>Fixed Blog Slider default columns on tablet and mobiles<\\/li>\\n<li>Fixed \\\"Related Articles\\\" heading, which was sometimes displayed on custom post types<\\/li>\\n<li>Fixed Flex Direction responsive options in Typing Text module<\\/li>\\n<li>Fixed Image Hotspot heading level option in Visual Builder<\\/li>\\n<li>Fixed various typos<\\/li>\\n<li>Added some semicolons here and there to spice up the code (and fix some issues)<\\/li>\\n<\\/ul>\\n<p><strong>1.4.4 - 31st May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Flip Box Dynamic Height option added<\\/li>\\n<li><strong>NEW:<\\/strong> Flip Box: force module to be a square option added<\\/li>\\n<li>Flip Box Image Overlay builder issue fixed<\\/li>\\n<li>Flip Box icon not displayed on front-end issue fixed<\\/li>\\n<li>Primary Menu customization when Menu Hover Animation disabled issue fixed<\\/li>\\n<li>Masonry Gallery: IE browser issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.3 - 27th May 2020<\\/strong><\\/p>\\n<ul>\\n<li>Flip Box: height issue fixed<\\/li>\\n<li>Flip Box: Back Button not displayed on front-end issue fixed<\\/li>\\n<li>Flip Box: 3D Content Effect issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.2 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Flip Box module: Dynamic Height option removed<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.1 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Plugin Settings\\/Modules section updated<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.0 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Fancy Text module added<\\/li>\\n<li>Breadcrumbs Module: responsive padding options added<\\/li>\\n<li>Breadcrumbs: separator icon issue fixed<\\/li>\\n<li>Back To Top Button: box-shadow issue on hover fixed<\\/li>\\n<li>Back To Top Button: custom link issue fixed<\\/li>\\n<li>Menu CTA Button: hover text\\/background issue fixed<\\/li>\\n<li>Secondary Header menu\\/social icons positioning issue fixed<\\/li>\\n<li>Button Grid: icon size and positioning fixed<\\/li>\\n<li>Blog Archive: meta text icons positioning fixed<\\/li>\\n<li>Blog Slider image clickable option added<\\/li>\\n<li>Blog Slider: responsive image height option added<\\/li>\\n<li>Mobile Menu: Theme Builder header issues fixed<\\/li>\\n<li>Custom Mobile Breakpoint: all menu customization settings revised and improved<\\/li>\\n<li>Login Page: form field text size option added<\\/li>\\n<li>Login Page: logo size issue fixed, logo height option added<\\/li>\\n<li>Related Articles: section title font size issue fixed<\\/li>\\n<li>Testimonial Slider: read more popup size on mobiles issue fixed<\\/li>\\n<li>Header Menu: customization setting improved<\\/li>\\n<li>Hover Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Hover Box: module not displayed in Builder\\/Firefox issue fixed<\\/li>\\n<li>Hover Box: responsive height fixed<\\/li>\\n<li>Flip Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Image Hotspot, Hover Box, Flip Box, Carousel, Tilt Image: configurable HTML title tag option added<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.3.1 - 26th April 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed a bunch of smaller bugs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.0 - 20th April 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Blog Slider module<\\/li>\\n<li><strong>NEW<\\/strong>: Animation Delay option in Counter module<\\/li>\\n<li><strong>NEW:<\\/strong> Option to enable beta downloads<\\/li>\\n<li>Mobile Menu issue fixed<\\/li>\\n<li>Header\\/Menu Animation issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0 - 26th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Countdown module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box module<\\/li>\\n<li>Force Footer to Bottom Firefox issue fixed<\\/li>\\n<li>Filled Background menu animation style Firefox issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0 - 16th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Hotspot module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Export\\/Import functionality added to the Divi Pixel options panel<\\/li>\\n<li>Back to top button functionality improved<\\/li>\\n<li>Testimonial Slider mobile issues fixed<\\/li>\\n<li>Testimonial Slider Website URL field added<\\/li>\\n<li>The improved license activation process<\\/li>\\n<li>Licensing API Library updated<\\/li>\\n<\\/ul>\\n<p><strong>1.0.0 - 4th March 2020<\\/strong><\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"],\"plugin\":\"divi-pixel\\/divi-pixel.php\",\"id\":\"divi-pixel\\/divi-pixel.php\"}\";}", "no");
INSERT INTO `z8ei5_options` VALUES("450", "dipi_instagram_db_version", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("455", "WPLANG", "fr_FR", "yes");
INSERT INTO `z8ei5_options` VALUES("457", "whl_redirect_admin", "404", "yes");
INSERT INTO `z8ei5_options` VALUES("461", "dipi_instagram_accounts", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("462", "dipi_facebook_accounts", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("465", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `z8ei5_options` VALUES("495", "et_google_api_settings", "a:3:{s:7:\"api_key\";s:0:\"\";s:16:\"use_google_fonts\";s:2:\"on\";s:26:\"enqueue_google_maps_script\";s:2:\"on\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("761", "db_upgraded", "", "yes");
INSERT INTO `z8ei5_options` VALUES("943", "dipi_pm_OnceMigrateCbcValues", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("991", "hjqs_mentions_legales_options", "a:31:{s:15:\"forme_juridique\";s:55:\"Société par Actions Simplifiée Unipersonnelle (SASU)\";s:12:\"proprietaire\";s:20:\"TURNEYSKILLFORMATION\";s:5:\"siret\";s:14:\"90531280700019\";s:3:\"rcs\";s:20:\"Angers B 905 312 807\";s:7:\"adresse\";s:30:\"5 RUE DE PRUNIERS 49000 ANGERS\";s:11:\"responsable\";s:20:\"TURNEYSKILLFORMATION\";s:19:\"responsable_contact\";s:31:\"contact@turneyskillformation.fr\";s:8:\"createur\";s:13:\"SI CONSULTING\";s:13:\"createur_site\";s:42:\"https://www.siconsulting-certification.fr/\";s:16:\"createur_contact\";s:37:\"contact@siconsulting-certification.fr\";s:9:\"hebergeur\";s:59:\"WP SERVEUR, 134 Avenue du président Wilson 93100 Montreuil\";s:19:\"cgv_forme_juridique\";s:0:\"\";s:16:\"cgv_proprietaire\";s:0:\"\";s:11:\"cgv_adresse\";s:0:\"\";s:9:\"cgv_siret\";s:0:\"\";s:18:\"cgv_capital_social\";s:0:\"\";s:7:\"cgv_rcs\";s:0:\"\";s:15:\"cgv_responsable\";s:0:\"\";s:23:\"cgv_responsable_contact\";s:0:\"\";s:37:\"cgv_duree_de_concervation_des_donnees\";s:0:\"\";s:23:\"cgv_produit_sans_retour\";s:0:\"\";s:21:\"cgv_conditions_retour\";s:0:\"\";s:18:\"cgv_adresse_retour\";s:0:\"\";s:33:\"cgv_indisponibilite_produit_temps\";s:0:\"\";s:22:\"pdc_user_can_subscribe\";s:3:\"Non\";s:24:\"pdc_user_can_submit_form\";s:3:\"Oui\";s:22:\"pdc_user_can_purcharge\";s:3:\"Non\";s:20:\"pdc_user_can_publish\";s:3:\"Non\";s:37:\"pdc_duree_de_concervation_des_donnees\";s:5:\"2 ans\";s:16:\"pdc_outils_stats\";a:1:{s:16:\"Google Analytics\";s:16:\"Google Analytics\";}s:22:\"cgv_moyens_de_paiement\";a:0:{}}", "yes");
INSERT INTO `z8ei5_options` VALUES("1046", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:17:\"jamila@j-boost.fr\";s:7:\"version\";s:5:\"6.4.2\";s:9:\"timestamp\";i:1702000064;}", "no");
INSERT INTO `z8ei5_options` VALUES("1191", "autoupdates_core", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("1192", "no_autoupdates_plugins", "a:9:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:1:\"2\";s:39:\"block-bad-queries/block-bad-queries.php\";s:1:\"2\";s:50:\"hjqs-mentions-legales-fr/hjqs-mentions-legales.php\";s:1:\"2\";s:19:\"optimus/optimus.php\";s:1:\"2\";s:24:\"wordpress-seo/wp-seo.php\";s:1:\"2\";s:31:\"wps-bidouille/wps-bidouille.php\";s:1:\"2\";s:27:\"wps-cleaner/wps-cleaner.php\";s:1:\"2\";s:33:\"wps-hide-login/wps-hide-login.php\";s:1:\"2\";s:35:\"wps-limit-login/wps-limit-login.php\";s:1:\"2\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("1193", "autoupdates_themes", "a:3:{s:12:\"twentytwenty\";s:1:\"1\";s:15:\"twentytwentyone\";s:1:\"1\";s:15:\"twentytwentytwo\";s:1:\"1\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("1194", "autoupdates_plugins_notification", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("1195", "autoupdates_plugins_notification_email", "jamila@j-boost.fr", "yes");
INSERT INTO `z8ei5_options` VALUES("1196", "autoupdates_plugins_notification_frequency", "", "yes");
INSERT INTO `z8ei5_options` VALUES("1219", "simba_tfa_priv_key_format", "1", "no");
INSERT INTO `z8ei5_options` VALUES("1226", "updraft_lock_aios_15_minutes_cron_event", "0", "no");
INSERT INTO `z8ei5_options` VALUES("1228", "wpr_rocket_cache_version", "20220927", "yes");
INSERT INTO `z8ei5_options` VALUES("1261", "wpseo_sitemap_cache_validator_global", "qk8i", "no");
INSERT INTO `z8ei5_options` VALUES("1268", "wpseo_sitemap_project_cache_validator", "5EtH4", "no");
INSERT INTO `z8ei5_options` VALUES("1271", "wpseo_sitemap_dipi_testimonial_cache_validator", "5rd7G", "no");
INSERT INTO `z8ei5_options` VALUES("1276", "wpseo_sitemap_dipi_popup_maker_cache_validator", "5Eu1X", "no");
INSERT INTO `z8ei5_options` VALUES("1279", "wpseo_sitemap_category_cache_validator", "5EudC", "no");
INSERT INTO `z8ei5_options` VALUES("1750", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("1752", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `z8ei5_options` VALUES("1763", "wpseo_sitemap_scope_cache_validator", "4N9mF", "no");
INSERT INTO `z8ei5_options` VALUES("1764", "wpseo_sitemap_module_width_cache_validator", "4N9mM", "no");
INSERT INTO `z8ei5_options` VALUES("1765", "wpseo_sitemap_layout_type_cache_validator", "4N9mI", "no");
INSERT INTO `z8ei5_options` VALUES("1781", "et_pb_contact_form_fa0e760caa84a5bcfe16859b7633f79f", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("1808", "et_pb_contact_form_ee38711b7f7b7fdbc09f5f75521b2cc4", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("1864", "et_pb_contact_form_66a439284c8258d152b7f594bdee6759", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("1882", "et_pb_contact_form_4884ca1af3f82e78d9fd5671a21e0854", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("2569", "dipi_customizer_option_preloader_background_color", "#ffffff", "yes");
INSERT INTO `z8ei5_options` VALUES("2570", "dipi_customizer_option_particles_color", "rgba(0,0,0,0.4)", "yes");
INSERT INTO `z8ei5_options` VALUES("2571", "dipi_customizer_option_link_color", "rgba(0,0,0,0.4)", "yes");
INSERT INTO `z8ei5_options` VALUES("2572", "dipi_customizer_option_particles_color_2", "rgba(0,0,0,0.4)", "yes");
INSERT INTO `z8ei5_options` VALUES("2573", "dipi_customizer_option_link_color_2", "rgba(0,0,0,0.4)", "yes");
INSERT INTO `z8ei5_options` VALUES("2574", "dipi_customizer_option_btt_btn_background", "rgba(0,0,0,0.4)", "yes");
INSERT INTO `z8ei5_options` VALUES("2575", "dipi_customizer_option_btt_btn_color", "#ffffff", "yes");
INSERT INTO `z8ei5_options` VALUES("2576", "dipi_customizer_option_btt_btn_background_hover", "#000000", "yes");
INSERT INTO `z8ei5_options` VALUES("2577", "dipi_customizer_option_btt_btn_color_hover", "#ffffff", "yes");
INSERT INTO `z8ei5_options` VALUES("2578", "dipi_customizer_option_blog_archives_page_background_color", "#ffffff", "yes");
INSERT INTO `z8ei5_options` VALUES("2579", "dipi_customizer_option_archive_box_icon_color", "#ffffff", "yes");
INSERT INTO `z8ei5_options` VALUES("2580", "dipi_customizer_option_blog_related_box_background_color", "#ffffff", "yes");
INSERT INTO `z8ei5_options` VALUES("2581", "dipi_customizer_option_blog_related_box_shadow_color", "#000000", "yes");
INSERT INTO `z8ei5_options` VALUES("2582", "dipi_customizer_option_blog_related_hover_box_shadow_color", "#444444", "yes");
INSERT INTO `z8ei5_options` VALUES("2583", "dipi_customizer_option_mobile_submenu_item_background", "#ffffff", "yes");
INSERT INTO `z8ei5_options` VALUES("2584", "dipi_customizer_option_mobile_menu_btn_shadow_color", "rgba(0,39,56,0.3)", "yes");
INSERT INTO `z8ei5_options` VALUES("2812", "dm_pfd_data", "a:1:{s:12:\"active_since\";i:1665071971;}", "yes");
INSERT INTO `z8ei5_options` VALUES("2813", "dm_core_notices", "a:1:{s:5:\"queue\";a:2:{i:122864;a:3:{s:4:\"inst\";s:3:\"pfd\";s:4:\"type\";s:4:\"info\";s:4:\"html\";s:432:\"<p><strong>???? Divimode Summer Sale</strong>: Get the best deal when upgrading to <strong><a href=\"https://divimode.com/divi-areas-pro/\" target=\"_blank\">Divi Areas Pro</a></strong> today! <a href=\"#dismiss\" class=\"notice-dismiss\">Dismiss (I do not want to save money)</a> <span style=\"padding-left:20px\"><a href=\"https://divimode.com/join/?sale=summer23\" target=\"_blank\" class=\"button-primary cta-link\">Get the Deal!</a></span></p>\";}i:108636;a:3:{s:4:\"inst\";s:3:\"pfd\";s:4:\"type\";s:4:\"info\";s:4:\"html\";s:858:\"<p><strong>You\'re using Popups for Divi</strong> for a while now, thanks! If you require any assistance, please <a href=\"https://wordpress.org/support/plugin/popups-for-divi/#new-post\" target=\"_blank\">reach out via support</a>, and we\'ll get back to you asap. <p>Meanwhile, you can do us a <strong>huge favor</strong> and leave an <a href=\"https://wordpress.org/support/plugin/popups-for-divi/reviews/#new-post\" target=\"_blank\"><strong>honest (5-star) rating</strong> on WordPress</a> - it only takes 30 seconds, and helps other users to find our plugin, and it enables us to spend more time developing and improving this free plugin for you. <em>- Thanks, Philipp from divimode.com</em> 👍 <br /><br><br><a href=\"https://wordpress.org/support/plugin/popups-for-divi/reviews/#new-post\" target=\"_blank\" class=\"button-primary\">Sure, I\'d love to help!</a></p>\";}}}", "yes");
INSERT INTO `z8ei5_options` VALUES("3312", "layout_category_children", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("3313", "wpseo_sitemap_layout_category_cache_validator", "6RrYP", "no");
INSERT INTO `z8ei5_options` VALUES("3329", "testimonial_cat_children", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("3435", "wps_limit_login_retries", "a:1:{s:15:\"188.166.178.164\";i:3;}", "no");
INSERT INTO `z8ei5_options` VALUES("3436", "wps_limit_login_retries_valid", "a:1:{s:15:\"188.166.178.164\";i:1702804253;}", "no");
INSERT INTO `z8ei5_options` VALUES("3642", "et_pb_contact_form_92f2b3520a95d6a8470e1d83dcb87632", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("4214", "external_updates-divi-flyin", "O:8:\"stdClass\":2:{s:9:\"lastCheck\";i:1705273330;s:14:\"checkedVersion\";s:3:\"1.2\";}", "no");
INSERT INTO `z8ei5_options` VALUES("4854", "et_pb_contact_form_9bf60eee520efaf59a0b9e5b1d23e529", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("4922", "et_pb_contact_form_30b2ca5a676aaf5b9762eab746517f32", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("6994", "aiowpsec_firewall_version", "1.0.5", "yes");
INSERT INTO `z8ei5_options` VALUES("7058", "dipi_use_particles", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7059", "dipi_use_particles_note", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7060", "dipi_use_coming_soon", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7061", "dipi_coming_soon_page", "9", "yes");
INSERT INTO `z8ei5_options` VALUES("7062", "dipi_coming_soon_vip", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7063", "dipi_login_page", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7064", "dipi_login_page_link", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7065", "dipi_browser_scrollbar", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7066", "dipi_svg_upload", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7067", "dipi_ttf_upload", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7068", "dipi_back_to_top", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7069", "dipi_btt_button_style", "display_icon", "yes");
INSERT INTO `z8ei5_options` VALUES("7070", "dipi_btt_custom_link", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7071", "dipi_btt_link", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7072", "dipi_btt_theme_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7073", "dipi_hide_projects", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7074", "dipi_rename_projects", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7075", "dipi_rename_projects_singular", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7076", "dipi_rename_projects_plural", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7077", "dipi_rename_projects_slug", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7078", "dipi_rename_projects_icon", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7079", "dipi_rename_projects_cat_slug", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7080", "dipi_rename_projects_tag_slug", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7081", "dipi_rename_projects_notice", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7082", "dipi_rename_testimonials", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7083", "dipi_rename_testimonials_singular", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7084", "dipi_rename_testimonials_plural", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7085", "dipi_rename_testimonials_slug", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7086", "dipi_hide_library_shortcodes", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7087", "dipi_disable_conditional_module_display", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7088", "dipi_hide_edit_in_vb", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7089", "dipi_hide_admin_bar", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7090", "dipi_custom_map_marker", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7091", "dipi_upload_custom_marker", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7092", "dipi_custom_map_marker_anchor", "bottom_center", "yes");
INSERT INTO `z8ei5_options` VALUES("7093", "dipi_custom_preloader", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7094", "dipi_custom_preloader_style", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7095", "dipi_custom_preloader_image", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7096", "dipi_upload_preloader", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7097", "dipi_custom_preloader_homepage", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7098", "dipi_preloader_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7099", "dipi_menu_styles", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7100", "dipi_enable_menu_hover_styles", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7101", "dipi_menu_hover_styles", "three_dots", "yes");
INSERT INTO `z8ei5_options` VALUES("7102", "dipi_custom_dropdown", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7103", "dipi_menu_button", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7104", "dipi_menu_cta_menu", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7105", "dipi_menu_button_text", "Click Here", "yes");
INSERT INTO `z8ei5_options` VALUES("7106", "dipi_menu_button_url", "#", "yes");
INSERT INTO `z8ei5_options` VALUES("7107", "dipi_menu_button_placement", "a", "yes");
INSERT INTO `z8ei5_options` VALUES("7108", "dipi_menu_button_classname", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7109", "dipi_cta_btn_new_tab", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7110", "dipi_mobile_cta_btn", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7111", "dipi_menu_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7112", "dipi_header_underline", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7113", "dipi_shrink_header", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7114", "dipi_fixed_logo", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7115", "dipi_fixed_logo_image", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7116", "dipi_zoom_logo", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7117", "dipi_footer_theme_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7118", "dipi_footer_layout", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7119", "dipi_select_footer_layout", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7120", "dipi_footer_customization", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7121", "dipi_hide_bottom_bar", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7122", "dipi_fixed_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7123", "dipi_reveal_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7124", "dipi_reveal_desktop", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7125", "dipi_reveal_tablet", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7126", "dipi_reveal_phone", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7127", "dipi_footer_reveal_posts_type", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7128", "dipi_footer_reveal_pages_type", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7129", "dipi_footer_reveal_projects_type", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7130", "dipi_footer_reveal_testimonials_type", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7131", "dipi_enable_beta_program", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7132", "dipi_settings_reset_button", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7133", "dipi_settings_reset_customizer_button", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7134", "dipi_google_place_id", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7135", "dipi_google_api_key", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7136", "dipi_google_api_lang", "en", "yes");
INSERT INTO `z8ei5_options` VALUES("7137", "dipi_facebook_page_id", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7138", "dipi_facebook_page_access_token", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7139", "dipi_instagram_basic_app_id", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7140", "dipi_instagram_basic_app_secret", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7141", "dipi_instagram_connect_basic", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7142", "dipi_instagram_connected_accounts_basic", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7143", "dipi_instagram_graph_app_id", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7144", "dipi_instagram_graph_app_secret", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7145", "dipi_instagram_connect_graph", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7146", "dipi_instagram_connected_accounts_graph", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7147", "dipi_export_settings", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7148", "dipi_export_customizer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7149", "dipi_export_button", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7150", "dipi_import_button", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7151", "dipi_social_icons_theme_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7152", "dipi_use_dipi_social_icons", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7153", "dipi_social_links_new_tab", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7154", "dipi_social_icons_individual_location", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7155", "dipi_social_icons_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7156", "dipi_social_icons_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7157", "dipi_social_icons_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7158", "dipi_social_media_facebook", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7159", "dipi_social_media_facebook_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7160", "dipi_social_media_facebook_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7161", "dipi_social_media_facebook_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7162", "dipi_social_media_instagram", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7163", "dipi_social_media_instagram_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7164", "dipi_social_media_instagram_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7165", "dipi_social_media_instagram_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7166", "dipi_social_media_twitter", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7167", "dipi_social_media_twitter_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7168", "dipi_social_media_twitter_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7169", "dipi_social_media_twitter_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7170", "dipi_social_media_youtube", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7171", "dipi_social_media_youtube_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7172", "dipi_social_media_youtube_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7173", "dipi_social_media_youtube_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7174", "dipi_social_media_pinterest", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7175", "dipi_social_media_pinterest_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7176", "dipi_social_media_pinterest_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7177", "dipi_social_media_pinterest_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7178", "dipi_social_media_vimeo", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7179", "dipi_social_media_vimeo_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7180", "dipi_social_media_vimeo_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7181", "dipi_social_media_vimeo_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7182", "dipi_social_media_tumblr", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7183", "dipi_social_media_tumblr_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7184", "dipi_social_media_tumblr_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7185", "dipi_social_media_tumblr_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7186", "dipi_social_media_linkedin", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7187", "dipi_social_media_linkedin_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7188", "dipi_social_media_linkedin_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7189", "dipi_social_media_linkedin_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7190", "dipi_social_media_flickr", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7191", "dipi_social_media_flickr_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7192", "dipi_social_media_flickr_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7193", "dipi_social_media_flickr_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7194", "dipi_social_media_dribbble", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7195", "dipi_social_media_dribbble_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7196", "dipi_social_media_dribbble_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7197", "dipi_social_media_dribbble_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7198", "dipi_social_media_skype", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7199", "dipi_social_media_skype_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7200", "dipi_social_media_skype_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7201", "dipi_social_media_skype_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7202", "dipi_social_media_google", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7203", "dipi_social_media_google_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7204", "dipi_social_media_google_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7205", "dipi_social_media_google_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7206", "dipi_social_media_xing", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7207", "dipi_social_media_xing_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7208", "dipi_social_media_xing_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7209", "dipi_social_media_xing_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7210", "dipi_social_media_whatsapp", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7211", "dipi_social_media_whatsapp_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7212", "dipi_social_media_whatsapp_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7213", "dipi_social_media_whatsapp_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7214", "dipi_social_media_snapchat", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7215", "dipi_social_media_snapchat_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7216", "dipi_social_media_snapchat_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7217", "dipi_social_media_snapchat_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7218", "dipi_social_media_soundcloud", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7219", "dipi_social_media_soundcloud_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7220", "dipi_social_media_soundcloud_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7221", "dipi_social_media_soundcloud_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7222", "dipi_social_media_tiktok", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7223", "dipi_social_media_tiktok_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7224", "dipi_social_media_tiktok_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7225", "dipi_social_media_tiktok_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7226", "dipi_social_media_telegram", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7227", "dipi_social_media_telegram_menu", "none", "yes");
INSERT INTO `z8ei5_options` VALUES("7228", "dipi_social_media_telegram_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7229", "dipi_social_media_telegram_mobile_menu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7230", "dipi_blog_theme_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7231", "dipi_custom_archive_page", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7232", "dipi_custom_archive_styles", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7233", "dipi_hide_excerpt_text", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7234", "dipi_blog_meta_icons", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7235", "dipi_remove_sidebar", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7236", "dipi_remove_sidebar_line", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7237", "dipi_sidebar_customization", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7238", "dipi_add_read_more_archive", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7239", "dipi_read_more_button_style", "text_icon", "yes");
INSERT INTO `z8ei5_options` VALUES("7240", "dipi_read_more_button", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7241", "dipi_read_more_button_text", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7242", "dipi_author_box", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7243", "dipi_blog_nav", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7244", "dipi_blog_nav_prev", "Previous Article", "yes");
INSERT INTO `z8ei5_options` VALUES("7245", "dipi_blog_nav_next", "Next Article", "yes");
INSERT INTO `z8ei5_options` VALUES("7246", "dipi_related_articles", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7247", "dipi_related_articles_heading", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7248", "dipi_related_articles_limit", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7249", "dipi_enable_custom_comments", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7250", "dipi_custom_comments_title", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7251", "dipi_mobile_theme_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7252", "dipi_custom_breakpoints", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7253", "dipi_breakpoint_mobile", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7254", "dipi_fixed_mobile_header", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7255", "dipi_search_icon_mobile", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7256", "dipi_mobile_logo", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7257", "dipi_mobile_logo_url", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7258", "dipi_mobile_menu_style", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7259", "dipi_mobile_menu_fullscreen", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7260", "dipi_hamburger_animation", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7261", "dipi_hamburger_animation_styles", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7262", "dipi_hamburger_animation_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7263", "dipi_collapse_submenu", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7264", "dipi_collapse_submenu_prevent_parent_opening", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7265", "dipi_modules_theme_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7266", "dipi_md_masonry_gallery", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7267", "dipi_md_testimonial", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7268", "dipi_md_countdown", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7269", "dipi_md_blog_slider", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7270", "dipi_md_counter", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7271", "dipi_md_flip_box", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7272", "dipi_md_button_grid", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7273", "dipi_md_before_after_slider", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7274", "dipi_md_floating_multi_images", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7275", "dipi_md_tilt_image", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7276", "dipi_md_carousel", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7277", "dipi_md_typing_text", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7278", "dipi_md_star_rating", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7279", "dipi_md_breadcrumbs", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7280", "dipi_md_pricelist", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7281", "dipi_md_image_hotspot", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7282", "dipi_md_hover_box", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7283", "dipi_md_fancy_text", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7284", "dipi_md_accordion_image", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7285", "dipi_md_scroll_image", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7286", "dipi_md_panorama", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7287", "dipi_md_reading_progress_bar", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7288", "dipi_md_image_magnifier", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7289", "dipi_md_lottie_icon", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7290", "dipi_md_image_showcase", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7291", "dipi_md_image_mask", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7292", "dipi_md_timeline", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7293", "dipi_md_content_toggle", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7294", "dipi_md_faq", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7295", "dipi_md_balloon", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7296", "dipi_md_gallery_slider", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7297", "dipi_md_dual_heading", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7298", "dipi_md_svg_animator", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7299", "dipi_md_info_circle", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7300", "dipi_md_advanced_tabs", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7301", "dipi_md_horizontal_timeline", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7302", "dipi_md_expanding_cta", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7303", "dipi_md_text_highlighter", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7304", "dipi_md_popup_maker", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7305", "dipi_md_tile_scroll", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7306", "dipi_md_pricing_table", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7307", "dipi_md_instagram", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7308", "dipi_md_filterable_gallery", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7309", "dipi_md_filterable_grid", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7310", "dipi_inject_theme_customizer", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7311", "dipi_before_nav_layout", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7312", "dipi_after_nav_layout", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7313", "dipi_nav_layout_homepage", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7314", "dipi_nav_layout_custom", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7315", "dipi_nav_specific_pages", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7316", "dipi_before_footer_layout", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7317", "dipi_after_footer_layout", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7318", "dipi_footer_layout_homepage", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7319", "dipi_footer_layout_custom", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7320", "dipi_footer_specific_pages", "", "yes");
INSERT INTO `z8ei5_options` VALUES("7321", "dipi_error_page", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7322", "dipi_select_error_page", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7323", "dipi_error_page_header", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7324", "dipi_error_page_footer", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("7325", "dipi_after_nav_post_layout", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7326", "dipi_after_nav_archives", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7327", "dipi_after_nav_categories", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7328", "dipi_after_nav_search", "-1", "yes");
INSERT INTO `z8ei5_options` VALUES("7335", "edd_sl_1a1f366f929fdafc7b48fed84a0dbf87", "a:2:{s:7:\"timeout\";i:1705283546;s:5:\"value\";s:150848:\"{\"new_version\":\"2.29.2\",\"stable_version\":\"2.29.2\",\"name\":\"Divi Pixel\",\"slug\":\"divi-pixel\",\"url\":\"https:\\/\\/www.divi-pixel.com\\/product\\/divi-pixel\\/?changelog=1\",\"last_updated\":\"2024-01-03 22:32:32\",\"homepage\":\"https:\\/\\/www.divi-pixel.com\\/product\\/divi-pixel\\/\",\"package\":\"https:\\/\\/www.divi-pixel.com\\/edd-sl\\/package_download\\/MTcwNTg4MTE0NjplYWQyMzc4ZmEzOGMzMGUyMGE3ZGI1NDVjY2RjYzYzMjozMjcxODo2MDE0NGY4OTM5NTY4ZGY3MzFlNjkyM2YyYTU3YjQ3MzpodHRwc0AvL3RzLWZvcm1hdGlvbi5mcjow\",\"download_link\":\"https:\\/\\/www.divi-pixel.com\\/edd-sl\\/package_download\\/MTcwNTg4MTE0NjplYWQyMzc4ZmEzOGMzMGUyMGE3ZGI1NDVjY2RjYzYzMjozMjcxODo2MDE0NGY4OTM5NTY4ZGY3MzFlNjkyM2YyYTU3YjQ3MzpodHRwc0AvL3RzLWZvcm1hdGlvbi5mcjow\",\"sections\":{\"description\":\"<p>[et_pb_section fb_built=\\\"1\\\" admin_label=\\\"section\\\" _builder_version=\\\"4.16\\\" collapsed=\\\"on\\\" global_colors_info=\\\"{}\\\"][et_pb_row column_structure=\\\"1_2,1_2\\\" admin_label=\\\"row\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"][et_pb_column type=\\\"1_2\\\" _builder_version=\\\"4.20.4\\\" _module_preset=\\\"default\\\" global_colors_info=\\\"{}\\\"][\\/et_pb_column][et_pb_column type=\\\"1_2\\\" _builder_version=\\\"4.16\\\" custom_padding=\\\"|||\\\" global_colors_info=\\\"{}\\\" custom_padding__hover=\\\"|||\\\"][et_pb_text admin_label=\\\"Text\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"]<br \\/>\\nDivi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals. Create amazing websites using powerful Divi Pixels modules and settings.<br \\/>\\n[\\/et_pb_text][\\/et_pb_column][\\/et_pb_row][\\/et_pb_section]<\\/p>\\n\",\"changelog\":\"<p><strong>2.29.2 December 21st 2023<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Dual Heading border issue<\\/li>\\n<li>Fixed Divi 4.23.2 compatibility issue<\\/li>\\n<li>Fixed Tripadvisor social icon issue<\\/li>\\n<li>Fixed Table Maker depraciated PHP: automatic conversion of false to array<\\/li>\\n<li>Fixed Flip Box module showing back side<\\/li>\\n<li>Fixed Popup Maker position issue when content is having single tags<\\/li>\\n<li>Fixed Filterable Gallery JS error when Conditional Display is used<\\/li>\\n<li>Improved Blog Slider data attribute format<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.29.1 December 15th 2023<\\/strong><\\/p>\\n<ul>\\n<li>Fixed parent mobile menu item link issue<\\/li>\\n<li>Fixed Jetpack captcha field width on login screen<\\/li>\\n<li>Fixed not saving Divi Pixel Category and link in Media Library<\\/li>\\n<li>Fixed not showing Read More button for arabic string in Blog Slider<\\/li>\\n<li>Fixed Dual Heading background text stroke color issue<\\/li>\\n<li>Fixed JS error when responsive text settings for TOC module title are used<\\/li>\\n<li>Fixed Gravity Forms Styler border issue when Orbital theme is used<\\/li>\\n<li>Added delay option to the Typing Text module<\\/li>\\n<li>Added archive page styling for search results page<\\/li>\\n<li>Added option to hide Homepage in the Breadcrumbs module<\\/li>\\n<li>Added option to remove Html for empty field in Testimonial Slider<\\/li>\\n<li>Added pagination and load more settings to the Masonry Gallery module<\\/li>\\n<li>Added option to show\\/hide Clear Divi Cache option in the WP toolbar<\\/li>\\n<li>Improved Fix Lazy Loading Image in Filterable Grid and Filterable Gallery<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.29.0 November 24th 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Table Maker module<\\/li>\\n<li>Added margin, padding and custom CSS filed for Advanced Tabs tab image<\\/li>\\n<li>Added Divider module to WPML config file<\\/li>\\n<li>Added custom CSS field to Advanced Tabs button<\\/li>\\n<li>Added shortcode support to Blog Slider, Parallax Image and Pricing Table modules<\\/li>\\n<li>Added title tag control for the Pricing Table Feature<\\/li>\\n<li>Added ability to translate DIPI category taxonomy<\\/li>\\n<li>Added support of Gravity Forms Styler to different themes<\\/li>\\n<li>Added Link toggle to Tile Scroll child modules<\\/li>\\n<li>Added \\u201cClickable Card\\u201d option to the Blog Slider module<\\/li>\\n<li>Added mobile option for the Ripple Effect Style 2 in the Image Hotspot module<\\/li>\\n<li>Added alt text for image in the Expanding CTA module<\\/li>\\n<li>Fixed Reveal module expanded height issue<\\/li>\\n<li>Fixed Panorama responsive issue<\\/li>\\n<li>Fixed menu hover animation when translation is used<\\/li>\\n<li>Fixed Reveal height in Advanced Tabs, Content Slider and Content Toggle<\\/li>\\n<li>Fixed Flip Box dynamic link issue<\\/li>\\n<li>Fixed not working page exclusion option in the TOC module<\\/li>\\n<li>Fixed not working Carousel link in older Safari browsers<\\/li>\\n<li>Improved Image Hotspot tooltip position on mobiles<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.28.0 October 11th 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Divider module<\\/li>\\n<li>Fixed Accordion Image rendering issue when used in Theme Builder template<\\/li>\\n<li>Fixed WPML-config.xml file conflict with Polylang plugin<\\/li>\\n<li>Fixed Reveal issue when used in the Content Slider module<\\/li>\\n<li>Fixed Image Slider thumbs navigation not working when Theme Builder is used<\\/li>\\n<li>Fixed Filterable Grid taxonomy select field issue with the Polylang plugin<\\/li>\\n<li>Fixed not working FAQ module order not working in the builder<\\/li>\\n<li>Fixed incorrect image count displayed in the Image Slider lightbox<\\/li>\\n<li>Fixed Gravity Forms Styler unique ID field not showing in the editor<\\/li>\\n<li>Fixed Gravity Forms Styler dropdown arrow position issue<\\/li>\\n<li>Added Custom CSS fields for Hover Gallery images and content icons<\\/li>\\n<li>Added Yelp and Spotify social media icons<\\/li>\\n<li>Added Popup Maker width settings<\\/li>\\n<li>Added Custom CSS ID &amp; Classes to the Timeline child items<\\/li>\\n<li>Updated WPML configuration file<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.27.0 September 13th 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Reveal module<\\/li>\\n<li>Added Box Shadow and Border settings to the Typing Text module<\\/li>\\n<li>Added Alt Text for images in the Info Circle module<\\/li>\\n<li>Added option to use icons with links in the Floating Images module<\\/li>\\n<li>Added Load More, Pagination, and Infinite Scroll options to the Masonry Gallery module<\\/li>\\n<li>Added Carousel Image Height control<\\/li>\\n<li>Added responsive settings for Show Table Title in the TOC module<\\/li>\\n<li>Added ACF support to the Price List module<\\/li>\\n<li>Added author prefix &amp; link target setting to the Filterable Grid module<\\/li>\\n<li>Fixed Testimonial Slider issue when content includes unicode symbols<\\/li>\\n<li>Fixed Table of Content issue when the Generate for Whole Page option is enabled<\\/li>\\n<li>Fixed Table of Contents issue when special characters are used in the title<\\/li>\\n<li>Fixed not working CTA button settings in the footer menu<\\/li>\\n<li>Fixed not a clickable logo in the header when the centered header is used<\\/li>\\n<li>Fixed CTA Menu Button styles not applying to the secondary menu<\\/li>\\n<li>Apply mobile menu styles only for the header menu, not for the footer<\\/li>\\n<li>Enabled Divi Pixel taxonomy for all CPT<\\/li>\\n<li>Updated Twitter icon<\\/li>\\n<li>Updated WPML config file<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.26.0 August 9th 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Table of Contents module added<\\/li>\\n<li><strong>NEW:<\\/strong> Clear Divi Cache functionality added to the WP dashboard toolbar<\\/li>\\n<li>Fixed Float Thumbs Over Main Image responsive issues in the Image Slider module<\\/li>\\n<li>Fixed Gravity Forms Styler submit button issue when placed at the end of a row<\\/li>\\n<li>Fixed Image Hotspot warning in the child module<\\/li>\\n<li>Fixed Image Rotator preloader issue when the image is bigger than the viewport height<\\/li>\\n<li>Fixed not clickable logo on mobile when centered header style is used<\\/li>\\n<li>Fixed not working border for the menu CTA button<\\/li>\\n<li>Added Popup Maker WPML support<\\/li>\\n<li>Added Tripadvisor, Twitch, and Yelp social media icons<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.25.1 July 13th 2023<\\/strong><\\/p>\\n<ul>\\n<li>Added preloader to the Image Rotator module<\\/li>\\n<li>Fixed WPML config file to fix the Pricing Table text field translation issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.25.0 July 12th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Image Rotate module added<\\/li>\\n<li>Fixed Testimonial Slider avatar issue for WooCommerce reviews<\\/li>\\n<li>Fixed Filterable Grid Sticky Filter issue<\\/li>\\n<li>Fixed submenu not opening in some devices when \\u2018Collapse Submenu Items on Mobiles\\u2019 is enabled<\\/li>\\n<li>Fixed rendering issue of Image Gallery in Content Slider<\\/li>\\n<li>Fixed Image Accordion background image not working when the image is not selected in the child module<\\/li>\\n<li>Fixed PHP warning in Expanding CTA module<\\/li>\\n<li>Fixed missing styling of Submit button container in the Gravity Forms Styler module<\\/li>\\n<li>Fixed not working \\u2018Hide Close Button\\u2019\\u00a0 in Popup Maker after PHP 8.0<\\/li>\\n<li>Fixed not working image animation in the Filterable Grid module<\\/li>\\n<li>Fixed archive\\/categories pages excerpt font color issue<\\/li>\\n<li>Fixed Image Hotspot ripple effect issue in Firefox browser<\\/li>\\n<li>Fixed dynamic text not rendering in the Visual Builder in the Text Highlighter module<\\/li>\\n<li>Added option to hide content by default in the Advanced Tabs module<\\/li>\\n<li>Added scroll bar to Filterable Gallery when image caption in lightbox goes out of the screen<\\/li>\\n<li>Added stronger selector to Button Grid for default margin-bottom of child module<\\/li>\\n<li>Added Slide Selector to the Content Slider module<\\/li>\\n<li>Added navigation settings to the Content Slider module<\\/li>\\n<li>Added \\u201cContent as Raw HTML\\u201d to the Blog Slider module<\\/li>\\n<li>Added tab index and field values setting to the Gravity Forms Styler module<\\/li>\\n<li>Added Show More button functionality to the Filterable Grid module<\\/li>\\n<li>Added publishing date, categories, and author to the Filterable Grid module<\\/li>\\n<li>Added filters to the Filterable Grid module<\\/li>\\n<li>Improved Filterable Grid title\\/content hover color functionality<\\/li>\\n<li>Improved \\u201cApply Hover Style to Active Menu Item\\u201d function<\\/li>\\n<li>Improved speed using async images in Blog Slider<\\/li>\\n<li>Improved image link function in the Advanced Tabs module<\\/li>\\n<li>Improved Popup Maker to allow users to trigger popups using a keyboard<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.24.0 June 7th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added full WPML compatibility<\\/li>\\n<li>Fixed not working autoplay speed in the Hover Gallery module<\\/li>\\n<li>Fixed Image Magnifier rendering issue in Divi Builder<\\/li>\\n<li>Fixed the preloader displayed on the blog page when only the homepage setting is enabled<\\/li>\\n<li>Fixed Timeline module displaying issue on front-end of CPT<\\/li>\\n<li>Fixed Timeline responsive issue in Theme Builder<\\/li>\\n<li>Fixed Testimonial Slider avatar issue for WooCommerce reviews<\\/li>\\n<li>Fixed not working Filterable Grid image animation<\\/li>\\n<li>Fixed Advanced Tabs scroll to content on mobiles issue<\\/li>\\n<li>Fixed Advanced Tabs sticky tabs with slider navigation issue<\\/li>\\n<li>Fixed truncated caption in the Filterable Gallery lightbox when an apostrophe is used<\\/li>\\n<li>Added link option for the content image in the Advanced Tabs module<\\/li>\\n<li>Added Image Slider lightbox option for main carousel images<\\/li>\\n<li>Added icon spacing settings to the Tilt Image module<\\/li>\\n<li>Added vertical scroll functionality to the Image Showcase module<\\/li>\\n<li>Added simple FadeIn animation to the Hover Gallery module<\\/li>\\n<li>Added \\u201cMenu Order\\u201d into Filterable Grid Order By settings<\\/li>\\n<li>Disabled popups displaying in the builder<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.23.1 May 23rd, 2023<\\/strong><\\/p>\\n<ul>\\n<li>Fixed conditional fields issue in the Gravity Forms Styler module<\\/li>\\n<li>Fixed Gravity Forms Styler files loaded when the module is hidden<\\/li>\\n<li>Fixed the z-index of the meta box in the Popup Maker user interface<\\/li>\\n<li>Fixed the wrapping text issue in the last tab in the Content Slider module<\\/li>\\n<li>Fixed Content Slider reloading when Advanced Tabs is used on the same page<\\/li>\\n<li>Fixed Popup Maker issue causing broken website styles on the front-end<\\/li>\\n<li>Added ID tag to FAQ module schema output<\\/li>\\n<li>Added Ajax feature to Gravity Forms Styler module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<br \\/>\\n<strong>2.23.0 May 18th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Gravity Forms Styler for Divi<\\/li>\\n<li>Fixed issue with the mouse pointer on archive pages when the popup Closing CSS Selector is empty<\\/li>\\n<li>Fixed Theme Customizer issue when the Divi Torque plugin is used<\\/li>\\n<li>Fixed Scroll Image not working in the Carousel module<\\/li>\\n<li>Fixed the select field in the Divi Pixel dashboard<\\/li>\\n<li>Fixed conflict with FluentCRM where the unsubscribe function didn\\u2019t work<\\/li>\\n<li>Fixed Content Slider Move by Pin not working on mobiles<\\/li>\\n<li>Fixed Filterable Grid broken image issue when the featured image is not set and image overlay used<\\/li>\\n<li>Fixed Filterable Grid cursor pointer issue when using post link without lightbox option enabled<\\/li>\\n<li>Fixed conflict with the FluentCRM plugin<\\/li>\\n<li>Fixed the Horizontal Timeline issue when used in the Advanced Tabs module<\\/li>\\n<li>Fixed Balloon module background issue<\\/li>\\n<li>Fixed Horizontal Timeline icons displaying issue<\\/li>\\n<li>Fixed Image Mask custom SVG mask not displayed on the front-end on a specific server<\\/li>\\n<li>Fixed Footer Stick to the Bottom not working on tablets and mobiles<\\/li>\\n<li>Fixed Testimonial Slider Read More function not working with non-latin contents<\\/li>\\n<li>Fixed Advanced Tabs Content Vertical Align option not working correctly<\\/li>\\n<li>Added Content Image width settings to the Advanced Tabs module<\\/li>\\n<li>Improved Blog Style 5 layout on tablets<\\/li>\\n<li>Improved Filterable Grid content length when excerpt text is empty<\\/li>\\n<li>Improved Force Footer to the Bottom feature<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.22.0 April 18th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Content Slider module added<\\/li>\\n<li>Added z-index setting in the Balloon module<\\/li>\\n<li>Added z-index setting for the Image Hotspot tooltip<\\/li>\\n<li>Added option to fix anchor link offset issue when Fixed Mobile Header is used<\\/li>\\n<li>Added Quora social media network<\\/li>\\n<li>Added Lazyload images to Filterable Grid and Filterable Gallery modules<\\/li>\\n<li>Added Post Offset setting to the Blog Slider module<\\/li>\\n<li>Fixed Pricing Table not working spacing setting when used in Theme Builder<\\/li>\\n<li>Fixed the issue with adding a new module below the Image Slider<\\/li>\\n<li>Fixed Popup Maker not triggering from the mobile menu item<\\/li>\\n<li>Improved the Filterable Grid performance<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.21.1 March 29th, 2023<\\/strong><\\/p>\\n<ul>\\n<li>Fixed duplicated mobile menu hamburger icon issue<\\/li>\\n<li>Fixed mobile menu hamburger icon animation issue<\\/li>\\n<li>Fixed space added when the reveal footer effect is used<\\/li>\\n<li>Fixed Filled Background menu hover effect styles issues<\\/li>\\n<li>Fixed dropdown menu item animation and styling issues<\\/li>\\n<li>Fixed mobile menu CTA button text color issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.21.0 March 28th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Hover Gallery module added<\\/li>\\n<li>Fixed Filterable Grid link target not working properly<\\/li>\\n<li>Fixed heading level issue in Filterable Grid and Filterable Gallery modules<\\/li>\\n<li>Fixed issue with the Author Box sizing<\\/li>\\n<li>Fixed Info Circle issue when button and content links are used at the same time<\\/li>\\n<li>Fixed an issue with the responsive icon selector in the Timeline module<\\/li>\\n<li>Fixed Carousel not displaying when the max-width property is used in the child module<\\/li>\\n<li>Fixed Timeline Font Awesome icons not displayed<\\/li>\\n<li>Fixed PHP warning when the option to display popup on specific pages is enabled, but pages not defined<\\/li>\\n<li>Added sticky filter bar options to Filterable Grid and Filterable Gallery modules<\\/li>\\n<li>Added Post Status option to the Filterable Grid module<\\/li>\\n<li>Added option to display raw HTML in the Filterable Grid module<\\/li>\\n<li>Added displaying order options to the Filterable Grid module<\\/li>\\n<li>Added pagination translation settings for the Filterable Gallery and Filterable Grid<\\/li>\\n<li>Added option to show title and caption in the Carousel image lightbox<\\/li>\\n<li>Added options to display animation in the viewport and only once in the Fancy Text module<\\/li>\\n<li>Added hooks to the Blog Slider module<\\/li>\\n<li>Improved Popup Maker CSS when the Video module is used<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.20.1 March 1st, 2023<\\/strong><\\/p>\\n<ul>\\n<li>New features added to the Before &amp; After Slider<\\/li>\\n<li>Added tooltip animation speed to the Image Hotspot module<\\/li>\\n<li>Fixed Filterable Grid duplicated taxonomy issue<\\/li>\\n<li>Fixed post quick edit not saving due to Divi Pixel taxonomy<\\/li>\\n<li>Fixed Advanced Tabs duplicated content on hover issue<\\/li>\\n<li>Fixed Advanced Tabs\\/Timeline module compatibility<\\/li>\\n<li>Fixed console error in Timeline module when Divi Builder is used<\\/li>\\n<li>Fixed Popup Maker console error when CSS selector is not used<\\/li>\\n<li>Fixed Carousel Autoplay option not working after navigation is used<\\/li>\\n<li>Fixed not working CTA Menu button text color on hover<\\/li>\\n<li>Fixed Balloon conflict with 3rd party mega menu plugin<\\/li>\\n<li>Fixed Popup Maker compatibility issue with Envira Gallery Lite plugin<\\/li>\\n<li>Removed title from the custom preloader<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.20 February 22nd, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Filterable Grid module added<\\/li>\\n<li>Fixed issue with Image Hotspot video still playing after the tooltip is closed<\\/li>\\n<li>Fixed issue with rendering custom fields in builder in Timeline modules<\\/li>\\n<li>Fixed not working Blog Slider in the Balloon module<\\/li>\\n<li>Fixed not working Horizontal Timeline when used in the Accordion module<\\/li>\\n<li>Fixed the not working active icon in the Timeline module<\\/li>\\n<li>Fixed Pricing Table justify text option<\\/li>\\n<li>Fixed Button Grid issue when only icon is used<\\/li>\\n<li>Fixed Menu CTA Button text color not working on hover<\\/li>\\n<li>Fixed Image Hotspot icon size responsive settings issue<\\/li>\\n<li>Fixed MailChimp submit button not working in the Balloon module<\\/li>\\n<li>Fixed FAQ module title markup issue visible in SEO tools<\\/li>\\n<li>Added icon padding settings to the Image Hotspot module<\\/li>\\n<li>Added icon padding settings to the Timeline module<\\/li>\\n<li>Added responsive settings for the Carousel Autoplay function<\\/li>\\n<li>Improved the tab selector in the Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.19.1 January 13th, 2023<\\/strong><\\/p>\\n<ul>\\n<li>Added option to make the FAQ module entries searchable<\\/li>\\n<li>Fixed PHP error in filetype hook<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.19 January 12th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Parallax Image module<\\/li>\\n<li>Added hover settings for the close button in the Testimonial Slider popup<\\/li>\\n<li>Fixed not working border radius for filled background menu effect<\\/li>\\n<li>Fixed Carousel image lightbox issue when the option is disabled<\\/li>\\n<li>Fixed not working Carousel module link when the Carousel image is clicked<\\/li>\\n<li>Fixed not working module link in Divi Library items (except Balloon module)<\\/li>\\n<li>Fixed Timeline module customization issue when the Divi Builder plugin is used<\\/li>\\n<li>Fixed Media Library image link not showing when Hide All Modules is enabled<\\/li>\\n<li>Fixed issue with Image Slider used in Advanced Tabs module<\\/li>\\n<li>Fixed Masonry Gallery image border not working on frontend<\\/li>\\n<li>Fixed Hover Box dynamic button link issue<\\/li>\\n<li>Fixed Horizontal Timeline displaying issues when the mixed layout is used<\\/li>\\n<li>Fixed Masonry Gallery displaying issue when used in the Advanced Tabs module<\\/li>\\n<li>Fixed custom font upload not working when Divi Pixel is activated<\\/li>\\n<li>Fixed Popup Maker issue not opening popup from the mobile menu button<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.18.1 December 14th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 2nd CTA button added to Expanding CTA module<\\/li>\\n<li><strong>NEW:<\\/strong> Added Custom CSS ID &amp; Classes to Horizontal Timeline child modules<\\/li>\\n<li><strong>NEW:<\\/strong> Added Scroll To Content responsive settings in the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Hide popup slug in URL option added<\\/li>\\n<li>Fixed Sticky Tabs not working in the Advanced Tabs module when tabs were added on the left or right<\\/li>\\n<li>Fixed Horizontal Timeline not rendering in Divi Builder when used in the Content Toggle module<\\/li>\\n<li>Fixed Timeline icon issue when the icon is not selected<\\/li>\\n<li>Fixed PHP warnings in the Divi Pixel setting panel (Modules)<\\/li>\\n<li>Fixed the not working button in Carousel when Coverflow effect is used (Firefox browser)<\\/li>\\n<li>Fixed not working Popup Maker closing button<\\/li>\\n<li>Fixed Popup Maker Close on Overlay Click issue<\\/li>\\n<li>Fixed video issue still playing after the popup is closed<\\/li>\\n<li>Fixed Menu module not displaying in the footer when the reveal effect is enabled<\\/li>\\n<li>Fixed PHP warnings in the Carousel module<\\/li>\\n<li>Fixed PHP warnings in the Blog Slider module<\\/li>\\n<li>Fixed Custom Mask\\/Dynamic Content issue in the Image Mask module<\\/li>\\n<li>Fixed the Divi Counter module issue affected by the Divi Pixel plugin<\\/li>\\n<li>Fixed Balloon styling issue when used in footer or header<\\/li>\\n<li>Fixed Content Toggle - header level for front page and builder<\\/li>\\n<li>Fixed SVG Animator not working when iTheme Security plugin is used<\\/li>\\n<li>Fixed Star Rating PHP warning with PHP 8<\\/li>\\n<li>Improved \\u201cHide All Modules\\u201d option in Divi Pixel settings<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.18 November 17th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Layout Importer<\\/li>\\n<li><strong>NEW:<\\/strong> Reveal the Before &amp; After Slider image after the label is clicked<\\/li>\\n<li><strong>NEW:<\\/strong> Added CPT support and Post Status to Blog Slider module<\\/li>\\n<li><strong>NEW:<\\/strong> Added dynamic field to Scroll Image module<\\/li>\\n<li><strong>NEW:<\\/strong> \\u201cHide All Modules\\u201d option added<\\/li>\\n<li>Fixed Advanced Tabs issue where content is not displayed in the builder<\\/li>\\n<li>Fixed Popup position issue on category pages<\\/li>\\n<li>Fixed popup periodicity function not working<\\/li>\\n<li>Fixed Contact Form success message not displayed in the Popup Maker<\\/li>\\n<li>Fixed the Carousel issue when used in the Balloon module<\\/li>\\n<li>Fixed header white gap when resizing the browser<\\/li>\\n<li>Fixed Hover Box PHP notice<\\/li>\\n<li>Fixed Image Showcase displaying link cursor when the link is not added<\\/li>\\n<li>Improved spacing settings for the Fancy Text animated text<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.17 October 26th, 2022<\\/strong><\\/p>\\n<ul>\\n<li>NEW: Filterable Gallery for Divi<\\/li>\\n<li>Fixed Menu CTA Button placement issue in the Safari browser<\\/li>\\n<li>Added Carousel navigation responsive settings<\\/li>\\n<li>Fixed Floating Images animation in Safari browser<\\/li>\\n<li>Fixed Blurb icon placement issue caused by the Advanced Tabs responsive icon settings<\\/li>\\n<li>Fixed duplicated content showing on hover in the Advanced Tabs module<\\/li>\\n<li>Fixed Advanced Tabs not showing inside the Balloon module<\\/li>\\n<li>Fixed hamburger mobile menu animation when multiple menus are used<\\/li>\\n<li>Fixed duplicated mobile menu displayed on CPT pages<\\/li>\\n<li>Fixed the Panorama module not working with the LatePoint plugin<\\/li>\\n<li>Fixed Popup Maker page search functionality<\\/li>\\n<li>Added Line social network<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.16.1 September 14th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added continuous slide animation to the Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Added option to make website elements clickable when the popup is opened<\\/li>\\n<li><strong>NEW:<\\/strong> Added Horizontal Timeline active line position setting<\\/li>\\n<li><strong>NEW:<\\/strong> Added responsive tab icon\\/image placement settings to the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Added list customization settings to the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Added Typing Text start animation in viewport<\\/li>\\n<li><strong>NEW:<\\/strong> Added responsive image count option to the Masonry Gallery module<\\/li>\\n<li><strong>NEW:<\\/strong> Added option to use custom images for Timeline line<\\/li>\\n<li>Fixed Expanding CTA button dynamic link issue<\\/li>\\n<li>Fixed Popup Maker Guest user role not saving<\\/li>\\n<li>Fixed Popup video still playing when the popup is closed<\\/li>\\n<li>Fixed Pricing Table module is still available in the Divi Builder when the module is hidden<\\/li>\\n<li>Fixed Masonry Gallery rendering issue when used in the Advanced Tabs module<\\/li>\\n<li>Fixed testimonial length not working with the Chinese language<\\/li>\\n<li>Fixed Image Showcase rendering issues in Safari and Firefox browsers<\\/li>\\n<li>Fixed Horizontal Timeline SVG image not showing<\\/li>\\n<li>Fixed Advanced Tabs default tab issue<\\/li>\\n<li>Fixed Advanced Tabs duplicated tab icons when Theme Builder for product template is used<\\/li>\\n<li>Fixed Carousel equal height issue<\\/li>\\n<li>Fixed Carousel Module duplicated box shadow, borders, padding, and margins in the builder<\\/li>\\n<li>Fixed Carousel Image hover effect transition<\\/li>\\n<li>Fixed FAQ module title alignment not working<\\/li>\\n<li>Fixed Expanding CTA responsive font size settings not working<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.16 July 27th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Pricing Table module<\\/li>\\n<li><strong>NEW:<\\/strong> Advanced Tabs activate on hover option added<\\/li>\\n<li>Improved Divi Builder plugin and Extra Theme support<\\/li>\\n<li>Improved hamburger script and placed it in external JS file so it can be excluded from Delayed JavaScript Execution<\\/li>\\n<li>Fixed Advanced Tabs content width issue on tablets and mobiles<\\/li>\\n<li>Fixed Popup Maker On Load issue in front-end builder<\\/li>\\n<li>Fixed Popup Maker saving issue<\\/li>\\n<li>Fixed customization functionality when the Divi Builder plugin is used<\\/li>\\n<li>Fixed a bug that caused Divi Pixel to not add the Theme Customizer settings<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.15.1 July 9th, 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Image Slider Loop option not working<\\/li>\\n<li>Fixed not working Custom Map Marker<\\/li>\\n<li>Fixed nonce_check in Popup Maker<\\/li>\\n<li>Fixed et_pb_get_specific_default_font function error<\\/li>\\n<li>Improved Breadcrumbs schema markup<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.15.0 - July 6th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Tile Scroll module<\\/li>\\n<li>Added option to activate\\/deactivate popups from the Popup Maker CPT dashboard<\\/li>\\n<li>Added option to close popup when browser back button is clicked<\\/li>\\n<li>Added Triggering column to the Popup Maker CPT screen<\\/li>\\n<li>Added z-index control for the Popup Maker overlay<\\/li>\\n<li>Added quick preview option to Popup Maker<\\/li>\\n<li>Added support for the Divi Ghoster plugin<\\/li>\\n<li>Added Horizontal Order Direction to the Masonry Gallery module<\\/li>\\n<li>Added responsive mockup images to the Image Showcase module<\\/li>\\n<li>Fixed FAQ module collapsed icon alignment issue<\\/li>\\n<li>Fixed Info Circle dynamic button link issue<\\/li>\\n<li>Fixed Image Hotspot responsive tooltip displaying issue<\\/li>\\n<li>Fixed dynamic button link in Advanced Tabs and Info Circle modules<\\/li>\\n<li>Fixed SVG Animator triggers animation during customizing other modules<\\/li>\\n<li>Fixed not working responsive Fullwidth Tabs option in the Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.14.0 - June 22nd, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Popup Maker for Divi<\\/li>\\n<li>Added title H tag control to FAQ module<\\/li>\\n<li>Fixed Horizontal Timeline image\\/icon position responsive settings<\\/li>\\n<li>Fixed Horizontal Timeline navigation not working on mobiles<\\/li>\\n<li>Fixed Collapsed Mobile Menu icon issue for the closed menu<\\/li>\\n<li>Fixed duplicated Google testimonials added during fetching<\\/li>\\n<li>Fixed Back To Top Button icon issue when circle double arrow icon is selected<\\/li>\\n<li>Fixed Masonry Gallery manual order issue<\\/li>\\n<li>Fixed not working Advanced Tabs tab image alignment<\\/li>\\n<li>Fixed Advanced Tabs content area margin issue<\\/li>\\n<li>Fixed Expanding CTA overlay height issue on Android mobiles<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.13.0 - June 8th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added Text Highlighter module<\\/li>\\n<li>Added option to select the active tab on load in the Advanced Tabs module<\\/li>\\n<li>Added ordering settings to the Masonry Gallery module<\\/li>\\n<li>Fixed particles background issue when the parallax option is enabled<\\/li>\\n<li>Fixed Theme Customizer toggles not displaying the correct value<\\/li>\\n<li>Fixed button icons not working when the Dynamic CSS is enabled<\\/li>\\n<li>Fixed Carousel button link dynamic option<\\/li>\\n<li>Fixed collapsed submenu not working when Theme Builder Menu module used<\\/li>\\n<li>Fixed Timeline animations not working in Firefox and Safari browsers<\\/li>\\n<li>Fixed not loading Divi Pixel font when the user is logged in<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.12.0 - May 26th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Particles Background effect<\\/li>\\n<li>Fixed Hotspot Image unwanted square element displayed below module when Lazy Load is used<\\/li>\\n<li>Added animation settings to child modules in the Timeline module<\\/li>\\n<li>Added Image Slider heading customization settings for H tags placed in the description<\\/li>\\n<li>Updated PHP 8 depreciated functions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.11.0 - May 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Expanding CTA module<\\/li>\\n<li>Fixed Advanced Tabs button target issue<\\/li>\\n<li>Fixed Image Gallery navigation issue when used in Advanced Tabs module<\\/li>\\n<li>Fixed Carousel description HTML markup displayed when not used<\\/li>\\n<li>Fixed Carousel image box-shadow issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.10 - May 9th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Maintenance Mode feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Allow TTF, OTF and WOFF file uploads<\\/li>\\n<li>Fixed Image Slider issue when used in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.9 - May 5th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Horizontal Timeline module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added option to add overlay image for Scroll Image module and set reveal effect<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added Animate in Viewport and Delay options to the Lottie Icon module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added reverse direction animation for autorotate option in Info Circle module<\\/li>\\n<li>Improved JavaScript for Balloon module to address issues when used in Theme Builder<\\/li>\\n<li>Added Telegram social media icon<\\/li>\\n<li>Added link customization settings to FAQ module<\\/li>\\n<li>Added Carousel image\\/icon hover option<\\/li>\\n<li>Fixed Floating Images animations not working in Safari and iOS 15.4.1<\\/li>\\n<li>Fixed Fancy Text prefix goes out of the screen issue<\\/li>\\n<li>Fixed Dual Heading background text displayed in Divi Builder when not used<\\/li>\\n<li>Fixed Advanced Tabs Divi Library item width issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.8 - April 25th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Advanced Tabs module<\\/li>\\n<li>Fixed Image Slider custom thumbnails not displayed on front-end<\\/li>\\n<li>Fixed Image Slider title formatting and HTML tag displayed on front-end<\\/li>\\n<li>Fixed Image Hotspot mobile issue<\\/li>\\n<li>Fixed Image Hotspot box shadow and border-radius issue<\\/li>\\n<li>Fixed Hover Box and Flip Box gradient migration issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.2 - April 13th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Author Box and Menu CTA Button font issue<\\/li>\\n<li>Fixed Panorama video controls not working in Safari browser<\\/li>\\n<li>Fixed Panorama default height value not working<\\/li>\\n<li>Fixed Image Slider custom navigation not displayed on the frontend<\\/li>\\n<li>Fixed Divi Pixel settings import issue<\\/li>\\n<li>Fixed Masonry Gallery icon border not working<\\/li>\\n<li>Fixed Dual Heading background animation issue<\\/li>\\n<li>Fixed module link not working in Balloon module<\\/li>\\n<li>Fixed dropdown link background color not working with Theme Builder header<\\/li>\\n<li>Added multi-select field for CTA menu button<\\/li>\\n<li>Added gradient migration for new gradient builder to retain old values<\\/li>\\n<li>Added dynamic images and content to Before &amp; After Slider module<\\/li>\\n<li>Added dynamic content fields to the Grid Button module<\\/li>\\n<li>Added dynamic labels to the Content Toggle module<\\/li>\\n<li>Added dynamic prefix and suffix fields to the Counter module<\\/li>\\n<li>Added dynamic heading content to the Dual Heading module<\\/li>\\n<li>Added dynamic fields for prefix and suffix in Fancy Text module<\\/li>\\n<li>Added dynamic image and image link fields to the Floating Images module<\\/li>\\n<li>Added dynamic image and content fields to Accordion Image module<\\/li>\\n<li>Added dynamic images and content fields to the Image Hotspot module<\\/li>\\n<li>Added dynamic images and content fields to the Balloon module<\\/li>\\n<li>Added dynamic images and content fields to the Carousel module<\\/li>\\n<li>Added dynamic images and content fields to the Flip Box module<\\/li>\\n<li>Added dynamic images and content fields to the Hover Box module<\\/li>\\n<li>Added dynamic images fields to the Image Magnifier module<\\/li>\\n<li>Added dynamic images fields to the Image Mask module<\\/li>\\n<li>Added dynamic images fields to the Image Showcase module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.1 - April 6th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Added Projects category and tag slug options<\\/li>\\n<li>Added CSS ID &amp; Classes fields to Image Accordion child items<\\/li>\\n<li>Added Half Circle option to the Counter module<\\/li>\\n<li>Added new gradient support to Divi Pixel modules<\\/li>\\n<li>Added image placeholder to Tilt Image module<\\/li>\\n<li>Fixed Circle Info Button margin not working<\\/li>\\n<li>Fixed Circle Info icon height issue<\\/li>\\n<li>Fixed Circle Info content switch on mobiles not working<\\/li>\\n<li>Fixed Circle Info icons not displayed in Firefox\\/Safari when icon animation is enabled<\\/li>\\n<li>Fixed Facebook and Google API code causing an error on cron<\\/li>\\n<li>Fixed Panorama responsive height issue<\\/li>\\n<li>Fixed Carousel, Content Toggle &amp; Balloon fatal errors sent to the email after WP autosave is triggered<\\/li>\\n<li>Fixed Carousel pagination responsive settings issue<\\/li>\\n<li>Fixed Carousel arrow navigation not working on mobile devices<\\/li>\\n<li>Fixed Masonry Gallery circle icon issue in builder<\\/li>\\n<li>Fixed Image Hotspot spacing issue in Firefox\\/Safari browsers<\\/li>\\n<li>Updated cron timing frequency for license check (twice daily)<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7 February 23rd 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Info Circle module added<\\/li>\\n<li>Updated Google social media icon<\\/li>\\n<li>Updated Snapchat and TikTok SVG images creating an error<\\/li>\\n<li>Updated Image Hotspot position value step to 0.1<\\/li>\\n<li>Updated hotspot icon line height causing hotspot icon to be not perfectly centred<\\/li>\\n<li>Improved Scroll Image horizontal mouse scroll performance<\\/li>\\n<li>Improved preloader performance<\\/li>\\n<li>Fixed Tilt Image glare effect<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Panorama rendering issues in Divi Builder when the video is used<\\/li>\\n<li>Fixed Panorama height not working when the video is used<\\/li>\\n<li>Fixed Flip Box back button padding not working<\\/li>\\n<li>Fixed Dual Heading module bottom margin and padding not working<\\/li>\\n<li>Fixed Dual Heading text background clipping for the 2nd text not working<\\/li>\\n<li>Fixed Carousel image border radius when box-shadow added not applying properly<\\/li>\\n<li>Fixed custom blog layout style not applying when Theme Builder template is used<\\/li>\\n<li>Fixed Image Slider Divi Library shortcodes not rendering<\\/li>\\n<li>Fixed dropdown arrow displayed on child submenus<\\/li>\\n<li>Fixed Search icon position when CTA Button not used<\\/li>\\n<li>Added support for PHP 8<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6.1 January 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added language settings for Google testimonials<\\/li>\\n<li><strong>NEW:<\\/strong> Added options to Exclude\\/Include Testimonials by Post ID<\\/li>\\n<li><strong>NEW:<\\/strong> Added 9 new animations to the Floating Images module<\\/li>\\n<li>Updated Floating Images position max and min values<\\/li>\\n<li>Fixed Floating Images transition CSS not working<\\/li>\\n<li>Fixed issue with Menu Hover Effect applies to the centred header logo<\\/li>\\n<li>Fixed Blog Slider random order not working<\\/li>\\n<li>Fixed not working link in Carousel child module<\\/li>\\n<li>Removed Carousel button wrapper HTML markup when the button is not used<\\/li>\\n<li>Added Soundcloud and TikTok icons to Social Media settings<\\/li>\\n<li>Added CSS ID &amp; Classes field to the Image Hotspot child module<\\/li>\\n<li>Added dynamic image support for Image Slider module (front-end only)<\\/li>\\n<li>Fixed JS error after searching when post meta section is empty<\\/li>\\n<li>Fixed Image Slider text displayed on sides when 3D Cube mode is used<\\/li>\\n<li>Fixed SVG Animator default width and height not working in Safari browser<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Tilt Image flickering issue in Chrome browser<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6 December 8th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> SVG Animator module added<\\/li>\\n<li>Image Slider thumbnails height various units support added<\\/li>\\n<li>Blog Slider backward PHP (&lt;7.2) compatibility issue fixed<\\/li>\\n<li>custom styles did not apply on paginated blog pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.3 November 26th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\" data-border-radius-top-cap=\\\"false\\\" data-border-radius-bottom-cap=\\\"false\\\">\\n<li><strong>NEW:<\\/strong> Image Accordion Always Visible new settings for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Showcase individual images links feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider featured image animation effects added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel image animation settings added<\\/li>\\n<li><strong>NEW:<\\/strong> All Divi Pixel modules support new Divi icons<\\/li>\\n<li>Carousel new custom CSS for active slide added<\\/li>\\n<li>Blog Slider navigation responsive settings added<\\/li>\\n<li>Blog Slider featured image border and box-shadow customization settings added<\\/li>\\n<li>Blog Slider new Custom CSS fields for navigation and active slide added<\\/li>\\n<li>Blog Slider pagination not working in builder when multiple instances used issue fixed<\\/li>\\n<li>Content Toggle new Custom CSS fields for toggle button added<\\/li>\\n<li>Image Mask shape 7 not displayed properly on front end issue fixed<\\/li>\\n<li>Masonry Gallery Grid Items border not working issue fixed<\\/li>\\n<li>Accordion module not triggered in Carousel module issue fixed<\\/li>\\n<li>Dropdown menu text color not working on fixed header issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.2 October 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 28 new masks added to the Image Mask module<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask selector field improved<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask: option to rotate, scale and flip the mask<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask image Alt Text field added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask upload custom shape option added<\\/li>\\n<li>Image Mask placeholder image added<\\/li>\\n<li>Image Showcase module URL issue fixed<\\/li>\\n<li>Carousel Autoplay stops working when the Pause on Hover option is disabled issue fixed<\\/li>\\n<li>Carousel item doesn\\u2019t take full width when short content is added issue fixed<\\/li>\\n<li>Countdown Timer doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Counter module doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Image Magnifier module doesn\\u2019t work in builder issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1 September 30th 2021<\\/strong><\\/p>\\n<ul>\\n<li>FAQ module categories missed issue fixed<\\/li>\\n<li>Custom preloader not working issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5 September 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Dual Heading module added<\\/li>\\n<li>Mobile Menu on WooCommerce pages issues fixed<\\/li>\\n<li>Blog archive custom style not applying for pagination pages issue fixed<\\/li>\\n<li>Image Hotspot tooltip displaying when border radius on the image is used issue fixed<\\/li>\\n<li>Image Hotspot tooltip image default width not applying in the builder issue fixed<\\/li>\\n<li>Image Hotspot new Ripple Effect style added<\\/li>\\n<li>Image Hotspot default image placeholder added<\\/li>\\n<li>Image Hotspot tooltip spacing in builder issue fixed<\\/li>\\n<li>Improved backwards compatibility with outdated PHP versions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4.2 - September 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider thumbnails margin controls added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider responsive settings for Image Overlay added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider custom thumbnail option added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider custom CSS field for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Slide Image responsive position control added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay hover settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay responsive settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Price List - Price Prefix and Suffix fields added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery image animation options added<\\/li>\\n<li>Custom Map Marker being cropped issue fixed<\\/li>\\n<li>Hover Box double arrow icon issue fixed<\\/li>\\n<li>Testimonial Slider Random order issue fixed<\\/li>\\n<li>Image Showcase in hidden section causing JS error issue fixed<\\/li>\\n<li>Blog Slider active pagination color issue fixed<\\/li>\\n<li>Blog Slider Content custom CSS field added<\\/li>\\n<li>dipi-anim-preload class not removed from the body after the page is loaded issue fixed<\\/li>\\n<li>Image Showcase causing JS error when the module is hidden issue fixed<\\/li>\\n<li>CTA Menu Button text color when Menu module is used issue fixed<\\/li>\\n<li style=\\\"list-style-type: none;\\\"><\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.4.1 August 23rd 2021<\\/strong><\\/p>\\n<p>Divi 4.10+ compatibility<\\/p>\\n<ul>\\n<li>Carousel lightbox functionality issue fixed<\\/li>\\n<li>Masonry Gallery layout grid and lightbox issue fixed<\\/li>\\n<li>Preloader, when Defer jQuery and jQuery Migrate option is enabled issue fixed<\\/li>\\n<li>Image Slider when Defer jQuery and jQuery migrate option is enabled issue fixed<\\/li>\\n<li>Counter module when Dynamic JS Libraries option enabled issue fixed<\\/li>\\n<li>Price List module when Dynamic JS Libraries enabled lightbox issue fixed<\\/li>\\n<li>Testimonial Slider popup when Dynamic JS Libraries enabled issue fixed<\\/li>\\n<li>Conditional Display when Dynamic Module Framework enabled issue fixed<\\/li>\\n<\\/ul>\\n<p>Improvements\\/Fixes<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\"><strong>NEW:<\\/strong> Image Slider Autoplay settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Archive page Style 2 - broken layout on category pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4 August 18th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Hotspot responsive positioning settings added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Open Carousel image in lightbox option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Reverse Carousel slide direction when Autoplay option is enabled<\\/li>\\n<li><strong>NEW:<\\/strong> Price List image lightbox gallery option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Masonry Gallery image link option added<\\/li>\\n<li>Carousel item Box Shadow on hover issue fixed<\\/li>\\n<li>Sidebar customization issues fixed<\\/li>\\n<li>Testimonial Slider heading customization settings added<\\/li>\\n<li>Carousel reloading in builder issue fixed<\\/li>\\n<li>Price List responsive settings for the layout and image added<\\/li>\\n<li>Price List module Box Shadow option to the parent module added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.3.2 July 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li>Related Article hover activation issue fixed<\\/li>\\n<li>Footer social icons when credits are disabled issue fixed<\\/li>\\n<li>Menu CTA button - menu selection issue fixed<\\/li>\\n<li>Image Hotspot - tooltip button when Trigger on Click is enabled issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.3.1 July 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Menu CTA Button - option for selecting menu added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Showcase - 11 new mockups added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box text line-height default values fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs alignment responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Divi Builder plugin &amp; Extra theme compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Exclude Posts option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive Featured Image border-radius option added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p>2.3 July 7th 2021<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> FAQ module with Google Structured Data added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider - category class added for single post box<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.5 June 30th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added new Section, Row and Module settings to conditionally display content based on users role or a login status<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Suppress Filters option is added to use the attempted filter by other 3rd party plugins (like WPML)<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mobile Menu Hamburger icon browser compatibility improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline card width when the icon is used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module PHP 7.2 compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Rename Projects tab category slug issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.4 June 18th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">duplicated logo when multiple Theme Builder headers are used issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.3 June 16th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> apply blog archive style to the native Divi Blog module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> select image size for the Blog Slider module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Divi Library Shortcodes to use in any module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Option to hide \\u201cEdit in Visual Builder\\u201d link on pages\\/posts overview dashboard pages<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial Read More popup font customization settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider \\u201cOrder By\\u201d settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - hide tooltip option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - link field to the hotspot child added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot isn\\u2019t interactive anymore issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider HTML markup displayed for disabled elements issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Accordion TinyMCE editor support added for the description field<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image responsive scroll speed settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Panorama 2D Image mode scroll issue on tablets and mobiles fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider responsive settings for navigation size and padding added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider - testimonials order settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More link disabled when a full testimonial is displayed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mega Menu width issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Read More Button Text\\u201d doesn\\u2019t apply to the native Divi Blog module issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d doesn\\u2019t apply to the Theme Builder custom header issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Collapsed mobile top menu not clickable issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module visibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module displaying on archive pages issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs separator alignment issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Lottie Icon width not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Content Toggle\\/Masonry Gallery compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Full-width post does not display full-width sections in frontend Divi Builder issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.2 April 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: open tooltip on click<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: tooltip animations added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Carousel - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module margin in Divi Builder modules list issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Ballon button link target issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">plugin settings modules list updated<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider HTML support for review text added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image content animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon button shadow not applying in builder properly issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider not working with Blog module when testimonial CPT is selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module fetches taxonomy from pages where taxonomy is not added issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline line border styles issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial custom CSS for Profile Image selector fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.1 April 2nd, 2021<\\/strong><\\/p>\\n<ul>\\n<li>plugin updater issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.0 April 1st, 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Ballon module added<\\/li>\\n<li>Blog Slider item not clickable in Firefox browser issue fixed<\\/li>\\n<li>Content Toggle et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li>Content Toggle and Image Showcase compatibility improved<\\/li>\\n<li>Testimonial Slider popup\\/Divi Machine conflict issue fixed<\\/li>\\n<li>API licensing UI and functionality improved<\\/li>\\n<li>Documentation pages UI improved<\\/li>\\n<\\/ul>\\n<p><strong>2.1.2 March 8th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">Content Toggle issue with dipi_label function issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module dipi_label function replaced with esc_html__ function<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.1 March 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Disable LazyLoad in Content Toggle module settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Enable Lightbox responsive settings issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Plugin Settings\\/Modules options updated<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.0 - February 25th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Content Toggle module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Archive section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Post Navigation section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Author Box section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Related Articles section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Disable Lightbox responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d in Firefox displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d ON\\/OFF builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box circle icon issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box WPML support improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image\\/Icon alignment in Timeline not working in Divi Builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel Autoplay option doesn\\u2019t work in Safari issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel items displayed vertically in Safari 8 issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel child item hover icon not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Button Grid on mobiles improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Floating Images Transform settings not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box height controls improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box solid border issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase rendering with WP Rocket Lazy Loading in different browsers issues fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image mouse scrolling improved<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.0.1 - February 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW: <\\/strong>Masonry Gallery Coverflow Animations<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Masonry Gallery - disable image lightbox option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box jQuery variable naming issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">CSS error preventing Divi scripts from compile issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text child module link issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion image responsive settings improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image Active On Load and Open On Click issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">fonts in Theme Customizer did not enqueue issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.0.0 - January 26th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Timeline module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added CSS ID &amp; Classes to Button Grid child modules<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> WhatsApp, Snapchat and Xing social media icons added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Active Image size responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Opened on Load responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Performance improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Mask SVG markup issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase - image positioning tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Primary Header Social Icons positioning when CTA Button is not used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery image width causing the problem with the proper displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Button displaying multiple icons when icon not selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default content-length value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default spacing value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Error messages when Google reviews are fetched corrected<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image arrow color rendering in builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box name improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text alignment settings revised<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup displaying mixed testimonials issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup image styling issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.3 - December 16th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>collapsed mobile menu close animation fixed<\\/li>\\n<li>dropdown menu width max value increased<\\/li>\\n<li>Hamburger Mobile Menu not displayed after WP 5.6 issue fixed<\\/li>\\n<li>minor code improvements in Panorama and Lottie modules<\\/li>\\n<li>Carousel Coverflow mode - disabled slide shadow issue fixed<\\/li>\\n<li>Duplicated Social Icons in Primary Header issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.2 - December 7th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Breadcrumbs active item styles missed on front-end issue fixed<\\/li>\\n<li>Dropdown menu item width control added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.1 - December 5th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Carousel spacing issue fixed<\\/li>\\n<li>plugin package\\/2 new modules Divi Builder rendering issues fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.0 - December 4th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Showcase module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask module added<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS Class field added to the header CTA button<\\/li>\\n<li><strong>NEW:<\\/strong> Divi Builder support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Extra theme support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Post Type\\/Taxonomy settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Alignment settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Dynamic button URL to Grid Button module added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel module CSS ID &amp; Classes added to child items<\\/li>\\n<li>Vertical Navigation style issues fixed<\\/li>\\n<li>Testimonial Slider overflow issue fixed<\\/li>\\n<li>Mobile Menu animation out when Theme Builder header used issue fixed<\\/li>\\n<li>Blog Archive responsive breakpoint updated<\\/li>\\n<li>Hotspot tooltip height on mobiles issue fixed<\\/li>\\n<li>Blog Slider body text and button box-shadow issues fixed<\\/li>\\n<li>Admin Label field added to the Carousel child modules<\\/li>\\n<li>Tooltip image wrapper if image not selected - HTML markup not displayed<\\/li>\\n<li>Post meta alignment on archive page issue fixed<\\/li>\\n<li>Tilt Image mobile height issue fixed<\\/li>\\n<li>Footer Reveal Effect visibility in the front-end builder issue fixed<\\/li>\\n<li>Hide Admin Bar setting issue fixed<\\/li>\\n<li>Hide Admin Bar\\/Hide Top Header\\/Reading Progress Bar issues fixed<\\/li>\\n<li>Breadcrumbs Schema Markup issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.9 - 14 October 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Mobile Submenu customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Collapsed Mobile menu icon customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Circle animation for Mobile Menu background overlay added<\\/li>\\n<li>Menu Dropdown visibility with Theme Builder Header and Footer Reveal Effect enabled issue fixed<\\/li>\\n<li>default Mobile Menu animation performance issue fixed<\\/li>\\n<li>Centered Inline Logo header alignment fixed<\\/li>\\n<li>Centered header hamburger icon position fixed<\\/li>\\n<li>Stand and Spring style Hamburger icon animation issues fixed<\\/li>\\n<li>Fixed Mobile Menu container gap issue on mobiles fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.2 - 28th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>NEW: Add Arrow to Dropdown Menus<\\/li>\\n<li>NEW: Dropdown Menu width and position controls added<\\/li>\\n<li>NEW: Open Menu Button Link in a New Window option added<\\/li>\\n<li>Header Height\\/Spacing issues fixed<\\/li>\\n<li>Hide Top Bar feature improved<\\/li>\\n<li>Do Not Shrink Header on Scroll feature improved<\\/li>\\n<li>Social Icons in Secondary Menu Firefox issue fixed<\\/li>\\n<li>CTA Menu Button Position First\\/Last issue fixed<\\/li>\\n<li>Centered\\/Centered Inline header style issues fixed<\\/li>\\n<li>Top Bar performance on mobiles improved<\\/li>\\n<li>Mobile Menu paddings issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.1 - 15th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Fixed duplicated hamburger icons when more than one menu was used on a page<\\/li>\\n<li>Do Not Shrink Header functionality improved<\\/li>\\n<\\/ul>\\n<p><strong>1.8 - 13th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Magnifier module<\\/li>\\n<li><strong>NEW:<\\/strong> Lottie Icon module<\\/li>\\n<li>Plugin Settings page responsive issues fixed<\\/li>\\n<li>Plugin Settings Page Toolbar added<\\/li>\\n<li>Hide Admin Bar when user not logged in issue fixed<\\/li>\\n<li>Archive Page Header Injector issue fixed<\\/li>\\n<li>Bottom Bar customization issues fixed<\\/li>\\n<li>Back To Top custom link issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.7.1 - 28th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Panorama module PHP error for older PHP versions<\\/li>\\n<\\/ul>\\n<p><strong>1.7 - 27th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Panorama module<\\/li>\\n<li><strong>NEW:<\\/strong> Reading Progress Bar module<\\/li>\\n<li><strong>NEW:<\\/strong> Google icon to Social Icons added<\\/li>\\n<li>SVG image upload feature improved<\\/li>\\n<li>Force Footer to Bottom when Theme Builder used issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.6.2 - 20th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed an issue with social icons individual locations<\\/li>\\n<li>Fixed an issue with the revealing footer effect<\\/li>\\n<\\/ul>\\n<p><strong>1.6.1 - 15th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue in Divi Pixel options panel (WordPress 5.5 compatibility)<\\/li>\\n<li>Fixed an issue where individual social icon locations would break the menus<\\/li>\\n<\\/ul>\\n<p><strong>1.6.0 - 12th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Scrollable Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt text field added for Hover Box images<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Accordion Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS fields added to Accordion Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Tilt Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Hotspot Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List configurable HTML title tag option added<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Label field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Fixed responsive flex settings for Button Grid and added options for alignment and justification<\\/li>\\n<li><strong>NEW:<\\/strong> Login Page custom logo URL option added<\\/li>\\n<li><strong>NEW:<\\/strong> option to add links to images in Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> SVG image preview in Media Library added<\\/li>\\n<li>Tilt Image title customization issue fixed<\\/li>\\n<li>fixed issue with Theme Customizer scripts not loading on FlyWheel hosted sites<\\/li>\\n<li>Hover Box displaying empty heading tags issue fixed<\\/li>\\n<li>duplicated Prefix and Suffix spans in Typing Text module issue fixed<\\/li>\\n<li>Login Page logo size default values fixed<\\/li>\\n<li>Added option to Masonry Gallery to enable lazy loading images compatibility<\\/li>\\n<li>Automatically scroll to the top of the Divi Pixel options page after switching tabs<\\/li>\\n<li>Fixed Masonry Gallery not opening images in a lightbox<\\/li>\\n<li>Accordion Image responsive spacing issue fixed<\\/li>\\n<li>Carousel box-shadow and border child module issue fixed<\\/li>\\n<li>Carousel module left navigation positioning issue in builder fixed<\\/li>\\n<li>Flip Box content displaying issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.5.0 - 8th May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Accordion Module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box: added option to force the module to be a square<\\/li>\\n<li>Fixed \\\"open in new window\\\" option in various modules<\\/li>\\n<li>Improved SVG upload functionality to allow different mime types<\\/li>\\n<li>Fixed Related Articles and Author Box when Theme Builder is used<\\/li>\\n<li>Fixed Blog Slider default columns on tablet and mobiles<\\/li>\\n<li>Fixed \\\"Related Articles\\\" heading, which was sometimes displayed on custom post types<\\/li>\\n<li>Fixed Flex Direction responsive options in Typing Text module<\\/li>\\n<li>Fixed Image Hotspot heading level option in Visual Builder<\\/li>\\n<li>Fixed various typos<\\/li>\\n<li>Added some semicolons here and there to spice up the code (and fix some issues)<\\/li>\\n<\\/ul>\\n<p><strong>1.4.4 - 31st May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Flip Box Dynamic Height option added<\\/li>\\n<li><strong>NEW:<\\/strong> Flip Box: force module to be a square option added<\\/li>\\n<li>Flip Box Image Overlay builder issue fixed<\\/li>\\n<li>Flip Box icon not displayed on front-end issue fixed<\\/li>\\n<li>Primary Menu customization when Menu Hover Animation disabled issue fixed<\\/li>\\n<li>Masonry Gallery: IE browser issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.3 - 27th May 2020<\\/strong><\\/p>\\n<ul>\\n<li>Flip Box: height issue fixed<\\/li>\\n<li>Flip Box: Back Button not displayed on front-end issue fixed<\\/li>\\n<li>Flip Box: 3D Content Effect issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.2 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Flip Box module: Dynamic Height option removed<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.1 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Plugin Settings\\/Modules section updated<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.0 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Fancy Text module added<\\/li>\\n<li>Breadcrumbs Module: responsive padding options added<\\/li>\\n<li>Breadcrumbs: separator icon issue fixed<\\/li>\\n<li>Back To Top Button: box-shadow issue on hover fixed<\\/li>\\n<li>Back To Top Button: custom link issue fixed<\\/li>\\n<li>Menu CTA Button: hover text\\/background issue fixed<\\/li>\\n<li>Secondary Header menu\\/social icons positioning issue fixed<\\/li>\\n<li>Button Grid: icon size and positioning fixed<\\/li>\\n<li>Blog Archive: meta text icons positioning fixed<\\/li>\\n<li>Blog Slider image clickable option added<\\/li>\\n<li>Blog Slider: responsive image height option added<\\/li>\\n<li>Mobile Menu: Theme Builder header issues fixed<\\/li>\\n<li>Custom Mobile Breakpoint: all menu customization settings revised and improved<\\/li>\\n<li>Login Page: form field text size option added<\\/li>\\n<li>Login Page: logo size issue fixed, logo height option added<\\/li>\\n<li>Related Articles: section title font size issue fixed<\\/li>\\n<li>Testimonial Slider: read more popup size on mobiles issue fixed<\\/li>\\n<li>Header Menu: customization setting improved<\\/li>\\n<li>Hover Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Hover Box: module not displayed in Builder\\/Firefox issue fixed<\\/li>\\n<li>Hover Box: responsive height fixed<\\/li>\\n<li>Flip Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Image Hotspot, Hover Box, Flip Box, Carousel, Tilt Image: configurable HTML title tag option added<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.3.1 - 26th April 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed a bunch of smaller bugs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.0 - 20th April 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Blog Slider module<\\/li>\\n<li><strong>NEW<\\/strong>: Animation Delay option in Counter module<\\/li>\\n<li><strong>NEW:<\\/strong> Option to enable beta downloads<\\/li>\\n<li>Mobile Menu issue fixed<\\/li>\\n<li>Header\\/Menu Animation issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0 - 26th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Countdown module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box module<\\/li>\\n<li>Force Footer to Bottom Firefox issue fixed<\\/li>\\n<li>Filled Background menu animation style Firefox issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0 - 16th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Hotspot module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Export\\/Import functionality added to the Divi Pixel options panel<\\/li>\\n<li>Back to top button functionality improved<\\/li>\\n<li>Testimonial Slider mobile issues fixed<\\/li>\\n<li>Testimonial Slider Website URL field added<\\/li>\\n<li>The improved license activation process<\\/li>\\n<li>Licensing API Library updated<\\/li>\\n<\\/ul>\\n<p><strong>1.0.0 - 4th March 2020<\\/strong><\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/www.divi-pixel.com\\/wp-content\\/uploads\\/2020\\/03\\/dp-affiliate-banner-02-128x128.png\",\"2x\":\"https:\\/\\/www.divi-pixel.com\\/wp-content\\/uploads\\/2020\\/03\\/dp-affiliate-banner-02-256x256.png\"},\"description\":[\"<p>[et_pb_section fb_built=\\\"1\\\" admin_label=\\\"section\\\" _builder_version=\\\"4.16\\\" collapsed=\\\"on\\\" global_colors_info=\\\"{}\\\"][et_pb_row column_structure=\\\"1_2,1_2\\\" admin_label=\\\"row\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"][et_pb_column type=\\\"1_2\\\" _builder_version=\\\"4.20.4\\\" _module_preset=\\\"default\\\" global_colors_info=\\\"{}\\\"][\\/et_pb_column][et_pb_column type=\\\"1_2\\\" _builder_version=\\\"4.16\\\" custom_padding=\\\"|||\\\" global_colors_info=\\\"{}\\\" custom_padding__hover=\\\"|||\\\"][et_pb_text admin_label=\\\"Text\\\" _builder_version=\\\"4.16\\\" background_size=\\\"initial\\\" background_position=\\\"top_left\\\" background_repeat=\\\"repeat\\\" global_colors_info=\\\"{}\\\"]<br \\/>\\nDivi Pixel is an all-in-one solution for all Divi users, from absolute beginners to professionals. Create amazing websites using powerful Divi Pixels modules and settings.<br \\/>\\n[\\/et_pb_text][\\/et_pb_column][\\/et_pb_row][\\/et_pb_section]<\\/p>\\n\"],\"changelog\":[\"<p><strong>2.29.2 December 21st 2023<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Dual Heading border issue<\\/li>\\n<li>Fixed Divi 4.23.2 compatibility issue<\\/li>\\n<li>Fixed Tripadvisor social icon issue<\\/li>\\n<li>Fixed Table Maker depraciated PHP: automatic conversion of false to array<\\/li>\\n<li>Fixed Flip Box module showing back side<\\/li>\\n<li>Fixed Popup Maker position issue when content is having single tags<\\/li>\\n<li>Fixed Filterable Gallery JS error when Conditional Display is used<\\/li>\\n<li>Improved Blog Slider data attribute format<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.29.1 December 15th 2023<\\/strong><\\/p>\\n<ul>\\n<li>Fixed parent mobile menu item link issue<\\/li>\\n<li>Fixed Jetpack captcha field width on login screen<\\/li>\\n<li>Fixed not saving Divi Pixel Category and link in Media Library<\\/li>\\n<li>Fixed not showing Read More button for arabic string in Blog Slider<\\/li>\\n<li>Fixed Dual Heading background text stroke color issue<\\/li>\\n<li>Fixed JS error when responsive text settings for TOC module title are used<\\/li>\\n<li>Fixed Gravity Forms Styler border issue when Orbital theme is used<\\/li>\\n<li>Added delay option to the Typing Text module<\\/li>\\n<li>Added archive page styling for search results page<\\/li>\\n<li>Added option to hide Homepage in the Breadcrumbs module<\\/li>\\n<li>Added option to remove Html for empty field in Testimonial Slider<\\/li>\\n<li>Added pagination and load more settings to the Masonry Gallery module<\\/li>\\n<li>Added option to show\\/hide Clear Divi Cache option in the WP toolbar<\\/li>\\n<li>Improved Fix Lazy Loading Image in Filterable Grid and Filterable Gallery<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.29.0 November 24th 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Table Maker module<\\/li>\\n<li>Added margin, padding and custom CSS filed for Advanced Tabs tab image<\\/li>\\n<li>Added Divider module to WPML config file<\\/li>\\n<li>Added custom CSS field to Advanced Tabs button<\\/li>\\n<li>Added shortcode support to Blog Slider, Parallax Image and Pricing Table modules<\\/li>\\n<li>Added title tag control for the Pricing Table Feature<\\/li>\\n<li>Added ability to translate DIPI category taxonomy<\\/li>\\n<li>Added support of Gravity Forms Styler to different themes<\\/li>\\n<li>Added Link toggle to Tile Scroll child modules<\\/li>\\n<li>Added \\u201cClickable Card\\u201d option to the Blog Slider module<\\/li>\\n<li>Added mobile option for the Ripple Effect Style 2 in the Image Hotspot module<\\/li>\\n<li>Added alt text for image in the Expanding CTA module<\\/li>\\n<li>Fixed Reveal module expanded height issue<\\/li>\\n<li>Fixed Panorama responsive issue<\\/li>\\n<li>Fixed menu hover animation when translation is used<\\/li>\\n<li>Fixed Reveal height in Advanced Tabs, Content Slider and Content Toggle<\\/li>\\n<li>Fixed Flip Box dynamic link issue<\\/li>\\n<li>Fixed not working page exclusion option in the TOC module<\\/li>\\n<li>Fixed not working Carousel link in older Safari browsers<\\/li>\\n<li>Improved Image Hotspot tooltip position on mobiles<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.28.0 October 11th 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Divider module<\\/li>\\n<li>Fixed Accordion Image rendering issue when used in Theme Builder template<\\/li>\\n<li>Fixed WPML-config.xml file conflict with Polylang plugin<\\/li>\\n<li>Fixed Reveal issue when used in the Content Slider module<\\/li>\\n<li>Fixed Image Slider thumbs navigation not working when Theme Builder is used<\\/li>\\n<li>Fixed Filterable Grid taxonomy select field issue with the Polylang plugin<\\/li>\\n<li>Fixed not working FAQ module order not working in the builder<\\/li>\\n<li>Fixed incorrect image count displayed in the Image Slider lightbox<\\/li>\\n<li>Fixed Gravity Forms Styler unique ID field not showing in the editor<\\/li>\\n<li>Fixed Gravity Forms Styler dropdown arrow position issue<\\/li>\\n<li>Added Custom CSS fields for Hover Gallery images and content icons<\\/li>\\n<li>Added Yelp and Spotify social media icons<\\/li>\\n<li>Added Popup Maker width settings<\\/li>\\n<li>Added Custom CSS ID &amp; Classes to the Timeline child items<\\/li>\\n<li>Updated WPML configuration file<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.27.0 September 13th 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Reveal module<\\/li>\\n<li>Added Box Shadow and Border settings to the Typing Text module<\\/li>\\n<li>Added Alt Text for images in the Info Circle module<\\/li>\\n<li>Added option to use icons with links in the Floating Images module<\\/li>\\n<li>Added Load More, Pagination, and Infinite Scroll options to the Masonry Gallery module<\\/li>\\n<li>Added Carousel Image Height control<\\/li>\\n<li>Added responsive settings for Show Table Title in the TOC module<\\/li>\\n<li>Added ACF support to the Price List module<\\/li>\\n<li>Added author prefix &amp; link target setting to the Filterable Grid module<\\/li>\\n<li>Fixed Testimonial Slider issue when content includes unicode symbols<\\/li>\\n<li>Fixed Table of Content issue when the Generate for Whole Page option is enabled<\\/li>\\n<li>Fixed Table of Contents issue when special characters are used in the title<\\/li>\\n<li>Fixed not working CTA button settings in the footer menu<\\/li>\\n<li>Fixed not a clickable logo in the header when the centered header is used<\\/li>\\n<li>Fixed CTA Menu Button styles not applying to the secondary menu<\\/li>\\n<li>Apply mobile menu styles only for the header menu, not for the footer<\\/li>\\n<li>Enabled Divi Pixel taxonomy for all CPT<\\/li>\\n<li>Updated Twitter icon<\\/li>\\n<li>Updated WPML config file<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.26.0 August 9th 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Table of Contents module added<\\/li>\\n<li><strong>NEW:<\\/strong> Clear Divi Cache functionality added to the WP dashboard toolbar<\\/li>\\n<li>Fixed Float Thumbs Over Main Image responsive issues in the Image Slider module<\\/li>\\n<li>Fixed Gravity Forms Styler submit button issue when placed at the end of a row<\\/li>\\n<li>Fixed Image Hotspot warning in the child module<\\/li>\\n<li>Fixed Image Rotator preloader issue when the image is bigger than the viewport height<\\/li>\\n<li>Fixed not clickable logo on mobile when centered header style is used<\\/li>\\n<li>Fixed not working border for the menu CTA button<\\/li>\\n<li>Added Popup Maker WPML support<\\/li>\\n<li>Added Tripadvisor, Twitch, and Yelp social media icons<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.25.1 July 13th 2023<\\/strong><\\/p>\\n<ul>\\n<li>Added preloader to the Image Rotator module<\\/li>\\n<li>Fixed WPML config file to fix the Pricing Table text field translation issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.25.0 July 12th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Image Rotate module added<\\/li>\\n<li>Fixed Testimonial Slider avatar issue for WooCommerce reviews<\\/li>\\n<li>Fixed Filterable Grid Sticky Filter issue<\\/li>\\n<li>Fixed submenu not opening in some devices when \\u2018Collapse Submenu Items on Mobiles\\u2019 is enabled<\\/li>\\n<li>Fixed rendering issue of Image Gallery in Content Slider<\\/li>\\n<li>Fixed Image Accordion background image not working when the image is not selected in the child module<\\/li>\\n<li>Fixed PHP warning in Expanding CTA module<\\/li>\\n<li>Fixed missing styling of Submit button container in the Gravity Forms Styler module<\\/li>\\n<li>Fixed not working \\u2018Hide Close Button\\u2019\\u00a0 in Popup Maker after PHP 8.0<\\/li>\\n<li>Fixed not working image animation in the Filterable Grid module<\\/li>\\n<li>Fixed archive\\/categories pages excerpt font color issue<\\/li>\\n<li>Fixed Image Hotspot ripple effect issue in Firefox browser<\\/li>\\n<li>Fixed dynamic text not rendering in the Visual Builder in the Text Highlighter module<\\/li>\\n<li>Added option to hide content by default in the Advanced Tabs module<\\/li>\\n<li>Added scroll bar to Filterable Gallery when image caption in lightbox goes out of the screen<\\/li>\\n<li>Added stronger selector to Button Grid for default margin-bottom of child module<\\/li>\\n<li>Added Slide Selector to the Content Slider module<\\/li>\\n<li>Added navigation settings to the Content Slider module<\\/li>\\n<li>Added \\u201cContent as Raw HTML\\u201d to the Blog Slider module<\\/li>\\n<li>Added tab index and field values setting to the Gravity Forms Styler module<\\/li>\\n<li>Added Show More button functionality to the Filterable Grid module<\\/li>\\n<li>Added publishing date, categories, and author to the Filterable Grid module<\\/li>\\n<li>Added filters to the Filterable Grid module<\\/li>\\n<li>Improved Filterable Grid title\\/content hover color functionality<\\/li>\\n<li>Improved \\u201cApply Hover Style to Active Menu Item\\u201d function<\\/li>\\n<li>Improved speed using async images in Blog Slider<\\/li>\\n<li>Improved image link function in the Advanced Tabs module<\\/li>\\n<li>Improved Popup Maker to allow users to trigger popups using a keyboard<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.24.0 June 7th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added full WPML compatibility<\\/li>\\n<li>Fixed not working autoplay speed in the Hover Gallery module<\\/li>\\n<li>Fixed Image Magnifier rendering issue in Divi Builder<\\/li>\\n<li>Fixed the preloader displayed on the blog page when only the homepage setting is enabled<\\/li>\\n<li>Fixed Timeline module displaying issue on front-end of CPT<\\/li>\\n<li>Fixed Timeline responsive issue in Theme Builder<\\/li>\\n<li>Fixed Testimonial Slider avatar issue for WooCommerce reviews<\\/li>\\n<li>Fixed not working Filterable Grid image animation<\\/li>\\n<li>Fixed Advanced Tabs scroll to content on mobiles issue<\\/li>\\n<li>Fixed Advanced Tabs sticky tabs with slider navigation issue<\\/li>\\n<li>Fixed truncated caption in the Filterable Gallery lightbox when an apostrophe is used<\\/li>\\n<li>Added link option for the content image in the Advanced Tabs module<\\/li>\\n<li>Added Image Slider lightbox option for main carousel images<\\/li>\\n<li>Added icon spacing settings to the Tilt Image module<\\/li>\\n<li>Added vertical scroll functionality to the Image Showcase module<\\/li>\\n<li>Added simple FadeIn animation to the Hover Gallery module<\\/li>\\n<li>Added \\u201cMenu Order\\u201d into Filterable Grid Order By settings<\\/li>\\n<li>Disabled popups displaying in the builder<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.23.1 May 23rd, 2023<\\/strong><\\/p>\\n<ul>\\n<li>Fixed conditional fields issue in the Gravity Forms Styler module<\\/li>\\n<li>Fixed Gravity Forms Styler files loaded when the module is hidden<\\/li>\\n<li>Fixed the z-index of the meta box in the Popup Maker user interface<\\/li>\\n<li>Fixed the wrapping text issue in the last tab in the Content Slider module<\\/li>\\n<li>Fixed Content Slider reloading when Advanced Tabs is used on the same page<\\/li>\\n<li>Fixed Popup Maker issue causing broken website styles on the front-end<\\/li>\\n<li>Added ID tag to FAQ module schema output<\\/li>\\n<li>Added Ajax feature to Gravity Forms Styler module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<br \\/>\\n<strong>2.23.0 May 18th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Gravity Forms Styler for Divi<\\/li>\\n<li>Fixed issue with the mouse pointer on archive pages when the popup Closing CSS Selector is empty<\\/li>\\n<li>Fixed Theme Customizer issue when the Divi Torque plugin is used<\\/li>\\n<li>Fixed Scroll Image not working in the Carousel module<\\/li>\\n<li>Fixed the select field in the Divi Pixel dashboard<\\/li>\\n<li>Fixed conflict with FluentCRM where the unsubscribe function didn\\u2019t work<\\/li>\\n<li>Fixed Content Slider Move by Pin not working on mobiles<\\/li>\\n<li>Fixed Filterable Grid broken image issue when the featured image is not set and image overlay used<\\/li>\\n<li>Fixed Filterable Grid cursor pointer issue when using post link without lightbox option enabled<\\/li>\\n<li>Fixed conflict with the FluentCRM plugin<\\/li>\\n<li>Fixed the Horizontal Timeline issue when used in the Advanced Tabs module<\\/li>\\n<li>Fixed Balloon module background issue<\\/li>\\n<li>Fixed Horizontal Timeline icons displaying issue<\\/li>\\n<li>Fixed Image Mask custom SVG mask not displayed on the front-end on a specific server<\\/li>\\n<li>Fixed Footer Stick to the Bottom not working on tablets and mobiles<\\/li>\\n<li>Fixed Testimonial Slider Read More function not working with non-latin contents<\\/li>\\n<li>Fixed Advanced Tabs Content Vertical Align option not working correctly<\\/li>\\n<li>Added Content Image width settings to the Advanced Tabs module<\\/li>\\n<li>Improved Blog Style 5 layout on tablets<\\/li>\\n<li>Improved Filterable Grid content length when excerpt text is empty<\\/li>\\n<li>Improved Force Footer to the Bottom feature<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.22.0 April 18th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Content Slider module added<\\/li>\\n<li>Added z-index setting in the Balloon module<\\/li>\\n<li>Added z-index setting for the Image Hotspot tooltip<\\/li>\\n<li>Added option to fix anchor link offset issue when Fixed Mobile Header is used<\\/li>\\n<li>Added Quora social media network<\\/li>\\n<li>Added Lazyload images to Filterable Grid and Filterable Gallery modules<\\/li>\\n<li>Added Post Offset setting to the Blog Slider module<\\/li>\\n<li>Fixed Pricing Table not working spacing setting when used in Theme Builder<\\/li>\\n<li>Fixed the issue with adding a new module below the Image Slider<\\/li>\\n<li>Fixed Popup Maker not triggering from the mobile menu item<\\/li>\\n<li>Improved the Filterable Grid performance<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.21.1 March 29th, 2023<\\/strong><\\/p>\\n<ul>\\n<li>Fixed duplicated mobile menu hamburger icon issue<\\/li>\\n<li>Fixed mobile menu hamburger icon animation issue<\\/li>\\n<li>Fixed space added when the reveal footer effect is used<\\/li>\\n<li>Fixed Filled Background menu hover effect styles issues<\\/li>\\n<li>Fixed dropdown menu item animation and styling issues<\\/li>\\n<li>Fixed mobile menu CTA button text color issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.21.0 March 28th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Hover Gallery module added<\\/li>\\n<li>Fixed Filterable Grid link target not working properly<\\/li>\\n<li>Fixed heading level issue in Filterable Grid and Filterable Gallery modules<\\/li>\\n<li>Fixed issue with the Author Box sizing<\\/li>\\n<li>Fixed Info Circle issue when button and content links are used at the same time<\\/li>\\n<li>Fixed an issue with the responsive icon selector in the Timeline module<\\/li>\\n<li>Fixed Carousel not displaying when the max-width property is used in the child module<\\/li>\\n<li>Fixed Timeline Font Awesome icons not displayed<\\/li>\\n<li>Fixed PHP warning when the option to display popup on specific pages is enabled, but pages not defined<\\/li>\\n<li>Added sticky filter bar options to Filterable Grid and Filterable Gallery modules<\\/li>\\n<li>Added Post Status option to the Filterable Grid module<\\/li>\\n<li>Added option to display raw HTML in the Filterable Grid module<\\/li>\\n<li>Added displaying order options to the Filterable Grid module<\\/li>\\n<li>Added pagination translation settings for the Filterable Gallery and Filterable Grid<\\/li>\\n<li>Added option to show title and caption in the Carousel image lightbox<\\/li>\\n<li>Added options to display animation in the viewport and only once in the Fancy Text module<\\/li>\\n<li>Added hooks to the Blog Slider module<\\/li>\\n<li>Improved Popup Maker CSS when the Video module is used<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.20.1 March 1st, 2023<\\/strong><\\/p>\\n<ul>\\n<li>New features added to the Before &amp; After Slider<\\/li>\\n<li>Added tooltip animation speed to the Image Hotspot module<\\/li>\\n<li>Fixed Filterable Grid duplicated taxonomy issue<\\/li>\\n<li>Fixed post quick edit not saving due to Divi Pixel taxonomy<\\/li>\\n<li>Fixed Advanced Tabs duplicated content on hover issue<\\/li>\\n<li>Fixed Advanced Tabs\\/Timeline module compatibility<\\/li>\\n<li>Fixed console error in Timeline module when Divi Builder is used<\\/li>\\n<li>Fixed Popup Maker console error when CSS selector is not used<\\/li>\\n<li>Fixed Carousel Autoplay option not working after navigation is used<\\/li>\\n<li>Fixed not working CTA Menu button text color on hover<\\/li>\\n<li>Fixed Balloon conflict with 3rd party mega menu plugin<\\/li>\\n<li>Fixed Popup Maker compatibility issue with Envira Gallery Lite plugin<\\/li>\\n<li>Removed title from the custom preloader<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.20 February 22nd, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Filterable Grid module added<\\/li>\\n<li>Fixed issue with Image Hotspot video still playing after the tooltip is closed<\\/li>\\n<li>Fixed issue with rendering custom fields in builder in Timeline modules<\\/li>\\n<li>Fixed not working Blog Slider in the Balloon module<\\/li>\\n<li>Fixed not working Horizontal Timeline when used in the Accordion module<\\/li>\\n<li>Fixed the not working active icon in the Timeline module<\\/li>\\n<li>Fixed Pricing Table justify text option<\\/li>\\n<li>Fixed Button Grid issue when only icon is used<\\/li>\\n<li>Fixed Menu CTA Button text color not working on hover<\\/li>\\n<li>Fixed Image Hotspot icon size responsive settings issue<\\/li>\\n<li>Fixed MailChimp submit button not working in the Balloon module<\\/li>\\n<li>Fixed FAQ module title markup issue visible in SEO tools<\\/li>\\n<li>Added icon padding settings to the Image Hotspot module<\\/li>\\n<li>Added icon padding settings to the Timeline module<\\/li>\\n<li>Added responsive settings for the Carousel Autoplay function<\\/li>\\n<li>Improved the tab selector in the Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.19.1 January 13th, 2023<\\/strong><\\/p>\\n<ul>\\n<li>Added option to make the FAQ module entries searchable<\\/li>\\n<li>Fixed PHP error in filetype hook<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.19 January 12th, 2023<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Parallax Image module<\\/li>\\n<li>Added hover settings for the close button in the Testimonial Slider popup<\\/li>\\n<li>Fixed not working border radius for filled background menu effect<\\/li>\\n<li>Fixed Carousel image lightbox issue when the option is disabled<\\/li>\\n<li>Fixed not working Carousel module link when the Carousel image is clicked<\\/li>\\n<li>Fixed not working module link in Divi Library items (except Balloon module)<\\/li>\\n<li>Fixed Timeline module customization issue when the Divi Builder plugin is used<\\/li>\\n<li>Fixed Media Library image link not showing when Hide All Modules is enabled<\\/li>\\n<li>Fixed issue with Image Slider used in Advanced Tabs module<\\/li>\\n<li>Fixed Masonry Gallery image border not working on frontend<\\/li>\\n<li>Fixed Hover Box dynamic button link issue<\\/li>\\n<li>Fixed Horizontal Timeline displaying issues when the mixed layout is used<\\/li>\\n<li>Fixed Masonry Gallery displaying issue when used in the Advanced Tabs module<\\/li>\\n<li>Fixed custom font upload not working when Divi Pixel is activated<\\/li>\\n<li>Fixed Popup Maker issue not opening popup from the mobile menu button<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.18.1 December 14th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 2nd CTA button added to Expanding CTA module<\\/li>\\n<li><strong>NEW:<\\/strong> Added Custom CSS ID &amp; Classes to Horizontal Timeline child modules<\\/li>\\n<li><strong>NEW:<\\/strong> Added Scroll To Content responsive settings in the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Hide popup slug in URL option added<\\/li>\\n<li>Fixed Sticky Tabs not working in the Advanced Tabs module when tabs were added on the left or right<\\/li>\\n<li>Fixed Horizontal Timeline not rendering in Divi Builder when used in the Content Toggle module<\\/li>\\n<li>Fixed Timeline icon issue when the icon is not selected<\\/li>\\n<li>Fixed PHP warnings in the Divi Pixel setting panel (Modules)<\\/li>\\n<li>Fixed the not working button in Carousel when Coverflow effect is used (Firefox browser)<\\/li>\\n<li>Fixed not working Popup Maker closing button<\\/li>\\n<li>Fixed Popup Maker Close on Overlay Click issue<\\/li>\\n<li>Fixed video issue still playing after the popup is closed<\\/li>\\n<li>Fixed Menu module not displaying in the footer when the reveal effect is enabled<\\/li>\\n<li>Fixed PHP warnings in the Carousel module<\\/li>\\n<li>Fixed PHP warnings in the Blog Slider module<\\/li>\\n<li>Fixed Custom Mask\\/Dynamic Content issue in the Image Mask module<\\/li>\\n<li>Fixed the Divi Counter module issue affected by the Divi Pixel plugin<\\/li>\\n<li>Fixed Balloon styling issue when used in footer or header<\\/li>\\n<li>Fixed Content Toggle - header level for front page and builder<\\/li>\\n<li>Fixed SVG Animator not working when iTheme Security plugin is used<\\/li>\\n<li>Fixed Star Rating PHP warning with PHP 8<\\/li>\\n<li>Improved \\u201cHide All Modules\\u201d option in Divi Pixel settings<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.18 November 17th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Layout Importer<\\/li>\\n<li><strong>NEW:<\\/strong> Reveal the Before &amp; After Slider image after the label is clicked<\\/li>\\n<li><strong>NEW:<\\/strong> Added CPT support and Post Status to Blog Slider module<\\/li>\\n<li><strong>NEW:<\\/strong> Added dynamic field to Scroll Image module<\\/li>\\n<li><strong>NEW:<\\/strong> \\u201cHide All Modules\\u201d option added<\\/li>\\n<li>Fixed Advanced Tabs issue where content is not displayed in the builder<\\/li>\\n<li>Fixed Popup position issue on category pages<\\/li>\\n<li>Fixed popup periodicity function not working<\\/li>\\n<li>Fixed Contact Form success message not displayed in the Popup Maker<\\/li>\\n<li>Fixed the Carousel issue when used in the Balloon module<\\/li>\\n<li>Fixed header white gap when resizing the browser<\\/li>\\n<li>Fixed Hover Box PHP notice<\\/li>\\n<li>Fixed Image Showcase displaying link cursor when the link is not added<\\/li>\\n<li>Improved spacing settings for the Fancy Text animated text<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.17 October 26th, 2022<\\/strong><\\/p>\\n<ul>\\n<li>NEW: Filterable Gallery for Divi<\\/li>\\n<li>Fixed Menu CTA Button placement issue in the Safari browser<\\/li>\\n<li>Added Carousel navigation responsive settings<\\/li>\\n<li>Fixed Floating Images animation in Safari browser<\\/li>\\n<li>Fixed Blurb icon placement issue caused by the Advanced Tabs responsive icon settings<\\/li>\\n<li>Fixed duplicated content showing on hover in the Advanced Tabs module<\\/li>\\n<li>Fixed Advanced Tabs not showing inside the Balloon module<\\/li>\\n<li>Fixed hamburger mobile menu animation when multiple menus are used<\\/li>\\n<li>Fixed duplicated mobile menu displayed on CPT pages<\\/li>\\n<li>Fixed the Panorama module not working with the LatePoint plugin<\\/li>\\n<li>Fixed Popup Maker page search functionality<\\/li>\\n<li>Added Line social network<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.16.1 September 14th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added continuous slide animation to the Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Added option to make website elements clickable when the popup is opened<\\/li>\\n<li><strong>NEW:<\\/strong> Added Horizontal Timeline active line position setting<\\/li>\\n<li><strong>NEW:<\\/strong> Added responsive tab icon\\/image placement settings to the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Added list customization settings to the Advanced Tabs module<\\/li>\\n<li><strong>NEW:<\\/strong> Added Typing Text start animation in viewport<\\/li>\\n<li><strong>NEW:<\\/strong> Added responsive image count option to the Masonry Gallery module<\\/li>\\n<li><strong>NEW:<\\/strong> Added option to use custom images for Timeline line<\\/li>\\n<li>Fixed Expanding CTA button dynamic link issue<\\/li>\\n<li>Fixed Popup Maker Guest user role not saving<\\/li>\\n<li>Fixed Popup video still playing when the popup is closed<\\/li>\\n<li>Fixed Pricing Table module is still available in the Divi Builder when the module is hidden<\\/li>\\n<li>Fixed Masonry Gallery rendering issue when used in the Advanced Tabs module<\\/li>\\n<li>Fixed testimonial length not working with the Chinese language<\\/li>\\n<li>Fixed Image Showcase rendering issues in Safari and Firefox browsers<\\/li>\\n<li>Fixed Horizontal Timeline SVG image not showing<\\/li>\\n<li>Fixed Advanced Tabs default tab issue<\\/li>\\n<li>Fixed Advanced Tabs duplicated tab icons when Theme Builder for product template is used<\\/li>\\n<li>Fixed Carousel equal height issue<\\/li>\\n<li>Fixed Carousel Module duplicated box shadow, borders, padding, and margins in the builder<\\/li>\\n<li>Fixed Carousel Image hover effect transition<\\/li>\\n<li>Fixed FAQ module title alignment not working<\\/li>\\n<li>Fixed Expanding CTA responsive font size settings not working<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.16 July 27th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Pricing Table module<\\/li>\\n<li><strong>NEW:<\\/strong> Advanced Tabs activate on hover option added<\\/li>\\n<li>Improved Divi Builder plugin and Extra Theme support<\\/li>\\n<li>Improved hamburger script and placed it in external JS file so it can be excluded from Delayed JavaScript Execution<\\/li>\\n<li>Fixed Advanced Tabs content width issue on tablets and mobiles<\\/li>\\n<li>Fixed Popup Maker On Load issue in front-end builder<\\/li>\\n<li>Fixed Popup Maker saving issue<\\/li>\\n<li>Fixed customization functionality when the Divi Builder plugin is used<\\/li>\\n<li>Fixed a bug that caused Divi Pixel to not add the Theme Customizer settings<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.15.1 July 9th, 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Image Slider Loop option not working<\\/li>\\n<li>Fixed not working Custom Map Marker<\\/li>\\n<li>Fixed nonce_check in Popup Maker<\\/li>\\n<li>Fixed et_pb_get_specific_default_font function error<\\/li>\\n<li>Improved Breadcrumbs schema markup<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.15.0 - July 6th, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Tile Scroll module<\\/li>\\n<li>Added option to activate\\/deactivate popups from the Popup Maker CPT dashboard<\\/li>\\n<li>Added option to close popup when browser back button is clicked<\\/li>\\n<li>Added Triggering column to the Popup Maker CPT screen<\\/li>\\n<li>Added z-index control for the Popup Maker overlay<\\/li>\\n<li>Added quick preview option to Popup Maker<\\/li>\\n<li>Added support for the Divi Ghoster plugin<\\/li>\\n<li>Added Horizontal Order Direction to the Masonry Gallery module<\\/li>\\n<li>Added responsive mockup images to the Image Showcase module<\\/li>\\n<li>Fixed FAQ module collapsed icon alignment issue<\\/li>\\n<li>Fixed Info Circle dynamic button link issue<\\/li>\\n<li>Fixed Image Hotspot responsive tooltip displaying issue<\\/li>\\n<li>Fixed dynamic button link in Advanced Tabs and Info Circle modules<\\/li>\\n<li>Fixed SVG Animator triggers animation during customizing other modules<\\/li>\\n<li>Fixed not working responsive Fullwidth Tabs option in the Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.14.0 - June 22nd, 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Popup Maker for Divi<\\/li>\\n<li>Added title H tag control to FAQ module<\\/li>\\n<li>Fixed Horizontal Timeline image\\/icon position responsive settings<\\/li>\\n<li>Fixed Horizontal Timeline navigation not working on mobiles<\\/li>\\n<li>Fixed Collapsed Mobile Menu icon issue for the closed menu<\\/li>\\n<li>Fixed duplicated Google testimonials added during fetching<\\/li>\\n<li>Fixed Back To Top Button icon issue when circle double arrow icon is selected<\\/li>\\n<li>Fixed Masonry Gallery manual order issue<\\/li>\\n<li>Fixed not working Advanced Tabs tab image alignment<\\/li>\\n<li>Fixed Advanced Tabs content area margin issue<\\/li>\\n<li>Fixed Expanding CTA overlay height issue on Android mobiles<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.13.0 - June 8th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added Text Highlighter module<\\/li>\\n<li>Added option to select the active tab on load in the Advanced Tabs module<\\/li>\\n<li>Added ordering settings to the Masonry Gallery module<\\/li>\\n<li>Fixed particles background issue when the parallax option is enabled<\\/li>\\n<li>Fixed Theme Customizer toggles not displaying the correct value<\\/li>\\n<li>Fixed button icons not working when the Dynamic CSS is enabled<\\/li>\\n<li>Fixed Carousel button link dynamic option<\\/li>\\n<li>Fixed collapsed submenu not working when Theme Builder Menu module used<\\/li>\\n<li>Fixed Timeline animations not working in Firefox and Safari browsers<\\/li>\\n<li>Fixed not loading Divi Pixel font when the user is logged in<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.12.0 - May 26th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Particles Background effect<\\/li>\\n<li>Fixed Hotspot Image unwanted square element displayed below module when Lazy Load is used<\\/li>\\n<li>Added animation settings to child modules in the Timeline module<\\/li>\\n<li>Added Image Slider heading customization settings for H tags placed in the description<\\/li>\\n<li>Updated PHP 8 depreciated functions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.11.0 - May 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Expanding CTA module<\\/li>\\n<li>Fixed Advanced Tabs button target issue<\\/li>\\n<li>Fixed Image Gallery navigation issue when used in Advanced Tabs module<\\/li>\\n<li>Fixed Carousel description HTML markup displayed when not used<\\/li>\\n<li>Fixed Carousel image box-shadow issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.10 - May 9th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Maintenance Mode feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Allow TTF, OTF and WOFF file uploads<\\/li>\\n<li>Fixed Image Slider issue when used in Advanced Tabs module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.9 - May 5th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong>\\u00a0Horizontal Timeline module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added option to add overlay image for Scroll Image module and set reveal effect<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added Animate in Viewport and Delay options to the Lottie Icon module<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Added reverse direction animation for autorotate option in Info Circle module<\\/li>\\n<li>Improved JavaScript for Balloon module to address issues when used in Theme Builder<\\/li>\\n<li>Added Telegram social media icon<\\/li>\\n<li>Added link customization settings to FAQ module<\\/li>\\n<li>Added Carousel image\\/icon hover option<\\/li>\\n<li>Fixed Floating Images animations not working in Safari and iOS 15.4.1<\\/li>\\n<li>Fixed Fancy Text prefix goes out of the screen issue<\\/li>\\n<li>Fixed Dual Heading background text displayed in Divi Builder when not used<\\/li>\\n<li>Fixed Advanced Tabs Divi Library item width issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.8 - April 25th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Advanced Tabs module<\\/li>\\n<li>Fixed Image Slider custom thumbnails not displayed on front-end<\\/li>\\n<li>Fixed Image Slider title formatting and HTML tag displayed on front-end<\\/li>\\n<li>Fixed Image Hotspot mobile issue<\\/li>\\n<li>Fixed Image Hotspot box shadow and border-radius issue<\\/li>\\n<li>Fixed Hover Box and Flip Box gradient migration issue<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.2 - April 13th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Author Box and Menu CTA Button font issue<\\/li>\\n<li>Fixed Panorama video controls not working in Safari browser<\\/li>\\n<li>Fixed Panorama default height value not working<\\/li>\\n<li>Fixed Image Slider custom navigation not displayed on the frontend<\\/li>\\n<li>Fixed Divi Pixel settings import issue<\\/li>\\n<li>Fixed Masonry Gallery icon border not working<\\/li>\\n<li>Fixed Dual Heading background animation issue<\\/li>\\n<li>Fixed module link not working in Balloon module<\\/li>\\n<li>Fixed dropdown link background color not working with Theme Builder header<\\/li>\\n<li>Added multi-select field for CTA menu button<\\/li>\\n<li>Added gradient migration for new gradient builder to retain old values<\\/li>\\n<li>Added dynamic images and content to Before &amp; After Slider module<\\/li>\\n<li>Added dynamic content fields to the Grid Button module<\\/li>\\n<li>Added dynamic labels to the Content Toggle module<\\/li>\\n<li>Added dynamic prefix and suffix fields to the Counter module<\\/li>\\n<li>Added dynamic heading content to the Dual Heading module<\\/li>\\n<li>Added dynamic fields for prefix and suffix in Fancy Text module<\\/li>\\n<li>Added dynamic image and image link fields to the Floating Images module<\\/li>\\n<li>Added dynamic image and content fields to Accordion Image module<\\/li>\\n<li>Added dynamic images and content fields to the Image Hotspot module<\\/li>\\n<li>Added dynamic images and content fields to the Balloon module<\\/li>\\n<li>Added dynamic images and content fields to the Carousel module<\\/li>\\n<li>Added dynamic images and content fields to the Flip Box module<\\/li>\\n<li>Added dynamic images and content fields to the Hover Box module<\\/li>\\n<li>Added dynamic images fields to the Image Magnifier module<\\/li>\\n<li>Added dynamic images fields to the Image Mask module<\\/li>\\n<li>Added dynamic images fields to the Image Showcase module<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7.1 - April 6th 2022<\\/strong><\\/p>\\n<ul>\\n<li>Added Projects category and tag slug options<\\/li>\\n<li>Added CSS ID &amp; Classes fields to Image Accordion child items<\\/li>\\n<li>Added Half Circle option to the Counter module<\\/li>\\n<li>Added new gradient support to Divi Pixel modules<\\/li>\\n<li>Added image placeholder to Tilt Image module<\\/li>\\n<li>Fixed Circle Info Button margin not working<\\/li>\\n<li>Fixed Circle Info icon height issue<\\/li>\\n<li>Fixed Circle Info content switch on mobiles not working<\\/li>\\n<li>Fixed Circle Info icons not displayed in Firefox\\/Safari when icon animation is enabled<\\/li>\\n<li>Fixed Facebook and Google API code causing an error on cron<\\/li>\\n<li>Fixed Panorama responsive height issue<\\/li>\\n<li>Fixed Carousel, Content Toggle &amp; Balloon fatal errors sent to the email after WP autosave is triggered<\\/li>\\n<li>Fixed Carousel pagination responsive settings issue<\\/li>\\n<li>Fixed Carousel arrow navigation not working on mobile devices<\\/li>\\n<li>Fixed Masonry Gallery circle icon issue in builder<\\/li>\\n<li>Fixed Image Hotspot spacing issue in Firefox\\/Safari browsers<\\/li>\\n<li>Updated cron timing frequency for license check (twice daily)<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.7 February 23rd 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Info Circle module added<\\/li>\\n<li>Updated Google social media icon<\\/li>\\n<li>Updated Snapchat and TikTok SVG images creating an error<\\/li>\\n<li>Updated Image Hotspot position value step to 0.1<\\/li>\\n<li>Updated hotspot icon line height causing hotspot icon to be not perfectly centred<\\/li>\\n<li>Improved Scroll Image horizontal mouse scroll performance<\\/li>\\n<li>Improved preloader performance<\\/li>\\n<li>Fixed Tilt Image glare effect<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Panorama rendering issues in Divi Builder when the video is used<\\/li>\\n<li>Fixed Panorama height not working when the video is used<\\/li>\\n<li>Fixed Flip Box back button padding not working<\\/li>\\n<li>Fixed Dual Heading module bottom margin and padding not working<\\/li>\\n<li>Fixed Dual Heading text background clipping for the 2nd text not working<\\/li>\\n<li>Fixed Carousel image border radius when box-shadow added not applying properly<\\/li>\\n<li>Fixed custom blog layout style not applying when Theme Builder template is used<\\/li>\\n<li>Fixed Image Slider Divi Library shortcodes not rendering<\\/li>\\n<li>Fixed dropdown arrow displayed on child submenus<\\/li>\\n<li>Fixed Search icon position when CTA Button not used<\\/li>\\n<li>Added support for PHP 8<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6.1 January 19th 2022<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Added language settings for Google testimonials<\\/li>\\n<li><strong>NEW:<\\/strong> Added options to Exclude\\/Include Testimonials by Post ID<\\/li>\\n<li><strong>NEW:<\\/strong> Added 9 new animations to the Floating Images module<\\/li>\\n<li>Updated Floating Images position max and min values<\\/li>\\n<li>Fixed Floating Images transition CSS not working<\\/li>\\n<li>Fixed issue with Menu Hover Effect applies to the centred header logo<\\/li>\\n<li>Fixed Blog Slider random order not working<\\/li>\\n<li>Fixed not working link in Carousel child module<\\/li>\\n<li>Removed Carousel button wrapper HTML markup when the button is not used<\\/li>\\n<li>Added Soundcloud and TikTok icons to Social Media settings<\\/li>\\n<li>Added CSS ID &amp; Classes field to the Image Hotspot child module<\\/li>\\n<li>Added dynamic image support for Image Slider module (front-end only)<\\/li>\\n<li>Fixed JS error after searching when post meta section is empty<\\/li>\\n<li>Fixed Image Slider text displayed on sides when 3D Cube mode is used<\\/li>\\n<li>Fixed SVG Animator default width and height not working in Safari browser<\\/li>\\n<li>Fixed SVG Animator not working when allow_url_fopen is disabled on the server<\\/li>\\n<li>Fixed Tilt Image flickering issue in Chrome browser<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.6 December 8th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> SVG Animator module added<\\/li>\\n<li>Image Slider thumbnails height various units support added<\\/li>\\n<li>Blog Slider backward PHP (&lt;7.2) compatibility issue fixed<\\/li>\\n<li>custom styles did not apply on paginated blog pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.3 November 26th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\" data-border-radius-top-cap=\\\"false\\\" data-border-radius-bottom-cap=\\\"false\\\">\\n<li><strong>NEW:<\\/strong> Image Accordion Always Visible new settings for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Showcase individual images links feature added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider featured image animation effects added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel image animation settings added<\\/li>\\n<li><strong>NEW:<\\/strong> All Divi Pixel modules support new Divi icons<\\/li>\\n<li>Carousel new custom CSS for active slide added<\\/li>\\n<li>Blog Slider navigation responsive settings added<\\/li>\\n<li>Blog Slider featured image border and box-shadow customization settings added<\\/li>\\n<li>Blog Slider new Custom CSS fields for navigation and active slide added<\\/li>\\n<li>Blog Slider pagination not working in builder when multiple instances used issue fixed<\\/li>\\n<li>Content Toggle new Custom CSS fields for toggle button added<\\/li>\\n<li>Image Mask shape 7 not displayed properly on front end issue fixed<\\/li>\\n<li>Masonry Gallery Grid Items border not working issue fixed<\\/li>\\n<li>Accordion module not triggered in Carousel module issue fixed<\\/li>\\n<li>Dropdown menu text color not working on fixed header issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5.2 October 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> 28 new masks added to the Image Mask module<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask selector field improved<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask: option to rotate, scale and flip the mask<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask image Alt Text field added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask upload custom shape option added<\\/li>\\n<li>Image Mask placeholder image added<\\/li>\\n<li>Image Showcase module URL issue fixed<\\/li>\\n<li>Carousel Autoplay stops working when the Pause on Hover option is disabled issue fixed<\\/li>\\n<li>Carousel item doesn\\u2019t take full width when short content is added issue fixed<\\/li>\\n<li>Countdown Timer doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Counter module doesn\\u2019t work in builder issue fixed<\\/li>\\n<li>Image Magnifier module doesn\\u2019t work in builder issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1 September 30th 2021<\\/strong><\\/p>\\n<ul>\\n<li>FAQ module categories missed issue fixed<\\/li>\\n<li>Custom preloader not working issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.5 September 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Dual Heading module added<\\/li>\\n<li>Mobile Menu on WooCommerce pages issues fixed<\\/li>\\n<li>Blog archive custom style not applying for pagination pages issue fixed<\\/li>\\n<li>Image Hotspot tooltip displaying when border radius on the image is used issue fixed<\\/li>\\n<li>Image Hotspot tooltip image default width not applying in the builder issue fixed<\\/li>\\n<li>Image Hotspot new Ripple Effect style added<\\/li>\\n<li>Image Hotspot default image placeholder added<\\/li>\\n<li>Image Hotspot tooltip spacing in builder issue fixed<\\/li>\\n<li>Improved backwards compatibility with outdated PHP versions<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4.2 - September 5th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider thumbnails margin controls added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider responsive settings for Image Overlay added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Slider custom thumbnail option added<\\/li>\\n<li><strong>NEW:<\\/strong> Blog Slider custom CSS field for content added<\\/li>\\n<li><strong>NEW:<\\/strong> Slide Image responsive position control added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay hover settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery Image Overlay responsive settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Price List - Price Prefix and Suffix fields added<\\/li>\\n<li><strong>NEW:<\\/strong> Masonry Gallery image animation options added<\\/li>\\n<li>Custom Map Marker being cropped issue fixed<\\/li>\\n<li>Hover Box double arrow icon issue fixed<\\/li>\\n<li>Testimonial Slider Random order issue fixed<\\/li>\\n<li>Image Showcase in hidden section causing JS error issue fixed<\\/li>\\n<li>Blog Slider active pagination color issue fixed<\\/li>\\n<li>Blog Slider Content custom CSS field added<\\/li>\\n<li>dipi-anim-preload class not removed from the body after the page is loaded issue fixed<\\/li>\\n<li>Image Showcase causing JS error when the module is hidden issue fixed<\\/li>\\n<li>CTA Menu Button text color when Menu module is used issue fixed<\\/li>\\n<li style=\\\"list-style-type: none;\\\"><\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.4.1 August 23rd 2021<\\/strong><\\/p>\\n<p>Divi 4.10+ compatibility<\\/p>\\n<ul>\\n<li>Carousel lightbox functionality issue fixed<\\/li>\\n<li>Masonry Gallery layout grid and lightbox issue fixed<\\/li>\\n<li>Preloader, when Defer jQuery and jQuery Migrate option is enabled issue fixed<\\/li>\\n<li>Image Slider when Defer jQuery and jQuery migrate option is enabled issue fixed<\\/li>\\n<li>Counter module when Dynamic JS Libraries option enabled issue fixed<\\/li>\\n<li>Price List module when Dynamic JS Libraries enabled lightbox issue fixed<\\/li>\\n<li>Testimonial Slider popup when Dynamic JS Libraries enabled issue fixed<\\/li>\\n<li>Conditional Display when Dynamic Module Framework enabled issue fixed<\\/li>\\n<\\/ul>\\n<p>Improvements\\/Fixes<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"false\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\"><strong>NEW:<\\/strong> Image Slider Autoplay settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Archive page Style 2 - broken layout on category pages issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.4 August 18th 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Slider module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Hotspot responsive positioning settings added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Open Carousel image in lightbox option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Reverse Carousel slide direction when Autoplay option is enabled<\\/li>\\n<li><strong>NEW:<\\/strong> Price List image lightbox gallery option added<\\/li>\\n<li><strong>NEW:<\\/strong>\\u00a0Masonry Gallery image link option added<\\/li>\\n<li>Carousel item Box Shadow on hover issue fixed<\\/li>\\n<li>Sidebar customization issues fixed<\\/li>\\n<li>Testimonial Slider heading customization settings added<\\/li>\\n<li>Carousel reloading in builder issue fixed<\\/li>\\n<li>Price List responsive settings for the layout and image added<\\/li>\\n<li>Price List module Box Shadow option to the parent module added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.3.2 July 28th 2021<\\/strong><\\/p>\\n<ul>\\n<li>Related Article hover activation issue fixed<\\/li>\\n<li>Footer social icons when credits are disabled issue fixed<\\/li>\\n<li>Menu CTA button - menu selection issue fixed<\\/li>\\n<li>Image Hotspot - tooltip button when Trigger on Click is enabled issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>2.3.1 July 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Menu CTA Button - option for selecting menu added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Showcase - 11 new mockups added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box text line-height default values fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs alignment responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Divi Builder plugin &amp; Extra theme compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Exclude Posts option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive Featured Image border-radius option added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p>2.3 July 7th 2021<\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> FAQ module with Google Structured Data added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider - category class added for single post box<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.5 June 30th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added new Section, Row and Module settings to conditionally display content based on users role or a login status<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Suppress Filters option is added to use the attempted filter by other 3rd party plugins (like WPML)<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mobile Menu Hamburger icon browser compatibility improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline card width when the icon is used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module PHP 7.2 compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Rename Projects tab category slug issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.4 June 18th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">duplicated logo when multiple Theme Builder headers are used issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.3 June 16th 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> apply blog archive style to the native Divi Blog module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> select image size for the Blog Slider module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Divi Library Shortcodes to use in any module<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Option to hide \\u201cEdit in Visual Builder\\u201d link on pages\\/posts overview dashboard pages<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial Read More popup font customization settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider \\u201cOrder By\\u201d settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - hide tooltip option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot - link field to the hotspot child added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot isn\\u2019t interactive anymore issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Hotspot mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider HTML markup displayed for disabled elements issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Accordion TinyMCE editor support added for the description field<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image responsive scroll speed settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Panorama 2D Image mode scroll issue on tablets and mobiles fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider responsive settings for navigation size and padding added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider - testimonials order settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More link disabled when a full testimonial is displayed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Mega Menu width issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Read More Button Text\\u201d doesn\\u2019t apply to the native Divi Blog module issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d doesn\\u2019t apply to the Theme Builder custom header issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">\\u201cChange Logo on Scroll\\u201d performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Collapsed mobile top menu not clickable issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module visibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module displaying on archive pages issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs separator alignment issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Lottie Icon width not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Content Toggle\\/Masonry Gallery compatibility issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Full-width post does not display full-width sections in frontend Divi Builder issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.2 April 21st 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: open tooltip on click<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Hotspot: tooltip animations added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Carousel - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Testimonial slider - display navigation on hover option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel navigation hover settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon module margin in Divi Builder modules list issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Ballon button link target issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">plugin settings modules list updated<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider HTML support for review text added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image content animations improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon Tiny MCE editor for description field added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Balloon button shadow not applying in builder properly issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider not working with Blog module when testimonial CPT is selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Breadcrumbs module fetches taxonomy from pages where taxonomy is not added issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline line border styles issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial custom CSS for Profile Image selector fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.1 April 2nd, 2021<\\/strong><\\/p>\\n<ul>\\n<li>plugin updater issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.2.0 April 1st, 2021<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Ballon module added<\\/li>\\n<li>Blog Slider item not clickable in Firefox browser issue fixed<\\/li>\\n<li>Content Toggle et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li>Content Toggle and Image Showcase compatibility improved<\\/li>\\n<li>Testimonial Slider popup\\/Divi Machine conflict issue fixed<\\/li>\\n<li>API licensing UI and functionality improved<\\/li>\\n<li>Documentation pages UI improved<\\/li>\\n<\\/ul>\\n<p><strong>2.1.2 March 8th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\">Content Toggle issue with dipi_label function issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery et_builder_i18 function replaced with esc_html__ function to support older Divi versions<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Timeline module dipi_label function replaced with esc_html__ function<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.1 March 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Disable LazyLoad in Content Toggle module settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup performance improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Enable Lightbox responsive settings issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Plugin Settings\\/Modules options updated<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.1.0 - February 25th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Content Toggle module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Blog Archive section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Post Navigation section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Author Box section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Related Articles section background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery Disable Lightbox responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Archive background settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d in Firefox displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box \\u201cForce module to be a Square\\u201d ON\\/OFF builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box circle icon issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box WPML support improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image\\/Icon alignment in Timeline not working in Divi Builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel Autoplay option doesn\\u2019t work in Safari issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel items displayed vertically in Safari 8 issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel child item hover icon not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Button Grid on mobiles improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Floating Images Transform settings not working issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box height controls improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box solid border issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase rendering with WP Rocket Lazy Loading in different browsers issues fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Scroll Image mouse scrolling improved<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n2.0.1 - February 5th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW: <\\/strong>Masonry Gallery Coverflow Animations<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Masonry Gallery - disable image lightbox option added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box jQuery variable naming issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">CSS error preventing Divi scripts from compile issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text child module link issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion image responsive settings improved<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image Active On Load and Open On Click issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Accordion Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">fonts in Theme Customizer did not enqueue issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>2.0.0 - January 26th, 2021<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Timeline module added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Added CSS ID &amp; Classes to Button Grid child modules<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> WhatsApp, Snapchat and Xing social media icons added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Active Image size responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\"><strong>NEW:<\\/strong> Image Accordion Opened on Load responsive settings added<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Performance improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Mask SVG markup issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Image Showcase - image positioning tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Primary Header Social Icons positioning when CTA Button is not used issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Masonry Gallery image width causing the problem with the proper displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider Button displaying multiple icons when icon not selected issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default content-length value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Blog Slider default spacing value tweaked<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Error messages when Google reviews are fetched corrected<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hover Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Flip Box module rendering with \\u201cForce Module to be a square\\u201d option enabled - issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image mobile displaying issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot Image arrow color rendering in builder issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Hotspot module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Author Box name improvements<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Fancy Text alignment settings revised<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup displaying mixed testimonials issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Testimonial Slider Read More popup image styling issue fixed<\\/li>\\n<li data-stringify-indent=\\\"0\\\">Carousel module when Divi Library item is used, Divi Builder rendering issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.3 - December 16th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>collapsed mobile menu close animation fixed<\\/li>\\n<li>dropdown menu width max value increased<\\/li>\\n<li>Hamburger Mobile Menu not displayed after WP 5.6 issue fixed<\\/li>\\n<li>minor code improvements in Panorama and Lottie modules<\\/li>\\n<li>Carousel Coverflow mode - disabled slide shadow issue fixed<\\/li>\\n<li>Duplicated Social Icons in Primary Header issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.2 - December 7th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Breadcrumbs active item styles missed on front-end issue fixed<\\/li>\\n<li>Dropdown menu item width control added<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.10.1 - December 5th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Carousel spacing issue fixed<\\/li>\\n<li>plugin package\\/2 new modules Divi Builder rendering issues fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.10.0 - December 4th, 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Showcase module added<\\/li>\\n<li><strong>NEW:<\\/strong> Image Mask module added<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS Class field added to the header CTA button<\\/li>\\n<li><strong>NEW:<\\/strong> Divi Builder support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Extra theme support for modules added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Post Type\\/Taxonomy settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Breadcrumbs module Alignment settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Dynamic button URL to Grid Button module added<\\/li>\\n<li><strong>NEW:<\\/strong> Carousel module CSS ID &amp; Classes added to child items<\\/li>\\n<li>Vertical Navigation style issues fixed<\\/li>\\n<li>Testimonial Slider overflow issue fixed<\\/li>\\n<li>Mobile Menu animation out when Theme Builder header used issue fixed<\\/li>\\n<li>Blog Archive responsive breakpoint updated<\\/li>\\n<li>Hotspot tooltip height on mobiles issue fixed<\\/li>\\n<li>Blog Slider body text and button box-shadow issues fixed<\\/li>\\n<li>Admin Label field added to the Carousel child modules<\\/li>\\n<li>Tooltip image wrapper if image not selected - HTML markup not displayed<\\/li>\\n<li>Post meta alignment on archive page issue fixed<\\/li>\\n<li>Tilt Image mobile height issue fixed<\\/li>\\n<li>Footer Reveal Effect visibility in the front-end builder issue fixed<\\/li>\\n<li>Hide Admin Bar setting issue fixed<\\/li>\\n<li>Hide Admin Bar\\/Hide Top Header\\/Reading Progress Bar issues fixed<\\/li>\\n<li>Breadcrumbs Schema Markup issue fixed<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n<p><strong>1.9 - 14 October 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Mobile Submenu customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Collapsed Mobile menu icon customization settings added<\\/li>\\n<li><strong>NEW:<\\/strong> Circle animation for Mobile Menu background overlay added<\\/li>\\n<li>Menu Dropdown visibility with Theme Builder Header and Footer Reveal Effect enabled issue fixed<\\/li>\\n<li>default Mobile Menu animation performance issue fixed<\\/li>\\n<li>Centered Inline Logo header alignment fixed<\\/li>\\n<li>Centered header hamburger icon position fixed<\\/li>\\n<li>Stand and Spring style Hamburger icon animation issues fixed<\\/li>\\n<li>Fixed Mobile Menu container gap issue on mobiles fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.2 - 28th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>NEW: Add Arrow to Dropdown Menus<\\/li>\\n<li>NEW: Dropdown Menu width and position controls added<\\/li>\\n<li>NEW: Open Menu Button Link in a New Window option added<\\/li>\\n<li>Header Height\\/Spacing issues fixed<\\/li>\\n<li>Hide Top Bar feature improved<\\/li>\\n<li>Do Not Shrink Header on Scroll feature improved<\\/li>\\n<li>Social Icons in Secondary Menu Firefox issue fixed<\\/li>\\n<li>CTA Menu Button Position First\\/Last issue fixed<\\/li>\\n<li>Centered\\/Centered Inline header style issues fixed<\\/li>\\n<li>Top Bar performance on mobiles improved<\\/li>\\n<li>Mobile Menu paddings issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.8.1 - 15th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Fixed duplicated hamburger icons when more than one menu was used on a page<\\/li>\\n<li>Do Not Shrink Header functionality improved<\\/li>\\n<\\/ul>\\n<p><strong>1.8 - 13th September 2020<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Image Magnifier module<\\/li>\\n<li><strong>NEW:<\\/strong> Lottie Icon module<\\/li>\\n<li>Plugin Settings page responsive issues fixed<\\/li>\\n<li>Plugin Settings Page Toolbar added<\\/li>\\n<li>Hide Admin Bar when user not logged in issue fixed<\\/li>\\n<li>Archive Page Header Injector issue fixed<\\/li>\\n<li>Bottom Bar customization issues fixed<\\/li>\\n<li>Back To Top custom link issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.7.1 - 28th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed Panorama module PHP error for older PHP versions<\\/li>\\n<\\/ul>\\n<p><strong>1.7 - 27th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Panorama module<\\/li>\\n<li><strong>NEW:<\\/strong> Reading Progress Bar module<\\/li>\\n<li><strong>NEW:<\\/strong> Google icon to Social Icons added<\\/li>\\n<li>SVG image upload feature improved<\\/li>\\n<li>Force Footer to Bottom when Theme Builder used issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.6.2 - 20th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed an issue with social icons individual locations<\\/li>\\n<li>Fixed an issue with the revealing footer effect<\\/li>\\n<\\/ul>\\n<p><strong>1.6.1 - 15th August 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue in Divi Pixel options panel (WordPress 5.5 compatibility)<\\/li>\\n<li>Fixed an issue where individual social icon locations would break the menus<\\/li>\\n<\\/ul>\\n<p><strong>1.6.0 - 12th August 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Scrollable Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt text field added for Hover Box images<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Carousel module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Accordion Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Custom CSS fields added to Accordion Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Tilt Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Hotspot Image module<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List configurable HTML title tag option added<\\/li>\\n<li><strong>NEW:<\\/strong> Alt Image text field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Label field added to Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> Fixed responsive flex settings for Button Grid and added options for alignment and justification<\\/li>\\n<li><strong>NEW:<\\/strong> Login Page custom logo URL option added<\\/li>\\n<li><strong>NEW:<\\/strong> option to add links to images in Floating Images module<\\/li>\\n<li><strong>NEW:<\\/strong> SVG image preview in Media Library added<\\/li>\\n<li>Tilt Image title customization issue fixed<\\/li>\\n<li>fixed issue with Theme Customizer scripts not loading on FlyWheel hosted sites<\\/li>\\n<li>Hover Box displaying empty heading tags issue fixed<\\/li>\\n<li>duplicated Prefix and Suffix spans in Typing Text module issue fixed<\\/li>\\n<li>Login Page logo size default values fixed<\\/li>\\n<li>Added option to Masonry Gallery to enable lazy loading images compatibility<\\/li>\\n<li>Automatically scroll to the top of the Divi Pixel options page after switching tabs<\\/li>\\n<li>Fixed Masonry Gallery not opening images in a lightbox<\\/li>\\n<li>Accordion Image responsive spacing issue fixed<\\/li>\\n<li>Carousel box-shadow and border child module issue fixed<\\/li>\\n<li>Carousel module left navigation positioning issue in builder fixed<\\/li>\\n<li>Flip Box content displaying issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.5.0 - 8th May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Accordion Module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box: added option to force the module to be a square<\\/li>\\n<li>Fixed \\\"open in new window\\\" option in various modules<\\/li>\\n<li>Improved SVG upload functionality to allow different mime types<\\/li>\\n<li>Fixed Related Articles and Author Box when Theme Builder is used<\\/li>\\n<li>Fixed Blog Slider default columns on tablet and mobiles<\\/li>\\n<li>Fixed \\\"Related Articles\\\" heading, which was sometimes displayed on custom post types<\\/li>\\n<li>Fixed Flex Direction responsive options in Typing Text module<\\/li>\\n<li>Fixed Image Hotspot heading level option in Visual Builder<\\/li>\\n<li>Fixed various typos<\\/li>\\n<li>Added some semicolons here and there to spice up the code (and fix some issues)<\\/li>\\n<\\/ul>\\n<p><strong>1.4.4 - 31st May 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Flip Box Dynamic Height option added<\\/li>\\n<li><strong>NEW:<\\/strong> Flip Box: force module to be a square option added<\\/li>\\n<li>Flip Box Image Overlay builder issue fixed<\\/li>\\n<li>Flip Box icon not displayed on front-end issue fixed<\\/li>\\n<li>Primary Menu customization when Menu Hover Animation disabled issue fixed<\\/li>\\n<li>Masonry Gallery: IE browser issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.3 - 27th May 2020<\\/strong><\\/p>\\n<ul>\\n<li>Flip Box: height issue fixed<\\/li>\\n<li>Flip Box: Back Button not displayed on front-end issue fixed<\\/li>\\n<li>Flip Box: 3D Content Effect issue fixed<\\/li>\\n<\\/ul>\\n<p><strong>1.4.2 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Flip Box module: Dynamic Height option removed<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.1 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li>Plugin Settings\\/Modules section updated<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.4.0 - 23rd May 2020<br \\/>\\n<\\/strong><\\/p>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\">\\n<li><strong>NEW:<\\/strong> Fancy Text module added<\\/li>\\n<li>Breadcrumbs Module: responsive padding options added<\\/li>\\n<li>Breadcrumbs: separator icon issue fixed<\\/li>\\n<li>Back To Top Button: box-shadow issue on hover fixed<\\/li>\\n<li>Back To Top Button: custom link issue fixed<\\/li>\\n<li>Menu CTA Button: hover text\\/background issue fixed<\\/li>\\n<li>Secondary Header menu\\/social icons positioning issue fixed<\\/li>\\n<li>Button Grid: icon size and positioning fixed<\\/li>\\n<li>Blog Archive: meta text icons positioning fixed<\\/li>\\n<li>Blog Slider image clickable option added<\\/li>\\n<li>Blog Slider: responsive image height option added<\\/li>\\n<li>Mobile Menu: Theme Builder header issues fixed<\\/li>\\n<li>Custom Mobile Breakpoint: all menu customization settings revised and improved<\\/li>\\n<li>Login Page: form field text size option added<\\/li>\\n<li>Login Page: logo size issue fixed, logo height option added<\\/li>\\n<li>Related Articles: section title font size issue fixed<\\/li>\\n<li>Testimonial Slider: read more popup size on mobiles issue fixed<\\/li>\\n<li>Header Menu: customization setting improved<\\/li>\\n<li>Hover Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Hover Box: module not displayed in Builder\\/Firefox issue fixed<\\/li>\\n<li>Hover Box: responsive height fixed<\\/li>\\n<li>Flip Box: icon, title, description, button wrappers removed if element not added<\\/li>\\n<li>Image Hotspot, Hover Box, Flip Box, Carousel, Tilt Image: configurable HTML title tag option added<\\/li>\\n<\\/ul>\\n<p><strong><br \\/>\\n1.3.1 - 26th April 2020<\\/strong><\\/p>\\n<ul>\\n<li>Fixed a bunch of smaller bugs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.0 - 20th April 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Blog Slider module<\\/li>\\n<li><strong>NEW<\\/strong>: Animation Delay option in Counter module<\\/li>\\n<li><strong>NEW:<\\/strong> Option to enable beta downloads<\\/li>\\n<li>Mobile Menu issue fixed<\\/li>\\n<li>Header\\/Menu Animation issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0 - 26th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Countdown module<\\/li>\\n<li><strong>NEW:<\\/strong> Hover Box module<\\/li>\\n<li>Force Footer to Bottom Firefox issue fixed<\\/li>\\n<li>Filled Background menu animation style Firefox issue fixed<\\/li>\\n<li>Various under the hood improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0 - 16th March 2020<\\/strong><\\/p>\\n<ul>\\n<li><strong>NEW:<\\/strong> Image Hotspot module<\\/li>\\n<li><strong>NEW:<\\/strong> Price List module<\\/li>\\n<li><strong>NEW:<\\/strong> Export\\/Import functionality added to the Divi Pixel options panel<\\/li>\\n<li>Back to top button functionality improved<\\/li>\\n<li>Testimonial Slider mobile issues fixed<\\/li>\\n<li>Testimonial Slider Website URL field added<\\/li>\\n<li>The improved license activation process<\\/li>\\n<li>Licensing API Library updated<\\/li>\\n<\\/ul>\\n<p><strong>1.0.0 - 4th March 2020<\\/strong><\\/p>\\n<ul>\\n<li>Initial Release<\\/li>\\n<\\/ul>\\n\"],\"plugin\":\"divi-pixel\\/divi-pixel.php\",\"id\":\"divi-pixel\\/divi-pixel.php\",\"tested\":null}\";}", "no");
INSERT INTO `z8ei5_options` VALUES("7776", "rocket_cache_dir_size_check", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("13217", "wpseo_sitemap_author_cache_validator", "56FxL", "no");
INSERT INTO `z8ei5_options` VALUES("13505", "et_pb_contact_form_ba8fd3a1679cbfc9c5ba55f5131e7fee", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("13698", "et_pb_contact_form_c26421cbbfb680741fe1bd8068ac17de", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("13764", "et_pb_contact_form_a715748eb23cd48e374ecde36b602a59", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("13858", "et_pb_contact_form_83082d469745f808403dbb7ad351508d", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("13885", "et_pb_contact_form_2e3ce2eedf3e12d43760a5cef7d27638", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("14022", "et_divi_builder_global_presets_ng", "O:8:\"stdClass\":0:{}", "no");
INSERT INTO `z8ei5_options` VALUES("14266", "et_pb_contact_form_e4342ff399608720c21b870ad0d80d18", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("14309", "autoupdate_warning_complete_dismiss", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("14364", "fm_key", "j9UXFIdg65W1OCGEvDRnLhVJP", "yes");
INSERT INTO `z8ei5_options` VALUES("14373", "filemanager_email_verified_4", "yes", "yes");
INSERT INTO `z8ei5_options` VALUES("14421", "rocket_analytics_notice_displayed", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("16279", "et_pb_contact_form_8e663280329736f0a9b4f0c4d0a14c86", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("17274", "duplicate_post_show_notice", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("17275", "duplicate_post_copytitle", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("17276", "duplicate_post_copydate", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17277", "duplicate_post_copystatus", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17278", "duplicate_post_copyslug", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17279", "duplicate_post_copyexcerpt", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("17280", "duplicate_post_copycontent", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("17281", "duplicate_post_copythumbnail", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("17282", "duplicate_post_copytemplate", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("17283", "duplicate_post_copyformat", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("17284", "duplicate_post_copyauthor", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17285", "duplicate_post_copypassword", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17286", "duplicate_post_copyattachments", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17287", "duplicate_post_copychildren", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17288", "duplicate_post_copycomments", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17289", "duplicate_post_copymenuorder", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("17290", "duplicate_post_taxonomies_blacklist", "a:0:{}", "yes");
INSERT INTO `z8ei5_options` VALUES("17291", "duplicate_post_blacklist", "", "yes");
INSERT INTO `z8ei5_options` VALUES("17292", "duplicate_post_types_enabled", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("17293", "duplicate_post_show_original_column", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17294", "duplicate_post_show_original_in_post_states", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17295", "duplicate_post_show_original_meta_box", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("17296", "duplicate_post_show_link", "a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("17297", "duplicate_post_show_link_in", "a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("17298", "duplicate_post_version", "4.5", "yes");
INSERT INTO `z8ei5_options` VALUES("17549", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `z8ei5_options` VALUES("17812", "et_hosting_card_dismissed", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("20056", "wp_rocket_no_licence", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("21599", "updraft_lock_aios_message_store_lock_rule_active", "0", "no");
INSERT INTO `z8ei5_options` VALUES("21600", "updraft_lock_aios_message_store_lock_rule_not_active", "0", "no");
INSERT INTO `z8ei5_options` VALUES("21601", "updraft_lock_aios_message_store_lock_rule_triggered", "0", "no");
INSERT INTO `z8ei5_options` VALUES("21602", "updraft_lock_aios_message_store_lock_rule_not_triggered", "0", "no");
INSERT INTO `z8ei5_options` VALUES("22538", "wp_rocket_last_base_url", "aHR0cDovL3RzLWZvcm1hdGlvbi5mci8=", "yes");
INSERT INTO `z8ei5_options` VALUES("22597", "duplicator_version_plugin", "1.5.8", "yes");
INSERT INTO `z8ei5_options` VALUES("22599", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("22600", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("22608", "duplicator_notifications", "a:4:{s:6:\"update\";i:1705272735;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `z8ei5_options` VALUES("22616", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("22619", "duplicator_migration_data", "{\n    \"time\": 1695039598,\n    \"installType\": -1,\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/tsformb\\/www\\/20230906_turneyskillformation_7392724af1cbf1c97802_20230906123410_archive.zip\",\n    \"packageHash\": \"7392724-06123410\",\n    \"installerPath\": \"\\/home\\/tsformb\\/www\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/tsformb\\/www\\/dup-installer-bootlog__2a624aa-06123410.txt\",\n    \"installerLog\": \"\\/home\\/tsformb\\/www\\/dup-installer\\/dup-installer-log__2a624aa-06123410.txt\",\n    \"dupInstallerPath\": \"\\/home\\/tsformb\\/www\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/tsformb\\/www\\/dup-installer\\/original_files_7392724-06123410\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true\n}", "no");
INSERT INTO `z8ei5_options` VALUES("22643", "_transient_health-check-site-status-result", "{\"good\":15,\"recommended\":6,\"critical\":1}", "yes");
INSERT INTO `z8ei5_options` VALUES("22883", "new_admin_email", "jamila@j-boost.fr", "yes");
INSERT INTO `z8ei5_options` VALUES("22889", "_transient_et_updated_plugins_data", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1705273266;}", "yes");
INSERT INTO `z8ei5_options` VALUES("22931", "rsssl_show_onboarding", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("22936", "rsssl_options", "a:4:{s:12:\"site_has_ssl\";s:1:\"1\";s:8:\"redirect\";s:11:\"wp_redirect\";s:19:\"mixed_content_fixer\";i:1;s:11:\"ssl_enabled\";s:1:\"1\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("22941", "rsssl_current_version", "7.2.1", "no");
INSERT INTO `z8ei5_options` VALUES("22951", "rsssl_6_notice_dismissed", "1", "no");
INSERT INTO `z8ei5_options` VALUES("22956", "rsssl_wp_version_detected", "found", "no");
INSERT INTO `z8ei5_options` VALUES("22964", "rsssl_port_check_2082", "fail", "no");
INSERT INTO `z8ei5_options` VALUES("22965", "rsssl_port_check_8443", "fail", "no");
INSERT INTO `z8ei5_options` VALUES("22966", "rsssl_port_check_2222", "fail", "no");
INSERT INTO `z8ei5_options` VALUES("23047", "rsssl_last_tested_http_method", "3", "no");
INSERT INTO `z8ei5_options` VALUES("23048", "rsssl_http_methods_allowed", "a:2:{s:11:\"not-allowed\";a:1:{i:0;s:3:\"GET\";}s:7:\"allowed\";a:3:{i:0;s:4:\"POST\";i:1;s:3:\"PUT\";i:2;s:6:\"DELETE\";}}", "no");
INSERT INTO `z8ei5_options` VALUES("23051", "rsssl_ssl_detection_overridden", "1", "no");
INSERT INTO `z8ei5_options` VALUES("23056", "rsssl_activation_timestamp", "1695657734", "no");
INSERT INTO `z8ei5_options` VALUES("23060", "https_migration_required", "", "yes");
INSERT INTO `z8ei5_options` VALUES("23075", "aiowps_temp_configs", "a:106:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:0:\"\";s:28:\"aiowps_allow_unlock_requests\";s:1:\"1\";s:25:\"aiowps_max_login_attempts\";s:1:\"3\";s:24:\"aiowps_retry_time_period\";s:1:\"5\";s:26:\"aiowps_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:35:\"n.ait@siconsulting-certification.fr\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"kbzckoom29rum87rl1dk\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"uhirkipysle617sitg8w\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:0:\"\";s:26:\"aiowps_db_backup_frequency\";s:1:\"4\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:26:\"aiowps_backup_files_stored\";s:1:\"2\";s:32:\"aiowps_send_backup_email_address\";s:0:\"\";s:27:\"aiowps_backup_email_address\";s:35:\"n.ait@siconsulting-certification.fr\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:0:\"\";s:27:\"aiowps_max_file_upload_size\";s:2:\"10\";s:31:\"aiowps_enable_pingback_firewall\";s:1:\"0\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:1:\"0\";s:29:\"aiowps_deny_bad_query_strings\";s:1:\"0\";s:34:\"aiowps_advanced_char_string_filter\";s:1:\"0\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:35:\"n.ait@siconsulting-certification.fr\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:36:\"aiowps_enable_php_backtrace_in_email\";s:0:\"\";s:30:\"aiowps_max_lockout_time_length\";s:2:\"60\";s:35:\"aiowps_disable_application_password\";s:1:\"1\";s:33:\"aiowps_enable_trash_spam_comments\";s:0:\"\";s:37:\"aiowps_trash_spam_comments_after_days\";s:2:\"14\";s:36:\"aiowps_on_uninstall_delete_db_tables\";s:1:\"1\";s:34:\"aiowps_on_uninstall_delete_configs\";s:1:\"1\";s:12:\"installed-at\";i:1665068452;s:25:\"aiowps_ip_retrieve_method\";i:0;s:22:\"aiowps_default_captcha\";s:0:\"\";s:33:\"aiowps_disable_rss_and_atom_feeds\";s:0:\"\";s:25:\"aiowps_turnstile_site_key\";s:0:\"\";s:27:\"aiowps_turnstile_secret_key\";s:0:\"\";s:31:\"aiowps_enable_spambot_detecting\";s:0:\"\";s:27:\"aiowps_spam_comments_should\";s:0:\"\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("23246", "wps_notifs_ajax", "4", "yes");
INSERT INTO `z8ei5_options` VALUES("24178", "wps_limit_login_lockouts", "a:1:{s:15:\"188.166.178.164\";i:1702762253;}", "yes");
INSERT INTO `z8ei5_options` VALUES("24179", "wps_limit_login_logged", "a:5:{s:14:\"172.233.24.103\";a:1:{s:6:\"jboost\";a:3:{s:7:\"counter\";i:1;s:4:\"date\";i:1698352288;s:7:\"gateway\";s:6:\"XMLRPC\";}}s:14:\"209.97.163.116\";a:1:{s:6:\"jboost\";a:3:{s:7:\"counter\";i:1;s:4:\"date\";i:1700708703;s:7:\"gateway\";s:6:\"XMLRPC\";}}s:12:\"20.46.180.25\";a:1:{s:6:\"jboost\";a:3:{s:7:\"counter\";i:1;s:4:\"date\";i:1701163493;s:7:\"gateway\";s:6:\"XMLRPC\";}}s:13:\"20.171.66.187\";a:1:{s:6:\"jboost\";a:3:{s:7:\"counter\";i:1;s:4:\"date\";i:1702280891;s:7:\"gateway\";s:6:\"XMLRPC\";}}s:15:\"188.166.178.164\";a:1:{s:6:\"jboost\";a:3:{s:7:\"counter\";i:1;s:4:\"date\";i:1702761053;s:7:\"gateway\";s:6:\"XMLRPC\";}}}", "yes");
INSERT INTO `z8ei5_options` VALUES("24180", "wps_limit_lockouts_total", "5", "no");
INSERT INTO `z8ei5_options` VALUES("24693", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `z8ei5_options` VALUES("25861", "can_compress_scripts", "0", "yes");
INSERT INTO `z8ei5_options` VALUES("25877", "duplicator_settings", "a:21:{s:7:\"version\";s:5:\"1.5.8\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:0;s:12:\"last_updated\";s:19:\"2024-01-14-23-02-39\";s:18:\"package_ui_created\";s:1:\"1\";}", "yes");
INSERT INTO `z8ei5_options` VALUES("25878", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"o;o6AzaAOJ62fVI+5bISLjFd_sHbVXwf4,N5y_t5d0f4\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 318.27,\n    \"siteNumFiles\": 10712,\n    \"siteDbSizeMB\": 9.88,\n    \"siteDbNumTables\": 35\n}", "yes");
INSERT INTO `z8ei5_options` VALUES("25879", "rsssl_previous_version", "7.2.0", "no");
INSERT INTO `z8ei5_options` VALUES("26173", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "yes");
INSERT INTO `z8ei5_options` VALUES("26304", "et_pb_contact_form_e962acac3c8feef0f16e7504aa235db2", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("26305", "et_pb_contact_form_91ca05b10b970bd0c62f30b4e50ff9e1", "off", "yes");
INSERT INTO `z8ei5_options` VALUES("27001", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.4.2.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.4.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.4.2\";s:7:\"version\";s:5:\"6.4.2\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1705273328;s:15:\"version_checked\";s:5:\"6.4.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `z8ei5_options` VALUES("27082", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1705626431", "no");
INSERT INTO `z8ei5_options` VALUES("27083", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `z8ei5_options` VALUES("27084", "_transient_timeout_rsssl_can_use_curl_headers_check", "1705626432", "no");
INSERT INTO `z8ei5_options` VALUES("27085", "_transient_rsssl_can_use_curl_headers_check", "a:7:{i:0;s:25:\"Upgrade Insecure Requests\";i:1;s:16:\"X-XSS protection\";i:2;s:22:\"X-Content Type Options\";i:3;s:15:\"Referrer-Policy\";i:4;s:15:\"X-Frame-Options\";i:5;s:18:\"Permissions-Policy\";i:6;s:30:\"HTTP Strict Transport Security\";}", "no");
INSERT INTO `z8ei5_options` VALUES("27150", "_transient_timeout_et_check_mod_pagespeed", "1705278843", "no");
INSERT INTO `z8ei5_options` VALUES("27151", "_transient_et_check_mod_pagespeed", "", "no");
INSERT INTO `z8ei5_options` VALUES("27178", "_transient_timeout__et_builder_gf_feature_cache", "1705335017", "no");
INSERT INTO `z8ei5_options` VALUES("27179", "_transient__et_builder_gf_feature_cache", "1", "no");
INSERT INTO `z8ei5_options` VALUES("27185", "_site_transient_timeout_available_translations", "1705283531", "no");
INSERT INTO `z8ei5_options` VALUES("27186", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-25 17:57:08\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-10-19 09:22:30\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-08 05:10:14\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.24/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-09 09:13:37\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-09 17:49:56\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-08 16:31:26\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-08 09:13:09\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-03 10:36:13\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-07 09:53:23\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-29 21:13:08\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-08 18:40:48\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.4.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-08 18:40:24\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-06 19:57:18\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.4.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-06 19:56:58\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.3/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-10 19:54:48\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-08-28 15:58:51\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-24 12:26:36\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-27 22:57:29\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-10-22 02:53:03\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-25 14:09:36\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-09-20 08:57:43\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-08 20:42:04\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-20 03:52:48\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-03-14 22:16:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.8/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.8/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.14/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-28 10:19:25\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.19\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.19/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-30 13:46:36\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-10-05 10:16:58\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-12 17:31:37\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-06 04:38:22\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-05 21:16:24\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-09 09:46:35\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-29 13:35:45\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-09 16:09:28\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.3/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-02 23:37:18\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-08-09 07:20:47\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.31\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.31/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-05-28 22:06:16\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-31 11:28:03\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-03 21:54:15\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.3/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-24 18:28:12\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-05 15:44:59\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.24/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-02 20:36:49\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-27 06:05:50\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.24/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.1.4\";s:7:\"updated\";s:19:\"2023-11-25 09:35:18\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.4/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.3/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.24/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.19\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.19/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.4\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.4/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-10-19 07:05:28\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-06 14:39:42\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-21 15:26:43\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.2/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.1.4\";s:7:\"updated\";s:19:\"2022-11-24 03:51:58\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.4/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-20 21:57:20\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-14 15:04:06\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-10-05 01:27:19\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.24/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.13\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.13/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.36\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.36/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-28 16:54:57\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-22 16:02:51\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-21 10:48:27\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-10-14 13:34:08\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.4.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-11 15:25:39\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-06 21:08:33\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.32\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.32/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-08-21 12:17:05\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-07 09:12:03\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.4.2/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-07 09:07:54\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-08 00:25:54\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-04 07:42:03\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-02 16:10:47\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.14/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-22 08:45:57\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-12 10:29:16\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-12 13:29:48\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-13 18:56:56\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-05 20:51:57\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-20 00:53:50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.16\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.16/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.36\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.36/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.8/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.23/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-06 00:04:30\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-11 17:50:19\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2024-01-14 12:08:20\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.2/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.14/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-07-15 15:30:50\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-12-07 00:00:04\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-23 09:22:54\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `z8ei5_options` VALUES("27187", "_transient_timeout_rsssl_testpage", "1705359135", "no");
INSERT INTO `z8ei5_options` VALUES("27188", "_transient_rsssl_testpage", "<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <META NAME=\"ROBOTS\" CONTENT=\"NOINDEX, NOFOLLOW\">\n</head>\n<body>\n<h1>#SSL TEST PAGE#</h1>\n<p>This page is used purely to test for SSL availability.</p>\n#SERVER-HTTPS-ON# (on)<br>#SERVERPORT443#<br>#ENVHTTPS#<br>#LOADBALANCER#<br><br>#SUCCESSFULLY DETECTED SSL#\n</body>\n</html>\n", "no");
INSERT INTO `z8ei5_options` VALUES("27189", "_transient_timeout_rsssl_admin_users", "1705276335", "no");
INSERT INTO `z8ei5_options` VALUES("27190", "_transient_rsssl_admin_users", "a:3:{i:0;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:1:\"6\";s:10:\"user_login\";s:6:\"Claire\";s:9:\"user_pass\";s:34:\"$P$BINlexb.FvhJ7HlskvuWdC9qLLeOGK0\";s:13:\"user_nicename\";s:6:\"claire\";s:10:\"user_email\";s:22:\"claire@ts-formation.fr\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2023-09-25 16:05:36\";s:19:\"user_activation_key\";s:45:\"1695925571:$P$Bwxo1oMHMmCcIKZhKvNeCZWIGvtM3l/\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:6:\"Claire\";}s:2:\"ID\";i:6;s:4:\"caps\";a:1:{s:13:\"administrator\";b:1;}s:7:\"cap_key\";s:18:\"z8ei5_capabilities\";s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:7:\"allcaps\";a:81:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:10:\"copy_posts\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:15:\"manage_security\";b:1;s:13:\"administrator\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:1;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:1:\"2\";s:10:\"user_login\";s:6:\"Jboost\";s:9:\"user_pass\";s:34:\"$P$Ba5Tq38BNqDLuXCtP71iDGyLQuMAJQ.\";s:13:\"user_nicename\";s:6:\"jboost\";s:10:\"user_email\";s:17:\"jamila@j-boost.fr\";s:8:\"user_url\";s:22:\"http://ts-formation.fr\";s:15:\"user_registered\";s:19:\"2022-06-16 00:40:39\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:11:\"JboostAdmin\";}s:2:\"ID\";i:2;s:4:\"caps\";a:1:{s:13:\"administrator\";b:1;}s:7:\"cap_key\";s:18:\"z8ei5_capabilities\";s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:7:\"allcaps\";a:81:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:10:\"copy_posts\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:15:\"manage_security\";b:1;s:13:\"administrator\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}i:2;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:1:\"4\";s:10:\"user_login\";s:7:\"Vincent\";s:9:\"user_pass\";s:34:\"$P$B90uaGexpM2btAwTOZCQQsFaNtrj9d.\";s:13:\"user_nicename\";s:7:\"vincent\";s:10:\"user_email\";s:23:\"vincentcadeau@gmail.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2023-03-17 10:23:58\";s:19:\"user_activation_key\";s:45:\"1679048638:$P$BdmZUxrgyc08atQsvmaKdlqyViRGu40\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:7:\"Vincent\";}s:2:\"ID\";i:4;s:4:\"caps\";a:1:{s:13:\"administrator\";b:1;}s:7:\"cap_key\";s:18:\"z8ei5_capabilities\";s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:7:\"allcaps\";a:81:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:10:\"copy_posts\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:15:\"manage_security\";b:1;s:13:\"administrator\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}}", "no");
INSERT INTO `z8ei5_options` VALUES("27191", "_transient_timeout_rsssl_certinfo", "1705359135", "no");
INSERT INTO `z8ei5_options` VALUES("27192", "_transient_rsssl_certinfo", "a:16:{s:4:\"name\";s:23:\"/CN=www.ts-formation.fr\";s:7:\"subject\";a:1:{s:2:\"CN\";s:19:\"www.ts-formation.fr\";}s:4:\"hash\";s:8:\"5d6561f0\";s:6:\"issuer\";a:3:{s:1:\"C\";s:2:\"US\";s:1:\"O\";s:13:\"Let\'s Encrypt\";s:2:\"CN\";s:2:\"R3\";}s:7:\"version\";i:2;s:12:\"serialNumber\";s:38:\"0x0397BA91594B095A5B9AA2E61C701E32FE17\";s:15:\"serialNumberHex\";s:36:\"0397BA91594B095A5B9AA2E61C701E32FE17\";s:9:\"validFrom\";s:13:\"231211034928Z\";s:7:\"validTo\";s:13:\"240310034927Z\";s:16:\"validFrom_time_t\";i:1702266568;s:14:\"validTo_time_t\";i:1710042567;s:15:\"signatureTypeSN\";s:10:\"RSA-SHA256\";s:15:\"signatureTypeLN\";s:23:\"sha256WithRSAEncryption\";s:16:\"signatureTypeNID\";i:668;s:8:\"purposes\";a:9:{i:1;a:3:{i:0;b:1;i:1;b:0;i:2;s:9:\"sslclient\";}i:2;a:3:{i:0;b:1;i:1;b:0;i:2;s:9:\"sslserver\";}i:3;a:3:{i:0;b:1;i:1;b:0;i:2;s:11:\"nssslserver\";}i:4;a:3:{i:0;b:0;i:1;b:0;i:2;s:9:\"smimesign\";}i:5;a:3:{i:0;b:0;i:1;b:0;i:2;s:12:\"smimeencrypt\";}i:6;a:3:{i:0;b:0;i:1;b:0;i:2;s:7:\"crlsign\";}i:7;a:3:{i:0;b:1;i:1;b:1;i:2;s:3:\"any\";}i:8;a:3:{i:0;b:1;i:1;b:0;i:2;s:10:\"ocsphelper\";}i:9;a:3:{i:0;b:0;i:1;b:0;i:2;s:13:\"timestampsign\";}}s:10:\"extensions\";a:9:{s:8:\"keyUsage\";s:35:\"Digital Signature, Key Encipherment\";s:16:\"extendedKeyUsage\";s:60:\"TLS Web Server Authentication, TLS Web Client Authentication\";s:16:\"basicConstraints\";s:8:\"CA:FALSE\";s:20:\"subjectKeyIdentifier\";s:59:\"95:0C:04:C9:2A:E0:F1:A9:EC:7F:7D:F3:02:80:BC:F6:2C:26:DB:00\";s:22:\"authorityKeyIdentifier\";s:66:\"keyid:14:2E:B3:17:B7:58:56:CB:AE:50:09:40:E6:1F:AF:9D:8B:14:C2:C6\n\";s:19:\"authorityInfoAccess\";s:73:\"OCSP - URI:http://r3.o.lencr.org\nCA Issuers - URI:http://r3.i.lencr.org/\n\";s:14:\"subjectAltName\";s:44:\"DNS:ts-formation.fr, DNS:www.ts-formation.fr\";s:19:\"certificatePolicies\";s:23:\"Policy: 2.23.140.1.2.1\n\";s:15:\"ct_precert_scts\";s:1161:\"Signed Certificate Timestamp:\n    Version   : v1 (0x0)\n    Log ID    : 48:B0:E3:6B:DA:A6:47:34:0F:E5:6A:02:FA:9D:30:EB:\n                1C:52:01:CB:56:DD:2C:81:D9:BB:BF:AB:39:D8:84:73\n    Timestamp : Dec 11 04:49:28.757 2023 GMT\n    Extensions: none\n    Signature : ecdsa-with-SHA256\n                30:45:02:20:61:1B:F6:BF:40:18:7A:87:94:F9:B1:4D:\n                A6:3C:81:BC:69:4B:5E:81:C3:34:0C:16:A8:D9:C1:1A:\n                FA:EE:85:61:02:21:00:8F:17:E4:19:1C:EC:3F:58:E9:\n                2B:50:3D:47:E1:E6:24:DD:CE:BC:78:BD:4F:3C:85:2E:\n                4C:76:98:AC:1C:5B:1B\nSigned Certificate Timestamp:\n    Version   : v1 (0x0)\n    Log ID    : 3B:53:77:75:3E:2D:B9:80:4E:8B:30:5B:06:FE:40:3B:\n                67:D8:4F:C3:F4:C7:BD:00:0D:2D:72:6F:E1:FA:D4:17\n    Timestamp : Dec 11 04:49:28.756 2023 GMT\n    Extensions: none\n    Signature : ecdsa-with-SHA256\n                30:45:02:20:58:27:94:BF:C4:C8:2C:62:CD:15:70:F6:\n                6D:B4:33:29:FC:C8:AC:32:11:EE:88:C3:0E:B6:AE:5F:\n                17:E4:F4:E3:02:21:00:99:B4:A5:00:51:F5:14:D6:E1:\n                87:0D:C9:D6:B3:4A:54:16:F7:72:F6:1A:AA:A1:27:B1:\n                0E:C9:68:B4:11:BC:B6\";}}", "no");
INSERT INTO `z8ei5_options` VALUES("27193", "_transient_timeout_rsssl_mixed_content_fixer_detected", "1705273338", "no");
INSERT INTO `z8ei5_options` VALUES("27194", "_transient_rsssl_mixed_content_fixer_detected", "found", "no");
INSERT INTO `z8ei5_options` VALUES("27195", "_transient_timeout_rsssl_admin_user_count", "1705276338", "no");
INSERT INTO `z8ei5_options` VALUES("27196", "_transient_rsssl_admin_user_count", "0", "no");
INSERT INTO `z8ei5_options` VALUES("27197", "_transient_timeout_rsssl_code_execution_allowed_status", "1705359138", "no");
INSERT INTO `z8ei5_options` VALUES("27198", "_transient_rsssl_code_execution_allowed_status", "allowed", "no");
INSERT INTO `z8ei5_options` VALUES("27199", "rsssl_plusone_count", "3", "yes");
INSERT INTO `z8ei5_options` VALUES("27200", "_site_transient_timeout_browser_821789b99f9168330b06379c53813800", "1705877538", "no");
INSERT INTO `z8ei5_options` VALUES("27201", "_site_transient_browser_821789b99f9168330b06379c53813800", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"120.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `z8ei5_options` VALUES("27202", "rsssl_admin_notices", "empty", "yes");
INSERT INTO `z8ei5_options` VALUES("27203", "_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1705315941", "no");
INSERT INTO `z8ei5_options` VALUES("27204", "_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Blog | WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 14 Jan 2024 21:39:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.5-alpha-57274\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Blog | WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordCamp Europe – Turin – Juin 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://fr.wordpress.org/2023/12/26/wordcamp-europe-turin-juin-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Dec 2023 13:55:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"wceu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2952\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"Le prochain WordCamp Europe aura lieu du 13 au 15 juin à Turin en Italie. Nous vous invitons à vous y rendre pour rencontrer d’autres personnes des communautés européennes et vivre une expérience intéressante et enrichissante. D’ailleurs, vous pouvez y participer de plusieurs manières, en tant que&#160;: Et si vous gérez un meetup local et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5826:\"\n<p>Le prochain <strong>WordCamp Europe</strong> aura lieu du <strong>13 au 15 juin à Turin en Italie</strong>. Nous vous invitons à vous y rendre pour rencontrer d’autres personnes des communautés européennes et vivre une expérience intéressante et enrichissante.</p>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\"><div class=\"wp-block-group__inner-container\">\n<p>D’ailleurs, vous pouvez y participer de plusieurs manières, en tant que&nbsp;:</p>\n\n\n\n<ul>\n<li><a href=\"https://europe.wordcamp.org/2024/volunteers/call-for-volunteers/\">bénévole</a> (date limite de candidature : 28 février 2024)&nbsp;;</li>\n\n\n\n<li>ou <a href=\"https://europe.wordcamp.org/2024/sponsors/call-for-sponsors/\">sponsor</a>&nbsp;;</li>\n\n\n\n<li>ou <a href=\"https://europe.wordcamp.org/2024/media-partners/call-for-media-partners/\">partenaire de communication</a> (postulez jusqu’au 9 février 2024)&nbsp;;</li>\n\n\n\n<li>ou encore comme <a href=\"https://europe.wordcamp.org/2024/speakers/call-for-speakers/\">orateur ou oratrice</a> (soumettez vos sujets de conférences jusqu’au 15 janvier 2024).</li>\n</ul>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-2 is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/volunteers/call-for-volunteers/\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2966\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin.jpg 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/sponsors/call-for-sponsors/\"><img decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-1024x538.png\" alt=\"\" class=\"wp-image-2964\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-1024x538.png 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-300x158.png 300w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-768x403.png 768w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin.png 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/media-partners/call-for-media-partners/\"><img decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2963\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin.jpg 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/call-for-2025-host-city/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2967\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin.jpg 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://europe.wordcamp.org/2024/speakers/call-for-speakers/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2962\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin.jpg 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n</figure>\n\n\n\n<p>Et si vous gérez un meetup local et souhaitez proposer votre ville comme <a href=\"https://europe.wordcamp.org/2024/call-for-2025-host-city/\">prochaine ville hôte</a> pour le <strong>WordCamp Europe 2025</strong>, l’appel à candidature est ouvert jusqu’au 14 février 2024.</p>\n</div></div>\n\n\n\n<p>Concernant les conférences, <strong>l’équipe organisatrice souhaite recevoir une grande variété de candidatures</strong>, y compris de personnes issues de groupes habituellement sous-représentés, afin d’offrir aux participants un programme diversifié. Notez qu’un programme de mentorat est disponible pour les personnes sélectionnées qui le désirent. Donc n’hésitez pas à postuler&nbsp;!</p>\n\n\n\n<p>Au final, il vous suffit de choisir comment vous souhaitez participer à ce prochain WordCamp Europe via les liens proposés ci-dessus, et vous ne serez plus qu’à quelques clics de votre départ pour Turin ! Lancez-vous, vous ne le regretterez pas…</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Alerte au phishing usurpant l’identité de WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://fr.wordpress.org/2023/12/05/alerte-au-phishing-usurpant-lidentite-de-wordpress-org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Dec 2023 08:50:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Securité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2934\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:445:\"L&#8217;équipe de sécurité de WordPress a été notifiée d&#8217;une campagne de phishing (ou « hameçonnage ») usurpant l&#8217;identité de comptes officiels WordPress.org. Ces campagnes de phishing utilisent comme nom d&#8217;expéditeur « WordPress Team » ou « WordPress Security Team » et tentent de faire croire à l&#8217;existence d&#8217;une faille de sécurité dans le cœur du CMS, et renvoient vers un site [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6698:\"\n<p>L&rsquo;équipe de sécurité de WordPress a été notifiée d&rsquo;une campagne de <em><bdo lang=\"en\" dir=\"ltr\">phishing</bdo></em> (ou « hameçonnage ») usurpant l&rsquo;identité de comptes officiels WordPress.org.</p>\n\n\n\n<p>Ces campagnes de <bdo lang=\"en\" dir=\"ltr\"><em>phishing</em></bdo> utilisent comme nom d&rsquo;expéditeur « WordPress Team » ou « WordPress Security Team » et tentent de faire croire à l&rsquo;existence d&rsquo;une faille de sécurité dans le cœur du CMS, et renvoient vers un site ressemblant au répertoire d&rsquo;extensions WordPress.org, sur lequel se trouve une extension à télécharger permettant de corriger la faille de sécurité.</p>\n\n\n\n<p>Il s&rsquo;agit d&rsquo;une arnaque : l&rsquo;extension est une <em><bdo lang=\"en\" dir=\"ltr\">backdoor</bdo></em>, c&rsquo;est à dire qu&rsquo;elle installe une porte dérobée permettant à une personne malveillante de se créer un compte d&rsquo;administration sur votre site. </p>\n\n\n\n<p class=\"has-background\" style=\"background-color:#ffecb7\"><strong>L&rsquo;équipe de sécurité de WordPress n&rsquo;envoie jamais d&rsquo;<bdo lang=\"en\" dir=\"ltr\">e-mail</bdo> vous demandant d&rsquo;installer une extension ou un thème sur votre site, et ne vous demande jamais votre identifiant ni votre mot de passe.</strong></p>\n\n\n\n<p>Si vous recevez un <bdo lang=\"en\" dir=\"ltr\">e-mail</bdo> prétendant provenir de WordPress avec des instructions similaires à celles décrites ci-dessus, ne tenez pas compte de celui-ci et indiquez si possible à votre fournisseur <bdo lang=\"en\" dir=\"ltr\">e-mail</bdo> qu&rsquo;il s&rsquo;agit d&rsquo;une escroquerie.</p>\n\n\n\n<p>Les <bdo lang=\"en\" dir=\"ltr\">e-mails</bdo> officiels du projet WordPress présentent toujours les caractéristiques suivantes :</p>\n\n\n\n<ul>\n<li>ils proviennent d&rsquo;un domaine <code>@wordpress.org</code> ou <code>@wordpress.net</code></li>\n\n\n\n<li>ils indiquent la mention <em><bdo lang=\"en\" dir=\"ltr\">« Signed by: wordpress.org »</bdo></em> dans la section des détails de l&rsquo;<bdo lang=\"en\" dir=\"ltr\">e-mail</bdo></li>\n</ul>\n\n\n\n<p>L&rsquo;équipe de sécurité de WordPress ne communique qu&rsquo;aux endroits suivants :</p>\n\n\n\n<ul>\n<li>le blog <bdo lang=\"en\" dir=\"ltr\">« Making WordPress Secure »</bdo> situé sur l&rsquo;URL <a href=\"https://make.wordpress.org/security\">make.wordpress.org/security</a></li>\n\n\n\n<li>le site principal <bdo lang=\"en\" dir=\"ltr\">« WordPress News »</bdo> situé sur les URLs <a href=\"https://wordpress.org/news\">wordpress.org/news</a> ou <a href=\"https://fr.wordpress.org/news/\">fr.wordpress.org/news</a> (pour les actualités en français)</li>\n</ul>\n\n\n\n<p>L&rsquo;équipe de gestion des extensions WordPress ne communique jamais directement avec les personnes ayant installé une extension, mais peut envoyer des <bdo lang=\"en\" dir=\"ltr\">e-mails</bdo> aux propriétaires d&rsquo;extensions hébergées sur WordPress.org. Ces courriels sont toujours envoyés à partir de l&rsquo;adresse <code>plugins@wordpress.org</code> et sont signés, comme indiqué ci-dessus.</p>\n\n\n\n<p>Le dépôt officiel des extensions WordPress est situé à l&rsquo;adresse <code>wordpress.org/plugins</code> avec des versions internationalisées sur des sous-domaines pour chaque langue, tel que <code>fr.wordpress.org/plugins</code>. Un sous-domaine peut contenir un trait d&rsquo;union, mais un point apparaîtra toujours juste avant <code>wordpress.org</code>.</p>\n\n\n\n<p>WordPress étant le système de gestion de contenu le plus utilisé, ce type d&rsquo;escroquerie par hameçonnage se produit occasionnellement. Prenez garde lorsque vous recevez un <bdo lang=\"en\" dir=\"ltr\">e-mail</bdo> vous proposant d&rsquo;installer un thème ou une extension, ou vous renvoyant vers un formulaire de connexion ressemblant au site officiel, il s&rsquo;agit potentiellement d&rsquo;une arnaque.</p>\n\n\n\n<p>Quelques captures d&rsquo;une des campagnes de hameçonnage en cours de diffusion (cliquer sur les images pour les ouvrir dans un nouvel onglet) :</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2023/12/c3bff9f57ed91503.png\" target=\"_blank\" rel=\"noreferrer noopener\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"295\" src=\"https://fr.wordpress.org/files/2023/12/c3bff9f57ed91503-300x295.png\" alt=\"\" class=\"wp-image-2936\" srcset=\"https://fr.wordpress.org/files/2023/12/c3bff9f57ed91503-300x295.png 300w, https://fr.wordpress.org/files/2023/12/c3bff9f57ed91503.png 769w\" sizes=\"(max-width: 300px) 100vw, 300px\" /></a><figcaption class=\"wp-element-caption\">Capture d&rsquo;écran d&rsquo;un email d&rsquo;arnaque visant à vous renvoyer vers un faux répertoire d&rsquo;extensions WordPress.org. On remarquera que « WordPress » est écrit sans son « P » majuscule.</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2023/12/f2d09cf6f87d0af0.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"249\" src=\"https://fr.wordpress.org/files/2023/12/f2d09cf6f87d0af0-300x249.png\" alt=\"\" class=\"wp-image-2937\" srcset=\"https://fr.wordpress.org/files/2023/12/f2d09cf6f87d0af0-300x249.png 300w, https://fr.wordpress.org/files/2023/12/f2d09cf6f87d0af0-768x638.png 768w, https://fr.wordpress.org/files/2023/12/f2d09cf6f87d0af0.png 830w\" sizes=\"(max-width: 300px) 100vw, 300px\" /></a><figcaption class=\"wp-element-caption\">Capture d&rsquo;écran du faux répertoire d&rsquo;extensions : on remarquera qu&rsquo;outre la mauvaise écriture de « WordPress », l&rsquo;URL du site n&rsquo;est pas exactement celle de wordpress.org.</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2023/12/d48a53997052d445.png\" target=\"_blank\" rel=\"noreferrer noopener\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"202\" src=\"https://fr.wordpress.org/files/2023/12/d48a53997052d445-300x202.png\" alt=\"\" class=\"wp-image-2938\" srcset=\"https://fr.wordpress.org/files/2023/12/d48a53997052d445-300x202.png 300w, https://fr.wordpress.org/files/2023/12/d48a53997052d445-1024x690.png 1024w, https://fr.wordpress.org/files/2023/12/d48a53997052d445-768x517.png 768w, https://fr.wordpress.org/files/2023/12/d48a53997052d445.png 1283w\" sizes=\"(max-width: 300px) 100vw, 300px\" /></a><figcaption class=\"wp-element-caption\">Le code contenu dans l&rsquo;extension proposée au téléchargement permet en réalité de créer un compte d&rsquo;administration permettant à une personne tierce de prendre le contrôle de votre site. </figcaption></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>Source des captures d&rsquo;écran : @rmceoin@infosec.exchange</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.4 « Shirley »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2023/11/07/wordpress-6-4-shirley/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://fr.wordpress.org/2023/11/07/wordpress-6-4-shirley/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2023 20:00:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2892\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Découvrez WordPress 6.4, nommée « Shirley » en l\'honneur de l\'artiste de jazz emblématique Shirley Horn.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:77560:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2023/11/wp64-shirley.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://fr.wordpress.org/files/2023/11/wp64-shirley-1024x683.png\" alt=\"\" class=\"wp-image-2924\" srcset=\"https://fr.wordpress.org/files/2023/11/wp64-shirley-1024x683.png 1024w, https://fr.wordpress.org/files/2023/11/wp64-shirley-300x200.png 300w, https://fr.wordpress.org/files/2023/11/wp64-shirley-768x512.png 768w, https://fr.wordpress.org/files/2023/11/wp64-shirley-1536x1024.png 1536w, https://fr.wordpress.org/files/2023/11/wp64-shirley.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Découvrez WordPress 6.4, nommée <strong>« Shirley »</strong> en l&rsquo;honneur de l&rsquo;artiste de jazz emblématique <a href=\"https://fr.wikipedia.org/wiki/Shirley_Horn\">Shirley Horn</a>.</p>\n\n\n\n<p>Sa voix distinctive et sa connexion extraordinaire au piano l&rsquo;ont établie comme l&rsquo;une des principales musiciennes de jazz de sa génération. Le parcours de Shirley Horn, de la scène jazz de <bdo lang=\"en\" dir=\"ltr\">Washington D.C</bdo>. à la scène internationale, témoigne de son dévouement et de sa persévérance. Son influence s&rsquo;est étendue bien au-delà des limites du jazz traditionnel, brisant les frontières et inspirant les publics du monde entier.<br><br>Lançons <a href=\"https://www.youtube.com/channel/UCS3pUiY9OmzB6bPta3-4ArQ/playlists\">quelques tubes</a> de Shirley Horn et musique, apprenons en davantage sur cette nouvelle version majeure de WordPress.</p>\n\n\n\n<p>Chaque version de WordPress renforce votre liberté créative, et WordPress 6.4 n&rsquo;y fait pas exception. Les nouvelles fonctionnalités et les améliorations apportées à l’édition, à la conception et à l’écriture de votre site permettent à vos idées de prendre forme de manière transparente. Améliorez la construction de votre site avec la flexibilité et la puissance de WordPress 6.4.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>La plupart des fonctionnalités et améliorations présentes dans WordPress 6.4 appartiennent à la catégorie des évolutions «&nbsp;petites mais puissantes&nbsp;». En parallèle de la belle flexibilité du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Four</bdo>, ces changements aideront les personnes créant du contenu ou développant leurs propres fonctionnalités à gagner du temps pour se concentrer sur la valeur ajoutée de leur cœur de métier.</p>\n<cite>Josepha Haden Chomphosy, Directrice exécutive du projet <bdo lang=\"en\" dir=\"ltr\">open-source</bdo> WordPress.</cite></blockquote>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link has-black-color has-text-color has-background has-link-color wp-element-button\" href=\"https://fr.wordpress.org/download/\" style=\"border-radius:0px;background:linear-gradient(150deg,rgb(207,202,190) 0%,rgb(234,233,231) 100%)\">Télécharger WordPress 6.4</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Les nouveautés de WordPress 6.4</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Découvrez <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Four</bdo></h3>\n\n\n\n<p>Découvrez les dernières avancées en matière d’édition de sites avec&nbsp;<a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Twenty Twenty-Four</a>. Conçu pour trois cas d’utilisation distincts, la polyvalence du nouveau thème par défaut en fait un choix idéal pour presque tous les types de sites web. Plongez dans sa collection de modèles et de compositions et ouvrez vous un monde de possibilités créatives en quelques ajustements.</p>\n\n\n\n<p>Gagnez en efficacité avec sa collection de <a href=\"https://2024.wordpress.net/index.php/patterns/\">35 modèles de pages et compositions</a> et débloquez en quelques clics tout un monde de possibilités créatives. La flexibilité remarquable de <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Four</bdo> lui permet de s&rsquo;adapter à presque n&rsquo;importe quel type de site.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link has-black-color has-text-color has-background has-link-color wp-element-button\" href=\"http://2024.wordpress.net/\" style=\"border-radius:0px;background:linear-gradient(150deg,rgb(207,202,190) 0%,rgb(234,233,231) 100%)\">Voir la démo de Twenty Twenty-Four</a></div>\n</div>\n\n\n\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/tt4.png?resize=1024%2C666&amp;ssl=1\" alt=\"Cropped screenshots of the Twenty Twenty-Four theme, showing its diverse use cases for photographers, bloggers, and small businesses.\" class=\"wp-image-16274\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Profitez des améliorations apportées à la rédaction de contenu</h3>\n\n\n\n<p>De&nbsp;<a href=\"https://make.wordpress.org/core/2023/10/05/core-editor-improvement-ensuring-excellence-in-the-writing-experience/\">nouvelles améliorations</a>&nbsp;garantissent la fluidité de votre parcours de création de contenus. Vous trouverez de nouveaux raccourcis clavier dans la Vue en liste, une fusion de liste améliorée et un meilleur contrôle des réglages de lien. Une barre d’outils remaniée et cohérente pour les blocs Navigation, Liste et Citation vous permet de travailler efficacement avec les outils dont vous avez besoin.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/writing.png?resize=1024%2C666&amp;ssl=1\" alt=\"Screenshot of a Quote block showing its improved toolbar and the text &quot;Études has saved us thousands of hours of work and has unlock insights we never thought possible.&quot;\" class=\"wp-image-16275\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez plus de résultats avec la palette de commandes</h3>\n\n\n\n<p>Profitez d’un&nbsp;<a href=\"https://make.wordpress.org/core/2023/09/12/core-editor-improvement-commanding-the-command-palette/\">nouveau design et d’un plus grand nombre de commandes (en anglais)</a>&nbsp;pour trouver ce que vous cherchez, effectuer des tâches de manière efficace et gagner du temps lors de vos créations.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/commands.png?resize=1024%2C666&amp;ssl=1\" alt=\"Screenshot of the refreshed UI of the Command Palette. It displays a search bar with the words &quot;Search for commands&quot; and a variety of shortcuts listed below, including &quot;Add new page,&quot; &quot;Preview in a new tab,&quot; and &quot;Patterns.&quot;\" class=\"wp-image-16276\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Catégorisez et filtrez les compositions</h3>\n\n\n\n<p>Organisez vos compositions synchronisées ou standards (non synchronisées) avec des catégories. Explorez le filtrage avancé dans la section Compositions de l’outil d’insertion pour les retrouver plus intuitivement.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/categorize-patterns-1.png?resize=1024%2C666&amp;ssl=1\" alt=\"Screenshot of the Site Editor\'s patterns view which shows a list of patterns with custom categories, such as &quot;About,&quot; &quot;Banners,&quot; and &quot;Call to Action,&quot; patterns.\" class=\"wp-image-16278\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Développez votre créativité avec davantage d’outils de conception</h3>\n\n\n\n<p>Faites preuve de créativité avec de nouvelles images d’arrière-plan dans les blocs Groupe et veillez à ce que les dimensions des images soient cohérentes avec les proportions de taille des espaces réservés.</p>\n\n\n\n<p>Vous souhaitez ajouter des boutons à votre bloc Navigation&nbsp;? Vous pouvez désormais le faire en toute simplicité, sans CSS personnalisé. Si vous travaillez avec des compositions synchronisées, les réglages d’alignement restent intacts pour une expérience de création de compositions transparente.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/design-tools.png?resize=1024%2C666&amp;ssl=1\" alt=\"Decorative image with text &quot;Background images in Group blocks.&quot;\" class=\"wp-image-16279\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Ajoutez un effet de visionneuse aux images</h3>\n\n\n\n<p>Activez la fonctionnalité visionneuse (en anglais <em><bdo lang=\"en\" dir=\"ltr\">lightbox</bdo></em>) pour des images interactives en plein écran d’un simple clic. Appliquez-la globalement ou à des images spécifiques pour personnaliser l’expérience de visualisation.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/lightbox.png?resize=1024%2C666&amp;ssl=1\" alt=\"Decorative photo of a triangular building structure with a &quot;click to expand&quot; icon on the right top corner.\" class=\"wp-image-16280\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Renommez les blocs Groupe</h3>\n\n\n\n<p>Définissez des noms personnalisés pour vos blocs Groupe pour facilement organiser et différencier les parties de votre contenu. Ces noms seront visibles dans la Vue en liste.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/rename.png?resize=1024%2C666&amp;ssl=1\" alt=\"Screenshot of the List View tool. It shows a Group block renamed as &quot;Hero Area&quot; with inner Group blocks also with custom names, such as &quot;Content,&quot; &quot;Images,&quot; and &quot;Call to action.&quot;\" class=\"wp-image-16281\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Prévisualisez les images depuis la vue en liste</h3>\n\n\n\n<p>Les nouveaux aperçus des médias pour les blocs Galerie et Image dans la vue en liste vous permettent de visualiser et de localiser d’un coup d’œil les images de votre contenu.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/list-view-images.png?resize=1024%2C666&amp;ssl=1\" alt=\"Screenshot of the List View tool, showing the new image previews for the Image and Gallery blocks.\" class=\"wp-image-16282\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Partagez des compositions entre sites</h3>\n\n\n\n<p>Besoin d’utiliser vos compositions personnalisées sur un autre site&nbsp;? Rien de plus simple&nbsp;! Importez et exportez-les sous forme de fichiers JSON à partir de la vue des compositions de l’éditeur de site.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/exporting-patterns.png?resize=1024%2C666&amp;ssl=1\" alt=\"Screenshot showing the &quot;Import pattern from JSON files&quot; option from the Site Editor\'s patterns view.\" class=\"wp-image-16283\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Présentation des crochets de bloc</h3>\n\n\n\n<p>Les <a href=\"https://make.wordpress.org/core/2023/10/15/introducing-block-hooks-for-dynamic-blocks/\">crochets de bloc (documentation technique en anglais)</a> sont une nouvelle fonctionnalité puissante qui permet aux extensions d’insérer automatiquement des blocs dans le contenu d’un autre bloc. Il s’agit de recommandations qui rendent votre travail avec les blocs plus intuitif. Un nouveau panneau «&nbsp;Extensions&nbsp;» vous permet de les adapter à vos besoins&nbsp; : ajoutez, supprimez et réorganisez les crochets de bloc à votre guise.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/11/block-hooks.png?resize=1024%2C666&amp;ssl=1\" alt=\"Cropped screenshot showing a mini shopping cart (in a red dotted circle) inserted into a navigation menu by Block Hooks.\" class=\"wp-image-16284\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Performances</h3>\n\n\n\n<p>WordPress 6.4 comprend plus de 100 mises à jour de performances pour une expérience plus rapide et plus efficace. Les améliorations se concentrent sur les performances de chargement des modèles pour les thèmes basés sur des blocs et les thèmes classiques, l’utilisation des stratégies de chargement de script «&nbsp;defer&nbsp;» et «&nbsp;async&nbsp;» dans le cœur, les blocs et les thèmes, et l’optimisation des options chargées automatiquement.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibilité</h3>\n\n\n\n<p>Chaque version s’engage à rendre WordPress accessible à toutes et tous. La version 6.4 apporte des améliorations à l’affichage en liste et la prise en charge de l’attribut <code>aria-label</code> pour le bloc Navigation, parmi d’autres points forts. L’interface d’administration inclut des améliorations dans le placement des boutons, le contexte des éléments de menu permettant d’ajouter du contenu, et les messages affichés aux synthèses vocales sur l’écran de Santé du site.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Autres éléments notables</h3>\n\n\n\n<ul>\n<li>Même si WordPress 6.4 est compatible avec toutes les versions supérieures ou égales à PHP 7.0,  nous&nbsp;<a href=\"https://wordpress.org/news/2023/10/wordpress-6-4s-php-compatibility/\">recommendons d&rsquo;utiliser WordPress 6.4 avec PHP 8.1 ou 8.2 (en anglais)</a>.</li>\n\n\n\n<li>WordPress 6.4&nbsp;<a href=\"https://make.wordpress.org/core/2023/10/16/changes-to-attachment-pages/\">désactivera maintenant les pages de fichiers attachés (communiqué en anglais)</a>&nbsp;pour toutes les nouvelles installations.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress&nbsp;6.4</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;Learn&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2023/10/30/guide-des-changements-techniques-de-wordpress-6-4/\">Guide des changements techniques de WordPress 6.4</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-4/\">Lisez les notes de version de WordPress 6.4</a>&nbsp;pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.4</h2>\n\n\n\n<p>​​La version 6.4 de WordPress 6.4 a été dirigée par une équipe entièrement composée de personnes appartenant à des genres sous-représentés dans le milieu «&nbsp;tech&nbsp;», ce qui est une façon pour le projet WordPress de souligner l&rsquo;importance de donner une voix à la diversité dans l&rsquo;écosystème <bdo lang=\"en\" dir=\"ltr\">open-source</bdo>.</p>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul>\n<li><strong>Direction générale&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a></li>\n\n\n\n<li><strong>Coordination&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a>,&nbsp;<a href=\"https://profiles.wordpress.org/metalandcoffee/\">Ebonie Butler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>,&nbsp;<a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>, avec l&rsquo;appui de <a href=\"https://profiles.wordpress.org/thewebprincess/\">Dee Teal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jaimieolmstead/\">Jaimie Olmstead</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jyolsna/\">Jyolsna J E</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li><strong>Direction technique Cœur&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, avec l&rsquo;appui de&nbsp;<a href=\"https://profiles.wordpress.org/pypwalters/\">Stephanie Walters</a></li>\n\n\n\n<li><strong>Direction technique de l’éditeur de blocs&nbsp;:&nbsp;</strong><a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>,&nbsp;<a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan Bamber</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, avec l&rsquo;appui de <a href=\"https://profiles.wordpress.org/68kheart/\">Devan Ferguson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/battelfred/\">Frédérique Battel</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jessicagoddard/\">Jessica Goddard</a>,&nbsp;<a href=\"https://profiles.wordpress.org/1happyplace/\">Katie Ayres</a>,&nbsp;<a href=\"https://profiles.wordpress.org/martatorre/\">Marta Torre</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ngreennc/\">Nyasha Green</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a></li>\n\n\n\n<li><strong>Gestion de projet côté Cœur WP&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a></li>\n\n\n\n<li><strong>Gestion de projet côté Éditeur</strong>&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, avec l&rsquo;appui de&nbsp;<a href=\"https://profiles.wordpress.org/emilyatmobtown/\">Emily Leffler Schulman</a></li>\n\n\n\n<li><strong>Direction de la documentation&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>,&nbsp;<a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a>,&nbsp;<a href=\"https://profiles.wordpress.org/611shabnam/\">Mushrit Shabnam</a>, avec l&rsquo;appui de <a href=\"https://profiles.wordpress.org/itsjustdj/\">D.J. Billings</a>,&nbsp;<a href=\"https://wordpress.org/support/users/codente/\">Jamie VanRaalte</a>,&nbsp;<a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a>,&nbsp;<a href=\"https://profiles.wordpress.org/baxbridge/\">Tiffany Bridge</a>,&nbsp;<a href=\"https://profiles.wordpress.org/planningwrite/\">Winstina Hughes</a></li>\n\n\n\n<li><strong>Direction marketing et communications :</strong>&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rmartinezduque/\">Reyes Martínez</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a>, avec l&rsquo;appui de&nbsp;<a href=\"https://profiles.wordpress.org/meaganhanes/\">Meagan Hanes</a>,&nbsp;<a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li><strong>Direction des tests&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a>, avec l&rsquo;appui de&nbsp;<a href=\"https://profiles.wordpress.org/annebovelett/\">Anne Bovelett</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coachbirgit/\">Birgit Olzem</a></li>\n\n\n\n<li><strong>Direction artistique&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/elmastudio/\">Ellen Bauer</a>,&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, avec l&rsquo;appui de&nbsp;<a href=\"https://profiles.wordpress.org/allisonplus/\">Allison Tarr</a>,&nbsp;<a href=\"https://profiles.wordpress.org/acirujano/\">Ana Cirujano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/cathibosco1/\">Cathi Bosco</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nudge/\">Sonia Gaballa</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ohia/\">Ohia</a></li>\n\n\n\n<li><strong>Direction des performances&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/clarkeemily/\">Emily Clarke</a>, avec l&rsquo;appui de <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a></li>\n\n\n\n<li><strong>Direction de l&rsquo;équipe formation&nbsp;:</strong>&nbsp;<a href=\"https://profiles.wordpress.org/courtneypk/\">Courtney P.K.</a>,&nbsp;<a href=\"https://profiles.wordpress.org/courane01/\">Courtney Roberston</a></li>\n\n\n\n<li><strong>Direction du design et du développement du nouve