<?php
/*
Plugin Name: Divi Fly-In
Plugin URI: https://www.divi-community.fr
Description: Elegantly display information with fly-in type pop-ups.
Version: 1.2
Author: Pierre Bichet
Author URI: https://twitter.com/PixelsnDecibels
Icon1x: https://www.divi-community.fr/wp-content/uploads/2020/04/divi-flyin-icon-128x128.png
Icon2x: https://www.divi-community.fr/wp-content/uploads/2020/04/divi-flyin-icon-256x256.png
BannerHigh: https://www.divi-community.fr/wp-content/uploads/2020/04/divi-flyin-banner-1544x500.jpg
BannerLow: https://www.divi-community.fr/wp-content/uploads/2020/04/divi-flyin-banner-772x250.jpg
*/


// If this file is called directly, abort.

	if ( ! defined( 'WPINC' ) ) {
		die;
	}

define( 'DIVI_FLYIN_VERSION', '1.2' );


// Load styles and scripts

	function pb_dfi_load_divi_flyin(){
		wp_enqueue_style( 'divi-flyin', plugins_url( 'assets/divi-flyin.css', __FILE__ ) );
		wp_register_script( 'divi-flyin-js', plugins_url( 'assets/divi-flyin-js.js', __FILE__ ), array( 'jquery' ) );
		wp_enqueue_script( 'divi-flyin-js' );
	}
	add_action( 'wp_enqueue_scripts', 'pb_dfi_load_divi_flyin', 9999 );



// If a cookie exists, leave the fly-in hidden

	function get_dfi_cookie() { 
		
		if(isset($_COOKIE["dfi_cookie"]) && $_COOKIE["dfi_cookie"] == "hide_dfi"){     

			echo '
				<style type="text/css">
					.divi-flyin { 
						display: none;
					}
				</style>
			';
		} 
	} 
	add_action('wp_head', 'get_dfi_cookie');


// Updater

	require_once plugin_dir_path( __FILE__ ) . 'lib/wp-package-updater/class-wp-package-updater.php';

	$darkdivi_updater = new WP_Package_Updater(
		'https://divi-community.fr',
		wp_normalize_path( __FILE__ ),
		wp_normalize_path( plugin_dir_path( __FILE__ ) )
	);