<?php

class DIPI_FilterableGallery extends DIPI_Builder_Module
{
    private static $vendor_prefix = 'dipi';
    public $slug = 'dipi_filterable_gallery';
    public $vb_support = 'on';

    protected $module_credits = array(
        'module_uri' => 'https://divi-pixel.com/modules/filterable-gallery',
        'author' => 'Divi Pixel',
        'author_uri' => 'https://divi-pixel.com',
    );


    public function init()
    {
        $this->icon_path = plugin_dir_path(__FILE__) . 'icon.svg';
        $this->name = esc_html__('Pixel Filterable Gallery', 'dipi-divi-pixel');
        $this->settings_modal_toggles = [
            'general' => [
                'toggles' => [
                    'filter_settings' => esc_html__('Filter Settings', 'dipi-divi-pixel'),
                    'pagination' => esc_html__('Pagination', 'dipi-divi-pixel'),
                    'filter_bar' => esc_html__('Filter Bar', 'dipi-divi-pixel'),
                    'grid' => esc_html__('Grid', 'dipi-divi-pixel'),
                    'grid_items' => esc_html__('Grid Items', 'dipi-divi-pixel'),
                    'images' => esc_html__('Images', 'dipi-divi-pixel'),
                    'overlay' => esc_html__('Image Overlay', 'dipi-divi-pixel'),
                    'overlay_animation' => array(
                        'title' => esc_html__('Image Overlay Animation', 'dipi-divi-pixel'),
                        'tabbed_subtoggles' => true,
                        'sub_toggles' => [
                            'icon' => [
                                'name' => 'Icon',
                            ],
                            'title' => [
                                'name' => 'Title',
                            ],
                            'caption' => [
                                'name' => 'Caption',
                            ],
                        ],
                    ),
                ],
            ],
            'advanced' => [
                'toggles' => [
                    'pagination_btn'  => [
                        'title' =>  esc_html__('Pagination Button', 'dipi-divi-pixel'),
                        'tabbed_subtoggles' => true,
                        'sub_toggles' => [
                            'normal' => [
                                'name' => 'Normal',
                            ],
                            'active' => [
                                'name' => 'Active',
                            ],
                        ],
                    ],
                    'load_more' => esc_html__('Load More', 'dipi-divi-pixel'),
                    'filter_bar' => esc_html__('Filter Bar', 'dipi-divi-pixel'),
                    'filter_bar_items' => [
                        'title' => esc_html__('Filter Bar Items', 'dipi-divi-pixel'),
                        'tabbed_subtoggles' => true,
                        'sub_toggles' => [
                            'normal' => [
                                'name' => 'Normal',
                            ],
                            'active' => [
                                'name' => 'Active',
                            ],
                        ],
                    ],
                    'grid' => esc_html__('Grid', 'dipi-divi-pixel'),
                    'grid_items' => esc_html__('Grid Items', 'dipi-divi-pixel'),
                    'grid_item_text' => [
                        'title' => esc_html__('Grid Item Text', 'dipi-divi-pixel'),
                        'tabbed_subtoggles' => true,
                        'sub_toggles' => [
                            'title' => [
                                'name' => 'Title',
                            ],
                            'caption' => [
                                'name' => 'Caption',
                            ],
                            'category' => [
                                'name' => 'Category',
                            ]
                        ]
                    ],                    
                    'overlay_text_group' => array(
                        'title' => esc_html__('Image Overlay Text', 'dipi-divi-pixel'),
                        'tabbed_subtoggles' => true,
                        'sub_toggles' => [
                            'title' => [
                                'name' => 'Title',
                            ],
                            'caption' => [
                                'name' => 'Caption',
                            ],
                        ],
                    ),
                    'overlay' => esc_html__('Image Overlay', 'dipi-divi-pixel'),
                ],
            ],
        ];
        $this->custom_css_fields = array(
            'grid_item'=> array(
                'label' => esc_html__('Grid Item', 'dipi-divi-pixel'),
                'selector' => '.dipi_filterable_gallery_wrapper .grid  .grid-item',
            ),
            'grid_item_img'=> array(
                'label' => esc_html__('Grid Image', 'dipi-divi-pixel'),
                'selector' => '.dipi_filterable_gallery_wrapper .grid  .grid-item .img-container img',
            ),
            'overlay_icon' => array(
                'label' => esc_html__('Overlay Icon', 'dipi-divi-pixel'),
                'selector' => '.dipi-filterable-gallery-icon',
            ),
            'overlay_title' => array(
                'label' => esc_html__('Overlay Title', 'dipi-divi-pixel'),
                'selector' => '.dipi-filterable-gallery-title',
            ),
            'overlay_caption' => array(
                'label' => esc_html__('Overlay Caption', 'dipi-divi-pixel'),
                'selector' => '.dipi-filterable-gallery-caption',
            ),
        );
    }

    public function get_fields()
    {
        $et_accent_color = et_builder_accent_color();
        
        $fields = [];

        $fields['include_term_ids'] = [
            'label' => esc_html__('Included Divi Pixel Category', 'dipi-divi-pixel'),
            'type' => 'categories',
            'option_category' => 'basic_option',
            'toggle_slug' => 'filter_settings',
            'renderer_options' => array(
                'use_terms' => true,
                'term_name' => 'dipi_media_category'
            ),
            'computed_affects' => ['__filterable_gallery'],
        ];
        $fields['pagination_type'] = [
            'label' => esc_html__('Pagination Type', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'configuration',
            'options' => [
                'none' => esc_html__('None', 'dipi-divi-pixel'),
                'numbered_pagination' => esc_html__('Numbered Pagination', 'dipi-divi-pixel'),
                'load_more' => esc_html__('Load More', 'dipi-divi-pixel'),
                'infinite_scroll' => esc_html__('Infinite Scroll', 'dipi-divi-pixel'),
            ],
            'default' => 'none',
            'toggle_slug' => 'pagination',
            'description' => esc_html__("Define the type of pagination.", 'dipi-divi-pixel'),
            'computed_affects' => ['__filterable_gallery'],
            'mobile_options' => true,
        ];
        $fields['image_count'] = [
            'label' => esc_html__('Image Count', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'unitless' => true,
            'default' => '-1',
            'range_settings' => array(
                'min' => '-1',
                'max' => '50',
                'step' => '1',
            ),
            'toggle_slug' => 'pagination',
            'description' => esc_html__("Define the number of images that should be displayed.", 'dipi-divi-pixel'),
            'computed_affects' => ['__filterable_gallery'],
            'mobile_options' => true,
            'show_if' => [
                'pagination_type' => 'none'
            ]
        ];
        $fields['images_per_page'] = [
            'label' => esc_html__('Images Per Page', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'unitless' => true,
            'default' => '10',
            'range_settings' => array(
                'min' => '1',
                'max' => '50',
                'step' => '1',
            ),
            'toggle_slug' => 'pagination',
            'description' => esc_html__("Define the number of images that should be displayed on a page.", 'dipi-divi-pixel'),
            'computed_affects' => ['__filterable_gallery'],
            'show_if_not' => [
                'pagination_type' => 'none'
            ]
        ];
        $fields["prev_btn_text"] = [
            'label'       => esc_html__('Prev Button Text', 'dipi-divi-pixel'),
            'type'        => 'text',
            'toggle_slug' => 'pagination',
            'default' => 'Prev',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'pagination_type' => ['numbered_pagination']
            ]
        ];
        $fields["next_btn_text"] = [
            'label'       => esc_html__('Next Button Text', 'dipi-divi-pixel'),
            'type'        => 'text',
            'toggle_slug' => 'pagination',
            'default' => 'Next',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'pagination_type' => ['numbered_pagination']
            ]
        ]; 
        $fields["load_more_text"] = [
            'label'       => esc_html__('Load More Text', 'dipi-divi-pixel'),
            'type'        => 'text',
            'toggle_slug' => 'pagination',
            'default' => 'Load More',
            'dynamic_content' => 'text',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'pagination_type' => ['load_more','infinite_scroll']
            ]
        ]; 
        $fields['infinite_scroll_viewport'] = [
            'label'           => esc_html__( 'Infinite Scrolling Viewport', 'dipi-divi-pixel' ),
            'description' => esc_html__('Load more images when scrolled this amount. Shouldn\'t be larger than 50% of screen height', 'dipi-divi-pixel'),
            'type'            => 'range',
            'range_settings'  => [
                'min'  => 0,
                'max'  => 50,
                'step' => 1,
            ],
            'default'             => '25%',
            'allowed_units' => array('%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'),
            'validate_unit'       => true,
            'fixed_range'         => true,
            'reset_animation'     => true,
            'toggle_slug' => 'pagination',
            'show_if' => [
                'pagination_type' => 'infinite_scroll'
            ]
        ];  
        $fields['gallery_orderby'] = array(
            'label' => esc_html__('Order By', 'dipi-divi-pixel'),
            'type' => $this->is_loading_bb_data() ? 'hidden' : 'select',
            'options' => array(
                '' => esc_html__('Default', 'dipi-divi-pixel'),
                'rand' => esc_html__('Random', 'dipi-divi-pixel'),
            ),
            'class' => array('et-pb-gallery-ids-field'),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'toggle_slug' => 'filter_settings',
        );

        $fields['filter_bar_layout'] = [
            'label' => esc_html__('Layout', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'configuration',
            'options' => [
                /*'dropdown' => esc_html__('Dropdown', 'dipi-divi-pixel'),*/
                'row' => esc_html__('Inline', 'dipi-divi-pixel'),
                'column' => esc_html__('Stacked', 'dipi-divi-pixel')
            ],
            'mobile_options' => true,
            'responsive' => true,
            'default' => 'row',
            'toggle_slug' => 'filter_bar',
        ];
        $fields['filter_tab_alignment'] =[
            'label'            => esc_html__( 'Filter Tab Alignment', 'et_builder' ),
            'type'             => 'select',
            'option_category'  => 'configuration',
            'options_icon' => 'module_align',
            'options' => [
                'start' => esc_html__('Left', 'dipi-divi-pixel'),
                'center' => esc_html__('Center', 'dipi-divi-pixel'),
                'end' => esc_html__('Right', 'dipi-divi-pixel'),
            ],
            'toggle_slug'      => 'filter_bar',
            'mobile_options' => true,
        ];
        $fields["show_all_filter"] = [
            'label' => esc_html__('Show All Filter', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'on',
            'options' => array(
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ),
            'toggle_slug'      => 'filter_bar',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];
        $fields["all_filter_label"] = [
            'label'       => esc_html__('All Filter Label', 'dipi-divi-pixel'),
            'type'        => 'text',
            'toggle_slug' => 'filter_bar',
            'show_if' => ['show_all_filter' => 'on'],
            'default' => 'All',
            'dynamic_content' => 'text',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];
        $fields["show_num_of_elements"] = [
            'label' => esc_html__('Show Number of Elements', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ),
            'toggle_slug'      => 'filter_bar',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];
        $fields['grid_layout'] = [
            'label' => esc_html__('Layout', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'configuration',
            'options' => [
                'grid' => esc_html__('Grid', 'dipi-divi-pixel'),
                'masonry' => esc_html__('Masonry', 'dipi-divi-pixel')
            ],
            'default' => 'masonry',
            'toggle_slug' => 'grid',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];

        $fields["columns"] = [
            'label' => esc_html__('Columns', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'basic_option',
            'toggle_slug' => 'grid',
            'default' => '4',
            'range_settings' => array(
                'min' => '1',
                'max' => '10',
                'step' => '1',
            ),
            'mobile_options' => true,
            'responsive' => true,
            'unitless' => true,
            'default_unit' => '',
        ];
        $fields['row_height'] = [
            'label' => esc_html__('Row Height', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'allowed_units' => array('%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'),
            'range_settings' => [
                'min' => '0',
                'max' => '500',
                'step' => '10',
            ],
            'show_if' => [
                'grid_layout' => 'grid',
            ],
            'mobile_options' => true,
            'default_unit' => 'px',
            'toggle_slug' => 'grid',
        ];


        $fields["gutter"] = [
            'label' => esc_html__('Gutter', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'layout',
            'toggle_slug' => 'grid',
            'default' => '10',
            'range_settings' => array(
                'min' => '0',
                'max' => '100',
                'step' => '1',
            ),
            'mobile_options' => true,
            'responsive' => true,
            'unitless' => true,
        ];
        $fields['grid_animation'] = array(
            'label' => esc_html__('Grid Animation', 'dipi-divi-pixel'),
            'type' => 'select',
            'options' => array(
                'none' => esc_html__('None', 'dipi-divi-pixel'),
                'fadeIn'  => esc_html__('Fade In', 'dipi-divi-pixel'),
                'fadeInLeftShort'  => esc_html__('FadeIn Left', 'dipi-divi-pixel'),
                'fadeInRightShort' => esc_html__('FadeIn Right', 'dipi-divi-pixel'),
                'fadeInUpShort'    => esc_html__('FadeIn Up', 'dipi-divi-pixel'),
                'fadeInDownShort'  => esc_html__('FadeIn Down', 'dipi-divi-pixel'),
                'zoomInShort'       => esc_html__('Grow', 'dipi-divi-pixel'),
                'bounceInShort' => esc_html__('BounceIn', 'dipi-divi-pixel'),
                'bounceInLeftShort' => esc_html__('BounceIn Left', 'dipi-divi-pixel'),
                'bounceInRightShort' => esc_html__('BounceIn Right', 'dipi-divi-pixel'),
                'bounceInUpShort' => esc_html__('BounceIn Up', 'dipi-divi-pixel'),
                'bounceInDownShort' => esc_html__('BounceIn Down', 'dipi-divi-pixel'),
                'flipInXShort' => esc_html__('FlipInX', 'dipi-divi-pixel'),
                'flipInYShort' => esc_html__('FlipInY', 'dipi-divi-pixel'),
                'jackInTheBoxShort' => esc_html__('JackInTheBox', 'dipi-divi-pixel'),
                'rotateInShort'  => esc_html__('RotateIn', 'dipi-divi-pixel'),
                'rotateInDownLeftShort' => esc_html__('RotateIn DownLeft', 'dipi-divi-pixel'),
                'rotateInUpLeftShort' => esc_html__('RotateIn UpLeft', 'dipi-divi-pixel'),
                'rotateInDownRightShort' => esc_html__('RotateIn DownRight', 'dipi-divi-pixel'),
                'rotateInUpRightShort' => esc_html__('RotateIn UpRight', 'dipi-divi-pixel'),
            ),
            'default' => 'none',
            'toggle_slug' => 'grid',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        );
        $fields['grid_animation_delay'] = [
            'label' => esc_html__('Interval Delay', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '0ms',
            'default_on_front' => '0ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '3000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'grid',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
             
        ];
        $fields['grid_animation_speed'] = [
            'label' => esc_html__('Grid Animation Speed', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '600ms',
            'default_on_front' => '1000ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '3000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'grid',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];

        $fields['fix_lazy'] = [
            'label' => esc_html__('Fix Lazy Loading Images', 'ds-suit-material'),
            'description' => esc_html__('Whether or not to use apply a fix for lazy loading images. Only activate this setting, if you encounter issues with the gallery in combination with lazy loading images plugins like Jetpack.', 'ds-suit'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'toggle_slug' => 'grid',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'ds-suit-material'),
                'on' => esc_html__('On', 'ds-suit-material'),
            ),
        ];

        $fields['image_animation'] = array(
            'label' => esc_html__('Image Animation', 'dipi-divi-pixel'),
            'type' => 'select',
            'options' => array(
                'none' => esc_html__('None', 'dipi-divi-pixel'),
                'zoom-in' => esc_html__('Zoom In', 'dipi-divi-pixel'),
                'zoom-out' => esc_html__('Zoom Out', 'dipi-divi-pixel'),
                'move-up' => esc_html__('Move Up', 'dipi-divi-pixel'),
                'move-down' => esc_html__('Move Down', 'dipi-divi-pixel'),
                'move-left' => esc_html__('Move Left', 'dipi-divi-pixel'),
                'move-right' => esc_html__('Move Right', 'dipi-divi-pixel'),
                'rotate' => esc_html__('Rotate', 'dipi-divi-pixel'),
            ),
            'default' => 'none',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'toggle_slug' => 'grid_items',
        );

        $fields['image_animation_speed'] = [
            'label' => esc_html__('Image Animation Speed', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '600ms',
            'default_on_front' => '500ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '3000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'grid_items',
        ];

        $fields['show_img_caption'] = [
            'label' => esc_html__('Show Image Caption in Grid item', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'configuration',
            'toggle_slug' => 'grid_items',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];
        $fields['show_img_title'] = [
            'label' => esc_html__('Show Image Title in Grid item', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'configuration',
            'toggle_slug' => 'grid_items',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];
        $fields['show_img_category'] = [
            'label' => esc_html__('Show Image Categories in Grid item', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'configuration',
            'toggle_slug' => 'grid_items',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];

        $fields["use_media_link"] = [
            'label' => esc_html__('Use Image Link', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'images',
            'description' => esc_html__('Open custom URL when image is clicked.', 'dipi-divi-pixel'),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'mobile_options' => true,
        ];

        $fields["show_lightbox"] = [
            'label' => esc_html__('Show Lightbox', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'on',
            'options' => array(
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'images',
            'description' => esc_html__('Whether or not to show lightbox.', 'dipi-divi-pixel'),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'use_media_link' => 'off'
            ],
            'mobile_options' => true,
        ];
        $fields["title_in_lightbox"] = [
            'label' => esc_html__('Show Image Title in Lightbox', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'images',
            'description' => esc_html__('Whether or not to show the image title in the lightbox. The title is automatically loaded from the media library.', 'dipi-divi-pixel'),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'show_lightbox' => 'on',
            ],
        ];

        $fields["caption_in_lightbox"] = [
            'label' => esc_html__('Show Image Caption in Lightbox', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'images',
            'description' => esc_html__('Whether or not to show the image caption in the lightbox. The caption is automatically loaded from the media library.', 'dipi-divi-pixel'),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'show_lightbox' => 'on',
            ],
        ];
        $fields['use_thumbnails'] = [
            'label' => esc_html__('Use Responsive Thumbnails', 'dipi-divi-pixel'),
            'description' => esc_html__('Whether or not to use custom sized thumbnails on different devices. If this option is disabled, the full size image will be used as thumbnail.', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'toggle_slug' => 'images',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
        ];

        $fields['image_size_desktop'] = [
            'label' => esc_html__('Image Size (Desktop)', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'basic_option',
            'default' => 'full',
            'options' => $this->dipi_get_image_sizes(),
            'toggle_slug' => 'images',
            'description' => 'Here you can choose the image size to use. If you are using very large images, consider using a thumbnail size to speed up page loading time.',
            'show_if' => [
                'use_thumbnails' => 'on',
            ],
        ];

        $fields['image_size_tablet'] = [
            'label' => esc_html__('Image Size (Tablet)', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'basic_option',
            'default' => 'full',
            'options' => $this->dipi_get_image_sizes(),
            'toggle_slug' => 'images',
            'description' => 'Here you can choose the image size to use. If you are using very large images, consider using a thumbnail size to speed up page loading time.',
            'show_if' => [
                'use_thumbnails' => 'on',
            ],
        ];

        $fields['image_size_phone'] = [
            'label' => esc_html__('Image Size (Phone)', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'basic_option',
            'default' => 'full',
            'options' => $this->dipi_get_image_sizes(),
            'toggle_slug' => 'images',
            'description' => 'Here you can choose the image size to use. If you are using very large images, consider using a thumbnail size to speed up page loading time.',
            'show_if' => [
                'use_thumbnails' => 'on',
            ],
        ];
        $fields["use_overlay"] = [
            'label' => esc_html__('Use Image Overlay', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'toggle_slug' => 'overlay',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'mobile_options' => true,
        ];
        $fields["show_lightbox_link_icon"] = [
            'label' => esc_html__('Show Lightbox and Link Icon', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'on',
            'options' => array(
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'overlay',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'mobile_options' => true,
            'show_if' => [
                'use_media_link' => 'on',
                'use_overlay' => 'on',
            ],
        ];
        $fields["overlay_align_horizontal"] = [
            'label' => esc_html__('Horizontal Align', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'basic_option',
            'default' => 'center',
            'options' => array(
                'flex-start' => esc_html__('Left', 'dipi-divi-pixel'),
                'center' => esc_html__('Center', 'dipi-divi-pixel'),
                'flex-end' => esc_html__('Right', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'overlay',
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];

        $fields["overlay_align_vertical"] = [
            'label' => esc_html__('Vertical Align', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'basic_option',
            'default' => 'center',
            'options' => array(
                'flex-start' => esc_html__('Top', 'dipi-divi-pixel'),
                'center' => esc_html__('Center', 'dipi-divi-pixel'),
                'flex-end' => esc_html__('Bottom', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'overlay',
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];
        $fields["icon_in_overlay"] = [
            'label' => esc_html__('Show Icon in Overlay', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'overlay',
            'description' => esc_html__('Whether or not to show the Icon in the Overlay. The title is automatically loaded from the media library.', 'dipi-divi-pixel'),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];

        $fields['hover_icon'] = array(
            'label' => esc_html__('Overlay Icon', 'dipi-divi-pixel'),
            'type' => 'select_icon',
            'option_category' => 'configuration',
            'class' => array('et-pb-font-icon'),
            'option_category' => 'configuration',
            'default' => '',
            'toggle_slug' => 'overlay',
            'show_if' => [
                'use_overlay' => 'on',
                'icon_in_overlay' => 'on',
            ],
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        );

        $fields["title_in_overlay"] = [
            'label' => esc_html__('Show Image Title in Overlay', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'overlay',
            'description' => esc_html__('Whether or not to show the image title in the Overlay. The title is automatically loaded from the media library.', 'dipi-divi-pixel'),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];

        $fields["caption_in_overlay"] = [
            'label' => esc_html__('Show Image Caption in Overlay', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
            'toggle_slug' => 'overlay',
            'description' => esc_html__('Whether or not to show the image caption in the lightbox. The caption is automatically loaded from the media library.', 'dipi-divi-pixel'),
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];
        $fields["icon_animation"] = [
            'label' => esc_html__('Icon Animation', 'dipi-divi-pixel'),
            'type' => 'select',
            'default' => 'fadeInUp',
            'options' => [
                'fadeIn' => esc_html__('Fade In', 'dipi-divi-pixel'),
                'fadeInLeft' => esc_html__('Fade In Left', 'dipi-divi-pixel'),
                'fadeInRight' => esc_html__('Fade In Right', 'dipi-divi-pixel'),
                'fadeInUp' => esc_html__('Fade In Up', 'dipi-divi-pixel'),
                'fadeInDown' => esc_html__('Fade In Down', 'dipi-divi-pixel'),
                'zoomIn' => esc_html__('Grow', 'dipi-divi-pixel'),
                'bounceIn' => esc_html__('Bounce In', 'dipi-divi-pixel'),
                'bounceInLeft' => esc_html__('Bounce In Left', 'dipi-divi-pixel'),
                'bounceInRight' => esc_html__('Bounce In Right', 'dipi-divi-pixel'),
                'bounceInUp' => esc_html__('Boune In Up', 'dipi-divi-pixel'),
                'bounceInDown' => esc_html__('BouneIn Down', 'dipi-divi-pixel'),
                'flipInX' => esc_html__('FlipInX', 'dipi-divi-pixel'),
                'flipInY' => esc_html__('FlipInY', 'dipi-divi-pixel'),
                'jackInTheBox' => esc_html__('JackInThe Box', 'dipi-divi-pixel'),
                'rotateIn' => esc_html__('RotateIn', 'dipi-divi-pixel'),
                'rotateInDownLeft' => esc_html__('RotateInDownLeft', 'dipi-divi-pixel'),
                'rotateInUpLeft' => esc_html__('RotateInUpLeft', 'dipi-divi-pixel'),
                'rotateInDownRight' => esc_html__('RotateInDownRight', 'dipi-divi-pixel'),
                'rotateInUpRight' => esc_html__('RotateInUpRight', 'dipi-divi-pixel'),
            ],
            'sub_toggle' => 'title',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'use_overlay' => 'on',
            ],
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'icon',
        ];
        $fields["title_animation"] = [
            'label' => esc_html__('Title Animation', 'dipi-divi-pixel'),
            'type' => 'select',
            'default' => 'fadeInUp',
            'options' => [
                'fadeIn' => esc_html__('Fade In', 'dipi-divi-pixel'),
                'fadeInLeft' => esc_html__('Fade In Left', 'dipi-divi-pixel'),
                'fadeInRight' => esc_html__('Fade In Right', 'dipi-divi-pixel'),
                'fadeInUp' => esc_html__('Fade In Up', 'dipi-divi-pixel'),
                'fadeInDown' => esc_html__('Fade In Down', 'dipi-divi-pixel'),
                'zoomIn' => esc_html__('Grow', 'dipi-divi-pixel'),
                'bounceIn' => esc_html__('Bounce In', 'dipi-divi-pixel'),
                'bounceInLeft' => esc_html__('Bounce In Left', 'dipi-divi-pixel'),
                'bounceInRight' => esc_html__('Bounce In Right', 'dipi-divi-pixel'),
                'bounceInUp' => esc_html__('Boune In Up', 'dipi-divi-pixel'),
                'bounceInDown' => esc_html__('BouneIn Down', 'dipi-divi-pixel'),
                'flipInX' => esc_html__('FlipInX', 'dipi-divi-pixel'),
                'flipInY' => esc_html__('FlipInY', 'dipi-divi-pixel'),
                'jackInTheBox' => esc_html__('JackInThe Box', 'dipi-divi-pixel'),
                'rotateIn' => esc_html__('RotateIn', 'dipi-divi-pixel'),
                'rotateInDownLeft' => esc_html__('RotateInDownLeft', 'dipi-divi-pixel'),
                'rotateInUpLeft' => esc_html__('RotateInUpLeft', 'dipi-divi-pixel'),
                'rotateInDownRight' => esc_html__('RotateInDownRight', 'dipi-divi-pixel'),
                'rotateInUpRight' => esc_html__('RotateInUpRight', 'dipi-divi-pixel'),
            ],
            'sub_toggle' => 'title',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'use_overlay' => 'on',
            ],
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'title',
        ];
        $fields['icon_delay'] = [
            'label' => esc_html__('Interval Delay', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '100ms',
            'default_on_front' => '0ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '3000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'icon',
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];

        $fields['icon_speed'] = [
            'label' => esc_html__('Speed', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '600ms',
            'default_on_front' => '600ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '2000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'icon',
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];
        $fields['title_delay'] = [
            'label' => esc_html__('Interval Delay', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '100ms',
            'default_on_front' => '100ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '3000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'title',
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];

        $fields['title_speed'] = [
            'label' => esc_html__('Speed', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '600ms',
            'default_on_front' => '600ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '2000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'title',
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];
        $fields["caption_animation"] = [
            'label' => esc_html__('Caption Animation', 'dipi-divi-pixel'),
            'type' => 'select',
            'default' => 'fadeInUp',
            'options' => [
                'fadeIn' => esc_html__('Fade In', 'dipi-divi-pixel'),
                'fadeInLeft' => esc_html__('Fade In Left', 'dipi-divi-pixel'),
                'fadeInRight' => esc_html__('Fade In Right', 'dipi-divi-pixel'),
                'fadeInUp' => esc_html__('Fade In Up', 'dipi-divi-pixel'),
                'fadeInDown' => esc_html__('Fade In Down', 'dipi-divi-pixel'),
                'zoomIn' => esc_html__('Grow', 'dipi-divi-pixel'),
                'bounceIn' => esc_html__('Bounce In', 'dipi-divi-pixel'),
                'bounceInLeft' => esc_html__('Bounce In Left', 'dipi-divi-pixel'),
                'bounceInRight' => esc_html__('Bounce In Right', 'dipi-divi-pixel'),
                'bounceInUp' => esc_html__('Boune In Up', 'dipi-divi-pixel'),
                'bounceInDown' => esc_html__('BouneIn Down', 'dipi-divi-pixel'),
                'flipInX' => esc_html__('FlipInX', 'dipi-divi-pixel'),
                'flipInY' => esc_html__('FlipInY', 'dipi-divi-pixel'),
                'jackInTheBox' => esc_html__('JackInThe Box', 'dipi-divi-pixel'),
                'rotateIn' => esc_html__('RotateIn', 'dipi-divi-pixel'),
                'rotateInDownLeft' => esc_html__('RotateInDownLeft', 'dipi-divi-pixel'),
                'rotateInUpLeft' => esc_html__('RotateInUpLeft', 'dipi-divi-pixel'),
                'rotateInDownRight' => esc_html__('RotateInDownRight', 'dipi-divi-pixel'),
                'rotateInUpRight' => esc_html__('RotateInUpRight', 'dipi-divi-pixel'),
            ],
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'caption',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];
        $fields['caption_delay'] = [
            'label' => esc_html__('Interval Delay', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '400ms',
            'default_on_front' => '400ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '3000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'caption',
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];

        $fields['caption_speed'] = [
            'label' => esc_html__('Speed', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'default' => '600ms',
            'default_on_front' => '600ms',
            'default_unit' => 'ms',
            'range_settings' => [
                'min' => '0',
                'max' => '2000',
                'step' => '100',
            ],
            'validate_unit' => true,
            'toggle_slug' => 'overlay_animation',
            'sub_toggle' => 'caption',
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];
       

        $fields["show_overflow"] = [
            'label' => esc_html__('Show Overflow', 'dipi-divi-pixel'),
            'description' => esc_html__('Hide or show the overflow of the module. Useful if you want to use box shadows on the images but be aware that too much gutter can cause weird effects on mobiles due to the extra margin of the module. In this case, you should set the overflow of the row or section to hidden.', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'layout',
            'toggle_slug' => 'grid',
            'tab_slug' => 'advanced',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('Off', 'dipi-divi-pixel'),
                'on' => esc_html__('On', 'dipi-divi-pixel'),
            ),
        ];

        $fields["overlay_bg_color"] = [
            'label' => esc_html__('Overlay Color', 'dipi-divi-pixel'),
            'type' => 'background-field',
            'base_name' => "overlay_bg",
            'context' => "overlay_bg",
            'custom_color' => true,
            'default' => 'transparent',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'overlay',
            'hover' => 'tabs',
            'mobile_options' => true,
            'responsive' => true,
            'background_fields' => array_merge(

                ET_Builder_Element::generate_background_options(
                    'overlay_bg',
                    'gradient',
                    "advanced",
                    "overlay",
                    "overlay_bg_gradient"
                ),

                ET_Builder_Element::generate_background_options(
                    "overlay_bg",
                    "color",
                    "advanced",
                    "overlay",
                    "overlay_bg_color"
                )
            ),
            'show_if' => [
                'use_overlay' => 'on',
            ],
        ];

        $fields['overlay_icon_color'] = [
            'label' => esc_html__(' Overlay Icon Color', 'dipi-divi-pixel'),
            'type' => 'color-alpha',
            'custom_color' => true,
            'tab_slug' => 'advanced',
            'hover' => 'tabs',
            'default' => '#ffffff',
            'show_if' => [
                'use_overlay' => 'on',
            ],
            'toggle_slug' => 'overlay',
            'description' => esc_html__('Color of the overlay icon. The overlay icon is centered horizontally and vertically over the image.', 'dipi-divi-pixel'),
        ];
        $fields['overlay_icon_use_circle'] = [
            'label' => esc_html__('Circle Icon', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'configuration',
            'options' => [
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'overlay',
            'description' => esc_html__('Here you can choose whether icon set above should display within a circle.', 'dipi-divi-pixel'),
            'default' => 'on',
            'show_if' => [
                'use_overlay' => 'on',
            ],
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];
        $fields['overlay_icon_circle_color'] = [
            'label' => esc_html__('Circle Color', 'dipi-divi-pixel'),
            'type' => 'color-alpha',
            'description' => esc_html__('Here you can define a custom color for the icon circle.', 'dipi-divi-pixel'),
            'show_if' => [
                'use_overlay' => 'on',
                'overlay_icon_use_circle' => 'on',
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'overlay',
            'hover' => 'tabs',
            'sticky' => true,
            'default' => 'rgba(255,255,255,0.22)',
            '' => 'rgba(21,2,42,0.5)',
        ];
        $fields['overlay_icon_circle_padding'] = [
            'label' => __('Circle Icon Padding', 'et_builder'),
            'type' => 'custom_margin',
            'description' => __('Set Padding of Overlay Icon.', 'et_builder'),
            'tab_slug' => 'advanced',
            'toggle_slug' => 'overlay',
            'default' => '20px|20px|20px|20px',
            'mobile_options' => true,
        ];
        $fields['overlay_icon_use_circle_border'] = [
            'label' => esc_html__('Show Circle Border', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'layout',
            'options' => [
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ],
            'description' => esc_html__('Here you can choose whether if the icon circle border should display.', 'dipi-divi-pixel'),
            'show_if' => [
                'use_overlay' => 'on',
                'overlay_icon_use_circle' => 'on',
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'overlay',
            'default_on_front' => 'off',
            'computed_affects' => array(
                '__filterable_gallery',
            ),
        ];
        $fields['overlay_icon_circle_border_color'] = [
            'default' => $et_accent_color,
            'label' => esc_html__('Circle Border Color', 'dipi-divi-pixel'),
            'type' => 'color-alpha',
            'description' => esc_html__('Here you can define a custom color for the icon circle border.', 'dipi-divi-pixel'),
            'show_if' => array(
                'use_overlay' => 'on',
                'overlay_icon_use_circle_border' => 'on',
            ),
            'tab_slug' => 'advanced',
            'toggle_slug' => 'overlay',
            'hover' => 'tabs',
            'sticky' => true,
            'default' => '#000',
        ];
        $fields['overlay_icon_use_icon_font_size'] = [
            'label' => esc_html__('Use Icon Font Size', 'dipi-divi-pixel'),
            'description' => esc_html__('If you would like to control the size of the icon, you must first enable this option.', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'font_option',
            'options' => [
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ],
            'show_if' => [
                'use_overlay' => 'on',
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'overlay',
            'default_on_front' => 'off',
        ];
        $fields['overlay_icon_font_size'] = [
            'label' => esc_html__('Icon Font Size', 'dipi-divi-pixel'),
            'description' => esc_html__('Control the size of the icon by increasing or decreasing the font size.', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'font_option',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'overlay',
            'default' => '18px',
            'default_unit' => 'px',
            'default_on_front' => '',
            'allowed_units' => array('%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'),
            'range_settings' => array(
                'min' => '1',
                'max' => '120',
                'step' => '1',
            ),
            'show_if' => [
                'use_overlay' => 'on',
                'overlay_icon_use_icon_font_size' => 'on',
            ],
            'mobile_options' => true,
            'hover' => 'tabs',
            'sticky' => true,
        ];
        $fields["sticky_filter_bar"] = [
            'label' => esc_html__('Sticky Filter bar', 'dipi-divi-pixel'),
            'type' => 'yes_no_button',
            'option_category' => 'basic_option',
            'default' => 'off',
            'options' => array(
                'off' => esc_html__('No', 'dipi-divi-pixel'),
                'on' => esc_html__('Yes', 'dipi-divi-pixel'),
            ),
            'mobile_options' => true,
            'tab_slug' => 'advanced',
            'toggle_slug'      => 'filter_bar',
        ];
        $fields['sticky_filter_bar_top'] = [
            'label' => esc_html__('Sticky Top Offset', 'dipi-divi-pixel'),
            'type' => 'range',
            'default' => '80px',
            'default_on_front' => '80px',
            'default_unit' => 'px',
            'range_settings' => [
                'min' => '0',
                'max' => '300',
                'step' => '10',
            ],
            'validate_unit' => true,
            'responsive' => true,
            'mobile_options' => true,
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar',
            'show_if'   => ['sticky_filter_bar' => 'on']
        ];

        $fields['space_tabs'] = [
            'label' => esc_html__('Space between Tabs', 'dipi-divi-pixel'),
            'type' => 'range',
            'default' => '20px',
            'default_on_front' => '20px',
            'default_unit' => 'px',
            'range_settings' => [
                'min' => '0',
                'max' => '300',
                'step' => '10',
            ],
            'validate_unit' => true,
            'responsive' => true,
            'mobile_options' => true,
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar',
        ];
        $fields['space_tab_number'] = [
            'label' => esc_html__('Space between Label and Number', 'dipi-divi-pixel'),
            'type' => 'range',
            'default' => '0.5em',
            'default_on_front' => '0.5em',
            'default_unit' => 'em',
            'range_settings' => [
                'min' => '0',
                'max' => '5',
                'step' => '0.1',
            ],
            'validate_unit' => true,
            'responsive' => true,
            'mobile_options' => true,
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar',
            'show_if'   => array (
                'show_num_of_elements' => 'on'
            )
        ];
        $fields['pagination_btn_margin'] = [
            'label' => __('Margin', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'normal',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
            'show_if' => [
                'pagination_type' => 'numbered_pagination'
            ]
        ];
        $fields['pagination_btn_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'normal',
            'default' => '5px|12px|5px|12px',
            'mobile_options' => true,
            'show_if' => [
                'pagination_type' => 'numbered_pagination'
            ]
        ];
        $fields['pagination_active_btn_margin'] = [
            'label' => __('Margin', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'active',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
            'show_if' => [
                'pagination_type' => 'numbered_pagination'
            ]
        ];
        $fields['pagination_active_btn_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'active',
            'default' => '5px|12px|5px|12px',
            'mobile_options' => true,
            'show_if' => [
                'pagination_type' => 'numbered_pagination'
            ]
        ];
        $fields['load_more_margin'] = [
            'label' => __('Margin', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'load_more',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
            'show_if' => [
                'pagination_type' => ['load_more','infinite_scroll']
            ]
        ];
        $fields['load_more_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'load_more',
            'default' => '5px|12px|5px|12px',
            'mobile_options' => true,
            'show_if' => [
                'pagination_type' => ['load_more','infinite_scroll']
            ]
        ];
        $fields["load_more_alignment"] = [
            'label' => esc_html__('Alignment', 'dipi-divi-pixel'),
            'default' => 'center',
            'type' => 'text_align',
            'options_icon' => 'module_align',
            'options' => [
                'left' => esc_html__('Left', 'dipi-divi-pixel'),
                'center' => esc_html__('Center', 'dipi-divi-pixel'),
                'right' => esc_html__('Right', 'dipi-divi-pixel'),
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'load_more',
            'show_if' => [
                'pagination_type' => ['load_more','infinite_scroll']
            ]
        ];
        $fields['pagination_btn_bg_color'] = [
            'label'          => esc_html__( 'Background Color', 'dipi-divi-pixel' ),
            'type'           => 'color-alpha',
            'default'        => 'transparent',
            'tab_slug'       => 'advanced',
            'hover'          => 'tabs',
            'mobile_options' => true,
            'sticky'         => true,
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'normal',
            'show_if' => [
                'pagination_type' => 'numbered_pagination'
            ]
        ];
        $fields['pagination_active_btn_bg_color'] = [
            'label'          => esc_html__( 'Background Color', 'dipi-divi-pixel' ),
            'type'           => 'color-alpha',
            'default'        => '#ff4200',
            'tab_slug'       => 'advanced',
            'hover'          => 'tabs',
            'mobile_options' => true,
            'sticky'         => true,
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'active',
            'show_if' => [
                'pagination_type' => 'numbered_pagination'
            ]
        ];
        $fields['load_more_bg_color'] = [
            'label'          => esc_html__( 'Background Color', 'dipi-divi-pixel' ),
            'type'           => 'color-alpha',
            'default'        => 'transparent',
            'tab_slug'       => 'advanced',
            'hover'          => 'tabs',
            'mobile_options' => true,
            'sticky'         => true,
            'toggle_slug' => 'load_more',
            'sub_toggle' => 'active',
            'show_if' => [
                'pagination_type' => ['load_more','infinite_scroll']
            ]
        ];
        $fields['filter_bar_margin'] = [
            'label' => __('Margin', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
        ];
        $fields['filter_bar_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
        ];
        $fields['filter_bar_background_color'] = [
            'label'          => esc_html__( 'Background Color', 'dipi-divi-pixel' ),
            'type'           => 'color-alpha',
            'default'        => 'transparent',
            'tab_slug'       => 'advanced',
            'hover'          => 'tabs',
            'mobile_options' => true,
            'sticky'         => true,
            'toggle_slug'  => 'filter_bar',
        ];

        $fields['overlay_padding'] = [
            'label' => __('Overlay Padding', 'et_builder'),
            'type' => 'custom_margin',
            'description' => __('Set Padding of Overlay.', 'et_builder'),
            'tab_slug' => 'advanced',
            'toggle_slug' => 'margin_padding',
            'default' => '30px|30px|30px|30px',
            'mobile_options' => true,
        ];
        $fields = array_merge(
            $fields,
            $this->generate_background_options(
                "overlay_bg",
                'skip',
                "advanced",
                "image",
                "overlay_bg_gradient"
            )
        );
        $fields = array_merge(
            $fields,
            $this->generate_background_options(
                "overlay_bg",
                'skip',
                "advanced",
                "image",
                "overlay_bg_color"
            )
        );
       
        $fields['filter_bar_item_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'normal',
            'default' => '5px|10px|5px|10px',
        ];
        $fields['filter_bar_item_padding_active'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'active',
            'default' => '5px|15px|5px|15px',
            'mobile_options' => true,
        ];

        $fields['filter_bar_item_background_color'] = [
            'label'          => esc_html__( 'Background Color', 'dipi-divi-pixel' ),
            'type'           => 'color-alpha',
            'default'        => 'transparent',
            'hover'          => 'tabs',
            'mobile_options' => true,
            'sticky'         => true,
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'normal',
        ];
        $fields['filter_bar_item_background_color_active'] = [
            'label'          => esc_html__( 'Background Color', 'dipi-divi-pixel' ),
            'type'           => 'color-alpha',
            'default'        => 'transparent',
            'hover'          => 'tabs',
            'mobile_options' => true,
            'sticky'         => true,
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'active',
        ];
        $fields['filter_bar_item_width'] = [
            'label' => esc_html__('Width', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'allowed_units' => array('%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'),
            'range_settings' => [
                'min' => '0',
                'max' => '100',
                'step' => '10',
            ],
            'default_unit' => 'px',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'normal',
            'mobile_options' => true,
        ];
        $fields['filter_bar_item_width_active'] = [
            'label' => esc_html__('Width', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'allowed_units' => array('%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'),
            'range_settings' => [
                'min' => '0',
                'max' => '100',
                'step' => '10',
            ],
            'default_unit' => 'px',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'active',
            'mobile_options' => true,
        ];
        $fields['filter_bar_item_height'] = [
            'label' => esc_html__('Height', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'allowed_units' => array('%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'),
            'range_settings' => [
                'min' => '0',
                'max' => '100',
                'step' => '10',
            ],
            'default_unit' => 'px',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'normal',
            'mobile_options' => true
        ];
        $fields['filter_bar_item_height_active'] = [
            'label' => esc_html__('Height', 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'configuration',
            'allowed_units' => array('%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'),
            'range_settings' => [
                'min' => '0',
                'max' => '100',
                'step' => '10',
            ],
            'default_unit' => 'px',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'active',
            'mobile_options' => true
        ];
       

        $fields['grid_margin'] = [
            'label' => __('Margin', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
        ];
        $fields['grid_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
        ];
        $fields['grid_background_color'] = [
            'label'          => esc_html__( 'Background Color', 'dipi-divi-pixel' ),
            'type'           => 'color-alpha',
            'default'        => 'transparent',
            'tab_slug'       => 'advanced',
            'hover'          => 'tabs',
            'mobile_options' => true,
            'sticky'         => true,
            'toggle_slug'  => 'grid',
        ];
        
        $fields['grid_item_background_color'] = [
            'label'          => esc_html__( 'Background Color', 'dipi-divi-pixel' ),
            'type'           => 'color-alpha',
            'default'        => 'transparent',
            'tab_slug'       => 'advanced',
            'hover'          => 'tabs',
            'mobile_options' => true,
            'sticky'         => true,
            'toggle_slug'  => 'grid_items',
        ];
        $fields['grid_item_title_margin'] = [
            'label' => __('Margin', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'title',
            'default' => '10px|10px|10px|10px',
            'mobile_options' => true,
        ];
        $fields['grid_item_title_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'title',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
        ];
        $fields['grid_item_caption_margin'] = [
            'label' => __('Margin', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'caption',
            'default' => '10px|10px|10px|10px',
            'mobile_options' => true,
        ];
        $fields['grid_item_caption_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'caption',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
        ];
        $fields['grid_item_category_margin'] = [
            'label' => __('Margin', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'category',
            'default' => '10px|10px|10px|10px',
            'mobile_options' => true,
        ];
        $fields['grid_item_category_padding'] = [
            'label' => __('Padding', 'et_builder'),
            'type' => 'custom_margin',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'category',
            'default' => '0px|0px|0px|0px',
            'mobile_options' => true,
        ];        
        $fields["__filterable_gallery"] = [
            'type' => 'computed',
            'computed_callback' => array('DIPI_FilterableGallery', 'render_filterable_gallery'),
            'computed_depends_on' => array(
                'include_term_ids',
                'pagination_type',
                'image_count',
                'images_per_page',
                'prev_btn_text',
                'next_btn_text',
                'load_more_text',
                'show_all_filter',
                'all_filter_label',
                'show_num_of_elements',
                'gallery_orderby',
                'grid_layout',
                'use_media_link',
                'show_lightbox_link_icon',
                'show_lightbox',
                'title_in_lightbox',
                'caption_in_lightbox',
                'icon_in_overlay',
                'title_in_overlay',
                'caption_in_overlay',
                'overlay_icon_use_circle',
                'overlay_icon_use_circle_border',
                'gallery_orderby',
                'hover_icon',
                'use_overlay',
                'icon_animation',
                'title_animation',
                'caption_animation',
                'image_animation',
                'grid_animation',
                'grid_animation_delay',
                'grid_animation_speed',
                'show_img_caption',
                'show_img_title',
                'show_img_category',
                'grid_item_title_level',
                'header_level'
            ),
        ];
        return $fields;
    }

    public function get_advanced_fields_config()
    {
        $filter_bar_selector = "%%order_class%% .dipi-filter-bar";
        $filter_bar_item_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item";
        $filter_bar_item_hover_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item:hover";
        $filter_bar_item_active_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item.active";
        $filter_bar_item_active_hover_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item.active:hover";
        $pagination_btn_normal_selector = "%%order_class%% .dipi-pagination .dipi-pagination-btn";
        $pagination_btn_normal_hover_selector = "%%order_class%% .dipi-pagination .dipi-pagination-btn:hover";
        $pagination_btn_active_selector = "%%order_class%% .dipi-pagination .dipi-pagination-btn.active";
        $pagination_btn_active_hover_selector = "%%order_class%% .dipi-pagination .dipi-pagination-btn.active:hover";
        $load_more_selector = "%%order_class%% .dipi-loadmore-btn";
        $load_more_hover_selector = "%%order_class%% .dipi-loadmore-btn:hover";
        $advanced_fields = [];

        $advanced_fields["text"] = false;
        $advanced_fields["text_shadow"] = false;
        $advanced_fields["fonts"]["header"] = [
            'label' => esc_html__('Title', 'dipi-divi-pixel'),
            'css' => [
                'main' => "%%order_class%% .dipi-filterable-gallery-title",
                'hover' => "%%order_class%%:hover .dipi-filterable-gallery-title",
            ],
            'header_level' => [
                'default' => 'h4',
            ],
            'hide_text_align' => true,
            'toggle_slug' => 'overlay_text_group',
            'sub_toggle' => 'title',
            'computed_affects' => ['__filterable_gallery'],
        ];
        $advanced_fields["fonts"]["caption"] = [
            'label' => esc_html__('Caption', 'dipi-divi-pixel'),
            'css' => [
                'main' => "%%order_class%% .dipi-filterable-gallery-caption",
                'hover' => "%%order_class%%:hover .dipi-filterable-gallery-caption",
            ],
            'hide_text_align' => true,
            'toggle_slug' => 'overlay_text_group',
            'sub_toggle' => 'caption',
        ];
        $advanced_fields["fonts"]["pagination_btn_normal"] = [
            'css' => [
                'main' => $pagination_btn_normal_selector,
                'hover' => $pagination_btn_normal_hover_selector,
            ],
            /*'hide_text_align' => false,*/
            'tab_slug' => 'advanced',
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'normal',
            'show_if' => [
                'pagination_type' => ['numbered_pagination']
            ]
        ];
        $advanced_fields["fonts"]["pagination_btn_active"] = [
            'css' => [
                'main' => $pagination_btn_active_selector,
                'hover' => $pagination_btn_active_hover_selector,
            ],
            'hide_text_align' => true,
            'tab_slug' => 'advanced',
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'active',
            'show_if' => [
                'pagination_type' => ['numbered_pagination']
            ]
        ];
        $advanced_fields["fonts"]["load_more"] = [
            'css' => [
                'main' => $load_more_selector,
                'hover' => $load_more_hover_selector,
            ],
            'hide_text_align' => true,
            'tab_slug' => 'advanced',
            'toggle_slug' => 'load_more',
        ];
        $advanced_fields["fonts"]["filter_bar_normal"] = [
            'css' => [
                'main' => "%%order_class%% .dipi-filter-bar-item",
                'hover' => "%%order_class%% .dipi-filter-bar-item:hover",
            ],
            /*'hide_text_align' => false,*/
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'normal',
        ];
        $advanced_fields["fonts"]["filter_bar_active"] = [
            'css' => [
                'main' => "%%order_class%% .dipi-filter-bar-item.active",
                'hover' => "%%order_class%% .dipi-filter-bar-item.active:hover",
            ],
            /*'hide_text_align' => false,*/
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'active',
        ];

        $advanced_fields["fonts"]["grid_item_title"] = [
            'label' => esc_html__('Title', 'dipi-divi-pixel'),
            'css' => [
                'main' => "%%order_class%% .dipi-grid-item-title",
                'hover' => "%%order_class%% .dipi-filter-bar-item:hover .dipi-grid-item-title",
            ],
            'header_level' => [
                'default' => 'h4',
            ],
            /*'hide_text_align' => true,*/
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'title',
            'computed_affects' => ['__filterable_gallery'],
        ];
        $advanced_fields["fonts"]["grid_item_caption"] = [
            'label' => esc_html__('Caption', 'dipi-divi-pixel'),
            'css' => [
                'main' => "%%order_class%% .dipi-grid-item-caption",
                'hover' => "%%order_class%% .dipi-filter-bar-item:hover .dipi-grid-item-caption",
            ],
            /*'hide_text_align' => true,*/
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'caption',
        ];
        $advanced_fields["fonts"]["grid_item_category"] = [
            'label' => esc_html__('Category', 'dipi-divi-pixel'),
            'css' => [
                'main' => "%%order_class%% .dipi-grid-item-category",
                'hover' => "%%order_class%% .dipi-filter-bar-item:hover .dipi-grid-item-category",
            ],
            /*'hide_text_align' => true,*/
            'toggle_slug' => 'grid_item_text',
            'sub_toggle' => 'category',
        ];        
        $advanced_fields["borders"]["default"] = [
            'css' => [
                'main' => [
                    'border_radii' => "%%order_class%%",
                    'border_styles' => "%%order_class%%",
                ],
            ],
        ];
        $advanced_fields["borders"]["pagination_btn_normal"] = [
            'css' => [
                'main' => [
                    'border_radii' => $pagination_btn_normal_selector,
                    'border_styles' => $pagination_btn_normal_selector,
                ],
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'normal',
        ];
        $advanced_fields["borders"]["pagination_btn_active"] = [
            'css' => [
                'main' => [
                    'border_radii' => $pagination_btn_active_selector,
                    'border_styles' => $pagination_btn_active_selector,
                ],
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'active',
            'show_if' => [
                'pagination_type' => 'numbered_pagination'
            ]
        ];
        $advanced_fields["borders"]["load_more"] = [
            'css' => [
                'main' => [
                    'border_radii' => $load_more_selector,
                    'border_styles' => $load_more_selector,
                ],
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'load_more',
            'show_if' => [
                'pagination_type' => ['load_more','infinite_scroll']
            ]
        ];
        $advanced_fields["borders"]["filter_bar"] = [
            'css' => [
                'main' => [
                    'border_radii' => "%%order_class%% .dipi-filter-bar",
                    'border_styles' => "%%order_class%% .dipi-filter-bar",
                ],
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar',
        ];
        $advanced_fields["borders"]["filter_bar_item"] = [
            'css' => [
                'main' => [
                    'border_radii' => "%%order_class%% .dipi-filter-bar-item",
                    'border_styles' => "%%order_class%% .dipi-filter-bar-item",
                ],
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'normal',
        ];

        $advanced_fields["borders"]["filter_bar_item_active"] = [
            'css' => [
                'main' => [
                    'border_radii' => "%%order_class%% .dipi-filter-bar-item.active",
                    'border_styles' => "%%order_class%% .dipi-filter-bar-item.active",
                ],
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'active',
        ];
        $advanced_fields["borders"]["grid"] = [
            'css' => [
                'main' => [
                    'border_radii' => "%%order_class%% .dipi-filtered-gallery-container",
                    'border_styles' => "%%order_class%% .dipi-filtered-gallery-container",
                ],
            ],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'grid',
        ];
        $advanced_fields["borders"]["grid_item"] = [
            'label_prefix' => esc_html__('Grid Item', 'dipi-divi-pixel'),
            'toggle_slug' => 'grid_items',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => [
                    'border_radii' => "%%order_class%% .grid .grid-item",
                    'border_styles' => "%%order_class%% .grid .grid-item",
                ],
            ],
        ];
        $advanced_fields["box_shadow"]["pagination_normal"] = [
            'label' => esc_html__('Box Shadow', 'dipi-divi-pixel'),
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'normal',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => $pagination_btn_normal_selector,
                'hover' => $pagination_btn_normal_hover_selector,
            ],
        ];
        $advanced_fields["box_shadow"]["pagination_btn_active"] = [
            'label' => esc_html__('Box Shadow', 'dipi-divi-pixel'),
            'toggle_slug' => 'pagination_btn',
            'sub_toggle' => 'active',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => $pagination_btn_active_selector,
                'hover' => $pagination_btn_active_hover_selector,
            ],
        ];
        $advanced_fields["box_shadow"]["load_more"] = [
            'label' => esc_html__('Box Shadow', 'dipi-divi-pixel'),
            'toggle_slug' => 'load_more',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => $load_more_selector,
                'hover' => $load_more_hover_selector,
            ],
            'show_if' => [
                'pagination_type' => ['load_more','infinite_scroll']
            ]
        ];
        $advanced_fields["box_shadow"]["filter_bar"] = [
            'label' => esc_html__('Filter Bar Box Shadow', 'dipi-divi-pixel'),
            'toggle_slug' => 'filter_bar',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => $filter_bar_selector,
            ],
        ];
        $advanced_fields["box_shadow"]["filter_bar_item"] = [
            'label' => esc_html__('Filter Bar Item Box Shadow', 'dipi-divi-pixel'),
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'normal',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => $filter_bar_item_selector,
                'hover' => $filter_bar_item_hover_selector
            ],
        ];
        $advanced_fields["box_shadow"]["filter_bar_item_active"] = [
            'label' => esc_html__('Filter Bar Item Box Shadow', 'dipi-divi-pixel'),
            'toggle_slug' => 'filter_bar_items',
            'sub_toggle' => 'active',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => $filter_bar_item_active_selector,
                'hover' => $filter_bar_item_active_hover_selector
            ],
        ];
        
        $advanced_fields["box_shadow"]["grid"] = [
            'label' => esc_html__('Grid Box Shadow', 'dipi-divi-pixel'),
            'toggle_slug' => 'grid',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => "%%order_class%%  .dipi-filtered-gallery-container",
            ],
        ];
        $advanced_fields["box_shadow"]["images"] = [
            'label' => esc_html__('Grid Item Box Shadow', 'dipi-divi-pixel'),
            'toggle_slug' => 'grid_items',
            'tab_slug' => 'advanced',
            'css' => [
                'main' => "%%order_class%% .grid .grid-item",
            ],
        ];

        $advanced_fields['margin_padding'] = [
            'css' => [
                'important' => 'all',
            ],
        ];

        return $advanced_fields;
    }

    public function dipi_get_image_sizes()
    {
        global $_wp_additional_image_sizes;
        $sizes = array();
        $get_intermediate_image_sizes = get_intermediate_image_sizes();
        foreach ($get_intermediate_image_sizes as $_size) {
            if (in_array($_size, array('thumbnail', 'medium', 'large'))) {
                $sizes[$_size]['width'] = get_option($_size . '_size_w');
                $sizes[$_size]['height'] = get_option($_size . '_size_h');
                $sizes[$_size]['crop'] = (bool) get_option($_size . '_crop');
            } elseif (isset($_wp_additional_image_sizes[$_size])) {
                $sizes[$_size] = array(
                    'width' => $_wp_additional_image_sizes[$_size]['width'],
                    'height' => $_wp_additional_image_sizes[$_size]['height'],
                    'crop' => $_wp_additional_image_sizes[$_size]['crop'],
                );
            }
        }

        $image_sizes = array(
            'full' => esc_html__('Full Size', 'dipi-divi-pixel'),
        );
        foreach ($sizes as $sizeKey => $sizeValue) {
            $image_sizes[$sizeKey] = sprintf(
                '%1$s (%2$s x %3$s,%4$s cropped)',
                $sizeKey,
                $sizeValue["width"],
                $sizeValue["height"],
                ($sizeValue["crop"] == false ? ' not' : '')

            );
        }

        return $image_sizes;
    }

    private static function get_attachment_image($attachment_id, $image_size, $fallback_url)
    {
        $attachment = wp_get_attachment_image_src($attachment_id, $image_size);
        if ($attachment) {
            return $attachment[0];
        } else {
            return $fallback_url;
        }
    }
    public static function render_filter_bar($args = array(), $conditional_tags = array(), $current_page = array()) {
        $filter_bar_html = '';
        $defaults = [
        ];
        $args = wp_parse_args($args, $defaults);
        $show_all_filter = $args['show_all_filter'];
        $all_filter_label = $args['all_filter_label'];
        $include_term_ids = $args['include_term_ids'];
        $show_num_of_elements = $args['show_num_of_elements'];
        if (!$include_term_ids) {
            return sprintf('<div class="alert" data-items-count="0">
                    Please Select <strong>\'Included Divi Pixel Category\'</strong> to show in filter bar.
                    <br>
                    If you still didn\'t add terms of <strong>\'Divi Pixel Category\'</strong>,
                    you can add new terms and assign in <a href="/wp-admin/edit-tags.php?taxonomy=dipi_media_category&post_type=attachment" target="_blank"><strong>Media Library</strong></a>.
                </div>');
        }
        $dipi_include_terms = $include_term_ids 
            ? array_map(function ($term_id)
                {
                    return  get_term( $term_id );
                }, explode(",", $include_term_ids)) 
            : [];
        if ($show_all_filter == 'on') {
            $dipi_include_term_all = new stdClass();
            $dipi_include_term_all->name = $all_filter_label;
            array_unshift($dipi_include_terms, $dipi_include_term_all);
        }
        foreach($dipi_include_terms as $index=>$dipi_include_term){
            $media = '';
            $extra_class = '';
            if(!empty($dipi_include_term->name) || !empty($dipi_include_term->description)){
                $name_html = sprintf('<div class="dipi-filter-bar-name">%1$s</div>', !empty($dipi_include_term->name) ? $dipi_include_term->name : '');
                $desc_html = sprintf('<div class="dipi-filter-bar-item-desc">%1$s</div>', !empty($dipi_include_term->description) ? $dipi_include_term->description : '');
            }
            $count_html = '';
            if ( $show_num_of_elements === 'on') {
                $query_images_args = [];
                $orderby = 'date';
                $tax_query = [];
                if ($show_all_filter == 'on' && $index == 0 ) {
                    $tax_query = [
                        [
                            'taxonomy' => 'dipi_media_category',
                            'field'    => 'id',
                            'terms'    => explode(",", $include_term_ids),
                        ]
                    ];
                } else {
                    $tax_query = [
                        [
                        'taxonomy' => 'dipi_media_category',
                        'field'    => 'slug',
                        'terms'    => $dipi_include_term->slug,
                        ]
                    ];
                }
                $query_images_args = array(
                    'post_type'      => 'attachment',
                    'post_mime_type' => 'image',
                    'post_status'    => 'inherit',
                    'posts_per_page' => - 1,
                    'tax_query'      => $tax_query,
                    'orderby'       => $orderby,
                    'fields' => 'ids',
                    'no_found_rows' => true,
                );
                $query_images = new WP_Query( $query_images_args );
                $post_count = $query_images->post_count;
                $count_html = sprintf('<div class="dipi-filter-bar-count">%1$s</div>', $query_images->post_count);
            }

            $filter_bar_html .=sprintf('
                <div class="dipi-filter-bar-item dipi-filter-bar-item-%3$s %5$s"
                    data-index="%3$s"
                    data-term="%4$s"
                >
                    <div class="dipi-filter-bar-item-title">
                        %1$s
                        %6$s
                    </div>
                    %2$s
                </div>
                ',
                $name_html, 
                $desc_html,
                $index,
                $dipi_include_term->name,
                $index === 0 ? 'active' : '', #5
                $count_html
            );
            
        }
        return sprintf(
            '<div class="dipi-filter-bar" data-items-count="%2$s">
                %1$s
            </div>
           ',
            $filter_bar_html,
            count($dipi_include_terms)
        );
    }
    public static function render_gallery($args = array(), $conditional_tags = array(), $current_page = array()) {
        $defaults = [
            'images' => '',
            'pagination_type'=>'none',
            'gallery_orderby' => '',
            'title_in_lightbox' => 'off',
            'caption_in_lightbox' => 'off',
            'icon_in_overlay' => 'off',
            'title_in_overlay' => 'off',
            'caption_in_overlay' => 'off',
            'use_media_link' => 'off',
            'use_overlay' => 'off',
            'hover_icon' => '',
            'image_size_desktop' => 'full',
            'image_size_tablet' => 'full',
            'image_size_phone' => 'full',
            'image_animation' => 'none',
            'grid_animation'=> 'none',
            'show_lightbox_link_icon' => 'off',
            'image_count' => '-1',
            'images_per_page'=>'10',
            'load_more_text' => 'Load More',
            'prev_btn_text' => 'Prev',
            'next_btn_text' => 'Next',
        ];
        $args = wp_parse_args($args, $defaults);
        $show_all_filter = $args['show_all_filter'];
        $all_filter_label = $args['all_filter_label'];
        $include_term_ids = $args['include_term_ids'];
        $grid_animation = $args['grid_animation'];
        $show_lightbox_link_icon = $args['show_lightbox_link_icon'];
        $use_overlay = $args['use_overlay'];
        $use_overlay_values = et_pb_responsive_options()->get_property_values($args, 'use_overlay');
        $use_overlay_tablet = isset($use_overlay_values['tablet']) ? $use_overlay_values['tablet'] : '';
        $use_overlay_phone = isset($use_overlay_values['phone']) ? $use_overlay_values['phone'] : '';
        $grid_layout = $args['grid_layout'];
        $use_media_link = $args['use_media_link'];
        $icon_animation = $args['icon_animation'];
        $title_animation = $args['title_animation'];
        $caption_animation = $args['caption_animation'];

        $show_lightbox = $args['show_lightbox'];
        $show_lightbox_values = et_pb_responsive_options()->get_property_values($args, 'show_lightbox');
        $show_lightbox_tablet = isset($show_lightbox_values['tablet']) && !empty($show_lightbox_values['tablet']) ? $show_lightbox_values['tablet'] : $show_lightbox;
        $show_lightbox_phone = isset($show_lightbox_values['phone']) && !empty($show_lightbox_values['phone']) ? $show_lightbox_values['phone'] : $show_lightbox_tablet;        
        $gallery_orderby = $args['gallery_orderby'];
        $overlay_icon_use_circle = $args['overlay_icon_use_circle'];
        $overlay_icon_use_circle_border = $args['overlay_icon_use_circle_border'];
        $icon_in_overlay = $args["icon_in_overlay"];
        $hover_icon = $args['hover_icon'];
        $title_in_overlay = $args["title_in_overlay"];
        $caption_in_overlay = $args["caption_in_overlay"];
        $show_img_category = $args["show_img_category"];
        $show_img_title = $args["show_img_title"];
        $show_img_caption = $args["show_img_caption"];
        $title_in_lightbox = $args["title_in_lightbox"];
        $caption_in_lightbox = $args["caption_in_lightbox"];
        $image_animation = $args["image_animation"];
        $fix_lazy = $args["fix_lazy"];
        $pagination_type = $args['pagination_type'];
        $image_count = $args['image_count'];
        $image_count_tablet = $args['image_count_tablet'];
        $image_count_phone = $args['image_count_phone'];
        $image_count_last_edited = $args['image_count_last_edited'];
        $image_count_responsive_active = et_pb_get_responsive_status($image_count_last_edited);
        $images_per_page = $args['images_per_page'];
        $load_more_text = $args['load_more_text'];
        $prev_btn_text = $args['prev_btn_text'];
        $next_btn_text = $args['next_btn_text'];
        
        $config = [
            'grid_layout' => $grid_layout,
        ];

        $dipi_include_terms = $include_term_ids 
        ? array_map(function ($term_id)
            {
                return  get_term( $term_id );
            }, explode(",", $include_term_ids)) 
        : [];
        
        if ($show_all_filter == 'on') {
            $dipi_include_term_all = new stdClass();
            $dipi_include_term_all->name = $all_filter_label;
            array_unshift($dipi_include_terms, $dipi_include_term_all);
        }
       

        $show_overlay_classes = ($use_overlay === 'on') ? 'show_overlay' : 'hide_overlay';
        if (!empty($use_overlay_tablet)) {
            $show_overlay_classes .= ($use_overlay_tablet === 'on') ? ' show_overlay_tablet' : ' hide_overlay_tablet';
        }
        if (!empty($use_overlay_phone)) {
            $show_overlay_classes .= ($use_overlay_phone === 'on') ? ' show_overlay_phone' : ' hide_overlay_phone';
        }


        $show_lightboxclasses = "";
        $use_media_link_class = "";
        if ($use_media_link  === "on" ) {
            if ($show_lightbox_link_icon === 'on') {
                $show_lightboxclasses = ($show_lightbox === 'on') ? 'show_lightbox' : 'hide_lightbox';
                if (!empty($show_lightbox_tablet)) {
                    $show_lightboxclasses .= ($show_lightbox_tablet === 'on') ? ' show_lightbox_tablet' : ' hide_lightbox_tablet';
                }
                if (!empty($show_lightbox_phone)) {
                    $show_lightboxclasses .= ($show_lightbox_phone === 'on') ? ' show_lightbox_phone' : ' hide_lightbox_phone';
                }
            } else {
                $show_lightboxclasses = "hide_lightbox";
            }
            $use_media_link_class ='use_media_link';
        } else {
            $show_lightboxclasses = ($show_lightbox === 'on') ? 'show_lightbox' : 'hide_lightbox';
            if (!empty($show_lightbox_tablet)) {
                $show_lightboxclasses .= ($show_lightbox_tablet === 'on') ? ' show_lightbox_tablet' : ' hide_lightbox_tablet';
            }
            if (!empty($show_lightbox_phone)) {
                $show_lightboxclasses .= ($show_lightbox_phone === 'on') ? ' show_lightbox_phone' : ' hide_lightbox_phone';
            }
        }

    

        $gallery_html = '';
        $pagination_pages = '';
        foreach($dipi_include_terms as $index=>$dipi_include_term){
            $items = [
                '<div class="grid-sizer"></div>',
                '<div class="gutter-sizer"></div>',
            ];
            $query_images_args = [];
            $orderby = 'date';
            $tax_query = [];
            if ($show_all_filter == 'on' && $index == 0 ) {
                $tax_query = [
                    [
                        'taxonomy' => 'dipi_media_category',
                        'field'    => 'id',
                        'terms'    => explode(",", $include_term_ids),
                    ]
                ];
            } else {
                $tax_query = [
                    [
                    'taxonomy' => 'dipi_media_category',
                    'field'    => 'slug',
                    'terms'    => $dipi_include_term->slug,
                    ]
                ];
            }
            $query_images_args = array(
                'post_type'      => 'attachment',
                'post_mime_type' => 'image',
                'post_status'    => 'inherit',
                'posts_per_page' => - 1,
                'tax_query'      => $tax_query,
                'orderby'       => $orderby
            );
            $query_images = new WP_Query( $query_images_args );
            $post_count = $query_images->post_count;
            $pages = (int)(($post_count  - 1) / $images_per_page) + 1;
            $pagination_html = '';
            $pagination_pages = '';
            if (($pagination_type === 'numbered_pagination') &&  ((int)$pages > 1)) {
                $prev_pagination_html = "<span class='dipi-pagination-btn' data-page='prev'>$prev_btn_text</span>";
                $next_pagination_html = "<span class='dipi-pagination-btn' data-page='next'>$next_btn_text</span>";
                $pagination_html .= $prev_pagination_html;
                for ($pageIndex = 1; $pageIndex <= $pages ; $pageIndex++) {
                    $one_pagination_html = sprintf(
                        '<span class="dipi-pagination-btn dipi-pagination-btn-%1$s %2$s" data-page="%1$s">
                            %1$s
                        </span>',
                        $pageIndex,
                        $pageIndex == 1 ? 'active' : ''
                    );
                    $pagination_html.= $one_pagination_html;
                }
                $pagination_html .= $next_pagination_html;
            }
            if ($pagination_type === 'load_more' && ((int)$pages > 1)) {
                $pagination_html =sprintf(
                    '<span class="dipi-loadmore-btn" data-page="1">
                        %1$s
                    </span>
                    ',
                    $load_more_text
                );
            }
            if ($pagination_type === 'infinite_scroll' && ((int)$pages > 1)) {
                $pagination_html =sprintf(
                    '<span class="dipi-loadmore-btn watch_end_of_grid" data-page="1">
                        %1$s
                    </span>
                    ',
                    $load_more_text
                );
            }
            $attachment_ids = array();
            foreach ( $query_images->posts as $image ) {
                $attachment_ids[] = $image->ID;
            }

            //$attachment_ids = explode(",", $args["images"]);
            if ('rand' === $gallery_orderby) {
                // echo "every day I'm shuffling";
                shuffle($attachment_ids);
            } else {
                // echo "no shuffle today";
            }

            $overlay_output = '';

            $overlay_icon_classes[] = 'dipi-filterable-gallery-icon';
            
            if ('on' === $overlay_icon_use_circle) {
                $overlay_icon_classes[] = 'dipi-filterable-gallery-icon-circle';
            }

            if ('on' === $overlay_icon_use_circle && 'on' === $overlay_icon_use_circle_border) {
                $overlay_icon_classes[] = 'dipi-filterable-gallery-icon-circle-border';
            }

            $data_icon = '' !== $hover_icon ? sprintf(
                ' data-icon="%1$s"',
                esc_attr(et_pb_process_font_icon($hover_icon)),
                esc_attr($hover_icon)
            ) : 'data-no-icon';

            if ($use_media_link === 'on') {
                $media_link_url_meta_field = self::$vendor_prefix === 'ds' ? 'ds_filterable_gallery_media_link_url' : 'media_link_url';
                $media_link_target_meta_field = self::$vendor_prefix === 'ds' ? 'ds_filterable_gallery_media_link_target' : 'media_link_target';
            }
            
            foreach ($attachment_ids as $img_index=>$attachment_id) {
                $attachment = wp_get_attachment_image_src($attachment_id, "full");
                if (!$attachment) {
                    continue;
                }

                $image = $attachment[0];
                $image_desktop_url = DIPI_FilterableGallery::get_attachment_image($attachment_id, $args['image_size_desktop'], $image);
                $image_tablet_url = DIPI_FilterableGallery::get_attachment_image($attachment_id, $args['image_size_tablet'], $image);
                $image_phone_url = DIPI_FilterableGallery::get_attachment_image($attachment_id, $args['image_size_phone'], $image);

                $image_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
                $image_title = get_the_title($attachment_id);

                $a_open_tag = '';
                $a_close_tag = '';
                $img_a_open_tag = '';
                $img_a_close_tag = '';
                $lightbox_and_link_icon_html = '';

                if ($use_media_link === 'on') {
                    $media_link_url = get_post_meta($attachment_id, $media_link_url_meta_field, true);
                    $media_link_target = get_post_meta($attachment_id, $media_link_target_meta_field, true);
                    $a_open_tag = sprintf('<a href="%1$s" target="%2$s">',
                        $media_link_url,
                        $media_link_target === '0' ? '_self' : '_blank'
                    );
                    $a_close_tag = '</a>';
                    if (!isset($media_link_target)) {
                        $media_link_target = '0';
                    }

                    if ($use_overlay === 'on'
                        && $show_lightbox_link_icon === 'on'
                    ) {
                        $lightbox_icon_html = sprintf(
                            '<div
                                class="et-pb-icon et_pb_inline_icon %1$s animated %2$s lightbox-icon"
                                href="%3$s"
                                data-icon="&#x55;"
                                data-anim="%2$s"
                            >
                            </div>
                            ',
                            implode(' ', $overlay_icon_classes),
                            $icon_animation,
                            $image
                        );

                        $link_icon_html = sprintf(
                            '<a href="%3$s" target="%4$s">
                                <div
                                    class="et-pb-icon et_pb_inline_icon %1$s animated %2$s link-icon"
                                    data-icon="&#xe02c;"
                                    data-anim="%2$s"
                                >
                                </div>
                            </a>',
                            implode(' ', $overlay_icon_classes),
                            $icon_animation,
                            $media_link_url,
                            $media_link_target === '0' ? '_self' : '_blank'
                        );

                        
                        $lightbox_and_link_icon_html =  sprintf(
                            '<div class="dipi_lightbox_link_icon">
                                %1$s
                                %2$s
                            </div>',
                            $lightbox_icon_html,
                            $link_icon_html
                        );
                    } else {
                        $img_a_open_tag = $a_open_tag;
                        $img_a_close_tag = $a_close_tag;
                    }
                }

                $icon_html = '';
                if ('on' === $icon_in_overlay) {
                    $icon_html = sprintf(
                        '<div class="et-pb-icon %1$s %3$s animated %4$s"%2$s data-anim="%4$s"></div>',
                        ('' !== $hover_icon ? ' et_pb_inline_icon' : ''),
                        'on' === $icon_in_overlay ? $data_icon : '',
                        implode(' ', $overlay_icon_classes),
                        $icon_animation
                    );
                }

                $name_html = '';
                $header_level = $args['header_level'];
                if ('on' === $title_in_overlay && '' !== $image_title) {
                    $name_html = sprintf(
                        '<%3$s
                            class="dipi-filterable-gallery-title animated %2$s"
                            data-anim="%2$s"
                        >
                            %1$s
                        </%3$s>',
                        $image_title,
                        $title_animation,
                        $header_level
                    );
                }

                $caption = wp_get_attachment_caption($attachment_id);
                $caption_html = '';
                if ('on' === $caption_in_overlay && '' !== $caption) {
                    $caption_html = sprintf(
                        '<div
                            class="dipi-filterable-gallery-caption animated %2$s"
                            data-anim="%2$s"
                        >
                            %1$s
                        </div>',
                        $caption,
                        $caption_animation
                    );
                }

                $overlay_output = sprintf(
                    '<span class="dipi_filterable_gallery_overlay background"></span>
                    <span class="dipi_filterable_gallery_overlay background-hover"></span>
                    <span class="dipi_filterable_gallery_overlay content" style="transition-duration: 0ms;">
                        %4$s
                        %1$s
                        %2$s
                        %3$s
                    </span>',
                    $icon_html,
                    $name_html,
                    $caption_html,
                    $lightbox_and_link_icon_html
                );

                $item_class = '';
                $data_page = '';
                $pagination_pages = '';
                if ($pagination_type === 'none') {
                    if ((int)$image_count >=0 && $img_index >= (int)$image_count) {
                        $item_class = 'hidden';
                    }
                    if ($image_count_responsive_active) {
                        if ((int)$image_count_tablet >= 0 && $img_index >=(int)$image_count_tablet) {
                            $item_class .= ' tablet_hidden';
                        } else {
                            $item_class .=" tablet_show";
                        }
                        if ((int)$image_count_phone >= 0 && $img_index >=(int)$image_count_phone) {
                            $item_class .= ' phone_hidden';
                        } else {
                            $item_class .=" phone_show";
                        }
                    }
                } else {
                    $page = (int)($img_index  / $images_per_page) + 1;
                    $item_class = 'page-'.$page;
                    if ( $page  !== 1) {
                        $item_class.=' hidden';
                    }
                    $data_page = 'data-page='.$page;
                    $pagination_pages='data-pages='.$pages;
                }
                //Grid Content
                $grid_item_category_html = '';
                if ('on' === $show_img_category &&  !empty($dipi_include_term->name)) {
                    $item_category_terms = get_the_terms($attachment_id, 'dipi_media_category');

                    $item_category_term_name = array_map(function ($term)
                    {
                        return $term->name;
                    }, $item_category_terms);
                    
                    $grid_item_category_html = sprintf(
                        '<span class="dipi-grid-item-category">
                            %1$s
                        </span>',
                        implode(", ", $item_category_term_name)
                    );
                }                
                $grid_item_title_html = '';
                $grid_item_title_level = $args['grid_item_title_level'];
                if ('on' === $show_img_title && '' !== $image_title) {
                    $grid_item_title_html = sprintf(
                        '<%2$s class="dipi-grid-item-title">
                            %1$s
                        </%2$s>',
                        $image_title,
                        esc_attr($grid_item_title_level)
                    );
                }

                $grid_item_caption_html = '';
                if ('on' === $show_img_caption && '' !== $caption) {
                    $grid_item_caption_html = sprintf(
                        '<div class="dipi-grid-item-caption">
                            %1$s
                        </div>',
                        $caption
                    );
                }

                $grid_content_html = sprintf(
                    '<div class="dipi-grid-item-content">
                        %1$s
                        %2$s
                        %3$s
                    </div>',
                    $grid_item_category_html,
                    $grid_item_title_html,
                    $grid_item_caption_html
                );

                $items[] = sprintf(
                    '<div class="grid-item %14$s" %17$s>
                        %10$s
                            <div class="img-container dipi-fg-animation dipi-fg-%12$s" href="%1$s"%4$s%5$s>
                                <img src="%1$s"
                                    alt="%2$s"
                                    srcset="%9$s 768w, %8$s 980w, %7$s 1024w"
                                    sizes="(max-width: 768px) 768px, (max-width: 980px) 980px, 1024px"
                                    loading="%18$s"
                                />
                                %6$s
                            </div>
                        %11$s
                        %15$s
                            %13$s
                        %16$s
                    </div>',
                    $image,
                    $image_alt,
                    $image_title,
                    'on' === $title_in_lightbox ? " data-title='$image_title'" : '',
                    'on' === $caption_in_lightbox ? " data-caption='" . htmlspecialchars(wp_get_attachment_caption($attachment_id)) . "'" : '', #5
                    et_core_esc_previously($overlay_output),
                    $image_desktop_url,
                    $image_tablet_url,
                    $image_phone_url,
                    $img_a_open_tag, #10
                    $img_a_close_tag,
                    $image_animation,
                    $grid_content_html,
                    $item_class,
                    $a_open_tag, #15
                    $a_close_tag,
                    $data_page,
                    $fix_lazy === 'on' ? esc_attr("eager") : esc_attr("lazy")
                );
            }
            if ($pagination_html) {
                $pagination_html = sprintf('
                    <div class="dipi-pagination" data-page-count="%2$s">
                        %1$s
                    </div>',
                    $pagination_html,
                    $pages
                );
            }
            $gallery_html.= sprintf('
                <div
                    class="
                        dipi-filtered-gallery-item
                        dipi-filtered-gallery-item-%6$s
                        %9$s
                        animated
                        %11$s
                    "
                    data-index="%6$s"
                    data-term="%7$s"
                    data-count="%8$s"
                    data-anim="%11$s"
                    %13$s
                >
                    <div class="grid %3$s %4$s %5$s animated %11$s" data-lazy="%2$s" data-config="%10$s">
                        %1$s
                    </div>
                    %12$s
                </div>',
                implode("", $items),
                $fix_lazy === 'on' ? esc_attr("true") : esc_attr("false"),
                $show_lightboxclasses,
                $show_overlay_classes,
                $use_media_link_class, #5
                $index,
                $dipi_include_term->name,
                $post_count,
                $index === 0 ? 'active' : '',
                esc_attr(htmlspecialchars(json_encode($config), ENT_QUOTES, 'UTF-8')), #10
                $grid_animation,
                $pagination_html,
                $pagination_pages
            );
        }
        return sprintf(
            '<div
                class="dipi-filtered-gallery-container"
                data-items-count="%2$s"
            >
                %1$s
             </div>',
            $gallery_html,
            count($dipi_include_terms)
        );
    }
    public static function render_filterable_gallery($args = array(), $conditional_tags = array(), $current_page = array())
    {
        $filter_bar_html = DIPI_FilterableGallery::render_filter_bar($args, $conditional_tags, $current_page);
        $gallery_html = DIPI_FilterableGallery::render_gallery($args, $conditional_tags, $current_page);
        
        return sprintf(
            '%1$s
            %2$s',
            $filter_bar_html,
            $gallery_html
        );
        
    }

    public function render($attrs, $content, $render_slug)
    {
        wp_enqueue_script('dipi_filterable_gallery_public');
        wp_enqueue_style('dipi_animate');
        wp_enqueue_style('magnific-popup');
        $this->dipi_apply_css($render_slug);
        $grid_layout = $this->props['grid_layout'];
        $sticky_filter_bar                            = $this->props['sticky_filter_bar'];
        $sticky_filter_bar_values                     = et_pb_responsive_options()->get_property_values( $this->props, 'sticky_filter_bar' );
        $sticky_filter_bar_tablet        = isset( $sticky_filter_bar_values['tablet'] ) ? $sticky_filter_bar_values['tablet'] : $sticky_filter_bar  ;
        $sticky_filter_bar_phone         = isset( $sticky_filter_bar_values['phone'] ) ? $sticky_filter_bar_values['phone'] : $sticky_filter_bar_phone;
        $config = [
            'infinite_scroll_viewport' => $this->props['infinite_scroll_viewport'],
        ];
        $filterable_gallery_html = DIPI_FilterableGallery::render_filterable_gallery($this->props);
        $module_custom_classes = 'dipi_filterable_gallery_wrapper';
        if ($grid_layout === 'grid') {
            $module_custom_classes.=" layout_grid";
        }
        if ($sticky_filter_bar  === "on") {
            $module_custom_classes.=" sticky_filter_bar";
        }
        if ($sticky_filter_bar_tablet  === "on") {
            $module_custom_classes.=" sticky_filter_bar_tablet";
        }
        if ($sticky_filter_bar_phone  === "on") {
            $module_custom_classes.=" sticky_filter_bar_phone";
        }
        return sprintf(
            '<div class="%2$s" data-config="%3$s">
                %1$s
            </div>
           ',
            $filterable_gallery_html,
            $module_custom_classes,
            esc_attr(htmlspecialchars(json_encode($config), ENT_QUOTES, 'UTF-8'))
        );
    }

    public function dipi_apply_css($render_slug)
    { 
 
        if('on' === $this->props['icon_in_overlay']){
            $this->dipi_generate_font_icon_styles($render_slug, 'hover_icon', '%%order_class%% .dipi-filterable-gallery-icon:before');
        }
        $columns = $this->props["columns"];
        $columns_responsive_active = isset($this->props["columns_last_edited"]) && et_pb_get_responsive_status($this->props["columns_last_edited"]);
        $columns_tablet = $columns_responsive_active && $this->props["columns_tablet"] ? $this->props["columns_tablet"] : $columns;
        $columns_phone = $columns_responsive_active && $this->props["columns_phone"] ? $this->props["columns_phone"] : $columns_tablet;

        $gutter = $this->props["gutter"];
        $gutter_responsive_active = isset($this->props["gutter_last_edited"]) && et_pb_get_responsive_status($this->props["gutter_last_edited"]);
        $gutter_tablet = $gutter_responsive_active && $this->props["gutter_tablet"] ? $this->props["gutter_tablet"] : $gutter;
        $gutter_phone = $gutter_responsive_active && $this->props["gutter_phone"] ? $this->props["gutter_phone"] : $gutter_tablet;


        $filter_bar_selector = "%%order_class%% .dipi-filter-bar";
        $filter_bar_item_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item";
        $filter_bar_item_title_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item .dipi-filter-bar-item-title";
        $filter_bar_item_text_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item .dipi-filter-bar-item-title, %%order_class%% .dipi-filter-bar .dipi-filter-bar-item .dipi-filter-bar-item-desc";
        $filter_bar_item_hover_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item:hover";
        $filter_bar_item_active_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item.active";
        $filter_bar_item_active_text_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item.active .dipi-filter-bar-item-title, %%order_class%% .dipi-filter-bar .dipi-filter-bar-item.active .dipi-filter-bar-item-desc";
        $filter_bar_item_active_hover_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item.active:hover";
        $filter_bar_item_name_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item .dipi-filter-bar-name";
        $filter_bar_item_count_selector = "%%order_class%% .dipi-filter-bar .dipi-filter-bar-item .dipi-filter-bar-count";
        $pagination_selector = "%%order_class%% .dipi-pagination";
        $pagination_btn_normal_selector = "%%order_class%% .dipi-pagination .dipi-pagination-btn";
        $pagination_btn_normal_hover_selector = "%%order_class%% .dipi-pagination .dipi-pagination-btn:hover";
        $pagination_btn_active_selector = "%%order_class%% .dipi-pagination .dipi-pagination-btn.active";
        $pagination_btn_active_hover_selector = "%%order_class%% .dipi-pagination .dipi-pagination-btn.active:hover";
        $load_more_selector = "%%order_class%% .dipi-loadmore-btn";
        $load_more_hover_selector = "%%order_class%% .dipi-loadmore-btn:hover";


        $grid_selector =  "%%order_class%% .dipi-filtered-gallery-container";
        $gallery_item_grid_selector =  "%%order_class%% .dipi-filtered-gallery-container .dipi-filtered-gallery-item, %%order_class%% .dipi-filtered-gallery-container .dipi-filtered-gallery-item .grid";
        $grid_item_selector =  "%%order_class%% .dipi-filtered-gallery-container .dipi-filtered-gallery-item .grid-item";

        //Pagination
        $this->dipi_apply_custom_style(
            $render_slug,
            'pagination_btn_bg_color',
            'background-color',
            $pagination_btn_normal_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'pagination_active_btn_bg_color',
            'background-color',
            $pagination_btn_active_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'load_more_bg_color',
            'background-color',
            $load_more_selector
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'pagination_btn_margin',
            'margin',
            $pagination_btn_normal_selector
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'pagination_btn_padding',
            'padding',
            $pagination_btn_normal_selector
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'pagination_active_btn_margin',
            'margin',
            $pagination_btn_active_selector
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'pagination_active_btn_padding',
            'padding',
            $pagination_btn_active_selector
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'load_more_margin',
            'margin',
            $load_more_selector
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'load_more_padding',
            'padding',
            $load_more_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'load_more_alignment',
            'justify-content',
            $pagination_selector
        );
        
        // Filter bar 
        $this->dipi_apply_custom_style(
            $render_slug,
            'sticky_filter_bar_top',
            'top',
            $filter_bar_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'space_tabs',
            'gap',
            $filter_bar_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'space_tab_number',
            'gap',
            $filter_bar_item_title_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_layout',
            'flex-direction',
            $filter_bar_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_tab_alignment',
            'place-content',
            $filter_bar_selector
        );

        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'filter_bar_margin',
            'margin',
            $filter_bar_selector
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'filter_bar_padding',
            'padding',
            $filter_bar_selector
        );
        
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_background_color',
            'background-color',
            $filter_bar_selector
        );

        // Filter bar Item
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'filter_bar_item_padding',
            'padding',
            $filter_bar_item_selector
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'filter_bar_item_padding_active',
            'padding',
            $filter_bar_item_active_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_normal_text_align',
            'justify-content',
            $filter_bar_item_text_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_active_text_align',
            'justify-content',
            $filter_bar_item_active_text_selector
        );
        
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_item_background_color',
            'background-color',
            $filter_bar_item_selector
        );
        $this->dipi_apply_custom_style_for_hover(
            $render_slug,
            'filter_bar_item_background_color',
            'background-color',
            $filter_bar_item_hover_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_item_background_color_active',
            'background-color',
            $filter_bar_item_active_selector
        );
        $this->dipi_apply_custom_style_for_hover(
            $render_slug,
            'filter_bar_item_background_color_active',
            'background-color',
            $filter_bar_item_active_hover_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_item_width',
            'width',
            $filter_bar_item_selector
        );
        $this->dipi_apply_custom_style_for_hover(
            $render_slug,
            'filter_bar_item_width',
            'width',
            $filter_bar_item_hover_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_item_width_active',
            'width',
            $filter_bar_item_active_selector
        );   
        $this->dipi_apply_custom_style_for_hover(
            $render_slug,
            'filter_bar_item_width_active',
            'width',
            $filter_bar_item_active_hover_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_item_height',
            'height',
            $filter_bar_item_selector
        );
        $this->dipi_apply_custom_style_for_hover(
            $render_slug,
            'filter_bar_item_height',
            'height',
            $filter_bar_item_hover_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'filter_bar_item_height_active',
            'height',
            $filter_bar_item_active_selector
        );
        $this->dipi_apply_custom_style_for_hover(
            $render_slug,
            'filter_bar_item_height_active',
            'height',
            $filter_bar_item_active_hover_selector
        );
        //Grid
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'grid_margin',
            'margin',
            $grid_selector
        );

        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'grid_padding',
            'padding',
            $grid_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'grid_background_color',
            'background-color',
            $grid_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'grid_animation_speed',
            'animation-duration',
            $gallery_item_grid_selector
        );
        // Grid Item
        $this->dipi_apply_custom_style(
            $render_slug,
            'grid_item_background_color',
            'background-color',
            $grid_item_selector
        );
        $this->dipi_apply_custom_style(
            $render_slug,
            'grid_animation_delay',
            'animation-delay',
            $gallery_item_grid_selector 
        );


        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'grid_item_title_margin',
            'margin',
            "%%order_class%% .dipi-grid-item-title"
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'grid_item_title_padding',
            'padding',
            "%%order_class%% .dipi-grid-item-title"
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'grid_item_caption_margin',
            'margin',
            "%%order_class%% .dipi-grid-item-caption"
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'grid_item_caption_padding',
            'padding',
            "%%order_class%% .dipi-grid-item-caption"
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'grid_item_category_margin',
            'margin',
            "%%order_class%% .dipi-grid-item-category"
        );
        $this->dipi_apply_custom_margin_padding(
            $render_slug,
            'grid_item_category_padding',
            'padding',
            "%%order_class%% .dipi-grid-item-category"
        );
        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .img-container.dipi-fg-animation:hover img',
            'declaration' => "transition-duration: " . intval($this->props["image_animation_speed"]) / 1000 . "s;",
        ]);
        //Width of grid items
        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .grid-item',
            'declaration' => "width: calc((100% - ({$columns} - 1) * {$gutter}px) / {$columns});",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .grid-item',
            'declaration' => "width: calc((100% - ({$columns_tablet} - 1) * {$gutter_tablet}px) / {$columns_tablet});",
            'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .grid-item',
            'declaration' => "width: calc((100% - ({$columns_phone} - 1) * {$gutter_phone}px) / {$columns_phone});",
            'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
        ]);

        // Height of Grid Items
        $this->generate_styles(
            array(
                'base_attr_name' => 'row_height',
                'selector' => "%%order_class%%.dipi_filterable_gallery .dipi_filterable_gallery_wrapper.layout_grid .grid img",
                'css_property' => 'height',
                'render_slug' => $render_slug,
                'type' => 'range',
            )
        );
        //Gutter of grid items
        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-item',
            'declaration' => "margin-bottom: {$gutter}px;",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-item',
            'declaration' => "margin-bottom: {$gutter_tablet}px;",
            'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-item',
            'declaration' => "margin-bottom: {$gutter_phone}px;",
            'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
        ]);
        $this->generate_styles(
            array(
                'base_attr_name' => 'gutter',
                'selector' => "%%order_class%%.dipi_filterable_gallery .dipi_filterable_gallery_wrapper.layout_grid .grid",
                'css_property' => 'column-gap',
                'render_slug' => $render_slug,
                'type' => 'range',
            )
        );
        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .gutter-sizer',
            'declaration' => "width: {$gutter}px;",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .gutter-sizer',
            'declaration' => "width: {$gutter_tablet}px;",
            'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .gutter-sizer',
            'declaration' => "width: {$gutter_phone}px;",
            'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
        ]);

        //Remove gutter from outer grid
        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid',
            'declaration' => "margin-bottom: -{$gutter}px;",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid',
            'declaration' => "margin-bottom: -{$gutter_tablet}px;",
            'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid',
            'declaration' => "margin-bottom: -{$gutter_phone}px;",
            'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
        ]);

        if ('on' === $this->props["show_overflow"]) {
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%%.dipi_filterable_gallery, %%order_class%%.dipi_filterable_gallery .grid-item',
                'declaration' => "overflow: visible !important;",
            ]);
        }

        if ('on' === $this->props["use_overlay"]) {
            $overlay_bg_image = [];
            $overlay_bg_style = '';
            $use_overlay_bg_gradient = $this->props["overlay_bg_use_color_gradient"];
            $overlay_bg_type = $this->props["overlay_bg_color_gradient_type"];
            $overlay_bg_direction = $this->props["overlay_bg_color_gradient_direction"];
            $overlay_bg_direction_radial = $this->props["overlay_bg_color_gradient_direction_radial"];
            $overlay_bg_start = $this->props["overlay_bg_color_gradient_start"];
            $overlay_bg_end = $this->props["overlay_bg_color_gradient_end"];
            $overlay_bg_start_position = $this->props["overlay_bg_color_gradient_start_position"];
            $overlay_bg_end_position = $this->props["overlay_bg_color_gradient_end_position"];
            $overlay_bg_overlays_image = $this->props["overlay_bg_color_gradient_overlays_image"];
            $overlay_icon_use_circle = $this->props['overlay_icon_use_circle'];
            $overlay_icon_use_circle_border = $this->props['overlay_icon_use_circle_border'];
            $overlay_icon_use_icon_font_size = $this->props['overlay_icon_use_icon_font_size'];
            $overlay_icon_selector = '%%order_class%%.dipi_filterable_gallery .grid .grid-item .dipi_filterable_gallery_overlay .dipi-filterable-gallery-icon';
            $overlay_icon_hover_selector = '%%order_class%%.dipi_filterable_gallery .grid .grid-item .dipi_filterable_gallery_overlay .dipi-filterable-gallery-icon:hover';
            $overlay_icon_circle_selector = '%%order_class%%.dipi_filterable_gallery .grid .grid-item .dipi_filterable_gallery_overlay .dipi-filterable-gallery-icon.dipi-filterable-gallery-icon-circle';
            $overlay_icon_circle_hover_selector = '%%order_class%%.dipi_filterable_gallery .grid .grid-item .dipi_filterable_gallery_overlay .dipi-filterable-gallery-icon.dipi-filterable-gallery-icon-circle:hover';
            $overlay_selector = '%%order_class%%.dipi_filterable_gallery .grid .grid-item .dipi_filterable_gallery_overlay.content';
            $overlay_selector_background = '%%order_class%%.dipi_filterable_gallery .grid .grid-item .dipi_filterable_gallery_overlay.background';
            $icon_delay = $this->props['icon_delay'];
            $icon_speed = $this->props['icon_speed'];
            $title_delay = $this->props['title_delay'];
            $title_speed = $this->props['title_speed'];
            $caption_delay = $this->props['caption_delay'];
            $caption_speed = $this->props['caption_speed'];
            $hover_icon_selector = "%%order_class%%.dipi_filterable_gallery .grid .grid-item:hover .dipi_filterable_gallery_overlay .dipi-filterable-gallery-icon";
            $hover_title_selector = "%%order_class%%.dipi_filterable_gallery .grid .grid-item:hover .dipi_filterable_gallery_overlay .dipi-filterable-gallery-title";
            $hover_caption_selector = "%%order_class%%.dipi_filterable_gallery .grid .grid-item:hover .dipi_filterable_gallery_overlay .dipi-filterable-gallery-caption";
            
            $this->set_background_css($render_slug, '%%order_class%% .grid .grid-item .dipi_filterable_gallery_overlay.background', '%%order_class%% .grid .grid-item .dipi_filterable_gallery_overlay.background-hover', 'overlay_bg', 'overlay_bg_color');

            ET_Builder_Element::set_style($render_slug, [
                'selector' => $hover_icon_selector,
                'declaration' => "animation-duration: {$icon_speed} !important;",
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => $hover_icon_selector,
                'declaration' => "animation-delay: {$icon_delay} !important;",
            ]);

            ET_Builder_Element::set_style($render_slug, [
                'selector' => $hover_title_selector,
                'declaration' => "animation-duration: {$title_speed} !important;",
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => $hover_title_selector,
                'declaration' => "animation-delay: {$title_delay} !important;",
            ]);

            ET_Builder_Element::set_style($render_slug, [
                'selector' => $hover_caption_selector,
                'declaration' => "animation-duration: {$caption_speed} !important;",
            ]);

            ET_Builder_Element::set_style($render_slug, [
                'selector' => $hover_caption_selector,
                'declaration' => "animation-delay: {$caption_delay} !important;",
            ]);

            $this->dipi_apply_custom_margin_padding(
                $render_slug,
                'overlay_padding',
                'padding',
                $overlay_selector
            );

            $text_align_style = sprintf(
                'text-align: %1$s !important;',
                $this->props['overlay_align_horizontal'] === 'flex-start' ? 'left' :
                ($this->props['overlay_align_horizontal'] === 'flex-end' ? 'right' : 'center')
            );
            ET_Builder_Element::set_style($render_slug, array(
                'selector' => $overlay_selector,
                'declaration' => $text_align_style,
            ));
            $this->generate_styles(
                array(
                    'base_attr_name' => 'overlay_align_horizontal',
                    'selector' => $overlay_selector,
                    'css_property' => 'align-items',
                    'render_slug' => $render_slug,
                    'type' => 'select',
                )
            );

            $this->generate_styles(
                array(
                    'base_attr_name' => 'overlay_align_vertical',
                    'selector' => $overlay_selector,
                    'css_property' => 'justify-content',
                    'render_slug' => $render_slug,
                    'type' => 'select',
                )
            );

            // Overlay Icon
            if ('off' !== $overlay_icon_use_icon_font_size) {
                $this->dipi_apply_custom_style(
                    $render_slug,
                    'overlay_icon_font_size',
                    'font-size',
                    $overlay_icon_selector
                );            
                $this->dipi_apply_custom_style_for_hover(
                    $render_slug,
                    'overlay_icon_font_size',
                    'font-size',
                    $overlay_icon_hover_selector
                );
            }
            $this->dipi_apply_custom_style(
                $render_slug,
                'overlay_icon_color',
                'color',
                $overlay_icon_selector
            );            
            $this->dipi_apply_custom_style_for_hover(
                $render_slug,
                'overlay_icon_color',
                'color',
                $overlay_icon_hover_selector
            );
            if ('on' === $overlay_icon_use_circle) {
                $this->dipi_apply_custom_style(
                    $render_slug,
                    'overlay_icon_circle_color',
                    'background-color',
                    $overlay_icon_circle_selector
                ); 
                $this->dipi_apply_custom_style_for_hover(
                    $render_slug,
                    'overlay_icon_circle_color',
                    'background-color',
                    $overlay_icon_circle_hover_selector,
                    true
                ); 
                $this->dipi_apply_custom_margin_padding(
                    $render_slug,
                    'overlay_icon_circle_padding',
                    'padding',
                    $overlay_icon_circle_selector
                );
                if ('on' === $overlay_icon_use_circle_border) {
                    $this->generate_styles(
                        array(
                            'base_attr_name' => 'overlay_icon_circle_border_color',
                            'selector' => $overlay_icon_circle_selector,
                            'css_property' => 'border-color',
                            'render_slug' => $render_slug,
                            'type' => 'color',
                        )
                    );
                }
            }
        }
    }
}

new DIPI_FilterableGallery;
