<?php 
class DIPI_SVG_Shapes {
    
    private static $layerID = 0;
    private function getLayerId($prefix = 'SVG_'){
        self::$layerID++;
        return $prefix . self::$layerID;
    }

    public function shape($name, $img_props, $layer_1_enable, $gradID ) {
        if($img_props['use_custom_mask'] === 'on')
            return $this->custom_mask($img_props, $layer_1_enable, $gradID);
        if(method_exists($this, $name)){
            return $this->$name($img_props, $layer_1_enable, $gradID);
        }
    }
  
    protected function Shape1($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on'){
            $layer_1 = sprintf('
                <path class="st1" fill="url(#%1$s)" d="M318,440c-52.5-36.7-208.7,60.7-228.3-27.5c-5.1-22.8,3.8-102.7,62.3-173.9c-86.8,84.1-99.7,189.8-93.4,217.7 c22,97.5,197.2-10.1,256,30.4c17.2,11.9,22.9,34,24.3,61.8C340.8,499.4,343,457.5,318,440z"/>
                <path class="st1" fill="url(#%1$s)" d="M907,470.1c-5.8-47.1-48.6-240.3-245.1-313.8C808.1,231,841.5,385.3,846.3,425 c12.5,102.5-16.2,379.3-294.2,362.5c-180.9-11-211.2-98.6-214.1-184.1c-4.5,109.4-10.5,252.6,239.1,267.5 C888.9,889.5,921,583.4,907,470.1z"/>',
            $gradID);
        }
        $mask = '<path d="M552.2,787.5c-330-20-158.9-294.9-234.2-347.5c-52.5-36.7-208.7,60.7-228.3-27.5 c-10-45,34.3-312.9,408.3-296.7C785.5,128.3,840,373.4,846.3,425C858.8,527.5,830.2,804.3,552.2,787.5z" />';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
        
    }

    protected function Shape2($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on')
          $layer_1 = sprintf('<path class="st1" fill="url(#%1$s)" d="M609.7,903.9c-12.7,0-25.1-1.1-37.2-3.2c27.9,51,82,85.6,144.3,85.6c90.7,0,164.2-73.5,164.2-164.2 c0-27.2-6.6-52.9-18.4-75.6c-15.4,6.8-31.8,12-48.9,15.1C783.1,844.6,703.3,903.9,609.7,903.9z"/>',
            $gradID);
        $mask = '<path id="%7$s" d="M991.9,547.7c0,106.7-76.8,195.4-178.2,213.9c-30.6,83.1-110.4,142.3-204,142.3c-75.4,0-141.8-38.4-180.8-96.7
            c-42.2,26.8-92.3,42.4-146,42.4C132.3,849.6,10.3,727.5,10.3,577c0-88.5,42.2-167.2,107.6-217c-13.4-22.3-21.1-48.3-21.1-76.2
            c0-81.8,66.3-148.1,148.1-148.1c15.8,0,31,2.5,45.3,7.1c53.4-76.3,142-126.2,242.2-126.2c163.5,0,296,132.5,296,296
            c0,8.2-0.3,16.2-1,24.2C921.9,360.4,991.9,445.9,991.9,547.7z"/>';
        
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }
     
    protected function Shape3($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('
                    <path class="st1" d="M402.8,857c-113.4-4.9-193.5-25.4-249.2-55.3c67.7,105.5,210.3,293,474.7,38.8 C561.9,854.3,486.6,860.6,402.8,857z"/>
                    <path class="st1" d="M607.7,189.2c70.4,39.8,185.2,87.1,269.7,153.1c-1.6-86.3-30.7-157-77.7-202.1 C727.4,70.8,621.2,83.4,518,117.1C540,140.3,566.8,166.1,607.7,189.2z"/>
                    <path class="st1" d="M67.2,450.1c12.2-37.6,52.5-131.3,109.2-219c-50.1,3-87.6,1.6-119.9,37.4c-54.9,61-44.4,172-14.4,277.2 C48.4,509.7,58.6,476.5,67.2,450.1z"/>',
            $gradID);
        }
        
        $mask = '<path class="st0" d="M985,535c-11.2,161-212.8,338-582.2,322C-48.1,837.4,27.9,571.5,67.2,450.1c25.7-79.5,177.4-409.7,343-403.4 c79.6,3,90.4,82,197.5,142.5C732.8,259.9,997.6,354.2,985,535z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
   }

    protected function Shape4($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('
                <path class="st1" d="M51.1,450.8c-32,47.9-47,86.2-37.9,105.1c6.6,13.6,23.9,11.8,55.3,8C54,533.9,47.1,495.6,51.1,450.8z"/>
                <path class="st1" d="M697.5,18.7C638.1,18.5,574.1,35.9,510,64.5C589,49,673.5,50.2,759.6,77.7C906,124.4,964.9,246.6,961.2,414.1 c-0.4,17.3-1.3,33.7-2.8,49.2c11.8-27.7,20-56.6,24.2-86C982.6,377.3,1047.7,19.4,697.5,18.7z"/>
                <path class="st1" d="M426.3,530.6c-66.8-7-100.4,17.3-130,44.4c44.9,10.5,95.9,26.7,153.8,51.4c59.9,25.5,115.9,38.7,167.5,42 C554.5,614.2,495,537.7,426.3,530.6z"/>',
            $gradID);
        }
        $mask = ' <path id="%1$s" class="st0" d="M961.2,414.1c-5.4,236.8-111.2,301.1-225.3,308C621.7,729,535.7,542,426.3,530.6 C286.8,516,292.2,637.8,175.7,636.3c-85.6-1.1-150.6-93.5-116.5-233.7C87.6,286.1,411.1-33.6,759.6,77.7 C906,124.4,964.9,246.6,961.2,414.1z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape5($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('
                <path class="st1" d="M198.1,379.1l129.1-210c-50.3,12.2-95.4,45.9-116.5,98.2L116,501.1l-13.6,33.5L198.1,379.1z" />
                <path class="st1" d="M505.3,878.6H211.2c-101.4,0-175.7-73.4-184.4-157.4l-5.6,13.8C-24.6,848.1,75.8,963.1,202,941.9l260.7-43.8l115.9-19.5 H505.3z" />',
            $gradID);
        }
        $mask = '<path d="M345.1,140c71.2-115.7,249.2-115.7,320.3,0l147.1,239.1l147.1,239.1c71.2,115.7-17.8,260.4-160.2,260.4H505.3 H211.2C68.8,878.6-20.2,733.9,51,618.2l147.1-239.1L345.1,140z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape6($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path  class="st1" d="M11.8,535.2c14.4,86.8,99.5,109,135.1,131.1c35.5,22.1,254.3,125.6,403.6,139 c149.3,13.4,547.4-73.5,415.4-403.6S530,81,387.8,105.5S-34.8,254.8,11.8,535.2z"/>',
                $gradID);
        }
        $mask = '<path id="%1$s" class="st0" d="M39.1,323.1C0.8,467.2,120,542.7,158.7,607.8c52.1,87.7,105,324.6,323.4,320.7 c225.6-4.1,499.6-137.4,501.1-321.1c1.5-175.3-106.6-468-452.6-500C190.7,76,67,217.8,39.1,323.1z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape7($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M18.6,271.7C88.9,84.2,379.5,39.6,510.7,43.4C641.9,47.1,920,95,949.2,301c29.2,206.1-103.7,621.5-356.6,675.6 C339.6,1030.5-76.4,525.1,18.6,271.7z"/>',
                $gradID);
        }
        $mask = '<path d="M122.7,108.4c128.8-152,417-92.7,539.1-43.8s367.6,190.8,326,394.6c-41.5,204-305.2,548.2-561.2,511.2 C170.7,933.3-51.5,313.6,122.7,108.4z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape8($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M973.2,451.7l-1.3,0.5L973.2,451.7c-6.4-28.1-21.4-51.4-42.2-65.7c-21-14.5-45.1-18.2-68.2-10.5l-34.9,11.7
                        c33.7-24.8,50.7-74.3,39.9-122c-13.1-58-62.6-92.1-110.5-76.2l-123,40.9c34.3-24.5,52-74.8,41.1-122.7
                        c-6.4-28.1-21.4-51.4-42.2-65.7c-21-14.5-45.1-18.2-68.2-10.5L228.4,143.1c-23.1,7.7-42.4,25.9-54.2,51.2s-15,54.7-8.7,82.8
                        c10.8,47.9,47.2,80.2,86.7,80.2h0.2l-160,53.3c-47.8,15.9-75.9,76-62.8,134s62.6,92.1,110.5,76.2l34.9-11.7
                        c-33.7,24.8-50.7,74.3-39.9,122c6.4,28.1,21.4,51.4,42.2,65.7c21,14.5,45.1,18.2,68.2,10.5l88.5-29.5c-31.2,25.9-46.5,74.1-36.2,119
                        c6.4,28.1,21.4,51.4,42.2,65.7c13.9,9.6,29.1,14.5,44.5,14.5c7.9,0,16-1.4,23.7-4l406.5-135.6c47.8-15.9,75.9-76,62.8-134
                        c-10.2-45.1-43.4-77.1-81.3-80l113.9-37.9C958.2,569.8,986.3,509.7,973.2,451.7z M909.6,582.4l-137.4,45.8l13.7-0.9
                        c40.9-2.8,78.3,29.7,89.1,77.4c12.7,56.1-14.6,114.3-60.9,129.7L407.5,970c-46.3,15.4-94.3-17.8-107-73.9
                        c-10.8-47.7,7.7-98.9,43.9-121.8l12.1-7.7L244.8,804c-22.4,7.5-45.7,3.7-66.1-10.1c-20.2-14-34.9-36.5-40.9-63.6
                        c-11.8-51.9,10.4-105.9,51.5-126l-1-3.3l-49.2,16.4c-46.3,15.4-94.3-17.8-107-73.9s14.6-114.3,60.9-129.7l176.4-58.9l-0.6-3.5
                        c-44.5,10.8-88.9-22.4-100.8-75.5c-6.2-27.1-3.1-55.4,8.3-80.2c11.6-24.5,30.1-42.3,52.4-49.6L565.4,34c22.4-7.5,45.7-3.7,66.1,10.1
                        c20.2,14,34.9,36.5,40.9,63.6c12,53.1-12.1,109.2-54.9,127.4l0.8,3.3l139.4-46.5c22.4-7.5,45.7-3.7,66.1,10.1
                        c20.4,13.8,34.9,36.5,40.9,63.6c11.8,51.9-10.4,105.9-51.5,126l1,3.3l49.2-16.4c22.4-7.5,45.7-3.7,66.1,10.1
                        c20.2,14,34.9,36.5,40.9,63.6C983.1,508.8,955.9,567,909.6,582.4z"/>',
                $gradID);
        }
        $mask = '<path id="%1$s" class="st0" d="M937,440L937,440c-12.1-53.5-58.2-85.3-102.5-70.6l-46.3,15.4c38.7-18.9,60.7-70.6,49.3-120.6l0,0
                    c-12.1-53.5-58.2-85.3-102.5-70.6l-131.3,43.7c40.7-17.5,64.2-70.8,52.6-122l0,0C644.2,61.8,598.1,30,553.8,44.7L236.7,150.4
                    c-44.1,14.7-70.4,70.6-58.2,124.4l0,0c11.6,51.2,54.4,82.5,96.6,72.2l-166.2,55.4C64.7,417.1,38.5,473,50.7,526.8l0,0
                    c12.1,53.5,58.2,85.3,102.5,70.6l46.3-15.4c-38.7,18.9-60.7,70.6-49.3,120.6l0,0c12.1,53.5,58.2,85.3,102.5,70.6l92.9-31.1
                    c-34.1,21.5-52.6,69.9-42,116.4l0,0c12.1,53.5,58.2,85.3,102.5,70.6L789,801.4c44.1-14.7,70.4-70.6,58.2-124.4l0,0
                    c-10.6-46.8-46.8-76.7-85.2-74.1l116.8-39C922.9,549.7,949.1,493.8,937,440z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape9($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M90.3,242c0.7-3.2,1.9-6.4,2.6-9.2c9.4-36.9,36-72,81.5-69.7c10.6,0.5,54.1,31.9,64.9,41.5
                                    c-2.9-7.1-5.8-14.1-8.8-21.2c-6.5-7.3-57.7-46.9-69.5-47.5c-47.4-2.6-75.1,36.1-84.9,76.6c-1.8,7.4-6,16.7-1.2,23.5
                                    C80,239,85.1,240.8,90.3,242z"/>
                                <path class="st1" d="M253.2,234c5.3,3.6,21.6,7.4,28,4.2c0.3-0.6,0.7-1.2,1-1.8c0-2.9-8.4-10-14.3-16.8c-7.1,0.7-17.6-1.9-23-4.7
                                    C247.7,221.2,250.4,227.6,253.2,234z"/>
                                <path class="st1" d="M250.2,143.6c11.7-21.5,48.8-38.6,63.1-41.2c7.1,0.4,14.3,0.8,21.4,1.1c1.7-3.9,3.5-7.8,5.2-11.8
                                    c7-0.2,13.9-0.5,20.9-0.7c10.5-8.4,15.8-43.7,36.1-43.7c0.9,0.6,1.7,1.3,2.6,1.9c5.4-7.5,10.9-14.9,16.3-22.4
                                    c-7.7-6.1-15.3-12.1-23-18.2c-21.2,0-26.7,38.9-37.6,48c-7.2,0.3-14.5,0.5-21.7,0.8c-1.8,4.3-3.6,8.6-5.4,12.9
                                    c-7.4-0.4-14.9-0.8-22.3-1.3c-20,3.8-83,36.6-66.9,70.8C242.4,141.8,246.2,143,250.2,143.6z"/>
                                <path class="st1" d="M414,70.5c-3.6,4.6-7.1,9.3-10.7,13.9c1.2,4.7,28,40.6,37.4,31.6c0.5-3.2,1-6.5,1.5-9.7
                                    c3.5-0.6,6.9-1.2,10.4-1.8c2.7,2.2,5.4,4.3,8.1,6.5c6.4,0,8.6-8.3,9.5-13.4c8.9-15.6,45.1,9.5,57.8,6.7
                                    c14.4-5.9,28.8-11.8,43.2-17.6c22.2-2.8,72.5-2.3,87,20.8c14.6,23.9,11.1,44.8,21,54.7c3,3.2,0.4,4-2.1,3.4
                                    c0.2,0.9,0.3,1.8,0.5,2.7c10.6,10.6,74-9.1,72,27.4c1.7-1,3.5-2,5.2-2.9c27.2-67.9-57-37.8-69.6-51.1c-0.2-1-0.3-2-0.5-3
                                    c2.5,0.7,5.3-0.2,2.1-3.7C676.5,124,680.2,101,665,74.7c-15.1-25.4-67.5-25.9-90.6-22.9c-15,6.5-30,12.9-45,19.4
                                    c-13.2,3.1-50.9-24.5-60.2-7.3c-1,5.5-3.2,14.7-9.9,14.7c-2.8-2.4-5.6-4.8-8.5-7.1c-3.6,0.7-7.2,1.3-10.8,2
                                    c-0.5,3.6-1,7.1-1.6,10.7C433.2,89.5,422.7,80.7,414,70.5z"/>
                                <path class="st1" d="M744.5,214.7c-3.7,2-7.4,3.9-11,5.9c0.9,2.1,1.8,4.2,2.7,6.3c10.6-0.8,21.2-1.5,31.8-2.3
                                    c9.8,3.9-1.8,68.3-13.9,80.7c-2.6,8,21.2,30,27.3,34c9.2,12.3-17.3,21.3,16.4,45.5c20.7,14.9,96.1,40.6,105.1,53.1
                                    c0,12,0,23.9,0,35.9c2.8,1.8,5.5,3.6,8.3,5.4c2,5-18.8,44.3-13.2,55.5c3.5,3.5,9.4,4.3,15.7,5c-0.7-16.1,16.6-51.4,14.7-56.4
                                    c-2.9-2-5.7-4-8.6-6c0-13.1,0-26.3,0-39.5c-9.4-13.8-87.8-42.1-109.4-58.4c-35.1-26.6-7.5-36.5-17.1-50
                                    c-6.4-4.5-31.1-28.7-28.4-37.4c12.6-13.6,24.7-84.4,14.5-88.7c-10.5,0.8-21,1.6-31.5,2.4C746.8,208.6,745.8,211.5,744.5,214.7z"/>
                                <path class="st1" d="M333.2,201.2c3.1-9.1-0.8-20.4-5.5-28.3c-0.1,0-0.2-0.1-0.2-0.1c-0.2,1.7-0.5,3.4-1,5
                                    c-17.2,0.5-34.4,1.1-51.5,1.6c-1.8,2.8-3.6,5.5-5.4,8.3c-4.6-1.4-9.1-2.9-13.7-4.3c-8.3,3.5,2.3,14.5,10.3,23.1
                                    c4.1,1.2,8.3,2.5,12.4,3.7c1.7-2.5,3.5-5,5.2-7.5C300.2,202.2,316.7,201.7,333.2,201.2z"/>
                                <path class="st1" d="M74.5,511.6c-0.1,0.6-0.2,1.2-0.3,1.8c0,24.4,21.1,42.1,13.7,77.6c-8.6,2-10.5,8.9-11.3,15.9
                                    c1.7-1,4.2-1.6,6.5-0.1c17.7,3.7,1.6-25.4,21-29.8c6.7-30.4-10.9-46.4-12.9-66.8c-5.4,0.1-10.7,0.2-16.1,0.3
                                    C75,510.9,74.7,511.2,74.5,511.6z"/>
                                <path class="st1" d="M886.6,708.2c-0.5,4.8-1.1,9.5-1.7,11.7c-2.7,8.4-15.6,1.7-19.8,6.1c-15.6,16.3-9.7,25-16.1,44.6
                                    c-3.2,3.3-45.2-12.2-57.4-7.2c-1.3,1.5-2.5,3.1-3.8,4.6c2.2,3.3,4.5,6.5,6.8,9.8c1.3,2.7,0.5,3.9-1.4,4.1
                                    c-6.1,1.1-12.1,2.1-18.2,3.2c-3.2-0.1,0.3-4.2-2.1-5.1c-1,4.8-6.4,9.4-8.1,10.6c2.5,3.3,4.9,6.6,7.4,9.8c1,9.2-6,28.7-14.6,30.9
                                    c-3.4-2.9-6.7-5.9-10.1-8.8c-3,1.1-6,2.3-9.1,3.4c0,0-16.4-15.1-17.2-16.7c-4.2,0-16.8-6.7-19.5,1.9c0.1,12,0.1,24,0.2,36
                                    c-0.7,1.1-11.8,37.2-18.5,46.8c-7.5,10.7-19.9,19.7-28.3,30.5c-1.7,4.6-3.4,9.2-5.2,13.8c-13.9,0-56.9,6.6-66.2-10.3
                                    c-4.5-20.2-9.1-40.4-13.6-60.6c-7.5-8.9-13.8-5.4-22.9-10.4c0,0-35.7-43.2-35.8-43.5c-0.2,0.6-1.8,2.3-4,2.2
                                    c-8.4-1.7-11.1-7.8-18.3-11.6c-5,5.3-2.6,8.8-5.7,13.5c-2,4.2-63.3-8.6-73.6-15.5c-27.4,0-32,38.8-53.9,45.6
                                    c-30.5,9.4-50,38.6-79,50.8c-13.5,5.7-22.3-4.4-34.5-4.4c-17.9,18.7-90.4,8.7-105.5-7.6c-12.2-13.2-15.3-39.2-13.3-62.1
                                    c-3.9,1.9-7.6,4-9,6.1c-9.5,26.5-11.6,79.1,7.4,100.7c15.7,17.9,91.3,28.9,109.9,8.4c12.7,0,21.9,11.1,35.9,4.8
                                    c30.2-13.4,50.6-45.5,82.3-55.8c22.9-7.4,27.6-50.1,56.2-50.1c10.7,7.6,74.6,21.6,76.7,17c3.2-5.1,0.7-9.1,5.9-14.8
                                    c7.6,4.2,10.3,10.9,19.1,12.8c2.4,0.1,4-1.7,4.2-2.4c0.1,0.3,37.3,47.8,37.3,47.8c9.5,5.5,16,1.6,23.9,11.4
                                    c4.7,22.2,9.4,44.4,14.2,66.6c9.7,18.5,54.5,11.3,69,11.3c1.8-5.1,3.6-10.1,5.4-15.2c8.8-11.9,21.7-21.8,29.5-33.5
                                    c7-10.5,18.6-50.2,19.3-51.4c-0.1-13.2-0.1-26.4-0.2-39.6c2.9-9.4,15.9-2.1,20.4-2.1c0.8,1.8,17.9,18.4,17.9,18.4
                                    c3.1-1.2,6.3-2.5,9.4-3.7c3.5,3.2,7,6.5,10.5,9.7c9-2.4,16.3-23.8,15.2-33.9c-2.6-3.6-5.1-7.2-7.7-10.8c1.8-1.3,7.4-6.4,8.4-11.7
                                    c2.5,1.1-1.1,5.6,2.2,5.6c6.3-1.2,12.7-2.3,19-3.5c2-0.3,2.8-1.6,1.5-4.6c-2.3-3.6-4.7-7.2-7-10.8c1.3-1.7,2.6-3.4,3.9-5.1
                                    c12.7-5.5,56.5,11.6,59.8,7.9c6.6-21.5,0.4-31.1,16.7-49c4.4-4.8,17.8,2.5,20.6-6.7c1.3-5.6,2.9-24,2.9-29.4
                                    C904.1,714.4,896.3,711,886.6,708.2z"/>
                                <path class="st1" d="M947.7,577.6c3.2-2.2,10.4-4.7,9.7-12.4c-3.2-10.1-11.2-13-19.6-14.3c0.4,0.9,0.8,1.8,1.2,2.8
                                    c0.7,6.9-6.2,9.2-9.3,11.2c0,11.3,24.6,25.9,6.4,39.6c-25.4,13-114.2-21.9-127,3.9c-3.2,22.9,2.6,41.4,16,54.5
                                    c-3.7-10.9-4.8-23.4-3-37.5c13.3-28.4,105.7,10,132.2-4.3C973.4,606,947.7,590,947.7,577.6z"/>
                                <path class="st1" d="M126.1,806.3c1-4.2,2.1-8,3.4-11.4c3.3-4.4,18.9-9,19.7-11.6c0-6.1-51.1-47.9-61-55.3
                                    c-2.1-3.4-3.5-6.5-4.3-9.3c-12.6,6.6-25.7,16.1-12.6,38.1C78.9,763,110.5,790.1,126.1,806.3z"/>
                                <path class="st1" d="M97,695c6.9-3.8,14.4-6.4,17.7-9.6c2-6,0.4-10.7-3.1-15.8c-15.9-10.7-39.5-0.9-50.9-19.8
                                    c-1.4-7.1,2.1-17.5,5.9-26c-0.2,0-0.4-0.1-0.6-0.1c-4.4-3.1-9.3,1.7-9.1,2.3c0,0-17.1,29.5-14.3,45c11.8,20.8,36.4,10.1,53,21.8
                                    C96.1,693.5,96.5,694.2,97,695z"/>
                                <path class="st1" d="M138.7,445.9c-13.5,27.9,1.4,33.2-19.1,57.6c3.1-0.1,6.3-0.1,9.4-0.2c27.8-27.4,9.8-30.7,23.9-58.2
                                    c6.2-3.3,12.3-6.6,18.5-9.9c9.9-19.2-31.9-71-45.1-79.5c0.6-0.1,1.3-0.2,1.9-0.3c-1.5-0.7-3-1.4-4.5-2c-8.2-11,12.2-34.3,8.7-37.8
                                    c-9.2-9.2-17.4-13.8-12.1-29.6c3.9-2,7.8-4.1,11.7-6.1c3.6-3.5,3-11.6-0.3-14.9c-4.4-1.5-8.9-2.3-13.3-3.1
                                    c-0.4,0.9-0.9,1.7-1.5,2.4c-4.1,2.2-8.1,4.5-12.2,6.7c-5.5,17.3,3.1,22.4,12.6,32.5c3.6,3.8-17.6,29.4-9,41.5
                                    c1.5,0.7,3.1,1.5,4.6,2.2c-0.7,0.1-1.3,0.2-2,0.3c13.8,9.3,57.3,66.3,47,87.4C151.5,438.6,145.1,442.2,138.7,445.9z"/>',
                $gradID);
        }
        $mask = '<path id="%1$s" d="M126.3,355.6c13.2,8.5,55,60.3,45.1,79.5c-6.2,3.3-12.3,6.6-18.5,9.9c-14,27.5,3.9,30.8-23.9,58.2
                    c-12.4,0.2-24.8,0.4-37.1,0.6c-0.2,0.3-0.4,0.6-0.6,1c-0.1,0.5-0.2,1.1-0.3,1.6c0,22.2,20.2,38.3,13.1,70.6
                    c-19.4,4.3-3.3,33.4-21,29.8c-4.2-2.8-8.9,1.6-8.8,2.1c0,0-16.4,26.8-13.7,40.9c11.3,18.9,35,9.2,50.9,19.8
                    c3.4,5.1,5.1,9.8,3.1,15.8c-8.3,8.2-45.2,12.7-26.5,42.6c9.9,7.4,61,49.2,61,55.3c-0.9,2.5-16.4,7.1-19.7,11.6
                    c-9.1,24.1-11.1,72,7.1,91.6c15.1,16.3,87.7,26.3,105.5,7.6c12.2,0,21,10.1,34.5,4.4c29-12.2,48.6-41.4,79-50.8
                    c21.9-6.8,26.5-45.6,53.9-45.6c10.3,6.9,71.6,19.7,73.6,15.5c3.1-4.7,0.7-8.3,5.7-13.5c7.3,3.8,9.9,9.9,18.3,11.6
                    c2.3,0.1,3.9-1.5,4-2.2c0.1,0.3,35.8,43.5,35.8,43.5c9.1,5,15.4,1.4,22.9,10.4c4.5,20.2,9.1,40.4,13.6,60.6
                    c9.4,16.9,52.3,10.3,66.2,10.3c1.7-4.6,3.4-9.2,5.2-13.8c8.5-10.8,20.8-19.8,28.3-30.5c6.7-9.6,17.9-45.7,18.5-46.8
                    c-0.1-12-0.1-24-0.2-36c2.8-8.6,15.3-1.9,19.5-1.9c0.8,1.6,17.2,16.7,17.2,16.7c3-1.1,6-2.3,9.1-3.4c3.4,2.9,6.7,5.9,10.1,8.8
                    c8.6-2.2,15.6-21.7,14.6-30.9c-2.5-3.3-4.9-6.6-7.4-9.8c1.7-1.2,7.1-5.8,8.1-10.6c2.4,1-1.1,5.1,2.1,5.1c6.1-1.1,12.1-2.1,18.2-3.2
                    c1.9-0.3,2.7-1.5,1.4-4.1c-2.2-3.3-4.5-6.5-6.8-9.8c1.3-1.5,2.5-3.1,3.8-4.6c12.2-5,54.2,10.6,57.4,7.2c6.3-19.6,0.4-28.3,16.1-44.6
                    c4.2-4.4,17,2.3,19.8-6.1c1.2-5,2.8-21.9,2.8-26.7c0.2-5.8-17.6-10-32.3-13.2c-34-10.3-51.3-35.5-46.3-71.6
                    c12.8-25.8,101.5,9.1,127-3.9c18.2-13.8-6.4-28.3-6.4-39.6c3.1-2,9.9-4.3,9.3-11.2c-6.4-19-32.1-9.8-41.2-18.9
                    c-5.6-11.2,15.2-50.5,13.2-55.5c-2.8-1.8-5.5-3.6-8.3-5.4c0-12,0-23.9,0-35.9c-9-12.5-84.3-38.3-105.1-53.1
                    c-33.7-24.2-7.2-33.2-16.4-45.5c-6.1-4.1-29.9-26.1-27.3-34c12.1-12.4,23.7-76.8,13.9-80.7c-10.6,0.8-21.2,1.5-31.8,2.3
                    c-0.9-2.1-1.8-4.2-2.7-6.3c3.7-2,7.4-3.9,11-5.9c26.1-61.8-54.8-34.4-66.9-46.5c-0.2-0.9-0.3-1.8-0.5-2.7c2.4,0.6,5.1-0.2,2.1-3.4
                    c-9.9-9.9-6.4-30.7-21-54.7c-14.5-23.1-64.8-23.6-87-20.8c-14.4,5.9-28.8,11.8-43.2,17.6c-12.7,2.8-48.9-22.3-57.8-6.7
                    c-0.9,5-3.1,13.4-9.5,13.4c-2.7-2.2-5.4-4.3-8.1-6.5c-3.5,0.6-6.9,1.2-10.4,1.8c-0.5,3.2-1,6.5-1.5,9.7
                    c-9.5,9.1-36.3-26.9-37.4-31.6c5.3-6.9,10.5-13.7,15.8-20.6c-7.4-5.5-14.7-11-22.1-16.6c-20.3,0-25.6,35.3-36.1,43.7
                    c-7,0.2-13.9,0.5-20.9,0.7c-1.7,3.9-3.5,7.8-5.2,11.8c-7.1-0.4-14.3-0.8-21.4-1.1c-19.2,3.5-79.7,33.3-64.2,64.4
                    c22.7,11.3,58.8-6.3,78.5,6.1c4.7,7.9,8.6,19.2,5.5,28.3c-16.5,0.5-33,1-49.5,1.5c-1.7,2.5-3.5,5-5.2,7.5c-4.4-1.3-8.8-2.6-13.2-3.9
                    c-11.9,4.7,16.9,24.8,16.9,30.1c-0.3,0.6-0.7,1.2-1,1.8c-6.4,3.1-22.7-0.6-28-4.2c-4-9.2-8-18.4-12.1-27.7
                    c-6.3-6.6-55.4-42.6-66.7-43.2c-45.5-2.3-72.1,32.8-81.5,69.7c-1.7,6.7-5.7,15.2-1.1,21.4c12.9,7.3,26.5,6.3,39.9,10.7
                    c3.3,3.3,3.9,11.4,0.3,14.9c-3.9,2-7.8,4.1-11.7,6.1c-5.3,15.8,2.9,20.4,12.1,29.6c3.5,3.5-16.9,26.7-8.7,37.8c1.5,0.7,3,1.4,4.5,2
                    C127.6,355.4,126.9,355.5,126.3,355.6z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape10($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M43.8,341.7c7.5,3.4,15,7.8,23.7,7.1c-1.6-0.8-3.3-1.5-4.9-2.3c-4.5-2-8.4-6-11.6-10
                                    c-5.4-6.7-3.6-15.2,4.3-18.7c6.2-2.8,13.2-4.7,20-5.6c13-1.7,23.1-8.1,25.6-20.1c0.9-4.5,1.4-10.3-0.6-13.9
                                    c-6-10.6-6.8-22.1-7-33.4c-0.4-22.1-4.5-43.5-8.6-65c-1.2-6.1-1-12.6-0.5-18.9c0.9-11.4,11.7-16.7,24.5-18.5
                                    c4.6-0.6,9.3-0.9,13.9-1.1c3.8-0.1,4.4-1.8,3.3-5c-0.9-2.6-1.7-5.3-2.6-7.9c-1.9-5.6-0.6-9,5.4-10.5c6.8-1.6,13.9-2.7,20.9-3.3
                                    c15.3-1.3,28.7-7.5,42-14.5c11.3-6,22.7-11.8,34.5-16.6c10.9-4.4,22.1-8.3,33.6-10.7c7-1.5,14.8-0.5,22.1,0.6
                                    c1.4,0.2,3,1.2,4.4,2.6c-1.8-5.2-3.6-10.4-5.6-15.4c-1.2-3-4.7-6.7-7.6-7.1c-7.6-1.2-15.7-2.2-23.1-0.6c-12,2.6-23.7,6.6-35.1,11.3
                                    c-12.3,5.1-24.3,11.2-36.1,17.5c-13.9,7.4-27.9,14-43.9,15.4c-7.3,0.6-14.7,1.7-21.8,3.5c-6.2,1.5-7.6,5.1-5.6,11
                                    c0.9,2.8,1.8,5.6,2.7,8.4c1.2,3.4,0.5,5.2-3.5,5.3c-4.9,0.1-9.7,0.5-14.5,1.1c-13.4,1.9-24.7,7.5-25.6,19.5
                                    c-0.5,6.6-0.7,13.5,0.5,19.9c4.3,22.7,8.6,45.3,9,68.6c0.2,12,1,24.1,7.3,35.3c2.2,3.8,1.6,10,0.7,14.7
                                    c-2.6,12.7-13.2,19.4-26.8,21.2c-7.1,0.9-14.4,2.9-20.9,5.9c-8.2,3.8-10.1,12.7-4.5,19.8C35,335.3,39.1,339.5,43.8,341.7z"/>
                                <path class="st1" d="M267.4,136.5c-4.9,1.5-10.4,1.4-15.6,1.1c0,3.5,1.1,7.4,3.4,11.5c1.1,2,4.1,3.9,6.4,4.1c5,0.3,10.3,0.4,14.9-1
                                    c9.2-2.8,19.6-2.7,27.4-9.6c1.2-1.1,2.9-2,4.4-2.2c16.4-1.7,32.8-4.1,49.2-4.3c9.5-0.1,16.2-2.6,21.8-9.8
                                    c7.1-9.1,16.1-16.2,26.6-20.5c11.5-4.6,23.7-6.7,34.8,2.1c2.9,2.3,5.9,5,9.4,5.9c3.9,1,8.7,1.6,12.2,0.1
                                    c14.9-6.3,28.8-15,44.9-18.7c13.6-3.2,27.1-7.3,40.5-11.5c16.2-5.1,32.1-10.9,48.2-16.3c6.7-2.2,13.4-4.2,20.2-6
                                    c0.3-0.1,0.7-0.1,1-0.1c-1.1-2.6,0-5.4,3-8.5c2.1-2.1,4.3-4,6-6.4c0.9-1.2,1.2-3.6,0.6-4.8c-0.5-0.9-3.1-1.2-4.5-0.9
                                    c-7.1,1.9-14.1,4-21.1,6.4c-16.8,5.7-33.5,11.8-50.4,17.2c-14,4.5-28,8.8-42.3,12.1c-16.8,3.9-31.3,13.1-46.9,19.7
                                    c-3.6,1.5-8.7,1-12.8-0.1c-3.6-1-6.8-3.8-9.8-6.2c-11.6-9.3-24.3-7.1-36.4-2.3c-11,4.4-20.4,12-27.8,21.6
                                    c-5.8,7.6-12.9,10.3-22.8,10.4c-17.2,0.2-34.3,2.8-51.4,4.5c-1.6,0.2-3.4,1.2-4.6,2.3C287.9,133.7,277.1,133.6,267.4,136.5z"/>
                                <path class="st1" d="M620.6,65.1c-0.1,0.7-0.4,1.3-0.7,1.7c-1.6,2.2-3.8,4.1-5.7,6c-4.7,4.7-4.4,8.7,1.2,12.2
                                    c12.3,7.5,26.1,10.2,39.9,12.6c5.7,1,11.4,1.6,17.1,2.2c3.6,0.4,4.3,2.6,2.6,4.9c-5.6,7.9-4.9,16.5-3.7,25.2
                                    c0.2,1.7,0.3,3.2,0.2,4.7c6.3-5.4,9.7-12.2,8.4-21.5c-1.3-9.2-2-18.3,3.8-26.6c1.8-2.5,1-4.8-2.7-5.2c-6-0.6-12-1.3-17.9-2.4
                                    c-14.5-2.6-28.9-5.4-41.7-13.3C621.2,65.5,620.9,65.3,620.6,65.1z"/>
                                <path class="st1" d="M29,535.1c-0.6-8.9,4.6-15,9.8-21.1c2.9-3.4,6.1-6.5,9.2-9.6c7.3-7.3,9.3-16.6,10.3-26.4
                                    c0.8-7.8,2.7-14.6,9.4-19.8c11.1-8.7,22.3-17.3,32.4-27.1c8.5-8.2,15.7-17.7,22.8-27.2c10-13.4,22.3-23.4,38.4-28.6
                                    c13.4-4.4,26-10.7,36.9-19.9c4.5-3.8,7.3-8.5,6.6-14.6c-0.2-1.8-1.5-4.3-2.9-4.8c-3.3-1.2-6.9-2.6-10.3-2.9
                                    c0.4,0.9,0.7,1.8,0.8,2.6c0.8,6.4-2.2,11.4-6.9,15.4c-11.4,9.7-24.5,16.4-38.5,21c-16.8,5.6-29.6,16-40.1,30.2
                                    c-7.4,10-15,20-23.9,28.7c-10.5,10.3-22.2,19.4-33.8,28.6c-7,5.5-9,12.8-9.8,20.9c-1,10.3-3.1,20.1-10.8,27.8
                                    c-3.3,3.3-6.7,6.6-9.7,10.1c-5.4,6.4-10.9,12.9-10.3,22.3c0.5,7.2,4.9,9.5,11.5,6.8c4.6-1.9,9.2-3.8,13.9-5.1
                                    C31.2,541.9,29.3,539.5,29,535.1z"/>
                                <path class="st1" d="M861.8,338.1c-5.2-2.8-10.4-5.6-10.3-13.2c0.1-4.7-1-9.3-1.4-14c-1.8-19.5-2.9-39.1-5.8-58.4
                                    c-1.6-10.9,2.4-16.6,11.2-21c1.7-0.8,2.5-3.4,4.6-6.3c-3.4,0-5,0.1-6.5,0c-13.6-0.6-26.5,3.2-39.3,6.8c-9.9,2.8-19.6,6.1-29.3,9.4
                                    c-15.2,5.1-29.9,11.9-45.4,15.4c-28,6.4-56.4,4-84.8,2c-13.4-0.9-26.8-1.3-40.2-1.4c-10.5-0.1-21,1.1-31.5,0.8
                                    c-4.2-0.1-8.7-0.3-12.5-3c-0.6,0.3-1.1,0.5-1.7,0.8c-2.2,1-3.9,3-6,4.7c4,6.4,10.2,6.6,15.7,6.7c10,0.3,20.1-0.8,30.1-0.7
                                    c12.8,0.1,25.7,0.4,38.5,1.3c27.1,1.9,54.4,4.1,81.1-1.9c14.8-3.4,29-9.7,43.5-14.6c9.3-3.1,18.6-6.2,28-8.9
                                    c12.3-3.4,24.6-7,37.6-6.4c1.5,0.1,2.9,0,6.2,0c-1.9,2.8-2.7,5.2-4.4,6c-8.4,4.2-12.3,9.5-10.8,19.9c2.8,18.3,3.8,36.9,5.5,55.4
                                    c0.4,4.4,1.4,8.9,1.3,13.3c-0.1,7.8,5.7,10.2,11,13.1c4.6,2.6,7.7-1.2,11.1-3.2C859,339.7,860.4,338.9,861.8,338.1z"/>
                                <path class="st1" d="M849.1,427.2c-12.5,9.5-25,19-37.5,28.5c-5.9,4.5-12.3,8.5-15.2,15.7c-0.7,1.7-0.4,3.9-0.5,5.9
                                    c1.7,0.1,3.4,0.3,5,0.2c3.3-0.2,6.4-0.8,9.3-1.7c0.1-0.8,0.2-1.6,0.5-2.3c3.1-7.6,9.8-11.9,15.9-16.6c13.1-10,26.1-20,39.2-30.1
                                    c6.7-5.2,13.2-10.9,20.2-15.7c11.2-7.6,23-14.3,34.2-21.9c4.1-2.8,9.3-6,7.6-13.7c-6.5,1.5-12.8,3.2-19.1,4.7
                                    c0.6,6.1-3.9,8.9-7.5,11.3c-10.7,7.3-22,13.6-32.7,20.8C861.7,416.9,855.6,422.3,849.1,427.2z"/>
                                <path class="st1" d="M40.8,541.2c4.3-0.4,8.6,0.1,13.2,1.9c3.7,1.5,5.9,0.2,6.6-3.9c0.2-1.3,0.5-2.5,0.8-3.8
                                    C54.4,535.7,47.6,538.5,40.8,541.2z"/>
                                <path class="st1" d="M949.7,300c-10,2.4-19.9,5.3-29.3,9.3c3-0.8,6-1.6,9-2.3c2.7-0.6,5.7-0.4,8.5-0.5c0.2,0.5,0.4,1,0.6,1.4
                                    c-2.7,3.2-5.3,6.3-8,9.4c-6.6,7.5-13.1,15.1-20.1,22.3c-3.1,3.2-7.5,5.2-10.6,8.5c-8.7,9.2-19.4,15.2-30.8,20.3
                                    c-4.5,2-9,4.3-13.3,6.9c-1.8,1.1-4.3,3.6-4.1,5.1c0.3,2,2.9,5.1,4.7,5.2c7.7,0.4,15.6,0.6,23.2-0.5c3.4-0.5,6.7-1.2,10.1-1.9
                                    c-5.4,0.3-10.9,0.1-16.3-0.2c-1.8-0.1-4.6-3.4-4.9-5.5c-0.3-1.6,2.3-4.2,4.3-5.4c4.4-2.7,9.1-5.1,13.9-7.2
                                    c11.9-5.4,23-11.7,32.2-21.4c3.2-3.4,7.8-5.5,11-8.9c7.2-7.6,14-15.6,21-23.6c2.9-3.3,5.6-6.6,8.4-10c-0.2-0.5-0.4-1-0.6-1.5
                                    C955.6,299.7,952.5,299.4,949.7,300z"/>
                                <path class="st1" d="M991.2,89.9c-8.2,1.8-16.4,3.5-24.6,5.6c-4.3,1.1-7.2-0.4-6-4.5c1.2-4.2,4.3-8,6.8-11.7
                                    c1.2-1.7,3.4-2.7,4.5-4.5c1.9-3.1,1.7-5.7-3-5.5c-6.2,0.3-12.5,0.3-18.7,0.8c-20.4,1.8-40,6.8-59,14.1c-14.5,5.5-28.9,11-43.3,16.7
                                    c-5.4,2.1-10.5,4.9-15.9,7.1c-8.9,3.7-17.7,7.5-26.8,10.7c-4.1,1.5-8.8,1.4-13.2,2.3c-18.7,3.9-37.4,7.7-56,12
                                    c-9.4,2.2-18.7,4.8-27.8,8.1c-10.5,3.8-20.5,9.2-31.1,12.5c-5,1.6-11.2,0.7-16.5-0.6c-0.2,0-0.3-0.1-0.4-0.1c0,0-0.1,0.1-0.1,0.1
                                    c-3,2.1-5.9,4.5-8.6,7c-3.7,3.4-3.4,6.6,1.4,7.7c5.1,1.2,11,2,15.8,0.5c10.2-3.1,19.7-8.3,29.7-11.8c8.7-3.1,17.6-5.6,26.6-7.7
                                    c17.8-4.1,35.7-7.7,53.6-11.4c4.2-0.9,8.6-0.8,12.6-2.2c8.7-3,17.1-6.6,25.6-10.1c5.1-2.1,10-4.7,15.2-6.8
                                    c13.8-5.4,27.6-10.6,41.4-15.8c18.2-6.9,37-11.7,56.5-13.4c5.9-0.5,11.9-0.5,17.9-0.8c4.5-0.2,4.7,2.3,2.9,5.2
                                    c-1,1.7-3.2,2.6-4.3,4.2c-2.4,3.6-5.4,7.1-6.5,11.1c-1.1,3.9,1.7,5.3,5.8,4.3c4.2-1,8.4-2,12.5-2.9c0.2-0.1,0.4-0.3,0.6-0.4
                                    c7.7-4.6,16.4-7.7,24.5-11.8c3.2-1.6,6-4.2,8.9-6.4C991.8,91.1,991.5,90.5,991.2,89.9z"/>
                                <path class="st1" d="M210.8,605.8c9.5,2.4,12.1,7.4,7.5,13.9c3.1-2,6.1-4.3,8.7-6.9c7.6-7.5,5.9-13.5-4.6-16.1
                                    c-5.6-1.4-11.4-2.7-17-2.5c-17.2,0.6-34.5,1.8-51.7,3c-1.9,0.1-3.8,1.4-5.6,2.3c-4.1,2-6.6,0.9-10.5-2.1c-8.8-7-9.7-14.8-5.5-24.1
                                    c5.8-13,0-23.5-6.9-33.7c-6.2-9-13.3-17.2-22.5-23.5c-8.7-6-15.8-5-19.7,2.9c0.9,0.5,1.8,1,2.7,1.7c9.7,6.7,17.1,15.3,23.6,24.9
                                    c7.2,10.7,13.3,21.9,7.3,35.5c-4.3,9.8-3.5,18,5.8,25.5c4.1,3.3,6.7,4.4,11,2.3c1.9-0.9,3.8-2.3,5.8-2.4c18-1.2,36-2.6,54-3.2
                                    C198.9,603,205,604.3,210.8,605.8z"/>
                                <path class="st1" d="M913.8,419.9c-2.3,0.5-4.7,1.2-7,2c6.6,3.5,10.1,11.5,11.6,19.7c2.8,15.8,0.3,31.4-1.6,47.1
                                    c-1.8,15.3-5.1,30.6-4.7,45.9c1.1,42.1-9.2,81.1-30,117.2c-12.6,21.8-27.6,42.2-41,63.5c-6.9,11-12.8,22.5-19.1,33.9
                                    c-5.1,9.3-9.3,19.1-15.3,27.8c-3.5,5-9.4,8.8-14.9,11.9c-8,4.6-16.5,8.3-24.9,12.1c-7.2,3.3-14.6,6.3-21.9,9.4
                                    c-1,0.4-2.4,0.7-2.9,1.5c-5.8,9.8-18.3,11.2-24.9,20.3c-6.3,8.6-14,16.3-21.8,23.7c-6,5.8-12.6,10.9-19.4,15.6
                                    c-15,10.4-30.2,20.7-45.7,30.3c-8.9,5.5-18.5,10.2-28.2,14.2c-10.2,4.2-20.7,8.1-31.4,10.5c-16.5,3.7-33.3,2.2-50,0.5
                                    c-11.2-1.1-22.4-2.9-33.4-5.4c-7.7-1.7-15.3-4.5-22.4-7.9c-18.8-8.9-38-14.2-59.1-11.1c-10.1,1.5-20.4,1.2-30.5,2.7
                                    c-17,2.5-33.8,6.4-50.8,8.5c-17.3,2.1-34.8,2.9-52.2,4.1c-3.7,0.3-5-2.3-4.6-5.5c1.3-10.6,2.5-21.3,4.2-31.9
                                    c2.1-12.8,5.6-25.3,3.8-38.6c-1.4-10.7-7.9-16.5-17.2-19.6c-13.7-4.6-27.9-3.3-42.1-2.7c-9.7,0.4-19.4,0.9-29,0.4
                                    c-5.1-0.3-10.8-1.1-11.9-8.5c-0.2-1.4-4.7-2.1-7.1-3.2c-1.5-0.7-3-1.7-4.5-2.6c1.1-1.6,2.2-3.2,3.4-4.6c0.6-0.7,1.4-1.2,2.2-1.7
                                    c7.7-4.5,8.2-8.4,2-15.2c-1.1-1.2-2.2-2.6-3.5-3.6c-7.3-6.2-6.2-13.5-3.3-21.3c2.2-6.1,3.8-12.4,5.8-18.5c0.4-1.3,1.1-3,2.2-3.7
                                    c5.3-3.2,4-7.5,2.1-11.6c-2.5-5.6-5.5-10.9-8.4-16.3c-3.2-5.9-4.4-11.3,1.6-16.3c6.9-5.7,3.8-13.2,3.2-20.2c-0.3-2.9-0.6-5.9-1-8.8
                                    c-0.7-5.5,0.4-10,2.8-13.9c-1.1,0.7-2.2,1.3-3.2,2c-8.9,5.6-14.9,13.2-13.5,24.7c0.4,3.1,0.7,6.2,1,9.3c0.7,7.4,3.9,15.3-3.4,21.3
                                    c-6.3,5.3-5,11.1-1.7,17.2c3,5.7,6.1,11.3,8.8,17.2c2,4.3,3.4,8.9-2.2,12.3c-1.1,0.7-1.9,2.5-2.3,3.9c-2.1,6.5-3.7,13.2-6,19.5
                                    c-3,8.3-4.2,16,3.4,22.5c1.3,1.1,2.4,2.5,3.6,3.8c6.5,7.2,6,11.3-2.1,16.1c-0.8,0.5-1.7,1-2.3,1.8c-1.3,1.6-2.4,3.3-3.6,4.9
                                    c1.5,0.9,3,2,4.7,2.7c2.6,1.2,7.2,1.9,7.5,3.4c1.2,7.7,7.1,8.7,12.4,8.9c10.1,0.5,20.2,0,30.3-0.4c14.8-0.6,29.6-2,44,2.9
                                    c9.7,3.3,16.6,9.4,18,20.7c1.8,14-1.8,27.2-4,40.7c-1.8,11.2-3.1,22.4-4.4,33.7c-0.4,3.3,1,6,4.9,5.8c18.2-1.3,36.5-2.1,54.6-4.3
                                    c17.8-2.2,35.3-6.3,53.1-9c10.5-1.6,21.3-1.3,31.9-2.8c22-3.2,42.1,2.3,61.8,11.7c7.5,3.6,15.4,6.5,23.4,8.4
                                    c11.5,2.6,23.2,4.5,34.9,5.7c17.4,1.8,35,3.4,52.3-0.5c11.2-2.6,22.2-6.6,32.9-11.1c10.1-4.2,20.1-9.2,29.5-15
                                    c16.2-10.1,32.1-21,47.8-32c7.1-5,14-10.4,20.3-16.5c8.1-7.9,16.2-16,22.7-25.1c7-9.7,20-11.1,26.1-21.4c0.5-0.9,2-1.2,3.1-1.6
                                    c7.6-3.3,15.4-6.5,22.9-9.9c8.8-4,17.7-7.9,26-12.8c5.7-3.3,11.9-7.3,15.6-12.6c6.3-9.1,10.6-19.5,16-29.3
                                    c6.5-12,12.7-24.2,19.9-35.8c14-22.5,29.7-44,42.9-67c21.8-38.1,32.5-79.2,31.3-123.7c-0.4-16.1,3.1-32.3,5-48.4
                                    c2-16.5,4.6-33,1.7-49.7C935.8,429.3,928.8,416.8,913.8,419.9z"/>',
                $gradID);
        }
        $mask = '<path id="%1$s" d="M970.1,109.8c-2.8,2-5.5,4.5-8.5,6c-7.7,3.9-16,6.8-23.4,11.2c-7.9,4.7-15.4,10.3-22.5,16.1
                    c-10.9,8.9-22.7,15-36.9,16.2c-12.4,1-23.6,5.5-34.7,10.8c-17.6,8.4-34.4,18.7-54,22.8c-18.6,3.9-37,8.8-55.5,13.3
                    c-16.9,4.1-33.9,7.9-50.5,12.7c-17.3,5.1-34.3,11.5-51.5,16.9c-15.9,4.9-32,9.1-47.9,13.8c-5.3,1.6-10.4,3.8-15.5,6.1
                    c-2.2,1-3.9,3-6,4.7c4,6.4,10.2,6.6,15.7,6.7c10,0.3,20.1-0.8,30.1-0.7c12.8,0.1,25.7,0.4,38.5,1.3c27.1,1.9,54.4,4.1,81.1-1.9
                    c14.8-3.4,29-9.7,43.5-14.6c9.3-3.1,18.6-6.2,28-8.9c12.3-3.4,24.6-7,37.6-6.4c1.5,0.1,2.9,0,6.2,0c-1.9,2.8-2.7,5.2-4.4,6
                    c-8.4,4.2-12.3,9.5-10.8,19.9c2.8,18.3,3.8,36.9,5.5,55.4c0.4,4.4,1.4,8.9,1.3,13.3c-0.1,7.8,5.7,10.2,11,13.1
                    c4.6,2.6,7.7-1.2,11.1-3.2c10.1-5.8,19.9-11.9,30-17.8c13-7.6,27.2-12.3,41.9-15.7c2.7-0.6,5.7-0.4,8.5-0.5c0.2,0.5,0.4,1,0.6,1.4
                    c-2.7,3.2-5.3,6.3-8,9.4c-6.6,7.5-13.1,15.1-20.1,22.3c-3.1,3.2-7.5,5.2-10.6,8.5c-8.7,9.2-19.4,15.2-30.8,20.3
                    c-4.5,2-9,4.3-13.3,6.9c-1.8,1.1-4.3,3.6-4.1,5.1c0.3,2,2.9,5.1,4.7,5.2c7.7,0.4,15.6,0.6,23.2-0.5c9.6-1.4,19-4.2,28.9-6.5
                    c1.6,7.3-3.4,10.3-7.2,12.9c-10.7,7.3-22,13.6-32.7,20.8c-6.7,4.5-12.9,9.9-19.3,14.9c-12.5,9.5-25,19-37.5,28.5
                    c-5.9,4.5-12.3,8.5-15.2,15.7c-0.7,1.7-0.4,3.9-0.5,5.9c1.7,0.1,3.4,0.3,5,0.2c15.3-1.1,26.8-9.9,38.2-18.8
                    c13.4-10.5,26.4-21.4,40.1-31.5c4.5-3.3,10.3-5.4,15.8-6.5c14.4-3,21.1,8.9,23.3,21c2.8,15.8,0.3,31.4-1.6,47.1
                    c-1.8,15.3-5.1,30.6-4.7,45.9c1.1,42.1-9.2,81.1-30,117.2c-12.6,21.8-27.6,42.2-41,63.5c-6.9,11-12.8,22.5-19.1,33.9
                    c-5.1,9.3-9.3,19.1-15.3,27.8c-3.5,5-9.4,8.8-14.9,11.9c-8,4.6-16.5,8.3-24.9,12.1c-7.2,3.3-14.6,6.3-21.9,9.4
                    c-1,0.4-2.4,0.7-2.9,1.5c-5.8,9.8-18.3,11.2-24.9,20.3c-6.3,8.6-14,16.3-21.8,23.7c-6,5.8-12.6,10.9-19.4,15.6
                    c-15,10.4-30.2,20.7-45.7,30.3c-8.9,5.5-18.5,10.2-28.2,14.2c-10.2,4.2-20.7,8.1-31.4,10.5c-16.5,3.7-33.3,2.2-50,0.5
                    c-11.2-1.1-22.4-2.9-33.4-5.4c-7.7-1.7-15.3-4.5-22.4-7.9c-18.8-8.9-38-14.2-59.1-11.1c-10.1,1.5-20.4,1.2-30.5,2.7
                    c-17,2.5-33.8,6.4-50.8,8.5c-17.3,2.1-34.8,2.9-52.2,4.1c-3.7,0.3-5-2.3-4.6-5.5c1.3-10.6,2.5-21.3,4.2-31.9
                    c2.1-12.8,5.6-25.3,3.8-38.6c-1.4-10.7-7.9-16.5-17.2-19.6c-13.7-4.6-27.9-3.3-42.1-2.7c-9.7,0.4-19.4,0.9-29,0.4
                    c-5.1-0.3-10.8-1.1-11.9-8.5c-0.2-1.4-4.7-2.1-7.1-3.2c-1.5-0.7-3-1.7-4.5-2.6c1.1-1.6,2.2-3.2,3.4-4.6c0.6-0.7,1.4-1.2,2.2-1.7
                    c7.7-4.5,8.2-8.4,2-15.2c-1.1-1.2-2.2-2.6-3.5-3.6c-7.3-6.2-6.2-13.5-3.3-21.3c2.2-6.1,3.8-12.4,5.8-18.5c0.4-1.3,1.1-3,2.2-3.7
                    c5.3-3.2,4-7.5,2.1-11.6c-2.5-5.6-5.5-10.9-8.4-16.3c-3.2-5.9-4.4-11.3,1.6-16.3c6.9-5.7,3.8-13.2,3.2-20.2c-0.3-2.9-0.6-5.9-1-8.8
                    c-1.4-10.9,4.3-18.1,12.9-23.4c11.2-6.9,22.7-13.2,33.9-19.9c3.6-2.2,7.1-4.8,10.1-7.8c7.6-7.5,5.9-13.5-4.6-16.1
                    c-5.6-1.4-11.4-2.7-17-2.5c-17.2,0.6-34.5,1.8-51.7,3c-1.9,0.1-3.8,1.4-5.6,2.3c-4.1,2-6.6,0.9-10.5-2.1c-8.8-7-9.7-14.8-5.5-24.1
                    c5.8-13,0-23.5-6.9-33.7c-6.2-9-13.3-17.2-22.5-23.5c-10.1-6.9-18.1-4.6-21.3,7.3c-0.9,3.4-1.9,6.8-2.6,10.3
                    c-0.7,3.9-2.8,5.1-6.3,3.7c-11.6-4.6-22.1,0.1-32.4,4.2c-6.2,2.5-10.5,0.4-11-6.5c-0.6-8.9,4.6-15,9.8-21.1c2.9-3.4,6.1-6.5,9.2-9.6
                    c7.3-7.3,9.3-16.6,10.3-26.4c0.8-7.8,2.7-14.6,9.4-19.8c11.1-8.7,22.3-17.3,32.4-27.1c8.5-8.2,15.7-17.7,22.8-27.2
                    c10-13.4,22.3-23.4,38.4-28.6c13.4-4.4,26-10.7,36.9-19.9c4.5-3.8,7.3-8.5,6.6-14.6c-0.2-1.8-1.5-4.3-2.9-4.8
                    c-4.1-1.5-8.6-3.3-12.8-2.9c-10.3,0.9-20.6,2.4-30.8,4.5c-16.6,3.4-33.2,7.4-49.7,11.1c-6.7,1.5-13.4,2.6-20,4.2
                    c-9.7,2.2-17.8-2.6-25.9-6.2c-4.5-2-8.4-6-11.6-10c-5.4-6.7-3.6-15.2,4.3-18.7c6.2-2.8,13.2-4.7,20-5.6c13-1.7,23.1-8.1,25.6-20.1
                    c0.9-4.5,1.4-10.3-0.6-13.9c-6-10.6-6.8-22.1-7-33.4c-0.4-22.1-4.5-43.5-8.6-65c-1.2-6.1-1-12.6-0.5-18.9
                    c0.9-11.4,11.7-16.7,24.5-18.5c4.6-0.6,9.3-0.9,13.9-1.1c3.8-0.1,4.4-1.8,3.3-5c-0.9-2.6-1.7-5.3-2.6-7.9c-1.9-5.6-0.6-9,5.4-10.5
                    c6.8-1.6,13.9-2.7,20.9-3.3c15.3-1.3,28.7-7.5,42-14.5c11.3-6,22.7-11.8,34.5-16.6c10.9-4.4,22.1-8.3,33.6-10.7
                    c7-1.5,14.8-0.5,22.1,0.6c2.8,0.4,6.2,3.9,7.3,6.7c4.1,10.1,7.4,20.5,10.6,30.9c0.3,1.1-2.2,4.1-3.8,4.5c-9.1,2.2-18.4,3.8-27.6,5.8
                    c-15.1,3.2-20.4,14.3-12.8,27.8c1.1,2,4.1,3.9,6.4,4.1c5,0.3,10.3,0.4,14.9-1c9.2-2.8,19.6-2.7,27.4-9.6c1.2-1.1,2.9-2,4.4-2.2
                    c16.4-1.7,32.8-4.1,49.2-4.3c9.5-0.1,16.2-2.6,21.8-9.8c7.1-9.1,16.1-16.2,26.6-20.5c11.5-4.6,23.7-6.7,34.8,2.1
                    c2.9,2.3,5.9,5,9.4,5.9c3.9,1,8.7,1.6,12.2,0.1c14.9-6.3,28.8-15,44.9-18.7c13.6-3.2,27.1-7.3,40.5-11.5
                    c16.2-5.1,32.1-10.9,48.2-16.3c6.7-2.2,13.4-4.2,20.2-6c1.3-0.4,3.8,0,4.3,0.8c0.6,1.1,0.3,3.4-0.6,4.6c-1.6,2.2-3.8,4.1-5.7,6
                    c-4.7,4.7-4.4,8.7,1.2,12.2c12.3,7.5,26.1,10.2,39.9,12.6c5.7,1,11.4,1.6,17.1,2.2c3.6,0.4,4.3,2.6,2.6,4.9
                    c-5.6,7.9-4.9,16.5-3.7,25.2c1.4,10.4-3.3,17.4-11.4,23c-3,2.1-5.9,4.5-8.6,7c-3.7,3.4-3.4,6.6,1.4,7.7c5.1,1.2,11,2,15.8,0.5
                    c10.2-3.1,19.7-8.3,29.7-11.8c8.7-3.1,17.6-5.6,26.6-7.7c17.8-4.1,35.7-7.7,53.6-11.4c4.2-0.9,8.6-0.8,12.6-2.2
                    c8.7-3,17.1-6.6,25.6-10.1c5.1-2.1,10-4.7,15.2-6.8c13.8-5.4,27.6-10.6,41.4-15.8c18.2-6.9,37-11.7,56.5-13.4
                    c5.9-0.5,11.9-0.5,17.9-0.8c4.5-0.2,4.7,2.3,2.9,5.2c-1,1.7-3.2,2.6-4.3,4.2c-2.4,3.6-5.4,7.1-6.5,11.1c-1.1,3.9,1.7,5.3,5.8,4.3
                    c7.8-2,15.7-3.6,23.5-5.3C969.4,108.5,969.8,109.1,970.1,109.8z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape11($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M114,386.7c7.5,9.2,5.8,12.3-4,18.4c-7.1,4.4-14.4,9.4-19.5,15.8c-6.9,8.7-4.9,15.2,4.4,21.4
                                    c5.5,3.7,11.4,6.9,16.7,11c6.1,4.8,6.6,9,2.4,15.7c-2.8,4.5-5.8,9-9.3,12.9c-2.8,3.2-5.5,5.4-8.2,6.9c0,0,0.1,0,0.1,0
                                    c11.4,5.4,18.5,4.2,27-5.1c3.4-3.7,6.2-7.9,9-12.1c4-6.2,3.6-10.2-2.3-14.7c-5-3.9-10.7-6.9-16-10.3c-8.9-5.8-10.9-11.9-4.2-20.1
                                    c4.9-6,11.9-10.7,18.7-14.8c9.4-5.7,11-8.6,3.9-17.2c-12.6-15.1-25.9-29.7-39.3-44.1c-3.9-4.3-5.5-8.2-3.9-14
                                    c2.6-9.2,4.4-18.7,6.5-28.1c2.7-12.1,6.5-15.4,19.2-15.8c10.5-0.3,21-0.2,31.5,0.1c5.1,0.2,7.4-1,7.5-6.7c0.2-9.4,1.2-18.8,2.6-28
                                    c0.5-3.3,2.9-7.8,5.6-8.9c15-6,16.2-18.6,16.4-31.8c0.1-4.6,0.9-7.8,5.5-10c1.8-0.8,3.3-3.8,3.7-6c1.1-6.4,1.7-13,2.2-19.5
                                    c0.3-4.8,9.3-8.5,10.3-8.9c10.5-3.3,12.1-6,12.7-17c0.4-6,1.7-12,3.4-17.7c1.2-4,4.7-5.5,9-4.1c2.9,0.9,5.9,1.8,8.9,2
                                    c1.9,0.1,5-0.5,5.6-1.8c2.5-5.1,7-5.6,11.6-5.9c6.7-0.4,20-6.6,17.5-21c-0.9-4.9-1.7-9.9-2.8-14.8c-1.1-4.8,1.5-6.1,5.3-5.6
                                    c11.8,1.5,24,1.9,35.3,5.2c12.3,3.5,23.9,9.4,35.6,14.9c12.2,5.7,24.2,11,38.2,9.7c11.6-1,18.2-5.8,21.1-17.1
                                    c1.4-5.3,2.2-10.7,2.9-16.1c1.1-8.6,2.7-10,10.8-7.5c7.5,2.2,14.9,5.1,22.5,7.1c6.5,1.7,12.3,0.8,16.9-5.3
                                    c5.5-7.3,17.8-4.7,20.8,4.3c2.4,7.2,3.6,14.9,5.7,22.2c3.6,12.4,16.4,21.6,29.2,20.8c9.2-0.6,15.8-5.5,19.9-14
                                    c8.4-17.3,24.3-24,42.6-16.7c9.6,3.8,18.2,10.2,27.1,15.8c9.2,5.8,18,12.4,27.4,18.1c10,6.1,20.2,5.8,30.3-0.7
                                    c3.8-2.4,8.2-4,12.6-5.3c3.2-1,6.2-0.1,6.5,4.3c1.1,17.4,10.4,30.8,21.5,43.2c7.8,8.6,16.3,16.6,24.1,25.1
                                    c5.3,5.7,11.9,4.6,18.3,4.6c10.1,0,10.4-0.1,11,9.9c0.7,12.2,5.1,22.2,13.8,30.8c6.5,6.4,12.1,13.9,18.5,20.4
                                    c7.7,7.9,11.2,16.8,10.2,27.9c-0.4,4.1-2.3,9.6,3.9,11.8c7.8,2.8,15.7,4.2,23-1.2c1.2-0.9,1-3.5,1.5-5.3c0.5-1.5,0.8-3.4,1.3-4.9
                                    c-5,0.7-10.1-0.6-15.3-2.4c-6.5-2.4-4.5-8.3-4.1-12.6c1.1-11.8-2.6-21.3-10.6-29.7c-6.7-7-12.5-14.9-19.3-21.8
                                    c-9.1-9.2-13.7-19.9-14.4-32.9c-0.6-10.6-0.9-10.5-11.4-10.5c-6.8,0-13.6,1.2-19.1-4.9c-8.2-9.1-17.1-17.6-25.2-26.7
                                    c-11.6-13.1-21.3-27.4-22.4-46c-0.3-4.6-3.4-5.6-6.7-4.5c-4.5,1.4-9.2,3.1-13.1,5.7c-10.5,6.9-21.1,7.2-31.6,0.7
                                    c-9.7-6-18.9-13-28.5-19.3c-9.2-5.9-18.2-12.7-28.2-16.8c-19.1-7.8-35.7-0.6-44.5,17.8c-4.3,9-11.1,14.2-20.8,14.9
                                    c-13.3,0.9-26.7-8.9-30.5-22.1c-2.2-7.8-3.5-15.9-6-23.6c-3.1-9.6-16-12.3-21.7-4.6c-4.8,6.5-10.9,7.4-17.6,5.6
                                    c-7.9-2.1-15.6-5.2-23.5-7.5c-8.5-2.6-10.1-1.2-11.3,8c-0.7,5.8-1.6,11.5-3,17.1c-3.1,12-10,17.1-22.1,18.2
                                    c-14.6,1.3-27.2-4.3-39.9-10.3C321,74.4,308.8,68.1,296,64.4c-11.8-3.5-24.5-3.9-36.9-5.5c-4-0.5-6.7,0.9-5.6,6
                                    c1.2,5.2,2,10.5,2.9,15.8c2.7,15.4-11.2,22-18.2,22.4c-4.8,0.3-9.5,0.8-12.1,6.3c-0.6,1.3-3.8,2-5.8,1.9c-3.1-0.2-6.3-1.1-9.3-2.1
                                    c-4.5-1.4-8.2,0.1-9.4,4.4c-1.8,6.1-3.2,12.5-3.6,18.9c-0.7,11.7-2.3,14.5-13.3,18.1c-1.1,0.4-10.4,4.4-10.7,9.5
                                    c-0.5,7-1.1,13.9-2.3,20.8c-0.4,2.4-2,5.5-3.9,6.4c-4.8,2.3-5.7,5.7-5.7,10.6c-0.2,14.1-1.5,27.5-17.1,33.9c-2.8,1.2-5.3,6-5.8,9.5
                                    c-1.6,9.9-2.5,19.9-2.8,29.9c-0.1,6.1-2.5,7.3-7.8,7.2c-11-0.3-21.9-0.4-32.9-0.1c-13.2,0.3-17.2,3.9-20,16.8
                                    c-2.2,10-4.1,20.1-6.8,29.9c-1.7,6.2,0,10.4,4.1,14.9C86.9,355.2,100.8,370.6,114,386.7z"/>
                                <path class="st1" d="M965.9,443c5.1-21.3,4-43-0.3-64.4c-0.7-3.5-3.2-7.3-6-9.6c-10.1-8.4-21.2-15.6-30.8-24.5
                                    c-20.7-19.1-44-32-71.8-35.6c-5.1-0.7-6.9-3.8-7.2-8.5c-0.5-8.1-1-16.3-1.7-24.4c-0.2-2.6-1.1-7.2-1.9-7.2c-3-0.2-6.7,0.3-8.9,2.2
                                    c-1.9,1.6-2.1,5.3-3,8.1c-0.4,1.5-0.4,3.4-1,4.7c0.2,0,0.5,0,0.7,0c0.8,0,1.6,4.4,1.8,6.8c0.7,7.6,1.1,15.3,1.6,22.9
                                    c0.3,4.4,1.9,7.3,6.9,8c26.7,3.4,49,15.6,68.8,33.5c9.2,8.3,19.9,15.1,29.5,23c2.6,2.2,5.1,5.7,5.7,9c4.1,20.1,5.2,40.5,0.3,60.5
                                    c-1.8,7.4-5.8,14.9-10.7,20.6c-14.2,16.5-15.2,34.5-8.9,54.1c4.4,13.7,9,27.4,12.2,41.4c3.6,16.3,0.9,32.2-7.8,46.7
                                    c-4.8,8.1-9.5,16.3-14.5,24.2c-4.8,7.6-6.7,15.6-5.3,24.4c1.4,9.3-1.8,15.9-10.3,20.5c-8.5,4.6-8.2,5-4.3,13.4c3,6.3,5.7,12.8,9,19
                                    c2.5,4.8,3.1,9.5,1.2,14.5c-8.9,23.3-27.4,37.5-48.7,51.8c0-8.8,0-15.8,0-23.4c-1.6,0.7-2.4,0.8-2.6,1.2
                                    c-10.1,15.4-25.7,21.7-42.7,25.9c-6.8,1.7-13.5,3.5-20.2,5.7c-10.8,3.5-12.6,6-12.9,17.5c-0.2,5.7-0.3,11.4,0,17.1
                                    c0.2,5.5-2.2,8.8-6.6,11.8c-9.4,6.4-20,8.5-31,9.5c-7.6,0.7-15.3,1.1-22.9,1.3c-5.7,0.2-9.8,2.4-11.6,7.8
                                    c-2.8,8.2-8.6,12.4-16.9,14.7c-16.2,4.5-32.2,9.9-48.3,14.7c-4.5,1.3-6.7,3.4-7.6,8.3c-1.7,9.2-8.4,15.3-16.2,19.6
                                    c-34.1,19.1-64.5,19.3-97-8c-10.3-8.7-20.5-10.5-32.5-11.1c-18.2-1-36-4.1-52.9-11.4c-18.6-8-32.5-20.1-37.2-41
                                    c-0.7-3.2-5.7-6.2-9.4-7.8c-4.1-1.8-5.9,2.3-7.6,5.5c-1.9,3.7-4,7.3-6,10.9c-7.3,13.5-15.5,18.1-30.8,16.1
                                    c-19.9-2.7-39.7-5.7-59.5-9.3c-4.1-0.7-8.7-3.5-11.4-6.7c-11.5-13.5-22.3-27.5-33.6-41.2c-5.6-6.7-10.9-14-17.8-19.2
                                    c-11-8.3-16.4-18.8-17.8-32c-2.8-25.1-17.1-40.3-40.9-47.5c-6.5-2-12.8-4.3-19.2-6.7c-10.7-4.1-19.2-10.9-25.9-20.3
                                    c-10.1-14.3-11.4-30.1-8.3-46.4c3.1-16.7-3.8-29.7-13.8-41.5c-4.6-5.4-10.8-9.5-16.7-13.6c-6.6-4.6-13.4-9.5-20.7-12.6
                                    c-15.4-6.5-21.3-20.4-27.5-33.9c-1.9-4.1-1.1-10.5,0.6-15.1c3.5-9.3,7.8-18.6,13-27.1c3.4-5.5,7.3-9,11.8-10.7
                                    c-0.9-0.4-1.7-0.7-2.6-1.1c-13.8-5.2-23.6-2.3-31.3,10.3c-5.5,9-9.9,18.9-13.6,28.8c-1.8,4.8-2.6,11.7-0.6,16.1
                                    c6.4,14.3,12.6,29.2,28.7,36.1c7.7,3.3,14.7,8.5,21.6,13.4c6.2,4.4,12.7,8.8,17.5,14.5C90,609.6,97.2,623.5,94,641.3
                                    c-3.2,17.4-1.9,34.2,8.7,49.4c7,10.1,15.8,17.3,27,21.7c6.6,2.6,13.2,5.1,20,7.2c24.8,7.7,39.7,23.9,42.6,50.6
                                    c1.5,14.1,7.2,25.3,18.6,34.1c7.2,5.5,12.7,13.3,18.6,20.5c11.8,14.5,23.1,29.5,35.1,43.9c2.9,3.4,7.6,6.4,11.9,7.1
                                    c20.6,3.8,41.3,7,62.1,9.9c16,2.2,24.6-2.8,32.2-17.1c2.1-3.9,4.2-7.7,6.2-11.7c1.7-3.4,3.6-7.7,7.9-5.8c3.8,1.7,9,4.9,9.8,8.3
                                    c4.9,22.3,19.5,35.2,38.9,43.7c17.6,7.7,36.2,11.1,55.2,12.2c12.5,0.7,23.1,2.6,33.9,11.9c33.9,29,65.7,28.8,101.2,8.5
                                    c8.1-4.7,15.1-11.1,16.9-20.9c1-5.3,3.3-7.5,8-8.9c16.8-5.1,33.5-10.8,50.4-15.6c8.7-2.4,14.7-6.9,17.7-15.6
                                    c1.9-5.7,6.2-8.2,12.1-8.3c8-0.3,15.9-0.7,23.9-1.4c11.4-1,22.5-3.3,32.3-10.1c4.6-3.2,7.2-6.8,6.9-12.6c-0.3-6.1-0.1-12.1,0-18.2
                                    c0.3-12.3,2.2-15,13.5-18.7c6.9-2.3,14-4.3,21.1-6c17.7-4.4,34-11.1,44.5-27.5c0.3-0.4,1.1-0.5,2.7-1.3c0,8.1,0,15.6,0,25
                                    c22.2-15.2,41.5-30.3,50.8-55.2c2-5.3,1.3-10.3-1.3-15.4c-3.4-6.6-6.2-13.5-9.3-20.2c-4.1-9-4.4-9.4,4.4-14.3
                                    c8.9-4.9,12.3-11.9,10.8-21.9c-1.4-9.4,0.6-18,5.5-26c5.2-8.5,10.1-17.2,15.1-25.8c9-15.5,11.9-32.4,8.1-49.8
                                    c-3.2-14.9-8.1-29.5-12.7-44.1c-6.5-20.9-5.5-40,9.3-57.6C959.9,458.9,964,450.9,965.9,443z"/>',
                $gradID);
        }
        $mask = '<path id="%1$s" d="M860.6,778c0-8.8,0-15.8,0-23.4c-1.6,0.7-2.4,0.8-2.6,1.2c-10.1,15.4-25.7,21.7-42.7,25.9
                    c-6.8,1.7-13.5,3.5-20.2,5.7c-10.8,3.5-12.6,6-12.9,17.5c-0.2,5.7-0.3,11.4,0,17.1c0.2,5.5-2.2,8.8-6.6,11.8c-9.4,6.4-20,8.5-31,9.5
                    c-7.6,0.7-15.3,1.1-22.9,1.3c-5.7,0.2-9.8,2.4-11.6,7.8c-2.8,8.2-8.6,12.4-16.9,14.7c-16.2,4.5-32.2,9.9-48.3,14.7
                    c-4.5,1.3-6.7,3.4-7.6,8.3c-1.7,9.2-8.4,15.3-16.2,19.6c-34.1,19.1-64.5,19.3-97-8c-10.3-8.7-20.5-10.5-32.5-11.1
                    c-18.2-1-36-4.1-52.9-11.4c-18.6-8-32.5-20.1-37.2-41c-0.7-3.2-5.7-6.2-9.4-7.8c-4.1-1.8-5.9,2.3-7.6,5.5c-1.9,3.7-4,7.3-6,10.9
                    c-7.3,13.5-15.5,18.1-30.8,16.1c-19.9-2.7-39.7-5.7-59.5-9.3c-4.1-0.7-8.7-3.5-11.4-6.7c-11.5-13.5-22.3-27.5-33.6-41.2
                    c-5.6-6.7-10.9-14-17.8-19.2c-11-8.3-16.4-18.8-17.8-32c-2.8-25.1-17.1-40.3-40.9-47.5c-6.5-2-12.8-4.3-19.2-6.7
                    c-10.7-4.1-19.2-10.9-25.9-20.3c-10.1-14.3-11.4-30.1-8.3-46.4c3.1-16.7-3.8-29.7-13.8-41.5c-4.6-5.4-10.8-9.5-16.7-13.6
                    c-6.6-4.6-13.4-9.5-20.7-12.6c-15.4-6.5-21.3-20.4-27.5-33.9c-1.9-4.1-1.1-10.5,0.6-15.1c3.5-9.3,7.8-18.6,13-27.1
                    c7.4-11.8,16.8-14.5,30-9.6c6.3,2.3,12.2,5.9,18.3,8.8c11.4,5.4,18.5,4.2,27-5.1c3.4-3.7,6.2-7.9,9-12.1c4-6.2,3.6-10.2-2.3-14.7
                    c-5-3.9-10.7-6.9-16-10.3c-8.9-5.8-10.9-11.9-4.2-20.1c4.9-6,11.9-10.7,18.7-14.8c9.4-5.7,11-8.6,3.9-17.2
                    c-12.6-15.1-25.9-29.7-39.3-44.1c-3.9-4.3-5.5-8.2-3.9-14c2.6-9.2,4.4-18.7,6.5-28.1c2.7-12.1,6.5-15.4,19.2-15.8
                    c10.5-0.3,21-0.2,31.5,0.1c5.1,0.2,7.4-1,7.5-6.7c0.2-9.4,1.2-18.8,2.6-28c0.5-3.3,2.9-7.8,5.6-8.9c15-6,16.2-18.6,16.4-31.8
                    c0.1-4.6,0.9-7.8,5.5-10c1.8-0.8,3.3-3.8,3.7-6c1.1-6.4,1.7-13,2.2-19.5c0.3-4.8,9.3-8.5,10.3-8.9c10.5-3.3,12.1-6,12.7-17
                    c0.4-6,1.7-12,3.4-17.7c1.2-4,4.7-5.5,9-4.1c2.9,0.9,5.9,1.8,8.9,2c1.9,0.1,5-0.5,5.6-1.8c2.5-5.1,7-5.6,11.6-5.9
                    c6.7-0.4,20-6.6,17.5-21c-0.9-4.9-1.7-9.9-2.8-14.8c-1.1-4.8,1.5-6.1,5.3-5.6c11.8,1.5,24,1.9,35.3,5.2c12.3,3.5,23.9,9.4,35.6,14.9
                    c12.2,5.7,24.2,11,38.2,9.7c11.6-1,18.2-5.8,21.1-17.1c1.4-5.3,2.2-10.7,2.9-16.1c1.1-8.6,2.7-10,10.8-7.5
                    c7.5,2.2,14.9,5.1,22.5,7.1c6.5,1.7,12.3,0.8,16.9-5.3c5.5-7.3,17.8-4.7,20.8,4.3c2.4,7.2,3.6,14.9,5.7,22.2
                    c3.6,12.4,16.4,21.6,29.2,20.8c9.2-0.6,15.8-5.5,19.9-14c8.4-17.3,24.3-24,42.6-16.7c9.6,3.8,18.2,10.2,27.1,15.8
                    c9.2,5.8,18,12.4,27.4,18.1c10,6.1,20.2,5.8,30.3-0.7c3.8-2.4,8.2-4,12.6-5.3c3.2-1,6.2-0.1,6.5,4.3c1.1,17.4,10.4,30.8,21.5,43.2
                    c7.8,8.6,16.3,16.6,24.1,25.1c5.3,5.7,11.9,4.6,18.3,4.6c10.1,0,10.4-0.1,11,9.9c0.7,12.2,5.1,22.2,13.8,30.8
                    c6.5,6.4,12.1,13.9,18.5,20.4c7.7,7.9,11.2,16.8,10.2,27.9c-0.4,4.1-2.3,9.6,3.9,11.8c7.8,2.8,15.7,4.2,23-1.2
                    c1.2-0.9,1-3.5,1.5-5.3c0.8-2.6,1-6.1,2.8-7.6c2.1-1.7,5.7-2.2,8.6-2c0.8,0,1.6,4.4,1.8,6.8c0.7,7.6,1.1,15.3,1.6,22.9
                    c0.3,4.4,1.9,7.3,6.9,8c26.7,3.4,49,15.6,68.8,33.5c9.2,8.3,19.9,15.1,29.5,23c2.6,2.2,5.1,5.7,5.7,9c4.1,20.1,5.2,40.5,0.3,60.5
                    c-1.8,7.4-5.8,14.9-10.7,20.6c-14.2,16.5-15.2,34.5-8.9,54.1c4.4,13.7,9,27.4,12.2,41.4c3.6,16.3,0.9,32.2-7.8,46.7
                    c-4.8,8.1-9.5,16.3-14.5,24.2c-4.8,7.6-6.7,15.6-5.3,24.4c1.4,9.3-1.8,15.9-10.3,20.5c-8.5,4.6-8.2,5-4.3,13.4c3,6.3,5.7,12.8,9,19
                    c2.5,4.8,3.1,9.5,1.2,14.5C900.4,749.5,881.9,763.7,860.6,778z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape12($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M51.6,382.1c0.2,8.5,0.4,16.9,0.6,25.4c0.2,8.6,0.3,17.3,0.5,25.9c0.2,7.1,0.3,14.2,0.5,21.3
                                    c0.2,8.5,0.3,17.1,0.5,25.6c0.2,7.2,0.3,14.4,0.5,21.5c0,0.5,0,0.9,0,1.4c0.8-5.9,1.7-11.8,2.5-17.7c1.2-8.5,2.4-16.9,3.6-25.4
                                    c1.2-8.4,2.3-16.8,3.5-25.1c1-7.1,2-14.2,3-21.3c1.2-8.5,2.4-16.9,3.6-25.4c1-7,1.9-14.1,2.9-21.1c1.2-8.6,2.4-17.1,3.6-25.7
                                    c1.2-8.4,2.3-16.8,3.5-25.1c1-7.3,2.1-14.6,3.1-21.9c0.2-1.2,0.3-2.3,0.5-3.5c-7,3.2-13,7.9-18,13.9c-9.3,11-14.7,23.6-15.1,38.1
                                    c-0.2,5.6,0.2,11.3,0.3,16.9C51.3,367.4,51.4,374.8,51.6,382.1z"/>
                                <path class="st1" d="M383.7,185c13.6-2.5,27.2-4.9,40.8-7.4c13.4-2.4,26.8-4.9,40.3-7.4c14.7-2.7,29.4-5.3,44-8
                                    c13.4-2.4,26.8-4.9,40.3-7.3c14.7-2.7,29.4-5.3,44-8c13.3-2.4,26.7-4.9,40-7.3c16.7-3,33.5-6.1,50.2-9.1
                                    c15.4-2.8,30.8-5.6,46.2-8.4c15.5-2.8,31-5.6,46.5-8.4c14.6-2.7,29.2-5.3,43.8-8c14.6-2.7,29.2-5.3,43.8-8c2.9-0.5,5.9-1,8.8-1.3
                                    c-1.6-10.1-3.3-20.2-4.9-30.3c-0.3-0.5-0.8-1-1-1.6c-3.1-10.8-10.1-18.4-19.8-23.6c-8.1-4.4-16.9-6.2-26-6.3
                                    c-10.8-0.2-21.1,2.2-31.2,5.9c-13.9,5-27.9,9.9-41.9,14.9c-14,5-27.9,9.9-41.9,14.9c-14.8,5.3-29.7,10.5-44.5,15.8
                                    c-14.7,5.2-29.5,10.5-44.2,15.7c-16,5.7-32.1,11.4-48.1,17.1c-12.8,4.5-25.5,9.1-38.3,13.6c-14.1,5-28.1,10-42.2,15
                                    c-12.9,4.6-25.7,9.2-38.6,13.7c-14.1,5-28.1,10-42.2,14.9c-8.8,3.1-17.6,6.3-26.4,9.4C382,185.3,382.9,185.1,383.7,185z"/>
                                <path class="st1" d="M459.8,922.4c-5.1-0.5-10.1-1-15.2-1.5c-4.4-0.4-8.9-0.8-13.3-1.2c-5.1-0.5-10.1-1-15.2-1.5
                                    c-4.4-0.4-8.9-0.8-13.3-1.2c-5-0.5-9.9-1-14.9-1.5c-4.5-0.4-9.1-0.8-13.6-1.3c-4.9-0.5-9.8-1-14.7-1.5c-4.5-0.4-9.1-0.8-13.6-1.2
                                    c-5.2-0.5-10.5-1-15.7-1.5c-4.3-0.4-8.7-0.8-13-1.3c-4.9-0.5-9.8-1-14.7-1.5c-4.6-0.4-9.2-0.8-13.8-1.3c-4.9-0.5-9.8-1-14.7-1.4
                                    c-4.5-0.4-9.1-0.8-13.6-1.2c-5.2-0.5-10.5-1-15.7-1.5c-4.3-0.4-8.7-0.8-13-1.2c-5.1-0.5-10.1-1-15.2-1.5c-4.4-0.4-8.9-0.8-13.3-1.3
                                    c-4.8-0.5-9.6-1-14.4-1.5c-4.6-0.4-9.2-0.8-13.9-1.2c-6.6-0.6-13.2-1.4-19.8-2c-6.6-0.6-13.2-1.1-19.8-1.8
                                    c-8.4-0.8-16.8-1.8-25.2-2.6c-6.7-0.6-13.4-1.1-20.1-1.8c-8.5-0.8-17-1.7-25.5-2.6c-0.7-0.1-1.4-0.1-2.1-0.2
                                    c0.1,5.9,0.1,11.7,0.6,17.5c1.3,16.5,7.5,30.5,22,39.8c5.9,3.8,12.4,5.5,19.5,5.1c7.5-0.5,15.1-1,22.6-1.4c8.5-0.5,17.1-1,25.6-1.5
                                    c6.7-0.4,13.4-1,20.1-1.5c8.4-0.5,16.9-1,25.3-1.5c6.6-0.4,13.2-1,19.9-1.4c6.6-0.4,13.2-0.8,19.9-1.2c4.6-0.3,9.2-0.7,13.9-1
                                    c4.8-0.3,9.6-0.6,14.4-0.9c4.4-0.3,8.9-0.6,13.3-0.9c5.1-0.3,10.2-0.6,15.2-1c4.4-0.3,8.7-0.6,13.1-0.9c5.3-0.3,10.5-0.7,15.8-1
                                    c4.5-0.3,9.1-0.7,13.6-1c4.9-0.3,9.8-0.6,14.7-0.9c4.6-0.3,9.2-0.6,13.9-1c4.9-0.3,9.8-0.6,14.7-0.9c4.4-0.3,8.7-0.6,13.1-0.9
                                    c5.3-0.3,10.5-0.7,15.8-1c4.5-0.3,9.1-0.7,13.6-1c4.9-0.3,9.8-0.6,14.7-0.9c4.5-0.3,9.1-0.6,13.6-0.9c5-0.3,10-0.6,15-0.9
                                    c0.1,0,0.2,0,0.2,0C464.2,922.8,462,922.6,459.8,922.4z"/>
                                <path class="st1" d="M986.7,817.2c-2.2-13.6-4.4-27.2-6.5-40.8c-8.4-52.6-16.7-105.3-25.1-157.9c-6.7-42.1-13.4-84.2-20.1-126.3
                                    c-0.1,14.7-0.1,29.4-0.2,44c-0.2,52.8-0.4,105.7-0.5,158.5c-0.2,53.3-0.4,106.6-0.5,159.9c0,12-0.1,24-0.1,36
                                    c10.4-2.5,20-7.1,28.5-13.9c14.9-11.8,23.7-26.9,25.2-46C987.7,826.3,987.4,821.7,986.7,817.2z"/>',
                $gradID);
        }
        $mask = '<path id="%1$s" d="M936.5,135.5c0,22.8,0,45.6,0,68.3c-0.2,1.2-0.5,2.5-0.5,3.7c-0.2,56.9-0.4,113.9-0.6,170.8
                    c-0.2,52.7-0.4,105.3-0.5,158c-0.2,52.8-0.4,105.7-0.5,158.5c-0.2,53.3-0.4,106.6-0.5,159.9c0,13.8-0.1,27.5-0.1,41.3
                    c0,4.6-0.4,9.1-1.5,13.5c-4.5,18.6-15.7,32.2-32.2,41.4c-12.3,6.8-25.6,9.9-39.6,9.4c-5.4-0.2-10.9-0.7-16.3-1.2
                    c-4.5-0.4-9.1-0.8-13.6-1.2c-5.2-0.5-10.3-1-15.5-1.5c-4.4-0.4-8.9-0.8-13.3-1.3c-5-0.5-10-1-14.9-1.5c-4.5-0.4-9.1-0.8-13.6-1.3
                    c-4.8-0.5-9.6-1-14.4-1.4c-4.6-0.4-9.2-0.8-13.9-1.2c-5.2-0.5-10.3-1-15.5-1.5c-4.3-0.4-8.7-0.8-13-1.2c-5.2-0.5-10.3-1-15.5-1.5
                    c-4.3-0.4-8.7-0.8-13-1.2c-5.1-0.5-10.1-1-15.2-1.5c-4.4-0.4-8.9-0.8-13.3-1.2c-5.1-0.5-10.1-1-15.2-1.5c-4.4-0.4-8.9-0.8-13.3-1.2
                    c-5.1-0.5-10.1-1-15.2-1.5c-4.4-0.4-8.9-0.8-13.3-1.2c-5-0.5-9.9-1-14.9-1.5c-4.5-0.4-9.1-0.8-13.6-1.3c-5.1-0.5-10.1-1-15.2-1.5
                    c-4.4-0.4-8.9-0.8-13.3-1.3c-5.1-0.5-10.1-1-15.2-1.5c-4.5-0.4-9-0.8-13.6-1.3c-4.9-0.5-9.8-1-14.7-1.4c-4.5-0.4-9.1-0.8-13.6-1.2
                    c-5.2-0.5-10.3-1-15.5-1.5c-4.3-0.4-8.7-0.8-13-1.2c-5.1-0.5-10.1-1-15.2-1.5c-4.4-0.4-8.9-0.8-13.3-1.2c-5.1-0.5-10.1-1-15.2-1.5
                    c-4.4-0.4-8.9-0.8-13.3-1.2c-5-0.5-9.9-1-14.9-1.5c-4.5-0.4-9.1-0.8-13.6-1.3c-4.9-0.5-9.8-1-14.7-1.5c-4.5-0.4-9.1-0.8-13.6-1.2
                    c-5.2-0.5-10.5-1-15.7-1.5c-4.3-0.4-8.7-0.8-13-1.3c-4.9-0.5-9.8-1-14.7-1.5c-4.6-0.4-9.2-0.8-13.8-1.3c-4.9-0.5-9.8-1-14.7-1.4
                    c-4.5-0.4-9.1-0.8-13.6-1.2c-5.2-0.5-10.5-1-15.7-1.5c-4.3-0.4-8.7-0.8-13-1.2c-5.1-0.5-10.1-1-15.2-1.5c-4.4-0.4-8.9-0.8-13.3-1.3
                    c-4.8-0.5-9.6-1-14.4-1.5c-4.6-0.4-9.2-0.8-13.9-1.2c-6.6-0.6-13.2-1.4-19.8-2c-6.6-0.6-13.2-1.1-19.8-1.8
                    c-8.4-0.8-16.8-1.8-25.2-2.6c-6.7-0.6-13.4-1.1-20.1-1.8c-8.5-0.8-17-1.7-25.5-2.6c-7.5-0.8-15-1.4-22.5-2.2
                    c-7-0.7-13.2-3.5-18.4-8.2C10.9,862.5,7,847.6,8.4,831.1c0.6-7.6,2-15.1,3-22.7c0.9-6.8,1.9-13.7,2.9-20.5c1-7.4,2.1-14.8,3.1-22.1
                    c1.2-8.2,2.3-16.4,3.4-24.6c1.2-8.6,2.4-17.3,3.7-25.9c1-7,2-14,3-21.1c1-7.2,2-14.4,3.1-21.6c1.2-8.3,2.3-16.6,3.5-24.9
                    c1.2-8.6,2.4-17.3,3.7-25.9c1-7,2-14,3-21.1c1-7.2,2-14.4,3.1-21.6c1.2-8.5,2.4-16.9,3.6-25.4c1.2-8.4,2.3-16.8,3.5-25.1
                    c1-7.1,2-14.2,3-21.3c1-7.2,2-14.4,3.1-21.6c1.2-8.5,2.4-16.9,3.6-25.4c1.2-8.4,2.3-16.8,3.5-25.1c1-7.1,2-14.2,3-21.3
                    c1.2-8.5,2.4-16.9,3.6-25.4c1-7,1.9-14.1,2.9-21.1c1.2-8.6,2.4-17.1,3.6-25.7c1.2-8.4,2.3-16.8,3.5-25.1c1-7.3,2.1-14.6,3.1-21.9
                    c0.8-5.6,1.4-11.2,2.5-16.7c2.7-14.2,10.1-25.8,21-35.2c7.3-6.3,15.7-10.4,25.4-12c10.1-1.7,20.2-3.6,30.3-5.5
                    c14.8-2.7,29.5-5.4,44.3-8.1c15.3-2.8,30.6-5.5,45.9-8.3c15.5-2.8,31-5.7,46.4-8.5c14.9-2.7,29.7-5.4,44.6-8.1
                    c13.2-2.4,26.5-4.8,39.7-7.2c13.6-2.5,27.2-4.9,40.8-7.4c13.4-2.4,26.8-4.9,40.3-7.4c14.7-2.7,29.4-5.3,44-8
                    c13.4-2.4,26.8-4.9,40.3-7.3c14.7-2.7,29.4-5.3,44-8c13.3-2.4,26.7-4.9,40-7.3c16.7-3,33.5-6.1,50.2-9.1c15.4-2.8,30.8-5.6,46.2-8.4
                    c15.5-2.8,31-5.6,46.5-8.4c14.6-2.7,29.2-5.3,43.8-8c14.6-2.7,29.2-5.3,43.8-8c10.6-2,21.1-2.7,31.8-0.8c9,1.6,17.4,4.8,24.7,10.4
                    c8.7,6.7,14.4,15.3,15.7,26.5C935.8,134.4,936.2,135,936.5,135.5z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape13($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('
                <path class="st1" d="M789.9 159.7c31.1-3.6 41.4 30.3 32.3 51.5-9.1 21.2-45.5 32.3-67.7 8.1s0-55.5 35.4-59.6zm-298.2-24.2C476.5 63.7 639.3-20.2 692.8 61.7c53.6 81.9-23.2 148.6-75.8 151.6-52.5 3-112-15-125.3-77.8zM487.6 841c24.3-17.3 102.1 29.3 66.7 72.8-35.4 43.5-70.8 8.1-78.8-2s-19.2-48.6 12.1-70.8z"/>
                <path class="st1" d="M59.1 502.4C107.6 356.2 212.7 187 356.3 187c91 0 141.1 64.6 205.2 71.8C723.2 277 947 337.5 971.9 554.9 987 687.3 852.5 776.3 746.4 796.5c-69.7 13.3-151.2-17.8-227.4 3-66.7 18.2-144.7 188.7-325.5 99.1-118.2-58.7-205.2-183-134.4-396.2z"/>',
            $gradID);
        }
        $mask = '<path d="M62.1 478.1c48.5-146.2 153.6-315.4 297.2-315.4 91 0 141.1 64.6 205.2 71.8 161.7 18.2 385.5 78.7 410.4 296.1C990 663.1 855.6 752 749.4 772.2c-69.7 13.3-151.2-17.8-227.4 3-66.7 18.2-144.7 188.7-325.5 99.1C78.3 815.7-8.6 691.4 62.1 478.1z"/>
                 <path d="M505.8 146.6C490.7 74.8 653.4-9.1 707 72.8c53.6 81.9-23.2 148.6-75.8 151.6s-112.1-15-125.4-77.8zm290.1 23.2c31.1-3.6 41.4 30.3 32.3 51.5s-45.5 32.3-67.7 8.1c-22.2-24.2 0-55.5 35.4-59.6zM496.7 833.9c24.3-17.3 102.1 29.3 66.7 72.8-35.4 43.5-70.8 8.1-78.8-2-8.1-10.2-19.2-48.6 12.1-70.8z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape14($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M388.4 588.9S-92.2 432.4 109.7 126.1c120.1-182.2 341.1-39.5 365.5-20.9C570.7 178 991 594.9 677.1 832.8 456.7 999.9 388.4 588.9 388.4 588.9z"/>',
            $gradID);
        }
        $mask = '<path class="st2" d="M121 167.6c78.2-111 256.8-22.6 357.4-13.5 140.7 12.7 275.1-5.1 400.8 115 41 39.1 88.1 115.5 72.9 169.3-54.5 192.6-209.8 135-349.3 218.7S334.3 1052.2 118.5 908c-135.2-90.3 1.7-255.1 26.1-342.1 35.3-126.2-108-278.5-23.6-398.3z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape15($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M608.8 933.2c-245.3-68.2-216.6-400.7.8-405.7 148.1-3.4 88.7 100.4 142 158.8 56.7 62.1 91.9 17.1 114.7 59.7 32.7 61-42.4 247-257.5 187.2zm149.2-396c-46.7-89.2 37.5-201.7 94-146.3 38.5 37.7-.6 59.6-.6 94.7.1 37.4 19.4 30.4 15.4 51.7-5.8 30.7-67.9 78.1-108.8-.1z"/>
                                <path class="st1" d="M220.4 651.7C-33.4 269 403.3-141.9 706.3 109.6c206.4 171.3 1.2 239.7 4.2 381.2 3.3 150.5 105.2 132.1 85.4 216.2-28.2 120.5-353 280.2-575.5-55.3z"/>
                                <path class="st1" d="M137.5 757.7C-116.3 375 320.4-35.8 623.4 215.7c206.4 171.3 1.2 239.7 4.2 381.2C630.9 747.4 732.8 729 713 813.1c-28.2 120.4-353 280.2-575.5-55.4z"/>',
            $gradID);
        }
        $mask = '<path class="st2" d="M226.9 830.8C-161.7 465.6 215.3-123 623.2 79.2 901.1 217 690 351.7 732 511.8 776.7 682.2 885.8 633 886.6 734.1c1.3 145-319 416.9-659.7 96.7z"/>
                 <path class="st2" d="M788.6 578.6c-94.2-88.5-2.8-231.2 96.1-182.2 67.4 33.4 16.2 66 26.4 104.8 10.8 41.3 37.3 29.4 37.5 53.9.2 35.3-77.4 101.1-160 23.5z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape16($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M63.6 878.1c5 49.8 55.7 77.9 94.7 63.5 69.2-25.5 70.1-148.4-9.4-153.7-43.3-3-90.8 35.5-85.3 90.2zM533.5 126c.2 19.6 9.1 37.9 24.1 49.4 26.7 20.9 105.6 21.3 109.2-27.1 2.1-27.7-26.9-46.3-42-64.5-11.6-13.9-24.6-24.1-43.3-19.7-27.4 7-47.1 32.4-48 61.9zm406.1 366.6c3.3 30.9 2.2 61.7-3.1 90.9-40.2 222.6-245.9 360.1-429.3 341.7-140.3-12.9-274.4-112.8-356-265.2-52.6-97.1-78.8-210-63.9-311.2 7-47.3 22.8-90.6 46.4-126.8 38.8-60.2 116.9-55.6 182.1-31.1s149.9 40.9 216.3 53.2c82.5 15.5 165.5 3.4 247.5 34.8 49 18.7 97 54.5 127.5 107.6 17.8 32.4 29 68.9 32.5 106.1z"/>',
            $gradID);
        }
        $mask = '<path d="M959.5 583.5c-5.1 30-14.7 58.8-28.2 85C828.4 868.8 577 947.2 391.5 884.1c-142.2-47.2-254-175-296.9-339.4-28-104.8-24.2-218 19.1-309.9 20.2-42.9 48.6-79.9 83-108.1 56.8-47.1 136.8-23.3 197.8 16.1s144.5 76 210.1 104.3c81.5 35.3 171 44.6 247.6 94.6 45.7 29.9 85.7 75.7 102.9 133.5 9.4 35 11 72.3 4.4 108.3zM559.6 141.2c3.9 31.4 20.3 58.8 44.2 74.1 42.6 28 156.9 12.1 152.9-66.2-2.2-44.8-47.6-68.6-72.9-94.6-19.4-19.9-40.2-33.6-66.4-22.6-38.3 17-62 61.9-57.8 109.3zm258.2 84.3c2.6 25.9 29 40.6 49.4 33.1 36.1-13.2 36.7-77.5-4.8-80.2-22.6-1.5-47.5 18.5-44.6 47.1z"/>
                <path d="M61.1 860.5c5 49.8 55.7 77.9 94.7 63.5 69.2-25.5 70.1-148.4-9.4-153.7-43.3-3-90.8 35.5-85.3 90.2z"/>
                <path d="M61.1 860.5c5 49.8 55.7 77.9 94.7 63.5 69.2-25.5 70.1-148.4-9.4-153.7-43.3-3-90.8 35.5-85.3 90.2z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape17($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M690.6 525.9C636.3 555.5 541.2 660.5 567 778.2c37.2 169.6 501.1-88.2 385.9-218.7-78.3-88.6-231.7-50.2-262.3-33.6zM37.7 465.6C45.4 264 229.4 99.7 497.4 99.7s-282.1 115-282.1 258.2 477 90.8 366.4 213.1-112.2 28.9-169.4 62.3C296.4 701 28.6 703.7 37.7 465.6z"/>',
            $gradID);
        }
        $mask = '<path d="M82.3 453.1C90 251.5 242.3 96.5 510.4 96.5s380 67.7 380 210.8-153.5 128.9-264.2 251.2-91.1 245-148.4 278.5C362.1 904.7 73.2 691.2 82.3 453.1z"/>
                 <path d="M678.3 529.9c-52 27.5-143.1 124.9-118.4 234.2 35.6 157.4 479.9-81.9 369.6-203-75-82.3-221.9-46.7-251.2-31.2z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape18($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M560.9 729.9c-2.5-1.2-5-3-7.6-3.5-6.1-1.1-11.7-3.3-16.9-6.8-1.8-1.2-4-1.8-6.1-2.4-.5-.1-1.3.7-1.9 1 .5.6 1 1.3 1.6 1.7.7.4 1.5.5 2.6.9-1.6 2.6-3.3 1.9-5.1 1.1-3.8-1.7-4.4-1.3-5.4 2.8-.3 1.3-1.4 2.5-2.3 3.6-1.3 1.6-1.1 2.6.7 3.8 2.2 1.5 4.2 3.3 6.4 4.9.6.4 1.5.4 2.3.5 4.2.4 8.5.2 12.5 1.3 10.3 2.9 13.3 15.2 5.9 23.1-5.5 5.8-12.7 7.4-20.2 8.1-.6.1-1.2-.6-1.8-.8-1.2-.4-2.5-1.2-3.6-1-3.7.7-6-1.7-8.2-4-.6-.7-1-1.9-.9-2.9.1-2.8-1.6-3.9-3.9-4.6-.1.9-.2 1.7-.5 3.2-1.4-1-2.6-1.7-3.6-2.6-1.4-1.2-2.5-2.8-4-3.8-3.3-2.1-5.9-1.1-6.9 2.8-.8 3.3-1.2 6.8-1.5 10.3-.2 3-1.2 5.1-3.8 6.7-1.5.9-2.9 2.6-3.5 4.3-1 2.7-2.2 4.5-5.3 4.3-.1 1.1-.2 2-.3 2.8-.4 3.3-1.8 4-4.4 2.1-1.3-1-2.3-2.3-3.5-3.4-3.5 4.2-3.6 6.8 2.8 8.6 3.5 1 5.2 2.8 4.8 6-1.1-.5-2.2-.9-3.2-1.3-.5-.3-.9-.5-1.4-.8-3.6-2.6-7.1-5.3-10.7-7.8-1.4-1-2.2-.2-2 1.4.1 1 .6 2.1.7 3.1.1.8.3 2.1-.1 2.5-1.6 1.2-1.1 2.8-1.1 4.4 0 2.5-.2 5-.2 7.4.1 3.5.4 6.9.4 10.4 0 3.1.3 6.2-.3 9.2-1.2 6.6-2.9 13.2-4.4 19.7-.9 4.3 0 8 3.2 11.2 1.1 1.1 1.8 3.4 1.6 5-.4 3.9-1.5 7.6-2.3 11.5-.5 2.2-1.2 4.4-3.7 5-2.4.5-3.8-1.1-5.1-2.9-4.2-5.5-6.3-12-7.5-18.6-1.8-9.5-2.7-19.2-4-28.9-.1-1-.1-2.2.2-3.1 3.6-9.1 1.3-17.4-3.2-25.8-.7 1.3-1.2 2.5-1.9 3.3-.5.5-1.7 1-2.2.7-.5-.3-1-1.6-.9-2.2 1.1-4.5 2.5-8.9 3.7-13.3.3-1.1.7-2.6.3-3.3-.8-1.3-2-2.5-3.4-3.1-.6-.2-2.1 1.1-2.7 2.1-.8 1.4-1.1 3.2-1.8 4.7-.5 1-1.3 1.7-2.5 3.1-.6-2.4-.8-4-1.3-5.4-.3-.7-1.1-1.2-1.6-1.8-.5.7-1.3 1.4-1.3 2.1 0 1.1.3 2.3.8 3.2 1.1 2 1.7 3.8.8 6.1-.3.7-.1 1.7 0 2.6.1 2 .4 3.9.4 5.8 0 .7-.7 1.4-1.2 2.1-.7-.5-1.7-.8-2-1.4-1.2-2.3-1.2-4.7-.1-7.2.4-.7.9-1.7.7-2.4-.8-2.6-1.9-5-3.6-7.7-.6 1.9-1.1 3.9-1.8 5.8-.4 1.1-1.2 2.1-1.9 3-.4.5-1.1.7-1.3 1.2-1.8 3.4-4.2 6.2-7.4 8.3-1 .6-1 3.1-1.2 4.7-.3 2.9-2.4 5.8-4.9 6.1 4.5-14.3 10.7-28.1 11.4-43.3-.3-.1-.6-.3-.9-.4-.7 1.4-1.4 2.8-2 4.2-.6 1.3-1.2 2.6-2 3.7-.4.5-1.2.6-1.9.9-.3-.8-.9-1.6-.8-2.3 0-.7.6-1.4 1.1-2 1.5-2 1.2-3.8-1.1-4.3-2.1-.4-2.4-1.5-2.5-3.2-.1-2.3-.4-4.6-.7-6.9-.4-2.5-1.7-3.3-4-2.7-.6.2-1.2.4-1.7.6-3.6 1.3-3.6 1.3-4.7-2.6-.4.8-.8 1.3-1 1.9-3 6.7-5.9 13.4-8.9 20.1-.6 1.3-.9 2.3.4 3.5.8.8.9 2.3 1.4 3.4-1.3.2-2.8 1-4 .6-1.8-.6-2.9-.1-4.3 1.1-14 12.3-24.9 27.4-35.9 42.3-7.2 9.8-14.5 19.6-21.8 29.4-1.2 1.5-2.6 2.9-3.9 4.3-.3-.2-.5-.4-.8-.6.9-1.7 1.6-3.6 2.7-5.2 6-8.5 11.9-17 18.1-25.2 7.8-10.3 15.7-20.4 23.8-30.5 2.6-3.2 4.5-6.6 5.4-10.7.4-1.8 1.7-3.3 2.6-5 2.1-3.8 4.4-7.6 6.2-11.5 1.4-2.9 2.7-5.2 5.9-6.4 2-.7 3.7-2.5 5.2-4.1 1.4-1.5 1.7-3.6.4-5.7-3.3 1.3-4.7 5.6-9.2 5.4.8-1.4 1.7-2.8 2.4-4.2.5-1.2.8-2.6 1.1-3.9-1.2.6-2.4 1.1-3.5 1.8-.6.4-1.1 1.2-1.6 1.7-1.6 1.5-3.1 1.8-4.6-.2-6.8-9.1-20-7.9-26.6-2.6-3.4 2.7-5.9 2-8.6-2.6 2.2-.7 4.3-1.6 6.5-2.1 3.3-.8 6.8-1.3 10.1-1.9 1.5-.3 2.7-1.1 2.4-3.3-.7.8-1.2 1.4-2.2 2.4-.5-1.3-1.2-2.2-1.3-3.2 0-.3 1.2-.8 2-1.4-1.8-1.6-3.9-2-6.1-1.6.1 1.1.4 2.1.3 3 0 .2-1.4.7-1.5.5-.7-.7-1.1-1.7-1.7-2.7-.8.6-1.9 1.4-2.9 2.1-1.6 1.1-3.2 1.4-5.1.7-1.4-.4-3 0-4.5 0-1.2 0-2.3 0-3.5-.1v-.7c1.7-1.4 3.6-2.6 5.2-4.1 1.4-1.3 2.3-3 .6-4.9-1.7-1.9-5.8-3-7-1.7-.5.6-.6 1.9-.5 2.9.7 7.1-1.2 13.1-6.6 17.6-6.4 5.3-17.9 5.1-24.3-.3-2.5-2.1-4.4-4.5-3.9-8.2.1-.9-.4-1.9-.7-2.8-.6-1.6-1.3-3.1-2-4.7.2-.3.4-.7.6-1-4.1 0-8.1 0-12.2.2s-8.2.6-12.2.9c-.1-.4-.2-.8-.2-1.1.8-.4 1.6-1.1 2.5-1.2 6.4-1.1 12.8-2.3 19.3-3.1 2-.3 3.6-.9 4.7-2.7 3.6-5.8 8.8-8.7 15.5-8.9.9 0 1.8-.4 2.7-.6 1.8-.4 3.8-1.9 4.7 1.3.1.3.7.5 1.1.7 2.1 1.1 4.3 2.3 6.4 3.4.7.3 2 .6 2.2.2.5-.6.9-1.9.6-2.6-.6-1.3-1.7-2.4-2.8-4-.7 1.4-.9 2.2-1.4 2.8-.3.4-1.1.7-1.5.6-.4-.1-1-.8-1-1.3 0-1.5-.5-2-2-2-.7 0-1.8-.8-1.9-1.5-.4-2-1.7-2.3-3.2-2.3-1.9.1-3.8.4-5.6.4-1 0-1.9-.7-2.9-1 .6-.9 1.1-1.8 1.7-2.6.2-.3.5-.4.8-.7-1.7-.8-2.8-.6-3.8 1-.7 1-1 2.3-1.8 3.2-.8.9-1.9 1.7-3 2.2-.5.2-1.6-.3-1.9-.8-.2-.4.2-1.4.6-2 .5-.7 1.4-1 2-1.6 1.7-1.5 1.7-2.7-.4-3.5-1.8-.7-3.9-1.2-5.7-1-6.6.8-13.1 2-19.6 2.8-4.1.5-8.2.6-12.3.7-1.3 0-2.7-.7-4.6-1.3 6.4-5.7 12.3-10.9 18.5-16.4-.7-1.2-2-2.6-2.3-4.3-.2-1 1-2.9 2-3.4 1.4-.7 3.2-.6 4.8-.5.7.1 1.7.9 2 1.6.2.6-.4 1.6-.8 2.2-.5.7-1.1 1.2-1.7 1.8.1.2.1.5.2.7.8 0 1.9.3 2.4-.1 2-1.9 4.1-3.7 4.1-7 0-.7.5-1.9 1-2 3.7-1.1 7.4-1.9 11.3-2.9-1.2-2.7-3.3-4-5.8-4.8-3.5-1.1-7-2.3-10.6-3.3-3.3-.9-5-3.2-6-6.4-.3-1-.6-2.1-1.1-3-.3-.6-.9-1.4-1.2-1.4-.7.1-1.6.6-2 1.2-1.3 2-3.2 2.7-5.1 1.7-1.5-.8-2.2-4.2-1.3-6 1.7-3.2 3.4-3.7 6.3-1.6.5.3 1.1.4 1.6.6.2-.2.5-.3.7-.5-.8-1.5-1.3-3.3-2.4-4.5-2.3-2.6-4.8-4.9-7.2-7.3-1.7-1.7-2.2-3.4-1.2-5.7 1.3-3.3.8-6.4-1.7-9.1-1.9-2.1-3.9-4.1-5.4-6.5-1.4-2-2.5-4.3-3.2-6.6-1-3.3.5-5.2 3.8-5.2 2.3 0 4.6.5 6.9.8 3.1.4 6.1 1.1 9.2 1.3 4.5.3 6.7-1.6 7.7-6.1.5-2.4 1.5-4.8 1.6-7.2.1-1.9-.3-4.2-1.3-5.8-2.3-4.2-2.5-8.1.1-12 2.8-4.1 6.7-5.7 11.4-5.1 3.6.4 6.2 2.7 7 6.5 1 4.9 1 9.8-2.5 14.1 1.7.7 3.9 1.1 2.7 3.9-.1.2.2.7.4.9 4.4 4.1 6.7 9.4 8.2 15.1 4.4-.9 5.3-.4 6.7 3.3-1.1.1-2.2.3-3.3.4.7 2.2 2.8 3.4 5.2 2.3 1.6-.7 2.8-2.4 4.3-3.6.9-.7 2-2 2.8-1.9 2.1.3 3.3-.7 4.7-2 3.5-3.1 8.7-5 13.7-.1 2.8 2.7 5.5 5.5 8.3 8.1 1.2 1.2 3 2.9 4.4 1.3.9-.9 1-3.4.5-4.9-.9-2.5-2.5-4.7-3.8-7-.7-1.3-1.8-2.5-2.2-3.9-.3-1-.1-2.6.5-3.3.4-.5 2.2-.5 2.9 0 1.9 1.1 3.5 2.6 5.2 3.9 1.8 1.5 3.5 3.2 5.5 4.5 1.4.9 3.2 1.2 4.9 1.7.2-.3.4-.5.5-.8-.8-1.6-1.6-3.2-2.3-4.9-.7-1.7-1.3-3.4-1.9-5.1.3-.3.6-.6.9-.8 3.3 2.6 6.5 5.2 10 7.9.6-1.3 1.1-2.4 2-4.1 1.9 2.2 3.5 4.1 5.1 6.1.3.4.3 1.1.7 1.4 1 .7 2.1 1.3 3.1 2 .1-1.1.5-2.2.4-3.3-.3-2.3-.8-4.6-1.2-6.8-.5-2.3.4-4 2.4-5.1 1.6-.9 3.1-1.8 4.7-2.8 3.4-2.3 6.8-4.7 10.3-6.9 1.7-1.1 3.5-1.8 5.2-2.9 4.6-2.8 9.4-5.2 13.5-8.5 4.5-3.7 9.8-4.8 14.7-3.9 3.7.7 4.6-.9 6.1-3 1-1.4 2.1-2.8 3.3-4 2.2-2.3 3.9-2.5 6-.2 2.3 2.6 4.6 1.7 7 1 1.8-.5 3.4-1.6 5.1-2.4 2.6-1.3 4.7-.8 6.9 1.6 1.8 2 .8 3.6-.1 5.6-2.1 4.2-3 8.6-1.3 13.4.5 1.4-.1 3.1-.1 4.7 0 1.4.2 2.7.3 4.1.3 0 .5.1.8.1.6-1.4 1.2-2.7 1.9-4.1.8-1.8 2.2-3 4.1-2.4 1 .3 2.1 1.4 2.6 2.5.8 1.8.1 3.5-1.5 4.6-1 .7-2.1 1.4-3.2 2.1 2.2 1.4 3.8 1.1 4.9-1 .7-1.4 1.3-2.9 2-4.3 1.5-2.9 4.1-4.1 6.8-3.2 2.5.8 3.7 2.9 3.5 6.4-.2 3.1-.6 6.1-.9 9.3 1 .2 1.6.2 2.2.4 1.5.5 2.2 1.3 1 2.9-.5.6-1.1 1.3-1.1 2 0 1 .4 2 .6 2.9.8-.3 1.7-.3 2.2-.8 3.2-3.3 6.3-6.8 9.5-10.1.9-1 2.3-1.4 3.5-2.2.6 1.4 1.5 2.7 1.8 4.2.4 2 .4 4 .6 6.3h6.1c2.8.1 5.3.9 7.4 3.2 2.5 2.7 5.2 2.4 6.3-1.2 1.2-4 1.7-8.3 2-12.5.6-6.7-2.3-12.7-3.8-19-.5-2.1-.9-4.3-1.5-6.8 2.5.2 3.3 1.6 4 3.4.5 1.3 1.4 2.4 2.1 3.6.7 1.3 1.8 2.6 2 4 .5 3.6 1.3 7.4-.6 10.9-.4.7-.2 1.7-.3 2.5.2.2.5.3.7.5.7-.8 1.6-1.5 2-2.4 1-2.6 1.8-5.4 2.7-8 .4-1.1 1-2.1 1.8-3.9 1.2 1.9 1.9 3.1 2.8 4.5.8-.1 1.8-.3 2.8-.4 5-.6 8.7 1.9 9.1 6.3.5 4.9-2.9 9.6-7.5 10.1-2.2.3-4.5.3-6.7.6-3.9.6-6.8 2.2-7.6 6.9-1 6.5-3.8 12.3-7.9 17.4-1.2 1.6-2.6 3.2-3.2 5.1-.6 1.9-1.1 4.3-.6 6.1 1 3.5 2.7 6.7 4.3 10 .8 1.7 2.3 1.2 3.6.7 1.4-.5 3.2-1.9 4.2-1.5 2 .9 3.8 2.6 5.1 4.3.6.8.1 2.6.1 3.9v3.2c.9-.3 2-.5 2.7-1.1 2.1-1.8 4.5-1.7 6.8-1 6.8 1.9 10.5 7.5 10.1 14.9-.3 6.1-4.9 11.4-11.2 11.3-4.6 0-8 1.2-11.4 4.3-3.3 3-5.5 2.4-8.9-.6-1-.9-2.3-2.8-3.6-1.2-1.3 1.6.6 2.8 1.6 3.5 3.2 2.1 6.4 4.3 9.9 5.7 10.7 4.2 20.7 9.5 29.9 16.8 6.1 4.8 9.5 4.4 15.4-.7 4.4-3.8 12.4-2.5 15.7 2.4 3.3 5 4.5 9.9 1.4 15.4-.3.6.3 1.6.4 2.5.1.7.2 1.3.2 1.4-3.7.1-7.2.7-10.6.3-4.2-.4-8.2-2-10.9-5.8-1.4-1.9-2.5-4.1-4-5.9-.9-.9-2.4-1.8-3.7-2.8-.1 0 0 0 0 0zm-258.9-54c-1-2.1-2.1-4.3-3-6.5-1.4-3.5-2.2-7.3-3.9-10.7-2.5-5.1-5.8-9.7-12.3-9-2 .2-5 1.1-5.4 2.4-.8 2.2-.7 5.6.5 7.6 2.3 3.7 5.7 6.8 8.6 10.1 1.1-.6 1.9-1.1 3.1-1.7 0 1.2.3 2 0 2.6-1.1 2.8-.3 4.5 2.6 4.8 3.2.2 6.4.2 9.8.4zm5.9 4.7c-.8 3.7-.8 3.7-4.4 2.6-.1 0-.2-.1-.2-.1-1.7.7-3.6 1.2-5.2 2.1-.5.3-1 2.1-.9 2.1 1.5.9 3 2.1 4.7 2.3 2.8.3 5.6.2 8.4-.1.9-.1 1.9-.8 2.4-1.6.2-.3-.6-1.5-1-2.2l-2.4-3.6c-.5-.3-.9-.8-1.4-1.5zm19.9-41.4c-7.3.2-13.8-3.8-21-2.2 2.3 3 5.1 4.3 8.4 5.2 2.4.7 3.7.9 3.8-1.9 3-.4 6 5.3 8.8-1.1zM398 747.8c1.5-.1 3 .1 4.2-.4 1.9-.8 1.3-2.7.7-4.1-.7-1.6-1.7-.8-2.7 0-.5.3-1.9.2-2 0-.8-2.8-2.2-1.5-3.5-.6-.8.6-1.8 1.1-2.4 1.8-.5.5-.9 1.5-.7 2.2.2.7 1 1.2 1.6 1.9.5-.6 1-1.1 1.4-1.7.2-.3.2-.9.5-1.2.4-.4 1-.9 1.6-1 .3 0 .8.7 1 1.2.2.4.1 1 .3 1.9zm-54.3-109.5c-1.5-1.2-2.6-2.6-4-3-1-.3-2.4.5-3.7.8.4 1.1.4 2.5 1.1 3.2 2.2 1.8 4.1.3 6.6-1zM323 676.9c.2-.4.3-.8.5-1.2-1.3-.9-2.6-1.9-3.8-2.8-.3.1-.5.3-.8.4.1.9-.1 2.3.3 2.5 1.1.6 2.5.8 3.8 1.1zm421.1-485.1c-1 1.8-2.4 3.5-2.9 5.4-1.1 4.5-3 8.4-5.8 12.1-1 1.3-1.5 2.9-2.1 4.4-.1.4.4 1 .7 1.4.4-.4 1-.7 1.3-1.1.3-.5.5-1.1.8-1.9 1.8 1.3 1.2 2.5.6 3.8-1.5 2.7-1.2 3.2 1.8 4.1 1 .3 1.8 1.2 2.6 1.9 1.1 1 1.9.9 2.8-.3 1.2-1.6 2.7-2.9 3.9-4.4.4-.4.4-1.1.5-1.7.5-3 .6-6.2 1.6-9.1 2.6-7.4 11.8-9 17.2-3.2 4 4.3 4.8 9.7 4.9 15.2 0 .4-.5.9-.7 1.3-.4.9-1 1.8-.9 2.6.3 2.8-1.5 4.3-3.3 5.9-.5.4-1.4.6-2.2.5-2.1-.2-2.9 1-3.6 2.7.7.1 1.2.3 2.3.5-.8 1-1.4 1.8-2.1 2.5-.9.9-2.2 1.7-3 2.7-1.7 2.3-1.1 4.3 1.7 5.2 2.4.7 4.9 1.2 7.5 1.6 2.2.3 3.7 1.1 4.7 3.1.6 1.2 1.8 2.3 3 2.8 1.9.9 3.2 1.8 2.9 4.1.8.1 1.4.2 2.1.3 2.4.5 2.9 1.5 1.3 3.4-.8.9-1.8 1.6-2.7 2.4 2.9 2.8 4.8 3 6.4-1.7.9-2.6 2.3-3.7 4.6-3.3-.4.8-.8 1.5-1.1 2.3-.2.3-.4.7-.7 1-2.1 2.5-4.2 4.9-6.3 7.4-.8 1-.3 1.6.9 1.5.8 0 1.5-.3 2.3-.4.6 0 1.6-.1 1.8.2.8 1.2 2 .9 3.2 1 1.8.1 3.6.4 5.4.5 2.5.1 5.1.1 7.6.2 2.3.1 4.6.1 6.7.7 4.8 1.2 9.5 2.8 14.3 4.2 3.1.9 5.9.4 8.4-1.8.9-.7 2.6-1.1 3.7-.9 2.8.5 5.5 1.5 8.3 2.3 1.6.5 3.2 1.1 3.4 3 .3 1.8-1 2.7-2.4 3.6-4.2 2.8-9.1 4-14 4.6-7.1.8-14.2 1-21.4 1.5-.8 0-1.6 0-2.3-.3-6.5-3.1-12.7-1.9-19.1 1 .9.6 1.7 1 2.3 1.6.4.4.6 1.3.4 1.6-.2.4-1.2.7-1.7.5-3.2-1.1-6.4-2.3-9.6-3.4-.8-.3-1.8-.7-2.4-.4-1 .5-2 1.4-2.4 2.3-.2.4.7 1.6 1.4 2.1 1 .7 2.3 1 3.3 1.6.7.4 1.2 1.1 2.2 2-1.8.3-2.9.4-4 .7-.5.2-.9.7-1.4 1.1.5.4.9 1 1.5 1.1.8.1 1.7-.1 2.4-.4 1.5-.7 2.9-1.1 4.5-.3.5.3 1.3.1 1.9.1 1.4 0 2.9-.1 4.3 0 .5 0 1 .6 1.5 1-.4.5-.6 1.2-1.1 1.4-1.8.8-3.5.6-5.3-.3-.5-.3-1.2-.7-1.7-.6-1.9.5-3.8 1.2-5.8 2.3 1.4.5 2.8 1 4.2 1.6.8.4 1.4 1 2.1 1.6.3.3.5.8.8 1 2.4 1.5 4.3 3.4 5.7 5.9.4.7 2.2.9 3.4 1.1 2.1.4 4.1 2.1 4.2 3.9-10.3-4-20.1-9.3-31.2-10.5-.1.2-.2.4-.4.7 1 .6 2 1.1 3 1.7.9.5 1.8 1 2.6 1.6.4.3.4.9.6 1.4-.6.2-1.2.6-1.7.5-.5-.1-1-.5-1.4-.9-1.4-1.2-2.8-1.1-3.2.6-.4 1.5-1.2 1.7-2.5 1.7-1.7 0-3.4 0-5.1.2-1.8.1-2.5 1.1-2.2 2.8.1.4.2.9.3 1.3.7 2.7.7 2.7-2.1 3.3.5.3.9.6 1.4.9 4.8 2.5 9.6 5 14.3 7.5.9.5 1.6.7 2.6-.1.6-.5 1.7-.6 2.6-.8.1 1 .6 2.1.3 2.9-.5 1.3-.2 2.2.6 3.2 8.3 10.9 18.9 19.6 29.3 28.5 6.8 5.8 13.7 11.6 20.5 
                                    17.5 1.1.9 2 2 3 3.1-.2.2-.3.4-.5.5-1.2-.8-2.6-1.4-3.7-2.3-5.9-4.8-11.9-9.6-17.6-14.5-7.2-6.2-14.2-12.6-21.2-19-2.2-2.1-4.6-3.6-7.6-4.5-1.3-.4-2.3-1.4-3.5-2.2-2.7-1.7-5.4-3.6-8.2-5.2-2-1.1-3.7-2.3-4.4-4.7-.4-1.5-1.6-2.9-2.8-4-1.1-1.1-2.6-1.5-4.2-.6.8 2.5 3.9 3.7 3.5 7-1-.7-1.9-1.4-3-2-.9-.5-1.9-.7-2.8-1 .4.9.7 1.8 1.1 2.6.3.5.8.8 1.2 1.3 1 1.2 1.2 2.4-.4 3.4-7.1 4.5-6.8 14.3-3.2 19.4 1.8 2.6 1.2 4.5-2.3 6.2-.4-1.7-1-3.2-1.2-4.9-.4-2.5-.6-5-.9-7.5-.2-1.2-.6-2.1-2.3-2 .5.6.9 1 1.7 1.8-.9.3-1.7.7-2.4.8-.3 0-.5-.9-.9-1.6-1.3 1.2-1.7 2.8-1.5 4.4.8 0 1.5-.2 2.2-.1.2 0 .5 1 .3 1.1-.6.4-1.3.7-2 1.1.4.7.9 1.4 1.4 2.3.7 1.2.8 2.4.3 3.8-.4 1-.2 2.2-.2 3.3-.1.9-.2 1.7-.2 2.6h-.5c-.9-1.3-1.7-2.7-2.8-4-.9-1.1-2.1-1.8-3.5-.7-1.5 1.1-2.5 4.1-1.6 5.1.4.4 1.4.6 2.1.5 5.2-.2 9.5 1.6 12.5 5.8 3.6 5 2.9 13.4-1.4 17.8-1.7 1.7-3.5 3-6.2 2.4-.6-.1-1.4.2-2.1.4-1.2.4-2.3.8-3.5 1.2-.2-.2-.5-.3-.7-.5-.2 3-.4 6-.5 8.9-.1 3 0 6 .1 9-.3 0-.6.1-.8.1-.3-.6-.7-1.2-.8-1.9-.5-4.8-1-9.5-1.3-14.3-.1-1.5-.5-2.7-1.7-3.6-4.1-3-6-6.9-5.7-11.8 0-.7-.2-1.4-.3-2-.2-1.3-1.2-2.9 1.2-3.4.2-.1.4-.5.5-.7.9-1.5 1.9-3 2.8-4.6.3-.5.5-1.4.3-1.6-.4-.4-1.4-.8-1.9-.6-1 .4-1.9 1.1-3.1 1.9 1 .6 1.6.8 2 1.2.3.3.5.8.4 1.2-.1.3-.7.7-1 .7-1.1-.1-1.5.2-1.6 1.4 0 .5-.7 1.3-1.2 1.3-1.5.2-1.8 1.1-1.8 2.3 0 1.4.1 2.8 0 4.2-.1.7-.6 1.4-.9 2.1-.6-.5-1.2-.9-1.8-1.4-.2-.2-.3-.4-.5-.6-.7 1.2-.5 2 .5 2.8.7.5 1.6.9 2.3 1.5.6.6 1.2 1.5 1.5 2.3.1.4-.3 1.2-.7 1.3-.3.1-1.1-.2-1.4-.6-.5-.4-.7-1.1-1.1-1.6-1-1.3-1.9-1.4-2.6.1-.6 1.3-1.1 2.8-1 4.2.2 4.9.8 9.7 1.1 14.5.2 3 .1 6.1-.1 9.1-.1 1-.7 1.9-1.2 3.3-3.9-5-7.4-9.6-11.1-14.4-.9.4-2 1.3-3.3 1.5-.7.1-2.1-.8-2.4-1.6-.4-1-.3-2.4-.1-3.5.1-.5.8-1.2 1.3-1.4.4-.1 1.1.4 1.6.7.5.4.8.9 1.2 1.4.2 0 .4-.1.5-.1 0-.6.3-1.4 0-1.8-1.3-1.6-2.5-3.2-4.9-3.4-.5 0-1.4-.5-1.4-.9-.6-2.7-1-5.5-1.6-8.5-2.1.8-3.1 2.2-3.8 4-1 2.5-2 5-2.9 7.6-.8 2.4-2.6 3.5-5 4.1-.8.2-1.5.3-2.3.6-.4.2-1.1.6-1.1.8 0 .5.3 1.2.8 1.6 1.4 1 1.8 2.5 1 3.8-.7 1.1-3.2 1.4-4.5.7-2.3-1.4-2.5-2.7-.9-4.7.3-.3.4-.8.5-1.1-.1-.2-.2-.4-.3-.5-1.2.5-2.5.8-3.4 1.6-2 1.5-3.8 3.2-5.7 4.9-1.3 1.2-2.6 1.4-4.3.6-2.4-1.1-4.7-.9-6.8.8-1.6 1.3-3.2 2.6-5 3.7-1.5.9-3.3 1.6-5 2-2.5.6-3.8-.6-3.6-3.1.1-1.7.6-3.3.9-5 .5-2.2 1.1-4.4 1.4-6.7.5-3.3-.8-5-4.1-5.9-1.7-.5-3.5-1.3-5.2-1.5-1.4-.2-3.1 0-4.3.6-3.2 1.5-6.1 1.4-8.8-.7-2.9-2.2-3.8-5.2-3.1-8.6.5-2.6 2.3-4.4 5.1-4.8 3.7-.5 7.2-.2 10.2 2.5.6-1.2 1-2.8 3-1.8.1.1.5-.1.7-.2 3.2-3 7.2-4.4 11.5-5.2-.4-3.3 0-3.9 2.8-4.8.1.8.1 1.6.2 2.4 1.7-.4 2.6-1.9 2-3.7-.5-1.2-1.6-2.2-2.4-3.3-.5-.7-1.4-1.5-1.2-2.2.3-1.5-.4-2.4-1.2-3.5-2.1-2.8-3.2-6.6.6-10 2.1-1.9 4.3-3.7 6.3-5.7.9-.9 2.3-2 1.2-3.2-.7-.7-2.5-.9-3.6-.6-1.9.5-3.5 1.6-5.3 2.4-1 .5-1.9 1.2-3 1.4-.8.2-1.9 0-2.4-.5-.4-.4-.2-1.6.1-2.2.9-1.3 2.1-2.4 3.2-3.6 1.2-1.3 2.6-2.4 3.6-3.8.7-1 1-2.3 1.5-3.5-.2-.1-.4-.3-.6-.4-1.2.5-2.4 1-3.7 1.5-1.3.4-2.5.8-3.8 1.2-.2-.2-.4-.5-.6-.7 2.1-2.3 4.1-4.5 6.3-7-.9-.5-1.7-.9-2.9-1.6 1.7-1.3 3.2-2.4 4.7-3.5.3-.2.8-.2 1.1-.4.6-.7 1.1-1.5 1.6-2.2-.8-.2-1.6-.5-2.4-.4-1.7.1-3.4.4-5.1.6-1.7.2-2.9-.5-3.6-2l-1.8-3.6c-1.5-2.6-3.1-5.2-4.6-7.9-.7-1.3-1.2-2.7-1.8-4-1.8-3.5-3.3-7.2-5.6-10.3-2.5-3.5-3.1-7.4-2.1-11 .7-2.7-.4-3.4-1.9-4.7-1-.8-1.9-1.7-2.8-2.7-1.6-1.7-1.7-3 .1-4.4 2-1.5 1.5-3.3 1.1-5.1-.3-1.3-1-2.6-1.5-3.9-.8-2-.3-3.5 1.5-5 1.5-1.2 2.7-.4 4.1.4 3 1.7 6.2 2.6 9.7 1.6 1-.3 2.3.2 3.5.3 1 .1 2 0 3 0 0-.2.1-.4.1-.6-1-.5-2-1.1-2.9-1.6-1.3-.7-2.1-1.8-1.5-3.1.3-.7 1.2-1.5 1.9-1.8 1.4-.5 2.6.1 3.3 1.3.5.8.9 1.6 1.4 2.5 1.1-1.6 1-2.8-.5-3.7-1-.6-2.1-1.1-3.1-1.7-2.1-1.2-2.8-3.2-2-5.2.7-1.8 2.3-2.6 4.9-2.2 2.2.3 4.5.8 6.8 1.2.2-.7.2-1.2.4-1.6.5-1.1 1.1-1.6 2.2-.6.4.4.9.9 1.4.9.7.1 1.5-.2 2.2-.3-.2-.6-.1-1.3-.5-1.7-2.3-2.5-4.7-4.9-7-7.5-.7-.7-.9-1.8-1.4-2.7 1.1-.4 2.1-.9 3.2-1.1 1.5-.2 3-.1 4.6-.1.1-1.4.2-2.9.3-4.5.2-2.1.9-3.9 2.7-5.3 2.1-1.7 2-3.7-.6-4.7-2.9-1.1-6-1.6-9.1-2.1-4.9-.8-9.4 1-14.1 1.8-1.6.3-3.2.5-5.1.7.2-1.8 1.4-2.4 2.7-2.8 1-.3 1.8-.9 2.7-1.4 1-.5 2-1.2 3-1.3 2.7-.2 5.5-.6 8 1 .5.3 1.2.2 1.8.3.1-.2.3-.3.4-.5-.6-.5-1-1.3-1.7-1.6-1.9-.9-3.9-1.6-5.8-2.4-.8-.3-1.5-.8-2.8-1.5 1.4-.8 2.4-1.3 3.4-1.8-.1-.6-.1-1.3-.2-2.1-.2-3.7 1.8-6.3 5.1-6.4 3.6-.1 6.9 2.6 7 6 .1 1.6 0 3.3.1 4.9.2 2.9 1.3 5.1 4.7 5.9 4.7 1.1 8.8 3.4 12.4 6.6 1.1 1 2.3 2 3.6 2.6 1.4.6 3.1 1 4.5.7 2.6-.6 5.1-1.7 7.6-2.6 1.3-.5 1-1.6.7-2.6-.3-1.1-1.2-2.4-.9-3.1.7-1.4 2.1-2.6 3.4-3.6.6-.4 1.9.1 2.9.1.8.1 1.5.1 2.3.1-.2-.7-.2-1.5-.7-2-1.2-1.6-1-3.4-.4-5.1 1.7-4.9 6-7.3 11.4-6.7 4.5.5 8.1 4.2 7.8 8.8-.2 3.4.5 6 2.6 8.6 2 2.6 1.5 4.2-.9 6.5-.7.7-2.1 1.5-1 2.6s2.1-.3 2.7-1c1.7-2.2 3.5-4.5 4.7-7 3.6-7.6 8-14.7 13.8-21.1 3.8-4.2 3.7-6.8.2-11.3-2.6-3.4-1.2-9.3 2.6-11.4 3.8-2.2 7.5-2.8 11.4-.3.4.3 1.2-.1 1.8-.2.5 0 1-.1 1.1-.1-.1 2.7.1 5.3-.3 7.8-.5 3.1-1.9 5.9-4.8 7.7-1.5.9-3.1 1.6-4.6 2.6-.8 1.2-1.5 2.3-2.3 3.1-.1.1 0 0 0 0zm-52.6 187.3c-1.6.6-3.2 1.3-4.9 1.8-2.7.8-5.5 1.3-8 2.3-3.9 1.6-7.4 3.8-7.2 8.6.1 1.4.6 3.7 1.5 4.1 1.6.7 4.1.8 5.6 0 2.9-1.5 5.3-3.8 7.8-5.8-.4-.8-.7-1.4-1.1-2.3.9 0 1.5-.1 1.9.1 2 .9 3.3.5 3.7-1.7.2-2.2.4-4.6.7-7.1zm3.7-4c2.7.8 2.7.8 1.7 3.4 0 .1-.1.1-.1.2.4 1.3.7 2.7 1.3 3.9.2.4 1.5.8 1.5.8.7-1.1 1.7-2.1 1.9-3.3.4-2 .4-4.1.4-6.2 0-.6-.5-1.4-1-1.9-.2-.2-1.1.4-1.6.6-.9.5-1.8 1-2.8 1.6-.4.2-.7.5-1.3.9zm-29.3-16.8c-.2 5.4-3.5 9.9-2.7 15.3 2.3-1.5 3.4-3.5 4.2-5.9.6-1.7.9-2.7-1.2-2.9-.1-2.1 4.2-4-.3-6.5zm83.2-46c0-1.1.2-2.2-.1-3.1-.5-1.5-1.9-1.1-3-.7-1.2.5-.7 1.2-.2 2 .2.4.1 1.4-.1 1.4-2.1.5-1.2 1.5-.6 2.5.4.6.7 1.4 1.2 1.9.4.4 1.1.7 1.6.6.5-.1 1-.7 1.4-1-.4-.4-.7-.8-1.2-1.1-.2-.2-.7-.2-.9-.4-.3-.3-.6-.8-.6-1.2 0-.2.6-.5 1-.7.4-.2.8-.1 1.5-.2zM666 346.6c-1 1.1-2 1.8-2.4 2.8-.3.7.2 1.8.4 2.7.8-.2 1.8-.2 2.4-.7 1.5-1.4.4-2.8-.4-4.8zm27.3 17.2c-.3-.1-.6-.3-.9-.4-.7.9-1.5 1.8-2.2 2.7l.3.6c.6 0 1.6.2 1.8-.1.5-.9.7-1.9 1-2.8z"/>',
            $gradID);
        }
        $mask = '<path d="M895.9 639.1c-6.4-3.7-12.4-8.9-19.3-10.7-16-4.1-30.2-11-43.2-21.5-4.5-3.6-10.3-5.6-15.7-7.7-1.3-.5-3.4 1.5-5.2 2.3 1.3 1.6 2.3 3.6 3.9 4.7 1.7 1.2 3.9 1.7 6.6 2.8-4.7 6.6-9.2 4.3-13.6 1.9-9.7-5.4-11.5-4.4-14.7 6.4-1.1 3.5-4.3 6.4-6.9 9.1-3.8 4-3.3 6.8 1 10.2 5.6 4.3 10.4 9.7 15.8 14.2 1.5 1.3 4 1.5 6.1 1.9 10.9 2 22.3 2.3 32.6 6 26.4 9.7 32 42.8 10.7 62-15.6 14.1-35.1 16.7-54.9 17.1-1.5 0-3-1.7-4.7-2.4-3.1-1.3-6.4-3.8-9.4-3.5-10 1-15.5-5.6-20.9-12.2-1.5-1.8-2.1-5.2-1.9-7.8.7-7.4-3.3-10.5-9.4-13-.5 2.3-1 4.3-1.9 8.2-3.5-2.9-6.5-5-9-7.6-3.4-3.5-5.9-8-9.6-10.8-8.3-6.3-15.4-4.1-18.7 5.9-2.8 8.7-4.6 17.7-6 26.8-1.2 7.8-4.2 13.2-11.5 16.9-4.2 2.1-8.3 6.3-10.3 10.7-3.2 6.8-6.7 11.5-14.8 10.3-.5 2.9-.8 5.2-1.3 7.4-1.8 8.7-5.6 10.3-12.1 4.6-3.2-2.8-5.7-6.5-8.5-9.8-10.1 10.2-10.9 17.2 5.7 23.1 9.1 3.3 13.2 8.4 11.5 16.8-2.8-1.4-5.5-2.8-8.2-4.2-1.2-.8-2.3-1.6-3.5-2.5-8.8-7.7-17.5-15.5-26.5-22.9-3.4-2.8-5.6-1-5.5 3.2.1 2.8 1.1 5.5 1.3 8.3.1 2.2.3 5.7-.9 6.5-4.4 3-3.4 7.2-3.8 11.3-.5 6.5-1.6 13-2 19.6-.5 9.1-.5 18.3-1.1 27.4-.5 8.1-.6 16.4-2.6 24.2-4.6 17.2-10.5 34.1-15.6 51.2-3.3 11.1-1.7 21.1 6 30.3 2.6 3.2 3.9 9.3 3.1 13.5-2 10.1-5.5 19.9-8.5 29.7-1.8 5.8-4.2 11.3-10.8 12.3-6.4.9-9.8-3.8-12.9-8.6-10-15.3-14-32.9-15.8-50.6-2.7-25.5-3.2-51.3-4.5-77-.1-2.7.1-5.8 1.3-8.1 11.4-23.2 7.2-45.6-3-68.8-2.2 3.2-3.6 6.2-5.8 8.2-1.4 1.3-4.6 2.2-5.9 1.4-1.4-.8-2.4-4.4-1.8-6.1 4-11.5 8.5-22.8 12.6-34.3 1-2.8 2.4-6.6 1.4-8.8-1.7-3.6-4.9-7.1-8.3-8.8-1.4-.7-5.8 2.6-7.5 5-2.5 3.5-3.5 8.2-5.7 12-1.4 2.5-3.9 4.3-7.1 7.7-1-6.4-1.2-10.6-2.3-14.6-.5-1.9-2.6-3.4-3.9-5.1-1.4 1.7-3.7 3.3-3.9 5.2-.3 2.8.2 6.1 1.4 8.6 2.5 5.4 3.7 10.4.8 16.1-1 1.9-.6 4.5-.6 6.8-.1 5.2.3 10.4-.2 15.5-.2 1.8-2.3 3.5-3.5 5.2-1.7-1.4-4.2-2.4-5-4.1-2.6-6.4-2.2-12.8 1.4-18.9 1.1-1.9 2.7-4.4 2.3-6.2-1.7-6.9-4-13.6-8-21.1-2 5-3.7 10.1-6 14.9-1.4 2.8-3.7 5.2-5.7 7.5-1 1.2-3 1.6-3.8 2.9-5.5 8.5-12.2 15.4-21.3 20.3-2.7 1.5-3.3 7.9-4.1 12.1-1.5 7.5-7.7 14.8-14.3 15 15-36.8 34.2-71.7 39-111.8-.8-.4-1.6-.9-2.4-1.3l-6.3 10.8c-1.9 3.2-3.6 6.6-6 9.4-1 1.3-3.4 1.3-5.1 2-.6-2.1-2-4.3-1.7-6.3.2-1.8 1.9-3.6 3.3-5.2 4.5-5.1 4-9.9-2.1-11.5-5.4-1.4-6-4.4-6-9 .1-6.1 0-12.3-.4-18.4-.4-6.6-3.9-9.1-10.1-7.9-1.6.3-3.1.7-4.7 1.1-9.8 2.6-9.8 2.6-11.9-7.8-1.2 1.9-2.3 3.3-3.1 4.9-9.2 17.1-18.4 34.2-27.7 51.2-1.8 3.4-2.8 5.8.2 9.3 1.9 2.2 2 6.1 2.9 9.3-3.6.4-7.6 2-10.6.8-4.7-1.9-7.7-.9-11.6 1.9-39.5 29.4-71.3 67-103.6 104.1-21.1 24.4-42.3 48.7-63.6 72.9-3.4 3.8-7.4 7.1-11.2 10.6-.6-.6-1.3-1.1-1.9-1.7 2.7-4.4 5.1-9.1 8.3-13.1 17.5-21.1 34.8-42.3 53-62.8 22.6-25.5 45.7-50.5 69.1-75.3 7.5-8 13.1-16.4 16.4-27.1 1.4-4.6 5.3-8.4 8-12.6 6.3-9.7 13.1-19.1 18.9-29.1 4.2-7.3 8.3-13.2 17-15.5 5.4-1.4 10.4-5.7 14.6-9.8 4-3.8 5.3-9.1 2.3-15-9.1 2.8-13.5 13.9-25.4 12.4 2.4-3.5 5.2-6.9 7.2-10.7 1.7-3.1 2.6-6.7 3.8-10.1-3.2 1.3-6.5 2.3-9.5 3.9-1.8.9-3 2.8-4.6 4.1-4.4 3.7-8.7 4.1-12.1-1.4-16-25.5-51.1-24.9-69.5-12.5-9.4 6.4-16.1 4-22.1-8.6 6.1-1.5 11.7-3.3 17.5-4.2 9-1.3 18.1-1.9 27.1-3 4.1-.5 7.4-2.2 7.1-8.3-2 1.9-3.6 3.3-6.4 6-1.2-3.4-2.6-6-2.7-8.6 0-.9 3.3-1.9 5.7-3.2-4.3-4.6-9.9-6.1-15.8-5.5.1 2.9.6 5.5.1 8-.1.7-3.7 1.6-4.1 1.1-1.6-2.1-2.5-4.7-3.9-7.4-2.4 1.4-5.2 3.2-8.2 4.9-4.4 2.6-8.6 2.9-13.6.8-3.5-1.5-7.9-.6-11.8-.9-3.1-.2-6.2-.6-9.3-.9v-1.7c4.9-3.2 9.9-6.1 14.5-9.8 4.1-3.2 6.6-7.4 2.7-12.7-4-5.4-14.7-9.2-18.1-5.9-1.6 1.5-2.1 5-2 7.5.4 18.8-6 34.2-21.2 44.9-18 12.6-48.4 9.8-64-5.9-6.1-6.1-10.7-12.8-8.5-22.5.5-2.3-.5-5-1.2-7.4-1.3-4.3-2.8-8.5-4.2-12.7.6-.9 1.2-1.8 1.9-2.6-10.7-.7-21.4-1.7-32.2-2.1-10.8-.4-21.6-.1-32.4-.1-.1-1-.3-2-.4-3 2.3-1 4.5-2.5 6.8-2.8 17.2-1.6 34.3-3.3 51.6-4.3 5.4-.3 9.7-1.7 13-6.1 10.8-14.5 25.1-21.1 42.8-20.2 2.4.1 4.9-.7 7.3-1.1 4.8-.8 10.4-4.3 12.2 4.3.2.8 1.7 1.4 2.7 2 5.4 3.5 10.7 7 16.3 10.2 1.7 1 5 1.9 5.9 1 1.5-1.5 2.8-4.9 2.2-6.7-1.2-3.6-3.8-6.8-6.5-11.1-2.1 3.6-2.9 5.7-4.2 7-1 1-3 1.7-4.2 1.4-1.1-.3-2.4-2.4-2.3-3.6.3-3.9-.8-5.5-4.9-5.7-1.7-.1-4.6-2.6-4.8-4.3-.7-5.3-3.9-6.5-8.1-6.7-5-.2-10 .3-15-.2-2.6-.3-5-2.2-7.4-3.3l5.1-6.6c.6-.7 1.5-1 2.3-1.6-4.3-2.5-7.2-2.1-10.1 1.8-2 2.6-3.2 5.9-5.4 8.1-2.3 2.3-5.4 4.1-8.4 5.2-1.3.5-4.2-1.1-4.8-2.5-.5-1.1.9-3.8 2.1-5 1.6-1.6 3.9-2.4 5.7-3.8 4.9-3.5 5.1-6.7-.3-9.3-4.6-2.2-10-4-14.9-3.8-17.5.6-34.9 2.6-52.4 3.3-10.8.5-21.8 0-32.6-.7-3.5-.2-6.9-2.5-11.8-4.5 18.2-13.7 34.8-26.2 52.2-39.3-1.5-3.2-4.8-7.3-5.3-11.8-.3-2.7 3.1-7.3 5.9-8.4 3.8-1.5 8.5-.9 12.7-.2 1.9.3 4.3 2.7 4.9 4.7.4 1.5-1.4 4-2.7 5.7-1.3 1.7-3.3 2.9-4.9 4.4.1.6.3 1.3.4 1.9 2.1.1 5 1.3 6.3.2 5.8-4.5 11.7-9 12.3-17.6.1-1.8 1.8-4.8 3.2-5.1 9.9-2 19.9-3.5 30.5-5.3-2.7-7.5-7.8-11.3-14.3-13.9-9.1-3.5-18.1-7.5-27.2-10.9-8.5-3.1-12.5-9.6-14.6-18.1-.7-2.7-1.2-5.6-2.1-8.2-.6-1.5-2-3.9-3-3.8-2 .1-4.4 1.1-5.6 2.6-3.8 4.9-8.9 6.4-13.7 3.4-3.8-2.4-5-11.6-2.2-16.1 5.1-8.2 9.7-8.9 16.8-2.9 1.1 1 2.7 1.4 4.1 2 .7-.4 1.3-.8 2-1.2-1.8-4.2-2.9-8.9-5.5-12.4-5.4-7.3-11.5-14-17.6-20.7-4.3-4.8-5-9.5-2.1-15.4 4.2-8.5 3.5-16.7-2.5-24.4-4.6-5.8-9.3-11.7-12.9-18.2-3.1-5.6-5.6-11.9-7-18.2-1.9-8.9 2.3-13.7 11.1-13 6 .5 12 2.3 18 3.6 8 1.8 15.9 4.2 23.9 5.4 11.8 1.8 18-2.8 21.5-14.4 1.9-6.3 4.9-12.4 5.7-18.8.7-5.1 0-11-2.1-15.6-5.3-11.5-5-21.9 2.9-31.6 8.1-10.2 18.8-13.5 31.2-11 9.3 1.9 15.9 8.4 17.2 18.6 1.7 13.2.6 26-9.4 36.7 4.4 2.2 10 3.8 6.2 10.8-.3.5.3 1.9.9 2.5 10.6 11.8 15.7 26.2 18.4 41.7 11.7-1.3 14.1.1 17 10.2-3 .2-5.8.3-8.7.5 1.3 6 6.6 9.6 13.2 7.2 4.4-1.6 8-5.8 12-8.6 2.5-1.7 5.6-4.8 7.8-4.3 5.5 1.2 8.7-1.2 12.7-4.2 10-7.5 24-11.3 36.1 2.5 6.7 7.7 13.3 15.5 20.2 23 3.1 3.3 7.2 8.2 11.4 4.4 2.5-2.3 3.2-8.9 2.2-12.8-1.8-6.7-5.5-12.8-8.4-19.1-1.7-3.6-4.2-7-5-10.8-.6-2.7.2-6.8 2-8.6 1.3-1.3 5.8-.8 7.8.6 4.7 3.3 8.7 7.5 12.9 11.5 4.5 4.3 8.5 9.3 13.4 13 3.6 2.7 8.3 3.8 12.5 5.6.5-.7 1-1.3 1.6-2-1.7-4.4-3.6-8.8-5.1-13.3-1.5-4.5-2.7-9.2-4-13.7.9-.7 1.7-1.3 2.6-2 8.1 7.5 16.1 15 24.8 23 1.9-3.3 3.5-6 6.1-10.5 4.5 6.3 8.5 11.7 12.3 17.2.8 1.1.7 3 1.6 3.8 2.4 2.2 5.2 3.9 7.8 5.8.6-2.9 1.8-5.7 1.7-8.6-.3-6.1-1.2-12.2-1.9-18.2-.7-6.3 2-10.3 7.3-12.9 4.3-2.1 8.7-4.1 12.9-6.4 9.6-5.3 19-10.9 28.6-16 4.6-2.5 9.6-4.1 14.3-6.5 12.6-6.3 25.9-11.6 37.4-19.7 12.7-8.8 26.9-10.7 39.7-7.1 9.7 2.7 12.3-1.3 16.8-6.6 3-3.5 6.2-6.9 9.7-10 6.3-5.6 10.8-5.9 15.7.7 5.4 7.3 11.9 5.6 18.3 4.2 4.8-1 9.4-3.5 14-5.3 7.2-2.9 12.6-1 17.9 5.7 4.4 5.5 1.4 9.8-1.5 14.6-6.4 10.7-9.6 22.1-6.2 35 1 3.8-.9 8.3-1.1 12.5-.2 3.6 0 7.2 0 10.8.7.2 1.4.3 2.1.5 1.9-3.5 3.9-7 5.7-10.5 2.5-4.7 6.4-7.4 11.2-5.4 2.7 1.1 5.3 4.2 6.4 7 1.8 5-.5 9.2-4.9 11.9-2.9 1.7-5.9 3.3-9 4.9 5.6 4.1 9.9 3.6 13.2-1.6 2.2-3.5 4-7.4 6.2-11 4.6-7.4 11.6-9.9 18.7-7.1 6.4 2.6 9.2 8.5 7.8 17.6-1.3 8-2.9 16-4.4 24.2 2.7.7 4.3.8 5.7 1.4 3.9 1.7 5.6 4 1.9 7.9-1.4 1.5-3.1 3.3-3.4 5.1-.3 2.5.7 5.2 1.1 7.9 2-.5 4.6-.4 6-1.7 9.2-8.1 17.9-16.7 27.1-24.7 2.7-2.3 6.4-3.3 9.6-5 1.3 3.8 3.3 7.5 3.8 11.4.7 5.3.2 10.7.2 16.7 4.9.4 10.5.7 16.1 1.3 7.5.8 13.8 3.5 18.8 9.9 5.9 7.7 13.2 7.4 16.8-1.9 4.1-10.3 6.1-21.5 8-32.5 3-17.5-3.3-34-5.9-50.9-.9-5.8-1.6-11.5-2.5-18.2 6.6 1 8.4 5 9.9 9.9 1.1 3.5 3.2 6.6 4.8 9.9 1.7 3.6 4.3 7.2 4.5 10.9.6 9.7 1.8 19.7-3.9 28.7-1.1 1.7-.9 4.3-1.3 6.6.6.5 1.2 1 1.9 1.5 2-2 4.7-3.6 5.8-6 3.3-6.7 5.8-13.8 8.9-20.6 1.3-2.8 3-5.4 5.6-10 2.7 5.2 4.4 8.5 6.4 12.4 2.2-.2 4.8-.5 7.5-.6 13.3-.6 22.4 6.9 22.7 18.6.3 13-9.7 24.6-21.9 25.1-5.9.2-11.8-.2-17.7.3-10.5.7-18.5 4.4-21.4 16.7-4 17-12.7 31.6-24.4 44.3-3.6 3.9-7.4 8-9.5 12.8-2.1 4.9-3.8 11.1-2.8 16 1.9 9.3 5.8 18.3 9.2 27.3 1.8 4.8 5.8 3.6 9.3 2.7 3.9-1 8.8-4.4 11.4-3 5 2.7 9.4 7.5 12.7 12.5 1.5 2.2-.3 6.8-.6 10.3-.2 2.8-.4 5.6-.6 8.3 2.5-.7 5.4-.8 7.3-2.3 5.9-4.4 12.3-3.5 18.2-1.3 17.5 6.5 26.1 22 23.5 41.3-2.1 16.1-15.3 28.9-31.9 27.5-12.1-1-21.4 1.6-31.1 9-9.3 7.1-15 5.3-23.3-3.5-2.5-2.7-5.5-7.8-9.3-3.8-3.9 4 .9 7.6 3.6 9.6 8 6.2 15.9 12.8 24.8 17.1 27.3 13.3 52.6 29.5 75.2 50.4 15.1 14 24.2 13.6 40.8 1.3 12.4-9.2 33.3-3.9 40.9 9.7 7.7 13.8 9.8 27.1.5 41-.9 1.4.4 4.4.6 6.6.2 1.7.2 3.5.2 3.8-9.7-.4-19 .2-27.9-1.4-11.1-2-21.3-7-27.6-17.5-3.2-5.4-5.6-11.4-9.2-16.5-2.6-3.6-6.5-6.2-9.8-9.3 0 1.1.3 1.3.3 1.3zM224.4 442.2c-2.1-5.8-4.6-11.7-6.4-17.9-2.9-9.6-4.4-19.7-8-29-5.6-14.1-13.4-26.9-30.5-26.4-5.2.1-13.3 1.9-14.8 5.3-2.5 5.7-3 14.7-.2 20 5.4 10.3 13.6 19.1 20.5 28.3 2.9-1.4 5.1-2.4 8.5-4-.2 3.1.3 5.3-.5 6.9-3.5 7.2-1.8 11.9 5.8 13.3 8.2 1.7 16.6 2.4 25.6 3.5zm14.5 13.8c-2.9 9.6-2.9 9.6-12.2 5.9-.2-.1-.5-.3-.6-.2-4.7 1.4-9.6 2.5-14.1 4.6-1.5.7-3 5.3-2.8 5.4 3.8 2.7 7.6 6.1 11.9 7 7.2 1.5 14.8 1.6 22.2 1.6 2.3 0 5.1-1.8 6.7-3.6.6-.7-1.2-4-2.2-5.9-1.8-3.4-3.7-6.7-5.6-10-1-1.6-2-2.9-3.3-4.8zm61.3-105c-19.4-.9-35.5-13-54.8-10.2 5.5 8.4 12.6 12.3 21.1 15.4 6.2 2.3 9.7 3.3 10.4-4.3 7.8-.4 14.4 15.3 23.3-.9zm162.2 301c4 0 7.9.9 11.3-.2 5.3-1.8 4.1-6.8 2.6-10.7-1.6-4.3-4.2-2.4-7-.7-1.3.8-5 .2-5.2-.4-1.6-7.5-5.4-4.4-9-2.2-2.3 1.4-4.9 2.5-6.8 4.3-1.3 1.3-2.6 3.9-2.3 5.6.3 1.9 2.4 3.5 3.7 5.2 1.4-1.4 2.8-2.6 4-4.1.7-.9.7-2.4 1.5-3.1 1.3-1.1 2.9-2.2 4.4-2.3.8 0 1.9 2.1 2.4 3.5.4 1.3.3 2.7.4 5.1zm-120-300.1c-3.8-3.6-6.3-7.4-9.8-8.8-2.7-1.1-6.5.8-9.8 1.3.7 2.9.6 6.6 2.3 8.5 4.9 5.6 10.3 2 17.3-1zm-62.9 97.5c.5-1 1.1-2.1 1.6-3.1-3.2-2.7-6.4-5.4-9.6-8.2l-2.1.9c0 2.3-.8 5.9.2 6.6 2.9 1.9 6.6 2.6 9.9 3.8z"/>
                 <path d="M464.1 234.9c-.6-4.5-.8-8-1.5-11.3-.7-3.2-2-6.2-3-9.3-.8 0-1.6.1-2.4.1-1 3.2-2.2 6.3-2.8 9.5-1.8 9.1-9.7 13-17.4 8.3-12.6-7.6-14.1-19.4-3.4-29.3 3.9-3.6 3.7-6.3 0-8.9-4.8-3.3-4.3-6.8-2.7-12 1.4-4.6 1.2-10.3-.1-15-3.5-12.7-8-25-11.9-37.5-3.9-12.7-4.1-25.8 4.6-36.2 5.7-6.9 13.8-11.9 21.5-16.5 2.3-1.4 6.8 1.6 10.3 2 15.7 2.2 21.8 12.4 23 27.7.9 12.2 2.7 24.3 4.4 36.4.7 4.6 2.2 9.1 3.4 13.6.7-.2 1.5-.3 2.2-.5 0-10.4-.3-20.7.1-31.1.4-10.2 1.7-20.3 2.6-30.5.8 0 1.7.1 2.5.1 2.2 15.4 5.8 30.8 6.3 46.2.5 15.3-2.1 30.7-3.3 44.9h9c-.3 2.6-.6 5.3-1 7.9-3.2-.5-6.4-1.1-10-1.7-3.7 4.3-8.2 10.1-13.3 15.1-2.5 2.4-6.2 3.7-9.5 4.8-5.8 1.8-7 3.9-4.4 9.7 2 4.7 4.1 9.3-3.2 13.5zm148.5-76.7c-1.2 4.2-1.7 9.4-4.1 13.4-6.1 10.3-13 20.1-19.5 30.2-.7 1.1-1.3 2.5-1.3 3.7 0 6.5-4.6 8.9-9.3 9.2-6.6.4-12.3-6.8-11-13.2.6-3.2 2.4-6.7 4.7-8.9 2.6-2.5 3.4-4.6 1.1-7-8.3-9-4.8-18.8-.7-27.5 3.6-7.7 9-14.6 14.6-21 6.4-7.3 19-4.2 22.4 5.3 1.6 4.7 2 9.9 3.1 15.8zm341 257c9.7-.4 16.3 5.3 20.6 15 2.9 6.6.3 12-3.1 17-6 8.9-19 10.8-28.7 5.3-5.9-3.4-11.7-6.3-12.7-14.2-1.8-12.9 8.4-23 23.9-23.1zm-77.3-8.9c11.6.3 24.3 11.3 24.1 20.8-.1 7.6-10.2 15-19.6 14.5-9.7-.5-16.6-8-16.5-17.7.2-12.1 4.1-17.8 12-17.6zm-845-100.4c7.6.9 13.7 1.5 19.7 2.5 1.1.2 2.2 1.9 2.8 3.1 1.5 3.4 3.2 6.7 3.9 10.3.9 4.6 2.9 11.8.9 13.4-3.1 2.6-9.4 2.9-13.8 1.8-5.5-1.4-11.3-4.3-15.5-8.3-4.1-3.8-6.7-9.6-9.1-15-.5-1.2 1.7-4.8 3.5-5.8 2.7-1.4 6.1-1.6 7.6-2zm134.9 401.7c-.2 7.5-2.6 9.2-6.7 10.3-4.5 1.1-8.7 3.8-13.1 5.5-3.6 1.4-7.2 3.2-10.9 3.5-10.2.8-20.5 1.1-30.8 1.3-3.9.1-4.6-2.6-3.3-5.8.9-2.3 2.2-5.4 4-6.1 8.6-3 17.5-5.4 26.4-7.6 1.2-.3 3.3 1.2 4.3 2.4 1.6 1.9 2.7 6.1 3.9 6 4.4-.3 8.8-1.5 12.9-3 4-1.5 7.9-3.8 13.3-6.5zM226 146.1c8.4.3 19.6 9.1 19.2 14.9-.6 7-11.1 14.3-19.9 13.8-7-.4-14.6-6.8-14.6-12.4 0-7.6 8.4-16.6 15.3-16.3zm84.7 102.1c0 9.4-6.6 13.8-14 8.4-4.4-3.2-8.1-8.3-10.2-13.4-1.2-3 .4-8.3 2.5-11.3 1.2-1.7 6.2-1.5 9-.6 10 3.3 12.7 7.2 12.7 16.9zM66.3 587c1.3-2.6 2.2-4.3 3.3-6.6-1.5-.9-3-1.4-4.1-2.4-1.4-1.3-2.6-2.9-3.9-4.4 1.9-1.8 3.6-4.1 5.8-5 1-.4 4.3 2.1 4.4 3.5.6 5.1 3.4 5.3 6.7 3.8 4.3-1.9 8.7-3.8 12.3-6.7 4.8-3.8 13.4-2.9 15.7 2.8.7 1.6.1 5.2-1.1 6-2.7 1.9-6 2.9-9.2 3.7-8.3 2.2-16.7 4.2-25.1 6.1-1.2.4-2.7-.4-4.8-.8zm34.3-181.5c.2 6.3-7 12.5-14.7 12.7-6.8.1-11.9-4.3-12.1-10.6-.3-7.9 5-13.4 13.2-13.7 7.6-.2 13.5 4.7 13.6 11.6zM439 796.1c-3.3-2.8-8.3-5.5-11.1-9.9-1.4-2.1.6-7.6 2.5-10.7 3.9-6.6 9.9-2.5 14.8-1.5 2.3.5 4.1 3.9 5.9 6.2.8 1 .7 2.6 1.5 3.7 3.3 4.8 1.7 7.8-3.2 9.4-2.9.9-5.7 1.5-10.4 2.8zm61.1 167.5c-3.7-6.5-.4-67.8 4.4-76.8 2.8 24.8-.6 48.1-.4 71.3 0 1.7-2.5 3.5-4 5.5zm-354.4-78.2c-13.5 21.7-34.8 32.3-56 43.1 18.5-14.6 34-33.4 56-43.1zm799.4-307.6c.1 6.6-4.2 11.2-10.6 11.2-7 0-14.4-6-14.3-11.6.1-4.2 7.1-10.4 11.6-10.3 8.8.2 13.2 3.7 13.3 10.7zM454.4 705.7c-.1 8.7-2.3 12.4-7.5 12.4-7.1 0-12.3-4-12.2-9.3.1-5 4.7-10.3 9.1-10.4 7.5-.2 10.6 2 10.6 7.3zM106.3 544.3c2.2.4 4.3.4 6.2 1.2 1.7.7 4.2 2 4.4 3.4.3 1.9-.5 5.1-1.9 6.1-3.5 2.4-7.5 4.4-11.5 5.7-3.5 1.1-7.8 1.1-8.6-4.1-.7-4.5-.4-9.2 4.8-11.1 2.2-.7 4.5-.8 6.6-1.2zm235.5 175.3c-1.2-1.3-4.7-3.5-5.2-6.2-1-5.7 5.2-10 14.5-10.1 1.8 0 4.7 2.4 5.1 4.2.9 4.4-7.2 12-14.4 12.1zm139.6 238.7c-4.8-13.4 5.7-22.1 6-33.7 8.8 5.8 5.5 23-6 33.7zm-54.6-186.5c-4.7 4.1-7.6 8.9-11 9.2-4.5.4-6.7-4.3-6.9-9.4-.3-6.3 3.8-9.1 8.3-8.5 3 .4 5.4 4.8 9.6 8.7zm494.3-467.2c-4.9 5.2-8 9.2-11.9 11.8-.7.5-5.9-4.2-7.2-7.3-1.4-3.5 4.1-9.8 8-9.4 3.2.4 6.1 2.6 11.1 4.9zm-76.8 322.6c8.2 2.3 16.5 4.3 24.5 7 1.7.6 2.7 3.6 4 5.5-2.3.7-5.1 2.7-6.9 1.9-7.7-3.3-15.2-7.3-22.7-11.1.4-1.1.7-2.2 1.1-3.3zm-704-169.6c-5.3-2.9-10.4-4.9-14.7-8.2-1.8-1.3-2.3-5.2-2.3-7.9 0-1.3 3-3.9 3.7-3.6 2.2.9 4 2.8 5.8 4.5 1.8 1.8 3.1 4.7 5.2 5.8 4.2 2 4.3 4.6 2.3 9.4zM435 806.4c1-6.7 5.1-6.8 8.7-6.9 4.5-.2 6.4 2.8 6.4 7.3 0 5.9-5.1 7.2-8.4 7.2-2.3-.1-4.5-4.9-6.7-7.6zm102.6 8.3c.4 2.9 1.4 5.9.9 8.7-.8 4.9-2.3 9.8-3.7 14.6-.4 1.3-1.4 2.4-2.1 3.5-1.3-.9-3.3-1.6-3.9-2.9-.6-1.6-.4-3.8.1-5.5 1.8-6 3.8-11.9 5.7-17.9 1-.2 2-.4 3-.5zM114.9 474.5c-3.4-3.7-5.3-5.8-7.2-7.9 3.5-2.4 6.9-5 10.8-6.7.7-.3 4.7 4.4 4.3 5-1.7 3.1-4.4 5.6-7.9 9.6zM50.3 246.3c2.3-1.3 4.6-3.4 7-3.7 3.9-.6 7 1.9 6.1 6.1-.6 2.8-3.6 5-5.6 7.5-2.6-2.3-5.2-4.6-7.8-6.8.1-1.1.2-2.1.3-3.1zm777.4 178.9c-4.4 3.3-7 6.5-9.8 6.8-2 .2-4.3-3.8-6.4-5.9 2.4-2.3 4.5-5.8 7.3-6.6 1.8-.6 4.6 2.8 8.9 5.7zM651.8 177.5c-4.3 2.8-6.7 5.6-8.8 5.4-2.5-.3-4.7-3.1-7-4.9 2.4-2.7 4.4-6.1 7.3-7.5 1.2-.6 4.4 3.5 8.5 7zM103.9 460.7c-4.8-1.8-9.6-3.5-14.2-5.7-.8-.4-1.3-3.3-.7-4.3.8-1.3 2.8-2.5 4.2-2.4 5.9.6 9.6 4.3 11.9 9.6-.4.9-.8 1.8-1.2 2.8zm280 237.8c-3.3 6.1-6.6 12.3-10.1 18.4-.3.5-2.5.7-2.9.2-.7-.9-1.1-2.4-.9-3.6 1.4-7.6 4.7-13.6 13.9-15zm514.7-175.6c-1.7-2.2-4.9-4.7-4.6-6.5.4-2.3 3.6-5.5 5.8-5.6 2.1-.1 5.8 2.7 6.4 5 1 4.2-2.1 6.1-7.6 7.1zM765.3 254.4c-2.4-3.1-4.8-4.7-4.6-6.1.4-4.4 2.2-8.8 7.3-8.1 1.7.2 4.8 4.4 4.4 5.5-1.3 2.9-4 5.1-7.1 8.7zm-444.5-30.2c2.8 3.7 5.4 6 6.4 8.9.6 1.8-.5 5.8-1.9 6.6-2 1.1-5.4.7-7.5-.4-1-.5-.6-4.4-.2-6.7.5-2.4 1.7-4.6 3.2-8.4zm12.7 464.5c-4.8 3.6-7.6 6.4-10.9 7.9-1 .5-4.9-2.3-5-3.7-.4-5.2 3.5-7.3 7.7-7.7 1.8-.2 3.9 1.6 8.2 3.5zm321.3 106.2c1.2.8 2.3 1.6 3.5 2.5.8 5.6-1.3 9.3-6.9 8.2-1.9-.3-4.2-4.6-4.3-7.1 0-5.7 4.6-3.6 7.7-3.6zm65-87.2c9.4-2.4 10.4-1.7 16.8 10-8.6 1.7-12.5-4.1-16.8-10zM68.1 513.3c-2.4-2.7-5.2-4.5-5.2-6.2.1-1.8 3-5.2 4.4-5 2.8.3 5.4 2.6 8.1 4.1-2.1 2-4.2 4-7.3 7.1zm37.2-42.1c3.1 3 5.1 4.9 7.1 6.8-2.1 2.1-4.3 4.2-6.4 6.3-1.7-2.1-4-4.1-4.7-6.5-.4-1.4 2.1-3.6 4-6.6zm333.8 261.9c-3.6 2.4-6 5.2-8.1 5-1.9-.2-3.4-3.7-5.2-5.8 2.1-1.7 4-4.4 6.2-4.6 1.8-.1 3.9 2.8 7.1 5.4zm-27.2 118.7c2.5 3.1 5.5 5.3 5.2 6.7-.5 2.5-3.1 4.5-4.8 6.7-2-2.2-4.6-4.2-5.8-6.8-.4-.9 2.8-3.5 5.4-6.6zm-59.3-48.5c-1.8-4.6-3.9-7.2-3.4-9.2.6-2.1 3.5-3.6 5.4-5.4 1.3 1.7 3.9 3.7 3.6 5-.7 2.8-2.8 5.2-5.6 9.6zm-55.4-600.2c-2.4 2.6-3.6 4-4.9 5.4-2.3-3.2-4.8-6.3-6.8-9.7-.2-.3 2.4-3.1 2.5-3 2.9 2 5.6 4.4 9.2 7.3zm557.4 69.8c.5-3.1.7-6.4 1.6-9.4.1-.4 3.8-.7 4.5.1 1.6 1.9 3.8 5.2 3.1 6.8-.8 2-4.2 2.8-6.5 4.1-.9-.6-1.8-1.1-2.7-1.6zm-127.9-3.7c2.8-2.2 5-4.8 5.9-4.4 2.6 1.1 4.7 3.5 7 5.4-1.7 1.9-3.9 5.5-4.9 5.2-2.6-.8-4.7-3.4-8-6.2zm-30.3-17c-2.7-3.8-4.7-6.3-6.1-9.2-.1-.3 3.8-3.8 4.5-3.3 2.4 1.4 4.8 3.6 5.8 6.1.5 1-2.2 3.6-4.2 6.4zm-8.3-58.4c-2.4-3-5-5.2-4.7-6.3.7-2.1 3.1-5.1 4.7-5.1 1.9 0 3.8 2.9 5.7 4.5-1.6 1.9-3.1 3.8-5.7 6.9zm108 125.8c-3.5 2.6-5.7 5.4-7.4 5.1-1.9-.4-4.3-3.3-4.6-5.4-.2-1.5 2.8-4.8 4.4-4.8 2-.1 4 2.5 7.6 5.1zM101 438.9c-4.3-1.4-8.5-2.8-14.2-4.7 2.1-2.3 4.4-5.6 5-5.3 3.8 1.9 7.2 4.6 10.7 7l-1.5 3zm748.7 15.6c-3.6 2.2-5.6 4.2-7.7 4.5-1.2.2-4.2-3.2-3.9-3.7 1-2.3 2.7-4.9 4.8-5.7 1.1-.5 3.5 2.4 6.8 4.9zM626.3 176.4v-12.5c.6-.3 1.2-.7 1.8-1 1.8 2.4 5.1 4.9 5 7.3-.1 2.5-3.4 4.8-5.3 7.3-.6-.4-1-.8-1.5-1.1zm-404.2 26.1c1.3 3.3 3 5.5 2.5 7-.6 1.9-3 4.6-4.4 4.5-1.8-.1-3.4-2.8-5.1-4.3 2-2 3.9-4 7-7.2zm673.1 409.4c2 2.3 4.3 4.5 6 7 .7 1.1.1 3.1.1 4.8-1.7-.1-4.3.4-4.8-.5-1.8-3-2.9-6.4-4.2-9.7.9-.5 1.9-1.1 2.9-1.6zm-780.6-155c-2.9-1.1-6.2-1.7-8.5-3.6-1.1-.9-.4-4.3-.5-6.6.7-.3 1.4-.7 2.1-1 2.8 2.8 5.6 5.5 8.4 8.3-.5 1-1 1.9-1.5 2.9zm696.5-249.4c-1.8 2.3-3 4-4.3 5.6-1.3-2.7-3.1-5.2-3.7-8-.3-1.3 1.6-3.2 2.5-4.8 1.7 2.2 3.3 4.4 5.5 7.2zm-450.6-43.6c3.2 3.5 6.5 7 9.7 10.5-.6.6-1.2 1.2-1.8 1.9-6.3-.2-8.2-5.2-9.9-10.4.7-.6 1.4-1.3 2-2zm112 753.7c-1.9-2.9-3.8-5.7-5.7-8.6l1.2-1.8c3 .8 6.4 1.1 8.8 2.8.7.5-1 5-1.7 7.6h-2.6zm415-272.8c-4.5 6.1-6.1 6-11.7-1.3 4.6-3.9 8.4-2.7 11.9 1.6l-.2-.3zM747.3 713c2.2 3.8 4.2 5.7 4.2 7.6 0 1.6-2.3 3.2-3.6 4.8-1.2-1.9-3-3.7-3.5-5.7-.4-1.4 1.2-3.2 2.9-6.7zM55 408.8c5.3-4.5 8.2-3.4 9.7.8.4 1.1-1.1 2.8-1.7 4.2-2.7-1.7-5.3-3.4-8-5zm145.1 293.6c-5.9 1.5-10.1 2.6-15.3 3.9 4.4-8.5 6.3-9.1 15.3-3.9zm519 26.9c-2-2.8-3.9-5.6-5.9-8.5 1.2-.8 2.7-2.5 3.6-2.2 4.6 1.5 4.5 5.4 4.7 9-.8.6-1.6 1.2-2.4 1.7zM59.2 584.5c1.8 2.9 3.7 4.9 3.4 5.8-.8 1.9-2.8 3.3-4.4 5-1.2-1.3-3.7-2.9-3.5-3.8.5-2.1 2.3-3.8 4.5-7zM759.4 184c1.8 2.8 3.9 5.3 3.5 5.7-1.4 1.8-3.5 2.9-5.4 4.3-.8-1.3-2.6-2.9-2.3-3.9.5-1.9 2.2-3.4 4.2-6.1zm-198.1 17.2c-2.2-3.6-4.1-5.4-3.9-6.9.2-1.7 2.3-3.2 3.7-4.8 1.1 1.4 3.1 2.8 3.2 4.3.1 1.7-1.4 3.6-3 7.4zM887.7 645c-1.8-8.7 4.7-5 8.2-5.9l-.2-.2c.5 1.7.9 3.4 1.6 5.9h-9.7c-.1 0 .1.2.1.2z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape19($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M34.2 504.2c0-45.7 12.6-59.9 60.8-64.1 45.6-4 91.4-6.6 134.8-23.2 6.8-2.6 14.7-3.9 20.3-8.1 6.1-4.6 14.8-12.8 13.9-17.9-1.1-6.1-10.6-13.4-17.7-15-16-3.6-33-2.6-48.9-6.3-9.1-2.1-19.6-8-24.7-15.4-10.7-15.9.2-33.1 19.3-31.5 8.7.7 17.3 5.1 25.5 8.7 15.6 7 30.2 16.7 46.4 21.1 8.9 2.4 22.5-1.1 29.4-7.2 4.9-4.3 5.1-18.4 2.3-26.3-8.9-25.4-25.3-46.4-48.8-59.8-51.5-29.2-67-74.6-61.8-130.2 2-20.8 16.5-38.9 31.6-40.3 15.7-1.4 33.3 14.8 37.5 36.6 5.7 29.3 9.8 59 14.9 88.4 4.3 25.2 17.5 45.7 37.3 61 6.2 4.8 18.6 8.6 24 5.5 5.3-3 9-16.2 7.1-23.3-7.1-27.7-5.8-54.1 3.5-80.9 7-20.1 3.4-39.8-7.2-58.2-5.2-9-10.7-17.8-15-27.2-7.9-17.3 4.7-38.1 23.6-37.6 4.2.1 11.4 8.5 11.8 13.6 1.8 21.2.7 42.7 2.4 64 .9 11.8 4.9 23.5 8.2 35.1 6.8 23.2 13.5 46.5 21.4 69.3 2.7 7.7 8.1 19.3 13.6 20.1 9.1 1.3 20.5-2.7 28.7-8 7.2-4.6 10.9-14.4 16.9-21.3 16.1-18.6 32.1-19.6 53.4-7.3 8.5 4.9 21 8.2 30 5.9 22.1-5.6 30.3-22.8 20.6-43.6-13.9-29.7-9.6-56.9 5.5-83.8 12.1-21.5 37.6-29.2 62-19.2 19.7 8.1 28.2 27.8 20.8 52.3-7.8 25.7-17.8 50.6-25.6 76.3-5.4 17.7-1.9 33.9 13.9 45.8 13.9 10.5 28.1 11.8 41.6-.2 11.4-10.1 21.6-21.6 33.3-31.4 20.1-16.7 37.1-10.7 42.9 14.2 5.9 25.5-7.9 49.9-36.1 62.4-11.1 5-24.2 6.9-33.7 13.8-8.3 6-18.6 18-17.4 25.7 1.3 8.3 13.7 18.1 23.3 21.3 21.1 7.1 40.6-.7 58.2-13.7 29.9-22.2 59.5-44.8 90.1-65.9 30.3-20.8 64.8-28.6 101.1-24.6 36 4 50.9 32.7 35.7 65.4-4.9 10.6-11.8 16.5-24.2 14.7-12.7-1.9-25.4-3.4-38.2-4.6-57-5.3-106.9 14.9-153.8 44.1-23 14.3-23 33.4-2.3 50.4 5.2 4.3 10.9 7.9 15.8 12.5 13.5 12.9 13.5 32.3.3 45.4-3 3-6.4 5.6-9.7 8.4-28.6 23.6-26.5 45.6 8.3 59.7 15 6.1 34.2 9.2 49.5 5.4 61.4-14.9 107.9 36.4 113.8 84 2.8 22.8 1.8 46.3.3 69.3-1.1 16.7-9.8 30.6-27.1 35.6-16.3 4.7-28-4.7-38.3-15.9-20.2-22-29.1-49.3-34.8-77.6-8.1-39.9-33.2-62.2-70.8-73.4-15.8-4.7-29.6-4.9-41.4 9.2-12 14.3-15.1 30.1-6.2 45.8 10.7 19.1 25.2 36.1 35.8 55.2 10 17.9 19.5 36.7 24.7 56.4 5.8 22.1-5 34.6-27.4 38.8-20 3.7-34.7-7-37.5-27.3-2.8-20.6-4.3-41.4-8.6-61.6-6.4-30.2-28.8-47.8-55.1-46.1-18.5 1.2-26.4 9.1-26.9 27.6-.2 9.1 2.6 18.8.4 27.3-2.2 8.2-7.5 19.1-14.2 21.6-6.7 2.5-20.5-1.1-24.7-6.8-10.3-14-17.1-30.7-24.8-46.5-3.2-6.5-3.9-14.7-8.2-20.2-4.4-5.6-12.1-12.1-18.1-12-6.1.2-16.4 7.5-17.1 12.7-2.5 17.7-6.1 37.3-1 53.6 13.2 41.7 31.4 81.8 46.6 123 5.6 15.2 10 31.2 12.1 47.2 1.7 13.3-5.9 25.8-19.6 26.3-7.9.3-20.9-7.8-23.2-14.9-8.3-25.1-15.7-51.2-18.3-77.4-5.1-51.4-13.3-101.7-34.8-149-5.1-11.3-7.5-27.8-26.1-25.6-13.6 1.6-25.2 17.1-24.8 36.2.2 11.7 3 24.3 8.4 34.6 10.4 20.1 16.6 40.2 15.1 63-.9 14.1-7.3 20.8-20.6 23.3-40.8 7.8-58.7-9.7-50.1-50.4 3.4-16.1 11-31.6 12.3-47.7 1.3-16.3.2-34.3-5.7-49.2-6.5-16.6-19.6-16.3-27.9-.3-10.3 19.9-20.7 40.7-25.5 62.4-12.8 57.7-22.7 116-33.4 174.2-4.8 26-12 50.1-38.4 62.7-28.4 13.4-47.9 3.2-45.9-27.5 1.3-19.7 8.2-40.9 18.4-57.9 43.4-71.6 76.6-147.2 95-228.9 1.7-7.3-2-15.9-3.2-23.9-6.5 5.3-13 10.5-19.3 16-6.9 5.9-12.8 15.6-20.6 17.5-18.8 4.6-32.1-10.1-30.7-29.6 1-13.7 3.6-28.7-.6-40.9-8-23-30-24.7-45.4-5.7-18.5 22.7-35.5 46.7-55.8 67.6-18.4 18.9-38.8 13.4-49.6-10.5-5.6-12.4-5.2-24.5 6.7-32.7 13.6-9.2 28-17.1 42.4-24.9 12.3-6.7 26.7-10.5 37.3-19.1 10.3-8.4 19.9-20.3 24.3-32.6 2.9-8.1-3.9-19.7-6.4-29.7-9.1 3.3-20.6 4.2-26.8 10.4-14.9 15.1-27.5 32.6-40.7 49.3-14.4 18.1-32.4 26.8-55.9 24.8-26-2.2-38.4-14.5-38.4-40.6-.1-6.7-.1-13.4-.1-20.2z"/>',
            $gradID);
        }
        $mask = '<path d="M39.9 484.4c0-45.7 12.6-59.9 60.8-64.1 45.6-4 91.4-6.6 134.8-23.2 6.8-2.6 14.7-3.9 20.3-8.1 6.1-4.6 14.8-12.8 13.9-17.9-1.1-6.1-10.6-13.4-17.7-15-16-3.6-33-2.6-48.9-6.3-9.1-2.1-19.6-8-24.7-15.4-10.7-15.9.2-33.1 19.3-31.5 8.7.7 17.3 5.1 25.5 8.7 15.6 7 30.2 16.7 46.4 21.1 8.9 2.4 22.5-1.1 29.4-7.2 4.9-4.3 5.1-18.4 2.3-26.3-8.9-25.4-25.3-46.4-48.8-59.8-51.5-29.2-67-74.6-61.8-130.2 2-20.8 16.5-38.9 31.6-40.3 15.7-1.4 33.3 14.8 37.5 36.6 5.7 29.3 9.8 59 14.9 88.4 4.3 25.2 17.5 45.7 37.3 61 6.2 4.8 18.6 8.6 24 5.5 5.3-3 9-16.2 7.1-23.3-7.1-27.7-5.8-54.1 3.5-80.9 7-20.1 3.4-39.8-7.2-58.2-5.2-9-10.7-17.8-15-27.2-7.9-17.3 4.7-38.1 23.6-37.6 4.2.1 11.4 8.5 11.8 13.6 1.8 21.2.7 42.7 2.4 64 .9 11.8 4.9 23.5 8.2 35.1 6.8 23.2 13.5 46.5 21.4 69.3 2.7 7.7 8.1 19.3 13.6 20.1 9.1 1.3 20.5-2.7 28.7-8 7.2-4.6 10.9-14.4 16.9-21.3 16.1-18.6 32.1-19.6 53.4-7.3 8.5 4.9 21 8.2 30 5.9 22.1-5.6 30.3-22.8 20.6-43.6-13.9-29.7-9.6-56.9 5.5-83.8 12.1-21.5 37.6-29.2 62-19.2 19.7 8.1 28.2 27.8 20.8 52.3-7.8 25.7-17.8 50.6-25.6 76.3-5.4 17.7-1.9 33.9 13.9 45.8 13.9 10.5 28.1 11.8 41.6-.2 11.4-10.1 21.6-21.6 33.3-31.4 20.1-16.7 37.1-10.7 42.9 14.2 5.9 25.5-7.9 49.9-36.1 62.4-11.1 5-24.2 6.9-33.7 13.8-8.3 6-18.6 18-17.4 25.7 1.3 8.3 13.7 18.1 23.3 21.3 21.1 7.1 40.6-.7 58.2-13.7 29.9-22.2 59.5-44.8 90.1-65.9 30.3-20.8 64.8-28.6 101.1-24.6 36 4 50.9 32.7 35.7 65.4-4.9 10.6-11.8 16.5-24.2 14.7-12.7-1.9-25.4-3.4-38.2-4.6-57-5.3-106.9 14.9-153.8 44.1-23 14.3-23 33.4-2.3 50.4 5.2 4.3 10.9 7.9 15.8 12.5 13.5 12.9 13.5 32.3.3 45.4-3 3-6.4 5.6-9.7 8.4-28.6 23.6-26.5 45.6 8.3 59.7 15 6.1 34.2 9.2 49.5 5.4 61.4-14.9 107.9 36.4 113.8 84 2.8 22.8 1.8 46.3.3 69.3-1.1 16.7-9.8 30.6-27.1 35.6-16.3 4.7-28-4.7-38.3-15.9-20.2-22-29.1-49.3-34.8-77.6-8.1-39.9-33.2-62.2-70.8-73.4-15.8-4.7-29.6-4.9-41.4 9.2-12 14.3-15.1 30.1-6.2 45.8 10.7 19.1 25.2 36.1 35.8 55.2 10 17.9 19.5 36.7 24.7 56.4 5.8 22.1-5 34.6-27.4 38.8-20 3.7-34.7-7-37.5-27.3-2.8-20.6-4.3-41.4-8.6-61.6-6.4-30.2-28.8-47.8-55.1-46.1-18.5 1.2-26.4 9.1-26.9 27.6-.2 9.1 2.6 18.8.4 27.3-2.2 8.2-7.5 19.1-14.2 21.6-6.7 2.5-20.5-1.1-24.7-6.8-10.3-14-17.1-30.7-24.8-46.5-3.2-6.5-3.9-14.7-8.2-20.2-4.4-5.6-12.1-12.1-18.1-12-6.1.2-16.4 7.5-17.1 12.7-2.5 17.7-6.1 37.3-1 53.6 13.2 41.7 31.4 81.8 46.6 123 5.6 15.2 10 31.2 12.1 47.2 1.7 13.3-5.9 25.8-19.6 26.3-7.9.3-20.9-7.8-23.2-14.9-8.3-25.1-15.7-51.2-18.3-77.4-5.1-51.4-13.3-101.7-34.8-149-5.1-11.3-7.5-27.8-26.1-25.6-13.6 1.6-25.2 17.1-24.8 36.2.2 11.7 3 24.3 8.4 34.6 10.4 20.1 16.6 40.2 15.1 63-.9 14.1-7.3 20.8-20.6 23.3-40.8 7.8-58.7-9.7-50.1-50.4 3.4-16.1 11-31.6 12.3-47.7 1.3-16.3.2-34.3-5.7-49.2-6.5-16.6-19.6-16.3-27.9-.3-10.3 19.9-20.7 40.7-25.5 62.4-12.8 57.7-22.7 116-33.4 174.2-4.8 26-12 50.1-38.4 62.7-28.4 13.4-47.9 3.2-45.9-27.5 1.3-19.7 8.2-40.9 18.4-57.9 43.4-71.6 76.6-147.2 95-228.9 1.7-7.3-2-15.9-3.2-23.9-6.5 5.3-13 10.5-19.3 16-6.9 5.9-12.8 15.6-20.6 17.5-18.8 4.6-32.1-10.1-30.7-29.6 1-13.7 3.6-28.7-.6-40.9-8-23-30-24.7-45.4-5.7-18.5 22.7-35.5 46.7-55.8 67.6-18.4 18.9-38.8 13.4-49.6-10.5-5.6-12.4-5.2-24.5 6.7-32.7 13.6-9.2 28-17.1 42.4-24.9 12.3-6.7 26.7-10.5 37.3-19.1 10.3-8.4 19.9-20.3 24.3-32.6 2.9-8.1-3.9-19.7-6.4-29.7-9.1 3.3-20.6 4.2-26.8 10.4-14.9 15.1-27.5 32.6-40.7 49.3-14.3 18.1-32.3 26.7-55.8 24.7-26-2.2-38.4-14.5-38.4-40.6-.2-6.7-.2-13.4-.2-20.1z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape20($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M50.4 110.9c-.5 1.6-1.5 2.7-2.2 4-1.3 2.2-.7 3.6 1.8 3.7 2.5.1 5.2-.2 7.5-1.1 3.1-1.2 5.8-3.2 8.7-4.8 1.6-.8 3.3-1.4 4.9-2.2.2.3.5.6.7.9-3.8 3.7-7.7 7.3-11.5 11 3.4 4.1 8.1 5.1 12.8 2.1 2.7-1.8 5.3-4 7.4-6.5 9.6-11.6 20.4-22.3 31.6-32.5 12.6-11.6 25.9-22.5 41-31.2.8-.4 1.3-1.2 1.9-1.9 2.2-2.6 4.1-5.5 6.7-7.7 3.9-3.3 8.4-6 12.5-9.2 2.1-1.6 3.8-3.7 5.7-5.5-.2-.2-.3-.4-.5-.6-1 .3-2.2.3-3.1.8-3.8 2.1-7.5 4.3-11.2 6.5l-8.4 5.1-.5-.5c.3-1.8.6-3.6 1.1-6.1-2.3 1.4-4.2 2.6-6.1 3.7-1.9 1.2-3.9 2.2-7 1.6 1.3-1.7 2.3-3.1 3.5-4.3 2-2 4.3-3.8 6.3-5.8 2.4-2.5 2.9-5.4 1.5-8.5-6.2-.4-10.3.9-15.9 5-3.9 2.9-7.7 5.9-11.7 8.6-4 2.6-4.1 2.4-7.8-.6-1.3-1.1-2.7-2.1-4.5-.5-7.2 6.3-15.4 11.1-24 15.3-.7.4-1.3 1.3-1.6 2.1-1 2.6-1.3 5.8-3 7.9-3 3.6-6.5 7.1-10.4 9.8-5.1 3.6-10.8 6.5-16.3 9.5-9.7 5.3-19.8 10.2-28.4 17.1-2.6 2-4.9 4.3-7.4 6.4v.5c3.1 1.1 5.4-.5 7.9-2 .9-.5 2.2-.5 3.3-.7.2 1.2.7 2.4.5 3.5-.1.9-.8 1.8-1.4 2.6-.8 1.1-1.9 2-2.4 3.2-.6 1.6-1.6 4-.9 5 .9 1.2 3.5 1.9 5.2 1.7 2.5-.2 4.9-1.3 7.3-2.3 2.2-.8 4.2-2 6.4-3.1zM607.8 149c-.6-3.7-1.8-6.6-6.6-6.3-1.2.1-2.5-.5-3.8-.7-1.8-.2-3.7-.3-4.8-.4-1 2.6-1.8 4.5-2.5 6.5 5.6.8 6.2 1.2 8 5.5 4.1-1.5 7.5 0 10.8 2.3-.2.4-.3.7-.4.9-.4.8-.7 1.7-1.1 2.5.9.3 1.8.7 2.8.7 14.5.5 28.6 3 42.3 7.7 3 1 3.1 1 2.9-2.2 2.3.4 4.6.7 6.8 1.1 2.3.4 4.6 1 7 1.5.2-2.9-3.4-1.7-4.3-3.9 1.3.1 2.4.3 3.5.1.7-.1 1.3-.7 2-1.1-.5-.6-.8-1.5-1.4-1.7-2.3-.8-4.7-1.2-6.9-1.9-1.1-.4-1.9-1.2-3.3-2.1 4 0 7.2.1 10.4 0s6.3-.5 9.6-.7c-3.3-6.6-20.8-9.2-29.4-6 0 .3-.1.6-.1.9-.1 4-.7 4.3-4.8 3.5-8.4-1.6-16.7-3.3-25.1-4.5-3.6-.5-7.3-.1-10.9-.1-.5-.8-.6-1.2-.7-1.6zm35.3 27.1c21 4.5 42.1 9.1 63.4 13.7-8.9-4.6-17.4-9.4-26.3-13.4-5.5-2.4-11.5-4-17.4-5.1-7.1-1.2-13.8.5-19.7 4.8z"/>
                <path class="st1" d="M898 527.5c-.4-1.4-.1-2.9-.1-4.6 1 .6 1.5 1 2 1.3-3.7-5.7-6.2-11.6-6.3-18.3 0-1.4-.3-2.8-.6-4.1-.7-2.5-1.8-3-4.4-2.4-1.4.3-2.8.6-4.4.9-7.1-25.4-16.9-49.7-29.2-72.7.4.5.9 1 1.3 1.4.4-.7 1.2-1.7 1-2.1-1.1-2.2-2.4-4.3-3.7-6.4-.4 1.3-.7 2.2-.8 2.9-2.8-5-5.6-10-8.6-14.8.7 1 1.4 1.9 2.1 2.9 1.4 1.9 2.9 3.7 4.4 5.5.2-.1.4-.3.6-.4-1.9-7.2-5.1-11.2-9-11.1-14.3-22.8-31.1-44-50.1-63.3.9 0 1.9-.1 2.9-.4.8-.2 2-1 2-1.3-.1-.8-.7-1.8-1.5-2.4-1-.7-2.3-1.1-3.5-1.7.5-1.2.9-2.3 1.3-3.5 4.9 3.2 9.8 6.2 14.5 9.3 3.8 2.6 7.6 5.2 11 8.1 2.5 2.2 4.4 4.9 6.6 7.5-.2.1-.4.3-.6.4-3-1.3-4-5.9-8.4-4.8-.2.3-.4.5-.6.8 2.5 2.3 5.1 4.6 7.6 6.9 3.3 2.9 6.6 5.8 9.8 8.8.6.5 1.3 1.7 1.1 2-2 3.3.5 5.2 2.1 7.4 1.3 1.9 2.9 3.8 3.5 5.9.5 1.9 1.3 2.8 3.2 3.2 3.4.7 7 1.2 7.5 5.5.1.5.6 1 1.1 1.4 1.2 1 2.4 1.9 4.1.5-1.6-3.8-3.2-7.7-4.8-11.4-3.6-8.4-8.2-16-18.2-19 1.9-3.2.4-5.2-2-7.2-2.1-1.7-4.6-3.4-5.7-5.6-1.5-3.1-3.9-5.3-6.3-7.6l-8.4-8.4c-8.8-8.7-17.7-17.3-28.3-24.1-5.4-3.4-11-6.3-17.4-7.9-.8 3.5-3.2 4.8-6.1 3-2.7-1.7-5.1-3.7-7.9-5.9-1.3.8-2.7 1-4.2.8-8.5-6.3-17.2-12.3-26.2-17.9 7.6 2 13.9 7.7 22.6 7.3-6-3.2-11.8-6.2-17.8-9.4-.4 2.2-1.7 1.7-3.2 1.1-.8-.3-1.7-.2-2.6-.3 0 .2 0 .5-.1.7-3.6-2.2-7.2-4.4-10.8-6.5-.9-.6-1.9-1.2-2.9-1.7-11.2-6.3-22.7-12.1-34.6-17.4.8.1 1.5.1 2.3.2-1.2-.8-2.1-1.4-3.1-2.1.5-.3.7-.4.8-.4.6 0 1.2 0 1.8.2 6.2 1.8 12.3 3.6 18.5 5.4.6.2 1.7.4 1.9.2.9-1.5 1.7-.8 2.7-.1.9.6 1.9 1.2 3 1.9-.1.2-.4.7-.8 1.5 8.4 3.8 16.8 7.5 25.6 11.5.2-1.4.3-1.9.4-2.7 10.5 5.2 20.7 10.4 31.7 15.9-.6-1.2-1-2-1.2-2.8-.2-.9-.2-1.9-.3-2.9.9.1 2 0 2.7.4 1.5.8 2.9 1.8 4.3 2.7 1.7.9 3.4 1.7 5.1 2.6-.4-1.4-1-2.5-1.9-3.3-4.3-3.8-8.6-7.6-12.9-11.3-6.3-5.4-11.9-11.2-10.2-20.1-17-7.4-28.5-13.8-32.6-18.2 2.7 1.1 4.9 2.2 7.2 3 2.3.8 4.8 1.3 7.2 2v-.4c-1.3-1.1-2.6-2.1-3.8-3.2.4-.5.7-.9 1.1-1.4 13.5 6 27 12 40.5 18.1.3-.3.6-.7.8-1-3.9-4.8-7.9-9.6-11.9-14.5.2-.2.9-.6 1.6-1.1-6.6-5.4-13.8-11.3-17.5-11.6-1.6 3.1 2.3 4.1 3 6.8-.9-.4-1.5-.7-2.1-1-7.9-3.8-15.5-8.1-23.6-11.2-22.6-8.8-45.4-17.2-68.1-25.7-2.6-1-5.7-1.3-5.5-4.9-3.1.5-5.8.9-8.3 1.2-2.5-.9-4.9-1.8-7.3-2.7-.1-.2-.1-.4-.2-.6 4.2-1.3 8.4-2.6 12.5-3.9 3 3.3 6.3 3.9 9.6 1.4-4.7-1.2-8.9-2.3-12.8-3.3.8-.7 2.3-1.5 2.2-2.2-.1-.8-1.3-2-2.3-2.3-3.5-1.1-7-2.4-10.6-2.7-4.7-.4-9.5.2-14.2.3-5.4 0-10.5-.8-14.5-4.8-.6-.6-1.7-.8-2.6-.9-3.1-.3-6.2-.5-9.3-.5-3.4 0-6.7.3-10.1.3-3.2 0-6.3-.5-8.4-3.1-1-1.3-2.1-1.4-3.5-1.3-2 .1-4.1 0-6.5 0 2.5-2.8 4.5-3.2 13-2.6.5-3.1 1.2-3.6 4.5-3.6.9 0 1.9.2 2.8.3l10.8.9c.2 0 .4-.2.5-.4-.3-.6-.7-1.2-1.1-2 6.3 1.4 7.5 1.4 9.8-.8-5.5-.8-10.6-1.5-15.6-2.2.1-1.1.2-2.2.4-4-4.1 2.6-7.8 2-11.5 1.4-2.9-.5-5.4-.5-6.1 2.7-3.7-.7-7.2-1.3-10.6-1.9-3.5-.6-6.9-1.4-9.7-3.8.7-1.2 1.4-2.3 2.4-4 .9 3.4 2.9 3.9 5.4 3.2 3.6-.9 7.3-1.9 11.2-2.9-1-.4-1.9-.9-2.7-1.1-2.7-.4-5.5-.8-8.2-1-3.7-.3-7-1.3-9.2-4.7 7.3.6 7.4.6 8.2-2.2-8-2.9-18-1-20.2 3.6 1.2.6 2.5 1.2 3.7 1.7l-.3.9c-1.7 0-3.4.2-5.1-.1-.6-.1-1.5-1-1.6-1.7-.5-2.9-.7-3.1-4.5-2.2.8 1.1 1.5 2 2.3 3.1-3.5 1.4-7 2.8-10.2 4.1 1.9 1 3.6 1.7 5.1 2.8 1.6 1.2 3.2 1.8 5.2 1.2.7-4.2.8-4.4 2.8-4.2 2.3.2 3.6 2.1 3.5 5.1-.5 0-1.1-.1-1.5.2-.9.6-1.6 1.4-2.5 2.1.7.6 1.4 1.6 2.2 1.8 2.4.5 4.9 1 7.4 1.1 6 .3 12.1.2 18.1.6 2.7.2 5.3 1.3 7.9 1.9-.1.4-.2.7-.2 1.1-5-.2-10.1-.4-15.3-.7-2.4 4.5-7.1 1.8-10.9 2.6 0-1.5 1.1-3.3-1.6-3.1-6.9.5-13.8 1-20.7 1.4-1.6.1-3.6.4-4.9-.3-1.3-.6-1.9-2.4-2.8-3.7-7.1 4.3-15.4 5-19.5 1.7.9-.5 2.2-.9 2.6-1.7.3-.6-.6-1.7-1.1-2.8 8.2.7 16.1.8 24.3-1.1-1.8-1.8-3.8-2-5.9-1.6-2.5.5-5 1.2-7.6 1.5-1.6.2-3.3-.2-4.9-.4v-.9c1.4-.3 2.8-.4 4.1-.8.8-.3 1.4-1 2-1.5-.7-.5-1.4-1.3-2.2-1.4-1.8-.2-3.6-.1-5.3-.1-.9 3.6-.9 3.6-4.8 3.3-1-.1-2.1 0-3.4 0 .5 1.6.9 2.7 1.3 3.7-2.3.7-4.3 1.4-6.4 2-3.2 1-4.4.6-5.1-1.5 6.9-.3 9.7-3.1 8.8-6.6-2.2-.2-4.5-.4-6.8-.6.5-.7 1-1.4 1.5-2.2-6.8-2.6-15.3-1.6-17.7 2.4 1.8.1 3.4.2 4.9.2 1.8 0 3.6-.3 5.4-.3 1.6.1 2.7.8 2.6 2.9h-8.2v5c.2.1.4.2.7.3.8-.9 1.4-1.9 2.3-2.5.7-.5 1.8-.9 2.7-.8.4.1 1.1 1.7.8 2.1-.8 1.1-1.9 2.2-3.2 2.7-1.8.7-3.8.7-6 1.1-.2-.9-.4-1.8-.5-2.5-2.2.1-4.3.6-6.3.2-1.7-.3-2.7-.1-3.9.9-6 5.1-11.9 10.2-18 15.3-.7.6-1.7 1.2-2.6 1.3-6.2 1.1-12.5 1.9-18.6 3.1-16.5 3.2-32.5 7.8-46.6 17-.4.3-1 .7-1.3.6-4.3-.8-7.4 1.5-10.7 3.5-1.6 1-3.5 1.4-5.8-.5 4.9-2.2 9.5-4.2 14.2-6.3-.8-1.7.4-2.7 2-3.4 1.4-.5 2.8-.9 4.1-1.6 1.2-.6 2.2-1.5 3.3-2.3-.1-.2-.3-.4-.4-.6-10 1.4-19.6 4.2-28.9 7.5-.4-1.5-.6-2.9-1.1-4.1-.6-1.5 0-2.2 1.5-2.7 5.1-1.8 10.2-3.7 15.2-5.5 3.2-1.2 6.4-2.3 9-3.3 1.5 1.5 2.6 2.9 4 3.9 1.5 1.1 3.2 2 1.5 4.6 2.3-1.6 2.5-2 2.6-4.9.1-3.6.6-4 4.1-4.1 1-3-2.8-1-3.1-2.9 12.5-2.5 24.6-6.3 36.2-11.3-13.9 1.9-27.4 6.3-42.4 4 7-1.8 13.3-3.3 19.6-4.9 0-.2-.1-.4-.1-.6-3.6-.5-7.6 1.5-11.4-1 1.8-.6 3.2-1 4.8-1.5-1.7-2.7-5.9-1.1-6.8-4.3 3.7-.8 7.4-1.3 10.9-2.3 8.2-2.2 16.2-5.2 25-5 2.5.1 3.9-1.8 5-4-4.8-1-4.8-1-4.1-3.9 8.7.7 15.8-4.2 23.9-6.2-.7-.8-1.3-1.4-2.3-2.5 5-1.4 9.4-3.2 14-4 14.7-2.4 29.5-4.3 44.3-6.5 5.5-.8 10.9-2.1 16.3-3.2-6.7-2.8-6.7-2.8-6.1-6.1 1.9 0 3.9.1 5.9 0 1.9-.1 3.7-.2 5.6-.4v-.8c-15.6-5.3-32-6.9-48.2-9.8 3-2.8 7.2-.6 10.5-2.4-.6-.6-1-1-1.6-1.5 2.4-.5 4.5-1 6.2-1.3-3.2-1.2-6.7-2.4-10-3.9-4.2-1.9-8.3-4.2-12.5.2-.6-.9-1-1.4-1.3-2-1.9-4.1-2.1-4.2-6.5-2.4-2.6 1-5.1 1.7-8.2 1 1.3-2.4 0-3-2.1-3.3-1.6-.2-3.1-.8-4.6-1.2.1-.2.1-.5.2-.7l5.1-2.7c-.1-.3-.1-.6-.2-.9-3.5-.6-6.9-1.5-10.4-1.7-7.8-.5-15.5-.7-23.3-1.1-2.3-.1-4.7-.6-7.1-.9.9-1.9 1.6-3.5 2.4-5.2-2.4-.5-4.2-1.2-6-1.1-17.8 1.4-35.7 2.7-53.4 4.6-17.2 1.8-34.2 4.6-51.4 6.5-15.6 1.7-30.8 4.8-45.6 9.8-11.9 4-23.9 7.8-36.6 8.4-1.5.1-1.9.9-1.6 2.2.1.6.3 1.2.4 2-.9-.1-1.6.1-2-.2-2.1-1.2-4.1-.7-6.2.2-3.7 1.5-7.5 2.9-11.2 4.6-16.7 7.8-31.6 18.1-45.7 29.6-3.6 2.9-7.2 5.7-11.4 6-1 1.6-1.4 3.2-2.5 3.9-7.9 5.4-16.2 10.3-24 15.9-7.3 5.2-13.3 11.6-16.5 19.8-1.1 2.7-1.7 5.7-2.5 8.5.3.1.5.3.8.4 1.4-.8 2.6-1.9 4.1-2.3 1.3-.4 2.8-.1 4.5-.1 1.2-3.6 3.2-5.1 7-4.7-4.1 7.1-3.3 13.7 2.1 19.8 3.2 3.5 3.9 3.6 8.4 1.7 1.4-.6 2.9-1.3 4.6.7-2.8 2.7-5.5 5.4-8 7.9-.7 1.8-1.3 3.4-1.9 5 .2.1.4.2.5.3.6-.6 1.2-1.2 1.9-1.8 3.5-3.3 6.9-6.6 10.5-9.8 1.5-1.3 3.1-.9 3.7 1 .3.8.2 1.8.2 2.7-.2 2.2.1 4.1 2.5 4.8-2.1 3-3.9 5.9-6 8.6-1.9 2.5-4.2 4.7-6.3 7.1-.7.9-1.6 1.9-1.7 3-.6 6-2.9 11.2-7.2 15.4-3.6 3.6-7.6 6.7-11.3 10.1-4.4 4-8.9 8-13.1 12.2-2.7 2.8-2.4 3 .2 5.7-.5.9-1.3 1.7-1.6 2.7-1 3.3-1.9 6.6-2.6 9.9-.3 1.3.5 2.3 2.2 1.5 1.9-.8 2.3.1 2.3 1.6 0 2.9.4 5.8-.1 8.6-.6 4.3 1.7 6.4 5.4 7.8 1.5.6 3.1 1.2 4.7 1.5 3.8.8 7.7 1.3 11.5 2 4.3.8 8.5 1.8 11.6 2.5 1 4.2 1.5 7.4 2.5 10.4 1.7 5.4 1.5 6.4-3 9.5 3.3 1.8 5.2 1.4 7.8-2.1 1.4 1 3.4 1.7 2.4 3.9-3.5 7.6-7.5 15-14.1 20.7-1.8 1.6-3.9 2.9-5.9 4.4-.3-.2-.6-.5-.9-.7l5.1-9-.6-.3c-.4.3-.8.6-1.1.9-3.4 3.8-6.8 7.6-10.1 11.5-5.3 6.2-10.5 12.3-15.8 18.5-.4.5-.7 1.1-.9 1.7-1.7 4.8-3.2 9.7-5 14.5-5.1 13.8-10.6 27.5-11.3 42.5-.2 3.7-1.6 7-4.7 9.6-.5.4-.6 1.2-.8 1.9-.6 2.8-1 5.6-1.9 8.3-1.1 3.4-2.8 6.7-4 10.1-.8 2.4-1.2 4.9.1 7.5 1.4-1.2 2.6-2.6 4.2-3.4 2.2-1.2 3.3-2.4 1.6-4.7-.3-.4 0-1.2.1-2.3 1 .8 1.4 1.2 1.8 1.6.8-.4 1.5-.7 2.2-1 2.7 7.5 1.3 19.4-2.6 22.5-.5-.6-1-1.2-1.7-2-2.5 3.9-3.1 7.8-2.6 11.7 1.6-.4 3-.8 4.7-1.3.1 6.6-.8 12.8 3.6 18.4-3.1.2-4.3 1.6-3.4 4 .7 1.9 2.3 2.7 4.3 2.5.6-.1 1.7-1.3 1.6-1.6-1.5-3.1.4-5.3 1.8-7.7.5-.8 1.7-1.3 2.5-1.9-.7 4.1-1.5 7.7-1.9 11.4-.4 4.6-.4 9.2-.8 13.7-.1 1.5-.9 2.9-1.4 4.4-.1-.1-.2-.1-.4-.2-.6-3.3-1.1-6.7-1.7-10.2-1.8.4-3.3.9-4.8 1.1-4 .5-5.4 1.3-6.2 5.1-.6 3-.6 6.2-.8 9.3-.3 5.6.1 11.3-5.6 15 1.1.8 2 1.4 3.1 2.2-2.2.8-3.9 1.4-5.6 2 2.1 5.4 1.9 10.7 1.4 16.1-.1.6.3 1.3.4 2 .6-.4 1.2-.8 1.8-1.3.4-.3.8-.7 1.3-1 .3.5.9 1 .9 1.5-.1 1.7-.5 3.4-.7 5.1-.2 1.7-.4 3.3-.6 5.5 3-.4 5.4-.8 7.8-1.1 1.4 5.1-3.7 10.2.2 15.4.7-.9 1.1-1.7 1.8-2.3 2.1-1.9 4.1-4 6.4-5.7 1.8-1.3 3.8-1.1 5.8.6-5.1 2.7-6.3 7.1-6.4 11.9 0 .6.5 1.2.8 1.8.5-.5 1.2-1 1.6-1.6.3-.4.1-1 .3-1.4.5-.8 1.2-2.3 1.6-2.3 1.4.1 3.1.6 4.1 1.5.5.4 0 2.2-.5 3.2s-1.7 1.6-2.5 2.5c-1.4 1.5-.7 2.8 1.1 3.5 1.4.6 3.2 1.6 3.4 2.8.5 2.4.4 5 .1 7.4-.1.9-1.3 1.7-2 2.5-.4-.8-.8-1.6-1.3-2.3-.3-.4-.8-.7-1.1-1.1-.3.4-.8.7-1 1.1-.7 1.4-1.3 2.8-1.9 4.1-.6 1.3-1.2 2.6-1.9 4 4.2.4 7.9.7 11.6 1 2.4-4 3.3-4.5 5.6-3.8 1.5 3.2 2.6 5.9 4 8.4 1.9 3.5 1.8 4.7-.7 7.7-1.1 1.4-1.9 3.2-2.4 5-.5 1.6-.3 3.4-.4 4.7 1.9.2 4.1.4 6.2.6 1.7.2 4.4-.7 3.4 2.7 0 .1.3.4.4.6 2.8 3.3 4 7 3.6 10.6.8 1.3 1.5 2.1 1.8 3 1.5 5.5 2.4 11.1 4.3 16.4 1.3 3.7 2.2 7.2 1.7 11.1-.1.8.6 1.7.9 2.5 1.4-1.2 2.3-2.1 2.7-2.5-.2-1.8-.5-3.2-.6-4.6 0-1.5.2-2.9.4-4.4.7-4.6 1.6-9.1 2.3-13.7.3-1.7 0-3.5.1-5.2 0-.7.2-1.4.3-2.1h2.8c1.5 2.4 2.8 4.5 3.9 6.4 2 .4 3.8.7 5.7 1 .4-1.4.2-2.2-1.5-2-2.7.4-3.6-1.1-3.8-3.2-.2-1.7-.3-3.4-.4-5.3 1.4-.7 2.8-1.5 4.3-2.3l.6.6c-1 1.1-1.9 2.3-3 3.5 1.3.6 2.3 1.1 3.8 1.9-1.5.4-2.3.6-3.2.9 1.2 2.5 3.1 2.2 5.5 1.9l.9 3.6c-.2.7-.4 1.4-.8 1.9-1.1 1.6-6.3.9-8-.5-2 4.4-2 4.4.5 6.1.9-.3 1.8-.8 2.7-.8 1.7-.1 2.7-.5 3.4-2.2.4-.9 1.7-1.5 2.8-2.2.2.6.3 1.2.5 1.7-.1.3-.2.6-.4.9-.9 1.8-.4 6.4.9 6.6 2.1.4 1.8 1.6 2 2.8.6 3.6 1.9 7.2 1.2 10.9-.1.5.5 1.2.8 1.7.4.7.9 1.3 1.1 2 1.9 6.9 3.6 13.9 7 20.4.1.2 0 .6 0 .8-1.7-.4-3.2-.7-4.7-1.1-.1.2-.3.4-.4.7l2.1 3.5c2.1-1 4.1-2 6.2-3.1.3.8.7 1.6 1 2.4-1.1.6-2 1.1-2.9 1.6.1.3.2.5.3.8.9.2 1.8.4 2.7.5.6.1 1 .2 1.4.4.2.5.4.9.6 1.4-.1.3-.3.7-.6 1.2-.4.7-.5 1.5-.8 2.8 1.1-.6 1.8-.9 2.6-1.3.8 1.8 1.7 3.7 2.6 5.5 0 .2.1.4.1.6.5 2.2.4 4.4.6 6.6-.2-.2-.5-.4-.7-.6-1.1 1.2-2.3 2.3-3.4 3.5 1.1 1 1.6 1.4 2.3 2 .9-1.3 1.6-3.4 2.5-3.5 1.3-.1 1.9-.6 2.3-1.2 1.4 2.7 2.8 5.5 4.3 8.2-.1.1-.2.2-.4.3-.1.1-.1.3 0 .1l1.4 1.4c4.4 7.9 9 15.7 13.9 23.3-.1.2-.2.3-.3.5.4.3.9.7 1.3 1.1 6.1 9.3 12.6 18.3 19.5 27-2-.6-4-1.2-5.9-1.7l-.7.7c.7 1 1.4 2.7 2.2 2.7 1.5.1 3.2-.7 4.8-1.1-.1-.1-.1-.3-.2-.4 1.8 2.2 3.6 4.5 5.4 6.6-1.4.6-1.8 1.7-1 3.6.7-.8 1.3-1.5 2.1-2.4.9 1.1 1.9 2.2 2.8 3.3-.1.1-.2.2-.3.4.3.2.7.5 1 .7 0 0 0-.1.1-.1C272.2 914.8 381.7 968 504.3 968c82.6 0 159.3-24.2 222.6-65.5-1.1.7-2.2 1.5-3.3 2.2.9.3 1.6.5 2.3.7-.1.3-.1.6-.2.9-1.1-.2-2.3-.4-3.4-.5-10 5.9-20.2 11.9-29.7 17.6 1.3 1.9 2.7 3.7 3.7 5.6 1.1 2.2 2 2.6 4.2 1.3.7-.4 1.3-1 2-1.5-.2 0-.4-.1-.6-.1v-4.5c3.5 2 2.8 5.9 4.4 8.6-.7 1.1-1.4 2.1-2.5 3.6-2-1.5-3.8-2.9-5.9-4.6-1.2 2.5-2.5 4.9-3.9 7.7-.5.1-1.8.3-3 .5 0 .2.1.4.1.7h3.4c-3.1 2.5-2.5 4.3.1 6 .9.6 1.1 2.1 1.6 3.3 1.5-.8 3.1-1.6 4.7-2.4-.1-.2-.1-.5-.2-.7-.7-.2-1.4-.4-2.2-.6-1.4-.2-2-.8-2-2.3 0-3.2 
                    3.3-5.4 6.5-4.3.7.2 1.6.2 2.2-.1 1.9-.7 3.6-1.7 4.8-2.2 1.2 1.3 2.1 2 2.8 2.9.5.6 1 1.6.7 2.2-.3.8-1.1 1.8-2.3.6-.3-.3-1.3 0-1.9.2-1 .2-1.9.5-3 .9.1-1 .1-1.7.1-2.3-.1 0-.2-.1-.4-.1l-.9 2.4c1.6.9 3.1 1.8 4.2 2.4 2-.8 3.6-1.5 5.3-2 2-.6 3-1.5 2.3-3.6-1-.1-1.8-.2-3-.3.4-1 .8-1.8 1.1-2.5-2.1-2.3-3.5-5.6-7.7-3.1-.9-4.5 3-3.9 5.3-5.1-1.1-2.6.3-4.5 2.3-6.3l.9.3c1.2.8 1.8 2.8 3.8 1.6 1.3-.7 2.5-1.7 3.6-2.7 1.2-1.3 2.1-2.7 3.3-4.2.6.5.9.8 1.3 1.1.6.6 1.2 1.2 1.7 1.8-.8.4-1.6.8-2.4 1.1-.9.3-2.3.3-2.6.8-1.6 2.8-2.8 5.8-4.2 8.7l.6.3c1-.7 2-1.3 3.3-2.2.3 2.1 2 3.9-.4 4.9-1.8-.4-3.3-.7-4.9-1-.2-1.1-.5-2.3-.7-3.2.7-1.2 1.2-2.1 1.7-3-.2-.3-.4-.5-.7-.8-1.9.6-3.8 1.2-5.7 1.7 0 .2-.1.4-.1.6 3.7 1.7 2.6 4.9 2.6 8 1.5-.5 2.6-.9 3.5-1.3 1.1.7 2.1 1.4 2.9 2 2.3-1.9 4.2-3.6 5.4-4.6-1.2-3-2-5.3-2.9-7.6.3-.2.6-.4.8-.6 1.8.6 3.6 1.3 5.7 2 .3-.7.8-1.7 1.2-2.6.2 0 .5-.1.7-.1.4.9.7 1.8 1.3 3.3 1.2-.7 2.3-1.4 3.7-2.2-2.9-2-3-2.3-2.4-4.8.1-.6.4-1.4.1-1.8-1.3-2.2-2.8-4.3-4-6.1-.6.4-1.3.9-2.1 1.4 0-.7.1-1.4.1-2.1-.7-.2-1.7-.6-2.6-.9 1.3-1 2.4-1.9 3.5-2.7 1.9 1.1 3.9 2.3 6.1 3.6.7-6.7 1.6-7 8.9-3.2 1.9-1.4 3.6-2.9 3-5.8-2.2.1-4.1.2-6.1.3-1.1.1-2.3.4-2.5-1.3-.2-1.4.1-2.4 1.8-2.6 2.6-.3 5.3-.7 8.5-1.2-.5-.7-1.1-2.3-1.9-2.3-1.7-.2-2.9-.4-3.8-2-.6-1.1-1.5-2.1-2.4-3.3 3.6-2.6 7.1-5.2 10.6-7.9-.1.6.1 1.3.4 2 .4 1 .3 2.1.4 3.8-2-.6-3.4-1-5-1.5-.3 1.2-.7 2.5-1.2 4.3 2.2-2.8 2.8-2.7 4.1.2.6-.1 1.3-.1 1.8-.2.3 1.4.6 2.7.8 3.5 2.2-.6 3.9-1.4 5.6-1.4 3.9.2 4 .3 5.8-3.5-2.4-.8-4.9-1.6-7.3-2.5l-.3.6 1 2c-1.6.2-3 .4-4.9.6 1.6-2.2 2.9-3.9 4-5.5-.2-1-.9-2.1-.5-2.9.4-.9 1.6-1.4 2.6-2.3-.5-.6-1.1-1.1-1.7-1.7.5-.4 1.1-.9 1.6-1.3-.1.5-.2 1.1-.2 1.8l3.4-1.7c.1 1.2.3 2 .1 2.8-.2 1.1-.9 2.2-1 3.3-.1.8.2 1.9.8 2.5 1.3 1.4 2.8 2.5 4.3 3.7.9.8 1.8 1.5 2.8 2.2.2-.1.4-.3.6-.4-.8-2.8-2-5.6-2.4-8.4-.4-2.7.2-5.5.3-8.5-1.2.4-2.1.8-3.1 1.1v-2.9c2.7-2.3 5.4-4.7 8.1-7 .8-.4 1.5-1 1.9-1.7.7-.6 1.4-1.3 2.1-1.9 1.4 3.6-3.3 3.4-4.3 5.7h5c.1.2.1.5.2.7-4-.2-5.3 2.2-6 5.3-.4 1.5-1.1 2.9-1.7 4.3.5.5 1 1.1 1.6 1.8.8-.2 1.7-.6 2.5-.5 1 .2 2 .7 3 1.1-.4.7-.8 1.3-1.1 2-.2.4-.3.9-.5 1.6 1.4.1 2.6.2 3.9.3-.4-2.7-.7-5-1.1-7.4 3.6-3.6 3.6-3.6 4.6-3.1-2.3 2.1-2.3 2.8-.7 3.6 1.1-1 2-1.8 3.1-2.8-.6-1.5-.2-2.6 1.7-3.4.7-.3.9-1.6 1.3-2.5-.2-.1-.5-.2-.7-.3-.7.6-1.4 1.1-2 1.6-1.4-1.6-2.6-3-3.9-4.5 2.7-.3 4.7-.5 6.1-.6 1.6 1.2 2.8 2 4.6 3.3-.3-3.7 2.2-2.2 3.8-2.9-1.3-.5-2.3-1-2.6-1.1.1-1.9.4-3.4.1-4.7-.3-1.6-1.1-3.1.3-4.6.3-.3-.3-1.4-.6-2.7-1.6 1.9-2.9 1.8-4.4.7-.4-.3-1.1-.4-1.7-.5l2.1-2.1c.8.5 1.5 1 2.2 1.5.4-1.2.7-2.1 1-3.1 1.2.5 2 .8 2.9 1.1-.2.2-.3.4-.5.5.4 1 .6 2.4 1.3 3 1.5 1.1 3 .4 4.5-1-2.6-.1-3.1-1.4-2.8-3.4.2-1.4 0-2.8 0-4.6-2.5 1.5-4.5 2.8-6.6 4 0-.1-.1-.1-.1-.2.8-.8 1.6-1.7 2.4-2.5 1.2-.5 1.7-1 1.5-1.6 1.8-1.9 3.6-3.8 5.3-5.7.3.4.6.7.8 1.1-.5 1.7-1 3.5-1.5 5.3-.7 3.1-.4 3.5 3 4.3 1.5-4 1.6-8 .2-11-.2-.5-.7-.9-1.3-1.2 1.4-1.5 2.7-3 4.1-4.6.1.1.2.2.3.2 1.1-1.2 2.1-2.4 3.5-4 .2 1.3.3 1.9.5 3 .9-.7 1.9-1.5 1.9-1.5-.6-.8-1.3-1.7-2.1-2.6 1-1.1 1.9-2.3 2.8-3.4 1.1-.2 2.2-1.4 3.4-1.8-.1.9-.2 1.5-.3 1.8.9.3 1.8.6 2.5.9.5-.7 1.1-1.4 1.7-2.3-4.4-1-1-3.8-1.6-5.8.5-.7 1.1-1.4 1.6-2.1 0 .3-.1.7-.1 1 .9-1.6 2-2.8 2.4-4 5-6.6 9.8-13.3 14.3-20.2.1.1.2.1.2.2.1-.4.3-.8.4-1.2 5.9-9 11.4-18.3 16.5-27.9h.7c0-.5 0-.9-.1-1.3 6-11.3 11.4-23 16.2-35h1.1c.1-.8.3-1.6.4-2.2-.1-.2-.3-.3-.4-.5 15.6-40.2 24.2-83.6 24.2-128.9 0-11.5-.6-22.9-1.6-34.2.4-2 .2-3.5-.5-4.5-1.8-16.4-4.7-32.5-8.7-48.2 1.8 4.5 4.4 8.8 8.2 12.5.7.7 1.1 2 1.1 3-.3 7.7 2.5 14.7 4.7 22.4 2.1-3.7 1.7-7.1.7-10.4-.8-2-2.1-4.9-2.9-7.9zM744.9 275c-2.1 1.3-2.1 1.3-12.3-2.4 3.5-2.4 8.9-1.3 12.3 2.4zm-21.2-9.4c-2.2-1.2-3.9-2-5.7-3 2.4-2.1 4.6-1.1 5.7 3zm-4.8.1c-5.3 1.1-7 .7-7.5-2 4.4-.6 6.5 0 7.5 2zm-9.1-4.3c-.4 1.8-1.1 2.2-3 1.1-1.6-1-3.1-2.1-5-3.4 3 .8 5.5 1.6 8 2.3zm-346.6-94.6c-2.4 2.7-5.6 2.1-8.5 2.6.2-3.1 2.3-3.7 8.5-2.6zM54.1 498.4c.3-1.6.3-2.8.7-3.9.1-.5.9-.8 1.3-1.2.4.5 1 1 1.1 1.5.1 1.6-.5 2.9-3.1 3.6zm-.7 92.3c-1.5-.4-2.8-.6-4-.9.9-1.2 1.6-2.2 2.5-3.3.6.1 1.4.4 2.7.7-.4 1.1-.8 2.2-1.2 3.5zm4.3-17.5c-1.3 2.2-2.8 4.4-4.5 6.5-.7-4.1 1.5-7.2 3.4-10.6 2.2 1.1 1.9 2.7 1.1 4.1zm650.5 349.6c-.8 0-1.6.1-2.4.1-.6-1.4-1.2-2.6-1.8-4.1 1.5.3 2.8.5 4.2.8v3.2zm6.2-3.4c-.9.7-1.9 1.6-2.9 2.4-.2-.2-.4-.4-.6-.5 1.2-1.2 2.2-2.9 3.6-3.3 1.6-.5 3.3.7 3.2 3.2-1-.6-2-1.2-3.3-1.8zm2.8-2c-.1-3 .4-3.5 2.7-3.8.3-1.4-2.3-3.3.4-4.2 1 1.3 1.9 2.5 2.9 3.8-1.7 1.2-3.7 2.6-6 4.2zm153.7-400.8c5 3.1 3.5 8.2 5.4 12.4-2.6-1.8-5.2-7.8-5.4-12.4zm-16.2-91.3c0 .6-.2 1.3 0 1.8l-.9-1.8h.9zm-4.3 54.7c1.4 2.4 2.8 4.7 4.2 7.1-.2.1-.5.3-.7.4-2.9-1.6-3.2-4.5-4.1-7.2l.6-.3zm-19.8-61.4c2.4 5.2 4.7 10.3 7 15.4-1.6.4-2.3.3-3.1-1.4-1-1.9-1.6-3.9-2.5-5.8-.8-1.5-1.8-2.9-2.7-4.4-.2.1-.5.2-.7.3-.1.4-.3.7-.4 1.1-1.5-.7-.6-2.7 2.4-5.2zm-18-7.2c3.3 1 3.7 4 5 6.4 3.7 6.8 7.6 13.4 10.9 20.3 2 4.2 3 8.8 4.6 13.2.4 1.1 1 2.2 1.8 3.2.7 1 1.7 1.8.1 3.6-2.5-4.1-5.1-7.9-7.1-11.9-3.9-8-7.3-16.2-11.1-24.2-1.6-3.3-3.8-6.2-5.6-9.4-.3-.5-.2-1.2-.3-1.8.5.1 1.1.4 1.7.6zm2.6 261.3c1.4 1.4 1.4 2.9-.3 5.3-1.4-1.7-1.2-3.3.3-5.3zm-.2-182.6c2.8 2.9 6 12.4 5.5 16.3-4.7-1.7-7.3-9.2-5.5-16.3zm2.8 241.6c.3.2.7.4 1 .7-.5.6-1 1.3-1.6 1.9-.1.1-.7-.2-1.1-.3.5-.9 1.1-1.6 1.7-2.3zm.2-11.3c-1.1-2.1-.3-4.6 3-10.2 1.9 3.3.5 8.1-3 10.2zm3-203.1c-.8-.5-1-1.8-1.3-2.6 2-.3 3.4-.5 5.5-.8-.5 1.1-.7 2.3-1.4 2.8-.7.6-2.3 1-2.8.6zM807.5 418c3.1 1.9 5.1 4.2 5.6 7.8-2.6-2.2-6.1-3.5-5.6-7.8zm0 40.9c1.1.6 2.1.9 2.3 1.4.4 1 .4 2.1.4 3.1 0 .2-1.3.6-1.4.6-.5-.8-1.1-1.7-1.4-2.6-.2-.6 0-1.2.1-2.5zm1.5 12.8c1.9 5.3 3.8 10.6 5.7 15.8l-.9.3c-2.5-3.9-5.8-7.5-6.5-12.3-.3-1.5.1-3 1.7-3.8zm-3.1 27.9c1.4-1 4.7.1 5.3 1.6.8 2 1.4 4.1 2.1 6.1-.2.1-.5.2-.7.4-.6-.8-1.5-1.6-1.8-2.5-.8-2.5-1.5-4.9-5.6-3.8.3-1 .3-1.6.7-1.8zm6.1 216.7c-.1.5-.2 1.2-.3 1.9H809v-5.6c.2-.1.4-.1.6-.2.3.7.6 1.4 1 2.1.3.6.9 1.1 1.4 1.8zm-83.2 117.9c-.3 2.6-1.7 3.8-4.2 4.4 1.5-1.6 2.7-2.8 4.2-4.4zm53.6-384.8c-2.2-2.4-4.3-4.3-6-6.5-.4-.5.4-1.9 1-2.9 1.8 3 5.4 5 5 9.4zm.2 321h.4l-1.3 3.9c-.7-.6-1.3-1-1.9-1.5.9-.8 1.8-1.6 2.8-2.4zm-41-358.9c3 1.3 1.9 4.5 3.5 6.9-4.6-2.1-5.7-4.4-3.5-6.9zm8.1 408.4c.4-1.6.8-3.1 1.2-4.6-.4-.5-.8-1-1.1-1.6-.1-.1.8-.9 1-.8.6.2 1.2.7 1.5 1.2 1.2 2.6 1.1 6.1-.2 9.5-2.7-.7-3-1.1-2.4-3.7zm3.4-4.4c.6-.7 1.2-1.4 2-2.2.8 2.2.6 2.6-2 2.2zm2 2.8c1.6-1 3.2-2.1 4.8-3.1l.6.9c-1.6 1-3.3 2-4.9 2.9-.1-.2-.3-.5-.5-.7zm3.5-9.7c-.2-.9-.3-1.5-.5-2.6-1.2 1.3-2.1 2.4-3 3.4-.1-.1-.3-.2-.4-.3.3-.4.5-.8.8-1.3-.4-.4-.8-.7-1.3-1.2.8-1 1.6-1.9 2.7-3.3 1.3 1.5 2.3 2.7 3.3 4 0 0-.9.7-1.6 1.3zm9.1-18.6c.3-1.3 1-2.6 1.4-3.7.1 1.7.5 3.3.2 4.8-.2 1.2-1.3 2.3-2.2 3.9.3-2.1.3-3.6.6-5zm3.4 1.1.9-.3c.3.6 1 1.2.9 1.8-.1 1.2-.5 2.3-2.5 2.3.2-1.3.4-2.5.7-3.8zm4.2-4.7c.7-1.3 1.6-2 3.1-.6-.9 1.2-1.8 2.3-2.9 3.7-1.3-.9-.8-2-.2-3.1zm.2 10.9c.3-.2.5-.3.8-.5 1 .8 1.9 1.7 2.9 2.5l-.5.5c-.7.1-1.4.1-2.4.2-.3-.9-.6-1.8-.8-2.7zm8.4-20.8v-2.9c1 .3 1.8.6 3.1 1-1.2.7-2 1.2-3.1 1.9zm.9-335.1c3.4-.3 6.3 3.2 8 9.5-.2.1-.3.2-.5.3-1.3-1.6-2.6-3.1-3.8-4.7-1.2-1.6-2.4-3.3-3.7-5.1zm1-7.7c2.1-1.4 4.4-.1 6-.2.3 2.1.6 4 1 5.9-2.3-1.9-4.6-3.8-7-5.7zm6.6-2.2c-.5-3.7-3.5-4.1-6.4-4.7-1.6-.3-2.3-1.1-2.7-2.7-.5-1.8-1.9-3.5-3-5.1-1.4-1.9-3.6-3.6-1.8-6.4.2-.3-.4-1.3-.9-1.7l-.4-3.9c8.7 2.6 12.6 9.2 15.7 16.3 1.4 3.2 2.8 6.5 4.2 9.8-1.5 1.2-2.5.4-3.5-.5-.7-.3-1.2-.7-1.2-1.1zm-9.5-102.4c-4-2.3-7.9-4.5-11.8-6.7-.4-.3-.8-.7-1.2-1 4.5-3.7 12.8.4 13 7.7zm-141.3-85.6c5 .9 6.5 2.5 4.8 5l-7.5-2.7c1.1-.1 2.1-.7 2.7-2.3zm-27.5-55.3c-.2-.9-.3-1.7-.5-2.7 2.9-.7 2.6 1.8 4.4 3.4-3.2.3-5.7.8-8.2.5-1-.1-1.8-2-3.1-3.5 3.6-.8 4.1 4.1 7.4 2.3zm-3.9 48c3.4-4.7 11.1-6.3 15.3-3-1.4 3.2-4.5 2.7-7.4 3.4.8.2 1.5.4 2.3.4.8.1 1.6-.1 2.6-.1-1 1.5-1.7 2.5-2 3.2-5.5-1.6-11.1-3.1-16.8-4.5.5-.3 1-.7 1.5-.7 1.5.2 3 .8 4.5 1.3zM592 203.6c-5.8 2.6-11.9 3.9-18.3 3.5 5.4-4.3 11.9-3.6 18.3-3.5zm-20.2 3.5c-4.2 4.3-9.8 2.9-14.6 4.4 1-3 6.4-4.6 14.6-4.4zm-27.8 5.8c-2.2 2.1-4.9 2.6-8.5 2.8 2.7-2.8 5.7-2.5 8.5-2.8zM334.9 204c.2.3.3.5.5.8-1.3 3.8-5.2 4-8.1 5.5-.6-.7-1.1-1.3-1.9-2.4 3.2-1.3 6.4-2.6 9.5-3.9zm-17.3 8c-.4 2.4-1.6 2.9-5.1 2.6.4-2.4 1.5-3 5.1-2.6zM110.7 670.8c-1.3.5-1.8 1.2-1.7 2.6 0 .7-.7 1.5-1.1 2.3-.3-.1-.5-.2-.8-.2l2.4-10.8.9-.3c.5.8 1.5 1.6 1.5 2.5.1 1.3 1 3.1-1.2 3.9zm7.8.3c-1.1-1.5-1.2-2.6-.2-4.7.2.6.4 1.3.6 1.9.6 3 1.3 5.9 2 8.8-.7-2.1-1.2-4.3-2.4-6zm456.3 252.2c-.2-.3-.4-.5-.6-.8 1-.7 2-1.5 2.9-2.2.2.3.5.5.7.8-1 .7-2 1.5-3 2.2zm17.2-4.2c-.6-.8-1.2-1.6-2-2.5.8-.4 1.4-.8 2.2-1.3.2 1.2.4 2.3.6 3.3-.3.2-.5.3-.8.5zm1.9-3.1c-.8-3-.6-3.5 1.7-4 .7 2.3.3 3.3-1.7 4zm6.7.2-.9-.3c.2-1.1.5-2.1.9-3.7.6.7 1.3 1.2 1.2 1.4-.2.9-.8 1.8-1.2 2.6zm0-5.8c1.6-.6 2.7-1 4-1.4-.4 2.1-1.1 2.4-4 1.4zm11.4 13.8c-1.2.1-2.4.9-3.6 1.3-.7.2-1.5.2-2.3.3v-.5c1.5-1 3-2 4.6-3-.1-.1-.2-.3-.3-.4 1.1 0 2.2.1 3.4.1 0 1.2-.1 2-1.8 2.2zm.1-8.3c-2-3-1.5-3.6 3.2-5.6.5 2.8-2.5 3.4-3.2 5.6zm1.2-6.2c-.2-.2-.4-.4-.6-.5.8-1.2 1.6-2.5 2.6-4 .6.6 1 1.1 1.7 1.7-1.4 1.1-2.6 2-3.7 2.8zm9.7-7.9c1.4.3 2.5.6 3.7.8.8.1 1.6.1 2.3.1-.5-.5-1-1.1-1.5-1.6-.1-.1-.1-.2-.4-.7 1.2-.2 2.3-.4 3.7-.7 1-1.9 3.7-2.1 5.9-3.1.2-.1 1.1.5 1.1.7-.1 1.4-.4 2.8-.5 4.1 0 .6.6 1.4.4 1.8-.9 1.6-2.1 3.1-3.6 4.4.3-1.5.7-3 1-4.5-.3-.1-.6-.1-.8-.2-.8 1.7-1.6 3.4-2.7 5.9-.9-1.1-1.5-2.2-2.4-3-2.3-2.1-3.4-1.8-4.7.9-.3.6-.9 1.1-1.5 1.5-.1.1-.8-.7-1.3-1-.5.3-.4.6.5 3.2-.9-.8-1.8-1.5-2.7-2.3.2-2.4 4.2-2.8 3.5-6.3zm11.4 16.5c-.1.2-.2.5-.3.7l-4.2-1.5c2.3-1.4 2.6-1.3 4.5.8zm-5.5-11.3c-1.2 1.4-1.1 3.7-4.4 3.6.5-1.7 1-3.5 1.6-5.4 1.1.7 1.9 1.2 2.8 1.8zm-6.1 8.4c-.8-1.2-1.5-1.9-1.4-2.1.6-.8 1.3-1.6 2.2-2.2.2-.1 1.2.8 1.8 1.2-.8.9-1.5 1.7-2.6 3.1zm4.1-2.2c1.1-.6 2.2-1.2 3.2-1.8.2.3.4.6.5.8-1.1.6-2.1 1.3-3.2 1.9-.1-.3-.3-.6-.5-.9zm2.4 10.1c1.2.1 2.3.2 3.5.2-1.1 1.8-1.7 1.8-3.5-.2zm3.4 6.8c-.2-.1-.5-.2-.7-.2-.1-.7-.4-1.6-.1-1.9.5-.5 1.4-.5 2.2-.7.2.3.3.5.5.8-.6.7-1.3 1.4-1.9 2zm9.9-19.5h-4.4c.7 1 1.1 1.7 1.9 2.9-1.2-.2-2.2-.4-3.1-.5-.4-.1-.9-.4-1.3-.3-1.4.1-2.4-.4-2.3-1.8.1-1.6 1.3-2.3 2.8-2.5 1.6-.2 3.2-.2 4.9-.3.4 0 .8-.3 1.6-.6-.7-1.1-1.3-1.9-1.8-2.9-.6-1.1-1.3-2.3-1.5-3.5-.1-.6.5-1.7 1-2 2.1-1 3.1-2.6 3.3-4.7.2-.1.4-.1.6-.2.8 1.2 1.6 2.4 2.4 3.7-3.2 1.3-3.1 1.3-2.6 4.4.2 1-.2 2.1-.4 3.6.8.9 1.8 2.2 2.9 3.5-1.2 1.1-3.6.9-3.2 3.3-.3-.7-.5-1.4-.8-2.1zm.9 4.3c.8-.4 1.5-.7 2.4-1.1.4.7.7 
                    1.4 1 2-1.9 1.1-2.3 1-3.4-.9zm8.2-9c-.3-2.5-.5-5.1-.7-7.9-.7.1-1.7.3-3 .5.2-1.8 3.5-2.9 1.4-5.1-.8.5-1.7 1-2.7 1.7-.4-1.1-.6-1.8-1-2.8 2.6-1.3 5.2-2.8 7.9-4 .7-.3 2.4.3 2.6.8.3.8-.2 2-.6 2.9-.2.4-.9.6-1.6 1 .5.8.9 1.5 1.3 2.2l-2.1 3c.3.5.7 1 1.2 1.6-.7.3-1.2.5-2.1.9.6 1.3 1 2.7 1.8 3.8.8 1.1.4 1.7-.5 2.2-1 .6-1.8.3-1.9-.8zm5.9 7.5c-1.3-1.3-2.3-2.3-4.2-1.1-.1.1-.5-.3-1.1-.6 1.2-.8 2.1-1.4 3-1.9 1.3.9 2.6 1.9 4.3 3.1 0 1-.7 1.8-2 .5zm38.1-26.2c-.4-1.2-.1-2.6-.1-4 .2 0 .3 0 .5.1.8 1.5 1.5 3 2.6 5.2-1.4-.6-2.8-.8-3-1.3zm1.8-17.8c.2 1.4 1.2 1.1 2.1 1.1 1.7-.1 3.4-.2 5.2-.2.5 2.4-1 3.7-2.6 5-6.3-3.3-7.1-3-7.7 2.7-1.9-1.1-3.6-2.1-5.2-3.1-.9.7-1.9 1.5-3 2.3.7.2 1.6.5 2.2.7 0 .7-.1 1.2-.1 1.8.7-.4 1.3-.9 1.8-1.2 1 1.5 2.3 3.4 3.5 5.3.2.4 0 1.1-.1 1.6-.5 2.1-.4 2.4 2.1 4.1-1.2.7-2.1 1.3-3.2 1.9-.5-1.3-.8-2.1-1.1-2.9-.2 0-.4.1-.6.1-.4.8-.8 1.7-1.1 2.3-1.8-.6-3.4-1.2-4.9-1.8-.2.2-.5.3-.7.5.8 2 1.5 4 2.5 6.6-1.1.9-2.7 2.3-4.7 4-.7-.5-1.5-1-2.5-1.7-.7.3-1.7.6-3 1.1 0-2.7 1-5.5-2.3-6.9 0-.2.1-.4.1-.5 1.6-.5 3.3-1 4.9-1.5.2.2.4.4.6.7-.5.8-.9 1.6-1.5 2.6.2.7.4 1.8.6 2.7 1.4.3 2.6.6 4.2.9 2.1-.8.6-2.4.4-4.2-1.1.7-1.9 1.3-2.8 1.9-.2-.1-.3-.2-.5-.3 1.2-2.5 2.3-5 3.6-7.4.3-.5 1.5-.4 2.2-.7.7-.3 1.4-.6 2.1-1-.5-.5-1-1.1-1.5-1.6-.3-.3-.6-.5-1.1-.9-1 1.3-1.8 2.6-2.8 3.6-.9.9-1.9 1.7-3.1 2.3-1.7 1-2.3-.7-3.3-1.4-.2-.2-.5-.2-.8-.3-1.8 1.5-3 3.1-2 5.4-2 1-5.3.6-4.6 4.4 3.6-2.2 4.8.6 6.6 2.6-.3.6-.6 1.3-.9 2.1 1 .1 1.7.2 2.5.3.6 1.8-.3 2.6-2 3.1-1.4.4-2.8 1.1-4.6 1.7-.9-.5-2.2-1.3-3.6-2.1.3-.7.5-1.4.8-2.1.1 0 .2 0 .3.1 0 .6-.1 1.1-.1 2 .9-.3 1.7-.6 2.6-.7.5-.1 1.4-.4 1.6-.1 1.1 1 1.8.2 2-.5.2-.5-.2-1.4-.6-1.9-.6-.8-1.3-1.4-2.4-2.5-1 .5-2.6 1.3-4.2 1.9-.6.2-1.3.2-1.9.1-2.8-.9-5.6 1-5.6 3.7 0 1.3.6 1.8 1.8 2 .6.1 1.2.3 1.9.5.1.2.1.4.2.6-1.4.7-2.7 1.4-4 2.1-.5-1-.6-2.3-1.4-2.9-2.2-1.5-2.7-3-.1-5.2h-2.9c0-.2-.1-.4-.1-.6 1.1-.2 2.1-.3 2.6-.4 1.2-2.4 2.3-4.6 3.4-6.7 1.8 1.4 3.4 2.6 5.1 3.9.9-1.3 1.5-2.2 2.1-3.1-1.4-2.4-.8-5.7-3.8-7.4v3.8c.2 0 .4 0 .6.1-.6.4-1.1.9-1.7 1.3-1.9 1.1-2.7.7-3.6-1.2-.8-1.7-2.1-3.2-3.2-4.8 8.2-4.9 16.9-10 25.6-15.1 1 .2 1.9.3 2.9.5.1-.3.1-.5.2-.8-.6-.2-1.2-.3-2-.6 2.4-1.6 4.7-3.2 7.1-4.8.8 2.8-3.6 4.2-1.4 7.5.9-2.9 3.3-4.8 2.4-7.8 0-.1.7-.4 1.1-.5.6-.2 1.7-.3 1.7-.5-.1-2.1 1.8-2.7 3.1-3.6.8-.6 1.5-1.3 2.2-1.8.8 1.1 1.7 2 2.3 3.1.7 1.3 1.8 1.5 3.3 1.7.6.1 1.1 1.4 1.6 2-2.8.4-5 .7-7.3 1-1.4 0-1.6.8-1.5 2zm12.3-2.6c1.3-.4 2.4-.7 3.5-1.1 2.2-.8 2.5-.7 2.9 1.7-2.7 1.2-5.5 1-6.4-.6zm4.6-4.8c-1.4-.1-2.9.7-4.8 1.2-.2-.7-.4-1.8-.6-3-.4 0-1 .1-1.5.2-1.2-2.4-1.7-2.5-3.5-.1.4-1.6.7-2.6 1-3.7 1.4.4 2.6.8 4.3 1.3-.1-1.4 0-2.4-.4-3.2-.7-1.7-.3-2.9 1.3-3.8.9-.5 1.7-1.4 2.6-2.1.7.7 1.3 1.3 1.9 2-.9.7-1.9 1.2-2.2 2-.3.7.3 1.6.5 2.5-1 1.3-2.1 2.8-3.5 4.7 1.6-.2 2.8-.4 4.2-.6-.3-.7-.6-1.2-.8-1.7.1-.2.2-.3.3-.5l6.3 2.1c-1.6 3-1.7 2.9-5.1 2.7zm9.1-1.5c-.8-.6-1.6-1.3-2.4-1.9-1.2-1-2.6-2-3.7-3.2-.5-.5-.7-1.5-.7-2.2.1-1 .6-1.9.8-2.8.1-.7 0-1.4-.1-2.4-1.2.6-1.9 1-2.9 1.5-.2-3.7 3.1-4.3 4.9-6.1v3.2c.9-.3 1.6-.6 2.7-1-.1 2.6-.6 5-.3 7.4.3 2.5 1.3 4.8 2.1 7.3-.1-.1-.3.1-.4.2zm.6-7.5c.7-.8 1.2-1.5 1.7-2.1.7.6 1.4 1.1 2.2 1.7-1 1.5-2.2 1.4-3.9.4zm4.4 7.3c.7-.8 1.3-1.6 2-2.3.4.7.8 1.4 1.5 2.5-1.5.1-2.3.2-3 .3l-.5-.5zm7.1 46.9-.9.3c-.6-1-1.4-1.9-1.7-3-.1-.3 1.4-1 2.2-1.5.3.2.5.4.8.7-.2 1.2-.3 2.3-.4 3.5zm.6-9.4c0 .2-1.3.3-2 .6-.5.2-1.3.5-1.3.6 1.1 3.5-1.8 5.7-2.8 9-2.5-3.8 2.5-5.5 1.7-8.7 1.6-1.1 3.3-2.2 4.9-3.3-.3.4-.5 1-.5 1.8zm-1.8-44c2.6.5 2.5 2.1 2.2 3.2-.4 1.2-1.6 2.2-2.7 3.6-1.2-2.7.5-3.5 1.9-4.5-.5-.7-.8-1.4-1.4-2.3zm7.1 1.4c-1.9-.2-3.2-.9-3.1-3.1h4.6c-.6 1.2-1 2.2-1.5 3.1zm-5.9-3.2c-.7-.5-1.4-.9-2.2-1.5.9-.8 1.5-2.1 3.4-1.6.7.2 1.7-.6 2.5-1.1 1-.6 1.8-1.3 3-2.1.3 1.2.6 2 .9 3-3.7-1.1-4.9 2.7-7.6 3.3zm7.6-12.1c-1.5-1.1-2.5-1.8-3.9-2.8-1.1.1-2.9.3-5.2.5 1.1 1.3 2.2 2.5 3.4 3.9.5-.4 1.1-.9 1.7-1.4.2.1.4.2.6.2-.4.7-.6 1.9-1.2 2.1-1.6.7-2 1.7-1.5 3-.9.8-1.7 1.6-2.6 2.4-1.4-.7-1.3-1.3.6-3.1-.8-.4-.8-.4-3.9 2.7.3 2.1.6 4.1.9 6.4-1.2-.1-2.2-.1-3.4-.2.2-.6.3-1 .4-1.4.3-.6.6-1.1.9-1.7-.8-.3-1.7-.8-2.5-1-.7-.1-1.4.2-2.1.4-.5-.6-1-1.1-1.4-1.5.5-1.2 1.1-2.4 1.4-3.7.6-2.6 1.7-4.7 5.2-4.5-.1-.2-.1-.4-.2-.6h-4.3c.9-2 5.3-1.7 3.5-5.3 2.2-2.6 4.4-5.3 6.7-8 .3.1.6.2.8.3-.2 1-.5 2-.7 3h-.6c.4.7.9 1.4 1.3 2.1-1 .8-2.1 1.6-3 2.5-.1.1.5.7.8 1.2.6-.9 1.1-1.5 1.9-2.6.4 1.3.7 2.2 1 3h.4l.6-3.9c.2 0 .5-.1.7-.1.2.7.3 1.3.5 2s.5 1.3.9 1.9c.1.1 1.1-.1 1.1-.2.1-.6.1-1.3 0-1.9-.1-.8-.2-1.6-.3-2.5-.5 0-1.1-.2-1.8-.2-1.3 0-2.4-.4-2.1-1.7.1-.4 1.4-.7 2.3-1.1-.7-.4-1.6-.9-2.5-1.3 0-.2.1-.4.1-.5.7.2 1.6.2 2.2.6 1.3.9 2.4 1 3.8-.6.3 1.1.8 2 .5 2.3-1.2 1.3-.5 2.6-.3 4 .2 1.2 0 2.4-.1 4.1.3.1 1.2.5 2.3 1-1.1.4-3.2-1-2.9 2.2zm2.1-15.3c.1-.2.3-.3.4-.5-.7-.3-1.5-.6-2.5-1-.3.8-.5 1.6-.8 2.6-.7-.5-1.4-.9-2.2-1.5-.4.2-1 .4-1.6.7l-.3-.3c2.1-2.3 4.2-4.6 6.3-6.8 1.6 1.5 1.5 2-.3 2.8-.9.4-1.8.9-2.6 1.4l.6.9c1.7-1.1 3.5-2.1 5.7-3.5 0 1.5.1 2.7 0 3.9-.2 1.7.1 2.8 2.4 2.9-1.3 1.2-2.6 1.8-3.8.8-.8-.3-.9-1.5-1.3-2.4zm4.8 6.1c-.3.9-.5 1.7-.8 2.7-1-.5-1.8-1-2.7-1.5 1.2-2.1 3.1-3 5.1-2.2.7.3 1 1.3 1.5 1.9-.3.2-.6.4-.8.6-.6-.3-1.4-.8-2.3-1.5zm15.6-27.8c-.7-.2-1.4-.5-2.2-.7 0-.3.1-.8.3-1.6-1.7.5-2.9 2.7-4.8.7 1.2-2.4 3.4-1.7 6-1.4-.7-1.2-1.3-2.1-1.9-3.1.6-.3 1.5-.8 2.5-1.3 1.3 1.8-2.5 4.6 1.6 5.5-.6.7-1 1.3-1.5 1.9zm2.7-.8c1-1.6 1.8-3 2.8-4.3.3-.4 1.2-.3 1.9-.5.1.6.5 1.3.2 1.7-.9 1.7-2.1 3.2-4.9 3.1zm21.8 52.9c-1.1.5-2.6.8-2.7 1.2-.3 1.5 1 2 2.5 2 .7 0 1.5.1 2.1.2.1 1.1.2 2 .3 3 .1.7.1 1.5 0 2.2 0 .2-1.2.4-1.3.3-.4-.7-.7-1.5-1-2.3-.3-.8-.4-1.5-.6-2.3-.3.1-.6.1-.8.2-.2 1.5-.5 3-.7 4.6h-.5c-.3-1-.6-1.9-1.2-3.5-.9 1.2-1.4 2-2.2 3-.4-.6-1-1.4-1-1.4 1.1-1 2.3-1.9 3.5-2.9l-1.5-2.4h.7c.1-.6.3-1.1.4-1.7.5-.5 1-1 1.5-1.4.8.4 1.7.8 2.5 1.2zm6.7-105.7c-2.4.2-3.2-1-3.4-3 2.1-.5 3.6.8 3.4 3zm.3-287.7c-.5-.5-1-1-1.3-1.6-.2-.5 0-1.1 0-1.7-2.1.2-2.3-.1-1-4 1.1 1.8 2.3 3.6 3.2 5.5.2.4-.6 1.2-.9 1.8zm-1-26c0-1.4.6-2.3 2-2.2.9 2.5 1.7 4.6 2.5 6.9-2.4-.3-4.4-2.5-4.5-4.7zm11.3 281.9-3.9 3.9c-.6-1.5 1.1-3.7 3.9-3.9zm3 5.9c.5-.7 1-1.5 1.5-2.2.4.3.8.5 1.2.8-.5.7-1 1.5-1.6 2.1-.1 0-.8-.5-1.1-.7zm8.3 98.8c-.9-.1-1.7-.2-2.5-.3.4-.5.9-1.1 1.3-1.6.4.6.8 1.2 1.2 1.9zm4.6-187.5c-1.4-2.7-1-5 .1-7.3 1.8 1.5 1.8 4.4-.1 7.3zm5.1-11.7c-2.4-12.3-.6-24.5.1-36.8 1.5 12.3 1.6 24.6-.1 36.8zm.2-52.6c2.8 1 3.2 3.2 1.4 8.5-1.1-1.3-1.4-2.9-1.4-8.5zm-.9 129.2c-.8-4.5-.3-5.9 2.4-6.1-.1 4.7-.4 5.6-2.4 6.1zm2.9-15.9c-.8-1.2-1.5-2.2-2.2-3.4 1.1-2 2.9-1.3 5.3-1.3-1.1 1.7-2 3-3.1 4.7zm.4-140.1c0-.9-.3-2-.9-2.6-5.1-5.2-7.8-11.4-9.1-18 1.4-.3 2.7-.5 3.9-.8 2.2-.5 3.2-.1 3.8 2 .3 1.1.5 2.4.5 3.5.1 5.8 2.2 10.8 5.4 15.7-.4-.3-.9-.6-1.7-1.1 0 1.5-.3 2.8.1 4 .7 2.6 1.8 5.1 2.6 7.6.9 2.9 1.2 5.7-.6 9-1.8-6.6-4.2-12.7-4-19.3zm8.4-58.5c-1.5-1.4-3-2.9-4.8-4.6.2-.2.6-1 1.3-1.4 1-.7 2.1-.8 2.6.7.6 1.6 1.1 3.2 1.7 4.9-.3 0-.5.2-.8.4zM852 492l-3.3-4.5c2.1-1 3.7.9 3.3 4.5zm5.2 5.5c0 .4-.5 1-.8 1.1-.5.1-1.4-.2-1.5-.5-.3-.9-.6-1.9-.4-2.8.2-.6 1.2-1.1 1.9-1.6.2.2.4.3.6.5.1 1.1.3 2.2.2 3.3zm25 55.7c2.7 1.9 1.8 4.7 2.3 7.2-2.1-2.1-2.3-4.6-2.3-7.2zm8.1 46.8c-1.9-5.3-3-10.5-2.4-16 2.8 2 4.1 10.9 2.4 16zm-1.8-17c-4.2-3.7-2.4-8.4-3.7-12.6 2.9 1.1 3.2 2.3 3.7 12.6zm-16.4-213.1c.1.7 0 1.5.3 2.1 2.1 3.6 4.7 7.1 6.5 10.9 4.4 9.3 8.4 18.9 12.9 28.2 2.3 4.7 5.3 9.1 8.2 13.9 1.9-2 .8-3-.1-4.1-.8-1.1-1.6-2.4-2.1-3.7-1.8-5.1-3-10.5-5.3-15.3-3.8-8-8.4-15.8-12.6-23.6-1.5-2.8-2-6.3-5.8-7.4-.7-.5-1.3-.7-2-1z"/>
                <path class="st1" d="M92.7 214.2c.8-.7 1.8-1.3 2.5-2.2 1-1.2 1.8-2.6 3-4.2-2.2.3-3.9 1-4.8.5-.9-.5-.8-2.4-1.3-4.4-7.7 9-14.9 17.5-22.2 26 .2.3.5.6.7.9 2.1-.4 4.1-.8 6.2-1.4 2.6-.7 2.9-1.5 1.7-3.7-1.1-2.2-.6-3.3 2-3.4 1.8-.1 3.7.4 5.1.6.5-2.2 1-4.4 1.6-6.8-1.3 1.1-2.2 1.9-3.2 2.8l-.8-.8c1.7-1.7 3.3-3.4 5.2-5.3 1.2 3.8 1.6 3.9 4.3 1.4zm496.1-72.7c-1.6-2-.5-3.2 1.3-3.5 2.2-.4 4.6-.5 6.9-.2 2.6.4 5.1 1.5 7.6 2.2 1.6.5 3.1.4 4.8-1.4-8.2-2.9-15.9-5.7-23.9-8.5-1 1-2.3 2.4-3.8 4 1 .4 1.6.5 1.8.8.8 1.2 1.4 2.6 2.1 3.8-1.1.4-2.2 1.1-3.4 1.2-1.4.1-2.9-.5-4.3-.5-1 0-2 .5-2.9.8.1.2.1.5.2.7 4.5-.7 8.7 2.9 13.6.6zm206.6 124.2c-.6 1.8-1 3.3-1.5 4.7-.5 1.5-.2 2.2 1.4 3 2.6 1.2 5.1 2.7 7.3 4.5 2.8 2.2 5.1 4.9 7.8 7.1 2.2 1.8 4.7 3.1 7 4.7.2-.3.5-.5.7-.8-3.9-10.8-14.1-16.2-22.7-23.2zm.8 3c3.3-.2 3.2 2.9 5.1 4.2-2.7.8-4.6-.8-5.1-4.2zM649.7 948.1c1.1.9 2.1 1.8 3.2 2.7-1-3-1.1-3.3-.6-3.7.5.4 1.4 1.3 1.5 1.2.7-.5 1.4-1.1 1.8-1.8 1.5-3.2 2.8-3.5 5.4-1.1 1 .9 1.7 2.2 2.7 3.5 1.3-2.9 2.3-4.9 3.2-6.9.3.1.6.2 1 .3-.4 1.7-.8 3.5-1.2 5.2 1.7-1.5 3.1-3.2 4.1-5.1.3-.5-.5-1.4-.5-2.1.1-1.6.5-3.2.6-4.8 0-.3-1-1-1.3-.9-2.5 1.2-5.7 1.4-6.8 3.6-1.6.3-2.9.6-4.3.8.3.5.3.7.5.8l1.8 1.8c-.9 0-1.8 0-2.7-.1-1.4-.2-2.7-.6-4.3-.9.8 4.2-3.9 4.6-4.1 7.5z"/>
                <path class="st1" d="M681.2 949.5c-1.3-1.5-2.5-3-3.4-4 .2-1.7.6-3 .4-4.1-.6-3.7-.7-3.6 3-5.1-.9-1.4-1.9-2.8-2.8-4.2-.2.1-.5.1-.7.2-.3 2.4-1.5 4.3-3.9 5.4-.7.3-1.3 1.6-1.2 2.4.3 1.4 1 2.7 1.7 4 .6 1.1 1.3 2.1 2.1 3.4-.9.3-1.4.6-1.9.7-1.9.2-3.8.2-5.7.4-1.8.2-3.2 1-3.3 2.9-.1 1.6 1.1 2.2 2.7 2.1.5 0 1 .3 1.5.4 1.1.2 2.2.4 3.7.6-.9-1.4-1.4-2.2-2.2-3.4h5.1c.3.8.6 1.6.9 2.3-.2-3 2.7-2.7 4-4zm8.2-3c1.1-.6 1.6-1.2.6-2.5-.9-1.3-1.4-2.9-2.1-4.4 1-.5 1.7-.7 2.4-1.1-.6-.8-1-1.3-1.4-1.9.9-1.2 1.7-2.4 2.5-3.5-.5-.8-1-1.6-1.5-2.5.8-.5 1.6-.7 1.8-1.2.4-1.1 1-2.5.6-3.4-.2-.6-2.3-1.3-3.1-.9-3.2 1.3-6.2 3.1-9.2 4.6.4 1.2.7 2 1.1 3.3 1.2-.7 2.2-1.4 3.2-1.9 2.4 2.6-1.4 3.8-1.6 5.9 1.5-.3 2.6-.5 3.4-.6.3 3.2.5 6.2.8 9.2.3 1.1 1.3 1.5 2.5.9zm23-774.8c2.3 1.1 4.7 1.9 7.8 1-7.3-4.8-13-11.9-23.2-9.4v3.7c2.9.5 5.8.7 8.4 1.5 2.5.7 4.7 2.1 7 3.2zm121.4 141.2c2.2 3.1 3.2 3.5 7.3 2.3-2-3.1-4-6.2-6.2-9.2-1.1-1.6-2.4-3.2-3.9-4.6-1.8-1.6-3.9-1.6-5.9-.4 3 4.1 5.9 7.9 8.7 11.9zm49.6 168.2c.5-4.5-3.2-15.6-6.4-18.9-2.1 8.2.8 17 6.4 18.9zM778.5 300.7c6.3 4.7 10.8 11.3 19.3 13.3-2.5-5.6-13.6-13.2-19.3-13.3zm113.8 84.5c.2-.4.3-.9.5-1.3.3-.1.5-.2.8-.4 1.1 1.7 2.3 3.3 3.2 5.1 1.1 2.2 1.8 4.6 2.9 6.8 1 1.9 1.7 2.1 3.7 1.6-2.7-5.9-5.4-11.8-8.2-17.8-3.7 2.8-4.7 5.1-2.9 6zm-24.4 60.1c.8 5.6 4.6 9.7 7.6 14.3.3-.1.7-.3 1-.4-2.2-6.1-4.4-12.2-6.6-18.4-1.8 1-2.3 2.6-2 4.5zm-22.8-100.4c-.1.2-.2.5-.3.7 3.9 5 6.7 10.9 12.5 14.4-5.2-7.4-5.5-8.2-5-12.6-2.6-.9-4.9-1.7-7.2-2.5zM570.2 140c-1.9-3.6-12.5-4.8-17.6-2.1 6 .6 11.4 3.9 17.6 2.1zm391.4 431.3c-.7 6.4.5 12.5 2.8 18.6 2-5.9.5-16.2-2.8-18.6zM47.1 136.9c5.1 1.6 10.3-1.4 13.3-7-1.5-.5-3-1.1-4.7-1.8-1.2 4.4-3.3 7.9-8.6 8.8zm66.4 555.9c-.4 0-.7 2.2-.9 2.7 1.6.8 3.2 1.3 3.2 1.8.1 1-.8 2.1-1.4 3.4 4-1.2 2.5 2.4 4.1 3.5 1.7-1.1 1.5-2.5.9-4.1-.6-1.9-.9-3.8-1.3-5.7.2-.2.5-.4.7-.7-1.8-.3-3.6-.9-5.3-.9zM80.8 206.6c-3.6 4.6-9 8-11 14.1 2.3-2 4.3-3.8 6.3-5.5 1.6-1.4 3.3-2.6 4.8-4 1.5-1.6 1.4-2.8-.1-4.6zm772.4 125.6c-2-5.1-4.6-9.9-9.3-13.5.5 6.1 4.9 9.8 9.3 13.5zM121.9 712.5c-.1.4.8.9 1.2 1.4.3-.2.6-.3.9-.5-.5-1.2-.8-2.3-1.4-3.5-.8-1.7-.5-2.8 1.7-3 .2.8.5 1.4.7 2.1 1.2-2.4 0-3.6-1.7-4.3.5-2.3 1-4.4 1.5-6.5-.2-.1-.5-.2-.7-.2-.6 1.2-1.5 2.4-1.6 3.7-.1 2.2-.9 4-2.7 5.3-.8-.3-1.6-.5-2.4-.8-.1.2-.3.5-.4.7.8.6 1.5 1.5 2.4 1.9 1.6.8 3 1.6 2.5 3.7zm657-431.2c1.4 1.7 3.3 2.2 5.2 1.2-1.9-2-3.8-3.9-5.8-5.8-1.4-1.3-2.8-2.7-4.3-3.8-.8-.5-2-.5-3-.7 1.8 1.9 3.5 3.4 5 5.1 1.1 1.3 1.8 2.8 2.9 4zm16-40.3c3.7 3.6 5.4 4.8 8.3 4.6-2.7-2.8-5.6-5.3-8.5-7.8-.5-.4-1-.9-1.5-1.3-1.6-1.2-3.2-2.5-5.4-1.9 2.5 2.2 4.9 4.2 7.1 6.4zm167.4 329.1c-.6-11.9-.9-13.3-4.3-14.6 1.6 4.8-.5 10.3 4.3 14.6zm-81.9 159.7c4.1-2.4 5.8-8 3.5-11.8-3.9 6.5-4.7 9.4-3.5 11.8zM942 493c.2 5.3 3.2 12.4 6.3 14.5-2.3-4.9-.6-11-6.3-14.5zM724.3 215.4c-2.1-5-7.5-5.3-12-8.1 1.8 6.5 7.9 5.9 12 8.1zm-115.1-48.7c-1.4.1-3.2.2-3.4 2.4 6.2-2.8 11.1 3.1 17.1 2.3-2.4-2.7-10.6-5-13.7-4.7zM745 192.5c-2.1-.9-4.2-2.2-6.5-2.6-.8-.1-2 2-2.8 2.8 2.1 1.4 3.7 2.4 5.5 3.6-.6-3.1 2.2-2.1 3.8-3.8zm39.2 38.9c-3.1-4.1-7.4-6.7-12.2-8.6 2.9 4.4 7.1 7.1 12.2 8.6zM843 396.6c2.8 2.3 5.5 4.4 8.1 6.5-.4-2.2-.7-4.4-1.1-6.8-1.9.2-4.6-1.3-7 .3zm18.1-67.1c.4-.7.9-1.4 1.4-2.1 1.5-2.4 1.2-3-1.7-3.7-.3 1.1-.4 2.7-1.1 3.2-.8.6-2.3.1-4.5.1 1.7 1.9 3.1 3.3 4.8 5.1.5-1.3.7-2 1.1-2.6zM70.7 653.3v4.7c1.6-.1 3.2.1 4.6-.3.6-.2 1.3-1.8 1.1-2.3-.9-2.1-2.9-2.3-5.7-2.1zM789 878c-.9.5-2.1 1.5-2.9 1.3-2.3-.6-3 1-4 1.9.9.6 1.7 1.1 2.5 1.7 3.1-.7 4.5-5.1 8.8-3.7-.4-1.3-.6-2.2-1-3.5-1.3.8-2.3 1.7-3.4 2.3zm66.1-479.2c.1 2.6 2.4 5.1 5.3 5.5-1-2.6-1.9-5.2-2.9-8-1.7-.2-2.4.8-2.4 2.5zm46.3 50.5c-.8.5-1.3 1.4-1.5 1.7 2 1.9 3.8 3.6 5.6 5.3.3-.2.6-.4.9-.5-.6-1.9-1.3-3.8-1.9-5.7-.7-1.7-2-1.6-3.1-.8zm-26.6-61.8c-.6-4.2-2.9-6.9-6.6-9.1-.5 4.9 3.5 6.5 6.6 9.1zm11.4-24.5c-1.7-3.8-3.2-7.2-4.8-10.6-.2.1-.5.2-.7.2-.8 4.2 1.2 8.2 5.5 10.4zM42.3 539.2c.8-2.8 1.8-5.5-1-8.2-2.1 2.4-1.7 5.9 1 8.2zm406.4-399c-6-1.7-8.7-1.9-8.5 1.8 3 .2 6 .4 8.5-1.8zM655.5 951c3.9.1 3.7-2.6 5.1-4.2-1-.7-2-1.3-3.3-2.1-.7 2.3-1.2 4.3-1.8 6.3zm236.3-245.3c2.3-.6 2.7-1.6 2.7-7.1-3.1.2-3.7 1.8-2.7 7.1zm-763 31.6c-.4 0-.8-.1-1.2-.1-.9 1.8-1.9 3.6-3 5.6 2.6-.3 5.6 1.5 6.1-2.4-1.7-.3-3.6-.5-1.9-3.1zm653.7-519.1c-.8-2.6-2.7-4.3-4.8-4.3-1 0-2.1.6-3.1 1 .1.3.2.7.3 1 2.5.7 4.9 1.4 7.6 2.3zm110.1 465.1c.9 1.3 1.7 2.5 2.6 3.9 1.2-1.9 2.2-3.5 3.5-5.5-2.7.1-4.8-.7-6.1 1.6zM180.8 821.2c-2.9 1-2.6 3.7-3.7 5.5 2-.6 5.3 2 5.6-2.2-2.8-.9-2.8-.9-1.9-3.3zm458.6 143.4c-1.8 1.2-3.5 2.3-5.3 3.5v.5c.9-.1 1.8-.1 2.6-.4 1.4-.5 2.8-1.4 4.2-1.5 2-.2 2.1-1.1 2.1-2.5-1.4-.1-2.7-.1-4-.2.2.2.3.4.4.6zM826 819.8c-1.2 1.5-2 3.1-3.2 5 3.3.2 4.7-1.5 5.7-3.6.3-.5-.2-1.3-.3-2-.8.2-1.9.2-2.2.6zm-22.5 37.3c-2.3-1-4.5 0-5.9 2.5 1 .5 1.9 1.1 3.1 1.7.3-1.2.6-2.1.9-3.2 1.1.8 1.9 1.3 2.7 1.9.3-.2.6-.5 1-.7-.7-.7-1.1-1.9-1.8-2.2zm-44.7 41.7c-1.3.5-2.6.8-4 1.3 1 1.8 4.3 2.1 7.4.7-.5-2.8-.8-2.9-3.4-2zm125.1-405c.6.4 2.4-.1 3.2-.7.8-.6 1-1.9 1.6-3.2-2.4.4-4.1.6-6.4.9.5 1 .7 2.4 1.6 3zM641.1 957.1c.8-2.5 4.2-3.2 3.7-6.5-5.5 2.3-5.9 3.1-3.7 6.5zM30.2 165.4c-1.3 1-2.2 2.4-3.3 3.6.1.2.2.3.4.5 1.6-.5 3.4-.7 4.8-1.5.6-.4.6-1.8.9-2.7-1 0-2.2-.4-2.8.1zm657.7 786.9c.6.4 1.1.8 1.2.7 2.2-1.4 3.4-.2 4.8 1.3 1.5 1.5 2.3.5 2.4-.6-1.9-1.4-3.5-2.5-4.9-3.6-1 .6-2.1 1.2-3.5 2.2zm118-701.5c3 1.7 2.9 6.1 7.5 7.1-1.4-2.1-2.4-3.5-3.3-4.9-1.6-3-1.8-3.1-4.2-2.2zm119.2 215.5c-.8.6-2 1.1-2.2 1.9-.3 1 .1 2.2.5 3.3.1.4 1.2.6 1.7.5.4-.1.9-.8.9-1.2.1-1.3-.1-2.6-.2-3.9-.2-.2-.4-.4-.7-.6zm-7-15.9c-.2.1-.5.3-.7.4 1 3.1 1.4 6.5 4.8 8.4.3-.2.5-.3.8-.5-1.6-2.8-3.3-5.5-4.9-8.3zm-46.8-19.2c0-1.2 0-2.5-.4-3.6-.2-.6-1.4-.9-2.6-1.6-.1 1.4-.3 2.2-.1 2.8.4 1.1 1 2.1 1.6 3 0 .1 1.5-.4 1.5-.6zM78.2 202.9c3.2-.8 5.2-2.5 6-6-3.6 1-4.7 3.5-6 6zm576.2 748.6c-1 .6-1.9 1.6-2.5 2.5-.2.3.7 1.1 1.6 2.5 1.3-1.6 2.1-2.6 2.9-3.6-.7-.5-1.8-1.6-2-1.4zm300.7-416c-.1 3.1.2 6 2.6 8.3-.5-2.9.5-6.2-2.6-8.3zM433.4 163.1c1.8-2.7 6.2-.1 8-3.8-6.8.5-8.9 1.5-8 3.8zm347.5 46.2c.5.4 1.7.1 2.5.1l.3-.9c-1-1-1.9-2.1-3-2.9-.4-.3-1.5.3-2.3.6.8 1 1.5 2.3 2.5 3.1zm10.6 677.3c.5-1.1 1-2.2 1.7-3.6h-5.3c-.1 2.5 1.4 3.3 3.6 3.6zm-8.3-1.7c.7 1.2 1.1 1.9 1.6 2.7-1.6 1.1-3.5 2.1-2.2 5.3 1.3-1.6 2.7-2.7 3.1-4.1.4-1.4.5-3.4-2.5-3.9zM599.4 156.1c-.2 2.7 1.1 3.4 5.1 2.7-.5-2.5-1.8-3.1-5.1-2.7zm223.2 180.1c.5-3-.9-4.2-3-4.8-.8-.2-1.8.3-2.8.5 2.2 1.6 3.8 2.9 5.8 4.3zm-22.9-19.1c1.5 2.2 2.4 5.1 7.2 4-2.5-1.8-4.5-3.3-6.6-4.8-.3.4-.4.6-.6.8zM744 261.5c1.5-.7 2.7-1.2 4.1-1.8-2-1.2-3.6-2.1-5.1-3l-.6.6c.4 1.3.9 2.5 1.6 4.2zm-94.8-78.1h4.1c0-.6.2-1.6-.1-1.7-1.2-.7-2.5-1.1-4-1.7v3.4zm226.7 162.1c0-3.3-1.5-5.3-4.3-7.2.7 3.1 1.5 5.5 4.3 7.2zM154.1 793.6c.9-.9 1.8-1.8 3-2.9-.6-.5-1.5-1.3-2.3-1.9-2.5 1.4-2.6 3.1-.7 4.8zm654.3-559.4c-2.1-2.1-4.2-4.3-6.2-6.4l-.6.6c1.3 2.8 4 4.4 6.8 5.8zm60.3 100.4c.1-2.5-1.5-4.1-3.9-6 .9 2.8 1.6 4.9 2.4 7.5.4-.5 1.5-1 1.5-1.5zM105.9 708.2v3.6c1.6-.6 2.9-1.1 4.2-1.8.1-.1 0-1.2-.2-1.2-1.3-.3-2.6-.5-4-.6zm51.9 83.5c.1 1.9.1 2.7.2 4 1.7-.9 4.2.3 4.1-2.2 0-.6-2.4-1.1-4.3-1.8zm327-659c-.5 0-.9.8-1.3 1.2.5.4 1 1.1 1.4 1 1.7-.3 3.3-.7 5-1.1-.1-.4-.1-.7-.2-1.1-1.7-.1-3.3-.2-4.9 0zm349.6 673.1c-1.8-1.6-2.8-.7-3.6.7-.7 1.3-1.3 2.6.3 3.5 1.3-1.5 2.3-2.8 3.3-4.2zm81.7-346.6c1.3 1.8 2.5 3.5 3.8 5.2.5-4.2-1.3-6.4-3.8-5.2zM164.5 798.7c1.2 3.4 2.8 4.4 6 3-2.9-.3-3.1-3.8-6-3zm658.1-507.4c-.2.1-.4.2-.7.3l-.3 4.2h4c-1.2-1.8-2.1-3.1-3-4.5zm-84.5 627.8c0 1.6-.3 3.2.1 4.6.2.6 1.8.8 3.5 1.5-1.3-2.5-2.1-4.3-3-6.1h-.6zM620 957.2c2.3-.7 2.8-1.9 1.9-4.7-2.6.6-2.9 1.2-1.9 4.7zm131.2-658.4v-3.7h-2.9c-.9 2.5.5 3.4 2.9 3.7zM112.3 714.9c1.6 3.4 2.8 4 5.7 3-1.8-1.3-3.5-2.5-5.1-3.7-.2.2-.4.5-.6.7zm529.5 234.4c.2.2.5.4.7.6 1.3-1 2.6-2 4.2-3.3-.7-.7-1.2-1.3-1.9-1.9-1.1 1.7-2.1 3.2-3 4.6zm186.1-135.5c0-.7-.7-1.4-1.1-2.1-.3.1-.7.3-1 .4-.3 1.4-.5 2.9-.8 4.4 2.3 0 2.9-1.3 2.9-2.7zm-706-69.1c-.6.9-1.1 1.9-1.7 2.8.9.4 1.9.8 3.4 1.4-.3-1.8-.4-2.9-.6-3.9-.3-.2-.7-.2-1.1-.3zm17.1 13.9c.8-1.4 1.4-2.3 2.3-3.8-1.8-.2-3.2-.4-4.4-.6.7 1.5 1.3 2.7 2.1 4.4zm668.3 85 .6.9c1.9-1.1 3.8-2.3 5.7-3.4-.2-.4-.5-.7-.7-1.1-1.8 1.2-3.7 2.4-5.6 3.6zm-633.2-14.9c-.6.9-1.2 1.8-1.9 2.8.9.5 1.7.9 3.3 1.8-.2-1.9-.2-3-.3-4.1-.3-.3-.7-.4-1.1-.5zM771.3 884c1.9 1.1 3.3 1.3 4.5-.5-.9-.7-1.7-1.3-2.5-2-.6.8-1.2 1.5-2 2.5zm-104.5 76.7c.1-.3.2-.5.3-.8-2.3-2.4-2.6-2.5-5.2-1 1.6.6 3.2 1.2 4.9 1.8zM195.4 844.1c.3.3.6.7.9 1 1.7-1.3 3.3-2.7 5-4-.2-.3-.4-.5-.7-.8-1.7 1.3-3.5 2.6-5.2 3.8zM831 819.2c.3 1.1.5 2.1.8 3.2 1.1-.1 2-.2 2.8-.3l.6-.6c-1.1-1-2.2-1.9-3.3-2.9-.3.3-.6.4-.9.6zM677.6 955.9c1.3 2.3 1.7 2.4 3.9 1.1-.4-.7-.7-1.5-1.1-2.3-1.1.5-1.9.8-2.8 1.2zm-62.2 2c.9 1.1 1.6 2 2.3 2.9.3-.2.7-.4 1-.6-.2-1.2-.5-2.4-.7-3.8-1 .6-1.7 1-2.6 1.5zM173.3 810.1c.1 1.2.2 2.4.2 3.6 1.3-.2 2.3-.3 3.3-.4-1.1-1.3-2-2.4-3-3.5-.1.1-.3.2-.5.3zm603.1 82.4c.2.2.3.4.5.5.9-.1 1.8-.2 3.5-.3-.8-1.3-1.3-2.1-1.7-2.9-.7.9-1.5 1.8-2.3 2.7zM121.2 726.1c.1 1.2.2 2.3.3 3.5 1.2-.2 2.1-.3 3.2-.4-1-1.3-1.9-2.4-2.8-3.5-.3.1-.5.3-.7.4zm542.9 245c-.4.4.1 1.5.1 2.3.3.1.5.2.8.3.7-.8 1.4-1.6 2.2-2.4-.2-.3-.4-.6-.5-.9-.9.2-2 .2-2.6.7zm207.6-237.7c.4.3 1.2.8 1.3.7.7-.8 1.2-1.6 1.8-2.5-.5-.3-.9-.6-1.4-.9-.6.9-1.1 1.8-1.7 2.7zm-245 223.7c.3.1.7.2 1 .4.5-1 1.1-2 1.4-3 .1-.3-.7-.9-1.4-1.7-.4 1.9-.7 3.1-1 4.3zm214.1-162c1.3-.8 2.2-1.3 3.6-2.2-1.5-.5-2.5-.8-3.6-1.1v3.3zm-718.9-70.8c1.5.9 2.6 1.6 4.1 2.5-.8-3-1.5-3.5-4.1-2.5zM665.2 966c-1.4-.1-2.8-.2-4.1-.3 2.1 2.3 2.8 2.3 4.1.3zm212.9-220.5c.4.1 1.1.5 1.3.3.7-.6 1.3-1.4 1.9-2.2-.4-.3-.8-.5-1.1-.8-.7 1-1.4 1.9-2.1 2.7zm-732.6 47.9c-.1.3-.3.6-.4.9 1.2.4 2.4.8 4 1.4-.5-2.6-2-2.6-3.6-2.3zm516.6 158.5c-1.3.7-2.5 1.4-3.8 2.1.2.3.4.7.7 1 1.2-.7 2.5-1.5 3.7-2.2l-.6-.9zm-417.4-74.3c-.3 1.1-.5 2.2-.8 3.3.3.2.6.3.9.5.4-.8 1.1-1.5 1.2-2.3.1-.5-.5-1.1-.8-1.7-.2.1-.4.2-.5.2zM136.4 771.7c.2.7 1.2 1.1 2.1 1.9-.4-1.7-.7-2.8-1.2-4.6-.5 1.2-1.1 2-.9 2.7zm496 177.3c-1.4.5-2.7 1-4.6 1.7 3.3 1.2 4.1.8 4.6-1.7zM93.1 710.3l3.6 1.2c.2-.3.3-.7.5-1-1.1-.5-2.3-1-3.4-1.6-.3.5-.5.9-.7 1.4zm84.5 100.1c.2-.2.4-.4.6-.5-.6-.7-1-1.5-1.7-1.9-.5-.3-1.4.1-2.7.2 1.4 1 2.1 1.5 2.9 2 .2.1.6.1.9.2zm629.7 27.4c-.9 1-1.6 1.8-2.3 2.6 3 .4 3.3 0 2.3-2.6zM597 964.8c.2.3.5.6.7.9 1.2-.8 2.3-1.7 3.5-2.5-.3-.3-.5-.6-.8-.9-1.2.8-2.3 1.6-3.4 2.5zm-510.7-297h.7c.2-1.4.5-2.7.7-4.1-.5 0-.9-.1-1.4-.1v4.2zm589 214.4c-1.2.4-2.1 1.9-3.1 2.9l.5.5c.9-.7 1.7-1.4 2.5-2 1.1.6 1.9 1 2.8 1.5.1-2.4-1.3-3.3-2.7-2.9zm15.9-11.6c.2.9.9 1.7 1.5 2.6.3-.1.5-.2.8-.3l.3-3c-.2-.2-.4-.4-.7-.6-.7.5-2 1.1-1.9 1.3zm-23.4 15.9c.7 0 1.3-.1 2-.1v-2.7c-1.2-.2-2.3-.4-3.6-.7.6 1.3 1 2.3 1.6 3.5zm12.2-8c-2 .2-2.4.7-2.3 3.2 1.9-1.3 3.7-2.6 5.2-3.6-.9-1.1-1.6-2.1-2.5-3.2-2.4.8-.2 2.4-.4 3.6z"/>',
            $gradID);
        }
        $mask = '<path d="M83.1 120.7c-.5 1.6-1.5 2.7-2.2 4-1.3 2.2-.7 3.6 1.8 3.7 2.5.1 5.2-.2 7.5-1.1 3.1-1.2 5.8-3.2 8.7-4.8 1.6-.8 3.3-1.4 4.9-2.2.2.3.5.6.7.9-3.8 3.7-7.7 7.3-11.5 11 3.4 4.1 8.1 5.1 12.8 2.1 2.7-1.8 5.3-4 7.4-6.5 9.6-11.6 20.4-22.3 31.6-32.5 12.6-11.6 25.9-22.5 41-31.2.8-.4 1.3-1.2 1.9-1.9 2.2-2.6 4.1-5.5 6.7-7.7 3.9-3.3 8.4-6 12.5-9.2 2.1-1.6 3.8-3.7 5.7-5.5-.2-.2-.3-.4-.5-.6-1 .3-2.2.3-3.1.8-3.8 2.1-7.5 4.3-11.2 6.5l-8.4 5.1-.5-.5c.3-1.8.6-3.6 1.1-6.1-2.3 1.4-4.2 2.6-6.1 3.7-1.9 1.2-3.9 2.2-7 1.6 1.3-1.7 2.3-3.1 3.5-4.3 2-2 4.3-3.8 6.3-5.8 2.4-2.5 2.9-5.4 1.5-8.5-6.2-.4-10.3.9-15.9 5-3.9 2.9-7.7 5.9-11.7 8.6-4 2.6-4.1 2.4-7.8-.6-1.3-1.1-2.7-2.1-4.5-.5-7.2 6.3-15.4 11.1-24 15.3-.7.4-1.3 1.3-1.6 2.1-1 2.6-1.3 5.8-3 7.9-3 3.6-6.5 7.1-10.4 9.8C104 83 98.4 85.9 92.8 89c-9.7 5.3-19.8 10.2-28.4 17.1-2.6 2-4.9 4.3-7.4 6.4v.5c3.1 1.1 5.4-.5 7.9-2 .9-.5 2.2-.5 3.3-.7.2 1.2.7 2.4.5 3.5-.1.9-.8 1.8-1.4 2.6-.8 1.1-1.9 2-2.4 3.2-.6 1.6-1.6 4-.9 5 .9 1.2 3.5 1.9 5.2 1.7 2.5-.2 4.9-1.3 7.3-2.3 2.3-.9 4.4-2.2 6.6-3.3zm557.4 38.1c-.6-3.7-1.8-6.6-6.6-6.3-1.2.1-2.5-.5-3.8-.7-1.8-.2-3.7-.3-4.8-.4-1 2.6-1.8 4.5-2.5 6.5 5.6.8 6.2 1.2 8 5.5 4.1-1.5 7.5 0 10.8 2.3-.2.4-.3.7-.4.9-.4.8-.7 1.7-1.1 2.5.9.3 1.8.7 2.8.7 14.5.5 28.6 3 42.3 7.7 3 1 3.1 1 2.9-2.2 2.3.4 4.6.7 6.8 1.1 2.3.4 4.6 1 7 1.5.2-2.9-3.4-1.7-4.3-3.9 1.3.1 2.4.3 3.5.1.7-.1 1.3-.7 2-1.1-.5-.6-.8-1.5-1.4-1.7-2.3-.8-4.7-1.2-6.9-1.9-1.1-.4-1.9-1.2-3.3-2.1 4 0 7.2.1 10.4 0s6.3-.5 9.6-.7c-3.3-6.6-20.8-9.2-29.4-6 0 .3-.1.6-.1.9-.1 4-.7 4.3-4.8 3.5-8.4-1.6-16.7-3.3-25.1-4.5-3.6-.5-7.3-.1-10.9-.1-.5-.8-.6-1.2-.7-1.6zm35.3 27.2c21 4.5 42.1 9.1 63.4 13.7-8.9-4.6-17.4-9.4-26.3-13.4-5.5-2.4-11.5-4-17.4-5.1-7.2-1.3-13.8.5-19.7 4.8z"/>
                <path d="M930.7 537.3c-.4-1.4-.1-2.9-.1-4.6 1 .6 1.5 1 2 1.3-3.7-5.7-6.2-11.6-6.3-18.3 0-1.4-.3-2.8-.6-4.1-.7-2.5-1.8-3-4.4-2.4-1.4.3-2.8.6-4.4.9-7.1-25.4-16.9-49.7-29.2-72.7.4.5.9 1 1.3 1.4.4-.7 1.2-1.7 1-2.1-1.1-2.2-2.4-4.3-3.7-6.4-.4 1.3-.7 2.2-.8 2.9-2.8-5-5.6-10-8.6-14.8.7 1 1.4 1.9 2.1 2.9 1.4 1.9 2.9 3.7 4.4 5.5.2-.1.4-.3.6-.4-1.9-7.2-5.1-11.2-9-11.1-14.3-22.8-31.1-44-50.1-63.3.9 0 1.9-.1 2.9-.4.8-.2 2-1 2-1.3-.1-.8-.7-1.8-1.5-2.4-1-.7-2.3-1.1-3.5-1.7.5-1.2.9-2.3 1.3-3.5 4.9 3.2 9.8 6.2 14.5 9.3 3.8 2.6 7.6 5.2 11 8.1 2.5 2.2 4.4 4.9 6.6 7.5-.2.1-.4.3-.6.4-3-1.3-4-5.9-8.4-4.8-.2.3-.4.5-.6.8 2.5 2.3 5.1 4.6 7.6 6.9 3.3 2.9 6.6 5.8 9.8 8.8.6.5 1.3 1.7 1.1 2-2 3.3.5 5.2 2.1 7.4 1.3 1.9 2.9 3.8 3.5 5.9.5 1.9 1.3 2.8 3.2 3.2 3.4.7 7 1.2 7.5 5.5.1.5.6 1 1.1 1.4 1.2 1 2.4 1.9 4.1.5-1.6-3.8-3.2-7.7-4.8-11.4-3.6-8.4-8.2-16-18.2-19 1.9-3.2.4-5.2-2-7.2-2.1-1.7-4.6-3.4-5.7-5.6-1.5-3.1-3.9-5.3-6.3-7.6l-8.4-8.4c-8.8-8.7-17.7-17.3-28.3-24.1-5.4-3.4-11-6.3-17.4-7.9-.8 3.5-3.2 4.8-6.1 3-2.7-1.7-5.1-3.7-7.9-5.9-1.3.8-2.7 1-4.2.8-8.5-6.3-17.2-12.3-26.2-17.9 7.6 2 13.9 7.7 22.6 7.3-6-3.2-11.8-6.2-17.8-9.4-.4 2.2-1.7 1.7-3.2 1.1-.8-.3-1.7-.2-2.6-.3 0 .2 0 .5-.1.7-3.6-2.2-7.2-4.4-10.8-6.5-.9-.6-1.9-1.2-2.9-1.7-11.2-6.3-22.7-12.1-34.6-17.4.8.1 1.5.1 2.3.2-1.2-.8-2.1-1.4-3.1-2.1.5-.3.7-.4.8-.4.6 0 1.2 0 1.8.2 6.2 1.8 12.3 3.6 18.5 5.4.6.2 1.7.4 1.9.2.9-1.5 1.7-.8 2.7-.1.9.6 1.9 1.2 3 1.9-.1.2-.4.7-.8 1.5 8.4 3.8 16.8 7.5 25.6 11.5.2-1.4.3-1.9.4-2.7 10.5 5.2 20.7 10.4 31.7 15.9-.6-1.2-1-2-1.2-2.8-.2-.9-.2-1.9-.3-2.9.9.1 2 0 2.7.4 1.5.8 2.9 1.8 4.3 2.7 1.7.9 3.4 1.7 5.1 2.6-.4-1.4-1-2.5-1.9-3.3-4.3-3.8-8.6-7.6-12.9-11.3-6.3-5.4-11.9-11.2-10.2-20.1-17-7.4-28.5-13.8-32.6-18.2 2.7 1.1 4.9 2.2 7.2 3 2.3.8 4.8 1.3 7.2 2v-.4c-1.3-1.1-2.6-2.1-3.8-3.2.4-.5.7-.9 1.1-1.4 13.5 6 27 12 40.5 18.1.3-.3.6-.7.8-1-3.9-4.8-7.9-9.6-11.9-14.5.2-.2.9-.6 1.6-1.1-6.6-5.4-13.8-11.3-17.5-11.6-1.6 3.1 2.3 4.1 3 6.8-.9-.4-1.5-.7-2.1-1-7.9-3.8-15.5-8.1-23.6-11.2-22.6-8.8-45.4-17.2-68.1-25.7-2.6-1-5.7-1.3-5.5-4.9-3.1.5-5.8.9-8.3 1.2-2.5-.9-4.9-1.8-7.3-2.7-.1-.2-.1-.4-.2-.6 4.2-1.3 8.4-2.6 12.5-3.9 3 3.3 6.3 3.9 9.6 1.4-4.7-1.2-8.9-2.3-12.8-3.3.8-.7 2.3-1.5 2.2-2.2-.1-.8-1.3-2-2.3-2.3-3.5-1.1-7-2.4-10.6-2.7-4.7-.4-9.5.2-14.2.3-5.4 0-10.5-.8-14.5-4.8-.6-.6-1.7-.8-2.6-.9-3.1-.3-6.2-.5-9.3-.5-3.4 0-6.7.3-10.1.3-3.2 0-6.3-.5-8.4-3.1-1-1.3-2.1-1.4-3.5-1.3-2 .1-4.1 0-6.5 0 2.5-2.8 4.5-3.2 13-2.6.5-3.1 1.2-3.6 4.5-3.6.9 0 1.9.2 2.8.3l10.8.9c.2 0 .4-.2.5-.4-.3-.6-.7-1.2-1.1-2 6.3 1.4 7.5 1.4 9.8-.8-5.5-.8-10.6-1.5-15.6-2.2.1-1.1.2-2.2.4-4-4.1 2.6-7.8 2-11.5 1.4-2.9-.5-5.4-.5-6.1 2.7-3.7-.7-7.2-1.3-10.6-1.9-3.5-.6-6.9-1.4-9.7-3.8.7-1.2 1.4-2.3 2.4-4 .9 3.4 2.9 3.9 5.4 3.2 3.6-.9 7.3-1.9 11.2-2.9-1-.4-1.9-.9-2.7-1.1-2.7-.4-5.5-.8-8.2-1-3.7-.3-7-1.3-9.2-4.7 7.3.6 7.4.6 8.2-2.2-8-2.9-18-1-20.2 3.6 1.2.6 2.5 1.2 3.7 1.7l-.3.9c-1.7 0-3.4.2-5.1-.1-.6-.1-1.5-1-1.6-1.7-.5-2.9-.7-3.1-4.5-2.2.8 1.1 1.5 2 2.3 3.1-3.5 1.4-7 2.8-10.2 4.1 1.9 1 3.6 1.7 5.1 2.8 1.6 1.2 3.2 1.8 5.2 1.2.7-4.2.8-4.4 2.8-4.2 2.3.2 3.6 2.1 3.5 5.1-.5 0-1.1-.1-1.5.2-.9.6-1.6 1.4-2.5 2.1.7.6 1.4 1.6 2.2 1.8 2.4.5 4.9 1 7.4 1.1 6 .3 12.1.2 18.1.6 2.7.2 5.3 1.3 7.9 1.9-.1.4-.2.7-.2 1.1-5-.2-10.1-.4-15.3-.7-2.4 4.5-7.1 1.8-10.9 2.6 0-1.5 1.1-3.3-1.6-3.1-6.9.5-13.8 1-20.7 1.4-1.6.1-3.6.4-4.9-.3-1.3-.6-1.9-2.4-2.8-3.7-7.1 4.3-15.4 5-19.5 1.7.9-.5 2.2-.9 2.6-1.7.3-.6-.6-1.7-1.1-2.8 8.2.7 16.1.8 24.3-1.1-1.8-1.8-3.8-2-5.9-1.6-2.5.5-5 1.2-7.6 1.5-1.6.2-3.3-.2-4.9-.4v-.9c1.4-.3 2.8-.4 4.1-.8.8-.3 1.4-1 2-1.5-.7-.5-1.4-1.3-2.2-1.4-1.8-.2-3.6-.1-5.3-.1-.9 3.6-.9 3.6-4.8 3.3-1-.1-2.1 0-3.4 0 .5 1.6.9 2.7 1.3 3.7-2.3.7-4.3 1.4-6.4 2-3.2 1-4.4.6-5.1-1.5 6.9-.3 9.7-3.1 8.8-6.6-2.2-.2-4.5-.4-6.8-.6.5-.7 1-1.4 1.5-2.2-6.8-2.6-15.3-1.6-17.7 2.4 1.8.1 3.4.2 4.9.2 1.8 0 3.6-.3 5.4-.3 1.6.1 2.7.8 2.6 2.9h-8.2v5c.2.1.4.2.7.3.8-.9 1.4-1.9 2.3-2.5.7-.5 1.8-.9 2.7-.8.4.1 1.1 1.7.8 2.1-.8 1.1-1.9 2.2-3.2 2.7-1.8.7-3.8.7-6 1.1-.2-.9-.4-1.8-.5-2.5-2.2.1-4.3.6-6.3.2-1.7-.3-2.7-.1-3.9.9-6 5.1-11.9 10.2-18 15.3-.7.6-1.7 1.2-2.6 1.3-6.2 1.1-12.5 1.9-18.6 3.1-16.5 3.2-32.5 7.8-46.6 17-.4.3-1 .7-1.3.6-4.3-.8-7.4 1.5-10.7 3.5-1.6 1-3.5 1.4-5.8-.5 4.9-2.2 9.5-4.2 14.2-6.3-.8-1.7.4-2.7 2-3.4 1.4-.5 2.8-.9 4.1-1.6 1.2-.6 2.2-1.5 3.3-2.3-.1-.2-.3-.4-.4-.6-10 1.4-19.6 4.2-28.9 7.5-.4-1.5-.6-2.9-1.1-4.1-.6-1.5 0-2.2 1.5-2.7 5.1-1.8 10.2-3.7 15.2-5.5 3.2-1.2 6.4-2.3 9-3.3 1.5 1.5 2.6 2.9 4 3.9 1.5 1.1 3.2 2 1.5 4.6 2.3-1.6 2.5-2 2.6-4.9.1-3.6.6-4 4.1-4.1 1-3-2.8-1-3.1-2.9 12.5-2.5 24.6-6.3 36.2-11.3-13.9 1.9-27.4 6.3-42.4 4 7-1.8 13.3-3.3 19.6-4.9 0-.2-.1-.4-.1-.6-3.6-.5-7.6 1.5-11.4-1 1.8-.6 3.2-1 4.8-1.5-1.7-2.7-5.9-1.1-6.8-4.3 3.7-.8 7.4-1.3 10.9-2.3 8.2-2.2 16.2-5.2 25-5 2.5.1 3.9-1.8 5-4-4.8-1-4.8-1-4.1-3.9 8.7.7 15.8-4.2 23.9-6.2-.7-.8-1.3-1.4-2.3-2.5 5-1.4 9.4-3.2 14-4 14.7-2.4 29.5-4.3 44.3-6.5 5.5-.8 10.9-2.1 16.3-3.2-6.7-2.8-6.7-2.8-6.1-6.1 1.9 0 3.9.1 5.9 0 1.9-.1 3.7-.2 5.6-.4v-.8c-15.6-5.3-32-6.9-48.2-9.8 3-2.8 7.2-.6 10.5-2.4-.6-.6-1-1-1.6-1.5 2.4-.5 4.5-1 6.2-1.3-3.2-1.2-6.7-2.4-10-3.9-4.2-1.9-8.3-4.2-12.5.2-.6-.9-1-1.4-1.3-2-1.9-4.1-2.1-4.2-6.5-2.4-2.6 1-5.1 1.7-8.2 1 1.3-2.4 0-3-2.1-3.3-1.6-.2-3.1-.8-4.6-1.2.1-.2.1-.5.2-.7l5.1-2.7c-.1-.3-.1-.6-.2-.9-3.5-.6-6.9-1.5-10.4-1.7-7.8-.5-15.5-.7-23.3-1.1-2.3-.1-4.7-.6-7.1-.9.9-1.9 1.6-3.5 2.4-5.2-2.4-.5-4.2-1.2-6-1.1-17.8 1.4-35.7 2.7-53.4 4.6-17.2 1.8-34.2 4.6-51.4 6.5-15.6 1.7-30.8 4.8-45.6 9.8-11.9 4-23.9 7.8-36.6 8.4-1.5.1-1.9.9-1.6 2.2.1.6.3 1.2.4 2-.9-.1-1.6.1-2-.2-2.1-1.2-4.1-.7-6.2.2-3.7 1.5-7.5 2.9-11.2 4.6-16.7 7.8-31.6 18.1-45.7 29.6-3.6 2.9-7.2 5.7-11.4 6-1 1.6-1.4 3.2-2.5 3.9-7.9 5.4-16.2 10.3-24 15.9-7.3 5.2-13.3 11.6-16.5 19.8-1.1 2.7-1.7 5.7-2.5 8.5.3.1.5.3.8.4 1.4-.8 2.6-1.9 4.1-2.3 1.3-.4 2.8-.1 4.5-.1 1.2-3.6 3.2-5.1 7-4.7-4.1 7.1-3.3 13.7 2.1 19.8 3.2 3.5 3.9 3.6 8.4 1.7 1.4-.6 2.9-1.3 4.6.7-2.8 2.7-5.5 5.4-8 7.9-.7 1.8-1.3 3.4-1.9 5 .2.1.4.2.5.3.6-.6 1.2-1.2 1.9-1.8 3.5-3.3 6.9-6.6 10.5-9.8 1.5-1.3 3.1-.9 3.7 1 .3.8.2 1.8.2 2.7-.2 2.2.1 4.1 2.5 4.8-2.1 3-3.9 5.9-6 8.6-1.9 2.5-4.2 4.7-6.3 7.1-.7.9-1.6 1.9-1.7 3-.6 6-2.9 11.2-7.2 15.4-3.6 3.6-7.6 6.7-11.3 10.1-4.4 4-8.9 8-13.1 12.2-2.7 2.8-2.4 3 .2 5.7-.5.9-1.3 1.7-1.6 2.7-1 3.3-1.9 6.6-2.6 9.9-.3 1.3.5 2.3 2.2 1.5 1.9-.8 2.3.1 2.3 1.6 0 2.9.4 5.8-.1 8.6-.6 4.3 1.7 6.4 5.4 7.8 1.5.6 3.1 1.2 4.7 1.5 3.8.8 7.7 1.3 11.5 2 4.3.8 8.5 1.8 11.6 2.5 1 4.2 1.5 7.4 2.5 10.4 1.7 5.4 1.5 6.4-3 9.5 3.3 1.8 5.2 1.4 7.8-2.1 1.4 1 3.4 1.7 2.4 3.9-3.5 7.6-7.5 15-14.1 20.7-1.8 1.6-3.9 2.9-5.9 4.4-.3-.2-.6-.5-.9-.7l5.1-9-.6-.3c-.4.3-.8.6-1.1.9-3.4 3.8-6.8 7.6-10.1 11.5-5.3 6.2-10.5 12.3-15.8 18.5-.4.5-.7 1.1-.9 1.7-1.7 4.8-3.2 9.7-5 14.5-5.1 13.8-10.6 27.5-11.3 42.5-.2 3.7-1.6 7-4.7 9.6-.5.4-.6 1.2-.8 1.9-.6 2.8-1 5.6-1.9 8.3-1.1 3.4-2.8 6.7-4 10.1-.8 2.4-1.2 4.9.1 7.5 1.4-1.2 2.6-2.6 4.2-3.4 2.2-1.2 3.3-2.4 1.6-4.7-.3-.4 0-1.2.1-2.3 1 .8 1.4 1.2 1.8 1.6.8-.4 1.5-.7 2.2-1 2.7 7.5 1.3 19.4-2.6 22.5-.5-.6-1-1.2-1.7-2-2.5 3.9-3.1 7.8-2.6 11.7 1.6-.4 3-.8 4.7-1.3.1 6.6-.8 12.8 3.6 18.4-3.1.2-4.3 1.6-3.4 4 .7 1.9 2.3 2.7 4.3 2.5.6-.1 1.7-1.3 1.6-1.6-1.5-3.1.4-5.3 1.8-7.7.5-.8 1.7-1.3 2.5-1.9-.7 4.1-1.5 7.7-1.9 11.4-.4 4.6-.4 9.2-.8 13.7-.1 1.5-.9 2.9-1.4 4.4-.1-.1-.2-.1-.4-.2-.6-3.3-1.1-6.7-1.7-10.2-1.8.4-3.3.9-4.8 1.1-4 .5-5.4 1.3-6.2 5.1-.6 3-.6 6.2-.8 9.3-.3 5.6.1 11.3-5.6 15 1.1.8 2 1.4 3.1 2.2-2.2.8-3.9 1.4-5.6 2 2.1 5.4 1.9 10.7 1.4 16.1-.1.6.3 1.3.4 2 .6-.4 1.2-.8 1.8-1.3.4-.3.8-.7 1.3-1 .3.5.9 1 .9 1.5-.1 1.7-.5 3.4-.7 5.1-.2 1.7-.4 3.3-.6 5.5 3-.4 5.4-.8 7.8-1.1 1.4 5.1-3.7 10.2.2 15.4.7-.9 1.1-1.7 1.8-2.3 2.1-1.9 4.1-4 6.4-5.7 1.8-1.3 3.8-1.1 5.8.6-5.1 2.7-6.3 7.1-6.4 11.9 0 .6.5 1.2.8 1.8.5-.5 1.2-1 1.6-1.6.3-.4.1-1 .3-1.4.5-.8 1.2-2.3 1.6-2.3 1.4.1 3.1.6 4.1 1.5.5.4 0 2.2-.5 3.2s-1.7 1.6-2.5 2.5c-1.4 1.5-.7 2.8 1.1 3.5 1.4.6 3.2 1.6 3.4 2.8.5 2.4.4 5 .1 7.4-.1.9-1.3 1.7-2 2.5-.4-.8-.8-1.6-1.3-2.3-.3-.4-.8-.7-1.1-1.1-.3.4-.8.7-1 1.1-.7 1.4-1.3 2.8-1.9 4.1-.6 1.3-1.2 2.6-1.9 4 4.2.4 7.9.7 11.6 1 2.4-4 3.3-4.5 5.6-3.8 1.5 3.2 2.6 5.9 4 8.4 1.9 3.5 1.8 4.7-.7 7.7-1.1 1.4-1.9 3.2-2.4 5-.5 1.6-.3 3.4-.4 4.7 1.9.2 4.1.4 6.2.6 1.7.2 4.4-.7 3.4 2.7 0 .1.3.4.4.6 2.8 3.3 4 7 3.6 10.6.8 1.3 1.5 2.1 1.8 3 1.5 5.5 2.4 11.1 4.3 16.4 1.3 3.7 2.2 7.2 1.7 11.1-.1.8.6 1.7.9 2.5 1.4-1.2 2.3-2.1 2.7-2.5-.2-1.8-.5-3.2-.6-4.6 0-1.5.2-2.9.4-4.4.7-4.6 1.6-9.1 2.3-13.7.3-1.7 0-3.5.1-5.2 0-.7.2-1.4.3-2.1h2.8c1.5 2.4 2.8 4.5 3.9 6.4 2 .4 3.8.7 5.7 1 .4-1.4.2-2.2-1.5-2-2.7.4-3.6-1.1-3.8-3.2-.2-1.7-.3-3.4-.4-5.3 1.4-.7 2.8-1.5 4.3-2.3l.6.6c-1 1.1-1.9 2.3-3 3.5 1.3.6 2.3 1.1 3.8 1.9-1.5.4-2.3.6-3.2.9 1.2 2.5 3.1 2.2 5.5 1.9l.9 3.6c-.2.7-.4 1.4-.8 1.9-1.1 1.6-6.3.9-8-.5-2 4.4-2 4.4.5 6.1.9-.3 1.8-.8 2.7-.8 1.7-.1 2.7-.5 3.4-2.2.4-.9 1.7-1.5 2.8-2.2.2.6.3 1.2.5 1.7-.1.3-.2.6-.4.9-.9 1.8-.4 6.4.9 6.6 2.1.4 1.8 1.6 2 2.8.6 3.6 1.9 7.2 1.2 10.9-.1.5.5 1.2.8 1.7.4.7.9 1.3 1.1 2 1.9 6.9 3.6 13.9 7 20.4.1.2 0 .6 0 .8-1.7-.4-3.2-.7-4.7-1.1-.1.2-.3.4-.4.7l2.1 3.5c2.1-1 4.1-2 6.2-3.1.3.8.7 1.6 1 2.4-1.1.6-2 1.1-2.9 1.6.1.3.2.5.3.8.9.2 1.8.4 2.7.5.6.1 1 .2 1.4.4.2.5.4.9.6 1.4-.1.3-.3.7-.6 1.2-.4.7-.5 1.5-.8 2.8 1.1-.6 1.8-.9 2.6-1.3.8 1.8 1.7 3.7 2.6 5.5 0 .2.1.4.1.6.5 2.2.4 4.4.6 6.6-.2-.2-.5-.4-.7-.6-1.1 1.2-2.3 2.3-3.4 3.5 1.1 1 1.6 1.4 2.3 2 .9-1.3 1.6-3.4 2.5-3.5 1.3-.1 1.9-.6 2.3-1.2 1.4 2.7 2.8 5.5 4.3 8.2-.1.1-.2.2-.4.3-.1.1-.1.3 0 .1l1.4 1.4c4.4 7.9 9 15.7 13.9 23.3-.1.2-.2.3-.3.5.4.3.9.7 1.3 1.1 6.1 9.3 12.6 18.3 19.5 27-2-.6-4-1.2-5.9-1.7l-.7.7c.7 1 1.4 2.7 2.2 2.7 1.5.1 3.2-.7 4.8-1.1-.1-.1-.1-.3-.2-.4 1.8 2.2 3.6 4.5 5.4 6.6-1.4.6-1.8 1.7-1 3.6.7-.8 1.3-1.5 2.1-2.4.9 1.1 1.9 2.2 2.8 3.3-.1.1-.2.2-.3.4.3.2.7.5 1 .7 0 0 0-.1.1-.1 72.1 83.4 181.5 136.6 304.1 136.6 82.6 0 159.3-24.2 222.6-65.5-1.1.7-2.2 1.5-3.3 2.2.9.3 1.6.5 2.3.7-.1.3-.1.6-.2.9-1.1-.2-2.3-.4-3.4-.5-10 5.9-20.2 11.9-29.7 17.6 1.3 1.9 2.7 3.7 3.7 5.6 1.1 2.2 2 2.6 4.2 1.3.7-.4 1.3-1 2-1.5-.2 0-.4-.1-.6-.1v-4.5c3.5 2 2.8 5.9 4.4 8.6-.7 1.1-1.4 2.1-2.5 3.6-2-1.5-3.8-2.9-5.9-4.6-1.2 2.5-2.5 4.9-3.9 7.7-.5.1-1.8.3-3 .5 0 .2.1.4.1.7h3.4c-3.1 2.5-2.5 4.3.1 6 .9.6 1.1 2.1 1.6 3.3 
                    1.5-.8 3.1-1.6 4.7-2.4-.1-.2-.1-.5-.2-.7-.7-.2-1.4-.4-2.2-.6-1.4-.2-2-.8-2-2.3 0-3.2 3.3-5.4 6.5-4.3.7.2 1.6.2 2.2-.1 1.9-.7 3.6-1.7 4.8-2.2 1.2 1.3 2.1 2 2.8 2.9.5.6 1 1.6.7 2.2-.3.8-1.1 1.8-2.3.6-.3-.3-1.3 0-1.9.2-1 .2-1.9.5-3 .9.1-1 .1-1.7.1-2.3-.1 0-.2-.1-.4-.1l-.9 2.4c1.6.9 3.1 1.8 4.2 2.4 2-.8 3.6-1.5 5.3-2 2-.6 3-1.5 2.3-3.6-1-.1-1.8-.2-3-.3.4-1 .8-1.8 1.1-2.5-2.1-2.3-3.5-5.6-7.7-3.1-.9-4.5 3-3.9 5.3-5.1-1.1-2.6.3-4.5 2.3-6.3l.9.3c1.2.8 1.8 2.8 3.8 1.6 1.3-.7 2.5-1.7 3.6-2.7 1.2-1.3 2.1-2.7 3.3-4.2.6.5.9.8 1.3 1.1.6.6 1.2 1.2 1.7 1.8-.8.4-1.6.8-2.4 1.1-.9.3-2.3.3-2.6.8-1.6 2.8-2.8 5.8-4.2 8.7l.6.3c1-.7 2-1.3 3.3-2.2.3 2.1 2 3.9-.4 4.9-1.8-.4-3.3-.7-4.9-1-.2-1.1-.5-2.3-.7-3.2.7-1.2 1.2-2.1 1.7-3-.2-.3-.4-.5-.7-.8-1.9.6-3.8 1.2-5.7 1.7 0 .2-.1.4-.1.6 3.7 1.7 2.6 4.9 2.6 8 1.5-.5 2.6-.9 3.5-1.3 1.1.7 2.1 1.4 2.9 2 2.3-1.9 4.2-3.6 5.4-4.6-1.2-3-2-5.3-2.9-7.6.3-.2.6-.4.8-.6 1.8.6 3.6 1.3 5.7 2 .3-.7.8-1.7 1.2-2.6.2 0 .5-.1.7-.1.4.9.7 1.8 1.3 3.3 1.2-.7 2.3-1.4 3.7-2.2-2.9-2-3-2.3-2.4-4.8.1-.6.4-1.4.1-1.8-1.3-2.2-2.8-4.3-4-6.1-.6.4-1.3.9-2.1 1.4 0-.7.1-1.4.1-2.1-.7-.2-1.7-.6-2.6-.9 1.3-1 2.4-1.9 3.5-2.7 1.9 1.1 3.9 2.3 6.1 3.6.7-6.7 1.6-7 8.9-3.2 1.9-1.4 3.6-2.9 3-5.8-2.2.1-4.1.2-6.1.3-1.1.1-2.3.4-2.5-1.3-.2-1.4.1-2.4 1.8-2.6 2.6-.3 5.3-.7 8.5-1.2-.5-.7-1.1-2.3-1.9-2.3-1.7-.2-2.9-.4-3.8-2-.6-1.1-1.5-2.1-2.4-3.3 3.6-2.6 7.1-5.2 10.6-7.9-.1.6.1 1.3.4 2 .4 1 .3 2.1.4 3.8-2-.6-3.4-1-5-1.5-.3 1.2-.7 2.5-1.2 4.3 2.2-2.8 2.8-2.7 4.1.2.6-.1 1.3-.1 1.8-.2.3 1.4.6 2.7.8 3.5 2.2-.6 3.9-1.4 5.6-1.4 3.9.2 4 .3 5.8-3.5-2.4-.8-4.9-1.6-7.3-2.5l-.3.6 1 2c-1.6.2-3 .4-4.9.6 1.6-2.2 2.9-3.9 4-5.5-.2-1-.9-2.1-.5-2.9.4-.9 1.6-1.4 2.6-2.3-.5-.6-1.1-1.1-1.7-1.7.5-.4 1.1-.9 1.6-1.3-.1.5-.2 1.1-.2 1.8l3.4-1.7c.1 1.2.3 2 .1 2.8-.2 1.1-.9 2.2-1 3.3-.1.8.2 1.9.8 2.5 1.3 1.4 2.8 2.5 4.3 3.7.9.8 1.8 1.5 2.8 2.2.2-.1.4-.3.6-.4-.8-2.8-2-5.6-2.4-8.4-.4-2.7.2-5.5.3-8.5-1.2.4-2.1.8-3.1 1.1v-2.9c2.7-2.3 5.4-4.7 8.1-7 .8-.4 1.5-1 1.9-1.7.7-.6 1.4-1.3 2.1-1.9 1.4 3.6-3.3 3.4-4.3 5.7h5c.1.2.1.5.2.7-4-.2-5.3 2.2-6 5.3-.4 1.5-1.1 2.9-1.7 4.3.5.5 1 1.1 1.6 1.8.8-.2 1.7-.6 2.5-.5 1 .2 2 .7 3 1.1-.4.7-.8 1.3-1.1 2-.2.4-.3.9-.5 1.6 1.4.1 2.6.2 3.9.3-.4-2.7-.7-5-1.1-7.4 3.6-3.6 3.6-3.6 4.6-3.1-2.3 2.1-2.3 2.8-.7 3.6 1.1-1 2-1.8 3.1-2.8-.6-1.5-.2-2.6 1.7-3.4.7-.3.9-1.6 1.3-2.5-.2-.1-.5-.2-.7-.3-.7.6-1.4 1.1-2 1.6-1.4-1.6-2.6-3-3.9-4.5 2.7-.3 4.7-.5 6.1-.6 1.6 1.2 2.8 2 4.6 3.3-.3-3.7 2.2-2.2 3.8-2.9-1.3-.5-2.3-1-2.6-1.1.1-1.9.4-3.4.1-4.7-.3-1.6-1.1-3.1.3-4.6.3-.3-.3-1.4-.6-2.7-1.6 1.9-2.9 1.8-4.4.7-.4-.3-1.1-.4-1.7-.5l2.1-2.1c.8.5 1.5 1 2.2 1.5.4-1.2.7-2.1 1-3.1 1.2.5 2 .8 2.9 1.1-.2.2-.3.4-.5.5.4 1 .6 2.4 1.3 3 1.5 1.1 3 .4 4.5-1-2.6-.1-3.1-1.4-2.8-3.4.2-1.4 0-2.8 0-4.6-2.5 1.5-4.5 2.8-6.6 4 0-.1-.1-.1-.1-.2.8-.8 1.6-1.7 2.4-2.5 1.2-.5 1.7-1 1.5-1.6 1.8-1.9 3.6-3.8 5.3-5.7.3.4.6.7.8 1.1-.5 1.7-1 3.5-1.5 5.3-.7 3.1-.4 3.5 3 4.3 1.5-4 1.6-8 .2-11-.2-.5-.7-.9-1.3-1.2 1.4-1.5 2.7-3 4.1-4.6.1.1.2.2.3.2 1.1-1.2 2.1-2.4 3.5-4 .2 1.3.3 1.9.5 3 .9-.7 1.9-1.5 1.9-1.5-.6-.8-1.3-1.7-2.1-2.6 1-1.1 1.9-2.3 2.8-3.4 1.1-.2 2.2-1.4 3.4-1.8-.1.9-.2 1.5-.3 1.8.9.3 1.8.6 2.5.9.5-.7 1.1-1.4 1.7-2.3-4.4-1-1-3.8-1.6-5.8.5-.7 1.1-1.4 1.6-2.1 0 .3-.1.7-.1 1 .9-1.6 2-2.8 2.4-4 5-6.6 9.8-13.3 14.3-20.2.1.1.2.1.2.2.1-.4.3-.8.4-1.2 5.9-9 11.4-18.3 16.5-27.9h.7c0-.5 0-.9-.1-1.3 6-11.3 11.4-23 16.2-35h1.1c.1-.8.3-1.6.4-2.2-.1-.2-.3-.3-.4-.5 15.6-40.2 24.2-83.6 24.2-128.9 0-11.5-.6-22.9-1.6-34.2.4-2 .2-3.5-.5-4.5-1.8-16.4-4.7-32.5-8.7-48.2 1.8 4.5 4.4 8.8 8.2 12.5.7.7 1.1 2 1.1 3-.3 7.7 2.5 14.7 4.7 22.4 2.1-3.7 1.7-7.1.7-10.4-.2-1.3-1.5-4.2-2.3-7.2zM777.6 284.9c-2.1 1.3-2.1 1.3-12.3-2.4 3.5-2.4 8.9-1.3 12.3 2.4zm-21.3-9.4c-2.2-1.2-3.9-2-5.7-3 2.5-2.2 4.7-1.1 5.7 3zm-4.7.1c-5.3 1.1-7 .7-7.5-2 4.3-.7 6.5-.1 7.5 2zm-9.1-4.3c-.4 1.8-1.1 2.2-3 1.1-1.6-1-3.1-2.1-5-3.4 3 .8 5.5 1.5 8 2.3zm-346.6-94.7c-2.4 2.7-5.6 2.1-8.5 2.6.2-3 2.2-3.6 8.5-2.6zM86.8 508.2c.3-1.6.3-2.8.7-3.9.1-.5.9-.8 1.3-1.2.4.5 1 1 1.1 1.5.1 1.7-.6 3-3.1 3.6zm-.7 92.3c-1.5-.4-2.8-.6-4-.9.9-1.2 1.6-2.2 2.5-3.3.6.1 1.4.4 2.7.7-.4 1.1-.8 2.3-1.2 3.5zm4.2-17.5c-1.3 2.2-2.8 4.4-4.5 6.5-.7-4.1 1.5-7.2 3.4-10.6 2.3 1.2 2 2.7 1.1 4.1zm650.5 349.6c-.8 0-1.6.1-2.4.1-.6-1.4-1.2-2.6-1.8-4.1 1.5.3 2.8.5 4.2.8v3.2zm6.3-3.4c-.9.7-1.9 1.6-2.9 2.4-.2-.2-.4-.4-.6-.5 1.2-1.2 2.2-2.9 3.6-3.3 1.6-.5 3.3.7 3.2 3.2-1-.6-2.1-1.1-3.3-1.8zm2.8-1.9c-.1-3 .4-3.5 2.7-3.8.3-1.4-2.3-3.3.4-4.2 1 1.3 1.9 2.5 2.9 3.8-1.7 1.2-3.7 2.6-6 4.2zm153.7-400.8c5 3.1 3.5 8.2 5.4 12.4-2.6-1.8-5.2-7.9-5.4-12.4zm-16.2-91.4c0 .6-.2 1.3 0 1.8l-.9-1.8c.2.1.5.1.9 0zm-4.3 54.8c1.4 2.4 2.8 4.7 4.2 7.1-.2.1-.5.3-.7.4-2.9-1.6-3.2-4.5-4.1-7.2l.6-.3zm-19.8-61.4c2.4 5.2 4.7 10.3 7 15.4-1.6.4-2.3.3-3.1-1.4-1-1.9-1.6-3.9-2.5-5.8-.8-1.5-1.8-2.9-2.7-4.4-.2.1-.5.2-.7.3-.1.4-.3.7-.4 1.1-1.6-.7-.7-2.8 2.4-5.2zm-18.1-7.3c3.3 1 3.7 4 5 6.4 3.7 6.8 7.6 13.4 10.9 20.3 2 4.2 3 8.8 4.6 13.2.4 1.1 1 2.2 1.8 3.2.7 1 1.7 1.8.1 3.6-2.5-4.1-5.1-7.9-7.1-11.9-3.9-8-7.3-16.2-11.1-24.2-1.6-3.3-3.8-6.2-5.6-9.4-.3-.5-.2-1.2-.3-1.8.6.2 1.2.4 1.7.6zm2.7 261.3c1.4 1.4 1.4 2.9-.3 5.3-1.4-1.7-1.3-3.3.3-5.3zm-.2-182.5c2.8 2.9 6 12.4 5.5 16.3-4.7-1.7-7.3-9.3-5.5-16.3zm2.7 241.5c.3.2.7.4 1 .7-.5.6-1 1.3-1.6 1.9-.1.1-.7-.2-1.1-.3.6-.8 1.2-1.5 1.7-2.3zm.3-11.3c-1.1-2.1-.3-4.6 3-10.2 1.9 3.3.5 8.1-3 10.2zm3-203c-.8-.5-1-1.8-1.3-2.6 2-.3 3.4-.5 5.5-.8-.5 1.1-.7 2.3-1.4 2.8s-2.3 1-2.8.6zm-13.5-99.4c3.1 1.9 5.1 4.2 5.6 7.8-2.6-2.1-6.1-3.5-5.6-7.8zm0 41c1.1.6 2.1.9 2.3 1.4.4 1 .4 2.1.4 3.1 0 .2-1.3.6-1.4.6-.5-.8-1.1-1.7-1.4-2.6-.2-.6 0-1.3.1-2.5zm1.4 12.7c1.9 5.3 3.8 10.6 5.7 15.8l-.9.3c-2.5-3.9-5.8-7.5-6.5-12.3-.2-1.5.2-2.9 1.7-3.8zm-3.1 28c1.4-1 4.7.1 5.3 1.6.8 2 1.4 4.1 2.1 6.1-.2.1-.5.2-.7.4-.6-.8-1.5-1.6-1.8-2.5-.8-2.5-1.5-4.9-5.6-3.8.4-1 .4-1.6.7-1.8zm6.2 216.6c-.1.5-.2 1.2-.3 1.9h-2.7v-5.6c.2-.1.4-.1.6-.2.3.7.6 1.4 1 2.1.3.7.9 1.2 1.4 1.8zm-83.2 118c-.3 2.6-1.7 3.8-4.2 4.4 1.5-1.6 2.7-2.9 4.2-4.4zm53.6-384.8c-2.2-2.4-4.3-4.3-6-6.5-.4-.5.4-1.9 1-2.9 1.8 3 5.4 5 5 9.4zm.1 321h.4l-1.3 3.9c-.7-.6-1.3-1-1.9-1.5 1-.9 1.9-1.6 2.8-2.4zm-40.9-359c3 1.3 1.9 4.5 3.5 6.9-4.6-2.1-5.7-4.4-3.5-6.9zm8.1 408.4c.4-1.6.8-3.1 1.2-4.6-.4-.5-.8-1-1.1-1.6-.1-.1.8-.9 1-.8.6.2 1.2.7 1.5 1.2 1.2 2.6 1.1 6.1-.2 9.5-2.7-.7-3-1-2.4-3.7zm3.4-4.3c.6-.7 1.2-1.4 2-2.2.8 2.2.6 2.5-2 2.2zm2 2.7c1.6-1 3.2-2.1 4.8-3.1l.6.9c-1.6 1-3.3 2-4.9 2.9-.2-.2-.3-.4-.5-.7zm3.4-9.7c-.2-.9-.3-1.5-.5-2.6-1.2 1.3-2.1 2.4-3 3.4-.1-.1-.3-.2-.4-.3.3-.4.5-.8.8-1.3-.4-.4-.8-.7-1.3-1.2.8-1 1.6-1.9 2.7-3.3 1.3 1.5 2.3 2.7 3.3 4 .1 0-.8.7-1.6 1.3zm9.2-18.5c.3-1.3 1-2.6 1.4-3.7.1 1.7.5 3.3.2 4.8-.2 1.2-1.3 2.3-2.2 3.9.3-2.2.3-3.6.6-5zm3.3 1.1.9-.3c.3.6 1 1.2.9 1.8-.1 1.2-.5 2.3-2.5 2.3.3-1.4.5-2.6.7-3.8zm4.3-4.8c.7-1.3 1.6-2 3.1-.6-.9 1.2-1.8 2.3-2.9 3.7-1.3-.9-.8-2-.2-3.1zm.2 10.9c.3-.2.5-.3.8-.5 1 .8 1.9 1.7 2.9 2.5l-.5.5c-.7.1-1.4.1-2.4.2-.4-.8-.6-1.7-.8-2.7zm8.4-20.8v-2.9c1 .3 1.8.6 3.1 1-1.2.8-2 1.3-3.1 1.9zm.9-335.1c3.4-.3 6.3 3.2 8 9.5-.2.1-.3.2-.5.3-1.3-1.6-2.6-3.1-3.8-4.7-1.2-1.6-2.4-3.3-3.7-5.1zm.9-7.7c2.1-1.4 4.4-.1 6-.2.3 2.1.6 4 1 5.9-2.2-1.9-4.6-3.7-7-5.7zm6.7-2.2c-.5-3.7-3.5-4.1-6.4-4.7-1.6-.3-2.3-1.1-2.7-2.7-.5-1.8-1.9-3.5-3-5.1-1.4-1.9-3.6-3.6-1.8-6.4.2-.3-.4-1.3-.9-1.7l-.4-3.9c8.7 2.6 12.6 9.2 15.7 16.4 1.4 3.2 2.8 6.5 4.2 9.8-1.5 1.2-2.5.4-3.5-.5-.7-.3-1.2-.7-1.2-1.2zm-9.5-102.4c-4-2.3-7.9-4.5-11.8-6.7-.4-.3-.8-.7-1.2-1 4.5-3.6 12.8.5 13 7.7zm-141.4-85.6c5 .9 6.5 2.5 4.8 5l-7.5-2.7c1.2 0 2.1-.6 2.7-2.3zm-27.4-55.2c-.2-.9-.3-1.7-.5-2.7 2.9-.7 2.6 1.8 4.4 3.4-3.2.3-5.7.8-8.2.5-1-.1-1.8-2-3.1-3.5 3.6-.8 4.1 4.1 7.4 2.3zm-4 47.9c3.4-4.7 11.1-6.3 15.3-3-1.4 3.2-4.5 2.7-7.4 3.4.8.2 1.5.4 2.3.4.8.1 1.6-.1 2.6-.1-1 1.5-1.7 2.5-2 3.2-5.5-1.6-11.1-3.1-16.8-4.5.5-.3 1-.7 1.5-.7 1.6.3 3 .9 4.5 1.3zm-18.1-32.6c-5.8 2.6-11.9 3.9-18.3 3.5 5.4-4.2 11.9-3.6 18.3-3.5zm-20.3 3.5c-4.2 4.3-9.8 2.9-14.6 4.4 1.1-3 6.4-4.5 14.6-4.4zm-27.7 5.9c-2.2 2.1-4.9 2.6-8.5 2.8 2.7-2.9 5.7-2.6 8.5-2.8zm-209.1-8.9c.2.3.3.5.5.8-1.3 3.8-5.2 4-8.1 5.5-.6-.7-1.1-1.3-1.9-2.4 3.2-1.3 6.3-2.6 9.5-3.9zm-17.4 8c-.4 2.4-1.6 2.9-5.1 2.6.5-2.5 1.6-3 5.1-2.6zM143.4 680.6c-1.3.5-1.8 1.2-1.7 2.6 0 .7-.7 1.5-1.1 2.3-.3-.1-.5-.2-.8-.2l2.4-10.8.9-.3c.5.8 1.5 1.6 1.5 2.5.1 1.3 1 3.2-1.2 3.9zm7.8.3c-1.1-1.5-1.2-2.6-.2-4.7.2.6.4 1.3.6 1.9.6 3 1.3 5.9 2 8.8-.8-2.1-1.2-4.3-2.4-6zm456.3 252.2c-.2-.3-.4-.5-.6-.8 1-.7 2-1.5 2.9-2.2.2.3.5.5.7.8-1.1.8-2.1 1.5-3 2.2zm17.2-4.2c-.6-.8-1.2-1.6-2-2.5.8-.4 1.4-.8 2.2-1.3.2 1.2.4 2.3.6 3.3-.3.2-.6.4-.8.5zm1.9-3.1c-.8-3-.6-3.5 1.7-4 .7 2.4.3 3.4-1.7 4zm6.7.3-.9-.3c.2-1.1.5-2.1.9-3.7.6.7 1.3 1.2 1.2 1.4-.3.9-.8 1.7-1.2 2.6zm0-5.9c1.6-.6 2.7-1 4-1.4-.4 2.1-1.1 2.4-4 1.4zm11.4 13.8c-1.2.1-2.4.9-3.6 1.3-.7.2-1.5.2-2.3.3v-.5c1.5-1 3-2 4.6-3-.1-.1-.2-.3-.3-.4 1.1 0 2.2.1 3.4.1 0 1.3-.1 2.1-1.8 2.2zm.1-8.2c-2-3-1.5-3.6 3.2-5.6.4 2.8-2.5 3.4-3.2 5.6zm1.2-6.2c-.2-.2-.4-.4-.6-.5.8-1.2 1.6-2.5 2.6-4 .6.6 1 1.1 1.7 1.7-1.5 1-2.6 1.9-3.7 2.8zm9.7-8c1.4.3 2.5.6 3.7.8.8.1 1.6.1 2.3.1-.5-.5-1-1.1-1.5-1.6-.1-.1-.1-.2-.4-.7 1.2-.2 2.3-.4 3.7-.7 1-1.9 3.7-2.1 5.9-3.1.2-.1 1.1.5 1.1.7-.1 1.4-.4 2.8-.5 4.1 0 .6.6 1.4.4 1.8-.9 1.6-2.1 3.1-3.6 4.4.3-1.5.7-3 1-4.5-.3-.1-.6-.1-.8-.2-.8 1.7-1.6 3.4-2.7 5.9-.9-1.1-1.5-2.2-2.4-3-2.3-2.1-3.4-1.8-4.7.9-.3.6-.9 1.1-1.5 1.5-.1.1-.8-.7-1.3-1-.5.3-.4.6.5 3.2-.9-.8-1.8-1.5-2.7-2.3.2-2.4 4.2-2.8 3.5-6.3zm11.4 16.5c-.1.2-.2.5-.3.7l-4.2-1.5c2.3-1.4 2.6-1.3 4.5.8zm-5.5-11.2c-1.2 1.4-1.1 3.7-4.4 3.6.5-1.7 1-3.5 1.6-5.4 1.1.7 1.9 1.2 2.8 1.8zm-6.2 8.3c-.8-1.2-1.5-1.9-1.4-2.1.6-.8 1.3-1.6 2.2-2.2.2-.1 1.2.8 1.8 1.2-.7.9-1.5 1.8-2.6 3.1zm4.2-2.1c1.1-.6 2.2-1.2 3.2-1.8.2.3.4.6.5.8-1.1.6-2.1 1.3-3.2 1.9-.1-.3-.3-.6-.5-.9zm2.3 10.1c1.2.1 2.3.2 3.5.2-1 1.7-1.6 1.7-3.5-.2zm3.5 6.8c-.2-.1-.5-.2-.7-.2-.1-.7-.4-1.6-.1-1.9.5-.5 1.4-.5 2.2-.7.2.3.3.5.5.8-.7.6-1.3 1.3-1.9 2zm9.9-19.5h-4.4c.7 1 1.1 1.7 1.9 2.9-1.2-.2-2.2-.4-3.1-.5-.4-.1-.9-.4-1.3-.3-1.4.1-2.4-.4-2.3-1.8.1-1.6 1.3-2.3 2.8-2.5 1.6-.2 3.2-.2 4.9-.3.4 0 .8-.3 1.6-.6-.7-1.1-1.3-1.9-1.8-2.9-.6-1.1-1.3-2.3-1.5-3.5-.1-.6.5-1.7 1-2 2.1-1 3.1-2.6 3.3-4.7.2-.1.4-.1.6-.2.8 1.2 1.6 2.4 2.4 3.7-3.2 1.3-3.1 1.3-2.6 4.4.2 1-.2 2.1-.4 3.6.8.9 1.8 2.2 
                    2.9 3.5-1.2 1.1-3.6.9-3.2 3.3-.3-.8-.5-1.4-.8-2.1zm.9 4.2c.8-.4 1.5-.7 2.4-1.1.4.7.7 1.4 1 2-2 1.2-2.3 1.1-3.4-.9zm8.1-8.9c-.3-2.5-.5-5.1-.7-7.9-.7.1-1.7.3-3 .5.2-1.8 3.5-2.9 1.4-5.1-.8.5-1.7 1-2.7 1.7-.4-1.1-.6-1.8-1-2.8 2.6-1.3 5.2-2.8 7.9-4 .7-.3 2.4.3 2.6.8.3.8-.2 2-.6 2.9-.2.4-.9.6-1.6 1 .5.8.9 1.5 1.3 2.2l-2.1 3c.3.5.7 1 1.2 1.6-.7.3-1.2.5-2.1.9.6 1.3 1 2.7 1.8 3.8.8 1.1.4 1.7-.5 2.2-.9.6-1.7.2-1.9-.8zm6 7.5c-1.3-1.3-2.3-2.3-4.2-1.1-.1.1-.5-.3-1.1-.6 1.2-.8 2.1-1.4 3-1.9 1.3.9 2.6 1.9 4.3 3.1 0 .9-.7 1.7-2 .5zm38.1-26.3c-.4-1.2-.1-2.6-.1-4 .2 0 .3 0 .5.1.8 1.5 1.5 3 2.6 5.2-1.4-.6-2.9-.8-3-1.3zm1.8-17.7c.2 1.4 1.2 1.1 2.1 1.1 1.7-.1 3.4-.2 5.2-.2.5 2.4-1 3.7-2.6 5-6.3-3.3-7.1-3-7.7 2.7-1.9-1.1-3.6-2.1-5.2-3.1-.9.7-1.9 1.5-3 2.3.7.2 1.6.5 2.2.7 0 .7-.1 1.2-.1 1.8.7-.4 1.3-.9 1.8-1.2 1 1.5 2.3 3.4 3.5 5.3.2.4 0 1.1-.1 1.6-.5 2.1-.4 2.4 2.1 4.1-1.2.7-2.1 1.3-3.2 1.9-.5-1.3-.8-2.1-1.1-2.9-.2 0-.4.1-.6.1-.4.8-.8 1.7-1.1 2.3-1.8-.6-3.4-1.2-4.9-1.8-.2.2-.5.3-.7.5.8 2 1.5 4 2.5 6.6-1.1.9-2.7 2.3-4.7 4-.7-.5-1.5-1-2.5-1.7-.7.3-1.7.6-3 1.1 0-2.7 1-5.5-2.3-6.9 0-.2.1-.4.1-.5 1.6-.5 3.3-1 4.9-1.5.2.2.4.4.6.7-.5.8-.9 1.6-1.5 2.6.2.7.4 1.8.6 2.7 1.4.3 2.6.6 4.2.9 2.1-.8.6-2.4.4-4.2-1.1.7-1.9 1.3-2.8 1.9-.2-.1-.3-.2-.5-.3 1.2-2.5 2.3-5 3.6-7.4.3-.5 1.5-.4 2.2-.7.7-.3 1.4-.6 2.1-1-.5-.5-1-1.1-1.5-1.6-.3-.3-.6-.5-1.1-.9-1 1.3-1.8 2.6-2.8 3.6-.9.9-1.9 1.7-3.1 2.3-1.7 1-2.3-.7-3.3-1.4-.2-.2-.5-.2-.8-.3-1.8 1.5-3 3.1-2 5.4-2 1-5.3.6-4.6 4.4 3.6-2.2 4.8.6 6.6 2.6-.3.6-.6 1.3-.9 2.1 1 .1 1.7.2 2.5.3.6 1.8-.3 2.6-2 3.1-1.4.4-2.8 1.1-4.6 1.7-.9-.5-2.2-1.3-3.6-2.1.3-.7.5-1.4.8-2.1.1 0 .2 0 .3.1 0 .6-.1 1.1-.1 2 .9-.3 1.7-.6 2.6-.7.5-.1 1.4-.4 1.6-.1 1.1 1 1.8.2 2-.5.2-.5-.2-1.4-.6-1.9-.6-.8-1.3-1.4-2.4-2.5-1 .5-2.6 1.3-4.2 1.9-.6.2-1.3.2-1.9.1-2.8-.9-5.6 1-5.6 3.7 0 1.3.6 1.8 1.8 2 .6.1 1.2.3 1.9.5.1.2.1.4.2.6-1.4.7-2.7 1.4-4 2.1-.5-1-.6-2.3-1.4-2.9-2.2-1.5-2.7-3-.1-5.2h-2.9c0-.2-.1-.4-.1-.6 1.1-.2 2.1-.3 2.6-.4 1.2-2.4 2.3-4.6 3.4-6.7 1.8 1.4 3.4 2.6 5.1 3.9.9-1.3 1.5-2.2 2.1-3.1-1.4-2.4-.8-5.7-3.8-7.4v3.8c.2 0 .4 0 .6.1-.6.4-1.1.9-1.7 1.3-1.9 1.1-2.7.7-3.6-1.2-.8-1.7-2.1-3.2-3.2-4.8 8.2-4.9 16.9-10 25.6-15.1 1 .2 1.9.3 2.9.5.1-.3.1-.5.2-.8-.6-.2-1.2-.3-2-.6 2.4-1.6 4.7-3.2 7.1-4.8.8 2.8-3.6 4.2-1.4 7.5.9-2.9 3.3-4.8 2.4-7.8 0-.1.7-.4 1.1-.5.6-.2 1.7-.3 1.7-.5-.1-2.1 1.8-2.7 3.1-3.6.8-.6 1.5-1.3 2.2-1.8.8 1.1 1.7 2 2.3 3.1.7 1.3 1.8 1.5 3.3 1.7.6.1 1.1 1.4 1.6 2-2.8.4-5 .7-7.3 1-1.4-.1-1.7.7-1.5 2zm12.3-2.6c1.3-.4 2.4-.7 3.5-1.1 2.2-.8 2.5-.7 2.9 1.7-2.7 1.2-5.5.9-6.4-.6zm4.6-4.8c-1.4-.1-2.9.7-4.8 1.2-.2-.7-.4-1.8-.6-3-.4 0-1 .1-1.5.2-1.2-2.4-1.7-2.5-3.5-.1.4-1.6.7-2.6 1-3.7 1.4.4 2.6.8 4.3 1.3-.1-1.4 0-2.4-.4-3.2-.7-1.7-.3-2.9 1.3-3.8.9-.5 1.7-1.4 2.6-2.1.7.7 1.3 1.3 1.9 2-.9.7-1.9 1.2-2.2 2-.3.7.3 1.6.5 2.5-1 1.3-2.1 2.8-3.5 4.7 1.6-.2 2.8-.4 4.2-.6-.3-.7-.6-1.2-.8-1.7.1-.2.2-.3.3-.5l6.3 2.1c-1.6 2.9-1.7 2.8-5.1 2.7zm9-1.6c-.8-.6-1.6-1.3-2.4-1.9-1.2-1-2.6-2-3.7-3.2-.5-.5-.7-1.5-.7-2.2.1-1 .6-1.9.8-2.8.1-.7 0-1.4-.1-2.4-1.2.6-1.9 1-2.9 1.5-.2-3.7 3.1-4.3 4.9-6.1v3.2c.9-.3 1.6-.6 2.7-1-.1 2.6-.6 5-.3 7.4.3 2.5 1.3 4.8 2.1 7.3l-.4.2zm.7-7.4c.7-.8 1.2-1.5 1.7-2.1.7.6 1.4 1.1 2.2 1.7-1 1.5-2.2 1.3-3.9.4zm4.4 7.3c.7-.8 1.3-1.6 2-2.3.4.7.8 1.4 1.5 2.5-1.5.1-2.3.2-3 .3l-.5-.5zm7.1 46.8-.9.3c-.6-1-1.4-1.9-1.7-3-.1-.3 1.4-1 2.2-1.5.3.2.5.4.8.7-.2 1.2-.3 2.4-.4 3.5zm.6-9.4c0 .2-1.3.3-2 .6-.5.2-1.3.5-1.3.6 1.1 3.5-1.8 5.7-2.8 9-2.5-3.8 2.5-5.5 1.7-8.7 1.6-1.1 3.3-2.2 4.9-3.3-.4.5-.6 1.1-.5 1.8zm-1.9-44c2.6.5 2.5 2.1 2.2 3.2-.4 1.2-1.6 2.2-2.7 3.6-1.2-2.7.5-3.5 1.9-4.5-.4-.7-.8-1.3-1.4-2.3zm7.2 1.5c-1.9-.2-3.2-.9-3.1-3.1h4.6c-.6 1.2-1.1 2.1-1.5 3.1zm-5.9-3.2c-.7-.5-1.4-.9-2.2-1.5.9-.8 1.5-2.1 3.4-1.6.7.2 1.7-.6 2.5-1.1 1-.6 1.8-1.3 3-2.1.3 1.2.6 2 .9 3-3.8-1.1-4.9 2.7-7.6 3.3zm7.5-12.1c-1.5-1.1-2.5-1.8-3.9-2.8-1.1.1-2.9.3-5.2.5 1.1 1.3 2.2 2.5 3.4 3.9.5-.4 1.1-.9 1.7-1.4.2.1.4.2.6.2-.4.7-.6 1.9-1.2 2.1-1.6.7-2 1.7-1.5 3-.9.8-1.7 1.6-2.6 2.4-1.4-.7-1.3-1.3.6-3.1-.8-.4-.8-.4-3.9 2.7.3 2.1.6 4.1.9 6.4-1.2-.1-2.2-.1-3.4-.2.2-.6.3-1 .4-1.4.3-.6.6-1.1.9-1.7-.8-.3-1.7-.8-2.5-1-.7-.1-1.4.2-2.1.4-.5-.6-1-1.1-1.4-1.5.5-1.2 1.1-2.4 1.4-3.7.6-2.6 1.7-4.7 5.2-4.5-.1-.2-.1-.4-.2-.6h-4.3c.9-2 5.3-1.7 3.5-5.3 2.2-2.6 4.4-5.3 6.7-8 .3.1.6.2.8.3-.2 1-.5 2-.7 3h-.6c.4.7.9 1.4 1.3 2.1-1 .8-2.1 1.6-3 2.5-.1.1.5.7.8 1.2.6-.9 1.1-1.5 1.9-2.6.4 1.3.7 2.2 1 3h.4l.6-3.9c.2 0 .5-.1.7-.1.2.7.3 1.3.5 2s.5 1.3.9 1.9c.1.1 1.1-.1 1.1-.2.1-.6.1-1.3 0-1.9-.1-.8-.2-1.6-.3-2.5-.5 0-1.1-.2-1.8-.2-1.3 0-2.4-.4-2.1-1.7.1-.4 1.4-.7 2.3-1.1-.7-.4-1.6-.9-2.5-1.3 0-.2.1-.4.1-.5.7.2 1.6.2 2.2.6 1.3.9 2.4 1 3.8-.6.3 1.1.8 2 .5 2.3-1.2 1.3-.5 2.6-.3 4 .2 1.2 0 2.4-.1 4.1.3.1 1.2.5 2.3 1-1 .3-3.1-1-2.9 2.2zm2.2-15.3c.1-.2.3-.3.4-.5-.7-.3-1.5-.6-2.5-1-.3.8-.5 1.6-.8 2.6-.7-.5-1.4-.9-2.2-1.5-.4.2-1 .4-1.6.7l-.3-.3c2.1-2.3 4.2-4.6 6.3-6.8 1.6 1.5 1.5 2-.3 2.8-.9.4-1.8.9-2.6 1.4l.6.9c1.7-1.1 3.5-2.1 5.7-3.5 0 1.5.1 2.7 0 3.9-.2 1.7.1 2.8 2.4 2.9-1.3 1.2-2.6 1.8-3.8.8-.8-.4-.9-1.6-1.3-2.4zm4.8 6.1c-.3.9-.5 1.7-.8 2.7-1-.5-1.8-1-2.7-1.5 1.2-2.1 3.1-3 5.1-2.2.7.3 1 1.3 1.5 1.9-.3.2-.6.4-.8.6-.7-.4-1.4-.9-2.3-1.5zm15.6-27.8c-.7-.2-1.4-.5-2.2-.7 0-.3.1-.8.3-1.6-1.7.5-2.9 2.7-4.8.7 1.2-2.4 3.4-1.7 6-1.4-.7-1.2-1.3-2.1-1.9-3.1.6-.3 1.5-.8 2.5-1.3 1.3 1.8-2.5 4.6 1.6 5.5-.6.7-1 1.3-1.5 1.9zm2.6-.9c1-1.6 1.8-3 2.8-4.3.3-.4 1.2-.3 1.9-.5.1.6.5 1.3.2 1.7-.9 1.8-2 3.3-4.9 3.1zm21.8 53c-1.1.5-2.6.8-2.7 1.2-.3 1.5 1 2 2.5 2 .7 0 1.5.1 2.1.2.1 1.1.2 2 .3 3 .1.7.1 1.5 0 2.2 0 .2-1.2.4-1.3.3-.4-.7-.7-1.5-1-2.3-.3-.8-.4-1.5-.6-2.3-.3.1-.6.1-.8.2-.2 1.5-.5 3-.7 4.6h-.5c-.3-1-.6-1.9-1.2-3.5-.9 1.2-1.4 2-2.2 3-.4-.6-1-1.4-1-1.4 1.1-1 2.3-1.9 3.5-2.9l-1.5-2.4h.7c.1-.6.3-1.1.4-1.7.5-.5 1-1 1.5-1.4.9.3 1.8.8 2.5 1.2zm6.8-105.7c-2.4.2-3.2-1-3.4-3 2.1-.6 3.5.8 3.4 3zm.3-287.7c-.5-.5-1-1-1.3-1.6-.2-.5 0-1.1 0-1.7-2.1.2-2.3-.1-1-4 1.1 1.8 2.3 3.6 3.2 5.5.1.3-.6 1.2-.9 1.8zm-1-26.1c0-1.4.6-2.3 2-2.2.9 2.5 1.7 4.6 2.5 6.9-2.4-.3-4.4-2.4-4.5-4.7zm11.3 282-3.9 3.9c-.6-1.5 1.1-3.7 3.9-3.9zm2.9 5.9c.5-.7 1-1.5 1.5-2.2.4.3.8.5 1.2.8-.5.7-1 1.5-1.6 2.1 0-.1-.7-.5-1.1-.7zm8.4 98.8c-.9-.1-1.7-.2-2.5-.3.4-.5.9-1.1 1.3-1.6.4.6.8 1.2 1.2 1.9zm4.6-187.5c-1.4-2.7-1-5 .1-7.3 1.8 1.5 1.8 4.4-.1 7.3zm5.1-11.7c-2.4-12.3-.6-24.5.1-36.8 1.5 12.3 1.5 24.5-.1 36.8zm.2-52.7c2.8 1 3.2 3.2 1.4 8.5-1.2-1.2-1.4-2.9-1.4-8.5zm-1 129.2c-.8-4.5-.3-5.9 2.4-6.1 0 4.8-.3 5.6-2.4 6.1zm3-15.9c-.8-1.2-1.5-2.2-2.2-3.4 1.1-2 2.9-1.3 5.3-1.3-1.2 1.7-2 3.1-3.1 4.7zm.4-140.1c0-.9-.3-2-.9-2.6-5.1-5.2-7.8-11.4-9.1-18 1.4-.3 2.7-.5 3.9-.8 2.2-.5 3.2-.1 3.8 2 .3 1.1.5 2.4.5 3.5.1 5.8 2.2 10.8 5.4 15.7-.4-.3-.9-.6-1.7-1.1 0 1.5-.3 2.8.1 4 .7 2.6 1.8 5.1 2.6 7.6.9 2.9 1.2 5.7-.6 9-1.9-6.6-4.3-12.6-4-19.3zm8.4-58.5c-1.5-1.4-3-2.9-4.8-4.6.2-.2.6-1 1.3-1.4 1-.7 2.1-.8 2.6.7.6 1.6 1.1 3.2 1.7 4.9-.3.1-.5.3-.8.4zm12.5 7-3.3-4.5c2.1-1.1 3.7.8 3.3 4.5zm5.2 5.4c0 .4-.5 1-.8 1.1-.5.1-1.4-.2-1.5-.5-.3-.9-.6-1.9-.4-2.8.2-.6 1.2-1.1 1.9-1.6.2.2.4.3.6.5.1 1.1.3 2.2.2 3.3zm25 55.7c2.7 1.9 1.8 4.7 2.3 7.2-2.1-2-2.3-4.5-2.3-7.2zm8.1 46.9c-1.9-5.3-3-10.5-2.4-16 2.7 2 4.1 10.9 2.4 16zm-1.8-17.1c-4.2-3.7-2.4-8.4-3.7-12.6 2.8 1.1 3.2 2.3 3.7 12.6zm-16.4-213c.1.7 0 1.5.3 2.1 2.1 3.6 4.7 7.1 6.5 10.9 4.4 9.3 8.4 18.9 12.9 28.2 2.3 4.7 5.3 9.1 8.2 13.9 1.9-2 .8-3-.1-4.1-.8-1.1-1.6-2.4-2.1-3.7-1.8-5.1-3-10.5-5.3-15.3-3.8-8-8.4-15.8-12.6-23.6-1.5-2.8-2-6.3-5.8-7.4-.7-.5-1.3-.8-2-1z"/>
                <path d="M125.3 224.1c.8-.7 1.8-1.3 2.5-2.2 1-1.2 1.8-2.6 3-4.2-2.2.3-3.9 1-4.8.5-.9-.5-.8-2.4-1.3-4.4-7.7 9-14.9 17.5-22.2 26 .2.3.5.6.7.9 2.1-.4 4.1-.8 6.2-1.4 2.6-.7 2.9-1.5 1.7-3.7-1.1-2.2-.6-3.3 2-3.4 1.8-.1 3.7.4 5.1.6.5-2.2 1-4.4 1.6-6.8-1.3 1.1-2.2 1.9-3.2 2.8l-.8-.8c1.7-1.7 3.3-3.4 5.2-5.3 1.2 3.8 1.6 3.9 4.3 1.4zm496.2-72.7c-1.6-2-.5-3.2 1.3-3.5 2.2-.4 4.6-.5 6.9-.2 2.6.4 5.1 1.5 7.6 2.2 1.6.5 3.1.4 4.8-1.4-8.2-2.9-15.9-5.7-23.9-8.5-1 1-2.3 2.4-3.8 4 1 .4 1.6.5 1.8.8.8 1.2 1.4 2.6 2.1 3.8-1.1.4-2.2 1.1-3.4 1.2-1.4.1-2.9-.5-4.3-.5-1 0-2 .5-2.9.8.1.2.1.5.2.7 4.4-.7 8.7 2.8 13.6.6zM828 275.6c-.6 1.8-1 3.3-1.5 4.7-.5 1.5-.2 2.2 1.4 3 2.6 1.2 5.1 2.7 7.3 4.5 2.8 2.2 5.1 4.9 7.8 7.1 2.2 1.8 4.7 3.1 7 4.7.2-.3.5-.5.7-.8-3.8-10.8-14-16.2-22.7-23.2zm.8 3c3.3-.2 3.2 2.9 5.1 4.2-2.7.8-4.6-.8-5.1-4.2zM682.4 957.9c1.1.9 2.1 1.8 3.2 2.7-1-3-1.1-3.3-.6-3.7.5.5 1.4 1.3 1.5 1.2.7-.5 1.4-1.1 1.8-1.8 1.5-3.2 2.8-3.5 5.4-1.1 1 .9 1.7 2.2 2.7 3.5 1.3-2.9 2.3-4.9 3.2-6.9.3.1.6.2 1 .3-.4 1.7-.8 3.5-1.2 5.2 1.7-1.5 3.1-3.2 4.1-5.1.3-.5-.5-1.4-.5-2.1.1-1.6.5-3.2.6-4.8 0-.3-1-1-1.3-.9-2.5 1.2-5.7 1.4-6.8 3.6-1.6.3-2.9.6-4.3.8.3.5.3.7.5.8l1.8 1.8c-.9 0-1.8 0-2.7-.1-1.4-.2-2.7-.6-4.3-.9.8 4.2-3.9 4.7-4.1 7.5z"/>
                <path d="M713.9 959.4c-1.3-1.5-2.5-3-3.4-4 .2-1.7.6-3 .4-4.1-.6-3.7-.7-3.6 3-5.1-.9-1.4-1.9-2.8-2.8-4.2-.2.1-.5.1-.7.2-.3 2.4-1.5 4.3-3.9 5.4-.7.3-1.3 1.6-1.2 2.4.3 1.4 1 2.7 1.7 4 .6 1.1 1.3 2.1 2.1 3.4-.9.3-1.4.6-1.9.7-1.9.2-3.8.2-5.7.4-1.8.2-3.2 1-3.3 2.9-.1 1.6 1.1 2.2 2.7 2.1.5 0 1 .3 1.5.4 1.1.2 2.2.4 3.7.6-.9-1.4-1.4-2.2-2.2-3.4h5.1c.3.8.6 1.6.9 2.3-.2-3 2.6-2.8 4-4zm8.2-3.1c1.1-.6 1.6-1.2.6-2.5-.9-1.3-1.4-2.9-2.1-4.4 1-.5 1.7-.7 2.4-1.1-.6-.8-1-1.3-1.4-1.9.9-1.2 1.7-2.4 2.5-3.5-.5-.8-1-1.6-1.5-2.5.8-.5 1.6-.7 1.8-1.2.4-1.1 1-2.5.6-3.4-.2-.6-2.3-1.3-3.1-.9-3.2 1.3-6.2 3.1-9.2 4.6.4 1.2.7 2 1.1 3.3 1.2-.7 2.2-1.4 3.2-1.9 2.4 2.6-1.4 3.8-1.6 5.9 1.5-.3 2.6-.5 3.4-.6.3 3.2.5 6.2.8 9.2.3 1.2 1.3 1.6 2.5.9zm23-774.8c2.3 1.1 4.7 1.9 7.8 1-7.3-4.8-13-11.9-23.2-9.4v3.7c2.9.5 5.8.7 8.4 1.5 2.5.7 4.7 2.1 7 3.2zm121.4 141.2c2.2 3.1 3.2 3.5 7.3 2.3-2-3.1-4-6.2-6.2-9.2-1.1-1.6-2.4-3.2-3.9-4.6-1.8-1.6-3.9-1.6-5.9-.4 3 4.2 5.9 8 8.7 11.9zm49.6 168.2c.5-4.5-3.2-15.6-6.4-18.9-2.2 8.3.8 17 6.4 18.9zM811.2 310.5c6.3 4.7 10.8 11.3 19.3 13.3-2.5-5.5-13.6-13.2-19.3-13.3zM925 395c.2-.4.3-.9.5-1.3.3-.1.5-.2.8-.4 1.1 1.7 2.3 3.3 3.2 5.1 1.1 2.2 1.8 4.6 2.9 6.8 1 1.9 1.7 2.1 3.7 1.6-2.7-5.9-5.4-11.8-8.2-17.8-3.7 2.8-4.7 5.2-2.9 6zm-24.4 60.1c.8 5.6 4.6 9.7 7.6 14.3.3-.1.7-.3 1-.4-2.2-6.1-4.4-12.2-6.6-18.4-1.8 1-2.3 2.7-2 4.5zm-22.8-100.4c-.1.2-.2.5-.3.7 3.9 5 6.7 10.9 12.5 14.4-5.2-7.4-5.5-8.2-5-12.6-2.6-.8-4.9-1.7-7.2-2.5zM602.9 149.9c-1.9-3.6-12.5-4.8-17.6-2.1 6 .5 11.4 3.9 17.6 2.1zm391.4 431.3c-.7 6.4.5 12.5 2.8 18.6 2-5.9.5-16.3-2.8-18.6zM79.7 146.8c5.1 1.6 10.3-1.4 13.3-7-1.5-.5-3-1.1-4.7-1.8-1.1 4.4-3.2 7.8-8.6 8.8zm66.4 555.9c-.4 0-.7 2.2-.9 2.7 1.6.8 3.2 1.3 3.2 1.8.1 1-.8 2.1-1.4 3.4 4-1.2 2.5 2.4 4.1 3.5 1.7-1.1 1.5-2.5.9-4.1-.6-1.9-.9-3.8-1.3-5.7.2-.2.5-.4.7-.7-1.7-.3-3.5-.9-5.3-.9zm-32.6-486.2c-3.6 4.6-9 8-11 14.1 2.3-2 4.3-3.8 6.3-5.5 1.6-1.4 3.3-2.6 4.8-4 1.5-1.7 1.4-2.9-.1-4.6zm772.4 125.6c-2-5.1-4.6-9.9-9.3-13.5.4 6.1 4.9 9.7 9.3 13.5zM154.6 722.4c-.1.4.8.9 1.2 1.4.3-.2.6-.3.9-.5-.5-1.2-.8-2.3-1.4-3.5-.8-1.7-.5-2.8 1.7-3 .2.8.5 1.4.7 2.1 1.2-2.4 0-3.6-1.7-4.3.5-2.3 1-4.4 1.5-6.5-.2-.1-.5-.2-.7-.2-.6 1.2-1.5 2.4-1.6 3.7-.1 2.2-.9 4-2.7 5.3-.8-.3-1.6-.5-2.4-.8-.1.2-.3.5-.4.7.8.6 1.5 1.5 2.4 1.9 1.6.8 3 1.5 2.5 3.7zm657-431.2c1.4 1.7 3.3 2.2 5.2 1.2-1.9-2-3.8-3.9-5.8-5.8-1.4-1.3-2.8-2.7-4.3-3.8-.8-.5-2-.5-3-.7 1.8 1.9 3.5 3.4 5 5.1 1.1 1.2 1.8 2.7 2.9 4zm16-40.3c3.7 3.6 5.4 4.8 8.3 4.6-2.7-2.8-5.6-5.3-8.5-7.8-.5-.4-1-.9-1.5-1.3-1.6-1.2-3.2-2.5-5.4-1.9 2.4 2.1 4.9 4.1 7.1 6.4zM995 580c-.6-11.9-.9-13.3-4.3-14.6 1.6 4.8-.5 10.3 4.3 14.6zm-81.9 159.7c4.1-2.4 5.8-8 3.5-11.8-3.9 6.4-4.8 9.3-3.5 11.8zm61.5-236.9c.2 5.3 3.2 12.4 6.3 14.5-2.3-4.9-.5-10.9-6.3-14.5zM756.9 225.2c-2.1-5-7.5-5.3-12-8.1 1.9 6.5 8 5.9 12 8.1zm-115-48.6c-1.4.1-3.2.2-3.4 2.4 6.2-2.8 11.1 3.1 17.1 2.3-2.4-2.7-10.7-5-13.7-4.7zm135.7 25.8c-2.1-.9-4.2-2.2-6.5-2.6-.8-.1-2 2-2.8 2.8 2.1 1.4 3.7 2.4 5.5 3.6-.5-3.2 2.2-2.1 3.8-3.8zm39.3 38.8c-3.1-4.1-7.4-6.7-12.2-8.6 2.8 4.5 7.1 7.1 12.2 8.6zm58.7 165.2c2.8 2.3 5.5 4.4 8.1 6.5-.4-2.2-.7-4.4-1.1-6.8-1.9.3-4.6-1.3-7 .3zm18.2-67.1c.4-.7.9-1.4 1.4-2.1 1.5-2.4 1.2-3-1.7-3.7-.3 1.1-.4 2.7-1.1 3.2-.8.6-2.3.1-4.5.1 1.7 1.9 3.1 3.3 4.8 5.1.5-1.2.7-1.9 1.1-2.6zM103.4 663.1v4.7c1.6-.1 3.2.1 4.6-.3.6-.2 1.3-1.8 1.1-2.3-.9-2-2.9-2.2-5.7-2.1zm718.3 224.8c-.9.5-2.1 1.5-2.9 1.3-2.3-.6-3 1-4 1.9.9.6 1.7 1.1 2.5 1.7 3.1-.7 4.5-5.1 8.8-3.7-.4-1.3-.6-2.2-1-3.5-1.3.8-2.3 1.6-3.4 2.3zm66.1-479.2c.1 2.6 2.4 5.1 5.3 5.5-1-2.6-1.9-5.2-2.9-8-1.7-.2-2.4.8-2.4 2.5zm46.2 50.5c-.8.5-1.3 1.4-1.5 1.7 2 1.9 3.8 3.6 5.6 5.3.3-.2.6-.4.9-.5-.6-1.9-1.3-3.8-1.9-5.7-.6-1.7-1.9-1.6-3.1-.8zm-26.5-61.9c-.6-4.2-2.9-6.9-6.6-9.1-.6 5 3.5 6.6 6.6 9.1zm11.3-24.5c-1.7-3.8-3.2-7.2-4.8-10.6-.2.1-.5.2-.7.2-.7 4.2 1.3 8.2 5.5 10.4zM74.9 549c.8-2.8 1.8-5.5-1-8.2-2 2.5-1.6 5.9 1 8.2zm406.5-398.9c-6-1.7-8.7-1.9-8.5 1.8 3 .2 5.9.4 8.5-1.8zm206.8 810.7c3.9.1 3.7-2.6 5.1-4.2-1-.7-2-1.3-3.3-2.1-.7 2.3-1.3 4.3-1.8 6.3zm236.3-245.3c2.3-.6 2.7-1.6 2.7-7.1-3.1.3-3.7 1.9-2.7 7.1zm-763.1 31.6c-.4 0-.8-.1-1.2-.1-.9 1.8-1.9 3.6-3 5.6 2.6-.3 5.6 1.5 6.1-2.4-1.6-.3-3.5-.5-1.9-3.1zM815.2 228c-.8-2.6-2.7-4.3-4.8-4.3-1 0-2.1.6-3.1 1 .1.3.2.7.3 1 2.5.7 4.9 1.5 7.6 2.3zm110.1 465.1c.9 1.3 1.7 2.5 2.6 3.9 1.2-1.9 2.2-3.5 3.5-5.5-2.7.1-4.9-.7-6.1 1.6zM213.4 831c-2.9 1-2.6 3.7-3.7 5.5 2-.6 5.3 2 5.6-2.2-2.7-.8-2.7-.8-1.9-3.3zm458.7 143.4c-1.8 1.2-3.5 2.3-5.3 3.5v.5c.9-.1 1.8-.1 2.6-.4 1.4-.5 2.8-1.4 4.2-1.5 2-.2 2.1-1.1 2.1-2.5-1.4-.1-2.7-.1-4-.2.2.3.3.5.4.6zm186.5-144.7c-1.2 1.5-2 3.1-3.2 5 3.3.2 4.7-1.5 5.7-3.6.3-.5-.2-1.3-.3-2-.7.2-1.8.1-2.2.6zM836.1 867c-2.3-1-4.5 0-5.9 2.5 1 .5 1.9 1.1 3.1 1.7.3-1.2.6-2.1.9-3.2 1.1.8 1.9 1.3 2.7 1.9.3-.2.6-.5 1-.7-.6-.8-1-1.9-1.8-2.2zm-44.7 41.7c-1.3.5-2.6.8-4 1.3 1 1.8 4.3 2.1 7.4.7-.4-2.8-.8-3-3.4-2zm125.2-405c.6.4 2.4-.1 3.2-.7.8-.6 1-1.9 1.6-3.2-2.4.4-4.1.6-6.4.9.5.9.7 2.4 1.6 3zM673.8 967c.8-2.5 4.2-3.2 3.7-6.5-5.5 2.3-5.9 3-3.7 6.5zM62.9 175.2c-1.3 1-2.2 2.4-3.3 3.6.1.2.2.3.4.5 1.6-.5 3.4-.7 4.8-1.5.6-.4.6-1.8.9-2.7-1 0-2.2-.3-2.8.1zm657.7 786.9c.6.4 1.1.8 1.2.7 2.2-1.4 3.4-.2 4.8 1.3 1.5 1.5 2.3.5 2.4-.6-1.9-1.4-3.5-2.5-4.9-3.6-1 .6-2.1 1.3-3.5 2.2zm118-701.5c3 1.7 2.9 6.1 7.5 7.1-1.4-2.1-2.4-3.5-3.3-4.9-1.6-2.9-1.8-3.1-4.2-2.2zm119.2 215.6c-.8.6-2 1.1-2.2 1.9-.3 1 .1 2.2.5 3.3.1.4 1.2.6 1.7.5.4-.1.9-.8.9-1.2.1-1.3-.1-2.6-.2-3.9-.2-.2-.5-.4-.7-.6zm-7-15.9c-.2.1-.5.3-.7.4 1 3.1 1.4 6.5 4.8 8.4.3-.2.5-.3.8-.5-1.7-2.8-3.3-5.6-4.9-8.3zM904 441c0-1.2 0-2.5-.4-3.6-.2-.6-1.4-.9-2.6-1.6-.1 1.4-.3 2.2-.1 2.8.4 1.1 1 2.1 1.6 3 0 .2 1.5-.3 1.5-.6zM110.9 212.8c3.2-.8 5.2-2.5 6-6-3.6 1-4.8 3.5-6 6zm576.2 748.5c-1 .6-1.9 1.6-2.5 2.5-.2.3.7 1.1 1.6 2.5 1.3-1.6 2.1-2.6 2.9-3.6-.7-.4-1.8-1.5-2-1.4zm300.7-416c-.1 3.1.2 6 2.6 8.3-.5-2.8.5-6.1-2.6-8.3zM466.1 173c1.8-2.7 6.2-.1 8-3.8-6.8.5-9 1.5-8 3.8zm347.5 46.2c.5.4 1.7.1 2.5.1l.3-.9c-1-1-1.9-2.1-3-2.9-.4-.3-1.5.3-2.3.6.8 1 1.5 2.2 2.5 3.1zm10.6 677.2c.5-1.1 1-2.2 1.7-3.6h-5.3c-.1 2.6 1.4 3.4 3.6 3.6zm-8.3-1.7c.7 1.2 1.1 1.9 1.6 2.7-1.6 1.1-3.5 2.1-2.2 5.3 1.3-1.6 2.7-2.7 3.1-4.1.4-1.4.5-3.3-2.5-3.9zM632.1 166c-.2 2.7 1.1 3.4 5.1 2.7-.5-2.6-1.8-3.2-5.1-2.7zm223.2 180.1c.5-3-.9-4.2-3-4.8-.8-.2-1.8.3-2.8.5 2.2 1.6 3.8 2.8 5.8 4.3zm-23-19.1c1.5 2.2 2.4 5.1 7.2 4-2.5-1.8-4.5-3.3-6.6-4.8-.2.3-.4.6-.6.8zm-55.7-55.6c1.5-.7 2.7-1.2 4.1-1.8-2-1.2-3.6-2.1-5.1-3l-.6.6c.5 1.2 1 2.5 1.6 4.2zm-94.7-78.1h4.1c0-.6.2-1.6-.1-1.7-1.2-.7-2.5-1.1-4-1.7v3.4zm226.7 162.1c0-3.3-1.5-5.3-4.3-7.2.7 3 1.4 5.4 4.3 7.2zM186.8 803.5c.9-.9 1.8-1.8 3-2.9-.6-.5-1.5-1.3-2.3-1.9-2.5 1.3-2.7 3.1-.7 4.8zm654.3-559.4c-2.1-2.1-4.2-4.3-6.2-6.4l-.6.6c1.3 2.8 4 4.3 6.8 5.8zm60.3 100.3c.1-2.5-1.5-4.1-3.9-6 .9 2.8 1.6 4.9 2.4 7.5.4-.4 1.4-.9 1.5-1.5zM138.6 718v3.6c1.6-.6 2.9-1.1 4.2-1.8.1-.1 0-1.2-.2-1.2-1.3-.3-2.6-.4-4-.6zm51.8 83.6c.1 1.9.1 2.7.2 4 1.7-.9 4.2.3 4.1-2.2.1-.6-2.3-1.1-4.3-1.8zm327.1-659.1c-.5 0-.9.8-1.3 1.2.5.4 1 1.1 1.4 1 1.7-.3 3.3-.7 5-1.1-.1-.4-.1-.7-.2-1.1-1.7 0-3.3-.1-4.9 0zm349.6 673.2c-1.8-1.6-2.8-.7-3.6.7-.7 1.3-1.3 2.6.3 3.5 1.2-1.6 2.3-2.9 3.3-4.2zM948.8 469c1.3 1.8 2.5 3.5 3.8 5.2.5-4.2-1.3-6.4-3.8-5.2zM197.2 808.5c1.2 3.4 2.8 4.4 6 3-2.9-.3-3.1-3.7-6-3zm658.1-507.3c-.2.1-.4.2-.7.3l-.3 4.2h4c-1.2-1.8-2.1-3.2-3-4.5zm-84.5 627.7c0 1.6-.3 3.2.1 4.6.2.6 1.8.8 3.5 1.5-1.3-2.5-2.1-4.3-3-6.1-.2.1-.4 0-.6 0zM652.6 967c2.3-.7 2.8-1.9 1.9-4.7-2.5.7-2.8 1.3-1.9 4.7zm131.3-658.4v-3.7H781c-1 2.6.5 3.4 2.9 3.7zM145 724.8c1.6 3.4 2.8 4 5.7 3-1.8-1.3-3.5-2.5-5.1-3.7-.2.2-.4.4-.6.7zm529.5 234.4c.2.2.5.4.7.6 1.3-1 2.6-2 4.2-3.3-.7-.7-1.2-1.3-1.9-1.9-1.2 1.7-2.1 3.1-3 4.6zm186.1-135.6c0-.7-.7-1.4-1.1-2.1-.3.1-.7.3-1 .4-.3 1.4-.5 2.9-.8 4.4 2.3.1 2.8-1.3 2.9-2.7zm-706-69.1c-.6.9-1.1 1.9-1.7 2.8.9.4 1.9.8 3.4 1.4-.3-1.8-.4-2.9-.6-3.9-.4-.1-.7-.2-1.1-.3zm17.1 14c.8-1.4 1.4-2.3 2.3-3.8-1.8-.2-3.2-.4-4.4-.6.7 1.5 1.3 2.7 2.1 4.4zm668.3 85 .6.9c1.9-1.1 3.8-2.3 5.7-3.4-.2-.4-.5-.7-.7-1.1-1.9 1.2-3.7 2.4-5.6 3.6zm-633.2-15c-.6.9-1.2 1.8-1.9 2.8.9.5 1.7.9 3.3 1.8-.2-1.9-.2-3-.3-4.1-.4-.2-.7-.3-1.1-.5zM804 893.9c1.9 1.1 3.3 1.3 4.5-.5-.9-.7-1.7-1.3-2.5-2-.6.7-1.2 1.5-2 2.5zm-104.6 76.6c.1-.3.2-.5.3-.8-2.3-2.4-2.6-2.5-5.2-1 1.7.6 3.3 1.2 4.9 1.8zM228.1 854c.3.3.6.7.9 1 1.7-1.3 3.3-2.7 5-4-.2-.3-.4-.5-.7-.8-1.7 1.3-3.5 2.5-5.2 3.8zm635.6-24.9c.3 1.1.5 2.1.8 3.2 1.1-.1 2-.2 2.8-.3l.6-.6c-1.1-1-2.2-1.9-3.3-2.9l-.9.6zM710.3 965.8c1.3 2.3 1.7 2.4 3.9 1.1-.4-.7-.7-1.5-1.1-2.3-1.1.4-1.9.7-2.8 1.2zm-62.2 1.9c.9 1.1 1.6 2 2.3 2.9.3-.2.7-.4 1-.6-.2-1.2-.5-2.4-.7-3.8-1 .6-1.7 1-2.6 1.5zM206 820c.1 1.2.2 2.4.2 3.6 1.3-.2 2.3-.3 3.3-.4-1.1-1.3-2-2.4-3-3.5-.1.1-.3.2-.5.3zm603.1 82.4c.2.2.3.4.5.5.9-.1 1.8-.2 3.5-.3-.8-1.3-1.3-2.1-1.7-2.9-.8.9-1.5 1.8-2.3 2.7zM153.8 735.9c.1 1.2.2 2.3.3 3.5 1.2-.2 2.1-.3 3.2-.4-1-1.3-1.9-2.4-2.8-3.5-.2.2-.4.3-.7.4zm543 245.1c-.4.4.1 1.5.1 2.3.3.1.5.2.8.3.7-.8 1.4-1.6 2.2-2.4-.2-.3-.4-.6-.5-.9-.9.1-2 .1-2.6.7zm207.5-237.8c.4.3 1.2.8 1.3.7.7-.8 1.2-1.6 1.8-2.5-.5-.3-.9-.6-1.4-.9-.5 1-1.1 1.9-1.7 2.7zM659.4 967c.3.1.7.2 1 .4.5-1 1.1-2 1.4-3 .1-.3-.7-.9-1.4-1.7-.4 1.8-.7 3.1-1 4.3zm214.1-162.1c1.3-.8 2.2-1.3 3.6-2.2-1.5-.5-2.5-.8-3.6-1.1v3.3zm-718.9-70.7c1.5.9 2.6 1.6 4.1 2.5-.8-3.1-1.5-3.5-4.1-2.5zm543.2 241.7c-1.4-.1-2.8-.2-4.1-.3 2.2 2.3 2.8 2.2 4.1.3zm213-220.5c.4.1 1.1.5 1.3.3.7-.6 1.3-1.4 1.9-2.2-.4-.3-.8-.5-1.1-.8-.8 1-1.4 1.8-2.1 2.7zm-732.6 47.9c-.1.3-.3.6-.4.9 1.2.4 2.4.8 4 1.4-.6-2.7-2-2.6-3.6-2.3zm516.6 158.4c-1.3.7-2.5 1.4-3.8 2.1.2.3.4.7.7 1 1.2-.7 2.5-1.5 3.7-2.2-.2-.2-.4-.5-.6-.9zm-417.5-74.2c-.3 1.1-.5 2.2-.8 3.3.3.2.6.3.9.5.4-.8 1.1-1.5 1.2-2.3.1-.5-.5-1.1-.8-1.7-.1.1-.3.1-.5.2zM169 781.5c.2.7 1.2 1.1 2.1 1.9-.4-1.7-.7-2.8-1.2-4.6-.4 1.2-1 2.1-.9 2.7zm496 177.4c-1.4.5-2.7 1-4.6 1.7 3.4 1.1 4.2.8 4.6-1.7zM125.8 720.1l3.6 1.2c.2-.3.3-.7.5-1-1.1-.5-2.3-1-3.4-1.6-.3.5-.5 1-.7 1.4zm84.5 100.2c.2-.2.4-.4.6-.5-.6-.7-1-1.5-1.7-1.9-.5-.3-1.4.1-2.7.2 1.4 1 2.1 1.5 2.9 2 .2 0 .6.1.9.2zM840 847.7c-.9 1-1.6 1.8-2.3 2.6 3 .4 3.3 0 2.3-2.6zM629.6 974.6c.2.3.5.6.7.9 1.2-.8 2.3-1.7 3.5-2.5-.3-.3-.5-.6-.8-.9-1.1.8-2.2 1.7-3.4 
                    2.5zM119 677.6h.7c.2-1.4.5-2.7.7-4.1-.5 0-.9-.1-1.4-.1v4.2zM707.9 892c-1.2.4-2.1 1.9-3.1 2.9l.5.5c.9-.7 1.7-1.4 2.5-2 1.1.6 1.9 1 2.8 1.5.2-2.3-1.2-3.3-2.7-2.9zm16-11.5c.2.9.9 1.7 1.5 2.6.3-.1.5-.2.8-.3l.3-3c-.2-.2-.4-.4-.7-.6-.7.5-2 1-1.9 1.3zm-23.5 15.8c.7 0 1.3-.1 2-.1v-2.7c-1.2-.2-2.3-.4-3.6-.7.6 1.3 1.1 2.3 1.6 3.5zm12.2-7.9c-2 .2-2.4.7-2.3 3.2 1.9-1.3 3.7-2.6 5.2-3.6-.9-1.1-1.6-2.1-2.5-3.2-2.4.7-.1 2.4-.4 3.6z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape21($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M919.9 538.7c-4.1.7-5.5 4.8-6.4 9.2-1.3 6.1-1.8 12.3-2.1 18.6-.1 1.9.5 2.6 1.8 2.7.4 0 .8 0 1.1-.1 1.5-.5 2.5.2 3.2 2 .2.4.4.8.8 1.4 3.1-7.6 4.7-16.1 9.5-22.8.4 1.6.8 2.8 1 4 2.4 11.9 3 24 2.2 36.2-1 15.5-3.9 30.6-7.2 45.5-3.5 15.6-7.1 31-10.6 46.6-.4 2-1.2 3.4-2.4 4.6-.9.9-1.9 1.8-2.7 2.8-2.5 2.9-2.9 4.7-1.7 8.8.6 2.2.9 4.5.5 6.8-.5 2.8-1.5 5.1-3.4 6.6-2.1 1.7-4.3 3.5-6.4 5.3-3.8 3.1-6.3 7.5-7.5 13.3-.5 2.1.2 3.3 1.7 2.8 1.1-.3 2.1-1.2 3.1-1.9 1.2-1 2.4-2.2 3.5-3.3 1.2-1.2 2.5-1.1 4-.7 0 .7.2 1.4 0 1.8-1.7 3.4-3.3 6.8-5.2 9.9-1.5 2.4-3.5 4-5.7 4.8-6.5 2.3-10.5 8.2-13.8 15.5-1.2 2.7-.9 3.6 1.5 4.2.2.1.4.2.7.4-.1 2.3-1.1 3.9-2.3 5.3-2.3 2.7-4.5 5.4-6.9 8.1-10.7 12.1-21.4 24.2-32 36.4-1.5 1.7-2.7 2.2-4.5.8-1-.8-2.1-1.2-3.2-1.7-4-1.8-8.3.3-10.8 5.3.4 1.3 1.3 1.6 2.2 1.4 1.1-.2 2.3-.5 3.4-.7.9-.2 1.7-.4 2.6-.6.3 1.8-.5 2.4-1 3.2-3.7 5.9-8.5 8.6-14.3 8.5-1.1 0-2.3.1-3.4.4-1.6.4-2.9 1.3-3.9 3.3-2.3 4.9-6 7.5-10 9.2-4.8 2.1-9.6 3.8-14.5 5.4-5 1.7-10.1 2.8-15 5.4-2.3 1.3-4.6 2.8-6.4 5.2-.5.6-.9 1.5-1.4 2.4 1.9 1.3 3.6 1.2 5.2.9 4.1-.7 8.1-1.6 12.2-2.6 3.9-1 7.7-2.3 11.6-3.3 1.5-.4 3-.4 4.5-.6.1.2.1.4.2.6-.3.5-.5 1-.9 1.4-8.1 7.1-16.9 11.1-26.6 11.8-2.2.1-4.4 0-6.6 0-1.2 0-2.2.2-3 1.6-1.8 2.7-4.2 4-6.7 4.9-5.3 2.1-10.8 2.3-16.3 2.5-4.6.1-9.1.5-13.7.7-.6 0-1.2.2-1.8.6-.9.6-1 2 0 2.5.7.4 1.6.5 2.4.6.8.1 1.5-.2 2.3-.2 1 0 1.8.4 2.3 1.9-.5.4-.9.8-1.3 1-7.7 2.7-15.5 3-23.4 1.7-5.4-.9-10.9-1.5-16.4-2.2-.5-.1-.9 0-1.4 0-2.5.2-3 1-3 4.3 0 .4 0 .8-.1 1.5-2.6.4-5.1.3-7.7-.4-4-1.1-7.4-3.6-10.8-6.4-.6-.5-1.4-1-1.9-1.7-2.6-3.1-5.7-3-8.8-2.2-.7.2-1.5.5-2.2.9-2.1 1.3-2.5 2.8-1.6 5.6.2.6.4 1.3.7 2.3-1.6-.3-3-.5-4.3-.8-9.8-2.3-19.4-5.4-28.9-9.2-12.5-4.9-24.7-11.1-36.5-18.4-16.7-10.3-32.4-23-47.3-37.4-8.9-8.6-17.3-18-25.3-28-13.5-16.9-25.6-35.4-36.5-55.3-.7-1.3-1.4-2.5-.7-4.4.3-.7 0-2.3-.4-3.2-1.7-3.7-3.5-7.3-5.3-11.1-1.9 1.3-2.1 3.9-3.6 5.5-.6-.6-1.4-1.2-2-2-.9-1.1-1.7-2.4-2.6-3.4-.9-1-2-1.6-3.4-2.7-.7-2.7.4-4.8 3-4.3 1.4.3 2.7 1.2 4.1 1.9.6.3 1.2.9 2.1 1.1-.3-.7-.6-1.5-1-2.2-2.4-4.6-4.7-9.2-6.1-14.6-.7-2.8-1.4-5.6-.6-8.6.3-1.4-.2-2-1.1-2.5-5.9-3.8-10.7-9.4-14.7-16.2-.3-.5-.5-1-.7-1.5-.1-.2 0-.4 0-.7 1.2-.6 2.2.2 3.1 1 1.4 1.2 2.8 2.5 4.2 3.7.8.6 1.6 1.2 2.5 1.6 1 .5 1.9.1 2.6-1.1-.1-.3-.2-.7-.3-.8-6.8-5.9-12.1-14.2-17.8-21.8-.1-.1-.3 0-.6 0 .1.7.1 1.3.2 2s.3 1.4.3 2.1c-.1 2.4-1.7 3.6-3.1 2.2-2.4-2.6-4.8-5.4-7.1-8.1-2.9-3.4-5.7-7-8.7-10.3-1-1.1-2-2.5-3.9-2.7.3 1.4.5 2.5.9 3.5.5 1.3 1.2 2.4 1.6 3.7.2.6.4 1.9.2 2.1-.5.5-1.3.8-1.8.6-.9-.4-1.7-1.3-2.4-2.1-1-1.1-1.8-2.5-2.7-3.7-.3-.5-.8-.7-1.5-1.4-.1 1.3-.1 2.1-.2 3-.2 1.6-.8 2.2-2 2.3-1.8.1-3.6.3-5.8.4-8.5-18.2-17.8-36.4-23.9-56.9 1.2-1.1 2.5-1.9 3.5-3.1 1-1.2 1.7-2.8 2.6-4.2 1.7-2.8 2.9-2.9 4.9-.2.5.6.9 1.3 1.7 2.5.2-1.2.5-1.9.4-2.4-.2-1.2-.6-2.3-.9-3.4-.6-2.3-1.2-4.6-1.9-6.8-.2-.8-.4-1.5-.8-2.2-.9-1.8-1.4-2-2.8-.8l-.9.9c-1.4 1.1-2.3.7-2.8-1.3-.6-2.3-1-4.7-1.5-7-.5-1.8-1-3.6-1.7-5.3-.8-1.8-1.5-1.7-2.7-.4-.5.6-1.2 1-2.1 1.6.3 3.5 2.2 6.9 1.6 11.1-1-.4-1.2-1.4-1.5-2.3-2.6-7.3-4.7-14.9-6.5-22.7-3.3-14.6-5.3-29.6-7.1-44.6-.7-6.3-1.3-12.7-2-19-.1-.8 0-2 .4-2.4.8-.8 1.6 0 2.2.9.4.7.8 1.6.9 2.4.3 2.4.5 4.8.7 7.2.1.8.1 1.5.2 2.5 1.3-1.1 1.3-2.5 1.6-3.9.9-5.1.6-10.1-.9-14.9-.2-.7-.5-1.5-.9-2.1-1.7-3.1-4.5-3.1-6.1.1-1.5 3-2.5 6.3-2.7 9.9-.2 3.8-.2 7.7-.2 11.5 0 1 .1 2-.2 3.2-.2-.4-.5-.7-.7-1.2-2.1-6.4-2.8-13.2-3.1-20.1-.5-11.5.2-22.9 1.4-34.3.1-.9.3-1.9.4-2.8.2 0 .4-.1.5-.1.4.8.9 1.5 1.1 2.4.3 1.9.6 3.8.7 5.7.1 2.7.1 5.5.2 8.2.1 1.2.3 2.5.5 3.8 1.4-.6 1.7-2 1.9-3.2.7-3.1 1.3-6.2 2-9.3.2-.8.4-1.6.7-2.2.3-.6.9-1.4 1.3-1.3.5.1.9.9 1.2 1.6.3.8.4 1.8.8 2.5.4.8 1 1.9 1.5 1.9s1.4-1 1.6-1.8c.6-2.5 1.3-5.1 1.4-7.6.3-7.3-.5-14.4-2.6-21.1-.8-2.5-2-4.7-3.1-7-.4-.9-.8-1.6-.7-2.7.4-4 .7-8 .9-12.1.2-5 .7-9.9 1.8-14.6.8-3.5.2-4.6-2.5-5-.4-.1-.8-.1-1.1-.2-1.5-.4-1.7-.8-1.3-2.6 1.5-5.8 2-11.9 2.8-17.9.4-3.2 1.1-6.3 1.8-10 2.5 2.9 1.5 6.6 2.4 9.9 2.7-3.6 2.2-9.1 5.1-12.5.4.7.8 1.2 1 1.8.9 3.8 1.7 7.6 2.5 11.4.8 3.8 1.5 7.6 2.4 11.4.2.9.7 1.7.9 2.4 2.9-2.1 5.5-4.1 8.2-6.1.2.2.4.4.4.7.4 5.4.8 10.9 1 16.4.1 3.6-1.3 5-4.1 4.3-1.2-.3-2.3-.8-3.5-1.2-2.1 3.5-2.2 10.8-.2 15.3 1.6-1.1.9-3.7 2.1-5.5.3.9.7 1.5.8 2.2 1 6 1.9 12.1 2.9 18.1.1.7.2 1.3.4 2.3.8-1 1.4-1.8 2.3-2.9.5 1.2 1.2 2.2 1.4 3.2 1.1 6.1 1.4 12.2.4 18.4-.3 1.6-.1 2.6.8 3.8 2.7 3.6 3.3 8.4 3.8 13.1.3 2.6.2 5.2.3 8.2.6-.3 1.2-.3 1.6-.7 1.2-1.2 2.5-2.4 3.6-3.7 1.3-1.6 1.3-2.1.3-4.1-2.2-4.6-4-9.3-5.1-14.6-1.8-8.8-1.8-17.6-1-26.6 1.5-17.3 5.9-33.3 11.8-48.7 7-18.6 15.9-35.6 26.1-51.3 5.6-8.7 11.5-17.1 17.5-25.2 9.3-12.5 19.2-24 29.3-35.4 11.1-12.5 22.2-25 33.3-37.6 1-1.2 2-2.4 3-3.7-.1-.2-.1-.4-.2-.6-.6.3-1.2.5-1.7.9-10.5 7.8-21.1 15.4-31.5 23.6-14 11-27.1 23.7-39.4 38.1-15.3 18-28.6 38.3-38.8 61.9-5.6 12.9-10.2 26.3-13.4 40.6-.2 1-.5 2-1.2 3-.1-.5-.3-1-.4-1.6-.7-6.3-.4-12.5.6-18.8 1.7-11.5 5.2-22 9.6-32.1 6.2-14.3 13.8-27.2 22.3-39.2 13.2-18.6 28.1-34.5 43.4-49.9 4.2-4.2 8.4-8.5 12.5-12.8.7-.7 1.3-1.6 1.8-2.7-5 2.4-9.9 4.8-14.9 7.2l-.3-.3c.5-.6.9-1.3 1.5-1.9 16.5-16.8 33.6-32.4 51.5-46.3 16-12.3 32.5-23.2 49.6-32.5 11.9-6.4 24.1-12 36.5-16.7 9.9-3.7 19.9-6.9 30-9.3 10.2-2.4 20.5-4.1 30.8-5 11.5-1.1 23-1.1 34.5-.3 8.4.6 16.7 1.9 25 3.7 9.8 2.1 19.4 5.2 28.9 8.9.8.3 1.6.6 2.4 1.1 6 3.9 12.5 2.9 18.8 4.2 15.8 3.2 30.9 9.1 44.7 20.2 2.2 1.8 4.2 4.1 6.2 6.1.3.3.6.9 1.1 1.8-1.9-.2-3.3-.4-4.7-.6-.4 1.5.4 1.9.9 2.5 2.1 2.3 4.3 4.5 6.4 6.9.9 1 1.7 2.3 2.5 3.6.5.8.8 2 .2 2.8-.4.5-1.3.6-1.9.4-3.6-1.5-7.1-3-10.6-4.7-5.9-2.8-11.7-5.8-17.6-8.4-4.3-1.9-8.7-2.8-13.3-1.8l-.9.3s-.1.2-.2.6c.5.4 1.1.8 1.7 1.1 19.6 9 37.5 22.5 53.8 39.4 6.4 6.6 12.5 13.7 18.7 20.5.4.5.8 1 1.2 1.4.5.7 1.3 1.3.8 2.5-.5 1.3-1.4 1.5-2.3 1.2-1.1-.4-2.1-1.1-3.2-1.7l-3.6-2.1c-.4-.2-1-.1-2-.2.7.9.9 1.4 1.3 1.7 10.6 9 20.3 19.8 30.1 30.2 3.6 3.8 7.4 7.4 11.2 11.1.5.4 1 .7 1.7.8-2.5-5.6-5.9-10.1-9.5-14.4-3.6-4.2-7.1-8.4-10.6-13.2.5 0 .9-.1 1.4.1 4.9 1.9 9.3 5 13.6 8.6 7.2 6.1 13.8 13.4 19.9 21.4 14.5 18.8 26.1 40.5 35.5 64.2 2.8 7.1 5.3 14.4 8 21.6.4 1 .6 2 .9 3-.1.1-.3.2-.4.4-.6-1-1.2-1.9-1.7-2.9-3.7-7.2-7.5-14.4-11.2-21.5-5.7-10.7-11.6-21.1-18.7-30.4-4-5.3-8.3-10.2-13.1-14.2-.7-.6-1.4-1.1-2-1.6-.1.2-.3.4-.4.6.3.8.6 1.7 1 2.5 2.5 5.4 5.8 9.9 9.3 14.2 4.2 5.2 8.4 10.3 12.6 15.5 2.6 3.3 4.9 7.1 6.1 11.6.6 2.2.9 4.7 1.1 7.1.1.9-.2 1.9-.4 3.2-.9-.7-1.5-1.2-2-1.7-1-.8-2-1.5-3.2-.8-1.1.7-1.8 0-2.5-1.1-5.5-8-9.6-17-12.4-27.1-.5-1.9-1.1-3.7-1.7-5.5-.2 0-.4.1-.5.1-.1.8-.2 1.7-.3 2.5-.2 5.6 1.3 10.5 3 15.4 3 8.4 6.8 16.1 10.5 23.9 7.2 14.9 14.4 29.9 20.8 45.5 5.7 14.1 10.7 28.7 14.3 44 2.1 8.7 3.5 17.7 4 26.8 0 .9 0 1.8-.1 2.7 0 .2-.2.5-.5 1.3-.4-1.3-.6-2.2-.9-3.1-2.1-8-4-16-7-23.4-1.1-2.8-2.5-5.3-3.8-7.9-1-1.9-2.2-2.9-4.1-1.7-1.1.7-2.4.6-3.5 1.2-1.3.7-2.4 1.6-3.6 2.6-.9.8-1 1.8-.4 3.1 1.4 3.4 2.4 7 2.9 10.8.6 4.5 0 8.7-1.1 12.9-2 7.4-1.4 14.6.7 21.7.1.5.3 1 .4 1.4.6 2.2.5 2.8-1.2 3.1-1.3.3-1.6 1.3-1.7 2.7-.1 1.1-.1 2.2-.1 3.3-.1 13.6-.6 27.2-2.2 40.6-.6 5.2-1.3 10.5-2.8 15.6-.1-.3-.2-.7-.2-1 0-2.7.1-5.5.1-8.2 0-1.5.2-3-1.1-4-.4-.3-.5-1.6-.6-2.5-.3-5.6-.6-11.1-.8-16.7-.2-6.3-.2-12.6-1.6-18.7-.6-2.4-1.7-4.5-2.6-6.7-.2-.5-.6-.7-1.2-1.4-.1 1.1-.2 1.7-.2 2.3.2 8 .5 16 .6 24 .1 6.8.3 13.6 1.9 20.2.3 0 .3.4.3 1zM456.4 692.6c.7 1.3 1 2 1.3 2.6 1.5 2.8 3.1 5.5 4.7 8.3 6.7 12.2 13.2 24.6 19.9 36.8 6.3 11.4 13.3 22 21.2 31.4 5.5 6.5 11.4 12.2 18.1 16.2.4.2.8.3 1.5.6-.7-2.7-1.9-4.4-3.2-5.9-3.9-4.4-7.9-8.6-11.8-13-2.8-3.1-5.6-6.2-8.3-9.6-2-2.5-3.5-5.6-4.4-9.1-.3-1.2-.9-2.4-.1-4 .9.7 1.7 1.3 2.5 2.1 1.7 1.8 3.2 3.8 4.9 5.5 1.3 1.3 2.6 2.4 4 3.5.7.5 1.6.9 2.5-.5-.6-1.1-1.2-2.2-1.9-3.2-7.6-11.6-15.4-23-22.9-34.8-8.5-13.3-15.8-27.8-21.4-43.7-.1-.3-.1-.7-.3-.8-.5-.4-1-1.2-1.5-1.1-.5.2-1.1.9-1.4 1.6-.2.4-.1 1.2-.1 1.8 0 1.5-.3 2.9-1.3 4.4-2.3-4.4-5.9-3.4-9.2-4.7 0 3.2 1.3 4.9 2.7 6.4 1.1 1.1 2.4 1.8 3.6 2.7 1.2.9 2.5 1.6 3.6 2.7.9.8 1.8 1.9 1.5 4-1.2-.2-2.4-.2-4.2-.2zM454.8 357c.2.2.4.4.5.7-4 11.3-8.7 22.2-12.6 34.1 1.5-.1 2.6-.1 3.7-.2 1.5-.1 1.7 2.1 2.9 3 .5-1.4 1.1-2.5 1.5-3.8 1.2-3.9 2.4-7.9 3.5-11.9 2.6-9.6 5-19.4 8.6-28.5.2-.6.4-1.3.7-2.5-2.3 2.2-3.3 5.4-5.9 7.3.1-2.3.1-4 .4-5.5.8-4.5 2.8-8.1 5-11.5 2.5-3.8 5.2-7.5 7.6-11.4 1.5-2.5 3-5.2 4.1-8 .9-2.3 1.2-4.9-.2-7.4-.3.2-.6.2-.8.4-.3.3-.6.7-.8 1.1-8.9 13.5-17.6 27.2-25.5 41.9-6.9 13-12.9 26.5-16.8 41.7-.3 1.3-.6 2.6-1 4.3.6-.4.9-.4 1-.6.5-.6 1-1.3 1.4-2 2.6-5.5 5.3-10.9 7.8-16.5 3.2-7.3 6.2-14.7 11-20.5 1.3-1.5 2.6-2.8 3.9-4.2zm27.1 309c1.8-1.9 1.9-2.3 1.1-4.6-1.9-5.4-3.9-10.8-5.8-16.2-.7-2.1-1.3-4.3-2.1-6.4-.7-1.9-1.3-2.1-2.7-1.1-1.9 1.3-3.9 1.6-6 .9-2.3-.8-4.6-1.5-6.9-2.2-1-.3-2.1-.5-2.9.6 2.2 4.5 4.2 8.7 6.4 13.2.6-.5 1.1-.9 1.5-1.3.7-.6 1.3-1.4 2-2 1.2-.9 2.2-.5 3 .9.8 1.3.8 2.1-.2 3.7l-.6.9c-1 1.8-1 2.8.2 4.5 1.4 2.1 3.2 3.4 5.3 3.8 2.7.4 5 1.7 6.8 4.4.2.4.5.6.9.9zm434.4-242c-.4.1-.7.1-.9.2-.4.2-.8.5-1.2.8-1.2.9-1.4 1.4-.8 3.2 3.3 9.6 4.8 19.8 6.3 30 .9 6.1 1.9 12.1 3.9 17.7.3.9.8 1.8 1.1 2.7.2-.1.4-.1.6-.2 0-1.1 0-2.1.1-3.2.4-5.8-.2-12 3.9-16.1-1.4-3.7-2.7-7.3-4-10.8-2.5-7-5-14.1-7.5-21.1-.4-1.2-1-2.2-1.5-3.2zM479.1 583.5c.5-2-.7-4.3.5-6.5.6 1.4 1 2.5 1.6 4 1.3-1.6 2.4-2.9 3.4-4.4.6-.9.8-1.9.3-3-1.8-4-4-7.5-7.2-9.5-1.9-1.2-4-2.4-6.5-1.3.6 3.8-.5 7.2-1.2 10.7-.3 1.2-.4 2.6-.3 3.9 0 2.2.4 2.8 2 3.4 2.4.8 4.8 1.7 7.4 2.7zm-5.8-244.8c1.9-.4 3.5-1.7 4.8-3.5 1.8-2.6 3.6-5.2 5.2-8.1 3.5-6.3 6.3-13.4 10.9-18.6.2-.2.1-.8.2-1.3-1.7-.2-1.7 3.1-3.6 2.5-.1-.7-.2-1.4-.3-2.6-6.9 8.9-12.8 18.1-18.6 27.3.4 1.4.8 2.6 1.4 4.3zm-45.3 4.2c5.5-3 26.8-35 27.7-41.5-1.7 2.5-3.2 4.8-4.8 6.9-6.2 7.9-12.5 15.8-18.6 23.8-1.3 1.7-2.3 3.8-3.2 5.9-.6 1.3-.7 3-1.1 4.9zm64.9 342.2c-2.7-6.1-5.1-11.6-7.5-17.3-.6.7-1 1-1.4 1.5-1 1.6-2 3.3-2.9 5-2.5 4.4-2.4 4.4.2 8.8.8 1.3 1.6 1.9 2.9 1.9 2.7 0 5.4.1 8.7.1zm.4.9c-.2.1-.4.3-.6.4.3 8.4 5.5 13.1 9.2 19.7h-5.3c-.1.2-.1.5-.2.7 1.4 1.9 2.9 3.8 4.3 5.6 1.4 1.8 2.9 3.6 4.4 5.3 1.5 1.8 3.1 3.6 4.7 5.2s2.9 3.6 5 4.3c-1-2.2-2.1-4.2-3.2-6.2-.6-1.1-1.4-1.8-2.4-2.1-.8-.2-1.5-.8-2.3-1.2 1-3.4-.2-5.5-2-7.2-.2-.2-.5-.5-.8-.7-1-.7-1.5-1.5-1-3.2.2-.6-.2-1.5-.5-2.1-2.8-5.7-5.6-11.3-8.4-17-.2-.4-.6-.9-.9-1.5zM364.7 488.4c-.4-3.8 1-7.2 1.9-10.9.5-2.1.4-4.6.5-6.9 
                                    0-1.2-.6-1.8-1.5-1.8H361c-1.1 0-1.5.8-1.5 2.1.1 4.9.2 9.7.4 14.6.1 1.7.5 3.4 1.6 4.4 1.1-.4 2.1-.9 3.2-1.5zm554.6 117.2c-1.2.2-1.7 1.3-2 2.6-.4 1.7-.7 3.5-.9 5.3-.3 2.8-.4 5.7-.8 8.4-.3 1.8-.9 3.6-1.7 5.2-1 2.1-.7 3.5 1.2 3.7 1.1.2 2.1.1 3.2.1 1.8 0 1.7 0 2.3-2.4 1.7-7.7.3-15.1-1-22.5 0-.1-.1-.2-.3-.4zM464.7 279.5c-6.2 3.3-25 29.1-26.5 36.2 1-1 1.7-1.6 2.4-2.4 3-3.9 6-7.7 8.9-11.7 4.7-6.6 9.3-13.3 14-20 .3-.7.8-1.4 1.2-2.1zm46.6 6c-1.7 1.5-3.6 2.9-5.3 4.5-.5.4-.9 1.4-.9 2.2-.1 1.6-.1 3.2-.9 4.6-.6 1.2-.1 2.1.6 2.9.7.8 1.4.6 2-.2 1.8-2.1 3.7-4.2 5.5-6.3 1-1.2 1.5-2.7 1.4-4-.8-1.3-1.5-2.3-2.4-3.7zm302 508.6c-1.6-.7-2.7-.2-3.8.7-1.8 1.5-3.5 3.1-5.4 4.4-1.1.7-1.5 1.5-1.2 3 .1.6.1 1.2.2 1.8.4 2.7 1.3 3.4 3.2 2.3.5-.3 1-.6 1.4-1 2.8-2.9 4.3-6.8 5.6-11.2zM484.7 256.9c0 .2.1.5.1.7.6-.2 1.3-.2 1.8-.6 2.4-1.7 4.9-3.4 7.1-5.5 4.4-4.3 8.7-8.8 13-13.3.2-.2.2-.5.4-.7-1.5 0-1.9 0-3.8 1.5-2.8 2.3-5.5 4.7-8.1 7.3-3.5 3.5-7 7.1-10.5 10.6zm305.2 552.7c-.1-.5-.1-.6-.1-.7-1.5-2.5-2.9-3.1-4.9-1.7-2.4 1.6-4.7 3.3-7 5.1-.8.6-.8 1.9 0 2.5.6.4 1.3.8 1.9.8 1.1 0 2.3-.2 3.4-.6 2.6-1 4.9-2.7 6.7-5.4zm41.3-23.2c-2.8-2.7-5.5-2.8-8.2-1-1.9 1.2-3.3 3-3.6 6.3 2.2 0 4.1.1 6 0 2.5-.2 4.2-2.2 5.8-5.3zM489 647c.7 3.2 3.9 9.9 5.6 11.3.8-1.1 1.7-2.2 2.5-3.4.3-.4.4-1.3.3-1.9-1.1-4.6-4.6-7.2-8.4-6zm-66.4-305.3c.9-.8 1.5-1.3 2-2 1.1-1.7 2.3-3.5 3.3-5.4 1.9-3.8 3.6-7.7 5.3-11.6.2-.4.2-.8.3-1.5-2.7 1.7-9.5 14.5-10.9 20.5zm488.8 254.9c-.5.1-.6.1-.7.2-2.9 2.7-3.9 8.1-2.2 12 .2.5 1 .9 1.5.9.3 0 .9-.9.9-1.4.3-3.4.6-6.8.8-10.2 0-.5-.2-.9-.3-1.5zm-1-78c-.7 2.4-.4 4.6-.2 6.7.2 2.2.5 4.4.7 6.6.4 4.8.4 4.8 1.5 6.4.1-2.1.3-3.9.3-5.7-.1-3.9-.3-7.9-.5-11.8-.1-1.2-.6-2-1.8-2.2zm-551-153.1c-.6.8-1.1 1.1-1.3 1.7-1 2.9-1.1 5.8-.3 8.8.1.5.4 1.2.8 1.4.5.3 1.2.6 1.6.3.4-.3.9-1.2.9-1.8-.1-2.6-.2-5.2-.5-7.8 0-.8-.7-1.6-1.2-2.6zm77.8 43.4c-1.8 3.7-2.7 7.8-3.8 11.9-.3.9-.3 1.9.6 2.2.8.3 1-.6 1.2-1.4 1.1-4.1 1.8-8.3 2-12.7zm490 87.2c1.8-4.6 1.8-4.8 0-6.8-1.4 1.9-1.4 2.9 0 6.8zm-463.3 170c.2 1.2.7 1.9 1.6 1.4-.5-.5-1-1-1.6-1.4zm-3.6-.1c-.3.3-.5.6-.8 1 .3.4.6.9.8 1.3.2-.6.2-.8.2-1.1-.1-.4-.1-.8-.2-1.2z"/>
                                <path class="st1" d="M428.8 722.1c.9 1.1 1.9 2.2 2.8 3.4 7.9 10.2 14.9 21.4 21.8 32.8 7.6 12.5 15.1 25 23.4 36.6 5.9 8.3 12.2 16.2 19.3 22.8 4.8 4.4 9.7 8.4 15 11.5.4.2.8.4 1.5.1-.4-.5-.7-1.1-1.1-1.5-6.1-6.9-12.4-13.5-18.3-20.6-19.3-23.2-36.9-48.4-51.8-76.8-3.7-7-7-14.2-10.5-21.4-.2-.5-.3-1.1-.6-1.8 1-.3 1.5.5 2 1.2 3.4 4.4 6.9 8.6 10 13.3 7.5 11.1 14.7 22.5 22.2 33.6 7.4 11 15 21.6 23.2 31.6 7.9 9.7 15.7 19.6 23.8 28.9 14.2 16.4 28.8 32.1 45.2 44.4 11.6 8.7 23.6 16.2 36.6 20.1 3.5 1.1 5.9 3.6 8 6.9 1.1 1.7 2.3 3.2 2.8 5.6-1.1.9-2.3.6-3.4.4-6-.8-11.8-3.2-17.4-6.2-8.2-4.3-15.9-9.7-23.7-15-2.8-1.9-5.7-3.5-8.5-5.1-.4-.2-.8-.3-1.6-.5 1.2 3.9 4.5 5.3 5.2 9.3-1.9.8-3.4-.1-4.8-1.1-4-2.7-8-5.5-11.9-8.5-11-8.4-21.2-18.4-31.5-28.2-6-5.7-11.7-11.7-17.8-17.1-3.3-2.9-5.6-6.5-7.8-10.7-3.5-6.5-7.5-12.6-11.5-18.5-8.6-12.7-17.7-24.9-25.7-38.4-5.2-8.9-10.1-18.1-14.3-27.9-.4-.9-.7-1.9-1.1-2.8.2-.2.3-.3.5-.4zm100.8 125.7c1.5 5.8 9.6 13.9 14.2 14.4-.4-4.1-8.9-12.9-14.2-14.4zm-126.4-79.1c-1.4.5-2.3-.4-3.2-1.3-1.7-1.7-3.3-3.6-4.9-5.4-1.1-1.2-2.2-2.5-3.4-3.6-.6-.5-1.3-.8-2.1-1.3-.4 2.2.2 3.4 1 4.5 1.4 1.8 2.9 3.6 4.4 5.3 1.1 1.2 2.3 2.3 3.5 3.5.7.7 1.3 1.5 1.8 2.3.6.8.9 1.8.2 2.7-.6.8-1.3.4-1.8-.2-2.1-2-4.2-4-6.3-6.1-7.2-7.4-14-15.4-20.5-23.8-5.2-6.8-10.4-13.8-15.5-20.6-1-1.3-1.7-2.6-1.7-4.7 0-2.9-1.2-5.4-2.5-7.7-2.4-4.2-4.9-8.3-7.4-12.4-5-8-10-16.1-13.8-25.4-.7-1.6-1.3-3.2-1.9-4.9-.2-.6-.3-1.3-.5-2.3.6.4.9.5 1 .7 24.2 33.9 47.5 69.1 73.6 100.7zm556.4-346.4c-1.8-.2-2.9-1.3-3.8-2.6-1.8-2.5-3.6-4.9-5.2-7.7-6.5-11.9-11.8-24.6-15.3-38.6-1-4-1.7-8-1.2-12.2.3-2.6.8-3.8 2.3-5.4.2.2.5.4.6.7 4.7 11.6 9.5 23.1 14.2 34.7 3.5 8.8 6.4 17.9 8 27.7.2 1.1.3 2.1.4 3.4zM906 244.5c-20.5-26.1-43-48.4-67.8-67.2.7-1.8 1.3-3.4 1.9-5.1.6.3 1.1.5 1.4.8 10.9 9.2 21.8 18.3 32.5 27.7 8.1 7.1 15.7 15.1 22.5 24.3 3.3 4.5 6.4 9.3 8.6 14.9.5 1.3.9 2.7 1.3 4.1-.1.1-.2.3-.4.5zM341.4 507.4c.8 2.4 1.7 4.7 2.3 7.1 3.1 11.9 6.1 23.8 9.1 35.7 3.1 12.2 6 24.4 9.2 36.6 2.3 9 4.9 17.9 7.3 26.9.1.4.1.9-.2 1.7-.7-.9-1.4-1.7-2-2.7-4.4-7-7.6-14.9-10.3-23.2-4-12.2-6.8-24.9-9-37.9-2.4-14.3-4.6-28.7-6.9-43.1v-.9c.2 0 .3-.1.5-.2zm604.4-221.9c-24.3-41.8-52.6-78.2-83.7-111 7 3.8 32.2 28.6 47.1 48.4 14.2 18.9 26.8 39.2 36.6 62.6zm12.4 47.9c-1.9-3.4-3.7-6.9-5.6-10.3-8-14.2-16.2-28.2-24.1-42.5-4.2-7.6-8.2-15.3-12.3-23.1-1-2-1.8-4.3-2.6-6.4-.2-.7-.3-1.4-.2-2.3 19.1 24.4 34.9 51.7 45.4 84.2-.3.1-.5.2-.6.4zM327.6 661.6c-1.2-2.2-2.2-3.9-3.2-5.7-5.5-10.4-9.6-21.8-13.2-33.6-3.5-11.8-6.3-23.9-8.8-36.1-.1-.6-.1-1.2-.2-2.2 1.5-.7 3-1.4 4.7-2.1.3 1.6.6 2.8.8 4.1 1.6 11.1 4.1 21.8 7.6 32.1 2.2 6.6 4.7 12.9 8.2 18.5 2.4 3.8 3.1 8.7 3.6 13.6.4 3.2.6 6.4.8 9.7 0 .4-.1.7-.3 1.7zm-25.2-299.1c-.7 3.4-1.3 6.5-1.9 9.6-1.7 8.9-2.3 18-3 27-.9 12.1-1.6 24.2-2.5 36.3-.2 2.2-.5 4.4-.8 6.6-.1 1-.3 2.1-1.3 2.1s-1.8-.7-2-2c-.2-1-.2-2-.2-3 0-.7.1-1.4.2-2.1.3-3.6-.1-4.2-2.9-4.9 0-1.1-.1-2.3 0-3.5.9-9.7 2.4-19.2 4.3-28.6 1.7-8.5 3.4-17 4.9-25.6.6-3.3.8-6.8 1.1-10.2.3-3.3.5-3.5 2.8-2.5.4.3.8.5 1.3.8zm632.7 323.9c-2.3 8-4.5 15.8-6.8 23.8-.6-.4-1.1-.8-1.6-1.2-1.7-1.4-3.4-1.3-4.9.4-1.2 1.4-2.3 3-3.2 4.7-1.3 2.3-2.4 4.9-3.7 7.3-1 1.7-2 3.3-3.2 4.7-.7.8-1.5 1.8-2.8 1.2.3-.9.5-1.7.8-2.5 3.4-9 6.9-18 10.3-27.1 1.6-4.2 3-8.4 4.4-12.7.8-2.3 1-2.4 2.8-1.8l5.7 2.1c.7.2 1.3.6 2.2 1.1zm11.7-225.1c.6 2.3 1.2 4.4 1.5 6.5 2.1 12 4.1 23.9 6 35.9.4 2.7.1 3.2-1.9 3.5-2.2.4-4.4 0-6.4-1.4-1.3-.9-2.6-1.5-4-2-.9-.3-1.3-.9-1.5-2-.2-2.1-.6-4.2-.7-6.3-.1-2.9-.1-5.9-.2-8.8-.1-2.6.9-3.7 2.8-2.9.7.3 1.3 1 2 1.4 1.6 1.1 2.9.2 3-2.2.1-1.3-.1-2.6-.4-3.9-.7-3.7-1.5-7.4-2.3-11.2-.2-1.1-.3-2.2-.3-3.3.2-1.7.8-2.6 2.4-3.3zM345 594.1c.6.9 1.2 1.7 1.7 2.6 2.8 5.4 5.6 10.9 8.4 16.3 3.3 6.3 6.7 12.6 10 18.8 1.4 2.7 2.2 5.6 1.3 8.9-.2.8-.3 1.6-.5 2.3-.6 2-.5 4 .2 5.9.3.8.5 1.6.8 2.7-1.2.4-1.8-.7-2.4-1.4-2.6-3-4.3-6.8-5.6-11-1.3-4.4-2.6-8.9-3.9-13.3-1.3-4.4-3.4-8.1-6.2-11.1-.6-.6-1.1-1.5-1.3-2.4-.6-2.3-1-4.7-1.4-7-.5-3-1-6.1-1.5-9.2-.1-.6-.1-1.1-.2-1.7.4-.2.5-.3.6-.4zm520.5 199.2c.6.9 1.3 1.6 1.7 2.5 1.3 2.9 2.9 5.2 5.9 5.3-.3.8-.3 1.3-.5 1.7-2.3 3.6-4.6 7.4-7 10.9-1.2 1.7-2.7 3-4.1 4.4-.9.8-1.8 1-2.7-.1-2.8-3.2-5.6-6.3-8.3-9.5-.2-.2-.2-.5-.4-1 1.4-3.2 3.3-5.9 6.1-7.3.7-.4 1.4-.7 2.2-.9 2.3-.7 4.3-2.1 5.8-4.5.3-.5.7-.8 1.3-1.5zm71.3-193.4c-.3-.4-.4-.5-.4-.6.1-4.6-.8-9-1.3-13.5-.2-2.2-.3-4.4.8-6.8.9.5 1.8.9 2.6 1.5 1 .8 2 1.9 2.9 2.9 2.1 2.2 4.4 3.1 7 2.2.3-.1.7-.1 1.4-.3.1 1.5.2 2.9.2 4.3-.1 5.5-1.2 10.6-3.8 15-.7 1.2-1.6 2.2-2.5 3-.5.5-1.3.7-1.9.8-1.3.1-1.7-.8-1.3-2.5.1-.4.3-.7.4-1.1.5-2 .1-3.8-1-5.3-1.1-1.4-2.1-.5-3.1.4zM326.6 452.2c-1-28.3.7-56.4 6.3-84.5 1 1.8 1 3.3 1 4.7.1 5.6-.9 11.1-1.6 16.6-1 7.6-2 15.2-2.7 22.8-.3 2.7.1 5.4.4 8.1.2 1.9.9 3.7 2.2 4.8.9.7 1 1.7.7 2.9-.7 3.6-1.3 7.3-2.2 10.8-1.2 4.7-2.7 9.2-4.1 13.8zm201.7 436.5c-2.6-2.2-5.3-4.3-7.9-6.5-6.4-5.3-12.9-10.4-19.2-15.9-4-3.5-7.7-7.6-10.7-12.7-1.3-2.1-2.5-4.2-3-7.4.5.4.8.5 1 .7 5.7 7.2 12.3 12.6 18.9 18.1 4.5 3.8 9.1 7.5 13.4 11.5 2.1 1.9 3.8 4.3 5.6 6.6 1.1 1.4 1.9 3.1 2.3 5.1-.2.2-.3.3-.4.5zm-114.6-226c1.1.5 2.2 1 3.3 1.6 4.4 2.6 8.4 6.2 12.2 10.1 6.4 6.5 12.5 13.7 18.1 21.4.4.5.7 1 1 1.6.1.2.1.6.1 1.1-2.2-.1-4.1-1-5.9-2.2-4.6-2.8-8.5-7-12.2-11.6-5.5-6.8-11-13.7-16.5-20.6-.2-.2-.3-.5-.4-.7.2-.2.3-.4.3-.7zm473.6 120.8c-1.2-3.2-2.8-4.3-4.8-4.7-.8-.2-1.5-.9-2.4-1.4.3-.8.4-1.5.7-2 3.2-5.3 7.1-9.2 12.1-10.9 1.9-.6 3.8-.8 5.6.5 2 1.4 2.2 2.6.8 4.9-.8 1.2-1.6 2.4-2.6 3.3-3.4 2.9-7 5.1-9.4 10.3zM325.8 364.7c-1.7 7.1-1.2 14.1-1.3 21 0 1.1-.1 2.2-.3 3.3-.1.5-.4 1.4-.7 1.4-1.8.5-2.1 2.4-2.5 4.2-.1.5-.3.9-.5 1.3-1.1-.2-1.4-1.3-1.6-2.4-.4-3.2-.6-6.4-.9-9.6-.2-2.4-.3-4.9-.6-7.2-.4-2.7.1-4.8 1.7-6.5 1.3-1.4 2.1-3.1 2.4-5.3.3-2 .8-2.3 2.2-1.7.8.5 1.3.9 2.1 1.5zm-11.1 78.9c1.3 2.8 1.9 5.9 2 9.1.1 5.7.2 11.4 0 17-.2 6.8-.2 13.6.8 20.3.1.5.1 1 .1 1.5 0 .2-.1.4-.2.9-.3-.5-.6-.9-.8-1.3-2.3-7.2-3.6-14.7-3.6-22.5 0-7.7.5-15.4.8-23.1 0-.7.2-1.3.4-1.9.1.1.3 0 .5 0zM923 678.9c-.1.7 0 1.2-.1 1.6-1.4 5.3-2.7 10.7-4.3 16-.5 1.8-1.5 3.5-2.5 5-.4.7-1.2 1.3-1.9 1.6-1.6.8-2.6-.2-2.4-2.4.6-7.9 3-14.8 7.5-20.2.9-1.1 2-2.3 3.7-1.6zm-78.6 146.5c-.1.4-.1.7-.2.9-2.6 3.5-5.2 7.1-8.6 9.4-1.8 1.2-2.1 1.1-3.5-.8-1.2-1.6-2.4-3.3-3.8-5.2 4-3.4 7.7-6.7 12.4-6.4 1.4-.1 2.8.4 3.7 2.1zm109.2-154.2c-.1-.7-.2-1.2-.1-1.6.3-2.1 0-4-.5-5.9-1-3.7-.7-7.3.4-10.9.3-1.1.8-1.7 1.7-1.5 1.7.3 3.3.6 4.9 1 .8.2 1.2.8 1 2-.6 4.9-1.4 9.7-3.9 13.7-.9 1.4-1.9 2.8-3.5 3.2zm-53.8-416.6c-.2-.2-.5-.4-.7-.7-4.8-6.9-10.5-12.6-15.8-18.9-1.5-1.7-2.7-3.9-3.9-5.9-.5-.9-.9-2.1-.3-3.5.4.3.7.5 1 .8 5.1 5.7 10.2 11.3 15.2 17.1 1.9 2.2 3.7 4.6 4.6 7.8.3 1 .3 2 .5 3-.3.1-.4.2-.6.3zm32.4 50.9c-3.5-2.7-18.2-25.6-19-29.6.5.3.9.5 1.2.8 4.3 4.1 8.3 8.6 11.9 13.7 2.6 3.7 4.7 7.7 5.6 12.7.2.7.2 1.5.3 2.4zM403.4 675.2c-4.7-.4-19.2-17.3-22.7-26.7.8.3 1.3.4 1.8.8 3.6 2.5 6.6 6.1 9.5 9.8 3.7 4.9 7.3 10 10.9 15.1.2.2.3.6.5 1zm5.2 41c5.2 2.2 22.4 19 24.7 24.2-.9-.2-1.7-.3-2.3-.5-3-1.1-5.6-3.3-8-5.7-5-5-9.4-10.9-13.8-16.8-.2-.2-.3-.5-.6-1.2zm498.8 31.3c2.3-6 4.3-11.5 8.5-15.3.6 2.1 1.6 2.4 3 1.9.6-.2 1.2-.2 1.8-.2 1 0 1.9.1 2.1 1.7.2 1.5-.3 2.8-1.4 3.4-.9.5-1.9.8-2.7 1.5-1.9 1.4-3.6 3-5.5 4.4-1.6 1.3-3.2 2.6-5.8 2.6zM339.7 570.8c-.7-1.1-1.5-2.1-2.1-3.3-2.3-4.5-3.7-9.5-4.8-14.7-.5-2.4-.9-4.9-1.2-7.4-.1-.8-.2-1.6-.1-2.4.1-1.3.8-1.8 1.6-1.2 1.4 1.1 2.8 2.1 3.2 4.7 1.2 7.5 2.6 15 3.9 22.5.1.5.1.9.2 1.4-.3.1-.5.3-.7.4zm481.4 265.5c1.1 1.6 2.2 3.4 3.3 5.1-5.4 6.6-16.2 7.7-20.3 3.9 2.2-3.4 5-5 8.1-3.6 3.5 1.6 5.7 0 7.4-3.9.2-.5.6-.9.9-1.4.1-.1.3-.1.6-.1zm-195.3 71.8c.1-1.8 1.1-2.4 2.1-2.6 2.2-.4 4.4-1 6.6-.8 3 .3 6 1 9 1.9 1.1.3 2 1.7 2.9 2.7.2.3.2 1.3 0 1.7-.2.4-.8.7-1.1.6-6.2-1.8-12.5-2.7-18.8-3-.3-.1-.4-.3-.7-.5zm319.6-577.5c.5.5 1.1.8 1.5 1.4 1.7 2.8 3.5 5.6 5 8.7 1.9 3.8 3.5 7.8 5.2 11.8.2.3.4.7.4 1.1 0 .5 0 1.3-.2 1.6-.3.3-1 .5-1.2.2-.9-.8-1.8-1.6-2.4-2.7-2.1-4.1-4.1-8.3-6-12.5-.8-1.8-1.4-3.8-2-5.8-.3-1.1-.5-2.2-.7-3.3 0-.2.2-.3.4-.5zm6.3 53.6c-1.8-4-3.5-8-4.8-12.3-.4-1.4-.8-2.9-1-4.3-.1-.9-.1-1.8.1-2.7.1-1.1.6-2 1.5-1.9.5.1 1 .8 1.2 1.4 1.4 4.1 2.8 8.3 4.1 12.5.4 1.4.5 3 .4 4.5 0 1-.5 1.9-.8 2.9-.2-.1-.5-.1-.7-.1zm-10.4 301.2c-2 6-3.2 11.9-5.7 17-.4.9-1.1 1.6-1.7 2.4-.6.7-1.3.9-2.2.1.3-1.3.7-2.6 1-3.9 1-3.9 2.1-7.8 3.1-11.7.4-1.6.9-2.6 2.4-2.5.8-.2 1.7-.8 3.1-1.4zm-543.6 16.8c-3.8.2-12.2-11.4-14.7-19.1.8-.8 1.5-.2 2 .3 1.4 1.3 3 2.6 4.1 4.3 2.9 4.5 5.7 9.3 8.5 13.9.1.2.1.4.1.6zm515 78.5c-1.5-1.5-1.5-3.1-1.4-4.6.5-5.2 2.5-9.2 5.6-12.3 1-1 2.1-1.5 3.7-.4-1.8 5.3-4.3 10.1-6.5 15.1-.4.8-.9 1.4-1.4 2.2zm-524.4-54c3.3.6 14.5 12.8 18.2 19.7-3.7.3-16.3-13.4-18.2-19.7zm116 153.4c-6.2-2.2-17.3-13.9-18.2-19.6 6.6 6.2 13.2 11.5 18.2 19.6zM360.1 666.4c1-.9 1.9-1.8 2.7-2.5.4.2.6.2.6.3 1.9 4.5 3.9 9.1 5 14.2.4 1.6.1 3-.8 4.1-1.3-1.4-5.6-10.4-7.5-16.1zm217.2 226.3c4.4 1.5 8.6 2.9 13.1 4.5-.3 1.8-.5 3.4-.8 5.3-3-1.3-5.8-2.4-8.6-3.7-1.1-.5-2.2-1.4-3.2-2.3-.9-.8-1.3-2-.5-3.8zM340.9 408.4c-1.3-2.7-1-6.6 1.1-15.3 1.4.4 2.8.8 4.5 1.3-.2.9-.4 1.6-.5 2.4-.2 1-.5 2.2-.3 3.1.4 1.8-.1 3-1.2 3.5-1.7.8-2.9 2.2-3.6 5zm-37.6 210c2.1-.3 3 .9 3.5 2.6.5 1.6.8 3.3 1.1 5 .6 3.7 1.2 7.3 2.9 10.5.2.4 0 1.2 0 1.8-.5 0-1.1.2-1.5 0-.5-.4-1-1.1-1.2-1.8-1.9-5.8-3-11.9-4.8-18.1zm23.8-62.3c-1.3.2-2-.5-2.4-1.7-.4-1.2-.7-2.5-.8-3.7-.2-2.8-.3-5.6-.3-8.5 0-.7.4-1.8.7-1.9.6 0 1.3.3 1.7.9.5.7.8 1.8.9 2.8.3 3.6.4 7.2.6 10.9 0 .4-.2.7-.4 1.2zm92.8 127.4c3.7 2.1 6.5 5.3 8.6 9.6.4.8.9 1.8.2 2.8-.6.9-1.4.6-2.1.1-.5-.3-1-.6-1.4-1.1-2.5-3.1-4.1-7.1-5.3-11.4zm551.7-247.7c-2.7-3.3-4.4-13.7-3.8-20.8 1 .9 2.1 4.4 3 9.8.7 3.5 1.8 6.9.8 11zm-637.5 164c2.7 4.1 5.1 8.5 7.1 13.2.2.5.2 1.7-.1 2.1-.3.4-1.3.7-1.6.4-.9-.8-1.8-1.7-2.2-2.9-1.1-3-2-6.1-2.9-9.2-.3-1.1-.5-2.2-.8-3.4.2 0 .3-.1.5-.2zm70.6 65.4c1.4-1 2.5-.5 3.2.6 1.9 3 3.7 6.1 5.4 9.3.2.3.1 1.4-.1 1.6-.4.4-1.2.8-1.6.6-.7-.3-1.3-1.1-1.7-1.9-1.7-3.2-3.4-6.6-5.2-10.2zm15.3 37c3.2-.9 7.9 2.8 9.8 7.5-3 1.9-7.8-1.6-9.8-7.5z"/>',
            $gradID);
        }
        $mask = '<path d="M887.2 543.1c-5.4.7-7.3 4.8-8.6 9.2-1.7 6.1-2.4 12.3-2.7 18.6-.1 1.9.6 2.6 2.5 2.7.5 0 1 0 1.5-.1 2-.5 3.4.2 4.3 2 .2.4.6.8 1.1 1.4 4.1-7.6 6.2-16.1 12.7-22.8.6 1.6 1.1 2.8 1.4 4 3.1 11.9 4 24 2.9 36.2-1.4 15.5-5.1 30.6-9.5 45.5-4.6 15.6-9.5 31-14.1 46.6-.6 2-1.6 3.4-3.3 4.6-1.2.9-2.5 1.8-3.6 2.8-3.4 2.9-3.8 4.7-2.3 8.8.8 2.2 1.2 4.5.7 6.8-.7 2.8-2 5.1-4.5 6.6-2.9 1.7-5.7 3.5-8.5 5.3-5.1 3.1-8.4 7.5-10 13.3-.6 2.1.2 3.3 2.3 2.8 1.4-.3 2.8-1.2 4.1-1.9 1.6-1 3.2-2.2 4.7-3.3 1.6-1.2 3.4-1.1 5.3-.7 0 .7.2 1.4 0 1.8-2.2 3.4-4.4 6.8-6.9 9.9-1.9 2.4-4.7 4-7.6 4.8-8.6 2.3-14 8.2-18.3 15.5-1.7 2.7-1.2 3.6 2 4.2.3.1.5.2.9.4-.1 2.3-1.5 3.9-3 5.3-3 2.7-6 5.4-9.1 8.1-14.2 12.1-28.4 24.2-42.6 36.4-1.9 1.7-3.6 2.2-5.9.8-1.3-.8-2.8-1.2-4.2-1.7-5.3-1.8-11 .3-14.3 5.3.6 1.3 1.7 1.6 3 1.4 1.5-.2 3-.5 4.5-.7 1.1-.2 2.3-.4 3.5-.6.4 1.8-.7 2.4-1.3 3.2-5 5.9-11.3 8.6-19 8.5-1.5 0-3.1.1-4.5.4-2.1.4-3.9 1.3-5.2 3.3-3.1 4.9-8 7.5-13.2 9.2-6.3 2.1-12.8 3.8-19.3 5.4-6.7 1.7-13.5 2.8-19.9 5.4-3.1 1.3-6.1 2.8-8.5 5.2-.7.6-1.2 1.5-1.9 2.4 2.5 1.3 4.8 1.2 6.9.9 5.4-.7 10.8-1.6 16.2-2.6 5.2-1 10.3-2.3 15.5-3.3 1.9-.4 4-.4 5.9-.6l.3.6c-.4.5-.7 1-1.2 1.4-10.7 7.1-22.5 11.1-35.4 11.8-2.9.1-5.9 0-8.8 0-1.6 0-2.9.2-4 1.6-2.3 2.7-5.6 4-8.9 4.9-7.1 2.1-14.4 2.3-21.7 2.5-6.1.1-12.1.5-18.2.7-.8 0-1.6.2-2.3.6-1.3.6-1.3 2 0 2.5 1 .4 2.1.5 3.2.6 1 .1 2-.2 3-.2 1.3 0 2.4.4 3.1 1.9-.6.4-1.2.8-1.8 1-10.2 2.7-20.6 3-31.1 1.7-7.2-.9-14.5-1.5-21.8-2.2-.6-.1-1.2 0-1.8 0-3.3.2-4.1 1-4 4.3 0 .4-.1.8-.1 1.5-3.4.4-6.8.3-10.2-.4-5.3-1.1-9.9-3.6-14.4-6.4-.9-.5-1.8-1-2.6-1.7-3.5-3.1-7.6-3-11.8-2.2-1 .2-2 .5-2.9.9-2.8 1.3-3.3 2.8-2.1 5.6.3.6.5 1.3.9 2.3-2.2-.3-3.9-.5-5.7-.8-13-2.3-25.8-5.4-38.4-9.2-16.6-4.9-32.8-11.1-48.6-18.4-22.3-10.3-43.1-23-62.9-37.4-11.8-8.6-23-18-33.6-28-18-16.9-34-35.4-48.6-55.3-1-1.3-1.9-2.5-.9-4.4.4-.7 0-2.3-.5-3.2-2.2-3.7-4.6-7.3-7-11.1-2.5 1.3-2.8 3.9-4.8 5.5-.9-.6-1.9-1.2-2.7-2-1.2-1.1-2.2-2.4-3.5-3.4-1.2-1-2.7-1.6-4.5-2.7-1-2.7.5-4.8 4-4.3 1.9.3 3.6 1.2 5.4 1.9.8.3 1.6.9 2.7 1.1-.4-.7-.8-1.5-1.3-2.2-3.1-4.6-6.3-9.2-8.2-14.6-1-2.8-1.8-5.6-.9-8.6.4-1.4-.3-2-1.5-2.5-7.8-3.8-14.2-9.4-19.5-16.2-.4-.5-.7-1-1-1.5-.1-.2 0-.4 0-.7 1.6-.6 2.9.2 4.1 1 1.9 1.2 3.7 2.5 5.6 3.7 1 .6 2.1 1.2 3.3 1.6 1.4.5 2.6.1 3.4-1.1-.2-.3-.2-.7-.5-.8-9.1-5.9-16.1-14.2-23.6-21.8-.1-.1-.4 0-.8 0 .1.7.1 1.3.2 2s.4 1.4.3 2.1c-.1 2.4-2.3 3.6-4.2 2.2-3.2-2.6-6.3-5.4-9.5-8.1-3.9-3.4-7.7-7-11.6-10.3-1.3-1.1-2.7-2.5-5.2-2.7.4 1.4.7 2.5 1.2 3.5.6 1.3 1.5 2.4 2.2 3.7.3.6.6 1.9.3 2.1-.6.5-1.7.8-2.4.6-1.2-.4-2.3-1.3-3.3-2.1-1.3-1.1-2.4-2.5-3.6-3.7-.5-.5-1.1-.7-2-1.4-.1 1.3-.2 2.1-.3 3-.3 1.6-1 2.2-2.7 2.3-2.4.1-4.8.3-7.7.4-11.3-18.2-23.7-36.4-31.8-56.9 1.7-1.1 3.3-1.9 4.6-3.1 1.3-1.2 2.3-2.8 3.4-4.2 2.3-2.8 3.9-2.9 6.5-.2.6.6 1.2 1.3 2.2 2.5.3-1.2.6-1.9.5-2.4-.3-1.2-.8-2.3-1.2-3.4-.8-2.3-1.7-4.6-2.5-6.8-.3-.8-.6-1.5-1-2.2-1.2-1.8-1.9-2-3.7-.8l-1.2.9c-1.8 1.1-3.1.7-3.7-1.3-.8-2.3-1.3-4.7-2-7-.6-1.8-1.3-3.6-2.3-5.3-1.1-1.8-2-1.7-3.5-.4-.7.6-1.6 1-2.7 1.6.3 3.5 2.9 6.9 2.1 11.1-1.3-.4-1.6-1.4-2-2.3-3.5-7.3-6.3-14.9-8.6-22.7-4.3-14.6-7.1-29.6-9.4-44.6-1-6.3-1.8-12.7-2.6-19-.1-.8.1-2 .6-2.4 1.1-.8 2.2 0 2.9.9.5.7 1 1.6 1.2 2.4.4 2.4.6 4.8.9 7.2.1.8.2 1.5.3 2.5 1.7-1.1 1.8-2.5 2.1-3.9 1.2-5.1.8-10.1-1.2-14.9-.3-.7-.7-1.5-1.2-2.1-2.2-3.1-5.9-3.1-8.1.1-2 3-3.3 6.3-3.6 9.9-.3 3.8-.2 7.7-.3 11.5 0 1 .1 2-.3 3.2-.3-.4-.7-.7-.9-1.2-2.8-6.4-3.8-13.2-4.2-20.1-.6-11.5.3-22.9 1.8-34.3.1-.9.4-1.9.6-2.8.2 0 .5-.1.7-.1.5.8 1.2 1.5 1.4 2.4.4 1.9.8 3.8.9 5.7.2 2.7.1 5.5.3 8.2.1 1.2.5 2.5.7 3.8 1.9-.6 2.2-2 2.6-3.2l2.7-9.3c.2-.8.5-1.6.9-2.2.4-.6 1.2-1.4 1.7-1.3.6.1 1.2.9 1.6 1.6.5.8.5 1.8 1 2.5.5.8 1.3 1.9 2 1.9s1.8-1 2.1-1.8c.8-2.5 1.7-5.1 1.8-7.6.4-7.3-.6-14.4-3.5-21.1-1.1-2.5-2.7-4.7-4.2-7-.6-.9-1-1.6-.9-2.7.5-4 1-8 1.2-12.1.2-5 .9-9.9 2.5-14.6 1.1-3.5.3-4.6-3.4-5-.5-.1-1-.1-1.5-.2-1.9-.4-2.3-.8-1.7-2.6 2-5.8 2.7-11.9 3.7-17.9.5-3.2 1.5-6.3 2.3-10 3.4 2.9 2.1 6.6 3.2 9.9 3.6-3.6 2.9-9.1 6.7-12.5.5.7 1.1 1.2 1.3 1.8 1.2 3.8 2.3 7.6 3.4 11.4 1.1 3.8 2.1 7.6 3.2 11.4.3.9.9 1.7 1.2 2.4 3.8-2.1 7.3-4.1 10.9-6.1.2.2.6.4.6.7.5 5.4 1.1 10.9 1.3 16.4.2 3.6-1.8 5-5.4 4.3-1.6-.3-3.1-.8-4.6-1.2-2.8 3.5-2.9 10.8-.3 15.3 2.1-1.1 1.2-3.7 2.8-5.5.5.9.9 1.5 1.1 2.2 1.3 6 2.6 12.1 3.9 18.1.1.7.3 1.3.6 2.3 1.1-1 1.9-1.8 3.1-2.9.7 1.2 1.6 2.2 1.8 3.2 1.4 6.1 1.9 12.2.5 18.4-.4 1.6-.1 2.6 1 3.8 3.5 3.6 4.3 8.4 5 13.1.4 2.6.3 5.2.4 8.2.9-.3 1.6-.3 2.1-.7 1.6-1.2 3.3-2.4 4.8-3.7 1.7-1.6 1.7-2.1.5-4.1-2.9-4.6-5.3-9.3-6.8-14.6-2.4-8.8-2.4-17.6-1.3-26.6 2.1-17.3 7.9-33.3 15.7-48.7 9.4-18.6 21.2-35.6 34.8-51.3 7.5-8.7 15.3-17.1 23.4-25.2 12.3-12.5 25.6-24 39-35.4 14.8-12.5 29.6-25 44.4-37.6 1.4-1.2 2.6-2.4 4-3.7l-.3-.6c-.8.3-1.6.5-2.2.9-14 7.8-28.1 15.4-41.9 23.6-18.6 11-36.1 23.7-52.4 38.1-20.4 18-38 38.3-51.7 61.9-7.4 12.9-13.5 26.3-17.9 40.6-.3 1-.7 2-1.6 3-.2-.5-.5-1-.5-1.6-1-6.3-.5-12.5.7-18.8 2.3-11.5 7-22 12.7-32.1 8.2-14.3 18.4-27.2 29.7-39.2 17.6-18.6 37.4-34.5 57.7-49.9 5.6-4.2 11.1-8.5 16.7-12.8.9-.7 1.8-1.6 2.4-2.7l-19.8 7.2c-.1-.1-.2-.2-.4-.3.6-.6 1.2-1.3 1.9-1.9 21.9-16.8 44.7-32.4 68.6-46.3 21.3-12.3 43.2-23.2 66-32.5 15.9-6.4 32.1-12 48.6-16.7 13.2-3.7 26.5-6.9 40-9.3 13.6-2.4 27.3-4.1 41.1-5 15.3-1.1 30.6-1.1 45.9-.3 11.1.6 22.2 1.9 33.2 3.7 13 2.1 25.8 5.2 38.5 8.9 1.1.3 2.2.6 3.2 1.1 7.9 3.9 16.7 2.9 25 4.2 21.1 3.2 41.2 9.1 59.5 20.2 2.9 1.8 5.6 4.1 8.3 6.1.4.3.7.9 1.5 1.8-2.5-.2-4.4-.4-6.2-.6-.6 1.5.5 1.9 1.1 2.5 2.8 2.3 5.8 4.5 8.6 6.9 1.2 1 2.3 2.3 3.3 3.6.7.8 1.1 2 .2 2.8-.6.5-1.7.6-2.5.4-4.7-1.5-9.5-3-14.2-4.7-7.8-2.8-15.6-5.8-23.5-8.4-5.7-1.9-11.6-2.8-17.7-1.8l-1.2.3c-.1 0-.1.2-.3.6.7.4 1.4.8 2.2 1.1 26.2 9 49.9 22.5 71.7 39.4 8.5 6.6 16.6 13.7 24.9 20.5.5.5 1.1 1 1.6 1.4.7.7 1.7 1.3 1.1 2.5-.7 1.3-1.9 1.5-3.1 1.2-1.4-.4-2.8-1.1-4.2-1.7-1.6-.7-3.1-1.4-4.7-2.1-.6-.2-1.3-.1-2.6-.2.9.9 1.2 1.4 1.7 1.7 14.2 9 27 19.8 40.1 30.2 4.9 3.8 9.9 7.4 14.9 11.1.6.4 1.3.7 2.2.8-3.3-5.6-7.9-10.1-12.7-14.4-4.7-4.2-9.5-8.4-14.1-13.2.6 0 1.3-.1 1.8.1 6.5 1.9 12.4 5 18.1 8.6 9.6 6.1 18.4 13.4 26.5 21.4 19.2 18.8 34.7 40.5 47.3 64.2 3.8 7.1 7.1 14.4 10.6 21.6.5 1 .8 2 1.2 3-.2.1-.4.2-.5.4-.8-1-1.6-1.9-2.3-2.9-5-7.2-9.9-14.4-14.9-21.5-7.6-10.7-15.5-21.1-24.8-30.4-5.3-5.3-11.1-10.2-17.4-14.2-.9-.6-1.8-1.1-2.7-1.6l-.6.6c.4.8.9 1.7 1.3 2.5 3.3 5.4 7.8 9.9 12.4 14.2 5.6 5.2 11.2 10.3 16.7 15.5 3.5 3.3 6.5 7.1 8.2 11.6.8 2.2 1.1 4.7 1.5 7.1.1.9-.3 1.9-.5 3.2-1.2-.7-1.9-1.2-2.7-1.7-1.3-.8-2.7-1.5-4.3-.8-1.5.7-2.4 0-3.4-1.1-7.3-8-12.8-17-16.5-27.1-.7-1.9-1.5-3.7-2.2-5.5-.2 0-.5.1-.7.1-.1.8-.3 1.7-.4 2.5-.3 5.6 1.7 10.5 4 15.4 4 8.4 9 16.1 14 23.9 9.6 14.9 19.2 29.9 27.7 45.5 7.6 14.1 14.3 28.7 19.1 44 2.7 8.7 4.7 17.7 5.3 26.8.1.9 0 1.8-.1 2.7 0 .2-.3.5-.7 1.3-.5-1.3-.9-2.2-1.2-3.1-2.8-8-5.3-16-9.3-23.4-1.5-2.8-3.3-5.3-5.1-7.9-1.3-1.9-3-2.9-5.4-1.7-1.4.7-3.2.6-4.7 1.2-1.7.7-3.2 1.6-4.8 2.6-1.3.8-1.3 1.8-.6 3.1 1.9 3.4 3.2 7 3.9 10.8.8 4.5 0 8.7-1.5 12.9-2.7 7.4-1.8 14.6 1 21.7.2.5.4 1 .5 1.4.8 2.2.6 2.8-1.6 3.1-1.8.3-2.1 1.3-2.3 2.7-.1 1.1-.1 2.2-.1 3.3-.2 13.6-.8 27.2-2.9 40.6-.8 5.2-1.8 10.5-3.7 15.6-.1-.3-.3-.7-.3-1 0-2.7.1-5.5.2-8.2 0-1.5.2-3-1.5-4-.6-.3-.7-1.6-.8-2.5-.4-5.6-.8-11.1-1.1-16.7-.3-6.3-.3-12.6-2.2-18.7-.7-2.4-2.2-4.5-3.4-6.7-.3-.5-.8-.7-1.6-1.4-.1 1.1-.2 1.7-.2 2.3.3 8 .6 16 .8 24 .1 6.8.4 13.6 2.5 20.2-.4 0-.4.4-.3 1zm-617 154c.9 1.3 1.3 2 1.8 2.6 2.1 2.8 4.2 5.5 6.2 8.3 8.9 12.2 17.6 24.6 26.5 36.8 8.4 11.4 17.7 22 28.2 31.4 7.3 6.5 15.2 12.2 24.2 16.2.5.2 1.1.3 2 .6-1-2.7-2.5-4.4-4.2-5.9-5.1-4.4-10.5-8.6-15.7-13-3.7-3.1-7.5-6.2-11-9.6-2.7-2.5-4.7-5.6-5.9-9.1-.4-1.2-1.1-2.4-.1-4 1.2.7 2.3 1.3 3.3 2.1 2.2 1.8 4.3 3.8 6.5 5.5 1.7 1.3 3.5 2.4 5.3 3.5.9.5 2.1.9 3.3-.5-.8-1.1-1.6-2.2-2.5-3.2-10.2-11.6-20.5-23-30.5-34.8-11.3-13.3-21.1-27.8-28.4-43.7-.1-.3-.2-.7-.4-.8-.6-.4-1.4-1.2-1.9-1.1-.7.2-1.4.9-1.9 1.6-.3.4-.1 1.2-.1 1.8 0 1.5-.4 2.9-1.8 4.4-3.1-4.4-7.8-3.4-12.2-4.7.1 3.2 1.7 4.9 3.7 6.4 1.5 1.1 3.2 1.8 4.7 2.7 1.6.9 3.3 1.6 4.7 2.7 1.1.8 2.4 1.9 2 4-1.7-.2-3.4-.2-5.8-.2zm-2.1-335.7c.2.2.5.4.7.7-5.3 11.3-11.6 22.2-16.8 34.1 2-.1 3.5-.1 4.9-.2 2-.1 2.2 2.1 3.9 3 .7-1.4 1.5-2.5 2-3.8 1.6-3.9 3.2-7.9 4.7-11.9 3.5-9.6 6.6-19.4 11.4-28.5.3-.6.5-1.3.9-2.5-3 2.2-4.4 5.4-7.9 7.3.2-2.3.1-4 .5-5.5 1-4.5 3.8-8.1 6.7-11.5 3.3-3.8 6.9-7.5 10.1-11.4 2.1-2.5 4-5.2 5.5-8 1.2-2.3 1.6-4.9-.2-7.4-.5.2-.8.2-1 .4-.4.3-.8.7-1.1 1.1-11.9 13.5-23.5 27.2-33.9 41.9-9.2 13-17.2 26.5-22.4 41.7-.4 1.3-.8 2.6-1.3 4.3.9-.4 1.2-.4 1.4-.6.6-.6 1.3-1.3 1.8-2 3.5-5.5 7.1-10.9 10.4-16.5 4.3-7.3 8.3-14.7 14.6-20.5 1.6-1.5 3.4-2.8 5.1-4.2zm36.1 309.1c2.4-1.9 2.6-2.3 1.4-4.6-2.6-5.4-5.2-10.8-7.7-16.2-1-2.1-1.7-4.3-2.8-6.4-.9-1.9-1.7-2.1-3.6-1.1-2.6 1.3-5.2 1.6-8 .9-3-.8-6.1-1.5-9.2-2.2-1.4-.3-2.7-.5-3.9.6 2.9 4.5 5.6 8.7 8.5 13.2.8-.5 1.4-.9 2-1.3.9-.6 1.7-1.4 2.7-2 1.6-.9 2.9-.5 4.1.9 1.1 1.3 1 2.1-.3 3.7-.3.3-.6.6-.8.9-1.4 1.8-1.3 2.8.3 4.5 1.9 2.1 4.2 3.4 7.1 3.8 3.5.4 6.7 1.7 9.1 4.4.2.3.6.5 1.1.9zm578.2-242c-.6.1-.9.1-1.2.2-.6.2-1.1.5-1.6.8-1.7.9-1.9 1.4-1 3.2 4.5 9.6 6.4 19.8 8.4 30 1.2 6.1 2.6 12.1 5.2 17.7.4.9 1 1.8 1.5 2.7.3-.1.5-.1.8-.2 0-1.1 0-2.1.1-3.2.6-5.8-.3-12 5.1-16.1-1.8-3.7-3.6-7.3-5.3-10.8-3.3-7-6.6-14.1-10-21.1-.5-1.2-1.4-2.2-2-3.2zM300.4 588c.7-2-.9-4.3.7-6.5.7 1.4 1.3 2.5 2.2 4 1.7-1.6 3.2-2.9 4.6-4.4.8-.9 1-1.9.3-3-2.4-4-5.3-7.5-9.5-9.5-2.6-1.2-5.3-2.4-8.7-1.3.8 3.8-.6 7.2-1.6 10.7-.4 1.2-.5 2.6-.5 3.9 0 2.2.6 2.8 2.7 3.4 3.2.7 6.3 1.7 9.8 2.7zm-7.8-244.9c2.6-.4 4.7-1.7 6.4-3.5 2.4-2.6 4.8-5.2 6.9-8.1 4.7-6.3 8.4-13.4 14.5-18.6.2-.2.1-.8.2-1.3-2.3-.2-2.3 3.1-4.7 2.5-.1-.7-.2-1.4-.4-2.6-9.2 8.9-17.1 18.1-24.8 27.3.7 1.5 1.2 2.7 1.9 4.3zm-60.2 4.3c7.3-3 35.6-35 36.8-41.5-2.3 2.5-4.2 4.8-6.4 6.9-8.2 7.9-16.6 15.8-24.8 23.8-1.7 1.7-3 3.8-4.2 5.9-.8 1.3-.9 3-1.4 4.9zm86.4 342.1c-3.6-6.1-6.7-11.6-10-17.3-.8.7-1.4 1-1.8 1.5-1.3 1.6-2.6 3.3-3.9 5-3.3 4.4-3.3 4.4.2 8.8 1 1.3 2.1 1.9 3.8 1.9 3.7 0 7.3.1 11.7.1zm.6 1c-.3.1-.5.3-.8.4.4 8.4 7.3 13.1 12.3 19.7h-7c-.1.2-.2.5-.3.7 1.9 1.9 3.8 3.8 5.8 5.6 1.9 1.8 3.9 3.6 5.8 5.3 2.1 1.8 4.1 3.6 6.3 5.2 2.1 1.6 3.9 3.6 6.7 4.3-1.3-2.2-2.8-4.2-4.3-6.2-.8-1.1-1.8-1.8-3.2-2.1-1-.2-2-.8-3.1-1.2 
                    1.3-3.4-.3-5.5-2.7-7.2-.3-.2-.7-.5-1-.7-1.4-.7-2-1.5-1.4-3.2.2-.6-.3-1.5-.7-2.1-3.7-5.7-7.4-11.3-11.2-17l-1.2-1.5zM148.2 492.9c-.6-3.8 1.4-7.2 2.5-10.9.7-2.1.5-4.6.6-6.9.1-1.2-.8-1.8-2-1.8h-6.1c-1.4 0-2 .8-2 2.1.2 4.9.3 9.7.6 14.6.1 1.7.7 3.4 2.1 4.4 1.4-.5 2.7-.9 4.3-1.5zM886.4 610c-1.6.2-2.3 1.3-2.7 2.6-.5 1.7-.9 3.5-1.1 5.3-.4 2.8-.5 5.7-1.1 8.4-.4 1.8-1.2 3.6-2.2 5.2-1.3 2.1-.9 3.5 1.6 3.7 1.4.2 2.8.1 4.3.1 2.4 0 2.3 0 3-2.4 2.2-7.7.4-15.1-1.3-22.5-.1 0-.3-.2-.5-.4zM281.2 284c-8.3 3.3-33.2 29.1-35.3 36.2 1.3-1 2.3-1.6 3.1-2.4 4-3.9 8-7.7 11.9-11.7 6.3-6.6 12.4-13.3 18.6-20 .6-.8 1.2-1.5 1.7-2.1zm62.1 6c-2.3 1.5-4.8 2.9-7.1 4.5-.6.4-1.1 1.4-1.2 2.2-.1 1.6-.2 3.2-1.2 4.6-.8 1.2-.1 2.1.8 2.9.9.8 1.8.6 2.7-.2 2.5-2.1 5-4.2 7.4-6.3 1.3-1.2 2-2.7 1.9-4-1.2-1.4-2.1-2.4-3.3-3.7zm402 508.5c-2.2-.7-3.6-.2-5 .7-2.4 1.5-4.7 3.1-7.2 4.4-1.5.7-2 1.5-1.6 3 .2.6.2 1.2.3 1.8.6 2.7 1.7 3.4 4.3 2.3.6-.3 1.3-.6 1.8-1 3.7-2.9 5.6-6.8 7.4-11.2zM307.9 261.3c0 .2.1.5.1.7.8-.2 1.7-.2 2.5-.6 3.2-1.7 6.5-3.4 9.4-5.5 5.9-4.3 11.6-8.8 17.4-13.3.2-.2.3-.5.5-.7-2 0-2.5 0-5 1.5-3.7 2.3-7.3 4.7-10.8 7.3-4.8 3.5-9.4 7.1-14.1 10.6zM714.1 814c-.1-.5-.1-.6-.2-.7-2-2.5-3.8-3.1-6.6-1.7-3.1 1.6-6.2 3.3-9.3 5.1-1 .6-1.1 1.9 0 2.5.8.4 1.7.8 2.6.8 1.5 0 3-.2 4.5-.6 3.6-1 6.7-2.7 9-5.4zm55-23.1c-3.8-2.7-7.3-2.8-10.9-1-2.5 1.2-4.4 3-4.9 6.3 2.9 0 5.5.1 8 0 3.4-.3 5.7-2.3 7.8-5.3zM313.6 651.4c.9 3.2 5.2 9.9 7.4 11.3 1.1-1.1 2.3-2.2 3.3-3.4.4-.4.5-1.3.4-1.9-1.3-4.6-6.1-7.1-11.1-6zm-88.4-305.3c1.1-.8 2-1.3 2.6-2 1.5-1.7 3.1-3.5 4.4-5.4 2.5-3.8 4.7-7.7 7.1-11.6.2-.4.2-.8.4-1.5-3.6 1.8-12.6 14.5-14.5 20.5zM875.9 601c-.6.1-.8.1-1 .2-3.8 2.7-5.2 8.1-2.9 12 .3.5 1.3.9 2 .9.4 0 1.1-.9 1.2-1.4.4-3.4.8-6.8 1.1-10.2 0-.4-.3-.9-.4-1.5zm-1.3-78c-.9 2.4-.5 4.6-.3 6.7.2 2.2.6 4.4.9 6.6.5 4.8.5 4.8 2 6.4.1-2.1.4-3.9.4-5.7-.1-3.9-.4-7.9-.6-11.8-.2-1.2-.8-1.9-2.4-2.2zM141.1 369.9c-.8.8-1.5 1.1-1.7 1.7-1.4 2.9-1.4 5.8-.4 8.8.2.5.6 1.2 1.1 1.4.6.3 1.6.6 2.2.3.6-.3 1.3-1.2 1.2-1.8-.1-2.6-.3-5.2-.7-7.8-.2-.8-1-1.5-1.7-2.6zm103.5 43.4c-2.4 3.7-3.5 7.8-5 11.9-.3.9-.4 1.9.8 2.2 1 .3 1.3-.6 1.6-1.4 1.5-4.1 2.4-8.3 2.6-12.7zM897 500.5c2.4-4.6 2.4-4.8 0-6.8-1.9 1.9-1.9 2.9 0 6.8zm-616.8 170c.3 1.2.9 1.9 2.2 1.4-.8-.5-1.5-.9-2.2-1.4zm-4.8 0c-.3.3-.7.6-1 1 .4.4.7.9 1.1 1.3.3-.6.3-.8.2-1.1l-.3-1.2z"/>
                 <path d="M233.4 726.5c1.3 1.1 2.5 2.2 3.8 3.4 10.5 10.2 19.9 21.4 29.1 32.8 10.1 12.5 20.1 25 31.1 36.6 7.9 8.3 16.3 16.2 25.7 22.8 6.3 4.4 12.9 8.4 20 11.5.5.2 1.1.4 1.9.1-.5-.5-1-1.1-1.5-1.5-8.1-6.9-16.5-13.5-24.4-20.6-25.7-23.2-49.1-48.4-69-76.8-4.9-7-9.3-14.2-14-21.4-.3-.5-.4-1.1-.7-1.8 1.3-.3 2.1.5 2.7 1.2 4.5 4.4 9.2 8.6 13.4 13.3 10 11.1 19.6 22.5 29.5 33.6 9.8 11 20 21.6 30.8 31.6 10.5 9.7 20.9 19.6 31.7 28.9 18.9 16.4 38.3 32.1 60.1 44.4 15.4 8.7 31.4 16.2 48.7 20.1 4.7 1.1 7.8 3.6 10.6 6.9 1.4 1.7 3.1 3.2 3.8 5.6-1.5.9-3 .6-4.5.4-8-.8-15.7-3.2-23.1-6.2-10.9-4.3-21.2-9.7-31.6-15-3.7-1.9-7.6-3.5-11.3-5.1-.5-.2-1.1-.3-2.1-.5 1.7 3.9 6 5.3 7 9.3-2.6.8-4.5-.1-6.4-1.1-5.3-2.7-10.6-5.5-15.8-8.5-14.6-8.4-28.2-18.4-41.9-28.2-7.9-5.7-15.6-11.7-23.7-17.1-4.4-2.9-7.4-6.5-10.4-10.7-4.7-6.5-10-12.6-15.3-18.5-11.5-12.7-23.6-24.9-34.2-38.4-7-8.9-13.4-18.1-19-27.9-.5-.9-1-1.9-1.4-2.8.1-.1.2-.3.4-.4zm134.3 125.8c2 5.8 12.8 13.9 18.9 14.4-.6-4.2-11.9-12.9-18.9-14.4zm-168.3-79.1c-1.8.5-3.1-.4-4.3-1.3-2.2-1.7-4.4-3.6-6.6-5.4-1.5-1.2-3-2.5-4.5-3.6-.8-.5-1.7-.8-2.8-1.3-.6 2.2.3 3.4 1.3 4.5 1.9 1.8 3.9 3.6 5.9 5.3 1.5 1.2 3.1 2.3 4.6 3.5.9.7 1.7 1.5 2.4 2.3.7.8 1.1 1.8.2 2.7-.8.8-1.7.4-2.5-.2-2.8-2-5.6-4-8.4-6.1-9.6-7.4-18.6-15.4-27.3-23.8-7-6.8-13.8-13.8-20.7-20.6-1.3-1.3-2.2-2.6-2.2-4.7 0-2.9-1.6-5.4-3.3-7.7-3.2-4.2-6.5-8.3-9.9-12.4-6.7-8-13.3-16.1-18.3-25.4-.9-1.6-1.7-3.2-2.5-4.9-.3-.6-.3-1.3-.6-2.3.7.4 1.1.5 1.4.7 32.4 33.8 63.3 69 98.1 100.7zM940 426.7c-2.4-.2-3.8-1.3-5.1-2.6-2.4-2.5-4.9-4.9-6.9-7.7-8.6-11.9-15.7-24.6-20.4-38.6-1.3-4-2.2-8-1.6-12.2.3-2.6 1-3.8 3.1-5.4.3.2.7.4.8.7 6.3 11.6 12.7 23.1 18.9 34.7 4.7 8.8 8.5 17.9 10.7 27.7.3 1.1.4 2.2.5 3.4zm-71.3-177.8c-27.2-26.1-57.2-48.4-90.2-67.2.9-1.8 1.7-3.4 2.5-5.1.8.3 1.4.5 1.9.8 14.5 9.2 29 18.3 43.3 27.7 10.8 7.1 20.9 15.1 30 24.3 4.4 4.5 8.5 9.3 11.5 14.9.7 1.3 1.2 2.7 1.8 4.1-.3.1-.6.3-.8.5zm-751.6 263c1 2.4 2.3 4.7 3.1 7.1 4.1 11.9 8.1 23.8 12.1 35.7 4.1 12.2 8 24.4 12.2 36.6 3.1 9 6.5 17.9 9.7 26.9.2.4.1.9-.3 1.7-.9-.9-1.8-1.7-2.6-2.7-5.9-7-10.1-14.9-13.7-23.2-5.3-12.2-9.1-24.9-12-37.9-3.2-14.3-6.2-28.7-9.2-43.1-.1-.3 0-.6.1-.9.2-.1.4-.2.6-.2zm804.6-222c-32.4-41.8-70.1-78.2-111.5-111 9.3 3.8 42.9 28.6 62.7 48.4 19 18.9 35.8 39.3 48.8 62.6zm16.4 47.9c-2.5-3.4-4.9-6.9-7.5-10.3-10.7-14.2-21.5-28.2-32.1-42.5-5.6-7.6-11-15.3-16.3-23.1-1.4-2-2.4-4.3-3.4-6.4-.3-.7-.4-1.4-.2-2.3 25.4 24.4 46.5 51.7 60.4 84.2-.3.1-.6.3-.9.4zM98.8 666.1c-1.6-2.2-3-3.9-4.2-5.7-7.4-10.4-12.9-21.8-17.6-33.6-4.7-11.8-8.4-23.9-11.8-36.1-.2-.6-.2-1.2-.3-2.2 2-.7 3.9-1.4 6.2-2.1.4 1.6.8 2.8 1.1 4.1 2.2 11.1 5.5 21.8 10.1 32.1 2.9 6.6 6.2 12.9 10.9 18.5 3.2 3.8 4.1 8.7 4.9 13.6.5 3.2.7 6.4 1.1 9.7-.1.3-.2.7-.4 1.7zM65.2 366.9c-.9 3.4-1.8 6.5-2.5 9.6-2.2 8.9-3.1 18-4 27-1.2 12.1-2.2 24.2-3.3 36.3-.2 2.2-.7 4.4-1.1 6.6-.2 1-.4 2.1-1.8 2.1s-2.4-.7-2.7-2c-.2-1-.2-2-.2-3 0-.7.2-1.4.2-2.1.4-3.6-.1-4.2-3.8-4.9 0-1.1-.1-2.3 0-3.5 1.2-9.7 3.2-19.2 5.7-28.6 2.3-8.5 4.5-17 6.5-25.6.8-3.3 1.1-6.8 1.5-10.2.4-3.3.7-3.5 3.7-2.5.6.3 1.1.5 1.8.8zm842.2 323.9c-3 8-6 15.8-9 23.8-.8-.4-1.4-.8-2.1-1.2-2.3-1.4-4.5-1.3-6.5.4-1.6 1.4-3 3-4.3 4.7-1.8 2.3-3.2 4.9-5 7.3-1.3 1.7-2.7 3.3-4.2 4.7-.9.8-1.9 1.8-3.8 1.2.4-.9.7-1.7 1.1-2.5 4.6-9 9.2-18 13.8-27.1 2.1-4.2 3.9-8.4 5.9-12.7 1-2.3 1.4-2.4 3.7-1.8 2.5.7 5.1 1.4 7.6 2.1.9.2 1.6.6 2.8 1.1zM923 465.7c.7 2.3 1.6 4.4 2.1 6.5 2.7 12 5.4 23.9 8 35.9.6 2.7.2 3.2-2.6 3.5-3 .4-5.8 0-8.5-1.4-1.7-.9-3.5-1.5-5.3-2-1.1-.3-1.8-.9-2-2-.3-2.1-.7-4.2-.9-6.3-.2-2.9-.1-5.9-.2-8.8-.1-2.6 1.2-3.7 3.8-2.9.9.3 1.8 1 2.7 1.4 2.1 1.1 3.9.2 4-2.2.1-1.3-.2-2.6-.5-3.9-.9-3.7-2-7.4-3-11.2-.3-1.1-.3-2.2-.4-3.3-.1-1.6.7-2.6 2.8-3.3zM122 598.5c.8.9 1.6 1.7 2.3 2.6 3.8 5.4 7.5 10.9 11.2 16.3 4.4 6.3 8.9 12.6 13.4 18.8 1.9 2.7 2.9 5.6 1.8 8.9-.3.8-.4 1.6-.7 2.3-.7 2-.6 4 .3 5.9.4.8.7 1.6 1.1 2.7-1.6.4-2.4-.7-3.2-1.4-3.5-3-5.7-6.8-7.4-11-1.8-4.4-3.4-8.9-5.1-13.3-1.7-4.4-4.5-8.1-8.2-11.1-.7-.6-1.5-1.5-1.8-2.4-.8-2.3-1.3-4.7-1.9-7-.7-3-1.3-6.1-2-9.2-.1-.6-.2-1.1-.3-1.7.1-.2.3-.3.5-.4zm692.8 199.3c.8.9 1.8 1.6 2.3 2.5 1.7 2.9 3.9 5.2 7.8 5.3-.3.8-.4 1.3-.7 1.7-3.1 3.6-6.1 7.4-9.3 10.9-1.6 1.7-3.5 3-5.4 4.4-1.1.8-2.4 1-3.6-.1-3.7-3.2-7.4-6.3-11.1-9.5-.2-.2-.3-.5-.6-1 1.9-3.2 4.4-5.9 8.1-7.3.9-.4 1.9-.7 2.9-.9 3.1-.7 5.7-2.1 7.8-4.5.4-.5 1-.9 1.8-1.5zm94.9-193.5c-.4-.4-.5-.5-.5-.6.1-4.6-1.1-9-1.7-13.5-.3-2.2-.4-4.4 1.1-6.8 1.2.5 2.5.9 3.5 1.5 1.4.8 2.6 1.9 3.9 2.9 2.8 2.2 5.9 3.1 9.4 2.2.5-.1 1-.1 1.8-.3.1 1.5.3 2.9.2 4.3-.1 5.5-1.6 10.6-5 15-.9 1.2-2.1 2.2-3.3 3-.7.5-1.7.7-2.5.8-1.7.1-2.3-.8-1.8-2.5.1-.4.3-.7.5-1.1.7-2 .1-3.8-1.4-5.3-1.5-1.3-2.9-.5-4.2.4zM97.4 456.6c-1.3-28.3.9-56.4 8.4-84.5 1.4 1.8 1.3 3.3 1.3 4.7.1 5.6-1.2 11.1-2.1 16.6-1.3 7.6-2.6 15.2-3.6 22.8-.3 2.7.2 5.4.5 8.1.3 1.9 1.2 3.7 2.9 4.8 1.1.7 1.3 1.7 1 2.9-1 3.6-1.7 7.3-2.9 10.8-1.6 4.7-3.6 9.2-5.5 13.8zm268.5 436.5c-3.5-2.2-7-4.3-10.6-6.5-8.5-5.3-17.2-10.4-25.6-15.9-5.4-3.5-10.3-7.6-14.3-12.7-1.7-2.1-3.3-4.2-3.9-7.4.7.4 1.1.5 1.3.7 7.6 7.2 16.4 12.6 25.1 18.1 6 3.8 12 7.5 17.9 11.5 2.7 1.9 5.1 4.3 7.5 6.6 1.4 1.4 2.5 3.1 3 5.1-.1.2-.2.4-.4.5zM213.4 667.2c1.5.5 3 1 4.4 1.6 5.9 2.6 11.2 6.2 16.2 10.1 8.6 6.5 16.6 13.7 24.1 21.4.5.5 1 1 1.4 1.6.2.2.1.6.2 1.1-2.9-.1-5.4-1-7.9-2.2-6.2-2.8-11.4-7-16.3-11.6-7.3-6.8-14.6-13.7-21.9-20.6-.2-.2-.4-.5-.5-.7.2-.3.2-.5.3-.7zM843.8 788c-1.6-3.2-3.7-4.3-6.4-4.7-1-.2-2-.9-3.2-1.4.4-.8.6-1.5 1-2 4.2-5.3 9.4-9.2 16-10.9 2.5-.6 5-.8 7.4.5 2.7 1.4 3 2.6 1.1 4.9-1 1.2-2.2 2.4-3.5 3.3-4.4 2.9-9.2 5.1-12.4 10.3zM96.4 369.1c-2.2 7.1-1.6 14.1-1.7 21 0 1.1-.1 2.2-.4 3.3-.1.5-.5 1.4-.9 1.4-2.4.5-2.8 2.4-3.3 4.2-.1.5-.4.9-.7 1.3-1.5-.2-1.9-1.3-2.1-2.4-.5-3.2-.8-6.4-1.2-9.6-.3-2.4-.3-4.9-.8-7.2-.5-2.7.2-4.8 2.3-6.5 1.7-1.4 2.8-3.1 3.3-5.3.4-2 1.1-2.3 3-1.7.7.5 1.4 1 2.5 1.5zm-14.9 79c1.7 2.8 2.5 5.9 2.6 9.1.2 5.7.2 11.4 0 17-.2 6.8-.2 13.6 1.1 20.3.1.5.1 1 .1 1.5 0 .2-.1.4-.3.9-.4-.5-.8-.9-1-1.3-3-7.2-4.8-14.7-4.8-22.5 0-7.7.7-15.4 1.1-23.1 0-.7.3-1.3.5-1.9h.7zm809.9 235.2c-.1.7 0 1.2-.2 1.6-1.9 5.3-3.6 10.7-5.7 16-.7 1.8-2 3.5-3.3 5-.6.7-1.6 1.3-2.5 1.6-2.1.8-3.5-.2-3.3-2.4.8-7.9 4-14.8 9.9-20.2 1.4-1.1 2.8-2.3 5.1-1.6zM786.8 829.8c-.1.4-.1.7-.3.9-3.5 3.5-7 7.1-11.5 9.4-2.4 1.2-2.8 1.1-4.7-.8-1.6-1.6-3.2-3.3-5-5.2 5.4-3.4 10.2-6.7 16.5-6.4 1.9 0 3.7.4 5 2.1zM932 675.7c-.1-.7-.2-1.2-.1-1.6.5-2.1 0-4-.7-5.9-1.4-3.7-.9-7.3.5-10.9.4-1.1 1.1-1.7 2.3-1.5 2.2.3 4.4.6 6.6 1 1 .2 1.6.8 1.4 2-.8 4.9-1.9 9.7-5.2 13.7-1.2 1.3-2.6 2.7-4.8 3.2zm-71.6-416.6c-.3-.2-.7-.4-1-.7-6.4-6.9-14-12.6-21.1-18.9-1.9-1.7-3.6-3.9-5.2-5.9-.7-.9-1.2-2.1-.4-3.5.5.3.9.5 1.3.8 6.8 5.7 13.6 11.3 20.2 17.1 2.5 2.2 4.9 4.6 6.1 7.8.4 1 .5 2 .7 3-.1.1-.3.2-.6.3zm43.2 50.9c-4.7-2.7-24.2-25.6-25.2-29.6.7.3 1.2.5 1.7.8 5.7 4.1 11.1 8.6 15.8 13.7 3.4 3.7 6.3 7.7 7.5 12.7.1.6.1 1.4.2 2.4zm-704 369.7c-6.3-.4-25.5-17.3-30.2-26.7 1 .3 1.7.4 2.4.8 4.8 2.5 8.8 6.1 12.7 9.8 5 4.9 9.7 10 14.6 15.1.2.2.3.6.5 1zm7 41c6.9 2.2 29.8 19 32.9 24.2-1.3-.2-2.2-.3-3.1-.5-4-1.1-7.4-3.3-10.7-5.7-6.7-5-12.6-10.9-18.4-16.8-.2-.3-.3-.6-.7-1.2zm663.9 31.2c3.1-6 5.7-11.5 11.4-15.3.8 2.1 2.2 2.4 4 1.9.8-.2 1.6-.2 2.4-.2 1.3 0 2.5.1 2.8 1.7.3 1.5-.4 2.8-1.8 3.4-1.2.5-2.5.8-3.7 1.5-2.5 1.4-4.8 3-7.3 4.4-2.1 1.3-4.3 2.7-7.8 2.6zM114.8 575.3c-1-1.1-2-2.1-2.8-3.3-3-4.5-4.9-9.5-6.4-14.7-.7-2.4-1.1-4.9-1.7-7.4-.2-.8-.2-1.6-.2-2.4.1-1.3 1.1-1.8 2.2-1.2 1.9 1.1 3.8 2.1 4.3 4.7 1.6 7.5 3.5 15 5.2 22.5.1.5.1.9.2 1.4-.2 0-.5.2-.8.4zm640.9 265.4c1.4 1.6 2.9 3.4 4.4 5.1-7.1 6.6-21.6 7.7-27 3.9 2.9-3.4 6.6-5 10.8-3.6 4.7 1.6 7.6 0 9.9-3.9.3-.5.8-.9 1.2-1.4.1-.1.3 0 .7-.1zm-260 71.9c.2-1.8 1.5-2.4 2.8-2.6 2.9-.4 5.9-1 8.7-.8 4 .3 8 1 11.9 1.9 1.4.3 2.7 1.7 3.8 2.7.3.3.3 1.3.1 1.7-.2.4-1 .7-1.5.6-8.3-1.8-16.6-2.7-25-3-.2-.1-.5-.4-.8-.5zm425.4-577.5c.7.5 1.5.8 2 1.4 2.3 2.8 4.6 5.6 6.6 8.7 2.5 3.8 4.7 7.8 7 11.8.2.3.5.7.5 1.1 0 .5 0 1.3-.3 1.6-.4.3-1.3.5-1.6.2-1.2-.8-2.5-1.6-3.2-2.7-2.8-4.1-5.4-8.3-8-12.5-1.1-1.8-1.9-3.8-2.7-5.8-.4-1.1-.6-2.2-1-3.3.3-.2.5-.4.7-.5zm8.5 53.6c-2.4-4-4.6-8-6.4-12.3-.6-1.4-1-2.9-1.3-4.3-.2-.9-.1-1.8.1-2.7.2-1.1.9-2 2-1.9.6.1 1.4.8 1.6 1.4 1.9 4.1 3.8 8.3 5.4 12.5.5 1.4.6 3 .6 4.5 0 1-.7 1.9-1.1 2.9-.3-.1-.6-.1-.9-.1zm-13.9 301.1c-2.7 6-4.3 11.9-7.6 17-.6.9-1.5 1.6-2.3 2.4-.8.7-1.8.9-2.9.1.5-1.3.9-2.6 1.4-3.9 1.4-3.9 2.8-7.8 4.1-11.7.5-1.6 1.3-2.6 3.2-2.5 1-.2 2.2-.8 4.1-1.4zM192 706.7c-5 .2-16.3-11.4-19.6-19.1 1-.8 2-.2 2.7.3 1.9 1.3 4 2.6 5.4 4.3 3.9 4.5 7.6 9.3 11.3 13.9.3.1.2.4.2.6zm685.6 78.5c-2-1.5-2-3.1-1.8-4.6.7-5.2 3.4-9.2 7.5-12.3 1.3-1 2.8-1.5 4.9-.4-2.4 5.3-5.8 10.1-8.7 15.1-.6.7-1.3 1.4-1.9 2.2zm-698-54.1c4.3.6 19.4 12.8 24.3 19.7-5 .3-21.8-13.3-24.3-19.7zm154.3 153.5c-8.3-2.2-23-13.9-24.3-19.6 8.9 6.1 17.7 11.5 24.3 19.6zM142 670.8c1.3-.9 2.5-1.8 3.6-2.5.5.2.8.2.8.3 2.6 4.5 5.2 9.1 6.6 14.2.5 1.6.2 3-1 4.1-1.7-1.3-7.4-10.3-10-16.1zm289.1 226.3c5.8 1.5 11.4 2.9 17.4 4.5-.4 1.8-.7 3.4-1 5.3-4-1.3-7.8-2.4-11.4-3.7-1.5-.5-2.9-1.4-4.2-2.3-1.3-.8-1.8-2-.8-3.8zM116.4 412.8c-1.8-2.7-1.3-6.6 1.5-15.3 1.9.4 3.8.8 6 1.3-.3.9-.6 1.6-.7 2.4-.2 1-.6 2.2-.4 3.1.5 1.8-.2 3-1.6 3.5-2.2.9-3.9 2.2-4.8 5zm-50 210c2.8-.3 3.9.9 4.6 2.6.6 1.6 1.1 3.3 1.4 5 .9 3.7 1.6 7.3 3.9 10.5.3.4 0 1.2.1 1.8-.7 0-1.5.2-2 0-.7-.4-1.3-1.1-1.6-1.8-2.6-5.7-4-11.8-6.4-18.1zm31.7-62.2c-1.7.2-2.7-.5-3.2-1.7s-.9-2.5-1.1-3.7c-.3-2.8-.4-5.6-.4-8.5 0-.7.6-1.8 1-1.9.8 0 1.8.3 2.3.9.6.7 1.1 1.8 1.2 2.8.3 3.6.5 7.2.7 10.9 0 .3-.3.7-.5 1.2zM221.6 688c4.9 2.1 8.7 5.3 11.5 9.6.5.8 1.2 1.8.2 2.8-.9.9-1.9.6-2.8.1-.6-.3-1.3-.6-1.8-1.1-3.3-3.2-5.4-7.2-7.1-11.4zm734.5-247.8c-3.6-3.3-5.9-13.7-5-20.8 1.3.9 2.8 4.4 4 9.9.7 3.4 2.2 6.8 1 10.9zm-848.7 164c3.6 4.1 6.7 8.5 9.5 13.2.3.5.3 1.7-.1 2.1-.4.4-1.7.7-2.1.4-1.1-.8-2.3-1.7-2.9-2.9-1.5-3-2.7-6.1-3.9-9.2-.4-1.1-.7-2.2-1-3.4.1 0 .3-.1.5-.2zm94 65.5c1.9-1 3.3-.5 4.2.6 2.5 3 4.9 6.1 7.2 9.3.2.3.1 1.4-.2 1.6-.6.4-1.5.8-2.1.6-.9-.3-1.7-1.1-2.3-1.9-2.2-3.3-4.4-6.7-6.8-10.2zm20.4 37c4.2-.9 10.5 2.8 13.1 7.5-4.2 1.8-10.5-1.7-13.1-7.5z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape22($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="m480.3 911.4-2.9-12.5 32.7 18.3-11.5 18.3-12.6-27-5.7 2.9L487 946l-117.4 25 110.7-59.6zm76 42.3 21.2 11.5-24.1 4.8 2.9-16.3zm-254-6.7 11.5-13.5 12.5 21.2-24-7.7zm184.7-1 5.8-1-4.8 6.7-1-5.7zm11.5-10.6 3.9 7.7-9.6 1.9 5.7-9.6zm18.3 1 4.8-8.6 9.6 10.6-14.4-2zm-103.9-25 38.5-7.7-12.5 24.1-26-16.4zm-125.1-11.6 8.7-5.8 2.9 14.4-11.6-8.6zm29.9-27.9 28.3-5.5-1.4-5.1 5.8-1 3.9 2.9 1-2.9 15.4-2.9.7 4.1 13.5-2.6 3.2-4.4-17.3 2.9-7.7-42.3v-1.9l2.9 1.9h.4l-4.8-9.6-1.4 9.6-4.8 25-17.5-21.1 4.8-3.8H336l-4.8-4.8 15.4 2.9-3.8 1.9H360l-13.5-1.9 13.6-10.2-1-2-22.2-10.9 15.6-2.3-6.3-12.6-15.8 7.7-.2.5-.3-.2-5 2.4-.4 4.5 2.9-1-4.8 10.6 1.9-9.6-11.5 1.9 18.3 18.3-13.5-2.9-1-5.8-1 5.8-7-1.2 5.4 9.7 1.5-8.6h1.9l1.9 16.4h-1l19.3 34.7-31.7-30.8-.8-22-12.7-2.1 1-9.6 7.9-.8-5.5-10.1-2.4 10.8-1 1-1.5-10.8-13.9 14.6-10.5-10-24.2-.6 2.9-4.8-9.6-1.6v3.5h-85.6v-38.5l64.5 22.1v8.7l19.2 3.5-.9-7.3 15.4 4.8-2.9 4.8 6.7 1.9 1-4.8-4.8-1.9 4.8-5.8L232 768l1 5.8-14.4-4.8 23.1-47.1 1.3 1.3-21.8-38.2-3.6 44.9 3.6-44.9-2.1-3.6-26.5-1.9-13.5-13.5 4.8-10.6h-8l4.1 4.8-7.7 15.4v-45.2H157v-57.7l-11.5-20.2 11.5-42.7V382.2l47.3-47.3 7.5-27.7 47.3-27.1 67.9-67.9-9.4-8.9 24.1-23.1 12.9 23.1h1.4l8.7-9.6.4 9.6h35.7L436 183h4.8l4.8-2.9v3.8l-2.1-.4-40 19.7h43.7l-1.7-19.2 7.7 2.9 1.5 16.4h3.3l-2.9-7.7h2V187l23.7 6.7 6.2-1.9 1.5 4 12 3.4-.3-11.5-13.1 4-7.7-26.9 16.1-4.3-25.8-26.5 49-20.2v8l10.6.7-1.7 5 13.2-4 1.9 2.9 1-3.9 4.8-1.9 5.1 82.7H589l1 1 14.4-5.8-1.9 4.8 2.1.4 3.1-6.5-3.3 1.3 12.4-28.5-28.2-15 22.6 20.4h-4.8v-1h-1l1 1-46.2 1.9 1.9-2.9 18.3-6.7-9.6-3.8L581 151l-12.2-6.4 36.9-32.5-36.9-4 37.5-35.6 12.5 3.8 32.7 40.4-18.3-1.9 6.7-3.9-2.9-3.8-6.7 7.7h2.9l-7.7 4.8 4.8-4.8-19.8-2.2 14.5 38.2 7.3-16.8 15.4 46.3 49.1 6.3 5.7-43.1 45.2 27.9-27.4 25.6 3.4 1.4-7.7 7.7h-2.9l.2-2.6-2.3 2.1 2.1.5v3.8l2.9-3.8 4.8 1-30.1 63.1 17.4 29.9 22.3 3.3-3.8 2.9 4.8 3.8-16.1 2.1 19.3 33 19 9.1-13.5-2.9-3.9-3.5 1.9 3.2 2.1.3 29.8 30.8v6.9l-16.5-11.6 9.9 16.9 6.6-1.7v12.9l38.5 65.9L770 613.7V636l-8.3 8.5L742 717l-53 29.8-2.6-1.3-55.1 51.3 2.1-17.9-9.5 5.5-33 33.6h-30.2l-18 6.7 40.4 3.8-4.8 7.7 15.4 7.7-2.9-14.4 30.8 2.9-42.3 41.4-1-1.9 1.9-25-13.5 11.5-26.9-32.7-1-1h2.9l-1 1 1.9-1h-1L554 818h-20.3l3.3 8.7-12.5 4.8 5.4-12.2-33.8 7.5.5 5.7-1.6-5.5-8.9 2-2 1.6 25 6.7-12.5 4.8-3.8-4.8 1.9 5.8-22.1 7.7-2.9-8.7 14.4-11.5-2.3-.6-15.1 3.3 2.9 8.8-1.9 1-6.3-8.6-4.3.9 2.5-3.5-7.3-10 11.5 2.9-2.2-6.7h-11.2l2.9 3.8-14.3-3.8h-23.5l11.9 31.7-4.8 1 1-6.7-13.3 3.6 6.2 4.5 6.1-1.5v5.8l6.7-1.9-1.9-4.8 26.9-4.8-27.7 14.6 3.6 2.7-8.8 2.2-.8 10.3-6.5-8.4-1.4.4-53.3 27.3-4.2 5.8-.9-3.2-19.3 9.9-17.3-34.7zm82.7-14.4.7-1.9-1.6.3.9 1.6zm22.1-.8v-.1h-.1l.1.1zm-20.2-6.9.6.7.3-1-.9.3zm-11.9-16.3-.7-13.6-23-3.7.4.8 23.3 16.5zm73.7-7.9.4-.6-.7-.2.3.8zm-97-8.5-.4-.8-.9-.2 1.3 1zm-1.3-1v-1h-1.9l1.9 1zm161.6-1-1.2-1.9h-16.1l11.4-7.3-7.7-11.9-16.1 6.6-1.1-16.1-9.9 13.2 8.1-2.9 1 19.2H490l-5.2-13.8-10.9 14.7h1.7l14.4-1 .4 1h5.3v-1l10.6-1-2.6 1.9 23.7.3zm-139.6 0-26-12.8-.5 3.2 4.8 9.6h21.7zM360.1 803l1.2-.9-2.2-1.1 1 2zm-55.3-10.2 8.1-.8-8.6-8.6.5 9.4zm47.7-5 34.1-5-.9-14.9-18.7-2.7-20.7 10 6.2 12.6zm54.9-.5-.8-2.9-2.9.5 3.7 2.4zm-.9-3.3-1.5-5.6-6.6 1.2 8.1 4.4zm-145.8-1-3.6-3.4 11.5-11.5-10.4-18.2-5 30.7 7.5 2.4zm41-2.1-4.3-4.3.7-3.1-1.8 2 1.1 1.1-.7 3.2 5 1.1zm94.8-.7v-.6h-1l1 .6zm2-.7-1.9-1v1h1.9zm-127-6.7 18.7 4.9-1-6.9-.4-.7v1.8l-11.7-11.7-8.5 7.8 2.9 4.8zm132.6 2.1-.8-3h10.6l-16.4-6.7v5.8l-3.1-9.4-1.2.9.8 10.8 3.9.7.5-1 .6 1.2 5.1.7zm-101.8-5.5v-.4l-.3.3.3.1zm-12.8-.7-.7-3.4v2.7l.7.7zm350.3-.1 43.1-24.9-12.7-6.3-30.4 30.9v.3zm-351-.4v-.2.2zm100.7-20.4-5.4-13.8-1-.2v10.5l6.4 3.5zm48.6-12.5-.1-1 2.1-.9.4-1.7-2.4 1.6v-5.7l-4.1 3.2 4.1 4.5zm35.4-9.6-.6-13.7-7.1.6 1 2.5h-.5l4.3 5.8-2.6 1.1 5.5 3.7zm-136.6-26-9.1 18.2 8.6-.2 2.4-15.1 5.7 14.9 9.6-.2 13.7-27.9-6.5-5.3-12.8-6.4 1-1.9 2.1.4-1.7-1.4-.5 1-5.8-1 4.8 2.9-1.9 3.9h-4.8l1.9-6.7v-4.8l.6.2-2.5-2.1-5 14.4 5-.9-1 6.7-5.8-.6-1.3 3.7 3.3 8.2zm123.7 17 2-1.7h-3.5v.7l1.5 1zm-7.1-2.9-.2-.6h1.9l3.8-1.2v-.8l13.5-5.1-.1-1.6h-9.6v-14.4L436 701.2l16.3 11.8-.9-3.6 6.7-2.9 1 4.8-6.6 1.9h.8l-.4.2.6.4zM173.3 642l8.5-25.9-8.5-14.8V642zM614 393.8l2.1-.5-2.1-3.4v3.9zm133.7-25.9V364l-1.7 1 1.7 2.9zM563 366.8v-7.4l-4.4-1.5.6 1.2-2.2 3.7 2.1 4h3.9zm74.1-40.4v-2.5l-2.4.4 2.4 2.1zm-3.6-3.3 3.6-20.2v-8.3l.6-.6-1.1-1.3-7.2-1v27.7l4.1 3.7zm-89.7-17.9 33.7 14.4.2-1.9h-4l-1-6.7 5.4 1.2.5-6.5-6.9-2.4 1 7.7-18.3-3.8 1.5-3-3.6-1.2-8.5 2.2zm-52 2 12.5-10.6-10.6-9.6-1.9 20.2zm79.9-3.9v-5.6l-10.1 2.7 10.1 2.9zm7.3-3.7.3-4-7.4 2 7.1 2zm49.2-18.7 1.1-.4 11.6-10-.5 6.3 15.9-5.3 2.2 2.2 9.8-9.5-11.9 3.5-2.4-2.2.4 2.2L639 259l2.8-5-1.9-1.8.2-.4-5.1-.5 4.9 4.7-12.2 24.3.5.6zm-47.9-16.1 17.1 6.3 3.7-22-.6.2-1-1.9 1.8.5 1.1-6.2h9.6v-7.8l-13.9.9-3.6 7.6 3.1 8-8.4 3.2-2.1 4.4-5.8-6.7 7.8-16-23.2 1.5 19.2-14.4 9.1 2.4 6.3-13 5.8 5.8-4.4 9.3 4.4 1.2v-4.7l6.7 6.5 11.6 3.1-7.8.5 7.6 7.3 11.8-5 10.9 3 9.3-17.5 6.1 21.8 6.2 1.7 7.9-15.8-4.8-12.5 8.7 1-1 5.8 2.9-4.8-1.9-1 1-5.8 4.8-1-3.8 7.7 10.1 1.5 1.4-10.2-7.6.9 1.9-3.9-5.8-2.9 6.7 1-1 1.9 5.6 2.8.5-3.8-5.2-.9 1.9-3.9 3.8.8 1.4-10.5-5.2 9.7-7.7-1-1 3.9-1 7.7-11.5 1.9-3.8-10.6-5.8 11.5-3.8 6.7-3.6-15.6-33.9-1.7 4.8-3.9H613l13.5-10.6-15.1 5.9-1.2 7 1.8-1.4-1-1h1.9l-1 1 1 2.9H610l-.8 4.8h1l-1 1.9V209l-6-.9-1.4 1.1-1.3 2.7-.9-.9-14.5 11.5-24.1-6.7-5.8 2.9-1-4.8 6.7 1.9 16.8-6.7H554l.3 4.8-9.6-2.7v11.1l.2.2 10.4-3.8.7 14.7 4.3 4.2 5.6-.6-3.4 2.7 16.4 16.1 1.4-.5v9.5zm-72.4 2.1 2.2-1.1-2.4.5.2.6zm165.4-7.6 6.2-6h-5.2l-1 6zm4.2-11.8 6.8 11.7 3.7-1.2-10.6-25 1.9-9.6-2.9 5.8 1 3.8-2.2 13.8 2.3.7zm-175.3-24.6 7.9-5.7v-10.1l-7.9 15.8zm207-5.2 1.9-8.7-3.2-.5-6 5.6 7.3 3.6zM540.9 210l-.4-1H537l3.9 1zm-2.5-6.7-4.3-11.5 10.6-11.5-21.2-16.4 10.6 27.9-10.7 11.5h15zm-23.8 0-2.6-.7-.2.7h2.8zm-3.6-1-9.6-2.6v2.6h9.6zm-45.2-6.8-8.7-4.8v4.8h8.7zm55.8-7.6-.1-1.5-.5.9.6.6zm-5.2-5.5 4.9-1.8-.7-18.8-3.5-2.9-4.2 12.5.3-15.7-3.2-2.6 3.3-1.2.1-6.3-6.3 5.6-8.7-6.7V157l.3 2.5 13.2-3.5v21.7l4.5 4.7zm7.2-18.6-2.9-8.7v6.7l2.9 2zm-2.9-8.7-.7-4.5-.7 2.1 1.4 2.4zm-.2-6 10.8-4.5-5.5-8.2 17-1.4-2.9-7.7-14 5.3-1.3 3.9h.3l-.4.4-4 12.2zm-7.5-12.2.7-.2.1-4.4-1.8.7 1 3.9zm34.6 737.9 3.8-2.9h4.8l-1-3.9 11.5-9.6 11.5 13.5-3.9 31.7-26.7-28.8zM262.8 895l9.6-4.8v8.7l-9.6-3.9zm-5.8-.9 5.8 1-6.7 3.8.9-4.8zm226.1-10.6 35.6-11.5-1.9 26-33.7-14.5zm-339.6-27 125.1 3.9-11.6 33.7-113.5-37.6zm130.9 3.9h-5.8l3.8-12.5 20.2 31.7-20.2 10.6 2-29.8zm158.7 2.9 10.6 10.6-12.5 9.6 1.9-20.2zm110.7 7.7 10.6-7.7 1 4.8-3.8 3.9-7.8-1zm-257.9-33.7 1.6.3-26.6-20.5 16.4-18.3 28.9 28.9.5 13.5 14.9 2.8-13.6 22.1-22.1-28.8zm155.9 17.3 9.6 1.9-3.8 5.8-5.8-7.7zm-91.4 5.8-6.7-3.9 12.5-1.9-1 5.8h-4.8zm144.3-17.3 1.9-1 9.6 12.5-4.8 3.8-6.7-15.3zm-283.8-16.4 36.6 12.5-23.1 14.4-13.5-26.9zm308.8 15.4 2.9-5.8-5.8 2.9-7.7-1.9 15.4-5.8-1.9 4.8 14.4-8.7 8.7 24.1-26-9.6zm63.5-13.5 5.8-8.7 1.9 9.6-7.7-.9zm-43.5-2.5-2.7 1 2.7-1zm88.7-5.2 8.7-3.8v6.7l-8.7-2.9zm-268.4-5 2.8.6-2.8-.6zM252.2 795l3.8 13.5-16.4 2.9 12.6-16.4zm250.2 3.8 2.9 3.8-4.8 3.9 1.9-7.7zM234 787.3l8.7 1-7.7 9.6-1-10.6zm96.2-3.9 9.6 3.8-12.5 1.9 2.9-5.7zm-171.3-83.7 13.5-24.1-1 68.3-12.5-44.2zm-33.7-30.8 23.1-7.7 10.6 38.5-11.5 23.1-22.2-53.9zm211.7 30.8 2.9-5.8-1 8.7-1.9-2.9zm3.9-11.5h1.9l-2.9 5.8 1-5.8zm1.9 0 3.9-6.7 7.7-1 1 9.6-12.6-1.9zm0-14.5 1 1-1-1zm-202.1-39.4 16.4-3.8v5.8l15.4 15.4v1.9l-24.1 7.7-7.7-27zm629.2-245.2 3.8 2.7-3.8 1v-3.7zm11.6-5 9.6 1.9-3.8 5.8-5.8-7.7zm59.6-80.8 31.7 45.2-74 17.3 42.3-62.5zm-4.8 29.8h4.8v-4.8l-4.8 4.8zM740 315.8l6.7-1.9-9.6-4.8 17.3-2.9-24.1-2.9 56.8-42.3-15.4 75-31.7-20.2zm-4.8-3.8-3.8-1.9 4.8-1-1 2.9 4.8 3.8-5.8 1 1-4.8zm1-2.9v-1l1 1h-1zm7.7-24.1 1-1.9h-1v1l-41.4-21.2 3.8-1.9 19.2 3.9-6.7-8.7 17.3-6.7 11.5 36.6-3.7-1.1zm-47.2-25 15.4-13.5 6.7 9.6-12.5 4.8-9.6-.9zm101.1-15.4h7.7l-1-4.8-9.6 2.9 2.9 1.9h-9.6l6.7-1.9-50-35.6 51-12.5 7.7 9.6 9.6 52-15.4-11.6zm-173.2-11.5 25-1.9-13.5 4.8-11.5-2.9zm-18.3-15.4 2.9-6.7-1.9 8.7-1-2zm53.9-2.9 9.6-1 1.9 2.9-11.5-1.9zM613 204.2h5.8l-3.9 3.8-1.9-3.8zm190.5 0-1.9-11.5-5.8 1.9-3.8-4.8 29.8-11.5-15.4 28.9-2.9-3zm-477.2-54.8 13.5-6.7 9.6 50-23.1-43.3zm127 37.5-1-7.7 3.9 7.7h-2.9zm303.1-8.7 15.4-11.5L768 185l-11.6-6.8zm-312.7-23.1 8.7 22.1-6.7 2.9-2-25zm162.6 20.2 1 1.9-1-1.9zM560.1 159l10.6 4.8-8.7 10.6-8.7 2.9 6.8-18.3zm85.7 0 5.8-16.4-1 17.3-4.8-.9zm-180-21.2 16.4 16.4-4.8 4.8-11.6-21.2zm41.4 13.5 2.9 1.9-11.5 3.9 8.6-5.8zM402.3 90.7l58.7 48.1-76 2.9 17.3-51zm123.2 45.2.3.5-.8.1.5-.6zm208.8-14.4 16.4 8.7-11.5 4.8-4.9-13.5zm-198.2-9.7h10.6l-2.9 10.6-2.9 1-4.8-11.6zm189.5 2h12.5l-11.5 3.8-1-3.8zM455.2 98.4l8.7 15.4-4.8 1.9-3.9-17.3zm201.1-7.7 27.9 4.8-15.4 12.5-12.5-17.3zm-37.5-14.4-7.7-8.7-4.8 4.8-5.8-1.9 21.2-26 1 33.7-3.9-1.9zm-53.9.9 6.7-17.3 6.7 18.3-13.4-1zm-130.8-26 26.9-9.6-6.7 18.3-20.2-8.7zm83.7-11.5 17.3-1-7.7 9.6-9.6-8.6zm-12.5-2.9 10.6-5.8-7.7 8.7-2.9-2.9z"/>',
            $gradID);
        }
        $mask = '<path d="m504.5 907.5-2.9-12.5 32.7 18.3-11.5 18.3-12.5-26.9-5.8 2.8 6.7 34.7-117.4 25 110.7-59.7zm76 42.4 21.2 11.5-24.1 4.8 2.9-16.3zm-254-6.8 11.5-13.5 12.5 21.2-24-7.7zm184.8-.9 5.8-1-4.8 6.7-1-5.7zm11.5-10.6 3.9 7.7-9.6 1.9 5.7-9.6zm18.3.9 4.8-8.6 9.6 10.6-14.4-2zm-103.9-25 38.5-7.7-12.5 24.1-26-16.4zM312.1 896l8.7-5.8 2.9 14.4-11.6-8.6zm29.8-27.9 28.3-5.5-1.4-5.1 5.8-1 3.9 2.9 1-2.9 15.4-2.9.7 4.1 13.5-2.6 3.2-4.4-17.3 2.9-7.7-42.3v-1.9l2.9 1.9h.4l-4.8-9.6-1.4 9.6-4.8 25-17.3-21.2 4.8-3.8h-6.7l-4.8-4.8 15.4 2.9-3.8 1.9h17.3l-13.5-1.9 13.6-10.2-1-2-22.2-10.9L377 784l-6.3-12.6-15.8 7.7-.2.5-.3-.2-5 2.4-.4 4.5 2.9-1-4.8 10.6 1.9-9.6-11.5 1.9 18.3 18.3-13.5-2.9-1-5.8-1 5.8-7-1.2 5.4 9.7 1.5-8.6h1.9l1.9 16.4h-1l19.3 34.7-31.7-30.8-.8-22-12.7-2.1 1-9.6 7.9-.8-5.5-10.1-2.4 10.8-1 1-1.5-10.8-14.1 14.8-10.5-10-24.2-.6 2.9-4.8-9.6-1.6v3.5h-85.6V743l64.5 22.1v8.7l19.2 3.5-.9-7.3 15.4 4.8-2.9 4.8 6.7 1.9 1-4.8-4.8-1.9 4.8-5.8-21.2-4.8 1 5.8-14.4-4.8 23.1-47.1 1.3 1.3-21.8-38.1-3.6 44.9 3.6-44.9-2.1-3.6-26.5-1.9-13.5-13.5 4.8-10.6h-8l4.1 4.8-7.7 15.4v-45.2h-15.4V569l-11.5-20.2 11.5-42.7V378.4l47.3-47.3 7.5-27.7 47.3-27.1 67.9-67.9-9.4-8.9 24.1-23.1 12.9 23.1h1.4l8.7-9.6.4 9.6H425l35.1-20.2h4.8l4.8-2.9v3.8l-2.1-.4-40 19.7h43.7l-1.7-19.2 7.7 2.9 1.5 16.4h3.3l-2.9-7.7h2v-8.6l23.7 6.7 6.2-1.9 1.5 4 12 3.4-.3-11.5-13.1 4-7.7-26.9 16.1-4.3-25.6-26.6 49-20.2v8l10.6.7-1.7 5 13.2-4 1.9 2.9 1-3.9 4.8-1.9 5.1 82.7h35.3l1 1 14.4-5.8-1.9 4.8 2.1.4 3.1-6.5-3.3 1.3 12.4-28.5-28.2-15 22.6 20.4h-4.8v-1h-1l1 1-46.2 1.9 1.9-2.9 18.3-6.7-9.6-3.9 10.3-12.8-12.2-6.4 36.9-32.5-36.9-4 37.5-35.6 12.5 3.8 32.7 40.4-18.3-1.9 6.7-3.9-2.9-3.8-6.7 7.7h2.9l-7.7 4.8 4.8-4.8-19.8-2.2 14.5 38.2 7.3-16.8 15.4 46.3 49.1 6.3 5.7-43.1 45.2 27.9-27.5 25.6 3.4 1.4-7.7 7.7h-2.9l.2-2.6-2.3 2.1 2.1.5v3.8l2.9-3.8 4.8 1-30 63 17.4 29.9 22.3 3.3-3.8 2.9 4.8 3.8-16.1 2.1 19.3 33 19 9.1-13.5-2.9-3.9-3.5 1.9 3.2 2.1.3 29.8 30.8v6.9l-16.5-11.6 9.9 16.9 6.6-1.7v12.9l38.5 65.9-38.5 142.2v22.3l-8.3 8.5-19.6 72.4-53.1 30-2.6-1.3-55.1 51.3 2.1-17.9-9.5 5.5-33 33.6H585l-18 6.7 40.4 3.8-4.8 7.7 15.4 7.7-2.9-14.4 30.8 2.9-42.3 41.4-1-1.9 1.9-25-13.5 11.5-26.9-32.7-1-1h2.9l-1 1 1.9-1h-1l12.2-6.7H558l3.3 8.7-12.5 4.8 5.4-12.2-33.8 7.5.5 5.7-1.6-5.5-8.9 2-2 1.6 25 6.7-12.5 4.8-3.8-4.8 1.9 5.8-22.1 7.7-2.9-8.7 14.4-11.5-2.3-.6-15.1 3.3 2.9 8.8-1.9 1-6.3-8.6-4.3.9 2.5-3.5-7.3-10 11.5 2.9-2.2-6.7h-11.2l2.9 3.8-14.3-3.8h-23.5l11.9 31.7-4.8 1 1-6.7-13.3 3.6 6.2 4.5 6.1-1.5v5.8l6.7-1.9-1.9-4.8 26.9-4.8-27.7 14.6 3.6 2.7-8.8 2.2-.8 10.3-6.5-8.4-1.4.4-53.3 27.3-4.2 5.8-.9-3.2-19.3 9.9-17.4-34.7zm82.8-14.4.7-1.9-1.6.3.9 1.6zm22.1-.9v-.1h-.1l.1.1zm-20.2-6.8.6.7.3-1-.9.3zm-11.9-16.3-.7-13.6-23-3.7.4.8 23.3 16.5zm73.7-8 .4-.6-.7-.2.3.8zm-97-8.5-.4-.8-.9-.2 1.3 1zm-1.4-.9v-1h-1.9l1.9 1zm161.7-1-1.2-1.9h-16.1l11.4-7.3-7.7-11.9-16.1 6.6-1.1-16.1-9.9 13.2 8.1-2.9 1 19.2h-5.8l-5.2-13.8-11.1 14.9h1.7l14.4-1 .4 1h5.3v-1l10.6-1-2.6 1.9 23.9.1zm-139.7 0-26-12.8-.5 3.2 4.8 9.6H412zm-27.7-12.1 1.2-.9-2.2-1.1 1 2zM329 789l8.1-.8-8.6-8.6.5 9.4zm47.8-5 34.1-5-.9-14.9-18.7-2.7-20.7 10 6.2 12.6zm54.9-.5-.8-2.9-2.9.5 3.7 2.4zm-.9-3.3-1.5-5.6-6.6 1.2 8.1 4.4zm-145.9-1-3.6-3.4 11.5-11.5-10.4-18.3-5 30.7 7.5 2.5zm41.1-2.1-4.3-4.3.7-3.1-1.8 2 1.1 1.1-.7 3.2 5 1.1zm94.8-.8v-.6h-1l1 .6zm1.9-.6-1.9-1v1h1.9zm-127-6.7 18.7 4.9-1-6.9-.4-.7v1.8l-11.7-11.7-8.5 7.8 2.9 4.8zm132.7 2-.8-3h10.6l-16.4-6.7v5.8l-3.1-9.4-1.2.9.8 10.8 3.9.7.5-1 .6 1.2 5.1.7zm-101.9-5.5v-.4l-.3.3.3.1zm-12.7-.6-.7-3.4v2.7l.7.7zm350.3-.1 43.1-24.9-12.7-6.3-30.4 30.9v.3zm-351-.4v-.2.2zM413.8 744l-5.4-13.8-1-.2v10.5l6.4 3.5zm48.5-12.5-.1-1 2.1-.9.4-1.7-2.4 1.6v-5.7l-4.1 3.2 4.1 4.5zm35.5-9.7-.6-13.7-7.1.6 1 2.5h-.5l4.3 5.8-2.6 1.1 5.5 3.7zm-136.6-25.9-9.1 18.2 8.6-.2 2.4-15.1 5.7 14.9 9.6-.2 13.7-27.9-6.5-5.3-12.8-6.4 1-1.9 2.1.4-1.7-1.4-.5 1-5.8-1 4.8 2.9-1.9 3.9H366l1.9-6.7V666l.6.2-2.5-2.1-5 14.4 5-.9-1 6.7-5.8-.6-1.3 3.7 3.3 8.5zm123.6 17 2-1.7h-3.5v.7l1.5 1zm-7.1-2.9-.2-.6h1.9l3.8-1.2v-.8l13.5-5.1-.1-1.6H487v-14.4l-26.9 11.1 16.3 11.8-.9-3.6 6.7-2.9 1 4.8-6.6 1.9h.8l-.4.2.7.4zm-280.1-71.9 8.5-25.9-8.5-14.8v40.7zm440.7-248.2 2.1-.5-2.1-3.4v3.9zM772 364v-3.9l-1.7 1 1.7 2.9zm-184.7-1v-7.4l-4.4-1.5.6 1.2-2.2 3.7 2.1 4h3.9zm74.1-40.4V320l-2.4.4 2.4 2.2zm-3.7-3.3 3.6-20.2v-8.3l.6-.6-1.1-1.3-7.2-1v27.7l4.1 3.7zM568 301.4l33.7 14.4.2-1.9h-4l-1-6.7 5.4 1.2.5-6.5-6.9-2.4 1 7.7-18.3-3.8 1.5-3-3.6-1.2-8.5 2.2zm-51.9 1.9 12.5-10.6-10.6-9.6-1.9 20.2zm79.8-3.8v-5.6l-10.1 2.7 10.1 2.9zm7.4-3.7.3-4-7.4 2 7.1 2zm49.2-18.7 1.1-.4 11.6-10-.5 6.3 15.9-5.3 2.2 2.2 9.8-9.5-11.9 3.5-2.4-2.2.4 2.2-15.4-8.7 2.8-5-1.9-1.8.2-.4-5.1-.5 4.9 4.7-12.2 24.3.5.6zM604.6 261l17.1 6.3 3.7-22-.6.2-1-1.9 1.8.5 1.1-6.2h9.6v-7.8l-13.9.9-3.6 7.6 3.1 8-8.4 3.2-2.1 4.4-5.8-6.7 7.8-16-23.2 1.5 19.2-14.4 9.1 2.4 6.3-13 5.8 5.8-4.4 9.3 4.4 1.2v-4.7l6.7 6.5 11.6 3.1-7.8.5 7.6 7.3 11.8-5 10.9 3 9.3-17.5 6.1 21.8 6.2 1.7 7.9-15.8-4.8-12.5 8.7 1-1 5.8 2.9-4.8-1.9-1 1-5.8 4.8-1-3.8 7.7 10.1 1.5 1.4-10.2-7.6.9 1.9-3.9-5.8-2.9 6.7 1-1 1.9 5.6 2.8.5-3.8-5.2-.9 1.9-3.9 3.8.8 1.4-10.5-5.2 9.7-7.7-1-1 3.9-1 7.7L694 210l-3.8-10.6-5.8 11.5-3.8 6.7L677 202l-33.9-1.7 4.8-3.9h-10.5l13.5-10.6-15.1 5.9-1.2 7 1.8-1.4-1-1h1.9l-1 1 1 2.9h-3.1l-.8 4.8h1l-1 1.9V205l-6-.9-1.4 1.1-1.3 2.7-.9-.9-14.5 11.5-24.1-6.7-5.8 2.9-1-4.8 6.7 1.9 16.8-6.7H578l.3 4.8-9.6-2.7v11.1l.2.2 10.4-3.8.7 14.7 4.3 4.2 5.6-.6-3.4 2.7 16.4 16.1 1.4-.5.3 9.7zm-72.4 2.1 2.2-1.1-2.4.5.2.6zm165.3-7.6 6.2-6h-5.2l-1 6zm4.3-11.8 6.8 11.7 3.7-1.2-10.6-25 1.9-9.6-2.9 5.8 1 3.8-2.2 13.8 2.3.7zm-175.4-24.6 7.9-5.7v-10.1l-7.9 15.8zm207.1-5.2 1.9-8.7-3.2-.5-6 5.6 7.3 3.6zm-168.3-7.7-.4-1h-3.5l3.9 1zm-2.5-6.8-4.3-11.5 10.6-11.5-21.2-16.4 10.6 27.9-10.7 11.5h15zm-23.9 0-2.6-.7-.2.7h2.8zm-3.5-1-9.6-2.6v2.6h9.6zm-45.2-6.7-8.7-4.8v4.8h8.7zm55.8-7.7-.1-1.5-.5.9.6.6zm-5.2-5.4 4.9-1.8-.7-18.8-3.5-2.9-4.2 12.5.3-15.7-3.2-2.6 3.3-1.2.1-6.3-6.3 5.6-8.7-6.7v12.5l.3 2.5 13.2-3.5V174l4.5 4.6zm7.1-18.6-2.9-8.7v6.7l2.9 2zm-2.9-8.7-.7-4.5-.7 2.1 1.4 2.4zm-.2-6.1 10.8-4.5-5.5-8.2 17-1.4-2.9-7.7-14 5.3-1.3 3.9h.3l-.4.4-4 12.2zm-7.5-12.2.7-.2.1-4.4-1.7.7.9 3.9zm34.7 738 3.8-2.9h4.8l-1-3.9 11.5-9.6 11.5 13.5-3.9 31.7-26.7-28.8zm-284.8 20.2 9.6-4.8v8.7l-9.6-3.9zm-5.8-1 5.8 1-6.7 3.8.9-4.8zm226.1-10.5 35.6-11.5-1.9 26-33.7-14.5zm-339.6-27 125.1 3.9-11.6 33.7-113.5-37.6zm130.8 3.8h-5.8l3.8-12.5 20.2 31.7-20.2 10.6 2-29.8zm158.8 2.9L468 870l-12.5 9.6 1.9-20.2zm110.6 7.7 10.6-7.7 1 4.8-3.8 3.9-7.8-1zm-257.8-33.7 1.6.3-26.6-20.5 16.4-18.3 28.9 28.9.5 13.5 14.9 2.8-13.5 22.1-22.2-28.8zM466 850.8l9.6 1.9-3.8 5.8-5.8-7.7zm-91.4 5.8-6.7-3.9 12.5-1.9-1 5.8h-4.8zM519 839.2l1.9-1 9.6 12.5-4.8 3.8-6.7-15.3zm-283.9-16.3 36.6 12.5-23.1 14.4-13.5-26.9zM544 838.3l2.9-5.8-5.8 2.9-7.7-1.9 15.4-5.8-1.9 4.8 14.4-8.7 8.7 24.1-26-9.6zm63.5-13.5 5.8-8.7 1.9 9.6-7.7-.9zm-43.5-2.5-2.7 1 2.7-1zm88.7-5.2 8.7-3.8v6.7l-8.7-2.9zM384.2 812l2.8.6-2.8-.6zm-107.7-20.9 3.8 13.5-16.4 2.9 12.6-16.4zm250.2 3.9 2.9 3.8-4.8 3.9 1.9-7.7zm-268.5-11.6 8.7 1-7.7 9.6-1-10.6zm96.2-3.8 9.6 3.8-12.5 1.9 2.9-5.7zm-171.2-83.7 13.5-24.1-1 68.3-12.5-44.2zm-33.7-30.8 23.1-7.7 10.6 38.5-11.6 23.1-22.1-53.9zm211.7 30.8 2.9-5.8-1 8.7-1.9-2.9zm3.8-11.6h1.9l-2.9 5.8 1-5.8zm1.9 0 3.9-6.7 7.7-1 1 9.6-12.6-1.9zm0-14.4 1 1-1-1zm-202-39.5 16.4-3.8v5.8l15.4 15.4v1.9l-24.1 7.7-7.7-27zm629.2-245.1 3.8 2.7-3.8 1v-3.7zm11.6-5 9.6 1.9-3.8 5.8-5.8-7.7zm59.6-80.8 31.7 45.2-74 17.3 42.3-62.5zm-4.8 29.8h4.8v-4.8l-4.8 4.8zM764.3 312l6.7-1.9-9.6-4.8 17.3-2.9-24.1-2.9 56.8-42.3-15.4 75-31.7-20.2zm-4.8-3.9-3.8-1.9 4.8-1-1 2.9 4.8 3.8-5.8 1 1-4.8zm.9-2.9v-1l1 1h-1zm7.7-24 1-1.9h-1v1l-41.4-21.2 3.8-1.9 19.2 3.9-6.7-8.7 17.3-6.7 11.5 36.6-3.7-1.1zm-47.1-25 15.4-13.5 6.7 9.6-12.5 4.8-9.6-.9zm101-15.4h7.7l-1-4.8-9.6 2.9 2.9 1.9h-9.6l6.7-1.9-50-35.6 51-12.5 7.7 9.6 9.6 52-15.4-11.6zm-173.2-11.6 25-1.9-13.5 4.8-11.5-2.9zm-18.2-15.3 2.9-6.7-1.9 8.7-1-2zm53.8-2.9 9.6-1 1.9 2.9-11.5-1.9zm-47.1-10.6h5.8l-3.9 3.8-1.9-3.8zm190.5 0-1.9-11.5-5.8 1.9-3.8-4.8 29.8-11.5-15.4 28.9-2.9-3zm-477.2-54.9 13.5-6.7 9.6 50-23.1-43.3zm127 37.6-1-7.7 3.9 7.7h-2.9zm303.1-8.7 15.4-11.5-3.8 18.3-11.6-6.8zM468 151.3l8.7 22.1-6.7 2.9-2-25zm162.6 20.2 1 1.9-1-1.9zm-46.2-16.3L595 160l-8.7 10.6-8.7 2.9 6.8-18.3zm85.6 0 5.8-16.4-1 17.3-4.8-.9zM490.1 134l16.4 16.4-4.8 4.8-11.6-21.2zm41.4 13.5 2.9 1.9-11.5 3.9 8.6-5.8zM426.6 86.9l58.7 48.1-76 2.9 17.3-51zm123.1 45.2.3.5-.8.1.5-.6zm208.8-14.5 16.4 8.7-11.5 4.8-4.9-13.5zM560.3 108h10.6l-2.9 10.6-2.9 1-4.8-11.6zm189.6 1.9h12.5l-11.5 3.8-1-3.8zM479.5 94.6l8.7 15.4-4.8 1.9-3.9-17.3zm201.1-7.7 27.9 4.8-15.4 12.5-12.5-17.3zm-37.5-14.5-7.7-8.7-4.8 4.8-5.8-1.9 21.2-26 1 33.7-3.9-1.9zm-53.9 1 6.7-17.3 6.7 18.3-13.4-1zm-130.9-26 26.9-9.6-6.7 18.3-20.2-8.7zM542 35.9l17.3-1-7.7 9.6-9.6-8.6zM529.5 33l10.6-5.8-7.7 8.7-2.9-2.9z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape23($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M506.4 244.5c2 4.3 4 8.6 6.3 13.5 2 .1 5.3.4 9.1.6-.3-5.1-.5-10.8 4.6-13.6 3.5-1.9 8.2-3 12.2-2.7 9 .8 12.9 7.8 10.8 17.5 5.3.6 10.6 1.3 15.7 1.9 0-2.7-.9-6.5.3-9.6 1.2-3 4-5.9 6.8-7.7 4-2.6 10.5-1 13.5 2.4 3.3 3.9 3 10.9-.8 16.2-3.7 5.2-7.8 6.3-14.5 3.8.6 3.8 1.1 7.6 1.8 11.7 3.3.2 6.8.5 10.9.8-.3-6.2.6-12.6 7-15.6 3-1.4 7-1.9 10.2-1.1 8.2 1.9 11 10.3 7.5 21.2 6.3-2.4 12.3-2.7 18 1 6.3 4.1 6.6 10 4.5 16.6 15.7-1.7 20.4 2.4 21.9 17.6 5.7 2 10.9 3.8 16.1 5.7l1.3 1.3c1.3 4.8 2.6 9.7 3.9 14.8 3.5.4 8.2 1 12.8 1.5-1.7-8.4-.4-12.8 4.7-15.6 4.9-2.7 11.6-2.3 15.1.9 3.2 2.9 4.1 8.1 2.2 12.4-2.5 5.6-8.1 7.9-17.6 7 .6 2.4 1.5 4.7 1.8 7.1.3 2.3.1 4.7.1 7.5 5.9-1.2 11.3 0 16.1 3.7 3.6 4.7 5.2 10 3.6 16.4 6.2-.2 11.9.5 16.2 5.1 4.4 4.7 5 10.2 2.6 16.7 5.5-1.7 10.8-2.4 14.3 1.8 2.7 3.3 5 7.5 5.7 11.7 1.5 8.7-4 13.2-15.9 14.2.2 3 .4 6.1.6 9.5 3.2.5 6.4.9 10.4 1.5-1.9-5.9-1.1-11.4 3.8-15.2 1.9-1.5 4.9-2.4 7.4-2.4 7 0 13.8 7.2 13.8 13.9 0 7.3-6 11.3-17.5 11.5.3 4.1.5 8.1.8 12.6 6.1-.6 11.8.5 15.6 6.1 3.7 5.4 3.6 11.2.3 17.7 6.7-2.9 12.7-3.7 17.1 2.6 3.6 5.1 4.5 10.8 1.6 16.5-3.2 6.2-9.1 5.7-15.2 4.8.2 4.7.4 9.1.6 13.5 12.4.6 17.3 4.6 17.3 14.4.1 9.7-4.6 13.8-16.7 14.4v10.9c5.4-.2 11.1.1 14.1 5.2 1.9 3.3 3.2 7.5 3.2 11.3-.1 8.9-6 13.3-16.6 13.5v9.6c11.8 1.9 17.2 7.5 16.7 17-.4 8.9-5.3 12.9-17.4 14v10.6c5.3-.4 10.9.3 13.6 5.6 1.8 3.5 2.9 8 2.5 11.9-.9 8.9-7.2 12.4-17.1 10.8-.3 5-.7 10-1 15.2 6.8-2.4 13.3-1.6 16.8 6.7 2.3 5.4.5 12-3.9 15.4-4 3.2-9.2 3.4-13.8.5-5.8-3.6-7.5-8.8-5.3-17-3.6.9-7 1.8-11 2.9-.2 2.4-.3 5.3-.5 8.2 12.1 1.2 17.2 6.9 15.9 17.7-1.1 9.4-6.8 12.9-16.9 11.4-1.4 5.6-1.9 11.4-4.4 16.3-2.8 5.6-9.3 5.6-15.1 5.9-.3 3.9-.7 7.6-1 11.9 5.9-1.2 11.5-.3 14.6 5.3 1.6 2.8 2.7 6.4 2.6 9.6-.3 6.9-6.3 11.1-13.9 10.6-8.9-.6-12.1-5.2-12-17.3-3 .5-6 1.1-9.5 1.7-.3 2.7-.7 5.6-1.1 8.8 5.3.1 11.3-.2 14.1 5.2 1.6 3.2 2.3 7.5 1.7 11.1-1.7 10.3-8.3 13.5-19.7 10.3 2.8 7.3 1 13.5-4.4 18.7-4.1 4-7.7 4.4-15 2 1.7 6.6.7 12.5-4.1 17.3-4.9 4.8-10.5 5.9-17.6 2.2 3.2 6.9 3.6 12.8-2.4 17.4-5.2 4-11.1 4.5-17.4 2.8 1.7 11.3-3.7 21.2-12.1 22.5-7.6 1.2-13-5.2-14.7-17.8-3 .3-5.9.6-9 .9-.6 3.1-1.2 6.4-1.9 9.7 12.5.4 18.1 4.2 17.7 11.9-.4 7.4-8.3 14.4-15.6 13.7-7-.6-10.9-7.3-10-17.3-3.7.5-7.3 1-9.7 1.3-2.9 5.4-4.9 10.9-8.5 15.1-4 4.7-10.2 3.9-16.3 2.4 1.3 5.3 2.1 10.6-2 14.1-3 2.5-7.1 4.6-11 5.1-9.3 1.3-14.1-4.4-14.8-16.4-3.1.3-6.3.6-9.3.9-1 3.7-2.1 7.4-3.1 11 8.6-1.5 14.8 1 17.7 7.1 2.2 4.6 1.2 10.9-2.4 14-4 3.6-10.9 3.6-16.3.1-5.4-3.6-6.5-8.1-3.8-16.3-2.6.7-5 1.7-7.5 1.8-2.6.2-5.2-.5-8.1-.8 1 4.6 1.9 9.7-2.1 12.9-3.2 2.5-7.4 4.7-11.4 5.2-9.8 1.1-14-4.4-13.6-16.3h-12.7c.5 5.1.8 10.8-4.3 13.8-3.4 2-7.7 3.2-11.7 3.2-8.7 0-12.7-5.7-12.5-16.5h-9.7c-1.8 4.4-2.5 9.2-5.3 12.1-2.6 2.7-7.2 4.2-11.1 4.5-9.7.8-13.5-4-14.6-16.8h-11.4c.4 5.2 0 10.6-5 13.3-3.5 1.9-7.9 3.2-11.7 3-9.3-.6-12.7-6.6-11.2-17.1-4.8-.2-9.7-.5-14.5-.7.8 7.9-2.1 14.6-8 17.1-4.6 2-10.9.6-14-3-3.5-4.1-3.7-11.2-.5-16.4 3.2-5.3 7.4-6.4 16-4.2-.8-3.5-1.6-7-2.5-11h-8.5c-1.1 11.1-6.5 16.5-16.3 16-9.6-.5-13.6-5.6-13.4-17.2-4.9-.9-9.7-1.7-14.4-2.5 1.5 8-.7 13.8-6.9 17-4.5 2.3-10.4 1.4-13.7-2-3.5-3.6-3.7-10.5-.4-15.8 3.4-5.6 7.5-6.8 15.3-4.6-.6-3.7-1.2-7.4-1.9-11.6-2.9-.2-6.3-.4-10-.6.6 7.9-2.3 13.7-10.1 15.8-5.6 1.5-11.2.9-15.1-4.1-4.3-5.6-3.2-11.4.5-17.1-16.5 5.8-28.1-3.7-22.5-17.8-6.1 1.3-12 1.7-17-2.5-5.1-4.3-5.6-9.9-4.5-16.4-6.1.8-11.8 0-16.4-4.2-4.9-4.4-5.6-9.8-3.9-15.9-16.2.2-22.7-6.9-19.6-21.7-6.3 1.8-12.2 1.5-16.8-3.4-4.7-4.9-5.2-10.7-2.7-17-11.4 2.8-18.2-1.5-20.1-12.2-1.6-9.3 3.1-13.8 16.2-15.3-.4-3.1-.7-6.3-1.1-9.5-3.2-.4-6.4-.8-10.4-1.4 2.1 5.6 1.3 10.8-3.2 14.6-1.9 1.6-4.7 2.9-7.1 3-7 .5-14.2-6.7-14.5-13.7-.4-7.4 5-11.1 17.6-11.9-.3-2-.6-4-.7-6.1-.1-1.9 0-3.8 0-6.2-6.1.7-11.8-.5-15.7-5.8-3.9-5.2-4.2-10.9-1.2-17.5-6.7 2.8-12.6 2.9-16.8-3.2-3.6-5.3-4.4-11.1-1.3-16.9 3.1-5.8 8.6-6.1 14.9-5.1-.4-3.9-.7-7.5-1.1-11.5-5.8.1-11.4-1.5-14.7-7.4-3.2-5.6-3.1-11.3-.2-17.8-8.1 2.9-14.9 2.4-19.6-4.9-2.6-4.1-2-9.4 1.2-13.4 4-5.1 8.7-6.2 15.9-4.2V611c-5.6 1.9-11.5 2.6-15.2-3.8-3.2-5.5-3.6-11.4 0-16.9 3.8-5.7 9.4-4.8 14.9-3.1v-15.5c-3-.2-6.5.4-9.2-.8-2.7-1.2-5.2-3.9-6.8-6.6-2.9-5.2-1.8-11.9 1.8-15.4 3.9-3.8 9.6-4.1 16.8-.5-2.4-6.1-3.5-12-.6-17.8 3.1-6.3 8.7-7.7 15.5-7 .2-3.8.5-7.4.7-11.5-5.3.4-11 .5-13.9-4.6-1.9-3.4-3-7.9-2.7-11.8.7-9.1 7.4-12.9 17.7-11.2.4-5 .8-10.1 1.2-14.8-2.7-.2-6.7.3-9.6-1.1-3.1-1.5-5.9-4.6-7.5-7.7-2.4-4.5-.3-10.5 3.5-13.2 4.2-3 10.9-2.4 15.9 1.3 4.9 3.7 5.8 7.7 3.1 14.8 3.4-.4 6.9-.7 10.3-1.4.8-.2 1.7-1.9 1.9-2.9.3-2.6.1-5.3.1-8.4-7 .5-13.6-.4-16-8.1-1.9-6.1.2-11.5 4.7-15.9 4.5-4.5 9.7-4.4 15.7-1.3-2.6-6.5-2.8-12.4 1.3-17.8 4.2-5.4 9.7-6.4 15-5.1 1.5-5.5 2.1-11.4 4.8-16.1 3.1-5.4 9.5-5.4 15.2-5.3.7-4.6 1.5-9.1 2.2-13.7-6.3 1.4-13 2.2-16.7-5.2-2.4-4.7-.6-11.3 3.6-15.1 3.6-3.3 8.9-4.2 12.4-2.1 5.8 3.4 8.1 9.7 6.1 17.6 2.2-.7 4.2-1.6 6.3-2 2-.4 4.1-.3 6.3-.4.5-3.8 1-7.9 1.6-11.9-12.1.2-18.2-4.3-17.8-13.2.4-6.9 6.5-11.6 14.2-10.8 8.7 1 11.6 6.2 9.8 17.3 4-.7 8.1-1.4 12.2-2.2.6-3.7 1.3-7.7 2-11.7-8.2.8-14.4-1.8-17-7.2-1.9-4.1-.7-10.2 2.6-13.2 3.9-3.5 11.1-4.2 15.9-1.3 6.3 3.7 5.8 9.4 4 16 2.6-.7 4.6-1.5 6.7-1.9 2.2-.3 4.4-.3 6.9-.4.2-5.6.4-11.3 5.1-15.5 4.5-4.1 10-4.1 16-3.1-.8-6.6.4-12.4 5.5-16.7 5.1-4.3 10.8-4.3 17.4-1.7-2-5.1-3.7-10.2.3-14.1 2.8-2.7 6.7-5.2 10.5-5.9 10-1.9 14.9 3.4 15.6 16 3-.3 6-.5 9.3-.8.8-3.5 1.7-7 2.4-9.7-4.4-1.1-8.8-1.6-12.6-3.4-2.2-1.1-3.9-4.1-4.9-6.6-1.9-4.8-.1-10.3 3.5-13 4.3-3.2 11.3-2.9 16.3.8 4.7 3.4 5.6 7.4 3.1 15.3 2.6-.6 4.9-1.3 7.3-1.6 2.4-.3 4.9-.1 7.4-.1-1.1-10.4 3.9-16.9 13.9-17.7 9.6-.8 14.1 4 15 16.2 3.2-.1 6.3-.3 8.7-.4 2-4.5 3.7-8.5 5.5-12.5.7-.8 1.5-1.5 2.2-2.3 5.5-3.5 11.3-4 18-1.2-2.3-6.6-2.8-12.6 3.5-16.6 5.3-3.3 11.1-3.6 16.5-.4 6 3.5 5.5 9.2 4.5 14.8h14c-.5-4.6-1.4-10.1 3.4-13.1 3.5-2.1 8-3.7 12-3.7 9.4.1 12.6 5.5 11.1 17.1h15.4c-1.4-6-2.1-12.4 5.1-16.2 4.8-2.6 11.6-1.4 16.3 2.5 5.1 4.4 5 9.7 2.3 15.9 7.5-3.2 14-2.9 19.8 2.1zm-423 388V646c3.6-.7 7.2-1.3 10.8-2v-9.3c-4-.8-7.7-1.5-10.8-2.2zm10.4-77.6c-3.8-1-7.2-2-10.3-2.8v12.4c3.2-.6 6.5-1.3 10.3-2.1v-7.5zm-.3 48.1v-8.8c-3.4-.5-6.5-1-9.2-1.5-.2 4.2-.4 8.3-.6 12.1 3.1-.5 6.3-1.1 9.8-1.8zM756 501.3c3.4.4 6.4.7 9 .9.5-4.2.9-8.1 1.4-11.6-3.5.6-6.9 1.3-10.4 1.9v8.8zM469.7 248.1c.7 2.8 1.4 5.9 2.2 9.1h7.6c1-3.6 1.9-6.9 2.7-9.9-4.1.3-8.1.5-12.5.8zM592.3 289c.5 3 1.1 6 1.6 9.1h7.5c.6-3.5 1.2-6.8 1.7-9.9-3.5.3-7 .5-10.8.8zm-344 589.9c-.8 3.7-1.6 7.3-2.3 10.7 3.3-.6 7.1-1.2 10.9-1.9-1-8.7-1-8.7-8.6-8.8zm151.6-630.7c-4.2-.2-7.9-.5-11.5-.7.6 3.3 1.2 6.4 1.8 9.5h8c.6-3.1 1.1-5.9 1.7-8.8zM703.2 797c-3 .6-5.4 1.1-8 1.5-.2 2.7-.3 5.2-.5 7.1 3.8.9 7.1 1.7 10.6 2.6-.6-3.5-1.3-7.2-2.1-11.2zm-59.5 71.2c-.2-1.4-.6-2.9-.7-4.4-.1-1.7 0-3.4 0-5.1-8.8.3-8.4-1.8-9.4 8.6 3.3.2 6.5.5 10.1.9zm-489.8-90c-2.8-.4-5.4-.7-7.8-1.1-.4 4-.8 7.3-1.2 10.5 3.2-.7 6.4-1.4 9.7-2.2-.2-2.3-.4-4.6-.7-7.2zm277.5-521.4h7c.7-3.1 1.4-5.9 2-8.5h-10.9c.7 2.8 1.3 5.5 1.9 8.5zm-297 175.4c-3.6-.8-6.9-1.5-9.8-2.1.4 3.6.9 7 1.3 10.7 2.4-.2 5-.5 7.8-.8.2-2.6.4-5.1.7-7.8zm-21.2 264.7c-2.6-.6-5.1-1.1-7.4-1.6-.6 3.9-1.2 7.6-1.7 11 3.4-.8 6.6-1.5 9.9-2.3-.3-2.3-.6-4.7-.8-7.1zm162.5-399.8c.5-2.7.9-5 1.3-7.2-3.6-.7-7.1-1.3-10.3-1.9.6 3.2 1.1 6.4 1.7 9.7 2.3-.1 4.6-.3 7.3-.6zm225.4 631.7c-.4-2.9-.7-5.7-1-8.5h-7.4c-.5 2.7-1.1 5.2-1.6 7.7 3.4.3 6.5.6 10 .8zm224-518.6c-3.6.5-6.6 1-9.7 1.5.4 2.5.7 4.8 1.1 7.2 2.4.4 4.6.8 7 1.2.5-3.4 1-6.5 1.6-9.9zm-50.4 415.6c3.9.9 6.9 1.5 9.9 2.2-.7-3.4-1.3-6.5-2-9.8-1.9.1-4.1.2-6.5.3-.5 2.4-.9 4.8-1.4 7.3zm-10.3 22.8c-.7-3.4-1.4-6.5-2.2-10.1-2.4.4-4.8.8-7.4 1.2v6.6c3.4.8 6.5 1.5 9.6 2.3zM236 866.7c-.3-2.1-.6-4.4-.9-6.9-2.4-.2-4.7-.5-7-.7-.6 3.2-1.2 6.2-1.8 9.2 3.4-.6 6.3-1.1 9.7-1.6zM105.5 492.4v9c2.7-.4 5.2-.7 7.6-1V493c-2.7-.2-5-.4-7.6-.6zm273.4 435.9c-.7-2.9-1.3-5.4-1.8-7.9h-6.4c-.5 2.7-.9 5.2-1.4 7.9h9.6zm173.7-20.7c3 .2 5.9.5 9.1.7-.4-3.1-.7-5.7-1-8.2h-6.6c-.6 2.5-1 4.6-1.5 7.5zm-10.8-638.8c-3.5.2-6.4.3-9.6.4.6 2.9 1.1 5.2 1.6 7.6h6.3c.5-2.5 1-5 1.7-8zm222.6 395.6v-9.1c-2.8.4-5.2.8-7.6 1.1v6.4c2.7.6 5.1 1.1 7.6 1.6zM173.8 799.2c-2.2-.5-4.1-.9-6.3-1.3-.6 3.2-1.2 6-1.7 8.9 3.2-.3 6-.6 9-.9-.4-2.4-.7-4.3-1-6.7zm562.6-81.5v6.5c2.8.4 5.4.7 7.9 1.1-.4-3.1-.7-5.8-1-8.6-2.1.3-4.3.6-6.9 1zm-115.2-400c.5-2.7 1-5.4 1.5-8.2-3.1.4-5.7.7-8.1 1v6.8c2.3.1 4.4.2 6.6.4zM308.5 907.8c3-.3 5.6-.5 8.5-.7-.4-2.5-.8-4.7-1.2-7h-5.6c-.6 2.6-1.1 5-1.7 7.7zM756.8 534v6.9c2.4.3 4.5.6 6.9.8.2-2.9.4-5.3.5-7.7h-7.4zM194.2 819.4c-2.4-.3-4.7-.5-7.3-.8v8.3c2.7-.6 5.1-1.1 7.3-1.6v-5.9zm134.6-550.3c.6 2.9 1.1 5.3 1.6 7.8h5.6c.5-2.5 1-4.8 1.4-7-2.8-.3-5.5-.6-8.6-.8zm-122.3 578c3-.2 5.7-.4 8.7-.7-.5-2.6-.9-4.8-1.2-6.9-2-.1-3.7-.2-5.6-.4-.6 2.7-1.2 5.1-1.9 8zm489.5-455v5.9c2.3.3 4.4.6 6.8 1 .2-2.7.4-5.1.6-7.7-2.7.3-4.9.5-7.4.8zm-549.2 27.4c2.6-.5 4.8-1 6.7-1.4v-6h-7.2c.2 2.5.3 4.7.5 7.4zm488.4-88c.1 2.3.2 4.2.3 5.9h6.1c.1-2.3.2-4.4.3-6.9-2.3.4-4.3.7-6.7 1zm-380.8-14.2c.4-2.5.7-4.5 1.1-6.9h-7.4c.2 2.4.4 4.6.6 6.9h5.7zM459.6 928c-.6-2.7-1-4.7-1.5-6.6h-5.9c-.3 2.1-.6 4-.9 6.1 2.9.1 5.3.3 8.3.5zm-49-.3c2.8-.2 5.3-.3 8.1-.4-.4-2.3-.8-4.1-1.1-6h-5.7c-.5 2.3-.9 4.2-1.3 6.4zm251.5-576.1h-6.3v6h5.9c.1-2.1.2-3.8.4-6zm19.7 26.3c.2-2.2.4-4.3.6-6.3-2.5.1-4.4.2-6.8.4.2 2.2.4 4.1.6 6.2h3.6c.6-.1 1.2-.2 2-.3zm76 197.3c-.8 5.7.4 6.8 5.8 5.7v-5.7h-5.8zm5.8 40.1c-2.4.6-4.2 1-5.9 1.4v5.2c2.1.2 3.9.3 5.9.5v-7.1zm-657 40.8v7.2c2.2-.5 4-.9 5.9-1.3v-4.7c-1.9-.4-3.6-.7-5.9-1.2zm630.6-182.4v5.2c2 .4 3.8.8 6 1.3v-6.9c-2 .1-3.8.2-6 .4zM234.5 331.6h-5.4v5.5c1.9-.1 3.6-.3 5.4-.4v-5.1zM168 392.3v5.8h5v-5.3c-1.7-.2-3.3-.3-5-.5zm-55.7 148v-5.4H107c.1 1.9.2 3.6.3 5.4h5zM126.4 724c2.5-.2 4.3-.3 6.3-.5v-5.2c-1.7-.2-3.3-.4-4.9-.6-.5 2.2-.9 4.1-1.4 6.3zm448 162.4c2.3-.2 4.1-.3 6.2-.5-.9-3.5-1.2-6.7-5.5-4.6-.3 1.5-.5 3-.7 5.1zm-74.9-614.2c-.3-.5-.7-.9-1-1.4h-6.4c1.5 2 2.5 3.4 3.4 4.7 1.3-1 2.6-2.1 4-3.3zm222.9 466.6h-5.5c.1 1.6.2 2.8.3 4.1 1.9.3 3.4.6 5.2.9v-5zM213.8 352.2c-1.9.1-3.2.2-5 .3.1 1.7.2 3.1.3 4.7 1.7-.1 2.9-.2 4.2-.3.2-1.6.4-2.9.5-4.7zm-20.6 20.6h-4.6v4.7c1.6-.2 3-.3 4.6-.5v-4.2zM107.3 576v4.8c.4.3.8.5 1.1.8 1.3-1.4 2.7-2.8 4-4.2l-.9-1.2c-1.3-.1-2.6-.2-4.2-.2zm-.4 45.4c1.7-.1 3.2-.1 4.7-.2l.9-1.5c-1.4-1.3-2.7-2.6-5-4.8-.3 
                                    3.1-.4 4.5-.6 6.5zm452.7-330.1h-4.9v4.1h4.4c.2-1.4.3-2.5.5-4.1zM290.7 881.7v3.9c1.6-.1 2.8-.2 4.1-.4 1-3.7-.7-4.3-4.1-3.5zM370 270.9c1.7 2 2.8 3.3 3.9 4.5 1-1.3 2.1-2.5 3.7-4.5H370zM127.6 474.6c-1.1 4.5.7 5.2 4.2 4.1v-4.1h-4.2zm183.5-182.7c-.3.5-.7 1-1 1.6 1.5.9 3 1.8 4.9 2.9 1.1-5.4-1.4-4.9-3.9-4.5z"/>
                                <path class="st1" d="M364.7 243.1c-.7.8-1.5 1.5-2.2 2.3-1.4.5-2.8 1-4.1 1.5-5.2 1.7-11.4-.9-14.5-6-3-4.9-2.3-11.7 1.5-15.2 3.9-3.7 11.5-3.4 16.9.6 5.2 3.9 6.4 8.8 3.5 14.4-.5.8-.8 1.6-1.1 2.4zm141.7 1.4c-.6-1.4-1.2-2.7-1.8-4.1-3.2-7.7.3-14.6 8.3-16.4 6.1-1.4 10.5 0 13 4.1 2.8 4.5 2.4 10.8-.8 14.6-3.4 4-9.5 5.4-14.7 3.4-1.3-.5-2.6-1.1-4-1.6zm304.1 354c0 6.9-5 12-12.1 12.1-7 .1-12.1-5-12.1-12 0-7.2 5.1-11.7 13.4-11.6 6.6 0 10.7 4.4 10.8 11.5zM595.8 932.8c-6.9 0-11.4-4.3-11.4-10.9 0-7 4.8-11.5 12.4-11.5 7 0 12.4 5.3 12.3 12-.1 5.9-5.9 10.4-13.3 10.4zm214.7-374.5c0 6.7-5 11.4-12.2 11.4-7.1 0-12.1-4.7-12-11.5 0-7 4.9-11.2 12.7-11.2 7.1 0 11.5 4.4 11.5 11.3zm-41.2 201.2c.1 7.2-4.6 12.7-10.8 12.8-6.6.1-11.9-5.3-11.9-12.3-.1-6.8 5.1-11.5 12.5-11.5 6.1.1 10.1 4.4 10.2 11zM83 517.3c.1 7.1-4.7 12.6-11 12.7-6.3.1-11.8-5.7-11.9-12.6-.1-6.4 4.8-10.9 12-11 6.4-.2 10.8 4.2 10.9 10.9zm117.9-221.1c.1-7.3 5-11.7 12.8-11.7 6.7 0 10.9 4.3 10.7 11-.2 6.6-6 11.7-13.3 11.6-6.4-.1-10.3-4.2-10.2-10.9zM133 365.3c6.6 0 10.8 4 10.8 10.4 0 6.8-5.9 12.1-13.4 12.1-6.3 0-10.2-4-10.2-10.4-.1-7.7 4.6-12.1 12.8-12.1zm312.9 595.8c-.4 7.6-5.9 13.8-11.7 13.4-6.1-.5-11.6-6.6-11.1-12.5.5-6.7 6.5-11.4 13.9-11 5.7.2 9.2 4.3 8.9 10.1zm353.9-333.3c5.8-.1 9.5 3.6 9.6 9.4.1 7.3-5.2 14-11 14.1-6 .1-11.8-5.8-11.8-11.8 0-6.6 5.6-11.6 13.2-11.7zM669.6 326l-1.3-1.3c-.6-1.6-1.4-3.3-1.9-5-1.5-5.6.6-11.1 5.1-13.5 4.7-2.6 10.4-2 13.7 1.2 3.6 3.6 4.1 10.7 1.1 15.4-2.8 4.4-7.7 5.9-13.3 4.2-1.2-.3-2.3-.6-3.4-1zm39 39.3c-.7-2.4-1.8-4.7-2-7.2-.7-6.2 1.7-10.1 6.9-12 5.7-2 10.7-1 13.4 2.7 3 4.1 2.9 10.3-.2 14.2-3.4 4.3-9.4 5.9-14.4 3.9-1.3-.5-2.5-1.1-3.7-1.6zM60.2 679.6c0-7 4.8-11.4 12.5-11.4 6 0 10.2 4.6 10.1 11.1-.1 6.3-5.6 11.6-12.3 11.6-6.2.1-10.3-4.3-10.3-11.3zm30.6 71.8c-6.4 0-10.5-4.3-10.5-11.2 0-6.9 4.9-11.4 12.6-11.4 6.1 0 10.2 4.4 10.1 11-.1 6.6-5.4 11.6-12.2 11.6zm687-282.9c-6.6 0-10.9-4.6-10.8-11.5.1-6.8 4.8-10.7 12.7-10.6 6 .1 10 4.4 10 10.8-.1 6.4-5.2 11.3-11.9 11.3zM393.9 973.3c-6.6-.1-10.7-4.6-10.5-11.7.1-6.8 4.8-10.5 12.8-10.3 6 .1 9.8 4.4 9.7 10.9-.1 6.5-5.2 11.2-12 11.1zm82.4-21.8c6.4 0 10.4 4.2 10.3 10.8-.1 6.3-5 10.9-11.7 10.8-6.4-.1-10.9-4.7-10.8-11.1 0-6.6 4.5-10.5 12.2-10.5zm180.6-644.9c-6.5 0-11.1-4.4-11.1-10.7-.1-6.6 4.5-10.8 12-10.9 6.4-.1 10.5 4.1 10.6 10.6-.1 6.5-4.8 11-11.5 11zm-434.7-31.1c.3-6.6 5.4-10.6 13-10.2 5.4.3 9 4.5 8.7 10.3-.3 6.2-5.9 10.7-12.7 10.4-5.9-.4-9.3-4.3-9-10.5zm565.7 242.7c0-6.8 4.5-10.7 12-10.7 5.6 0 9.4 4.2 9.3 10.2-.1 6.1-5.3 10.9-11.8 10.9-6 0-9.5-3.8-9.5-10.4zM748.6 376c.1 6.2-5.1 11.2-11.5 11.2-5.9 0-9.7-4-9.8-10.4-.1-6.6 4.2-10.5 11.6-10.7 5.8 0 9.6 3.8 9.7 9.9zm-626.2 20.1c.1 6.3-4.9 11.3-11.3 11.4-5.9.1-9.6-3.9-9.7-10.4-.1-6.9 4.3-11 11.8-10.9 5.4 0 9.1 4 9.2 9.9zm49.5 476c-5.9-.1-10.3-5.3-10.1-11.8.2-5.7 5.2-9.9 11.7-9.7 5.5.1 9.2 4.4 9.1 10.5-.1 6.7-4.4 11.2-10.7 11zM141.8 841c0-6.6 4.3-10.4 11.7-10.4 5.8 0 9.4 4 9.3 10.1-.1 6.3-5.2 11-11.7 10.9-5.9 0-9.3-3.9-9.3-10.6zm40.4 40.1c0-6.2 4-9.8 11.2-9.8 6-.1 10.4 4.3 10.5 10.4.1 5.5-5 9.9-11.5 9.9-6.3 0-10.2-4-10.2-10.5zm133-656.1c5.5.1 9.1 3.9 9.1 9.9 0 6.1-4.9 10.8-11.2 10.7-6-.1-10-4.5-9.9-10.8.2-6.1 4.8-9.9 12-9.8zm463.1 525.2c-5.9.1-10.2-4-10.5-9.8-.2-6 4.1-10 11-10.2 5.8-.2 9.9 3.8 10 9.6 0 5.8-4.5 10.3-10.5 10.4zm-645.4 60.9c6.2 0 9.7 3.5 9.7 9.7 0 5.7-4.5 9.9-10.5 9.9-5.9 0-10.5-4-10.7-9.3-.1-6.3 4.3-10.3 11.5-10.3zM304 941.6c.1 6-4.1 10.3-10.3 10.5-6.2.2-10.5-4-10.5-10.2 0-6 4.5-9.9 11.3-9.9 5.6 0 9.4 3.9 9.5 9.6zm495.3-271.9c6.3 0 9.6 3.3 9.6 9.7 0 5.8-4.3 9.9-10.4 9.9-6 0-10.5-4-10.5-9.3-.1-6.4 4.1-10.2 11.3-10.3zM415.7 205.3c5.8.1 9.2 3.5 9.2 9.1 0 5.9-5.2 10.3-11.7 10.1-5.5-.1-8.9-3.6-8.9-9 0-6.3 4.5-10.3 11.4-10.2zm220 79.8c-5.6 0-9.1-3.2-9.2-8.6-.2-6.5 4.4-10.7 11.4-10.7 5.7.1 9.3 3.6 9.2 9.2-.1 5.7-5.1 10.1-11.4 10.1zm52 576c.1-6.1 4.2-9.7 10.8-9.5 5.2.2 9.8 4.7 9.8 9.7 0 5-5.8 9.6-12.1 9.5-5.4-.1-8.5-3.6-8.5-9.7zM61.6 477.6c.1-6.1 4.1-9.7 10.8-9.6 5.3.1 9.8 4.4 9.9 9.5.1 5.1-5.6 9.6-11.9 9.6-5.4 0-8.9-3.7-8.8-9.5zm515.3 454.9c5.5-.1 10.3 4.4 10.3 9.5 0 4.9-5.9 9.6-12.1 9.5-5.3-.1-8.6-3.5-8.7-9.2.1-6.2 3.7-9.7 10.5-9.8zm-30.6-697.2c0-6.4 3.7-9.6 10.7-9.6 5.3 0 9.9 4.3 10 9.3.1 5.1-5.4 9.6-11.9 9.6-5.6.1-8.8-3.3-8.8-9.3zm-101-20.4c.1-6.1 4.2-9.7 10.9-9.5 5.3.1 9.7 4.6 9.8 9.6 0 5.1-5.5 9.5-12 9.4-5.6 0-8.8-3.5-8.7-9.5zm-92.1 756.8c-5.6 0-8.9-3.5-8.9-9.4.1-6.1 4.1-9.7 10.8-9.7 5.3.1 9.8 4.4 9.9 9.5.1 5.2-5.3 9.5-11.8 9.6zm-130.6-70.2c0 5.7-4.1 9.7-9.9 9.8-5.9 0-9.9-4.1-9.9-10.3 0-5.5 4.8-9.3 11.5-9.2 5 .2 8.3 4 8.3 9.7zM727.5 841c0 5.7-4.1 9.6-10 9.6-6 0-9.9-4-9.9-10.2 0-5.4 4.3-8.9 11.1-9 5.4 0 8.9 3.7 8.8 9.6zm31.7-453.3c5.4.1 8.6 3.5 8.4 9.2-.1 5.5-4 9.2-9.8 9.2-5.9 0-9.5-3.9-9.4-9.9.2-5.6 4-8.6 10.8-8.5zM51 587.8c-5.9-.1-9.5-4-9.4-10 .1-5.5 4.1-8.5 10.8-8.4 5.4.1 8.6 3.6 8.4 9.3-.1 5.4-4.2 9.2-9.8 9.1zm464.8 384c-5.2-.1-9.7-5-9.5-10.4.2-5.1 4.8-8.8 10.5-8.6 4.8.2 8 3.8 8 8.9 0 5.7-4 10.2-9 10.1zm170.5-90.9c0 5.9-3.7 10.1-8.9 10-5.1-.1-9.3-4.4-9.4-9.8-.1-5.3 4-9 9.9-9 5.1-.1 8.4 3.4 8.4 8.8zM60.6 619.3c0 5.2-3 8.9-7.3 9-5.7.1-12.1-5.6-11.9-10.6.1-4 4.9-7.7 10-7.7 5.2-.1 9.2 4 9.2 9.3zm201.3-364.8c0 5.9-4.3 10.9-9.1 10.7-4.9-.1-9-4.3-8.9-9.3 0-5.6 4.2-9.5 10.1-9.5 5 .1 7.9 3 7.9 8.1zm112.5-48.4c5.4 0 9.3 3.8 9.3 9.2 0 5.3-2.9 8.8-7.3 8.9-5.8.1-12-5.4-11.9-10.5.1-4 4.7-7.6 9.9-7.6zM111.6 809.5c-5.5 0-8.9-3.6-8.9-9.4-.1-5 4.1-8.4 10.4-8.5 4.7 0 7.9 3.5 7.9 8.8 0 5.4-3.9 9.2-9.4 9.1zM739 812c4.9 0 7.9 3.2 7.9 8.7 0 5.4-3.8 9.2-9.3 9.2-5.4 0-8.8-3.6-8.9-9.5 0-5.2 3.9-8.4 10.3-8.4zm-81.9 98.5c-5.6.1-9.2-3.6-9.2-9.6 0-4.8 4-8.1 10.2-8.3 4.7-.1 8 3.3 8.2 8.6.1 5.3-3.8 9.2-9.2 9.3zM80.5 719.7c0 5.4-3.8 9.1-9.3 9.1-5.4 0-8.8-3.7-8.9-9.5 0-5.1 4-8.4 10.4-8.4 4.8 0 7.8 3.3 7.8 8.8zm405.9-505.4c0-5.1 4.2-8.3 10.5-8.2 4.9.1 7.7 3.4 7.6 8.9-.1 5.3-4.1 9.1-9.5 9-5.3-.1-8.6-3.8-8.6-9.7zm-403.9 202c0-5 4.2-8.3 10.5-8.3 4.7 0 7.8 3.6 7.8 8.9-.1 5.3-4.1 9.1-9.5 9-5.4 0-8.8-3.7-8.8-9.6zm717.1 52.9c4.5.1 7.1 2.8 6.9 7.4-.2 5.5-4.3 10.5-8.5 10.4-4.3-.1-8.6-4.9-8.5-9.3.2-5 4.5-8.6 10.1-8.5zM50.9 547.6c-4.4-.1-8.6-4.8-8.5-9.3.2-4.9 4.5-8.7 10.1-8.6 4.4.1 7.1 3 6.9 7.5-.2 5.5-4.3 10.5-8.5 10.4zM617.7 247c4.5 0 7.1 2.7 7.1 7.3-.1 5.5-4 10.5-8.3 10.6-4.3 0-8.8-4.6-8.7-9.1 0-5 4.3-8.8 9.9-8.8zM241.3 922.7c-.1 4.7-3.3 7.9-7.9 7.8-4.6-.1-9-4.6-8.9-9.4 0-4.3 3.9-7.5 9-7.4 4.5.1 7.9 3.9 7.8 9zM50.6 667.2c-4.7-.1-7.6-3.1-7.5-8 .1-5 3.8-8.3 9.2-8.1 4.5.1 7.4 3.2 7.3 7.8.1 4.9-3.8 8.4-9 8.3zm715.8 134.2c.1 4.5-1.9 7-5.6 7.1-5 .2-11.3-4.8-11.4-8.9-.1-3.6 4.8-7 10-6.9 4.4 0 6.9 3.3 7 8.7zm60.5-221.8c-.1 4.5-2.2 6.9-5.9 6.8-5.1-.1-11.2-5.3-11.1-9.4.1-3.4 5-6.6 10-6.5 4.5.1 7.1 3.4 7 9.1zm-.3 38.9c.1 4.9-3.4 8.4-8.3 8.4-4.6 0-7.6-3.1-7.8-7.9-.1-4.7 3.6-8 9.2-8.1 4.2 0 6.8 3 6.9 7.6zM321.8 962.2c0 4.7-3.1 7.8-7.8 7.8-4.8 0-8.3-3.4-8.3-8 0-4.4 3.5-7.3 8.8-7.5 4.5 0 7.3 2.9 7.3 7.7zm323.1-40.3c0 4.8-3.1 7.7-8 7.6-4.7-.1-8.1-3.4-8.1-7.8s3.6-7.5 8.8-7.5c4.6-.1 7.3 2.8 7.3 7.7zm145.6-202.4c.1-4.5 3.6-7.3 9-7.2 4.5.1 7.3 3.2 7.1 7.9-.2 4.4-3.5 7.5-7.9 7.5-4.8 0-8.3-3.5-8.2-8.2zm-4.2-302.6c0 4.8-3 7.8-7.7 7.8-4.8 0-8.4-3.4-8.4-7.9 0-4.4 3.5-7.3 8.8-7.4 4.6-.1 7.3 2.7 7.3 7.5zM83.6 780.8c0-4.5 3.5-7.7 8.5-7.8 4.1-.1 7.5 2.9 7.5 6.7.1 4.1-4.6 8.2-9.5 8.3-4.2 0-6.5-2.5-6.5-7.2zM341.3 215c-.1 5-2.5 7.4-7.5 7.3-4.8-.1-7.5-2.6-7.5-6.9 0-4.3 3.6-7.7 8.1-7.7 4.5-.1 7 2.6 6.9 7.3zm216 753.7c-5-.1-9.2-3.1-9.2-6.6.1-3.6 4.6-7.2 8.9-7.1 4.4.1 7.3 3.3 7.2 7.9-.1 3.7-2.5 5.8-6.9 5.8zm-94.9 13.9c0 4.6-1.6 6.8-5.2 6.8-4.5.1-9.9-4.4-9.8-8.2.1-3.1 4.3-6.1 8.7-6.2 4 0 6.2 2.7 6.3 7.6zM280.7 235.7c0 4.5-1.8 6.6-5.4 6.6-4.3 0-9.5-4.3-9.6-7.9-.1-3.2 4.4-6.4 9-6.5 3.7 0 6 2.9 6 7.8zM422 982.9c0 4.4-1.8 6.6-5.5 6.6-4.3-.1-9.5-4.4-9.6-7.9-.1-3.2 4.5-6.4 9-6.4 3.9-.1 6.2 2.8 6.1 7.7zm121.2-767.6c0 4.4-1.8 6.9-5.2 6.9-4.4.1-9.8-4.5-9.7-8.3.1-3.2 4.1-6 8.6-6.1 4.2 0 6.2 2.5 6.3 7.5zm282.7 323.2c0 4.4-1.8 6.8-5.2 6.8-4.5 0-9.8-4.5-9.6-8.3.1-3.2 4.2-6 8.7-6 4-.1 6.1 2.4 6.1 7.5zM51.3 504.6c-4.5-.1-7.3-2.8-7.3-7.2 0-3.8 3.3-6.5 8-6.5 4.1 0 7.1 3.1 7 7.5-.1 3.7-3.3 6.2-7.7 6.2zm27.4-66.8c-.1 2.9-.5 6.1-4.8 6.4-4.2.3-9.8-4.4-9.8-8.2 0-3 3.5-5.6 7.9-5.7 4.2 0 6.6 2.6 6.7 7.5zm747.2 222.3c-.2 2.9-.5 6-4.9 6.2-4.4.1-9.8-4.5-9.7-8.2.1-3 3.7-5.5 8-5.5s6.6 2.5 6.6 7.5zM260.5 942.8c-.3 2.9-.6 6.1-5 6.2-4.4.1-9.8-4.6-9.7-8.3.1-3 3.8-5.5 8.1-5.5 4.2.1 6.6 2.7 6.6 7.6zM152.4 309.4c3.7 0 6.8 3.4 6.7 7.5-.1 3.5-2.4 5.9-5.9 6-4.1.1-8.5-4-8.3-7.8.1-3 3.8-5.7 7.5-5.7zm-13.5 26.1c.1 3.5-3.8 7.3-7.7 7.3-3.3.1-5.9-2.8-6-6.5-.1-3.9 2.9-6.7 7.2-6.8 3.5 0 6.4 2.6 6.5 6zm234.6 653.6c-3.3.1-5.9-2.9-5.9-6.5 0-3.9 3-6.8 7.2-6.8 3.6 0 6.2 2.4 6.3 6 0 3.5-3.7 7.2-7.6 7.3zm-319.2-296c.8 1.1 3 2.9 3.3 5 .6 3.9-4.4 8.7-8.1 8.5-2.9-.2-5.3-3.9-5.2-7.8.1-2.9 4.4-5.9 10-5.7zm730.4 84.6c0 4.9-4.1 9.6-7.7 9.8-3.1.1-5.9-3.6-5.8-7.7 0-3 4.3-6.1 8.3-5.9 2.9.1 5.1 1.5 5.2 3.8zM488.5 981.9c-.1-3.1 3.8-6.1 8.1-6 3 0 5.2 1.3 5.4 4.7.2 4-4.1 8.9-7.9 8.8-3-.1-5.6-3.5-5.6-7.5zM590 235.4c.1-4.5 2.5-6.8 6.9-6.7 4 .1 6.2 2.3 6 6-.2 3.6-3.8 7.1-7.3 7.2-3.4-.1-5.7-2.6-5.6-6.5zm-424.1 60.7c.1-4.6 2.2-6.7 6.9-6.7 3.7 0 5.4 2 5.4 5.5-.1 4-3.3 7.8-6.6 7.7-3.1 0-5.7-3-5.7-6.5zM623 942c0 3.9-2.2 6.1-6.1 6.1-3.8 0-6.7-2.6-6.8-6.2 0-3.5 2.6-6 6.4-5.9 3.8.1 6.6 2.6 6.5 6zM199.2 276.5c-.1 2.5-.8 5.2-4.7 5.1-3.6-.1-8.3-3.7-8.5-6.7-.2-2.7 3.1-5 7.3-5 3.7-.2 5.8 2 5.9 6.6zm524.1 39c0 4-2.4 6.4-6 6.4-4 0-5-2.7-5.2-5.8-.2-3.7 2.3-6.1 6-6.2 4-.1 4.7 2.8 5.2 5.6zM440.9 194.6c0 3.6-1.6 5.6-5.3 5.5-3.7-.1-6.9-2.8-6.6-5.7.4-3.4 2.6-5.2 6-5.3 3.9-.1 5.9 1.9 5.9 5.5zM111.2 350.5c4-.1 6.5 2.1 6.7 5.4.1 3.6-1.4 5.7-5.1 5.9-3.4.2-7.1-2.8-6.9-5.6.2-3.5 2.6-5.1 5.3-5.7zm-39.5 404c3.8.1 5.9 2.1 5.8 5.7-.1 3.6-1.9 5.6-5.6 5.3-3.4-.3-6.1-1.7-6.5-5.5-.2-2.7 3.2-5.6 6.3-5.5zm725.8-311.8c-3.5-.3-5-2.3-4.9-5.6.1-3.4 3.2-5.9 6.8-5.6 3.5.3 5 2.2 4.9 5.6-.3 3.5-3.2 5.9-6.8 5.6zm20.1 60.7c-2.8-.2-4.8-1.8-4.8-5.3 0-3.4 2.9-6.3 6.3-6.2 3.3.2 5.3 1.9 5.4 5.3.2 3.4-2.9 6.2-6.9 6.2zM691.5 295.7c.4-3.6 3.5-5.9 7.1-5.6 3.5.4 4.8 2.5 4.6 5.8-.3 3.4-3.3 5.7-6.9 5.3-3.6-.3-4.7-2.5-4.8-5.5zm46.6 34.8c4 .2 5.3 2.5 5.4 5.9.1 2.9-.7 5-4.1 5.2-3.4.1-7.5-3-7.3-5.9.2-3.6 3.2-4.5 6-5.2zM400.5 
                                    196.8c-1.2.9-2.8 2.9-4.7 3.3-3.4.6-7.4-3-7-5.9.4-3.7 3.3-4.8 6.4-4.9 4-.1 4.8 2.9 5.3 7.5zm73.9-7.5c5 .3 6.5 2.3 6.6 5.6.1 2.8-.5 5.1-3.9 5.3-3.3.2-8.1-3.2-7.3-5.6.8-2.4 3.5-4.1 4.6-5.3zm201.7 81c5.5-.1 6.7 2.3 6.8 5.4.1 2.7-.7 5.1-3.9 5.3-3.2.2-8-3.3-7.2-5.7.8-2.3 3.4-4 4.3-5zM37.5 599.9c-1.6 1.4-3 3.7-4.9 4.1-3.1.8-7.4-3-7.2-5.7.2-3.9 3.4-4.5 6.3-4.8 3.8-.3 4.9 2.2 5.8 6.4zm256.3-380.2c-3.1.2-5.2-.7-5.2-4.1 0-3.3 2.4-5.7 5.6-5.6 3.3.1 4.2 2.2 4.2 5 .1 3.2-1.2 5.1-4.6 4.7zm-258.1 339c.4 3.3-1.7 4.4-4.8 4.3-2.9 0-4.9-1.1-4.9-4.4 0-3.3 2.4-5.5 5.7-5.4 3.7.1 4.1 2.5 4 5.5zm787.8 141c.2 3.5-1.6 4.9-4.8 4.8-2.8-.1-5-.8-4.9-4.3.1-3.4 2.2-5.5 5.6-5.5 3.5-.1 3.9 2.3 4.1 5zM213.2 260c-3 .2-5.2-.4-5.3-3.9-.1-3.3 2.2-5.8 5.3-5.8 3.3 0 4.4 1.9 4.4 4.8 0 3.1-.8 5.4-4.4 4.9zm-94.6 581.1c-2.7 2.2-4 4.1-5.8 4.6-2.5.6-6.6-3.1-5.6-5s3.4-3.8 5.4-4.1c1.5-.1 3.3 2.4 6 4.5zm634.6-482.6c-.3-5 1.6-6.8 5-6.3 1.7.2 4.2 1.2 4.7 2.5 1 2.2-3.9 6.7-6.7 6.2-1.4-.2-2.5-1.9-3-2.4zM542.6 982.4c-2.6 2.2-4 4.1-5.7 4.6-2.5.7-6.5-3-5.6-4.9 1-1.9 3.4-3.8 5.4-4.1 1.4-.2 3.2 2.3 5.9 4.4zm-266.9-24.3c.4.4 1.6 1.6 2.9 2.8-2.3 2-4.7 4-7 6-1-1.5-2.8-2.8-3-4.4-.4-3.6 2.1-4.8 7.1-4.4zM52.4 452.3l3.9 3.6c-2.3 2.1-4.5 4.1-6.8 6.2-1.1-1.4-2.9-2.7-3.1-4.3-.5-3.6 1.9-4.9 6-5.5zm74.8 410.9c-.1-5.3 2.2-6.7 5.4-6.2 1.7.3 3.1 1.8 4.7 2.8-2.3 2-4.5 4.3-7 5.9-.5.3-2.6-2-3.1-2.5zm666.3-100.9c-.2-5.2 2.1-6.7 5.3-6.3 1.7.2 3.2 1.7 4.7 2.7-2.2 2.1-4.4 4.3-6.9 6-.4.3-2.5-1.9-3.1-2.4zM583.1 215.1c-2.8 2.2-4.2 4-5.9 4.4-2.6.6-6.6-3-5.6-4.9 1-1.8 3.4-3.6 5.4-3.9 1.5-.1 3.3 2.3 6.1 4.4zM167.7 903.8c-.4-5 1.5-6.8 4.8-6.4 1.8.2 3.4 1.8 5 2.8-2.3 2-4.5 4.2-7 5.8-.4.4-2.3-1.8-2.8-2.2zm-14.4-27.4c1.3 1.2 2.7 2.3 4 3.5-2.2 2.1-4.4 4.2-6.7 6.3-1.1-1.4-2.9-2.7-3.1-4.2-.6-3.6 1.7-4.9 5.8-5.6zM92.8 371.6c1.3 1.2 2.7 2.4 4 3.5-2.3 2.1-4.5 4.1-6.8 6.2-1.1-1.4-3-2.7-3.2-4.3-.5-3.5 2-4.8 6-5.4zM26.3 641.2c-.2-5 1.6-6.7 5.1-6.2 1.7.3 4.1 1.3 4.7 2.6.9 2.1-4.2 6.7-6.9 6.1-1.4-.3-2.5-2.1-2.9-2.5zM361 194.6c-2.9 2.3-4.9 4.9-5.9 4.6-2.1-.7-3.8-3-5.6-4.6 1.8-1.5 3.3-3.8 5.3-4.2 1.3-.2 3.2 2.1 6.2 4.2zm-25.8 782.8c1.3 1.2 2.5 2.4 3.8 3.6-2.3 2.1-4.5 4.1-6.8 6.2-1.1-1.4-2.8-2.8-3.1-4.3-.5-3.7 2.1-4.8 6.1-5.5zm327.5-721.1c-1.6 1.2-3.6 3.8-4.7 3.4-2.2-.7-3.9-2.9-5.7-4.5 1.8-1.5 3.4-3.6 5.4-4.2 2.9-.8 4 1.6 5 5.3zM602 963.1c-1.6 1.2-3.6 3.8-4.6 3.5-2.1-.7-3.8-3-5.6-4.6 1.8-1.4 3.3-3.6 5.3-4.2 2.9-.7 4.1 1.6 4.9 5.3zm-86.3-761.9c-2.1-3.1-4.3-4.9-4.2-6.6 0-1.4 2.7-3.7 4.3-3.8 1.5 0 4.5 2.5 4.4 3.5-.3 2-2.4 3.8-4.5 6.9zM736.6 866c-1-1.5-3.1-3.5-2.8-4.4.8-1.9 2.9-3.1 4.5-4.7 1.2 1.4 3.6 2.8 3.5 4-.2 1.8-2.1 3.4-3.3 5.1h-1.9zM716 885.5c-.6-.9-2.6-2.8-2.2-3.7.7-1.8 2.6-3.8 4.4-4.4 2.3-.7 3.7 1.1 3.6 3.7-.1 3-1.6 4.4-5.8 4.4zM29.7 522.7c-.9-1.5-3-3.5-2.6-4.4.8-1.8 2.8-3.4 4.7-4.3.5-.2 3.5 2.5 3.3 3.4-.4 2-2.2 3.7-3.4 5.5-.7-.1-1.4-.2-2-.2zm167 397.5c-.1 4.3-1.6 5.6-4.5 5.7-2.6 0-4.3-1.5-3.6-3.8.6-1.8 2.7-3.6 4.6-4.3.9-.3 2.8 1.8 3.5 2.4zm647-320.9c-1.7 1.1-3.3 3-5 3.1-1.2.1-2.7-2.1-4-3.3 1.5-1.5 2.8-3.6 4.6-4.4.9-.4 2.9 1.6 4.3 2.5 0 .8 0 1.5.1 2.1zm-612-359.6c-.9-1.4-2.5-2.8-2.6-4.3-.1-2.7 1.8-4.6 4.6-4.1 1.2.2 3.2 2.4 3 3.2-.5 1.9-2.1 3.6-3.2 5.3-.6.1-1.2 0-1.8-.1zM52.4 735.4c.9 1.4 2.9 3 2.6 4-.5 1.8-2.2 3.5-3.9 4.4-.6.3-3.8-2.1-3.6-3 .3-1.9 1.9-3.6 3-5.5.6.1 1.2.1 1.9.1zm787.7-181.7c.9 1.4 2.7 3.1 2.4 4.1-.6 1.7-2.3 3.4-4 4.3-.6.3-3.6-2.3-3.5-3.2.3-1.9 2-3.6 3.1-5.3.7 0 1.4.1 2 .1zm-138 348.4c-1.7 1.2-3.3 2.9-5.2 3.3-.9.2-3.6-2.8-3.3-3.3.8-1.7 2.4-3.5 4.1-4.2.9-.4 2.7 1.4 4.1 2.2.2.7.3 1.3.3 2zM783 376.9c-1.7 1.2-3.3 2.9-5.2 3.5-.8.2-3-1.8-3.3-3-.5-2.7 1.1-4.8 3.9-4.6 1.5.1 2.9 1.5 4.3 2.4.1.5.2 1.1.3 1.7zm35.4 85.9c-1.7-2.7-3.5-4.3-3.4-5.7.1-1.3 2.5-3.5 3.5-3.3 1.6.2 3.8 2.1 3.9 3.5.2 1.3-2 2.9-4 5.5zm24.9 177.1c-1.5 1-3.2 2.9-4.6 2.7-1.5-.2-2.6-2.4-3.9-3.7 1.3-1.2 2.6-3.2 3.9-3.3 1.5-.1 3 1.6 4.6 2.6v1.7zM76.1 397.3c-1.5 1-3.1 3-4.5 2.9-1.4-.1-2.7-2.2-4-3.5 1.2-1.2 2.3-3.3 3.6-3.4 1.5-.1 3.2 1.5 4.8 2.3 0 .6.1 1.1.1 1.7zm15.5 418c1.9 2.6 3.8 4.1 3.8 5.5 0 1.3-2.3 3.6-3.3 3.5-1.5-.2-3.8-1.9-4.1-3.3-.4-1.2 1.7-3 3.6-5.7zM36.8 679.7c-2.8 1.6-4.5 3.4-5.9 3.2-1.4-.2-2.5-2.5-3.7-3.8 1.5-1.1 2.9-2.9 4.4-3 1.2-.2 2.7 1.7 5.2 3.6zM435 1007.5c-1.8-2.1-3.8-3.5-3.8-4.7.1-1.3 2.3-3.6 3.4-3.5 1.5.2 3.5 1.9 4 3.4.3.9-1.8 2.6-3.6 4.8zm323-171.6c1.8 2.3 3.5 3.6 3.8 5.3.2.8-2.3 3.2-3.3 3-1.6-.3-3.7-1.8-4.1-3.2-.3-1 1.8-2.7 3.6-5.1zm-80.5 80.9c1.7 2.4 3.7 3.9 3.5 5.1-.2 1.3-2.5 3.2-3.8 3.2-1.3 0-3.4-2.1-3.5-3.4-.1-1.3 2-2.7 3.8-4.9zM216.7 943c-1.3.8-2.7 2.1-4 2.1-1.1 0-2.2-1.6-3.3-2.5 1.3-1.4 2.4-3.1 4-3.9.5-.3 2.2 1.6 3.4 2.5-.1.6-.1 1.2-.1 1.8zm424-706.6c-1.4.7-2.8 1.9-4.2 1.9-1.1 0-2.1-1.7-3.2-2.6 1.3-1.3 2.5-3 4.1-3.7.6-.3 2.2 1.7 3.3 2.7.1.5 0 1.1 0 1.7zm-243.6 769.5c-1.8-.4-3.8-.5-5.4-1.4-.5-.3-.3-3.1.5-3.8.9-.9 3.7-1.7 4.1-1.2 1.1 1.3 1.5 3.4 2.1 5.1-.5.4-.9.9-1.3 1.3zm80.6.1c-1.8-.4-3.8-.6-5.3-1.5-.5-.3-.2-3.1.6-3.8.9-.9 3.7-1.6 4-1.2 1.1 1.4 1.4 3.4 2 5.1-.5.5-.9.9-1.3 1.4zM783 821.1c-2.4 1.4-3.8 2.8-5.1 2.7-1.1-.1-2-1.9-3.1-3 1.2-1 2.3-2.7 3.7-2.9 1-.2 2.3 1.5 4.5 3.2zM313.8 199.3c-1.6-2-3.4-3.4-3.2-4.3.3-1.3 2-2.8 3.3-3.1.8-.2 3 1.8 2.9 2.7-.1 1.4-1.6 2.7-3 4.7zm509.7 540.9c-2.4 1.4-3.8 2.8-5.1 2.8-1.1-.1-2-1.9-3.1-2.9 1.2-1 2.3-2.7 3.6-2.9 1-.3 2.3 1.4 4.6 3zM293.8 977.7c1.5 2.3 3 3.7 2.8 4.6-.4 1.3-2 2.8-3.3 3.1-.7.2-2.8-1.9-2.8-2.9 0-1.3 1.6-2.5 3.3-4.8zm549.8-459.6c-2.5 1.5-3.9 3-5.1 2.9-1.1-.1-2-1.9-3-3 1.2-1 2.3-2.6 3.6-2.9.9-.2 2.2 1.4 4.5 3zM573.1 982.7c.9-1.2 1.9-2.3 2.8-3.5l1.5.3c.1 1.7.2 3.3.3 5-1.4-.1-2.9-.2-4.3-.3 0-.5-.1-1-.3-1.5zm-16.6-784.6c-1.3-1.5-2.8-2.5-2.7-3.3.1-.9 1.5-2.1 2.5-2.3.6-.1 2.2 1.3 2.2 2 .1 1-1 2-2 3.6zm237.6 199.7c2.2-1.9 3.3-2.8 4.5-3.7.6.8 1.6 1.4 1.8 2.3.2.9-.5 2.7-.6 2.7-1.6-.2-3-.6-5.7-1.3zM31.4 474c1.1 1.7 2.2 2.7 2.2 3.7 0 .7-1.6 2.1-2.2 2-1-.2-2.5-1.4-2.5-2.2-.2-1 1.2-1.9 2.5-3.5zm627.1 465.2v5c-1.2-.2-2.4-.5-3.6-.7.4-1.6.7-3.1 1.1-4.7.8.2 1.6.3 2.5.4zM31.2 716.3c1.2 1.7 2.3 2.6 2.4 3.6.1.7-1.4 2.2-2.1 2.1-1-.2-2.6-1.2-2.7-2-.1-1 1.2-2.1 2.4-3.7zm326.9 286c-1.9 1.2-2.9 2.3-3.8 2.2-.9 0-1.7-1.2-2.6-1.8.8-.9 1.5-2.3 2.4-2.6.9-.1 2 1.1 4 2.2zm258.4-790.9c1.3 1.6 2.5 2.5 2.6 3.5.1.6-1.3 2.1-2 2.1-1-.1-2.5-1-2.7-1.9-.1-.8 1.1-1.9 2.1-3.7zM236.9 962.7c-2.1.8-3.3 1.6-4.3 1.4-.8-.1-1.4-1.4-2-2.2.9-.7 1.9-2 2.8-2 .9 0 1.8 1.3 3.5 2.8zM454 178.3c-.4-1.2-1.4-2.5-1.2-3.6.2-.9 1.5-2.1 2.5-2.4.6-.2 2.2 1.1 2.3 1.8.1.9-.9 2-1.5 2.9-.7.5-1.4.9-2.1 1.3zm-39.2-7.2c1.2 1.6 2.4 2.5 2.5 3.4.1.6-1.4 2.1-2.1 2.1-1-.1-2.6-1.1-2.7-1.9-.2-.8 1.1-1.9 2.3-3.6zM74.9 802.3c-1.1.3-2.3 1-3.3.8-1.1-.2-2-1.3-3-2 .9-1.1 1.5-2.7 2.6-3.1.9-.3 2.3.8 3.5 1.3.1 1 .2 2 .2 3zM55.1 416.9c-1.9 1.1-2.9 2.2-3.9 2.2-.8 0-1.6-1.2-2.4-1.9.8-.9 1.5-2.2 2.5-2.4.9-.2 2 .9 3.8 2.1zm783.6 259c1.3 1.6 2.5 2.4 2.7 3.4.1.6-1.4 2.1-2 2.1-1-.1-2.6-1-2.8-1.9-.2-.8 1.1-1.9 2.1-3.6zM515.4 999c1.4 1.5 2.6 2.3 2.8 3.3.1.6-1.3 2.2-1.9 2.2-1 0-2.6-.9-2.8-1.8-.2-.8 1-1.9 1.9-3.7z"/>
                                <path class="st1" d="M631.2 139.4c2 4.3 4 8.6 6.3 13.5 2 .1 5.3.4 9.1.6-.3-5.1-.5-10.8 4.6-13.6 3.5-1.9 8.2-3 12.2-2.7 9 .8 12.9 7.8 10.8 17.5 5.3.6 10.6 1.3 15.7 1.9 0-2.7-.9-6.5.3-9.6 1.2-3 4-5.9 6.8-7.7 4-2.6 10.5-1 13.5 2.4 3.3 3.9 3 10.9-.8 16.2-3.7 5.2-7.8 6.3-14.5 3.8.6 3.8 1.1 7.6 1.8 11.7 3.3.2 6.8.5 10.9.8-.3-6.2.6-12.6 7-15.6 3-1.4 7-1.9 10.2-1.1 8.2 1.9 11 10.3 7.5 21.2 6.3-2.4 12.3-2.7 18 1 6.3 4.1 6.6 10 4.5 16.6 15.7-1.7 20.4 2.4 21.9 17.6 5.7 2 10.9 3.8 16.1 5.7l1.3 1.3c1.3 4.8 2.6 9.7 3.9 14.8 3.5.4 8.2 1 12.8 1.5-1.7-8.4-.4-12.8 4.7-15.6 4.9-2.7 11.6-2.3 15.1.9 3.2 2.9 4.1 8.1 2.2 12.4-2.5 5.6-8.1 7.9-17.6 7 .6 2.4 1.5 4.7 1.8 7.1.3 2.3.1 4.7.1 7.5 5.9-1.2 11.3 0 16.1 3.7 3.6 4.7 5.2 10 3.6 16.4 6.2-.2 11.9.5 16.2 5.1 4.4 4.7 5 10.2 2.6 16.7 5.5-1.7 10.8-2.4 14.3 1.8 2.7 3.3 5 7.5 5.7 11.7 1.5 8.7-4 13.2-15.9 14.2.2 3 .4 6.1.6 9.5 3.2.5 6.4.9 10.4 1.5-1.9-5.9-1.1-11.4 3.8-15.2 1.9-1.5 4.9-2.4 7.4-2.4 7 0 13.8 7.2 13.8 13.9 0 7.3-6 11.3-17.5 11.5.3 4.1.5 8.1.8 12.6 6.1-.6 11.8.5 15.6 6.1 3.7 5.4 3.6 11.2.3 17.7 6.7-2.9 12.7-3.7 17.1 2.6 3.6 5.1 4.5 10.8 1.6 16.5-3.2 6.2-9.1 5.7-15.2 4.8.2 4.7.4 9.1.6 13.5 12.4.6 17.3 4.6 17.3 14.4.1 9.7-4.6 13.8-16.7 14.4v10.9c5.4-.2 11.1.1 14.1 5.2 1.9 3.3 3.2 7.5 3.2 11.3-.1 8.9-6 13.3-16.6 13.5v9.6c11.8 1.9 17.2 7.5 16.7 17-.4 8.9-5.3 12.9-17.4 14v10.6c5.3-.4 10.9.3 13.6 5.6 1.8 3.5 2.9 8 2.5 11.9-.9 8.9-7.2 12.4-17.1 10.8-.3 5-.7 10-1 15.2 6.8-2.4 13.3-1.6 16.8 6.7 2.3 5.4.5 12-3.9 15.4-4 3.2-9.2 3.4-13.8.5-5.8-3.6-7.5-8.8-5.3-17-3.6.9-7 1.8-11 2.9-.2 2.4-.3 5.3-.5 8.2 12.1 1.2 17.2 6.9 15.9 17.7-1.1 9.4-6.8 12.9-16.9 11.4-1.4 5.6-1.9 11.4-4.4 16.3-2.8 5.6-9.3 5.6-15.1 5.9-.3 3.9-.7 7.6-1 11.9 5.9-1.2 11.5-.3 14.6 5.3 1.6 2.8 2.7 6.4 2.6 9.6-.3 6.9-6.3 11.1-13.9 10.6-8.9-.6-12.1-5.2-12-17.3-3 .5-6 1.1-9.5 1.7-.3 2.7-.7 5.6-1.1 8.8 5.3.1 11.3-.2 14.1 5.2 1.6 3.2 2.3 7.5 1.7 11.1-1.7 10.3-8.3 13.5-19.7 10.3 2.8 7.3 1 13.5-4.4 18.7-4.1 4-7.7 4.4-15 2 1.7 6.6.7 12.5-4.1 17.3-4.9 4.8-10.5 5.9-17.6 2.2 3.2 6.9 3.6 12.8-2.4 17.4-5.2 4-11.1 4.5-17.4 2.8 1.7 11.3-3.7 21.2-12.1 22.5-7.6 1.2-13-5.2-14.7-17.8-3 .3-5.9.6-9 .9-.6 3.1-1.2 6.4-1.9 9.7 12.5.4 18.1 4.2 17.7 11.9-.4 7.4-8.3 14.4-15.6 13.7-7-.6-10.9-7.3-10-17.3-3.7.5-7.3 1-9.7 1.3-2.9 5.4-4.9 10.9-8.5 15.1-4 4.7-10.2 3.9-16.3 2.4 1.3 5.3 2.1 10.6-2 14.1-3 2.5-7.1 4.6-11 5.1-9.3 1.3-14.1-4.4-14.8-16.4-3.1.3-6.3.6-9.3.9-1 3.7-2.1 7.4-3.1 11 8.6-1.5 14.8 1 17.7 7.1 2.2 4.6 1.2 10.9-2.4 14-4 3.6-10.9 3.6-16.3.1-5.4-3.6-6.5-8.1-3.8-16.3-2.6.7-5 1.7-7.5 1.8-2.6.2-5.2-.5-8.1-.8 1 4.6 1.9 9.7-2.1 12.9-3.2 2.5-7.4 4.7-11.4 5.2-9.8 1.1-14-4.4-13.6-16.3h-12.7c.5 5.1.8 10.8-4.3 13.8-3.4 2-7.7 3.2-11.7 3.2-8.7 0-12.7-5.7-12.5-16.5h-9.7c-1.8 4.4-2.5 9.2-5.3 12.1-2.6 2.7-7.2 4.2-11.1 4.5-9.7.8-13.5-4-14.6-16.8h-11.4c.4 5.2 0 10.6-5 13.3-3.5 1.9-7.9 3.2-11.7 3-9.3-.6-12.7-6.6-11.2-17.1-4.8-.2-9.7-.5-14.5-.7.8 7.9-2.1 14.6-8 17.1-4.6 2-10.9.6-14-3-3.5-4.1-3.7-11.2-.5-16.4 3.2-5.3 7.4-6.4 16-4.2-.8-3.5-1.6-7-2.5-11h-8.5c-1.1 11.1-6.5 16.5-16.3 16-9.6-.5-13.6-5.6-13.4-17.2-4.9-.9-9.7-1.7-14.4-2.5 1.5 8-.7 13.8-6.9 17-4.5 2.3-10.4 1.4-13.7-2-3.5-3.6-3.7-10.5-.4-15.8 3.4-5.6 7.5-6.8 15.3-4.6-.6-3.7-1.2-7.4-1.9-11.6-2.9-.2-6.3-.4-10-.6.6 7.9-2.3 13.7-10.1 15.8-5.6 1.5-11.2.9-15.1-4.1-4.3-5.6-3.2-11.4.5-17.1-16.5 5.8-28.1-3.7-22.5-17.8-6.1 1.3-12 1.7-17-2.5-5.1-4.3-5.6-9.9-4.5-16.4-6.1.8-11.8 0-16.4-4.2-4.9-4.4-5.6-9.8-3.9-15.9-16.2.2-22.7-6.9-19.6-21.7-6.3 1.8-12.2 1.5-16.8-3.4-4.7-4.9-5.2-10.7-2.7-17-11.4 2.8-18.2-1.5-20.1-12.2-1.6-9.3 3.1-13.8 16.2-15.3-.4-3.1-.7-6.3-1.1-9.5-3.2-.4-6.4-.8-10.4-1.4 2.1 5.6 1.3 10.8-3.2 14.6-1.9 1.6-4.7 2.9-7.1 3-7 .5-14.2-6.7-14.5-13.7-.4-7.4 5-11.1 17.6-11.9-.3-2-.6-4-.7-6.1-.1-1.9 0-3.8 0-6.2-6.1.7-11.8-.5-15.7-5.8-3.9-5.2-4.2-10.9-1.2-17.5-6.7 2.8-12.6 2.9-16.8-3.2-3.6-5.3-4.4-11.1-1.3-16.9 3.1-5.8 8.6-6.1 14.9-5.1-.4-3.9-.7-7.5-1.1-11.5-5.8.1-11.4-1.5-14.7-7.4-3.2-5.6-3.1-11.3-.2-17.8-8.1 2.9-14.9 2.4-19.6-4.9-2.6-4.1-2-9.4 1.2-13.4 4-5.1 8.7-6.2 15.9-4.2v-16.9c-5.6 1.9-11.5 2.6-15.2-3.8-3.2-5.5-3.6-11.4 0-16.9 3.8-5.7 9.4-4.8 14.9-3.1v-15.5c-3-.2-6.5.4-9.2-.8-2.7-1.2-5.2-3.9-6.8-6.6-2.9-5.2-1.8-11.9 1.8-15.4 3.9-3.8 9.6-4.1 16.8-.5-2.4-6.1-3.5-12-.6-17.8 3.1-6.3 8.7-7.7 15.5-7 .2-3.8.5-7.4.7-11.5-5.3.4-11 .5-13.9-4.6-1.9-3.4-3-7.9-2.7-11.8.7-9.1 7.4-12.9 17.7-11.2.4-5 .8-10.1 1.2-14.8-2.7-.2-6.7.3-9.6-1.1-3.1-1.5-5.9-4.6-7.5-7.7-2.4-4.5-.3-10.5 3.5-13.2 4.2-3 10.9-2.4 15.9 1.3 4.9 3.7 5.8 7.7 3.1 14.8 3.4-.4 6.9-.7 10.3-1.4.8-.2 1.7-1.9 1.9-2.9.3-2.6.1-5.3.1-8.4-7 .5-13.6-.4-16-8.1-1.9-6.1.2-11.5 4.7-15.9 4.5-4.5 9.7-4.4 15.7-1.3-2.6-6.5-2.8-12.4 1.3-17.8 4.2-5.4 9.7-6.4 15-5.1 1.5-5.5 2.1-11.4 4.8-16.1 3.1-5.4 9.5-5.4 15.2-5.3.7-4.6 1.5-9.1 2.2-13.7-6.3 1.4-13 2.2-16.7-5.2-2.4-4.7-.6-11.3 3.6-15.1 3.6-3.3 8.9-4.2 12.4-2.1 5.8 3.4 8.1 9.7 6.1 17.6 2.2-.7 4.2-1.6 6.3-2 2-.4 4.1-.3 6.3-.4.5-3.8 1-7.9 1.6-11.9-12.1.2-18.2-4.3-17.8-13.2.4-6.9 6.5-11.6 14.2-10.8 8.7 1 11.6 6.2 9.8 17.3 4-.7 8.1-1.4 12.2-2.2.6-3.7 1.3-7.7 2-11.7-8.2.8-14.4-1.8-17-7.2-1.9-4.1-.7-10.2 2.6-13.2 3.9-3.5 11.1-4.2 15.9-1.3 6.3 3.7 5.8 9.4 4 16 2.6-.7 4.6-1.5 6.7-1.9 2.2-.3 4.4-.3 6.9-.4.2-5.6.4-11.3 5.1-15.5 4.5-4.1 10-4.1 16-3.1-.8-6.6.4-12.4 5.5-16.7 5.1-4.3 10.8-4.3 17.4-1.7-2-5.1-3.7-10.2.3-14.1 2.8-2.7 6.7-5.2 10.5-5.9 10-1.9 14.9 3.4 15.6 16 3-.3 6-.5 9.3-.8.8-3.5 1.7-7 2.4-9.7-4.4-1.1-8.8-1.6-12.6-3.4-2.2-1.1-3.9-4.1-4.9-6.6-1.9-4.8-.1-10.3 3.5-13 4.3-3.2 11.3-2.9 16.3.8 4.7 3.4 5.6 7.4 3.1 15.3 2.6-.6 4.9-1.3 7.3-1.6 2.4-.3 4.9-.1 7.4-.1-1.1-10.4 3.9-16.9 13.9-17.7 9.6-.8 14.1 4 15 16.2 3.2-.1 6.3-.3 8.7-.4 2-4.5 3.7-8.5 5.5-12.5.7-.8 1.5-1.5 2.2-2.3 5.5-3.5 11.3-4 18-1.2-2.3-6.6-2.8-12.6 3.5-16.6 5.3-3.3 11.1-3.6 16.5-.4 6 3.5 5.5 9.2 4.5 14.8h14c-.5-4.6-1.4-10.1 3.4-13.1 3.5-2.1 8-3.7 12-3.7 9.4.1 12.6 5.5 11.1 17.1h15.4c-1.4-6-2.1-12.4 5.1-16.2 4.8-2.6 11.6-1.4 16.3 2.5 5.1 4.4 5 9.7 2.3 15.9 7.5-3.2 14-2.9 19.8 2.1zm-423 388v13.5c3.6-.7 7.2-1.3 10.8-2v-9.3c-4-.8-7.7-1.6-10.8-2.2zm10.4-77.6c-3.8-1-7.2-2-10.3-2.8v12.4c3.2-.6 6.5-1.3 10.3-2.1v-7.5zm-.3 48.1v-8.8c-3.4-.5-6.5-1-9.2-1.5-.2 4.2-.4 8.3-.6 12.1 3.1-.6 6.3-1.2 9.8-1.8zm662.5-101.7c3.4.4 6.4.7 9 .9.5-4.2.9-8.1 1.4-11.6-3.5.6-6.9 1.3-10.4 1.9v8.8zM594.5 143c.7 2.8 1.4 5.9 2.2 9.1h7.6c1-3.6 1.9-6.9 2.7-9.9-4.1.3-8.1.5-12.5.8zm122.6 40.9c.5 3 1.1 6 1.6 9.1h7.5c.6-3.5 1.2-6.8 1.7-9.9-3.5.2-7 .5-10.8.8zm-344 589.8c-.8 3.7-1.6 7.3-2.3 10.7 3.3-.6 7.1-1.2 10.9-1.9-1-8.6-1-8.6-8.6-8.8zm151.6-630.6c-4.2-.2-7.9-.5-11.5-.7.6 3.3 1.2 6.4 1.8 9.5h8c.6-3.1 1.1-6 1.7-8.8zM828 691.9c-3 .6-5.4 1.1-8 1.5-.2 2.7-.3 5.2-.5 7.1 3.8.9 7.1 1.7 10.6 2.6-.7-3.6-1.4-7.3-2.1-11.2zM768.5 763c-.2-1.4-.6-2.9-.7-4.4-.1-1.7 0-3.4 0-5.1-8.8.3-8.4-1.8-9.4 8.6 3.3.3 6.5.6 10.1.9zm-489.8-89.9c-2.8-.4-5.4-.7-7.8-1.1-.4 4-.8 7.3-1.2 10.5 3.2-.7 6.4-1.4 9.7-2.2-.2-2.3-.4-4.6-.7-7.2zm277.5-521.5h7c.7-3.1 1.4-5.9 2-8.5h-10.9c.6 2.9 1.3 5.6 1.9 8.5zM259.1 327.1c-3.6-.8-6.9-1.5-9.8-2.1.4 3.6.9 7 1.3 10.7 2.4-.2 5-.5 7.8-.8.3-2.7.5-5.1.7-7.8zm-21.2 264.7c-2.6-.6-5.1-1.1-7.4-1.6-.6 3.9-1.2 7.6-1.7 11 3.4-.8 6.6-1.5 9.9-2.3-.3-2.4-.5-4.7-.8-7.1zM400.5 192c.5-2.7.9-5 1.3-7.2-3.6-.7-7.1-1.3-10.3-1.9.6 3.2 1.1 6.4 1.7 9.7 2.3-.1 4.6-.4 7.3-.6zm225.3 631.7c-.4-2.9-.7-5.7-1-8.5h-7.4c-.5 2.7-1.1 5.2-1.6 7.7 3.5.3 6.6.5 10 .8zm224.1-518.6c-3.6.5-6.6 1-9.7 1.5.4 2.5.7 4.8 1.1 7.2 2.4.4 4.6.8 7 1.2.5-3.4 1-6.5 1.6-9.9zm-50.4 415.6c3.9.9 6.9 1.5 9.9 2.2-.7-3.4-1.3-6.5-2-9.8-1.9.1-4.1.2-6.5.3-.5 2.4-1 4.8-1.4 7.3zm-10.3 22.7c-.7-3.4-1.4-6.5-2.2-10.1-2.4.4-4.8.8-7.4 1.2v6.6c3.3.9 6.5 1.6 9.6 2.3zm-428.5 18.2c-.3-2.1-.6-4.4-.9-6.9-2.4-.2-4.7-.5-7-.7-.6 3.3-1.2 6.2-1.8 9.2 3.5-.6 6.4-1.1 9.7-1.6zM230.3 387.3v9c2.7-.4 5.2-.7 7.6-1v-7.4c-2.7-.2-5-.4-7.6-.6zm273.3 435.9c-.7-2.9-1.3-5.4-1.8-7.9h-6.4c-.5 2.7-.9 5.2-1.4 7.9h9.6zm173.8-20.7c3 .2 5.9.5 9.1.7-.4-3.1-.7-5.7-1-8.2h-6.6c-.6 2.4-1 4.6-1.5 7.5zm-10.8-638.8c-3.5.2-6.4.3-9.6.4.6 2.9 1.1 5.2 1.6 7.6h6.3c.5-2.6 1-5 1.7-8zm222.6 395.5v-9.1c-2.8.4-5.2.8-7.6 1.1v6.4c2.7.6 5.1 1.1 7.6 1.6zM298.5 694.1c-2.2-.5-4.1-.9-6.3-1.3-.6 3.2-1.2 6-1.7 8.9 3.2-.3 6-.6 9-.9-.4-2.4-.6-4.3-1-6.7zm562.7-81.5v6.5c2.8.4 5.4.7 7.9 1.1-.4-3.1-.7-5.8-1-8.6-2.2.3-4.3.6-6.9 1zM746 212.5c.5-2.7 1-5.4 1.5-8.2-3.1.4-5.7.7-8.1 1v6.8c2.3.2 4.4.3 6.6.4zM433.3 802.7c3-.3 5.6-.5 8.5-.7-.4-2.5-.8-4.7-1.2-7H435c-.6 2.5-1.1 4.9-1.7 7.7zm448.3-373.9v6.9c2.4.3 4.5.6 6.9.8.2-2.9.4-5.3.5-7.7h-7.4zM319 714.3c-2.4-.3-4.7-.5-7.3-.8v8.3c2.7-.6 5.1-1.1 7.3-1.6v-5.9zm134.6-550.4c.6 2.9 1.1 5.3 1.6 7.8h5.6c.5-2.5 1-4.8 1.4-7-2.8-.3-5.5-.5-8.6-.8zM331.3 742c3-.2 5.7-.4 8.7-.7-.5-2.6-.9-4.8-1.2-6.9-2-.1-3.7-.2-5.6-.4-.6 2.6-1.2 5.1-1.9 8zm489.5-455v5.9c2.3.3 4.4.6 6.8 1 .2-2.7.4-5.1.6-7.7-2.7.3-4.9.5-7.4.8zm-549.2 27.4c2.6-.5 4.8-1 6.7-1.4v-6h-7.2c.1 2.4.3 4.6.5 7.4zm488.3-88c.1 2.3.2 4.2.3 5.9h6.1c.1-2.3.2-4.4.3-6.9-2.2.4-4.2.6-6.7 1zm-380.7-14.2c.4-2.5.7-4.5 1.1-6.9h-7.4c.2 2.4.4 4.6.6 6.9h5.7zm205.2 610.6c-.6-2.7-1-4.7-1.5-6.6H577c-.3 2.1-.6 4-.9 6.1 2.9.2 5.3.3 8.3.5zm-49-.2c2.8-.2 5.3-.3 8.1-.4-.4-2.3-.8-4.1-1.1-6h-5.7c-.5 2.3-.9 4.2-1.3 6.4zm251.4-576.1h-6.3v6h5.9c.2-2.1.3-3.9.4-6zm19.8 26.2c.2-2.2.4-4.3.6-6.3-2.5.1-4.4.2-6.8.4.2 2.2.4 4.1.6 6.2h3.6c.6-.1 1.2-.2 2-.3zm76 197.4c-.8 5.7.4 6.8 5.8 5.7v-5.7h-5.8zm5.8 40.1c-2.4.6-4.2 1-5.9 1.4v5.2c2.1.2 3.9.3 5.9.5v-7.1zM231.3 551v7.2c2.2-.5 4-.9 5.9-1.3v-4.7c-1.8-.4-3.5-.8-5.9-1.2zM862 368.5v5.2c2 .4 3.8.8 6 1.3v-6.9c-2 .2-3.8.3-6 .4zM359.3 226.4h-5.4v5.5c1.9-.1 3.6-.3 5.4-.4v-5.1zm-66.5 60.8v5.8h5v-5.3c-1.7-.2-3.3-.4-5-.5zm-55.7 148v-5.4h-5.3c.1 1.9.2 3.6.3 5.4h5zm14.1 183.7c2.5-.2 4.3-.3 6.3-.5v-5.2c-1.7-.2-3.3-.4-4.9-.6-.5 2.2-.9 4-1.4 6.3zm448 162.3c2.3-.2 4.1-.3 6.2-.5-.9-3.5-1.2-6.7-5.5-4.6-.3 1.6-.5 3-.7 5.1zm-74.9-614.1c-.3-.5-.7-.9-1-1.4h-6.4c1.5 2 2.5 3.4 3.4 4.7 1.3-1 2.6-2.2 4-3.3zm222.8 466.6h-5.5c.1 1.6.2 2.8.3 4.1 1.9.3 3.4.6 5.2.9v-5zM338.6 247c-1.9.1-3.2.2-5 .3.1 1.7.2 3.1.3 4.7 1.7-.1 2.9-.2 4.2-.3.2-1.5.3-2.8.5-4.7zM318 267.7h-4.6v4.7c1.6-.2 3-.3 4.6-.5v-4.2zm-85.9 203.1v4.8c.4.3.8.5 1.1.8 1.3-1.4 2.7-2.8 4-4.2l-.9-1.2c-1.3 0-2.6-.1-4.2-.2zm-.4 45.4c1.7-.1 3.2-.1 4.7-.2l.9-1.5c-1.4-1.3-2.7-2.6-5-4.8-.3 
                                    3.2-.5 4.6-.6 6.5zm452.7-330h-4.9v4.1h4.4c.1-1.4.3-2.6.5-4.1zM415.5 776.5v3.9c1.6-.1 2.8-.2 4.1-.4 1-3.6-.7-4.2-4.1-3.5zm79.2-610.7c1.7 2 2.8 3.3 3.9 4.5 1-1.3 2.1-2.5 3.7-4.5h-7.6zM252.4 369.4c-1.1 4.5.7 5.2 4.2 4.1v-4.1h-4.2zm183.5-182.6c-.3.5-.7 1-1 1.6 1.5.9 3 1.8 4.9 2.9 1.1-5.4-1.4-5-3.9-4.5z"/>
                                <path class="st1" d="M489.5 138c-.7.8-1.5 1.5-2.2 2.3-1.4.5-2.8 1-4.1 1.5-5.2 1.7-11.4-.9-14.5-6-3-4.9-2.3-11.7 1.5-15.2 3.9-3.7 11.5-3.4 16.9.6 5.2 3.9 6.4 8.8 3.5 14.4-.6.8-.8 1.6-1.1 2.4zm141.7 1.4c-.6-1.4-1.2-2.7-1.8-4.1-3.2-7.7.3-14.6 8.3-16.4 6.1-1.4 10.5 0 13 4.1 2.8 4.5 2.4 10.8-.8 14.6-3.4 4-9.5 5.4-14.7 3.4-1.3-.5-2.6-1.1-4-1.6zm304.1 353.9c0 6.9-5 12-12.1 12.1-7 .1-12.1-5-12.1-12 0-7.2 5.1-11.7 13.4-11.6 6.6.1 10.7 4.5 10.8 11.5zM720.6 827.7c-6.9 0-11.4-4.3-11.4-10.9 0-7 4.8-11.5 12.4-11.5 7 0 12.4 5.3 12.3 12-.1 5.8-5.9 10.3-13.3 10.4zm214.7-374.5c0 6.7-5 11.4-12.2 11.4-7.1 0-12.1-4.7-12-11.5 0-7 4.9-11.2 12.7-11.2 7 0 11.5 4.4 11.5 11.3zm-41.2 201.2c.1 7.2-4.6 12.7-10.8 12.8-6.6.1-11.9-5.3-11.9-12.3-.1-6.8 5.1-11.5 12.5-11.5 6.1.1 10.1 4.3 10.2 11zM207.8 412.2c.1 7.1-4.7 12.6-11 12.7-6.3.1-11.8-5.7-11.9-12.6-.1-6.4 4.8-10.9 12-11 6.4-.2 10.8 4.2 10.9 10.9zM325.7 191c.1-7.3 5-11.7 12.8-11.7 6.7 0 10.9 4.3 10.7 11-.2 6.6-6 11.7-13.3 11.6-6.4 0-10.3-4.2-10.2-10.9zm-67.9 69.2c6.6 0 10.8 4 10.8 10.4 0 6.8-5.9 12.1-13.4 12.1-6.3 0-10.2-4-10.2-10.4-.1-7.7 4.6-12.1 12.8-12.1zM570.7 856c-.4 7.6-5.9 13.8-11.7 13.4-6.1-.5-11.6-6.6-11.1-12.5.5-6.7 6.5-11.4 13.9-11 5.6.2 9.2 4.3 8.9 10.1zm353.9-333.3c5.8-.1 9.5 3.6 9.6 9.4.1 7.3-5.2 14-11 14.1-6 .1-11.8-5.8-11.8-11.8 0-6.7 5.6-11.6 13.2-11.7zM794.3 220.9l-1.3-1.3c-.6-1.6-1.4-3.3-1.9-5-1.5-5.6.6-11.1 5.1-13.5 4.7-2.6 10.4-2 13.7 1.2 3.6 3.6 4.1 10.7 1.1 15.4-2.8 4.4-7.7 5.9-13.3 4.2-1.1-.3-2.2-.6-3.4-1zm39.1 39.2s0 .1 0 0c-.7-2.4-1.8-4.7-2-7.2-.7-6.2 1.7-10.1 6.9-12 5.7-2 10.7-1 13.4 2.7 3 4.1 2.9 10.3-.2 14.2-3.4 4.3-9.4 5.9-14.4 3.9-1.3-.5-2.5-1-3.7-1.6zM185 574.5c0-7 4.8-11.4 12.5-11.4 6 0 10.2 4.6 10.1 11.1-.1 6.3-5.6 11.6-12.3 11.6-6.2.1-10.3-4.4-10.3-11.3zm30.6 71.8c-6.4 0-10.5-4.3-10.5-11.2 0-6.9 4.9-11.4 12.6-11.4 6.1 0 10.2 4.4 10.1 11-.1 6.5-5.4 11.5-12.2 11.6zm687-283c-6.6 0-10.9-4.6-10.8-11.5.1-6.8 4.8-10.7 12.7-10.6 6 .1 10 4.4 10 10.8-.1 6.5-5.2 11.3-11.9 11.3zM518.7 868.1c-6.6-.1-10.7-4.6-10.5-11.7.1-6.8 4.8-10.5 12.8-10.3 6 .1 9.8 4.4 9.7 10.9-.2 6.6-5.2 11.3-12 11.1zm82.4-21.7c6.4 0 10.4 4.2 10.3 10.8-.1 6.3-5 10.9-11.7 10.8-6.4-.1-10.9-4.7-10.8-11.1 0-6.7 4.5-10.5 12.2-10.5zm180.6-644.9c-6.5 0-11.1-4.4-11.1-10.7-.1-6.6 4.5-10.8 12-10.9 6.4-.1 10.5 4.1 10.6 10.6-.1 6.5-4.8 11-11.5 11zm-434.8-31.2c.3-6.6 5.4-10.6 13-10.2 5.4.3 9 4.5 8.7 10.3-.3 6.2-5.9 10.7-12.7 10.4-5.8-.3-9.2-4.2-9-10.5zm565.8 242.8c0-6.8 4.5-10.7 12-10.7 5.6 0 9.4 4.2 9.3 10.2-.1 6.1-5.3 10.9-11.8 10.9-6.1 0-9.6-3.9-9.5-10.4zm-39.4-142.2c.1 6.2-5.1 11.2-11.5 11.2-5.9 0-9.7-4-9.8-10.4-.1-6.6 4.2-10.5 11.6-10.7 5.9-.1 9.7 3.8 9.7 9.9zM247.2 291c.1 6.3-4.9 11.3-11.3 11.4-5.9.1-9.6-3.9-9.7-10.4-.1-6.9 4.3-11 11.8-10.9 5.4 0 9.1 4 9.2 9.9zm49.4 476c-5.9-.1-10.3-5.3-10.1-11.8.2-5.7 5.2-9.9 11.7-9.7 5.5.1 9.2 4.4 9.1 10.5 0 6.7-4.4 11.1-10.7 11zm-30-31.1c0-6.6 4.3-10.4 11.7-10.4 5.8 0 9.4 4 9.3 10.1-.1 6.3-5.2 11-11.7 10.9-5.9 0-9.3-4-9.3-10.6zM307 776c0-6.2 4-9.8 11.2-9.8 6-.1 10.4 4.3 10.5 10.4.1 5.5-5 9.9-11.5 9.9-6.3 0-10.2-4.1-10.2-10.5zm133-656.1c5.5.1 9.1 3.9 9.1 9.9 0 6.1-4.9 10.8-11.2 10.7-6-.1-10-4.5-9.9-10.8.2-6.1 4.8-9.9 12-9.8zm463.1 525.2c-5.9.1-10.2-4-10.5-9.8-.2-6 4.1-10 11-10.2 5.8-.2 9.9 3.8 10 9.6 0 5.8-4.5 10.3-10.5 10.4zm-645.4 60.8c6.2 0 9.7 3.5 9.7 9.7 0 5.7-4.5 9.9-10.5 9.9-5.9 0-10.5-4-10.7-9.3-.1-6.2 4.3-10.2 11.5-10.3zm171.1 130.6c.1 6-4.1 10.3-10.3 10.5-6.2.2-10.5-4-10.5-10.2 0-6 4.5-9.9 11.3-9.9 5.6 0 9.4 3.9 9.5 9.6zm495.3-271.9c6.3 0 9.6 3.3 9.6 9.7 0 5.8-4.3 9.9-10.4 9.9-6 0-10.5-4-10.5-9.3-.2-6.4 4.1-10.3 11.3-10.3zM540.5 100.1c5.8.1 9.2 3.5 9.2 9.1 0 5.9-5.2 10.3-11.7 10.1-5.5-.1-8.9-3.6-8.9-9 0-6.3 4.4-10.2 11.4-10.2zm220 79.9c-5.6 0-9.1-3.2-9.2-8.6-.2-6.5 4.4-10.7 11.4-10.7 5.7.1 9.3 3.6 9.2 9.2-.1 5.6-5.1 10-11.4 10.1zm52 576c.1-6.1 4.2-9.7 10.8-9.5 5.2.2 9.8 4.7 9.8 9.7 0 5-5.8 9.6-12.1 9.5-5.4-.1-8.6-3.6-8.5-9.7zM186.4 372.4c.1-6.1 4.1-9.7 10.8-9.6 5.3.1 9.8 4.4 9.9 9.5.1 5.1-5.6 9.6-11.9 9.6-5.5.1-8.9-3.7-8.8-9.5zm515.3 455c5.5-.1 10.3 4.4 10.3 9.5 0 4.9-5.9 9.6-12.1 9.5-5.3-.1-8.6-3.5-8.7-9.2 0-6.3 3.7-9.7 10.5-9.8zm-30.6-697.2c0-6.4 3.7-9.6 10.7-9.6 5.3 0 9.9 4.3 10 9.3.1 5.1-5.4 9.6-11.9 9.6-5.6.1-8.8-3.3-8.8-9.3zm-101-20.4c.1-6.1 4.2-9.7 10.9-9.5 5.3.1 9.7 4.6 9.8 9.6 0 5.1-5.5 9.5-12 9.4-5.6 0-8.8-3.5-8.7-9.5zM478 866.5c-5.6 0-8.9-3.5-8.9-9.4.1-6.1 4.1-9.7 10.8-9.7 5.3.1 9.8 4.4 9.9 9.5.1 5.2-5.3 9.6-11.8 9.6zm-130.6-70.1c0 5.7-4.1 9.7-9.9 9.8-5.9 0-9.9-4.1-9.9-10.3 0-5.5 4.8-9.3 11.5-9.2 5 .2 8.3 4 8.3 9.7zm504.9-60.5c0 5.7-4.1 9.6-10 9.6-6 0-9.9-4-9.9-10.2 0-5.4 4.3-8.9 11.1-9 5.4-.1 8.8 3.7 8.8 9.6zM884 282.6c5.4.1 8.6 3.5 8.4 9.2-.1 5.5-4 9.2-9.8 9.2-5.9 0-9.5-3.9-9.4-9.9.2-5.6 4-8.6 10.8-8.5zM175.8 482.7c-5.9-.1-9.5-4-9.4-10 .1-5.5 4.1-8.5 10.8-8.4 5.4.1 8.6 3.6 8.4 9.3-.1 5.4-4.2 9.2-9.8 9.1zm464.8 384c-5.2-.1-9.7-5-9.5-10.4.2-5.1 4.8-8.8 10.5-8.6 4.8.2 8 3.8 8 8.9 0 5.7-4 10.2-9 10.1zm170.5-90.9c0 5.9-3.7 10.1-8.9 10-5.1-.1-9.3-4.4-9.4-9.8-.1-5.3 4-9 9.9-9 5-.1 8.3 3.4 8.4 8.8zM185.4 514.2c0 5.2-3 8.9-7.3 9-5.7.1-12.1-5.6-11.9-10.6.1-4 4.9-7.7 10-7.7 5.2-.1 9.2 3.9 9.2 9.3zm201.2-364.8c0 5.9-4.3 10.9-9.1 10.7-4.9-.1-9-4.3-8.9-9.3 0-5.6 4.2-9.5 10.1-9.5 5.1 0 8 3 7.9 8.1zM499.2 101c5.4 0 9.3 3.8 9.3 9.2 0 5.3-2.9 8.8-7.3 8.9-5.8.1-12-5.4-11.9-10.5.1-4 4.7-7.6 9.9-7.6zM236.3 704.4c-5.5 0-8.9-3.6-8.9-9.4-.1-5 4.1-8.4 10.4-8.5 4.7 0 7.9 3.5 7.9 8.8 0 5.4-3.8 9.1-9.4 9.1zm627.5 2.4c4.9 0 7.9 3.2 7.9 8.7 0 5.4-3.8 9.2-9.3 9.2-5.4 0-8.8-3.6-8.9-9.5 0-5.1 3.9-8.3 10.3-8.4zm-82 98.6c-5.6.1-9.2-3.6-9.2-9.6 0-4.8 4-8.1 10.2-8.3 4.7-.1 8 3.3 8.2 8.6.1 5.3-3.7 9.2-9.2 9.3zM205.2 614.6c0 5.4-3.8 9.1-9.3 9.1-5.4 0-8.8-3.7-8.9-9.5 0-5.1 4-8.4 10.4-8.4 4.9 0 7.8 3.3 7.8 8.8zm406-505.4c0-5.1 4.2-8.3 10.5-8.2 4.9.1 7.7 3.4 7.6 8.9-.1 5.3-4.1 9.1-9.5 9-5.3-.1-8.6-3.8-8.6-9.7zm-403.9 202c0-5 4.2-8.3 10.5-8.3 4.7 0 7.8 3.6 7.8 8.9-.1 5.3-4.1 9.1-9.5 9-5.5-.1-8.8-3.8-8.8-9.6zm717.1 52.9c4.5.1 7.1 2.8 6.9 7.4-.2 5.5-4.3 10.5-8.5 10.4-4.3-.1-8.6-4.9-8.5-9.3.2-5 4.4-8.6 10.1-8.5zm-748.8 78.4c-4.4-.1-8.6-4.8-8.5-9.3.2-4.9 4.5-8.7 10.1-8.6 4.4.1 7.1 3 6.9 7.5-.1 5.5-4.2 10.5-8.5 10.4zm566.9-300.6c4.5 0 7.1 2.7 7.1 7.3-.1 5.5-4 10.5-8.3 10.6-4.3 0-8.8-4.6-8.7-9.1 0-5 4.3-8.8 9.9-8.8zM366.1 817.6c-.1 4.7-3.3 7.9-7.9 7.8-4.6-.1-9-4.6-8.9-9.4 0-4.3 3.9-7.5 9-7.4 4.5.1 7.9 3.9 7.8 9zM175.4 562.1c-4.7-.1-7.6-3.1-7.5-8 .1-5 3.8-8.3 9.2-8.1 4.5.1 7.4 3.2 7.3 7.8.1 4.8-3.8 8.4-9 8.3zm715.8 134.1c.1 4.5-1.9 7-5.6 7.1-5 .2-11.3-4.8-11.4-8.9-.1-3.6 4.8-7 10-6.9 4.3.1 6.9 3.3 7 8.7zm60.5-221.7c-.1 4.5-2.2 6.9-5.9 6.8-5.1-.1-11.2-5.3-11.1-9.4.1-3.4 5-6.6 10-6.5 4.5 0 7.1 3.4 7 9.1zm-.3 38.9c.1 4.9-3.4 8.4-8.3 8.4-4.6 0-7.6-3.1-7.8-7.9-.1-4.7 3.6-8 9.2-8.1 4.2 0 6.8 2.9 6.9 7.6zM446.6 857c0 4.7-3.1 7.8-7.8 7.8-4.8 0-8.3-3.4-8.3-8 0-4.4 3.5-7.3 8.8-7.5 4.5 0 7.3 3 7.3 7.7zm323.1-40.2c0 4.8-3.1 7.7-8 7.6-4.7-.1-8.1-3.4-8.1-7.8s3.6-7.5 8.8-7.5c4.6-.1 7.3 2.8 7.3 7.7zm145.6-202.4c.1-4.5 3.6-7.3 9-7.2 4.5.1 7.3 3.2 7.1 7.9-.2 4.4-3.5 7.5-7.9 7.5-4.8-.1-8.3-3.6-8.2-8.2zm-4.2-302.6c0 4.8-3 7.8-7.7 7.8-4.8 0-8.4-3.4-8.4-7.9 0-4.4 3.5-7.3 8.8-7.4 4.5-.1 7.3 2.7 7.3 7.5zM208.4 675.7c0-4.5 3.5-7.7 8.5-7.8 4.1-.1 7.5 2.9 7.5 6.7.1 4.1-4.6 8.2-9.5 8.3-4.2 0-6.5-2.5-6.5-7.2zm257.7-565.8c-.1 5-2.5 7.4-7.5 7.3-4.8-.1-7.5-2.6-7.5-6.9 0-4.3 3.6-7.7 8.1-7.7 4.5-.2 7 2.5 6.9 7.3zm216 753.6c-5-.1-9.2-3.1-9.2-6.6.1-3.6 4.6-7.2 8.9-7.1 4.4.1 7.3 3.3 7.2 7.9-.1 3.8-2.6 5.9-6.9 5.8zm-94.9 14c0 4.6-1.6 6.8-5.2 6.8-4.5.1-9.9-4.4-9.8-8.2.1-3.1 4.3-6.1 8.7-6.2 4-.1 6.2 2.7 6.3 7.6zm-181.8-747c0 4.5-1.8 6.6-5.4 6.6-4.3 0-9.5-4.3-9.6-7.9-.1-3.2 4.4-6.4 9-6.5 3.8.1 6.1 2.9 6 7.8zm141.4 747.3c0 4.4-1.8 6.6-5.5 6.6-4.3-.1-9.5-4.4-9.6-7.9-.1-3.2 4.5-6.4 9-6.4 3.9-.1 6.2 2.8 6.1 7.7zM668 110.2c0 4.4-1.8 6.9-5.2 6.9-4.4.1-9.8-4.5-9.7-8.3.1-3.2 4.1-6 8.6-6.1 4.1 0 6.2 2.5 6.3 7.5zm282.7 323.1c0 4.4-1.8 6.8-5.2 6.8-4.5 0-9.8-4.5-9.6-8.3.1-3.2 4.2-6 8.7-6 4 0 6 2.5 6.1 7.5zm-774.6-33.9c-4.5-.1-7.3-2.8-7.3-7.2 0-3.8 3.3-6.5 8-6.5 4.1 0 7.1 3.1 7 7.5-.2 3.8-3.3 6.3-7.7 6.2zm27.4-66.7c-.1 2.9-.5 6.1-4.8 6.4-4.2.3-9.8-4.4-9.8-8.2 0-3 3.5-5.6 7.9-5.7 4.2 0 6.6 2.5 6.7 7.5zM950.7 555c-.2 2.9-.5 6-4.9 6.2-4.4.1-9.8-4.5-9.7-8.2.1-3 3.7-5.5 8-5.5 4.2-.1 6.6 2.4 6.6 7.5zM385.3 837.7c-.3 2.9-.6 6.1-5 6.2-4.4.1-9.8-4.6-9.7-8.3.1-3 3.8-5.5 8.1-5.5 4.2 0 6.5 2.6 6.6 7.6zM277.2 204.2c3.7 0 6.8 3.4 6.7 7.5-.1 3.5-2.4 5.9-5.9 6-4.1.1-8.5-4-8.3-7.8.1-2.9 3.8-5.7 7.5-5.7zm-13.5 26.1c.1 3.5-3.8 7.3-7.7 7.3-3.3.1-5.9-2.8-6-6.5-.1-3.9 2.9-6.7 7.2-6.8 3.5 0 6.4 2.7 6.5 6zm234.6 653.6c-3.3 0-5.9-2.9-5.9-6.5 0-3.9 3-6.8 7.2-6.8 3.6 0 6.2 2.4 6.3 6 0 3.6-3.7 7.3-7.6 7.3zM179.1 588c.8 1.1 3 2.9 3.3 5 .6 3.9-4.4 8.7-8.1 8.5-2.9-.2-5.3-3.9-5.2-7.8.1-2.9 4.4-5.9 10-5.7zm730.3 84.6c0 4.9-4.1 9.6-7.7 9.8-3.1.1-5.9-3.6-5.8-7.7 0-3 4.3-6.1 8.3-5.9 3 .1 5.2 1.5 5.2 3.8zM613.2 876.7c-.1-3.1 3.8-6.1 8.1-6 3 0 5.2 1.3 5.4 4.7.2 4-4.1 8.9-7.9 8.8-2.9 0-5.5-3.4-5.6-7.5zm101.6-746.5c.1-4.5 2.5-6.8 6.9-6.7 4 .1 6.2 2.3 6 6-.2 3.6-3.8 7.1-7.3 7.2-3.4 0-5.7-2.6-5.6-6.5zM290.7 191c.1-4.6 2.2-6.7 6.9-6.7 3.7 0 5.4 2 5.4 5.5-.1 4-3.3 7.8-6.6 7.7-3.1-.1-5.7-3-5.7-6.5zm457.1 645.9c0 3.9-2.2 6.1-6.1 6.1-3.8 0-6.7-2.6-6.8-6.2 0-3.5 2.6-6 6.4-5.9 3.8.1 6.5 2.6 6.5 6zM323.9 171.3c-.1 2.5-.8 5.2-4.7 5.1-3.6-.1-8.3-3.7-8.5-6.7-.2-2.7 3.1-5 7.3-5 3.8-.1 5.9 2 5.9 6.6zM848 210.4c0 4-2.4 6.4-6 6.4-4 0-5-2.7-5.2-5.8-.2-3.7 2.3-6.1 6-6.2 4.1-.1 4.8 2.7 5.2 5.6zM565.7 89.5c0 3.6-1.6 5.6-5.3 5.5-3.7-.1-6.9-2.8-6.6-5.7.4-3.4 2.6-5.2 6-5.3 3.8-.1 5.9 1.9 5.9 5.5zM235.9 245.3c4-.1 6.5 2.1 6.7 5.4.1 3.6-1.4 5.7-5.1 5.9-3.4.2-7.1-2.8-6.9-5.6.3-3.4 2.7-5 5.3-5.7zm-39.4 404.1c3.8.1 5.9 2.1 5.8 5.7-.1 3.6-1.9 5.6-5.6 5.3-3.4-.3-6.1-1.7-6.5-5.5-.3-2.8 3.2-5.6 6.3-5.5zm725.8-311.8c-3.5-.3-5-2.3-4.9-5.6.1-3.4 3.2-5.9 6.8-5.6 3.5.3 5 2.2 4.9 5.6-.3 3.4-3.2 5.8-6.8 5.6zm20.1 60.6c-2.8-.2-4.8-1.8-4.8-5.3 0-3.4 2.9-6.3 6.3-6.2 3.3.2 5.3 1.9 5.4 5.3.1 3.4-2.9 6.3-6.9 6.2zM816.3 190.6c.4-3.6 3.5-5.9 7.1-5.6 3.5.4 4.8 2.5 4.6 5.8-.3 3.4-3.3 5.7-6.9 5.3-3.6-.3-4.8-2.6-4.8-5.5zm46.6 34.8c4 .2 5.3 2.5 5.4 5.9.1 2.9-.7 5-4.1 5.2-3.4.1-7.5-3-7.3-5.9.2-3.7 
                                    3.2-4.5 6-5.2zM525.3 91.7c-1.2.9-2.8 2.9-4.7 3.3-3.4.6-7.4-3-7-5.9.4-3.7 3.3-4.8 6.4-4.9 4-.2 4.7 2.8 5.3 7.5zm73.9-7.5c5 .3 6.5 2.3 6.6 5.6.1 2.8-.5 5.1-3.9 5.3-3.3.2-8.1-3.2-7.3-5.6.8-2.4 3.4-4.1 4.6-5.3zm201.7 81c5.5-.1 6.7 2.3 6.8 5.4.1 2.7-.7 5.1-3.9 5.3-3.2.2-8-3.3-7.2-5.7.8-2.3 3.4-4 4.3-5zM162.3 494.8c-1.6 1.4-3 3.7-4.9 4.1-3.1.8-7.4-3-7.2-5.7.2-3.9 3.4-4.5 6.3-4.8 3.8-.3 4.8 2.2 5.8 6.4zm256.3-380.3c-3.1.2-5.2-.7-5.2-4.1 0-3.3 2.4-5.7 5.6-5.6 3.3.1 4.2 2.2 4.2 5 0 3.3-1.3 5.2-4.6 4.7zM160.5 453.6c.4 3.3-1.7 4.4-4.8 4.3-2.9 0-4.9-1.1-4.9-4.4 0-3.3 2.4-5.5 5.7-5.4 3.6.1 4.1 2.4 4 5.5zm787.7 140.9c.2 3.5-1.6 4.9-4.8 4.8-2.8-.1-5-.8-4.9-4.3.1-3.4 2.2-5.5 5.6-5.5 3.6 0 4 2.4 4.1 5zM338 154.9c-3 .2-5.2-.4-5.3-3.9-.1-3.3 2.2-5.8 5.3-5.8 3.3 0 4.4 1.9 4.4 4.8 0 3.1-.8 5.4-4.4 4.9zM243.4 736c-2.7 2.2-4 4.1-5.8 4.6-2.5.6-6.6-3.1-5.6-5s3.4-3.8 5.4-4.1c1.5-.2 3.3 2.3 6 4.5zM878 253.4c-.3-5 1.6-6.8 5-6.3 1.7.2 4.2 1.2 4.7 2.5 1 2.2-3.9 6.7-6.7 6.2-1.4-.2-2.5-2-3-2.4zM667.4 877.3c-2.6 2.2-4 4.1-5.7 4.6-2.5.7-6.5-3-5.6-4.9 1-1.9 3.4-3.8 5.4-4.1 1.4-.2 3.2 2.3 5.9 4.4zm-267-24.4c.4.4 1.6 1.6 2.9 2.8-2.3 2-4.7 4-7 6-1-1.5-2.8-2.8-3-4.4-.3-3.5 2.2-4.7 7.1-4.4zM177.2 347.2l3.9 3.6c-2.3 2.1-4.5 4.1-6.8 6.2-1.1-1.4-2.9-2.7-3.1-4.3-.5-3.6 1.9-4.9 6-5.5zm74.7 410.9c-.1-5.3 2.2-6.7 5.4-6.2 1.7.3 3.1 1.8 4.7 2.8-2.3 2-4.5 4.3-7 5.9-.5.2-2.5-2.1-3.1-2.5zm666.4-100.9c-.2-5.2 2.1-6.7 5.3-6.3 1.7.2 3.2 1.7 4.7 2.7-2.2 2.1-4.4 4.3-6.9 6-.4.3-2.5-1.9-3.1-2.4zM707.9 110c-2.8 2.2-4.2 4-5.9 4.4-2.6.6-6.6-3-5.6-4.9 1-1.8 3.4-3.6 5.4-3.9 1.5-.2 3.3 2.2 6.1 4.4zM292.5 798.7c-.4-5 1.5-6.8 4.8-6.4 1.8.2 3.4 1.8 5 2.8-2.3 2-4.5 4.2-7 5.8-.4.3-2.3-1.8-2.8-2.2zm-14.4-27.4c1.3 1.2 2.7 2.3 4 3.5-2.2 2.1-4.4 4.2-6.7 6.3-1.1-1.4-2.9-2.7-3.1-4.2-.7-3.7 1.7-5 5.8-5.6zm-60.5-504.9c1.3 1.2 2.7 2.4 4 3.5-2.3 2.1-4.5 4.1-6.8 6.2-1.1-1.4-3-2.7-3.2-4.3-.5-3.4 2-4.7 6-5.4zM151 536c-.2-5 1.6-6.7 5.1-6.2 1.7.3 4.1 1.3 4.7 2.6.9 2.1-4.2 6.7-6.9 6.1-1.3-.3-2.4-2-2.9-2.5zM485.8 89.5c-2.9 2.3-4.9 4.9-5.9 4.6-2.1-.7-3.8-3-5.6-4.6 1.8-1.5 3.3-3.8 5.3-4.2 1.3-.2 3.2 2.1 6.2 4.2zM460 872.3c1.3 1.2 2.5 2.4 3.8 3.6-2.3 2.1-4.5 4.1-6.8 6.2-1.1-1.4-2.8-2.8-3.1-4.3-.5-3.8 2.1-4.9 6.1-5.5zm327.4-721.1c-1.6 1.2-3.6 3.8-4.7 3.4-2.2-.7-3.9-2.9-5.7-4.5 1.8-1.5 3.4-3.6 5.4-4.2 2.9-.8 4.1 1.5 5 5.3zM726.8 858c-1.6 1.2-3.6 3.8-4.6 3.5-2.1-.7-3.8-3-5.6-4.6 1.8-1.4 3.3-3.6 5.3-4.2 2.9-.8 4.1 1.5 4.9 5.3zM640.4 96c-2.1-3.1-4.3-4.9-4.2-6.6 0-1.4 2.7-3.7 4.3-3.8 1.5 0 4.5 2.5 4.4 3.5-.3 2.1-2.3 3.9-4.5 6.9zm221 664.8c-1-1.5-3.1-3.5-2.8-4.4.8-1.9 2.9-3.1 4.5-4.7 1.2 1.4 3.6 2.8 3.5 4-.2 1.8-2.1 3.4-3.3 5.1-.6.1-1.3.1-1.9 0zm-20.6 19.6c-.6-.9-2.6-2.8-2.2-3.7.7-1.8 2.6-3.8 4.4-4.4 2.3-.7 3.7 1.1 3.6 3.7-.1 2.9-1.6 4.3-5.8 4.4zM154.4 417.5c-.9-1.5-3-3.5-2.6-4.4.8-1.8 2.8-3.4 4.7-4.3.5-.2 3.5 2.5 3.3 3.4-.4 2-2.2 3.7-3.4 5.5-.6-.1-1.3-.1-2-.2zm167.1 397.6c-.1 4.3-1.6 5.6-4.5 5.7-2.6 0-4.3-1.5-3.6-3.8.6-1.8 2.7-3.6 4.6-4.3.9-.3 2.7 1.8 3.5 2.4zm646.9-320.9c-1.7 1.1-3.3 3-5 3.1-1.2.1-2.7-2.1-4-3.3 1.5-1.5 2.8-3.6 4.6-4.4.9-.4 2.9 1.6 4.3 2.5.1.8.1 1.4.1 2.1zM356.5 134.6c-.9-1.4-2.5-2.8-2.6-4.3-.1-2.7 1.8-4.6 4.6-4.1 1.2.2 3.2 2.4 3 3.2-.5 1.9-2.1 3.6-3.2 5.3-.6 0-1.2 0-1.8-.1zM177.2 630.3c.9 1.4 2.9 3 2.6 4-.5 1.8-2.2 3.5-3.9 4.4-.6.3-3.8-2.1-3.6-3 .3-1.9 1.9-3.6 3-5.5.6 0 1.2.1 1.9.1zm787.7-181.7c.9 1.4 2.7 3.1 2.4 4.1-.6 1.7-2.3 3.4-4 4.3-.6.3-3.6-2.3-3.5-3.2.3-1.9 2-3.6 3.1-5.3.7 0 1.3.1 2 .1zM826.9 797c-1.7 1.2-3.3 2.9-5.2 3.3-.9.2-3.6-2.8-3.3-3.3.8-1.7 2.4-3.5 4.1-4.2.9-.4 2.7 1.4 4.1 2.2.2.6.2 1.3.3 2zm80.9-525.3c-1.7 1.2-3.3 2.9-5.2 3.5-.8.2-3-1.8-3.3-3-.5-2.7 1.1-4.8 3.9-4.6 1.5.1 2.9 1.5 4.3 2.4.1.5.2 1.1.3 1.7zm35.4 86c-1.7-2.7-3.5-4.3-3.4-5.7.1-1.3 2.5-3.5 3.5-3.3 1.6.2 3.8 2.1 3.9 3.5.2 1.3-2 2.9-4 5.5zm24.9 177c-1.5 1-3.2 2.9-4.6 2.7-1.5-.2-2.6-2.4-3.9-3.7 1.3-1.2 2.6-3.2 3.9-3.3 1.5-.1 3 1.6 4.6 2.6v1.7zM200.9 292.2c-1.5 1-3.1 3-4.5 2.9-1.4-.1-2.7-2.2-4-3.5 1.2-1.2 2.3-3.3 3.6-3.4 1.5-.1 3.2 1.5 4.8 2.3 0 .5 0 1.1.1 1.7zm15.4 418c1.9 2.6 3.8 4.1 3.8 5.5 0 1.3-2.3 3.6-3.3 3.5-1.5-.2-3.8-1.9-4.1-3.3-.3-1.3 1.8-3 3.6-5.7zm-54.7-135.6c-2.8 1.6-4.5 3.4-5.9 3.2-1.4-.2-2.5-2.5-3.7-3.8 1.5-1.1 2.9-2.9 4.4-3 1.2-.2 2.7 1.7 5.2 3.6zm398.2 327.7c-1.8-2.1-3.8-3.5-3.8-4.7.1-1.3 2.3-3.6 3.4-3.5 1.5.2 3.5 1.9 4 3.4.3 1-1.9 2.7-3.6 4.8zm322.9-171.5c1.8 2.3 3.5 3.6 3.8 5.3.2.8-2.3 3.2-3.3 3-1.6-.3-3.7-1.8-4.1-3.2-.3-1 1.9-2.8 3.6-5.1zm-80.4 80.8c1.7 2.4 3.7 3.9 3.5 5.1-.2 1.3-2.5 3.2-3.8 3.2-1.3 0-3.4-2.1-3.5-3.4-.1-1.2 1.9-2.6 3.8-4.9zm-460.9 26.2c-1.3.8-2.7 2.1-4 2.1-1.1 0-2.2-1.6-3.3-2.5 1.3-1.4 2.4-3.1 4-3.9.5-.3 2.2 1.6 3.4 2.5 0 .6 0 1.2-.1 1.8zm424.1-706.6c-1.4.7-2.8 1.9-4.2 1.9-1.1 0-2.1-1.7-3.2-2.6 1.3-1.3 2.5-3 4.1-3.7.6-.3 2.2 1.7 3.3 2.7.1.5 0 1.1 0 1.7zM521.9 900.8c-1.8-.4-3.8-.5-5.4-1.4-.5-.3-.3-3.1.5-3.8.9-.9 3.7-1.7 4.1-1.2 1.1 1.3 1.5 3.4 2.1 5.1-.5.4-.9.8-1.3 1.3zm80.6 0c-1.8-.4-3.8-.6-5.3-1.5-.5-.3-.2-3.1.6-3.8.9-.9 3.7-1.6 4-1.2 1.1 1.4 1.4 3.4 2 5.1-.5.5-.9 1-1.3 1.4zm305.3-184.9c-2.4 1.4-3.8 2.8-5.1 2.7-1.1-.1-2-1.9-3.1-3 1.2-1 2.3-2.7 3.7-2.9 1-.2 2.3 1.6 4.5 3.2zM438.6 94.2c-1.6-2-3.4-3.4-3.2-4.3.3-1.3 2-2.8 3.3-3.1.8-.2 3 1.8 2.9 2.7-.1 1.4-1.6 2.6-3 4.7zm509.6 540.9c-2.4 1.4-3.8 2.8-5.1 2.8-1.1-.1-2-1.9-3.1-2.9 1.2-1 2.3-2.7 3.6-2.9 1.1-.3 2.4 1.3 4.6 3zM418.6 872.6c1.5 2.3 3 3.7 2.8 4.6-.4 1.3-2 2.8-3.3 3.1-.7.2-2.8-1.9-2.8-2.9 0-1.3 1.6-2.6 3.3-4.8zm549.8-459.7c-2.5 1.5-3.9 3-5.1 2.9-1.1-.1-2-1.9-3-3 1.2-1 2.3-2.6 3.6-2.9.9-.2 2.2 1.4 4.5 3zM697.9 877.6c.9-1.2 1.9-2.3 2.8-3.5l1.5.3c.1 1.7.2 3.3.3 5-1.4-.1-2.9-.2-4.3-.3 0-.5-.2-1-.3-1.5zM681.3 92.9c-1.3-1.5-2.8-2.5-2.7-3.3.1-.9 1.5-2.1 2.5-2.3.6-.1 2.2 1.3 2.2 2 .1 1-1 2-2 3.6zm237.5 199.8c2.2-1.9 3.3-2.8 4.5-3.7.6.8 1.6 1.4 1.8 2.3.2.9-.5 2.7-.6 2.7-1.5-.2-2.9-.7-5.7-1.3zm-762.7 76.1c1.1 1.7 2.2 2.7 2.2 3.7 0 .7-1.6 2.1-2.2 2-1-.2-2.5-1.4-2.5-2.2-.1-.9 1.3-1.9 2.5-3.5zm627.1 465.3v5c-1.2-.2-2.4-.5-3.6-.7.4-1.6.7-3.1 1.1-4.7.9.2 1.7.3 2.5.4zm-627.3-223c1.2 1.7 2.3 2.6 2.4 3.6.1.7-1.4 2.2-2.1 2.1-1-.2-2.6-1.2-2.7-2 0-.9 1.3-2 2.4-3.7zm327 286.1c-1.9 1.2-2.9 2.3-3.8 2.2-.9 0-1.7-1.2-2.6-1.8.8-.9 1.5-2.3 2.4-2.6.8-.1 2 1.1 4 2.2zm258.4-790.9c1.3 1.6 2.5 2.5 2.6 3.5.1.6-1.3 2.1-2 2.1-1-.1-2.5-1-2.7-1.9-.1-.8 1.1-2 2.1-3.7zM361.7 857.5c-2.1.8-3.3 1.6-4.3 1.4-.8-.1-1.4-1.4-2-2.2.9-.7 1.9-2 2.8-2 .9.1 1.8 1.4 3.5 2.8zM578.8 73.2c-.4-1.2-1.4-2.5-1.2-3.6.2-.9 1.5-2.1 2.5-2.4.6-.2 2.2 1.1 2.3 1.8.1.9-.9 2-1.5 2.9-.7.5-1.4.9-2.1 1.3zM539.5 66c1.2 1.6 2.4 2.5 2.5 3.4.1.6-1.4 2.1-2.1 2.1-1-.1-2.6-1.1-2.7-1.9-.1-.8 1.2-1.9 2.3-3.6zM199.7 697.2c-1.1.3-2.3 1-3.3.8-1.1-.2-2-1.3-3-2 .9-1.1 1.5-2.7 2.6-3.1.9-.3 2.3.8 3.5 1.3.1 1 .2 2 .2 3zm-19.8-385.5c-1.9 1.1-2.9 2.2-3.9 2.2-.8 0-1.6-1.2-2.4-1.9.8-.9 1.5-2.2 2.5-2.4.9-.2 2 1 3.8 2.1zm783.6 259.1c1.3 1.6 2.5 2.4 2.7 3.4.1.6-1.4 2.1-2 2.1-1-.1-2.6-1-2.8-1.9-.2-.8 1-1.9 2.1-3.6zM640.2 893.9c1.4 1.5 2.6 2.3 2.8 3.3.1.6-1.3 2.2-1.9 2.2-1 0-2.6-.9-2.8-1.8-.2-.8 1-2 1.9-3.7z"/>',
                            $gradID);
        }
        $mask = '<path d="M585.9 151.6c2.3 4.8 4.5 9.7 7.1 15.3 2.2.1 6 .4 10.2.7-.4-5.7-.5-12.2 5.2-15.3 4-2.2 9.2-3.4 13.7-3 10.2.9 14.5 8.8 12.1 19.7 5.9.7 11.9 1.5 17.7 2.2 0-3-1-7.4.3-10.8 1.3-3.4 4.5-6.7 7.7-8.7 4.6-3 11.8-1.1 15.2 2.8 3.8 4.4 3.4 12.3-.9 18.3-4.2 5.9-8.8 7.1-16.4 4.3.6 4.3 1.3 8.6 2 13.2 3.7.3 7.7.5 12.3.8-.4-7 .6-14.2 7.9-17.6 3.4-1.6 7.9-2.1 11.5-1.3 9.3 2.1 12.4 11.6 8.4 23.9 7.1-2.7 13.9-3 20.3 1.2 7.1 4.6 7.4 11.3 5.1 18.7 17.8-1.9 23 2.7 24.7 19.9 6.4 2.3 12.3 4.3 18.1 6.4l1.5 1.5c1.5 5.5 2.9 10.9 4.4 16.6 3.9.5 9.2 1.1 14.4 1.7-1.9-9.5-.5-14.4 5.3-17.6 5.5-3.1 13.1-2.6 17 1 3.6 3.3 4.6 9.1 2.5 13.9-2.8 6.3-9.1 8.9-19.8 7.9.7 2.7 1.7 5.3 2 8 .3 2.6.1 5.3.1 8.4 6.6-1.4 12.8 0 18.1 4.2v-.1c4.1 5.4 5.8 11.3 4 18.5 7-.2 13.4.6 18.3 5.7 5 5.3 5.6 11.5 2.9 18.8 6.2-1.9 12.2-2.7 16.1 2.1 3.1 3.7 5.6 8.5 6.4 13.2 1.7 9.8-4.5 14.9-18 16 .2 3.4.5 6.9.7 10.7 3.7.5 7.2 1 11.7 1.7-2.2-6.6-1.3-12.8 4.2-17.2 2.2-1.7 5.5-2.7 8.3-2.7 7.9 0 15.6 8.1 15.6 15.7 0 8.2-6.7 12.7-19.7 13 .3 4.6.6 9.2.9 14.2 6.9-.6 13.3.6 17.5 6.8 4.2 6.1 4.1 12.6.4 19.9 7.5-3.2 14.3-4.2 19.3 2.9 4 5.7 5.1 12.1 1.8 18.6-3.6 7-10.2 6.5-17.1 5.5.2 5.3.5 10.2.7 15.2 14 .7 19.4 5.2 19.5 16.2.1 10.9-5.2 15.5-18.8 16.3v12.3c6.1-.2 12.5.1 15.9 5.9 2.2 3.7 3.6 8.4 3.6 12.7-.1 10-6.7 15-18.7 15.2v10.8c13.2 2.2 19.4 8.4 18.9 19.1-.5 10-5.9 14.5-19.6 15.8v11.9c6-.4 12.3.3 15.4 6.3 2 4 3.3 9 2.8 13.4-1 10-8.1 14-19.3 12.1-.4 5.6-.8 11.3-1.2 17.1 7.6-2.7 15-1.8 19 7.5 2.6 6.1.6 13.5-4.4 17.4-4.5 3.6-10.3 3.8-15.5.6-6.5-4.1-8.4-9.9-6-19.2-4 1.1-7.9 2.1-12.4 3.2-.2 2.7-.4 5.9-.6 9.2 13.7 1.4 19.4 7.8 17.9 20-1.3 10.6-7.6 14.6-19 12.8-1.6 6.3-2.2 12.9-5 18.4-3.2 6.3-10.5 6.3-17.1 6.6-.4 4.4-.7 8.5-1.2 13.4 6.6-1.3 12.9-.4 16.5 6 1.8 3.2 3.1 7.3 2.9 10.8-.4 7.8-7.1 12.5-15.7 12-10-.6-13.7-5.8-13.5-19.5-3.4.6-6.8 1.2-10.8 1.9-.4 3-.8 6.3-1.3 9.9 6 .2 12.8-.3 15.9 5.9 1.8 3.6 2.6 8.5 2 12.5-2 11.6-9.4 15.2-22.2 11.6 3.1 8.2 1.1 15.2-4.9 21.1-4.6 4.5-8.7 5-16.9 2.2 2 7.5.8 14.1-4.6 19.5-5.5 5.4-11.9 6.6-19.9 2.5 3.6 7.7 4 14.4-2.7 19.6-5.8 4.5-12.5 5.1-19.6 3.2 1.9 12.8-4.2 23.9-13.6 25.4-8.6 1.4-14.7-5.9-16.6-20.1-3.3.3-6.7.7-10.1 1-.7 3.5-1.4 7.2-2.1 10.9 14.1.5 20.4 4.8 19.9 13.4-.5 8.4-9.4 16.2-17.6 15.4-7.9-.7-12.3-8.2-11.2-19.5-4.1.5-8.2 1.1-10.9 1.5-3.3 6.1-5.6 12.3-9.6 17-4.5 5.3-11.5 4.4-18.4 2.7 1.5 6 2.4 12-2.3 15.9-3.4 2.9-8 5.2-12.3 5.8-10.4 1.4-15.9-4.9-16.7-18.5-3.5.3-7.1.7-10.5 1-1.2 4.2-2.3 8.3-3.5 12.4 9.7-1.7 16.6 1.1 20 8 2.5 5.2 1.3 12.2-2.7 15.8-4.5 4.1-12.3 4.1-18.3.1-6.1-4.1-7.3-9.1-4.3-18.4-2.9.8-5.7 1.9-8.5 2.1-2.9.2-5.9-.5-9.2-.9 1.1 5.2 2.2 10.9-2.3 14.5-3.6 2.9-8.3 5.3-12.8 5.8-11 1.3-15.8-4.9-15.4-18.4h-14.3c.6 5.7.9 12.2-4.9 15.6-3.8 2.3-8.7 3.7-13.1 3.6-9.8 0-14.3-6.5-14.1-18.7h-10.9c-2 5-2.9 10.4-6 13.6-2.9 3-8.1 4.8-12.5 5.1-10.9.8-15.2-4.5-16.4-18.9h-12.9c.5 5.9 0 12-5.6 15-3.9 2.1-8.9 3.7-13.2 3.4-10.4-.7-14.4-7.5-12.6-19.3-5.4-.3-10.9-.5-16.3-.8 1 8.9-2.4 16.5-9 19.3-5.2 2.3-12.3.7-15.7-3.4-3.9-4.7-4.1-12.6-.5-18.5 3.6-6 8.3-7.2 18.1-4.8-.9-3.9-1.8-7.9-2.8-12.3h-9.6c-1.2 12.5-7.4 18.6-18.4 18.1-10.8-.6-15.3-6.4-15.1-19.4-5.5-1-11-1.9-16.3-2.8 1.7 9-.8 15.6-7.8 19.1-5 2.5-11.7 1.6-15.4-2.3-3.9-4.1-4.2-11.9-.5-17.9 3.8-6.3 8.5-7.6 17.3-5.2-.7-4.1-1.4-8.3-2.2-13-3.3-.2-7.1-.4-11.3-.7.7 8.9-2.6 15.5-11.3 17.8-6.3 1.7-12.6 1-17-4.6-4.9-6.3-3.7-12.8.5-19.3-18.5 6.5-31.7-4.2-25.3-20.1-6.9 1.4-13.5 1.9-19.2-2.8-5.7-4.8-6.3-11.1-5-18.5-6.9.9-13.3 0-18.5-4.7-5.5-4.9-6.3-11.1-4.4-17.9-18.3.2-25.6-7.8-22.1-24.5-7.1 2.1-13.7 1.7-19-3.9-5.3-5.6-5.9-12.1-3-19.2-12.8 3.1-20.5-1.7-22.6-13.8-1.8-10.5 3.5-15.6 18.2-17.2-.4-3.5-.8-7.1-1.3-10.7-3.6-.5-7.2-.9-11.7-1.5 2.3 6.3 1.4 12.2-3.6 16.5-2.1 1.8-5.3 3.2-8 3.4-7.8.5-16-7.5-16.4-15.5-.4-8.3 5.7-12.5 19.8-13.5-.3-2.3-.7-4.5-.8-6.8-.1-2.2 0-4.3 0-7-6.9.8-13.3-.5-17.7-6.5-4.4-5.9-4.7-12.3-1.3-19.7-7.6 3.1-14.2 3.3-18.9-3.6-4.1-6-4.9-12.6-1.4-19.1 3.5-6.6 9.7-6.9 16.8-5.8-.4-4.4-.8-8.4-1.2-12.9-6.6.1-12.8-1.7-16.6-8.3-3.6-6.3-3.5-12.8-.2-20-9.1 3.3-16.8 2.8-22.1-5.5-3-4.6-2.2-10.6 1.4-15.1 4.5-5.7 9.8-7 18-4.7v-19c-6.3 2.2-12.9 3-17.2-4.3-3.7-6.3-4.1-12.9 0-19.1 4.3-6.5 10.5-5.4 16.8-3.5v-17.5c-3.3-.2-7.3.5-10.3-.9-3.1-1.4-5.9-4.4-7.6-7.5-3.3-5.8-2-13.4 2-17.3 4.4-4.2 10.8-4.6 19-.6-2.7-6.9-3.9-13.5-.7-20 3.5-7.1 9.8-8.7 17.5-7.9.3-4.2.5-8.3.8-12.9-6 .4-12.4.5-15.6-5.2-2.1-3.8-3.4-8.9-3.1-13.3.8-10.2 8.3-14.6 19.9-12.6.5-5.7.9-11.4 1.4-16.7-3.1-.3-7.5.4-10.8-1.3-3.4-1.7-6.6-5.2-8.5-8.7-2.7-5-.4-11.8 3.9-14.9 4.7-3.4 12.3-2.7 17.9 1.5 5.5 4.1 6.5 8.7 3.5 16.6 3.9-.5 7.8-.8 11.6-1.6.9-.2 2-2.1 2.1-3.3.3-3 .1-6 .1-9.4-7.9.5-15.3-.4-18-9.2-2.1-6.9.2-13 5.3-17.9 5.1-5 11-5 17.7-1.4-2.9-7.3-3.1-14 1.5-20 4.7-6.1 11-7.2 16.9-5.7 1.7-6.2 2.4-12.8 5.4-18.1 3.5-6.1 10.7-6.1 17.1-5.9.8-5.2 1.7-10.3 2.5-15.5-7.1 1.6-14.6 2.5-18.8-5.9-2.7-5.3-.7-12.7 4.1-17 4.1-3.7 10-4.7 14-2.4 6.6 3.8 9.1 10.9 6.9 19.9 2.5-.8 4.8-1.8 7.1-2.2 2.2-.4 4.6-.3 7.1-.4.6-4.3 1.2-8.9 1.8-13.4-13.6.3-20.6-4.8-20-14.9.4-7.8 7.4-13.1 16-12.2 9.8 1.1 13.1 6.9 11.1 19.5 4.5-.8 9.1-1.6 13.8-2.5.7-4.2 1.5-8.7 2.2-13.2-9.2.9-16.2-2.1-19.1-8.2-2.2-4.6-.8-11.5 3-14.9 4.4-4 12.5-4.7 18-1.5 7.1 4.2 6.6 10.5 4.5 18 2.9-.8 5.2-1.7 7.5-2.1 2.4-.4 5-.3 7.8-.4.3-6.3.5-12.7 5.7-17.4 5.1-4.6 11.3-4.6 18.1-3.5-.9-7.4.4-14 6.2-18.8 5.8-4.8 12.2-4.9 19.6-2-2.3-5.7-4.2-11.5.3-15.9 3.2-3.1 7.6-5.9 11.9-6.7 11.3-2.1 16.8 3.8 17.5 18 3.4-.3 6.8-.6 10.5-.9.9-3.9 1.9-7.9 2.7-10.9-4.9-1.2-9.9-1.8-14.2-3.8-2.5-1.2-4.4-4.6-5.5-7.5-2.1-5.4-.1-11.6 3.9-14.6 4.9-3.7 12.7-3.3 18.4.9 5.3 3.9 6.3 8.3 3.5 17.3 2.9-.7 5.5-1.5 8.2-1.8 2.8-.3 5.6-.1 8.4-.1-1.3-11.7 4.4-19 15.6-19.9 10.8-.9 15.9 4.5 16.9 18.2 3.6-.2 7.2-.3 9.8-.4 2.2-5 4.2-9.5 6.2-14 .8-.9 1.7-1.7 2.5-2.6 6.2-3.9 12.8-4.5 20.3-1.3-2.6-7.5-3.2-14.2 4-18.7 6-3.7 12.5-4.1 18.7-.5 6.8 3.9 6.1 10.4 5 16.7h15.8c-.5-5.2-1.6-11.4 3.8-14.8 3.9-2.4 9-4.2 13.5-4.1 10.6.2 14.2 6.2 12.6 19.2h17.3c-1.6-6.7-2.4-14 5.7-18.3 5.4-2.9 13.1-1.6 18.3 2.9 5.7 4.9 5.7 10.9 2.6 17.9 8.1-3.4 15.3-3 21.9 2.6zM109.1 589v15.2c4-.7 8.1-1.5 12.2-2.2v-10.4c-4.6-1-8.8-1.9-12.2-2.6zm11.7-87.5c-4.2-1.2-8.1-2.2-11.6-3.2v14c3.6-.7 7.3-1.5 11.6-2.3v-8.5zm-.4 54.2v-9.9c-3.8-.6-7.3-1.2-10.4-1.7-.3 4.8-.5 9.3-.7 13.7 3.6-.7 7.3-1.4 11.1-2.1zm746.9-114.6c3.8.4 7.2.8 10.2 1.1.6-4.8 1.1-9.1 1.5-13.1-4 .7-7.8 1.4-11.7 2.1v9.9zM544.6 155.6c.7 3.1 1.6 6.6 2.5 10.3h8.5c1.1-4 2.1-7.8 3-11.1-4.6.3-9.1.6-14 .8zm138.2 46.2c.6 3.4 1.2 6.7 1.8 10.2h8.5c.7-3.9 1.4-7.7 2-11.2-4.1.4-8.1.7-12.3 1zM295 866.7c-.9 4.2-1.8 8.3-2.6 12 3.7-.7 8-1.4 12.3-2.2-1.1-9.7-1.1-9.7-9.7-9.8zm170.9-710.9c-4.8-.3-8.9-.5-12.9-.8.7 3.7 1.3 7.2 2 10.7h9c.6-3.5 1.2-6.7 1.9-9.9zm341.9 618.7c-3.4.7-6.1 1.2-9 1.7-.2 3-.4 5.8-.5 8 4.2 1 8 2 11.9 2.9-.8-4.1-1.6-8.2-2.4-12.6zm-67.1 80.1c-.2-1.6-.6-3.3-.7-4.9-.1-1.9 0-3.9 0-5.8-9.9.3-9.4-2-10.5 9.7 3.5.3 7.1.7 11.2 1zM188.6 753.2c-3.1-.4-6.1-.8-8.8-1.2-.5 4.5-.9 8.2-1.3 11.8 3.7-.8 7.2-1.6 11-2.5-.4-2.5-.6-5.1-.9-8.1zm312.8-587.8h7.9c.8-3.5 1.5-6.6 2.2-9.6h-12.3c.8 3.3 1.4 6.3 2.2 9.6zM166.5 363.2c-4.1-.9-7.7-1.7-11.1-2.4.5 4 1 7.9 1.5 12 2.7-.3 5.6-.5 8.8-.9.3-2.9.5-5.7.8-8.7zm-23.9 298.4c-2.9-.6-5.7-1.2-8.4-1.8-.7 4.4-1.4 8.6-2 12.4 3.8-.9 7.5-1.7 11.2-2.6-.2-2.7-.5-5.3-.8-8zm183.2-450.7c.5-3 1-5.6 1.4-8.1-4.1-.7-8-1.4-11.6-2.1.6 3.6 1.3 7.2 1.9 11 2.7-.3 5.4-.5 8.3-.8zM579.9 923c-.4-3.3-.8-6.4-1.1-9.5h-8.3c-.6 3-1.2 5.8-1.8 8.6 3.8.3 7.3.6 11.2.9zm252.6-584.6c-4.1.6-7.4 1.1-11 1.7.4 2.9.8 5.5 1.2 8.2 2.7.5 5.2.9 7.9 1.4.6-4 1.2-7.5 1.9-11.3zm-56.9 468.5c4.4 1 7.8 1.7 11.2 2.5-.8-3.8-1.5-7.3-2.3-11.1-2.2.1-4.6.2-7.4.3-.4 2.8-1 5.5-1.5 8.3zM764 832.5c-.8-3.8-1.6-7.3-2.5-11.3-2.7.4-5.4.9-8.4 1.3v7.5c3.9.9 7.4 1.7 10.9 2.5zM281 853c-.3-2.4-.6-5-1-7.8-2.7-.3-5.3-.5-7.9-.8-.7 3.7-1.4 7-2 10.3 3.9-.6 7.2-1.1 10.9-1.7zM134 431.1v10.2c3.1-.4 5.8-.8 8.5-1.2v-8.4c-2.9-.2-5.6-.4-8.5-.6zm308.1 491.3c-.8-3.3-1.4-6.1-2.1-8.9h-7.2c-.5 3.1-1 5.9-1.6 8.9h10.9zM638 899.1c3.4.3 6.6.5 10.3.8-.4-3.5-.8-6.4-1.2-9.3h-7.5c-.6 2.8-1 5.2-1.6 8.5zM625.8 179c-3.9.2-7.3.3-10.9.5.7 3.3 1.2 5.8 1.8 8.6h7.1c.6-3 1.2-5.7 2-9.1zm250.9 445.9v-10.2c-3.2.5-5.9.9-8.5 1.3v7.2c3 .6 5.7 1.1 8.5 1.7zm-665.8 152c-2.4-.5-4.7-1-7.1-1.5-.7 3.6-1.3 6.8-2 10 3.6-.4 6.8-.7 10.1-1.1-.3-2.6-.6-4.7-1-7.4zM845.2 685v7.3c3.2.4 6.1.8 8.9 1.2-.4-3.5-.8-6.5-1.2-9.7-2.4.4-4.8.8-7.7 1.2zM715.3 234.1c.6-3.1 1.1-6.1 1.7-9.2-3.5.5-6.4.8-9.1 1.2v7.7c2.6 0 4.9.1 7.4.3zM362.8 899.3c3.4-.3 6.4-.5 9.6-.8-.5-2.8-.9-5.3-1.4-7.9h-6.3c-.6 2.9-1.2 5.6-1.9 8.7zm505.4-421.4v7.7c2.7.3 5.1.6 7.8 1 .2-3.2.4-5.9.6-8.7h-8.4zM233.9 799.7c-2.8-.3-5.3-.6-8.2-.9v9.3c3-.7 5.7-1.3 8.2-1.8v-6.6zm151.8-620.4c.7 3.2 1.2 5.9 1.8 8.8h6.4c.6-2.8 1.1-5.4 1.6-7.9-3.2-.3-6.3-.6-9.8-.9zM247.9 830.9c3.4-.3 6.4-.5 9.8-.8-.5-3-1-5.4-1.4-7.8-2.3-.1-4.2-.3-6.3-.4-.7 3-1.4 5.7-2.1 9zM799.6 318v6.6c2.5.4 5 .7 7.7 1.1.2-3 .4-5.7.6-8.6-2.9.3-5.4.6-8.3.9zm-619.1 30.9c2.9-.6 5.4-1.1 7.6-1.5v-6.8H180c.2 2.7.3 5.2.5 8.3zM731 249.7c.1 2.6.3 4.7.4 6.7h6.9c.1-2.6.2-4.9.4-7.8-2.6.4-4.9.7-7.7 1.1zm-429.1-16c.5-2.8.8-5.1 1.3-7.7h-8.4c.2 2.7.4 5.2.6 7.7h6.5zM533.2 922c-.7-3.1-1.2-5.3-1.6-7.5H525c-.3 2.4-.7 4.5-1 6.9 3.1.2 5.8.4 9.2.6zm-55.3-.2c3.2-.2 6-.3 9.1-.5-.5-2.5-.9-4.6-1.3-6.7h-6.5c-.4 2.5-.8 4.7-1.3 7.2zm283.5-649.5h-7.1v6.8h6.7c.1-2.4.2-4.3.4-6.8zm22.2 29.6c.2-2.4.5-4.8.7-7.1-2.9.2-5 .3-7.7.4.2 2.4.5 4.6.7 6.9h4.1c.7 0 1.3-.1 2.2-.2zm85.7 222.5c-.9 6.5.4 7.7 6.5 6.4v-6.4h-6.5zm6.5 45.2c-2.7.7-4.7 1.1-6.7 1.6v5.8c2.4.2 4.4.4 6.7.6v-8zm-740.6 46v8.1c2.5-.6 4.5-1 6.6-1.5v-5.3c-2.1-.4-4-.8-6.6-1.3zm710.9-205.7v5.9c2.2.5 4.3.9 6.7 1.5v-7.8c-2.2.1-4.2.3-6.7.4zM279.4 249.7h-6.1v6.2c2.2-.2 4.1-.3 6.1-.5v-5.7zm-74.9 68.5v6.5h5.7v-5.9c-2.1-.2-3.8-.4-5.7-.6zm-62.9 166.9v-6h-6c.1 2.1.2 4 .3 6h5.7zm16 207.1c2.8-.2 4.9-.4 7.1-.5v-5.8c-1.9-.3-3.7-.5-5.6-.7-.5 2.3-1 4.4-1.5 7zm504.9 183c2.6-.2 4.7-.4 6.9-.5-1-3.9-1.4-7.6-6.3-5.2-.1 1.7-.3 3.3-.6 5.7zm-84.4-692.3c-.4-.5-.7-1-1.1-1.5h-7.3c1.7 2.3 2.8 3.8 3.9 5.3 1.5-1.3 3-2.6 4.5-3.8zm251.3 525.9h-6.2c.1 1.8.2 3.2.4 4.6 2.1.4 3.8.7 5.8 1v-5.6zM256.1 273c-2.1.1-3.7.2-5.6.3.1 1.9.2 3.5.4 5.3 1.9-.1 3.3-.2 4.8-.3.1-1.8.2-3.3.4-5.3zm-23.2 23.2h-5.2v5.3c1.8-.2 3.3-.4 
                    5.2-.6v-4.7zm-96.9 229v5.4c.4.3.8.6 1.3.9l4.5-4.8c-.4-.4-.7-.9-1.1-1.3-1.4 0-2.8-.1-4.7-.2zm-.4 51.2c1.9-.1 3.6-.2 5.3-.2.3-.6.7-1.1 1-1.7-1.5-1.5-3.1-3-5.7-5.4-.3 3.5-.5 5.1-.6 7.3zm510.3-372.1h-5.5v4.7h4.9c.2-1.6.4-2.9.6-4.7zM342.7 869.8v4.4c1.8-.2 3.2-.3 4.6-.4 1.3-4.2-.7-4.8-4.6-4zm89.4-688.4c2 2.3 3.2 3.7 4.4 5.1 1.2-1.4 2.3-2.8 4.2-5.1h-8.6zM158.9 411c-1.2 5 .8 5.8 4.8 4.7V411h-4.8zm206.9-206c-.4.6-.8 1.2-1.1 1.8 1.7 1 3.4 2 5.6 3.3 1.1-6.1-1.7-5.6-4.5-5.1z"/>
                 <path d="M426.1 150.1c-.8.9-1.7 1.7-2.5 2.6-1.6.6-3.1 1.2-4.7 1.7-5.9 1.9-12.8-1-16.4-6.8-3.3-5.5-2.6-13.2 1.6-17.2 4.4-4.2 12.9-3.9 19 .7 5.8 4.4 7.2 9.9 3.9 16.3-.2.8-.5 1.8-.9 2.7zm159.8 1.5c-.7-1.5-1.4-3-2-4.6-3.6-8.6.3-16.5 9.3-18.5 6.8-1.6 11.8 0 14.7 4.6 3.1 5 2.7 12.2-.9 16.5-3.8 4.5-10.7 6.1-16.5 3.8-1.5-.6-3.1-1.2-4.6-1.8zm342.8 399c.1 7.8-5.7 13.5-13.6 13.7-7.8.2-13.6-5.6-13.6-13.6 0-8.1 5.8-13.2 15.1-13.1 7.3.1 12 5.1 12.1 13zm-242 376.9c-7.8 0-12.8-4.8-12.9-12.3 0-7.9 5.5-13 14-12.9 7.8 0 14 6 13.9 13.5-.1 6.6-6.6 11.7-15 11.7zm242-422.1c0 7.5-5.7 12.8-13.7 12.9-8 0-13.6-5.3-13.5-13 .1-7.8 5.5-12.6 14.3-12.7 7.9 0 12.9 5 12.9 12.8zm-46.5 226.7c.1 8.1-5.2 14.3-12.2 14.5-7.4.2-13.4-6-13.5-13.9-.1-7.7 5.7-13 14.1-12.9 7.1 0 11.6 4.9 11.6 12.3zm-773.6-273c.1 8-5.3 14.2-12.4 14.4-7.1.1-13.3-6.5-13.4-14.3-.1-7.2 5.4-12.3 13.6-12.4 7.2-.2 12.1 4.8 12.2 12.3zm132.9-249.3c.1-8.2 5.6-13.2 14.4-13.2 7.5 0 12.3 4.9 12.1 12.4-.2 7.4-6.8 13.2-15 13.1-7.2 0-11.6-4.7-11.5-12.3zm-76.5 78c7.5 0 12.1 4.5 12.1 11.7 0 7.6-6.7 13.7-15.1 13.6-7.1 0-11.5-4.6-11.5-11.8 0-8.5 5.3-13.5 14.5-13.5zm352.7 671.6c-.5 8.6-6.6 15.6-13.2 15.1-6.9-.5-13-7.5-12.5-14.1.6-7.5 7.4-12.9 15.7-12.4 6.4.3 10.4 4.8 10 11.4zm398.9-375.7c6.5-.1 10.7 4.1 10.8 10.6.1 8.2-5.9 15.8-12.4 15.8-6.7.1-13.3-6.5-13.3-13.3.1-7.4 6.3-13 14.9-13.1zM769.8 243.5l-1.5-1.5c-.7-1.9-1.6-3.7-2.1-5.6-1.7-6.4.7-12.5 5.8-15.2 5.3-2.9 11.8-2.3 15.4 1.4 4 4.1 4.6 12 1.3 17.3-3.1 4.9-8.7 6.7-15 4.8l-3.9-1.2zm44 44.2s.1.1 0 0c-.8-2.6-2-5.3-2.3-8.1-.8-7 1.9-11.4 7.8-13.5 6.5-2.3 12-1.2 15.1 3 3.3 4.6 3.2 11.6-.2 16-3.8 4.9-10.6 6.7-16.3 4.4-1.4-.5-2.7-1.2-4.1-1.8zM83 642.1c0-7.9 5.4-12.8 14.1-12.9 6.8 0 11.5 5.2 11.4 12.5-.1 7.1-6.4 13.1-13.8 13.1-7.2.2-11.8-4.9-11.7-12.7zm34.4 80.9c-7.3 0-11.8-4.8-11.8-12.6s5.5-12.8 14.2-12.9c6.9 0 11.5 4.9 11.4 12.4-.1 7.4-6.1 13.1-13.8 13.1zm774.4-318.9c-7.4 0-12.3-5.2-12.2-13 .1-7.6 5.5-12.1 14.3-12 6.7.1 11.2 4.9 11.2 12.2.1 7.3-5.7 12.8-13.3 12.8zm-432.7 569c-7.5-.1-12-5.2-11.9-13.1.2-7.6 5.4-11.9 14.4-11.7 6.8.2 11.1 5 10.9 12.3 0 7.4-5.8 12.6-13.4 12.5zm92.9-24.5c7.2 0 11.7 4.8 11.6 12.2-.1 7.2-5.7 12.3-13.2 12.1-7.2-.1-12.3-5.3-12.2-12.5.1-7.5 5.1-11.9 13.8-11.8zm203.6-727c-7.4 0-12.5-4.9-12.6-12.1-.1-7.4 5.1-12.1 13.5-12.2 7.2-.1 11.9 4.6 11.9 11.9 0 7.3-5.2 12.4-12.8 12.4zm-490.1-35.1c.3-7.4 6.1-12 14.7-11.5 6.1.3 10.1 5.1 9.8 11.7-.4 7-6.6 12.1-14.3 11.7-6.7-.4-10.5-4.9-10.2-11.9zm637.7 273.6c0-7.6 5.1-12.1 13.5-12 6.3 0 10.6 4.8 10.4 11.5-.2 6.9-6 12.3-13.3 12.2-6.7.1-10.6-4.3-10.6-11.7zm-44.3-160.2c.1 6.9-5.7 12.6-12.9 12.6-6.7 0-10.9-4.5-11-11.7-.1-7.4 4.7-11.9 13-12 6.5-.2 10.8 4.2 10.9 11.1zM153 322.5c.1 7.1-5.5 12.7-12.7 12.9-6.6.1-10.8-4.4-11-11.7-.1-7.7 4.8-12.4 13.3-12.3 6.2 0 10.3 4.4 10.4 11.1zm55.8 536.6c-6.7-.2-11.6-5.9-11.4-13.3.2-6.4 5.9-11.2 13.2-11 6.2.2 10.4 5 10.3 11.8-.1 7.6-5 12.7-12.1 12.5zm-33.9-35c0-7.5 4.8-11.7 13.2-11.7 6.5 0 10.6 4.5 10.5 11.4-.1 7.1-5.8 12.4-13.2 12.3-6.6-.1-10.5-4.6-10.5-12zm45.5 45.1c0-7 4.5-11 12.6-11.1 6.7-.1 11.7 4.9 11.8 11.7.1 6.2-5.7 11.2-13 11.2-7 0-11.3-4.5-11.4-11.8zm149.9-739.6c6.2.1 10.3 4.4 10.3 11.1 0 6.9-5.5 12.2-12.6 12.1-6.7-.1-11.3-5.1-11.1-12.2.2-6.8 5.4-11.1 13.4-11zm522.1 592.1c-6.6.1-11.5-4.5-11.8-11.1-.3-6.8 4.6-11.3 12.4-11.5 6.6-.2 11.2 4.3 11.2 10.8.1 6.6-5 11.6-11.8 11.8zm-727.5 68.6c7-.1 11 3.9 10.9 10.9-.1 6.5-5 11.2-11.8 11.1-6.7 0-11.9-4.6-12-10.4-.2-7.1 4.8-11.6 12.9-11.6zm192.8 147.1c.1 6.8-4.7 11.6-11.6 11.8-7 .2-11.8-4.5-11.8-11.5 0-6.8 5.1-11.2 12.7-11.2 6.4.1 10.7 4.5 10.7 10.9zm558.4-306.5c7.1 0 10.8 3.8 10.8 10.9-.1 6.6-4.9 11.1-11.7 11.1-6.7 0-11.8-4.5-11.9-10.5-.1-7.1 4.7-11.4 12.8-11.5zM483.6 107.4c6.5.1 10.4 3.9 10.4 10.3 0 6.6-5.8 11.6-13.2 11.4-6.2-.2-10.1-4.1-10-10.1 0-7.2 5-11.7 12.8-11.6zm248 89.9c-6.4 0-10.3-3.6-10.4-9.7-.2-7.3 4.9-12.1 12.9-12 6.4.1 10.5 4.1 10.4 10.3-.1 6.5-5.7 11.4-12.9 11.4zm58.7 649.4c.1-6.9 4.7-11 12.2-10.7 5.8.2 11 5.3 11 10.9 0 5.7-6.5 10.8-13.6 10.7-6.1-.1-9.7-4.1-9.6-10.9zM84.5 414.3c.1-6.9 4.6-10.9 12.2-10.8 6 .1 11.1 5 11.1 10.7.1 5.7-6.3 10.9-13.4 10.8-6.1.1-10-4.1-9.9-10.7zm580.9 512.9c6.2-.1 11.6 5 11.7 10.7 0 5.6-6.6 10.8-13.6 10.7-6-.1-9.7-4-9.8-10.3-.1-7.2 4-11 11.7-11.1zm-34.5-786c0-7.2 4.1-10.9 12-10.8 6 0 11.1 4.9 11.3 10.5.1 5.8-6.1 10.8-13.4 10.9-6.3.1-9.9-3.8-9.9-10.6zm-113.8-23c.1-6.9 4.7-10.9 12.3-10.7 6 .2 11 5.1 11 10.9 0 5.8-6.2 10.7-13.5 10.6-6.3 0-9.9-4-9.8-10.8zM413.2 971.3c-6.3 0-10.1-4-10-10.6.1-6.9 4.6-11 12.2-10.9 5.9.1 11.1 5 11.2 10.7.1 5.8-6 10.8-13.4 10.8zM266 892.2c0 6.4-4.6 11-11.2 11s-11.1-4.6-11.2-11.6c0-6.2 5.4-10.5 12.9-10.3 5.8.2 9.5 4.5 9.5 10.9zM835.2 824c0 6.4-4.6 10.8-11.3 10.9-6.8 0-11.1-4.5-11.1-11.5 0-6.1 4.9-10.1 12.5-10.1 6.1-.1 9.9 4 9.9 10.7zm35.7-511c6.1.1 9.6 3.9 9.5 10.3-.1 6.2-4.5 10.4-11 10.4-6.6 0-10.7-4.4-10.6-11.2.1-6.2 4.4-9.6 12.1-9.5zM72.5 538.6c-6.6-.1-10.7-4.5-10.5-11.3.2-6.1 4.6-9.6 12.2-9.5 6.1.1 9.7 4.1 9.5 10.4-.2 6.3-4.8 10.5-11.2 10.4zm524 432.9c-5.8-.1-10.9-5.7-10.7-11.7.2-5.7 5.4-9.9 11.9-9.7 5.4.2 9 4.2 9 10 0 6.4-4.5 11.4-10.2 11.4zM788.7 869c0 6.7-4.2 11.4-10 11.3-5.8-.1-10.5-5-10.6-11.1-.1-5.9 4.5-10.1 11.2-10.2 5.6-.1 9.4 3.9 9.4 10zM83.4 574.1c0 5.9-3.4 10-8.3 10.1-6.4.1-13.6-6.3-13.4-12 .1-4.5 5.6-8.7 11.3-8.7 5.9 0 10.4 4.6 10.4 10.6zm226.8-411.2c0 6.6-4.8 12.2-10.3 12.1-5.6-.1-10.1-4.9-10.1-10.5 0-6.3 4.8-10.8 11.4-10.7 5.8 0 9.1 3.3 9 9.1zm127-54.6c6.1 0 10.4 4.3 10.5 10.4 0 6-3.2 9.9-8.2 10-6.5.1-13.6-6-13.4-11.8-.1-4.5 5.1-8.6 11.1-8.6zM140.8 788.5c-6.2 0-10-4-10.1-10.6-.1-5.6 4.7-9.5 11.7-9.6 5.3 0 8.9 4 8.9 10 .1 6.1-4.2 10.3-10.5 10.2zm707.4 2.8c5.5 0 8.9 3.6 8.9 9.8 0 6.1-4.3 10.4-10.4 10.4-6.1 0-9.9-4.1-10-10.7-.2-5.9 4.2-9.5 11.5-9.5zm-92.5 111.1c-6.4.1-10.3-4.1-10.4-10.9 0-5.4 4.5-9.1 11.5-9.3 5.3-.2 9.1 3.7 9.2 9.7.2 6-4.1 10.4-10.3 10.5zM105.8 687.3c0 6.1-4.3 10.3-10.5 10.3-6.1 0-10-4.1-10-10.7-.1-5.7 4.6-9.5 11.7-9.5 5.4 0 8.8 3.7 8.8 9.9zm457.5-569.7c0-5.7 4.7-9.3 11.9-9.2 5.5.1 8.7 3.8 8.6 10-.1 6-4.6 10.3-10.7 10.1-6-.1-9.8-4.3-9.8-10.9zM108 345.3c0-5.7 4.7-9.4 11.8-9.3 5.3 0 8.8 4.1 8.8 10-.1 5.9-4.6 10.2-10.7 10.1-6-.1-9.8-4.2-9.9-10.8zm808.4 59.6c5.1.1 8 3.2 7.8 8.4-.2 6.2-4.8 11.9-9.6 11.8-4.8-.1-9.7-5.5-9.6-10.5.3-5.7 5.1-9.8 11.4-9.7zm-844 88.3c-4.9-.1-9.7-5.4-9.6-10.5.2-5.6 5.1-9.8 11.4-9.7 5 .1 8 3.3 7.8 8.5-.2 6.3-4.8 11.9-9.6 11.7zm638.9-338.8c5.1 0 8 3 8 8.2-.1 6.2-4.5 11.9-9.3 11.9-4.9 0-9.9-5.2-9.8-10.2 0-5.6 4.9-9.8 11.1-9.9zM287.1 916.1c-.1 5.3-3.7 8.9-8.9 8.8-5.2-.1-10.1-5.2-10.1-10.6.1-4.8 4.4-8.4 10.1-8.3 5.2 0 9 4.4 8.9 10.1zm-215-288c-5.3-.1-8.5-3.5-8.4-9.1.1-5.6 4.3-9.3 10.3-9.1 5.1.2 8.3 3.6 8.3 8.8 0 5.5-4.3 9.5-10.2 9.4zM879 779.3c.1 5.1-2.1 7.9-6.3 8-5.6.2-12.7-5.4-12.8-10.1-.1-4.1 5.4-7.9 11.3-7.8 4.8.2 7.7 3.9 7.8 9.9zm68.2-250c-.1 5-2.4 7.8-6.6 7.7-5.7-.1-12.7-6-12.5-10.6.1-3.8 5.6-7.4 11.3-7.4 5 .1 7.9 3.9 7.8 10.3zm-.3 43.9c.1 5.5-3.8 9.4-9.4 9.5-5.1 0-8.6-3.5-8.8-8.9-.1-5.3 4.1-9.1 10.4-9.1 4.7 0 7.7 3.3 7.8 8.5zM377.8 960.6c0 5.3-3.5 8.8-8.8 8.8-5.4 0-9.4-3.8-9.4-9 0-4.9 4-8.3 9.9-8.4 5.2-.1 8.3 3.2 8.3 8.6zM742 915.2c0 5.4-3.5 8.7-9 8.6-5.3-.1-9.1-3.8-9.1-8.8 0-5 4-8.4 9.9-8.5 5.2-.1 8.3 3.2 8.2 8.7zm164.2-228.1c.1-5 4-8.2 10.1-8.1 5.1.1 8.3 3.6 8 8.9-.2 4.9-4 8.4-8.9 8.4-5.4 0-9.3-4-9.2-9.2zM901.4 346c0 5.4-3.3 8.7-8.7 8.7-5.4 0-9.4-3.8-9.4-8.9 0-4.9 4-8.3 9.9-8.4 5.1 0 8.2 3.1 8.2 8.6zM109.3 756.2c0-5.1 4-8.7 9.6-8.8 4.6-.1 8.4 3.3 8.5 7.5.1 4.7-5.2 9.3-10.7 9.3-4.8 0-7.4-2.8-7.4-8zm290.5-637.9c-.1 5.7-2.8 8.4-8.4 8.2-5.4-.1-8.5-2.9-8.5-7.8 0-4.8 4.1-8.7 9.2-8.7 5 0 7.8 3 7.7 8.3zm243.5 849.6c-5.6-.1-10.4-3.5-10.3-7.4.1-4.1 5.2-8.1 10-8 4.9.1 8.2 3.7 8.1 8.9-.1 4.2-2.9 6.6-7.8 6.5zm-107 15.8c0 5.2-1.8 7.6-5.8 7.7-5.1.1-11.1-4.9-11-9.2.1-3.4 4.8-6.8 9.8-7 4.4-.2 6.9 2.9 7 8.5zM331.4 141.6c0 5-2 7.5-6.1 7.5-4.9 0-10.7-4.8-10.8-8.9-.1-3.6 5-7.3 10.1-7.3 4.3 0 6.9 3.2 6.8 8.7zM490.8 984c0 5-2.1 7.5-6.2 7.4-4.9-.1-10.7-4.9-10.8-8.9-.1-3.6 5.1-7.2 10.2-7.2 4.3-.1 6.8 3.1 6.8 8.7zm136.6-865.3c0 4.9-2.1 7.7-5.9 7.8-5 .1-11-5.1-10.9-9.3.1-3.6 4.6-6.8 9.7-6.9 4.7-.1 7 2.7 7.1 8.4zM946 483c0 4.9-2.1 7.7-5.9 7.7-5 .1-11-5.1-10.8-9.4.1-3.6 4.7-6.7 9.8-6.8 4.6 0 6.9 2.8 6.9 8.5zM72.9 444.7c-5.1-.1-8.2-3.2-8.2-8.1 0-4.3 3.8-7.3 9-7.4 4.7 0 8 3.6 7.9 8.4-.2 4.4-3.7 7.2-8.7 7.1zm30.9-75.2c-.2 3.3-.6 6.9-5.4 7.2-4.8.3-11.1-5-11.1-9.2 0-3.4 3.9-6.3 8.9-6.4 4.7-.1 7.5 2.8 7.6 8.4zm842.3 250.6c-.2 3.2-.6 6.8-5.5 7-4.9.1-11.1-5.1-11-9.3.1-3.4 4.2-6.2 9.1-6.2 4.7 0 7.3 2.8 7.4 8.5zM308.7 938.8c-.3 3.3-.7 6.9-5.6 7-4.9.1-11.1-5.1-11-9.3.1-3.3 4.3-6.2 9.1-6.2s7.5 2.9 7.5 8.5zM186.9 224.7c4.2 0 7.6 3.9 7.5 8.5-.1 4-2.7 6.7-6.6 6.7-4.6.1-9.6-4.6-9.4-8.8.1-3.3 4.3-6.4 8.5-6.4zm-15.3 29.4c.1 4-4.3 8.2-8.7 8.3-3.7.1-6.7-3.2-6.7-7.3-.1-4.4 3.3-7.6 8.1-7.7 4 0 7.2 3 7.3 6.7zm264.5 736.8c-3.7.1-6.7-3.2-6.7-7.3 0-4.4 3.3-7.7 8.1-7.7 4.1-.1 7 2.7 7.1 6.8.1 4-4.1 8.1-8.5 8.2zM76.3 657.3c.9 1.2 3.4 3.3 3.7 5.6.7 4.4-5 9.8-9.1 9.6-3.3-.2-6-4.3-5.9-8.8.1-3.3 4.9-6.6 11.3-6.4zm823.3 95.4c.1 5.6-4.6 10.8-8.6 11-3.5.2-6.6-4.1-6.6-8.7.1-3.3 4.8-6.9 9.4-6.6 3.3.1 5.7 1.7 5.8 4.3zM565.7 982.8c-.1-3.5 4.3-6.8 9.1-6.8 3.4 0 5.9 1.5 6.1 5.3.3 4.6-4.7 10-8.9 10-3.3-.1-6.2-4-6.3-8.5zm114.5-841.5c.1-5.1 2.8-7.7 7.8-7.6 4.5.1 7 2.6 6.8 6.8-.2 4.1-4.2 8-8.2 8.1-4 0-6.5-2.9-6.4-7.3zm-478.1 68.5c.1-5.2 2.5-7.5 7.8-7.5 4.2 0 6.1 2.2 6.1 6.2-.1 4.5-3.8 8.8-7.4 8.7-3.6-.1-6.5-3.5-6.5-7.4zm515.3 728.1c0 4.4-2.5 6.9-6.8 6.9s-7.6-3-7.6-6.9c-.1-4 2.9-6.7 7.2-6.7 4.1 0 7.2 2.9 7.2 6.7zM239.6 187.6c-.2 2.9-.9 5.8-5.3 5.8-4.1-.1-9.3-4.2-9.6-7.6-.2-3 3.5-5.6 8.2-5.7 4.2-.1 6.6 2.3 6.7 7.5zm590.8 44c0 4.5-2.7 7.2-6.8 7.3-4.5.1-5.6-3-5.8-6.6-.2-4.2 2.6-6.9 6.7-7 4.6-.1 5.3 3.1 5.9 6.3zM512.1 95.4c0 4-1.8 6.3-6 6.2-4.2-.1-7.8-3.1-7.4-6.5.5-3.8 2.9-5.9 6.8-6 4.3 0 6.6 2.2 6.6 6.3zM140.4 271.1c4.5-.2 7.4 2.4 7.5 6.1.2 4-1.6 6.4-5.7 6.7-3.8.2-8-3.1-7.8-6.3.3-4 2.9-5.8 6-6.5zM95.9 726.5c4.3.1 6.6 2.4 6.5 6.5-.1 4.1-2.2 6.3-6.3 6-3.8-.3-6.9-2-7.3-6.2-.3-3.2 3.6-6.4 7.1-6.3zM914.1 375c-3.9-.3-5.7-2.6-5.6-6.3.1-3.8 3.6-6.6 7.6-6.3 3.9.3 5.7 2.5 5.5 6.3-.2 3.9-3.4 6.6-7.5 6.3zm22.7 68.4c-3.2-.2-5.4-2-5.4-5.9 
                    0-3.8 3.2-7.1 7.1-6.9 3.7.2 6 2.2 6.1 6 .1 3.7-3.3 6.8-7.8 6.8zm-142.2-234c.5-4.1 4-6.7 8-6.3 4 .4 5.5 2.9 5.2 6.6-.3 3.8-3.8 6.4-7.8 6-4-.5-5.4-3-5.4-6.3zm52.5 39.2c4.5.2 6 2.8 6.1 6.7.1 3.2-.8 5.7-4.6 5.8-3.8.1-8.5-3.4-8.3-6.6.3-4.2 3.6-5.2 6.8-5.9zM466.6 97.8c-1.3 1-3.1 3.3-5.3 3.7-3.9.7-8.3-3.4-7.9-6.7.5-4.2 3.7-5.4 7.2-5.5 4.5-.1 5.3 3.3 6 8.5zm83.3-8.4c5.7.3 7.3 2.6 7.4 6.3.1 3.1-.6 5.7-4.5 5.9-3.7.2-9.2-3.6-8.2-6.4.9-2.6 3.9-4.4 5.3-5.8zm227.3 91.3c6.2-.1 7.5 2.6 7.7 6.1.1 3.1-.7 5.7-4.5 6-3.6.3-9-3.7-8.1-6.5 1-2.6 3.9-4.5 4.9-5.6zM57.4 552.2c-1.8 1.6-3.4 4.1-5.5 4.7-3.5.9-8.3-3.3-8.1-6.5.3-4.4 3.8-5.1 7.1-5.4 4.1-.3 5.4 2.5 6.5 7.2zm288.8-428.6c-3.5.2-5.8-.8-5.8-4.6 0-3.7 2.7-6.4 6.3-6.4 3.8.1 4.7 2.5 4.8 5.7 0 3.6-1.5 5.8-5.3 5.3zM55.3 505.8c.4 3.7-1.9 4.9-5.4 4.9-3.3 0-5.5-1.2-5.5-4.9s2.7-6.1 6.5-6.1c4 0 4.5 2.7 4.4 6.1zm888 158.9c.2 3.9-1.8 5.5-5.4 5.4-3.1-.1-5.6-.9-5.5-4.8.1-3.8 2.5-6.2 6.3-6.2 4-.1 4.5 2.6 4.6 5.6zM255.4 169.1c-3.4.2-5.9-.4-6-4.4-.1-3.7 2.5-6.5 6-6.6 3.7 0 4.9 2.2 4.9 5.5.1 3.4-.8 6-4.9 5.5zm-106.7 655c-3 2.5-4.5 4.6-6.5 5.1-2.8.7-7.4-3.5-6.3-5.6 1.1-2.1 3.8-4.2 6.1-4.6 1.7-.1 3.7 2.7 6.7 5.1zm715.4-543.9c-.4-5.6 1.8-7.6 5.6-7.1 1.9.3 4.7 1.4 5.3 2.8 1.1 2.5-4.4 7.6-7.5 7-1.6-.3-2.8-2.3-3.4-2.7zM626.7 983.4c-3 2.5-4.5 4.7-6.4 5.2-2.8.8-7.4-3.4-6.3-5.6 1.1-2.1 3.8-4.3 6.1-4.6 1.6-.2 3.6 2.6 6.6 5zM325.8 956c.4.4 1.8 1.8 3.3 3.2-2.6 2.3-5.3 4.5-7.9 6.8-1.2-1.6-3.2-3.2-3.3-4.9-.5-4.2 2.3-5.6 7.9-5.1zM74.1 385.9c1.5 1.3 2.9 2.7 4.4 4-2.5 2.3-5.1 4.6-7.6 7-1.2-1.6-3.3-3.1-3.5-4.8-.6-4.1 2.1-5.6 6.7-6.2zm84.3 463.2c-.1-5.9 2.5-7.5 6.1-7 1.9.3 3.5 2.1 5.3 3.2-2.6 2.3-5 4.8-7.9 6.6-.6.3-2.9-2.4-3.5-2.8zm751.2-113.8c-.2-5.9 2.4-7.5 6-7.1 1.9.2 3.6 2 5.3 3-2.5 2.3-4.9 4.9-7.7 6.8-.6.4-3-2.2-3.6-2.7zM672.4 118.5c-3.1 2.5-4.7 4.6-6.6 5-2.9.7-7.4-3.3-6.3-5.5 1.1-2.1 3.8-4.1 6.1-4.4 1.6-.3 3.6 2.4 6.8 4.9zM204.1 894.8c-.5-5.7 1.7-7.7 5.5-7.2 2 .3 3.8 2.1 5.7 3.2-2.6 2.3-5.1 4.7-7.9 6.6-.5.3-2.8-2.1-3.3-2.6zm-16.2-30.9 4.5 3.9c-2.5 2.4-5 4.7-7.5 7.1-1.2-1.6-3.3-3-3.5-4.7-.8-4.1 1.9-5.6 6.5-6.3zm-68.3-569.1c1.5 1.3 3 2.7 4.5 4-2.6 2.3-5.1 4.7-7.7 7-1.2-1.6-3.3-3.1-3.6-4.8-.4-4 2.3-5.5 6.8-6.2zM44.7 598.7c-.3-5.6 1.9-7.6 5.7-7 1.9.3 4.7 1.4 5.3 2.9 1 2.3-4.7 7.6-7.7 6.9-1.6-.3-2.8-2.3-3.3-2.8zM422 95.4c-3.2 2.6-5.5 5.6-6.7 5.2-2.4-.8-4.3-3.3-6.3-5.2 2-1.7 3.8-4.3 6-4.7 1.5-.3 3.7 2.3 7 4.7zm-29.1 882.4c1.4 1.4 2.9 2.7 4.3 4.1-2.5 2.3-5.1 4.6-7.6 6.9-1.2-1.6-3.2-3.1-3.4-4.9-.7-4.2 2.2-5.4 6.7-6.1zM762 164.9c-1.8 1.4-4 4.3-5.3 3.9-2.4-.8-4.3-3.3-6.5-5.1 2-1.6 3.8-4.1 6.1-4.7 3.4-.9 4.7 1.7 5.7 5.9zm-68.3 796.8c-1.8 1.4-4 4.3-5.2 3.9-2.4-.8-4.2-3.3-6.3-5.2 2-1.6 3.7-4.1 6-4.7 3.2-.9 4.6 1.7 5.5 6zm-97.4-859c-2.4-3.5-4.8-5.5-4.8-7.5 0-1.5 3.1-4.2 4.8-4.3 1.7 0 5.1 2.8 5 4-.2 2.4-2.5 4.4-5 7.8zm249.1 749.4c-1.1-1.7-3.5-3.9-3.1-4.9.9-2.1 3.3-3.5 5.1-5.3 1.4 1.5 4 3.2 3.9 4.5-.2 2-2.4 3.9-3.7 5.8-.7 0-1.5 0-2.2-.1zm-23.2 22.1c-.6-1-2.9-3.1-2.5-4.2.8-2 2.9-4.3 5-4.9 2.6-.8 4.2 1.3 4.1 4.2-.2 3.2-1.9 4.8-6.6 4.9zM48.5 465.1c-1.1-1.7-3.4-4-2.9-5 .9-2 3.2-3.8 5.3-4.8.6-.3 3.9 2.8 3.7 3.8-.5 2.2-2.4 4.1-3.8 6.2-.8 0-1.5-.1-2.3-.2zm188.3 448.2c-.1 4.8-1.9 6.3-5.1 6.4-2.9 0-4.9-1.7-4-4.2.7-2 3.1-4 5.1-4.8 1.1-.5 3.2 1.9 4 2.6zm729.3-361.7c-1.9 1.3-3.7 3.4-5.7 3.5-1.4.1-3-2.4-4.5-3.8 1.7-1.7 3.1-4.1 5.2-5 1.1-.4 3.2 1.8 4.9 2.9 0 .9 0 1.6.1 2.4zM276.2 146.2c-1-1.6-2.9-3.2-2.9-4.8-.1-3 2-5.2 5.2-4.6 1.4.3 3.6 2.7 3.4 3.6-.5 2.2-2.3 4-3.6 6-.7 0-1.4-.1-2.1-.2zM74.1 705c1.1 1.5 3.3 3.4 2.9 4.5-.6 2-2.5 4-4.4 4.9-.7.4-4.2-2.4-4.1-3.4.3-2.2 2.2-4.1 3.4-6.1.8 0 1.5.1 2.2.1zm888-204.8c1 1.6 3.1 3.5 2.7 4.6-.7 2-2.6 3.9-4.5 4.8-.6.3-4.1-2.5-3.9-3.6.4-2.1 2.3-4 3.5-6 .7.1 1.5.1 2.2.2zM806.5 892.9c-1.9 1.3-3.7 3.3-5.8 3.7-1 .2-4-3.2-3.7-3.7.9-1.9 2.7-3.9 4.7-4.7 1.1-.4 3.1 1.6 4.7 2.5 0 .7.1 1.4.1 2.2zm91.2-592.1c-1.9 1.4-3.7 3.3-5.9 3.9-.9.3-3.4-2-3.7-3.4-.6-3 1.2-5.4 4.4-5.2 1.7.1 3.3 1.7 4.9 2.7.1.7.2 1.3.3 2zm39.9 96.9c-1.9-3-4-4.8-3.9-6.4.1-1.4 2.8-3.9 4-3.8 1.7.3 4.3 2.4 4.4 4 .2 1.5-2.2 3.2-4.5 6.2zm28.1 199.6c-1.7 1.1-3.6 3.2-5.1 3-1.6-.2-3-2.7-4.4-4.2 1.5-1.3 2.9-3.6 4.4-3.7 1.6-.1 3.4 1.8 5.2 2.9-.1.7-.1 1.3-.1 2zM100.8 323.8c-1.7 1.2-3.5 3.3-5.1 3.2-1.6-.1-3-2.5-4.6-3.9 1.4-1.4 2.6-3.7 4.1-3.9 1.7-.1 3.6 1.6 5.4 2.6.2.8.2 1.4.2 2zM118.3 795c2.1 2.9 4.3 4.6 4.2 6.2 0 1.4-2.5 4-3.7 3.9-1.7-.2-4.3-2.1-4.6-3.7-.3-1.4 2-3.3 4.1-6.4zM56.6 642.2c-3.2 1.8-5.1 3.9-6.7 3.6-1.6-.3-2.8-2.8-4.2-4.3 1.6-1.2 3.2-3.3 5-3.4 1.4-.2 3 2 5.9 4.1zm448.9 369.5c-2-2.4-4.3-3.9-4.2-5.3.1-1.5 2.6-4.1 3.8-3.9 1.7.2 4 2.2 4.5 3.9.3.9-2.2 2.8-4.1 5.3zm364-193.4c2 2.6 3.9 4.1 4.3 5.9.2.9-2.6 3.6-3.7 3.4-1.8-.3-4.1-2-4.7-3.6-.3-1.1 2.1-3.1 4.1-5.7zm-90.7 91.1c1.9 2.7 4.2 4.4 3.9 5.8-.3 1.5-2.8 3.6-4.3 3.6-1.4 0-3.8-2.4-3.9-3.9-.1-1.4 2.2-3 4.3-5.5zM259.3 939c-1.5.8-3 2.4-4.6 2.3-1.2 0-2.5-1.8-3.7-2.8 1.5-1.5 2.7-3.5 4.5-4.4.6-.3 2.5 1.8 3.8 2.8v2.1zm478-796.6c-1.6.8-3.2 2.2-4.7 2.1-1.2-.1-2.4-1.9-3.6-2.9 1.5-1.5 2.8-3.4 4.7-4.2.6-.3 2.5 1.9 3.8 3-.1.7-.2 1.3-.2 2zm-274.6 867.5c-2.1-.5-4.3-.6-6.1-1.6-.5-.3-.3-3.5.5-4.3 1-1.1 4.1-1.9 4.6-1.4 1.3 1.5 1.6 3.8 2.4 5.8-.5.5-.9 1-1.4 1.5zm90.9.1c-2-.5-4.3-.7-6-1.7-.5-.3-.3-3.4.6-4.3 1-1 4.2-1.8 4.5-1.3 1.2 1.6 1.5 3.8 2.2 5.8-.4.5-.8 1-1.3 1.5zm344.1-208.5c-2.7 1.5-4.3 3.1-5.7 3-1.2-.1-2.3-2.2-3.4-3.4 1.4-1.2 2.6-3 4.2-3.3 1-.1 2.4 1.8 4.9 3.7zM368.8 100.7c-1.8-2.3-3.9-3.8-3.6-4.8.4-1.5 2.2-3.1 3.7-3.5.9-.2 3.3 2 3.3 3-.1 1.5-1.8 2.9-3.4 5.3zm574.5 609.7c-2.7 1.6-4.3 3.2-5.7 3.1-1.2-.1-2.3-2.1-3.4-3.3 1.3-1.2 2.5-3 4.1-3.3 1-.2 2.5 1.6 5 3.5zM346.2 978.1c1.7 2.6 3.4 4.2 3.1 5.2-.5 1.5-2.2 3.1-3.7 3.5-.8.2-3.1-2.1-3.1-3.3.1-1.5 1.9-2.8 3.7-5.4zM966.1 460c-2.8 1.7-4.4 3.3-5.8 3.2-1.2-.1-2.3-2.2-3.4-3.4 1.3-1.2 2.5-2.9 4.1-3.2 1-.2 2.4 1.6 5.1 3.4zm-305 523.7c1.1-1.3 2.1-2.6 3.2-3.9.5.1 1.1.2 1.6.3.1 1.9.2 3.8.4 5.6l-4.8-.3c-.1-.5-.2-1.1-.4-1.7zM642.4 99.3c-1.5-1.7-3.1-2.9-3-3.7.2-1 1.7-2.3 2.9-2.6.7-.2 2.5 1.4 2.5 2.3 0 1-1.3 2.1-2.4 4zm267.8 225.1c2.5-2.1 3.8-3.2 5-4.2.7.8 1.8 1.6 2 2.6.2 1-.5 3.1-.7 3.1-1.6-.2-3.2-.7-6.3-1.5zM50.4 410.3c1.2 1.9 2.4 3 2.4 4.1 0 .8-1.8 2.4-2.5 2.2-1.1-.2-2.8-1.5-2.9-2.5 0-.9 1.6-2 3-3.8zm706.9 524.4v5.6c-1.3-.3-2.7-.5-4-.8.4-1.8.8-3.5 1.3-5.3.9.3 1.8.4 2.7.5zM50.2 683.4c1.3 1.9 2.6 2.9 2.7 4 .1.8-1.6 2.4-2.3 2.3-1.2-.2-2.9-1.3-3-2.3-.2-.9 1.3-2.1 2.6-4zm368.5 322.5c-2.2 1.4-3.3 2.5-4.3 2.5s-1.9-1.3-2.9-2c.9-1 1.7-2.6 2.7-2.9 1-.2 2.3 1.1 4.5 2.4zm291.4-891.6c1.5 1.9 2.8 2.8 3 3.9.1.7-1.5 2.4-2.2 2.4-1.1-.1-2.8-1.2-3-2.1-.3-1 1-2.2 2.2-4.2zm-428 846.9c-2.4.9-3.7 1.8-4.8 1.6-.9-.1-1.5-1.6-2.3-2.5 1.1-.8 2.1-2.3 3.2-2.3 1 0 2 1.5 3.9 3.2zM526.8 77c-.5-1.4-1.5-2.8-1.3-4 .2-1.1 1.7-2.4 2.8-2.7.7-.2 2.5 1.2 2.6 2.1.1 1-1.1 2.2-1.7 3.3-.8.4-1.6.8-2.4 1.3zm-44.2-8.1c1.4 1.8 2.7 2.8 2.8 3.9.1.7-1.6 2.4-2.4 2.3-1.1-.1-2.9-1.2-3.1-2.2-.1-.9 1.4-2.1 2.7-4zM99.5 780.4c-1.2.3-2.6 1.2-3.7.9-1.2-.3-2.3-1.5-3.4-2.3 1-1.2 1.7-3 3-3.5 1-.4 2.6.9 4 1.4 0 1.2.1 2.3.1 3.5zM77.2 345.9c-2.1 1.3-3.2 2.4-4.3 2.4-.9 0-1.8-1.4-2.7-2.2.9-1 1.7-2.5 2.8-2.7.9-.1 2.1 1.2 4.2 2.5zm883.3 292c1.5 1.8 2.8 2.7 3 3.9.1.7-1.5 2.4-2.3 2.4-1.1-.1-2.9-1.2-3.1-2.1-.2-1 1.2-2.3 2.4-4.2zm-364.4 364.3c1.6 1.7 2.9 2.6 3.2 3.7.2.7-1.4 2.5-2.2 2.5-1.1 0-3-1.1-3.2-2-.2-1 1.1-2.3 2.2-4.2z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape24($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="m826.9 101.5 3.6 151.1-137.2 26.9 155 20.3L874.9 465l-142.1 94 3.6 10 113-50.4 50.7 58.2-154.2 71.9 173.7-8.7-6.9 163.3-652.6 118.2-44.1-81.6 176.4-92.7-203.5 72.7-37.4-105.3 119.7-55.8-206.4 15.8-24-132.7 274.1-104.7-158.8-9.3-23.2-117.3L258 246.1 97.3 268 86.6 76z"/>',
            $gradID);
        }
        $mask = '<path d="m855.8 101.5 3.6 151.1-137.1 26.9 155 20.3L903.9 465l-142.2 94 3.7 10 113-50.4 50.6 58.2-154.1 71.9 173.6-8.7-6.8 163.3-652.6 118.2-44.2-81.6 176.5-92.7-203.5 72.7-37.4-105.3 119.7-55.8-206.5 15.8-23.9-132.7 274.1-104.7-158.9-9.3-23.2-117.3L287 246.1 126.2 268 115.5 76zM150.1 926.6l73.3 8.3-29.1-45.9zM910.2 238l20.2 49.2 42.1-49.2z"/>
                 <path d="m58.5 287.2 35.3 28.4v-28.4z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape25($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="m156.6 801.5-11.3-10.9c-2.2-2-5.4-2.9-8.2-2.2l-15.2 3.8c-2.9.7-5.2 2.9-5.9 5.8l-3.9 14.9c-.8 2.9.1 6 2.3 8l11.3 10.9c2.2 2 5.4 2.9 8.2 2.2l15.2-3.8c2.9-.7 5.2-2.9 5.9-5.8l3.9-14.9c.8-2.9.1-6-2.3-8zm660-573.9c-40.3-49.2-11.5-72.8-11.5-72.8l9.3-8c13.4-9.1 28.3-9.9 45.5-12.8 11.7-1.9 23.1-5.6 32.9-11.2l10-5.2c17.5-11.6 15.8-35.3-3.8-47.4l-3.7-2.4c-24.8-15.4-58.4-11.2-73 10l-3.2 4.5-14.5 22.4c-9 14.3-32.1 16.9-47.7 5.5l-20.7-15c-24.3-14.4-55.7-5-61.3 18.4l-2.8 12c-3.1 13.1-21.9 16.8-34 7.1l-49.6-40.9c-15.9-13-40.7-23.2-58.4-14.2-46.3 23.5-45.8 62.9-203.1 64.9-77.8 1-151.2-60-192.8 9.1C97.4 213 107.9 457 107.9 457c-4.2 17.5 3.3 36.4 19.2 49.4l23.5 19.2c13.7 11.8 53.2 30.9 76.8 67.2 31.2 47.6 22.4 60.6 60.8 71.7 38.5 11.1 57.2 31.2 55.7 59.7-1 18.9-26.7 16.2-37.8 40.8-3.8 8.8-5.1 31.7 17 42.3 27.4 13.1 46.7-3.1 51.8-18.3 6.2-20 4.3-46.3 55.8-60.6 2.2-.4 4.4-.7 6.6-1.1l317.6-68.6c20-4.3 35.1-17.7 39.3-35.2l61.5-258.9c.9-2.4 1.6-5.2 2.2-8 18.1-75.8-7.5-87.9-41.3-129z"/>
                                <path class="st1" d="M370.8 337.9c-21.3 44.7-46.8 31.4-46.8 31.4l-8.5-4.2c-10.5-6.8-15.8-17.3-23.2-28.9-5-7.9-11.2-14.9-18.1-20.2l-6.8-5.6c-13.6-9-29.4-.2-31.6 17.8l-.5 3.4c-2.9 22.8 10.7 45.8 29.9 49.6l4.1.9 20.1 3.4c12.7 2 21.9 17.9 18.9 32.7l-3.9 19.7c-2.3 22.1 14.2 41.8 32.1 38.5l9.2-1.7c10-1.9 18.5 10.5 15.6 22.3l-12.6 48.8c-4 15.6-3.2 36.8 8.6 46.7 30.9 26 58 13.2 109.1 126.2 25.3 55.9 6.2 128.3 67.2 136.4 54.2 7.3 219.9-77.6 219.9-77.6 13.5-2.5 24.2-13.9 28.1-29.5l5.9-23.1c3.9-13.6 4.6-48.2 22.3-76.8 23.1-37.6 34.9-35.4 30.5-66.7-4.5-31.3 3.6-51.2 23.7-59.2 13.4-5.3 19.6 14.2 40.2 14.4 7.3 0 23.6-6.4 24-25.7.4-24-16.9-32.8-29.1-31.6-15.8 1.9-93.4 61.2-50.6-61-.9-1.5-10.8 36.8-11.8 35.4L689 246c-9.3-13.1-23.3-19.8-36.8-17.2l-198.8 37.5c-2 .1-4.1.5-6.2.9-58.3 11-58.6 33.3-76.4 70.7z"/>',
            $gradID);
        }
        $mask = '<path d="M816 266c-37.5-57.6-6.4-86.2-6.4-86.2l10-9.7c14.3-11 29.6-12.2 47.3-16 12-2.4 23.9-7 34.3-13.8l10.6-6.4c18.7-14.1 18.6-42.2-.5-56.2l-3.6-2.7c-24.1-17.9-58.7-12.3-75 13.1l-3.6 5.4-16.3 26.8c-10.2 17.1-33.9 20.6-48.9 7.4l-20-17.4c-23.7-16.7-56.4-4.9-63.7 22.9l-3.8 14.2c-4.1 15.6-23.5 20.3-35.1 9l-47.6-47.6C578.5 93.7 553.9 82 535.2 93c-48.8 28.8-51.2 75.4-211.6 80.6-79.3 2.6-149.7-68.5-197 14.2-42.1 73.5-49.2 362.8-49.2 362.8-5.5 20.9.7 43.1 15.9 58.2l22.6 22.4c13.1 13.8 51.9 35.7 73.4 78.4 28.3 55.9 18.4 71.5 56.7 84 38.4 12.5 56 36 52.4 69.8-2.4 22.4-28.3 19.7-41.5 49.1-4.6 10.5-7.5 37.7 14.2 49.9 27 15.1 47.8-4.5 54.1-22.7 7.7-23.8 7.8-55 61.3-72.9 2.3-.5 4.5-.9 6.8-1.4l328.5-87.1c20.7-5.4 37-21.6 42.6-42.4l81.5-308.3c1.1-2.9 2-6.2 2.9-9.5C872.5 328 847.4 314.2 816 266zM183.3 813.5l-16.4-16.1c-3.1-3-7.8-4.2-12-3.2l-22.2 5.7c-4.2 1-7.6 4.3-8.7 8.7l-5.9 22.2c-1.1 4.3.1 8.9 3.3 11.9l16.4 16.1c3.1 3 7.8 4.2 12 3.2l22.2-5.7c4.2-1 7.6-4.3 8.7-8.7l5.9-22.2c1.1-4.3.2-8.8-3.3-11.9zm116-749.6-12-1.7c-4.4-.7-9.2 1.4-11.6 5.2l-6.8 10.2c-2.4 3.8-3.2 9.1-1.4 13.2l5 11.4c2 4.6 6 7.7 10.6 7.8l12 1.7c4.4.7 9.2-1.4 11.6-5.2l6.8-10.2c2.4-3.8 3.2-9.1 1.4-13.2l-5-11.4c-2.4-4.4-6.4-7.5-10.6-7.8z"/>
                 <path d="m773.6 76.1 6.2 6.3c2.2 2.4 5.9 3.4 9 2.4l8.4-2.3c3.1-.9 5.9-3.4 6.7-6.4l2.3-8.6c.9-3.3 0-6.7-2.6-8.9l-6.2-6.3c-2.2-2.4-5.9-3.4-9-2.4l-8.4 2.3c-3.1.9-5.9 3.4-6.7 6.4l-2.2 8.3c-.9 3.3-.1 6.8 2.5 9.2zM845.4 698l20 19.9c3.1 3 7.8 4.2 12 3.2l27.2-7.2c4.2-1 7.6-4.3 8.7-8.7l7.2-27.2c1.1-4.3-.1-8.9-3.3-11.9l-20-19.9c-3.1-3-7.8-4.2-12-3.2l-27.2 7.2c-4.2 1-7.6 4.3-8.7 8.7l-7.2 27.2c-1.1 4.3.2 8.9 3.3 11.9z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape26($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M47 196.1c53.5-75.3 154.2-8.2 248.6-35.4s146.1-107 203.3-107 62.6 60.8 103.4 71.7 112.5-12.7 152.4 8.2c39.9 20.9 29.9 87.1 59 132.5 29 45.4 118.9 54.4 140.6 121.6 21.8 67.1-41.7 162.4-59.9 258.6s75.3 132.5 10.9 203.2-171.5-49-284.9-8.2C507 882 537.9 965.5 452.6 964.6s-124.3-61.7-207.8-125.2S45.2 834 23.4 745.9s79.8-130.7 87.1-237.7S-6.5 271.4 47 196.1z"/>',
            $gradID);
        }
        $mask = '<path d="M71.2 174.3c53.5-75.3 154.2-8.2 248.6-35.4s146.1-107 203.3-107c57.2 0 62.6 60.8 103.4 71.7 40.8 10.9 112.5-12.7 152.4 8.2s29.9 87.1 59 132.5c29 45.4 118.9 54.4 140.6 121.6s-41.7 162.4-59.9 258.6 75.3 132.5 10.9 203.2-171.5-49-284.9-8.2C531.2 860.3 562 943.8 476.7 942.9c-85.3-.9-124.3-61.7-207.8-125.2s-199.6-5.4-221.4-93.5 79.8-130.7 87.1-237.7C142 379.4 17.7 249.6 71.2 174.3z"/>
                    <circle cx="911.6" cy="189.3" r="72.4"/>
                    <circle cx="645.7" cy="888.3" r="42.1"/>
                    <circle cx="304.8" cy="82.7" r="42.1"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape27($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<circle class="st1" cx="180" cy="505.7" r="110.2"/>
                                <circle class="st1" cx="343.6" cy="296.6" r="257"/>
                                <circle class="st1" cx="694.7" cy="453.8" r="257"/>
                                <circle class="st1" cx="371" cy="644.9" r="193.5"/>
                                <circle class="st1" cx="667.5" cy="772.7" r="193.5"/>',
            $gradID);
        }
        $mask = '<circle cx="315.5" cy="289" r="257"/>
                <circle cx="666.6" cy="446.1" r="257"/>
                <circle cx="342.9" cy="637.2" r="193.5"/>
                <circle cx="639.5" cy="765" r="193.5"/>
                <circle cx="859.2" cy="225.9" r="89"/>
                <circle cx="714.5" cy="112.8" r="51.5"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape28($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M425.3 207.7 368 175.5 311.5 209l.8 65.7 57.3 32.2 56.4-33.5zM763 726.9l-44.8-25.2-44.2 26.2.6 51.4 44.8 25.2 44.2-26.2z"/>',
            $gradID);
        }
        $mask = '<path d="m928.1 483.7-137.3-77.1-135.4 80.3 1.8 157.5 137.3 77.1L930 641.2zm-88.9-348.2L643.4 25.6 450.3 140.1l2.7 224.5 195.7 110L841.8 360zM643.1 486 370 332.6 100.6 492.4l3.7 313.2L377.4 959l269.4-159.8z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape29($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M476.6 763.9H366.1l-55.2 95.6 55.2 95.7h110.5l55.2-95.7zm354.6 0H720.8l-55.3 95.6 55.3 95.7h110.4l55.2-95.7zm-529-712.7H191.8l-55.3 95.6 55.3 95.7h110.4l55.2-95.7z"/>',
            $gradID);
        }
        $mask = '<path d="M478.3 155.8H367.8l-55.2 95.7 55.2 95.6h110.5l55.2-95.6zm176-102H543.9l-55.3 95.6 55.3 95.6h110.4l55.2-95.6zm.9 203.2H544.7l-55.2 95.7 55.2 95.6h110.5l55.2-95.6zM477.4 358.2H367l-55.3 95.7 55.3 95.6h110.4l55.2-95.6zm176.9 101.2H543.9l-55.3 95.7 55.3 95.6h110.4l55.2-95.6zm176.9-101.2H720.8l-55.3 95.7 55.3 95.6h110.4l55.2-95.6zm.9-203.2H721.6l-55.2 95.6 55.2 95.7h110.5l55.2-95.7zm-.9 404.8H720.8l-55.3 95.6 55.3 95.7h110.4l55.2-95.7zM654.3 661H543.9l-55.3 95.6 55.3 95.7h110.4l55.2-95.7zM476.6 560.6H366.1l-55.2 95.7 55.2 95.6h110.5l55.2-95.6zM301.4 256.2H190.9l-55.2 95.6 55.2 95.7h110.5l55.2-95.7zm0 202.4H190.9l-55.2 95.6 55.2 95.7h110.5l55.2-95.7zm0 202.4H190.9l-55.2 95.6 55.2 95.7h110.5l55.2-95.7z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape30($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="m512.1 40.3-64.7 76.6 34 94.4 98.7 17.7 64.7-76.7-34-94.3zm316.3 56.8-64.7 76.6 34.1 94.4 98.7 17.7 64.7-76.6-34-94.4zM378.5 775.8l-64.7 76.7 34 94.3 98.7 17.8 64.7-76.7-34-94.3zM96 535.2l-64.7 76.6 34 94.4 98.7 17.7 64.7-76.6-34-94.4z"/>',
            $gradID);
        }
        $mask = '<path d="m412.8 591.6-64.7 76.7 34 94.3 98.7 17.7 64.7-76.6-34-94.4zm33.3-184.2L381.4 484l34 94.4 98.7 17.7 64.7-76.7-34-94.3zM303.5 286.9l-64.7 76.7 34 94.3 98.7 17.7 64.8-76.6-34.1-94.4zm174.8-63.8-64.7 76.6 34.1 94.4 98.7 17.7 64.7-76.7-34-94.3zM335.4 104l-64.7 76.6 34 94.3 98.7 17.8 64.8-76.7-34.1-94.3zM236 655.2l-64.7 76.7 34 94.3L304 844l64.7-76.7-34-94.3zm417.2-493.6-64.7 76.6 34 94.4 98.7 17.7 64.7-76.7-34-94.3zm-32.3 182.6-64.7 76.6 34 94.4 98.7 17.7 64.7-76.7-34-94.3zM762 465.3 697.3 542l34 94.3L830 654l64.7-76.6-34-94.4zm33.7-184L731 358l34 94.3 98.7 17.7 64.7-76.6-34-94.4zm-67.1 366.1L663.9 724l34 94.4 98.7 17.7 64.7-76.7-34-94.3zM128.7 351.5 64 428.1l34 94.4 98.7 17.7 64.7-76.7-34-94.3zm425.1 359.3-64.7 76.6 34 94.4 98.7 17.7 64.7-76.6-34-94.4zm32.9-182.9L522 604.5l34 94.4 98.8 17.7 64.7-76.6-34.1-94.4zm-315.4-55.3-64.7 76.6 34 94.4 98.7 17.7 64.7-76.6-34-94.4z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape31($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="m546.8 551.3 96.4 168.4L739.7 888H353.8l96.5-168.3zm130.3 92.5L528.9 385.1 380.7 126.4h592.9L825.3 385.1zM147.8 540.5 90.3 440.2 32.9 340h229.7l-57.4 100.2z"/>',
            $gradID);
        }
        $mask = '<path d="m461.9 355.7 148.2 258.7 148.2 258.7H165.4l148.3-258.7zM653 659.5 504.8 400.8 356.6 142.1h592.9L801.3 400.8zm-401.4 34L154 523.2 56.4 352.8h390.3l-97.5 170.4z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape32($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M678.8 894.8c-1-.9-2.1-1.7-3.1-2.7l-4.1-4.1c-.2 1.5-.3 2.5-.5 3.8-.9-.4-1.6-.7-2.4-1 .7-1.8.9-3.3-.9-3.5l-.6 1.5c-.3-.1-.5-.1-.8-.2-1-.6-2-1.3-3-1.9-1.2-.8-2.2-.6-2.9.9-1.5.6-2.4-2.7-4.4-.2 4.7 3.7 8.7 8.2 13.5 11.4.8-.6 1.4-2.2 2.5-1.3.8.6 1.7 1 2.7 1.6.5-3.1-.7-4.1-1.9-5.2-.5-.5-1.4-.9-.3-2.3 1.3 2 3.3 2.9 3.6 6.3.1 1.3 1.2 2.7 2.1 3.3 1.9 1.1 3.4 3.6 5.8 3.3.7-.1 1.5 1.1 2.3 1.7.1-.7.2-1.3.3-2.3.9.8 1.6 1.5 1.7 3 0 1.4.7 2 1.5 2.6 3.5 2.6 6.8 5.3 10.4 7.7 1.6 1.1 2.1 3.1 2.4 5.1.3 1.9.6 3 2.2 3.3 1.7.3 2.6 1.7 2.8 4.3.3 3 .7 5.9-1 9.1-1.4-1-2.7-2-4.3-3.1-.6 1.4-1 2.6-1.7 4.2-.9-2.3-1.8-4.3-2.5-6.3-3.1.8-1.2 4.4-2.5 6.3-1.1-.7-1.1-2.2-1.3-3.5-.9.4-1.8 1.2-2.6 1.1-.8-.1-1.4-1.1-2.1-1.8l-3.8-3.8c-.5.7-1 1.4-1.6 2.3-.3-.9-.6-1.7-.9-2.7-.5.3-.9.6-1.4 1-.7-1.3-.1-4-2.2-3.8-.3.5-.6 1.1-.8 1.5-1.3-.6-2.5-1.1-3.8-1.8.2 1.6.3 2.8.5 4-.2.2-.4.3-.6.5-1.9-1.5-2.1-5.8-4.9-6.1-.2 1.5-.5 3.1-.9 5.2-1.6-1.8-2.9-3.5-3.3-5.8-.4-1.9-.9-3.1-2.3-3.7-.9-.4-1.6-1.2-2.4-1.9-1.1-.9-2-1.2-3.4 0-1.2 1-2.9 1-4.2-.1-.8-.6-1.7-1.2-2.7-2-.8 3.2-.7 6.2.2 8.5.5 1.2 1.3 2.8 2.3 3.4 4.8 2.8 9.7 5.3 14.7 8 0 .2.2.5.2.8-.2 3.9.7 6.8 3.4 8.2 1 .5 1.3 1.7.9 2.9-.2.7-1.2 1-2.2 1.7-.1.8-.3 2.3-.5 3.7-.3 3.4-.5 3.7-3.2 4.9-.2-.4-.5-.8-.8-1.2-.7-1.1-1.5-.7-1.9.5-.5 1.7-.9 3.5-1.1 5.3-.4 2.6-.3 2.6-2.2 2.4-.6 1.5-1.3 3-1.9 4.4-2.6-.7-2.4-4.8-4.7-5.9-.3.4-.8 1-1.4 1.7-.8-.6-1.7-1.3-2.6-2-1.3-1-2.3-2.8-4.3-2.2-1.2.3-2.6-1.4-4.1-2.2-.3 1.4-.6 2.5-.9 4-1.3-1.6-2.4-3-3.5-4.3-.4-.5-.8-1.2-1.2-1.2-2.6-.3-4.7-2.5-7.4-2.5-.3 0-.7-.2-1-.4-2-2-4.2-2-6.7-1.3-1.8.5-4.1 3.3-4.2 5.8-.1 1.6-.1 3-1.3 3.8-.2 0-.4.1-.5 0-2.4-2.8-5-2.4-7.8-.2-.5.4-1 .5-1.5.6-1.5.4-2.8.9-2.8 3.7 0 .9-1 1.9-1.5 3-.7-.4-1.3-.8-2.1-1.3.1.7.1 1 .2 1.3.7 1.5 2 2.6 1.3 5.4-2-1.6-3.8-3.3-5.8-4.7-2.1-1.4-4.2-2.7-6.4-3.6-2.2-.9-4.2-2.7-6.7-2.5-.2 2.3.1 3 2.1 6.3-.3.4-.6.8-1 1.1-.4.4-.8.7-1.3 1.2-1.9-2-3.9-4.1-5.9-6-.9-.9-1.9-1.6-2.9-2.1-3.4-1.6-6.9-3.1-10.3-4.7-2.7-1.3-5.3-2.8-7.9-4.3-4.2-2.5-8.8-3.2-13.4-4.1-5.3-1-10.5-2.6-15.6-4.4-5.3-1.8-10.6-3.9-15.7-6.2-5.6-2.5-11-5.6-16.7-7.8-4.3-1.6-8.1-4.8-12.5-6.2-4.3-1.4-8.6-3-12.9-4.6-4.4-1.6-8.7-3.4-13.1-4.9-1-.4-2-1.3-3.2.1-.3.4-1.2.1-1.7-.1-7.7-3-15.3-6.1-23-9-3.1-1.2-6.3-1.9-9.4-3-2-.7-4-1.5-6-2.2-1.9-.7-3.9-1.4-5.9-1.8-3.6-.7-7.1-1.4-10.2-4-1.1-1-2.6-1.2-4-1.6-4.4-1.5-8.7-3.3-13.1-4.5-3.4-.9-6.7-2.4-10.4-2-1.6.2-3.1-.6-4.7-.8-5.4-.6-10.9-1.1-16.3-1.8-4.6-.6-9.1-1.3-13.6-2-.9-.1-1.8-.2-2.7-.2-2.3.1-4.4-.1-6.6-1.3-2.5-1.3-5.5-1-8.4-1.2-4.6-.3-9.2-.7-13.8-.8-2.6-.1-5.3.3-7.9.5-.5 0-1.1.2-1.6-.1-2.5-1.7-5.3-1.1-8.1-.9-1.7.1-3.4.3-5-.2-3.5-1-7-.6-10.6-.7-2.4-.1-4.7-.5-6.9-1.7-1.4-.8-3-1-4.5-1.5-.7-.2-1.3-.4-2-.5-1-.1-2.1-.2-3.1-.1s-2.1.3-3.6.5c-.2.2-.8 1-1.4 1.7-.2-.2-.3-.4-.3-.5 0-.8.2-1.9 0-2.5-1.5-2.9-.3-5.4 1-7.7 1.7-3.1 1.7-3.4-.9-4.5-.2-.1-.5-.3-.7-.5.1-1.8 1.3-2.3 2.1-3.3.6-.8 1.5-1.5 1.7-2.4.7-3.9 3-5.6 5.1-7.6 5.2-5 11.1-7.4 16.9-10.1 1.4-.7 2.7-2 4.1-3.1-.6-2.1-1.3-2.8-2.7-2.3-2.3.8-4.7 1.4-7.1 2.1 1.1-2.1 3.8-3.6 10.2-5.5.4-1.4.1-2.4-1-2.6-5.9-.9-11.5-3.8-17.7-3.4-3.7.3-7.4-.8-11-1.3-.2 0-.4-.1-.5 0-3.4 1.1-6.6-.6-9.8-.7-3.4-.1-6.8.3-10.1.5-.6 0-1.3.2-1.8 0-2.6-1.4-5.3-.9-8.1-1-4.7 0-9.3.3-14 .5-1.4.1-2.8.5-4.3.6-.8.1-1.6 0-2.3-.1-1.5-.3-3-1-4.6-1-7.2.1-14.4.7-21.6 1.8-6.4 1-12.8.8-19.2 1.6-4.8.5-9.6 1.5-14.4 2.6-6.5 1.4-12.9 3.2-19.4 4.7-2.1.5-4.3.8-6.4 1.2-.6.1-1.3.2-1.8-.1-2.5-1.4-5.3-.9-8-1.3-1.5-.2-2.9-.6-3.6-2.7-.5-1.5-.5-2.8.4-4 1.7-2.4 2.8-5.4 3.8-8.4.6-1.7 1.6-3.1 2.5-4.5 1.4-2.3 3-4.5 4.4-6.9 2.7-4.5 6.2-7.7 9.6-11.1 3.2-3.2 6.4-6.6 9.7-9.6 2.9-2.5 6-4.5 9-6.6 2.3-1.6 4.5-3.1 6.8-4.7v-.9c-1.5-.9-3.1-1.8-4.6-2.6-2.3-1.2-2.3-1.2-2.1-4.7 0-1 0-2 .1-2.9.1-.9.5-1.8.8-3-1.3-.2-2.6-.4-3.9-.5-3.6-.2-7.2-.3-10.9-.5-3.9-.3-7.8-.5-11.4-2.3-1.4-.7-2.7-1.5-4.1-2.3-.5-.3-.9-.7-1.3-1.1.2-.3.4-.6.6-.8.3 0 .7-.2 1-.1 2.2 1.1 4.3 2.2 6.5 3.3.4.2.8.3 1.3.4 7.7 1.5 15.4 2.4 23.2 2.6.1 0 .3-.2 1-.8-4.2-.6-7.9-.9-11.5-1.6-4.9-.9-9.8-1.5-14.4-3.9-1.7-.9-2.8-2.6-3.7-4.6-.7-1.7 0-3.8 1.5-4.3.5-.2 1.1-.1 1.6-.3 1.8-.4 3.4-.6 4.1-4 .3-1.6 1.6-3.3 3.4-3 1.3.2 2.2-.6 2.3-2.8.1-1.3.8-2.7 1.3-4.2-1.4-.4-2.8-.8-4.6-1.3 1.8-4.2 4.8-1.6 6.9-4.3-2.3-3.4-6.2-4.1-8-8.8.1-.6.2-1.8.4-3.2-.5-.2-.9-.6-1.2-.5-4.5.5-9.1 1.1-13.6 1.5-3.8.4-7.6.6-11.5.9-2 .1-4.1 0-6.1.5-2.6.7-4.8-.5-7.2-1-2.9-.7-5.7-2-8.5-3.1-.5-.2-.9-.9-1.3-1.3.4-.6.8-1.3 1.2-1.8 1.4-1.7 2.8-3.4 4.2-5 1.1-1.3 2.2-2.7 3.5-3.5 1.8-1.2 3.5-2.3 4.6-4.7.2-.4.5-1 .8-1.1 2.9-1.3 5.2-4.7 8.3-5.8 3.4-1.1 6.8-2.8 10-4.9 2-1.3 3.8-3.4 5.3-6.2-1.7-2.1-3.2-4.3-4.9-5.8-4.3-3.8-7.6-9-10.6-14.6-1.4-2.7-3.1-4-5.8-3.4-2.1.4-4.2-.3-6.3-.4-2.2 0-4.4.1-6.7.3-2.5.2-5 .7-7.5 1-.6.1-1.4-.1-1.7-.6-1.3-2.4-3.3-3.2-5.3-4-2.5-1-4.6-2.5-5.6-6.1-.5-1.8-1.8-2.4-3.2-2.7-1.2-.3-2.5-.5-3.6-1-.6-.2-1.3-1-1.3-1.7 0-.8.6-1.7 1-2.5.2-.4.6-.6.9-.8 4.2-1.5 6.8-6.4 10.6-9.3-1-2.5-2.7-2.2-4.2-2.6-1.4-.5-2.9-.6-4.5-.9.2-1.2.4-2.2.7-3.3-1-.1-2-.3-3.3-.4 1.2-3.1 2.9-5.2 4.7-7 1.3-1.2 2-2.5 2.1-4.5 0-.4 0-.7.1-1.1.8-3.4-.1-4.7-2.6-4-.8.2-1.6.5-2.4.8-1.8-3.8-.5-7.5.9-10.8 3.1-7.1 7.4-12.7 12.7-16.9 4-3.2 8.2-5.6 12.5-7.9 4.4-2.4 8.8-4.2 13.3-5.1 1.9-.4 3.8-1.6 5.7-2.4 8.8-3.8 17.7-4.9 26.6-6.3 2.5-.4 4.8-1.7 7.3-2.2 4.7-.9 9.4-1.7 14.1-2.3 3.7-.5 7.5-.6 11.4-.8 1.1-2.5 2.3-5.1 3.2-7.8 1.4-3.9 3.4-7 6.1-9.2 2.7-2.3 5.4-4.4 8.2-6.5 1-.8 1.7-1.5 2-3.2.2-1 1.2-2.1 2-2.8 1.6-1.4 3.3-2.6 5.3-4.1-1-.6-1.8-.9-2.4-1.3-.6-.4-1.3-.7-1.7-1.4-1.2-2.3-2.9-2.1-4.7-1.8-1.7.3-3.3.8-5 1.2 0-.3-.1-.5-.1-.8 1.4-.7 2.9-1.5 4.7-2.4-1.9-1.8-3.5-1-5.1-.5-2.3.7-4.6 1.3-6.9 2 3.1-1.6 6.2-3.1 9.4-4.7-.4-2.2-.7-4.1-2.2-4.4-3-.5-6 .3-8.9 1.9-1 .6-2 1.3-3.3 2.1 1.3 1.1 2.4 1.9 3.6 2.9-.7.6-1.1 1-1.5 1.4.8 1.9 2.2.3 3.2.7.4.7.7 1.5 1.3 2.7-2.8.2-5.4.8-7.7-.3-2.9-1.3-5.6-3-8.3-4.7-3.2-2.1-3.3-2.3-2.2-7.1l1.2.6c-.8 4.6 2.2 4.7 3.8 6.7 1.8-2 1.8-6.1 4.5-6.5 2.1-.3 4.1-.7 6.2-1.1-.9-.6-1.8-.7-2.7-.8-.9-.1-1.9-.1-2.8-.4-3.4-.8-6.8-.2-10.1 1.6-2.1.6-4.3 1.2-6.6 1.8-.2-1.3 1.5-3.1-.2-4.6-.8.8-1.6 1.6-2.4 2.5 0-2.2 0-2.2 4.7-9.1-.9-2.8-2.9-3.5-4.9-3.4-4.4.1-8.7.4-13.1.6-.1 0-.2.1-.3 0-3.8-1.2-7.1 1-10.5 3.5-2.9 2.2-3.4 5.5-1 8.1 1.1 1.2 2.5 2 4.1 3.8-.4.1-.7.2-1.1.2-4.2 0-8.1-4.5-8.6-10.1-.1-1.3-.4-2.6-.6-3.9-.5-2.2-1.7-3-3.3-3.3-3-.6-6.1-1.3-9-2.3-5.7-2-9.4-7.6-12.4-13.9-2.8-6-4.1-12.9-4.9-20.2-1.3-12 .4-23.4 5-34.4 1.3-3.1 2.7-6.1 2.2-10-.6-.4-1.3-.7-2.1-1.2.1-.3.2-.8.4-1 1.7-1.8 3.4-3.6 5-5.4.5-.6 1-1.4 1.3-2.3.4-1.1.6-2.4.8-3.6 1.1-7.2 3.4-13.8 7.1-19.4 1.9-3.1 4.2-5.9 6.5-8.4 5.8-6.1 11.8-12 17.7-17.9 2.3-2.3 4.9-4.1 7.3-6.2.7-.6 1.2-1.8 1.9-2.6.6-.7 1.3-1.3 2.1-2.1.3-1.9.5-4-.9-5.8 1.7-2.2 1.3-4.4.5-6.6-3.2-8.6-3.2-7 1.8-14.5 3.8-5.6 8.2-10.3 12.4-15.4 1.2-1.5 2.5-3.1 3.7-4.7 1.2-1.6 1.4-3.5.8-5.4-.2-.7-.7-1.5-.7-2.2 0-1.8-.8-2.5-1.7-3.2-2-1.4-3.9-2.8-5.3-5.3-2.7-4.6-3.7-9.9-2.7-15.9.3-1.9 1.8-3.7 3-5.4-.4 6.4.4 11.8 4.3 15.5 0-.7.1-1.5 0-2.2-.2-1.8-1-3.5-.1-5.6.2-.5-.3-2.1-.9-2.7-2.3-2.3-2.1-6-1.6-9.2.8-4.9 2.6-9.5 6-12.4 1.8-1.5 2.9-4 3.4-6.3 1.1-4.2 3.2-7 5.5-9.8 1.5-1.8 2.9-3.6 4.1-5.7 1.8-3.3 3.9-6.1 6.2-8.8 4.8-5.7 9.4-11.7 14.2-17.4 4.6-5.4 9.1-10.9 14.5-14.9 5.9-4.4 11.9-8.5 17.9-12.8 1-.7 2-1.5 2.9-2.9-.5 0-.9 0-1.4.1-2.9.3-5.9.8-8.8.7-6-.1-11.9 2.1-17.8 4-4.9 1.5-9.7 3-14.5 4.9-4.3 1.7-8.7 2-12.8 4.8-.4.3-1 .4-1.3.2-1.3-1.3-2.5-.4-3.8.2-.5.2-1.1.5-1.6.5-1.5.2-1.9-.5-1.7-2.5.7-5.6 1.5-6.8 5.6-8.4 1.7-.6 3-1.7 4.4-3.5 1.4-1.9 3.4-3 5.2-4.2 1.4-.9 2.7-1.6 3.2-3.9.1-.5.3-1 .6-1.3 2.1-2.4 4.2-5 6.5-7.2 2.6-2.5 5.3-4.6 8-6.8 1.7-1.4 3.6-2.6 5.3-4 .8-.6 1.6-1.3 2.3-2.1 3.4-4.3 7.3-7.4 11.3-10.3 2.7-1.9 5.3-4.2 7.6-6.9 3.4-4.2 7.4-6.9 11-10.3 4.2-4 9-6.2 13.7-8.7 5.9-3.2 12-3.6 18-4.4 5.3-.7 10.5-1.5 15.8-2.3 4.7-.7 9.4-1.3 14.1-2.1 4.2-.7 8.4-1.8 12.5-2.5 5.5-.9 11.1-1.6 16.6-2.5 5.1-.8 10.1-2 15.2-2.8 3.8-.6 7.7-1.1 11.5-1.3 7-.5 14.1-1 21.1-1 8 0 15.9.5 23.9.9 1.6.1 3.3-.1 4.6 1.6.6.8 2 .4 3.1.4 11.3-.2 22.6-.3 33.9-.6 5-.1 10-.8 15-1.2.7-.1 1.5-.3 2.1 0 2.9 1.1 6 .4 9 0 1.7-.2 3.4-.2 5.1-.3 5.8-.1 11.6-.3 17.3-.4 3.9 0 7.8.1 11.7.2 4.2.1 8.3.1 12.5.3 6 .2 12 .3 18 .6 2 .1 4 .8 5.9 1.3.3.1.7.3 1 .2 4.7-.8 9 1.5 13.6 1.6 4.6.1 9.2.7 13.7 1.3 9 1.1 18.1 2.3 27.1 3.5 4 .5 8 1.2 12 1.8.4.1.8.6 1.2 1.4-1 .1-1.9.4-2.9.4-5 0-9.9-.1-14.9-.3-4-.2-7.9-.6-11.9-.9-8.7-.7-17.4-1.4-26.1-2.2-2.3-.2-4.6-.4-6.8-.5-.8 0-1.5 0-2.9.1.6 1.1.8 1.8 1.1 2.2.2.3.7.2 1 .3 5 .7 10 1.2 14.9 2.3 9.5 2.2 19.4 1.7 28.9 3.5 1 .2 2.1.5 3.1.8 6.9 1.8 13.9 2.2 21 2.4 5.9.2 11.9 0 17.7 1.3 2.6.6 5.3.6 7.9 1 3.7.6 7.3 1.4 10.9 2 .5.1 1.1 0 1.6-.3-4.5-1.5-9.1-3-13.6-4.5V93c3.9-.6 7.7-1.1 11.7-1.7-1.5-1.6-3.5-1.2-5-2.7 1.4.1 2.8.2 4.1.3 1.4.1 2.8.3 4.2.3 4.9-.1 9.6 1.4 14.4 2.3 4.6.9 9 2.7 13.6 4 3 .8 6 1.3 9 2.1 10.2 2.7 19.9 6.8 28.8 13.7.3.2.8.3.9.6.5 3.1 2.6 2.9 4.2 3.8 1.2.7 2.4 1.4 3.5 2.6-.5-.1-1 0-1.5-.2-7.6-3.4-15.1-6.8-22.7-10.1-1.2-.5-2.6-.4-3.8-.6-1.2-.2-2.5.2-3.1-1.9-.1-.4-.6-.8-1-.9-2.8-.9-5.6-1.8-8.6-2.2.3.3.9.6.9.9-.2 3.4 1.8 3.4 3.3 3.9 9.2 3.7 18.3 7.2 27.5 10.9 2.2.9 4.5 1.8 6.7 3 3.6 1.9 7.1 3.9 10.7 5.9 2.3 1.2 4.7 2.3 7 3.5 3.3 1.7 6.5 3.7 9.9 5.2 5.1 2.4 10.2 4.4 15.3 6.7 1.7.7 3.4 1.6 5.3 2.6-1.4 1.9-2.6-.1-3.8.9 3.7 2.3 8.1 2.4 11.6 6.2-.9-.1-1.3-.1-1.7-.2-.4-.1-.9-.6-1.2-.5-4.5 1.6-7.8-2.3-11.7-3.2-1.8-.4-3.4-1.6-5.1-2.4-.4-.2-.6-.7-.7-1.6.7.3 1.6.4 2.2 1 1.9 1.9 2.9 1.9 5.6-.4-2.9-1.2-5.4-2.4-8.1-3.3-2.2-.7-4.4-1.1-6.7-1.7-.4-.1-.7-.6-1-.8-1.5-1-2.9-1.9-4.8-1.1-.8.3-1.7 0-2.6-.4-3.6-1.4-7.1-3.1-10.8-4.3-2.4-.8-5-.9-7.5-1.4-1.2-.2-2.4-.5-3.6-1-3.9-1.4-7.7-3-11.6-4.3-1.7-.6-3.6-.7-5.4-1.2-4.7-1.5-9.3-3.2-13.9-4.7-2.8-.9-5.6-1.7-8.4-2.5-.4-.1-.9.1-1.3.2-.1 0-.1.4-.3 1 2.3 1.1 4.6 2.2 7 3.2 6.9 2.8 13.8 5.6 20.8 8.2 2.8 1 5.6 1.5 8.5 2.3 1.9.5 3.7 1.1 5.6 1.6 7 1.7 13.7 4.2 20.2 7.7 7.1 3.8 14.1 7.6 22 8.4 3.6.4 7.1 2 10.6 3 1.6.4 3.3.8 4.9 1 3.4.3 6.8 1 9.9 2.7 1.6.8 3.3 1.2 5.6 1.9-.5-1.3-.8-1.9-1.3-3 2 1.2 3.8 2.2 5.4 3.3 2.6 1.9 5.4 2.9 8.5 3.2 3.5.4 7.1-.2 10.7-.4.5 0 1 .2 1.5.4 1.2.6 2.4 1.3 3.6 1.9.2.1.4.1.5.2 2.6 4.3 7.2 5 9.8 9.2 1.3 2 2.9 3.6 3.3 7-2.7 1.6-5.3 3.2-8 4.8-1.7-1.5-3.3-3.1-4.9-4.6-.6 4.9-.3 5.6 3 6.2 1.5.3 3.1 1.1 4.7-.2.3-.2.9-.1 1.2.2 2.5 2.7 6.1 8 4.9 
                14.5-2.4-.7-4.5-2.2-6.2-4.4-1.7-2.3-3.5-4-5.7-5.1-1.7-.9-3.2-2.3-4.6-3.7-.8-.8-1.7-1.7-1.1-3.8.3-1.2-.4-2.5-1.5-2.9-.7-.3-1.4-.7-2.5-.7.8 1.6 1.7 3.2 2.6 5-.9 1-1.7 1.3-2.8.5-1.4-1.1-2.9-2-4.4-2.9-.3-.2-.8-.3-.9-.7-.7-3.4-3.2-2.6-5.3-4 .7 2.3 2.1 2.4 3 3.9-.8.1-1.3.1-2 .2-.1.7-.3 1.5-.5 2.6-1-1-1.9-1.8-2.9-2.7-1.7 3.7-3.4-.1-5.7.6 1.7 2.7 3.2 5.1 4.7 7.5-.1.2-.2.3-.3.5-.8-.9-1.5-1.7-2.6-2.9-.1 1.3-.1 2-.1 3-2-1.7-2.5-5.8-5.8-5.4.5 2.1.9 3.9 1.4 5.8l-.3.6c-1.2-.8-2.3-1.7-3.8-2.7-.2 2.4-.2 3.8 1.3 4.5 1.6.8 3.2 1.7 4.7 2.8 2.5 1.9 4.9 4.2 7.4 6.1 1.3 1 2.7 2.2 4.2 2.5 6.7 1.6 12.7 5.6 19 8.4.6.3 1.1.7 1.6 1.1 3.9 2.9 4.6 6.4 2.2 12-1 2.4-2.8 3.5-4.6 3.6-2.2.2-4.4-.2-6.6-.3-3.2-.1-6.3-.5-8.8-3.5-.8-1-2.2-1.3-3.4-1.5-7.4-1.4-14.8-2.7-22.2-4.1-1.8-.3-3.4-.1-4.5 2.7.5.9 1 1.7 1.5 2.6l-.3.6c-.8-.4-1.5-.9-2.3-1.1-.6-.1-1.3.3-1.9 1.1-.7-.4-1.3-1-2-1.2-2.1-.6-2.7.2-2.6 3.1 0 2.1-.4 2.7-1.9 2.3-3.5-1.1-6.9-2.6-10.4-3.6-1.7-.5-3.5-.4-5.2-.7-2.4-.4-4.7-.9-7-1.3-4.5-.6-9.1-1.2-13.7-1.7-1.4-.2-2.7.3-4.1 1.6-.8.8-2 .7-3.1.7s-2.3-.3-3.4-.5c-2.1-.2-3 .3-3.6 3.2-.5 2.5-1.4 2.3-2.6 1.9-2.3-.7-4.6-1.5-6.9-2-1.2-.2-2.6 0-3.9.4-2.3.8-4.6 1-6.9.6-1.8-.4-3.7-.6-5.5-.5-.9 0-1.9.6-3.3 1.1 2.7 3.5 5.8 4.6 8.8 6 .9.4 2.2-.7 3.3-.6 1 .1 1.4 2 2.7 2.1 1.5.1 3 1 4.5 1.6 1.2.5 2.4 1.1 3.6 1.6 0 .1-.1.2-.1.3h-3.4c1.3 3.1 3.3 3.9 5 5.2 1.5 1.1 3.1 2.1 4.7 2.7 1.1.4 0 2.6 1.4 2.7.8 0 1.6 1 2.4 1.5l-.3.9c-1.7-.6-3.4-1.3-5.2-2-1.7 3-3.5 3-5.7 1.3-1.3-1-3-.8-4.6-1-2.2-.3-4.4-.6-6.6-.8-.2 0-.5.2-1.3.6 4.5 1.6 8.5 3 12.8 4.5-1.4.6-2.3 1-3 1.3-.2 1.1-.1 2-.4 2.8-.3.8-.8 1.5-1.3 2.3-1.5-.2-3.2-.4-4.8-.6 7 2.5 14 5.1 20.6 8.8-.1.3-.2.7-.3 1l-3-1.2c-5.6-2.2-11.2-4.5-16.8-6.6-1-.4-2-.3-3-.4-.1.3-.2.5-.4.8.6 1 1.2 2 1.9 3-.9 2.3-.9 2.3 2.2 5-.8.1-1.4.2-2.3.4.7 3.3-.7 5.5-2.4 7.7-2.2-1-4.6-2-6.7 1.1-2-1.2-3.8-2.2-5.6-3.3l-.3.9c1.3.8 2.5 1.6 3.8 2.3 4.3 2.5 8.7 4.8 13 7.3 6.4 3.8 12.8 7.6 19.1 11.7 7.8 5.2 15.6 10.4 23.2 16.1 2.5 1.9 5.1 3.1 7.7 4.7 2 1.2 3.9 2.8 5.8 4.3 2.6 2.1 5.3 4.3 7.9 6.6 4.1 3.5 8.5 6 13 8.3 8.8 4.5 17.5 9.5 25.6 15.8 3.4 2.7 7 4.9 10.5 7.4 2.9 2.1 5.7 4.3 8.6 6.4 2.3 1.6 4.7 3 6.9 4.7 5.6 4.3 11.3 8.4 16.7 13.1 6 5.1 11.8 10.8 16.8 17.6 4.7 6.3 7.8 13.8 8.9 23.1.4 3.4 1.2 6.8 1.5 10.2.2 2.2.3 4.6 0 6.9-.3 2.2-.2 4.2.7 5.9 1.3 2.5 2.6 4.9 4.1 7.1 1.8 2.7 2.9 5.8 3 9.6.1 4.8-1.9 8.7-4.2 12-1.1 1.6-3.1 2.3-4.7 2.9-4.6 1.6-9.1 3-13.7 1.7-1.6-.5-3.3-.5-5.1-.7-.2 2.3.8 3.6 1.5 5.2 2.3 5.1 4.8 10 6.9 15.3 2 4.9 3.6 10.2 5.3 15.3.1.3.3.7.3 1 .1 4.7 2.1 7.9 4 11.2 2.9 5.1 5.5 10.4 8 15.9.6 1.2.1 3.3-.3 5.2-.9-2.3-1.7-4.6-2.8-7.5-.6 2.5 0 4.4-.2 6.3-.1 1.9-.1 3.9-.5 5.8-.4 2-1.2 3.9-1.7 5.3-1.7.5-3.1.6-4.3 1.4-3.5 2.2-6.8 1-10.2.5-2.8-.5-5.5-1.1-8.1-2.6-.2-.1-.6-.1-.7-.3-1.6-2.1-3.6-2.3-5.7-2.8-.9-.2-1.7-1.1-2.3-2-1.2-1.6-2.7-2.3-4.6-1.9-.3 2.3.8 3.4 2 4.2-.1 1.3-1.2 1.7-.9 3.3.4 2.5.2 5.3.3 7.9 0 .5 0 1 .1 1.4 1.5 4.2 3.3 8.1 6.2 10.9 1.3 1.2 3.3 2 3 5-1.1-1.1-2.3-2.2-3.6-3.5-2.2.8-.1 3-.9 4.7-1.1-3-3.1-2.5-4.8-1.7-5.3 2.3-10.2 1.3-15.1-.5-.8-.3-1.3-.5-2.2.4-.8.8-2 1-3 1.1-3.1.2-6.2.3-9.2-.8-.8-.3-1.5-1-2.2-1.5-.8-.6-1.7-1.2-2.5-1.6-1.8-.9-3.6-1.6-5.1-4.1 1.4.3 2.4.5 3.5.7 0-.2.1-.3.1-.5l-5.4-2.4c-1.5-.7-3.1-1.2-4.3-2.3-3.5-3.1-7.7-3-11.8-4.6.1-.2.3-.5.4-.8-2.3-1.6-3.8-1.9-6.6-1.5-.1 1.7.9 2.7 1.4 4 1.2 2.7 2.4 5.4 3.7 8.1.2.5 1 .6 1.2 1.1.1.5-.4 1.4-.3 2 .1.6.6 1.1 1 1.5.7.7 1.4 1.3 2.1 1.9-.7 2-1.6 2.6-2.7 1.9-1.2-.8-2-.2-2.7 1.3 0 3 1.7 4.3 2.9 6.1.6.8 1.2 1.7 1.5 2.7 1.2 4.7 3.5 8.2 6 11.6 2.4 3.4 4.7 7.1 7 10.6 1.4 2.1 3.1 4.1 4.4 6.3 1.6 2.6 3.1 5.3 4.6 8 .9 1.6.8 1.7.5 3.4 1 1.6 1.8 3 2.6 4.4.5.8.9 1.8 1.6 2.2 2.5 1.3 2.7 4.5 3.2 7.5.2 1.1.5 2.2.9 3.2 1 2.2 2 4.3 3 6.5.4.9.9 1.7 1.5 2.4 1.6 2.1 3.2 4.1 4.9 6.3-1.9 3.8-.4 6.9 0 10.2.2 1.6.8 3.1.9 4.7.2 2.3.7 4.2 2.2 5.2.6.4 1.3.8 1.7 1.5 1.6 2.2 3.3 3.2 5.5.7.2-.2.5-.2.8-.2.1 0 .1.2.4.6-.6.9-1.3 1.8-2.1 2.9 1.6 2.2 3.6 3.5 5.6 4.5 1.3.6 2.4 1.2 2.6 3.4.1.6.3 1.2.6 1.5 1.8 1.9 2.1 5.1 2.9 7.8.7 2.4 2.1 2.8 3.8 1.3.8-.7 1.6-1.2 3.1-2.3-.3 2.5-.3 4.1-.6 5.6-.3 1.7-.2 3.2.8 3.8 3.4 2 5 6.6 7.9 9.3.7.7 1.6 1.1 2.4 1.6.6 1.1 1.2 2.3 2 3.3 5 6 10 12 14.2 19.1 1.2 2.1 2.3 4.3 2.8 7.1.4 2.4 1.3 4.6 2 6.9 1.6 4.8 3.3 9.6 4.4 14.7.7 3.1 1.8 5.8 4.2 7.5 3.9 2.6 7.5 6 11.3 9 2.3 1.8 4.8 3.4 7.1 5.3 1.2 1.1 2.2 2.8 3.3 4.2.3.4.6.9 1 1.1 4.5 2 7.5 6.9 10.8 11 2.1 2.6 4.4 4.9 6.2 8 .7 1.2 1.3 2.4 1.8 3.8.7 1.9.5 4-.5 5.9-.5 1.1-.9 2.2-1.5 3.2-.5.8-1.3 1.9-1.9 1.9-3.7.4-7.5.5-11.2.7-.2 0-.4-.2-.8-.4 3-.7 5.7-1.2 8.4-1.9 1-.2 2-.7 2.8-1.4.5-.4 1.1-1.5 1.1-2.3.1-1.2-.6-2.5.7-3.4-.5-1-.7-2.4-1.4-3-.9-.9-1.9-1.2-1.5-3.5.2-.8-.9-2-1.4-3-3.6 2.1-4.3-2.1-6.3-4.1.7-.5 1.1-.7 2-1.3-2.7-1.1-5.1-1.7-6.8-4.8.9.1 1.3.2 1.8.2.5-1.5-4.7-6.1-7.7-6.6 2.1 1.7 3.8 3.2 5.8 4.9-1.5.7-2.7.6-3.4-.5-1.7-2.9-4.2-4.6-6.4-6.7-1.5-1.5-3.2-2.7-4.8-4.1 1-1.8 1.5.5 2.6.2-.7-1.1-1.2-2-1.8-3-1 .7-1.9 1.3-3 2 1.5 4.4 2.1 9.5 6.2 11.1-.5 3 1.4 4.2 2.5 5.9.3.5 1.3 0 2.2 0 1.1 2.3 1.2 4.8-.1 7.4-2-.5-3.9-1.1-6.1-1.7.2 1.2.2 2 .4 2.1 1.5.9 1.4 3.1 1.9 4.8.2.7-.7 1.9-1.2 3.2-2.3-2.1-4.3-3.9-6.4-5.8-1.3 1.6-1.3 1.6-2.8.1-.4-.4-1.1-.4-1.7-.5-.5 0-1.1.4-1.5.2-1.8-.7-1.9-.8-3.4.1-2-1.5-4.1-2.8-6.7-1.8-1.7-1.7-4.2.9-5.9-1.7-1.1 2.6-.3 4.2.6 6-.4.6-.8 1.3-1.2 2.1.4 2.3.8 4.6 2.5 6.1.6.5 1 2.1.8 3.1-.3 1.8.2 2.4 1.1 3.1 3.9 3.3 7.8 6.8 11.8 9.9 6 4.6 12 8.9 18.1 13.2 3.3 2.3 6.7 4 9.7 7.2 1.8 1.9 4.3 2.8 6.5 4.2.7.5 1.4 1.1 2.3 1.8-1.7 1.4-2.3-.2-3.2-.6-1.1-.5-2.2-1.2-3.3-1.8-.4-.2-1.1-.2-1.2-.6-1-3-3.5-3.2-5.2-5-.8-.8-1.9-1.5-2.9-1.4-2 .3-3.3-1.2-4.7-2.4-1-.8-2.1-1.6-3.2-2-2.2-.8-4.4-1.3-6.6-1.9-.1 0-.2-.1-.3 0-2.8 1.3-5.3.3-7.9-.4-1.2-.3-2.5-.1-3.9-1.9.3 3 .3 5 2.3 5.7.7.2 1.2 1.5 1.8 2.4-.7.1-1.3.2-1.9.2.2-.1.4-.3.6-.4.5 1.5 1 3 1.5 4.4.1.2.3.2.5.3 1.7.9 3.3 1.7 5 2.6 1.1-2.9 2.6-1.7 4.1-1.9.1-1 .3-2 .4-3.2-.9-1-1.9-2.1-3-3.2 1.3-.4 1.4-.5 3.2 1.6.8 1 1.4 2.5 2.1 3.8 2.5-.7 2.5-.7 3.6.3-.6 1.6-1.3 3.2-2 4.9-.5-.2-1.3-.7-1.5-.4-1.3 1.5-2.4 1-3.7.5-.9-.3-1.2.5-.7 2.4-2.1-.3-4.3-.6-6.5-.9-.3 1.2-.5 2.3-.8 3.9-1.8-.7-3.5-1.3-5.3-1.8-.5-.2-1.1.1-1.7.1-.4 0-.9.3-1.2.1-3.1-1.3-6.4-1.7-9.1-4.4-.7-.7-1.7-.9-2.6-1.4-.3.9-.5 2-.9 2.4-.4.4-1.2.1-1.7-.2-1.2-.7-2.2-1.8-3.4-2.4-.9-.5-1.9-.6-2.9-.7-.2 0-.5.9-.7 1.3-1.2-.6-2.4-1.3-3.7-2-1.1 3.9-3.3 1.4-4.9 2.4.3 1.9.3 1.9 3.6 5-1 .5-1.8.8-2.6 1.2.1.7.2 1.3.4 2.2-.7.1-1.4.2-2 .3l2.4 4.2c-2 2.1-3.5-.7-5.3-.3.9 1.8 8.8 6.6 11.6 7.1-.4.7-.7 1.6-.9 1.6-1.9-.4-4 .5-5.7-1.7-1.1-1.4-2.9-1.7-4.3-2.7-2.9-1.8-5.8-3.2-9.1-3.7-2.2-.3-4.2-2.2-6.3-3.3-.9-.5-1.9-.8-3.1-.6.2.3.3.6.5.9.2.3.5.5 1 1.2-1.2-.3-1.9-.4-2.9-.7 1.1 2.2 3.4 1.3 3.8 3.8v-.1c-2.7-1.2-5.4-2.4-8.1-3.5-.4-.2-.8 0-1.3.1-.9.1-2.1.7-1.8-1.6 0-.2-.5-.5-.8-.7-1.7-.8-3.5-1.2-4.9-2.8-.4-.4-1-.7-1.5-.5-1.5.5-2.3-.6-2.9-2.2-.8.3-1.6.5-1.9.6-1.5-1-2.5-2-3.7-2.5-4.1-1.8-8.3-3.2-12.4-5.2-4.6-2.2-9.3-4.1-14-5.6-.2-.1-.5.1-1.3.3 4.1 2.1 7.6 3.9 11.4 5.9-.4.4-.6.7-.7.7-2.1-.8-4.2-1.5-6.3-2.4-3.2-1.3-6.4-2.8-9.6-4-4.2-1.6-8.4-3-12.6-4.5-.3-.1-.7-.1-1.1.2 2.9 2.9 6.7 3.2 9.9 5.1 0 .3-.1.5-.1.8-.4 0-.8.2-1.1.1-4.7-1.5-9.5-3.1-14.2-4.7-.3-.1-.9-.2-.9-.5-.5-2-1.9-1.8-3-2.1-1.8-.6-3.7-1-5.3-2.4-1.3-1.1-2.6-1-4.1.5 5 3.8 11.1 4 16.1 8-3.9-1.2-7.8-2.4-11.7-3.5 0 .1-.1.2-.1.3 1.1.6 2.3 1.3 3.4 1.9-.1.2-.1.4-.2.6-2.6-.3-5.2-.7-7.7-1.1-.4-.1-1-.1-1.2-.4-2.3-2.9-5.5-2.9-8.4-3.7-.9-.2-1.8-.4-2.7-.7 0-.3.1-.5.1-.8 1.1-.1 2.3-.1 3.4-.2 0-.1 0-.3.1-.4-2.8-.7-5.6-1.4-8.4-2-3.2-.8-6.4-1.5-9.7-2.2-.7-.2-1.5.1-1.7-1.6-.1-.6-1.3-1.2-2.1-1.3-6.2-.9-12.4-1.7-18.6-2.6-.9-.1-1.4-.8-1.4-2.1-.1-2.9-1.8-3.4-3.4-4-.7-.2-1.4-.1-2.1-.4-1.1-.5-2-1.5-3.1-1.8-1-.2-2.1.3-3.4.6.1-1.1.2-1.8.4-3-1.4-.6-2.7-1.2-4.1-1.8-.9-.4-1.7-1.1-2.6-1.4-1-.4-2.1-1-3-.6-1.2.5-2.1.2-3.1-.1-2.4-.8-4.9-1.5-7.8-2.3.3 1 .4 1.7.7 1.9 3.2 2.6 5.7 6.4 9.4 8.1.4.2.8.4 1.1.8.7.9 1.1 2.1 1.9 2.7.7.6 1.8.7 2.7 1 .2-.4.6-1.4.8-1.4 1.4.2 2.8.4 4.1.9 1.9.8 3.6 2.1 5.5 2.9.7.3 1.6.3 2.3 0 1.2-.4 2.3-.3 3.5 1-1 .2-1.7.4-2.6.6.8 1.4 2.4 2.1 1.7 4.4 1 1.1 1.9 2.3 2.9 3.3.5.5 1.3.7 1.9 1 1.4.5 2.4 1.2 2.2 3.6 0 .7.5 1.4.8 2.2.6-.2 1.1-.3 1.6-.4.7 3.1.8 6.7 3.3 8.1.4 1.9-.5 3-1.5 4.1.3 2 .7 4.1 1 6.1-1.9.9-3.1.3-4-1.9-1-2.6-1-2.6-3.2-2-.5 1.3-.9 2.7-1.5 4-.5 1.4-1 2.7-.1 4 .2.3-.2 1.3-.3 1.9-1.2-1.2-.2-4-1.8-3.5.8-1 1.4-2 .5-3.8-.2 1.5-.3 2.6-.5 3.8zM566 102.8c9.7 2.1 19.5 3.5 29.5 3.9-4.5-1.7-9.3-1.9-13.9-3.2 1.8-.2 3.5.2 5.3.3 1.7.1 3.5.2 5.3-.3 1.6-.4 3.3.9 4.9-1.3-3.3 2.1-5.3-.9-7.9-2.3.5-.9.9-1.5 1.6-2.4-2.4-.6-4.5-1.3-6.7-1.6-6-.7-12-1.7-18.2-.9-4.1.5-8.1 0-12.2-.3-2.8-.2-4.9 1.8-7.2 4.1 1.8.7 3.5 1.1 5.3 1.3l23.7 2.7c.2 0 .4.3.7.4-.1.1-.1.3-.2.4-3.4-.3-6.7-.5-10-.8zm-9 688.9c0-1.6-.5-2.4-1.5-2.5-.9-.1-1.8-.3-2.6-.2-2 .3-3.9.5-5.8-.4-.9-.4-2-.4-3.1 1 .8.5 1.4.9 2.1 1.2 5.1 2.2 10.2 4.4 15.3 6.5 3.4 1.4 6.8 2.7 10.2 4 2.3.8 4.6 2 7-1.3.8 2.6 1.9 2.7 3.7 1.7 1.1-.7 2.5-.4 4-.6.2-.5.4-1.3.8-2.5h-2.5c-.7-.9-1.2-1.7-1.8-2.2-2.3-1.8-4.6-3.6-7.3-4.1-1.4-.2-2.8-.3-4.2-.3-1.4 0-2.7.3-4.2.4.2.8.3 1.3.4 1.7-1.7-1.5-3.4-1.8-5.4-1.3-2 .5-4.1.4-6.1.5-.2 0-.3-.5-.5-.7.6-.2 1.1-.6 1.5-.9zm292.8-231.1c2.1.6 3.5-.5 4.6-3.3-1.8.4-3.3.8-4.8 1-1.6.1-3.2-.1-4.7-.1-1.3 0-2.7.1-4 .3-.8.1-1.6.6-2.7 1.1 2.8 2.5 9 3.9 12 2.9-.2-.5-.3-1-.4-1.9zm-430-478.2c.7 1.9 1.7 2.4 2.9 2.3 2.2 0 4.4.1 6.7.1 2.7 0 5.3-.6 7.8-2.3-3.1 0-6.4 1.5-9.3-.5.6-.1 1.1-.2 1.7-.3-3.2-.4-6.4-2-9.8.7zm306.9 778c.9.6 1.1.8 1.3.9 2.5.3 5.3-.7 6.8 3 .1.3.6.2 1 .2.3 0 .7 0 .7.1.6 2.4 1.8 2.3 3.4 1.6.5-.2 1.2.3 1.8.4.4.1.9.1 1.7.1-1-1.6-1.7-2.7-2.5-3.8-.6-.6-1.5-.5-2.3-.5-.6 0-1.3.2-1.8-.2-2.4-1.9-5.2-2.2-8-2.8-.4-.1-1 .5-2.1 1zM598.5 103.5c4 1.8 11.5 1.9 13.3.2-6.4-1.5-11.3-1.7-13.3-.2zm67.7 19.8c4.4 3.6 5.6 4 8.8 3.1-3.2-1.1-6-2.1-8.8-3.1zm58.1 739.6c-.4 1.9.5 2.1 1.3 2.5 1.4.5 2.7.6 4.4-.5-1.9-1.5-3.7-2.2-5.7-2zM579 968.2c-1.3-3.4-2.8-4.4-5.4-3.7 1.6 1.9 3.4 2.6 5.4 3.7zM141.2 245.7c2.2-2 3.1-4.2 3.7-6.9-1.9 1.6-3.3 3.2-3.7 6.9zM812.8 221c.1-.3.3-.6.4-.9-1.3-2.1-3.3-2.4-5.1-3.4-.1.2-.2.5-.3.7 1.7 1.1 3.4 2.3 5 3.6zm-97.6 635.7c.1 1.1 0 1.9.3 2.3 1 1.2 2 2.7 4.1 2.3-1.6-1.6-2.7-2.8-4.4-4.6zM650 929.3c.2-.2.4-.4.7-.6-.2-1.1-.5-2.3-.8-3.7-.9.6-1.6 1.1-2.5 1.8 1.1 1 1.8 1.8 2.6 2.5zm56.1-74.5c1.5 2.2 3.2 1.5 4.9 1.7-.6-2.2-.9-2.3-4.9-1.7zm-33.5 10.6c1.1 1.6 1.2 3.9 3.2 2.8-1.2-.4-.7-3.7-3.2-2.8zm46.7-6.4c.2-.2.3-.5.5-.7-.6-.6-1.2-1.2-1.8-1.7-.1.2-.2.4-.4.6.6.6 1.1 1.2 1.7 1.8zM835 893.9c-.1.2-.3.4-.4.6.3.5.6 1 1 1.4.1.1.4-.2.9-.4-.6-.7-1.1-1.2-1.5-1.6zM618.2 105.2c0 .3-.1.7-.1 1 .7-.1 1.5-.1 2.2-.2v-.6c-.7 0-1.4-.1-2.1-.2zm-38.3 699.4c1.1 1.3 1.1 1.3 2.7.2-1.1-.1-1.9-.1-2.7-.2zM772.4 193c-.2-1.8-.2-1.8-1.7-2.7.7 1.2 1.1 1.8 1.7 2.7zm-77.1 661.7c0-.3.1-.6.1-.9h-1.3c0 .2 0 .3-.1.5.5.1.9.3 1.3.4zm-6.1 72.5c-.1.1-.3.2-.4.3.1.5.2.9.4 1.4l.4-.2c-.1-.5-.2-1-.4-1.5z"/>',
            $gradID);
        }
        $mask = '<path d="M709.8 868.6c-1-.9-2.1-1.7-3.1-2.6-1.3-1.2-2.6-2.6-4.2-4.1-.2 1.5-.3 2.5-.5 3.8-.9-.4-1.6-.7-2.4-1 .6-1.9.8-3.3-.9-3.5l-.6 1.5c-.3-.1-.5-.1-.8-.2-1-.6-2.1-1.2-3.1-1.9-1.2-.8-2.2-.6-2.9 1-1.5.6-2.5-2.6-4.4-.1 4.7 3.7 8.8 8.1 13.7 11.2.8-.7 1.4-2.2 2.5-1.3.8.6 1.7 1 2.7 1.6.5-3.1-.8-4.1-2-5.1-.5-.5-1.4-.8-.3-2.3 1.3 2 3.4 2.9 3.7 6.3.1 1.3 1.2 2.7 2.2 3.2 1.9 1.1 3.4 3.5 5.9 3.2.7-.1 1.5 1 2.3 1.7.1-.7.2-1.3.3-2.3.9.8 1.7 1.5 1.7 3 .1 1.4.7 2 1.5 2.6 3.5 2.5 6.9 5.2 10.5 7.6 1.6 1.1 2.2 3 2.5 5.1.3 1.9.7 3 2.2 3.3 1.7.3 2.6 1.7 2.9 4.3.3 3 .7 5.9-.9 9.1-1.4-1-2.8-2-4.3-3.1-.5 1.4-1 2.6-1.6 4.2-1-2.3-1.8-4.3-2.6-6.2-3.1.9-1.1 4.4-2.4 6.3-1.2-.7-1.1-2.2-1.3-3.5-.9.4-1.8 1.2-2.6 1.1-.8-.1-1.4-1.1-2.1-1.7-1.2-1.2-2.5-2.4-3.8-3.7-.5.7-1 1.4-1.6 2.3-.3-.8-.6-1.7-.9-2.7-.5.3-.9.6-1.4 1-.7-1.3-.2-4-2.2-3.7-.3.5-.6 1.1-.8 1.5-1.3-.6-2.5-1.1-3.9-1.7.2 1.6.4 2.8.5 4-.2.2-.4.3-.6.5-2-1.5-2.2-5.8-5-6-.2 1.5-.5 3.1-.8 5.2-1.7-1.8-2.9-3.5-3.4-5.8-.4-1.9-1-3.1-2.4-3.7-.9-.3-1.6-1.2-2.4-1.8-1.1-.8-2-1.1-3.4.1-1.2 1-2.9 1-4.2 0-.8-.6-1.7-1.2-2.7-1.9-.7 3.2-.7 6.2.3 8.5.5 1.2 1.3 2.8 2.4 3.4 4.9 2.7 9.8 5.2 14.8 7.8 0 .2.2.5.2.8-.2 3.9.8 6.8 3.5 8.1 1 .5 1.3 1.7.9 2.9-.2.7-1.2 1-2.2 1.8-.1.8-.3 2.3-.4 3.7-.3 3.4-.5 3.7-3.1 4.9-.2-.4-.5-.8-.8-1.2-.7-1.1-1.5-.7-1.9.6-.5 1.7-.8 3.5-1.1 5.3-.3 2.6-.3 2.6-2.1 2.4l-1.8 4.5c-2.7-.6-2.5-4.8-4.8-5.9-.3.4-.8 1-1.4 1.7-.8-.6-1.7-1.3-2.6-1.9-1.4-1-2.3-2.7-4.4-2.2-1.2.3-2.6-1.3-4.1-2.2-.3 1.4-.5 2.5-.9 4-1.3-1.6-2.4-3-3.6-4.3-.4-.5-.8-1.2-1.2-1.2-2.6-.2-4.7-2.5-7.4-2.4-.3 0-.7-.1-1-.4-2-1.9-4.3-2-6.7-1.2-1.8.5-4.1 3.4-4.2 5.9-.1 1.6-.1 3-1.3 3.8-.2 0-.4.1-.5 0-2.4-2.8-5-2.3-7.8-.1-.5.4-1 .5-1.5.6-1.5.4-2.8.9-2.8 3.7 0 .9-.9 2-1.5 3-.7-.4-1.3-.8-2.1-1.2.1.7.1 1 .2 1.3.7 1.5 2.1 2.6 1.3 5.4-2-1.6-3.9-3.3-5.9-4.6-2.1-1.4-4.2-2.7-6.5-3.5-2.2-.8-4.2-2.6-6.7-2.4-.1 2.3.1 3 2.2 6.3-.3.4-.6.8-.9 1.1-.4.4-.8.7-1.3 1.2-2-2-3.9-4-5.9-5.9-.9-.9-1.9-1.6-3-2.1-3.4-1.6-7-3-10.4-4.6-2.7-1.3-5.4-2.7-8-4.2-4.3-2.5-8.8-3.1-13.5-3.9-5.3-.9-10.5-2.5-15.7-4.2-5.3-1.8-10.6-3.8-15.8-6-5.6-2.4-11.1-5.5-16.8-7.6-4.4-1.6-8.2-4.7-12.6-6-4.3-1.3-8.6-2.9-12.9-4.5-4.4-1.6-8.7-3.2-13.1-4.8-1-.4-2-1.3-3.2.2-.3.4-1.2.1-1.7-.1-7.7-2.9-15.4-5.9-23.2-8.8-3.1-1.1-6.3-1.9-9.4-2.8-2-.6-4-1.5-6.1-2.1-1.9-.6-3.9-1.3-5.9-1.7-3.6-.7-7.1-1.3-10.2-3.9-1.1-.9-2.6-1.1-4-1.6-4.4-1.5-8.7-3.2-13.2-4.3-3.4-.8-6.7-2.4-10.4-1.9-1.6.2-3.1-.6-4.7-.7-5.5-.6-10.9-1-16.4-1.6-4.6-.5-9.1-1.2-13.7-1.8-.9-.1-1.8-.2-2.7-.1-2.3.2-4.4-.1-6.6-1.2-2.5-1.3-5.6-.9-8.4-1.1-4.6-.3-9.2-.5-13.8-.6-2.6 0-5.3.4-7.9.5-.5 0-1.1.2-1.6-.1-2.5-1.7-5.3-1-8.1-.8-1.7.1-3.4.3-5-.1-3.5-1-7-.5-10.6-.6-2.4 0-4.7-.4-7-1.6-1.4-.8-3-1-4.5-1.4-.7-.2-1.4-.4-2-.5-1-.1-2.1-.1-3.1-.1-1 .1-2.1.3-3.6.5-.2.2-.8 1-1.3 1.8-.2-.2-.3-.4-.4-.5 0-.8.2-1.9-.1-2.5-1.5-2.9-.3-5.4 1-7.7 1.7-3.1 1.7-3.4-.9-4.5-.2-.1-.5-.3-.7-.5.1-1.8 1.3-2.3 2-3.3.6-.8 1.5-1.5 1.6-2.4.7-3.9 2.9-5.6 5-7.7 5.2-5 11-7.5 16.7-10.3 1.4-.7 2.7-2 4-3.1-.6-2.1-1.3-2.8-2.7-2.3-2.3.8-4.7 1.4-7 2.1 1.1-2.1 3.7-3.6 10.1-5.7.3-1.5.1-2.4-1.1-2.5-5.9-.8-11.5-3.7-17.7-3.2-3.7.3-7.4-.7-11-1.1-.2 0-.4-.1-.5 0-3.4 1.1-6.6-.5-9.9-.6-3.4 0-6.7.4-10.1.6-.6 0-1.3.3-1.8 0-2.6-1.3-5.4-.9-8.1-.9-4.7 0-9.3.4-14 .7-1.4.1-2.8.5-4.3.7-.8.1-1.6.1-2.3-.1-1.5-.3-3-1-4.6-1-7.2.2-14.4.9-21.6 2.1-6.4 1.1-12.8 1-19.2 1.8-4.8.6-9.6 1.7-14.4 2.8-6.5 1.5-12.9 3.3-19.3 5-2.1.5-4.2.9-6.4 1.2-.6.1-1.3.2-1.8-.1-2.6-1.4-5.3-.9-8-1.2-1.5-.2-2.9-.6-3.7-2.7-.5-1.5-.5-2.8.3-4 1.7-2.4 2.7-5.4 3.7-8.4.5-1.7 1.6-3.1 2.5-4.5 1.4-2.3 2.9-4.6 4.3-6.9 2.7-4.6 6.1-7.8 9.5-11.2 3.2-3.3 6.3-6.7 9.6-9.7 2.8-2.5 5.9-4.5 8.9-6.7 2.2-1.6 4.5-3.2 6.7-4.8v-.9c-1.6-.8-3.1-1.7-4.7-2.5-2.3-1.2-2.3-1.1-2.2-4.7 0-1 0-2 .1-2.9.1-.9.4-1.8.7-3-1.3-.2-2.6-.4-3.9-.5-3.6-.2-7.2-.2-10.9-.4-3.9-.2-7.8-.4-11.4-2.2-1.4-.7-2.7-1.4-4.1-2.2-.5-.3-.9-.7-1.3-1.1.2-.3.4-.6.6-.8.3 0 .7-.2.9-.1 2.2 1 4.4 2.2 6.5 3.2.4.2.8.3 1.3.4 7.7 1.4 15.4 2.2 23.2 2.3.1 0 .3-.2 1-.8-4.2-.5-7.9-.8-11.5-1.4-4.9-.8-9.8-1.4-14.4-3.7-1.8-.9-2.9-2.6-3.8-4.6-.8-1.7-.1-3.8 1.4-4.4.5-.2 1.1-.2 1.6-.3 1.8-.5 3.4-.6 4.1-4 .3-1.6 1.6-3.3 3.4-3.1 1.3.2 2.1-.7 2.3-2.9.1-1.3.8-2.7 1.2-4.2-1.4-.4-2.9-.8-4.6-1.2 1.7-4.2 4.8-1.6 6.8-4.3-2.4-3.3-6.2-4-8.1-8.7.1-.6.2-1.8.4-3.2-.5-.2-.9-.6-1.2-.5-4.5.5-9.1 1.2-13.6 1.7-3.8.4-7.6.7-11.4 1-2 .2-4.1 0-6.1.6-2.6.7-4.8-.4-7.2-1-2.9-.7-5.7-1.9-8.6-3-.5-.2-.9-.9-1.3-1.3.4-.6.8-1.3 1.2-1.8 1.4-1.7 2.7-3.4 4.1-5 1.1-1.3 2.2-2.7 3.5-3.6 1.7-1.2 3.4-2.4 4.6-4.7.2-.4.5-1 .8-1.1 2.9-1.3 5.1-4.8 8.2-5.9 3.4-1.2 6.8-2.9 10-5 1.9-1.3 3.8-3.5 5.2-6.3-1.7-2.1-3.2-4.2-5-5.8-4.4-3.8-7.7-9-10.7-14.5-1.4-2.6-3.1-3.9-5.8-3.3-2.1.5-4.2-.3-6.3-.3-2.2 0-4.4.2-6.7.4-2.5.3-5 .8-7.5 1.1-.6.1-1.4-.1-1.7-.6-1.3-2.4-3.3-3.2-5.3-3.9-2.6-.9-4.6-2.4-5.6-6-.5-1.8-1.9-2.3-3.2-2.7-1.2-.3-2.5-.4-3.6-.9-.6-.2-1.3-1-1.4-1.7-.1-.8.5-1.7 1-2.5.2-.4.6-.6.9-.8 4.1-1.6 6.7-6.5 10.5-9.4-1-2.4-2.8-2.1-4.2-2.6-1.4-.5-2.9-.6-4.5-.9.2-1.2.4-2.2.6-3.3-1-.1-2-.2-3.3-.4 1.2-3.1 2.9-5.2 4.6-7 1.2-1.3 2-2.5 2-4.6 0-.4 0-.7.1-1.1.7-3.4-.1-4.7-2.6-4-.8.2-1.6.5-2.4.8-1.9-3.8-.6-7.5.8-10.8 3.1-7.1 7.2-12.8 12.5-17.1 4-3.2 8.2-5.6 12.4-8 4.3-2.4 8.7-4.3 13.3-5.3 1.9-.4 3.8-1.6 5.7-2.5 8.7-3.9 17.7-5.1 26.5-6.7 2.5-.4 4.8-1.8 7.2-2.3 4.7-1 9.4-1.8 14.1-2.4 3.7-.5 7.5-.6 11.4-1 1-2.5 2.2-5.1 3.1-7.8 1.3-3.9 3.4-7 6-9.3 2.7-2.3 5.4-4.5 8.1-6.6 1-.8 1.7-1.5 2-3.2.2-1 1.2-2.1 2-2.8 1.6-1.4 3.3-2.6 5.3-4.2-1-.6-1.8-.9-2.4-1.3-.6-.4-1.3-.7-1.7-1.4-1.2-2.3-3-2.1-4.7-1.7-1.7.3-3.3.8-4.9 1.3 0-.3-.1-.5-.1-.8 1.4-.8 2.9-1.5 4.7-2.5-1.9-1.8-3.5-1-5.1-.5-2.3.8-4.6 1.4-6.8 2.1l9.3-4.8c-.5-2.2-.7-4.1-2.3-4.3-3-.5-6 .3-8.9 2-1 .6-2 1.3-3.3 2.2 1.4 1.1 2.4 1.9 3.6 2.8-.7.6-1.1 1-1.5 1.4.9 1.9 2.2.3 3.2.6.4.7.7 1.5 1.3 2.7-2.8.2-5.4.8-7.7-.2-2.9-1.2-5.7-2.9-8.4-4.6-3.3-2-3.3-2.3-2.3-7.1l1.2.6c-.8 4.6 2.3 4.7 3.9 6.6 1.8-2 1.7-6.1 4.4-6.6 2.1-.4 4.1-.8 6.2-1.2-.9-.6-1.8-.7-2.7-.8-.9-.1-1.9-.1-2.8-.3-3.4-.8-6.8-.1-10.1 1.7-2.1.6-4.3 1.2-6.6 1.9-.2-1.3 1.4-3.1-.2-4.6-.7.8-1.6 1.6-2.4 2.5 0-2.2 0-2.2 4.6-9.1-1-2.8-2.9-3.4-5-3.4-4.3.1-8.7.5-13.1.7-.1 0-.2.1-.3 0-3.8-1.1-7.1 1.1-10.4 3.7-2.9 2.3-3.4 5.6-.9 8.1 1.1 1.2 2.5 2 4.1 3.8-.4.1-.7.2-1.1.3-4.2.1-8.1-4.4-8.7-10-.1-1.3-.4-2.6-.7-3.8-.5-2.1-1.7-3-3.4-3.2-3-.5-6.1-1.2-9-2.2-5.7-1.9-9.5-7.4-12.6-13.8-2.9-6-4.3-12.9-5.1-20.1-1.4-12 .2-23.4 4.5-34.5 1.2-3.1 2.7-6.2 2.1-10-.6-.3-1.3-.7-2.1-1.1.1-.3.2-.8.4-1 1.6-1.8 3.3-3.6 5-5.5.5-.6 1-1.4 1.3-2.3.4-1.1.6-2.4.8-3.6 1.1-7.2 3.3-13.8 6.8-19.5 1.9-3.1 4.1-5.9 6.4-8.4 5.8-6.2 11.6-12.2 17.5-18.1 2.3-2.3 4.8-4.2 7.2-6.3.7-.7 1.2-1.8 1.8-2.6.6-.7 1.2-1.3 2.1-2.1.2-1.9.5-4-.9-5.8 1.6-2.2 1.3-4.4.4-6.6-3.3-8.5-3.3-7 1.7-14.5 3.7-5.6 8.1-10.4 12.2-15.6 1.2-1.6 2.5-3.1 3.6-4.8 1.2-1.6 1.4-3.5.7-5.5-.3-.7-.7-1.5-.7-2.2 0-1.8-.8-2.5-1.8-3.1-2-1.4-3.9-2.8-5.4-5.2-2.7-4.5-3.9-9.8-2.9-15.8.3-2 1.7-3.7 2.9-5.5-.3 6.4.5 11.8 4.5 15.5 0-.7.1-1.5 0-2.2-.2-1.8-1.1-3.5-.2-5.6.2-.5-.4-2.1-.9-2.6-2.4-2.3-2.2-6-1.7-9.2.8-4.9 2.4-9.6 5.8-12.5 1.8-1.6 2.8-4 3.4-6.3 1-4.3 3.1-7 5.4-9.9 1.4-1.8 2.9-3.7 4-5.8 1.8-3.3 3.9-6.1 6.1-8.9 4.7-5.8 9.2-11.8 14-17.5 4.5-5.5 9-11.1 14.3-15.1 5.9-4.5 11.8-8.7 17.8-13 1-.7 2-1.6 2.9-3-.5 0-.9 0-1.4.1-2.9.3-5.9.9-8.8.9-6 0-11.9 2.3-17.8 4.2-4.8 1.6-9.7 3.1-14.5 5.1-4.2 1.8-8.7 2.1-12.8 5-.4.3-1 .4-1.2.2-1.3-1.3-2.5-.4-3.8.2-.5.2-1 .5-1.6.5-1.5.2-1.9-.5-1.7-2.5.6-5.6 1.4-6.8 5.5-8.4 1.7-.7 3-1.7 4.4-3.6 1.4-1.9 3.4-3 5.2-4.3 1.3-.9 2.7-1.6 3.1-3.9.1-.5.3-1 .6-1.3 2.1-2.5 4.2-5.1 6.4-7.2 2.6-2.5 5.3-4.6 8-6.8 1.7-1.4 3.5-2.7 5.3-4.1.8-.6 1.6-1.3 2.3-2.2 3.3-4.3 7.2-7.5 11.2-10.4 2.6-2 5.3-4.2 7.5-7 3.3-4.2 7.3-6.9 10.9-10.5 4.2-4.1 9-6.3 13.6-8.9 5.9-3.2 11.9-3.8 18-4.6 5.2-.7 10.5-1.6 15.7-2.5 4.7-.7 9.4-1.4 14.1-2.3 4.2-.8 8.3-1.9 12.5-2.7 5.5-1 11-1.7 16.5-2.7 5.1-.9 10.1-2.1 15.2-3 3.8-.7 7.7-1.2 11.5-1.5 7-.5 14.1-1.1 21.1-1.2 8-.1 15.9.3 23.9.6 1.6.1 3.3-.2 4.7 1.5.6.8 2 .4 3.1.3 11.3-.3 22.6-.5 33.9-1 5-.2 10-.9 14.9-1.3.7-.1 1.5-.3 2.1-.1 3 1.1 6 .3 9-.1 1.7-.3 3.4-.3 5.1-.3 5.8-.2 11.6-.5 17.3-.6 3.9-.1 7.8 0 11.7 0 4.2 0 8.3 0 12.5.1 6 .1 12 .1 18.1.4 2 .1 4 .8 6 1.2.3.1.7.2 1 .2 4.7-.8 9 1.4 13.6 1.4 4.6.1 9.2.6 13.8 1.1 9 1 18.1 2.1 27.1 3.2 4 .5 8 1.1 12 1.7.4.1.8.5 1.2 1.4-.9.2-1.9.5-2.8.5-5 0-9.9 0-14.9-.1-4-.1-7.9-.5-11.9-.8L555.7 59c-2.3-.2-4.6-.3-6.8-.4-.8 0-1.5.1-2.9.1.6 1.1.8 1.8 1.1 2.2.2.3.7.2 1 .3 5 .7 10 1 15 2.1 9.6 2.1 19.4 1.5 29 3.2 1 .2 2.1.5 3.1.8 6.9 1.7 13.9 2.1 21 2.2 5.9.1 11.9-.2 17.7 1.1 2.6.6 5.3.5 7.9.9 3.7.5 7.3 1.3 11 1.9.5.1 1.1 0 1.6-.3-4.6-1.4-9.1-2.9-13.7-4.3v-.3c3.9-.6 7.7-1.2 11.7-1.8-1.5-1.6-3.5-1.1-5.1-2.7l4.2.3c1.4.1 2.8.3 4.2.3 4.9-.2 9.6 1.3 14.4 2.2 4.6.9 9.1 2.6 13.6 3.8 3 .8 6 1.2 9 2 10.2 2.5 20 6.5 29 13.4.3.2.8.3.9.6.5 3.1 2.6 2.8 4.2 3.7 1.2.7 2.4 1.4 3.6 2.6-.5-.1-1 0-1.5-.2-7.6-3.3-15.2-6.6-22.9-9.8-1.2-.5-2.6-.3-3.9-.5-1.2-.2-2.5.2-3.1-1.8-.1-.4-.6-.8-1-.9-2.8-.9-5.6-1.8-8.6-2.1.3.3.9.6.9.9-.2 3.4 1.8 3.3 3.3 3.9 9.2 3.6 18.4 7 27.6 10.6 2.3.9 4.5 1.8 6.7 2.9 3.6 1.8 7.2 3.9 10.8 5.7 2.3 1.2 4.7 2.3 7.1 3.4 3.3 1.7 6.6 3.6 10 5.1 5.1 2.3 10.3 4.3 15.4 6.5 1.7.7 3.4 1.6 5.3 2.5-1.4 2-2.6-.1-3.8.9 3.7 2.2 8.1 2.3 11.7 6.1-.9-.1-1.3-.1-1.7-.2-.4-.1-.9-.6-1.2-.5-4.4 1.6-7.8-2.2-11.8-3.1-1.8-.4-3.5-1.5-5.2-2.4-.4-.2-.6-.7-.7-1.6.7.3 1.6.4 2.2 1 1.9 1.8 2.9 1.9 5.6-.5-2.9-1.1-5.5-2.3-8.1-3.2-2.2-.7-4.5-1.1-6.7-1.6-.4-.1-.7-.6-1.1-.8-1.5-1-2.9-1.8-4.8-1-.8.3-1.7 0-2.6-.3-3.6-1.3-7.2-3-10.8-4.1-2.4-.8-5-.8-7.5-1.3-1.2-.2-2.4-.5-3.6-.9-3.9-1.4-7.7-2.9-11.6-4.2-1.8-.6-3.6-.6-5.4-1.2-4.7-1.4-9.3-3.1-14-4.5-2.8-.9-5.6-1.6-8.5-2.4-.4-.1-.8.1-1.3.2-.1 0-.1.4-.3 1 2.3 1 4.6 2.2 7 3.1 6.9 2.7 13.9 5.4 20.9 8 2.8 1 5.7 1.5 8.5 2.2 1.9.5 3.8 1.1 5.7 1.5 7 1.6 13.7 4 20.3 7.4 7.1 3.7 14.2 7.4 22.1 8.2 3.6.4 7.1 2 10.7 2.9 1.6.4 3.3.8 4.9.9 3.4.2 6.8 1 9.9 2.6 1.6.8 3.4 1.1 5.6 1.9-.6-1.3-.8-1.9-1.3-2.9 2.1 1.2 3.8 2.1 5.5 3.3 2.6 1.8 5.5 2.8 8.5 3.1 3.6.4 7.1-.2 10.7-.5.5 0 1 .2 1.5.4 1.2.6 2.4 1.3 3.6 1.9.2.1.4.1.5.2 2.7 4.3 7.2 4.9 9.9 9.1 1.3 2 2.9 3.5 3.3 6.9-2.6 1.7-5.2 3.3-7.9 4.9-1.7-1.5-3.3-3-5-4.5-.6 4.9-.3 5.6 3.1 6.1 1.5.2 3.1 1 4.7-.2.3-.2.9-.1 1.2.2 2.6 2.7 6.2 8 5.1 
                    14.4-2.4-.7-4.6-2.1-6.2-4.3-1.7-2.2-3.5-3.9-5.8-5.1-1.7-.8-3.2-2.3-4.6-3.7-.8-.8-1.7-1.6-1.2-3.8.3-1.2-.4-2.5-1.5-2.9-.7-.3-1.4-.7-2.5-.7.9 1.6 1.7 3.2 2.7 4.9-.8 1.1-1.7 1.4-2.7.5-1.4-1.1-3-1.9-4.4-2.9-.3-.2-.8-.3-.9-.6-.8-3.4-3.2-2.5-5.4-3.9.7 2.2 2.1 2.4 3 3.8-.8.1-1.3.1-2 .2-.1.7-.2 1.5-.4 2.6-1-1-1.9-1.8-2.9-2.7-1.7 3.7-3.4-.1-5.6.7 1.7 2.7 3.2 5.1 4.8 7.5-.1.2-.2.3-.3.5-.8-.9-1.5-1.7-2.6-2.9 0 1.3-.1 2-.1 3-2-1.7-2.5-5.8-5.9-5.3.5 2.1 1 3.9 1.5 5.7l-.3.6c-1.2-.8-2.4-1.7-3.8-2.7-.2 2.4-.1 3.8 1.3 4.5 1.6.8 3.2 1.7 4.7 2.8 2.5 1.9 4.9 4.1 7.5 6 1.3 1 2.7 2.1 4.2 2.5 6.7 1.5 12.8 5.5 19.1 8.2.6.2 1.1.7 1.6 1.1 3.9 2.8 4.6 6.4 2.4 12-1 2.4-2.7 3.5-4.5 3.7-2.2.2-4.4-.1-6.6-.2-3.2-.1-6.3-.5-8.9-3.4-.9-1-2.2-1.2-3.4-1.5-7.4-1.3-14.8-2.6-22.2-3.8-1.8-.3-3.4-.1-4.4 2.7.5.8 1 1.7 1.5 2.6l-.3.6c-.8-.4-1.5-.9-2.3-1-.6-.1-1.3.3-1.9 1.1-.7-.4-1.3-.9-2.1-1.1-2.1-.6-2.7.2-2.6 3.1.1 2.1-.4 2.8-1.9 2.3-3.5-1.1-6.9-2.5-10.4-3.5-1.7-.5-3.5-.4-5.2-.6-2.4-.4-4.7-.9-7-1.2-4.6-.6-9.1-1.1-13.7-1.6-1.4-.1-2.7.3-4.1 1.6-.8.8-2 .7-3.1.7s-2.3-.3-3.4-.4c-2.1-.2-3 .4-3.6 3.2-.5 2.5-1.4 2.3-2.6 2-2.3-.6-4.6-1.5-6.9-1.9-1.2-.2-2.6 0-3.9.4-2.3.8-4.6 1.1-6.9.6-1.8-.3-3.7-.5-5.5-.5-.9 0-1.9.7-3.3 1.2 2.8 3.5 5.9 4.6 8.9 5.9.9.4 2.2-.7 3.3-.6 1 .1 1.4 2 2.7 2.1 1.5.1 3 1 4.5 1.5l3.6 1.5c0 .1-.1.2-.1.3h-3.4c1.3 3 3.3 3.9 5.1 5.2 1.5 1.1 3.1 2 4.7 2.6 1.1.4 0 2.6 1.4 2.7.8 0 1.6.9 2.4 1.5l-.3.9c-1.7-.6-3.4-1.2-5.2-1.9-1.7 3-3.5 3.1-5.7 1.4-1.3-.9-3.1-.8-4.6-1-2.2-.3-4.4-.5-6.6-.7-.2 0-.5.2-1.3.6 4.5 1.5 8.5 2.9 12.9 4.4-1.4.6-2.3 1-3 1.3-.1 1.1-.1 2-.4 2.8-.3.8-.8 1.5-1.3 2.3-1.5-.2-3.2-.4-4.8-.6 7 2.4 14 4.9 20.7 8.6-.1.3-.2.7-.3 1l-3-1.2c-5.6-2.2-11.2-4.4-16.8-6.4-1-.4-2-.3-3-.4-.1.3-.2.5-.4.8.6 1 1.3 2 1.9 3-.9 2.3-.9 2.3 2.2 4.9-.8.1-1.4.3-2.2.4.7 3.3-.6 5.5-2.3 7.7-2.2-.9-4.6-1.9-6.7 1.2-2-1.1-3.8-2.2-5.7-3.2l-.3.9c1.3.8 2.5 1.6 3.8 2.3 4.4 2.4 8.8 4.7 13.1 7.2 6.4 3.7 12.9 7.4 19.2 11.5 7.9 5.1 15.8 10.2 23.4 15.9 2.5 1.9 5.1 3.1 7.7 4.6 2 1.2 4 2.7 5.9 4.3 2.7 2.1 5.3 4.3 7.9 6.5 4.1 3.4 8.6 5.9 13.1 8.1 8.9 4.4 17.6 9.3 25.8 15.5 3.5 2.6 7.1 4.8 10.6 7.3 2.9 2 5.7 4.3 8.6 6.3 2.3 1.6 4.7 2.9 7 4.6 5.7 4.2 11.4 8.3 16.9 12.9 6.1 5.1 11.9 10.7 17.1 17.4 4.7 6.2 8 13.7 9.1 23 .4 3.4 1.2 6.7 1.7 10.2.3 2.2.4 4.6.1 6.9-.3 2.3-.1 4.2.7 5.9 1.3 2.4 2.6 4.8 4.2 7 1.8 2.7 3 5.7 3.1 9.5.1 4.8-1.8 8.7-4 12-1.1 1.6-3 2.3-4.7 3-4.5 1.7-9.1 3.1-13.7 1.8-1.6-.4-3.3-.4-5.1-.7-.2 2.3.9 3.6 1.6 5.1 2.3 5.1 4.9 10 7.1 15.2 2 4.9 3.7 10.2 5.5 15.3.1.3.3.7.3 1 .1 4.7 2.2 7.8 4.1 11.2 2.9 5 5.6 10.3 8.2 15.8.6 1.2.2 3.3-.2 5.2-.9-2.3-1.8-4.6-2.9-7.4-.6 2.5 0 4.4-.1 6.3-.1 1.9 0 3.9-.4 5.8-.4 2-1.2 3.9-1.6 5.3-1.7.5-3.1.7-4.3 1.4-3.5 2.2-6.8 1.1-10.2.6-2.8-.4-5.5-1.1-8.1-2.5-.2-.1-.6-.1-.7-.3-1.6-2-3.7-2.3-5.7-2.8-.9-.2-1.7-1.1-2.4-1.9-1.3-1.6-2.7-2.3-4.6-1.9-.2 2.3.8 3.3 2 4.2-.1 1.3-1.2 1.7-.9 3.3.4 2.5.3 5.3.4 7.9 0 .5 0 1 .1 1.4 1.6 4.2 3.4 8.1 6.3 10.8 1.3 1.2 3.3 2 3 5-1.2-1.1-2.3-2.2-3.7-3.5-2.2.8-.1 3-.9 4.7-1.1-2.9-3.1-2.4-4.8-1.6-5.3 2.4-10.2 1.4-15.1-.3-.8-.3-1.3-.4-2.2.4-.8.8-2 1.1-3 1.1-3.1.2-6.2.3-9.2-.7-.8-.3-1.5-1-2.2-1.5-.8-.6-1.7-1.2-2.6-1.6-1.8-.8-3.6-1.5-5.2-4 1.4.3 2.5.5 3.5.7 0-.2.1-.3.1-.5-1.8-.8-3.6-1.5-5.4-2.3-1.5-.7-3.1-1.1-4.4-2.2-3.5-3.1-7.8-2.9-11.8-4.5.1-.2.3-.5.4-.8-2.3-1.6-3.8-1.9-6.6-1.4 0 1.7.9 2.7 1.5 4 1.2 2.7 2.5 5.4 3.8 8 .3.5 1.1.6 1.2 1.1.1.5-.4 1.4-.3 2 .1.6.6 1.1 1 1.5.7.7 1.4 1.3 2.1 1.9-.7 2-1.6 2.6-2.7 1.9-1.2-.8-2-.2-2.7 1.3.1 3 1.7 4.3 2.9 6 .6.8 1.3 1.7 1.5 2.7 1.3 4.7 3.6 8.2 6.1 11.6 2.5 3.4 4.7 7.1 7.1 10.6 1.5 2.1 3.1 4 4.5 6.2 1.6 2.5 3.2 5.2 4.7 7.9.9 1.6.8 1.7.6 3.4 1 1.6 1.8 3 2.7 4.4.5.8 1 1.8 1.6 2.2 2.5 1.3 2.7 4.5 3.3 7.5.2 1.1.5 2.2.9 3.2 1 2.2 2 4.3 3.1 6.4.4.9.9 1.7 1.5 2.4 1.6 2.1 3.3 4.1 5 6.3-1.9 3.8-.4 6.9.1 10.2.2 1.6.8 3.1 1 4.7.2 2.3.7 4.2 2.3 5.2.6.4 1.3.8 1.7 1.5 1.6 2.2 3.3 3.2 5.5.6.2-.2.5-.2.8-.2.1 0 .1.2.4.5-.6.9-1.3 1.8-2.1 2.9 1.6 2.2 3.6 3.5 5.7 4.5 1.3.6 2.4 1.2 2.7 3.3.1.6.3 1.2.7 1.5 1.9 1.9 2.2 5 3 7.7.8 2.4 2.1 2.8 3.8 1.2.8-.7 1.6-1.3 3-2.3-.2 2.5-.3 4.1-.6 5.6-.3 1.7-.2 3.2.9 3.8 3.4 1.9 5.1 6.5 8 9.2.7.7 1.6 1.1 2.4 1.6.6 1 1.2 2.3 2 3.3 5.1 5.9 10.2 11.8 14.4 19 1.3 2.1 2.3 4.3 2.9 7 .5 2.4 1.3 4.6 2.1 6.9 1.7 4.8 3.4 9.5 4.6 14.6.7 3.1 1.8 5.8 4.3 7.4 4 2.6 7.6 5.9 11.4 8.8 2.4 1.8 4.9 3.3 7.2 5.3 1.3 1.1 2.2 2.7 3.3 4.1.3.4.6.9 1 1 4.6 1.9 7.6 6.8 10.9 10.9 2.1 2.6 4.5 4.9 6.3 7.9.7 1.2 1.4 2.4 1.9 3.8.8 1.9.6 4-.4 5.9-.5 1.1-.9 2.2-1.5 3.2-.5.8-1.3 1.9-1.9 2-3.7.4-7.5.6-11.2.8-.2 0-.4-.2-.8-.4 3-.7 5.7-1.3 8.4-2 1-.3 2-.7 2.8-1.4.5-.4 1.1-1.5 1.1-2.3.1-1.2-.7-2.5.6-3.4-.5-1-.8-2.4-1.4-3-.9-.9-2-1.1-1.5-3.5.2-.8-.9-2-1.4-3-3.6 2.1-4.3-2.1-6.4-4.1.7-.5 1.1-.7 2-1.3-2.7-1-5.1-1.6-6.9-4.7.9.1 1.3.2 1.8.2.5-1.5-4.7-6.1-7.7-6.5 2.1 1.7 3.8 3.1 5.9 4.8-1.5.7-2.7.6-3.4-.5-1.8-2.9-4.2-4.5-6.5-6.6-1.6-1.4-3.2-2.7-4.9-4 1-1.8 1.5.5 2.6.1-.7-1.1-1.2-2-1.8-3-1 .7-1.9 1.3-2.9 2 1.5 4.4 2.2 9.4 6.4 11-.5 3 1.4 4.1 2.5 5.9.3.5 1.3 0 2.2 0 1.1 2.3 1.3 4.8 0 7.4-2-.5-3.9-1-6.1-1.6.2 1.2.2 2 .4 2.1 1.5.9 1.5 3.1 1.9 4.8.2.7-.7 1.9-1.1 3.2-2.4-2.1-4.4-3.9-6.4-5.7-1.3 1.6-1.3 1.6-2.8.1-.4-.4-1.1-.4-1.7-.4-.5 0-1.1.4-1.5.2-1.8-.7-1.9-.7-3.4.1-2.1-1.4-4.2-2.7-6.7-1.7-1.8-1.6-4.2.9-5.9-1.6-1 2.6-.2 4.2.7 6-.4.6-.7 1.3-1.2 2.1.4 2.3.9 4.6 2.5 6.1.6.5 1 2.1.9 3.1-.3 1.8.3 2.4 1.2 3.1 4 3.2 7.8 6.7 11.9 9.7 6 4.5 12.1 8.8 18.3 13 3.3 2.2 6.8 4 9.8 7.1 1.9 1.9 4.3 2.7 6.5 4.1.7.5 1.4 1.1 2.3 1.8-1.7 1.4-2.3-.2-3.2-.6-1.1-.5-2.2-1.2-3.3-1.7-.4-.2-1.1-.2-1.2-.6-1-3-3.5-3.2-5.2-4.9-.8-.8-1.9-1.5-2.9-1.4-2 .3-3.3-1.1-4.8-2.3-1-.8-2.1-1.6-3.2-2-2.2-.8-4.4-1.2-6.7-1.8-.1 0-.2-.1-.3 0-2.7 1.3-5.3.3-7.9-.3-1.2-.3-2.5-.1-3.9-1.9.4 3 .4 5 2.4 5.6.7.2 1.2 1.5 1.8 2.3-.7.1-1.3.2-1.9.3.2-.1.4-.3.6-.4.5 1.5 1 2.9 1.6 4.4.1.2.3.2.5.3 1.7.8 3.3 1.7 5 2.5 1-3 2.6-1.7 4.1-1.9.1-1 .2-2 .4-3.2-1-1-2-2-3-3.1 1.3-.4 1.4-.5 3.2 1.6.9 1 1.4 2.4 2.1 3.8 2.5-.7 2.5-.7 3.6.3-.6 1.6-1.3 3.2-1.9 5-.5-.1-1.3-.7-1.5-.4-1.3 1.5-2.4 1-3.7.5-.9-.3-1.1.5-.7 2.4-2.1-.3-4.3-.5-6.5-.8-.2 1.2-.5 2.3-.8 4-1.9-.6-3.6-1.3-5.3-1.8-.5-.1-1.1.1-1.7.2-.4.1-.9.3-1.2.1-3.1-1.3-6.4-1.6-9.1-4.2-.7-.7-1.8-.9-2.6-1.3-.3.9-.4 2-.9 2.4-.4.4-1.2.1-1.7-.2-1.2-.7-2.2-1.7-3.4-2.4-.9-.5-1.9-.6-2.9-.7-.2 0-.5.9-.7 1.3-1.2-.6-2.4-1.3-3.8-2-1.1 3.9-3.3 1.4-4.9 2.5.3 1.9.3 1.9 3.7 5-1 .5-1.8.8-2.6 1.2.1.7.2 1.3.4 2.2-.7.1-1.4.2-2 .3.8 1.4 1.6 2.7 2.4 4.2-2 2.1-3.5-.6-5.3-.2.9 1.8 8.9 6.5 11.7 7-.3.7-.7 1.7-.9 1.6-1.9-.3-4 .5-5.7-1.7-1.1-1.4-2.9-1.7-4.3-2.6-2.9-1.8-5.8-3.2-9.2-3.6-2.2-.3-4.2-2.1-6.3-3.2-.9-.5-1.9-.8-3.1-.5.2.3.3.6.5.9.2.3.5.5 1 1.2-1.2-.3-1.9-.4-3-.6 1.1 2.2 3.4 1.3 3.8 3.8v-.1c-2.7-1.1-5.4-2.3-8.2-3.4-.4-.2-.8 0-1.3.1-.9.1-2.1.8-1.8-1.6 0-.2-.5-.5-.8-.7-1.7-.7-3.5-1.1-4.9-2.8-.4-.4-1-.7-1.5-.5-1.5.5-2.3-.6-3-2.2-.8.3-1.6.5-1.9.6-1.5-1-2.6-2-3.8-2.5-4.1-1.7-8.4-3.1-12.4-5-4.6-2.2-9.3-4-14.1-5.5-.2-.1-.5.1-1.3.3 4.1 2 7.7 3.9 11.5 5.7-.4.4-.6.7-.7.7-2.1-.8-4.2-1.5-6.3-2.3-3.2-1.3-6.4-2.7-9.7-3.9-4.2-1.5-8.4-2.9-12.7-4.3-.3-.1-.7-.1-1.1.2 2.9 2.8 6.7 3.1 10 5 0 .3-.1.5-.1.8-.4 0-.8.2-1.1.1-4.8-1.5-9.5-3-14.3-4.5-.3-.1-.9-.2-.9-.5-.5-2-1.9-1.8-3.1-2.1-1.8-.6-3.7-.9-5.3-2.3-1.3-1.1-2.6-.9-4.1.6 5.1 3.7 11.2 3.8 16.2 7.8-3.9-1.1-7.8-2.3-11.7-3.4 0 .1-.1.2-.1.3 1.1.6 2.3 1.2 3.4 1.8-.1.2-.1.4-.2.6-2.6-.3-5.2-.6-7.7-1-.4-.1-1-.1-1.2-.4-2.4-2.9-5.5-2.9-8.5-3.6l-2.7-.6c0-.3.1-.5.1-.8 1.1-.1 2.3-.2 3.4-.3v-.4c-2.8-.6-5.6-1.3-8.5-1.9-3.2-.7-6.5-1.4-9.7-2.1-.7-.2-1.5.1-1.7-1.6-.1-.6-1.4-1.1-2.1-1.2-6.2-.8-12.4-1.6-18.6-2.3-.9-.1-1.4-.8-1.5-2.1-.2-2.9-1.9-3.4-3.4-4-.7-.2-1.4-.1-2.1-.4-1.1-.5-2-1.5-3.1-1.7-1-.2-2.1.4-3.4.6.1-1.1.2-1.8.4-3-1.4-.6-2.8-1.1-4.1-1.8-.9-.4-1.7-1.1-2.6-1.4-1-.4-2.1-1-3-.6-1.2.5-2.1.3-3.1 0-2.4-.7-4.9-1.4-7.8-2.2.3 1 .4 1.7.7 1.9 3.2 2.6 5.8 6.4 9.5 7.9.4.2.8.4 1.1.8.7.9 1.1 2.1 1.9 2.7.8.6 1.8.7 2.7.9.2-.4.6-1.4.8-1.4 1.4.2 2.8.3 4.1.9 1.9.8 3.7 2 5.5 2.9.7.3 1.6.3 2.3 0 1.2-.5 2.3-.3 3.6 1-1 .2-1.7.4-2.6.6.8 1.4 2.4 2 1.7 4.4 1 1.1 1.9 2.3 3 3.3.5.5 1.3.7 1.9 1 1.4.5 2.4 1.2 2.3 3.6 0 .7.5 1.4.8 2.1.6-.2 1.1-.3 1.6-.5.7 3.1.9 6.7 3.4 8.1.5 1.9-.5 3-1.4 4.1.4 2 .7 4 1.1 6.1-1.8.9-3.1.4-4-1.9-1.1-2.6-1.1-2.6-3.2-2-.5 1.3-.9 2.7-1.4 4-.5 1.4-1 2.7-.1 4 .2.3-.2 1.3-.3 1.9-.9-2.3 0-5.1-1.5-4.6.8-1 1.4-2 .5-3.8-.2 1.5-.4 2.6-.5 3.8zM587.6 78c9.7 1.9 19.6 3.3 29.5 3.5-4.5-1.6-9.3-1.8-14-3.1 1.8-.2 3.5.1 5.3.2 1.7.1 3.5.1 5.3-.3 1.6-.4 3.3.9 4.9-1.4-3.2 2.1-5.3-.8-7.9-2.2.5-.9.9-1.5 1.5-2.5-2.4-.6-4.5-1.2-6.7-1.5-6-.7-12-1.6-18.2-.7-4.1.6-8.1.1-12.2-.2-2.8-.2-4.9 1.9-7.1 4.2 1.8.7 3.5 1 5.3 1.2l23.7 2.4c.2 0 .4.3.7.4 0 .1-.1.3-.1.4-3.4 0-6.7-.2-10-.4zm-.8 688.9c0-1.6-.5-2.4-1.5-2.5-.9-.1-1.8-.3-2.6-.1-2 .3-3.9.5-5.8-.3-.9-.4-2-.3-3.1 1.1.8.5 1.4.9 2.1 1.2 5.1 2.1 10.2 4.3 15.4 6.3 3.4 1.4 6.9 2.6 10.3 3.9 2.3.8 4.6 2 7-1.4.8 2.6 2 2.7 3.7 1.6 1.1-.7 2.5-.5 4-.7.2-.5.4-1.3.8-2.5-1.1 0-2 0-2.5.1-.7-.9-1.2-1.7-1.8-2.2-2.3-1.8-4.6-3.6-7.4-4-1.4-.2-2.8-.3-4.2-.2-1.4 0-2.7.3-4.2.5.2.8.3 1.3.4 1.7-1.7-1.5-3.4-1.7-5.4-1.2-2 .5-4.1.4-6.1.6-.2 0-.3-.5-.5-.7.5-.5.9-.8 1.4-1.2zm289.9-234.5c2.1.5 3.4-.6 4.6-3.4-1.8.4-3.3.9-4.8 1-1.6.1-3.2-.1-4.7-.1-1.3 0-2.7.1-4 .4-.8.2-1.6.7-2.7 1.1 2.9 2.5 9.1 3.8 12 2.8-.1-.4-.2-1-.4-1.8zm-435.6-473c.7 1.9 1.7 2.3 2.9 2.3 2.2-.1 4.4 0 6.7 0 2.7 0 5.3-.7 7.8-2.4-3.1 0-6.4 1.6-9.3-.4.6-.1 1.1-.2 1.7-.4-3.2-.4-6.4-1.9-9.8.9zm316.1 774.2c.9.6 1.1.8 1.3.9 2.5.3 5.3-.8 6.9 2.9.1.3.6.1 1 .2.3 0 .7-.1.7.1.6 2.4 1.8 2.3 3.4 1.6.5-.2 1.2.2 1.8.3.4.1.9 0 1.7.1-1-1.5-1.8-2.7-2.5-3.8-.6-.6-1.5-.5-2.3-.5-.6 0-1.3.2-1.8-.2-2.4-1.9-5.2-2.1-8-2.7-.5 0-1.1.6-2.2 1.1zM620 78.3c4 1.8 11.6 1.8 13.3.1-6.4-1.5-11.2-1.6-13.3-.1zm68 19c4.4 3.5 5.6 3.9 8.9 3-3.3-1-6.1-2-8.9-3zm66.9 738.9c-.4 2 .5 2.1 1.4 2.5 1.4.5 2.7.6 4.4-.5-2-1.6-3.8-2.3-5.8-2zm-144 107c-1.4-3.4-2.9-4.4-5.4-3.7 1.5 1.9 3.4 2.6 5.4 3.7zM164.5 226c2.1-2 3-4.2 3.6-6.9-1.9 1.5-3.3 3.2-3.6 6.9zm671.2-32.8c.1-.3.3-.6.4-1-1.4-2-3.4-2.3-5.1-3.3-.1.2-.2.5-.3.7 1.7 1.2 3.4 2.4 5 3.6zm-90 636.9c.1 1.1 0 1.9.3 2.3 1 1.2 2 2.6 4.2 2.2l-4.5-4.5zm-64.3 73.3c.2-.2.4-.4.7-.6-.3-1.1-.5-2.3-.8-3.7-.9.7-1.6 1.1-2.5 1.8 1 1.1 1.8 1.8 2.6 2.5zm55.2-75.1c1.5 2.2 3.2 1.5 4.9 1.6-.6-2.1-.9-2.2-4.9-1.6zm-33.4 11c1.1 1.5 1.2 3.8 3.2 2.8-1.2-.5-.7-3.7-3.2-2.8zm46.6-6.9c.2-.2.3-.5.5-.7-.6-.6-1.2-1.1-1.8-1.7l-.3.6c.5.5 1.1 1.2 1.6 1.8zm116.1 33.4c-.1.2-.3.4-.4.6.3.5.6 1 1 1.4.1.1.4-.2.9-.4-.6-.7-1-1.1-1.5-1.6zm-226.1-786c0 .3-.1.7-.1 1 .7-.1 1.5-.1 2.2-.2V80c-.7 0-1.4-.1-2.1-.2zm-30 699.8c1.1 1.3 1.1 1.3 2.7.1-1.1 0-1.9 0-2.7-.1zM795 165.8c-.2-1.8-.2-1.8-1.8-2.7l1.8 2.7zm-69.2 662.5c0-.3.1-.6.1-.9h-1.3c0 .2 0 .3-.1.5.5.2.9.3 1.3.4zm-5.2 72.6c-.1.1-.3.2-.4.3.1.5.3.9.4 1.4l.4-.2c-.2-.6-.3-1-.4-1.5z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape33($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M683.8 94.3h222v222h-222zM99.4 595.9h304.9v304.9H99.4z"/>',
            $gradID);
        }
        $mask = '<path d="M53.5 46.1h441.2v441.2H53.5zm458.7 458.7h441.2V946H512.2zm0-380.3h362.7v362.7H512.2zM131.3 505.4H494v362.7H131.3z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape34($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" id="alexandru-zdrobau-juESZxMhtXk-unsplash" class="st0" d="M814.3 178.8c-1.6 0-3.5-.4-4.4 1.5v.4-.4c-3.1-.4-3.1 0-3.8.4-1.3 0-2.8-.7-3.8 1.5-.6-1.5-.6-1.5-1.6-.7s-1.6 1.1-1.9-.4c0-.4-.6-.4-.9-.7-1.4-.4-2.8-.3-4.1.4h-.3c-.9.4-1.6-.4-2.2-.4-1.3-.4-2.5-.4-3.8-.7-.9 0-.9-.4-.3-1.1.6-.7 2.2-.7 2.5-2.2-2.1.3-4.2.8-6.3 1.5-3.8 1.1-7.4 2.6-11 4.4-.9.4-2.2.7-3.1 1.1-.6.4-.9 0-.6-.7.6-.4.9-.7 1.6-.7.9 0 .9-.7.6-1.1 0-1.8-3.5.4-2.8-1.8h-.6c-.6.4-.9.7-1.6.7-1.2.8-2.7 1.1-4.1.7h.3c.9-.4 1.6-.7 1.6-1.5-1.3.4-2.2-.4-3.1.7-.9.4-2.2.7-3.1 1.1h-.9c-.6-.4-1.9.4-2.2-.4-.3.5-.8.7-1.3.7-1.7-.3-3.4.2-4.7 1.5-4.1 1.5-8.2 2.2-12.2 3.7-2.5 1.1-5.2 1.9-7.8 2.2-5.6 1-11 2.6-16.3 4.8-1.6.4-2.8 1.1-4.4 1.5-.3 0-.6.4-1.3.4-2.2-.4-4.5 0-6.6 1.1-1.2.7-2.5 1.1-3.8 1.5-4.1.7-8.2 2.6-12.2 3.7l-3.8 1.1c-2.4 1-4.8 1.7-7.2 2.2h-.6c-1.3 0-2.8.7-3.5-.7-.2-.6-.9-.9-1.4-.6-.2.1-.4.3-.5.6-.3.7-1.3 1.1-2.2 1.5 0-.4-.3-.4-.3-.7.8-2.3 2.9-3.7 5-3.3.8.2 1.7.1 2.5-.4-.3.4-.3 1.1-.9 1.1-.3 0-.9 0-.6.4 0 .4.6.4.6.4 1.3-.7 3.1-1.1 3.8-2.6.3-.7.3-1.1 1.3-1.1.6 0 .9-.4 1.3-1.1.9-.7 1.9-.4 2.8-.7 1.6 0 1.9-1.5 2.2-1.8.6-1.1-1.3-.4-1.6-1.1 1.9-.7 3.8-.4 5.6-1.1.6.4 1.3.4 1.9.7.9 0 1.9.7 2.5 0 .9-1.5 2.5-1.1 3.8-1.5.3 0 .3-.4.6-.4 1.9.4 2.8-1.8 4.7-1.5.3 0 .3-.7-.3-1.1-.6-.5-1.5-.6-2.2-.4 0-.4-.3-.4-.3-.7.8-1.1 1.9-1.7 3.1-1.5.9.7 1.9.4 2.8.4h2.2c0 1.1-1.3 1.1-1.6 2.2 1 .3 2-.2 2.5-1.1.3-.7.3-1.5 1.6-1.8.3.7 0 2.2 1.6 1.8 1.6-.4 3.5-.7 3.1-2.9.6.4 1.3 1.1 1.6 0 .3-1.1.9-1.5 1.9-.4.3.4.9 0 .6-.4-.9-1.5.9-.7 1.3-1.5.3 0 .9-.4 1.3-.4.6.7 1.3.4 1.9 0 1.6-.4 2.8-1.1 4.4-1.5 1.3-.4 2.2-1.1 1.9-2.2-.3-1.1-1.6-.7-2.5-.4-.2 0-.3.2-.3.4-.6-1.1-1.9 0-2.5-.7-1.3-1.5-2.2-.4-2.5.7-.6.7-1.4 1.2-2.2 1.5-.9 0-1.7.3-2.5.7-2 .8-4.2 1-6.3.7.3-.4.6-.4 1.3-.7 5-1.8 9.7-4 14.8-5.9 2.7-.9 5.3-2.1 7.8-3.3.3 0 .6-.4.9-.4 3.8-.7 6.6-3.7 10.4-4.8.3 0 .9-.7.6-1.1-1.9-.4-1.3-1.5-.6-2.9.3-.7 0-1.1-.6-1.8-1.3-.7-2.2.4-3.5.4-.2 0-.3-.2-.3-.4.3-1.5-1.6-.4-1.6-1.1.6-.4.9-.4 1.3-1.1.3-.4.3-.4.3-.7.9-1.1 1.9-2.2 1.3-3.7 1.9-2.2 4.4-3.7 6-5.9.3-.7 1.3-1.1 2.2-1.5 2.2-.4 4.1-1.8 5.3-3.9.3-.4.9-.7 1.3-1.5 2.5-2.4 4.8-5.1 6.9-8.1.6-.7.9-1.5 1.6-2.2.9-1.1 1.3-1.5 0-2.2-1.3-.7-1.3-1.5.3-2.2.6-.4 1.6-.7.9-1.5-.9-1.8-1.3-1.8-2.8 0-.6-1.1.3-2.6-.3-3.7-1.3-2.6.3-5.5-.3-8.1-.3-1.1-.6-1.5-1.9-1.1-.5.3-1.2.2-1.6-.4-.6-.4 0-.7.3-1.1 1.6-1.1 1.9-2.2 0-2.9-.7-.4-.9-1.4-.6-2.2.3-1.1-.3-1.1-1.3-.7-.7.2-1.5.4-2.2.7-1.6.7-3.3 1.1-5 1.5-1.8.3-3.6.8-5.3 1.5-2.6 1.5-5.3 2.5-8.2 2.9.3-.4-1.6.4-.6-.7l.9-1.1c.8-1.6 2.2-2.7 3.8-2.9 3.1-.7 6-2.2 9.1-3.3 1.9-.7 3.5-4 2.2-4.8-1.6-.7-.9-1.5-.6-2.6.3-.7.9-1.1.6-1.8-.9-1.8.6-2.6 2.2-3.3.9-.4 1.3-.7.9-1.8-.3-1.8-1.6-2.9-4.1-2.6 2.1-.9 3.2-3.7 2.4-6.2 0-.2-.1-.3-.2-.4-.3-1.1-.6-2.2-2.5-1.1-.6.2-1.3-.1-1.6-.7 0-.7.6-.7 1.3-.7.9 0 1.9 0 1.6-1.5-.3-.7.6-1.1 1.3-1.5.6-.4 1.6-1.1.9-1.8s-1.6-.4-2.2 0c-.6-.1-1.3.1-1.9.4-.3-.4-.9-.4-1.3-.7-1.3-1.1-3.1-1.5-3.8-3.3h.3c1.9-.7 4.1 0 5.6-1.5 1.3-1.1 3.5-1.1 4.4-2.9.3-.3.6-.4.9-.4.9 0 1.9.4.9-1.1.2-.4.4-.8.6-1.1.9-.7 1.9 0 3.1-1.1.3-.4.3 1.1 1.3 1.1.3-1.8 2.2-1.5 3.1-2.2 1-.6 2.1-.8 3.1-.4 1.9 0 2.5-1.8 3.5-2.6.6-.4 0-1.1-.3-1.5-.3-.4-.6-.4-1.3 0-.9.4-1.3 1.1-2.5 1.5a5.9 5.9 0 0 1 3.8-2.6c.6 0 1.3-.4.9-1.1 0-.7-.6-.7-1.3-.4-.3.4-.9.7-1.3 0v-.4c.6-.4 1.6-.4 1.6-1.1s-.9-.7-1.6-.4c-.4 0-.9-.1-1.3-.4-.9 1.1-2.5.7-3.5 1.5-1.9 1-3.9 1.5-6 1.5-.9.4-2.5 1.5-3.8.4l-.6.4c-.3 1.5-2.5 1.8-2.8 3.3-.1.4-.4.6-.7.5-.1 0-.1-.1-.2-.1-.3-1.5-1.6-.7-2.5-.4-.9 0-2.5 1.5-2.8-.4 0-.4-.3 0-.6 0-.9.4-1.3 0-1.9 0-.9 0-1.9-2.2-2.8 0 0 .4-.6.4-.9.4-1.3-.2-2.5-.2-3.8 0-3.6.2-7.1 1.2-10.4 2.9-1.6.2-3.2.6-4.7 1.1h-.6c-3.2.3-6.4 1.2-9.4 2.6.6-.7 1.9-1.1 1.6-2.2 1.3-.7 3.1 0 3.8-1.8.3-.7.6.7 1.3 0-.3-2.2-.3-2.2-3.1-1.1-.9.3-1.8.8-2.5 1.5-2.2 0-4.4 1.5-6.6 1.5-.3 0-.6.3-.6.7-.4.7-.9 1.2-1.6 1.5-3 1-6 2.3-8.8 4h-.3c-4.7 2.6-9.7 4-14.4 6.2-4.7 1.8-9.4 4-14.1 6.2-.9.4-1.9 1.1-2.8.7-1.8-.1-3.5.4-5 1.5-2.5 1.4-5 2.6-7.5 3.7-2.3.7-4.7 1.5-6.9 2.6-.6 0-.6.4-.6.7-.9.3-1.7.7-2.5 1.1-6 2.6-12.2 5.1-18.2 7.7-.6-.7 2.2-1.8.3-2.6-.9-.4-1.3-.4-1.9.4-.9 0-.6-1.1-1.6-1.1.3-.7.9-.7 1.6-.7 1.7-.4 3.3-1.2 4.7-2.2.6-.4 2.2-1.5 2.5-.7.6 1.1 1.3.4 1.6 0 2.4-1.7 4.9-3.1 7.5-4 .9 0 1.9-.4 2.5.4-.9-1.5-.6-1.8 1.3-2.2s3.1-2.6 5.3-2.6c.7 0 1.3-.3 1.9-.7 1.9-2.2 5.3-1.8 7.2-4h.3c.6 0 .9 0 .9-.4s-.3-.7-.6-.7c-1.6-.4-2.2.7-2.8 1.8-.6-.4-1.6-.7 0-1.5.3 0 .3-.4.3-.7.6-.7 1.3-1.8 2.8-1.5.8-.1 1.5-.4 2.2-.7.6 0 .9-.4 1.6-.4.6.4 1.6-.4 1.9.4.3.7-.9.7-1.3 1.5-.3.4-.9.4-.9.7 2.8 0 2.8 0 3.5-2.2.3-1.1.9-1.1 1.3-.4.9 1.5 2.2.7 3.5 0 1.6-1.1 2.2-2.9 4.4-3.3.3-.7 1.3-1.1 1.9-1.5 2.9-.3 5.6-1.6 7.8-3.7.9-.7.6-1.5-.6-1.8-.6-.1-1.3.1-1.9.4-.9 0-2.2.7-3.1.4-1.9-1.1-2.2 0-2.5 1.1-.3.7 0 1.5-1.3 1.5-1.4.1-2.8.6-4.1 1.5-1.5.7-3.1 1.2-4.7 1.5-1.3-1.5-1.9.4-2.8.7-.6 0-.6 1.5-.9 1.8-1.3 1.1-.3-.7-1.6-.7-2.3.4-4.5 1.6-6.3 3.3v.4l-.6.7c-.3 0-.3 0-.6-.4s.3-1.1-.6-1.1c-.6 0-.9.7-1.3 1.1-.3.7-.3 1.5-1.3 1.5-.3-.4-.9-1.1-1.6-.4-1.6 1.5-4.7 1.5-5.3 4-.3-.4-.3-.7-.6-.7-.9.4-2.5 0-2.2 1.8 0 .4-.6.4-.6.4h-1.4c-2.2.9-4.6 1.3-6.9 1.1-.6.4-1.9 0-1.6 1.5.3 1.8-.3 2.6-2.5 2.2-.7-.1-1.5.1-2.2.4-1.6 0-3.5-1.1-3.8 1.5h-.3c-1.9.4-3.5 1.1-5.3 1.5-.6 0-.9-.7-1.6 0-.6.7.6.7.6 1.5-.5.1-1.1.2-1.6.4-.9-.4-1.3-.4-.9.4 0 1.1-.6 1.8-1.3 2.9-.9-.4-.3-1.1-.6-1.5s-.3-1.1-1.3-1.1c-.6 0-.6.7-.9 1.1-.3 1.1-.9 1.1-1.6.7-2.2-.7-3.1-.4-3.8 1.8-.9.7-1.3 1.8 0 1.8 2.2 0 .9.7.3 1.5-1.3 0-1.9-.4-1.9-1.5s-.6-1.5-1.6-1.8c-.6 0-1.6.4-1.3.7.6 1.1-.6 1.1-.9 1.8-2.2.7-4.4 1.2-6.6 1.5-.5-.4-1.1-.4-1.6 0-.6.4-2.2.4-1.6 1.1.9 1.8-.9 1.1-1.6 1.5-.6 0-1.3.4-1.9 0-1.3-.4-2.8 0-3.8 1.1-1.2 1.9-3 3.1-5 3.3-.3.7-.3 1.5.6 1.1 2.5-.7 2.2 1.1 2.8 2.2-.9.4-2.5 1.5-2.8.7-.6-1.5-3.1-.7-3.8-2.6-.3-1.1-1.6-1.5-2.8 0-1 .6-2 1.1-3.1 1.5-2.5.4-4.4 1.8-6.9 2.2-.2 0-.5-.2-.6-.4l-1.9 1.1c-.9 1.1-2.8.7-3.5 1.8 0 .7-.9 1.1-1.6 1.1-1.3 0-3.1-.7-3.5 1.5-.3.4-.8.6-1.3.7-2.2 1.1-2.5 1.5-.6 2.6 0 .4 0 .7-.3.7-.2 0-.3.2-.3.4-.3-.4-.6-.7-.9-.7-.9-.4-1.9-.4-2.8 0-1.6.7-3.1 1.1-4.7 1.8h-.6c-.6 0-1.1.3-1.6.7-.7.1-1.3.3-1.9.7-.3 0-.6.4-.9.4l-4.4 1.1c-4.7 2.2-10 2.9-14.8 5.5-1.1.7-2.4.7-3.5 0-.2 0-.3-.2-.3-.4 0-.4 0-.4-.3-.7-1.9-.4-.6-.7 0-1.5.3 0 .3 0 .6-.4.6 0 .9-.4 1.6-.4.6-.4 1.6-.4 2.2-.7h.3c.9-.4 1.9-.4 2.5-.7 1-.1 1.9.1 2.8.4h1.9c.9-.4 2.2-.4 3.1-.7 2.6-1.4 5.4-2.7 8.2-3.7.9.4 1.3-.7 1.9-1.1.3-.4.6-.4.9-.7.8-.3 1.6-.8 2.2-1.5 1.3-1.1 2.6-1.9 4.1-2.6h.9c.7.7 1.8.7 2.5 0 .5-.3 1-.6 1.6-.7 2.2.4 2.8-.7 3.1-2.2h.6c2.5.1 4.9-.8 6.9-2.6h.3c2.9-.4 5.7-1.7 8.2-3.7.4-.5 1-.7 1.6-.7.3 0 .9-.4 1.3-.4 1.3-.7 2.2-1.5 3.5-1.1.6-.4 1.3-.4 1.3-1.1 0-.7-.9 0-1.3-.4-.6-.4-1.3-.4-.9-1.1 1.3-.7 2.8-1.1 4.1-1.8.6 0 .9.4 1.6.4.3 1.8 1.9.7 2.8.4 2.2-.7 4.4-1.8 6.6-2.6.3 0 .9-.4.9-.7-.3-.7-.9-.7-1.9-.7-.3 0-.6.4-.6 0 .3 0 .3 0 .6-.4s1.3-1.1 1.3-1.8c0-.4-.9-.4-1.6 0-1.9 1.1-4.4 1.8-6.3 2.9-.6 0-1.3.4-1.3-.4.6-.7.9-.7 1.9-.4.5 0 1-.3 1.3-.7 0-.4.3-.7 0-.7-.4-.4-.9-.4-1.3 0-3.5 1.5-6.9 2.6-10.4 4.4-.6.4-1.6.4-2.2.7-.6 0-.9.4-1.6.4-1.9 1.1-4.1 1.1-5.6 2.6-.9.4-1.9.4-2.8.7-1.4.9-2.9 1.4-4.4 1.5-1.1.1-2.2.5-3.1 1.1-.3 0-.6.4-1.3.4h-.9c-.3 0-.6.3-.6.7l-.6.7c-.9.7-2.8 0-2.2 2.2 0 .7 1.3.4 1.6.7l-.3.4c-.5.3-1 .4-1.6.4-.6-.7-1.3-2.2-2.5-1.5l-6.6 2.2c-.6.4-1.6.4-1.9 1.1 0 .4-.6.4-.9.4-1-.5-2.1-.2-2.8.7-2.4 1.9-5.1 3.2-7.8 4-.9.4-1.6-.4-2.5.4-.9 1.1-1.3.4-1.3-.4 0-.4.3-1.1-.6-1.1 0 0-.6 0-.6.4s-.6 1.1 0 1.5c.3.4.6.7 0 1.1-2.3 1.4-4.7 2.3-7.2 2.9-.9 0-1.9.4-2.2-.7 0-.7-.6-.4-1.3 0-.6.4-1.9.4-1.9 1.1 0 .7.9.4 1.3.4.3.4 1.6-.4 1.3.7-.9.7-2.2.7-3.1 1.5-1.9.7-3.8 1.8-5.6 2.6-2.8.4-3.1 0-3.5-2.2 0-.4-.3-.4-.9-.4-.6.4-1.3.4-1.6.7l-2.8 1.1c-.6.7-.6 1.5.6 1.5h3.5c-1.3 1.1-3.1 1.1-3.8 2.2-1.9 0-2.2 1.5-3.1 2.6-.2.3-.6.4-.8.1l-.1-.1c-.9-.7-.6-2.2-1.9-2.6-.6 0-1.3-1.1-1.9-.7-.9.7.3 1.5.3 1.8 0 .4.3.7.6 1.1.3 1.1-.3 1.8-1.6 2.2-1.6.7-3.1 1.1-4.7 1.8-2.2.9-4.6 1.4-6.9 1.5 1.6-1.1 1.9-1.5 1.3-1.8-.9-.4-1.6.4-2.2.7-.6.7-.6 1.1 0 1.5-2.2.7-4.4 1.2-6.6 1.5-1.4.8-2.9 1.3-4.4 1.5-1.3 0-1.9 0-.6-1.5-.5-.1-1.1 0-1.6.4-1.3 1.1-2.8.7-4.1 1.5-.9.4-.9 2.6-2.8 1.5l-.3.4c-.3 1.1-.9 1.1-1.6.4-.3-.4-.3-.4-.6 0-1.5 1-3.3 1.6-5 1.5-.6 0-1.6.4-.6 1.1 1.3.7 1.6 1.8 3.1 2.2l.3.4c-1.6 1.5-3.7 2.1-5.6 1.5-1.4-.8-3.1-.7-4.4.4-.3.4-1.3.7-1.6.4-1.9-1.1-3.5.4-5 1.5-.6.4-1.3 1.5-2.2.4-.5-.3-1.2-.1-1.6.4-1.7 1.9-3.9 3.2-6.3 3.7-.7-.4-1.5-.1-1.9.7-.3.7.3 1.1.9 1.8.3.7.9.4 1.6.4 1-.5 2.1-.6 3.1-.4-1.3.7-2.5 1.5-.9 2.6.6.4 0 1.1-.6 1.5-.6.4-1.6.7-2.2 1.1-1.1.5-2.3.9-3.5 1.1.3-.7 1.3-1.1 0-1.5-1.3-.7-.3-1.1.6-1.1.6 0 .9.4 1.6.4.3 0 .6.4.9.4.3-.4 0-.7 0-1.1 0-1.8-1.6-2.6-2.8-3.7-.6-.4-1.4-.3-1.9.4-.9.7-1.8 1.2-2.8 1.5-1.6.7-3.1 0-4.7 1.5-.6.6-1.2 1.1-1.9 1.5-1.3.7-3.1.7-4.1 1.5-2.7 1.8-5.5 3.3-8.5 4.4-2.5.7-5 1.8-7.5 2.6-2.9.7-5.6 1.9-8.2 3.7-2 1.2-4.1 2-6.3 2.6-1.6.4-2.9 1.6-3.5 3.3-.6 2.6-1.6 1.1-2.5.7-.6-.4-1.6-1.1-1.9-.7-1.3 1.5-3.1 1.5-4.7 2.2-1.6 1.2-3.4 1.8-5.3 1.8-1.9-.4-1.6.7-1.9 1.5-.6 1.1.3 1.5 1.3 1.5.3 0 .9-.4.9.4-.3.4-.9.4-1.3.7-.3.4-.3.4-.3.7.2.3.6.4.8.1l.1-.1c1.3-1.5 2.8-1.1 4.4-1.5.9-.7 2.2-.7 3.1-1.5s.9 0 .6.7c-1.9 1.1-1.9 1.1 0 1.8v.4h-.5c-.6 0-.6.4-1.3.7-.9 0-1.6.7-2.2.7-1.3.4-2.2.7-3.5 1.1-.6.4-1.6.7-1.9.4-.6-.7-1.3-.4-2.2 0-.6.4-1.6.4-2.5.7.3-1.1 2.2-2.2 0-2.2h-3.5c-1.9.7-3.8.4-5.3 1.5-1.7 1-3.5 1.7-5.3 2.2-.3 0-.6.4-.9.4-1.9.7-3.5 2.6-5.6 2.2-.6 0-1.9.4-2.2 1.5-.6 1.1.6 1.1 1.3 1.5.9.7-.6.7-.3 1.1-1.9.7-.3 2.2-.9 3.3v.7c-.3 1.1-1.6 1.5-2.2 2.2-3.1.8-6.1 2.2-8.8 4-5.3 3.3-11.3 5.1-17 8.4-2.8 1.5-6 2.9-8.8 4.4-.8.4-1.7.8-2.5 1.1-2.4 1.2-4.9 2.1-7.5 2.6h-.3c-2.9 2.2-6.1 3.8-9.4 4.8-2.7.6-5.3 1.9-7.5 3.7-.6.6-1.4.9-2.2.7-3.2.6-6.3 1.8-9.1 3.7l-6.6 3.3c-.5.4-1.1.4-1.6 0-.9-.4-1.3 0-1.9.7-1.2 2.3-3.4 3.6-5.6 3.3-.8 0-1.5.3-2.2.7-.9 1-2.2 1.7-3.5 1.8-3.7.3-7.4 1.6-10.7 3.7-3.1 1.5-3.8 1.5-4.4-1.5 0-.4 0-1.1-.9-.7-.7 0-1.3.4-1.6 1.1-.3 1.1 0 1.8.9 2.6.9.7.6 1.1-.3 1.8-2.9 1.3-5.8 2.4-8.8 3.3-1.3.4-.6-.4-.3-1.1.6-1.5.3-1.8-1.3-1.8-.7.2-1.5.2-2.2 0-2.5-.7-1.6 1.5-2.2 2.2-.6 1.1 0 1.5.9 1.5 1.6.4 2.2 1.1.9 1.8-2 1.7-4.1 3.2-6.3 4.4-2.2 1.1-4.7.7-6.6 2.6-.3.4-1.6 1.1-2.2.7-1.8-.7-3.8-.7-5.6 0-2.8 1.1-5.8 1.5-8.8 1.5-.6 0-1.9 0-1.3 1.1.3.4-.6 1.1-1.6 1.1-2.2-.4-2.2-.4-2.5 1.8 0 .4.3 1.1-.6 1.5-.6.4-.9-.4-1.3-.7-.6-.7-1.6-2.2-2.2.4 0 .4-.3.4-.6.4-1.8-.1-3.6.5-5 1.8-2.2 1.6-4.5 2.9-6.9 
                                    4-1.9.7-3.8 1.1-5.6 1.8-2.6.9-5.1 2.1-7.5 3.3-3.8 1.9-7.7 3.5-11.6 4.8-4.3 1.7-8.4 4.1-12.2 7-1.6.6-3.1 1.7-4.1 3.3-1.5.9-2.7 2.2-3.8 3.7-1.8 2.8-4.6 4.5-7.5 4.8-1.6 0-3.1 1.2-3.8 2.9-.8 1.5-1.7 2.9-2.8 4-1.6 1.3-3 2.9-4.1 4.8-.4.8-1.1 1.3-1.9 1.5-.6 0-1.2.5-1.6 1.1-1.6 3.3-3.6 6.2-6 8.8-.6.7-.3 1.5.3 1.8 1.3 1.1 1.3 1.8-.6 2.6-1.9 1.1-2.2 1.5-.9 2.9.3.4.6 1.1.9 1.5.3.4.3.7 1.3.4 1.6 0 1.6-1.5 2.5-2.6-.2 2.7.1 5.5.9 8.1.9 2.6-1.6 5.9.3 8.4-.6 2.2.3 3 2.8 2.2.6-.3 1.4-.2 1.9.4.3.4 0 .7-.3 1.5l-.9 1.1c-1.6 1.5-1.6 2.2 0 2.9 1.9.7 1.6 2.2 1.9 3.3.6 1.8.3 2.2 2.5 1.1 2.8-1.1 5.6-2.1 8.5-2.9 2.4-.3 4.8-.8 7.2-1.5-2.2 3.1-4.6 5.9-7.2 8.4-.9.7-.3 1.1.3 1.8 1.6 1.8 1.3 2.6-1.6 3.3-.3 0-1.3 0-.9.7-.2 1.6.6 3.1 1.9 3.7 1.3.4 1.6-1.1 2.5-1.5.6 1.8-.9 3.3-.3 5.1.6 1.9.6 4 0 5.9-.9 1.4-1 3.2-.3 4.8.3.4 0 1.1-.3 1.5-.3.4-.6 1.1 0 1.5.6.4.9 1.1 1.9.4.5-.4 1.1-.4 1.6 0 1.3.7 1.3 1.5-.9 2.9-1.9 1.1-1.6 2.2-.3 2.9 1.6 1.1 1.3 2.6.9 4-.3 1.5.6 1.5 1.6 1.5 1.3-.4 2.2-.4 3.5-.7 2.2-1.1 4.7-.4 6.6-1.5 4.4.2 8.8-.7 12.9-2.6 2.2-1 4.5-1.6 6.9-1.8 1.6.2 3.2-.5 4.4-1.8.7-.7 1.6-1.1 2.5-1.1 2-.1 4-.3 6-.7 1.6-.1 3.2-.9 4.4-2.2 1-1.6 2.7-2.3 4.4-1.8 1.4.3 2.8.1 4.1-.4.6 0 1.3-1.1 1.9-.7 2.7.6 5.4.2 7.8-1.1 1.9-1.1 3.5 0 5-.4 3.1 0 6.3-.7 9.1-.7 1.8 0 3.5-.5 5-1.5 2-1 4.1-1.7 6.3-1.8.3 0 .6 0 .6.4.9 1.1 2.2.7 3.5 0 2.5-.8 5-1.3 7.5-1.5 2.6-.6 5.2-.9 7.8-.7.9 0 .9-.7.9-1.5 0-1.1-.6-.4-1.3-.4-1.5.2-3.1-.1-4.4-1.1 1.5-.7 3.1-1.1 4.7-1.1.8 0 1.5-.4 1.9-1.1.8-1.4 2-2.3 3.5-2.6.3 0 .9 0 .9.4s-.3 1.1-.6 1.1c-2.2.4-2.2 1.8-2.8 2.9-.7 1.1-.6 1.8 1.3 1.8 1.3 0 2.2 1.5 3.5.7 2.2-1.5 4.4-.4 6.6-.7-.6.4-1.6.7-2.2 1.1-.3 0-.9.4-.6.7.9 1.1-.6 1.5-.9 1.8-1.9 1.5-4.4 1.1-6.3 1.8-5.2 1.7-10.4 3.8-15.4 6.2-7.8 4-15.7 8.4-23.9 12.5-3.1 1.5-6 2.9-9.1 4.8-1.6.6-3.1 1.6-4.4 2.9-.6.4-.9.4-1.6.7-4.1 1.7-8.1 3.8-11.9 6.2-5.7 2.6-11.2 5.9-16.3 9.9-6.6 3.8-12.6 8.8-17.9 14.7-.9 1.2-2 2.2-3.1 2.9-2.2 1.8-4.7 3.3-5 6.2-.7.4-1.3.9-1.9 1.5-.9 1.1-1.6 1.8-1.3 2.9-.3.4-.3.4 0 .7h.3l.3.4v.7c-.3.7-.3 1.1.6 1.1.6 0 .6.4.6.7.6 2.6 2.5 3.3 5.3 2.9.6 0 1.3-.4 1.9.4.3.4 1.3 0 1.9 0 3.5-.1 6.9-.6 10.4-1.5 2.2-.7 4.4-1.1 6.3-1.8 4.1-1.1 8.2-.7 12.6-1.5-.9.7-1.3 1.5-.9 2.2-.4 1.6-1.7 2.7-3.1 2.6-2.2-.4-2.5.7-2.5 2.2 0 .7 0 1.5.9 1.8.6 0 .6.7.3 1.1-1.3 1.5 1.6 2.9-.6 4.8 1.6 1.1-.3 2.9.6 4.4.5.6.6 1.6.1 2.2-.1.1-.2.3-.4.4-1 .7-2.2.7-3.1 0-.8-.7-1.9-1-2.8-.7 1.9 1.1 3.8 2.2 3.5 4.4 0 .7.6.7.9 1.1.3.4.9.4.9.7.5 2.3 1.1 4.5 1.9 6.6-.3.4 0 .7 0 1.1-3.5 1.1-6.9 1.8-10.4 2.9-5 1.5-9.7 4-15.1 5.1-3.9.8-7.7 2.1-11.3 4-1.3 1-2.6 1.7-4.1 2.2-7.5 2.2-15.1 4-22.3 6.6-8.6 3.1-16.7 7.7-24.2 13.6-1.8.4-3.6.4-5.3 0-1.2-.3-2.4-.2-3.5.4-.9.4-1.6 1.5 0 2.2.6.4 1.6.7 1.3 1.5-.6 2.2.9 2.2 2.2 2.6-.6 1.1-2.2 1.1-2.8 2.2-1.3.4-1.3 1.8-.3 1.8 1.9 0 3.5 1.8 5.3 1.5 2.2-.9 4.6-1.3 6.9-1.1.6 0 1.3 0 1.6.7 2.2 2.9 2.8 3.3 6 2.6 2.5-.7 4.4-2.6 6.9-3.3.9.2 1.8-.1 2.5-.7 2.5-1 5-1.7 7.5-2.2-1.9 1.8-3.1 4-5 3.7-1.3-.3-2.7.1-3.8 1.1l-7.5 4.4c-.9-.7-1.6-1.1-1.9.4-.3 1.5-1.3 2.2-2.5 2.9-.9.7-3.1.4-2.5 2.9-.3 0-.3 0-.6-.4 0-.7-.3-1.5-1.3-1.1.3-1.1.3-2.2-1.3-1.1-1.3.7-2.5 1.8-3.5-1.1-.3 1.5.6 2.9.3 4v.7c.3 1.8-.9 2.6-2.8 2.6.9-.4 1.9-.7 1.3-2.2-.6-1.5-1.6-.4-2.5-.4-.6 0-.9.4-1.3 1.1-1.9.4-3.8.7-4.7 2.9-.6 1.1-2.2.4-2.5 1.5-1.7.7-3.5 1.2-5.3 1.5l.3 1.8c-.3.4 0 .7 0 1.1-.3.4-.6.7-.9.7-.9.4-1.6.7-1.3 1.8.5.8 1.4 1.1 2.2.7 1.6-.4 2.8-1.1 4.4-1.5.7-.2 1.5 0 2.2.4.3-2.2 1.6-.4 2.5-.4.6-1.5-.6-1.8-.9-2.6.7.1 1.5-.1 2.2-.4 2.8-1.6 6-2.4 9.1-2.2.9.4 0 2.2 1.6 2.2 1.3 0-.3-1.5.9-1.5.6 1.2 1.7 1.9 2.8 1.8 0 .4-.9.7-.6 1.5.3.4.9 0 1.3 0 1.3-.7 2.2-1.1 3.5-1.8 2.2-.7 4.4-1.5 6.3-2.2 1.6-.7 3.1-.7 4.4-2.2.3 0 .3-.4.6-.4 1.6 1.8 4.2 1.8 5.8-.1.1-.1.1-.2.2-.2.3-.3.6-.4.9-.4.9 1.1 1.6 0 2.2-.7.3-.4.6-1.5 1.3-1.1 2.2.7 3.1-1.1 4.7-1.8.9 0 1.9 0 2.2-1.1.6-1.8 1.6-1.8 3.1-1.1 1.2.8 2.8.3 3.4-1.1.6-1.5-.9-1.1-1.3-1.8 1.9-1.1 3.9-1.9 6-2.6.9-.4 2.2-1.1 3.1-1.5.9-.7 1.9 0 2.8 0 3.5.4 6.9-1.3 9.1-4.4.3-.9 1.1-1.4 1.9-1.1 1 .6 2.1.6 3.1 0 2.1-.7 4.3-.4 6.3.7-.3.7-.6.4-.9.7-6.6 3.7-14.1 5.9-20.7 9.5-4.4 2.2-8.8 3.7-13.2 5.5-3.8 1.8-7.5 4-11.3 5.5-3.4 1.2-6.7 3-9.7 5.1h1.3c5.2-1.6 10.3-3.6 15.4-5.9 5-2.6 10.7-4.4 16-6.6 3.1-1.1 5.6-3.7 9.4-3.3.9-.1 1.7-.4 2.5-.7 5.3-3.3 11.3-5.1 17-8.1 2.7-1.1 5.4-1.9 8.2-2.6.6.4.9-.4 1.6 0v1.1c.6 1.5-.6 2.2-.9 3.3-2.3 1.4-4.7 2.5-7.2 3.3-1.1.3-2.2.8-3.1 1.5-.9.7-1.6 1.5-.6 2.6-2.2 1.1-4.7-.4-6.9.7.9 1.1 1.9.4 2.5 1.1-.4.6-1 1.1-1.6 1.5-.3 0-.3 0-.6-.4-.2-.8-.7-1.4-1.3-1.8-.6-.4-1.9 0-1.3.7.9 1.5-.3 1.8-.6 2.6-.3.4-.6 1.1-.9 1.5-1.7-.3-3.4-.1-5 .7v.4-.4c-1.6-1.5 1.3-1.5.6-2.6-1.6 0-2.5.7-2.2 2.9-2.8-1.5-2.8-1.5-4.1 1.1 0 .4-.3.4-.6.4-1.3.4-2.5.4-2.8 2.2-1.3.4-2.8.4-3.8 1.8-.6-.4-1.3.4-1.9.7-.6 0-1.3.4-.9 1.1.3.7.9.7 1.6.7 1.9-.7 3.8-.7 5-2.6 1.3.7 2.2 0 3.1-.7 1.2 0 2.3-.3 3.5-.7h.3c1.3.7 1.6-.4 2.2-1.1.3-.4.6-1.5 1.3-1.1.3.7 0 1.5.6 1.8.6-.4 1.6-.7 2.2-1.1h.3c1.9.4 2.2-1.1 2.5-2.6.6.7 1.6 1.8 1.9 0 0-.4.3-.7.9-.7 1.3.1 2.5-.5 3.5-1.5.7-.5 1.4-.7 2.2-.7.3 0 2.5.4.6-1.5-.3-.4.3-.4.6-.4 1.4.7 3 .7 4.4 0 2.2 1.5 2.8 1.5 3.5-1.5 0-.7.6-.7.9-.7 1.6-.4 2.5.4 3.1 2.6.3-1.8.6-2.2 1.6-2.6 1.3-.4.6-1.1.3-2.2 1.6-1.1 4.1 0 5.3-2.2.3-.4 1.3-.7 1.3-1.5-.3-.7-1.3-.7-1.9-.7-.3 0-.6 0-.6-.7 1.9-2.2 4.4-1.5 6.6-2.2.6.4 2.2.7.6 1.8-.3.4-.6.4 0 .7.3.3.6.4.9.4.7-.3 1.3-1 1.6-1.8.6.6 1 1.4 1.3 2.2.5 2.4 1.8 4.4 3.5 5.9.4.5 1 .7 1.6.7 3.8.7 7.2 1.8 11 2.2 5.9.8 11.8.3 17.6-1.5 3.8-1.1 7.5-2.6 11.3-3.7 2.5-.7 4.7-1.8 7.2-2.6 3.7-.8 7.4-2.1 11-3.7h.6c3.7-.5 7.3-1.7 10.7-3.7.6-.4.9-1.5 1.6-1.1 2.2.8 4.6.3 6.6-1.1.3-.4 1.3 0 1.6-.7.6-1.1 1.3-2.9 3.5-1.5.3.4 1.3.4 1.9.4 2.9-.8 5.8-1.4 8.8-1.8.6 0 .9 0 .9-.7-.3-1.5.9-1.1 1.6-1.1h1.9c-1.3.7-2.6 1.6-3.8 2.6-1.6.8-3 1.7-4.4 2.9-3.3 1.2-6.3 3.5-8.5 6.6-4.7 1.6-8.8 5.1-11.6 9.9-3.8 1.1-6.3 4.8-10.4 5.5-.2 0-.3.2-.3.4.9 2.2-.9 1.8-1.9 2.2-1 .3-2 .8-2.8 1.5-3 2.2-6.3 3.7-9.7 4.4-5.3 2.2-11.3 3.3-16.6 5.5-1.5.7-3.1 1.1-4.7 1.5-2.4.4-4.7 1.3-6.9 2.6-1.6 1.2-3.3 2.2-5 2.9-5.7 1.4-11.4 3.3-17 5.5-1.4.9-3.1 1.3-4.7 1.1-1.6-.4-3.3 0-4.7 1.1-1.3 1-2.8 1.6-4.4 1.8-5.9 1.1-11.7 2.9-17.3 5.5-1.9.7-3.7 1.7-5.3 2.9.9 0 1.3.4 1.9 0 3.1-.7 6.3-1.1 9.4-1.8 2.5-.4 5-.4 7.5-.7 6-1.5 11.9-2.9 17.6-4.4.6.4 2.2-.4 2.5 1.1.3 1.1-1.3 1.1-1.9 1.5l-.9 1.1c.9.4 1.6.7 2.5 1.1.6 0 1.3 0 1.3.7.1.5-.2 1-.7 1.1h-.3c-1.8 1-3.4 2.4-4.7 4-1.3.4-2.2 1.5-3.8 1.5-1.3-1.1-2.2-.4-3.1 0-3 1.7-6.2 3.1-9.4 4-2.9 1-5.5 2.9-7.5 5.5 1.5 1.5 3.5 2.1 5.3 1.5 3.1-1.1 6.6-1.8 10-2.9 1.6-.7 2.8-2.2 4.7-1.8 1 .3 2.1 0 2.8-.7h.3c1.1 3.4 4.3 5.1 7.2 4 1.3 0 2.8.7 4.1-.4 1-.5 2.1-.2 2.8.7 2.3 1.8 5.2 2.2 7.8 1.1 3.2-1 6.4-1.6 9.7-1.8 3.8-.7 7.5-1.1 11-2.2 6.6-2.2 13.5-1.8 20.1-4.4 1.3-.4 2.5-.4 3.8-.7-6.2 2.8-12.6 4.9-19.1 6.2-6.6 1.8-12.9 3.3-19.5 5.1-6.3 1.8-13.2 2.2-19.8 4.4 2.6 1.2 5.5 1.3 8.2.4 5.5-1.5 11-2.6 16.6-3.3h.3c1.9 0 3.5-1.8 5.6-.4-1.3.8-2.7 1.4-4.1 1.8-1.9-.7-3.1.4-4.7 1.5 1 .4 2.1.4 3.1 0 1.3-.4 2.5 1.8 3.5.4 1.1-1 2.4-1.6 3.8-1.8 1.3 0 2.5.7 3.5-.7.3 1.1 2.2 1.1 1.3 2.2-.6.7-.6 2.2-1.9 1.8-.3 0-.6.3-.6.7 0 .4.3.7.6 1.1.3.4.6 0 .9-.4.3-1.5 1.3-.7 1.9-.7 1.2.5 2.5.2 3.5-.7.3 1.5-.6 2.2-.9 3.7.7-.4 1.4-.6 2.2-.7l.6.7c.3.4-.3 1.5.9 1.5.6 0 .6-.7.3-1.5-.3-.7.3-.7.6-.4.6.4.9.4 1.3 0h2.8v.4h-.3c-1.6.4-1.6 2.2-3.1 3.3-.6.4.3 1.5 1.3 1.1.2 0 .3.2.3.4v.4c-.6 1.8-2.8.4-3.8 1.8-.9-.4-1.3-1.8-2.5-1.1-.6-2.6-.6-2.6-3.1-1.5-.2 0-.3-.2-.3-.4-.3-.7 1.3-.7.9-1.8-1.7-.7-3.5-1.1-5.3-1.1 0 1.5-1.3 1.1-1.9 1.8 1.6-1.1 1.3 2.2 2.8 1.5.6.9 1.6 1.3 2.5 1.1.9 0 0 .7.3 1.1-.9 0-1.9.4-2.5 0-.9-.9-2.2-.9-3.1 0-1.4.1-2.7-.1-4.1-.4-3-.4-6.1.3-8.8 1.8-.6.4-1.6 1.1-2.5-.4-.6-.4-1.4-.3-1.9.4-.3.5-.8.7-1.3.7-2.8.2-5.6 1.3-7.8 3.3-.3.4-.9.7-.6 1.5.3.7.6.7 1.3.7h1.9c.6 0 .9.4 1.3 1.1.3 1.5-1.3 1.8-.9 2.9-.3-.4-.9-.4-1.3-.7-1.3-1.1-2.5-1.5-3.5-.4-.7.7-1.6 1.1-2.5 1.1-1.3.4-2.5.4-2.5 2.2 0 .7-.6.4-.9 0-.3-.4-.3-1.1-.6-1.5 2.4-1.5 4.5-3.5 6.3-5.9-1.9-.7-2.5 1.1-3.5 1.1-2.2 0-4.7-.4-5.3 2.9l-.3.4c-2.2.4-4.1 1.8-6.6.7-1.6.7-3.1 1.1-4.7 1.8-.8-.9-2.1-.9-2.9.1-.1.1-.2.2-.2.3-.6.7-1.9.7-1.6 2.2-.3 0-.9.4-1.3.4-.9.4-1.9 1.1-2.8.7-.9-.4-1.9-.1-2.5.7-.6.7-.9 1.8-1.9.4-.2-.3-.6-.4-.8-.1l-.1.1c-.6.4.3.7.3.7.3 1.1 1.3 2.6 0 3.7.7-.1 1.5.1 2.2.4-.6.4-.9.7-1.3.7.3.7 1.3-.4 1.3.4-.1.6-.3 1.1-.6 1.5-.9-.7-1.6 1.8-2.5.4-.6-1.5-1.6-1.1-2.5-1.1-5.9.5-11.7 2.7-16.6 6.6-1.7 1.8-4 2.6-6.3 2.2-.5-.1-1 .2-1.3.7 1.3 0 2.8-.4 4.1-.4.9 0 1.3-.4 1.6 1.1.3 1.8 1.3 2.6 3.1 1.5.9-.4 2.5-1.8 2.5 1.1 0 .4.6 1.1.9 1.5-2.2 1.1-4.7 1.1-7.2 2.2 2 .3 3.7 1.9 4.4 4 .3 2.6 2.5 4.4 3.5 6.2 1.6 3.7 3.5.7 5.3 1.5h.3c-1.9 1.1-3.1 2.2-3.5 4.4v.4-.4c-.6-.4-1.6.7-2.2 0-.3-1.1-1.3-1.1-2.2-1.1-.3 0-.6.3-.6.7 0 .7.9.4 1.3.7 0 .7-1.3.7-1.3 1.5-.3 0-.3.4-.6.4-.3-.4-.6-1.1-1.3-1.1-1.6-.4-1.6-1.1-.9-2.2.3-.4.9-.7.6-1.1-.4-.4-.9-.4-1.3 0-1.3 1.1-3.1 1.5-4.7 2.6-.3.4-1.3.4-.9 1.5.3 1.1 1.3 0 1.9.4l-.9 1.1c-.3.4-.9.7-.3 1.1.3.4.9.7 1.3.4.6-.7 1.9-1.1.9-2.6 1.3.4 3.1-2.2 3.5 1.5-.3 0-.6.4-1.3.4-1.9.4-1.6 2.6-2.8 3.7-.3 0-.3 0-.6.4h-2.2c.9-1.8.9-1.8-.9-2.2-.6-.7-1.6-2.2-2.2-1.5-.9 1.1-2.8 1.1-3.1 2.9-1.6.4-3.1 1.8-4.4 1.5-3.5-1.1-5-.7-6.3 2.6 1.3.4 1.9-1.5 2.8-.7 1.9 2.2 3.5.4 5 .7-.8.3-1.5.8-2.2 1.5-1.3 2-3.2 3.3-5.3 3.7-.9.4-1.9 1.5-2.5-.7-.5-.4-1.1-.4-1.6 0-1.6 1.8-3.8 2.6-5.3 4.4-.6.7-2.5.4-1.9 1.8.6 1.5 1.9 0 3.1.4.3 0 .6-.4.9-.4 2.2-.7 4.4-1.5 6.9-2.2 0 .4.3.4.3.7-2.2 1.5-4.1 3.3-6.3 4.8-.3.4-1.6 0-1.3 1.1.3.7.9.4 1.6.4h1.3c4.4-2.1 9.1-3.1 13.8-2.9.4-.1.8-.2 1.3-.4 0-1.8 1.3-1.1 1.6-.7.7.5 1.5.6 2.2.4 2.5.4 4.7-1.5 7.2-.4.6 0 .9-.4 1.6 0 1.3 1.5 2.5.7 3.8 0 .3 0 .9-.4 1.3-.4 2.8-.4 5.3-.7 8.2-1.1 1.3 0 3.5-.4 3.8-2.6 0-.4.3-.7.6-.7 2.2 0 4.4-1.5 6.6-1.5.3.4-.3 1.1.9 1.1 1.9 0 3.1 0 3.8-2.2 2.8-.7 5.6-1.1 8.5-1.1 1.9 0 3.8 1.1 5.3-.4.2 0 .5.2.6.4 1.3.7 2.2-.4 3.5 0 .3 0 .9-.4.6-1.1-.3-.7-.9-.4-1.3 0-.9 1.5-2.5.4-3.8.7-.9.4-.9-.7-.9-1.1 0-.7.3-1.1 1.3-.7.9.5 2 .2 2.5-.7 0-2.9 1.9-1.8 3.1-1.8 1.4.1 2.8-.1 4.1-.7 2.1-1.3 4.3-2.3 6.6-2.9l.6.7c-.6.7 0 1.1.6 1.1s1.6-.7 1.3-1.5c-.3-1.1-.9 0-1.6 0-.3-1.5.9-1.1 1.3-1.5 3-.4 5.9-1.2 8.8-2.2 1.3 1.1 1.3 1.8-.3 2.2-1.8.1-3.5.7-5 1.8-.3.7-1.3 1.1-.3 1.8.6.4.9 0 1.3-.4.3-.4 1.3-.4 1.6-.4 2.5-.7 5.3 0 7.5-1.8.9-.7 1.3-1.1 0-1.8 0-.7.9-1.1.6-1.8-1.6-1.8.6-1.5.9-2.2.6 0 .9.4 1.6 0 5.3-2.6 11-4 16.3-6.2-1.3.7-2.4 1.9-3.1 
                                    3.3-.3.8-.9 1.3-1.6 1.5-3.5 1.5-3.5 1.5-2.5 5.5v.4c-.6 1.5-.9 2.9-2.8 2.6-.6 0-1.1.5-1.3 1.1.3 2.2-1.3 2.9-2.5 3.7-.6.4-2.2.4-1.6 2.2 0 .4-.1.8-.3 1.1-2.5 2.2-5.3 4-7.8 6.6-1.8 1.3-3.4 2.9-4.7 4.8-1.9 1.1-2.5 3.7-3.5 5.9 1.9-1 3.7-2.4 5.3-4l.3-.4c1.3-.4 1.9-1.8 2.8-2.6.6 0 .9-.7 1.3-1.1 1.6-2.1 3.6-3.7 6-4.4 1.8.7 3.7.4 5.3-.7.3-.4.9-.7 1.3-.4.6.7 0 1.1-.3 1.8-.6 1.1-1.9 1.8-1.9 3.3-.6.3-1.2.4-1.9.4-1.6 0-6 3.3-6 4.8.3 3.7-1.9 4-3.8 5.1-1.3.7-2.8.7-3.1 2.6-.6 3.7-3.1 5.5-5.6 7.3-2 .6-3.3 2.7-3.1 5.1.1 2.1-.9 4-2.5 4.8-.6.4-1.3.7-.9 1.5.6 1.1.3 2.6.3 4-2.2 2.6-2.5 6.2-4.4 8.8-.3.4 0 1.5-.3 1.8-.3 2.2 0 5.1-1.9 6.6-4.1 2.9-5 8.1-7.5 12.5-.9 1.5-1.3 3.3-2.5 4.4-1.3 1.1-1.6 3.2-.6 4.8 1.5 2.2 1.6 5.3.3 7.7l-.9 3.3c-.6 1.8-.6 4.4-2.5 5.5-1.3.4-1.3 1.8-2.2 2.6-2 1.9-3.6 4.3-4.7 7-.3.7 1.3 3.3-1.6 2.6 0 .3-.1.5-.3.7-2.2 1.8-1.3 5.1-1.9 7.7-.3 1.8.6 1.8 1.6 1.5.5 0 1-.3 1.3-.7 1.8-1.2 4-.7 5.3 1.1l.6.4c.9-1.1 1.9-.4 3.1 0 1.5.4 2.8 1.5 3.8 2.9 1.6 2.4 4 3.8 6.6 4 .6 1.1.6 1.1 2.2.7.6 0 1.6-.7 1.9.4.6 1.8 2.2 3.3 1.9 5.1-.6 3.3 2.2 3.7 3.8 4.8 1.3.7.6-1.5 1.3-2.2.2-.2.4-.3.6-.4 1.7-1 3.3-2.2 4.7-3.7 1.6-1.3 3.4-2.3 5.3-2.9 1.9-.4 3.8-.4 5-2.2.4-.5 1-.6 1.5-.1l.1.1c1 1 1.8 2.2 2.2 3.7.3 1.5 1.7 2.4 3 2 .2 0 .3-.1.4-.2 1.3.4 2.5-.4 3.5 1.1.2.3.6.4.8.1l.1-.1c1.3-3.3 3.1-2.6 5.6-1.5.9 1.1 1.6 2.5 1.9 4 .9 2.6 3.5 2.9 6 .7-1.9.7-2.8-.7-3.8-.7 0-2.2 1.3-1.5 2.5-1.8.6-.4 2.5 2.6 2.2-.7 0-.4.6-.4.9-.7.6 0 .6.4.6.7 1.6 3.3 2.5 3.7 5.6 2.6 1.2-.5 2.5-.6 3.8-.4 1.3.7 3.1-.4 3.1-1.8 0-2.2.9-2.6 2.2-2.9.3.7 1.6.4 1.9 1.5.3 2.6 1.6 1.1 2.8.7.3 0 .6-1.1.9-.7 1.9 1.8 2.5-.4 3.1-1.1.6-.7 1.6-1.5 1.6-2.6 0-.4-.3-.4-.6-.4-1.1-.2-2.2.4-2.8 1.5-.3 0-.3.7-.3.7-.3.4-.6.7-1.3.4-1.3-.7-2.8-.7-3.8-2.2-.3-.4-.6-.7 0-1.1 1.3.7 2.5-.7 3.8-.4 1.6.4 2.8-.7 4.4-.7.3.4.6.4.6 0 0-1.8.9-1.5 1.9-1.8 1-.2 2.1-.2 3.1 0 1.3 0 1.6 1.1.6 1.8-1.2.8-1.7 2.5-1.3 4 0 .4-.9.4-.3 1.1.4.4.9.4 1.3 0 1.6-1.8 3.8-1.5 5.6-2.6 1.3.4 1.6-.4 1.9-1.5 0 2.2.6 2.9 1.9 1.5.5 0 1 .3 1.3.7.3.4.9.7 1.3 1.1.3.4.9.7 1.3 0 .9-2.2 2.8-1.8 4.4-2.2 1.3 1.8 1.9 2.2 2.8.4-.6-1.1 0-1.5.9-1.8 1.2-.1 2.3-1 2.8-2.2.6-.7 0-1.5-.3-1.8 0-.4-.3-.7-.3-1.1.9-.7 0-1.8 0-2.6 1.1-.9 2.5-1 3.8-.4h.3c.3.4.3.7.3 1.5-.9 2.2-.9 2.2 1.6 2.2h1.4c-.3.4-.3 1.1-.6 1.5-.3 1.1.3 1.5.6 2.2 1.3-1.5 2.2.7 3.5 0 .6-.4.6-1.5 1.3-1.8-.3 2.6 1.6 3.7 3.1 5.1 1.3 1.4 3 2.2 4.7 2.2 2.5 1.1 5.2 1.5 7.8 1.1 1.7-.2 3.4-.2 5 0 3.5.4 7.1.4 10.7 0 3.5-.4 6.9-.3 10.4.4-3.3 2.3-6.8 4.2-10.4 5.9 0-.4 1.3-.7.6-1.1-.3-.4-.9.4-1.6.4-.9.4-.6.7-.3 1.1-2.3.6-4.5 1.6-6.6 2.9-.9.6-1.9.8-2.8.7-.6 0-1.3 0-1.6-.7 0-.4 0-1.1-1.3-1.1-1.9 0-3.8.4-5.6 1.1-5.7 1.5-11.1 4.5-15.7 8.8-.6.7-1.3.7-2.2 1.1-1.6.7-3.5 0-5 1.8 1.9-.4 3.5-.7 4.7-1.1.6 0 1.3-.4 1.9 0-.6.7.6 1.1.3 1.5-.3.7-1.3.7-1.9.7-.9 0-1.8.5-2.2 1.5 1.6-.2 3.2-.6 4.7-1.1 1.9-.7 1.9.4 2.2 1.5.3 1.1-.9 1.1-1.6 1.5-2.2.7-4.7 1.8-6.9 2.6 1.8-.3 3.6-.8 5.3-1.5.6-.4 1.3-.7 1.6 0 .3.7 1.3 1.1 1.6 1.8l-6.6 2.2c-.3 0-.9 0-.6.7 0 .7.6.4.9 0 1.9-.7 3.5-1.1 5.3-1.8 1.3-.4 2.2-.7 1.9.7 0 .4.3.7.6 1.1.9 1.1 2.5 1.8 3.1 2.9 1.6 2 4 3 6.3 2.6 6.5.7 13 .4 19.5-.7.6.4 1.3-.4 1.6 0h-.3c-.3 0-.9.4-1.3.4-1.5.8-2.6 2.5-2.8 4.4 0 .7-.6 1.1 0 1.8.6.2 1.4.1 1.9-.4.3.1.7-.1.9-.4.6.4 1.3-.4 1.9-.4.8.1 1.7-.1 2.5-.4.6.4.9 1.5 2.5.7h1.9c1.9.7 3.8-.7 5.3-.7h.3c-.3 1.1.6 1.5 1.6 2.2-1.4 1-2.9 1.7-4.4 2.2-.9.4-1.6.7-1.6 1.8-1.6 1.8-4.1 2.6-6.3 4.8 1.1-.2 2.1-.4 3.1-.7 1.3.4 2.2.7.3 1.8-.3 0-.6.3-.6.7 0 .4.6.4.9.4h1.3c0 .4-.6.7 0 .7 1.8 0 3.6-.4 5.3-1.1.3 1.5-.6 2.9.9 4 .3.4 0 1.1-.9 1.5-.3 0-.6.4-.3.7.9.4.9 1.1.6 1.8-.3.7 0 .7.6.7 1.6-.4 1.6 1.1 2.5 1.5-.9.7-.3 2.2-1.3 2.9-1.3.4-.6 1.1-.6 1.5 0 .4.6.4 0 .7-1.3 1.1 0 1.1.6 1.5.7.3 1.5.1 2.2-.4 1.3-.4 2.2-.4 3.5-.7.3.4 1.3-.7 1.6 0 .3.4-.3 1.1-.6 1.5-.3 0-.3.4-.6.4-.6.7-.9 1.8.6 1.5h2.8c-.3 1.2-1 2.1-1.9 2.6-1 .4-1.9 1.2-2.5 2.2-.6.3-1.1.7-1.6 1.1-.6.4-1.9.7-1.3 1.8.6.8 1.6 1.1 2.5.7 2.5.7 5 .8 7.5.4 1.4.4 2.9.4 4.4 0 .6 0 1.3-.4 1.6 0 .6.7 1.6.4 2.2.7 1.9.4 4.4-1.5 5.6.7h.6c2.5-.7 5-1.1 7.5-1.1 3-.8 6-1.4 9.1-1.8 2.4-.2 4.9-.7 7.2-1.5.9-.4 2.2-.4 3.1-.7 5-1.5 10-1.8 15.1-3.7 1.9-.1 3.8-.6 5.6-1.5 4.4-1.1 8.5-2.9 12.9-4 3.6-.7 7.2-1.8 10.7-3.3 4.7-1.5 9.7-2.6 14.4-4.4 5.3-1.8 10.7-3.3 16-4.8 1.5-.7 3.1-1.2 4.7-1.5 4.1-.5 8.1-1.7 11.9-3.3 1 .2 2 .1 2.8-.4 4.4-1.5 8.8-2.9 13.5-4 1.9-.4 3.8-1.1 5.6-1.5 1.4-.3 2.8-.8 4.1-1.5h.6c1.3.7 2.8.4 3.8-.7.3-.4.9-.4 1.3-.7.3 0 .3-.4.6-.4s.3 0 .6-.4c1.6-.7 3.3-1.1 5-1.5 1.3 0 2.5-.7 3.8-.7 1 .2 2.1.2 3.1 0 1.6-.9 3.3-1.4 5-1.5.9 0 .9-.7 1.3-1.5 2.5-1.1 5.3-1.1 7.8-2.2h.6c.9 1.1 1.6-.4 2.2-.7.3 1.1-.3 2.2.3 3.3.7 1.3.8 3 .3 4.4 0 1.4.2 2.7.6 4-.3.4-.6.4-.9.7h-.3c-1.7-.1-3.3.4-4.7 1.5-1.6.7-2.8 0-4.4.4-5.7.6-11.3 2-16.6 4.4-.9.4-1.9.7-2.8.7-2.8.2-5.6.9-8.2 2.2-.6 0-1.3.4-1.9.4-4.5.8-8.9 1.9-13.2 3.3-.9-.9-2.2-.9-3.1 0-1.6.7-3.8.4-5 1.8-.2.3-.6.4-.8.1l-.1-.1c-.9-.7-1.6-.4-2.5.4-.3.5-.8.7-1.3.7-1.8-.1-3.5.4-5 1.5-.9.4-1.6.4-2.5.7-2.4.7-4.8 1.2-7.2 1.5-2.2.4-4.4 1.1-6.6 1.5h-.3c-1.3.2-2.6.6-3.8 1.1-.3 0-.9.4-.6 1.1.2.3.6.4.8.1l.1-.1c.6 0 .9-.4 1.6 0 1.4.8 2.9 1.1 4.4.7 1.6-.7 2.8-1.8 4.4-1.1 1.6 0 3.1-.5 4.4-1.5v-.4c-1.9-1.5.6-1.1.9-1.8h1.3c2.8.1 5.6-.5 8.2-1.8 1.2-.7 2.5-.9 3.8-.7-.6.7-1.6.7-2.2 1.5l2.8-1.1c.6-.4 1.3-.4 1.9 0 1.5.7 3.2.1 4.1-1.5.3-1.1 1.6-1.1 2.2-1.1.9 0-.6.7.3 1.1 1.6-1.8 4.1-1.5 6.3-2.2.9-.4 1.9-.7 3.1-1.1-.8 1-1.6 1.8-2.5 2.6 1.6 0 2.8.7 3.8-.4 1-.7 2-1.2 3.1-1.5.6.8 1.6 1.1 2.5.7 1.9-.4 1.6-1.8 2.5-2.6.8-.8 1.8-1.3 2.8-1.5 1.2-.1 2.4-.6 3.5-1.5l2.8-1.1c.3.4 1.6-.4 1.6.7 0 .7-.6 1.1-.9 1.5l4.7-1.1c.6-.4 1.9-.4 1.9-1.1 0-.7-1.3 0-1.6-.4v-.7c1.9.7 2.5-1.5 4.4-1.5 1.3.4 2.2-.4 3.5-.7s2.2-.4 1.3 1.1c-.3.4-.3.7 0 .7.3.4.6-.4.9-.4 1.6-.7 1.9-2.2 3.5-2.6 2.1 1 4.4.5 6-1.5.3-.4.9-.7 1.3-.4.3 0 .3.4.3.7-.9 1.5.3.7.9.7 1.3 0 1.3 1.1 1.3 1.8 0 2.2 1.3 1.5 2.5.7 2-1 4.1-1.6 6.3-1.8.6 0 1.3-.4 1.9-.4 3-1.6 6.2-2.8 9.4-3.7.5-.1.9-.3 1.3-.7.8-1.1 1.9-1.6 3.1-1.5 1.3-.4 2.5-.7 3.5-1.1 2.5-.4 4.7-2.2 7.2-2.6 2.5-.5 4.8-1.6 6.9-3.3 2.5-.6 5-.9 7.5-1.1 1.6-.4 2.5-1.5 4.1-1.8.4-.1.9.1 1.3.4.6 1.1.6 1.1 1.9 1.1h1.3c0 1.1 0 1.8-1.6 1.5-1.3-.4-4.1 1.8-4.7 3.3 2.5-1.5 5.3-1.5 7.5-2.9 2.1-1 4.3-1.7 6.6-2.2.6 0 1.9-.4 1.6-.7-.6-1.1.3-.7.6-.7.9-.1 1.7-.3 2.5-.7 3.3-1.5 6.8-2.2 10.4-2.2.3 0 .3-.4.6-.4 1.6-.4 3.1-1.1 4.7-1.5L635 879c4.5-.8 8.9-2.1 13.2-3.7.6-.3 1.2-.4 1.9-.4 2.3.5 4.7.2 6.9-.7 1.8-.7 3.7-1.2 5.6-1.5 2-.3 4-.8 6-1.5l14.1-5.5c11.6-4.8 23.2-8.8 34.5-14.7 4.7-2.6 9.4-4.4 14.1-7 6.9-3.7 13.5-7.7 20.1-11.7.7-.5 1.4-.9 2.2-1.1 2.2-.6 4.3-1.5 6.3-2.6 2.8-.7 5-2.9 7.8-3.7 1.1-.3 2.2-.8 3.1-1.5.9-.8 1.8-1.4 2.8-1.8 4.1-1.5 8.1-3.3 11.9-5.5 2-.7 4-1.6 6-2.6 2.7-2 5.5-3.6 8.5-4.8 1.8-.8 3.4-1.7 5-2.9 2.1-.9 4.1-2.1 6-3.7.9-.7 2.2-.4 2.8-1.5 1.4-2 3.1-3.6 5-4.8 3.6-2.7 7.7-4.4 11.9-4.8 1.3 0 2.2-.7 2.2-1.8 0-1.5.9-1.8 2.2-2.6 2.2-1.1 4.1-2.2 6-3.3 2.8-1.5 5.6-2.6 8.5-4 1.7-.6 3.2-1.5 4.7-2.6.3 0 .6-.4.3-.7-.6-.7 0-1.5.6-2.2 1-.3 2-.8 2.8-1.5 0-.2-.1-.4-.3-.4l-2.8 1.1c-1.3 0-1.3-.4-.9-.4.6-1.1.9-2.2 2.2-2.9 1-.2 1.9-.9 2.5-1.8 1.3-.4 2.5-1.1 3.5-2.2l2.8-1.1c3.3-1.1 6.4-2.6 9.4-4.4h.3c3.1-1.1 6.3-1.8 9.4-2.9 4.4-1.5 8.5-3.7 12.9-4.8 3.2-.8 6.4-2.1 9.4-3.7 1.1-.8 2.2-1.4 3.5-1.8 6.3-1.8 12.6-3.7 18.8-6.2 7.2-2.8 14.1-6.5 20.7-11 1.4-.5 2.9-.6 4.4-.4 1 .4 2.1.1 2.8-.7.6-.4 1.3-1.1 0-1.5-.6 0-1.3-.4-.9-.7.6-1.5-.6-1.5-1.6-1.5.6-.7 1.9-1.1 2.5-1.8.9-.4.9-1.5.3-1.5-1.6 0-2.8-1.1-4.4-.7-1.8.9-3.7 1.3-5.6 1.1-.6 0-.9 0-1.3-.4-1.6-1.8-2.2-1.8-4.7-1.1-1.9 1-3.9 1.9-6 2.6-.8.1-1.5.3-2.2.7-2.2.9-4.4 1.6-6.6 2.2 1.9-1.5 2.8-2.9 4.4-2.9 1.1.1 2.2-.3 3.1-1.1 2.3-1.1 4.5-2.3 6.6-3.7.6.4 1.3.7 1.6-.4.3-1.1 1.3-1.5 2.2-2.2.9-.4 2.8-.4 2.2-2.2h.4c0 .4 0 1.1.9.7-.3.7-.3 1.5.9.7.9-.7 2.2-1.5 2.8.4.3-1.1-.3-1.8 0-2.9v-.8c0-1.5.9-1.8 2.5-1.8-.6.4-1.6.7-1.3 1.5s1.3 0 1.9 0c.5 0 1-.3 1.3-.7 1.5-.1 3-.9 4.1-2.2.3-.7 1.6-.4 2.2-1.1 1.6-.4 3.1-1.1 4.7-1.5 0-.4-.3-.7-.3-1.5.3-.4 0-.4 0-.7.3-.4.3-.4.6-.4.6-.4 1.3-.7 1.3-1.5-.5-.6-1.3-.7-1.9-.4-1.3.4-2.5 1.1-3.8 1.5-.5.2-1.1.2-1.6 0-.3 1.5-1.3.4-1.9.4-.6 1.1.3 1.1.6 1.8-.6-.1-1.3.1-1.9.4-2.4 1.3-4.9 2-7.5 2.2-.6 0 0-1.5-1.3-1.1-.9 0 .3 1.1-.6 1.1-.5-.8-1.3-1.2-2.2-1.1 0-.4.9-.7.6-1.1-.3-.4-.6 0-.9 0-.9.4-1.9 1.1-2.8 1.5-1.9.7-3.8 1.5-5.3 2.2-1.4.2-2.7.9-3.8 1.8-.3 0-.3 0-.6.4-1.6-1-3.7-.8-5 .7-.3.3-.6.4-.9.4-.9-.7-1.3.4-1.9.7-.3.4-.6 1.1-1.3.7-1.6-.4-2.8 1.1-4.1 1.5-.7 0-1.3.3-1.9.7-.6 1.5-1.3 1.5-2.5 1.1-1.1-.4-2.2.1-2.8 1.1-.6 1.1.9.7.9 1.1-1.6.9-3.3 1.6-5 2.2-.9.3-1.7.7-2.5 1.1-.7.4-1.5.4-2.2 0-2.9 0-5.7 1.3-7.8 3.7-.2.7-.9 1-1.5.8h-.1c-1-.2-2-.1-2.8.4-1.7.7-3.6.7-5.3 0 .3-.7.6-.4.9-.4 5.6-2.9 11.9-5.1 17.6-8.1 3.8-1.8 7.5-3.3 11.3-4.8 3.2-1.7 6.4-3.2 9.7-4.4 2.9-1.2 5.7-2.7 8.5-4.4-.6 0-.9 0-1.3.4-4.4 1.3-8.7 3-12.9 5.1-4.4 2.2-8.9 4-13.5 5.5-2.5 1.6-5.3 2.6-8.2 2.9-.7.1-1.3.4-1.9.7-4.7 2.6-9.7 4.4-14.4 6.6-2.3.9-4.6 1.7-6.9 2.2-.3 0-.9.4-1.3 0v-.7c-.3-.7.6-1.5.9-2.2 2-1.2 4.1-2.2 6.3-2.9l2.8-1.1c.9-.4 1.3-1.1.6-1.8 1.9-1.1 4.1 0 6-1.1-.6-.7-1.6 0-1.9-.4.5-.3.9-.7 1.3-1.1h.6c0 .6.4 1.1.9 1.1.6 0 1.6 0 1.3-.7-.6-1.1.3-1.1.6-1.8l.9-1.1c1.4 0 2.8-.3 4.1-.7v.4c1.3.7-.9 1.1-.6 1.8 1.3 0 2.2-.7 2.2-2.2 2.2.7 2.2.7 3.5-1.1 0-.4 0-.4.3-.4.9-.4 2.2-.4 2.5-1.8 1.2-.1 2.2-.6 3.1-1.5.6 0 .9-.4 1.6-.7.3 0 .9-.4.9-.7-.3-.4-.6-.4-1.3-.4-1.6.7-3.1.7-4.4 2.2-.9-.3-1.9-.1-2.5.7-1 .1-1.9.3-2.8.7h-.3c-.9-.4-1.3.4-1.9.7-.3.4-.6 1.1-1.3 1.1-.3-.4 0-1.1-.3-1.5-.6.4-1.2.7-1.9.7h-.3c-1-.1-1.9.7-2.2 1.8-.6-.4-1.3-1.1-1.6.4 0 .4-.3.7-.9.7-1.1-.2-2.2.4-2.8 1.5-.3.4-1.6.4-1.9.7-.3 0-1.9 0-.6 1.1.3.4-.3.4-.6.4-1.1-.4-2.4-.3-3.5.4-1.6-.7-2.2-.7-2.8 1.1 0 .4-.3.4-.9.7-1.3.4-1.9 0-2.5-1.5-.2.9-.8 1.6-1.6 1.8-.9.4-.6.7-.3 1.5-1.3 1.1-3.1.4-4.4 1.8-.3.4-1.3.4-1.3 1.1 0 .4.9.4 1.3.4.3 0 .6 0 .6.4-1.7 1.2-3.7 1.8-5.6 1.8-.3-.4-1.9-.4-.3-1.1.3-.4.3-.4 0-.7-.3 0-.6-.4-.9 0-.6.4-1.1.9-1.6 1.5-.6.7.3.7.9.7.6.4-.3.4 0 .7-.3 0-.3.4-.6.4-.3-.7-1.3-.4-1.3-1.1s0-1.5-.9-1.5c-1.3 0-.6 1.1-1.3 1.5-1.3.4-2.7.7-4.1.7-1.6-.4-1.3.7-1.6 1.5-.2 0-.5.2-.6.4h-.9c-1.5-.6-3.1 0-4.1 1.5-.3.4-.9 1.5-1.9 1.1-.3 0-.6 0-.6.4s.3.4.6.4h.9c.9 1.5.9 1.5-.9 2.6-.3-.4-.3-1.5-1.6-.7-1.3-.3-2.7-.4-4.1-.4-.3-.1-.7.1-.9.4-1.6.2-3.2.7-4.7 1.5-2.5 1.8-5.6 2.2-7.8 4 .3 1.5-.6 2.2-3.1 2.9 1.9-.7 1.9-.7 2.2-1.5-3 0-5.9.4-8.8 1.1 
                                    1.6-.8 3.1-1.9 4.4-3.3.9-1.1 2.2-1.1 3.1-1.8.3.7.9.7 1.9.4 1.3-.1 2.5-.7 3.5-1.8 2.5.4 4.1-1.8 6.6-2.2 1.6-.4 3.1-1.8 4.7-2.2.9-.7 2.2-.4 3.5-1.5-.9 0-1.6-.4-2.2-.4 1.2-.9 2.6-1.6 4.1-1.8.9-.4 0 .4.3.4-.3 0-.6.4-.3.4.5.3 1 .5 1.6.4 1.5-.8 3.1-1.4 4.7-1.8.3 0 .6 0 .6-.4s-.3-.4-.6-.4c-.3-.4-.6.4-.9 0l.3-.4c.3-.4 1.3-.4.9-1.1-.3-.4-.9 0-1.3.4l-5.6 2.2c.3-.4.6-.4.9-1.1.3-.4.6-.7 0-.4-.9 0-1.7.3-2.5.7-1.6.5-3.2 1.3-4.7 2.2-1.3.3-2.6.8-3.8 1.5-.3 0-.6 0-.6.4-3.3.8-6.5 2.3-9.4 4.4.6.7 1.3-.4 2.2-.4.6 0 1.3-.7 2.5-.7-5.6 3.7-11.8 6.2-18.2 7.3 4.1-2.6 8.5-3.3 12.2-5.9-1.7.1-3.4.6-5 1.5-1.6 1-3.3 1.7-5 2.2-3.8 1.5-7.8 2.9-11.6 4.4-4.1 1.5-7.8 3.7-11.9 4.8-.9.4-1.3 1.5-2.5 1.5-.9-1.1.9-1.1.9-1.8.9-.4 1.9-1.5 3.1-1.5.3 0 1.3.4.9-.4 0-.4-.3-1.1-1.3-.7-.8.3-1.7.4-2.5.4-1.5 0-3 .4-4.4 1.1h-.3c-1.1 0-2.1.3-3.1.7-.6.4-1.6.7-.3 1.1.9.4.9.7 0 1.1-3.1 1.1-6.3 2.2-9.1 2.9-1.9.4-3.8 1.1-6 1.5 4.5-3 9.4-5.2 14.4-6.6-.6-.3-1.2-.4-1.9-.4-2.4.4-4.8 1-7.2 1.8-2.9 1.1-6 1.5-9.1 1.1-.3 0-.6.4-.6-.4.2-.2.4-.3.6-.4.6.4.6-.4.9-.4 3.1-1.5 6.2-3.2 9.1-5.1 2.5-1.5 5-2.6 7.2-4 1.3-.5 2.6-1.3 3.8-2.2 2.8-1 5.4-2.8 7.5-5.1 4-1.2 7.5-3.9 10-7.7 3.1-1.1 5.6-3.7 8.8-4.4l.3-.4c-.6-1.5.9-1.1 1.6-1.5.9-.4 1.6-.7 2.5-1.1 2.6-1.6 5.3-2.8 8.2-3.7 4.7-1.8 9.4-2.9 14.1-5.1 1.2-.7 2.5-1.1 3.8-1.5 2-.5 4-1.3 6-2.2 1.4-1 2.9-1.7 4.4-2.2 4.7-1.8 9.7-2.9 14.4-5.1 1.3-.8 2.7-1.1 4.1-1.1 1.3.1 2.6-.3 3.8-1.1 1.2-.7 2.5-1.1 3.8-1.5 5-1.3 9.9-3 14.8-5.1 1.6-.6 3.2-1.3 4.7-2.2h-1.6c-2.7.8-5.4 1.4-8.2 1.8-2.1.2-4.2.6-6.3 1.1-5 1.5-10 2.9-14.8 4.4-.6-.4-1.9.4-1.9-.4-.3-.7.9-.7 1.6-1.1.3-.4.6-.4.9-.7-.6 0-1.3-.4-1.9-.4-.3 0-.9 0-.9-.4s.3-.7.9-.7c1.4-.9 2.8-1.9 4.1-2.9 1-.6 2-1 3.1-1.1.9.7 1.9 0 2.5-.4 2.5-1.4 5.1-2.5 7.8-3.3 2.5-.8 4.7-2.3 6.6-4.4-1.3-1-2.9-1.2-4.4-.7-2.8 1.1-5.6 1.8-8.5 2.9-1.2.7-2.5 1.1-3.8 1.5-.8 0-1.5.3-2.2.7h-.3c-1.1-2.4-3.6-3.4-5.6-2.2-1.3 0-2.5-.4-3.5.7-.8.4-1.8.3-2.5-.4-2.1-1.1-4.5-1.1-6.6 0-2.7.9-5.4 1.7-8.2 2.2l-9.4 2.2c-5.6 1.8-11.3 2.2-17 4.4-.9.4-2.2.4-3.1.7 5.1-2.6 10.5-4.4 16-5.5 5.3-1.8 11-3.3 16.3-5.1s11-2.6 16.6-4.4c-2.3-.6-4.7-.5-6.9.4-4.7 1.1-9.1 2.9-13.8 3.7h-.3c-1.6 0-3.1 1.5-4.7.7 1.1-.8 2.2-1.3 3.5-1.5 1.4.3 2.8-.3 3.8-1.5-.9-.2-1.9-.2-2.8 0-.9.4-1.9-1.1-2.8 0-1 .6-2 1.1-3.1 1.5-.9 0-2.2-.4-2.8.7 0-.7-1.9-.4-.9-1.5.3-.4.6-1.5 1.6-1.5.2 0 .5-.2.6-.4 0-.4-.3-.4-.3-.7-.3 0-.6 0-.6.4-.3 1.1-1.3.7-1.6.7-1-.1-2 .1-2.8.7-.3-1.1.6-1.5 1.3-2.6-.6.2-1.3.4-1.9.7-.3 0-.3-.4-.6-.4-.3-.4.3-1.1-.6-.7-.6 0-.6.4-.3 1.1.3.4-.3.4-.6.4-.2-.3-.6-.4-.8-.1l-.1.1c-.7-.1-1.5.1-2.2.4v-.4h.3c1.3-.4 1.6-1.8 2.5-2.2.6-.4-.3-1.1-.9-.7h-.3c.6-1.1 2.5-.4 3.1-1.5.6.4.9 1.1 1.9.7.3 1.8.3 1.8 2.5.7h.3c0 .7-.9.7-.6 1.1 1.4.3 2.9.4 4.4.4 0-.7 1.3-.7 1.6-1.5-1.6.7-.9-1.5-2.2-.7-.3-.7-1.3-.7-1.9-.7-.6 0 0-.4-.3-.7.6 0 1.6-.4 2.2 0 .8.6 1.9.5 2.5-.4 1.1-.2 2.3-.2 3.5 0 2.6 0 5.2-.8 7.5-2.2.7-.6 1.5-.6 2.2 0 .3.4.9.4 1.6-.4.3-.4.6-.7.9-.7 2.4-.2 4.7-1.2 6.6-2.9.3-.4.6-.4.6-1.1 0-.4-.6-.4-.9-.4-.5-.1-1.1.1-1.6.4-.6 0-.9 0-.9-.7-.3-.7.9-1.5.9-2.2.3 0 .6.4.9.4.8.7 2 .7 2.8 0 .6-.7 1.3-.7 2.2-1.1.9-.4 2.2-.4 2.2-1.8 0-.4.6-.4.6 0s.3.7.3 1.1c-1.9 1.2-3.7 2.6-5.3 4.4 1.6.4 2.2-.7 2.8-1.1 1.9-.4 3.8 0 4.4-2.2h.3c1.8-.8 3.7-1.1 5.6-1.1 1.3-.4 2.5-1.1 3.8-1.5.9.6 2.1.5 2.8-.4.6-.4 1.6-.7 1.6-1.5.3 0 .6-.4.9-.4.7-.4 1.4-.7 2.2-.7.9.4 1.6-.4 2.2-.7.6-.7.9-1.1 1.6-.4.3.4.6 0 .9 0 .3-.4-.3-.4-.3-.7 0-.7-.9-1.5.3-2.6h-1.3c.6-.4.9-.4 1.3-.7-.3-.4-.9.4-.9-.4 0-.4.6-1.1.6-1.1.6.4 1.6-1.5 1.9-.4.3 1.1 1.3.7 2.2.7 5-.7 9.8-2.5 14.1-5.5 1.5-1.4 3.4-2.2 5.3-2.2.3 0 .9 0 .9-.7-1.3 0-2.2.4-3.5.4-.6 0-1.3.4-1.3-.7-.3-1.1-.9-1.8-2.5-.7-.6.4-2.2 1.5-1.9-.7 0-.4-.3-.7-.6-1.1 1.9-1.1 4.1-1.1 6-2.2-1.4 0-2.7-.9-3.5-2.2 0-1.8-1.9-2.6-2.5-4-1.3-2.2-2.8-.4-4.4-.7h-.3c1.4-.5 2.6-1.7 3.1-3.3v-.3.4c.6.4 1.3-.7 1.9 0 .3.7.9.7 1.6.4.3 0 .6-.3.6-.7 0-.7-.6 0-.9-.4 0-.4.9-.4.9-1.1.3 0 .3 0 .6-.4.3.4.6.7.9.7 1.3 0 1.3.7.6 1.5-.3.4-.9.4-.6.7 0 .4.6.4.9 0 1.3-.5 2.6-1.3 3.8-2.2.3-.4 1.3-.4.9-1.1-.3-.7-.9 0-1.3 0 .3-.4.6-.4.6-.7.3-.4.6-.4.3-.7-.2-.3-.6-.4-.8-.1l-.1.1c-.6.4-1.6 1.1-.9 1.8-.9 0-2.8 1.8-2.8-.7.3 0 .6-.4.9-.4 1.6-.4 1.6-1.8 2.5-2.6.3 0 .3 0 .6-.4.6.1 1.3-.1 1.9-.4-.9 1.5-.9 1.5.6 1.5.3.7.9 1.5 1.6.7.9-.7 2.5-1.1 2.8-2.2 1.3-.4 2.5-1.5 3.8-1.1 2.8.4 4.1 0 5.3-2.2-.9-.4-1.9 1.1-2.2.7-1.3-1.5-2.8 0-4.1 0 .6-.4 1.3-.4 1.9-1.1 1.3-1.4 3-2.4 4.7-2.9.6-.4 1.6-1.1 2.2.4 0 .4.9 0 1.3-.4 1.6-1.5 3.5-2.2 4.7-3.3.6-.4 2.2-.4 1.6-1.5-.3-.7-1.6 0-2.5 0-.3 0-.3.4-.6.4-1.9.7-3.8 1.1-5.6 1.8 0-.2-.1-.4-.3-.4 1.9-1.1 3.5-2.6 5.3-3.7.3-.4 1.3 0 .9-.7 0-.7-.9-.4-1.3-.4s-.9.1-1.3.4c-3.7 1.8-7.6 3-11.6 3.3-.3.1-.7.2-.9.4 0 1.5-.9.7-1.3.7-.6-.4-1.3 0-1.9 0-2.2 0-4.1 1.5-6 .7-.3 0-.9.4-1.3 0-1-.6-2.2-.5-3.1.4-.3 0-.6.4-.9.4-2.2.4-4.4 1.1-6.6 1.5-.9 0-2.8.4-3.1 2.2 0 .4-.3.4-.6.4-1.9.3-3.8.8-5.6 1.5 0-.4.3-.7-.6-.7-1.6 0-2.5.4-3.1 1.8-2.4.7-4.8 1.2-7.2 1.5-1.6 0-3.1-.7-4.4.7h-.3c-.9-.4-1.9.4-2.8.4-.3 0-.9.4-.6.7.2.3.6.4.8.1l.1-.1c.9-1.1 2.2-.4 3.1-.7.6-.4.9.4.9.7 0 .7-.3.7-.9.7-.9-.4-1.9.4-1.9.7 0 2.2-1.6 1.5-2.8 1.5-1.2-.1-2.4.1-3.5.7-1.8 1-3.7 1.9-5.6 2.6-.3 0-.3-.4-.6-.4.6-.7 0-.7-.6-.7s-1.3.4-1.3 1.1.6 0 1.3 0c.3 1.1-.9.7-1.3 1.1-2.5.5-4.9 1.3-7.2 2.2-.9-.7-.9-1.1.3-1.5 1.4-.3 2.8-.8 4.1-1.5.3-.4.9-.7.3-1.1-.3-.4-.6 0-.9.4-.4.3-.8.4-1.3.4-2.2.2-4.3.8-6.3 1.8-.9.7-.9.7 0 1.1 0 .4-.9.7-.6 1.1 1.3 1.1-.6 1.1-.9 1.5h-1.3c-4.4 2.2-9.4 3.7-13.8 5.5 1.1-.5 2.1-1.4 2.8-2.6.3-.7.9-1.1 1.6-1.1 2.8-1.1 2.8-1.5 2.2-4 .6-1.1.9-2.2 2.5-1.8.5 0 .9-.5.9-1.1 0-1.5 1.3-1.8 2.2-2.6.6-.4 1.9-.4 1.3-1.5 0-.4 0-.4.3-.7 2.2-1.8 4.7-3.3 6.9-5.1 1.5-1 2.9-2.2 4.1-3.7 1.9-1.1 2.2-2.6 3.1-4-1.7.9-3.3 2-4.7 3.3-.2 0-.3.2-.3.4-1.3.4-1.6 1.5-2.5 1.8-.5 0-1 .3-1.3.7-1.6 1.5-3.4 2.7-5.3 3.3-1.6 0-3.1-.4-4.4 1.1-.4.3-.8.4-1.3.4-.6-.4 0-.7.3-1.1.6-.7 1.6-1.5 1.9-2.6.5-.3 1-.4 1.6-.4 1.3 0 5.3-2.6 5-3.7-.3-2.2 1.6-2.9 3.5-3.7.9-.4 2.5-.7 2.8-1.8 1.2-2.4 2.9-4.3 5-5.5 1.5-.4 2.7-1.8 2.8-3.7 0-1.6.9-2.9 2.2-3.3.6-.4.9-.4.6-1.1-.3-.7 0-1.8 0-2.6 1.9-1.8 2.5-4.4 4.1-6.2.3-.4.3-.7.3-1.5.6-1.5.3-3.7 1.9-4.8 3.5-2.2 4.7-5.9 6.9-8.8.7-1.2 1.6-2.3 2.5-3.3 1.3-1.1 1.6-2.2.9-3.3-1.1-1.5-1.1-3.7 0-5.1l.9-2.2c.6-1.5.6-2.9 2.2-4 1.3-.4 1.3-1.5 1.9-2.2 1.7-1.4 3.2-3.2 4.4-5.1.3-.7-.9-2.2 1.3-1.8 0-.2.1-.4.3-.4 1.9-1.5 1.3-3.7 1.9-5.1.3-1.5-.3-1.5-1.3-1.1-.3 0-.6.4-1.3.7-1.4 1-3.2.9-4.4-.4h-.8c-.9.7-1.6.4-2.5.4-1.1 0-2.2-.7-2.8-1.8-1.4-1.5-3.2-2.3-5-2.2-.3-.7-.6-.7-1.6-.4-.6 0-1.3.4-1.6 0-.3-1.1-1.6-1.8-1.3-3.3.6-2.6-1.6-2.2-2.8-2.9-.9-.4-.6 1.1-1.3 1.5-.2.2-.4.3-.6.4-1.5.8-2.8 1.7-4.1 2.9-1.4 1.2-3 1.9-4.7 2.2-1.5.2-2.9.8-4.1 1.8-.3.4-.9.7-1.3.4l-1.9-2.2c-.6-1.1-1.3-1.5-2.8-1.1-.9-.4-2.2.4-2.8-.4-.2-.2-.4-.2-.6 0-1 1.9-3.1 2.5-4.7 1.5.9-1.8 2.5-2.6 3.5-4.4 1.6.4 2.2 0 2.8-1.5.6-1.8 2.5-2.2 4.1-2.9.9-.4 1.9-.4 1.9-1.8 0-1.1.3-1.5.9-.4.3.4.6.4.6 0 1-1.8 2.4-3.2 4.1-4 .9-.7 2.2-1.5 2.2-2.9.6-.4.6-1.8 1.6-1.5 4.1.4 4.7-4.4 7.2-5.9.9-.7 1.9-2.2 3.1-3.3.7-.3 1.3-1 1.6-1.8 1.3-1.8 3.5-2.6 4.4-4.8.6-.4 1.9-1.1 1.3-2.2-.6-1.5-1.3 0-2.2 0-1.9 0-2.8 1.8-4.1 2.9-4.4 2.9-7.5 6.6-11.6 9.9-2 2.1-4.4 3.7-6.9 4.8-1.3.4-1.9.7-1.9 2.2-.9 1.1-1.8 2.1-2.8 2.9-2.5 2.2-5.6 3.3-7.5 6.2-2.5.4-3.8 2.9-6 4.4-1.2.3-2.4.8-3.5 1.5-.6.4-1.3 1.8-1.9.7s.6-1.5 1.3-2.2c.3-.4.9-.4 1.3-.7.6-.7 1.9-1.1 1.6-2.6 1.3-1.4 2.8-2.7 4.4-3.7 1.6-1.1 3.8-2.6 3.8-4.8 0-4 2.8-6.6 3.1-10.6.3-2.2 2.2-3.7 2.5-5.9 2.3-5.2 4.3-10.6 6-16.1.5-.7.7-1.6.6-2.6-.9-4 .9-8.1 0-12.5-.4-.8-.2-1.9.3-2.6.2-.3.4-.7.3-1.1.3-3.7-2.2-5.9-4.4-8.1-1.5-2.1-3.6-3.5-6-4-3-1.9-6.3-2.8-9.7-2.6-2 .1-4-.1-6-.7-4.2-1-8.5-1.5-12.9-1.5-4.2.3-8.5-.3-12.6-1.8 3.6-3.2 7.6-5.6 11.9-7.3 0 .7-1.6.7-.6 1.5.6.4 1.3-.4 1.9-.4.9-.4.6-1.1.3-1.5 2.7-.7 5.4-1.8 7.8-3.3 1-.6 2.1-.8 3.1-.7.9 0 1.6 0 1.9 1.5 0 .4 0 1.5 1.6 1.8 2.5.7 4.4-.7 6.6-1.1 6.8-1.6 13.2-5.4 18.2-11 .6-.7 1.6-.7 2.5-1.1 1.9-.7 4.4.4 6-2.2-2.2.4-4.1.7-5.6 1.1-.6 0-1.6.4-2.2 0 .6-1.1-.9-1.5-.6-2.2.5-.8 1.4-1.1 2.2-.7 1.3.4 1.9-.4 2.5-1.8-2.2.4-3.8.4-5.6.7-2.2.7-2.5-1.1-2.8-2.6-.6-1.5.9-1.5 1.6-1.8 2.8-1.1 5.3-2.2 8.2-3.3-2.2-.1-4.3.4-6.3 1.5-.6.4-1.6.7-1.9-.4-.3-1.1-1.6-1.8-1.9-2.9 2.5-.7 5-1.5 7.8-2.2.3 0 .9 0 .9-.7-.3-1.1-.6-.4-1.3-.4-2.2.7-4.1 1.5-6.3 2.2-1.3.4-2.5 1.1-2.5-1.5 0-.7-.6-1.1-.9-1.8-1.4-1.6-2.8-3.3-4.1-5.1-1.7-3.1-4.7-4.9-7.8-4.8-7.9-1.8-15.9-2.3-23.9-1.5-.6-.7-1.3 0-1.9-.4.2 0 .3-.2.3-.4.3-.4.9-.4 1.3-.7 1.8-1.2 3.1-3.3 3.3-5.7 0-.7.9-1.8 0-2.6-.6-.7-1.6 0-2.2.4-.4-.1-.9.1-1.3.4-.7-.3-1.5-.1-2.2.4-.9-.4-1.9-.4-2.8 0-.9-.7-1.6-2.6-2.8-1.5-.8.1-1.7-.1-2.5-.4-2.5-1.5-4.4.4-6.6.4H797c0-1.5-.7-2.8-1.9-3.3 1.5-1.2 3.2-2 5-2.6.9-.4 1.9-1.1 1.9-2.2 1.9-2.2 4.7-3.3 7.2-5.9-1.3 0-2.6.2-3.8.7-1.6-.7-2.5-1.1-.6-2.6.3-.4.9-.4.6-1.1 0-.7-.9-.7-1.3-.7h-1.6c0-.4.6-1.1 0-.7-2.2.4-4.4-.4-6.3.7-.6-1.8.3-4.4-1.6-6.2-.3-.4 0-1.8.9-2.2.3-.4.9-.7 0-1.1-1.3-.7-1.3-1.5-.9-2.6.3-1.1-.3-1.1-.9-1.1-1.9.4-1.9-1.5-3.1-2.6.9-1.1 0-3.3 1.3-4 1.3-.7.6-1.5.6-2.2 0-.4-.6-.7-.3-1.5 1.6-1.5 0-1.8-.9-2.2-.9-.4-2-.3-2.8.4-1.3 0-2.8.4-4.1.4-.6-.7-1.6.7-1.9-.4-.3-.7 0-1.5.9-2.2.3 0 .6-.3.6-.7.6-1.1.9-2.2-1.3-2.6-.9 0-2.2-.4-3.5-.4-.1-1.6.9-3 2.2-3.3 1.3-.3 2.4-1.4 2.8-2.9l1.9-1.1c.6-.7 2.2-1.1 1.3-2.6-.6-1.3-1.9-2-3.1-1.5-2.9-1.3-6-2-9.1-1.8-1.7-.5-3.6-.6-5.3-.4-.6 0-1.3.4-1.9-.4-.6-1.1-1.9-.7-2.8-1.1-.6-.4-1.3-.4-1.9 0 .3-.4.3-.4.6-.4.6 0 .6-.7.6-1.5 0-.7-.6-.4-1.3-.7-.6 0-1.3.7-1.9 0 1.7-.2 3.3-.8 4.7-1.8.3 0 .3 0 .6-.4.7.4 1.3.9 1.9 1.5 2.8 1 5.8.9 8.5-.4.2-.3.6-.4.8-.1l.1.1c.9 1.1 2.2.7 3.5.4.3 0 1.3 0 1.6.4 1.6 2.2 2.8 1.1 4.1 0 1.1-.7 2.3-1.3 3.5-1.8.6 0 1.3.4 1.9.4.6 1.1 3.1-.4 2.8 2.6 0 .4.3.4.6.4 3.1-.4 6.6 0 8.8-3.3.3-.7 1.3-1.1 1.9-1.8-.4.1-.9-.1-1.3-.4-3.2-2-7.1-2-10.4 0-3.4-1.5-7.3-.7-10 2.2 0-.3-.1-.5-.3-.7.7-.6.9-1.7.4-2.5 0 0 0-.1-.1-.1-.9-1.1-1.3-.4-2.2 0-.6.4-.9 0-.9-.7-.2-.7-.7-1.2-1.3-1.5.3-.4.9-.4 1.3-.7.6-.4.6-.7.6-1.5 0-.7-.6-.4-.9-.4-.6 0-.6 0 .3-.7.6-.4.3-1.5 1.3-1.5.6 1.3 2 1.8 3.1 1.1 1-.9 2.2-1.4 3.5-1.5v.4c-.9.6-1.5 1.7-1.6 2.9.9-.6 1.8-1.1 2.8-1.5.8.5 1.8.3 2.5-.4.8-1 1.8-1.6 2.8-1.8.9-.4.9-.7.3-1.5.3-.4 1.3-.7 1.3-1.5 2.5-.4 3.5-2.6 5-4 .4-.5.8-.8 1.3-1.1 0-1.1.3-2.6 1.6-2.6 1.9 0 1.3-.7 1.3-1.8v-1.1c0-.4.9-.7.3-.7-.3 0-1.3-.7-1.6-.4-.9 1.5-2.8 1.1-4.1 1.8-2.8 1.5-6.3 1.5-9.1 2.6-.6.4-1.9 0-1.6-.4.3-1.5-1.3-1.1-1.3-.7-.3 
                                    1.5-1.6-.7-1.9.4-.3 1.1-.9 0-1.3.4-.3-.7-.3-1.1-.6-1.8 1.3-1.5 3.1-.4 4.4-1.5 8.1-2.7 16-6.4 23.5-11 2-.9 3.9-2 5.6-3.3 1.6-.4 3.5-1.1 5-1.5 1.2.2 2.5-.2 3.5-1.1.6-.4.9-.7.6-1.1-.9-.7-1.6-1.5-1.6-2.6.6-.4 1.6-.7 1.9-1.8-2.8-.2-5.5.2-8.2 1.1-1.9.7-4.1 1.5-5.3-.4-.5-.4-1.1-.4-1.6 0-1.6.2-3.1.8-4.4 1.8-3.1 1.8-6.9 2.9-10 4.4-1 .5-2.1.7-3.1.7.6-1.1 1.9-1.8 2.5-2.9-1.2 0-2.3.3-3.5.7-2.2 1.1-4.5 1.9-6.9 2.6-1.6 0-2.8.7-4.1.7-.6-.2-1.4-.1-1.9.4-.6.4-.9 0-.9-.4.7-.4 1.4-.7 2.2-.7 1.3 0 1.3-.7 1.3-1.5.9-.4.9-1.5 1.9-1.8 1.3 0 1.6-.7 2.2-1.8h.6c1.6-1.1 3.3-1.9 5-2.6.6-.4 0-.7-.3-1.1 3.5-1.1 7.2-1.8 9.1-5.5 1.8-.7 3.5-2 4.7-3.7.3-.7.9-.7 1.6-.7h.3c.6 0 .9-.4 1.6-.7 2.3-1.2 4.4-2.8 6.3-4.8v-.1c.3-.7 1.3-.7 1.9-1.1 2.5-1.3 4.9-3 6.9-5.1.3-.4.6-.4.3-1.1-2.8.7-5.5 2.1-7.8 4-6 4.8-13.2 8.1-19.5 12.5-2.5 1.8-5.6 3.3-8.5 5.1-3.6 2.2-7.2 4.1-11 5.9-2.3 1.1-4.5 2.5-6.6 4-2.2 1.5-4.7 2.2-6.9 3.7-3.1 2.3-6.7 3.6-10.4 3.7-2.7-.3-5.4.2-7.8 1.5-.8-.2-1.7-.1-2.5.4-3.4 1.2-6.8 2.7-10 4.4-2.9 1.1-5.8 2.4-8.5 4-.3 0-.3.4-.6.4-.7-.1-1.5.1-2.2.4-2.4 1.2-4.7 2.6-6.9 4.1-4.1 1.8-8.5 2.6-12.6 4.4.6-.7 1.6-.7 2.5-1.5-2.4 1.1-5 1.8-7.5 2.2-1.8.2-3.6.5-5.3 1.1v-.4c0-.4-1.3-.4-.6-.7.6-.7 1.3-1.8 2.5-1.5.9-.4 1.9-.7 1.9-1.5 0-.4-.3-.4-.6-.7-.9 0-1.6.4-1.6 1.1-.3 0-.3.4-.9.4-.3 0-.3-.4-.3-.7 0-.4-.3-1.1.3-1.1 1.9-.5 3.8-1.3 5.6-2.2.7-.4 1.4-.7 2.2-.7.3-1.5-1.3-1.8-1.9-2.9.5-.3.9-.7 1.3-1.1.4-.8 1.2-1.1 1.9-.7.9.7 2.8.7.9 2.6-.3.4 0 .7.3 1.1 1.6-.4.6 1.1 1.6 1.5v.3H706c.3.7.6 1.5 1.6 1.1.6-.4 1.6 0 1.9-.7 1.5.2 3.1-.5 4.1-1.8.3-.4.6-.7 1.3-.4 1.6.7 3.1-.4 4.7-1.1.6-.4.9-.7.6-1.1-.3-.7-.9 0-1.3 0-1.6.4-3.1.7-3.8-1.1-.3-.7-.9-1.1-1.9-.4-.6.7-1.6.4-2.5.7-1.6.4-1.9-.4-1.3-1.5.3-.4.9-1.1.6-1.5-.6-1.1-.3-1.8.6-2.2 1.9-.7 3.1-3.3 5.6-2.6 0 .7-1.6.7-.9 1.5.6.7 1.3 0 1.9-.4.6.4 0 .7.3 1.1.3.4 1.3.4 1.3-.4s.6-1.5-.3-1.8c-.6 0-1.3-.4-1.9-.4.3-1.1.3-1.1-1.9-1.5.3-.7.9-1.1.3-1.8.9-1.1.9.7 1.6 0 .9 1.5 2.2 1.1 3.8.4 0 .7.3 1.1 1.3.7.9-.2 1.8.1 2.5.7 0 .4-.9 1.1.3 1.1 1 .1 2 .5 2.8 1.1.3 0 .6.4.9.4.6-1.5 2.2-1.5 3.1-2.6.6-1.1 1.3-1.5 2.2-1.1.6 0 .9.4 1.6 0 1.3-.4 2.8-1.1 3.1.7 0 .4.3.4.6.4s.6-.4.3-.7c-.3-.7.6-.7.9-1.5 1.6-1.5 3.6-2.3 5.6-2.2.3 0 .3-.4.6-.4.9-1.1 2.2 0 3.1-.7.6 0 .9-.7 1.9-1.1 0 1.1-1.3 1.8-.3 2.9h-.4c-.3.4-1.3 0-1.3.7.3 1.1 2.2 1.8 3.5 1.5.9-.4 1.3-.7.9-1.5-.6-1.1-2.5-2.2-.6-4 .3-.4-.6-.4-.3-.7 2.2 1.1 2.8.7 5-1.1 1-.9 2.4-.9 3.5 0l-2.8 1.1c.9 0 1.9 0 1.9.7 0 2.2 2.2 1.5 3.8 1.8-.6-.7-.3-1.5-.6-2.2 0-.3-.1-.5-.3-.7-.6-1.1 0-1.5.9-1.8.3.4-.6.7 0 1.5 3.8-1.8 3.8-1.8 3.5-2.6-.9 0-.9 1.1-2.2 1.1.4-.8.7-1.7.9-2.6.9.7 2.5 1.1 2.5.4.6-1.1 3.5-1.5 2.5-3.3 0-1.1-1.6-.7-1.9-1.5 0 0-.6 0-.6-.4.9-.4.9-1.8 2.5-2.2 1.6-.4 3.5-.4 4.4-1.8.3-.4.9-.4 1.3-.7.3-.4.6-.7.3-.7-.3-.4-.6 0-.9.4-.3-1.5-.3-1.5-1.3-1.5-1.3-.7-2.2 1.1-3.5.4-.9-1.1-2.2-.4-3.5-.7-1.6 0-1.6-.4-.3-1.5.3.7 1.3.7 2.2.7.6 0 1.1-.5 1.3-1.1 0-.4 0-1.1-.3-1.1s-1.3-.4-1.6.4h-.3c0-.4 0-1.1.6-1.1.3 0 .9 0 .6-.4-1.3-1.1 0-1.5.6-2.2 1.1-.6 1.7-1.9 1.6-3.3.2 0 .5-.2.6-.4.6.4 1.6-.7 2.2 0 0 .7.6 1.1 1.6.4.6-.3 1.2-.8 1.6-1.5 0-.4 0-1.1-.6-1.1-.3-.4-.3-.7.3-.7.6-.4 1.3-.4 1.9-.7h.9c1.6-.4 3.1.7 4.4-.7 1-1 2-1.9 3.1-2.7.9-.7-.3-1.5 1.3-1.8.9.4-.6 1.5 0 1.8-.9 1.5.6.7 1.3 1.1.7-.4 1.4-.7 2.2-.7 1.1-.4 2.2-1 3.1-1.8 1.6-1.1 0-1.8-.3-2.6 0 0-.3-.4.3-.7.6.4.9 1.1 2.2.7.6 0 1.3.4 1.6-.4.9-.4 1.9-.4 2.8-.7.3.7.3 1.8 1.6 1.1h.9c2.2.4 2.5-.7 2.8-2.2.3-.4.9-.7 1.3-1.1 3.1-1.5 5.3-3.7 5.3-5.5 1.2.1 2.3.3 3.5.7.3-.7 0-1.1-.3-1.5-.6-.4-.3-.7.6-1.1 1.3-.4 3.1-1.1 2.2-2.6-.3-.7.9-.7.9-1.5-.9-.4-1.9-.7-2.8.4-.3.4-.9.7-1.3.4-.3-.4-.6-.4-.6 0-.4 1-1.3 1.6-2.2 1.5-2.7.3-5.5.8-8.2 1.5-.3 0-.9.4-1.3-.4-.6-1.5-.6-1.5-1.9 0-.2 0-.3.2-.3.4h-.3c-.9 0-1.6-.7-2.5 0-.4.3-.8.4-1.3.4h-.9c-.6 0-1.3-.4-1.9-.4-1.9-.4-3.8-.3-5.6.4-1.1.3-2.3.4-3.5.4-1.5-.1-2.9.4-4.1 1.5-.6.4-.9.7-1.6 1.1l-4.7 1.1c.6-1.5-.9-1.1-1.9-1.1-.3-.7.6-.7.9-1.5l.9-1.1c1.3-.4 1.6-1.5 2.2-2.2 2.2-.7 3.1-2.2 2.8-4 1.3-1.1.6-2.6 1.9-3.7.3 0-.3-.7-.6-.4-1.6.4-3.1-.7-4.7 0-.3 0-.9 0-.9-.4.3-1.5-.6-1.8-1.9-1.8-.3 0-.6-.4-.9-.4.6-.7 1.6-1.5 2.2-2.2.9-.7 2.2-1.1 2.2-2.2s.9-1.1 1.6-1.1c.4.1.9-.1 1.3-.4 3.2-1.1 6.3-2.7 9.1-4.8.3.4-.6 1.1-.3 1.8.3-.7 1.3 0 1.3-1.1 0-.4.3-.7.9-.7 1.7-.5 3.4-1.5 4.7-2.9.6-.7 1.9-1.8 2.5-1.5 1.6.7 2.2-.4 3.1-1.1.3-.4.6-.7 1.3-.4.3.4.6 0 .6-.4s0-.7-.6-.4c-.7.1-1.3-.3-1.6-1.1.6-.4.9-1.1 1.6-1.8 1.3-.7 2.5-1.1 3.1-2.2l.3-.4c.9-.4.9-1.8 2.2-1.5 1.3-.7 1.6-2.6 3.5-1.5h.3c.6-1.1 1.3-.7 2.2-.4 2.2.4 3.8-1.1 3.5-2.9 0-.7-.6-1.5 0-2.6-3.7-5.7-4-6.4-5.3-6.4z"/>',
            $gradID);
        }
        $mask = '<path id="alexandru-zdrobau-juESZxMhtXk-unsplash_00000091737860096417183090000007947309053583689385_" class="st2" d="M819.3 147.1c-1.6 0-3.5-.4-4.4 1.5v.4-.4c-3.1-.4-3.1 0-3.8.4-1.3 0-2.8-.7-3.8 1.5-.6-1.5-.6-1.5-1.6-.7s-1.6 1.1-1.9-.4c0-.4-.6-.4-.9-.7-1.4-.4-2.8-.3-4.1.4h-.3c-.9.4-1.6-.4-2.2-.4-1.3-.4-2.5-.4-3.8-.7-.9 0-.9-.4-.3-1.1.6-.7 2.2-.7 2.5-2.2-2.1.3-4.2.8-6.3 1.5-3.8 1.1-7.4 2.6-11 4.4-.9.4-2.2.7-3.1 1.1-.6.4-.9 0-.6-.7.6-.4.9-.7 1.6-.7.9 0 .9-.7.6-1.1 0-1.8-3.5.4-2.8-1.8h-.6c-.6.4-.9.7-1.6.7-1.2.8-2.7 1.1-4.1.7h.3c.9-.4 1.6-.7 1.6-1.5-1.3.4-2.2-.4-3.1.7-.9.4-2.2.7-3.1 1.1h-.9c-.6-.4-1.9.4-2.2-.4-.3.5-.8.7-1.3.7-1.7-.3-3.4.2-4.7 1.5-4.1 1.5-8.2 2.2-12.2 3.7-2.5 1.1-5.2 1.9-7.8 2.2-5.6 1-11 2.6-16.3 4.8-1.6.4-2.8 1.1-4.4 1.5-.3 0-.6.4-1.3.4-2.2-.4-4.5 0-6.6 1.1-1.2.7-2.5 1.1-3.8 1.5-4.1.7-8.2 2.6-12.2 3.7l-3.8 1.1c-2.4 1-4.8 1.7-7.2 2.2h-.6c-1.3 0-2.8.7-3.5-.7-.2-.6-.9-.9-1.4-.6-.2.1-.4.3-.5.6-.3.7-1.3 1.1-2.2 1.5 0-.4-.3-.4-.3-.7.8-2.3 2.9-3.7 5-3.3.8.2 1.7.1 2.5-.4-.3.4-.3 1.1-.9 1.1-.3 0-.9 0-.6.4 0 .4.6.4.6.4 1.3-.7 3.1-1.1 3.8-2.6.3-.7.3-1.1 1.3-1.1.6 0 .9-.4 1.3-1.1.9-.7 1.9-.4 2.8-.7 1.6 0 1.9-1.5 2.2-1.8.6-1.1-1.3-.4-1.6-1.1 1.9-.7 3.8-.4 5.6-1.1.6.4 1.3.4 1.9.7.9 0 1.9.7 2.5 0 .9-1.5 2.5-1.1 3.8-1.5.3 0 .3-.4.6-.4 1.9.4 2.8-1.8 4.7-1.5.3 0 .3-.7-.3-1.1-.6-.5-1.5-.6-2.2-.4 0-.4-.3-.4-.3-.7.8-1.1 1.9-1.7 3.1-1.5.9.7 1.9.4 2.8.4h2.2c0 1.1-1.3 1.1-1.6 2.2 1 .3 2-.2 2.5-1.1.3-.7.3-1.5 1.6-1.8.3.7 0 2.2 1.6 1.8 1.6-.4 3.5-.7 3.1-2.9.6.4 1.3 1.1 1.6 0 .3-1.1.9-1.5 1.9-.4.3.4.9 0 .6-.4-.9-1.5.9-.7 1.3-1.5.3 0 .9-.4 1.3-.4.6.7 1.3.4 1.9 0 1.6-.4 2.8-1.1 4.4-1.5 1.3-.4 2.2-1.1 1.9-2.2-.3-1.1-1.6-.7-2.5-.4-.2 0-.3.2-.3.4-.6-1.1-1.9 0-2.5-.7-1.3-1.5-2.2-.4-2.5.7-.6.7-1.4 1.2-2.2 1.5-.9 0-1.7.3-2.5.7-2 .8-4.2 1-6.3.7.3-.4.6-.4 1.3-.7 5-1.8 9.7-4 14.8-5.9 2.7-.9 5.3-2.1 7.8-3.3.3 0 .6-.4.9-.4 3.8-.7 6.6-3.7 10.4-4.8.3 0 .9-.7.6-1.1-1.9-.4-1.3-1.5-.6-2.9.3-.7 0-1.1-.6-1.8-1.3-.7-2.2.4-3.5.4-.2 0-.3-.2-.3-.4.3-1.5-1.6-.4-1.6-1.1.6-.4.9-.4 1.3-1.1.3-.4.3-.4.3-.7.9-1.1 1.9-2.2 1.3-3.7 1.9-2.2 4.4-3.7 6-5.9.3-.7 1.3-1.1 2.2-1.5 2.2-.4 4.1-1.8 5.3-3.9.3-.4.9-.7 1.3-1.5 2.5-2.4 4.8-5.1 6.9-8.1.6-.7.9-1.5 1.6-2.2.9-1.1 1.3-1.5 0-2.2-1.3-.7-1.3-1.5.3-2.2.6-.4 1.6-.7.9-1.5-.9-1.8-1.3-1.8-2.8 0-.6-1.1.3-2.6-.3-3.7-1.3-2.6.3-5.5-.3-8.1-.3-1.1-.6-1.5-1.9-1.1-.5.3-1.2.2-1.6-.4-.6-.4 0-.7.3-1.1 1.6-1.1 1.9-2.2 0-2.9-.7-.4-.9-1.4-.6-2.2.3-1.1-.3-1.1-1.3-.7-.7.2-1.5.4-2.2.7-1.6.7-3.3 1.1-5 1.5-1.8.3-3.6.8-5.3 1.5-2.6 1.5-5.3 2.5-8.2 2.9.3-.4-1.6.4-.6-.7l.9-1.1c.8-1.6 2.2-2.7 3.8-2.9 3.1-.7 6-2.2 9.1-3.3 1.9-.7 3.5-4 2.2-4.8-1.6-.7-.9-1.5-.6-2.6.3-.7.9-1.1.6-1.8-.9-1.8.6-2.6 2.2-3.3.9-.4 1.3-.7.9-1.8-.3-1.8-1.6-2.9-4.1-2.6 2.1-.9 3.2-3.7 2.4-6.2 0-.2-.1-.3-.2-.4-.3-1.1-.6-2.2-2.5-1.1-.6.2-1.3-.1-1.6-.7 0-.7.6-.7 1.3-.7.9 0 1.9 0 1.6-1.5-.3-.7.6-1.1 1.3-1.5s1.6-1.1.9-1.8c-.6-.7-1.6-.4-2.2 0-.6-.1-1.3.1-1.9.4-.3-.4-.9-.4-1.3-.7-1.3-1.1-3.1-1.5-3.8-3.3h.3c1.9-.7 4.1 0 5.6-1.5 1.3-1.1 3.5-1.1 4.4-2.9.3-.3.6-.4.9-.4.9 0 1.9.4.9-1.1.2-.4.4-.8.6-1.1.9-.7 1.9 0 3.1-1.1.3-.4.3 1.1 1.3 1.1.3-1.8 2.2-1.5 3.1-2.2 1-.6 2.1-.8 3.1-.4 1.9 0 2.5-1.8 3.5-2.6.6-.4 0-1.1-.3-1.5-.3-.4-.6-.4-1.3 0-.9.4-1.3 1.1-2.5 1.5a5.9 5.9 0 0 1 3.8-2.6c.6 0 1.3-.4.9-1.1 0-.7-.6-.7-1.3-.4-.3.4-.9.7-1.3 0V21c.6-.4 1.6-.4 1.6-1.1s-.9-.7-1.6-.4c-.4 0-.9-.1-1.3-.4-.9 1.1-2.5.7-3.5 1.5-1.9 1-3.9 1.5-6 1.5-.9.4-2.5 1.5-3.8.4l-.6.4c-.3 1.5-2.5 1.8-2.8 3.3-.1.4-.4.6-.7.5-.1 0-.1-.1-.2-.1-.3-1.5-1.6-.7-2.5-.4-.9 0-2.5 1.5-2.8-.4 0-.4-.3 0-.6 0-.9.4-1.3 0-1.9 0-.9 0-1.9-2.2-2.8 0 0 .4-.6.4-.9.4-1.3-.2-2.5-.2-3.8 0-3.6.2-7.1 1.2-10.4 2.9-1.6.2-3.2.6-4.7 1.1h-.6c-3.2.3-6.4 1.2-9.4 2.6.6-.7 1.9-1.1 1.6-2.2 1.3-.7 3.1 0 3.8-1.8.3-.7.6.7 1.3 0-.3-2.2-.3-2.2-3.1-1.1-.9.3-1.8.8-2.5 1.5-2.2 0-4.4 1.5-6.6 1.5-.3 0-.6.3-.6.7-.4.7-.9 1.2-1.6 1.5-3 1-6 2.3-8.8 4h-.3c-4.7 2.6-9.7 4-14.4 6.2-4.7 1.8-9.4 4-14.1 6.2-.9.4-1.9 1.1-2.8.7-1.8-.1-3.5.4-5 1.5-2.5 1.4-5 2.6-7.5 3.7-2.3.7-4.7 1.5-6.9 2.6-.6 0-.6.4-.6.7-.9.3-1.7.7-2.5 1.1-6 2.6-12.2 5.1-18.2 7.7-.6-.7 2.2-1.8.3-2.6-.9-.4-1.3-.4-1.9.4-.9 0-.6-1.1-1.6-1.1.3-.7.9-.7 1.6-.7 1.7-.4 3.3-1.2 4.7-2.2.6-.4 2.2-1.5 2.5-.7.6 1.1 1.3.4 1.6 0 2.4-1.7 4.9-3.1 7.5-4 .9 0 1.9-.4 2.5.4-.9-1.5-.6-1.8 1.3-2.2 1.9-.4 3.1-2.6 5.3-2.6.7 0 1.3-.3 1.9-.7 1.9-2.2 5.3-1.8 7.2-4h.3c.6 0 .9 0 .9-.4s-.3-.7-.6-.7c-1.6-.4-2.2.7-2.8 1.8-.6-.4-1.6-.7 0-1.5.3 0 .3-.4.3-.7.6-.7 1.3-1.8 2.8-1.5.8-.1 1.5-.4 2.2-.7.6 0 .9-.4 1.6-.4.6.4 1.6-.4 1.9.4.3.7-.9.7-1.3 1.5-.3.4-.9.4-.9.7 2.8 0 2.8 0 3.5-2.2.3-1.1.9-1.1 1.3-.4.9 1.5 2.2.7 3.5 0 1.6-1.1 2.2-2.9 4.4-3.3.3-.7 1.3-1.1 1.9-1.5 2.9-.3 5.6-1.6 7.8-3.7.9-.7.6-1.5-.6-1.8-.6-.1-1.3.1-1.9.4-.9 0-2.2.7-3.1.4-1.9-1.1-2.2 0-2.5 1.1-.3.7 0 1.5-1.3 1.5-1.4.1-2.8.6-4.1 1.5-1.5.7-3.1 1.2-4.7 1.5-1.3-1.5-1.9.4-2.8.7-.6 0-.6 1.5-.9 1.8-1.3 1.1-.3-.7-1.6-.7-2.3.4-4.5 1.6-6.3 3.3v.4l-.6.7c-.3 0-.3 0-.6-.4s.3-1.1-.6-1.1c-.6 0-.9.7-1.3 1.1-.3.7-.3 1.5-1.3 1.5-.3-.4-.9-1.1-1.6-.4-1.6 1.5-4.7 1.5-5.3 4-.3-.4-.3-.7-.6-.7-.9.4-2.5 0-2.2 1.8 0 .4-.6.4-.6.4h-1.4c-2.2.9-4.6 1.3-6.9 1.1-.6.4-1.9 0-1.6 1.5.3 1.8-.3 2.6-2.5 2.2-.7-.1-1.5.1-2.2.4-1.6 0-3.5-1.1-3.8 1.5h-.3c-1.9.4-3.5 1.1-5.3 1.5-.6 0-.9-.7-1.6 0s.6.7.6 1.5c-.5.1-1.1.2-1.6.4-.9-.4-1.3-.4-.9.4 0 1.1-.6 1.8-1.3 2.9-.9-.4-.3-1.1-.6-1.5s-.3-1.1-1.3-1.1c-.6 0-.6.7-.9 1.1-.3 1.1-.9 1.1-1.6.7-2.2-.7-3.1-.4-3.8 1.8-.9.7-1.3 1.8 0 1.8 2.2 0 .9.7.3 1.5-1.3 0-1.9-.4-1.9-1.5s-.6-1.5-1.6-1.8c-.6 0-1.6.4-1.3.7.6 1.1-.6 1.1-.9 1.8-2.2.7-4.4 1.2-6.6 1.5-.5-.4-1.1-.4-1.6 0-.6.4-2.2.4-1.6 1.1.9 1.8-.9 1.1-1.6 1.5-.6 0-1.3.4-1.9 0-1.3-.4-2.8 0-3.8 1.1-1.2 1.9-3 3.1-5 3.3-.3.7-.3 1.5.6 1.1 2.5-.7 2.2 1.1 2.8 2.2-.9.4-2.5 1.5-2.8.7-.6-1.5-3.1-.7-3.8-2.6-.3-1.1-1.6-1.5-2.8 0-1 .6-2 1.1-3.1 1.5-2.5.4-4.4 1.8-6.9 2.2-.2 0-.5-.2-.6-.4l-1.9 1.1c-.9 1.1-2.8.7-3.5 1.8 0 .7-.9 1.1-1.6 1.1-1.3 0-3.1-.7-3.5 1.5-.3.4-.8.6-1.3.7-2.2 1.1-2.5 1.5-.6 2.6 0 .4 0 .7-.3.7-.2 0-.3.2-.3.4-.3-.4-.6-.7-.9-.7-.9-.4-1.9-.4-2.8 0-1.6.7-3.1 1.1-4.7 1.8h-.6c-.6 0-1.1.3-1.6.7-.7.1-1.3.3-1.9.7-.3 0-.6.4-.9.4l-4.4 1.1c-4.7 2.2-10 2.9-14.8 5.5-1.1.7-2.4.7-3.5 0-.2 0-.3-.2-.3-.4 0-.4 0-.4-.3-.7-1.9-.4-.6-.7 0-1.5.3 0 .3 0 .6-.4.6 0 .9-.4 1.6-.4.6-.4 1.6-.4 2.2-.7h.3c.9-.4 1.9-.4 2.5-.7 1-.1 1.9.1 2.8.4h1.9c.9-.4 2.2-.4 3.1-.7 2.6-1.4 5.4-2.7 8.2-3.7.9.4 1.3-.7 1.9-1.1.3-.4.6-.4.9-.7.8-.3 1.6-.8 2.2-1.5 1.3-1.1 2.6-1.9 4.1-2.6h.9c.7.7 1.8.7 2.5 0 .5-.3 1-.6 1.6-.7 2.2.4 2.8-.7 3.1-2.2h.6c2.5.1 4.9-.8 6.9-2.6h.3c2.9-.4 5.7-1.7 8.2-3.7.4-.5 1-.7 1.6-.7.3 0 .9-.4 1.3-.4 1.3-.7 2.2-1.5 3.5-1.1.6-.4 1.3-.4 1.3-1.1s-.9 0-1.3-.4c-.6-.4-1.3-.4-.9-1.1 1.3-.7 2.8-1.1 4.1-1.8.6 0 .9.4 1.6.4.3 1.8 1.9.7 2.8.4 2.2-.7 4.4-1.8 6.6-2.6.3 0 .9-.4.9-.7-.3-.7-.9-.7-1.9-.7-.3 0-.6.4-.6 0 .3 0 .3 0 .6-.4s1.3-1.1 1.3-1.8c0-.4-.9-.4-1.6 0-1.9 1.1-4.4 1.8-6.3 2.9-.6 0-1.3.4-1.3-.4.6-.7.9-.7 1.9-.4.5 0 1-.3 1.3-.7 0-.4.3-.7 0-.7-.4-.4-.9-.4-1.3 0-3.5 1.5-6.9 2.6-10.4 4.4-.6.4-1.6.4-2.2.7-.6 0-.9.4-1.6.4-1.9 1.1-4.1 1.1-5.6 2.6-.9.4-1.9.4-2.8.7-1.4.9-2.9 1.4-4.4 1.5-1.1.1-2.2.5-3.1 1.1-.3 0-.6.4-1.3.4h-.9c-.3 0-.6.3-.6.7l-.6.7c-.9.7-2.8 0-2.2 2.2 0 .7 1.3.4 1.6.7l-.3.4c-.5.3-1 .4-1.6.4-.6-.7-1.3-2.2-2.5-1.5l-6.6 2.2c-.6.4-1.6.4-1.9 1.1 0 .4-.6.4-.9.4-1-.5-2.1-.2-2.8.7-2.4 1.9-5.1 3.2-7.8 4-.9.4-1.6-.4-2.5.4-.9 1.1-1.3.4-1.3-.4 0-.4.3-1.1-.6-1.1 0 0-.6 0-.6.4s-.6 1.1 0 1.5c.3.4.6.7 0 1.1-2.3 1.4-4.7 2.3-7.2 2.9-.9 0-1.9.4-2.2-.7 0-.7-.6-.4-1.3 0-.6.4-1.9.4-1.9 1.1 0 .7.9.4 1.3.4.3.4 1.6-.4 1.3.7-.9.7-2.2.7-3.1 1.5-1.9.7-3.8 1.8-5.6 2.6-2.8.4-3.1 0-3.5-2.2 0-.4-.3-.4-.9-.4-.6.4-1.3.4-1.6.7l-2.8 1.1c-.6.7-.6 1.5.6 1.5h3.5c-1.3 1.1-3.1 1.1-3.8 2.2-1.9 0-2.2 1.5-3.1 2.6-.2.3-.6.4-.8.1l-.1-.1c-.9-.7-.6-2.2-1.9-2.6-.6 0-1.3-1.1-1.9-.7-.9.7.3 1.5.3 1.8s.3.7.6 1.1c.3 1.1-.3 1.8-1.6 2.2-1.6.7-3.1 1.1-4.7 1.8-2.2.9-4.6 1.4-6.9 1.5 1.6-1.1 1.9-1.5 1.3-1.8-.9-.4-1.6.4-2.2.7-.6.7-.6 1.1 0 1.5-2.2.7-4.4 1.2-6.6 1.5-1.4.8-2.9 1.3-4.4 1.5-1.3 0-1.9 0-.6-1.5-.5-.1-1.1 0-1.6.4-1.3 1.1-2.8.7-4.1 1.5-.9.4-.9 2.6-2.8 1.5l-.3.4c-.3 1.1-.9 1.1-1.6.4-.3-.4-.3-.4-.6 0-1.5 1-3.3 1.6-5 1.5-.6 0-1.6.4-.6 1.1 1.3.7 1.6 1.8 3.1 2.2l.3.4c-1.6 1.5-3.7 2.1-5.6 1.5-1.4-.8-3.1-.7-4.4.4-.3.4-1.3.7-1.6.4-1.9-1.1-3.5.4-5 1.5-.6.4-1.3 1.5-2.2.4-.5-.3-1.2-.1-1.6.4-1.7 1.9-3.9 3.2-6.3 3.7-.7-.4-1.5-.1-1.9.7-.3.7.3 1.1.9 1.8.3.7.9.4 1.6.4 1-.5 2.1-.6 3.1-.4-1.3.7-2.5 1.5-.9 2.6.6.4 0 1.1-.6 1.5-.6.4-1.6.7-2.2 1.1-1.1.5-2.3.9-3.5 1.1.3-.7 1.3-1.1 0-1.5-1.3-.7-.3-1.1.6-1.1.6 0 .9.4 1.6.4.3 0 .6.4.9.4.3-.4 0-.7 0-1.1 0-1.8-1.6-2.6-2.8-3.7-.6-.4-1.4-.3-1.9.4-.9.7-1.8 1.2-2.8 1.5-1.6.7-3.1 0-4.7 1.5-.6.6-1.2 1.1-1.9 1.5-1.3.7-3.1.7-4.1 1.5-2.7 1.8-5.5 3.3-8.5 4.4-2.5.7-5 1.8-7.5 2.6-2.9.7-5.6 1.9-8.2 3.7-2 1.2-4.1 2-6.3 2.6-1.6.4-2.9 1.6-3.5 3.3-.6 2.6-1.6 1.1-2.5.7-.6-.4-1.6-1.1-1.9-.7-1.3 1.5-3.1 1.5-4.7 2.2-1.6 1.2-3.4 1.8-5.3 1.8-1.9-.4-1.6.7-1.9 1.5-.6 1.1.3 1.5 1.3 1.5.3 0 .9-.4.9.4-.3.4-.9.4-1.3.7-.3.4-.3.4-.3.7.2.3.6.4.8.1l.1-.1c1.3-1.5 2.8-1.1 4.4-1.5.9-.7 2.2-.7 3.1-1.5s.9 0 .6.7c-1.9 1.1-1.9 1.1 0 1.8v.4h-.5c-.6 0-.6.4-1.3.7-.9 0-1.6.7-2.2.7-1.3.4-2.2.7-3.5 1.1-.6.4-1.6.7-1.9.4-.6-.7-1.3-.4-2.2 0-.6.4-1.6.4-2.5.7.3-1.1 2.2-2.2 0-2.2h-3.5c-1.9.7-3.8.4-5.3 1.5-1.7 1-3.5 1.7-5.3 2.2-.3 0-.6.4-.9.4-1.9.7-3.5 2.6-5.6 2.2-.6 0-1.9.4-2.2 1.5-.6 1.1.6 1.1 1.3 1.5.9.7-.6.7-.3 1.1-1.9.7-.3 2.2-.9 3.3v.7c-.3 1.1-1.6 1.5-2.2 2.2-3.1.8-6.1 2.2-8.8 4-5.3 3.3-11.3 5.1-17 8.4-2.8 1.5-6 2.9-8.8 4.4-.8.4-1.7.8-2.5 1.1-2.4 1.2-4.9 2.1-7.5 2.6h-.3c-2.9 2.2-6.1 3.8-9.4 4.8-2.7.6-5.3 1.9-7.5 3.7-.6.6-1.4.9-2.2.7-3.2.6-6.3 1.8-9.1 3.7l-6.6 3.3c-.5.4-1.1.4-1.6 0-.9-.4-1.3 0-1.9.7-1.2 2.3-3.4 3.6-5.6 3.3-.8 0-1.5.3-2.2.7-.9 1-2.2 1.7-3.5 1.8-3.7.3-7.4 1.6-10.7 3.7-3.1 1.5-3.8 1.5-4.4-1.5 0-.4 0-1.1-.9-.7-.7 0-1.3.4-1.6 1.1-.3 1.1 0 1.8.9 2.6.9.7.6 1.1-.3 1.8-2.9 1.3-5.8 2.4-8.8 3.3-1.3.4-.6-.4-.3-1.1.6-1.5.3-1.8-1.3-1.8-.7.2-1.5.2-2.2 0-2.5-.7-1.6 1.5-2.2 2.2-.6 1.1 0 1.5.9 1.5 1.6.4 2.2 1.1.9 1.8-2 1.7-4.1 3.2-6.3 4.4-2.2 1.1-4.7.7-6.6 2.6-.3.4-1.6 1.1-2.2.7-1.8-.7-3.8-.7-5.6 0-2.8 1.1-5.8 1.5-8.8 1.5-.6 0-1.9 0-1.3 1.1.3.4-.6 1.1-1.6 1.1-2.2-.4-2.2-.4-2.5 1.8 0 .4.3 1.1-.6 1.5-.6.4-.9-.4-1.3-.7-.6-.7-1.6-2.2-2.2.4 0 .4-.3.4-.6.4-1.8-.1-3.6.5-5 1.8-2.2 
                    1.6-4.5 2.9-6.9 4-1.9.7-3.8 1.1-5.6 1.8-2.6.9-5.1 2.1-7.5 3.3-3.8 1.9-7.7 3.5-11.6 4.8-4.3 1.7-8.4 4.1-12.2 7-1.6.6-3.1 1.7-4.1 3.3-1.5.9-2.7 2.2-3.8 3.7-1.8 2.8-4.6 4.5-7.5 4.8-1.6 0-3.1 1.2-3.8 2.9-.8 1.5-1.7 2.9-2.8 4-1.6 1.3-3 2.9-4.1 4.8-.4.8-1.1 1.3-1.9 1.5-.6 0-1.2.5-1.6 1.1-1.6 3.3-3.6 6.2-6 8.8-.6.7-.3 1.5.3 1.8 1.3 1.1 1.3 1.8-.6 2.6-1.9 1.1-2.2 1.5-.9 2.9.3.4.6 1.1.9 1.5s.3.7 1.3.4c1.6 0 1.6-1.5 2.5-2.6-.2 2.7.1 5.5.9 8.1.9 2.6-1.6 5.9.3 8.4-.6 2.2.3 3 2.8 2.2.6-.3 1.4-.2 1.9.4.3.4 0 .7-.3 1.5l-.9 1.1c-1.6 1.5-1.6 2.2 0 2.9 1.9.7 1.6 2.2 1.9 3.3.6 1.8.3 2.2 2.5 1.1 2.8-1.1 5.6-2.1 8.5-2.9 2.4-.3 4.8-.8 7.2-1.5-2.2 3.1-4.6 5.9-7.2 8.4-.9.7-.3 1.1.3 1.8 1.6 1.8 1.3 2.6-1.6 3.3-.3 0-1.3 0-.9.7-.2 1.6.6 3.1 1.9 3.7 1.3.4 1.6-1.1 2.5-1.5.6 1.8-.9 3.3-.3 5.1.6 1.9.6 4 0 5.9-.9 1.4-1 3.2-.3 4.8.3.4 0 1.1-.3 1.5-.3.4-.6 1.1 0 1.5s.9 1.1 1.9.4c.5-.4 1.1-.4 1.6 0 1.3.7 1.3 1.5-.9 2.9-1.9 1.1-1.6 2.2-.3 2.9 1.6 1.1 1.3 2.6.9 4-.3 1.5.6 1.5 1.6 1.5 1.3-.4 2.2-.4 3.5-.7 2.2-1.1 4.7-.4 6.6-1.5 4.4.2 8.8-.7 12.9-2.6 2.2-1 4.5-1.6 6.9-1.8 1.6.2 3.2-.5 4.4-1.8.7-.7 1.6-1.1 2.5-1.1 2-.1 4-.3 6-.7 1.6-.1 3.2-.9 4.4-2.2 1-1.6 2.7-2.3 4.4-1.8 1.4.3 2.8.1 4.1-.4.6 0 1.3-1.1 1.9-.7 2.7.6 5.4.2 7.8-1.1 1.9-1.1 3.5 0 5-.4 3.1 0 6.3-.7 9.1-.7 1.8 0 3.5-.5 5-1.5 2-1 4.1-1.7 6.3-1.8.3 0 .6 0 .6.4.9 1.1 2.2.7 3.5 0 2.5-.8 5-1.3 7.5-1.5 2.6-.6 5.2-.9 7.8-.7.9 0 .9-.7.9-1.5 0-1.1-.6-.4-1.3-.4-1.5.2-3.1-.1-4.4-1.1 1.5-.7 3.1-1.1 4.7-1.1.8 0 1.5-.4 1.9-1.1.8-1.4 2-2.3 3.5-2.6.3 0 .9 0 .9.4s-.3 1.1-.6 1.1c-2.2.4-2.2 1.8-2.8 2.9s-.6 1.8 1.3 1.8c1.3 0 2.2 1.5 3.5.7 2.2-1.5 4.4-.4 6.6-.7-.6.4-1.6.7-2.2 1.1-.3 0-.9.4-.6.7.9 1.1-.6 1.5-.9 1.8-1.9 1.5-4.4 1.1-6.3 1.8-5.2 1.7-10.4 3.8-15.4 6.2-7.8 4-15.7 8.4-23.9 12.5-3.1 1.5-6 2.9-9.1 4.8-1.6.6-3.1 1.6-4.4 2.9-.6.4-.9.4-1.6.7-4.1 1.7-8.1 3.8-11.9 6.2-5.7 2.6-11.2 5.9-16.3 9.9-6.6 3.8-12.6 8.8-17.9 14.7-.9 1.2-2 2.2-3.1 2.9-2.2 1.8-4.7 3.3-5 6.2-.7.4-1.3.9-1.9 1.5-.9 1.1-1.6 1.8-1.3 2.9-.3.4-.3.4 0 .7h.3l.3.4v.7c-.3.7-.3 1.1.6 1.1.6 0 .6.4.6.7.6 2.6 2.5 3.3 5.3 2.9.6 0 1.3-.4 1.9.4.3.4 1.3 0 1.9 0 3.5-.1 6.9-.6 10.4-1.5 2.2-.7 4.4-1.1 6.3-1.8 4.1-1.1 8.2-.7 12.6-1.5-.9.7-1.3 1.5-.9 2.2-.4 1.6-1.7 2.7-3.1 2.6-2.2-.4-2.5.7-2.5 2.2 0 .7 0 1.5.9 1.8.6 0 .6.7.3 1.1-1.3 1.5 1.6 2.9-.6 4.8 1.6 1.1-.3 2.9.6 4.4.5.6.6 1.6.1 2.2-.1.1-.2.3-.4.4-1 .7-2.2.7-3.1 0-.8-.7-1.9-1-2.8-.7 1.9 1.1 3.8 2.2 3.5 4.4 0 .7.6.7.9 1.1.3.4.9.4.9.7.5 2.3 1.1 4.5 1.9 6.6-.3.4 0 .7 0 1.1-3.5 1.1-6.9 1.8-10.4 2.9-5 1.5-9.7 4-15.1 5.1-3.9.8-7.7 2.1-11.3 4-1.3 1-2.6 1.7-4.1 2.2-7.5 2.2-15.1 4-22.3 6.6-8.6 3.1-16.7 7.7-24.2 13.6-1.8.4-3.6.4-5.3 0-1.2-.3-2.4-.2-3.5.4-.9.4-1.6 1.5 0 2.2.6.4 1.6.7 1.3 1.5-.6 2.2.9 2.2 2.2 2.6-.6 1.1-2.2 1.1-2.8 2.2-1.3.4-1.3 1.8-.3 1.8 1.9 0 3.5 1.8 5.3 1.5 2.2-.9 4.6-1.3 6.9-1.1.6 0 1.3 0 1.6.7 2.2 2.9 2.8 3.3 6 2.6 2.5-.7 4.4-2.6 6.9-3.3.9.2 1.8-.1 2.5-.7 2.5-1 5-1.7 7.5-2.2-1.9 1.8-3.1 4-5 3.7-1.3-.3-2.7.1-3.8 1.1l-7.5 4.4c-.9-.7-1.6-1.1-1.9.4-.3 1.5-1.3 2.2-2.5 2.9-.9.7-3.1.4-2.5 2.9-.3 0-.3 0-.6-.4 0-.7-.3-1.5-1.3-1.1.3-1.1.3-2.2-1.3-1.1-1.3.7-2.5 1.8-3.5-1.1-.3 1.5.6 2.9.3 4v.7c.3 1.8-.9 2.6-2.8 2.6.9-.4 1.9-.7 1.3-2.2-.6-1.5-1.6-.4-2.5-.4-.6 0-.9.4-1.3 1.1-1.9.4-3.8.7-4.7 2.9-.6 1.1-2.2.4-2.5 1.5-1.7.7-3.5 1.2-5.3 1.5l.3 1.8c-.3.4 0 .7 0 1.1-.3.4-.6.7-.9.7-.9.4-1.6.7-1.3 1.8.5.8 1.4 1.1 2.2.7 1.6-.4 2.8-1.1 4.4-1.5.7-.2 1.5 0 2.2.4.3-2.2 1.6-.4 2.5-.4.6-1.5-.6-1.8-.9-2.6.7.1 1.5-.1 2.2-.4 2.8-1.6 6-2.4 9.1-2.2.9.4 0 2.2 1.6 2.2 1.3 0-.3-1.5.9-1.5.6 1.2 1.7 1.9 2.8 1.8 0 .4-.9.7-.6 1.5.3.4.9 0 1.3 0 1.3-.7 2.2-1.1 3.5-1.8 2.2-.7 4.4-1.5 6.3-2.2 1.6-.7 3.1-.7 4.4-2.2.3 0 .3-.4.6-.4 1.6 1.8 4.2 1.8 5.8-.1.1-.1.1-.2.2-.2.3-.3.6-.4.9-.4.9 1.1 1.6 0 2.2-.7.3-.4.6-1.5 1.3-1.1 2.2.7 3.1-1.1 4.7-1.8.9 0 1.9 0 2.2-1.1.6-1.8 1.6-1.8 3.1-1.1 1.2.8 2.8.3 3.4-1.1.6-1.5-.9-1.1-1.3-1.8 1.9-1.1 3.9-1.9 6-2.6.9-.4 2.2-1.1 3.1-1.5.9-.7 1.9 0 2.8 0 3.5.4 6.9-1.3 9.1-4.4.3-.9 1.1-1.4 1.9-1.1 1 .6 2.1.6 3.1 0 2.1-.7 4.3-.4 6.3.7-.3.7-.6.4-.9.7-6.6 3.7-14.1 5.9-20.7 9.5-4.4 2.2-8.8 3.7-13.2 5.5-3.8 1.8-7.5 4-11.3 5.5-3.4 1.2-6.7 3-9.7 5.1h1.3c5.2-1.6 10.3-3.6 15.4-5.9 5-2.6 10.7-4.4 16-6.6 3.1-1.1 5.6-3.7 9.4-3.3.9-.1 1.7-.4 2.5-.7 5.3-3.3 11.3-5.1 17-8.1 2.7-1.1 5.4-1.9 8.2-2.6.6.4.9-.4 1.6 0v1.1c.6 1.5-.6 2.2-.9 3.3-2.3 1.4-4.7 2.5-7.2 3.3-1.1.3-2.2.8-3.1 1.5-.9.7-1.6 1.5-.6 2.6-2.2 1.1-4.7-.4-6.9.7.9 1.1 1.9.4 2.5 1.1-.4.6-1 1.1-1.6 1.5-.3 0-.3 0-.6-.4-.2-.8-.7-1.4-1.3-1.8-.6-.4-1.9 0-1.3.7.9 1.5-.3 1.8-.6 2.6-.3.4-.6 1.1-.9 1.5-1.7-.3-3.4-.1-5 .7v.4-.4c-1.6-1.5 1.3-1.5.6-2.6-1.6 0-2.5.7-2.2 2.9-2.8-1.5-2.8-1.5-4.1 1.1 0 .4-.3.4-.6.4-1.3.4-2.5.4-2.8 2.2-1.3.4-2.8.4-3.8 1.8-.6-.4-1.3.4-1.9.7-.6 0-1.3.4-.9 1.1.3.7.9.7 1.6.7 1.9-.7 3.8-.7 5-2.6 1.3.7 2.2 0 3.1-.7 1.2 0 2.3-.3 3.5-.7h.3c1.3.7 1.6-.4 2.2-1.1.3-.4.6-1.5 1.3-1.1.3.7 0 1.5.6 1.8.6-.4 1.6-.7 2.2-1.1h.3c1.9.4 2.2-1.1 2.5-2.6.6.7 1.6 1.8 1.9 0 0-.4.3-.7.9-.7 1.3.1 2.5-.5 3.5-1.5.7-.5 1.4-.7 2.2-.7.3 0 2.5.4.6-1.5-.3-.4.3-.4.6-.4 1.4.7 3 .7 4.4 0 2.2 1.5 2.8 1.5 3.5-1.5 0-.7.6-.7.9-.7 1.6-.4 2.5.4 3.1 2.6.3-1.8.6-2.2 1.6-2.6 1.3-.4.6-1.1.3-2.2 1.6-1.1 4.1 0 5.3-2.2.3-.4 1.3-.7 1.3-1.5-.3-.7-1.3-.7-1.9-.7-.3 0-.6 0-.6-.7 1.9-2.2 4.4-1.5 6.6-2.2.6.4 2.2.7.6 1.8-.3.4-.6.4 0 .7.3.3.6.4.9.4.7-.3 1.3-1 1.6-1.8.6.6 1 1.4 1.3 2.2.5 2.4 1.8 4.4 3.5 5.9.4.5 1 .7 1.6.7 3.8.7 7.2 1.8 11 2.2 5.9.8 11.8.3 17.6-1.5 3.8-1.1 7.5-2.6 11.3-3.7 2.5-.7 4.7-1.8 7.2-2.6 3.7-.8 7.4-2.1 11-3.7h.6c3.7-.5 7.3-1.7 10.7-3.7.6-.4.9-1.5 1.6-1.1 2.2.8 4.6.3 6.6-1.1.3-.4 1.3 0 1.6-.7.6-1.1 1.3-2.9 3.5-1.5.3.4 1.3.4 1.9.4 2.9-.8 5.8-1.4 8.8-1.8.6 0 .9 0 .9-.7-.3-1.5.9-1.1 1.6-1.1h1.9c-1.3.7-2.6 1.6-3.8 2.6-1.6.8-3 1.7-4.4 2.9-3.3 1.2-6.3 3.5-8.5 6.6-4.7 1.6-8.8 5.1-11.6 9.9-3.8 1.1-6.3 4.8-10.4 5.5-.2 0-.3.2-.3.4.9 2.2-.9 1.8-1.9 2.2-1 .3-2 .8-2.8 1.5-3 2.2-6.3 3.7-9.7 4.4-5.3 2.2-11.3 3.3-16.6 5.5-1.5.7-3.1 1.1-4.7 1.5-2.4.4-4.7 1.3-6.9 2.6-1.6 1.2-3.3 2.2-5 2.9-5.7 1.4-11.4 3.3-17 5.5-1.4.9-3.1 1.3-4.7 1.1-1.6-.4-3.3 0-4.7 1.1-1.3 1-2.8 1.6-4.4 1.8-5.9 1.1-11.7 2.9-17.3 5.5-1.9.7-3.7 1.7-5.3 2.9.9 0 1.3.4 1.9 0 3.1-.7 6.3-1.1 9.4-1.8 2.5-.4 5-.4 7.5-.7 6-1.5 11.9-2.9 17.6-4.4.6.4 2.2-.4 2.5 1.1.3 1.1-1.3 1.1-1.9 1.5l-.9 1.1c.9.4 1.6.7 2.5 1.1.6 0 1.3 0 1.3.7.1.5-.2 1-.7 1.1h-.3c-1.8 1-3.4 2.4-4.7 4-1.3.4-2.2 1.5-3.8 1.5-1.3-1.1-2.2-.4-3.1 0-3 1.7-6.2 3.1-9.4 4-2.9 1-5.5 2.9-7.5 5.5 1.5 1.5 3.5 2.1 5.3 1.5 3.1-1.1 6.6-1.8 10-2.9 1.6-.7 2.8-2.2 4.7-1.8 1 .3 2.1 0 2.8-.7h.3c1.1 3.4 4.3 5.1 7.2 4 1.3 0 2.8.7 4.1-.4 1-.5 2.1-.2 2.8.7 2.3 1.8 5.2 2.2 7.8 1.1 3.2-1 6.4-1.6 9.7-1.8 3.8-.7 7.5-1.1 11-2.2 6.6-2.2 13.5-1.8 20.1-4.4 1.3-.4 2.5-.4 3.8-.7-6.2 2.8-12.6 4.9-19.1 6.2-6.6 1.8-12.9 3.3-19.5 5.1-6.3 1.8-13.2 2.2-19.8 4.4 2.6 1.2 5.5 1.3 8.2.4 5.5-1.5 11-2.6 16.6-3.3h.3c1.9 0 3.5-1.8 5.6-.4-1.3.8-2.7 1.4-4.1 1.8-1.9-.7-3.1.4-4.7 1.5 1 .4 2.1.4 3.1 0 1.3-.4 2.5 1.8 3.5.4 1.1-1 2.4-1.6 3.8-1.8 1.3 0 2.5.7 3.5-.7.3 1.1 2.2 1.1 1.3 2.2-.6.7-.6 2.2-1.9 1.8-.3 0-.6.3-.6.7 0 .4.3.7.6 1.1.3.4.6 0 .9-.4.3-1.5 1.3-.7 1.9-.7 1.2.5 2.5.2 3.5-.7.3 1.5-.6 2.2-.9 3.7.7-.4 1.4-.6 2.2-.7l.6.7c.3.4-.3 1.5.9 1.5.6 0 .6-.7.3-1.5s.3-.7.6-.4c.6.4.9.4 1.3 0h2.8v.4h-.3c-1.6.4-1.6 2.2-3.1 3.3-.6.4.3 1.5 1.3 1.1.2 0 .3.2.3.4v.4c-.6 1.8-2.8.4-3.8 1.8-.9-.4-1.3-1.8-2.5-1.1-.6-2.6-.6-2.6-3.1-1.5-.2 0-.3-.2-.3-.4-.3-.7 1.3-.7.9-1.8-1.7-.7-3.5-1.1-5.3-1.1 0 1.5-1.3 1.1-1.9 1.8 1.6-1.1 1.3 2.2 2.8 1.5.6.9 1.6 1.3 2.5 1.1.9 0 0 .7.3 1.1-.9 0-1.9.4-2.5 0-.9-.9-2.2-.9-3.1 0-1.4.1-2.7-.1-4.1-.4-3-.4-6.1.3-8.8 1.8-.6.4-1.6 1.1-2.5-.4-.6-.4-1.4-.3-1.9.4-.3.5-.8.7-1.3.7-2.8.2-5.6 1.3-7.8 3.3-.3.4-.9.7-.6 1.5.3.7.6.7 1.3.7h1.9c.6 0 .9.4 1.3 1.1.3 1.5-1.3 1.8-.9 2.9-.3-.4-.9-.4-1.3-.7-1.3-1.1-2.5-1.5-3.5-.4-.7.7-1.6 1.1-2.5 1.1-1.3.4-2.5.4-2.5 2.2 0 .7-.6.4-.9 0-.3-.4-.3-1.1-.6-1.5 2.4-1.5 4.5-3.5 6.3-5.9-1.9-.7-2.5 1.1-3.5 1.1-2.2 0-4.7-.4-5.3 2.9l-.3.4c-2.2.4-4.1 1.8-6.6.7-1.6.7-3.1 1.1-4.7 1.8-.8-.9-2.1-.9-2.9.1-.1.1-.2.2-.2.3-.6.7-1.9.7-1.6 2.2-.3 0-.9.4-1.3.4-.9.4-1.9 1.1-2.8.7-.9-.4-1.9-.1-2.5.7-.6.7-.9 1.8-1.9.4-.2-.3-.6-.4-.8-.1l-.1.1c-.6.4.3.7.3.7.3 1.1 1.3 2.6 0 3.7.7-.1 1.5.1 2.2.4-.6.4-.9.7-1.3.7.3.7 1.3-.4 1.3.4-.1.6-.3 1.1-.6 1.5-.9-.7-1.6 1.8-2.5.4-.6-1.5-1.6-1.1-2.5-1.1-5.9.5-11.7 2.7-16.6 6.6-1.7 1.8-4 2.6-6.3 2.2-.5-.1-1 .2-1.3.7 1.3 0 2.8-.4 4.1-.4.9 0 1.3-.4 1.6 1.1.3 1.8 1.3 2.6 3.1 1.5.9-.4 2.5-1.8 2.5 1.1 0 .4.6 1.1.9 1.5-2.2 1.1-4.7 1.1-7.2 2.2 2 .3 3.7 1.9 4.4 4 .3 2.6 2.5 4.4 3.5 6.2 1.6 3.7 3.5.7 5.3 1.5h.3c-1.9 1.1-3.1 2.2-3.5 4.4v.4-.4c-.6-.4-1.6.7-2.2 0-.3-1.1-1.3-1.1-2.2-1.1-.3 0-.6.3-.6.7 0 .7.9.4 1.3.7 0 .7-1.3.7-1.3 1.5-.3 0-.3.4-.6.4-.3-.4-.6-1.1-1.3-1.1-1.6-.4-1.6-1.1-.9-2.2.3-.4.9-.7.6-1.1-.4-.4-.9-.4-1.3 0-1.3 1.1-3.1 1.5-4.7 2.6-.3.4-1.3.4-.9 1.5s1.3 0 1.9.4l-.9 1.1c-.3.4-.9.7-.3 1.1.3.4.9.7 1.3.4.6-.7 1.9-1.1.9-2.6 1.3.4 3.1-2.2 3.5 1.5-.3 0-.6.4-1.3.4-1.9.4-1.6 2.6-2.8 3.7-.3 0-.3 0-.6.4H103c.9-1.8.9-1.8-.9-2.2-.6-.7-1.6-2.2-2.2-1.5-.9 1.1-2.8 1.1-3.1 2.9-1.6.4-3.1 1.8-4.4 1.5-3.5-1.1-5-.7-6.3 2.6 1.3.4 1.9-1.5 2.8-.7 1.9 2.2 3.5.4 5 .7-.8.3-1.5.8-2.2 1.5-1.3 2-3.2 3.3-5.3 3.7-.9.4-1.9 1.5-2.5-.7-.5-.4-1.1-.4-1.6 0-1.6 1.8-3.8 2.6-5.3 4.4-.6.7-2.5.4-1.9 1.8s1.9 0 3.1.4c.3 0 .6-.4.9-.4 2.2-.7 4.4-1.5 6.9-2.2 0 .4.3.4.3.7-2.2 1.5-4.1 3.3-6.3 4.8-.3.4-1.6 0-1.3 1.1.3.7.9.4 1.6.4h1.3c4.4-2.1 9.1-3.1 13.8-2.9.4-.1.8-.2 1.3-.4 0-1.8 1.3-1.1 1.6-.7.7.5 1.5.6 2.2.4 2.5.4 4.7-1.5 7.2-.4.6 0 .9-.4 1.6 0 1.3 1.5 2.5.7 3.8 0 .3 0 .9-.4 1.3-.4 2.8-.4 5.3-.7 8.2-1.1 1.3 0 3.5-.4 3.8-2.6 0-.4.3-.7.6-.7 2.2 0 4.4-1.5 6.6-1.5.3.4-.3 1.1.9 1.1 1.9 0 3.1 0 3.8-2.2 2.8-.7 5.6-1.1 8.5-1.1 1.9 0 3.8 1.1 5.3-.4.2 0 .5.2.6.4 1.3.7 2.2-.4 3.5 0 .3 0 .9-.4.6-1.1-.3-.7-.9-.4-1.3 0-.9 1.5-2.5.4-3.8.7-.9.4-.9-.7-.9-1.1 0-.7.3-1.1 1.3-.7.9.5 2 .2 2.5-.7 0-2.9 1.9-1.8 3.1-1.8 1.4.1 2.8-.1 4.1-.7 2.1-1.3 4.3-2.3 6.6-2.9l.6.7c-.6.7 0 1.1.6 1.1s1.6-.7 1.3-1.5c-.3-1.1-.9 0-1.6 0-.3-1.5.9-1.1 1.3-1.5 3-.4 5.9-1.2 8.8-2.2 1.3 1.1 1.3 1.8-.3 2.2-1.8.1-3.5.7-5 1.8-.3.7-1.3 1.1-.3 1.8.6.4.9 0 1.3-.4.3-.4 1.3-.4 1.6-.4 2.5-.7 5.3 0 7.5-1.8.9-.7 1.3-1.1 0-1.8 0-.7.9-1.1.6-1.8-1.6-1.8.6-1.5.9-2.2.6 0 .9.4 1.6 0 5.3-2.6 11-4 16.3-6.2-1.3.7-2.4 1.9-3.1 3.3-.3.8-.9 1.3-1.6 1.5-3.5 1.5-3.5 1.5-2.5 
                    5.5v.4c-.6 1.5-.9 2.9-2.8 2.6-.6 0-1.1.5-1.3 1.1.3 2.2-1.3 2.9-2.5 3.7-.6.4-2.2.4-1.6 2.2 0 .4-.1.8-.3 1.1-2.5 2.2-5.3 4-7.8 6.6-1.8 1.3-3.4 2.9-4.7 4.8-1.9 1.1-2.5 3.7-3.5 5.9 1.9-1 3.7-2.4 5.3-4l.3-.4c1.3-.4 1.9-1.8 2.8-2.6.6 0 .9-.7 1.3-1.1 1.6-2.1 3.6-3.7 6-4.4 1.8.7 3.7.4 5.3-.7.3-.4.9-.7 1.3-.4.6.7 0 1.1-.3 1.8-.6 1.1-1.9 1.8-1.9 3.3-.6.3-1.2.4-1.9.4-1.6 0-6 3.3-6 4.8.3 3.7-1.9 4-3.8 5.1-1.3.7-2.8.7-3.1 2.6-.6 3.7-3.1 5.5-5.6 7.3-2 .6-3.3 2.7-3.1 5.1.1 2.1-.9 4-2.5 4.8-.6.4-1.3.7-.9 1.5.6 1.1.3 2.6.3 4-2.2 2.6-2.5 6.2-4.4 8.8-.3.4 0 1.5-.3 1.8-.3 2.2 0 5.1-1.9 6.6-4.1 2.9-5 8.1-7.5 12.5-.9 1.5-1.3 3.3-2.5 4.4-1.3 1.1-1.6 3.2-.6 4.8 1.5 2.2 1.6 5.3.3 7.7l-.9 3.3c-.6 1.8-.6 4.4-2.5 5.5-1.3.4-1.3 1.8-2.2 2.6-2 1.9-3.6 4.3-4.7 7-.3.7 1.3 3.3-1.6 2.6 0 .3-.1.5-.3.7-2.2 1.8-1.3 5.1-1.9 7.7-.3 1.8.6 1.8 1.6 1.5.5 0 1-.3 1.3-.7 1.8-1.2 4-.7 5.3 1.1l.6.4c.9-1.1 1.9-.4 3.1 0 1.5.4 2.8 1.5 3.8 2.9 1.6 2.4 4 3.8 6.6 4 .6 1.1.6 1.1 2.2.7.6 0 1.6-.7 1.9.4.6 1.8 2.2 3.3 1.9 5.1-.6 3.3 2.2 3.7 3.8 4.8 1.3.7.6-1.5 1.3-2.2.2-.2.4-.3.6-.4 1.7-1 3.3-2.2 4.7-3.7 1.6-1.3 3.4-2.3 5.3-2.9 1.9-.4 3.8-.4 5-2.2.4-.5 1-.6 1.5-.1l.1.1c1 1 1.8 2.2 2.2 3.7.3 1.5 1.7 2.4 3 2 .2 0 .3-.1.4-.2 1.3.4 2.5-.4 3.5 1.1.2.3.6.4.8.1l.1-.1c1.3-3.3 3.1-2.6 5.6-1.5.9 1.1 1.6 2.5 1.9 4 .9 2.6 3.5 2.9 6 .7-1.9.7-2.8-.7-3.8-.7 0-2.2 1.3-1.5 2.5-1.8.6-.4 2.5 2.6 2.2-.7 0-.4.6-.4.9-.7.6 0 .6.4.6.7 1.6 3.3 2.5 3.7 5.6 2.6 1.2-.5 2.5-.6 3.8-.4 1.3.7 3.1-.4 3.1-1.8 0-2.2.9-2.6 2.2-2.9.3.7 1.6.4 1.9 1.5.3 2.6 1.6 1.1 2.8.7.3 0 .6-1.1.9-.7 1.9 1.8 2.5-.4 3.1-1.1.6-.7 1.6-1.5 1.6-2.6 0-.4-.3-.4-.6-.4-1.1-.2-2.2.4-2.8 1.5-.3 0-.3.7-.3.7-.3.4-.6.7-1.3.4-1.3-.7-2.8-.7-3.8-2.2-.3-.4-.6-.7 0-1.1 1.3.7 2.5-.7 3.8-.4 1.6.4 2.8-.7 4.4-.7.3.4.6.4.6 0 0-1.8.9-1.5 1.9-1.8 1-.2 2.1-.2 3.1 0 1.3 0 1.6 1.1.6 1.8-1.2.8-1.7 2.5-1.3 4 0 .4-.9.4-.3 1.1.4.4.9.4 1.3 0 1.6-1.8 3.8-1.5 5.6-2.6 1.3.4 1.6-.4 1.9-1.5 0 2.2.6 2.9 1.9 1.5.5 0 1 .3 1.3.7.3.4.9.7 1.3 1.1s.9.7 1.3 0c.9-2.2 2.8-1.8 4.4-2.2 1.3 1.8 1.9 2.2 2.8.4-.6-1.1 0-1.5.9-1.8 1.2-.1 2.3-1 2.8-2.2.6-.7 0-1.5-.3-1.8 0-.4-.3-.7-.3-1.1.9-.7 0-1.8 0-2.6 1.1-.9 2.5-1 3.8-.4h.3c.3.4.3.7.3 1.5-.9 2.2-.9 2.2 1.6 2.2h1.4c-.3.4-.3 1.1-.6 1.5-.3 1.1.3 1.5.6 2.2 1.3-1.5 2.2.7 3.5 0 .6-.4.6-1.5 1.3-1.8-.3 2.6 1.6 3.7 3.1 5.1 1.3 1.4 3 2.2 4.7 2.2 2.5 1.1 5.2 1.5 7.8 1.1 1.7-.2 3.4-.2 5 0 3.5.4 7.1.4 10.7 0 3.5-.4 6.9-.3 10.4.4-3.3 2.3-6.8 4.2-10.4 5.9 0-.4 1.3-.7.6-1.1-.3-.4-.9.4-1.6.4-.9.4-.6.7-.3 1.1-2.3.6-4.5 1.6-6.6 2.9-.9.6-1.9.8-2.8.7-.6 0-1.3 0-1.6-.7 0-.4 0-1.1-1.3-1.1-1.9 0-3.8.4-5.6 1.1-5.7 1.5-11.1 4.5-15.7 8.8-.6.7-1.3.7-2.2 1.1-1.6.7-3.5 0-5 1.8 1.9-.4 3.5-.7 4.7-1.1.6 0 1.3-.4 1.9 0-.6.7.6 1.1.3 1.5-.3.7-1.3.7-1.9.7-.9 0-1.8.5-2.2 1.5 1.6-.2 3.2-.6 4.7-1.1 1.9-.7 1.9.4 2.2 1.5.3 1.1-.9 1.1-1.6 1.5-2.2.7-4.7 1.8-6.9 2.6 1.8-.3 3.6-.8 5.3-1.5.6-.4 1.3-.7 1.6 0 .3.7 1.3 1.1 1.6 1.8l-6.6 2.2c-.3 0-.9 0-.6.7 0 .7.6.4.9 0 1.9-.7 3.5-1.1 5.3-1.8 1.3-.4 2.2-.7 1.9.7 0 .4.3.7.6 1.1.9 1.1 2.5 1.8 3.1 2.9 1.6 2 4 3 6.3 2.6 6.5.7 13 .4 19.5-.7.6.4 1.3-.4 1.6 0h-.3c-.3 0-.9.4-1.3.4-1.5.8-2.6 2.5-2.8 4.4 0 .7-.6 1.1 0 1.8.6.2 1.4.1 1.9-.4.3.1.7-.1.9-.4.6.4 1.3-.4 1.9-.4.8.1 1.7-.1 2.5-.4.6.4.9 1.5 2.5.7h1.9c1.9.7 3.8-.7 5.3-.7h.3c-.3 1.1.6 1.5 1.6 2.2-1.4 1-2.9 1.7-4.4 2.2-.9.4-1.6.7-1.6 1.8-1.6 1.8-4.1 2.6-6.3 4.8 1.1-.2 2.1-.4 3.1-.7 1.3.4 2.2.7.3 1.8-.3 0-.6.3-.6.7 0 .4.6.4.9.4h1.3c0 .4-.6.7 0 .7 1.8 0 3.6-.4 5.3-1.1.3 1.5-.6 2.9.9 4 .3.4 0 1.1-.9 1.5-.3 0-.6.4-.3.7.9.4.9 1.1.6 1.8-.3.7 0 .7.6.7 1.6-.4 1.6 1.1 2.5 1.5-.9.7-.3 2.2-1.3 2.9-1.3.4-.6 1.1-.6 1.5 0 .4.6.4 0 .7-1.3 1.1 0 1.1.6 1.5.7.3 1.5.1 2.2-.4 1.3-.4 2.2-.4 3.5-.7.3.4 1.3-.7 1.6 0 .3.4-.3 1.1-.6 1.5-.3 0-.3.4-.6.4-.6.7-.9 1.8.6 1.5h2.8c-.3 1.2-1 2.1-1.9 2.6-1 .4-1.9 1.2-2.5 2.2-.6.3-1.1.7-1.6 1.1-.6.4-1.9.7-1.3 1.8.6.8 1.6 1.1 2.5.7 2.5.7 5 .8 7.5.4 1.4.4 2.9.4 4.4 0 .6 0 1.3-.4 1.6 0 .6.7 1.6.4 2.2.7 1.9.4 4.4-1.5 5.6.7h.6c2.5-.7 5-1.1 7.5-1.1 3-.8 6-1.4 9.1-1.8 2.4-.2 4.9-.7 7.2-1.5.9-.4 2.2-.4 3.1-.7 5-1.5 10-1.8 15.1-3.7 1.9-.1 3.8-.6 5.6-1.5 4.4-1.1 8.5-2.9 12.9-4 3.6-.7 7.2-1.8 10.7-3.3 4.7-1.5 9.7-2.6 14.4-4.4 5.3-1.8 10.7-3.3 16-4.8 1.5-.7 3.1-1.2 4.7-1.5 4.1-.5 8.1-1.7 11.9-3.3 1 .2 2 .1 2.8-.4 4.4-1.5 8.8-2.9 13.5-4 1.9-.4 3.8-1.1 5.6-1.5 1.4-.3 2.8-.8 4.1-1.5h.6c1.3.7 2.8.4 3.8-.7.3-.4.9-.4 1.3-.7.3 0 .3-.4.6-.4s.3 0 .6-.4c1.6-.7 3.3-1.1 5-1.5 1.3 0 2.5-.7 3.8-.7 1 .2 2.1.2 3.1 0 1.6-.9 3.3-1.4 5-1.5.9 0 .9-.7 1.3-1.5 2.5-1.1 5.3-1.1 7.8-2.2h.6c.9 1.1 1.6-.4 2.2-.7.3 1.1-.3 2.2.3 3.3.7 1.3.8 3 .3 4.4 0 1.4.2 2.7.6 4-.3.4-.6.4-.9.7h-.3c-1.7-.1-3.3.4-4.7 1.5-1.6.7-2.8 0-4.4.4-5.7.6-11.3 2-16.6 4.4-.9.4-1.9.7-2.8.7-2.8.2-5.6.9-8.2 2.2-.6 0-1.3.4-1.9.4-4.5.8-8.9 1.9-13.2 3.3-.9-.9-2.2-.9-3.1 0-1.6.7-3.8.4-5 1.8-.2.3-.6.4-.8.1l-.1-.1c-.9-.7-1.6-.4-2.5.4-.3.5-.8.7-1.3.7-1.8-.1-3.5.4-5 1.5-.9.4-1.6.4-2.5.7-2.4.7-4.8 1.2-7.2 1.5-2.2.4-4.4 1.1-6.6 1.5h-.3c-1.3.2-2.6.6-3.8 1.1-.3 0-.9.4-.6 1.1.2.3.6.4.8.1l.1-.1c.6 0 .9-.4 1.6 0 1.4.8 2.9 1.1 4.4.7 1.6-.7 2.8-1.8 4.4-1.1 1.6 0 3.1-.5 4.4-1.5v-.2c-1.9-1.5.6-1.1.9-1.8h1.3c2.8.1 5.6-.5 8.2-1.8 1.2-.7 2.5-.9 3.8-.7-.6.7-1.6.7-2.2 1.5l2.8-1.1c.6-.4 1.3-.4 1.9 0 1.5.7 3.2.1 4.1-1.5.3-1.1 1.6-1.1 2.2-1.1.9 0-.6.7.3 1.1 1.6-1.8 4.1-1.5 6.3-2.2.9-.4 1.9-.7 3.1-1.1-.8 1-1.6 1.8-2.5 2.6 1.6 0 2.8.7 3.8-.4 1-.7 2-1.2 3.1-1.5.6.8 1.6 1.1 2.5.7 1.9-.4 1.6-1.8 2.5-2.6.8-.8 1.8-1.3 2.8-1.5 1.2-.1 2.4-.6 3.5-1.5l2.8-1.1c.3.4 1.6-.4 1.6.7 0 .7-.6 1.1-.9 1.5l4.7-1.1c.6-.4 1.9-.4 1.9-1.1s-1.3 0-1.6-.4v-.6c1.9.7 2.5-1.5 4.4-1.5 1.3.4 2.2-.4 3.5-.7 1.3-.4 2.2-.4 1.3 1.1-.3.4-.3.7 0 .7.3.4.6-.4.9-.4 1.6-.7 1.9-2.2 3.5-2.6 2.1 1 4.4.5 6-1.5.3-.4.9-.7 1.3-.4.3 0 .3.4.3.7-.9 1.5.3.7.9.7 1.3 0 1.3 1.1 1.3 1.8 0 2.2 1.3 1.5 2.5.7 2-1 4.1-1.6 6.3-1.8.6 0 1.3-.4 1.9-.4 3-1.6 6.2-2.8 9.4-3.7.5-.1.9-.3 1.3-.7.8-1.1 1.9-1.6 3.1-1.5 1.3-.4 2.5-.7 3.5-1.1 2.5-.4 4.7-2.2 7.2-2.6 2.5-.5 4.8-1.6 6.9-3.3 2.5-.6 5-.9 7.5-1.1 1.6-.4 2.5-1.5 4.1-1.8.4-.1.9.1 1.3.4.6 1.1.6 1.1 1.9 1.1h1.3c0 1.1 0 1.8-1.6 1.5-1.3-.4-4.1 1.8-4.7 3.3 2.5-1.5 5.3-1.5 7.5-2.9 2.1-1 4.3-1.7 6.6-2.2.6 0 1.9-.4 1.6-.7-.6-1.1.3-.7.6-.7.9-.1 1.7-.3 2.5-.7 3.3-1.5 6.8-2.2 10.4-2.2.3 0 .3-.4.6-.4 1.6-.4 3.1-1.1 4.7-1.5l17.6-4.4c4.5-.8 8.9-2.1 13.2-3.7.6-.3 1.2-.4 1.9-.4 2.3.5 4.7.2 6.9-.7 1.8-.7 3.7-1.2 5.6-1.5 2-.3 4-.8 6-1.5l14.1-5.5c11.6-4.8 23.2-8.8 34.5-14.7 4.7-2.6 9.4-4.4 14.1-7 6.9-3.7 13.5-7.7 20.1-11.7.7-.5 1.4-.9 2.2-1.1 2.2-.6 4.3-1.5 6.3-2.6 2.8-.7 5-2.9 7.8-3.7 1.1-.3 2.2-.8 3.1-1.5.9-.8 1.8-1.4 2.8-1.8 4.1-1.5 8.1-3.3 11.9-5.5 2-.7 4-1.6 6-2.6 2.7-2 5.5-3.6 8.5-4.8 1.8-.8 3.4-1.7 5-2.9 2.1-.9 4.1-2.1 6-3.7.9-.7 2.2-.4 2.8-1.5 1.4-2 3.1-3.6 5-4.8 3.6-2.7 7.7-4.4 11.9-4.8 1.3 0 2.2-.7 2.2-1.8 0-1.5.9-1.8 2.2-2.6 2.2-1.1 4.1-2.2 6-3.3 2.8-1.5 5.6-2.6 8.5-4 1.7-.6 3.2-1.5 4.7-2.6.3 0 .6-.4.3-.7-.6-.7 0-1.5.6-2.2 1-.3 2-.8 2.8-1.5 0-.2-.1-.4-.3-.4l-2.8 1.1c-1.3 0-1.3-.4-.9-.4.6-1.1.9-2.2 2.2-2.9 1-.2 1.9-.9 2.5-1.8 1.3-.4 2.5-1.1 3.5-2.2l2.8-1.1c3.3-1.1 6.4-2.6 9.4-4.4h.3c3.1-1.1 6.3-1.8 9.4-2.9 4.4-1.5 8.5-3.7 12.9-4.8 3.2-.8 6.4-2.1 9.4-3.7 1.1-.8 2.2-1.4 3.5-1.8 6.3-1.8 12.6-3.7 18.8-6.2 7.2-2.8 14.1-6.5 20.7-11 1.4-.5 2.9-.6 4.4-.4 1 .4 2.1.1 2.8-.7.6-.4 1.3-1.1 0-1.5-.6 0-1.3-.4-.9-.7.6-1.5-.6-1.5-1.6-1.5.6-.7 1.9-1.1 2.5-1.8.9-.4.9-1.5.3-1.5-1.6 0-2.8-1.1-4.4-.7-1.8.9-3.7 1.3-5.6 1.1-.6 0-.9 0-1.3-.4-1.6-1.8-2.2-1.8-4.7-1.1-1.9 1-3.9 1.9-6 2.6-.8.1-1.5.3-2.2.7-2.2.9-4.4 1.6-6.6 2.2 1.9-1.5 2.8-2.9 4.4-2.9 1.1.1 2.2-.3 3.1-1.1 2.3-1.1 4.5-2.3 6.6-3.7.6.4 1.3.7 1.6-.4s1.3-1.5 2.2-2.2c.9-.4 2.8-.4 2.2-2.2h.4c0 .4 0 1.1.9.7-.3.7-.3 1.5.9.7.9-.7 2.2-1.5 2.8.4.3-1.1-.3-1.8 0-2.9v-.8c0-1.5.9-1.8 2.5-1.8-.6.4-1.6.7-1.3 1.5.3.7 1.3 0 1.9 0 .5 0 1-.3 1.3-.7 1.5-.1 3-.9 4.1-2.2.3-.7 1.6-.4 2.2-1.1 1.6-.4 3.1-1.1 4.7-1.5 0-.4-.3-.7-.3-1.5.3-.4 0-.4 0-.7.3-.4.3-.4.6-.4.6-.4 1.3-.7 1.3-1.5-.5-.6-1.3-.7-1.9-.4-1.3.4-2.5 1.1-3.8 1.5-.5.2-1.1.2-1.6 0-.3 1.5-1.3.4-1.9.4-.6 1.1.3 1.1.6 1.8-.6-.1-1.3.1-1.9.4-2.4 1.3-4.9 2-7.5 2.2-.6 0 0-1.5-1.3-1.1-.9 0 .3 1.1-.6 1.1-.5-.8-1.3-1.2-2.2-1.1 0-.4.9-.7.6-1.1s-.6 0-.9 0c-.9.4-1.9 1.1-2.8 1.5-1.9.7-3.8 1.5-5.3 2.2-1.4.2-2.7.9-3.8 1.8-.3 0-.3 0-.6.4-1.6-1-3.7-.8-5 .7-.3.3-.6.4-.9.4-.9-.7-1.3.4-1.9.7-.3.4-.6 1.1-1.3.7-1.6-.4-2.8 1.1-4.1 1.5-.7 0-1.3.3-1.9.7-.6 1.5-1.3 1.5-2.5 1.1-1.1-.4-2.2.1-2.8 1.1-.6 1.1.9.7.9 1.1-1.6.9-3.3 1.6-5 2.2-.9.3-1.7.7-2.5 1.1-.7.4-1.5.4-2.2 0-2.9 0-5.7 1.3-7.8 3.7-.2.7-.9 1-1.5.8h-.1c-1-.2-2-.1-2.8.4-1.7.7-3.6.7-5.3 0 .3-.7.6-.4.9-.4 5.6-2.9 11.9-5.1 17.6-8.1 3.8-1.8 7.5-3.3 11.3-4.8 3.2-1.7 6.4-3.2 9.7-4.4 2.9-1.2 5.7-2.7 8.5-4.4-.6 0-.9 0-1.3.4-4.4 1.3-8.7 3-12.9 5.1-4.4 2.2-8.9 4-13.5 5.5-2.5 1.6-5.3 2.6-8.2 2.9-.7.1-1.3.4-1.9.7-4.7 2.6-9.7 4.4-14.4 6.6-2.3.9-4.6 1.7-6.9 2.2-.3 0-.9.4-1.3 0v-.7c-.3-.7.6-1.5.9-2.2 2-1.2 4.1-2.2 6.3-2.9l2.8-1.1c.9-.4 1.3-1.1.6-1.8 1.9-1.1 4.1 0 6-1.1-.6-.7-1.6 0-1.9-.4.5-.3.9-.7 1.3-1.1h.6c0 .6.4 1.1.9 1.1.6 0 1.6 0 1.3-.7-.6-1.1.3-1.1.6-1.8l.9-1.1c1.4 0 2.8-.3 4.1-.7v.4c1.3.7-.9 1.1-.6 1.8 1.3 0 2.2-.7 2.2-2.2 2.2.7 2.2.7 3.5-1.1 0-.4 0-.4.3-.4.9-.4 2.2-.4 2.5-1.8 1.2-.1 2.2-.6 3.1-1.5.6 0 .9-.4 1.6-.7.3 0 .9-.4.9-.7-.3-.4-.6-.4-1.3-.4-1.6.7-3.1.7-4.4 2.2-.9-.3-1.9-.1-2.5.7-1 .1-1.9.3-2.8.7h-.3c-.9-.4-1.3.4-1.9.7-.3.4-.6 1.1-1.3 1.1-.3-.4 0-1.1-.3-1.5-.6.4-1.2.7-1.9.7h-.3c-1-.1-1.9.7-2.2 1.8-.6-.4-1.3-1.1-1.6.4 0 .4-.3.7-.9.7-1.1-.2-2.2.4-2.8 1.5-.3.4-1.6.4-1.9.7-.3 0-1.9 0-.6 1.1.3.4-.3.4-.6.4-1.1-.4-2.4-.3-3.5.4-1.6-.7-2.2-.7-2.8 1.1 0 .4-.3.4-.9.7-1.3.4-1.9 0-2.5-1.5-.2.9-.8 1.6-1.6 1.8-.9.4-.6.7-.3 1.5-1.3 1.1-3.1.4-4.4 1.8-.3.4-1.3.4-1.3 1.1 0 .4.9.4 1.3.4s.6 0 .6.4c-1.7 1.2-3.7 1.8-5.6 1.8-.3-.4-1.9-.4-.3-1.1.3-.4.3-.4 0-.7-.3 0-.6-.4-.9 0-.6.4-1.1.9-1.6 1.5-.6.7.3.7.9.7.6.4-.3.4 0 .7-.3 0-.3.4-.6.4-.3-.7-1.3-.4-1.3-1.1 0-.7 0-1.5-.9-1.5-1.3 0-.6 1.1-1.3 1.5-1.3.4-2.7.7-4.1.7-1.6-.4-1.3.7-1.6 1.5-.2 0-.5.2-.6.4h-.9c-1.5-.6-3.1 0-4.1 1.5-.3.4-.9 1.5-1.9 1.1-.3 0-.6 0-.6.4s.3.4.6.4h.9c.9 1.5.9 1.5-.9 2.6-.3-.4-.3-1.5-1.6-.7-1.3-.3-2.7-.4-4.1-.4-.3-.1-.7.1-.9.4-1.6.2-3.2.7-4.7 1.5-2.5 1.8-5.6 2.2-7.8 4 .3 1.5-.6 2.2-3.1 2.9 1.9-.7 1.9-.7 2.2-1.5-3 0-5.9.4-8.8 1.1 1.6-.8 3.1-1.9 4.4-3.3.9-1.1 2.2-1.1 3.1-1.8.3.7.9.7 1.9.4 1.3-.1 2.5-.7 3.5-1.8 2.5.4 
                    4.1-1.8 6.6-2.2 1.6-.4 3.1-1.8 4.7-2.2.9-.7 2.2-.4 3.5-1.5-.9 0-1.6-.4-2.2-.4 1.2-.9 2.6-1.6 4.1-1.8.9-.4 0 .4.3.4-.3 0-.6.4-.3.4.5.3 1 .5 1.6.4 1.5-.8 3.1-1.4 4.7-1.8.3 0 .6 0 .6-.4s-.3-.4-.6-.4c-.3-.4-.6.4-.9 0l.3-.4c.3-.4 1.3-.4.9-1.1-.3-.4-.9 0-1.3.4l-5.6 2.2c.3-.4.6-.4.9-1.1.3-.4.6-.7 0-.4-.9 0-1.7.3-2.5.7-1.6.5-3.2 1.3-4.7 2.2-1.3.3-2.6.8-3.8 1.5-.3 0-.6 0-.6.4-3.3.8-6.5 2.3-9.4 4.4.6.7 1.3-.4 2.2-.4.6 0 1.3-.7 2.5-.7-5.6 3.7-11.8 6.2-18.2 7.3 4.1-2.6 8.5-3.3 12.2-5.9-1.7.1-3.4.6-5 1.5-1.6 1-3.3 1.7-5 2.2-3.8 1.5-7.8 2.9-11.6 4.4-4.1 1.5-7.8 3.7-11.9 4.8-.9.4-1.3 1.5-2.5 1.5-.9-1.1.9-1.1.9-1.8.9-.4 1.9-1.5 3.1-1.5.3 0 1.3.4.9-.4 0-.4-.3-1.1-1.3-.7-.8.3-1.7.4-2.5.4-1.5 0-3 .4-4.4 1.1h-.3c-1.1 0-2.1.3-3.1.7-.6.4-1.6.7-.3 1.1.9.4.9.7 0 1.1-3.1 1.1-6.3 2.2-9.1 2.9-1.9.4-3.8 1.1-6 1.5 4.5-3 9.4-5.2 14.4-6.6-.6-.3-1.2-.4-1.9-.4-2.4.4-4.8 1-7.2 1.8-2.9 1.1-6 1.5-9.1 1.1-.3 0-.6.4-.6-.4.2-.2.4-.3.6-.4.6.4.6-.4.9-.4 3.1-1.5 6.2-3.2 9.1-5.1 2.5-1.5 5-2.6 7.2-4 1.3-.5 2.6-1.3 3.8-2.2 2.8-1 5.4-2.8 7.5-5.1 4-1.2 7.5-3.9 10-7.7 3.1-1.1 5.6-3.7 8.8-4.4l.3-.4c-.6-1.5.9-1.1 1.6-1.5.9-.4 1.6-.7 2.5-1.1 2.6-1.6 5.3-2.8 8.2-3.7 4.7-1.8 9.4-2.9 14.1-5.1 1.2-.7 2.5-1.1 3.8-1.5 2-.5 4-1.3 6-2.2 1.4-1 2.9-1.7 4.4-2.2 4.7-1.8 9.7-2.9 14.4-5.1 1.3-.8 2.7-1.1 4.1-1.1 1.3.1 2.6-.3 3.8-1.1 1.2-.7 2.5-1.1 3.8-1.5 5-1.3 9.9-3 14.8-5.1 1.6-.6 3.2-1.3 4.7-2.2H897c-2.7.8-5.4 1.4-8.2 1.8-2.1.2-4.2.6-6.3 1.1-5 1.5-10 2.9-14.8 4.4-.6-.4-1.9.4-1.9-.4-.3-.7.9-.7 1.6-1.1.3-.4.6-.4.9-.7-.6 0-1.3-.4-1.9-.4-.3 0-.9 0-.9-.4s.3-.7.9-.7c1.4-.9 2.8-1.9 4.1-2.9 1-.6 2-1 3.1-1.1.9.7 1.9 0 2.5-.4 2.5-1.4 5.1-2.5 7.8-3.3 2.5-.8 4.7-2.3 6.6-4.4-1.3-1-2.9-1.2-4.4-.7-2.8 1.1-5.6 1.8-8.5 2.9-1.2.7-2.5 1.1-3.8 1.5-.8 0-1.5.3-2.2.7h-.3c-1.1-2.4-3.6-3.4-5.6-2.2-1.3 0-2.5-.4-3.5.7-.8.4-1.8.3-2.5-.4-2.1-1.1-4.5-1.1-6.6 0-2.7.9-5.4 1.7-8.2 2.2l-9.4 2.2c-5.6 1.8-11.3 2.2-17 4.4-.9.4-2.2.4-3.1.7 5.1-2.6 10.5-4.4 16-5.5 5.3-1.8 11-3.3 16.3-5.1s11-2.6 16.6-4.4c-2.3-.6-4.7-.5-6.9.4-4.7 1.1-9.1 2.9-13.8 3.7h-.3c-1.6 0-3.1 1.5-4.7.7 1.1-.8 2.2-1.3 3.5-1.5 1.4.3 2.8-.3 3.8-1.5-.9-.2-1.9-.2-2.8 0-.9.4-1.9-1.1-2.8 0-1 .6-2 1.1-3.1 1.5-.9 0-2.2-.4-2.8.7 0-.7-1.9-.4-.9-1.5.3-.4.6-1.5 1.6-1.5.2 0 .5-.2.6-.4 0-.4-.3-.4-.3-.7-.3 0-.6 0-.6.4-.3 1.1-1.3.7-1.6.7-1-.1-2 .1-2.8.7-.3-1.1.6-1.5 1.3-2.6-.6.2-1.3.4-1.9.7-.3 0-.3-.4-.6-.4-.3-.4.3-1.1-.6-.7-.6 0-.6.4-.3 1.1.3.4-.3.4-.6.4-.2-.3-.6-.4-.8-.1l-.1.1c-.7-.1-1.5.1-2.2.4v-.4h.3c1.3-.4 1.6-1.8 2.5-2.2.6-.4-.3-1.1-.9-.7h-.3c.6-1.1 2.5-.4 3.1-1.5.6.4.9 1.1 1.9.7.3 1.8.3 1.8 2.5.7h.3c0 .7-.9.7-.6 1.1 1.4.3 2.9.4 4.4.4 0-.7 1.3-.7 1.6-1.5-1.6.7-.9-1.5-2.2-.7-.3-.7-1.3-.7-1.9-.7-.6 0 0-.4-.3-.7.6 0 1.6-.4 2.2 0 .8.6 1.9.5 2.5-.4 1.1-.2 2.3-.2 3.5 0 2.6 0 5.2-.8 7.5-2.2.7-.6 1.5-.6 2.2 0 .3.4.9.4 1.6-.4.3-.4.6-.7.9-.7 2.4-.2 4.7-1.2 6.6-2.9.3-.4.6-.4.6-1.1 0-.4-.6-.4-.9-.4-.5-.1-1.1.1-1.6.4-.6 0-.9 0-.9-.7-.3-.7.9-1.5.9-2.2.3 0 .6.4.9.4.8.7 2 .7 2.8 0 .6-.7 1.3-.7 2.2-1.1.9-.4 2.2-.4 2.2-1.8 0-.4.6-.4.6 0s.3.7.3 1.1c-1.9 1.2-3.7 2.6-5.3 4.4 1.6.4 2.2-.7 2.8-1.1 1.9-.4 3.8 0 4.4-2.2h.3c1.8-.8 3.7-1.1 5.6-1.1 1.3-.4 2.5-1.1 3.8-1.5.9.6 2.1.5 2.8-.4.6-.4 1.6-.7 1.6-1.5.3 0 .6-.4.9-.4.7-.4 1.4-.7 2.2-.7.9.4 1.6-.4 2.2-.7.6-.7.9-1.1 1.6-.4.3.4.6 0 .9 0 .3-.4-.3-.4-.3-.7 0-.7-.9-1.5.3-2.6h-1.3c.6-.4.9-.4 1.3-.7-.3-.4-.9.4-.9-.4 0-.4.6-1.1.6-1.1.6.4 1.6-1.5 1.9-.4.3 1.1 1.3.7 2.2.7 5-.7 9.8-2.5 14.1-5.5 1.5-1.4 3.4-2.2 5.3-2.2.3 0 .9 0 .9-.7-1.3 0-2.2.4-3.5.4-.6 0-1.3.4-1.3-.7-.3-1.1-.9-1.8-2.5-.7-.6.4-2.2 1.5-1.9-.7 0-.4-.3-.7-.6-1.1 1.9-1.1 4.1-1.1 6-2.2-1.4 0-2.7-.9-3.5-2.2 0-1.8-1.9-2.6-2.5-4-1.3-2.2-2.8-.4-4.4-.7h-.3c1.4-.5 2.6-1.7 3.1-3.3v-.4.4c.6.4 1.3-.7 1.9 0 .3.7.9.7 1.6.4.3 0 .6-.3.6-.7 0-.7-.6 0-.9-.4 0-.4.9-.4.9-1.1.3 0 .3 0 .6-.4.3.4.6.7.9.7 1.3 0 1.3.7.6 1.5-.3.4-.9.4-.6.7 0 .4.6.4.9 0 1.3-.5 2.6-1.3 3.8-2.2.3-.4 1.3-.4.9-1.1s-.9 0-1.3 0c.3-.4.6-.4.6-.7.3-.4.6-.4.3-.7-.2-.3-.6-.4-.8-.1l-.1.1c-.6.4-1.6 1.1-.9 1.8-.9 0-2.8 1.8-2.8-.7.3 0 .6-.4.9-.4 1.6-.4 1.6-1.8 2.5-2.6.3 0 .3 0 .6-.4.6.1 1.3-.1 1.9-.4-.9 1.5-.9 1.5.6 1.5.3.7.9 1.5 1.6.7.9-.7 2.5-1.1 2.8-2.2 1.3-.4 2.5-1.5 3.8-1.1 2.8.4 4.1 0 5.3-2.2-.9-.4-1.9 1.1-2.2.7-1.3-1.5-2.8 0-4.1 0 .6-.4 1.3-.4 1.9-1.1 1.3-1.4 3-2.4 4.7-2.9.6-.4 1.6-1.1 2.2.4 0 .4.9 0 1.3-.4 1.6-1.5 3.5-2.2 4.7-3.3.6-.4 2.2-.4 1.6-1.5-.3-.7-1.6 0-2.5 0-.3 0-.3.4-.6.4-1.9.7-3.8 1.1-5.6 1.8 0-.2-.1-.4-.3-.4 1.9-1.1 3.5-2.6 5.3-3.7.3-.4 1.3 0 .9-.7 0-.7-.9-.4-1.3-.4s-.9.1-1.3.4c-3.7 1.8-7.6 3-11.6 3.3-.3.1-.7.2-.9.4 0 1.5-.9.7-1.3.7-.6-.4-1.3 0-1.9 0-2.2 0-4.1 1.5-6 .7-.3 0-.9.4-1.3 0-1-.6-2.2-.5-3.1.4-.3 0-.6.4-.9.4-2.2.4-4.4 1.1-6.6 1.5-.9 0-2.8.4-3.1 2.2 0 .4-.3.4-.6.4-1.9.3-3.8.8-5.6 1.5 0-.4.3-.7-.6-.7-1.6 0-2.5.4-3.1 1.8-2.4.7-4.8 1.2-7.2 1.5-1.6 0-3.1-.7-4.4.7h-.3c-.9-.4-1.9.4-2.8.4-.3 0-.9.4-.6.7.2.3.6.4.8.1l.1-.1c.9-1.1 2.2-.4 3.1-.7.6-.4.9.4.9.7 0 .7-.3.7-.9.7-.9-.4-1.9.4-1.9.7 0 2.2-1.6 1.5-2.8 1.5-1.2-.1-2.4.1-3.5.7-1.8 1-3.7 1.9-5.6 2.6-.3 0-.3-.4-.6-.4.6-.7 0-.7-.6-.7s-1.3.4-1.3 1.1.6 0 1.3 0c.3 1.1-.9.7-1.3 1.1-2.5.5-4.9 1.3-7.2 2.2-.9-.7-.9-1.1.3-1.5 1.4-.3 2.8-.8 4.1-1.5.3-.4.9-.7.3-1.1-.3-.4-.6 0-.9.4-.4.3-.8.4-1.3.4-2.2.2-4.3.8-6.3 1.8-.9.7-.9.7 0 1.1 0 .4-.9.7-.6 1.1 1.3 1.1-.6 1.1-.9 1.5h-.8c-4.4 2.2-9.4 3.7-13.8 5.5 1.1-.5 2.1-1.4 2.8-2.6.3-.7.9-1.1 1.6-1.1 2.8-1.1 2.8-1.5 2.2-4 .6-1.1.9-2.2 2.5-1.8.5 0 .9-.5.9-1.1 0-1.5 1.3-1.8 2.2-2.6.6-.4 1.9-.4 1.3-1.5 0-.4 0-.4.3-.7 2.2-1.8 4.7-3.3 6.9-5.1 1.5-1 2.9-2.2 4.1-3.7 1.9-1.1 2.2-2.6 3.1-4-1.7.9-3.3 2-4.7 3.3-.2 0-.3.2-.3.4-1.3.4-1.6 1.5-2.5 1.8-.5 0-1 .3-1.3.7-1.6 1.5-3.4 2.7-5.3 3.3-1.6 0-3.1-.4-4.4 1.1-.4.3-.8.4-1.3.4-.6-.4 0-.7.3-1.1.6-.7 1.6-1.5 1.9-2.6.5-.3 1-.4 1.6-.4 1.3 0 5.3-2.6 5-3.7-.3-2.2 1.6-2.9 3.5-3.7.9-.4 2.5-.7 2.8-1.8 1.2-2.4 2.9-4.3 5-5.5 1.5-.4 2.7-1.8 2.8-3.7 0-1.6.9-2.9 2.2-3.3.6-.4.9-.4.6-1.1-.3-.7 0-1.8 0-2.6 1.9-1.8 2.5-4.4 4.1-6.2.3-.4.3-.7.3-1.5.6-1.5.3-3.7 1.9-4.8 3.5-2.2 4.7-5.9 6.9-8.8.7-1.2 1.6-2.3 2.5-3.3 1.3-1.1 1.6-2.2.9-3.3-1.1-1.5-1.1-3.7 0-5.1l.9-2.2c.6-1.5.6-2.9 2.2-4 1.3-.4 1.3-1.5 1.9-2.2 1.7-1.4 3.2-3.2 4.4-5.1.3-.7-.9-2.2 1.3-1.8 0-.2.1-.4.3-.4 1.9-1.5 1.3-3.7 1.9-5.1.3-1.5-.3-1.5-1.3-1.1-.3 0-.6.4-1.3.7-1.4 1-3.2.9-4.4-.4h-.8c-.9.7-1.6.4-2.5.4-1.1 0-2.2-.7-2.8-1.8-1.4-1.5-3.2-2.3-5-2.2-.3-.7-.6-.7-1.6-.4-.6 0-1.3.4-1.6 0-.3-1.1-1.6-1.8-1.3-3.3.6-2.6-1.6-2.2-2.8-2.9-.9-.4-.6 1.1-1.3 1.5-.2.2-.4.3-.6.4-1.5.8-2.8 1.7-4.1 2.9-1.4 1.2-3 1.9-4.7 2.2-1.5.2-2.9.8-4.1 1.8-.3.4-.9.7-1.3.4l-1.9-2.2c-.6-1.1-1.3-1.5-2.8-1.1-.9-.4-2.2.4-2.8-.4-.2-.2-.4-.2-.6 0-1 1.9-3.1 2.5-4.7 1.5.9-1.8 2.5-2.6 3.5-4.4 1.6.4 2.2 0 2.8-1.5.6-1.8 2.5-2.2 4.1-2.9.9-.4 1.9-.4 1.9-1.8 0-1.1.3-1.5.9-.4.3.4.6.4.6 0 1-1.8 2.4-3.2 4.1-4 .9-.7 2.2-1.5 2.2-2.9.6-.4.6-1.8 1.6-1.5 4.1.4 4.7-4.4 7.2-5.9.9-.7 1.9-2.2 3.1-3.3.7-.3 1.3-1 1.6-1.8 1.3-1.8 3.5-2.6 4.4-4.8.6-.4 1.9-1.1 1.3-2.2-.6-1.5-1.3 0-2.2 0-1.9 0-2.8 1.8-4.1 2.9-4.4 2.9-7.5 6.6-11.6 9.9-2 2.1-4.4 3.7-6.9 4.8-1.3.4-1.9.7-1.9 2.2-.9 1.1-1.8 2.1-2.8 2.9-2.5 2.2-5.6 3.3-7.5 6.2-2.5.4-3.8 2.9-6 4.4-1.2.3-2.4.8-3.5 1.5-.6.4-1.3 1.8-1.9.7-.6-1.1.6-1.5 1.3-2.2.3-.4.9-.4 1.3-.7.6-.7 1.9-1.1 1.6-2.6 1.3-1.4 2.8-2.7 4.4-3.7 1.6-1.1 3.8-2.6 3.8-4.8 0-4 2.8-6.6 3.1-10.6.3-2.2 2.2-3.7 2.5-5.9 2.3-5.2 4.3-10.6 6-16.1.5-.7.7-1.6.6-2.6-.9-4 .9-8.1 0-12.5-.4-.8-.2-1.9.3-2.6.2-.3.4-.7.3-1.1.3-3.7-2.2-5.9-4.4-8.1-1.5-2.1-3.6-3.5-6-4-3-1.9-6.3-2.8-9.7-2.6-2 .1-4-.1-6-.7-4.2-1-8.5-1.5-12.9-1.5-4.2.3-8.5-.3-12.6-1.8 3.6-3.2 7.6-5.6 11.9-7.3 0 .7-1.6.7-.6 1.5.6.4 1.3-.4 1.9-.4.9-.4.6-1.1.3-1.5 2.7-.7 5.4-1.8 7.8-3.3 1-.6 2.1-.8 3.1-.7.9 0 1.6 0 1.9 1.5 0 .4 0 1.5 1.6 1.8 2.5.7 4.4-.7 6.6-1.1 6.8-1.6 13.2-5.4 18.2-11 .6-.7 1.6-.7 2.5-1.1 1.9-.7 4.4.4 6-2.2-2.2.4-4.1.7-5.6 1.1-.6 0-1.6.4-2.2 0 .6-1.1-.9-1.5-.6-2.2.5-.8 1.4-1.1 2.2-.7 1.3.4 1.9-.4 2.5-1.8-2.2.4-3.8.4-5.6.7-2.2.7-2.5-1.1-2.8-2.6-.6-1.5.9-1.5 1.6-1.8 2.8-1.1 5.3-2.2 8.2-3.3-2.2-.1-4.3.4-6.3 1.5-.6.4-1.6.7-1.9-.4-.3-1.1-1.6-1.8-1.9-2.9 2.5-.7 5-1.5 7.8-2.2.3 0 .9 0 .9-.7-.3-1.1-.6-.4-1.3-.4-2.2.7-4.1 1.5-6.3 2.2-1.3.4-2.5 1.1-2.5-1.5 0-.7-.6-1.1-.9-1.8-1.4-1.6-2.8-3.3-4.1-5.1-1.7-3.1-4.7-4.9-7.8-4.8-7.9-1.8-15.9-2.3-23.9-1.5-.6-.7-1.3 0-1.9-.4.2 0 .3-.2.3-.4.3-.4.9-.4 1.3-.7 1.8-1.2 3.1-3.3 3.3-5.7 0-.7.9-1.8 0-2.6-.6-.7-1.6 0-2.2.4-.4-.1-.9.1-1.3.4-.7-.3-1.5-.1-2.2.4-.9-.4-1.9-.4-2.8 0-.9-.7-1.6-2.6-2.8-1.5-.8.1-1.7-.1-2.5-.4-2.5-1.5-4.4.4-6.6.4h-.3c0-1.5-.7-2.8-1.9-3.3 1.5-1.2 3.2-2 5-2.6.9-.4 1.9-1.1 1.9-2.2 1.9-2.2 4.7-3.3 7.2-5.9-1.3 0-2.6.2-3.8.7-1.6-.7-2.5-1.1-.6-2.6.3-.4.9-.4.6-1.1 0-.7-.9-.7-1.3-.7h-1.6c0-.4.6-1.1 0-.7-2.2.4-4.4-.4-6.3.7-.6-1.8.3-4.4-1.6-6.2-.3-.4 0-1.8.9-2.2.3-.4.9-.7 0-1.1-1.3-.7-1.3-1.5-.9-2.6s-.3-1.1-.9-1.1c-1.9.4-1.9-1.5-3.1-2.6.9-1.1 0-3.3 1.3-4 1.3-.7.6-1.5.6-2.2 0-.4-.6-.7-.3-1.5 1.6-1.5 0-1.8-.9-2.2-.9-.4-2-.3-2.8.4-1.3 0-2.8.4-4.1.4-.6-.7-1.6.7-1.9-.4-.3-.7 0-1.5.9-2.2.3 0 .6-.3.6-.7.6-1.1.9-2.2-1.3-2.6-.9 0-2.2-.4-3.5-.4-.1-1.6.9-3 2.2-3.3 1.3-.3 2.4-1.4 2.8-2.9l1.9-1.1c.6-.7 2.2-1.1 1.3-2.6-.6-1.3-1.9-2-3.1-1.5-2.9-1.3-6-2-9.1-1.8-1.7-.5-3.6-.6-5.3-.4-.6 0-1.3.4-1.9-.4-.6-1.1-1.9-.7-2.8-1.1-.6-.4-1.3-.4-1.9 0 .3-.4.3-.4.6-.4.6 0 .6-.7.6-1.5s-.6-.4-1.3-.7c-.6 0-1.3.7-1.9 0 1.7-.2 3.3-.8 4.7-1.8.3 0 .3 0 .6-.4.7.4 1.3.9 1.9 1.5 2.8 1 5.8.9 8.5-.4.2-.3.6-.4.8-.1l.1.1c.9 1.1 2.2.7 3.5.4.3 0 1.3 0 1.6.4 1.6 2.2 2.8 1.1 4.1 0 1.1-.7 2.3-1.3 3.5-1.8.6 0 1.3.4 1.9.4.6 1.1 3.1-.4 2.8 2.6 0 .4.3.4.6.4 3.1-.4 6.6 0 8.8-3.3.3-.7 1.3-1.1 1.9-1.8-.4.1-.9-.1-1.3-.4-3.2-2-7.1-2-10.4 0-3.4-1.5-7.3-.7-10 2.2 0-.3-.1-.5-.3-.7.7-.6.9-1.7.4-2.5 0 0 0-.1-.1-.1-.9-1.1-1.3-.4-2.2 0-.6.4-.9 0-.9-.7-.2-.7-.7-1.2-1.3-1.5.3-.4.9-.4 1.3-.7.6-.4.6-.7.6-1.5s-.6-.4-.9-.4c-.6 0-.6 0 .3-.7.6-.4.3-1.5 1.3-1.5.6 1.3 2 1.8 3.1 1.1 1-.9 2.2-1.4 3.5-1.5v.4c-.9.6-1.5 1.7-1.6 2.9.9-.6 1.8-1.1 2.8-1.5.8.5 1.8.3 2.5-.4.8-1 1.8-1.6 2.8-1.8.9-.4.9-.7.3-1.5.3-.4 1.3-.7 1.3-1.5 2.5-.4 3.5-2.6 5-4 .4-.5.8-.8 1.3-1.1 0-1.1.3-2.6 1.6-2.6 1.9 0 1.3-.7 1.3-1.8V261c0-.4.9-.7.3-.7-.3 0-1.3-.7-1.6-.4-.9 1.5-2.8 1.1-4.1 1.8-2.8 1.5-6.3 1.5-9.1 2.6-.6.4-1.9 0-1.6-.4.3-1.5-1.3-1.1-1.3-.7-.3 1.5-1.6-.7-1.9.4-.3 1.1-.9 0-1.3.4-.3-.7-.3-1.1-.6-1.8 1.3-1.5 3.1-.4 4.4-1.5 8.1-2.7 16-6.4 23.5-11 2-.9 3.9-2 5.6-3.3 1.6-.4 
                    3.5-1.1 5-1.5 1.2.2 2.5-.2 3.5-1.1.6-.4.9-.7.6-1.1-.9-.7-1.6-1.5-1.6-2.6.6-.4 1.6-.7 1.9-1.8-2.8-.2-5.5.2-8.2 1.1-1.9.7-4.1 1.5-5.3-.4-.5-.4-1.1-.4-1.6 0-1.6.2-3.1.8-4.4 1.8-3.1 1.8-6.9 2.9-10 4.4-1 .5-2.1.7-3.1.7.6-1.1 1.9-1.8 2.5-2.9-1.2 0-2.3.3-3.5.7-2.2 1.1-4.5 1.9-6.9 2.6-1.6 0-2.8.7-4.1.7-.6-.2-1.4-.1-1.9.4-.6.4-.9 0-.9-.4.7-.4 1.4-.7 2.2-.7 1.3 0 1.3-.7 1.3-1.5.9-.4.9-1.5 1.9-1.8 1.3 0 1.6-.7 2.2-1.8h.6c1.6-1.1 3.3-1.9 5-2.6.6-.4 0-.7-.3-1.1 3.5-1.1 7.2-1.8 9.1-5.5 1.8-.7 3.5-2 4.7-3.7.3-.7.9-.7 1.6-.7h.3c.6 0 .9-.4 1.6-.7 2.3-1.2 4.4-2.8 6.3-4.8v-.1c.3-.7 1.3-.7 1.9-1.1 2.5-1.3 4.9-3 6.9-5.1.3-.4.6-.4.3-1.1-2.8.7-5.5 2.1-7.8 4-6 4.8-13.2 8.1-19.5 12.5-2.5 1.8-5.6 3.3-8.5 5.1-3.6 2.2-7.2 4.1-11 5.9-2.3 1.1-4.5 2.5-6.6 4-2.2 1.5-4.7 2.2-6.9 3.7-3.1 2.3-6.7 3.6-10.4 3.7-2.7-.3-5.4.2-7.8 1.5-.8-.2-1.7-.1-2.5.4-3.4 1.2-6.8 2.7-10 4.4-2.9 1.1-5.8 2.4-8.5 4-.3 0-.3.4-.6.4-.7-.1-1.5.1-2.2.4-2.4 1.2-4.7 2.6-6.9 4.1-4.1 1.8-8.5 2.6-12.6 4.4.6-.7 1.6-.7 2.5-1.5-2.4 1.1-5 1.8-7.5 2.2-1.8.2-3.6.5-5.3 1.1v-.4c0-.4-1.3-.4-.6-.7.6-.7 1.3-1.8 2.5-1.5.9-.4 1.9-.7 1.9-1.5 0-.4-.3-.4-.6-.7-.9 0-1.6.4-1.6 1.1-.3 0-.3.4-.9.4-.3 0-.3-.4-.3-.7s-.3-1.1.3-1.1c1.9-.5 3.8-1.3 5.6-2.2.7-.4 1.4-.7 2.2-.7.3-1.5-1.3-1.8-1.9-2.9.5-.3.9-.7 1.3-1.1.4-.8 1.2-1.1 1.9-.7.9.7 2.8.7.9 2.6-.3.4 0 .7.3 1.1 1.6-.4.6 1.1 1.6 1.5v.3H711c.3.7.6 1.5 1.6 1.1.6-.4 1.6 0 1.9-.7 1.5.2 3.1-.5 4.1-1.8.3-.4.6-.7 1.3-.4 1.6.7 3.1-.4 4.7-1.1.6-.4.9-.7.6-1.1-.3-.7-.9 0-1.3 0-1.6.4-3.1.7-3.8-1.1-.3-.7-.9-1.1-1.9-.4-.6.7-1.6.4-2.5.7-1.6.4-1.9-.4-1.3-1.5.3-.4.9-1.1.6-1.5-.6-1.1-.3-1.8.6-2.2 1.9-.7 3.1-3.3 5.6-2.6 0 .7-1.6.7-.9 1.5.6.7 1.3 0 1.9-.4.6.4 0 .7.3 1.1.3.4 1.3.4 1.3-.4s.6-1.5-.3-1.8c-.6 0-1.3-.4-1.9-.4.3-1.1.3-1.1-1.9-1.5.3-.7.9-1.1.3-1.8.9-1.1.9.7 1.6 0 .9 1.5 2.2 1.1 3.8.4 0 .7.3 1.1 1.3.7.9-.2 1.8.1 2.5.7 0 .4-.9 1.1.3 1.1 1 .1 2 .5 2.8 1.1.3 0 .6.4.9.4.6-1.5 2.2-1.5 3.1-2.6.6-1.1 1.3-1.5 2.2-1.1.6 0 .9.4 1.6 0 1.3-.4 2.8-1.1 3.1.7 0 .4.3.4.6.4s.6-.4.3-.7c-.3-.7.6-.7.9-1.5 1.6-1.5 3.6-2.3 5.6-2.2.3 0 .3-.4.6-.4.9-1.1 2.2 0 3.1-.7.6 0 .9-.7 1.9-1.1 0 1.1-1.3 1.8-.3 2.9h-.4c-.3.4-1.3 0-1.3.7.3 1.1 2.2 1.8 3.5 1.5.9-.4 1.3-.7.9-1.5-.6-1.1-2.5-2.2-.6-4 .3-.4-.6-.4-.3-.7 2.2 1.1 2.8.7 5-1.1 1-.9 2.4-.9 3.5 0l-2.8 1.1c.9 0 1.9 0 1.9.7 0 2.2 2.2 1.5 3.8 1.8-.6-.7-.3-1.5-.6-2.2 0-.3-.1-.5-.3-.7-.6-1.1 0-1.5.9-1.8.3.4-.6.7 0 1.5 3.8-1.8 3.8-1.8 3.5-2.6-.9 0-.9 1.1-2.2 1.1.4-.8.7-1.7.9-2.6.9.7 2.5 1.1 2.5.4.6-1.1 3.5-1.5 2.5-3.3 0-1.1-1.6-.7-1.9-1.5 0 0-.6 0-.6-.4.9-.4.9-1.8 2.5-2.2 1.6-.4 3.5-.4 4.4-1.8.3-.4.9-.4 1.3-.7s.6-.7.3-.7c-.3-.4-.6 0-.9.4-.3-1.5-.3-1.5-1.3-1.5-1.3-.7-2.2 1.1-3.5.4-.9-1.1-2.2-.4-3.5-.7-1.6 0-1.6-.4-.3-1.5.3.7 1.3.7 2.2.7.6 0 1.1-.5 1.3-1.1 0-.4 0-1.1-.3-1.1s-1.3-.4-1.6.4h-.3c0-.4 0-1.1.6-1.1.3 0 .9 0 .6-.4-1.3-1.1 0-1.5.6-2.2 1.1-.6 1.7-1.9 1.6-3.3.2 0 .5-.2.6-.4.6.4 1.6-.7 2.2 0 0 .7.6 1.1 1.6.4.6-.3 1.2-.8 1.6-1.5 0-.4 0-1.1-.6-1.1-.3-.4-.3-.7.3-.7.6-.4 1.3-.4 1.9-.7h.9c1.6-.4 3.1.7 4.4-.7 1-1 2-1.9 3.1-2.7.9-.7-.3-1.5 1.3-1.8.9.4-.6 1.5 0 1.8-.9 1.5.6.7 1.3 1.1.7-.4 1.4-.7 2.2-.7 1.1-.4 2.2-1 3.1-1.8 1.6-1.1 0-1.8-.3-2.6 0 0-.3-.4.3-.7.6.4.9 1.1 2.2.7.6 0 1.3.4 1.6-.4.9-.4 1.9-.4 2.8-.7.3.7.3 1.8 1.6 1.1h.9c2.2.4 2.5-.7 2.8-2.2.3-.4.9-.7 1.3-1.1 3.1-1.5 5.3-3.7 5.3-5.5 1.2.1 2.3.3 3.5.7.3-.7 0-1.1-.3-1.5-.6-.4-.3-.7.6-1.1 1.3-.4 3.1-1.1 2.2-2.6-.3-.7.9-.7.9-1.5-.9-.4-1.9-.7-2.8.4-.3.4-.9.7-1.3.4s-.6-.4-.6 0c-.4 1-1.3 1.6-2.2 1.5-2.7.3-5.5.8-8.2 1.5-.3 0-.9.4-1.3-.4-.6-1.5-.6-1.5-1.9 0-.2 0-.3.2-.3.4h-.3c-.9 0-1.6-.7-2.5 0-.4.3-.8.4-1.3.4h-.9c-.6 0-1.3-.4-1.9-.4-1.9-.4-3.8-.3-5.6.4-1.1.3-2.3.4-3.5.4-1.5-.1-2.9.4-4.1 1.5-.6.4-.9.7-1.6 1.1l-4.7 1.1c.6-1.5-.9-1.1-1.9-1.1-.3-.7.6-.7.9-1.5l.9-1.1c1.3-.4 1.6-1.5 2.2-2.2 2.2-.7 3.1-2.2 2.8-4 1.3-1.1.6-2.6 1.9-3.7.3 0-.3-.7-.6-.4-1.6.4-3.1-.7-4.7 0-.3 0-.9 0-.9-.4.3-1.5-.6-1.8-1.9-1.8-.3 0-.6-.4-.9-.4.6-.7 1.6-1.5 2.2-2.2.9-.7 2.2-1.1 2.2-2.2s.9-1.1 1.6-1.1c.4.1.9-.1 1.3-.4 3.2-1.1 6.3-2.7 9.1-4.8.3.4-.6 1.1-.3 1.8.3-.7 1.3 0 1.3-1.1 0-.4.3-.7.9-.7 1.7-.5 3.4-1.5 4.7-2.9.6-.7 1.9-1.8 2.5-1.5 1.6.7 2.2-.4 3.1-1.1.3-.4.6-.7 1.3-.4.3.4.6 0 .6-.4s0-.7-.6-.4c-.7.1-1.3-.3-1.6-1.1.6-.4.9-1.1 1.6-1.8 1.3-.7 2.5-1.1 3.1-2.2l.3-.4c.9-.4.9-1.8 2.2-1.5 1.3-.7 1.6-2.6 3.5-1.5h.3c.6-1.1 1.3-.7 2.2-.4 2.2.4 3.8-1.1 3.5-2.9 0-.7-.6-1.5 0-2.6-3.8-5.5-4.1-6.2-5.3-6.2z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape35($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M754.1 847.4h-3.8c-1.8-3.6-4.2-6.7-7.8-8.7-1.9-1-3.5-2.4-5.4-3.4-8.1-4.4-16.3-8.8-24.4-13.2-11.1-6-21.4-13-29.1-23.2-.7-1-2.1-1.7-3.4-2.1-4.7-1.5-9.2-3.4-13.2-6.3-3.8-2.7-7.4-5.5-11-8.4-4.2-3.4-8.3-6.7-13.4-8.7-11.8-4.8-23.1-10.8-33.4-18.4-1.6-1.2-3-1.4-4.8-.7-5.1 2-9.6.8-13.4-2.9-.6-.6-1.3-1.2-1.9-1.9-1.3-1.5-2.7-1.9-4.7-1.5-5.2 1.1-10.4.6-15.6-.9-2.3-.7-4.6-1.2-6.9-1.8-6.2-1.7-12.4-1.5-18.4.9-2 .8-3.8.8-5.7-.3-1.7-1.1-3.5-1.9-5.4-2.6-5.4-2.2-6.1-1.9-8.5 3.5-.1.2 0 .5.1 1 8.2 4.5 16.5 9.3 26.3 11.5-1.6 3-3.7 3.4-6.2 3-2.7-.5-5.2-.3-6.9 2-3.9-3.6-4.5-3.7-8.5-1.1-.5.3-1 .7-1.6 1-1.4.7-2.6.8-4-.5-1.2-1.1-3.1-1.5-4.7-2s-3.5-.4-4.5-2.6c1.2-.9 2.4-1.7 3.6-2.6 2.4-1.9 2.5-2.9.5-5.3-1.1-1.3-2.4-2.5-3.6-3.9-2.5 1.6-4.9 3.1-7.5 4.7 1.4 1.6 2.5 2.9 3.6 4.1-2.8 5-8.6 6.3-13.4 2.7-1.7-1.2-3.2-1.6-5.2-1.4-5.1.4-10.2.8-15.3 1-9.1.2-18.3.2-27.4.3-1.5 0-3.1.2-4.6.4 0 .3-.1.7-.1 1 1.1.3 2.2.8 3.4 1 2.6.4 5.2.5 7.8 1.1 2 .5 4.1 1.3 5.7 2.4 1.5 1.1 2.7 1.5 4.4.5 1-.6 2.1-1.1 3.1 0 3.2 3.9 7.8 4.6 12.3 5.7 2.3.6 4.5 1.4 6.6 2.6 2.1 1.1 3.6 3 3.9 6.1-1.8 0-3.5.2-5 0-3.2-.6-6.3-1.4-9.5-2.3-4.7-1.4-9.5-2.8-14.4-1.5-4.3 1.2-7.8 1.1-10.6-2.9-2.8 1.5-5.3 2.8-7.9 4-1.1.5-2.5 1.1-3.5.7-5.9-2.3-12.2-2.5-18.4-3.3-2.1-.3-4.4-1.3-6.1 1.1-.3.4-1.2.4-1.8.4-4.7.2-9.5.5-14.2.4-10.8-.3-21.5-.3-31.8 3.5-1 .4-2.3.5-3.2.1-6.6-3.3-13.1-2.5-19.6 0-2.7 1-5.1 3.2-8.3 1.8-.3-.1-.7.1-1.1.2-1.8.6-3.6.9-5.2-.7-.4-.4-1.6-.2-2.4-.1-3.9.9-7.7 2-11.7 2.7-16 2.5-32.1 5-48.2 7.3-14.1 2-28.2 4.3-42 7.8-2.1.5-4.4.7-6.6.6-7.1-.2-14.2-.4-21.3-1-6.2-.5-12.4-1.5-18.6-2.3-2.1-.3-3-1.5-2.9-3.6.1-1.6-.2-3.2-.2-4.9.5-.4.9-.8 1.4-1.2 7.2-5.3 15.3-7.8 24.1-8.4 4.9-.4 9.7-.7 14.6-1.2 2.3-.2 4.5-.9 6.8-1.4-.6-1-1.1-1.4-1.6-1.5-3-.2-6-.4-9-.3-7.5.2-15 .6-22.5.7-2.6 0-5.2 0-6.8-1.1-1.1-2.7-1.9-4.6-2.5-6.5-.3-.9-.7-2.2-.3-2.8 2.1-2.6 3.8-5.7 7.8-6.3 6.8-1 13.5-2.5 20.3-3.6 8.1-1.3 16.3-2.5 24.5-3.7 1.9-.3 3.6-.9 5.5-1.4 0-.3-.1-.5-.1-.8-.7-.1-1.4-.3-2.1-.2-3.1.2-6.2.5-9.3.9-13.6 1.4-27.1 2.6-40.8 1.7-2.3-.2-4.6-.6-6.8-.9.2-3.9 2.1-5.6 5.3-6.2 3.5-.7 7.1-1.6 10.6-2.4 5.4-1.2 10.7-2.4 16.1-3.6 1.2-.3 2.5-.6 3.7-2.2-3.1 0-5.7-.1-8.3 0-5.5.3-11 .8-16.5 1.1-1.6.1-3.4.4-5.1-1 .8-.6 1.4-1.1 2-1.4 5-2.9 10.5-3.9 16.1-4.5 3.6-.4 7.2-.7 10.8-1.1.7-.1 1.3-.6 2-.9-1-.6-1.8-.9-2.7-.8-3.4.3-6.7.5-10.1.9-1.9.3-3.5 0-5.3-1-2.7-1.5-5.6-3-8.6-3.6-5-1-10.1-1.7-15.2-1.9-6.7-.3-13.5-.1-20.3-.1-5.9 0-11.8-.5-17.3-2.8-2.6-1.1-4.9-1.1-7.6-.5-7.3 1.7-14.4 1.3-20.9-3.1-1.5-1-3-1.1-4.6-1-3.2.3-6.2-.6-8.8-2.4-1.9-1.4-3.8-2.9-5.8-4.2-1.7-1.1-1.8-2.4-1.2-4.2 1.7-5.2 5.3-8.7 9.5-11.7 1.1-.8 2.1-1.5 2.7-1.9-2.1-5.9-4-11.1-5.9-16.4-.7-1.9-1.3-3.8-2.2-5.6-.4-.8-1.3-1.7-2.1-1.9-5.1-1.1-10.2-2.3-15.4-3-1.7-.3-2.9-.7-3.5-2.2-1-2.4-2.2-4.8-2.8-7.3-1.4-5.3-2.4-10.7-3.6-16.1-.8-3.5-2.4-6.5-4.8-9.2-1.8-2.1-4-2.8-6.7-2.1-1.6.4-3.1.9-4.7 1.1-1.5.2-3.1.2-3.9-1.8 1.4-2.8 4.9-3.1 6.9-5.6-3.6-8.5-10.6-15.2-13.2-24.3 2.5-2.1 4.9-4.1 7.4-6.2-1.4-1.2-3.1-2-3.4-3.1-.3-1.1 1-2.5 1.8-4.4-1.5.2-2.6.3-3.6.6-1.9.5-3.8 1.2-5.8 1.4-1.1.1-3-.3-3.3-.9-1.1-2.9-2.4-5.9-2.3-8.9 0-3.6 1.4-7.1 2.1-10.6.4-1.7 1.2-3 2.8-3.8 1.3-.7 2.7-1.3 4-2.1 1.8-1.1 3.7-2.1 5.3-3.6.8-.7 1.5-2.3 1.2-3.2-.3-.8-1.9-1.3-3-1.5-1.2-.2-2.5.2-3.7.2-1.3 0-2.6-.1-4.5-.2.8-4.2 1.5-8 2.3-11.7 1.2-5.7 3.6-10.9 7.7-15.2 1-1 1.4-1.9 1-3.3-.8-2.9.2-5.4 1.8-7.8 1.6-2.3 3.3-4.4 4.7-6.8 1.2-2 2.8-4.3 2.7-6.4-.2-3.7 1.8-5.8 4-7.9 1.4-1.4 3.1-2.5 4.8-3.8-.2-.9-.2-1.8-.5-2.8-1.3-4.4-.8-8.7 1.2-12.8 1.4-2.9 3.1-5.8 5.2-8.2 3.9-4.4 8.1-8.5 12.3-12.6 5.1-5 10.5-9.7 14.7-15.5 3-4.1 5.1-8.7 5-13.9 0-1.8.8-2.7 2.2-3.5 8.4-5.2 14.6-12.4 18.9-21.3 2.1-4.3 4.1-8.6 6.3-12.8 1.8-3.4 3.8-6.7 7-9.1 3.5-2.6 6.7-5.6 9.9-8.5 3.1-2.8 5.9-5.7 9-8.5 13.3-11.9 28.3-21.4 43.7-30.3 12.8-7.3 25.5-14.8 38.2-22.3 1.3-.8 2.6-1.7 3.8-2.6-.1-.3-.3-.6-.4-.9-1.1.3-2.3.4-3.3.9-2 .8-3.8 1.9-5.7 2.8-2.4 1.1-4.7 2.3-7.2 3.2-1.8.7-3.7 1-4.8-1.2.1-.3.2-.6.3-.8.3-.4.6-.8 1-1.1 4.7-3.8 10-6.6 15.7-8.6 5-1.7 9.8-3.7 14.7-5.7 1.2-.5 2.4-1.4 3.3-2.4 3.1-3.7 6.9-6.5 11.1-8.9 7.7-4.4 16-6.9 24.5-9.2 7.9-2.2 15.9-4.3 23.6-7.2 12.3-4.7 24.3-9.8 37-13.2 18.7-5.1 37.3-10.3 55.4-17.5 9.2-3.7 18.6-6.5 28.7-6.9 1.1 0 2.2-.5 3.2-1 10.4-5.2 21.4-8.3 32.8-10.5 8.8-1.7 17.7-3.5 26.1-6.8.7-.3 1.4-.8 2.3-1.4-1.8-3.1-4.5-3.6-7.3-3.2-3.8.6-7.6 1.4-11.3 2.6-5.3 1.8-10.5 4.1-15.7 6-1.3.5-2.5 1.7-4.5.6 1-1.2 2.3-2.1 2.6-3.2.8-2.7 2.9-3.6 5.1-4.5 1.8-.8 3.7-1.6 5.5-2.3 9.3-3.6 19.1-4.7 29-5.8 8.1-.9 16.1-2.1 23.9-4.6 1-.3 2.1-.5 3.2-.8.8 1.1 1.4 2 2.2 3.2 9.1-4.3 18.9-5.4 28.6-7.9-.1 1.4-.1 2.3-.2 3.4 12.8-.4 25.4-1.2 38-1.3 12.6-.1 25.2.4 37.9.7 12.5.3 25 .6 37.5 1.8-3.9 3.1-8.3 4.8-13 5.5-6.8 1-13.6 1.7-20.4 2.6-1.4.2-2.7.7-4 1v1c1.6.4 3.2 1 4.9 1.2 1.7.3 3.5.2 5.2.6 2.9.7 5.7 1.7 8.6 2.3 1.4.3 2.9.4 4.3.3 9.5-.5 18.9-1.2 28.4-1.4 10-.2 20 .3 30 .2 4.8 0 9.7-1 14.3 1.5.6.3 1.5.4 2.2.4 5.7.4 11.5.9 17.2 1.1 2.6.1 4.8.5 7.1 1.7 12.2 6.6 24.5 13 37.9 17.1.9.3 2 .8 2.4 1.6 1 1.9 1.8 4 2.9 6.8-2.3-.1-3.9 0-5.4-.4-4.9-1.1-9.7-2.5-14.5-3.6-2.1-.5-4.4-.8-6.4.5.1.4.1.7.3.9 4.5 4 9 7.9 13.4 11.9 3.7 3.4 7.8 6.3 12.8 7.5.6.1 1.2.6 1.9.9-5 4.5-8.9 3.9-12.4-2.1-1.2.4-2.4.9-3.7 1.2-1.4.3-2.9.3-4.4.4-2.2 2 0 4.1.1 5.7-2.1 1.7-4.1 3-5.8 4.6-2.9 2.8-3.1 3.3-.3 6.1 3.1 3.2 6.5 6.2 9.9 9.2 3.7 3.2 7.6 6.1 11.3 9.2.6.5.9 1.3 1.5 2.1-3.4 2.5-6.7 2.6-10.1.8-1.5-.8-2.9-2-4.5-2.8-1.5-.8-3.1-1.6-5-.5.5 2.2 2.2 3.1 3.7 4.2 2.3 1.9 4.9 3.5 7 5.6 1.3 1.2 2.6 3.1 2.7 4.7.2 2.9 1.8 4.4 3.7 6.1 18.3 16.1 36.7 32.1 53.7 49.6 9.5 9.8 18.7 19.9 27.9 29.8.8.9 1.4 1.9 2.1 2.8-.2.2-.3.4-.5.6-1.1-.7-2.3-1.4-3.3-2.1-4.4-3.2-8.5-6.6-13.1-9.5-4.5-2.9-9.4-5.2-14.1-7.7-.6-.3-1.5-.2-3.1-.3 3.2 4.4 5.9 8.2 8.7 11.8 10.8 14 23.4 26.4 35.7 39 13.6 13.9 26.1 28.6 36.4 45.2.6 1 1.5 2.1 2.6 2.6 3.4 1.6 5.8 4.3 7.7 7.4l5.4 9c.2.4.2 1 .4 2.3-5.5-4.1-10.4-7.8-15.2-11.5-19.1-14.9-36.7-31.4-54.6-47.5-2.1-1.9-3.4-3.9-3.2-6.8.1-1.1-.2-2.2-.2-3.3-.5-.2-.8-.5-1.1-.5-6-.9-10.6-4-14.7-8.4-2.8-3-5.8-5.9-8.8-8.7-.5-.5-1.4-.7-2.5-1.2-.4 1.8-.8 3.2-1.1 4.4 3.3 2.7 6.4 5 9.1 7.8 6.2 6.4 12.2 12.9 18.2 19.5 6.7 7.3 13.2 14.7 21.2 20.6 1.1.8 1.8 2 2.6 3.1 2.4 3.3 4.5 7 7.2 10 7.4 8.1 15.2 15.9 22.7 24 3.9 4.1 7.7 8.2 11.3 12.6 4.4 5.3 7.8 11.3 9.8 18 .2.8.2 1.6.4 3.2-10.3-7.5-21.6-8.3-33.2-8-1.1-6.5-4.8-9.5-11-9-.2-.5-.3-.9-.5-1.2-1.2-2.2-1.9-5.4-3.8-6.5-7.1-4.1-13-9.7-19.4-14.7-2.6-2.1-5.4-4.1-8.3-5.7-4.5-2.6-9.4-4-14.7-3.7-1.7.1-2.7.6-2.4 2.5 0 .4.3.8.2 1.1-.4.7-.7 1.7-1.3 1.9-.7.2-2 0-2.3-.5-.4-.7-.2-1.8.1-2.6.3-.7 1.1-1.3 1.7-2-4.9-4.9-9.9-9.2-17.3-8.7-1 .1-2.3-.5-2.9-1.2-1.9-2.5-4.6-3.8-7.3-5.1-2.6-1.3-5.1-2.6-5.6-6.1-.8.9-1.3 1.7-1.7 2.6-.5 1.1-.8 2.4-1.4 3.5-1.9 3.6-3.4 3.7-6.9.3 1.3-.8 2.5-1.5 4.1-2.5-4.6-3.7-8.4-1.7-11.7-.6-1.8-.9-3.1-2-4.3-2-2.8 0-5-1-6.8-3.2-2.4 1.7-4.7 1.9-7.2.5-1.9-1-3.8-.7-5.5 1.6 2.8 1.3 5.4 2.5 8 3.6 16 6.8 32 13.5 47.9 20.5 13.5 5.9 26.5 13 38.5 21.7 1 .7 1.9 1.5 3.4 2.8-1.8.7-3 1.6-3.9 1.4-2.2-.6-4.2-1.8-6.6-2.8-4.7 4.1-10.6 4.7-16.9 4-1.8-.2-3.8 0-5.6.2-2.1.3-3.3-.1-3.9-2.3-.4-1.5-1.2-3.1-3.4-2.9-3.8.3-6.8-1.4-9.5-3.7-1-.9-2.1-1.8-3.2-2.6-3.4-2.6-7.2-3.5-11.3-1.9-1.6.6-2.8.3-4-.9-1.7-1.6-3.6-3.1-5.5-4.5-7.1-5.1-15.4-7-23.8-8.5-2.4-.4-4.8-.7-8-1.2.8 1.1 1 1.7 1.4 2.1 2.5 1.9 4.9 3.9 7.6 5.4 7.2 4.2 15.1 6.6 22.9 9.2 8.2 2.6 16.5 5.2 24 9.4 1.9 1.1 3.8 1.7 6 1.6 1.2 0 2.7.1 3.5.8 3.8 3.4 8.5 4.5 13.3 5.6 2.2.5 4.1.3 6.1-.8 1.4-.8 2.8-2.1 4.7-1.7.3 2.6.6 5 1 7.4 3.5.8 6 0 7.7-2.9.9-1.6 2.2-3 3.3-4.5 1.3-1.8 3.1-2.7 5.4-3 5.8-.8 11 .7 15.4 4.5 3.8 3.4 7.3 7.2 10.9 10.8.2.2 0 .7 0 1.2-3.5 1-6.7.2-9.8-1.3-2.5-1.2-4.8-2.8-7.4-3.6-2.2-.7-4.7-.9-6.9-.6-1.7.2-3.9.7-4.6 2.8 4.9 2.2 9.6 4.3 14.2 6.4 6.3 2.9 12.8 5.2 19.9 4.3 1.6-.2 2.6.5 3.4 1.7 3.4 4.8 8 8.2 13 11.2 3.1 1.9 6.4 3.5 9.4 5.5 4.8 3.2 9.4 6.5 14.1 9.9.5.4.9 1 1.6 2-4.7.3-8.7-.6-12.6-1.5-8.4-2-15.7-6.5-22.9-11-5.7-3.6-11.5-7.1-18-9.2-1-.3-2-.4-3.2-.6-.4 2.9.1 5 1.7 6.7 1.4 1.5 3 3 4.7 4.3 3.5 2.6 7.1 5.1 10.6 7.8 1.1.8 1.9 2.1 2.8 3.2-.1.3-.3.6-.4.8-1 0-2.1.1-3.1 0-3.5-.6-6.9-1.1-10.3-1.9-5.7-1.3-11.5-2.6-17.4-1.7-.5.1-1.2-.2-1.9-.4 0-.9 0-1.6.1-2.3.2-1.4-.5-2.1-1.7-2.5-4-1.5-7.8-1-11.4 1.5 1.2 2.6 3.5 3.7 5.6 5 2.4 1.6 4.9 3 7.3 4.6 3 2.1 3 2.6.2 5.3-.2.1-.1.5-.3.8 1.6 2.5 4.2 4 6.7 5.7 4.4 2.9 9 5.5 13.2 8.5 5.8 4.1 8.9 9.8 7.9 17.1-.3 2.4.1 4.1 2.4 5-.3 1.1-1 2.1-.8 2.7 1.1 2.5-.4 4.2-1.8 5.8 1.2 2.6 2.3 5 3.4 7.3 1.3 2.8-1.1 4.9-1.4 7.8 1.2-.2 2.1-.3 3.1-.5 1.1-.2 2.1-.6 3.5-.9 1 2.3 1.9 4.4 2.8 6.4-3.9 4-3.9 4-4.7 9.8-.2 1.5-.6 2.9-2.5 3.6-.9-1.6-1.9-3.1-2.7-4.6-3.6 1.5-7 2.7-10.2 4.2-2.1.9-2.5 3.3-.8 4.9.9.9 2.1 1.4 2.9 2.3.6.7 1.2 2.1.9 2.5-.5.7-1.8 1.4-2.7 1.3-1.6-.2-3.1-1-4.5-1.7-1.3-.6-2.5-1.8-3.9-2.2-1.2-.3-2.6 0-3.9.1.1 1 .3 2.1.5 3.1 0 .2.2.4.3.7.6 1.9 0 2.9-2.4 3.8-1.9.8-2.8.5-3.6-1.4-.5-1.2-.9-2.5-1.5-4.2-2.2.5-4.3.8-6.3 1.4-5.1 1.5-9.4 4.5-13.8 7.4-1.4.9-2.9 1.8-4.7 2.9-.1-1.1.1-1.7-.2-2.1-.3-.5-.8-.9-1.3-1.4-.4.6-1 1.1-1.1 1.7 0 .8.5 1.7.7 2.5 1 2.8.4 3.9-2.4 4.7-3 .8-5.4-.5-6.5-3.5-.3-.9-.6-1.8-1.1-3.1-2 1.3-3.6 2.5-5.4 3.4-1.7.9-3.5 1.5-5.2 2.3 1.4 2.9 3.7.7 5 1.2-.3 2.8-.6 5.3-.9 8.1-1.9.6-4.1 1.2-4.4 4.1-.2 2-.8 4-1.4 6.6 1.2.7 2.9 1.7 4.6 2.7 2.5 1.6 2.8 2.3 1.4 4.8-.9 1.6-1.8 3.2-2.7 4.9-2.4 0-2.4 0-4.2.9.3.4.5.9.9 1.1 4.2 2.9 7.2 6.9 10.2 10.9 1.8 2.4 1.6 3.2-1 4.7-.7.4-1.5.8-2.4 1.3 1.2 2.3.3 4.1-1 5.6-2.4 2.9-4.8 5.8-7.5 8.3-2.7 2.6-5.7 4.7-8.9 7.3 2.6 2.8 1.2 5.8 0 8.7-1.2 2.9-2.2 5.8-.5 8.9-1 .9-1.9 1.5-2.7 2.3-1.9 2-1.8 3 .1 5 1.2 1.3 2.2 2.7 3.4 4 1.2 1.2 2.5 2.3 4 3.7-1.1 1.3-2 2.4-3 3.5-1.2 1.3-2.8 2.4-3.4 3.9-1.6 3.6-4.2 4.3-7.6 3.7h-.7c-3.2.3-4.4 2.1-3.4 5.2.4 1.2.9 2.3 1.4 3.5-1.1.7-2.1 1.4-3.2 2.1.4.5.6.9.9 1 1.3.5 2.2 1.3 2 2.8-.3 1.5-1.6 1.7-2.8 2-.7.2-1.4.6-2.5 1.1.9.7 1.4 1.1 1.8 1.5.4.5.8 1.1 1.3 2-1.1.2-1.8.5-2.4.5-1.9-.2-3.7-.5-5.6-.7-3.8-.3-6.5.2-7.7 4.7-.5 1.9-1.7 3.3-3.6 4.1-.8.4-1.4.9-2.5 1.5 1 1.7 1.6 3.3 2.7 4.6 1.4 1.6 3.2 2.8 4.7 4.3 1.2 1.2 2.5 2.5 3.3 4 .9 1.7 1.5 3.8.1 5.7-.8 1-3.3.3-5.4-1.4-.7-.5-1.3-1.2-1.9-1.8-1-.8-2-1.6-3.1-2.1-2.4-1.2-4-.7-5.2 1.7-.7 1.5-1.2 3.2-1.8 4.9-4-.7-8.1-1.4-12.1-2.1-5-.8-6.1.1-5.8 5.2 0 .5.1 1 .1 1.5-.4 2.5-.7 4.3-2.2 5.7zm4.4-457.6c-1.8-1.3-2.9-2.5-4.2-3-2.6-1.1-5.4-2.1-8.1-2.7-5.1-1.2-10.2-2.3-14.4-5.9-1.1.6-2.1 1.1-3 1.5.2.4.2.7.4.9 8.4 7.5 15.6 16.2 23.1 24.6 5.3 6 10.9 11.7 17.3 16.6 7.5 5.7 15.8 9.5 25.3 10.5 3.2.3 6.4.4 9.5.6.9 1.8 1.8 3.4 2.7 5.2 2-.9 3.8-1.7 5.2-2.4 4 3.5 7.7 6.6 11.4 9.8 1.6 1.4 3.2 2.8 4.7 4.3 1.4 1.4 2.3 3.7 3.9 4.4 1.8.8 4.1.1 6.2.1 1.7 0 3.2-.3 4.5-1.6-2.4-4-6.7-6.6-7-11.8 2.8-1.3 5.5-1.9 8.4-.9 2.8 1 8.5-1.7 9.6-4.5.1-.2-.1-.5-.3-.9-4 .3-8.1.4-12.1.9-1.1.1-2.2 1.1-3.2 1.8-.7.4-1.3 1-2.1 1.6-2.3-2-4.4-3.9-6.6-5.8-8.8-7.4-18.7-13.3-28.7-19-13-7.3-26.3-13.8-38.3-22.8-.4-.3-1.1-.4-1.6-.6-1 1.9-1.9 3.6-3.2 6.1-1-2.5-3.4-2.7-3.8-4.9 1.1-.6 2.3-1.2 4.4-2.1zm69.7-44.6c-1.3-2.8-2.5-5.3-3.6-7.8-.5-1.2-1.1-2.1-2.7-2.2-1.7-.1-3.4-.4-5.1-.9-1.4-.3-2.6-.9-3.7.8.4 1.9 2.2 2.5 3.6 3.4 1.8 1.2 2.9 2.7 2.4 5-.1.4.1.9.2 1.4 3 .7 5.8 1.5 8.9.3zm20 19.7c-2.7-6.7-9-9.8-12.7-15.6-2 1.3-3.7 2.4-5.4 3.7-1 .7-1.3 1.9-.5 3 .7 1 1.7 1.4 2.9.9.5-.2.9-.4 1.4-.6 3-1.2 3.3-1.1 5.3 1.4 1.4 1.8 2.7 3.6 4.1 5.3 1 1.3 2.5 2.2 4.9 1.9zm-22.5 17.8c0-.3.1-.5.1-.8-2.9-3.7-5.6-7.6-8.6-11.2-1.3-1.6-3-2.9-4.7-4.2-.7-.5-1.7-.6-3.4-1.2 3.2 7.2 6.8 12.9 12.9 16.5 1 .6 2.4.6 3.7.9zM515.6 203.3c4.9.3 9.7.9 14.4 0 1.4-.3 2.8-.9 4.2-1.5.6-.3 1-1.1 1.9-2.3-5-.3-9.3-.7-13.6-.6-2.8 0-5.4 1.2-6.9 4.4zM409.8 758.7l-6-.9c-1.6-.2-3.3-.5-4.2 1.3 2.8 3 6.9 2.7 10.2-.4zm489.9-269.3c1.9 3.7 3.6 4.4 6.7 2.6-1.4-3.4-3.6-4.2-6.7-2.6zm6.8 137.7c-1.8 1.6-3 2.3-3.8 3.3-.8 1-.2 2.9.7 2.6 1.5-.3 3-1.1 4.1-2 .3-.3-.5-1.9-1-3.9zm-71.6-236.5c-2.8-4.3-3.7-4.9-6-4 3.3 5.1 3.3 5.1 6 4zm9.4 69.6c1.3-.6 2.4-1.1 3.4-1.8.4-.3.7-1.1.6-1.5-.1-.5-.8-1.2-1.2-1.2-1.2.1-2.5.3-3.4.9-1.3 1-.5 2.2.6 3.6zm1.7 202.5c-2.5-3.3-3.5-3.6-6.3-2.1 1.9 2.9 2.4 3 6.3 2.1zm30.2-131.1c-.4 1.8.6 2.6 1.8 3 1.4.4 2.7 0 3.5-1.4-1.3-1.9-3-2.1-5.3-1.6zM768.6 252.4c2.1-.2 3.1-1 3.4-2.5.1-.5-.3-1.6-.7-1.7-.5-.2-1.6.1-1.8.6-.6 1-.6 2.1-.9 3.6zm-170.7-55.9c2.3 2.7 3.4 2.6 5.8-.4-2.1.2-3.8.3-5.8.4zm286.7 337.9v1c.8 0 1.5-.1 2.3-.1v-.7c-.8-.1-1.6-.2-2.3-.2z"/>
                                <path class="st1" d="M949.9 531.2c-3.6-.2-5.6-2.1-5.8-5.7 0-.6.5-1.5 1-1.7.5-.2 1.6.1 1.9.5.6.9.9 2 1.4 3 .4.8 1 1.6 1.5 2.4v1.5zM296.8 246.6c1.1-1.7 2.1-3.5 3.2-5.2l-.5-.5c-.6.3-1.2.5-1.8.8-5.6 3.1-11 6.5-16.7 9.3-6.6 3.3-13.3 6.4-18.3 12.1-.2.2-.6.3-1.2.5-1-2.2.2-4 1-5.6.9-1.8 2.2-3.3 3.4-4.9.9-1.2 2-2.3 2.5-3.7 1.1-3.2 3.5-4.6 6.2-6 10.8-5.5 21.5-11.2 32.3-16.6 5.4-2.7 11-4.8 17-5.7 3.2-.5 6.5-.4 9.7-.7 1.4-.1 3-.4 4.2-1.1 10-6.5 21-10.5 32.5-13.2 9.2-2.2 18-5.4 26.2-10.1 1.6-.9 3.2-1.9 5.3-.8.6.3 2 0 2.7-.5 5.7-3.9 12.2-5.7 18.9-6.7 1.1-.2 2.3-.5 3.1-1.1 7.2-5.7 15.7-8.2 24.2-10.6 6.9-1.9 13.6-4.3 20-7.5 1.2-.6 2.7-1.1 3.9-.8 4.6 1.3 9 .4 13.3-.9 7.4-2.2 14.7-4.7 22.1-7.1 3.5-1.1 7-2.4 11.1-2.5-.1 4-4 5.4-5.2 8.4 5 1.3 19.9-4.1 24.3-8.8-1.6-2.4-4.6.3-6.7-2.2 6.8-2 13.6-2.4 20.2-3.2 6.8-.9 13.6-.8 20.8-.4-.5 2.3-2 2.8-3.6 3-1.3.2-2.7 0-4.1-.1-1-.1-2-.5-3-.3-1.1.3-2.8.8-3 1.6-.3 1.1.2 2.6.8 3.8.3.6 1.5 1 2.2.9.5-.1 1-1.2 1.2-1.9.5-2.5 1.2-3.1 3.4-1.9 4.7 2.8 9.8 2.7 14.9 2.3 3.4-.2 6.7-.7 10.1-1 .6-.1 1.1.1 1.9.9-1.2.6-2.4 1.6-3.8 1.9-4.1.9-8.3 1.6-12.5 2.4-4.5 1-9 2.1-13.5 3.1-1.1.2-2.3.6-3.2.3-6.1-1.9-12.1-1.2-18.2-.4-5.5.7-10.9 1.9-16.3 2.3-4.3.4-8.7-.1-13-.1-1.2 0-2.5.1-3.5.6-10.4 5.1-21.6 7.8-33 9.6-10.1 1.6-19.8 4.3-28.9 8.8-1.4.7-3.1 1.1-4.7 1-11.4-.1-22 2.8-31.8 8.6-1.4.8-3.3 1.1-4.9 1.3-1.7.2-3.5.1-5.2 0-3.2-.1-6 .5-8 3.6-2.1-2.1-3.9-1-6 .1-8.4 4.4-17 8.5-25.5 12.7-3 1.5-5.9 3.2-8.8 4.7.1.3.1.6.2.9 1-.1 2-.2 2.9-.4 13-3.1 25.6-7.5 38.2-12.2 9.7-3.7 19.5-7.2 29.2-10.7 1.3-.5 2.4-.9 3.8.1.8.6 2.4.5 3.5.3 2.3-.5 4.4-1.8 6.9-1 .4.1 1.2-.4 1.6-.8 3.4-3.4 8.1-3.6 12.6-4.3-.5.6-.9 1.3-1.5 1.7-5.4 3.8-11.2 6.6-17.7 7.9-.7.1-1.6.4-2.2.1-2.7-1.1-4.8.3-7.1 1.1-11.3 4.2-22.4 8.5-33.9 12.2-21 6.7-41.5 14.5-62.1 22.1-9.6 3.5-19.3 6.8-29 10.2-.8.3-1.6.5-2.5.7-.3-.1-.5-.3-.6-.4zM321 232c4.7-1.7 9.4-3.5 14.1-5.2-.1-.2-.2-.5-.3-.7-5.1.3-9.6 2.6-13.8 5.9z"/>
                                <path class="st1" d="M550.1 167.5c1 .9 1.6 1.3 2.1 1.9 1.2 1.2 2.4 1.5 4 .8 2.2-.9 4.5-1.6 6.8-2.1 1.1-.3 2.5-.3 3.6.1 4.8 1.6 9.3 1 13.8-1.2 1.8-.9 4.1-1.4 6.1-1.4 17.9-.1 35.8-.3 53.6 0 25.1.5 50.2 1.5 75.2 3.5 1.2.1 2.3.3 3.5.5l.3.9c-1.1.9-2 2.1-3.2 2.7-2.5 1.1-5.1 1.9-7.7 2.8-1.3.4-2.8.5-4 1.1-3.5 1.8-7.1 1.7-10.9 1.6-18.5-.2-37 0-55.5-.1-9-.1-18-.6-26.9-1.2-3.1-.2-5.9-.2-8.6 1.6-.7.5-1.6.7-2.5 1.1-3.1-3.2-6.9-3.1-10.8-2.5-5.2.8-10.4 1.7-15.5 2.6-3.7.7-7.4 1-11.1-.5-3.4-1.4-6.3.2-9.4 1.8-.6-.4-1.2-.7-1.8-1.1-2.6-1.8-5-2.5-8.2-.7-3.8 2.1-8.1 1.9-13.1.4 3.9-2.2 7.3-4 10.4-6 3.3-2.1 6.4-4.3 9.8-6.6zM656.6 139c3.6.8 7.2 2 10.9 2.3 7.8.7 15.7 1 23.6 1.5 6 .4 11.9 1 17.9 1.6.9.1 1.8.5 2.8 1.2-3.7.8-6.7 3.4-11.2 2.2-5.6-1.5-11.7-1.1-17.5-.6-5.9.5-11.7 1.2-17.5 1.8-1.1.1-2.3.3-3.3 0-9-2.1-18.1-1.7-27.2-1.2-8.6.5-17.2 1.2-25.8.1-1.2-.1-2.4-.5-3.8-.8 1.1-3.1 3.4-3.9 5.8-4.4 2.2-.5 4.4-.7 6.6-1.2 1.5-.3 3-.9 4.6-1.3 0-.3.1-.6.1-.9-1.1-.3-2.1-.8-3.2-1-5.9-1.1-11.9-1.4-17.9-1.1-12.3.7-24.3 3.1-36.3 5.4-.4.1-.8.4-1.4.7 1.1 1.9 2.7 1.4 4 1.3 3-.4 5.9-1 8.9-1.4 2.7-.4 5.5-.6 8.2-.8 1.2-.1 2.4.3 3.6.9-3.4 2-7.3 1.7-11 2.4s-7.4 1.1-11.1 1.6c-3.8.5-7.7.9-11.5 1.4-3.7.4-7.4.9-11.2 1 2-2.5 5.6-2.4 7.5-5.2-3.4-2.9-6.1.3-9.3.9-.4-1-.7-1.9-1.1-3 4.6-3 9.4-2.8 14-1.8 2.9.6 5.3.1 7.9-.8 10-3.8 20.3-6.2 31.1-6.1.7 0 1.5-.1 2.2.1 3.6.9 7 .6 10.5-1 1.9-.9 4.4-.7 6.8-1.1.1 1.2.2 2.1.3 3.3.5.1 1.1.2 1.6.3 2.9.6 5.2.3 6.3-3 .5-1.5 1.8-1.4 3.1-1.5 1.6 0 3.2-.2 5-.4 1.1.9 2.4 2.3 3.9 3.3s3.7.6 4.9 2.6c-3.5 2.4-8 .1-11.6 2.7 2.9 1.5 16.2 1.3 24.7-.4v-3.5c6-4.1 18.3-4.3 23.9-.3-2.7 2.1-5.9 2.7-9.1 2.9-3.1.3-6.3.1-9.5.1-.2.4-.2.8-.2 1.2zm-46.1-10.8c-2.4-1.4-4.3-2.6-6.9-4.1 1.2-1.1 2-2 3-2.6 4.3-2.7 9-4.2 14.1-4.5 3.6-.2 7.2-.3 10.9-.3 4.5 0 8.9-.6 13.2-2.2 1-.4 2.3-.6 3.2-.2 5.5 2.6 11.2 1.9 16.9 1.6 4.5-.3 9-.5 13.4-.7.7 0 1.4.2 2.6.5-3.8 3.2-7.8 4.9-12.1 5.5-4 .6-8.2.6-12.3.6-6 .1-12-.4-17.8 1.5-.8.3-2.2.2-2.8-.3-3.9-3.5-8.2-2.6-12.3-1.1-3.4 1.2-6.6 3-9.8 4.5-1.1.5-2.1 1.1-3.3 1.8zM455.9 202c.8 2.2 1.5 3.9 2.2 5.9-21 6.7-41.4 14.3-63.1 17.7.5-.6.9-1.2 1.5-1.6 4.7-3.3 10.1-4.8 15.6-6.3 4.4-1.1 8.7-2.2 13-3.4 3.4-1 6.5-2.6 9.1-5 .8-.7 2-1.3 2.9-1.2 4.7.5 8.9-1.1 12.9-3.1 1.9-.8 3.6-1.8 5.9-3zm-148.6 50.4c2-3.2 4.5-5.8 7.8-7.8 2.6-1.6 4.7-.4 6.8 1.8 6.8-3.4 13.5-6.9 20.5-10.4.8 1.9 1.5 3.4 2.4 5.5-6.5 1.9-12.7 3.7-18.8 5.6-6.1 1.9-12.2 4-18.3 6.1-.1-.3-.2-.5-.4-.8zm53.1-19c4.3-3.8 8.7-6.8 14.3-7.7 1.8-.3 3.5.1 4.3 2.3-.5.5-1 1.2-1.6 1.5-4 2-8 3.9-12.1 5.7-1.7.7-3.3.3-4.9-1.8zm261.6-73c7.9-4.1 16-5.2 24.7-4.1-1.5 3.3-2 3.4-4.7 3.1-2-.2-4.2.1-6.2.5-2.8.6-5.5 1.6-8.3 2.1-1.9.5-3.8.6-5.5-1.6zm-117.8 23.3c.8-4.3 3.4-5.7 6.3-6.4 2.8-.6 5.6-.9 8.5-1.1 1.9-.2 3.8 0 5.8.3-5.6 5.7-13.2 4.9-20.6 7.2zm-17.5 1.4c-5.7 4.4-11.8 4.1-18.4 4.2 5-4.8 14.4-6.9 18.4-4.2zm358.9 288.7c-7.5 2.4-11.1-3.2-16-6.1 3.9-1.5 10 .8 16 6.1zm-100-297c2.7-3.4 7.2-3.5 10.2-.1-2.6 3-6.7 3.1-10.2.1zm-230.7-29.4c.9-5 5-7.8 9.9-6.9-1.2 3.1-5.6 6.2-9.9 6.9zm52.4-21.5c3.8-2.2 8-2.4 12.6-2.9-2.1 2.8-2.1 2.8-12.6 2.9zm-237.5 80.9c2.7-4.2 6.4-4.8 10.3-5.9-1.3 2.9-4.6 4.8-10.3 5.9zm366.3-89.5c5.9-1.4 8.3-.8 9.6 2.5-3.3 0-6.5.7-9.6-2.5zm-138.4 9.1c-.2 3.3-.2 3.4-3.2 5.4-.9-1.1-1.8-2.2-2.8-3.5 1.7-1.7 3.9-1.4 6-1.9zm274.7 577.8c2.7-2.1 4-1.6 6.5 2.3-2.3 1.3-2.5 1.2-6.5-2.3zm-74.3-527.7c2-.4 4-1.1 6.1.4-1.1 2-2.7 2.5-4.7 2.2-.9-.1-1-.4-1.4-2.6zm39.8 246.4c-2.9 1.8-5.6 1.4-8.3.8-6.8-1.5-11.8-5.8-15.9-11.2-1.6-2-3.1-4.1-3.7-6.7 1.6-1.3 2.7-.4 4 .2 1.6.8 3.3 1.3 5.5 2.2.7 2.7 3.4 4.3 6.5 5.7 2.4 1.1 4.8 2.2 7 3.5 2.2 1.3 3.9 2.9 4.9 5.5z"/>',
            $gradID);
        }
        $mask = '<path d="M784 840.6h-3.8c-1.8-3.6-4.2-6.7-7.8-8.7-1.9-1-3.5-2.4-5.4-3.4-8.1-4.4-16.3-8.8-24.4-13.2-11.1-6-21.4-13-29.1-23.2-.7-1-2.1-1.7-3.4-2.1-4.7-1.5-9.2-3.4-13.2-6.3-3.8-2.7-7.4-5.5-11-8.4-4.2-3.4-8.3-6.7-13.4-8.7-11.8-4.8-23.1-10.8-33.4-18.4-1.6-1.2-3-1.4-4.8-.7-5.1 2-9.6.8-13.4-2.9-.6-.6-1.3-1.2-1.9-1.9-1.3-1.5-2.7-1.9-4.7-1.5-5.2 1.1-10.4.6-15.6-.9-2.3-.7-4.6-1.2-6.9-1.8-6.2-1.7-12.4-1.5-18.4.9-2 .8-3.8.8-5.7-.3-1.7-1.1-3.5-1.9-5.4-2.6-5.4-2.2-6.1-1.9-8.5 3.5-.1.2 0 .5.1 1 8.2 4.5 16.5 9.3 26.3 11.5-1.6 3-3.7 3.4-6.2 3-2.7-.5-5.2-.3-6.9 2-3.9-3.6-4.5-3.7-8.5-1.1-.5.3-1 .7-1.6 1-1.4.7-2.6.8-4-.5-1.2-1.1-3.1-1.5-4.7-2s-3.5-.4-4.5-2.6c1.2-.9 2.4-1.7 3.6-2.6 2.4-1.9 2.5-2.9.5-5.3-1.1-1.3-2.4-2.5-3.6-3.9-2.5 1.6-4.9 3.1-7.5 4.7 1.4 1.6 2.5 2.9 3.6 4.1-2.8 5-8.6 6.3-13.4 2.7-1.7-1.2-3.2-1.6-5.2-1.4-5.1.4-10.2.8-15.3 1-9.1.2-18.3.2-27.4.3-1.5 0-3.1.2-4.6.4 0 .3-.1.7-.1 1 1.1.3 2.2.8 3.4 1 2.6.4 5.2.5 7.8 1.1 2 .5 4.1 1.3 5.7 2.4 1.5 1.1 2.7 1.5 4.4.5 1-.6 2.1-1.1 3.1 0 3.2 3.9 7.8 4.6 12.3 5.7 2.3.6 4.5 1.4 6.6 2.6 2.1 1.1 3.6 3 3.9 6.1-1.8 0-3.5.2-5 0-3.2-.6-6.3-1.4-9.5-2.3-4.7-1.4-9.5-2.8-14.4-1.5-4.3 1.2-7.8 1.1-10.6-2.9-2.8 1.5-5.3 2.8-7.9 4-1.1.5-2.5 1.1-3.5.7-5.9-2.3-12.2-2.5-18.4-3.3-2.1-.3-4.4-1.3-6.1 1.1-.3.4-1.2.4-1.8.4-4.7.2-9.5.5-14.2.4-10.8-.3-21.5-.3-31.8 3.5-1 .4-2.3.5-3.2.1-6.6-3.3-13.1-2.5-19.6 0-2.7 1-5.1 3.2-8.3 1.8-.3-.1-.7.1-1.1.2-1.8.6-3.6.9-5.2-.7-.4-.4-1.6-.2-2.4-.1-3.9.9-7.7 2-11.7 2.7-16 2.5-32.1 5-48.2 7.3-14.1 2-28.2 4.3-42 7.8-2.1.5-4.4.7-6.6.6-7.1-.2-14.2-.4-21.3-1-6.2-.5-12.4-1.5-18.6-2.3-2.1-.3-3-1.5-2.9-3.6.1-1.6-.2-3.2-.2-4.9.5-.4.9-.8 1.4-1.2 7.2-5.3 15.3-7.8 24.1-8.4 4.9-.4 9.7-.7 14.6-1.2 2.3-.2 4.5-.9 6.8-1.4-.6-1-1.1-1.4-1.6-1.5-3-.2-6-.4-9-.3-7.5.2-15 .6-22.5.7-2.6 0-5.2 0-6.8-1.1-1.1-2.7-1.9-4.6-2.5-6.5-.3-.9-.7-2.2-.3-2.8 2.1-2.6 3.8-5.7 7.8-6.3 6.8-1 13.5-2.5 20.3-3.6 8.1-1.3 16.3-2.5 24.5-3.7 1.9-.3 3.6-.9 5.5-1.4 0-.3-.1-.5-.1-.8-.7-.1-1.4-.3-2.1-.2-3.1.2-6.2.5-9.3.9-13.6 1.4-27.1 2.6-40.8 1.7-2.3-.2-4.6-.6-6.8-.9.2-3.9 2.1-5.6 5.3-6.2 3.5-.7 7.1-1.6 10.6-2.4 5.4-1.2 10.7-2.4 16.1-3.6 1.2-.3 2.5-.6 3.7-2.2-3.1 0-5.7-.1-8.3 0-5.5.3-11 .8-16.5 1.1-1.6.1-3.4.4-5.1-1 .8-.6 1.4-1.1 2-1.4 5-2.9 10.5-3.9 16.1-4.5 3.6-.4 7.2-.7 10.8-1.1.7-.1 1.3-.6 2-.9-1-.6-1.8-.9-2.7-.8-3.4.3-6.7.5-10.1.9-1.9.3-3.5 0-5.3-1-2.7-1.5-5.6-3-8.6-3.6-5-1-10.1-1.7-15.2-1.9-6.7-.3-13.5-.1-20.3-.1-5.9 0-11.8-.5-17.3-2.8-2.6-1.1-4.9-1.1-7.6-.5-7.3 1.7-14.4 1.3-20.9-3.1-1.5-1-3-1.1-4.6-1-3.2.3-6.2-.6-8.8-2.4-1.9-1.4-3.8-2.9-5.8-4.2-1.7-1.1-1.8-2.4-1.2-4.2 1.7-5.2 5.3-8.7 9.5-11.7 1.1-.8 2.1-1.5 2.7-1.9-2.1-5.9-4-11.1-5.9-16.4-.7-1.9-1.3-3.8-2.2-5.6-.4-.8-1.3-1.7-2.1-1.9-5.1-1.1-10.2-2.3-15.4-3-1.7-.3-2.9-.7-3.5-2.2-1-2.4-2.2-4.8-2.8-7.3-1.4-5.3-2.4-10.7-3.6-16.1-.8-3.5-2.4-6.5-4.8-9.2-1.8-2.1-4-2.8-6.7-2.1-1.6.4-3.1.9-4.7 1.1-1.5.2-3.1.2-3.9-1.8 1.4-2.8 4.9-3.1 6.9-5.6-3.6-8.5-10.6-15.2-13.2-24.3 2.5-2.1 4.9-4.1 7.4-6.2-1.4-1.2-3.1-2-3.4-3.1-.3-1.1 1-2.5 1.8-4.4-1.5.2-2.6.3-3.6.6-1.9.5-3.8 1.2-5.8 1.4-1.1.1-3-.3-3.3-.9-1.1-2.9-2.4-5.9-2.3-8.9 0-3.6 1.4-7.1 2.1-10.6.4-1.7 1.2-3 2.8-3.8 1.3-.7 2.7-1.3 4-2.1 1.8-1.1 3.7-2.1 5.3-3.6.8-.7 1.5-2.3 1.2-3.2-.3-.8-1.9-1.3-3-1.5-1.2-.2-2.5.2-3.7.2-1.3 0-2.6-.1-4.5-.2.8-4.2 1.5-8 2.3-11.7 1.2-5.7 3.6-10.9 7.7-15.2 1-1 1.4-1.9 1-3.3-.8-2.9.2-5.4 1.8-7.8 1.6-2.3 3.3-4.4 4.7-6.8 1.2-2 2.8-4.3 2.7-6.4-.2-3.7 1.8-5.8 4-7.9 1.4-1.4 3.1-2.5 4.8-3.8-.2-.9-.2-1.8-.5-2.8-1.3-4.4-.8-8.7 1.2-12.8 1.4-2.9 3.1-5.8 5.2-8.2 3.9-4.4 8.1-8.5 12.3-12.6 5.1-5 10.5-9.7 14.7-15.5 3-4.1 5.1-8.7 5-13.9 0-1.8.8-2.7 2.2-3.5 8.4-5.2 14.6-12.4 18.9-21.3 2.1-4.3 4.1-8.6 6.3-12.8 1.8-3.4 3.8-6.7 7-9.1 3.5-2.6 6.7-5.6 9.9-8.5 3.1-2.8 5.9-5.7 9-8.5 13.3-11.9 28.3-21.4 43.7-30.3 12.8-7.3 25.5-14.8 38.2-22.3 1.3-.8 2.6-1.7 3.8-2.6-.1-.3-.3-.6-.4-.9-1.1.3-2.3.4-3.3.9-2 .8-3.8 1.9-5.7 2.8-2.4 1.1-4.7 2.3-7.2 3.2-1.8.7-3.7 1-4.8-1.2.1-.3.2-.6.3-.8.3-.4.6-.8 1-1.1 4.7-3.8 10-6.6 15.7-8.6 5-1.7 9.8-3.7 14.7-5.7 1.2-.5 2.4-1.4 3.3-2.4 3.1-3.7 6.9-6.5 11.1-8.9 7.7-4.4 16-6.9 24.5-9.2 7.9-2.2 15.9-4.3 23.6-7.2 12.3-4.7 24.3-9.8 37-13.2 18.7-5.1 37.3-10.3 55.4-17.5 9.2-3.7 18.6-6.5 28.7-6.9 1.1 0 2.2-.5 3.2-1 10.4-5.2 21.4-8.3 32.8-10.5 8.8-1.7 17.7-3.5 26.1-6.8.7-.3 1.4-.8 2.3-1.4-1.8-3.1-4.5-3.6-7.3-3.2-3.8.6-7.6 1.4-11.3 2.6-5.3 1.8-10.5 4.1-15.7 6-1.3.5-2.5 1.7-4.5.6 1-1.2 2.3-2.1 2.6-3.2.8-2.7 2.9-3.6 5.1-4.5 1.8-.8 3.7-1.6 5.5-2.3 9.3-3.6 19.1-4.7 29-5.8 8.1-.9 16.1-2.1 23.9-4.6 1-.3 2.1-.5 3.2-.8.8 1.1 1.4 2 2.2 3.2 9.1-4.3 18.9-5.4 28.6-7.9-.1 1.4-.1 2.3-.2 3.4 12.8-.4 25.4-1.2 38-1.3 12.6-.1 25.2.4 37.9.7 12.5.3 25 .6 37.5 1.8-3.9 3.1-8.3 4.8-13 5.5-6.8 1-13.6 1.7-20.4 2.6-1.4.2-2.7.7-4 1v1c1.6.4 3.2 1 4.9 1.2 1.7.3 3.5.2 5.2.6 2.9.7 5.7 1.7 8.6 2.3 1.4.3 2.9.4 4.3.3 9.5-.5 18.9-1.2 28.4-1.4 10-.2 20 .3 30 .2 4.8 0 9.7-1 14.3 1.5.6.3 1.5.4 2.2.4 5.7.4 11.5.9 17.2 1.1 2.6.1 4.8.5 7.1 1.7 12.2 6.6 24.5 13 37.9 17.1.9.3 2 .8 2.4 1.6 1 1.9 1.8 4 2.9 6.8-2.3-.1-3.9 0-5.4-.4-4.9-1.1-9.7-2.5-14.5-3.6-2.1-.5-4.4-.8-6.4.5.1.4.1.7.3.9 4.5 4 9 7.9 13.4 11.9 3.7 3.4 7.8 6.3 12.8 7.5.6.1 1.2.6 1.9.9-5 4.5-8.9 3.9-12.4-2.1-1.2.4-2.4.9-3.7 1.2-1.4.3-2.9.3-4.4.4-2.2 2 0 4.1.1 5.7-2.1 1.7-4.1 3-5.8 4.6-2.9 2.8-3.1 3.3-.3 6.1 3.1 3.2 6.5 6.2 9.9 9.2 3.7 3.2 7.6 6.1 11.3 9.2.6.5.9 1.3 1.5 2.1-3.4 2.5-6.7 2.6-10.1.8-1.5-.8-2.9-2-4.5-2.8-1.5-.8-3.1-1.6-5-.5.5 2.2 2.2 3.1 3.7 4.2 2.3 1.9 4.9 3.5 7 5.6 1.3 1.2 2.6 3.1 2.7 4.7.2 2.9 1.8 4.4 3.7 6.1 18.3 16.1 36.7 32.1 53.7 49.6 9.5 9.8 18.7 19.9 27.9 29.8.8.9 1.4 1.9 2.1 2.8-.2.2-.3.4-.5.6-1.1-.7-2.3-1.4-3.3-2.1-4.4-3.2-8.5-6.6-13.1-9.5-4.5-2.9-9.4-5.2-14.1-7.7-.6-.3-1.5-.2-3.1-.3 3.2 4.4 5.9 8.2 8.7 11.8 10.8 14 23.4 26.4 35.7 39 13.6 13.9 26.1 28.6 36.4 45.2.6 1 1.5 2.1 2.6 2.6 3.4 1.6 5.8 4.3 7.7 7.4l5.4 9c.2.4.2 1 .4 2.3-5.5-4.1-10.4-7.8-15.2-11.5-19.1-14.9-36.7-31.4-54.6-47.5-2.1-1.9-3.4-3.9-3.2-6.8.1-1.1-.2-2.2-.2-3.3-.5-.2-.8-.5-1.1-.5-6-.9-10.6-4-14.7-8.4-2.8-3-5.8-5.9-8.8-8.7-.5-.5-1.4-.7-2.5-1.2-.4 1.8-.8 3.2-1.1 4.4 3.3 2.7 6.4 5 9.1 7.8 6.2 6.4 12.2 12.9 18.2 19.5 6.7 7.3 13.2 14.7 21.2 20.6 1.1.8 1.8 2 2.6 3.1 2.4 3.3 4.5 7 7.2 10 7.4 8.1 15.2 15.9 22.7 24 3.9 4.1 7.7 8.2 11.3 12.6 4.4 5.3 7.8 11.3 9.8 18 .2.8.2 1.6.4 3.2-10.3-7.5-21.6-8.3-33.2-8-1.1-6.5-4.8-9.5-11-9-.2-.5-.3-.9-.5-1.2-1.2-2.2-1.9-5.4-3.8-6.5-7.1-4.1-13-9.7-19.4-14.7-2.6-2.1-5.4-4.1-8.3-5.7-4.5-2.6-9.4-4-14.7-3.7-1.7.1-2.7.6-2.4 2.5 0 .4.3.8.2 1.1-.4.7-.7 1.7-1.3 1.9-.7.2-2 0-2.3-.5-.4-.7-.2-1.8.1-2.6.3-.7 1.1-1.3 1.7-2-4.9-4.9-9.9-9.2-17.3-8.7-1 .1-2.3-.5-2.9-1.2-1.9-2.5-4.6-3.8-7.3-5.1-2.6-1.3-5.1-2.6-5.6-6.1-.8.9-1.3 1.7-1.7 2.6-.5 1.1-.8 2.4-1.4 3.5-1.9 3.6-3.4 3.7-6.9.3 1.3-.8 2.5-1.5 4.1-2.5-4.6-3.7-8.4-1.7-11.7-.6-1.8-.9-3.1-2-4.3-2-2.8 0-5-1-6.8-3.2-2.4 1.7-4.7 1.9-7.2.5-1.9-1-3.8-.7-5.5 1.6 2.8 1.3 5.4 2.5 8 3.6 16 6.8 32 13.5 47.9 20.5 13.5 5.9 26.5 13 38.5 21.7 1 .7 1.9 1.5 3.4 2.8-1.8.7-3 1.6-3.9 1.4-2.2-.6-4.2-1.8-6.6-2.8-4.7 4.1-10.6 4.7-16.9 4-1.8-.2-3.8 0-5.6.2-2.1.3-3.3-.1-3.9-2.3-.4-1.5-1.2-3.1-3.4-2.9-3.8.3-6.8-1.4-9.5-3.7-1-.9-2.1-1.8-3.2-2.6-3.4-2.6-7.2-3.5-11.3-1.9-1.6.6-2.8.3-4-.9-1.7-1.6-3.6-3.1-5.5-4.5-7.1-5.1-15.4-7-23.8-8.5-2.4-.4-4.8-.7-8-1.2.8 1.1 1 1.7 1.4 2.1 2.5 1.9 4.9 3.9 7.6 5.4 7.2 4.2 15.1 6.6 22.9 9.2 8.2 2.6 16.5 5.2 24 9.4 1.9 1.1 3.8 1.7 6 1.6 1.2 0 2.7.1 3.5.8 3.8 3.4 8.5 4.5 13.3 5.6 2.2.5 4.1.3 6.1-.8 1.4-.8 2.8-2.1 4.7-1.7.3 2.6.6 5 1 7.4 3.5.8 6 0 7.7-2.9.9-1.6 2.2-3 3.3-4.5 1.3-1.8 3.1-2.7 5.4-3 5.8-.8 11 .7 15.4 4.5 3.8 3.4 7.3 7.2 10.9 10.8.2.2 0 .7 0 1.2-3.5 1-6.7.2-9.8-1.3-2.5-1.2-4.8-2.8-7.4-3.6-2.2-.7-4.7-.9-6.9-.6-1.7.2-3.9.7-4.6 2.8 4.9 2.2 9.6 4.3 14.2 6.4 6.3 2.9 12.8 5.2 19.9 4.3 1.6-.2 2.6.5 3.4 1.7 3.4 4.8 8 8.2 13 11.2 3.1 1.9 6.4 3.5 9.4 5.5 4.8 3.2 9.4 6.5 14.1 9.9.5.4.9 1 1.6 2-4.7.3-8.7-.6-12.6-1.5-8.4-2-15.7-6.5-22.9-11-5.7-3.6-11.5-7.1-18-9.2-1-.3-2-.4-3.2-.6-.4 2.9.1 5 1.7 6.7 1.4 1.5 3 3 4.7 4.3 3.5 2.6 7.1 5.1 10.6 7.8 1.1.8 1.9 2.1 2.8 3.2-.1.3-.3.6-.4.8-1 0-2.1.1-3.1 0-3.5-.6-6.9-1.1-10.3-1.9-5.7-1.3-11.5-2.6-17.4-1.7-.5.1-1.2-.2-1.9-.4 0-.9 0-1.6.1-2.3.2-1.4-.5-2.1-1.7-2.5-4-1.5-7.8-1-11.4 1.5 1.2 2.6 3.5 3.7 5.6 5 2.4 1.6 4.9 3 7.3 4.6 3 2.1 3 2.6.2 5.3-.2.1-.1.5-.3.8 1.6 2.5 4.2 4 6.7 5.7 4.4 2.9 9 5.5 13.2 8.5 5.8 4.1 8.9 9.8 7.9 17.1-.3 2.4.1 4.1 2.4 5-.3 1.1-1 2.1-.8 2.7 1.1 2.5-.4 4.2-1.8 5.8 1.2 2.6 2.3 5 3.4 7.3 1.3 2.8-1.1 4.9-1.4 7.8 1.2-.2 2.1-.3 3.1-.5 1.1-.2 2.1-.6 3.5-.9 1 2.3 1.9 4.4 2.8 6.4-3.9 4-3.9 4-4.7 9.8-.2 1.5-.6 2.9-2.5 3.6-.9-1.6-1.9-3.1-2.7-4.6-3.6 1.5-7 2.7-10.2 4.2-2.1.9-2.5 3.3-.8 4.9.9.9 2.1 1.4 2.9 2.3.6.7 1.2 2.1.9 2.5-.5.7-1.8 1.4-2.7 1.3-1.6-.2-3.1-1-4.5-1.7-1.3-.6-2.5-1.8-3.9-2.2-1.2-.3-2.6 0-3.9.1.1 1 .3 2.1.5 3.1 0 .2.2.4.3.7.6 1.9 0 2.9-2.4 3.8-1.9.8-2.8.5-3.6-1.4-.5-1.2-.9-2.5-1.5-4.2-2.2.5-4.3.8-6.3 1.4-5.1 1.5-9.4 4.5-13.8 7.4-1.4.9-2.9 1.8-4.7 2.9-.1-1.1.1-1.7-.2-2.1-.3-.5-.8-.9-1.3-1.4-.4.6-1 1.1-1.1 1.7 0 .8.5 1.7.7 2.5 1 2.8.4 3.9-2.4 4.7-3 .8-5.4-.5-6.5-3.5-.3-.9-.6-1.8-1.1-3.1-2 1.3-3.6 2.5-5.4 3.4-1.7.9-3.5 1.5-5.2 2.3 1.4 2.9 3.7.7 5 1.2-.3 2.8-.6 5.3-.9 8.1-1.9.6-4.1 1.2-4.4 4.1-.2 2-.8 4-1.4 6.6 1.2.7 2.9 1.7 4.6 2.7 2.5 1.6 2.8 2.3 1.4 4.8-.9 1.6-1.8 3.2-2.7 4.9-2.4 0-2.4 0-4.2.9.3.4.5.9.9 1.1 4.2 2.9 7.2 6.9 10.2 10.9 1.8 2.4 1.6 3.2-1 4.7-.7.4-1.5.8-2.4 1.3 1.2 2.3.3 4.1-1 5.6-2.4 2.9-4.8 5.8-7.5 8.3-2.7 2.6-5.7 4.7-8.9 7.3 2.6 2.8 1.2 5.8 0 8.7-1.2 2.9-2.2 5.8-.5 8.9-1 .9-1.9 1.5-2.7 2.3-1.9 2-1.8 3 .1 5 1.2 1.3 2.2 2.7 3.4 4 1.2 1.2 2.5 2.3 4 3.7-1.1 1.3-2 2.4-3 3.5-1.2 1.3-2.8 2.4-3.4 3.9-1.6 3.6-4.2 4.3-7.6 3.7h-.7c-3.2.3-4.4 2.1-3.4 5.2.4 1.2.9 2.3 1.4 3.5-1.1.7-2.1 1.4-3.2 2.1.4.5.6.9.9 1 1.3.5 2.2 1.3 2 2.8-.3 1.5-1.6 1.7-2.8 2-.7.2-1.4.6-2.5 1.1.9.7 1.4 1.1 1.8 1.5.4.5.8 1.1 1.3 2-1.1.2-1.8.5-2.4.5-1.9-.2-3.7-.5-5.6-.7-3.8-.3-6.5.2-7.7 4.7-.5 1.9-1.7 3.3-3.6 4.1-.8.4-1.4.9-2.5 1.5 1 1.7 1.6 3.3 2.7 4.6 1.4 1.6 3.2 2.8 4.7 4.3 1.2 1.2 2.5 2.5 3.3 4 .9 1.7 1.5 3.8.1 5.7-.8 1-3.3.3-5.4-1.4-.7-.5-1.3-1.2-1.9-1.8-1-.8-2-1.6-3.1-2.1-2.4-1.2-4-.7-5.2 1.7-.7 1.5-1.2 3.2-1.8 4.9-4-.7-8.1-1.4-12.1-2.1-5-.8-6.1.1-5.8 5.2 0 .5.1 1 .1 1.5-.3 2.6-.7 4.3-2.2 5.7zm4.4-457.6c-1.8-1.3-2.9-2.5-4.2-3-2.6-1.1-5.4-2.1-8.1-2.7-5.1-1.2-10.2-2.3-14.4-5.9-1.1.6-2.1 1.1-3 1.5.2.4.2.7.4.9 8.4 7.5 15.6 16.2 23.1 24.6 5.3 6 10.9 11.7 17.3 16.6 7.5 5.7 15.8 9.5 25.3 10.5 3.2.3 6.4.4 9.5.6.9 1.8 1.8 3.4 2.7 5.2 2-.9 3.8-1.7 5.2-2.4 4 3.5 7.7 6.6 11.4 9.8 1.6 1.4 3.2 2.8 4.7 4.3 1.4 1.4 2.3 3.7 3.9 4.4 1.8.8 4.1.1 6.2.1 1.7 0 3.2-.3 4.5-1.6-2.4-4-6.7-6.6-7-11.8 2.8-1.3 5.5-1.9 8.4-.9 2.8 1 8.5-1.7 9.6-4.5.1-.2-.1-.5-.3-.9-4 .3-8.1.4-12.1.9-1.1.1-2.2 1.1-3.2 1.8-.7.4-1.3 1-2.1 1.6-2.3-2-4.4-3.9-6.6-5.8-8.8-7.4-18.7-13.3-28.7-19-13-7.3-26.3-13.8-38.3-22.8-.4-.3-1.1-.4-1.6-.6-1 1.9-1.9 3.6-3.2 6.1-1-2.5-3.4-2.7-3.8-4.9 1.1-.5 2.3-1.1 4.4-2.1zm69.7-44.5c-1.3-2.8-2.5-5.3-3.6-7.8-.5-1.2-1.1-2.1-2.7-2.2-1.7-.1-3.4-.4-5.1-.9-1.4-.3-2.6-.9-3.7.8.4 1.9 2.2 2.5 3.6 3.4 1.8 1.2 2.9 2.7 2.4 5-.1.4.1.9.2 1.4 3 .7 5.8 1.4 8.9.3zm20 19.7c-2.7-6.7-9-9.8-12.7-15.6-2 1.3-3.7 2.4-5.4 3.7-1 .7-1.3 1.9-.5 3 .7 1 1.7 1.4 2.9.9.5-.2.9-.4 1.4-.6 3-1.2 3.3-1.1 5.3 1.4 1.4 1.8 2.7 3.6 4.1 5.3 1.1 1.3 2.5 2.2 4.9 1.9zm-22.5 17.7c0-.3.1-.5.1-.8-2.9-3.7-5.6-7.6-8.6-11.2-1.3-1.6-3-2.9-4.7-4.2-.7-.5-1.7-.6-3.4-1.2 3.2 7.2 6.8 12.9 12.9 16.5 1.1.7 2.5.7 3.7.9zM545.5 196.6c4.9.3 9.7.9 14.4 0 1.4-.3 2.8-.9 4.2-1.5.6-.3 1-1.1 1.9-2.3-5-.3-9.3-.7-13.6-.6-2.8-.1-5.4 1.2-6.9 4.4zM439.7 751.9l-6-.9c-1.6-.2-3.3-.5-4.2 1.3 2.8 3 6.9 2.8 10.2-.4zm490-269.2c1.9 3.7 3.6 4.4 6.7 2.6-1.5-3.4-3.7-4.3-6.7-2.6zm6.7 137.7c-1.8 1.6-3 2.3-3.8 3.3-.8 1-.2 2.9.7 2.6 1.5-.3 3-1.1 4.1-2 .3-.3-.5-2-1-3.9zm-71.6-236.6c-2.8-4.3-3.7-4.9-6-4 3.3 5.1 3.3 5.1 6 4zm9.4 69.7c1.3-.6 2.4-1.1 3.4-1.8.4-.3.7-1.1.6-1.5-.1-.5-.8-1.2-1.2-1.2-1.2.1-2.5.3-3.4.9-1.3.9-.4 2.1.6 3.6zm1.7 202.5c-2.5-3.3-3.5-3.6-6.3-2.1 1.9 2.8 2.4 3 6.3 2.1zm30.2-131.1c-.4 1.8.6 2.6 1.8 3 1.4.4 2.7 0 3.5-1.4-1.3-1.9-3-2.1-5.3-1.6zM798.5 245.6c2.1-.2 3.1-1 3.4-2.5.1-.5-.3-1.6-.7-1.7-.5-.2-1.6.1-1.8.6-.5 1-.6 2.2-.9 3.6zm-170.7-55.8c2.3 2.7 3.4 2.6 5.8-.4-2.1.1-3.8.3-5.8.4zm286.7 337.8v1c.8 0 1.5-.1 2.3-.1v-.7c-.8-.1-1.5-.1-2.3-.2z"/>
                <path d="M979.9 524.5c-3.6-.2-5.6-2.1-5.8-5.7 0-.6.5-1.5 1-1.7.5-.2 1.6.1 1.9.5.6.9.9 2 1.4 3 .4.8 1 1.6 1.5 2.4v1.5zM326.7 239.8c1.1-1.7 2.1-3.5 3.2-5.2l-.5-.5c-.6.3-1.2.5-1.8.8-5.6 3.1-11 6.5-16.7 9.3-6.6 3.3-13.3 6.4-18.3 12.1-.2.2-.6.3-1.2.5-1-2.2.2-4 1-5.6.9-1.8 2.2-3.3 3.4-4.9.9-1.2 2-2.3 2.5-3.7 1.1-3.2 3.5-4.6 6.2-6 10.8-5.5 21.5-11.2 32.3-16.6 5.4-2.7 11-4.8 17-5.7 3.2-.5 6.5-.4 9.7-.7 1.4-.1 3-.4 4.2-1.1 10-6.5 21-10.5 32.5-13.2 9.2-2.2 18-5.4 26.2-10.1 1.6-.9 3.2-1.9 5.3-.8.6.3 2 0 2.7-.5 5.7-3.9 12.2-5.7 18.9-6.7 1.1-.2 2.3-.5 3.1-1.1 7.2-5.7 15.7-8.2 24.2-10.6 6.9-1.9 13.6-4.3 20-7.5 1.2-.6 2.7-1.1 3.9-.8 4.6 1.3 9 .4 13.3-.9 7.4-2.2 14.7-4.7 22.1-7.1 3.5-1.1 7-2.4 11.1-2.5-.1 4-4 5.4-5.2 8.4 5 1.3 19.9-4.1 24.3-8.8-1.6-2.4-4.6.3-6.7-2.2 6.8-2 13.6-2.4 20.2-3.2 6.8-.9 13.6-.8 20.8-.4-.5 2.3-2 2.8-3.6 3-1.3.2-2.7 0-4.1-.1-1-.1-2-.5-3-.3-1.1.3-2.8.8-3 1.6-.3 1.1.2 2.6.8 3.8.3.6 1.5 1 2.2.9.5-.1 1-1.2 1.2-1.9.5-2.5 1.2-3.1 3.4-1.9 4.7 2.8 9.8 2.7 14.9 2.3 3.4-.2 6.7-.7 10.1-1 .6-.1 1.1.1 1.9.9-1.2.6-2.4 1.6-3.8 1.9-4.1.9-8.3 1.6-12.5 2.4-4.5 1-9 2.1-13.5 3.1-1.1.2-2.3.6-3.2.3-6.1-1.9-12.1-1.2-18.2-.4-5.5.7-10.9 1.9-16.3 2.3-4.3.4-8.7-.1-13-.1-1.2 0-2.5.1-3.5.6-10.4 5.1-21.6 7.8-33 9.6-10.1 1.6-19.8 4.3-28.9 8.8-1.4.7-3.1 1.1-4.7 1-11.4-.1-22 2.8-31.8 8.6-1.4.8-3.3 1.1-4.9 1.3-1.7.2-3.5.1-5.2 0-3.2-.1-6 .5-8 3.6-2.1-2.1-3.9-1-6 .1-8.4 4.4-17 8.5-25.5 12.7-3 1.5-5.9 3.2-8.8 4.7.1.3.1.6.2.9 1-.1 2-.2 2.9-.4 13-3.1 25.6-7.5 38.2-12.2 9.7-3.7 19.5-7.2 29.2-10.7 1.3-.5 2.4-.9 3.8.1.8.6 2.4.5 3.5.3 2.3-.5 4.4-1.8 6.9-1 .4.1 1.2-.4 1.6-.8 3.4-3.4 8.1-3.6 12.6-4.3-.5.6-.9 1.3-1.5 1.7-5.4 3.8-11.2 6.6-17.7 7.9-.7.1-1.6.4-2.2.1-2.7-1.1-4.8.3-7.1 1.1-11.3 4.2-22.4 8.5-33.9 12.2-21 6.7-41.5 14.5-62.1 22.1-9.6 3.5-19.3 6.8-29 10.2-.8.3-1.6.5-2.5.7-.3 0-.4-.2-.6-.4zm24.2-14.5c4.7-1.7 9.4-3.5 14.1-5.2-.1-.2-.2-.5-.3-.7-5.1.3-9.6 2.6-13.8 5.9z"/>
                <path d="M580 160.8c1 .9 1.6 1.3 2.1 1.9 1.2 1.2 2.4 1.5 4 .8 2.2-.9 4.5-1.6 6.8-2.1 1.1-.3 2.5-.3 3.6.1 4.8 1.6 9.3 1 13.8-1.2 1.8-.9 4.1-1.4 6.1-1.4 17.9-.1 35.8-.3 53.6 0 25.1.5 50.2 1.5 75.2 3.5 1.2.1 2.3.3 3.5.5l.3.9c-1.1.9-2 2.1-3.2 2.7-2.5 1.1-5.1 1.9-7.7 2.8-1.3.4-2.8.5-4 1.1-3.5 1.8-7.1 1.7-10.9 1.6-18.5-.2-37 0-55.5-.1-9-.1-18-.6-26.9-1.2-3.1-.2-5.9-.2-8.6 1.6-.7.5-1.6.7-2.5 1.1-3.1-3.2-6.9-3.1-10.8-2.5-5.2.8-10.4 1.7-15.5 2.6-3.7.7-7.4 1-11.1-.5-3.4-1.4-6.3.2-9.4 1.8-.6-.4-1.2-.7-1.8-1.1-2.6-1.8-5-2.5-8.2-.7-3.8 2.1-8.1 1.9-13.1.4 3.9-2.2 7.3-4 10.4-6 3.3-2.1 6.4-4.3 9.8-6.6zm106.5-28.5c3.6.8 7.2 2 10.9 2.3 7.8.7 15.7 1 23.6 1.5 6 .4 11.9 1 17.9 1.6.9.1 1.8.5 2.8 1.2-3.7.8-6.7 3.4-11.2 2.2-5.6-1.5-11.7-1.1-17.5-.6-5.9.5-11.7 1.2-17.5 1.8-1.1.1-2.3.3-3.3 0-9-2.1-18.1-1.7-27.2-1.2-8.6.5-17.2 1.2-25.8.1-1.2-.1-2.4-.5-3.8-.8 1.1-3.1 3.4-3.9 5.8-4.4 2.2-.5 4.4-.7 6.6-1.2 1.5-.3 3-.9 4.6-1.3 0-.3.1-.6.1-.9-1.1-.3-2.1-.8-3.2-1-5.9-1.1-11.9-1.4-17.9-1.1-12.3.7-24.3 3.1-36.3 5.4-.4.1-.8.4-1.4.7 1.1 1.9 2.7 1.4 4 1.3 3-.4 5.9-1 8.9-1.4 2.7-.4 5.5-.6 8.2-.8 1.2-.1 2.4.3 3.6.9-3.4 2-7.3 1.7-11 2.4s-7.4 1.1-11.1 1.6c-3.8.5-7.7.9-11.5 1.4-3.7.4-7.4.9-11.2 1 2-2.5 5.6-2.4 7.5-5.2-3.4-2.9-6.1.3-9.3.9-.4-1-.7-1.9-1.1-3 4.6-3 9.4-2.8 14-1.8 2.9.6 5.3.1 7.9-.8 10-3.8 20.3-6.2 31.1-6.1.7 0 1.5-.1 2.2.1 3.6.9 7 .6 10.5-1 1.9-.9 4.4-.7 6.8-1.1.1 1.2.2 2.1.3 3.3.5.1 1.1.2 1.6.3 2.9.6 5.2.3 6.3-3 .5-1.5 1.8-1.4 3.1-1.5 1.6 0 3.2-.2 5-.4 1.1.9 2.4 2.3 3.9 3.3s3.7.6 4.9 2.6c-3.5 2.4-8 .1-11.6 2.7 2.9 1.5 16.2 1.3 24.7-.4v-3.5c6-4.1 18.3-4.3 23.9-.3-2.7 2.1-5.9 2.7-9.1 2.9-3.1.3-6.3.1-9.5.1-.1.3-.2.8-.2 1.2zm-46-10.9c-2.4-1.4-4.3-2.6-6.9-4.1 1.2-1.1 2-2 3-2.6 4.3-2.7 9-4.2 14.1-4.5 3.6-.2 7.2-.3 10.9-.3 4.5 0 8.9-.6 13.2-2.2 1-.4 2.3-.6 3.2-.2 5.5 2.6 11.2 1.9 16.9 1.6 4.5-.3 9-.5 13.4-.7.7 0 1.4.2 2.6.5-3.8 3.2-7.8 4.9-12.1 5.5-4 .6-8.2.6-12.3.6-6 .1-12-.4-17.8 1.5-.8.3-2.2.2-2.8-.3-3.9-3.5-8.2-2.6-12.3-1.1-3.4 1.2-6.6 3-9.8 4.5-1.1.5-2.2 1.2-3.3 1.8zm-154.7 73.9c.8 2.2 1.5 3.9 2.2 5.9-21 6.7-41.4 14.3-63.1 17.7.5-.6.9-1.2 1.5-1.6 4.7-3.3 10.1-4.8 15.6-6.3 4.4-1.1 8.7-2.2 13-3.4 3.4-1 6.5-2.6 9.1-5 .8-.7 2-1.3 2.9-1.2 4.7.5 8.9-1.1 12.9-3.1 1.9-.8 3.6-1.8 5.9-3zm-148.5 50.4c2-3.2 4.5-5.8 7.8-7.8 2.6-1.6 4.7-.4 6.8 1.8 6.8-3.4 13.5-6.9 20.5-10.4.8 1.9 1.5 3.4 2.4 5.5-6.5 1.9-12.7 3.7-18.8 5.6-6.1 1.9-12.2 4-18.3 6.1-.2-.3-.3-.6-.4-.8zm53-19.1c4.3-3.8 8.7-6.8 14.3-7.7 1.8-.3 3.5.1 4.3 2.3-.5.5-1 1.2-1.6 1.5-4 2-8 3.9-12.1 5.7-1.7.7-3.3.4-4.9-1.8zM652 153.7c7.9-4.1 16-5.2 24.7-4.1-1.5 3.3-2 3.4-4.7 3.1-2-.2-4.2.1-6.2.5-2.8.6-5.5 1.6-8.3 2.1-1.9.5-3.9.6-5.5-1.6zM534.1 177c.8-4.3 3.4-5.7 6.3-6.4 2.8-.6 5.6-.9 8.5-1.1 1.9-.2 3.8 0 5.8.3-5.5 5.6-13.2 4.9-20.6 7.2zm-17.5 1.4c-5.7 4.4-11.8 4.1-18.4 4.2 5-4.8 14.4-7 18.4-4.2zm358.9 288.7c-7.5 2.4-11.1-3.2-16-6.1 3.9-1.6 10 .8 16 6.1zm-99.9-297c2.7-3.4 7.2-3.5 10.2-.1-2.7 3-6.8 3-10.2.1zm-230.7-29.4c.9-5 5-7.8 9.9-6.9-1.3 3-5.6 6.1-9.9 6.9zm52.3-21.5c3.8-2.2 8-2.4 12.6-2.9-2.1 2.8-2.1 2.8-12.6 2.9zm-237.5 80.9c2.7-4.2 6.4-4.8 10.3-5.9-1.3 2.9-4.6 4.8-10.3 5.9zM726 110.5c5.9-1.4 8.3-.8 9.6 2.5-3.3.1-6.5.7-9.6-2.5zm-138.4 9.2c-.2 3.3-.2 3.4-3.2 5.4-.9-1.1-1.8-2.2-2.8-3.5 1.7-1.7 3.9-1.4 6-1.9zm274.7 577.8c2.7-2.1 4-1.6 6.5 2.3-2.2 1.2-2.5 1.1-6.5-2.3zm-74.2-527.7c2-.4 4-1.1 6.1.4-1.1 2-2.7 2.5-4.7 2.2-1-.1-1.1-.5-1.4-2.6zm39.8 246.4c-2.9 1.8-5.6 1.4-8.3.8-6.8-1.5-11.8-5.8-15.9-11.2-1.6-2-3.1-4.1-3.7-6.7 1.6-1.3 2.7-.4 4 .2 1.6.8 3.3 1.3 5.5 2.2.7 2.7 3.4 4.3 6.5 5.7 2.4 1.1 4.8 2.2 7 3.5 2.1 1.2 3.9 2.8 4.9 5.5z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape36($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M487.5 205.7c21-12.4 47.4-9.6 59.9-32 8.2-14.7 14.9-30.2 24.4-49.5 10.4 6.8 20.2 15.1 31.4 19.8 7 2.9 20.6 3.9 23.8-.2 16.7-20.7 39.4-16.9 60.9-17.8 1.3-.1 6.1 12.3 4.1 16-3.9 7.2-11.6 12.3-17.8 18.5 6.7 5.6 13.1 10.9 20.3 16.9 4.5-4.1 9.5-11.3 16.3-14.2 7.5-3.1 19.4-6.1 24.5-2.4 14 10.1 21 2.7 30.1-6.1 22.1-21.4 44.8-42.2 67.2-63.2 13.6 23 5.7 42.9.1 62.8 1.3 1.1 2.6 2.1 3.9 3.2 12.8-12.9 25.6-25.8 39.1-39.3 1.9 3.4 3.8 7 5.9 10.8 10.4-7.8 20.7-15.7 31.1-23.5.8.6 1.7 1.2 2.5 1.8-4.1 6.7-9 13.1-11.9 20.3-2.3 5.6-2.1 12.2-3.4 20.6 11.5-7 18.4-11.3 25.5-15.6-2.4-4.4-5.4-9.9-8.4-15.2 5.5-8.8 11.1-18.8 17.7-28.1 8.4-11.7 15.5-10.8 21.5 2.3 6 13.2 7.5 25.9-2.7 38.5-17.6 21.9-35.4 43.7-51.3 66.8-6.1 8.8-7.1 21.2-7.8 33.2 16.2-5.6 33.5 1.4 44.9-12.9 1.7-2.1 10.3-1.4 13.6 1 15.4 11 16.8 34 3.4 47.9-7.5 7.7-14.9 14.3-9.4 27.1 7.2 16.9-7.5 26.7-16.1 36.4-11.1 12.6-14.4 20.7 9.5 27.9-11.4 9.1-18.7 16.2-27.2 21.5-27.6 17.6-52.5 37.2-63.1 72.7 6.9-.4 12.3-.9 17.6-1 4.4-.1 9.9-1.3 12.8.8 5.7 4 10.1 10 14.8 15.3 6.9 7.9 7.4-17.9 15.5-2.9 2.3-1.8 4.6-3.5 6.8-5.4 9.1-8 17.7-6.9 24.2 3.1.6.9 1 2.2 1.9 2.8 6.2 4.3 17.8 8.5 17.9 12.8.2 11.4-4.4 22.9-7.6 34.3-1.7 6-4.3 11.8-7.4 20-9.6-3.7-20.2-7.8-30.8-11.9-.4-2.4-.7-4.7-1.1-7.1-8.3 9.1-18.7 17-24.2 27.6-4.6 8.8-3.3 20.7-5 34.4 6.8-1.6 12.5-3 23.3-5.6-5.1 12.8-7.3 25.7-14.3 34.8-18.6 24-39.3 46.4-59.2 69.4-8 9.3-19.2 17.8-4.2 30.6 2.3 2 4.1 7.9 2.8 10.3-11.9 23.6 4.9 55.5-23.6 75.2-18.2-28.4 2-58.5-.5-84.1-29.5 27.6-44.7 65.4-58.3 104.2-2.7-.6-5.5-1.1-8.2-1.7 0-7 .2-13.9-.1-20.9-.3-8.1 13.9-14.7 2.7-24.2-.2-.2 3.2-6.6 5-6.6 18.2-.2 17.7-15.6 20.4-29.4-14.1 11-28.1 22.1-42.2 33.1-1.4 1.1-4 2.4-3.9 3.3 5.6 32.9-29.8 37.3-40.3 61.7-8.6-7.7-15.5-14.2-22.7-20.2-2.1-1.8-5-3.4-7.7-3.5-33.4-1.3-42.4-16-32-51-14.4 16.5-28.8 33.1-43.2 49.6-9.6-5.3-17-9.4-25.1-13.8-2.8 4-4.7 7.2-7.1 9.9-14.1 15.4-28.6 30.3-42.2 46.1-4.5 5.2-6.8 12.2-9.7 18.6-8.8 19.5-20.8 36.1-43.3 46.8-8.1-10.3-15.8-21-24.5-30.8-2.7-3.1-8.9-3-11.9-6-11.4-11.5-22.6-23.4-32.6-36.1-1.5-1.9 2.6-9.9 5.9-13.6 22.7-25.4 45.9-50.3 68.7-75.6 1.5-1.7 1.5-5.2 1.4-7.9-.8-18.1-1.7-36.3-2.7-55.4-19.6 4.6-40.4 14.9-55.9 33.7-13.5 16.4-21.1 17-34.9.4-2-2.4-4.2-6-6.6-6.3-16.1-1.7-33.3-6.3-48.3-2.6-11.5 2.8-20.4 16.4-30.2 25.4-1.6 1.5-1.8 4.6-3.5 5.8-15.4 11.3-31.3 21.7-46.3 33.5-11.6 9.1-20 19.9-39 15.2-8.5-2.1-20.6 11.6-31.4 17.5-11.8 6.4-24.1 11.7-35.9 18.2-12 6.6-23.7 14-37.4 18.8 1.8-2.1 3.6-4.2 6.8-7.9-5.4.9-9.4 1.6-13.1 2.2-1-11.1-2-21.2-3.4-35.8 53.7-21.9 102.8-59.1 146-102.4-5.5-10.3-16.6-21.6-15.9-32.2.8-13.5 10-27.1 17.8-39.3 7.5-11.8 7.3-20.2-5.8-28.7-26.9 22.7-54.1 45.7-83.2 70.3-6.5-4.9-14.1-10.6-21.2-16-7.6 5.2-14.3 12.7-22.3 14.7-23.4 5.6-21.6-16.4-27.9-28.6-3.3-6.3-3-14.5-3.6-17.9 9.6-7.1 18.2-12.2 25.1-19 37.4-36.5 74.5-73.4 111.6-110.2.9-.9 2.2-1.7 2.4-2.8 7.7-39.6 46.5-54.9 66.3-84.9 4.5-6.8 6.7-15.3 11.9-21.4 12.1-14.4 25.7-27.5 37.9-41.8 2.7-3.2 2.1-9.3 3.5-16.4 1.9-2.1 6.5-7.1 11.1-12.1.6 1.8 1.6 4.9 4.3 13.5 5.6-12.2 9.5-20.5 11.5-24.8 8.2-5.1 14.9-7.4 19-12.1 8.6-9.8 16-20.7 23.5-31.4 8.4-11.8 14.2-24.4 34.1-21.9 9.6 1.2 23.2-7.6 30.5-15.8 15.1-17.2 27.2-37.2 40.6-55.9 2.9-4.1 6.2-8 9.3-12 3.5 3 10.2 6.5 9.9 8.8-1 5.8-3.8 13.5-8.3 16-11.7 5.9-17.4 14.3-17.6 30.2z"/>
                                <path class="st1" d="M148.4 673c9.1 8.9 29 13.6 13 30.4-3.6 3.8-16.1 4.8-20.2 1.6-17.3-13.5 6.4-20.4 7.2-32zM692 826.2c-5.1 7.1-10.2 14.3-16.8 23.3-4.3-8.1-7.2-13.8-11-21 8.4-2.3 16.2-4.5 24.1-6.7 1.3 1.5 2.5 3 3.7 4.4z"/>',
            $gradID);
        }
        $mask = '<path d="M463.3 212.1c21-12.4 47.4-9.6 59.9-32 8.2-14.7 14.9-30.2 24.4-49.5 10.4 6.8 20.2 15.1 31.4 19.8 7 2.9 20.6 3.9 23.8-.2 16.7-20.7 39.4-16.9 60.9-17.8 1.3-.1 6.1 12.3 4.1 16-3.9 7.2-11.6 12.3-17.8 18.5 6.7 5.6 13.1 10.9 20.3 16.9 4.5-4.1 9.5-11.3 16.3-14.2 7.5-3.1 19.4-6.1 24.5-2.4 14 10.1 21 2.7 30.1-6.1 22.1-21.4 44.8-42.2 67.2-63.2 13.6 23 5.7 42.9.1 62.8 1.3 1.1 2.6 2.1 3.9 3.2 12.8-12.9 25.6-25.8 39.1-39.3 1.9 3.4 3.8 7 5.9 10.8 10.4-7.8 20.7-15.7 31.1-23.5.8.6 1.7 1.2 2.5 1.8-4.1 6.7-9 13.1-11.9 20.3-2.3 5.6-2.1 12.2-3.4 20.6 11.5-7 18.4-11.3 25.5-15.6-2.4-4.4-5.4-9.9-8.4-15.2 5.5-8.8 11.1-18.8 17.7-28.1C918.9 84 926 84.9 932 98c6 13.2 7.5 25.9-2.7 38.5-17.6 21.9-35.4 43.7-51.3 66.8-6.1 8.8-7.1 21.2-7.8 33.2 16.2-5.6 33.5 1.4 44.9-12.9 1.7-2.1 10.3-1.4 13.6 1 15.4 11 16.8 34 3.4 47.9-7.5 7.7-14.9 14.3-9.4 27.1 7.2 16.9-7.5 26.7-16.1 36.4-11.1 12.6-14.4 20.7 9.5 27.9-11.4 9.1-18.7 16.2-27.2 21.5-27.6 17.6-52.5 37.2-63.1 72.7 6.9-.4 12.3-.9 17.6-1 4.4-.1 9.9-1.3 12.8.8 5.7 4 10.1 10 14.8 15.3 6.9 7.9 7.4-17.9 15.5-2.9 2.3-1.8 4.6-3.5 6.8-5.4 9.1-8 17.7-6.9 24.2 3.1.6.9 1 2.2 1.9 2.8 6.2 4.3 17.8 8.5 17.9 12.8.2 11.4-4.4 22.9-7.6 34.3-1.7 6-4.3 11.8-7.4 20-9.6-3.7-20.2-7.8-30.8-11.9-.4-2.4-.7-4.7-1.1-7.1-8.3 9.1-18.7 17-24.2 27.6-4.6 8.8-3.3 20.7-5 34.4 6.8-1.6 12.5-3 23.3-5.6-5.1 12.8-7.3 25.7-14.3 34.8-18.6 24-39.3 46.4-59.2 69.4-8 9.3-19.2 17.8-4.2 30.6 2.3 2 4.1 7.9 2.8 10.3-11.9 23.6 4.9 55.5-23.6 75.2-18.2-28.4 2-58.5-.5-84.1-29.5 27.6-44.7 65.4-58.3 104.2-2.7-.6-5.5-1.1-8.2-1.7 0-7 .2-13.9-.1-20.9-.3-8.1 13.9-14.7 2.7-24.2-.2-.2 3.2-6.6 5-6.6 18.2-.2 17.7-15.6 20.4-29.4-14.1 11-28.1 22.1-42.2 33.1-1.4 1.1-4 2.4-3.9 3.3 5.6 32.9-29.8 37.3-40.3 61.7-8.6-7.7-15.5-14.2-22.7-20.2-2.1-1.8-5-3.4-7.7-3.5-33.4-1.3-42.4-16-32-51-14.4 16.5-28.8 33.1-43.2 49.6-9.6-5.3-17-9.4-25.1-13.8-2.8 4-4.7 7.2-7.1 9.9-14.1 15.4-28.6 30.3-42.2 46.1-4.5 5.2-6.8 12.2-9.7 18.6-8.8 19.5-20.8 36.1-43.3 46.8-8.1-10.3-15.8-21-24.5-30.8-2.7-3.1-8.9-3-11.9-6-11.4-11.5-22.6-23.4-32.6-36.1-1.5-1.9 2.6-9.9 5.9-13.6 22.7-25.4 45.9-50.3 68.7-75.6 1.5-1.7 1.5-5.2 1.4-7.9-.8-18.1-1.7-36.3-2.7-55.4-19.6 4.6-40.4 14.9-55.9 33.7-13.5 16.4-21.1 17-34.9.4-2-2.4-4.2-6-6.6-6.3-16.1-1.7-33.3-6.3-48.3-2.6-11.5 2.8-20.4 16.4-30.2 25.4-1.6 1.5-1.8 4.6-3.5 5.8-15.4 11.3-31.3 21.7-46.3 33.5-11.6 9.1-20 19.9-39 15.2-8.5-2.1-20.6 11.6-31.4 17.5-11.8 6.4-24.1 11.7-35.9 18.2-12 6.6-23.7 14-37.4 18.8 1.8-2.1 3.6-4.2 6.8-7.9-5.4.9-9.4 1.6-13.1 2.2-1-11.1-2-21.2-3.4-35.8 53.7-21.9 102.8-59.1 146-102.4-5.5-10.3-16.6-21.6-15.9-32.2.8-13.5 10-27.1 17.8-39.3 7.5-11.8 7.3-20.2-5.8-28.7-26.9 22.7-54.1 45.7-83.2 70.3-6.5-4.9-14.1-10.6-21.2-16-7.6 5.2-14.3 12.7-22.3 14.7-23.2 5.5-21.5-16.6-27.8-28.8-3.3-6.3-3-14.5-3.6-17.9 9.6-7.1 18.2-12.2 25.1-19 37.4-36.5 74.5-73.4 111.6-110.2.9-.9 2.2-1.7 2.4-2.8 7.7-39.6 46.5-54.9 66.3-84.9 4.5-6.8 6.7-15.3 11.9-21.4 12.1-14.4 25.7-27.5 37.9-41.8 2.7-3.2 2.1-9.3 3.5-16.4 1.9-2.1 6.5-7.1 11.1-12.1.6 1.8 1.6 4.9 4.3 13.5 5.6-12.2 9.5-20.5 11.5-24.8 8.2-5.1 14.9-7.4 19-12.1 8.6-9.8 16-20.7 23.5-31.4 8.4-11.8 14.2-24.4 34.1-21.9 9.6 1.2 23.2-7.6 30.5-15.8 15.1-17.2 27.2-37.2 40.6-55.9 2.9-4.1 6.2-8 9.3-12 3.5 3 10.2 6.5 9.9 8.8-1 5.8-3.8 13.5-8.3 16-11.7 6.1-17.5 14.5-17.7 30.4z"/>
                 <path d="M124.3 679.4c9.1 8.9 29 13.6 13 30.4-3.6 3.8-16.1 4.8-20.2 1.6-17.4-13.5 6.3-20.4 7.2-32zm578 153.7c-5.1 7.1-10.2 14.3-16.8 23.3-4.3-8.1-7.2-13.8-11-21 8.4-2.3 16.2-4.5 24.1-6.7 1.2 1.5 2.5 2.9 3.7 4.4z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape37($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<path class="st1" d="M839.9,575.5c-240.3-52.5-322.5-27.5-416.3-60c-42-14.6-71.5-67.4-61.7-135.8L386,212.5
                                    c9.8-68.4,52.7-107.5,97.5-112.9c108.1-13,315.6,21.4,416.3,60c41.9,16,71.5,67.4,61.7,135.8l-24.1,167.2
                                    C927.6,531,883.3,585,839.9,575.5z"/>',
            $gradID);
        }
        $mask = '<path d="M800.9,738c-351.4-24.1-462.8,25.7-602.4,0C136,726.5,83.4,660.8,83.4,566.3V335.4c0-94.4,52.7-155.6,115.2-171.7
		            c150.6-38.7,451.7-32.5,602.4,0C863.6,177.3,916,241,916,335.4v230.9C916,660.8,864.3,742.4,800.9,738z"/>
                <path d="M373.5,913.2c-115.8-46.7-148.2-122.5-130.4-190s181.6-1.7,181.6-1.7S255.6,778.2,373.5,913.2z"/>
                <path d="M271.3,138.7c0,0-216.3-12.5-199.3,225.3C39.5,276.7,59.1,117.2,271.3,138.7z"/>
                <path d="M927.1,600.4c-5.5,55.4-24.9,145.4-121.8,149.5C896.7,792.8,943.7,697.3,927.1,600.4z"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape38($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<rect class="st1" x="61.3" y="113.1" class="st1" width="138.7" height="269.2"/>
                                <rect class="st1" x="808.2" y="610.6" class="st1" width="138.7" height="266.7"/>
                                <rect class="st1" x="210" y="755" class="st1" width="92.1" height="92.1"/>
                                <rect class="st1" x="700.5" y="140.8" class="st1" width="92.1" height="92.1"/>',
            $gradID);
        }
        $mask = '<rect x="78.2" y="130.4" width="273.4" height="273.4"/>
        <rect x="366.8" y="354.6" width="273.4" height="273.4"/>
        <rect x="366.8" y="64.8" width="273.4" height="273.4"/>
        <rect x="366.8" y="644.7" width="273.4" height="273.4"/>
        <rect x="78.2" y="418.8" width="273.4" height="273.4"/>
        <rect x="654.6" y="294" width="273.4" height="273.4"/>
        <rect x="654.6" y="157.2" width="121.6" height="121.6"/>
        <rect x="228.9" y="707.9" width="121.6" height="121.6"/>
        <rect x="654.6" y="583.8" width="273.4" height="273.4"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function Shape39($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<polygon class="st1" points="745.9,575.6 548.1,575.6 449.2,746.9 548.1,918.2 745.9,918.2 844.8,746.9 "/>
                                <polygon class="st1" points="318,328.8 120.3,328.8 21.4,500.1 120.3,671.4 318,671.4 416.9,500.1 "/>
                                <polygon class="st1" points="747,83.2 549.3,83.2 450.4,254.5 549.3,425.7 747,425.7 845.9,254.5 "/>',
            $gradID);
        }
        $mask = '<polygon points="383.3,302.8 155.8,302.8 42.1,499.8 155.8,696.8 383.3,696.8 497,499.8 "/>
                <polygon points="736.2,506.4 508.7,506.4 395,703.3 508.7,900.3 736.2,900.3 849.9,703.3 "/>
                <polygon points="382.8,709.3 274.9,709.3 220.9,802.8 274.9,896.3 382.8,896.3 436.8,802.8 "/>
                <polygon points="381.7,102.1 273.7,102.1 219.7,195.6 273.7,289.1 381.7,289.1 435.7,195.6 "/>
                <polygon points="909.3,406.5 801.3,406.5 747.3,500 801.3,593.5 909.3,593.5 963.3,500 "/>
                <polygon points="736.2,99.3 508.7,99.3 395,296.3 508.7,493.2 736.2,493.2 849.9,296.3 "/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }
    protected function Shape40($img_props, $layer_1_enable, $gradID) {
        $unique_id = uniqid();
        $layer_1 = '';
        if($layer_1_enable === 'on') {
            $layer_1 = sprintf('<rect class="st1" x="607.1" y="83" class="st1" width="311.3" height="311.3"/>
                                <rect class="st1" x="150.5" y="130.8" class="st1" width="311.3" height="311.3"/>
                                <rect class="st1" x="542.1" y="545.4" class="st1" width="311.3" height="311.3"/>
                                <rect class="st1" x="90.6" y="579.8" class="st1" width="127" height="379.2"/>',
            $gradID);
        }
        $mask = '<rect x="115.4" y="160.8" width="379.2" height="379.2"/>
        <rect x="509.7" y="444.4" width="379.2" height="379.2"/>
        <rect x="509.7" y="51.2" width="379.2" height="379.2"/>
        <rect x="115.4" y="555.3" width="379.2" height="379.2"/>';
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        return $this->shape_template($mask, $layer_1, $gradID, $maskId, $img_props );
    }

    protected function custom_mask($img_props, $layer_1_enable, $gradID){
        $unique_id = uniqid();
        $svg_content = DIPI_Builder_Module::dipi_get_url_content($img_props['custom_mask']);
        $svg_content = preg_replace( '/fill="[#][0-9A-F]*?"|fill="\w*?"/i', ' ', $svg_content);
        $maskId = $this->getLayerId("SHAPE_") . "-" . $unique_id;
        if($svg_content)
            return $this->shape_template($svg_content, '', $gradID, $maskId, $img_props );
        
        return false;
    }

    function shape_template($mask, $border, $gradID, $maskId, $img_props) {
            $border_markup = (!empty($border)) ?
                sprintf('<g %2$s fill="url(#%3$s)">%1$s</g>',
                    $border,
                    $this->shape_transform($img_props),
                    $gradID
                ): '';
            
            return sprintf('
                <g>
                    %2$s
                    <g>
                        <defs>
                            <mask id="%3$s" fill="#fff">
                                <g %4$s> 
                                    %1$s
                                </g>
                            </mask>
                        </defs>
                        %5$s
                    </g>
                </g>', 
                    $mask, 
                    $border_markup,
                    $maskId,
                    $this->shape_transform($img_props),
                    $this->maskImage($img_props, $maskId)
            );
    }

    function shape_transform($props) {
        $flip = explode('|', $props['shape_flip']);
        $flip_css = '';
        $flip_css .= in_array('horizontal', $flip)? ' scale(-1,1)' : '';
        $flip_css .= in_array('vertical', $flip)? ' scale(1,-1)' : '';
        return sprintf('style="transform-origin: center; transform: rotate(%1$s) scale(%2$s , %3$s)%4$s"',
            $props['shape_rotate'],
            $props['shape_scale_x'],
            $props['shape_scale_y'],
            $flip_css
        );
    }

    function maskImage($props, $maskId ) {
        return sprintf('
        <g style="mask:url(#%1$s)">
            <image 
                style="overflow:visible" 
                width=%2$s  
                href=%3$s
                transform="matrix(1 0 0 1 %4$s %5$s)"
                preserveAspectRatio="none"> 
            </image>
        </g>',
        $maskId,
        $props['image_width'],
        $props['image'],
        $props['image_horz'],
        $props['image_vert']);
    }
}