<?php
/**
 * TODO:
 * -Option to enable/disable title attribute on images so caption won't show on hover
 * 
 */
class DIPI_InstagramSlider extends DIPI_Swiper_Module
{
    private $instagram_accounts_basic;
    private $instagram_accounts_graph;

    public $slug = 'dipi_instagram_slider';
    public $vb_support = 'on';

    protected $module_credits = array(
        'module_uri' => 'https://divi-pixel.com/modules/instagram',
        'author' => 'Divi Pixel',
        'author_uri' => 'https://divi-pixel.com',
    );

    public function init()
    {
        $this->name = esc_html__('Pixel Instagram Slider', 'dipi-divi-pixel');
        $this->icon_path = plugin_dir_path(__FILE__) . 'icon.svg';

        $instagram_accounts = \DiviPixel\DIPI_Settings::get_option('instagram_accounts');
        if (!empty($instagram_accounts)) {
            $this->instagram_accounts_basic = [
                'no_account' => esc_html__('-- Select Account --', 'dipi-divi-pixel'),
            ];
            foreach ($instagram_accounts as $account_id => $account) {
                $this->instagram_accounts_basic[$account_id] = $account['username'];
            }
        }

        $facebook_accounts = \DiviPixel\DIPI_Settings::get_option('facebook_accounts');
        if (!empty($facebook_accounts)) {
            $this->instagram_accounts_graph = [
                'no_account' => esc_html__('-- Select Account --', 'dipi-divi-pixel'),
            ];
            foreach ($facebook_accounts as $fb_account_id => $fb_account) {
                foreach ($fb_account['instagram_accounts'] as $insta_account_id => $insta_account) {
                    $this->instagram_accounts_graph["{$fb_account_id}_{$insta_account_id}"] = "{$insta_account['username']} ({$fb_account['name']})";
                }
            }
        }
    }

    public function get_settings_modal_toggles()
    {
        $settings_modal_toggles = [
            'general' => [
                'toggles' => [
                    'instagram' => esc_html__('Instagram', 'dipi-divi-pixel'),
                ],
            ],
            'advanced' => [
                'toggles' => [
                    'test' => esc_html__('Test', 'dipi-divi-pixel'),
                ],
            ],
        ];

        return array_merge_recursive($settings_modal_toggles, parent::get_settings_modal_toggles());
    }

    public function get_fields()
    {
        $fields = [];

        $fields['instagram_api'] = [
            'label' => esc_html__('Instagram API', 'dipi-divi-pixel'),
            'description' => esc_html__('Select the type of Instagram API you want to use.', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'basic_option',
            'options' => [
                'basic' => esc_html__('Basic', 'dipi-divi-pixel'),
                'graph' => esc_html__('Graph', 'dipi-divi-pixel'),
            ],
            'default' => 'basic',
            'toggle_slug' => 'instagram',
        ];

        if (!empty($this->instagram_accounts_basic)) {
            $fields['instagram_account_basic'] = [
                'label' => esc_html__('Instagram Account', 'dipi-divi-pixel'),
                'description' => esc_html__('Select the Instagram account you want to use.', 'dipi-divi-pixel'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'options' => $this->instagram_accounts_basic,
                'default' => 'no_account',
                'toggle_slug' => 'instagram',
                'show_if' => [
                    'instagram_api' => 'basic',
                ],
            ];
        } else {
            $fields['no_instagram_account_basic'] = [
                'label' => '',
                'type' => 'warning',
                'value' => true,
                'display_if' => true,
                'message' => sprintf(
                    esc_html__('No Instagram accounts connected via the Basic API. Please connect an account via the <a href="%s" target="_blank">Divi Pixel settings page</a>.', 'dipi-divi-pixel'),
                    \DiviPixel\DIPI_Settings::admin_url('settings', 'third_party_providers', 'settings_instagram_api_basic')
                ),
                'option_category' => 'basic_option',
                'toggle_slug' => 'instagram',
                'show_if' => [
                    'instagram_api' => 'basic',
                ],
            ];
        }

        if (!empty($this->instagram_accounts_graph)) {
            $fields['instagram_account_graph'] = [
                'label' => esc_html__('Instagram Account', 'dipi-divi-pixel'),
                'description' => esc_html__('Select the Instagram account you want to use.', 'dipi-divi-pixel'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'options' => $this->instagram_accounts_graph,
                'default' => 'no_account',
                'toggle_slug' => 'instagram',
                'show_if' => [
                    'instagram_api' => 'graph',
                ],
            ];
        } else {
            $fields['no_instagram_account_graph'] = [
                'label' => '',
                'type' => 'warning',
                'value' => true,
                'display_if' => true,
                'message' => sprintf(
                    esc_html__('No Instagram accounts connected via the Graph API. Please connect an account via the <a href="%s" target="_blank">Divi Pixel settings page</a>.', 'dipi-divi-pixel'),
                    \DiviPixel\DIPI_Settings::admin_url('settings', 'third_party_providers', 'settings_instagram_api_graph')
                ),
                'option_category' => 'basic_option',
                'toggle_slug' => 'instagram',
                'show_if' => [
                    'instagram_api' => 'graph',
                ],
            ];
        }

        $fields['images_count'] = [
            'label' => esc_html__('Number of Images', 'dipi-divi-pixel'),
            'description' => esc_html__("The number of images you want to show.", 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'layout',
            'unitless' => true,
            'default' => '9',
            'range_settings' => array(
                'min' => '1',
                'max' => '100',
                'step' => '1',
            ),
            'toggle_slug' => 'instagram',
        ];

        $fields['image_click_target'] = [
            'label' => esc_html__('Image Click Target', 'dipi-divi-pixel'),
            'description' => esc_html__('Select what should happen when an image is clicked.', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'configuration',
            'default' => 'instagram',
            'options' => [
                'instagram' => esc_html__('Instagram', 'dipi-divi-pixel'),
                'lightbox' => esc_html__('Lightbox Gallery', 'dipi-divi-pixel'),
                'nothing' => esc_html__('No Interaction', 'dipi-divi-pixel'),
            ],
            'toggle_slug' => 'instagram',
        ];

        $fields['__swiper_slides'] = [
            'type' => 'computed',
            'computed_callback' => ['DIPI_InstagramSlider', 'render_swiper_slides'],
            'computed_depends_on' => [
                'instagram_api',
                'instagram_account_basic',
                'instagram_account_graph',
                'images_count',
                'open_images_in',
            ],
            'computed_minimum' => [
                'instagram_api',
                'images_count',
            ],
        ];


        //Instagram Slide Height
        $fields['slide_height'] = [
            'label' => esc_html('Slide Height', 'dipi-divi-pixel'),
            'description' => esc_html('The height of the slides. 100% would be a perfect square whereas 1% would be a thin line. The width is determined by the Number of Columns.', 'dipi-divi-pixel'),
            'type' => 'range',
            'default' => '100%',
            'range_settings' => [
                'min' => '1',
                'max' => '100',
                'step' => '1',
            ],
            'validate_unit' => true,
            'default_unit' => '%',
            'allowed_units' => ['%'],
            'mobile_options' => true,
            'tab_slug' => 'advanced',
            'toggle_slug' => 'slider_layout',
        ];
        
        return array_merge_recursive($fields, parent::get_fields());
    }

    public static function render_swiper_slides($args = [], $conditional_tags = [], $current_page = [])
    {
        $defaults = [
            'instagram_api' => 'basic',
            'instagram_account_basic' => 'no_account',
            'instagram_account_graph' => 'no_account',
            'images_count' => '9',
            'open_images_ins' => 'instagram',
        ];

        $args = wp_parse_args($args, $defaults);

        if ($args['instagram_api'] === 'basic' && $args['instagram_account_basic'] === 'no_account') {
            return sprintf('<div>%1$s</div>', esc_html__('No account selected.', 'dipi-divi-pixel'));
        } else if ($args['instagram_api'] === 'graph' && $args['instagram_account_graph'] === 'no_account') {
            return sprintf('<div>%1$s</div>', esc_html__('No account selected.', 'dipi-divi-pixel'));
        }

        if ($args['instagram_api'] === 'basic') {
            return self::render_swiper_slides_basic($args['instagram_account_basic'], $args['images_count'], $args['image_click_target']);
        } else if ($args['instagram_api'] === 'graph') {
            return self::render_swiper_slides_graph($args['instagram_account_graph'], $args['images_count'], $args['image_click_target']);
        } else {
            return sprintf('<div>%1$s</div>', esc_html__('Unknown Instagram API selected. Please choose either Basic or Graph.', 'dipi-divi-pixel'));
        }
    }

    private static function render_swiper_slides_basic($account_id, $images_count, $target)
    {


        $instagram_account = \DiviPixel\DIPI_Instagram_Basic_API::instance()->get_instagram_account($account_id);
        if(!$instagram_account){
            return sprintf('<div>%1$s</div>', esc_html__('The selected Instagram account is not connected. Please connect it in the Divi Pixel settings.', 'dipi-divi-pixel'));
        }


        $media = \DiviPixel\DIPI_Instagram_Basic_API::instance()->get_media($account_id, $images_count);
        if(!$media){
            return sprintf(
                '<div>%1$s</div>', 
                sprintf(esc_html__('No images found for account %s.', 'dipi-divi-pixel'), $instagram_account['username'])
            );
        }

        $output = '';
        foreach($media as $medium){
            $output .= sprintf(
                '<div class="dipi_instagram_slider_slide swiper-slide">
                    <a href="%3$s" target="_blank" data-title="%4$s">
                        <img src="%1$s" title="%2$s" alt="%2$s" />
                    </a>
                </div>',
                $medium['media_url'],
                $medium['caption'],
                $target === 'instagram' ? esc_attr($medium['permalink']) : esc_attr($medium['media_url']),
                $target === 'lightbox' ? esc_attr($medium['caption']) : ''
            );
        }
        
        return $output;
    }

    private static function render_swiper_slides_graph($account_id, $images_count, $target)
    {
        $components = explode('_', $account_id);
        $facebook_account_id = $components[0];
        $instagram_account_id =  $components[1];
        
        $instagram_account = \DiviPixel\DIPI_Instagram_Graph_API::instance()->get_instagram_account($instagram_account_id);
        if (!$instagram_account) {
            return sprintf('<div>%1$s</div>', esc_html__('The selected Instagram account is not connected. Please connect it in the Divi Pixel settings.', 'dipi-divi-pixel'));
        }

        $media = \DiviPixel\DIPI_Instagram_Graph_API::instance()->get_media($instagram_account_id, $images_count);
        if(!$media){
            return sprintf(
                '<div>%1$s</div>', 
                sprintf(esc_html__('No images found for account %s.', 'dipi-divi-pixel'), $instagram_account['username'])
            );
        }

        $output = '';
        foreach($media as $medium){
            $output .= sprintf(
                '<div class="dipi_instagram_slider_slide swiper-slide">
                    <a href="%3$s" target="_blank" data-title="%4$s">
                        <img src="%1$s" title="%2$s" alt="%2$s" />
                    </a>
                </div>',
                $medium['media_url'],
                $medium['caption'],
                $target === 'instagram' ? esc_attr($medium['permalink']) : esc_attr($medium['media_url']),
                $target === 'lightbox' ? esc_attr($medium['caption']) : ''
            );
        }
        
        return $output;
    }

    public function render($attrs, $content, $render_slug)
    {
        parent::render($attrs, $content, $render_slug);

        wp_enqueue_script('dipi_instagram_slider_public');
        if($this->props['image_click_target'] === 'lightbox'){
            wp_enqueue_style( 'magnific-popup');
        }
        
        $this->dipi_apply_css($render_slug);

        $slides = self::render_swiper_slides($this->props);
        return $this->render_swiper_container($slides, $render_slug, ['image_click_target' => $this->props['image_click_target']]);
    }

    private function dipi_apply_css($render_slug){
        $slide_height = $this->dipi_get_responsive_prop('slide_height');
        et_pb_responsive_options()->generate_responsive_css($slide_height, '%%order_class%% .dipi_instagram_slider_slide::after', 'padding-bottom', $render_slug);
    }
}

new DIPI_InstagramSlider();
